# ActRelationshipType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActRelationshipType**

## CodeSystem: ActRelationshipType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType | *Version*:4.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActRelationshipType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1002 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The source is an excerpt from the target. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActRelationshipAccounting](ValueSet-v3-ActRelationshipAccounting.md)
* [ActRelationshipActProvenance](ValueSet-v3-ActRelationshipActProvenance.md)
* [ActRelationshipActiveImmunizationAgainst](ValueSet-v3-ActRelationshipActiveImmunizationAgainst.md)
* [ActRelationshipAdjunctCurativeIndication](ValueSet-v3-ActRelationshipAdjunctCurativeIndication.md)
* [ActRelationshipAdjunctMitigation](ValueSet-v3-ActRelationshipAdjunctMitigation.md)
* [ActRelationshipAdjunctiveTreatment](ValueSet-v3-ActRelationshipAdjunctiveTreatment.md)
* [ActRelationshipArrival](ValueSet-v3-ActRelationshipArrival.md)
* [ActRelationshipAssignsName](ValueSet-v3-ActRelationshipAssignsName.md)
* [ActRelationshipAuthorizedBy](ValueSet-v3-ActRelationshipAuthorizedBy.md)
* [ActRelationshipBlocks](ValueSet-v3-ActRelationshipBlocks.md)
* [ActRelationshipCompliesWith](ValueSet-v3-ActRelationshipCompliesWith.md)
* [ActRelationshipConcurrentWith](ValueSet-v3-ActRelationshipConcurrentWith.md)
* [ActRelationshipConditional](ValueSet-v3-ActRelationshipConditional.md)
* [ActRelationshipContainsEndOf](ValueSet-v3-ActRelationshipContainsEndOf.md)
* [ActRelationshipContainsStartOf](ValueSet-v3-ActRelationshipContainsStartOf.md)
* [ActRelationshipContainsStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipContainsStartOfEndsBeforeEndOf.md)
* [ActRelationshipContainsTimeOf](ValueSet-v3-ActRelationshipContainsTimeOf.md)
* [ActRelationshipCostTracking](ValueSet-v3-ActRelationshipCostTracking.md)
* [ActRelationshipCoveredBy](ValueSet-v3-ActRelationshipCoveredBy.md)
* [ActRelationshipCurativeIndication](ValueSet-v3-ActRelationshipCurativeIndication.md)
* [ActRelationshipDeparture](ValueSet-v3-ActRelationshipDeparture.md)
* [ActRelationshipDiagnosis](ValueSet-v3-ActRelationshipDiagnosis.md)
* [ActRelationshipDocumentHQMF](ValueSet-v3-ActRelationshipDocumentHQMF.md)
* [ActRelationshipDocumentProvenance](ValueSet-v3-ActRelationshipDocumentProvenance.md)
* [ActRelationshipDocuments](ValueSet-v3-ActRelationshipDocuments.md)
* [ActRelationshipDuring](ValueSet-v3-ActRelationshipDuring.md)
* [ActRelationshipEndsAfterEndOf](ValueSet-v3-ActRelationshipEndsAfterEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipEndsAfterStartOf](ValueSet-v3-ActRelationshipEndsAfterStartOf.md)
* [ActRelationshipEndsBeforeEnd](ValueSet-v3-ActRelationshipEndsBeforeEnd.md)
* [ActRelationshipEndsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipEndsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipEndsBeforeStartOf](ValueSet-v3-ActRelationshipEndsBeforeStartOf.md)
* [ActRelationshipEndsConcurrentWith](ValueSet-v3-ActRelationshipEndsConcurrentWith.md)
* [ActRelationshipEndsConcurrentWithStart](ValueSet-v3-ActRelationshipEndsConcurrentWithStart.md)
* [ActRelationshipEndsDuring](ValueSet-v3-ActRelationshipEndsDuring.md)
* [ActRelationshipEndsNearEnd](ValueSet-v3-ActRelationshipEndsNearEnd.md)
* [ActRelationshipEndsNearStarts](ValueSet-v3-ActRelationshipEndsNearStarts.md)
* [ActRelationshipEpisodelink](ValueSet-v3-ActRelationshipEpisodelink.md)
* [ActRelationshipEvaluatesGoal](ValueSet-v3-ActRelationshipEvaluatesGoal.md)
* [ActRelationshipExacerbatredBy](ValueSet-v3-ActRelationshipExacerbatredBy.md)
* [ActRelationshipExcerpt](ValueSet-v3-ActRelationshipExcerpt.md)
* [ActRelationshipExcerptVerbatim](ValueSet-v3-ActRelationshipExcerptVerbatim.md)
* [ActRelationshipFulfills](ValueSet-v3-ActRelationshipFulfills.md)
* [ActRelationshipHasBaseline](ValueSet-v3-ActRelationshipHasBaseline.md)
* [ActRelationshipHasBoundedSupport](ValueSet-v3-ActRelationshipHasBoundedSupport.md)
* [ActRelationshipHasCharge](ValueSet-v3-ActRelationshipHasCharge.md)
* [ActRelationshipHasComponent](ValueSet-v3-ActRelationshipHasComponent.md)
* [ActRelationshipHasContinuingObjective](ValueSet-v3-ActRelationshipHasContinuingObjective.md)
* [ActRelationshipHasContraIndication](ValueSet-v3-ActRelationshipHasContra-indication.md)
* [ActRelationshipHasControlVariable](ValueSet-v3-ActRelationshipHasControlVariable.md)
* [ActRelationshipHasCost](ValueSet-v3-ActRelationshipHasCost.md)
* [ActRelationshipHasCredit](ValueSet-v3-ActRelationshipHasCredit.md)
* [ActRelationshipHasDebit](ValueSet-v3-ActRelationshipHasDebit.md)
* [ActRelationshipHasExplanation](ValueSet-v3-ActRelationshipHasExplanation.md)
* [ActRelationshipHasFinalObjective](ValueSet-v3-ActRelationshipHasFinalObjective.md)
* [ActRelationshipHasGeneralization](ValueSet-v3-ActRelationshipHasGeneralization.md)
* [ActRelationshipHasGoal](ValueSet-v3-ActRelationshipHasGoal.md)
* [ActRelationshipHasMember](ValueSet-v3-ActRelationshipHasMember.md)
* [ActRelationshipHasMetadata](ValueSet-v3-ActRelationshipHasMetadata.md)
* [ActRelationshipHasOption](ValueSet-v3-ActRelationshipHasOption.md)
* [ActRelationshipHasPart](ValueSet-v3-ActRelationshipHasPart.md)
* [ActRelationshipHasPreCondition](ValueSet-v3-ActRelationshipHasPre-condition.md)
* [ActRelationshipHasPreviousInstance](ValueSet-v3-ActRelationshipHasPreviousInstance.md)
* [ActRelationshipHasQualifier](ValueSet-v3-ActRelationshipHasQualifier.md)
* [ActRelationshipHasReferenceValues](ValueSet-v3-ActRelationshipHasReferenceValues.md)
* [ActRelationshipHasRisk](ValueSet-v3-ActRelationshipHasRisk.md)
* [ActRelationshipHasStep](ValueSet-v3-ActRelationshipHasStep.md)
* [ActRelationshipHasSubject](ValueSet-v3-ActRelationshipHasSubject.md)
* [ActRelationshipHasSupport](ValueSet-v3-ActRelationshipHasSupport.md)
* [ActRelationshipHasTrigger](ValueSet-v3-ActRelationshipHasTrigger.md)
* [ActRelationshipHasValue](ValueSet-v3-ActRelationshipHasValue.md)
* [ActRelationshipICSRInvestigation](ValueSet-v3-ActRelationshipICSRInvestigation.md)
* [ActRelationshipImmunizationAgainst](ValueSet-v3-ActRelationshipImmunizationAgainst.md)
* [ActRelationshipIndependentOfTimeOf](ValueSet-v3-ActRelationshipIndependentOfTimeOf.md)
* [ActRelationshipInstantiatesMaster](ValueSet-v3-ActRelationshipInstantiatesMaster.md)
* [ActRelationshipInterferedBy](ValueSet-v3-ActRelationshipInterferedBy.md)
* [ActRelationshipIsAppendage](ValueSet-v3-ActRelationshipIsAppendage.md)
* [ActRelationshipIsDerivedFrom](ValueSet-v3-ActRelationshipIsDerivedFrom.md)
* [ActRelationshipIsEtiologyFor](ValueSet-v3-ActRelationshipIsEtiologyFor.md)
* [ActRelationshipIsManifestationOf](ValueSet-v3-ActRelationshipIsManifestationOf.md)
* [ActRelationshipItemsLocated](ValueSet-v3-ActRelationshipItemsLocated.md)
* [ActRelationshipLimitedBy](ValueSet-v3-ActRelationshipLimitedBy.md)
* [ActRelationshipMaintenanceTreatment](ValueSet-v3-ActRelationshipMaintenanceTreatment.md)
* [ActRelationshipMatchesTrigger](ValueSet-v3-ActRelationshipMatchesTrigger.md)
* [ActRelationshipMitigates](ValueSet-v3-ActRelationshipMitigates.md)
* [ActRelationshipModifies](ValueSet-v3-ActRelationshipModifies.md)
* [ActRelationshipObjective](ValueSet-v3-ActRelationshipObjective.md)
* [ActRelationshipOccurrence](ValueSet-v3-ActRelationshipOccurrence.md)
* [ActRelationshipOutcome](ValueSet-v3-ActRelationshipOutcome.md)
* [ActRelationshipOverlapsWith](ValueSet-v3-ActRelationshipOverlapsWith.md)
* [ActRelationshipPalliates](ValueSet-v3-ActRelationshipPalliates.md)
* [ActRelationshipPassiveImmunizationAgainst](ValueSet-v3-ActRelationshipPassiveImmunizationAgainst.md)
* [ActRelationshipPertains](ValueSet-v3-ActRelationshipPertains.md)
* [ActRelationshipPosting](ValueSet-v3-ActRelationshipPosting.md)
* [ActRelationshipProphylaxisOf](ValueSet-v3-ActRelationshipProphylaxisOf.md)
* [ActRelationshipProvidesEvidenceFor](ValueSet-v3-ActRelationshipProvidesEvidenceFor.md)
* [ActRelationshipReChallenge](ValueSet-v3-ActRelationshipRe-challenge.md)
* [ActRelationshipReason](ValueSet-v3-ActRelationshipReason.md)
* [ActRelationshipRecovery](ValueSet-v3-ActRelationshipRecovery.md)
* [ActRelationshipReferencesOrder](ValueSet-v3-ActRelationshipReferencesOrder.md)
* [ActRelationshipRefersTo](ValueSet-v3-ActRelationshipRefersTo.md)
* [ActRelationshipRelievedBy](ValueSet-v3-ActRelationshipRelievedBy.md)
* [ActRelationshipReplaces](ValueSet-v3-ActRelationshipReplaces.md)
* [ActRelationshipReverses](ValueSet-v3-ActRelationshipReverses.md)
* [ActRelationshipSchedulesRequest](ValueSet-v3-ActRelationshipSchedulesRequest.md)
* [ActRelationshipSequel](ValueSet-v3-ActRelationshipSequel.md)
* [ActRelationshipStartAfterStartOfContainsEndOf](ValueSet-v3-ActRelationshipStartAfterStartOfContainsEndOf.md)
* [ActRelationshipStartsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipStartsAfterStartOf](ValueSet-v3-ActRelationshipStartsAfterStartOf.md)
* [ActRelationshipStartsAfterStartOfEndsWith](ValueSet-v3-ActRelationshipStartsAfterStartOfEndsWith.md)
* [ActRelationshipStartsAfterStartofEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterStartofEndsAfterEndOf.md)
* [ActRelationshipStartsBeforeEnd](ValueSet-v3-ActRelationshipStartsBeforeEnd.md)
* [ActRelationshipStartsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipStartsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipStartsBeforeStartOf](ValueSet-v3-ActRelationshipStartsBeforeStartOf.md)
* [ActRelationshipStartsBeforeStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsBeforeEndOf.md)
* [ActRelationshipStartsBeforeStartOfEndsWith](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsWith.md)
* [ActRelationshipStartsConcurrentWith](ValueSet-v3-ActRelationshipStartsConcurrentWith.md)
* [ActRelationshipStartsConcurrentWithEnd](ValueSet-v3-ActRelationshipStartsConcurrentWithEnd.md)
* [ActRelationshipStartsDuring](ValueSet-v3-ActRelationshipStartsDuring.md)
* [ActRelationshipStartsNearEnd](ValueSet-v3-ActRelationshipStartsNearEnd.md)
* [ActRelationshipStartsNearStart](ValueSet-v3-ActRelationshipStartsNearStart.md)
* [ActRelationshipStartsWithEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsWithEndsAfterEndOf.md)
* [ActRelationshipStartsWithEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsWithEndsBeforeEndOf.md)
* [ActRelationshipSucceeds](ValueSet-v3-ActRelationshipSucceeds.md)
* [ActRelationshipSummarizedBy](ValueSet-v3-ActRelationshipSummarizedBy.md)
* [ActRelationshipSymptomaticRelief](ValueSet-v3-ActRelationshipSymptomaticRelief.md)
* [ActRelationshipTemporallyPertains](ValueSet-v3-ActRelationshipTemporallyPertains.md)
* [ActRelationshipTemporallyPertainsApproximates](ValueSet-v3-ActRelationshipTemporallyPertainsApproximates.md)
* [ActRelationshipTemporallyPertainsEnd](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md)
* [ActRelationshipTemporallyPertainsStart](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md)
* [ActRelationshipTransformation](ValueSet-v3-ActRelationshipTransformation.md)
* [ActRelationshipTreats](ValueSet-v3-ActRelationshipTreats.md)
* [ActRelationshipType](ValueSet-v3-ActRelationshipType.md)
* [ActRelationshipUpdate](ValueSet-v3-ActRelationshipUpdate.md)
* [ActRelationshipUpdatesCondition](ValueSet-v3-ActRelationshipUpdatesCondition.md)
* [ActRelationshipUses](ValueSet-v3-ActRelationshipUses.md)
* [XActRelationshipDocument](ValueSet-v3-xActRelationshipDocument.md)
* [XActRelationshipDocumentSPL](ValueSet-v3-xActRelationshipDocumentSPL.md)
* [XActRelationshipEntry](ValueSet-v3-xActRelationshipEntry.md)
* [XActRelationshipEntryRelationship](ValueSet-v3-xActRelationshipEntryRelationship.md)
* [XActRelationshipExternalReference](ValueSet-v3-xActRelationshipExternalReference.md)
* [XActRelationshipPatientTransport](ValueSet-v3-xActRelationshipPatientTransport.md)
* [XActRelationshipPertinentInfo](ValueSet-v3-xActRelationshipPertinentInfo.md)
* [XActRelationshipRelatedAuthorizations](ValueSet-v3-xActRelationshipRelatedAuthorizations.md)
* [XActReplaceOrRevise](ValueSet-v3-xActReplaceOrRevise.md)
* [XSUCCREPLPREV](ValueSet-v3-xSUCCREPLPREV.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActRelationshipType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1002"
    }
  ],
  "version" : "4.0.0",
  "name" : "ActRelationshipType",
  "title" : "ActRelationshipType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The source is an excerpt from the target.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "conductible",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-conductible",
      "description" : "If true, indicates that ActRelationships or Participations of the specified type (and any specializations thereof) will normally conduct. For more usage information, refer to the Core Principles specification.",
      "type" : "boolean"
    },
    {
      "code" : "isDocumentCharacteristic",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-document-characteristic",
      "description" : "If true, indicates that the Act attribute or association (as represented by a typeCode for eaither ActRelationship or Pareticipation is a descriptor of the document (record) represented by the act object. If false, indicates the property is a descriptor of the action itself, actual, intended, or potential.  Applies to interpretation of attributes and associations with respect to changes in the value of Act.actionNegationInd and Act.moodCode. (See descriptions of these attributes for further discussion.) For example, in an order, the id attribute [isDocumentCharacteristic = true] is an identifier of the record of the order, not an identifier of the intended event.  On the other hand, the code attribute [isDocumentCharacteristic = false] describes a characteristic of the intended event.",
      "type" : "boolean"
    },
    {
      "code" : "Name:Act:inboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-inbound-relationship",
      "description" : "Name of inboundRelationship from Act to ActReln",
      "type" : "string"
    },
    {
      "code" : "Name:Act:outboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-outbound-relationship",
      "description" : "Formal name of outboundRelationship from Act to ActReln",
      "type" : "string"
    },
    {
      "code" : "Sort:Act:inboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Act-inbound-sort",
      "description" : "Sort key for the inboundRelationship from Act to ActReln",
      "type" : "string"
    },
    {
      "code" : "Sort:Act:outboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-act-outbound-sort",
      "description" : "Sort key for the outboundRelationship from Act to ActReln",
      "type" : "string"
    },
    {
      "code" : "appliesTo",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-applies-to",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "howApplies",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-how-applies",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "Name:ActRelationship:source:Act",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-ActRelationship-source",
      "description" : "The name of the assciation from ActRelationship to the source Act",
      "type" : "string"
    },
    {
      "code" : "Name:ActRelationship:target:Act",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-ActRelationship-target",
      "description" : "The name of the assciation from ActRelationship to the source Act",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ART",
      "display" : "act relationship type",
      "definition" : "**Description:** A directed association between a source Act and a target Act.\r\n\r\n**Usage Note:** This code should never be transmitted in an instance as the value of ActRelationship.typeCode (attribute)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23252"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CURE",
      "display" : "curative indication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21642"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CURE.ADJ",
      "display" : "adjunct curative indication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21643"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTGT.ADJ",
      "display" : "adjunct mitigation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21641"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RACT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "14892"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUGG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10322"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsEnd",
      "display" : "ActRelationshipTemporallyPertainsEnd",
      "definition" : "A relationship that defines the relative time of the end source act based on the time of the target act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23077"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endTemporallyRelatedTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatedEndInformation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsStart",
      "display" : "ActRelationshipTemporallyPertainsStart",
      "definition" : "A relationship that defines the relative time of the start source act based on the time of the target act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23075"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startTemporallyRelatedTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatedStartInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DNA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DNA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipCostTracking",
      "display" : "ActRelationshipCostTracking",
      "definition" : "Expresses values for describing the relationship relationship between an InvoiceElement or InvoiceElementGroup and a billable act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21360"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "costTrackingOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "costTracking"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipPosting",
      "display" : "ActRelationshipPosting",
      "definition" : "Expresses values for describing the relationship between a FinancialTransaction and an Account.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21359"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "postingTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "posting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CIND",
      "display" : "has contra-indication",
      "definition" : "A contraindication is just a negation of a reason, i.e. it gives a condition under which the action is not to be done. Both, source and target can be any kind of service; target service is in criterion mood. How the strength of a contraindication is expressed (e.g., relative, absolute) is left as an open issue. The priorityNumber attribute could be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10323"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "contra-indication"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "contraindicationFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "contraindication"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "CC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "CC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PRCN",
      "display" : "has pre-condition",
      "definition" : "A requirement to be true before a service is performed. The target can be any service in criterion mood. For multiple pre-conditions a conjunction attribute (AND, OR, XOR) is applicable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10319"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "pre-condition"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "preconditionFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "precondition"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "CD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "CD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RSON",
      "display" : "has reason",
      "definition" : "**Description:** The reason or rationale for a service. A reason link is weaker than a trigger, it only suggests that some service may be or might have been a reason for some action, but not that this reason requires/required the action to be taken. Also, as opposed to the trigger, there is no strong timely relation between the reason and the action. As well as providing various types of information about the rationale for a service, the RSON act relationship is routinely used between a SBADM act and an OBS act to describe the indication for use of a medication. Child concepts may be used to describe types of indication.\r\n\r\n*Discussion:* In prior releases, the code \"SUGG\" (suggests) was expressed as \"an inversion of the reason link.\" That code has been retired in favor of the inversion indicator that is an attribute of ActRelationship.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10321"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "reason"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "reasonOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "reason"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "CA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "CA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TRIG",
      "display" : "has trigger",
      "definition" : "A pre-condition that if true should result in the source Act being executed. The target is in typically in criterion mood. When reported after the fact (i.e. the criterion has been met) it may be in Event mood. A delay between the trigger and the triggered action can be specified.\r\n\r\n*Discussion:* This includes the concept of a required act for a service or financial instrument such as an insurance plan or policy. In such cases, the trigger is the occurrence of a specific condition such as coverage limits being exceeded.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10320"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "trigger"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "triggerFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "trigger"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "CB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "CB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CHRG",
      "display" : "has charge",
      "definition" : "A relationship that provides an ability to associate a financial transaction (target) as a charge to a clinical act (source). A clinical act may have a charge associated with the execution or delivery of the service.\r\n\r\nThe financial transaction will define the charge (bill) for delivery or performance of the service.\r\n\r\nCharges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14904"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "chargeFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "charge"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOBA_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOBA_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipCostTracking"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COST",
      "display" : "has cost",
      "definition" : "A relationship that provides an ability to associate a financial transaction (target) as a cost to a clinical act (source). A clinical act may have an inherit cost associated with the execution or delivery of the service.\r\n\r\nThe financial transaction will define the cost of delivery or performance of the service.\r\n\r\nCharges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14903"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "costOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "cost"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOBB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOBB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipCostTracking"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CREDIT",
      "display" : "has credit",
      "definition" : "A credit relationship ties a financial transaction (target) to an account (source). A credit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account credit will decrease the account balance. A non-asset account credit will decrease the account balance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14902"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "creditTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "credit"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOAA_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOAA_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosting"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DEBIT",
      "display" : "has debit",
      "definition" : "A debit relationship ties a financial transaction (target) to an account (source). A debit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account debit will increase the account balance. A non-asset account debit will decrease the account balance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14901"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "debitTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "debit"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DOAB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DOAB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosting"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsApproximates",
      "display" : "ActRelationshipTemporallyPertainsApproximates",
      "definition" : "Abstract collector for ActRelationship types that relate two acts by their approximate timing.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23637"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAS",
      "display" : "ends after start of",
      "definition" : "A relationship in which the source act ends after the target act starts.\r\n\r\n*UsageNote:* Inverse code is **SBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23079"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsAfterStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EASORECWS",
      "display" : "ends after or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time ends after or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EBSORECWS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23645"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INDEPENDENT",
      "display" : "independent of time of",
      "definition" : "The source Act is independent of the time of the target Act.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23582"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "independentOfTimeOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "independentOfTimeOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAEORSCWE",
      "display" : "starts after or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time starts after or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SBEORSCWE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23644"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASORSCW",
      "display" : "starts after or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time starts after or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SBSORSCW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23642"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBEORSCWE",
      "display" : "starts before or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time starts before or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SAEORSCWE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23643"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ENE",
      "display" : "ends near end",
      "definition" : "A relationship in which the source act's effective time ends near the end of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is ENS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23640"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsNearStart"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsNearEnd"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ENS",
      "display" : "ends near start",
      "definition" : "A relationship in which the source act's effective time ends near the start of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is ENE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23641"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsNearEnd"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsNearStart"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SNE",
      "display" : "starts near end",
      "definition" : "A relationship in which the source act's effective time starts near the end of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is SNS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23638"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsNearStart"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsNearEnd"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SNS",
      "display" : "starts near start",
      "definition" : "A relationship in which the source act's effective time starts near the start of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is SNE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23639"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsNearEnd"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsNearStart"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OBJC",
      "display" : "has continuing objective",
      "definition" : "A desired state that a service action aims to maintain. E.g., keep systolic blood pressure between 90 and 110 mm Hg. Source is an intervention service. Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10327"
        },
        {
          "code" : "appliesTo",
          "valueString" : "service"
        },
        {
          "code" : "howApplies",
          "valueString" : "criterion"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "maintenanceGoalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "maintenanceGoal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "ACA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "ACA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationsipObjective"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OBJF",
      "display" : "has final objective",
      "definition" : "A desired outcome that a service action aims to meet finally. Source is any service (typically an intervention). Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10326"
        },
        {
          "code" : "appliesTo",
          "valueString" : "service"
        },
        {
          "code" : "howApplies",
          "valueString" : "criterion"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "finalGoalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "finalGoal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "ACB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "ACB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationsipObjective"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActClassTemporallyPertains",
      "display" : "ActClassTemporallyPertains",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "internalId",
          "valueCode" : "21307"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatesTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatedInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TemporallyPertains",
      "display" : "ActClassTemporallyPertains",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "internalId",
          "valueCode" : "21307"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatesTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "temporallyRelatedInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipAccounting",
      "display" : "ActRelationshipAccounting",
      "definition" : "Codes that describe the relationship between an Act and a financial instrument such as a financial transaction, account or invoice element.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "internalId",
          "valueCode" : "20946"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "accountingFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "accounting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipPosts",
      "display" : "ActRelationshipAccounting",
      "definition" : "Codes that describe the relationship between an Act and a financial instrument such as a financial transaction, account or invoice element.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "internalId",
          "valueCode" : "20946"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "accountingFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "accounting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipConditional",
      "display" : "ActRelationshipConditional",
      "definition" : "Specifies under what circumstances (target Act) the source-Act may, must, must not or has occurred",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20945"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "conditionedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "conditions"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "C________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "C________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertains",
      "display" : "ActRelationshipTemporallyPertains",
      "definition" : "Abstract collector for ActRelationhsip types that relate two acts by their timing.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23581"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "AUTH",
      "display" : "authorized by",
      "definition" : "A relationship in which the target act authorizes or certifies the source act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14019"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "authorizationOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "authorization"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DH_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DH_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CAUS",
      "display" : "is etiology for",
      "definition" : "**Description:** An assertion that an act was the cause of another act.This is stronger and more specific than the support link. The source (cause) is typically an observation, but may be any act, while the target may be any act.\r\n\r\n**Examples:**\r\n\r\n *  a growth of Staphylococcus aureus may be considered the cause of an abscess\r\n *  contamination of the infusion bag was deemed to be the cause of the infection that the patient experienced\r\n *  lack of staff on the shift was deemed to be a supporting factor (proximal factor) causing the patient safety incident where the patient fell out of bed because the bed-sides had not been put up which caused the night patient to fall out of bed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10332"
        },
        {
          "code" : "appliesTo",
          "valueString" : "cause"
        },
        {
          "code" : "howApplies",
          "valueString" : "effect"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "cause"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "causeOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COMP",
      "display" : "has component",
      "definition" : "The target act is a component of the source act, with no semantics regarding composition or aggregation implied.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10318"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "componentOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "component"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "E________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "E________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COVBY",
      "display" : "covered by",
      "definition" : "A relationship in which the source act is covered by or is under the authority of a target act. A financial instrument such as an Invoice Element is covered by one or more specific instances of an Insurance Policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14894"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "coverageOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "coverage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DP_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DP_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DRIV",
      "display" : "is derived from",
      "definition" : "Associates a derived Act with its input parameters. E.G., an anion-gap observation can be associated as being derived from given sodium-, (potassium-,), chloride-, and bicarbonate-observations. The narrative content (Act.text) of a source act is wholly machine-derived from the collection of target acts.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10334"
        },
        {
          "code" : "appliesTo",
          "valueString" : "output parameter"
        },
        {
          "code" : "howApplies",
          "valueString" : "input parameter"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "derivation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "derivedFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DF_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DF_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ELNK",
      "display" : "episodeLink",
      "definition" : "Expresses an association that links two instances of the same act over time, indicating that the instance are part of the same episode, e.g. linking two condition nodes for episode of illness; linking two encounters for episode of encounter.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18865"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "linkedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "links"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BG_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BG_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EVID",
      "display" : "provides evidence for",
      "definition" : "Indicates that the target Act provides evidence in support of the action represented by the source Act. The target is not a 'reason' for the source act, but rather gives supporting information on why the source act is an appropriate course of action. Possible targets might be clinical trial results, journal articles, similar successful therapies, etc.\r\n\r\n*Rationale:* Provides a mechanism for conveying clinical justification for non-approved or otherwise non-traditional therapies.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21572"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EXACBY",
      "display" : "exacerbated by",
      "definition" : "**Description:**The source act is aggravated by the target act. (Example \"chest pain\" EXACBY \"exercise\")",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22827"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EXPL",
      "display" : "has explanation",
      "definition" : "This is the inversion of support. Used to indicate that a given observation is explained by another observation or condition.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10331"
        },
        {
          "code" : "howApplies",
          "valueString" : "explaining observation or condition"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "explanationFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "explanation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DI_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DI_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INTF",
      "display" : "interfered by",
      "definition" : "the target act documents a set of circumstances (events, risks) which prevent successful completion, or degradation of quality of, the source Act.\r\n\r\n*UsageNote:* This provides the semantics to document barriers to care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23597"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "interferesWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "interferedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "G________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "G________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ITEMSLOC",
      "display" : "items located",
      "definition" : "Items located",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20841"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "itemStorageFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "itemStorage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DR_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DR_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "LIMIT",
      "display" : "limited by",
      "definition" : "A relationship that limits or restricts the source act by the elements of the target act. For example, an authorization may be limited by a financial amount (up to $500). Target Act must be in EVN.CRIT mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14896"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "limitationOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "limitation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DQ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DQ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "META",
      "display" : "has metadata",
      "definition" : "**Definition:** Indicates that the attributes and associations of the target act provide metadata (for example, identifiers, authorship, etc.) for the source act.\r\n\r\n**Constraint:**  Source act must have either a mood code that is not \"EVN\" (event) or its \"isCriterion\" attribute must set to \"true\". Target act must be an Act with a mood code of EVN and with isCriterionInd attribute set to \"true\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23111"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "metadataFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "metadata"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DZ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "AA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MFST",
      "display" : "is manifestation of",
      "definition" : "An assertion that a new observation may be the manifestation of another existing observation or action. This assumption is attributed to the same actor who asserts the manifestation. This is stronger and more specific than an inverted support link. For example, an agitated appearance can be asserted to be the manifestation (effect) of a known hyperthyroxia. This expresses that one might not have realized a symptom if it would not be a common manifestation of a known condition. The target (cause) may be any service, while the source (manifestation) must be an observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10333"
        },
        {
          "code" : "appliesTo",
          "valueString" : "manifestation"
        },
        {
          "code" : "howApplies",
          "valueString" : "cause"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "manifestation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "manifestationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DE_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DE_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NAME",
      "display" : "assigns name",
      "definition" : "Used to assign a \"name\" to a condition thread. Source is a condition node, target can be any service.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10336"
        },
        {
          "code" : "appliesTo",
          "valueString" : "condition thread"
        },
        {
          "code" : "howApplies",
          "valueString" : "name"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "assignedConditionName"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "conditionNamed"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DJ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DJ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OUTC",
      "display" : "has outcome",
      "definition" : "An observation that should follow or does actually follow as a result or consequence of a condition or action (sometimes called \"post-conditional\".) Target must be an observation as a goal, risk or any criterion. For complex outcomes a conjunction attribute (AND, OR, XOR) can be used. An outcome link is often inverted to describe an outcome assessment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10324"
        },
        {
          "code" : "appliesTo",
          "valueString" : "condition or action"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "howApplies",
          "valueString" : "outcome"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "outcomeOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "outcome"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "A________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "A________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PERT",
      "display" : "has pertinent information",
      "definition" : "This is a very unspecific relationship from one item of clinical information to another. It does not judge about the role the pertinent information plays.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10329"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any service"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "howApplies",
          "valueString" : "any service"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "pertainsTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "pertinentInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "D________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "D________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PREV",
      "display" : "has previous instance",
      "definition" : "A relationship in which the target act is a predecessor instance to the source act. Generally each of these instances is similar, but no identical. In healthcare coverage it is used to link a claim item to a previous claim item that might have claimed for the same set of services.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Previous instance"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14018"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "successor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "predecessor"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REFR",
      "display" : "refers to",
      "definition" : "A relationship in which the target act is referred to by the source act. This permits a simple reference relationship that distinguishes between the referent and the referee.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14020"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "referencedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "reference"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DK_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DK_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REFV",
      "display" : "has reference values",
      "definition" : "Reference ranges are essentially descriptors of a class of result values assumed to be \"normal\", \"abnormal\", or \"critical.\" Those can vary by sex, age, or any other criterion. Source and target are observations, the target is in criterion mood. This link type can act as a trigger in case of alarms being triggered by critical results.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10335"
        },
        {
          "code" : "howApplies",
          "valueString" : "range"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "referenceRangeFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "referenceRange"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DL_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DL_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RELVBY",
      "display" : "relieved by",
      "definition" : "**Description:**The source act is wholly or partially alleviated by the target act. (Example \"chest pain\" RELVBY \"sublingual nitroglycerin administration\")",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22828"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SEQL",
      "display" : "is sequel",
      "definition" : "An act relationship indicating that the source act follows the target act. The source act should in principle represent the same kind of act as the target. Source and target need not have the same mood code (mood will often differ). The target of a sequel is called antecedent. Examples for sequel relationships are: revision, transformation, derivation from a prototype (as a specialization is a derivation of a generalization), followup, realization, instantiation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10337"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "sequel"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "sequelTo"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "B________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "B________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SPRT",
      "display" : "has support",
      "definition" : "Used to indicate that an existing service is suggesting evidence for a new observation. The assumption of support is attributed to the same actor who asserts the observation. Source must be an observation, target may be any service (e.g., to indicate a status post).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10330"
        },
        {
          "code" : "howApplies",
          "valueString" : "supporting evidence"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "supportOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "support"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUBJ",
      "display" : "has subject",
      "definition" : "Relates an Act to its subject Act that the first Act is primarily concerned with.\r\n\r\nExamples\r\n\r\n1.  The first Act may be a ControlAct manipulating the subject Act\r\n2.  The first act is a region of interest (ROI) that defines a region within the subject Act.\r\n3.  The first act is a reporting or notification Act, that echos the subject Act for a specific new purpose.\r\n\r\nConstraints\r\n\r\nAn Act may have multiple subject acts.\r\n\r\nRationale\r\n\r\nThe ActRelationshipType \"has subject\" is similar to the ParticipationType \"subject\", Acts that primarily operate on physical subjects use the Participation, those Acts that primarily operate on other Acts (other information) use the ActRelationship.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13971"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "subjectOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "subject"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUMM",
      "display" : "summarized by",
      "definition" : "An act that contains summary values for a list or set of subordinate acts. For example, a summary of transactions for a particular accounting period.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15988"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "summaryOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "summary"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DM_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DM_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "VALUE",
      "display" : "has value",
      "definition" : "**Description:**Indicates that the target Act represents the result of the source observation Act.\r\n\r\n**FormalConstraint:** Source Act must be an Observation or specialization there-of. Source Act must not have the value attribute specified\r\n\r\n**UsageNote:** This relationship allows the result of an observation to be fully expressed as RIM acts as opposed to being embedded in the value attribute. For example, sending a Document act as the result of an imaging observation, sending a list of Procedures and/or other acts as the result of a medical history observation.\r\n\r\nThe valueNegationInd attribute on the source Act has the same semantics of \"negated finding\" when it applies to the target of a VALUE ActRelationship as it does to the value attribute. On the other hand, if the ActRelationship.negationInd is true for a VALUE ActRelationship, that means the specified observation does not have the indicated value but does not imply a negated finding. Because the semantics are extremely close, it is recommended that Observation.valueNegationInd be used, not ActRelationship.negationInd.\r\n\r\n**OpenIssue:** The implications of negationInd on ActRelationship and the valueNegationind on Observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23319"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CTRLV",
      "display" : "has control variable",
      "definition" : "A relationship from an Act to a Control Variable. For example, if a Device makes an Observation, this relates the Observation to its Control Variables documenting the device's settings that influenced the observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17902"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "controlVariableFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "controlVariable"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MBR",
      "display" : "has member",
      "definition" : "The target Acts are aggregated by the source Act. Target Acts may have independent existence, participate in multiple ActRelationships, and do not contribute to the meaning of the source.\r\n\r\n**UsageNotes:** This explicitly represents the conventional notion of aggregation. The target Act is part of a collection of Acts (no implication is made of cardinality, a source of Acts may contain zero, one, or more member target Acts).\r\n\r\nIt is expected that this will be primarily used with \\_ActClassRecordOrganizer, BATTERY, and LIST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "This explicitly represents the conventional notion of aggregation.  The target Act is part of a collection of Acts (no implication is made of cardinality, a source of Acts may contain zero, one, or more member target Acts). It is expected that this will be primarily used with _ActClassRecordOrganizer, BATTERY, and LIST"
        },
        {
          "code" : "internalId",
          "valueCode" : "23594"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "memberOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "hasMember"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PART",
      "display" : "has part",
      "definition" : "The source Act is a composite of the target Acts. The target Acts do not have an existence independent of the source Act.\r\n\r\n*UsageNote:* In UML 1.1, this is a \"composition\" defined as:  \r\n*\"A form of aggregation with strong ownership and coincident lifetime as part of the whole. Parts with non-fixed multiplicity may be created after the composite itself, but once created they live and die with it (i.e., they share lifetimes). Such parts can also be explicitly removed before the death of the composite. Composition may be recursive.\"*",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23596"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "isPartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "hasPart"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASEAE",
      "display" : "starts after start of, ends after end of",
      "definition" : "The source Act starts after start of the target Act and ends after end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSEBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23583"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOfEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOfEndsAfterAndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAE",
      "display" : "ends after end of",
      "definition" : "A relationship in which the source act ends after the target act ends.\r\n\r\n*UsageNote:* Inverse code is **EBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23081"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ECW",
      "display" : "ends concurrent with",
      "definition" : "A relationship in which the source act's effective time ends with the end of the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23033"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsConcurrentlyWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsConcurrentlyWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ENE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAS",
      "display" : "starts after start of",
      "definition" : "The source Act starts after the start of the target Act (i.e. if we say \"ActOne SAS ActTwo\", it means that ActOne starts after the start of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SBS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21308"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASORSCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAEORECW",
      "display" : "ends after or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time ends after or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EBEORECW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23646"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ECWS",
      "display" : "ends concurrent with start of",
      "definition" : "The source Act ends when the target act starts (i.e. if we say \"ActOne ECWS ActTwo\", it means that ActOne ends when ActTwo starts, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SCWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23463"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBSORECWS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ENS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEBE",
      "display" : "starts before start of, ends before end of",
      "definition" : "The source Act starts before the start of the target Act, and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23590"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOfEndsAfterAndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOfEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBE",
      "display" : "ends before end of",
      "definition" : "The source Act ends before the end of the target Act (i.e. if we say \"ActOne EBE ActTwo\", it means that ActOne ends before the end of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **EAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23461"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBS",
      "display" : "ends before start of",
      "definition" : "A relationship in which the source act ends before the target act starts.\r\n\r\n*UsageNote:* Inverse code is **SAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23078"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsBeforeStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBSORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CONCURRENT",
      "display" : "concurrent with",
      "definition" : "A relationship in which the source act's effective time is the same as the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23032"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "isConcurrentWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "isConcurrentWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSECWE",
      "display" : "starts before start of, ends with",
      "definition" : "The source Act starts before the start of the target Act, and ends with the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASECWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23591"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOfEndsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOfEndsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEASEBE",
      "display" : "contains start of, ends before end of",
      "definition" : "The source Act contains the start of the target Act, and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASSBEEAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23589"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startAfterStartOfContainsEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "containsStartOfEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EDU"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWSEBE",
      "display" : "starts with. ends before end of",
      "definition" : "The source Act starts with.the target Act and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SCWSEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23593"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsWithEndsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsWithEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EDU"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OCCR",
      "display" : "occurrence",
      "definition" : "The source act is a single occurrence of a repeatable target act. The source and target act can be in any mood on the \"completion track\" but the source act must be as far as or further along the track than the target act (i.e., the occurrence of an intent can be an event but not vice versa).",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "is occurrence of"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11614"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "occurrence"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "occurrenceOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OREF",
      "display" : "references order",
      "definition" : "Relates either an appointment request or an appointment to the order for the service being scheduled.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11628"
        },
        {
          "code" : "appliesTo",
          "valueString" : "ActMood = ARQ or APT and ActMood = ORD"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "referencedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "referencedOrder"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BAB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BAB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCH",
      "display" : "schedules request",
      "definition" : "Associates a specific time (and associated resources) with a scheduling request or other intent.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "schedules"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11627"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "requestedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "scheduleRequest"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BAC______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BAC______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ACTIMM",
      "display" : "active immunization against",
      "definition" : "**Description:** The source act is intended to provide active immunity against the effects of the target act (the target act describes an infectious disease)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23305"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "activelyImmunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IMM"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PASSIMM",
      "display" : "passive immunization against",
      "definition" : "**Description:** The source act is intended to provide passive immunity against the effects of the target act (the target act describes an infectious disease).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23306"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "passivelyImmunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IMM"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "STEP",
      "display" : "has step",
      "definition" : "A collection of sub-services as steps or subtasks performed for the source service. Services may be performed sequentially or concurrently.\r\n\r\n*UsageNotes:* Sequence of steps may be indicated by use of \\_ActRelationshipTemporallyPertains, as well as via ActRelationship.sequenceNumber, ActRelationship.pauseQuantity, Target.priorityCode.\r\n\r\n*OpenIssue:* Need Additional guidelines on when each approach should be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Sequence of steps may be indicated by use of _ActRelationshipTemporallyPertains, as well as via  ActRelationship.sequenceNumber, ActRelationship.pauseQuantity, Target.priorityCode."
        },
        {
          "code" : "internalId",
          "valueCode" : "23595"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any _ActMoodCompletionTrack"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "isStepOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "hasStep"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "MBR"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RCVY",
      "display" : "recovers",
      "definition" : "**Definition:** The source act is performed to recover from the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22189"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "recoveredFrom"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "recovers"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "MITGT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationsipObjective",
      "display" : "Act Relationsip Objective",
      "definition" : "The target act is a desired outcome of the source act. Source is any act (typically an intervention). Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21384"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "goalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "goal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "AC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "AC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GOAL",
      "display" : "has goal",
      "definition" : "A goal that one defines given a patient's health condition. Subsequently planned actions aim to meet that goal. Source is an observation or condition node, target must be an observation in goal mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10325"
        },
        {
          "code" : "appliesTo",
          "valueString" : "observation, condition"
        },
        {
          "code" : "howApplies",
          "valueString" : "goal"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "goalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "goal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "AB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "AB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RISK",
      "display" : "has risk",
      "definition" : "A noteworthy undesired outcome of a patient's condition that is either likely enough to become an issue or is less likely but dangerous enough to be addressed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10328"
        },
        {
          "code" : "appliesTo",
          "valueString" : "observation, condition"
        },
        {
          "code" : "howApplies",
          "valueString" : "risk"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "riskOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "risk"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "AA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "AA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EDU",
      "display" : "ends during",
      "definition" : "A relationship in which the source act ends within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBEEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23080"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "encompassesEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBEEAE",
      "display" : "contains end of",
      "definition" : "The source Act contains the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **EDU**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23587"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "containsEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASEAE"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEAS",
      "display" : "contains start of",
      "definition" : "The source Act contains the start of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SDU**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23586"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "containsStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCW",
      "display" : "starts concurrent with",
      "definition" : "A relationship in which the source act's effective time starts with the start of the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23036"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsConcurrentlyWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsConcurrentlyWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASORSCW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSORSCW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SNS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWE",
      "display" : "starts concurrent with end of",
      "definition" : "The source Act starts when the target act ends (i.e. if we say \"ActOne SCWE ActTwo\", it means that ActOne starts when ActTwo ends, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SBSECWS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23462"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAEORSCWE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SNE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SDU",
      "display" : "starts during",
      "definition" : "A relationship in which the source act starts within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBSEAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23082"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "encompassesStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "USE",
      "display" : "uses",
      "definition" : "Indicates that the source act makes use of (or will make use of) the information content of the target act.\r\n\r\n*UsageNotes:* A usage relationship only makes sense if the target act is authored and occurs independently of the source act. Otherwise a simpler relationship such as COMP would be appropriate.\r\n\r\n*Rationale:* There is a need when defining a clinical trial protocol to indicate that the protocol makes use of other protocol or treatment specifications. This is stronger than the assertion of \"references\". References may exist without usage, and in a clinical trial protocol is common to assert both: what other specifications does this trial use and what other specifications does it merely reference.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "A usage relationship only makes sense if the target act is authored and occurs independently of the source act.  Otherwise a simpler relationship such as COMP would be appropriate."
        },
        {
          "code" : "internalId",
          "valueCode" : "23102"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "usedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "uses"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DKA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DKA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "REFR"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "BLOCK",
      "display" : "blocks",
      "definition" : "**Definition:** The source act is performed to block the effects of the target act. This act relationship should be used when describing near miss type incidents where potential harm could have occurred, but the action described in the source act blocked the potential harmful effects of the incident actually occurring.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22188"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "blockedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "blocks"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DIAG",
      "display" : "diagnoses",
      "definition" : "**Description:** The source act is intended to help establish the presence of a (an adverse) situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21644"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "diagnosedBy"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "IMM",
      "display" : "immunization against",
      "definition" : "**Description:** The source act is intented to provide immunity against the effects of the target act (the target act describes an infectious disease)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23304"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "immunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MITGT",
      "display" : "mitigates",
      "definition" : "The source act removes or lessens the occurrence or effect of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19986"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "mitigatedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "mitigates"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "CAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "CAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PRYLX",
      "display" : "prophylaxis of",
      "definition" : "**Description:** The source act is intended to reduce the risk of of an adverse situation to emerge as described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23303"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "prophylaxisOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TREAT",
      "display" : "treats",
      "definition" : "**Description:** The source act is intended to improve a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23307"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "treatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAE",
      "display" : "starts after end of",
      "definition" : "A relationship in which the source act starts after the target act ends.\r\n\r\n*UsageNote:* Inverse code is **EBS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22043"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsBeforeStartof"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAEORSCWE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DURING",
      "display" : "occurs during",
      "definition" : "A relationship in which the source act's effective time is wholly within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBSEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23034"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "spansOccurrenceOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "occursDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASECWE",
      "display" : "starts after start of, ends with",
      "definition" : "The source Act starts after start of the target Act, and ends with the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSECWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23584"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOfEndsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOfEndsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASSBEEAS",
      "display" : "start after start of, contains end of",
      "definition" : "The source Act start after the start of the target Act, and contains the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSEASEBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23585"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "containsStartOfEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startAfterStartOfContainsEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SDU"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBEORECW",
      "display" : "ends before or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time ends before or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EAEORECW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23648"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSORSCW",
      "display" : "starts before or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time starts before or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SASORSCW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23647"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEAE",
      "display" : "contains time of",
      "definition" : "The source Act contains the time of the target Act.\r\n\r\n*UsageNote:* Inverse code is **DURING**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23588"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "occursDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "containsTimeOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWSEAE",
      "display" : "starts with, ends after end of",
      "definition" : "The source Act starts with the target Act, and ends after the end of the target Act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23592"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsWithEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsWithEndsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OVERLAP",
      "display" : "overlaps with",
      "definition" : "A relationship in which the source act's effective time overlaps the target act's effective time in any way.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23035"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "overlapsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "overlapsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEORSCWE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBE",
      "display" : "starts before end of",
      "definition" : "The source Act starts before the end of the target Act (i.e. if we say \"ActOne SBE ActTwo\", it means that ActOne starts before the end of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **EAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23460"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsAfterStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEORSCWE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBSORECWS",
      "display" : "ends before or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time ends before or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EASORECWS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23649"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "endsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "endsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBS",
      "display" : "starts before start of",
      "definition" : "A relationship in which the source act begins before the target act begins.\r\n\r\n*UsageNote:* Inverse code is **SAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23076"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "startsAfterStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "startsBeforeStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSORSCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "APND",
      "display" : "is appendage",
      "definition" : "An addendum (source) to an existing service object (target), containing supplemental information. The addendum is itself an original service object linked to the supplemented service object. The supplemented service object remains in place and its content and status are unaltered.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10339"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "appendageOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "appendage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BJ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BJ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "BSLN",
      "display" : "has baseline",
      "definition" : "Indicates that the target observation(s) provide an initial reference for the source observation or observation group.\r\n\r\n*UsageConstraints:* Both source and target must be Observations or specializations thereof.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23101"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "baselineFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "baseline"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BG_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BG_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COMPLY",
      "display" : "complies with",
      "definition" : "**Description:**The source act complies with, adheres to, conforms to, or is permissible under (in whole or in part) the policy, contract, agreement, law, conformance criteria, certification guidelines or requirement conveyed by the target act.\r\n\r\nExamples for compliance relationships are: audits of adherence with a security policy, certificate of conformance to system certification requirements, or consent directive in compliance with or permissible under a privacy policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22626"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "compliesWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "compliance"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DOC",
      "display" : "documents",
      "definition" : "The source act documents the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11609"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "documentation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "documentationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BH_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BH_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "FLFS",
      "display" : "fulfills",
      "definition" : "The source act fulfills (in whole or in part) the target act. Source act must be in a mood equal or more actual than the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10342"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "fulfillment"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "inFulfillmentOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GEN",
      "display" : "has generalization",
      "definition" : "The generalization relationship can be used to express categorical knowledge about services (e.g., amilorid, triamterene, and spironolactone have the common generalization potassium sparing diuretic).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10348"
        },
        {
          "code" : "appliesTo",
          "valueString" : "specialization"
        },
        {
          "code" : "howApplies",
          "valueString" : "generalization"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "specialization"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "generalization"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GEVL",
      "display" : "evaluates (goal)",
      "definition" : "A goal-evaluation links an observation (intent or actual) to a goal to indicate that the observation evaluates the goal. Given the goal and the observation, a \"goal distance\" (e.g., goal to observation) can be \"calculated\" and need not be sent explicitly.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10346"
        },
        {
          "code" : "appliesTo",
          "valueString" : "evaluation"
        },
        {
          "code" : "howApplies",
          "valueString" : "goal"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "evaluation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "evaluationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INST",
      "display" : "instantiates (master)",
      "definition" : "Used to capture the link between a potential service (\"master\" or plan) and an actual service, where the actual service instantiates the potential service. The instantiation may override the master's defaults.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10341"
        },
        {
          "code" : "appliesTo",
          "valueString" : "instance"
        },
        {
          "code" : "howApplies",
          "valueString" : "master"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "instantiation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "definition"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MOD",
      "display" : "modifies",
      "definition" : "Definition: Used to link a newer version or 'snapshot' of a business object (source) to an older version or 'snapshot' of the same business object (target).\r\n\r\n*Usage:*The identifier of the Act should be the same for both source and target. If the identifiers are distinct, RPLC should be used instead.\r\n\r\nName from source to target = \"modifiesPrior\"\r\n\r\nName from target to source = \"modifiesByNew\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21638"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTCH",
      "display" : "matches (trigger)",
      "definition" : "A trigger-match links an actual service (e.g., an observation or procedure that took place) with a service in criterion mood. For example if the trigger is \"observation of pain\" and pain is actually observed, and if that pain-observation caused the trigger to fire, that pain-observation can be linked with the trigger.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10345"
        },
        {
          "code" : "appliesTo",
          "valueString" : "matching service"
        },
        {
          "code" : "howApplies",
          "valueString" : "trigger"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "match"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "matchOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BF_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BF_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OPTN",
      "display" : "has option",
      "definition" : "A relationship between a source Act that provides more detailed properties to the target Act.\r\n\r\nThe source act thus is a specialization of the target act, but instead of mentioning all the inherited properties it only mentions new property bindings or refinements.\r\n\r\nThe typical use case is to specify certain alternative variants of one kind of Act. The priorityNumber attribute is used to weigh refinements as preferred over other alternative refinements.\r\n\r\nExample: several routing options for a drug are specified as one SubstanceAdministration for the general treatment with attached refinements for the various routing options.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10347"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "optionFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "option"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RCHAL",
      "display" : "re-challenge",
      "definition" : "**Description:**A relationship in which the target act is carried out to determine whether an effect attributed to the source act can be recreated.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22044"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REV",
      "display" : "reverses",
      "definition" : "A relationship between a source Act that seeks to reverse or undo the action of the prior target Act.\r\n\r\nExample: A posted financial transaction (e.g., a debit transaction) was applied in error and must be reversed (e.g., by a credit transaction) the credit transaction is identified as an undo (or reversal) of the prior target transaction.\r\n\r\nConstraints: the \"completion track\" mood of the target Act must be equally or more \"actual\" than the source act. I.e., when the target act is EVN the source act can be EVN, or any INT. If the target act is INT, the source act can be INT.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14898"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "reversal"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "reversalOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BK_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BK_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RPLC",
      "display" : "replaces",
      "definition" : "A replacement source act replaces an existing target act. The state of the target act being replaced becomes obselete, but the act is typically still retained in the system for historical reference. The source and target must be of the same type.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10338"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "replacement"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "replacementOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BI_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BI_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUCC",
      "display" : "succeeds",
      "definition" : "**Definition:** A new act that carries forward the intention of the original act, but does not completely replace it. The status of the predecessor act must be 'completed'. The original act is the target act and the successor is the source act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11616"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "successor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "predecessor"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BIA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BIA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "UPDT",
      "display" : "updates (condition)",
      "definition" : "A condition thread relationship specifically links condition nodes together to form a condition thread. The source is the new condition node and the target links to the most recent node of the existing condition thread.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10340"
        },
        {
          "code" : "appliesTo",
          "valueString" : "new head of thread"
        },
        {
          "code" : "howApplies",
          "valueString" : "old head of thread"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "update"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "updateOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BE_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BE_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "XCRPT",
      "display" : "Excerpts",
      "definition" : "The source is an excerpt from the target.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18660"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "excerpt"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "excerptFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BM_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BM_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "XFRM",
      "display" : "transformation",
      "definition" : "Used when the target Act is a transformation of the source Act. (For instance, used to show that a CDA document is a transformation of a DICOM SR document.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11624"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "transformation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "transformationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BL_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BL_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SPRTBND",
      "display" : "has bounded support",
      "definition" : "A specialization of \"has support\" (SPRT), used to relate a secondary observation to a Region of Interest on a multidimensional observation, if the ROI specifies the true boundaries of the secondary observation as opposed to only marking the approximate area. For example, if the start and end of an ST elevation episode is visible in an EKG, this relation would indicate the ROI bounds the \"ST elevation\" observation -- the ROI defines the true beginning and ending of the episode. Conversely, if a ROI simply contains ST elevation, but it does not define the bounds (start and end) of the episode, the more general \"has support\" relation is used. Likewise, if a ROI on an image defines the true bounds of a \"1st degree burn\", the relation \"has bounded support\" is used; but if the ROI only points to the approximate area of the burn, the general \"has support\" relation is used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17899"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "boundedSupportOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "boundedSupport"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SPRT"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ARR",
      "display" : "arrival",
      "definition" : "The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act entered into the source Act by means of the target Transportation act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17911"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "arrivalFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "arrivedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EAAB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EAAB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "STEP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DEP",
      "display" : "departure",
      "definition" : "The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act departed from the source Act by means of the target Transportation act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17912"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "departureFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "departedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "EAAC_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "EAAC_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "STEP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "QUALF",
      "display" : "has qualifier",
      "definition" : "The target observation qualifies (refines) the semantics of the source observation.\r\n\r\n*UsageNote:* This is not intended to replace concept refinement and qualification via vocabulary. It is used when there are multiple components which together provide the complete understanding of the source Act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23598"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "qualifies"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "hasQualifier"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "DBA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "DBA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUBJ"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ADJUNCT",
      "display" : "adjunctive treatment",
      "definition" : "**Description:** The source act is intended to offer an additional treatment for the management or cure of a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature. It is not a requirement that the non-adjunctive treatment is explicitly specified.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23310"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "adjunctiveTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTREAT",
      "display" : "maintenance treatment",
      "definition" : "**Description:** The source act is intended to provide long term maintenance improvement or management of a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23308"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "maintenanceTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PALLTREAT",
      "display" : "palliates",
      "definition" : "**Description:** The source act is intended to provide palliation for the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23309"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "palliativeTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SYMP",
      "display" : "symptomatic relief",
      "definition" : "**Description:** The source act is intented to provide symptomatic relief for the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21645"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "symptomaticTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "VRXCRPT",
      "display" : "Excerpt verbatim",
      "definition" : "The source is a direct quote from the target.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18661"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueString" : "verbatimExcerpt"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueString" : "verbatimExcerptFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueString" : "BMA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueString" : "BMA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "XCRPT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    }
  ]
}

```
