# ActMood - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActMood**

## CodeSystem: ActMood 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActMood | *Version*:3.0.0 | |
| Active as of 2023-05-30 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActMood |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1001 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept definitions in the vocabulary used for Act.moodCode. The vote was found "Persuasive With Mod", with the understanding that M and M would undertake a detailed review of these concept definitions for a future release of the RIM. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSMoodCodes](ValueSet-v2-0725.md)
* [ActMood](ValueSet-v3-ActMood.md)
* [ActMoodActRequest](ValueSet-v3-ActMoodActRequest.md)
* [ActMoodAppointment](ValueSet-v3-ActMoodAppointment.md)
* [ActMoodAppointmentRequest](ValueSet-v3-ActMoodAppointmentRequest.md)
* [ActMoodCompletionTrack](ValueSet-v3-ActMoodCompletionTrack.md)
* [ActMoodCriterion](ValueSet-v3-ActMoodCriterion.md)
* [ActMoodDefinition](ValueSet-v3-ActMoodDefinition.md)
* [ActMoodDesire](ValueSet-v3-ActMoodDesire.md)
* [ActMoodEventCriterion](ValueSet-v3-ActMoodEventCriterion.md)
* [ActMoodEventOccurrence](ValueSet-v3-ActMoodEventOccurrence.md)
* [ActMoodExpectation](ValueSet-v3-ActMoodExpectation.md)
* [ActMoodGoal](ValueSet-v3-ActMoodGoal.md)
* [ActMoodIntent](ValueSet-v3-ActMoodIntent.md)
* [ActMoodOption](ValueSet-v3-ActMoodOption.md)
* [ActMoodPermission](ValueSet-v3-ActMoodPermission.md)
* [ActMoodPermissionRequest](ValueSet-v3-ActMoodPermissionRequest.md)
* [ActMoodPotential](ValueSet-v3-ActMoodPotential.md)
* [ActMoodPredicate](ValueSet-v3-ActMoodPredicate.md)
* [ActMoodPromise](ValueSet-v3-ActMoodPromise.md)
* [ActMoodProposal](ValueSet-v3-ActMoodProposal.md)
* [ActMoodRecommendation](ValueSet-v3-ActMoodRecommendation.md)
* [ActMoodRequest](ValueSet-v3-ActMoodRequest.md)
* [ActMoodResourceSlot](ValueSet-v3-ActMoodResourceSlot.md)
* [ActMoodRisk](ValueSet-v3-ActMoodRisk.md)
* [XActMoodCompletionCriterion](ValueSet-v3-xActMoodCompletionCriterion.md)
* [XActMoodDefEvn](ValueSet-v3-xActMoodDefEvn.md)
* [XActMoodDefEvnRqo](ValueSet-v3-xActMoodDefEvnRqo.md)
* [XActMoodDefEvnRqoPrmsPrp](ValueSet-v3-xActMoodDefEvnRqoPrmsPrp.md)
* [XActMoodDocumentObservation](ValueSet-v3-xActMoodDocumentObservation.md)
* [XActMoodEvnOrdPrmsPrp](ValueSet-v3-xActMoodEvnOrdPrmsPrp.md)
* [XActMoodIntentEvent](ValueSet-v3-xActMoodIntentEvent.md)
* [XActMoodOrdPrms](ValueSet-v3-xActMoodOrdPrms.md)
* [XActMoodOrdPrmsEvn](ValueSet-v3-xActMoodOrdPrmsEvn.md)
* [XActMoodPermPermrq](ValueSet-v3-xActMoodPermPermrq.md)
* [XActMoodRequestEvent](ValueSet-v3-xActMoodRequestEvent.md)
* [XActMoodRqoPrpAptArq](ValueSet-v3-xActMoodRqoPrpAptArq.md)
* [XClinicalStatementActMood](ValueSet-v3-xClinicalStatementActMood.md)
* [XClinicalStatementEncounterMood](ValueSet-v3-xClinicalStatementEncounterMood.md)
* [XClinicalStatementExposureMood](ValueSet-v3-xClinicalStatementExposureMood.md)
* [XClinicalStatementObservationMood](ValueSet-v3-xClinicalStatementObservationMood.md)
* [XClinicalStatementProcedureMood](ValueSet-v3-xClinicalStatementProcedureMood.md)
* [XClinicalStatementSubstanceMood](ValueSet-v3-xClinicalStatementSubstanceMood.md)
* [XClinicalStatementSupplyMood](ValueSet-v3-xClinicalStatementSupplyMood.md)
* [XDocumentActMood](ValueSet-v3-xDocumentActMood.md)
* [XDocumentEncounterMood](ValueSet-v3-xDocumentEncounterMood.md)
* [XDocumentProcedureMood](ValueSet-v3-xDocumentProcedureMood.md)
* [XDocumentSubstanceMood](ValueSet-v3-xDocumentSubstanceMood.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActMood",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1001"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActMood",
  "title" : "ActMood",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-05-30",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept definitions in the vocabulary used for Act.moodCode. The vote was found \"Persuasive With Mod\", with the understanding that M and M would undertake a detailed review of these concept definitions for a future release of the RIM.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "Name:Class",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Class",
      "description" : "The formal name for the class clone under this code",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "_ActMoodCompletionTrack",
      "display" : "ActMoodCompletionTrack",
      "definition" : "These are moods describing activities as they progress in the business cycle, from defined, through planned and ordered to completed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20935"
        },
        {
          "code" : "Name:Class",
          "valueString" : "Process"
        }
      ],
      "concept" : [
        {
          "code" : "_ActMoodPotential",
          "display" : "potential",
          "definition" : "**Definition:** A possible act.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23087"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Potential"
            }
          ],
          "concept" : [
            {
              "code" : "DEF",
              "display" : "definition",
              "definition" : "**Definition:** A definition of a kind of act that can occur .\r\n\r\n**OpenIssue:** The semantic constructs embodied in DEF and CRT moods seem indistinguishable, and their uses can readily be determined by the context in which these are used. Therefore, this OpenIssue has been created to declare that it is likely that ActMood.DEF will be \"retired\" in the future in favor of the more general ActMood.CRT.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10198"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Definition"
                }
              ]
            },
            {
              "code" : "PERM",
              "display" : "permission",
              "definition" : "**Definition:** A kind of act that defines a permission that has been granted.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21381"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Permission"
                }
              ]
            },
            {
              "code" : "SLOT",
              "display" : "resource slot",
              "definition" : "**Definition:** A kind of act that may occur during the specified time period.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19168"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "ResourceSlot"
                }
              ]
            }
          ]
        },
        {
          "code" : "EVN",
          "display" : "event (occurrence)",
          "definition" : "**Definition:** An act that actually happens (may be an ongoing act or a documentation of a past act).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10201"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Event"
            }
          ]
        },
        {
          "code" : "INT",
          "display" : "intent",
          "definition" : "**Definition:** An intention or plan for an act.\r\n\r\n**>UsageNotes:** The final outcome of the intent, the act that is intended to occur, is always an event. However the final outcome may be reached indirectly via steps through other intents, such as promise, permission request, or an appointment that may lead to an actual event to occur. Alternatively, the intended act may never occur.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10199"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Intent"
            }
          ],
          "concept" : [
            {
              "code" : "_ActMoodDesire",
              "display" : "desire",
              "definition" : "**Definition:** A desire to have an act occur.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23088"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Desire"
                }
              ],
              "concept" : [
                {
                  "code" : "_ActMoodActRequest",
                  "display" : "act request",
                  "definition" : "**Definition:** A request (or order) for an act that is part of a defined request/fulfillment cycle.\r\n\r\n**UsageNotes:** Use of an HL7 defined request/fulfillment framework is not required to use this mood code.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "HL7usageNotes",
                      "valueString" : "Use of an HL7 defined request/fulfillment framework is not required to use this mood code."
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23089"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "ActRequest"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ARQ",
                      "display" : "appointment request",
                      "definition" : "**Definition:** A request act that is specialized for the appointment scheduling request/fulfillment cycle. An appointment request is fulfilled only and completely by an appointment (APT), i.e., all that the appointment request intends is to create an appointment *(the actual act may well not happen if that is the professional decision during the appointment)*.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11625"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "AppointmentRequest"
                        }
                      ]
                    },
                    {
                      "code" : "PERMRQ",
                      "display" : "permission request",
                      "definition" : "**Definition:** A request for a permission to perform the act. Typically a payer (or possibly a supervisor) is being requested to give permission to perform the act. As opposed to the RQO, the requestee is not asked to perform or cause to perform the act but only to give the permission.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21382"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "PermissionRequest"
                        }
                      ]
                    },
                    {
                      "code" : "RQO",
                      "display" : "request",
                      "definition" : "**Definition:** A request act that is specialized for an event request/fulfillment cycle.\r\n\r\n**UsageNotes:** The fulfillment cycle may involve intermediary fulfilling acts in moods such as PRMS, APT, or even another RQO before being fulfilled by the final event.\r\n\r\n**UsageNotes:** The concepts of a \"request\" and an \"order\" are viewed as different, because there is an implication of a mandate associated with order. In practice, however, this distinction has no general functional value in the inter-operation of health care computing. \"Orders\" are commonly refused for a variety of clinical and business reasons, and the notion of a \"request\" obligates the recipient (the fulfiller) to respond to the sender (the author). Indeed, in many regions, including Australia and Europe, the common term used is \"request.\"\r\n\r\nThus, the concept embodies both notions, as there is no useful distinction to be made. If a mandate is to be associated with a request, this will be embodied in the \"local\" business rules applied to the transactions. Should HL7 desire to provide a distinction between these in the future, the individual concepts could be added as specializations of this concept.\r\n\r\nThe critical distinction here, is the difference between this concept and an \"intent\", of which it is a specialization. An intent involves decisions by a single party, the author. A request, however, involves decisions by two parties, the author and the fulfiller, with an obligation on the part of the fulfiller to respond to the request indicating that the fulfiller will indeed fulfill the request.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "synonymCode",
                          "valueCode" : "ORD"
                        },
                        {
                          "code" : "HL7usageNotes",
                          "valueString" : "The concepts of a \"request\" and an \"order\" are viewed as different, because there is an implication of a mandate associated with order.  In practice, however, this distinction has no general functional value in the inter-operation of health care computing.  \"Orders\" are commonly refused for a variety of clinical and business reasons, and the notion of a \"request\" obligates the recipient (the fulfiller) to respond to the sender (the author).  Indeed, in many regions, including Australia and Europe, the common term used is \"request.\" Thus, the concept embodies both notions, as there is no useful distinction to be made.  If a mandate is to be associated with a request, this will be embodied in the \"local\" business rules applied to the transactions.  Should HL7 desire to provide a distinction between these in the future, the individual concepts could be added as specializations of this concept. The critical distinction here, is the difference between this concept and an \"intent\", of which it is a specialization.  An intent involves decisions by a single party, the author.  A request, however, involves decisions by two parties, the author and the fulfiller, with an obligation on the part of the fulfiller to respond to the request indicating that the fulfiller will indeed fulfill the request."
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19973"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "Request"
                        }
                      ]
                    },
                    {
                      "code" : "ORD",
                      "display" : "request",
                      "definition" : "**Definition:** A request act that is specialized for an event request/fulfillment cycle.\r\n\r\n**UsageNotes:** The fulfillment cycle may involve intermediary fulfilling acts in moods such as PRMS, APT, or even another RQO before being fulfilled by the final event.\r\n\r\n**UsageNotes:** The concepts of a \"request\" and an \"order\" are viewed as different, because there is an implication of a mandate associated with order. In practice, however, this distinction has no general functional value in the inter-operation of health care computing. \"Orders\" are commonly refused for a variety of clinical and business reasons, and the notion of a \"request\" obligates the recipient (the fulfiller) to respond to the sender (the author). Indeed, in many regions, including Australia and Europe, the common term used is \"request.\"\r\n\r\nThus, the concept embodies both notions, as there is no useful distinction to be made. If a mandate is to be associated with a request, this will be embodied in the \"local\" business rules applied to the transactions. Should HL7 desire to provide a distinction between these in the future, the individual concepts could be added as specializations of this concept.\r\n\r\nThe critical distinction here, is the difference between this concept and an \"intent\", of which it is a specialization. An intent involves decisions by a single party, the author. A request, however, involves decisions by two parties, the author and the fulfiller, with an obligation on the part of the fulfiller to respond to the request indicating that the fulfiller will indeed fulfill the request.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "retired"
                        },
                        {
                          "code" : "synonymCode",
                          "valueCode" : "RQO"
                        },
                        {
                          "code" : "HL7usageNotes",
                          "valueString" : "The concepts of a \"request\" and an \"order\" are viewed as different, because there is an implication of a mandate associated with order.  In practice, however, this distinction has no general functional value in the inter-operation of health care computing.  \"Orders\" are commonly refused for a variety of clinical and business reasons, and the notion of a \"request\" obligates the recipient (the fulfiller) to respond to the sender (the author).  Indeed, in many regions, including Australia and Europe, the common term used is \"request.\" Thus, the concept embodies both notions, as there is no useful distinction to be made.  If a mandate is to be associated with a request, this will be embodied in the \"local\" business rules applied to the transactions.  Should HL7 desire to provide a distinction between these in the future, the individual concepts could be added as specializations of this concept. The critical distinction here, is the difference between this concept and an \"intent\", of which it is a specialization.  An intent involves decisions by a single party, the author.  A request, however, involves decisions by two parties, the author and the fulfiller, with an obligation on the part of the fulfiller to respond to the request indicating that the fulfiller will indeed fulfill the request."
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19973"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "Request"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "PRP",
                  "display" : "proposal",
                  "definition" : "**Definition:** A suggestion that an act might be performed. Not an explicit request, and professional responsibility may or may not be present.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16726"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "Proposal"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "RMD",
                      "display" : "recommendation",
                      "definition" : "**Definition:** A suggestion that an act should be performed with an acceptance of some degree of professional responsibility for the resulting act. Not an explicit request. .\r\n\r\n**UsageNotes:** Where there is no clear definition or applicable concept of \"professional responsibility\", RMD becomes indistinguishable from PRP. .",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "HL7usageNotes",
                          "valueString" : "Where there is no clear definition or applicable concept of \"professional responsibility\", RMD becomes indistinguishable from PRP. ."
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21571"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "Recommendation"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "PRMS",
              "display" : "promise",
              "definition" : "**Definition:** A commitment to perform an act (may be either solicited or unsolicited). The committer becomes responsible to the other party for executing the act, and, as a consequence, the other party may rely on the first party to perform or cause to perform the act.\r\n\r\n**UsageNotes:** Commitments may be retracted or cancelled.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "Commitments may be retracted or cancelled."
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16728"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Promise"
                }
              ],
              "concept" : [
                {
                  "code" : "APT",
                  "display" : "appointment",
                  "definition" : "**Definition:** An act that has been scheduled to be performed at a specific place and time.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11626"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "Appointment"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_ActMoodPredicate",
      "display" : "ActMoodPredicate",
      "definition" : "**Definition:** An act that expresses condition statements for other acts.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20936"
        },
        {
          "code" : "Name:Class",
          "valueString" : "Predicate"
        }
      ],
      "concept" : [
        {
          "code" : "CRT",
          "display" : "criterion",
          "definition" : "***Deprecation Comment:*** This concept This codes should no longer be used. Instead, set attribute Act.isCriterionInd to \"true\" and use the desired mood for your criterion.\r\n\r\n**Definition:** A condition that must be true for the source act to be considered.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2010-07-12"
            },
            {
              "code" : "internalId",
              "valueCode" : "22042"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Criterion"
            }
          ],
          "concept" : [
            {
              "code" : "EVN.CRT",
              "display" : "event criterion",
              "definition" : "***Deprecation Comment:*** This concept This codes should no longer be used. Instead, set attribute Act.isCriterionInd to \"true\" and use the desired mood for your criterion.\r\n\r\n**Definition:** A criterion (CRT) that has\\_match = an event (EVN).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "deprecated"
                },
                {
                  "code" : "deprecationDate",
                  "valueDateTime" : "2010-07-12"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10203"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "EventCriterion"
                }
              ]
            },
            {
              "code" : "GOL.CRT",
              "display" : "goal criterion",
              "definition" : "A criterion expressed over goals (ActMood.GOL).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23057"
                }
              ]
            },
            {
              "code" : "INT.CRT",
              "display" : "intent criterion",
              "definition" : "A criterion expressed over intents (ActMood.INT).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23054"
                }
              ],
              "concept" : [
                {
                  "code" : "PRMS.CRT",
                  "display" : "promise criterion",
                  "definition" : "A criterion expressed over promises (ActMood.PRMS).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "retired"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23056"
                    }
                  ]
                },
                {
                  "code" : "RQO.CRT",
                  "display" : "request criterion",
                  "definition" : "A criterion expressed over requests or orders (ActMood.RQO).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "retired"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23055"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "RSK.CRT",
              "display" : "risk criterion",
              "definition" : "A criterion expressed over risks (ActMood.RSK).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23058"
                }
              ]
            }
          ]
        },
        {
          "code" : "EXPEC",
          "display" : "expectation",
          "definition" : "**Definition:** An act that is considered to have some noteworthy likelihood of occurring in the future (has\\_match = event).\r\n\r\n**Examples:**Prognosis of a condition, Expected date of discharge from hospital, patient will likely need an emergency decompression of the intracranial pressure by morning.\r\n\r\n**UsageNotes:**INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with expectation, which is a prediction that something will happen in the future. GOL (goal) reflects a hope rather than a prediction. RSK (risk) reflects a potential negative event that may or may not be expected to happen.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "HL7usageNotes",
              "valueString" : "INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with expectation, which is a prediction that something will happen in the future. GOL (goal) reflects a hope rather than a prediction. RSK (risk) reflects a potential negative event that may or may not be expected to happen."
            },
            {
              "code" : "internalId",
              "valueCode" : "21574"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Expectation"
            }
          ],
          "concept" : [
            {
              "code" : "GOL",
              "display" : "Goal",
              "definition" : "**Definition:** An expectation that is considered to be desirable to occur in the future\r\n\r\n**Examples:**Target weight below 80Kg, Stop smoking, Regain ability to walk, goal is to administer thrombolytics to candidate patients presenting with acute myocardial infarction.\r\n\r\n**UsageNotes:** INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with goal which doesn't represent an intention to act, merely a hope for an eventual result. A goal is distinct from the intended actions to reach that goal. \"I will reduce the dose of drug x to 20mg\" is an intent. \"I hope to be able to get the patient to the point where I can reduce the dose of drug x to 20mg\" is a goal. EXPEC (expectation) reflects a prediction rather than a hope. RSK (risk) reflects a potential negative event rather than a hope.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "INT (intent) reflects a plan for the future, which is a declaration to do something.  This contrasts with goal which doesn't represent an intention to act, merely a hope for an eventual result.  A goal is distinct from the intended actions to reach that goal.  \"I will reduce the dose of drug x to 20mg\" is an intent.  \"I hope to be able to get the patient to the point where I can reduce the dose of drug x to 20mg\" is a goal. EXPEC (expectation) reflects a prediction rather than a hope. RSK (risk) reflects a potential negative event rather than a hope."
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18864"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Goal"
                }
              ]
            },
            {
              "code" : "RSK",
              "display" : "risk",
              "definition" : "**Definition:**An act that may occur in the future and which is regarded as undesirable\r\n\r\n**Examples:**Increased risk of DVT, at risk for sub-acute bacterial endocarditis.\r\n\r\n**UsageNotes:**Note: An observation in RSK mood expresses the undesirable act, and not the underlying risk factor. A risk factor that is present (e.g. obesity, smoking, etc) should be expressed in event mood. INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen. GOL (goal) reflects a hope to achieve something. EXPEC (expectation) is the prediction of a positive or negative event. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen, and may not be expected to happen.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "Note: An observation in RSK mood expresses the undesirable act, and not the underlying risk factor. A risk factor that is present (e.g. obesity, smoking, etc) should be expressed in event mood. INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen. GOL (goal) reflects a hope to achieve something. EXPEC (expectation) is the prediction of a positive or negative event. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen, and may not be expected to happen."
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21575"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "Risk"
                }
              ]
            }
          ]
        },
        {
          "code" : "OPT",
          "display" : "option",
          "definition" : "**Definition:** One of a set of acts that specify an option for the property values that the parent act may have. Typically used in definitions or orders to describe alternatives. An option can only be used as a group, that is, all assigned values must be used together. The actual mood of the act is the same as the parent act, and they must be linked by an actrelationship with type = OPTN.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10204"
            },
            {
              "code" : "Name:Class",
              "valueString" : "Option"
            }
          ]
        }
      ]
    }
  ]
}

```
