# V2 Table List - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **V2 Table List**

## CodeSystem: V2 Table List 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-tables | *Version*:6.0.0 | |
| Active as of 2025-02-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:V2Tables |
| **Copyright/Legal**: Copyright HL7. Licensed under creative commons public domain | | |

 
Master List of V2 Tables 
Please note that V2 Code System and Value Set URIs are present, but the URIs do not resolve. The addition of the appropriate THO artifacts for these are in progress. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-tables",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-tables",
  "version" : "6.0.0",
  "name" : "V2Tables",
  "title" : "V2 Table List",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-02-24",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Master List of V2 Tables\r\n\r\nPlease note that V2 Code System and Value Set URIs are present, but the URIs do not resolve. The addition of the appropriate THO artifacts for these are in progress.",
  "copyright" : "Copyright HL7. Licensed under creative commons public domain",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "v2-table-oid",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-oid",
      "description" : "V2 Table OID",
      "type" : "string"
    },
    {
      "code" : "v2-cs-oid",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-cs-oid",
      "description" : "V2 Code System OID",
      "type" : "string"
    },
    {
      "code" : "v2-cs-uri",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-cs-uri",
      "description" : "V2 Code System URI",
      "type" : "string"
    },
    {
      "code" : "v2-vs-oid",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-vs-oid",
      "description" : "V2 Value Set OID",
      "type" : "string"
    },
    {
      "code" : "v2-vs-uri",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-vs-uri",
      "description" : "V2 Value Set URI",
      "type" : "string"
    },
    {
      "code" : "v2-table-type",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-type",
      "description" : "V2 Table Type",
      "type" : "code"
    },
    {
      "code" : "v2-cs-version",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-cs-version",
      "description" : "V2 Code System Version",
      "type" : "integer"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/hl7-work-group"
        }
      ],
      "code" : "steward",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#steward",
      "description" : "Steward WorkGroup",
      "type" : "code"
    },
    {
      "code" : "v2-where-used",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-where-used",
      "description" : "Field Where Used",
      "type" : "string"
    },
    {
      "code" : "v2-binding",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-binding",
      "description" : "V2 Binding Code",
      "type" : "string"
    },
    {
      "code" : "v2-version-tbl-introduced",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-version-tbl-introduced",
      "description" : "version-tbl-introduced",
      "type" : "string"
    },
    {
      "code" : "v2-version-csvs-introduced",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-version-csvs-introduced",
      "description" : "version-csvs-introduced",
      "type" : "string"
    },
    {
      "code" : "v2-cld",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-cld",
      "description" : "V2 VS CLD Type",
      "type" : "string"
    },
    {
      "code" : "vocab-domain",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#vocab-domain",
      "description" : "Concept Domain",
      "type" : "string"
    },
    {
      "code" : "v2-codes-table-comment",
      "uri" : "http://hl7.org/fhir/concept-properties#comment",
      "description" : "V2 Codes Table Comment.",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "0001",
      "display" : "Administrative Sex",
      "definition" : "Table of codes specifying a patient's sex.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.1"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.2"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0001"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.2"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0001"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdministrativeSex"
        }
      ]
    },
    {
      "code" : "0002",
      "display" : "Marital Status",
      "definition" : "Table of codes specifying a person's marital (civil/legal) status.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.2"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.179"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0002"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.3"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0002"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2MaritalStatus"
        }
      ]
    },
    {
      "code" : "0003",
      "display" : "Event Type",
      "definition" : "HL7-defined table of codes specifying the trigger event for Version 2.x interface messages.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.3"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.4"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0003"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.4"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0003"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-9.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventType"
        }
      ]
    },
    {
      "code" : "0004",
      "display" : "Patient Class",
      "definition" : "Table of codes used by systems to categorize patients by site in HL7 Version 2.x interfaces.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.4"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.5"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0004"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.5"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0004"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientClass"
        }
      ]
    },
    {
      "code" : "0005",
      "display" : "Race",
      "definition" : "Table of codes specifying the patient's race. These values are suggestions only, they are not required for use in HL7 messages.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.5"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.238"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "urn:oid:2.16.840.1.113883.6.238"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.114222.4.11.6065"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0005"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-10"
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "US Realm"
        },
        {
          "code" : "v2-binding",
          "valueString" : "4"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2Race"
        }
      ]
    },
    {
      "code" : "0006",
      "display" : "Religion",
      "definition" : "Table of codes specifying a person's religion.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.6"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0006"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.9"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0006"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Religion"
        }
      ]
    },
    {
      "code" : "0007",
      "display" : "Admission Type",
      "definition" : "Table of codes specifying the circumstances under which the patient was or will be admitted.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.7"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.9"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0007"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.10"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0007"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdmissionType"
        }
      ]
    },
    {
      "code" : "0008",
      "display" : "Acknowledgment code",
      "definition" : "HL7-defined table of codes specifying acknowledgment codes used in Version 2.x message.  For details of usage, see message processing rules in the published Standard.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.8"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.10"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0008"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.11"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0008"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSA-1.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AcknowledgmentCode"
        }
      ]
    },
    {
      "code" : "0009",
      "display" : "Ambulatory Status",
      "definition" : "Table of codes specifying permanent or transient handicapped conditions of a person.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.9"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.11"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0009"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.12"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0009"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AmbulatoryStatus"
        }
      ]
    },
    {
      "code" : "0010",
      "display" : "Physician ID",
      "definition" : "Table of codes specifying the attending physician information.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.10"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-7, SCD-34"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0010"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0010"
        }
      ]
    },
    {
      "code" : "0011",
      "display" : "CHARGING SYSTEM",
      "definition" : "Table of codes for charging system. Not used after HL7 2.1.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.11"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "no longer used"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "contains values, published erroneously"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ChargingSystem"
        }
      ]
    },
    {
      "code" : "0012",
      "display" : "STOCK LOCATION",
      "definition" : "Table of codes specifying the stock location.  Table is no longer published as part of the relased standard after version 2.2.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.12"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.12"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0012"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.13"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0012"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "no longer used"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "in appendix only"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StockLocation"
        }
      ]
    },
    {
      "code" : "0016",
      "display" : "ISOLATION",
      "definition" : "Table of codes that identify reasons for patient isolation. Not used after HL7 2.1.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.16"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "no longer used"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "contains values, published erroneously"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ISOLATION"
        }
      ]
    },
    {
      "code" : "0017",
      "display" : "Transaction Type",
      "definition" : "Table of codes specifying a type of financial transaction.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.17"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.13"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0017"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.14"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0017"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransactionType"
        }
      ]
    },
    {
      "code" : "0018",
      "display" : "Patient Type",
      "definition" : "Table of codes specifying the patient type.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.18"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0018"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0018"
        }
      ]
    },
    {
      "code" : "0019",
      "display" : "Anesthesia Code",
      "definition" : "Table of codes specifying the anesthesia used during the procedure.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.19"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AnesthesiaCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0019"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0019"
        }
      ]
    },
    {
      "code" : "0020",
      "display" : "UNUSED TABLE",
      "definition" : "Not used in HL7 Version 2.x messaging; publishing artifact.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.20"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "no longer used"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "Contains values, published erroneously"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "0021",
      "display" : "Bad Debt Agency Code",
      "definition" : "Table of codes specifying the bad debt agency to which the account was transferred.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.21"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BadDebtAgencyCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0021"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0021"
        }
      ]
    },
    {
      "code" : "0022",
      "display" : "Billing Status",
      "definition" : "Table of codes specifying whether the particular insurance has been billed and, if so, the type of bill.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.22"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-32"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BillingStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0022"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0022"
        }
      ]
    },
    {
      "code" : "0023",
      "display" : "Admit Source",
      "definition" : "Table of codes specifying where the patient was admitted.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.23"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdmitSource"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0023"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0023"
        }
      ]
    },
    {
      "code" : "0024",
      "display" : "Fee Schedule",
      "definition" : "Table of codes specifying the appropriate fee schedule to be used for this transaction posting.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.24"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FeeSchedule"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0024"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0024"
        }
      ]
    },
    {
      "code" : "0027",
      "display" : "Priority",
      "definition" : "HL7-defined table of codes specifying the allowed priorities for obtaining the specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.27"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.15"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0027"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.16"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0027"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM4-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Priority"
        }
      ]
    },
    {
      "code" : "0032",
      "display" : "Charge/Price Indicator",
      "definition" : "Table of codes specifying which price schedule is to be used for room and bed charges.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.32"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Charge_PriceIndicator"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0032"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0032"
        }
      ]
    },
    {
      "code" : "0033",
      "display" : "ROUTE",
      "definition" : "Table of codes that indicate a means of administrating a medication dose. As of HL7 version 2.3, it was replaced by tables 0162 Route of Administration and table 0165 Administration Method.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.33"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.16"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0033"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.17"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0033"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "replaced by 0165"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ROUTE"
        }
      ]
    },
    {
      "code" : "0034",
      "display" : "SITE ADMINISTERED",
      "definition" : "Table of codes specifying a location on the body where a dose is to be administered, e.g., IV, IM, Subcutaneous.   Used in HL7 Version 2.1 messaging only in the RX1 segment; as of version 2.2 it has been replaced with table 0163 Body Site.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.34"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.17"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0034"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.18"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0034"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "replaced by 0163"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SiteAdminstered"
        }
      ]
    },
    {
      "code" : "0038",
      "display" : "Order status",
      "definition" : "HL7-defined table of codes specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent.  Only the filler can originate these values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.38"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.18"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0038"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.21"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0038"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrderStatus"
        }
      ]
    },
    {
      "code" : "0042",
      "display" : "Company Plan Code",
      "definition" : "Table of codes specifying an insurance company plan uniquely.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.42"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-35"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CompanyPlanCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0042"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0042"
        }
      ]
    },
    {
      "code" : "0043",
      "display" : "Condition Code",
      "definition" : "Table of codes specifying the condition code.  These codes are defined by CMS or other regulartory agencies.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.43"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "UB2-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConditionCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0043"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0043"
        }
      ]
    },
    {
      "code" : "0044",
      "display" : "Contract Code",
      "definition" : "Table of codes specifying the type of contract entered into by the healthcare facility and the guarantor for the purpose of settling outstanding account balances.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.44"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContractCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0044"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0044"
        }
      ]
    },
    {
      "code" : "0045",
      "display" : "Courtesy Code",
      "definition" : "Table of codes specifying whether the patient will be extended certain special courtesies.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.45"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CourtesyCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0045"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0045"
        }
      ]
    },
    {
      "code" : "0046",
      "display" : "Credit Rating",
      "definition" : "Table of codes specifying past credit experience.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.46"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CreditRating"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0046"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0046"
        }
      ]
    },
    {
      "code" : "0047",
      "display" : "DANGER CODE",
      "definition" : "HL7-defined table of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code  (code system 2.16.840.1.133883.18.25).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.47"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "defined as table for all versions and assign to OBR-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DangerCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0047"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0047"
        }
      ]
    },
    {
      "code" : "0048",
      "display" : "What subject filter",
      "definition" : "HL7-defined table of concepts which specify the kind of information that is required to satisfy a query request.  The values define the type of transaction inquiry.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.48"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.20"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0048"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.23"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0048"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WhatSubjectFilter"
        }
      ]
    },
    {
      "code" : "0049",
      "display" : "Department Code",
      "definition" : "Table of codes specifying the department code that controls the transaction code.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.49"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DepartmentCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0049"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0049"
        }
      ]
    },
    {
      "code" : "0050",
      "display" : "Accident Code",
      "definition" : "Table of codes specifying the type of accident.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.50"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ACC-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AccidentCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0050"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0050"
        }
      ]
    },
    {
      "code" : "0051",
      "display" : "Diagnosis Code",
      "definition" : "Table of codes specifying the primary diagnosis code for billing purposes.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.51"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-19"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0051"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0051"
        }
      ]
    },
    {
      "code" : "0052",
      "display" : "Diagnosis Type",
      "definition" : "Table of codes that specify a type of diagnosis being sent.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.52"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.21"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0052"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.24"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0052"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisType"
        }
      ]
    },
    {
      "code" : "0053",
      "display" : "Diagnosis Coding Method",
      "definition" : "Table of codes specifying a diagnosis coding method.  No suggested values.  Table is no longer published as part of the released standard after version 2.5.1.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.53"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisCodingMethod"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0053"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0053"
        }
      ]
    },
    {
      "code" : "0055",
      "display" : "Diagnosis Related Group",
      "definition" : "Table of codes specifying the diagnostic related group (DRG) for the transaction.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.55"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DMI-1, DRG-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisRelatedGroup"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0055"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0055"
        }
      ]
    },
    {
      "code" : "0056",
      "display" : "DRG Grouper Review Code",
      "definition" : "Table of codes specifying that the grouper results have been reviewed and approved.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.56"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgGrouperReviewCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0056"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0056"
        }
      ]
    },
    {
      "code" : "0057",
      "display" : "DRUG CODE",
      "definition" : "HL7-defined table of concepts which specify a categorical assessment of an observation value (carried in HL7 V2.x field OBX.5), such as \"Normal\", \"Abnormal\", \"Positive\", \"Negative\", \"Resistant\", \"Susceptible\", etc.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.57"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "verify? In RX1-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Drug"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0057"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0057"
        }
      ]
    },
    {
      "code" : "0059",
      "display" : "Consent Code",
      "definition" : "Table of codes specifying the type of consent that was obtained for permission to treat the patient.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.59"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0059"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0059"
        }
      ]
    },
    {
      "code" : "0060",
      "display" : "ERROR CODE",
      "definition" : "Table of codes that identify an error.  Not used after HL7 2.2.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.60"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Error"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0060"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0060"
        }
      ]
    },
    {
      "code" : "0061",
      "display" : "Check Digit Scheme",
      "definition" : "HL7-defined table of codes specifying the check digit scheme employed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.61"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.22"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0061"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.25"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0061"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.3, PPN.12, XCN.12, XON.5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CheckDigitScheme"
        }
      ]
    },
    {
      "code" : "0062",
      "display" : "Event Reason",
      "definition" : "Table of codes which specify the reason for an event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.62"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.23"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0062"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.26"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0062"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EVN-4, FC.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventReason"
        }
      ]
    },
    {
      "code" : "0063",
      "display" : "Relationship",
      "definition" : "Table of codes specifying an actual personal relationship that the next of kin/associated party has to a patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.63"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.24"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0063"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.27"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0063"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-3, IN1-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Relationship"
        }
      ]
    },
    {
      "code" : "0064",
      "display" : "Financial Class",
      "definition" : "Table of codes specifying the financial class assigned to a person.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.64"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FC.1, PV1-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FinancialClass"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0064"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0064"
        }
      ]
    },
    {
      "code" : "0065",
      "display" : "Specimen Action Code",
      "definition" : "HL7-defined table of codes which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code ( table 0119).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.65"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.25"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0065"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.28"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0065"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenActionCode"
        }
      ]
    },
    {
      "code" : "0066",
      "display" : "Employment Status",
      "definition" : "Table of codes specifying the guarantor's employment status.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.66"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.26"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0066"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.29"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0066"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GT1-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EmploymentStatus"
        }
      ]
    },
    {
      "code" : "0068",
      "display" : "Guarantor Type",
      "definition" : "Table of codes specifying the type of guarantor, e.g., individual, institution, etc.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.68"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-33, GT1-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GuarantorType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0068"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0068"
        }
      ]
    },
    {
      "code" : "0069",
      "display" : "Hospital Service",
      "definition" : "Table of codes specifying the treatment or type of surgery the patient is scheduled to receive.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.69"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.27"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0069"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.30"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0069"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "HospitalService"
        }
      ]
    },
    {
      "code" : "0070",
      "display" : "Specimen Source Codes",
      "definition" : "HL7-defined table of concepts which specify sources for speciments for clinical testing.  These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table 0488 Specimen Collection Method as of version 2.5 and thereafter.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.70"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.28"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0070"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.31"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0070"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenSource"
        }
      ]
    },
    {
      "code" : "0072",
      "display" : "Insurance Plan ID",
      "definition" : "Table of codes specifying the identifier of an insurance plan with which a transaction should be associated.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.72"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "AUT-1, FT1-14, IN1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InsurancePlanId"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0072"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0072"
        }
      ]
    },
    {
      "code" : "0073",
      "display" : "Interest Rate Code",
      "definition" : "Table of codes specifying the amount of interest that will be charged the guarantor on any outstanding amounts.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.73"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InterestRateCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0073"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0073"
        }
      ]
    },
    {
      "code" : "0074",
      "display" : "Diagnostic Service Section ID",
      "definition" : "HL7-defined table of codes which specify a section of a diagnostic service where an observation may be performed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.74"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.29"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0074"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.32"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0074"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-24, OM4-49"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosticServiceSectionId"
        }
      ]
    },
    {
      "code" : "0075",
      "display" : "REPORT TYPES",
      "definition" : "Table of codes for report types. Not used after HL7 2.1.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.75"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0075"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0075"
        }
      ]
    },
    {
      "code" : "0076",
      "display" : "Message Type",
      "definition" : "HL7-defined table of codes which specify message types.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.76"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.30"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0076"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.33"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0076"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-9.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MessageType"
        }
      ]
    },
    {
      "code" : "0078",
      "display" : "Interpretation Codes",
      "definition" : "HL7-defined table of codes which specify a categorical assessment of an observation value.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.78"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.5.83"
        },
        {
          "code" : "v2cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.1.11.78"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v3-ObservationInterpretation"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InterpretationCodes"
        }
      ]
    },
    {
      "code" : "0079",
      "display" : "Location",
      "definition" : "Table of codes that identify a bed location.  Not used after HL7 v2.2  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.79"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Location"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0079"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0079"
        }
      ]
    },
    {
      "code" : "0080",
      "display" : "Nature of Abnormal Testing",
      "definition" : "HL7-defined table of codes specifying the nature of an abnormal test.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.80"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.32"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0080"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.36"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0080"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NatureOfAbnormalTesting"
        }
      ]
    },
    {
      "code" : "0081",
      "display" : "NOTICE OF ADMISSION",
      "definition" : "HL7-defined table of concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.81"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "reeplaced by 0136 later on"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NoticeOfAdmission"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0081"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0081"
        }
      ]
    },
    {
      "code" : "0083",
      "display" : "Outlier Type",
      "definition" : "Table of codes specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.83"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.33"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0083"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.37"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0083"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OutlierType"
        }
      ]
    },
    {
      "code" : "0084",
      "display" : "Performed by",
      "definition" : "Table of codes specifying a composite number/name of a person/group that performed a test/procedure/transaction, etc.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.84"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PerformedBy"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0084"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0084"
        }
      ]
    },
    {
      "code" : "0085",
      "display" : "Observation Result Status Codes Interpretation",
      "definition" : "HL7-defined table of codes which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.85"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.34"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0085"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.38"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0085"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ObservationResultStatusCodesInterpretation"
        }
      ]
    },
    {
      "code" : "0086",
      "display" : "Plan ID",
      "definition" : "Table of codes specifying the coding structure that identifies the various plan types (i.e., Medicare, Medicaid, Blue Cross, HMO, etc.).  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.86"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PlanId"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0086"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0086"
        }
      ]
    },
    {
      "code" : "0087",
      "display" : "Pre-Admit Test Indicator",
      "definition" : "Table of codes specifying whether the patient must have pre-admission testing done in order to be admitted.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.87"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Pre-admitTestIndicator"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0087"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0087"
        }
      ]
    },
    {
      "code" : "0088",
      "display" : "Procedure Code",
      "definition" : "Table of codes specifying a unique identifier assigned to a procedure, if any, associated with a charge.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.88"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-25, OBR-44, CDM-7, FT1-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0088"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0088"
        }
      ]
    },
    {
      "code" : "0089",
      "display" : "Procedure Coding Method",
      "definition" : "Table of codes that specify the methodology used to assign a code to a procedure (CPT4, for example).  Used for backwards-compatibility purposes.   No suggestted values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.89"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureCodingMethod"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0089"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0089"
        }
      ]
    },
    {
      "code" : "0090",
      "display" : "PROCEDURE TYPE",
      "definition" : "Table of codes that further define a type of procedure. Not used after HL7 2.2.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.90"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0090"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0090"
        }
      ]
    },
    {
      "code" : "0091",
      "display" : "Query Priority",
      "definition" : "HL7-defined table of codes which specify a time frame in which a querry response is expected.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.91"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.35"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0091"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.39"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0091"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCP.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2QueryPriority"
        }
      ]
    },
    {
      "code" : "0092",
      "display" : "Re-Admission Indicator",
      "definition" : "Table of codes which are used to specify that a patient is being re-admitted to a healthcare facility from which they were discharged, and indicates the circumstances around such re-admission.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.92"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.36"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0092"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.40"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0092"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Re-admissionIndicator"
        }
      ]
    },
    {
      "code" : "0093",
      "display" : "Release Information",
      "definition" : "Table of codes specifying whether the healthcare provider can release information about a patient and what information can be released.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.93"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReleaseInformation"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0093"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0093"
        }
      ]
    },
    {
      "code" : "0094",
      "display" : "REPORT OF ELIGIBILITY",
      "definition" : "Table of codes that indicate if the insurance sends a report indication that the patient is eligible for benefits and identifying what those benefits are.  Replaced by table 0136 after HL7 2.2.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.94"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportOfEligibility"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0094"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0094"
        }
      ]
    },
    {
      "code" : "0096",
      "display" : "FINANCIAL TRANSACTION CODE",
      "definition" : "HL7-defined table of concepts which, for an order, indicate the amount of information to be returned from the filler for the response to the order.  Sometimes the requested level of response may not be possible immediately, but when it is possible, the filler (receiving) application must send the information.  Used in HL7 Version 2.x messaging in the ORC segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.96"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "replaced by table 0132"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FinancialTransactionCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0096"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0096"
        }
      ]
    },
    {
      "code" : "0098",
      "display" : "Type of Agreement",
      "definition" : "Table of codes which specify codes to further identify an insurance plan.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.98"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.37"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0098"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.41"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0098"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TypeOfAgreement"
        }
      ]
    },
    {
      "code" : "0099",
      "display" : "VIP Indicator",
      "definition" : "Table of codes specifying a type of VIP.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.99"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VipIndicator"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0099"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0099"
        }
      ]
    },
    {
      "code" : "0100",
      "display" : "Invocation event",
      "definition" : "HL7-defined table of codes which specify codes for an event precipitating/triggering a charge activity.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.100"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.38"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0100"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.42"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0100"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CCD.1, BLG-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InvocationEvent"
        }
      ]
    },
    {
      "code" : "0101",
      "display" : "DISPLAY LEVEL",
      "definition" : "HL7-defined table of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.  Used in HL7 Version 2.x query messaging.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.101"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DisplayLevel"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0101"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0101"
        }
      ]
    },
    {
      "code" : "0102",
      "display" : "Delayed acknowledgment type",
      "definition" : "HL7-defined table of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.102"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.39"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0102"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.43"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0102"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DelayedAcknowledgmentType"
        }
      ]
    },
    {
      "code" : "0103",
      "display" : "Processing ID",
      "definition" : "HL7-defined table of codes which specify whether the message is part of a production, training or debugging system.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.103"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.40"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0103"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.44"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0103"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PT.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessingId"
        }
      ]
    },
    {
      "code" : "0104",
      "display" : "Version ID",
      "definition" : "HL7-defined table of codes which are used to identify an HL7 version in the Version 2.x family of published standards.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.104"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.41"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0104"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.45"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0104"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "VID.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VersionId"
        }
      ]
    },
    {
      "code" : "0105",
      "display" : "Source of Comment",
      "definition" : "HL7-defined table of codes which are used to specify the source of a comment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.105"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.42"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0105"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.46"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0105"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NTE-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SourceOfComment"
        }
      ]
    },
    {
      "code" : "0106",
      "display" : "Query/response format code",
      "definition" : "HL7-defined table of concepts which specify which of several types of formats for data to be returned in response to a query.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.106"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.43"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0106"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.47"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0106"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Query_ResponseFormatCode"
        }
      ]
    },
    {
      "code" : "0107",
      "display" : "Deferred response type",
      "definition" : "HL7-defined table of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.107"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.44"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0107"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.48"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0107"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeferredResponseType"
        }
      ]
    },
    {
      "code" : "0108",
      "display" : "Query results level",
      "definition" : "HL7-defined table of concepts which are used to control level of detail in query results.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.108"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.45"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0108"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.49"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0108"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QueryResultsLevel"
        }
      ]
    },
    {
      "code" : "0109",
      "display" : "Report priority",
      "definition" : "HL7-defined table of concepts which specify the priority associated with a report or update run using a query.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.109"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.46"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0109"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.50"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0109"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportPriority"
        }
      ]
    },
    {
      "code" : "0110",
      "display" : "Transfer to Bad Debt Code",
      "definition" : "Table of codes specifying that the account was transferred to bad debts and gives the reason.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.110"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransferToBadDebtCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0110"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0110"
        }
      ]
    },
    {
      "code" : "0111",
      "display" : "Delete Account Code",
      "definition" : "Table of codes specifying that the account was deleted from the file and gives the reason.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.111"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-34"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeleteAccountCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0111"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0111"
        }
      ]
    },
    {
      "code" : "0112",
      "display" : "Discharge Disposition",
      "definition" : "Table of codes which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.).  No suggested values.  In the US, this field should use the Official Uniform Billing (UB) 04 2008 numeric codes found on form locator 17.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.112"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.438"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-36"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DischargeDisposition"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0112"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0112"
        }
      ]
    },
    {
      "code" : "0113",
      "display" : "Discharged to Location",
      "definition" : "Table of codes specifying the healthcare facility to which the patient was discharged.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.113"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLD.1. PV1-37"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DischargedToLocation"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0113"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0113"
        }
      ]
    },
    {
      "code" : "0114",
      "display" : "Diet Type",
      "definition" : "Table of codes specifying a special diet type for a patient.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.114"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLD.1. PV1-38"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DietType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0114"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0114"
        }
      ]
    },
    {
      "code" : "0115",
      "display" : "Servicing Facilities",
      "definition" : "Table of codes specifying the healthcare facility with which this visit is associated in a multiple facility environment.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.115"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLD.1. PV1-39"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ServicingFacilities"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0115"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0115"
        }
      ]
    },
    {
      "code" : "0116",
      "display" : "Bed Status",
      "definition" : "Table of codes which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.116"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.47"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0116"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.51"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0116"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLD.1. PV1-40"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BedStatus"
        }
      ]
    },
    {
      "code" : "0117",
      "display" : "Account Status",
      "definition" : "Table of codes specifying the account status.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.117"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NPU-2, PV1-41"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AccountStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0117"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0117"
        }
      ]
    },
    {
      "code" : "0118",
      "display" : "Major Diagnostic Category",
      "definition" : "Table of codes specifying the major diagnostic category.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.118"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DMI-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MajorDiagnosticCategory"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0118"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0118"
        }
      ]
    },
    {
      "code" : "0119",
      "display" : "Order Control Codes",
      "definition" : "HL7-defined table of codes which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.119"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.48"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0119"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.52"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0119"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrderControlCodes"
        }
      ]
    },
    {
      "code" : "0121",
      "display" : "Response Flag",
      "definition" : "HL7-defined table of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.121"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.49"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0121"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.53"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0121"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ResponseFlag"
        }
      ]
    },
    {
      "code" : "0122",
      "display" : "Charge Type",
      "definition" : "HL7-defined table of codes which specify someone or something other than the patient to be billed for a service.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.122"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.50"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0122"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.54"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0122"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BLG-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ChargeType"
        }
      ]
    },
    {
      "code" : "0123",
      "display" : "Result Status",
      "definition" : "HL7-defined table of codes which specify a status of results for an order.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.123"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.51"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0123"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.55"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0123"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ResultStatus"
        }
      ]
    },
    {
      "code" : "0124",
      "display" : "Transportation Mode",
      "definition" : "HL7-defined table of codes which specify how (or whether) to transport a patient, when applicable, for an ordered service.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.124"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.52"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0124"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.56"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0124"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-30"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransportationMode"
        }
      ]
    },
    {
      "code" : "0125",
      "display" : "Value Type",
      "definition" : "HL7-defined table of codes specifying the format of the observation value in the Observation Result (OBX).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.125"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.280"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0440"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.57"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0125"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-2, OM1-3, OM3-7 and OMC-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ValueType"
        }
      ]
    },
    {
      "code" : "0126",
      "display" : "Quantity Limited Request",
      "definition" : "HL7-defined table of codes which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.126"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.53"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0126"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.64"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0126"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCP.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QuantityLimitedRequest"
        }
      ]
    },
    {
      "code" : "0127",
      "display" : "Allergen Type",
      "definition" : "Table of codes speciying a classification of general allergy categories (drug, food, pollen, etc.).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.127"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.54"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0127"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.65"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0127"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "AL1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AllergenType"
        }
      ]
    },
    {
      "code" : "0128",
      "display" : "Allergy Severity",
      "definition" : "Table of codes which specify the general severity of an allergy.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.128"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.55"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0128"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.66"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0128"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "AL1-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AllergySeverity"
        }
      ]
    },
    {
      "code" : "0129",
      "display" : "Accommodation Code",
      "definition" : "Table of codes specifying the fiancial accommodation type of the bed or room which implies the rate to be used when occupied by a patient under specific medical conditions, which determines how it is billed.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.129"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-2, LCC-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AccommodationCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0129"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0129"
        }
      ]
    },
    {
      "code" : "0130",
      "display" : "Visit User Code",
      "definition" : "Table of codes which specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.130"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.56"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0130"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.67"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0130"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VisitUserCode"
        }
      ]
    },
    {
      "code" : "0131",
      "display" : "Contact Role",
      "definition" : "Table of codes which specify a relationship role that the next of kin/associated parties plays with regard to a patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that issued a referral.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.131"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.58"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0131"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.69"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0131"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-7, CTD-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContactRole"
        }
      ]
    },
    {
      "code" : "0132",
      "display" : "Transaction Code",
      "definition" : "Table of coded codes that are used by an institution for the purpose of uniquely identifying a transaction based on the Transaction Type.  For example, procedure, supply item, or test for charges; or to identify the payment medium for payments.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.132"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-7, ITM-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransactionCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0132"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0132"
        }
      ]
    },
    {
      "code" : "0133",
      "display" : "Procedure Practitioner Identifier Code Type",
      "definition" : "HL7-defined table of concepts which specify the different types of practitioners associated with this procedure.   This set of codes is known to be incomplete.  Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.133"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.59"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0133"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.70"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0133"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "0135",
      "display" : "Assignment of Benefits",
      "definition" : "Table of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider.  If so, the insurance will pay the provider directly.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.135"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.60"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0135"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.71"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0135"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AssignmentOfBenefits"
        }
      ]
    },
    {
      "code" : "0136",
      "display" : "Yes/no Indicator",
      "definition" : "HL7-defined table of codes specifying either Yes or No used in fields containing binary answers generally user-specified. The actual interpretation of Yes/No is context sensitive. Individual chapters will further refine the meaning of Yes/No in their specific context.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.136"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.347"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0532"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.72"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0136"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "numerous"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Yes/noIndicator"
        }
      ]
    },
    {
      "code" : "0137",
      "display" : "Mail Claim Party",
      "definition" : "Table of codes which specify a party to which a claim should be mailed when claims are sent by mail.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.137"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.61"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0137"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.73"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0137"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MailClaimParty"
        }
      ]
    },
    {
      "code" : "0139",
      "display" : "Employer Information Data",
      "definition" : "Table of codes specifying the required employer information data for UB82 form locator 71.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.139"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-50, IN2-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EmployerInformationData"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0139"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0139"
        }
      ]
    },
    {
      "code" : "0140",
      "display" : "Military Service",
      "definition" : "Table of codes which specify the military branch.  This field is defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.140"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.62"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0140"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.74"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0140"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PD1-19"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MilitaryService"
        }
      ]
    },
    {
      "code" : "0141",
      "display" : "Military Rank/Grade",
      "definition" : "Table of codes which specify the military rank/grade of the patient.\r\nAustralia: https://en.wikipedia.org/wiki/Australian_Defence_Force_ranks\r\nCanada: http://www.forces.gc.ca/en/honours-history-badges-insignia/rank.page\r\nUnited States: published in the Defense Travel Administrator's Manual, Appendix M: Military Rank/Civilian Pay Grade Abbreviations and Service Agency Names, http://www.defensetravel.dod.mil/Docs/Training/DTA_App_M.pdf",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.141"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PD1-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MilitaryRank/grade"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0141"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0141"
        }
      ]
    },
    {
      "code" : "0142",
      "display" : "Military Status",
      "definition" : "Table of codes which specify the military status of the patient.  This field is defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.142"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.64"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0142"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.76"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0142"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PD1-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MilitaryStatus"
        }
      ]
    },
    {
      "code" : "0143",
      "display" : "Non-covered Insurance Code",
      "definition" : "Table of codes specifying the reason a service is not covered.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.143"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Non-coveredInsuranceCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0143"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0143"
        }
      ]
    },
    {
      "code" : "0144",
      "display" : "Eligibility Source",
      "definition" : "Table of codes which specify the source of information about the insured's eligibility for benefits.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.144"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.65"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0144"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.77"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0144"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EligibilitySource"
        }
      ]
    },
    {
      "code" : "0145",
      "display" : "Room Type",
      "definition" : "Table of codes which specify the room type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.145"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.66"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0145"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.78"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0145"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RMC.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RoomType"
        }
      ]
    },
    {
      "code" : "0146",
      "display" : "Amount Type",
      "definition" : "Table of codes which specify amount quantity type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.146"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.67"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0146"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.79"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0146"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RMC.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AmountType"
        }
      ]
    },
    {
      "code" : "0147",
      "display" : "Policy Type",
      "definition" : "Table of codes which specify the policy type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.147"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.68"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0147"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.80"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0147"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PTA.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PolicyType"
        }
      ]
    },
    {
      "code" : "0148",
      "display" : "Money or Percentage Indicator",
      "definition" : "HL7-defined table of codes which specify whether the amount is currency or a percentage.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.148"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.69"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0148"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.81"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0148"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MOP.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MoneyOrPercentageIndicator"
        }
      ]
    },
    {
      "code" : "0149",
      "display" : "Day Type",
      "definition" : "Table of codes which specify whether the days are denied, pending or approved.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.149"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.70"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0149"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.82"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0149"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DTN.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DayType"
        }
      ]
    },
    {
      "code" : "0150",
      "display" : "Certification Patient Type",
      "definition" : "Table of codes which specify the category or type of patient for which this certification is requested.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.150"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.71"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0150"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.83"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0150"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ICD.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificationPatientType"
        }
      ]
    },
    {
      "code" : "0151",
      "display" : "Second Opinion Status",
      "definition" : "Table of codes specifying the status of the second opinion.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.151"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SecondOpinionStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0151"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0151"
        }
      ]
    },
    {
      "code" : "0152",
      "display" : "Second Opinion Documentation Received",
      "definition" : "Table of codes specifying if accompanying documentation has been received by the provider.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.152"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SecondOpinionDocumentationReceived"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0152"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0152"
        }
      ]
    },
    {
      "code" : "0153",
      "display" : "Value Code",
      "definition" : "In the US, NUBC codes are generally used, see code system 2.16.840.1.113883.6.301.6; more information may be found at http://www.nubc.org/become.html",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.153"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.301.6"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "https://terminology.hl7.org/CodeSystem-AHANUBCValueCodesAndAmounts.html"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "UVC.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ValueCode"
        }
      ]
    },
    {
      "code" : "0155",
      "display" : "Accept/Application Acknowledgment Conditions",
      "definition" : "HL7-defined table of codes which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.155"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.73"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0155"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.85"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0155"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-15, MSH-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AcknowledgmentConditions"
        }
      ]
    },
    {
      "code" : "0156",
      "display" : "Which date/time qualifier",
      "definition" : "HL7-defined table of codes that specify the type of date referred to in the other date fields in the QRF segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.156"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.74"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0156"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.86"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0156"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WhichDate_TimeQualifier"
        }
      ]
    },
    {
      "code" : "0157",
      "display" : "Which date/time status qualifier",
      "definition" : "HL7-defined table of codes that specify the status type of objects selected in date range defined by QRF-2 and QRF-3.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.157"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.75"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0157"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.87"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0157"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WhichDate_TimeStatusQualifier"
        }
      ]
    },
    {
      "code" : "0158",
      "display" : "Date/time selection qualifier",
      "definition" : "HL7-defined table of codes that allow the specification of certain types of values within the date/time range.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.158"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.76"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0158"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.88"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0158"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Date_TimeSelectionQualifier"
        }
      ]
    },
    {
      "code" : "0159",
      "display" : "Diet Code Specification Type",
      "definition" : "HL7-defined table of codes which specify the type of diet.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.159"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.77"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0159"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.89"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0159"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ODS-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DietCodeSpecificationType"
        }
      ]
    },
    {
      "code" : "0160",
      "display" : "Tray Type",
      "definition" : "HL7-defined table of codes which specify the type of dietary tray.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.160"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.78"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0160"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.90"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0160"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ODT-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TrayType"
        }
      ]
    },
    {
      "code" : "0161",
      "display" : "Allow Substitution",
      "definition" : "HL7-defined table of codes which specify whether substitutions are allowed and, if so, the type of substitutions allowed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.161"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.79"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0161"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.91"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0161"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXO-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AllowSubstitution"
        }
      ]
    },
    {
      "code" : "0162",
      "display" : "Route of Administration",
      "definition" : "Table of codes which specify the route of administration.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.162"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.80"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0162"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.92"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0162"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXR-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2RouteOfAdministration"
        }
      ]
    },
    {
      "code" : "0163",
      "display" : "Body Site",
      "definition" : "HL7-defined table of codes that specify a body site from which a specimen is obtained.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.163"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.81"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0163"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.93"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0163"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-20, CH7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BodySite"
        }
      ]
    },
    {
      "code" : "0164",
      "display" : "Administration Device",
      "definition" : "Table of codes which specify the mechanical device used to aid in the administration of the drug or other treatment.  Common examples are IV-sets of different types.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.164"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.82"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0164"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.94"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0164"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXR-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdministrationDevice"
        }
      ]
    },
    {
      "code" : "0165",
      "display" : "Administration Method",
      "definition" : "Table of codes which specify the specific method requested for the administration of the drug or treatment to the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.165"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.83"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0165"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.95"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0165"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXR-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdministrationMethod"
        }
      ]
    },
    {
      "code" : "0166",
      "display" : "RX Component Type",
      "definition" : "HL7-defined table of codes which specify the RX component type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.166"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.84"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0166"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.96"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0166"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXC-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RxComponentType"
        }
      ]
    },
    {
      "code" : "0167",
      "display" : "Substitution Status",
      "definition" : "HL7-defined table of codes which specify the substitution status.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.167"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.85"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0167"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.97"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0167"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXE-9, RXD-11, RXG-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubstitutionStatus"
        }
      ]
    },
    {
      "code" : "0168",
      "display" : "Processing Priority",
      "definition" : "HL7-defined table of codes which specify one or more available priorities for performing the observation or test.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.168"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.86"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0168"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.98"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0168"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessingPriority"
        }
      ]
    },
    {
      "code" : "0169",
      "display" : "Reporting Priority",
      "definition" : "HL7-defined table of codes which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.169"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.87"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0169"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.99"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0169"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportingPriority"
        }
      ]
    },
    {
      "code" : "0170",
      "display" : "Derived Specimen",
      "definition" : "HL7-defined table of codes which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture).  The process also produces new \"specimens\" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.170"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.88"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0170"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.100"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0170"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM4-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DerivedSpecimen"
        }
      ]
    },
    {
      "code" : "0171",
      "display" : "Citizenship",
      "definition" : "Table of codes specifying the information related to a person's country citizenship.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.171"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-26, PID-39"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Citizenship"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0171"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0171"
        }
      ]
    },
    {
      "code" : "0172",
      "display" : "Veterans Military Status",
      "definition" : "Table of codes specifying the military status assigned to a veteran.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.172"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VeteransMilitaryStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0172"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0172"
        }
      ]
    },
    {
      "code" : "0173",
      "display" : "Coordination of Benefits",
      "definition" : "Table of codes specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.173"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.89"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0173"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.101"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0173"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CoordinationOfBenefits"
        }
      ]
    },
    {
      "code" : "0174",
      "display" : "Nature of Service/Test/Observation",
      "definition" : "Table of codes specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.174"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.90"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0174"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.102"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0174"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NatureOfService_Test_Observation"
        }
      ]
    },
    {
      "code" : "0175",
      "display" : "Master File Identifier Code",
      "definition" : "HL7-defined table of codes which are represented by codes identifying HL7 Versions 2.x Master Files.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.175"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.91"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0175"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.103"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0175"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFI-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MasterFileIdentifierCode"
        }
      ]
    },
    {
      "code" : "0176",
      "display" : "Master File Application Identifier",
      "definition" : "Table of codes that uniquely identify an application responsible for maintaining a master file of a particular type at a particular site. Not used after HL7 v2.2  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.176"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MasterFileApplicationIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0176"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0176"
        }
      ]
    },
    {
      "code" : "0177",
      "display" : "Confidentiality Code",
      "definition" : "Table of codes specifying the degree to which special confidentiality protection should be applied to the observation.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.177"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.92"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0177"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.104"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0177"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-30, ORC-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConfidentialityCode"
        }
      ]
    },
    {
      "code" : "0178",
      "display" : "File Level Event Code",
      "definition" : "HL7-defined table of codes specifying file-level events for master files.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.178"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.93"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0178"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.105"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0178"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFI-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FileLevelEventCode"
        }
      ]
    },
    {
      "code" : "0179",
      "display" : "Response Level",
      "definition" : "HL7-defined table of codes specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.179"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.94"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0179"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.106"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0179"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFI-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ResponseLevel"
        }
      ]
    },
    {
      "code" : "0180",
      "display" : "Record-level Event Code",
      "definition" : "HL7-defined table of codes specifying an action for a master file record.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.180"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.95"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0180"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.107"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0180"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFE-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MasterfileActionCode"
        }
      ]
    },
    {
      "code" : "0181",
      "display" : "MFN Record-level Error Return",
      "definition" : "Table of codes specifying the status of the requested update.  Site-defined table, specific to each master file being updated via this transaction.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.181"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.96"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0181"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.108"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0181"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFA-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MfnRecord-levelErrorReturn"
        }
      ]
    },
    {
      "code" : "0182",
      "display" : "Staff type",
      "definition" : "Table of codes specifying the staff person's sex.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.182"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StaffType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0182"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0182"
        }
      ]
    },
    {
      "code" : "0183",
      "display" : "Active/Inactive",
      "definition" : "HL7-defined table of codes specifying whether a person is currently a valid staff member.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.183"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.97"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0183"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.109"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0183"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Active/Inactive"
        }
      ]
    },
    {
      "code" : "0184",
      "display" : "Department",
      "definition" : "Table of codes specifying the institution department to which this person reports or belongs.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.184"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Department"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0184"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0184"
        }
      ]
    },
    {
      "code" : "0185",
      "display" : "Preferred Method of Contact",
      "definition" : "HL7-defined table of codes specifying which of a group of multiple phone numbers is the preferred method of contact for this person.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.185"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.98"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0185"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.110"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0185"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-16, PRD-6, PRD-14, CTD-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PreferredMethodOfContact"
        }
      ]
    },
    {
      "code" : "0186",
      "display" : "Practitioner Category",
      "definition" : "Table of codes specifying the category of practitioner.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.186"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRA-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PractitionerCategory"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0186"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0186"
        }
      ]
    },
    {
      "code" : "0187",
      "display" : "Provider Billing",
      "definition" : "HL7-defined table of codes specifying how provider services are billed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.187"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.99"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0187"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.111"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0187"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRA-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProviderBilling"
        }
      ]
    },
    {
      "code" : "0188",
      "display" : "Operator ID",
      "definition" : "Table of codes specifying the individual responsible for triggering the event.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.188"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EVN-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0188"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0188"
        }
      ]
    },
    {
      "code" : "0189",
      "display" : "Ethnic Group",
      "definition" : "Table of codes further defining a patient's ancestry.  In the US, a current use is to use these codes to report ethnicity in line with US federal standards for Hispanic origin.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.189"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.100"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0189"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.112"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0189"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EthnicGroup"
        }
      ]
    },
    {
      "code" : "0190",
      "display" : "Address Type",
      "definition" : "HL7-defined table of codes specifying types or kinds of addresses.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.190"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.101"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0190"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.113"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0190"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.8, AD.7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AddressType"
        }
      ]
    },
    {
      "code" : "0191",
      "display" : "Type of Referenced Data",
      "definition" : "HL7-defined table of codes declaring the general type of media data that is encoded.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.191"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.102"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0191"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.114"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0191"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TypeOfReferencedData"
        }
      ]
    },
    {
      "code" : "0192",
      "display" : "Visit ID Type",
      "definition" : "HL7-defined table of concepts defining whether patient transportation preparations are in place.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.192"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "does not exist?"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VisitIDType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0192"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0192"
        }
      ]
    },
    {
      "code" : "0193",
      "display" : "Amount Class",
      "definition" : "Table of codes specifying the amount quantity class.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.193"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.103"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0193"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.115"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0193"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PTA.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AmountClass"
        }
      ]
    },
    {
      "code" : "0200",
      "display" : "Name Type",
      "definition" : "HL7-defined table of codes for types of names for persons.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.200"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.105"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0200"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.117"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0200"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XPN.8, PPN.10, XCN.10, PID-5, MRG-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NameType"
        }
      ]
    },
    {
      "code" : "0201",
      "display" : "Telecommunication Use Code",
      "definition" : "HL7-defined table of codes for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.201"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.106"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0201"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.118"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0201"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XTN.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TelecommunicationUseCode"
        }
      ]
    },
    {
      "code" : "0202",
      "display" : "Telecommunication Equipment Type",
      "definition" : "HL7-defined table of codes  for specifying a type of telecommunication equipment.  Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.202"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.107"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0202"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.119"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0202"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XTN.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TelecommunicationEquipmentType"
        }
      ]
    },
    {
      "code" : "0203",
      "display" : "Identifier Type",
      "definition" : "HL7-defined table of codes specifying the type of identififier.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.203"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.108"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0203"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.120"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0203"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.5, PPN.13, XCN.13, XON.7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IdentifierType"
        }
      ]
    },
    {
      "code" : "0204",
      "display" : "Organizational Name Type",
      "definition" : "Table of codes used to specify the type of name for an organization i.e., legal name, display name.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.204"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.109"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0204"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.121"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0204"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XON.2, PD1-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrganizationalNameType"
        }
      ]
    },
    {
      "code" : "0205",
      "display" : "Price Type",
      "definition" : "HL7-defined table of codes used to identify the intent for the dollar amount on a pricing transaction.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.205"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.110"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0205"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.122"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0205"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CP.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PriceType"
        }
      ]
    },
    {
      "code" : "0206",
      "display" : "Segment Action Code",
      "definition" : "HL7-defined table of codes specifying actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.206"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.111"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0206"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.123"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0206"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CH2, RXA-21, RXV-22, LCH-2, IAM-6, ARV-2, IN1-55, OH1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SegmentActionCode"
        }
      ]
    },
    {
      "code" : "0207",
      "display" : "Processing Mode",
      "definition" : "HL7-defined table of codes that indicate an archival process or an initial load process.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.207"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.112"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0207"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.124"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0207"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PT.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ProcessingMode"
        }
      ]
    },
    {
      "code" : "0208",
      "display" : "Query Response Status",
      "definition" : "HL7-defined table of codes defining precise response status concepts in support of HL7 Version 2 query messaging.  It is commonly used to indicate no data is found that matches the query parameters, but no error.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.208"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.113"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0208"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.125"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0208"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QAK.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QueryResponseStatus"
        }
      ]
    },
    {
      "code" : "0209",
      "display" : "Relational Operator",
      "definition" : "HL7-defined table of codes used to define the relationship between HL7 segment field names identified in a query construct.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.209"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.114"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0209"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.126"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0209"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QSC.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2RelationalOperator"
        }
      ]
    },
    {
      "code" : "0210",
      "display" : "Relational Conjunction",
      "definition" : "HL7-defined table of codes used with relational operator values to group more than one segment field name.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.210"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.115"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0210"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.127"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0210"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QSC.4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RelationalConjunction"
        }
      ]
    },
    {
      "code" : "0211",
      "display" : "Alternate Character Sets",
      "definition" : "Table of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.211"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.116"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0211"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.128"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0211"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AlternateCharacterSets"
        }
      ]
    },
    {
      "code" : "0212",
      "display" : "Nationality",
      "definition" : "Table of codes that identify the nation or national grouping to which the person belongs.  This information may be different from a person’s citizenship in countries in which multiple nationalities are recognized (for example, Spain: Basque, Catalan, etc.).  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.212"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-27, GT1-43. IN1-41,"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Nationality"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0212"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0212"
        }
      ]
    },
    {
      "code" : "0213",
      "display" : "Purge Status Code",
      "definition" : "Table of codes used to define the state of a visit relative to its place in a purge workflow.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.213"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.117"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0213"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.129"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0213"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PurgeStatusCode"
        }
      ]
    },
    {
      "code" : "0214",
      "display" : "Special Program Code",
      "definition" : "Table of codes used to record a health insurance program required for healthcare visit reimbursement.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.214"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.118"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0214"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.130"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0214"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecialProgramCode"
        }
      ]
    },
    {
      "code" : "0215",
      "display" : "Publicity Code",
      "definition" : "Table of codes specifying a level of publicity of information about a patient for a specific visit.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.215"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.119"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0215"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.131"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0215"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-21, PD1-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PublicityCode"
        }
      ]
    },
    {
      "code" : "0216",
      "display" : "Patient Status Code",
      "definition" : "Table of codes used to define the state of a care episode for a patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.216"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.120"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0216"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.132"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0216"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientStatusCode"
        }
      ]
    },
    {
      "code" : "0217",
      "display" : "Visit Priority Code",
      "definition" : "Table of codes used to define a relative level of urgency applied to a patient visit.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.217"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.121"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0217"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.133"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0217"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VisitPriorityCode"
        }
      ]
    },
    {
      "code" : "0218",
      "display" : "Patient Charge Adjustment",
      "definition" : "Table of codes used to indicate which adjustments should be made to a guarantor’s charges.  For example, when a hospital agrees to adjust a guarantor’s charges to a sliding scale.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.218"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GT1-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientChargeAdjustment"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0218"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0218"
        }
      ]
    },
    {
      "code" : "0219",
      "display" : "Recurring Service Code",
      "definition" : "Table of codes used to indicate whether a treatment is continuous.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.219"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RecurringServiceCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0219"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0219"
        }
      ]
    },
    {
      "code" : "0220",
      "display" : "Living Arrangement",
      "definition" : "Table of codes characterizing the situation that patient-associated parties live in at their residential address.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.220"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.122"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0220"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.134"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0220"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-21, PD1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2LivingArrangement"
        }
      ]
    },
    {
      "code" : "0222",
      "display" : "Contact Reason",
      "definition" : "Table of codes used to indicate a reason for contacting a guarantor, for example, to phone a guarantor if payments are late.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.222"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GT1-47, NK1-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContactReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0222"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0222"
        }
      ]
    },
    {
      "code" : "0223",
      "display" : "Living Dependency",
      "definition" : "Table of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.223"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.124"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0223"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.136"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0223"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-17, PD1-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LivingDependency"
        }
      ]
    },
    {
      "code" : "0224",
      "display" : "Transport Arranged",
      "definition" : "HL7-defined table of codes defining whether patient transportation preparations are in place.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.224"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.125"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0224"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.137"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0224"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-41"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransportArranged"
        }
      ]
    },
    {
      "code" : "0225",
      "display" : "Escort Required",
      "definition" : "HL7-defined table of codes indicating whether a patient must be accompanied while travelling to a diagnostic service department.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.225"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.126"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0225"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.138"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0225"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-42"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EscortRequired"
        }
      ]
    },
    {
      "code" : "0227",
      "display" : "Manufacturers of Vaccines (code=MVX)",
      "definition" : "Table of codes specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP.  The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.227"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.12.227"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://hl7.org/fhir/sid/mvx"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.114222.4.11.826"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0227"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Imported"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXA-17, RXD-20, RXG-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ManufacturersOfVaccines"
        }
      ]
    },
    {
      "code" : "0228",
      "display" : "Diagnosis Classification",
      "definition" : "Table of codes used to classify whether a patient visit can be related to a diagnosis.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.228"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.128"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0228"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.140"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0228"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisClassification"
        }
      ]
    },
    {
      "code" : "0229",
      "display" : "DRG Payor",
      "definition" : "Table of codes used to identify a Diagnostic Resource Group Payor.  US Realm.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.229"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgPayor"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0229"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0229"
        }
      ]
    },
    {
      "code" : "0230",
      "display" : "Procedure Functional Type",
      "definition" : "Table of codes used to classify a procedure.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.230"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.130"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0230"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.142"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0230"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureFunctionalType"
        }
      ]
    },
    {
      "code" : "0231",
      "display" : "Student Status",
      "definition" : "Table of codes used to designate whether a guarantor is a full or part time student.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.231"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.131"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0231"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.143"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0231"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GT1-40, NK1-24, PD1-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StudentStatus"
        }
      ]
    },
    {
      "code" : "0232",
      "display" : "- Insurance Company Contact Reason",
      "definition" : "Table of codes used to describe why an insurance company has been contacted.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.232"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.132"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0232"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.144"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0232"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-57"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InsuranceCompanyContactReason"
        }
      ]
    },
    {
      "code" : "0233",
      "display" : "Non-Concur Code/Description",
      "definition" : "Table of codes that specify a non-concur code and description for a denied request, used in insurance claims processing.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.233"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Non-concurCode_Description"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0233"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0233"
        }
      ]
    },
    {
      "code" : "0234",
      "display" : "Report Timing",
      "definition" : "HL7-defined table of codes used to identify the time span of a report or the reason for a report sent to a regulatory agency.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.234"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.133"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0234"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.145"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0234"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PES-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportTiming"
        }
      ]
    },
    {
      "code" : "0235",
      "display" : "Report Source",
      "definition" : "HL7-defined table of codes used to identify where a report sender learned about an event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.235"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.134"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0235"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.146"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0235"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PES-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReportSource"
        }
      ]
    },
    {
      "code" : "0236",
      "display" : "Event Reported To",
      "definition" : "HL7-defined table of codes used to identify the type of entity to which the event has been reported.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.236"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.135"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0236"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.147"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0236"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PES-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventReportedTo"
        }
      ]
    },
    {
      "code" : "0237",
      "display" : "Event Qualification",
      "definition" : "HL7-defined table of codes used to qualify an event related to a product experience.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.237"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.136"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0237"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.148"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0237"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventQualification"
        }
      ]
    },
    {
      "code" : "0238",
      "display" : "Event Seriousness",
      "definition" : "HL7-defined table of codes used by a sender to designate an event as serious or significant.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.238"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.137"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0238"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.149"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0238"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventSeriousness"
        }
      ]
    },
    {
      "code" : "0239",
      "display" : "Event Expected",
      "definition" : "HL7-defined table of codes used to communicate whether an event has been judged to be expected or unexpected.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.239"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.138"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0239"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.150"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0239"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventExpected"
        }
      ]
    },
    {
      "code" : "0240",
      "display" : "Event Consequence",
      "definition" : "HL7-defined table of codes used to describe the impact of an event on a patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.240"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.139"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0240"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.151"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0240"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventConsequence"
        }
      ]
    },
    {
      "code" : "0241",
      "display" : "Patient Outcome",
      "definition" : "HL7-defined table of codes used to describe the overall state of a patient as a result of patient care.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.241"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.140"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0241"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.152"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0241"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientOutcome"
        }
      ]
    },
    {
      "code" : "0242",
      "display" : "Primary Observer's Qualification",
      "definition" : "HL7-defined table of codes used to provide a general description of the kind of health care professional who provided the primary observation.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.242"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.141"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0242"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.153"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0242"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-22, PEO-23, PCR-19"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrimaryObserversQualification"
        }
      ]
    },
    {
      "code" : "0243",
      "display" : "Identity May Be Divulged",
      "definition" : "HL7-defined table of codes used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.243"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.142"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0243"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.154"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0243"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PEO-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IdentityMayBeDivulged"
        }
      ]
    },
    {
      "code" : "0244",
      "display" : "Single Use Device",
      "definition" : "Table of codes that indicate whether a product is designed for a single use.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.244"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SingleUseDevice"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0244"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0244"
        }
      ]
    },
    {
      "code" : "0245",
      "display" : "Product Problem",
      "definition" : "Table of codes used to indicate if a product problem would exist if a product malfunction could lead to death or serious injury.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.245"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProductProblem"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0245"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0245"
        }
      ]
    },
    {
      "code" : "0246",
      "display" : "Product Available for Inspection",
      "definition" : "Table of codes used to indicate that the product is available for analysis. No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.246"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProductAvailableForInspection"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0246"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0246"
        }
      ]
    },
    {
      "code" : "0247",
      "display" : "Status of Evaluation",
      "definition" : "HL7-defined table of codes that describes the status of product evaluation.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.247"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.143"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0247"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.155"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0247"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StatusOfEvaluation"
        }
      ]
    },
    {
      "code" : "0248",
      "display" : "Product Source",
      "definition" : "HL7-defined table of codes used to describe the evaluation state of a product identified in an incident.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.248"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.144"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0248"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.156"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0248"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProductSource"
        }
      ]
    },
    {
      "code" : "0249",
      "display" : "Generic Product",
      "definition" : "Table of codes used to indicate whether the product used is a generic or a branded product. No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.249"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GenericProduct"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0249"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0249"
        }
      ]
    },
    {
      "code" : "0250",
      "display" : "Relatedness Assessment",
      "definition" : "HL7-defined table of codes used to provide an estimate of whether an issue with a  product was the cause of an event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.250"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.145"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0250"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.157"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0250"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RelatednessAssessment"
        }
      ]
    },
    {
      "code" : "0251",
      "display" : "Action Taken in Response to the Event",
      "definition" : "HL7-defined table of codes used to define the action taken as a result of an event related to a product issue.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.251"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.146"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0251"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.158"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0251"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ActionTakenInResponseToTheEvent"
        }
      ]
    },
    {
      "code" : "0252",
      "display" : "Causality Observations",
      "definition" : "HL7-defined table of codes used to record event observations regarding what may have caused a product related event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.252"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.147"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0252"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.159"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0252"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CausalityObservations"
        }
      ]
    },
    {
      "code" : "0253",
      "display" : "Indirect Exposure Mechanism",
      "definition" : "HL7-defined table of codes used to identify the mechanism of product transmission when the product has not been directly applied to the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.253"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.148"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0253"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.160"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0253"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PCR-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IndirectExposureMechanism"
        }
      ]
    },
    {
      "code" : "0254",
      "display" : "Kind of Quantity",
      "definition" : "HL7-defined table of codes that describe the underlying kind of property represented by an observation.  The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth.  These are discussed more fully in the LOINC Users' Manual.   They are derived from the approach described in 1995 edition of the IUPAC Silver Book.  These distinctions are used in IUPAC and LOINC standard codes.  The distinctions of true quantities in this table are based primarily on dimensional analyses. The table contains a number of \"families,\" those related to simple counts (number, number concentration, etc.), to mass (mass, mass concentration, etc.), to enzyme activity (catalytic content, catalytic concentration, etc.), and molar or equivalents (substance content, substance concentration).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.254"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.149"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0254"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.161"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0254"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-42"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "KindOfQuantity"
        }
      ]
    },
    {
      "code" : "0255",
      "display" : "Duration Categories",
      "definition" : "Table of codes used to classify an observation definition as intended to measure a patient's state at a point in time.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.255"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.150"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0255"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.162"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0255"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-43"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DurationCategories"
        }
      ]
    },
    {
      "code" : "0256",
      "display" : "Time Delay Post Challenge",
      "definition" : "HL7-defined table of codes used to classify an observation definition as being a component of a challenge test.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.256"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.151"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0256"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.163"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0256"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-44"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TimeDelayPostChallenge"
        }
      ]
    },
    {
      "code" : "0257",
      "display" : "Nature of Challenge",
      "definition" : "HL7-defined table of codes used to further describe an observation definition that is characterized as a challenge observation.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.257"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.152"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0257"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.164"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0257"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-44"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NatureOfChallenge"
        }
      ]
    },
    {
      "code" : "0258",
      "display" : "Relationship Modifier",
      "definition" : "HL7-defined table of codes used in an observation definition to describe the subject of an observation in relation to a patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.258"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.153"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0258"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.165"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0258"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-45"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RelationshipModifier"
        }
      ]
    },
    {
      "code" : "0259",
      "display" : "Modality",
      "definition" : "Table of codes used to define the imaging apparatus expected to be used to acquire an observation.  This table has been removed from the standard as of 2.7 in favor of table 0910.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.259"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-47"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Modality"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0259"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0259"
        }
      ]
    },
    {
      "code" : "0260",
      "display" : "Patient Location Type",
      "definition" : "Table of codes used to identify the kind of location described in the location definition.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.260"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.155"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0260"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.167"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0260"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LOC-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientLocationType"
        }
      ]
    },
    {
      "code" : "0261",
      "display" : "Location Equipment",
      "definition" : "Table of codes used to identify the equipment available in a location definition identified as a room or bed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.261"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.156"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0261"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.168"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0261"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LOC-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationEquipment"
        }
      ]
    },
    {
      "code" : "0262",
      "display" : "Privacy Level",
      "definition" : "Table of codes used to identify the level of privacy a patient will be afforded when assigned to this location definition.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.262"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.157"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0262"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.169"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0262"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LCH-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrivacyLevel"
        }
      ]
    },
    {
      "code" : "0263",
      "display" : "Level of Care",
      "definition" : "Table of codes used to identify the level of care a patient may be afforded when assigned to this location definition.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.263"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.158"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0263"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.170"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0263"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LCH-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LevelOfCare"
        }
      ]
    },
    {
      "code" : "0264",
      "display" : "Location Department",
      "definition" : "Table of codes used to specify the institution’s department to which a location belongs, or its cost center.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.264"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LDP-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationDepartment"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0264"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0264"
        }
      ]
    },
    {
      "code" : "0265",
      "display" : "Specialty Type",
      "definition" : "Table of codes used to identify the specialty of the care professional who is supported when using this location definition.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.265"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.159"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0265"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.171"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0265"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LDP-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecialtyType"
        }
      ]
    },
    {
      "code" : "0267",
      "display" : "Days of the Week",
      "definition" : "HL7-defined table of codes used to identify the day(s) of the week when a location may be scheduled for appointments.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.267"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.160"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0267"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.172"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0267"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "UVC.2, LDP.10 UVC.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DaysOfTheWeek"
        }
      ]
    },
    {
      "code" : "0268",
      "display" : "Override",
      "definition" : "Table of codes used to define whether a Charge Description Master description may be overridden or if it must be overridden.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.268"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.161"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0268"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.173"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0268"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CDM-5, PRC-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Override"
        }
      ]
    },
    {
      "code" : "0269",
      "display" : "Charge On Indicator",
      "definition" : "Table of codes used to define the event upon which a charge should be generated.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.269"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.162"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0269"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.174"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0269"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRC-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ChargeOnIndicator"
        }
      ]
    },
    {
      "code" : "0270",
      "display" : "Document Type",
      "definition" : "Table of codes used to identify the kind of patient document.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.270"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.163"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0270"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.175"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0270"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2DocumentType"
        }
      ]
    },
    {
      "code" : "0271",
      "display" : "Document Completion Status",
      "definition" : "HL7-defined table of codes used to record the state of a document in a workflow.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.271"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.164"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0271"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.176"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0271"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DocumentCompletionStatus"
        }
      ]
    },
    {
      "code" : "0272",
      "display" : "Document Confidentiality Status",
      "definition" : "HL7-defined table of codes that specify the degree to which special confidentiality protection should be applied to  information.  The assignment of data elements to these categories is left to the discretion of the healthcare organization.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.272"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.166"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0272"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.178"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0272"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DocumentConfidentialityStatus"
        }
      ]
    },
    {
      "code" : "0273",
      "display" : "Document Availability Status",
      "definition" : "HL7-defined table of codes used to define whether a patient document is appropriate or available for use in patient care.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.273"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.167"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0273"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.179"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0273"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-19"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DocumentAvailabilityStatus"
        }
      ]
    },
    {
      "code" : "0275",
      "display" : "Document Storage Status",
      "definition" : "HL7-defined table of codes used to describe the availability of a document in relation to the type of storage.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.275"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.168"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0275"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.180"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0275"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DocumentStorageStatus"
        }
      ]
    },
    {
      "code" : "0276",
      "display" : "Appointment reason codes",
      "definition" : "Table of codes used to describe the kind of appointment or the reason why an appointment has been scheduled.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.276"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.169"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0276"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.181"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0276"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AppointmentReasonCodes"
        }
      ]
    },
    {
      "code" : "0277",
      "display" : "Appointment Type Codes",
      "definition" : "Table of codes used in an appointment request to describe the kind of appointment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.277"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.170"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0277"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.182"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0277"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AppointmentTypeCodes"
        }
      ]
    },
    {
      "code" : "0278",
      "display" : "Filler status codes",
      "definition" : "Table of codes used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.278"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.171"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0278"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.183"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0278"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FillerStatusCodes"
        }
      ]
    },
    {
      "code" : "0279",
      "display" : "Allow Substitution Codes",
      "definition" : "Table of codes used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.279"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.172"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0279"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.184"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0279"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AllowSubstitutionCodes"
        }
      ]
    },
    {
      "code" : "0280",
      "display" : "Referral Priority",
      "definition" : "Table of codes used to designate the urgency of a  referral.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.280"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.173"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0280"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.185"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0280"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralPriority"
        }
      ]
    },
    {
      "code" : "0281",
      "display" : "Referral Type",
      "definition" : "Table of codes used to identify the general category of healthcare professional desired to satisfy a referral.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.281"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.174"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0281"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.186"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0281"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralType"
        }
      ]
    },
    {
      "code" : "0282",
      "display" : "Referral Disposition",
      "definition" : "Table of codes used to identify the expected response from the healthcare professional receiving a referral.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.282"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.175"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0282"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.187"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0282"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralDisposition"
        }
      ]
    },
    {
      "code" : "0283",
      "display" : "Referral Status",
      "definition" : "Table of codes used to define the state of a  referral.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.283"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.176"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0283"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.188"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0283"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralStatus"
        }
      ]
    },
    {
      "code" : "0284",
      "display" : "Referral Category",
      "definition" : "Table of codes used to describe the patient care setting where a referral should take place.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.284"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.177"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0284"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.189"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0284"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralCategory"
        }
      ]
    },
    {
      "code" : "0285",
      "display" : "Insurance Company ID Codes",
      "definition" : "Table of codes specifying the identification of the insurance company or other entity that administers the authorizing coverage plan.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.285"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "AUT-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InsuranceCompanyIdCodes"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0285"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0285"
        }
      ]
    },
    {
      "code" : "0286",
      "display" : "Provider Role",
      "definition" : "Table of codes used to define the relationship between a referral recipient and a patient or between a referral initiator and a patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.286"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.178"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0286"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.190"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0286"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRD-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralProviderRole"
        }
      ]
    },
    {
      "code" : "0287",
      "display" : "Problem/Goal Action Code",
      "definition" : "HL7-defined table of codes used in Patient Care for the intent of a problem or goal.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.287"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.3"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0287"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.191"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0287"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ROL-2, GOL-1, PRB-1, PTH-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Problem_GoalActionCode"
        }
      ]
    },
    {
      "code" : "0288",
      "display" : "Census Tract",
      "definition" : "Table of codes specifying the census tract in which the specified address resides.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.288"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.109"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CensusTract"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0288"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0288"
        }
      ]
    },
    {
      "code" : "0289",
      "display" : "County/Parish",
      "definition" : "Table of codes specifying the county or parish in which the specified address resides.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.289"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.9, CX.9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "County/Parish"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0289"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0289"
        }
      ]
    },
    {
      "code" : "0290",
      "display" : "MIME base64 encoding characters",
      "definition" : "Table of encoding characters used for base64 MIME encoding.  Base64 is defined as follows (adapted from MIME Internet standard RFC 1521).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.290"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.180"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0290"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.192"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0290"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EncodingCharacters"
        }
      ]
    },
    {
      "code" : "0291",
      "display" : "Subtype of Referenced Data",
      "definition" : "Table of codes specifying a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.291"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.181"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0291"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.193"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-notAllCodes-0291"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RP.4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubtypeOfReferencedData"
        }
      ]
    },
    {
      "code" : "0292",
      "display" : "Vaccines Administered",
      "definition" : "Table of codes specifying the administered vaccines.   The values are maintained by the US Centers of Disease Control.  The code system is maintained by the CDC, and may be found at URL;  https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.292\r\nThe value set is maintained by the CDC and may be found at URL: https://phinvads.cdc.gov/vads/ViewValueSet.action?id=ABDEE003-77C3-48E7-B941-EBF92B6B81FC",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.292"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.12.292"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://hl7.org/fhir/sid/cvx"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.114222.4.11.934"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0292"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXA-5, RXE-2, RXD-2, RXG-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VaccinesAdministered"
        }
      ]
    },
    {
      "code" : "0293",
      "display" : "Billing Category",
      "definition" : "Table of codes specifying the billing category codes for any classification systems needed, for example, general ledger codes and UB92 categories.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.293"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRC-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BillingCategory"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0293"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0293"
        }
      ]
    },
    {
      "code" : "0294",
      "display" : "Time Selection Criteria Parameter Class Codes",
      "definition" : "Table of codes used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.294"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.183"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0294"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.195"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0294"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCV.1, APR-1, APR-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TimeSelectionCriteriaParameterClassCodes"
        }
      ]
    },
    {
      "code" : "0295",
      "display" : "Handicap",
      "definition" : "Table of codes specifying an associated party's disability.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.295"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-36, PD1-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Handicap"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0295"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0295"
        }
      ]
    },
    {
      "code" : "0296",
      "display" : "Primary Language",
      "definition" : "Table of codes specifying the patient's primary language.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.296"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:18, PID-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrimaryLanguage"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0296"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0296"
        }
      ]
    },
    {
      "code" : "0297",
      "display" : "CN ID Source",
      "definition" : "Table of codes specifying the CN identification source.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.297"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CNN.8, PPN.8, XCN.8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CnIdSource"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0297"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0297"
        }
      ]
    },
    {
      "code" : "0298",
      "display" : "CP Range Type",
      "definition" : "HL7-defined table of codes that specify whether a composite price range is experssed as a flat rate or a percentage.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.298"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.184"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0298"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.196"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0298"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "Data type CP.6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CpRangeType"
        }
      ]
    },
    {
      "code" : "0299",
      "display" : "Encoding",
      "definition" : "HL7-defined table of codes identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters.  These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.299"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.185"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0299"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.197"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0299"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Encoding"
        }
      ]
    },
    {
      "code" : "0300",
      "display" : "Namespace ID",
      "definition" : "Table of codes which specify the unique name of the system that stores the data.   It was previously named the Application ID.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.300"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "HD.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NamespaceId"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0300"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0300"
        }
      ]
    },
    {
      "code" : "0301",
      "display" : "Universal ID Type",
      "definition" : "HL7-defined table of codes specifying the type of UID (Universal Identifier).  Open Issue:  Table 0301 has a mix of class and instance identifiers for namespaces, which is improper.  The values for instances. such as CLIA, CLIP, CAP, and NPI. These were added for pragmatic issues related to older datatypes that were universally bound tand should not be here but are needed for implementation pragmatics.   These should be annotated in Comment or Usage Notes that these are not universal ID types really.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.301"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.186"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0301"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.198"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0301"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "HD.3, EI.4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "UniversalIdType"
        }
      ]
    },
    {
      "code" : "0302",
      "display" : "Point of Care",
      "definition" : "Table of codes specifying the point where patient care is administered.  It is conditional on Person Location Type (e.g., nursing unit or department or clinic).   No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.302"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.1, NDL.4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PointOfCare"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0302"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0302"
        }
      ]
    },
    {
      "code" : "0303",
      "display" : "Room",
      "definition" : "Table of codes specifying the patient's room.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.303"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.2, NDL.5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Room"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0303"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0303"
        }
      ]
    },
    {
      "code" : "0304",
      "display" : "Bed",
      "definition" : "Table of codes specifying the patient's bed.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.304"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.3, NDL.6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Bed"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0304"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0304"
        }
      ]
    },
    {
      "code" : "0305",
      "display" : "Person Location Type",
      "definition" : "Table of codes specifying the categorization of the person's location.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.305"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.187"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0305"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.199"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0305"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.6, NDL.9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PersonLocationType"
        }
      ]
    },
    {
      "code" : "0306",
      "display" : "Location Status",
      "definition" : "Table of codes specifying the status or availability of the location, such as the bed status.   No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.306"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.5, NDL.8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0306"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0306"
        }
      ]
    },
    {
      "code" : "0307",
      "display" : "Building",
      "definition" : "Table of codes specifying the building where the person is located.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.307"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.7, NDL.10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Building"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0307"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0307"
        }
      ]
    },
    {
      "code" : "0308",
      "display" : "Floor",
      "definition" : "Table of codes specifying the floor where the person is located.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.308"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PL.8, NDL.11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Floor"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0308"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0308"
        }
      ]
    },
    {
      "code" : "0309",
      "display" : "Coverage Type",
      "definition" : "Table of codes specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system.  For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.309"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.188"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0309"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.200"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0309"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-47"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CoverageType"
        }
      ]
    },
    {
      "code" : "0311",
      "display" : "Job Status",
      "definition" : "Table of codes specifying a next of kin/associated party's job status.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.311"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.189"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0311"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.201"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0311"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NK1-34"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "JobStatus"
        }
      ]
    },
    {
      "code" : "0312",
      "display" : "Policy Scope",
      "definition" : "Table of codes specifying the extent of insurance coverage for a participating member (e.g., single, family, etc.).  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.312"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-59"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PolicyScope"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0312"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0312"
        }
      ]
    },
    {
      "code" : "0313",
      "display" : "Policy Source",
      "definition" : "Table of codes specifying how an insurance policy is established.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.313"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-60"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PolicySource"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0313"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0313"
        }
      ]
    },
    {
      "code" : "0315",
      "display" : "Living Will Code",
      "definition" : "Table of codes specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility.  If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.315"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.190"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0315"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.202"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0315"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-43, PD1-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LivingWillCode"
        }
      ]
    },
    {
      "code" : "0316",
      "display" : "Organ Donor Code",
      "definition" : "Table of codes specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.316"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.192"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0316"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.204"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0316"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-44, PD1-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrganDonorCode"
        }
      ]
    },
    {
      "code" : "0317",
      "display" : "Annotations",
      "definition" : "Table of codes specifying the coded entry associated with a given point in time during the waveform recording.  Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.317"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.193"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0317"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.205"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0317"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX ANO"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Annotations"
        }
      ]
    },
    {
      "code" : "0319",
      "display" : "Department Cost Center",
      "definition" : "Table of codes specifying the accounting code that identifies the department in order to charge for the item.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.319"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RQD-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DepartmentCostCenter"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0319"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0319"
        }
      ]
    },
    {
      "code" : "0320",
      "display" : "Item Natural Account Code",
      "definition" : "Table of codes identifying an item in order to charge for the item.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.320"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RQD-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ItemNaturalAccountCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0320"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0320"
        }
      ]
    },
    {
      "code" : "0321",
      "display" : "Dispense Method",
      "definition" : "HL7-defined table of codes specifying the method by which treatment is dispensed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.321"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.194"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0321"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.206"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0321"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXE-30, RXD-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DispenseMethod"
        }
      ]
    },
    {
      "code" : "0322",
      "display" : "Completion Status",
      "definition" : "HL7-defined table of codes specifying the status of the treatment administration event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.322"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.195"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0322"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.207"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0322"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXA-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CompletionStatus"
        }
      ]
    },
    {
      "code" : "0323",
      "display" : "Action Code",
      "definition" : "HL7-defined table ofstatus codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed.  As of version 2.6, this table was replaced with table 0206, whose values are defined by code system 2.16.840.1.133883.18.111.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.323"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.196"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0323"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.208"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0323"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ActionCode"
        }
      ]
    },
    {
      "code" : "0324",
      "display" : "Location Characteristic ID",
      "definition" : "Table of codes specifying an identifier code to show which characteristic is being communicated with the segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.324"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.197"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0324"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.209"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0324"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LCH-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationCharacteristicId"
        }
      ]
    },
    {
      "code" : "0325",
      "display" : "Location Relationship ID",
      "definition" : "Table of codes specifying an identifier code to show which relationship is being communicated with the segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.325"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.198"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0325"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.210"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0325"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LRL-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationRelationshipId"
        }
      ]
    },
    {
      "code" : "0326",
      "display" : "Visit Indicator",
      "definition" : "Table of codes specifying the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to indicate that the data sent in the message are at the visit level.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.326"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.199"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0326"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.211"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0326"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV1-51"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VisitIndicator"
        }
      ]
    },
    {
      "code" : "0327",
      "display" : "Job Code",
      "definition" : "Table of codes that specify a person's job code.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.327"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "JCC.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "JobCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0327"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0327"
        }
      ]
    },
    {
      "code" : "0328",
      "display" : "Employee Classification",
      "definition" : "Table of codes that specify a person's employee classification.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.328"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "JCC.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EmployeeClassification"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0328"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0328"
        }
      ]
    },
    {
      "code" : "0329",
      "display" : "Quantity Method",
      "definition" : "HL7-defined table of codes used to specify the method by which the quantity distributed is measured.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.329"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.200"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0329"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.212"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0329"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSH-8, PSH-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QuantityMethod"
        }
      ]
    },
    {
      "code" : "0330",
      "display" : "Marketing Basis",
      "definition" : "HL7-defined table of codes used to specify the basis for marketing approval.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.330"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.201"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0330"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.213"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0330"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PDC-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MarketingBasis"
        }
      ]
    },
    {
      "code" : "0331",
      "display" : "Facility Type",
      "definition" : "HL7-defined table of codes used to specify the type of facility.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.331"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.202"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0331"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.214"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0331"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FAC-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FacilityType"
        }
      ]
    },
    {
      "code" : "0332",
      "display" : "Source Type",
      "definition" : "HL7-defined table of codes used to indicate (in certain systems) whether a lower level source identifier is an initiate or accept type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.332"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.203"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0332"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.215"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0332"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NST-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SourceType"
        }
      ]
    },
    {
      "code" : "0333",
      "display" : "Driver's License Issuing Authority",
      "definition" : "Table of codes specifying the driver's license issuing authority.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.333"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLN.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DriversLicenseIssuingAuthority"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0333"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0333"
        }
      ]
    },
    {
      "code" : "0334",
      "display" : "Disabled Person Code",
      "definition" : "Table of codes used to specify to which person the disability information relates in the message.  For example, if the value is PT, the disability information relates to the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.334"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.204"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0334"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.216"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0334"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DB1-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DisabledPersonCode"
        }
      ]
    },
    {
      "code" : "0335",
      "display" : "Repeat Pattern",
      "definition" : "Table of codes used to specify the interval between repeated services. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns illustrating the syntax used to construct expressions using the codes and other modifiers.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.335"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.205"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0335"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.217"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0335"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RI.1, RPT.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RepeatPattern"
        }
      ]
    },
    {
      "code" : "0336",
      "display" : "Referral Reason",
      "definition" : "Table of codes used to specify the reason for which the referral will take place.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.336"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.206"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0336"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.218"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0336"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralReason"
        }
      ]
    },
    {
      "code" : "0337",
      "display" : "Certification Status",
      "definition" : "HL7-defined table of codes used to specify the status of the practitioner's speciality certification.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.337"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.207"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0337"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.219"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0337"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPD.3, PRA-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificationStatus"
        }
      ]
    },
    {
      "code" : "0338",
      "display" : "Practitioner ID Number Type",
      "definition" : "Table of codes specifying the type of number used for the practitioner identification.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.338"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.108"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0203"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.220"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0338"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PLN.2, PRD-7, CTD-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PractitionerIdNumberType"
        }
      ]
    },
    {
      "code" : "0339",
      "display" : "Advanced Beneficiary Notice Code",
      "definition" : "Table of codes specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.339"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.209"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0339"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.221"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0339"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-20, FT1-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdvancedBeneficiaryNoticeCode"
        }
      ]
    },
    {
      "code" : "0340",
      "display" : "Procedure Code Modifier",
      "definition" : "Table of codes that specify a procedure code modifier to a procedure code.  Procedure code modifiers are defined by regulatory agencies such as CMS and the AMA.  Multiple modifiers may be reported.  The modifiers are sequenced in priority according to user entry.  This is a requirement of the UB and the 1500 claim forms.  Multiple modifiers are allowed and the order placed on the form affects reimbursement.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.340"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-26, OBR-45, IIM-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureCodeModifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0340"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0340"
        }
      ]
    },
    {
      "code" : "0341",
      "display" : "Guarantor Credit Rating Code",
      "definition" : "Table of codes that specify a guarantor's credit rating.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.341"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GT1-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GuarantorCreditRatingCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0341"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0341"
        }
      ]
    },
    {
      "code" : "0342",
      "display" : "Military Recipient",
      "definition" : "Table of codes that specify a designation as a military recipient.  This field is defined by CMS or other regulatory agencies.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.342"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MilitaryRecipient"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0342"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0342"
        }
      ]
    },
    {
      "code" : "0343",
      "display" : "Military Handicapped Program Code",
      "definition" : "Table of codes that specify a military program for the handicapped in which a patient is enrolled.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.343"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-59"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MilitaryHandicappedProgramCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0343"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0343"
        }
      ]
    },
    {
      "code" : "0344",
      "display" : "Patient's Relationship to Insured",
      "definition" : "Table of codes used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.344"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.210"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0344"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.222"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0344"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN2-72"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Patient'sRelationshipToInsured"
        }
      ]
    },
    {
      "code" : "0345",
      "display" : "Appeal Reason",
      "definition" : "Table of codes that specify  reasons an appeal was made on a non-concur for certification.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.345"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AppealReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0345"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0345"
        }
      ]
    },
    {
      "code" : "0346",
      "display" : "Certification Agency",
      "definition" : "Table of codes that specify a certification agency.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.346"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificationAgency"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0346"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0346"
        }
      ]
    },
    {
      "code" : "0347",
      "display" : "State/Province",
      "definition" : "Table of codes specifying the names of the principal country subdivisions (e.g., provinces or states).  The values in the table are country specific.  For example, in the US, the Federal Information Processing Standard (FIPS) alpha codes may be used by local agreement.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.347"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "1.0.3166.2"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "urn:iso:std:iso:3166"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.9, PPN.23, XCN.22, ACC-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CountrySubdivision"
        }
      ]
    },
    {
      "code" : "0348",
      "display" : "Special Program Indicator",
      "definition" : "Table of codes that specify the special program indicator, as described in the UB82 Field 44.  This field is defined by HCFA or other regulatory agencies in the US.  Note that The UB codes listed as examples in earlier released of the HL7 Standards are not an exhaustive or current list; refer to a UB specification for additional information",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.348"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecialProgramIndicator"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0348"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0348"
        }
      ]
    },
    {
      "code" : "0349",
      "display" : "PSRO/UR Approval Indicator",
      "definition" : "HL7-defined table of codes of PSRO/UR approval indicators, as used in the UB82 field 87.  This field is defined by HCFA (in the US) or other regulatory agencies.  Note that this form type is no longer used in the US, and the  codes listed (as examples) are not an exhaustive or current list; refer to a UB84 specification for additional information.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.349"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PSRO_URApprovalIndicator"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0349"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0349"
        }
      ]
    },
    {
      "code" : "0350",
      "display" : "Occurrence Code",
      "definition" : "Table of codes that specify a National Uniform Billing Committee (NUBC) code for the event or occurrence relating to a bill that may affect payer processing.  In the US, NUBC codes generally used, see code system 2.16.840.1.113883.6.301.7; more information may be found at  http://www.nubc.org/become.html",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.350"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.301.7"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0350"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.227"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0350"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OCD.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OccurrenceCode"
        }
      ]
    },
    {
      "code" : "0351",
      "display" : "Occurrence Span",
      "definition" : "Externally defined table of codes specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim.  In the US, NUBC codes generally used, see code system 2.16.840.1.113883.6.301.8; more information may be found at  http://www.nubc.org/become.html.  The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.351"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.301.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0351"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.228"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0351"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OSP.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OccurrenceSpan"
        }
      ]
    },
    {
      "code" : "0353",
      "display" : "CWE statuses",
      "definition" : "HL7-defined table of codes that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended).  These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.353"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.213"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0353"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.229"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0353"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "vocab"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CWE.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CweStatuses"
        }
      ]
    },
    {
      "code" : "0354",
      "display" : "Message Structure",
      "definition" : "HL7-defined table of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.354"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.214"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0354"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.230"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0354"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-9.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MessageStructure"
        }
      ]
    },
    {
      "code" : "0355",
      "display" : "Primary Key Value Type",
      "definition" : "HL7-defined table of codes used to specify the type for the master file record identifier.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.355"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.215"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0355"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.231"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0355"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MFE-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrimaryKeyValueType"
        }
      ]
    },
    {
      "code" : "0356",
      "display" : "Alternate Character Set Handling Scheme",
      "definition" : "HL7-defined table of codes that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.356"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.216"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0356"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.232"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0356"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AlternateCharacterSetHandlingScheme"
        }
      ]
    },
    {
      "code" : "0357",
      "display" : "Message Error Condition Codes",
      "definition" : "HL7-defined table of codes specifying the HL7 (communications) error code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.357"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.217"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0357"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.233"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0357"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MessageErrorConditionCodes"
        }
      ]
    },
    {
      "code" : "0358",
      "display" : "Practitioner Group",
      "definition" : "Table of codes specifying the name and/or code of a group of practitioners to which this practitioner belongs.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.358"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PractitionerGroup"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0358"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0358"
        }
      ]
    },
    {
      "code" : "0359",
      "display" : "Diagnosis Priority",
      "definition" : "Table of codes that identify the significance or priority of the diagnosis code.  Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.359"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.218"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0359"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.234"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0359"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DiagnosisPriority"
        }
      ]
    },
    {
      "code" : "0360",
      "display" : "Degree/License/Certificate",
      "definition" : "Table of codes specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.360"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.220"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0360"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.236"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0360"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CNN.7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Degree/License/Certificate"
        }
      ]
    },
    {
      "code" : "0361",
      "display" : "Application",
      "definition" : "Table of codes that identify a sending application among all other applications within the network enterprise.  The network enterprise consists of all those applications that participate in the exchange of HL7 messages within the enterprise.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.361"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-3, MSH-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Application"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0361"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0361"
        }
      ]
    },
    {
      "code" : "0362",
      "display" : "Facility",
      "definition" : "Table of codes specifying the site-specific name for the facility used by this application.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.362"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-4, MSH-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Facility"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0362"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0362"
        }
      ]
    },
    {
      "code" : "0363",
      "display" : "Assigning Authority",
      "definition" : "Table of codes specifying a unique name of the system (or organization or agency or department) that creates the data.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.363"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.4, EI.2, PL.11, PPN.9, XCN.9, XON.6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AssigningAuthority"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0363"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0363"
        }
      ]
    },
    {
      "code" : "0364",
      "display" : "Comment Type",
      "definition" : "Table of codes that identify the type of comment text being sent in the specific comment record.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.364"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.222"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0364"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.238"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0364"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NTE-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CommentType"
        }
      ]
    },
    {
      "code" : "0365",
      "display" : "Equipment State",
      "definition" : "HL7-defined table of codes that identify the status the equipment was in at the time the transaction was initiated.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.365"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.223"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0365"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.239"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0365"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EQU-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EquipmentState"
        }
      ]
    },
    {
      "code" : "0366",
      "display" : "Local/Remote Control State",
      "definition" : "HL7-defined table of codes that identify the current state of control associated with the equipment.   Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.366"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.224"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0366"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.240"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0366"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EQU-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Local_RemoteControlState"
        }
      ]
    },
    {
      "code" : "0367",
      "display" : "Alert Level",
      "definition" : "HL7-defined table of codes that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.367"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.225"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0367"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.241"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0367"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EQU-5, NDS-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AlertLevel"
        }
      ]
    },
    {
      "code" : "0368",
      "display" : "Remote Control Command",
      "definition" : "Table of codes that identify the comment the component is to initiate.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.368"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.226"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0368"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.242"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0368"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ECD-2, ISD-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RemoteControlCommand"
        }
      ]
    },
    {
      "code" : "0369",
      "display" : "Specimen Role",
      "definition" : "Table of codes that identify the role of a sample.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.369"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.227"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0369"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.243"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0369"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-11, OBR-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenRole"
        }
      ]
    },
    {
      "code" : "0370",
      "display" : "Container Status",
      "definition" : "HL7-defined table of codes that identify the status of the unique container in which the specimen resides at the time the transaction was initiated.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.370"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.228"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0370"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.244"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0370"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerStatus"
        }
      ]
    },
    {
      "code" : "0371",
      "display" : "Additive/Preservative",
      "definition" : "HL7-defined table of codes specifying any additive introduced to the specimen before or at the time of collection.  These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.371"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.229"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0371"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.245"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0371"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-6, SAC-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Additive/Preservative"
        }
      ]
    },
    {
      "code" : "0372",
      "display" : "Specimen Component",
      "definition" : "Table of codes that identify the specimen component, e.g., supernatant, sediment, etc.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.372"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.230"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0372"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.246"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0372"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenComponent"
        }
      ]
    },
    {
      "code" : "0373",
      "display" : "Treatment",
      "definition" : "Table of codes that identify the specimen treatment performed during lab processing.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.373"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.231"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0373"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.247"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0373"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-30"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Treatment"
        }
      ]
    },
    {
      "code" : "0374",
      "display" : "System Induced Contaminants",
      "definition" : "Table of codes that identify the specimen contaminant identifier associated with the specimen in the container.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.374"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.232"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0374"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.248"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0374"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-40"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SystemInducedContaminants"
        }
      ]
    },
    {
      "code" : "0375",
      "display" : "Artificial Blood",
      "definition" : "Table of codes that identify the artificial blood identifier associated with the specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.375"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.233"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0375"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.249"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0375"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-42"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ArtificialBlood"
        }
      ]
    },
    {
      "code" : "0376",
      "display" : "Special Handling Code",
      "definition" : "Table of codes describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.376"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.234"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0376"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.250"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0376"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-15, SAC-43,  PAC-7, OM4-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecialHandlingCode"
        }
      ]
    },
    {
      "code" : "0377",
      "display" : "Other Environmental Factors",
      "definition" : "Table of codes that identify the other environmental factors associated with the specimen in a specific container, e.g., atmospheric exposure.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.377"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.235"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0377"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.251"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0377"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-44"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OtherEnvironmentalFactors"
        }
      ]
    },
    {
      "code" : "0378",
      "display" : "Carrier Type",
      "definition" : "Table of codes that identify a type of carrier.  Because the geometry can be different, the carrier type should, if possible, express the number of positions in the carrier.  The definition assumes hierarchical nesting using the following phrases: container is located in a carrier, carrier is located in a tray.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.378"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CarrierType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0378"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0378"
        }
      ]
    },
    {
      "code" : "0379",
      "display" : "Tray Type",
      "definition" : "Table of codes that identify a type of tray.  Because the geometry can be different, the tray type should, if possible, express the number of positions in the tray.  The definition assumes hierarchical nesting using the following phrases: container is located in a carrier, carrier is located in a tray.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.379"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerTrayType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0379"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0379"
        }
      ]
    },
    {
      "code" : "0380",
      "display" : "Separator Type",
      "definition" : "Table of codes that identify a type of separator being used (e.g., a gel separator in a container - not to be confused with the communication separators).  It is recommended the first table entry be \"NO\" meaning \"No Separator\".  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.380"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SeparatorType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0380"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0380"
        }
      ]
    },
    {
      "code" : "0381",
      "display" : "Cap Type",
      "definition" : "Table of codes that identify a type of cap that is to be used with a container for decapping, piercing or other mechanisms.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.381"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CapType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0381"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0381"
        }
      ]
    },
    {
      "code" : "0382",
      "display" : "Drug Interference",
      "definition" : "Table of codes that identify a drug interference  associated with a specimen.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.382"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-41"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrugInterference"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0382"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0382"
        }
      ]
    },
    {
      "code" : "0383",
      "display" : "Substance Status",
      "definition" : "HL7-defined table of codes identifying the status of the inventoried item.  The status indicates the current status of the substance.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.383"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.236"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0383"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.252"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0383"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubstanceStatus"
        }
      ]
    },
    {
      "code" : "0384",
      "display" : "Substance Type",
      "definition" : "HL7-defined table of codes identifying the type of substance.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.384"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.237"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0384"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.253"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0384"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubstanceType"
        }
      ]
    },
    {
      "code" : "0385",
      "display" : "Manufacturer Identifier",
      "definition" : "Table of codes that identify a manufacturer of a substance.  Relevant external code systems may be used, e.g., HIBCC Manufacturers Labeler ID Code (LIC), UPC, NDC, etc.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.385"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-17, RQ1-2, SID-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ManufacturerIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0385"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0385"
        }
      ]
    },
    {
      "code" : "0386",
      "display" : "Supplier Identifier",
      "definition" : "Table of codes that identify a supplier of a substance.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.386"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SupplierIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0386"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0386"
        }
      ]
    },
    {
      "code" : "0387",
      "display" : "Command Response",
      "definition" : "Table of codes identifying the response of the previously issued command.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.387"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.238"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0387"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.254"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0387"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ECR-1, ISD-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CommandResponse"
        }
      ]
    },
    {
      "code" : "0388",
      "display" : "Processing Type",
      "definition" : "HL7-defined table of codes identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.388"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.239"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0388"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.255"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0388"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TCC-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessingType"
        }
      ]
    },
    {
      "code" : "0389",
      "display" : "Analyte Repeat Status",
      "definition" : "HL7-defined table of codes identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex).  The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as \"Panic\" or mechanical failures).  Repeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits).  Reflex test — this test is performed as the consequence of rules triggered based on other test result(s).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.389"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.240"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0389"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.256"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0389"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TCD-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AnalyteRepeatStatus"
        }
      ]
    },
    {
      "code" : "0391",
      "display" : "Segment Group",
      "definition" : "HL7-defined table of codes specifying the optional segment groups which are to be included in a response.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.391"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.242"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0391"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.258"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0391"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCP.7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SegmentGroup"
        }
      ]
    },
    {
      "code" : "0392",
      "display" : "Match Reason",
      "definition" : "Table of codes identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels.  It provides a method for passing a descriptive indication of the reason a particular record was found.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.392"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.243"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0392"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.259"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0392"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QRI.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MatchReason"
        }
      ]
    },
    {
      "code" : "0393",
      "display" : "Match Algorithms",
      "definition" : "Table of codes identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.393"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.244"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0393"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.260"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0393"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QRI.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MatchAlgorithms"
        }
      ]
    },
    {
      "code" : "0394",
      "display" : "Response Modality",
      "definition" : "HL7-defined table of codes identifying the timing and grouping of the response message(s).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.394"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.245"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0394"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.261"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0394"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCP.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ResponseModality"
        }
      ]
    },
    {
      "code" : "0395",
      "display" : "Modify Indicator",
      "definition" : "HL7-defined table of codes identifying whether the subscription is new or is being modified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.395"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.246"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0395"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.262"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0395"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCP.5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ModifyIndicator"
        }
      ]
    },
    {
      "code" : "0396",
      "display" : "Coding System",
      "definition" : "HL7-defined table of specifying the coding system.  This table is maintained outside of the published Version 2 standards; the content is not listed here; the content is maintained outside of the Version 2 Product Family maintenance process.  For the list of codes in the table, see the HL7 Webpage rendering, at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.396"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.247"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0396"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.263"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0396"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "vocab"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CWE.3, CWE.6, CWE, and numerous places"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CodingSystem"
        }
      ]
    },
    {
      "code" : "0397",
      "display" : "Sequencing",
      "definition" : "HL7-defined table of codes identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.397"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.248"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0397"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.264"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0397"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SRT.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2Sequencing"
        }
      ]
    },
    {
      "code" : "0398",
      "display" : "Continuation Style Code",
      "definition" : "HL7-defined table of codes identifying whether it is a fragmented message or part of an interactive continuation message.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.398"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.249"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0398"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.265"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0398"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CH02, DSC.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContinuationStyleCode"
        }
      ]
    },
    {
      "code" : "0399",
      "display" : "Country Code",
      "definition" : "Table of codes that identifies a country of origin for a message.  It will be used primarily to specify default elements, such as currency denominations. The values to be used are those of ISO 3166. The ISO 3166 table has three separate forms of the country code: HL7 specifies that the 3-character (alphabetic) form be used for the country code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.399"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "1.0.3166.1"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "urn:iso:std:iso:3166"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.266"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-notAllCodes-0399"
        },
        {
          "code" : "v2-cld",
          "valueString" : "4"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-17, CX.9, PPN.23,VID.2, XAD.6, XCN.22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CountryCode"
        }
      ]
    },
    {
      "code" : "0401",
      "display" : "Government Reimbursement Program",
      "definition" : "Table of codes which specify codes that indicate an agency that the practitioner is authorized to bill for medical services.  Existing codes only for use in the United States.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.401"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.250"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0401"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.267"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0401"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRA-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GovernmentReimbursementProgram"
        }
      ]
    },
    {
      "code" : "0402",
      "display" : "School Type",
      "definition" : "Table of codes which specify a categorization of an academic institution that grants a degree to a Staff Member.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.402"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.251"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0402"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.268"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0402"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EDU-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SchoolType"
        }
      ]
    },
    {
      "code" : "0403",
      "display" : "Language Ability",
      "definition" : "Table of codes which specify codes that indicate the ability that a Staff Member possesses with respect to the language.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.403"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.252"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0403"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.269"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0403"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LAN-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LanguageAbility"
        }
      ]
    },
    {
      "code" : "0404",
      "display" : "Language Proficiency",
      "definition" : "HL7-defined table of codes which specify the level of knowledge a person possesses with respect to a language ability identified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.404"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.253"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0404"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.270"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0404"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LAN-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LanguageProficiency"
        }
      ]
    },
    {
      "code" : "0405",
      "display" : "Organization Unit",
      "definition" : "Table of codes which specify the hierarchical components of an organization unit, as defined by the institution.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.405"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORG-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrganizationUnit"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0405"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0405"
        }
      ]
    },
    {
      "code" : "0406",
      "display" : "Participant Organization Unit Type",
      "definition" : "HL7-defined table of codes that specify the environment in which the provider acts in the role associated with the provider type, and inludes codes for venues outside of formal organized healthcare settings, such as Home. The provider environment is not the specialty for the provider.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.406"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.254"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0406"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.271"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0406"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRT-7, ROL-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ParticipantOrganizationUnitType"
        }
      ]
    },
    {
      "code" : "0409",
      "display" : "Application Change Type",
      "definition" : "HL7-defined table of codes that specify a type of change being requested (if NMR query) or announced (if NMD unsolicited update).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.409"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.255"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0409"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.272"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0409"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "NSC-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ApplicationChangeType"
        }
      ]
    },
    {
      "code" : "0411",
      "display" : "Supplemental Service Information Values",
      "definition" : "Table of codes that specify supplemental service information sent between a placer system and a filler system for the universal procedure code reported in OBR-4 Universal Service ID. This specifies ordering information detail that is not available in other specific tables for fields in the OBR segment.  These might be details such as whether a study is to be done on the right or left, for example, where the study is of the arm and the order master file does not distinguish right from left, or whether a study is to be done with or without contrast (when the order master file does not make such distinctions).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.411"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-46, OBR-47, AIS-11, AIS-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SupplementalServiceInformationValues"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0411"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0411"
        }
      ]
    },
    {
      "code" : "0412",
      "display" : "Category Identifier",
      "definition" : "Table of codes that specify a category name (term given to a group of service items for the purpose of classification). Examples: Laboratory, Pharmacy, Diagnostic Imaging, etc.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.412"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM7-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CategoryIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0412"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0412"
        }
      ]
    },
    {
      "code" : "0413",
      "display" : "Consent Identifier",
      "definition" : "Table of codes that provide an identifier for the consent specified for a service item.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.413"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM7-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0413"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0413"
        }
      ]
    },
    {
      "code" : "0414",
      "display" : "Units of Time",
      "definition" : "Table of codes that specify a unit of time.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.414"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM7-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "UnitsOfTime"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0414"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0414"
        }
      ]
    },
    {
      "code" : "0415",
      "display" : "Transfer Type",
      "definition" : "HL7-defined table of codes that specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG's), for example, exempt or non-exempt.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.415"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.257"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0415"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.274"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0415"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransferType"
        }
      ]
    },
    {
      "code" : "0416",
      "display" : "Procedure DRG Type",
      "definition" : "HL7-defined table of codes that specify a procedure's priority ranking relative to its DRG.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.416"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.258"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0416"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.275"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0416"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedureDrgType"
        }
      ]
    },
    {
      "code" : "0417",
      "display" : "Tissue Type Code",
      "definition" : "HL7-defined table of codes that specify",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.417"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.259"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0417"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.276"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0417"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TissueTypeCode"
        }
      ]
    },
    {
      "code" : "0418",
      "display" : "Procedure Priority",
      "definition" : "HL7-defined table of codes specifying a number that identifies the significance or priority of the procedure code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.418"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.260"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0418"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.277"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0418"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcedurePriority"
        }
      ]
    },
    {
      "code" : "0421",
      "display" : "Severity of Illness Code",
      "definition" : "Table of codes specifying the severity ranking of a patient's illness.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.421"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.262"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0421"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.278"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0421"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ABS-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SeverityOfIllnessCode"
        }
      ]
    },
    {
      "code" : "0422",
      "display" : "Triage Code",
      "definition" : "Table of codes specifying a patient's prioritization within the context of this abstract.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.422"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.263"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0422"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.279"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0422"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ABS-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TriageCode"
        }
      ]
    },
    {
      "code" : "0423",
      "display" : "Case Category Code",
      "definition" : "Table of codes specifying the reason a non-urgent patient presents to the emergency room for treatment instead of a clinic or physican office.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.423"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.264"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0423"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.280"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0423"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ABS-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CaseCategoryCode"
        }
      ]
    },
    {
      "code" : "0424",
      "display" : "Gestation Category Code",
      "definition" : "Table of codes specifying the status of the birth in relation to the gestation",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.424"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.265"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0424"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.281"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0424"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ABS-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GestationCategoryCode"
        }
      ]
    },
    {
      "code" : "0425",
      "display" : "Newborn Code",
      "definition" : "Table of codes specifying whether the baby was born in or out of the facility.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.425"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.266"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0425"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.282"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0425"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ABS-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NewbornCode"
        }
      ]
    },
    {
      "code" : "0426",
      "display" : "Blood Product Code",
      "definition" : "Table of codes specifying the blood product code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.426"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.267"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0426"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.283"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0426"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BLC-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BloodProductCode"
        }
      ]
    },
    {
      "code" : "0427",
      "display" : "Risk Management Incident Code",
      "definition" : "Table of codes specifying the incident that occurred during a patient's stay.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.427"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.268"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0427"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.284"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0427"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RMI-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RiskManagementIncidentCode"
        }
      ]
    },
    {
      "code" : "0428",
      "display" : "Incident Type Code",
      "definition" : "Table of codes specifying a classification of the incident type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.428"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.269"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0428"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.285"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0428"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RMI-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IncidentTypeCode"
        }
      ]
    },
    {
      "code" : "0429",
      "display" : "Production Class Code",
      "definition" : "Table of codes specifying the code and/or text indicating the primary use for which the living subject was bred or grown.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.429"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.270"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0429"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.286"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0429"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-38"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProductionClassCode"
        }
      ]
    },
    {
      "code" : "0430",
      "display" : "Mode of Arrival Code",
      "definition" : "Table of codes specifying how the patient was brought to the healthcare facility.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.430"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.271"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0430"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.287"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0430"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-38"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ModeOfArrivalCode"
        }
      ]
    },
    {
      "code" : "0431",
      "display" : "Recreational Drug Use Code",
      "definition" : "Table of codes specifying what recreational drugs the patient uses.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.431"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.272"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0431"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.288"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0431"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-39"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RecreationalDrugUseCode"
        }
      ]
    },
    {
      "code" : "0432",
      "display" : "Admission Level of Care Code",
      "definition" : "Table of codes specifying the acuity level assigned to the patient at the time of admission.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.432"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.273"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0432"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.289"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0432"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-40"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdmissionLevelOfCareCode"
        }
      ]
    },
    {
      "code" : "0433",
      "display" : "Precaution Code",
      "definition" : "Table of codes specifying non-clincal precautions that need to be taken with the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.433"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.274"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0433"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.290"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0433"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-41"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrecautionCode"
        }
      ]
    },
    {
      "code" : "0434",
      "display" : "Patient Condition Code",
      "definition" : "Table of codes specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.434"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.275"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0434"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.291"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0434"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-42"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientConditionCode"
        }
      ]
    },
    {
      "code" : "0435",
      "display" : "Advance Directive Code",
      "definition" : "Table of codes specifying the patient's instructions to the healthcare facility.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.435"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.276"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0435"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.292"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0435"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-45, PD1-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdvanceDirectiveCode"
        }
      ]
    },
    {
      "code" : "0436",
      "display" : "Sensitivity to Causative Agent Code",
      "definition" : "Table of codes specifying the reason the patient should not be exposed to a substance.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.436"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.277"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0436"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.293"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0436"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IAM-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SensitivityToCausativeAgentCode"
        }
      ]
    },
    {
      "code" : "0437",
      "display" : "Alert Device Code",
      "definition" : "Table of codes specifying any type of allergy alert device the patient may be carrying or wearing.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.437"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.278"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0437"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.294"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0437"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IAM-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AlertDeviceCode"
        }
      ]
    },
    {
      "code" : "0438",
      "display" : "Allergy Clinical Status",
      "definition" : "Table of codes specifying the verification status for the allergy.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.438"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.279"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0438"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.295"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0438"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IAM-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AllergyClinicalStatus"
        }
      ]
    },
    {
      "code" : "0440",
      "display" : "Data Types",
      "definition" : "HL7-defined table of codes specifying the data type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.440"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.280"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0440"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.296"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0440"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RCD.2, RDF-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DataTypes"
        }
      ]
    },
    {
      "code" : "0441",
      "display" : "Immunization Registry Status",
      "definition" : "Table of codes specifying the immunization registry status of the patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.441"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.281"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0441"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.297"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0441"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PD1-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ImmunizationRegistryStatus"
        }
      ]
    },
    {
      "code" : "0442",
      "display" : "Location Service Code",
      "definition" : "Table of codes specifying the types of services provided by the location.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.442"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.282"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0442"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.298"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0442"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LOC-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationServiceCode"
        }
      ]
    },
    {
      "code" : "0443",
      "display" : "Provider Role",
      "definition" : "Table of codes specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.443"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.283"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0443"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.299"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0443"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ROL-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProviderRole"
        }
      ]
    },
    {
      "code" : "0444",
      "display" : "Name Assembly Order",
      "definition" : "HL7-defined table of codes specifying the preferred display order of the components of this person name.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.444"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.284"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0444"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.300"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0444"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PPN-19, XCN-18, XPN-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NameAssemblyOrder"
        }
      ]
    },
    {
      "code" : "0445",
      "display" : "Identity Reliability Code",
      "definition" : "Table of codes specifying the reliability of patient/person identifying data transmitted via a transaction.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.445"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.285"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0445"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.301"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0445"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-32"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IdentityReliabilityCode"
        }
      ]
    },
    {
      "code" : "0446",
      "display" : "Species Code",
      "definition" : "Table of codes specifying the species of living organism.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.446"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-35"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpeciesCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0446"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0446"
        }
      ]
    },
    {
      "code" : "0447",
      "display" : "Breed Code",
      "definition" : "Table of codes specifying the specific breed of animal.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.447"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PID-36"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BreedCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0447"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0447"
        }
      ]
    },
    {
      "code" : "0448",
      "display" : "Name Context",
      "definition" : "Table of codes specifying the context in which a name is used.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.448"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PPN.17, XCN.16, XPN.9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NameContext"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0448"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0448"
        }
      ]
    },
    {
      "code" : "0449",
      "display" : "Conformance statements",
      "definition" : "HL7-defined table of reasons a specimen may be rejected for a specified observation/result/analysis.  Used in Version 2 messaging in the SPM segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.449"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConformanceStatements"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0449"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0449"
        }
      ]
    },
    {
      "code" : "0450",
      "display" : "Event Type",
      "definition" : "HL7-defined table of codes specifying the type of event of the message.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.450"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.286"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0450"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.302"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0450"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "EQP-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EQPEventType"
        }
      ]
    },
    {
      "code" : "0451",
      "display" : "Substance Identifier",
      "definition" : "Table of codes specifying the substance that is in inventory.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.451"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubstanceIdentifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0451"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0451"
        }
      ]
    },
    {
      "code" : "0452",
      "display" : "Health Care Provider Type Code",
      "definition" : "Table of codes specifying the major grouping of the service or occupation of the practitioner at a specific organization unit.   In the US, it is suggested to use ANSI ASC X12 Health Care Provider Taxonomy, Level 1 - Type",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.452"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORG-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "HealthCareProviderTypeCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0452"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0452"
        }
      ]
    },
    {
      "code" : "0453",
      "display" : "Health Care Provider Classification",
      "definition" : "Table of codes specifying the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. Health Care Provider ClassificationIn the US, it is suggested to use ANSI ASC X12 Health Care Provider Taxonomy, Level 2 - Classification",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.453"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORG-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "HealthCareProviderClassification"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0453"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0453"
        }
      ]
    },
    {
      "code" : "0454",
      "display" : "Health Care Provider Area of Specialization",
      "definition" : "Table of codes specifying the segment of the population that a health care provider chooses to service, a specific medical service, a specialization in treating a specific disease, or any other descriptive characteristic about the provider’s practice relating to the services rendered of the practitioner at a specific organization unit.Health Care Provider Area of Specialization.  In the US it is suggested to use ANSI ASC X12 Health Care Provider Taxonomy, Level 2 - Classification.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.454"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORG-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "HealthCareProviderAreaOfSpecialization"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0454"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0454"
        }
      ]
    },
    {
      "code" : "0455",
      "display" : "Type of Bill Code",
      "definition" : "Table of codes specifying the specific type of bill with digit 1 showing type of facility, digit 2 showing bill classification and digit 3 showing frequency.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.455"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP1-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TypeOfBillCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0445"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0445"
        }
      ]
    },
    {
      "code" : "0456",
      "display" : "Revenue code",
      "definition" : "Externally defined table of codes specifying a service line revenue code.  These are claim codes indicating the identifying number for the product or service provided.  In the US, NUBC codes generally used, see code system 2.16.840.1.113883.6.301.3; more information may be found at  http://www.nubc.org/become.html. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html, UB form locater 42.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.456"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.301.3"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0456"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.476"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0456"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP1-2, FT1-41"
        },
        {
          "code" : "v2-binding",
          "valueString" : "4"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RevenueCode"
        }
      ]
    },
    {
      "code" : "0457",
      "display" : "Overall Claim Disposition Code",
      "definition" : "Table of codes specifying the final status of the claim.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.457"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.292"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0457"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.308"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0457"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP1-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OverallClaimDispositionCode"
        }
      ]
    },
    {
      "code" : "0458",
      "display" : "OCE Edit Code",
      "definition" : "Table of codes that specify the edits that result from processing the HCPCS/CPT procedures for a record after evaluating all the codes, revenue codes, and modifiers.  The codes listed as examples are not an exhaustive or current list, refer to OPPS Final Rule.  OCE (Outpatient Code Editor) edits also exist at the pre-procedure level.  This field is defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.458"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP1-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OceEditCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0458"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0458"
        }
      ]
    },
    {
      "code" : "0459",
      "display" : "Reimbursement Action Code",
      "definition" : "Table of codes specifying the action to be taken during reimbursement calculations.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.459"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReimbursementActionCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0459"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0459"
        }
      ]
    },
    {
      "code" : "0460",
      "display" : "Denial or Rejection Code",
      "definition" : "Table of codes specifying the OCE status of the line item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.460"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DenialOrRejectionCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0460"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0460"
        }
      ]
    },
    {
      "code" : "0461",
      "display" : "License Number",
      "definition" : "Table of codes specifying the license number for the facility.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.461"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LOC-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LicenseNumber"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0461"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0461"
        }
      ]
    },
    {
      "code" : "0462",
      "display" : "Location Cost Center",
      "definition" : "Table of codes specifying the cost center to which this location belongs.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.462"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "LDP-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LocationCostCenter"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0462"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0462"
        }
      ]
    },
    {
      "code" : "0463",
      "display" : "Inventory Number",
      "definition" : "Table of codes specifying an identifying stock number, if any, which might be used, for example, as a cross reference for materials management.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.463"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CDM-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InventoryNumber"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0463"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0463"
        }
      ]
    },
    {
      "code" : "0464",
      "display" : "Facility ID",
      "definition" : "Table of codes specifying the facility of the institution for which this price (for the preceding CDM entry) is valid.  For use when needing multi-facility pricing. If null, assume all facilities. In a multi-facility environment, the facility associated with this chargeable item may not be the same as the sending or receiving facility identified in the MSH segment. Use only when the price is not the same for all facilities, that is, a null value indicates that this pricing is valid for all facilities.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.464"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRC-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "FacilityId"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0464"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0464"
        }
      ]
    },
    {
      "code" : "0465",
      "display" : "Name/Address Representation",
      "definition" : "HL7-defined table of codes specifying an indication of the representation provided by the data item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.465"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.295"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0465"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.311"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0465"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PPN.16, XAD.11, XCN.15, XON.9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Name_AddressRepresentation"
        }
      ]
    },
    {
      "code" : "0466",
      "display" : "Ambulatory Payment Classification Code",
      "definition" : "Table of codes specifying the derived Ambulatory Payment Classification (APC) code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.466"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.296"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0466"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.312"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0466"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AmbulatoryPaymentClassificationCode"
        }
      ]
    },
    {
      "code" : "0467",
      "display" : "Modifier Edit Code",
      "definition" : "Table of codes that specify the edits of the modifiers for each line or HCPCS/CPT.  This field is defined by CMS or other regulatory agencies in the US.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.467"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP1-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ModifierEditCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0467"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0467"
        }
      ]
    },
    {
      "code" : "0468",
      "display" : "Payment Adjustment Code",
      "definition" : "Table of codes specifying any payment adjustment due to drugs or medical devices.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.468"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.297"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0468"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.313"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0468"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PaymentAdjustmentCode"
        }
      ]
    },
    {
      "code" : "0469",
      "display" : "Packaging Status Code",
      "definition" : "Table of codes specifying the packaging status of the service.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.469"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.298"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0469"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.314"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0469"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PackagingStatusCode"
        }
      ]
    },
    {
      "code" : "0470",
      "display" : "Reimbursement Type Code",
      "definition" : "Table of codes specifying the fee schedule reimbursement type applied to the line item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.470"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.299"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0470"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.315"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0470"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "GP2-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReimbursementTypeCode"
        }
      ]
    },
    {
      "code" : "0471",
      "display" : "Query Name",
      "definition" : "Table of codes specifying the name of the query.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.471"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "QPD-1, QAK-3, QID-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QueryName"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0471"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0471"
        }
      ]
    },
    {
      "code" : "0472",
      "display" : "TQ Conjunction ID",
      "definition" : "HL7-defined table of codes specifying that a second timing specification is to follow using the repeat delimiter.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.472"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.300"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0472"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.316"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0472"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ1-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TqConjunctionId"
        }
      ]
    },
    {
      "code" : "0473",
      "display" : "Formulary Status",
      "definition" : "Table of codes specifying whether or not the service (pharmaceutical) is in the formulary.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.473"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.301"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0473"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.317"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0473"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM7-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ServiceFormularyStatus"
        }
      ]
    },
    {
      "code" : "0474",
      "display" : "Practitioner Organization Unit Type",
      "definition" : "Table of codes specifying the classification of the organization unit.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.474"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.302"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0474"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.318"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0474"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORG-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.4"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PractitionerOrganizationUnitType"
        }
      ]
    },
    {
      "code" : "0475",
      "display" : "Charge Type Reason",
      "definition" : "Table of codes specifying the choice of, and providing the clinical rationale for, a selected charge type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.475"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.303"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0475"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.319"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0475"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BLG-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ChargeTypeReason"
        }
      ]
    },
    {
      "code" : "0476",
      "display" : "Medically Necessary Duplicate Procedure Reason",
      "definition" : "Table of codes specifying the reason the procedure code found in OBR-44 Procedure Code is a duplicate of one ordered/charged previously for the same patient within the same date of service and has been determined to be medically necessary.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.476"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-48, FT1-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2MedicallyNecessaryDuplicateProcedureReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0476"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0476"
        }
      ]
    },
    {
      "code" : "0477",
      "display" : "Controlled Substance Schedule",
      "definition" : "Table of codes specifying the class of the drug or other substance if its usage is controlled by legislation.  In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Values are drawn from the Pharmacy Law Digest July 1988.  Other countries should create their own versions of this table.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.477"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.304"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0477"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.320"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0477"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXE-35"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ControlledSubstanceSchedule"
        }
      ]
    },
    {
      "code" : "0478",
      "display" : "Formulary Status",
      "definition" : "HL7-defined table of codes specifying whether or not the pharmaceutical substance is part of the local formulary.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.478"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.305"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0478"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.321"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0478"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SubstanceFormularyStatus"
        }
      ]
    },
    {
      "code" : "0479",
      "display" : "Pharmaceutical Substances",
      "definition" : "Table of codes specifying the medical substance or treatment that has been ordered to be given to the patient, as encoded by the pharmacy or treatment supplier.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.479"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXE-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PharmaceuticalSubstances"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0479"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0479"
        }
      ]
    },
    {
      "code" : "0480",
      "display" : "Pharmacy Order Types",
      "definition" : "HL7-defined table of codes specifying the general category of pharmacy order which may be used to determine the processing path the order will take.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.480"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.306"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0480"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.322"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0480"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXO-27, RXE-44, RXD-32, RXG-26, RXA-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PharmacyOrderTypes"
        }
      ]
    },
    {
      "code" : "0482",
      "display" : "Order Type",
      "definition" : "HL7-defined table of codes specifying whether the order is to be executed in an inpatient setting or an outpatient setting.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.482"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.307"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0482"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.323"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0482"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrderType"
        }
      ]
    },
    {
      "code" : "0483",
      "display" : "Authorization Mode",
      "definition" : "HL7-defined table of codes of forms of authorization a recorder may receive from the responsible practitioner to create or change an order.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.483"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.308"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0483"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.324"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0483"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-30"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AuthorizationMode"
        }
      ]
    },
    {
      "code" : "0484",
      "display" : "Dispense Type",
      "definition" : "Table of codes specifying the type of dispensing event that occurred.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.484"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.309"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0484"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.325"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0484"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXD-33"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DispenseType"
        }
      ]
    },
    {
      "code" : "0485",
      "display" : "Extended Priority Codes",
      "definition" : "Table of codes describing the urgency of a request carried in an order. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns illustrating the syntax used to construct expressions using the codes and other modifiers.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.485"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.310"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0485"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.326"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0485"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ1-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ExtendedPriorityCodes"
        }
      ]
    },
    {
      "code" : "0487",
      "display" : "Specimen Type",
      "definition" : "HL7-defined table of codes that describe the precise nature of an entity that may be used as the source material for an observation.  This is one of two code systems that are used instead of table 0070 (code system 2.16.840.1.113883.18.28) which conflated specimen types and specimen collection methods.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.487"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.311"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0487"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.327"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0487"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenType"
        }
      ]
    },
    {
      "code" : "0488",
      "display" : "Specimen Collection Method",
      "definition" : "HL7-defined table of codes specifying the specimen collection method.   Used in Version 2 messaging in the SPM segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.488"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.312"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0488"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.328"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0488"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenCollectionMethod"
        }
      ]
    },
    {
      "code" : "0489",
      "display" : "Risk Codes",
      "definition" : "Table of codes specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.489"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.313"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0489"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.329"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0489"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-16, PAC-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RiskCodes"
        }
      ]
    },
    {
      "code" : "0490",
      "display" : "Specimen Reject Reason",
      "definition" : "HL7-defined table of codes specifying the reasons a specimen may be rejected for a specified observation/result/analysis.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.490"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.314"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0490"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.330"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0490"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenRejectReason"
        }
      ]
    },
    {
      "code" : "0491",
      "display" : "Specimen Quality",
      "definition" : "Table of codes specifying the degree or grade of excellence of the specimen at receipt.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.491"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.315"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0491"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.331"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0491"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenQuality"
        }
      ]
    },
    {
      "code" : "0492",
      "display" : "Specimen Appropriateness",
      "definition" : "Table of codes specifying the suitability of the specimen for the particular planned use as determined by the filler.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.492"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.316"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0492"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.332"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0492"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenAppropriateness"
        }
      ]
    },
    {
      "code" : "0493",
      "display" : "Specimen Condition",
      "definition" : "Table of codes specifying a mode or state of being that describes the nature of the specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.493"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.317"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0493"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.333"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0493"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-24"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenCondition"
        }
      ]
    },
    {
      "code" : "0494",
      "display" : "Specimen Child Role",
      "definition" : "HL7-defined table of codes specifying for child specimens the relationship between this specimen and the parent specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.494"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.318"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0494"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.334"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0494"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenChildRole"
        }
      ]
    },
    {
      "code" : "0495",
      "display" : "Body Site Modifier",
      "definition" : "HL7-defined table of codes specifying the modifier for the body site.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.495"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.319"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0495"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.335"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0495"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXR-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BodySiteModifier"
        }
      ]
    },
    {
      "code" : "0496",
      "display" : "Consent Type",
      "definition" : "Table of codes specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.496"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.320"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0496"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.336"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0496"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA:2; CON:2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentType"
        }
      ]
    },
    {
      "code" : "0497",
      "display" : "Consent Mode",
      "definition" : "HL7-defined table of codes specifying the method in which a subject provides consent.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.497"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.321"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0497"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.337"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0497"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA:10; CON:10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentMode"
        }
      ]
    },
    {
      "code" : "0498",
      "display" : "Consent Status",
      "definition" : "HL7-defined table of codes specifying whether the consent has been sought and granted.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.498"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.322"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0498"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.338"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0498"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TXA:11; CON:11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentStatus"
        }
      ]
    },
    {
      "code" : "0499",
      "display" : "Consent Bypass Reason",
      "definition" : "Table of codes specifying the reason the subject's consent was not sought.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.499"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.323"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0499"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.339"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0499"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentBypassReason"
        }
      ]
    },
    {
      "code" : "0500",
      "display" : "Consent Disclosure Level",
      "definition" : "HL7-defined table of codes used to specify how much information was disclosed to the subject as part of the informed consent process.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.500"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.324"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0500"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.340"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0500"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentDisclosureLevel"
        }
      ]
    },
    {
      "code" : "0501",
      "display" : "Consent Non-Disclosure Reason",
      "definition" : "Table of codes used to specify a reason the subject did not receive full disclosure.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.501"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.325"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0501"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.341"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0501"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ConsentNon-disclosureReason"
        }
      ]
    },
    {
      "code" : "0502",
      "display" : "Non-Subject Consenter Reason",
      "definition" : "HL7-defined table of codes used to specify a reason consent was granted by a person other than the subject of the consent.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.502"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.326"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0502"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.342"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0502"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Non-subjectConsenterReason"
        }
      ]
    },
    {
      "code" : "0503",
      "display" : "Sequence/Results Flag",
      "definition" : "HL7-defined table of codes used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.503"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.327"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0503"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.343"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0503"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ2-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Sequence_ResultsFlag"
        }
      ]
    },
    {
      "code" : "0504",
      "display" : "Sequence Condition Code",
      "definition" : "HL7-defined table of codes used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.504"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.328"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0504"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.344"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0504"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ2-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SequenceConditionCode"
        }
      ]
    },
    {
      "code" : "0505",
      "display" : "Cyclic Entry/Exit Indicator",
      "definition" : "HL7-defined table of codes used to specify if this service request is the first or last service request in a cyclic series of service requests.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.505"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.329"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0505"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.345"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0505"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ2-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CyclicEntry_ExitIndicator"
        }
      ]
    },
    {
      "code" : "0506",
      "display" : "Service Request Relationship",
      "definition" : "HL7-defined table of codes used to specify an additional or alternate relationship between this service request and other service requests.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.506"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.330"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0506"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.346"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0506"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TQ2-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ServiceRequestRelationship"
        }
      ]
    },
    {
      "code" : "0507",
      "display" : "Observation Result Handling",
      "definition" : "Table of codes regarding the handling of a result.  For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.507"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.331"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0507"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.347"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0507"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-49"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ObservationResultHandling"
        }
      ]
    },
    {
      "code" : "0508",
      "display" : "Blood Product Processing Requirements",
      "definition" : "Table of codes used to specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.508"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.332"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0508"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.348"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0508"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BPO-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BloodProductProcessingRequirements"
        }
      ]
    },
    {
      "code" : "0509",
      "display" : "Indication for Use",
      "definition" : "Table of codes that specify the reason the blood product was ordered.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.509"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BPO-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IndicationForUse"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0509"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0509"
        }
      ]
    },
    {
      "code" : "0510",
      "display" : "Blood Product Dispense Status",
      "definition" : "HL7-defined table of codes used to specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product.  When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been \"dispensed\".",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.510"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.333"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0510"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.349"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0510"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BPX-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BloodProductDispenseStatus"
        }
      ]
    },
    {
      "code" : "0511",
      "display" : "BP Observation Status Codes Interpretation",
      "definition" : "HL7-defined table of codes used to specify the interpretation for the blood product observation status codes.  A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary.  However, once the product is transfused, the status would be considered final.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.511"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.334"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0511"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.350"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0511"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BPX-3, BTX-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BpObservationStatusCodesInterpretation"
        }
      ]
    },
    {
      "code" : "0512",
      "display" : "Commercial Product",
      "definition" : "Table of codes that specify a commercial product.  Examples of commercial products are blood derivatives such as Rh Immune Globulin and Factor VIII concentrate, Leukoreduction filters and blood administration sets.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.512"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BPX-8, BTX-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CommercialProduct"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0512"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0512"
        }
      ]
    },
    {
      "code" : "0513",
      "display" : "Blood Product Transfusion/Disposition Status",
      "definition" : "HL7-defined table of codes used to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.513"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.335"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0513"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.351"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0513"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BTX-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BloodProductTransfusion_DispositionStatus"
        }
      ]
    },
    {
      "code" : "0514",
      "display" : "Transfusion Adverse Reaction",
      "definition" : "Table of codes used to specify the type of adverse reaction that the recipient of the blood product experienced.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.514"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.336"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0514"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.352"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0514"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BTX-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransfusionAdverseReaction"
        }
      ]
    },
    {
      "code" : "0515",
      "display" : "Transfusion Interrupted Reason",
      "definition" : "Table of codes that specify the reason the transfusion of the blood product was interrupted.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.515"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BTX-19"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransfusionInterruptedReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0515"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0515"
        }
      ]
    },
    {
      "code" : "0516",
      "display" : "Error Severity",
      "definition" : "HL7-defined table of codes specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.516"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.337"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0516"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.353"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0516"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ErrorSeverity"
        }
      ]
    },
    {
      "code" : "0517",
      "display" : "Inform Person Code",
      "definition" : "Table of codes used to specify who (if anyone) should be informed of the error.  This field may also be used to indicate that a particular person should NOT be informed of the error (e.g. do not inform patient.)",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.517"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.338"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0517"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.354"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0517"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InformPersonCode"
        }
      ]
    },
    {
      "code" : "0518",
      "display" : "Override Type",
      "definition" : "Table of codes used to specify what type of override can be used to override the specific error identified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.518"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.339"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0518"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.355"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0518"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-10, OVR-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OverrideType"
        }
      ]
    },
    {
      "code" : "0519",
      "display" : "Override Reason",
      "definition" : "Table of codes that specify the override codes that can be used to override enforcement of the application rule that generated an error.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.519"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OverrideReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0519"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0519"
        }
      ]
    },
    {
      "code" : "0520",
      "display" : "Message Waiting Priority",
      "definition" : "HL7-defined table of codes used to specify how important the most important waiting mesasge is.  For example, if there are 3 low priority messages, 1 medium priority message and 1 high priority message, the message waiting priority would be \"high\", because that is the highest priority of any new message waiting.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.520"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.340"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0520"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.356"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0520"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSA-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2MessageWaitingPriority"
        }
      ]
    },
    {
      "code" : "0521",
      "display" : "Override Code",
      "definition" : "Table of codes that specify the reason for the business rule override.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.521"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OVR-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OverrideCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0521"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0521"
        }
      ]
    },
    {
      "code" : "0523",
      "display" : "Computation Type",
      "definition" : "HL7-defined table of codes used to specify if the change is computed as a percent change or as an absolute change.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.523"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.341"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0523"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.357"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0523"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DLT.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ComputationType"
        }
      ]
    },
    {
      "code" : "0524",
      "display" : "Sequence condition",
      "definition" : "HL7-defined table of codes that identify whether sequence conditions or a repeating cycle of orders is defined.   This is part of the Order Sequence Definition.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.524"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.342"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0524"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.358"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0524"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SequenceCondition"
        }
      ]
    },
    {
      "code" : "0525",
      "display" : "Privilege",
      "definition" : "Table of codes that specify the institutional privilege.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.525"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PIP.1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Privilege"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0525"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0525"
        }
      ]
    },
    {
      "code" : "0526",
      "display" : "Privilege Class",
      "definition" : "Table of codes that specify the class category of institutional privilege.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.526"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PIP.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PrivilegeClass"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0526"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0526"
        }
      ]
    },
    {
      "code" : "0527",
      "display" : "Calendar Alignment",
      "definition" : "HL7-defined table of codes used to specify an alignment of the repetition to a calendar (e.g., to distinguish every  30 days from \"the 5th of every month\").",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.527"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.343"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0527"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.359"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0527"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RPT.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CalendarAlignment"
        }
      ]
    },
    {
      "code" : "0528",
      "display" : "Event Related Period",
      "definition" : "HL7-defined table of codes used to specify a common (periodical) activity of daily living.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.528"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.344"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0528"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.360"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0528"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RPT.8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EventRelatedPeriod"
        }
      ]
    },
    {
      "code" : "0529",
      "display" : "Precision",
      "definition" : "HL7-defined table of concepts used to specify the degree of precision of the time stamp.   Table is no longer published as part of the released Standard after version 2.5.1.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.529"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.345"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0529"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.361"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0529"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Precision"
        }
      ]
    },
    {
      "code" : "0530",
      "display" : "Organization, Agency, Department",
      "definition" : "Table of codes used to specify the agency or department that assigned the identifier in component 1.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.530"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.346"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0530"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.362"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0530"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.10, PPN.24, XCN.23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Organization_Agency_Department"
        }
      ]
    },
    {
      "code" : "0531",
      "display" : "Institution",
      "definition" : "Table of codes that specify the institution where a staff member is or was active.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.531"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DIN.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Institution"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0531"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0531"
        }
      ]
    },
    {
      "code" : "0532",
      "display" : "Expanded Yes/no Indicator",
      "definition" : "HL7-defined table of codes used to specify an expansion on the original Yes/No indicator table by including \"flavors of null\".  It is intended to be applied to fields where the response is not limited to \"yes\" or \"no\".",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.532"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.347"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0532"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.363"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0532"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "Numerous locations"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ExpandedYes_NoIndicator"
        }
      ]
    },
    {
      "code" : "0533",
      "display" : "Application Error Code",
      "definition" : "Table of codes that specify the application specific code identifying the specific error that occurred.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.533"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ERR-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ApplicationErrorCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0533"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0533"
        }
      ]
    },
    {
      "code" : "0534",
      "display" : "Notify Clergy Code",
      "definition" : "Table of codes used to specify whether the clergy should be notified.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.534"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.348"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0534"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.364"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0534"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PV2-49"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NotifyClergyCode"
        }
      ]
    },
    {
      "code" : "0535",
      "display" : "Signature Code",
      "definition" : "Table of codes that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.535"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.349"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0535"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.365"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0535"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN1-50"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SignatureCode"
        }
      ]
    },
    {
      "code" : "0536",
      "display" : "Certificate Status",
      "definition" : "Table of codes used to specify the status of the certificate held by the health professional.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.536"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.350"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0536"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.366"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0536"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CER-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificateStatus"
        }
      ]
    },
    {
      "code" : "0537",
      "display" : "Institution",
      "definition" : "Table of codes that specify the institution the practitioner began or intends to begin practicing at (e.g., at hospital, at physician organization, at managed care network).  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.537"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRA-9, STF-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Institution2"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0537"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0537"
        }
      ]
    },
    {
      "code" : "0538",
      "display" : "Institution Relationship Type",
      "definition" : "Table of codes used to specify the relationship the staff person has with the institution for whom he/she provides services.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.538"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.351"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0538"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.367"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0538"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-33"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InstitutionRelationshipType"
        }
      ]
    },
    {
      "code" : "0539",
      "display" : "Cost Center Code",
      "definition" : "Table of codes that specify the organization unit in the General Ledger to which the staff member is currently assigned.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.539"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-36"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CostCenterCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0539"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0539"
        }
      ]
    },
    {
      "code" : "0540",
      "display" : "Inactive Reason Code",
      "definition" : "Table of codes used to specify the reason the staff member is inactive.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.540"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.352"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0540"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.368"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0540"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-38"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InactiveReasonCode"
        }
      ]
    },
    {
      "code" : "0541",
      "display" : "Specimen Type Modifier",
      "definition" : "Table of codes that specify the modifying or qualifying description(s) about the specimen type.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.541"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenTypeModifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0541"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0541"
        }
      ]
    },
    {
      "code" : "0542",
      "display" : "Specimen Source Type Modifier",
      "definition" : "Table of codes that specify the modifying or qualifying description(s) about the specimen source site.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.542"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenSourceTypeModifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0542"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0542"
        }
      ]
    },
    {
      "code" : "0543",
      "display" : "Specimen Collection Site",
      "definition" : "Table of codes that specify the modifying or qualifying description(s) about the specimen collection site.  This field differs from Specimen Source Site in those cases where the source site must be approached via a particular site (e.g., anatomic location). For example, in the case where a liver biopsy is obtained via a percutaneous needle, the collection site would be the point of entry of the needle. For venous blood collected from the left radial vein, the collection site could be “antecubital fossa”.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.543"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SpecimenCollectionSite"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0543"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0543"
        }
      ]
    },
    {
      "code" : "0544",
      "display" : "Container Condition",
      "definition" : "HL7-defined table of codes used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.544"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.353"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0544"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.369"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0544"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SPM-28, SHP-9, PAC-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerCondition"
        }
      ]
    },
    {
      "code" : "0545",
      "display" : "Language Translated To",
      "definition" : "Table of codes that specify the language to which the consent material must be translated.  Used in the Consent (CON) segment in Version 2 messaging.  Table is no longer published as part of the released Standard after version 2.5.1.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.545"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Language"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0545"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0545"
        }
      ]
    },
    {
      "code" : "0547",
      "display" : "Jurisdictional Breadth",
      "definition" : "Table of codes used to specify the breadth/extent of the jurisdiction where the qualification is valid.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.547"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.354"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0547"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.370"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0547"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CER-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "JurisdictionalBreadth"
        }
      ]
    },
    {
      "code" : "0548",
      "display" : "Signatory's Relationship to Subject",
      "definition" : "Table of codes used to specify the relationship of the consenter to the subject.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.548"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.355"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0548"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.371"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0548"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "sd"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CON:25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SignatorysRelationshipToSubject"
        }
      ]
    },
    {
      "code" : "0549",
      "display" : "NDC Codes",
      "definition" : "Table of codes that specify the National Drug Codes (NDC) that are required by the Health Insurance Portability and Accountability Act (HIPAA) for electronic claims for pharmacy charges.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.549"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "NdcCodes"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0549"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0549"
        }
      ]
    },
    {
      "code" : "0550",
      "display" : "Body Parts",
      "definition" : "HL7-defined table of codes used to specify the part of the body.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.550"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.356"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0550"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.372"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0550"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXR-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BodyParts"
        }
      ]
    },
    {
      "code" : "0552",
      "display" : "Advanced Beneficiary Notice Override Reason",
      "definition" : "Table of codes that specify the reason the patient did not sign an Advanced Beneficiary Notice.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.552"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.5"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdvancedBeneficiaryNoticeOverrideReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0552"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0552"
        }
      ]
    },
    {
      "code" : "0553",
      "display" : "Invoice Control Code",
      "definition" : "Table of codes used to specify what invoice action is being performed by this message.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.553"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.357"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0553"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.373"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0553"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVC-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InvoiceControlCode"
        }
      ]
    },
    {
      "code" : "0554",
      "display" : "Invoice Reason Codes",
      "definition" : "Table of codes used to specify the reason for an invoice.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.554"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.358"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0554"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.374"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0554"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVC-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InvoiceReasonCodes"
        }
      ]
    },
    {
      "code" : "0555",
      "display" : "Invoice Type",
      "definition" : "Table of codes used to specify the type of invoice.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.555"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.359"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0555"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.375"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0555"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVC-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InvoiceType"
        }
      ]
    },
    {
      "code" : "0556",
      "display" : "Benefit Group",
      "definition" : "Table of codes used to specify the benefit group.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.556"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.360"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0556"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.376"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0556"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVC-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BenefitGroup"
        }
      ]
    },
    {
      "code" : "0557",
      "display" : "Payee Type",
      "definition" : "Table of codes used to specify the type of payee (e.g., organization, person).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.557"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.361"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0557"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.377"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0557"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PYE-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PayeeType"
        }
      ]
    },
    {
      "code" : "0558",
      "display" : "Payee Relationship to Invoice",
      "definition" : "Table of codes used to specify the relationship to the invoice for Person Payee Types.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.558"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.362"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0558"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.378"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0558"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PYE-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PayeeRelationshipToInvoice"
        }
      ]
    },
    {
      "code" : "0559",
      "display" : "Product/Service Status",
      "definition" : "Table of codes used to specify the processing status for the Product/Service Code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.559"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.363"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0559"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.379"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0559"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PLS-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Product_ServiceStatus"
        }
      ]
    },
    {
      "code" : "0560",
      "display" : "Quantity Units",
      "definition" : "Table of codes that specify the adjustment quantity.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.560"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.380"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.455"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0560"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0560"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ADJ-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "QuantityUnits"
        }
      ]
    },
    {
      "code" : "0561",
      "display" : "Product/Services Clarification Codes",
      "definition" : "Table of codes used to specify the Product/Service Code.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.561"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.364"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0561"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.381"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0561"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Product_ServicesClarificationCodes"
        }
      ]
    },
    {
      "code" : "0562",
      "display" : "Processing Consideration Codes",
      "definition" : "Table of codes used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.562"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.365"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0562"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.382"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0562"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessingConsiderationCodes"
        }
      ]
    },
    {
      "code" : "0564",
      "display" : "Adjustment Category Code",
      "definition" : "Table of codes used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.564"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.366"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0564"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.383"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0564"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ADJ-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdjustmentCategoryCode"
        }
      ]
    },
    {
      "code" : "0565",
      "display" : "Provider Adjustment Reason Code",
      "definition" : "Table of codes used to specify the reason for this adjustment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.565"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.367"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0565"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.384"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0565"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ADJ-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProviderAdjustmentReasonCode"
        }
      ]
    },
    {
      "code" : "0566",
      "display" : "Blood Unit Type",
      "definition" : "HL7-defined table of codes used to specify the type of blood unit",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.566"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.368"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0566"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.385"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0566"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BUI-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BloodUnitType"
        }
      ]
    },
    {
      "code" : "0567",
      "display" : "Weight Units",
      "definition" : "Weight Units.  Note this table has been deprecated and is replacaced by table 0929.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.567"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.452"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0929"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "replaced by 0929"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WeightUnits"
        }
      ]
    },
    {
      "code" : "0568",
      "display" : "Volume Units",
      "definition" : "Volume Units Note this table has been deprecated and is replacaced by table 0930.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.568"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.453"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0930"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-codes-table-comment",
          "valueString" : "replaced by 0930"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VolumeUnits"
        }
      ]
    },
    {
      "code" : "0569",
      "display" : "Adjustment Action",
      "definition" : "Table of codes used to specify the action requested of a party that receives an adjustment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.569"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.369"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0569"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.386"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0569"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ADJ-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AdjustmentAction"
        }
      ]
    },
    {
      "code" : "0570",
      "display" : "Payment Method Code",
      "definition" : "Table of codes used to specify the method for the movement of payment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.570"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.370"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0570"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.387"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0570"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PMT-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PaymentMethodCode"
        }
      ]
    },
    {
      "code" : "0571",
      "display" : "Invoice Processing Results Status",
      "definition" : "Table of codes used to specify the processing status for an Invoice Processing Result.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.571"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.371"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0571"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.388"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0571"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IPR-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "InvoiceProcessingResultsStatus"
        }
      ]
    },
    {
      "code" : "0572",
      "display" : "Tax status",
      "definition" : "Table of codes used to specify the tax status of a provider.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.572"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.372"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0572"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.389"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0572"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVC-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TaxStatus"
        }
      ]
    },
    {
      "code" : "0615",
      "display" : "User Authentication Credential Type Code",
      "definition" : "HL7-defined table of codes specifying a type of user authentication credential.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.615"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.373"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0615"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.390"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0615"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "UAC-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "UserAuthenticationCredentialTypeCode"
        }
      ]
    },
    {
      "code" : "0616",
      "display" : "Address Expiration Reason",
      "definition" : "Table of codes specifying the reason this address was marked as \"ended\".",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.616"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.374"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0616"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.391"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0616"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AddressExpirationReason"
        }
      ]
    },
    {
      "code" : "0617",
      "display" : "Address Usage",
      "definition" : "HL7-defined table of codes specifying how an address is intended to be used.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.617"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.375"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0617"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.392"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0617"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AddressUsage"
        }
      ]
    },
    {
      "code" : "0618",
      "display" : "Protection Code",
      "definition" : "Table of codes specifying that an address needs to be treated with special care or sensitivity.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.618"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.376"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0618"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.393"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0618"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XAD.22, XTN.16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProtectionCode"
        }
      ]
    },
    {
      "code" : "0625",
      "display" : "Item Status Codes",
      "definition" : "Table of codes specifying the state of an inventory item within the context of an inventory location.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.625"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.377"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0625"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.394"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0625"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVT-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ItemStatusCodes"
        }
      ]
    },
    {
      "code" : "0634",
      "display" : "Item Importance Codes",
      "definition" : "Table of codes that denote a level or importance of an inventory item within the context of an inventory location.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.634"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.378"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0634"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.395"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0634"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVT-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ItemImportanceCodes"
        }
      ]
    },
    {
      "code" : "0642",
      "display" : "Reorder Theory Codes",
      "definition" : "Table of codes specifying the calculation method used to determine the resupply schedule.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.642"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.379"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0642"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.396"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0642"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IVT-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReorderTheoryCodes"
        }
      ]
    },
    {
      "code" : "0651",
      "display" : "Labor Calculation Type",
      "definition" : "Table of codes specifying the method used to calculate employee labor and measure employee productivity.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.651"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.380"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0651"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.397"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0651"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCP-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LaborCalculationType"
        }
      ]
    },
    {
      "code" : "0653",
      "display" : "Date Format",
      "definition" : "Table of codes specifying the date format for a decontamination/sterilization instance.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.653"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.381"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0653"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.398"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0653"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCP-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DateFormat"
        }
      ]
    },
    {
      "code" : "0657",
      "display" : "Device Type",
      "definition" : "Table of codes specifying the kind of device as defined by the manufacturer.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.657"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.382"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0657"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.399"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0657"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCP-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceType"
        }
      ]
    },
    {
      "code" : "0659",
      "display" : "Lot Control",
      "definition" : "Table of codes specifying whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.659"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.383"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0659"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.400"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0659"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCP-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LotControl"
        }
      ]
    },
    {
      "code" : "0667",
      "display" : "Device Data State",
      "definition" : "Table of codes specifying the state of the data as provided from a device.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.667"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.384"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0667"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.401"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0667"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SDD-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceDataState"
        }
      ]
    },
    {
      "code" : "0669",
      "display" : "Load Status",
      "definition" : "Table of codes specifying the status of the information provided in a device sterilization or decontamination cycle.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.669"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.385"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0669"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.402"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0669"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SDD-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LoadStatus"
        }
      ]
    },
    {
      "code" : "0682",
      "display" : "Device Status",
      "definition" : "Table of codes specifying the state of a device.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.682"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.386"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0682"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.403"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0682"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCD-10"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceStatus"
        }
      ]
    },
    {
      "code" : "0702",
      "display" : "Cycle Type",
      "definition" : "Table of codes specifying the type of cycle that is being executed.  A cycle type is a specific sterilization method used for a specific type of supply item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.702"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.387"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0702"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.404"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0702"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SCD-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CycleType"
        }
      ]
    },
    {
      "code" : "0717",
      "display" : "Access Restriction Value",
      "definition" : "Table of codes specifying the policies governing the information to which access is controlled.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.717"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.388"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0717"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.405"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0717"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ARV-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AccessRestrictionValue"
        }
      ]
    },
    {
      "code" : "0719",
      "display" : "Access Restriction Reason Code",
      "definition" : "Table of codes specifying the reason for the restricted access.  Note these codes are maintained within HL7, but outside of Version 2.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.719"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.5.4"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.1.11.20428"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v3-InformationSensitivityPolicy"
        },
        {
          "code" : "v2-cld",
          "valueString" : "3"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ARV-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AccessRestrictionReasonCode"
        }
      ]
    },
    {
      "code" : "0725",
      "display" : "Mood Codes",
      "definition" : "HL7-defined table of codes specifying the functional state of an order.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.725"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.5.1001"
        },
        {
          "code" : "v2cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v3-ActMood"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.407"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0725"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXO-31, OBX-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MoodCodes"
        }
      ]
    },
    {
      "code" : "0728",
      "display" : "CCL Value",
      "definition" : "Table of codes specifying the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis.  US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.728"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.391"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0728"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.408"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0728"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-23"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CclValue"
        }
      ]
    },
    {
      "code" : "0731",
      "display" : "DRG Diagnosis Determination Status",
      "definition" : "HL7-defined table of codes specifying the status of a diagnosis for a diagnosis related group (DRG) determination. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.731"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.392"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0731"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.409"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0731"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgDiagnosisDeterminationStatus"
        }
      ]
    },
    {
      "code" : "0734",
      "display" : "Grouper Status",
      "definition" : "Table of codes specifying the status of a grouper in general. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.734"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.393"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0734"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.410"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0734"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "GrouperStatus"
        }
      ]
    },
    {
      "code" : "0739",
      "display" : "DRG Status Patient",
      "definition" : "Table of codes specifying whether the length of stay is normal or respectively shorter or longer than normal.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.739"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.394"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0739"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.411"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0739"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-17"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgStatusPatient"
        }
      ]
    },
    {
      "code" : "0742",
      "display" : "DRG Status Financial Calculation",
      "definition" : "Table of codes specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.742"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.395"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0742"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.412"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0742"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgStatusFinancialCalculation"
        }
      ]
    },
    {
      "code" : "0749",
      "display" : "DRG Grouping Status",
      "definition" : "Table of codes specifying the status of the use of the gender information for diagnosis related group (DRG) determination. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.749"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.396"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0749"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.413"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0749"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgGroupingStatus"
        }
      ]
    },
    {
      "code" : "0755",
      "display" : "Status Weight At Birth",
      "definition" : "Table of codes specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination.  US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.755"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.397"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0755"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.414"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0755"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StatusWeightAtBirth"
        }
      ]
    },
    {
      "code" : "0757",
      "display" : "DRG Status Respiration Minutes",
      "definition" : "Table of codes specifying the status of the use of the respiration minutes information for diagnosis related group (DRG) determination.  US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.757"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.398"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0757"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.415"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0757"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-32"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DrgStatusRespirationMinutes"
        }
      ]
    },
    {
      "code" : "0759",
      "display" : "Status Admission",
      "definition" : "Table of codes specifying the admission status for the diagnosis related group (DRG) determination. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.759"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.399"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0759"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.416"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0759"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DRG-33"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "StatusAdmission"
        }
      ]
    },
    {
      "code" : "0761",
      "display" : "DRG Procedure Determination Status",
      "definition" : "Table of codes specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination.  US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.761"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.400"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0761"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.417"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0761"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DRGProcedureDeterminationStatus"
        }
      ]
    },
    {
      "code" : "0763",
      "display" : "DRG Procedure Relevance",
      "definition" : "Table of codes specifying the relevance of this particular procedure for the diagnosis related group (DRG) determination. US Realm.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.763"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.401"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0763"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.418"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0763"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PR1-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DRGProcedureRelevance"
        }
      ]
    },
    {
      "code" : "0771",
      "display" : "Resource Type or Category",
      "definition" : "Table of codes specifying a high level categorization of resources.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.771"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pa"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STF-39"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ResourceTypeOrCategory"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0771"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0771"
        }
      ]
    },
    {
      "code" : "0776",
      "display" : "Item Status",
      "definition" : "Table of codes specifying the status (useful for reporting and item usage purposes) that applies to an item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.776"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.402"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0776"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.419"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0776"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "mnm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ITM-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ItemStatus"
        }
      ]
    },
    {
      "code" : "0778",
      "display" : "Item Type",
      "definition" : "Table of codes specifying a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.778"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.403"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0778"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.420"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0778"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ITM-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ItemType"
        }
      ]
    },
    {
      "code" : "0790",
      "display" : "Approving Regulatory Agency",
      "definition" : "Table of codes specifying the regulatory agency by which the item has been approved, such as the FDA or AMA.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.790"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.404"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0790"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.421"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0790"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ITM-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ApprovingRegulatoryAgency"
        }
      ]
    },
    {
      "code" : "0793",
      "display" : "Ruling Act",
      "definition" : "Table of codes specifying an act containing a rule that the item is legally required to be included in notification reporting.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.793"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.405"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0793"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.422"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0793"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ITM-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RulingAct"
        }
      ]
    },
    {
      "code" : "0806",
      "display" : "Sterilization Type",
      "definition" : "Table of codes specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.806"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.406"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0806"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.423"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0806"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STZ-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SterilizationType"
        }
      ]
    },
    {
      "code" : "0809",
      "display" : "Maintenance Cycle",
      "definition" : "Table of codes specifying the maintenance cycle used for the inventory supply item, such as the number of times to sharpen after five uses.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.809"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STZ-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MaintenanceCycle"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0809"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0809"
        }
      ]
    },
    {
      "code" : "0811",
      "display" : "Maintenance Type",
      "definition" : "Table of codes specifying the type of maintenance performed on the inventory supply item.  This is different than the maintenance cycle in the sense that it can describe the number of maintenance cycles that can be performed before disposing of the inventory supply item.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.811"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "STZ-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MaintenanceType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0811"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0811"
        }
      ]
    },
    {
      "code" : "0818",
      "display" : "Package",
      "definition" : "Table of codes specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.818"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.407"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0818"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.424"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0818"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PKG-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Package"
        }
      ]
    },
    {
      "code" : "0834",
      "display" : "MIME Types",
      "definition" : "Table of codes specifying the general type of data.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.834"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.408"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0834"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.425"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-notAllCodes-0834"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Imported"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RP.3, ED.2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MimeTypes"
        }
      ]
    },
    {
      "code" : "0836",
      "display" : "Problem Severity",
      "definition" : "Table of codes specifying the severity of the problem.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.836"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProblemSeverity"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0836"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0836"
        }
      ]
    },
    {
      "code" : "0838",
      "display" : "Problem Perspective",
      "definition" : "Table of codes specifying from whose perspective this problem was identified.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.838"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProblemPerspective"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0838"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0838"
        }
      ]
    },
    {
      "code" : "0865",
      "display" : "Referral Documentation Completion Status",
      "definition" : "Table of codes specifying to the receiving provider that the clinical history in the message is incomplete and that more will follow.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.865"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RF1-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ReferralDocumentationCompletionStatus"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0865"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0865"
        }
      ]
    },
    {
      "code" : "0868",
      "display" : "Telecommunication Expiration Reason",
      "definition" : "Table of codes specifying the reason this contact number/email was marked as \"ended\".",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.868"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.409"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0868"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.426"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0868"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "XTN.15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TelecommunicationExpirationReason"
        }
      ]
    },
    {
      "code" : "0871",
      "display" : "Supply Risk Codes",
      "definition" : "Table of codes specifying any known or suspected hazard associated with this material item.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.871"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.410"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0871"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.427"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0871"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ITM-15"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SupplyRiskCodes"
        }
      ]
    },
    {
      "code" : "0879",
      "display" : "Product/Service Code",
      "definition" : "Table of codes specifying what service was delivered/received.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.879"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-7, PSL-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Product_ServiceCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0879"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0879"
        }
      ]
    },
    {
      "code" : "0880",
      "display" : "Product/Service Code Modifier",
      "definition" : "Table of codes specifying additional optional modifier(s) for the Product/Service Code (e.g., after hours - evening, after hours - weekend).  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.880"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Product_ServiceCodeModifier"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0880"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0880"
        }
      ]
    },
    {
      "code" : "0881",
      "display" : "Role Executing Physician",
      "definition" : "Table of codes specifying the account role of the physician, for example, only billing for the professional part, the technical part or both.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.881"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.411"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0881"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.428"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0881"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RoleExecutingPhysician"
        }
      ]
    },
    {
      "code" : "0882",
      "display" : "Medical Role Executing Physician",
      "definition" : "Table of codes specifying the role of the physician (\"self-employed\" or \"employed\").",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.882"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.412"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0882"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.429"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0882"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-32"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MedicalRoleExecutingPhysician"
        }
      ]
    },
    {
      "code" : "0894",
      "display" : "Side of body",
      "definition" : "Table of codes specifying the side of the body (\"left\" or \"right\").",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.894"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.413"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0894"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.430"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0894"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PSL-33"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SideOfBody"
        }
      ]
    },
    {
      "code" : "0895",
      "display" : "Present On Admission (POA) Indicator",
      "definition" : "Table of codes specifying the present on admission indicator for this particular diagnosis. US reimbursement formulas for some states and Medicare have mandated that each diagnosis code be flagged as to whether it was present on admission or not.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.895"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.301.11"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0895"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.431"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0895"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DG1-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "4"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.6"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PresentOnAdmissionIndicator"
        }
      ]
    },
    {
      "code" : "0904",
      "display" : "Security Check Scheme",
      "definition" : "HL7-defined table of codes specifying the scheme for the security check.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.904"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.415"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0904"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.432"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0904"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CX.12, PPN.26, XCN.25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SecurityCheckScheme"
        }
      ]
    },
    {
      "code" : "0905",
      "display" : "Shipment Status",
      "definition" : "HL7-defined table of codes specifying the status of the shipment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.905"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.416"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0905"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.433"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0905"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SHP-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ShipmentStatus"
        }
      ]
    },
    {
      "code" : "0906",
      "display" : "ActPriority",
      "definition" : "HL7-defined table of codes specifying the priority for the shipment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.906"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.417"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0906"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.434"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0906"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SHP-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ActPriority"
        }
      ]
    },
    {
      "code" : "0907",
      "display" : "Confidentiality",
      "definition" : "HL7-defined table of codes specifying the confidentiality for the shipment.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.907"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.418"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0907"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.435"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0907"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SHP-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2Confidentiality"
        }
      ]
    },
    {
      "code" : "0908",
      "display" : "Package Type",
      "definition" : "Table of codes specifying the type of package.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.908"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PAC-5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PackageType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0908"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0908"
        }
      ]
    },
    {
      "code" : "0909",
      "display" : "Patient Results Release Categorization Scheme",
      "definition" : "HL7-defined table of codes specifying the scheme for the patient results release categorization.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.909"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.419"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0909"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.436"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0909"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PatientResultsReleaseCategorizationScheme"
        }
      ]
    },
    {
      "code" : "0910",
      "display" : "Acquisition Modality",
      "definition" : "Table of codes specifying the modality for the acquisition. Suggest using values from DICOM.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.910"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-47"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "AcquisitionModality"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0910"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0910"
        }
      ]
    },
    {
      "code" : "0912",
      "display" : "Participation",
      "definition" : "HL7-defined table of codes that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.912"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.420"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0912"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.438"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0912"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "PRT-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Participation"
        }
      ]
    },
    {
      "code" : "0913",
      "display" : "Monetary Denomination Code",
      "definition" : "Table of codes specifying the denomination in which the quantity is expressed. The values for the denomination component are the three-character codes specified in  ISO-4217 (1.0.4217 iso4217).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.913"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "1.0.4217"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MO.2, MOP.3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "MonetaryDenominationCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0913"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0913"
        }
      ]
    },
    {
      "code" : "0914",
      "display" : "Root Cause",
      "definition" : "Table of codes specifying the root cause.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.914"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.421"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0914"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.439"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0914"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RootCause"
        }
      ]
    },
    {
      "code" : "0915",
      "display" : "Process Control Code",
      "definition" : "Table of codes specifying the process control code.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.915"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-28"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessControlCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0915"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0915"
        }
      ]
    },
    {
      "code" : "0916",
      "display" : "Relevant Clincial Information",
      "definition" : "Table of codes specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.916"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.422"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0916"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.440"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0916"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.7.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RelevantClinicialInformation"
        }
      ]
    },
    {
      "code" : "0917",
      "display" : "Bolus Type",
      "definition" : "HL7-defined table of codes specifying the type of bolus.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.917"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.423"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0917"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.441"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0917"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXV-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "BolusType"
        }
      ]
    },
    {
      "code" : "0918",
      "display" : "PCA Type",
      "definition" : "HL7-defined table of codes specifying the type of PCA.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.918"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.424"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0918"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.442"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0918"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "RXV-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PcaType"
        }
      ]
    },
    {
      "code" : "0919",
      "display" : "Exclusive Test",
      "definition" : "HL7-defined table of codes that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.919"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.425"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0919"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.443"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0919"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM1-48"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ExclusiveTest"
        }
      ]
    },
    {
      "code" : "0920",
      "display" : "Preferred Specimen/Attribute Status",
      "definition" : "HL7-defined table of codes that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.920"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.426"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0920"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.444"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0920"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OM4-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PreferredSpecimen_AttributeStatus"
        }
      ]
    },
    {
      "code" : "0921",
      "display" : "Certification Type Code",
      "definition" : "Table of codes specifying the code for the certification type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.921"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.427"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0921"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.445"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0921"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-26"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificationTypeCode"
        }
      ]
    },
    {
      "code" : "0922",
      "display" : "Certification Category Code",
      "definition" : "Table of codes specifying the code for the certification category.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.922"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.428"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0922"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.446"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0922"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-27"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CertificationCategoryCode"
        }
      ]
    },
    {
      "code" : "0923",
      "display" : "Process Interruption",
      "definition" : "HL7-defined table of codes specifying whether the process was interrrupted and whether the needle had been inserted in the donor's arm prior to the interruption.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.923"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.429"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0923"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.447"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0923"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessInterruption"
        }
      ]
    },
    {
      "code" : "0924",
      "display" : "Cumulative Dosage Limit UoM",
      "definition" : "Table of codes specifying the unit of measure (UoM) for the cumulative dosage limit.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.924"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.430"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0924"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.448"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0924"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CDO-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CumulativeDosageLimitUom"
        }
      ]
    },
    {
      "code" : "0925",
      "display" : "Phlebotomy Issue",
      "definition" : "HL7-defined table of codes specifying the phlebotomy issue.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.925"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.431"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0925"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.449"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0925"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PhlebotomyIssue"
        }
      ]
    },
    {
      "code" : "0926",
      "display" : "Phlebotomy Status",
      "definition" : "HL7-defined table of codes specifying the status of the phlebotomy.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.926"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.432"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0926"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.450"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0926"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PhlebotomyStatus"
        }
      ]
    },
    {
      "code" : "0927",
      "display" : "Arm Stick",
      "definition" : "HL7-defined table of codes specifying the arm(s) receiving the stick.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.927"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.433"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0927"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.451"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0927"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-22"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ArmStick"
        }
      ]
    },
    {
      "code" : "0929",
      "display" : "Weight Units",
      "definition" : "HL7-defined table of codes specifying the units of weight.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.929"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.452"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0929"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BUI -5"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WeightUnits"
        }
      ]
    },
    {
      "code" : "0930",
      "display" : "Volume Units",
      "definition" : "HL7-defined table of codes specifying the units of volume.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.930"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.453"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0930"
        },
        {
          "code" : "v2-cld",
          "valueString" : "2"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BUI -7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "VolumeUnits"
        }
      ]
    },
    {
      "code" : "0931",
      "display" : "Temperature Units",
      "definition" : "HL7-defined table of codes specifying  the units of transport temperature.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.931"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.454"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0931"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "BUI -12"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TemperatureUnits"
        }
      ]
    },
    {
      "code" : "0932",
      "display" : "Donation Duration Units",
      "definition" : "HL7-defined table of codes specifying the units of donation duration.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.932"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.455"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0932"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.6.8"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://unitsofmeasure.org"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DonationDurationUnits"
        }
      ]
    },
    {
      "code" : "0933",
      "display" : "Intended Procedure Type",
      "definition" : "HL7-defined table of codes specifying the type of intended procedure.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.933"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.434"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0933"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.456"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0933"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "IntendedProcedureType"
        }
      ]
    },
    {
      "code" : "0934",
      "display" : "Order Workflow Profile",
      "definition" : "Table of codes specifying the profile of the order workflow.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.934"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-34"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OrderWorkflowProfile"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0934"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0934"
        }
      ]
    },
    {
      "code" : "0935",
      "display" : "Process Interruption Reason",
      "definition" : "HL7-defined table of codes specifying the reason for the process interruption.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.935"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.435"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0935"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.457"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0935"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DON-13"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ProcessInterruptionReason"
        }
      ]
    },
    {
      "code" : "0936",
      "display" : "Observation Type",
      "definition" : "HL7-defined table of codes specifying types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.936"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.439"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0936"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.460"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0936"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.1"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "V2ObservationType"
        }
      ]
    },
    {
      "code" : "0937",
      "display" : "Observation Sub-Type",
      "definition" : "HL7-defined table of codes specifying the observation sub-type.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.937"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.440"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0937"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.461"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0937"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ObservationSub-type"
        }
      ]
    },
    {
      "code" : "0938",
      "display" : "Collection Event/Process Step Limit",
      "definition" : "HL7-defined table of codes specifying the limit for the collection event or process step.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.938"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.441"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0938"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.462"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0938"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CollectionEvent_ProcessStepLimit"
        }
      ]
    },
    {
      "code" : "0939",
      "display" : "Communication Location",
      "definition" : "HL7-defined table of codes specifying the communication location.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.939"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.442"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0939"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.463"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0939"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "CommunicationLocation"
        }
      ]
    },
    {
      "code" : "0940",
      "display" : "Limitation Type Codes",
      "definition" : "HL7-defined table of codes specifying the type of limitation.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.940"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.443"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0940"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.464"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0940"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "LimitationTypeCodes"
        }
      ]
    },
    {
      "code" : "0941",
      "display" : "Procedure Code",
      "definition" : "Table of codes specifying procedure codes that may impact payer coverage requirements, for example procedure code 1234 is not covered by a payer ABCD or may be covered in conjunction with a specific diagnosis code which can be identifeid in DPS-1 Diagnosis Code. The procedure codes should be drawn from appropriate externally defined procedure codes, for example in the US Realm these include CPT-4 codes defined by the American Medical Association and ICD codes published by CMS.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.941"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PayerCoverageProcedureCode"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0941"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0941"
        }
      ]
    },
    {
      "code" : "0942",
      "display" : "Equipment State Indicator Type Code",
      "definition" : "HL7-defined table of codes that specify the type of measurement of the state of an automated laboratory instrument.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.942"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.444"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0942"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.465"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0942"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-where-used",
          "valueString" : "INV-21"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "EquipmentStateIndicatorTypeCode"
        }
      ]
    },
    {
      "code" : "0943",
      "display" : "Transport Destination",
      "definition" : "Table of codes that identify the destination for transport of a specific container.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.943"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DST-1"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransportDestination"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0943"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0943"
        }
      ]
    },
    {
      "code" : "0944",
      "display" : "Transport Route",
      "definition" : "Table of codes that identify the route for transport of a specific container.    No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.944"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DST-2"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "TransportRoute"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0944"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0944"
        }
      ]
    },
    {
      "code" : "0945",
      "display" : "Auto-Dilution Type",
      "definition" : "Vendor-defined codes of the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.945"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.445"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0945"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.466"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0945"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "TCD-11"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Auto-dilutionType"
        }
      ]
    },
    {
      "code" : "0946",
      "display" : "Supplier Type",
      "definition" : "Table of codes specifying the type of supplier that will distribute the supply items associated to a contract number.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.946"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.446"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0946"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.467"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0946"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CTR-8"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "SupplierType"
        }
      ]
    },
    {
      "code" : "0947",
      "display" : "Class of Trade",
      "definition" : "Table of codes specifying the purchasing channel with which the contract is associated  such as Hospital, Retail, etc.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.947"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CTR-20"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ClassOfTrade"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0947"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0947"
        }
      ]
    },
    {
      "code" : "0948",
      "display" : "Relationship Type",
      "definition" : "HL7-defined table of codes specifying the type of relationship identified by Relationship Instance Identifier (REL-3) that is established between the Source Information Instance (REL-4)  and the Target Information Instance (REL-5).",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.948"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.448"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0948"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.471"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0948"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "RelationshipType"
        }
      ]
    },
    {
      "code" : "0949",
      "display" : "Order Control Code Reason",
      "definition" : "HL7-defined table of codes that describe reasons for the chosen order control codes – this table is extensible; while these codes are intended to be generally useful, they were developed to cover situations for replacement orders (ORC-1 = RO) and recommendations for replacement orders (ORC-1 = RP)",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.949"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.449"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0949"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.472"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0949"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-16"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "orderControlCodeReason"
        }
      ]
    },
    {
      "code" : "0950",
      "display" : "Order Status Modifier",
      "definition" : "HL7-defined table of codes used to further define the status identified in ORC-5",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.950"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.450"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0950"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.473"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0950"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ORC-25"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "orderStatusModifier"
        }
      ]
    },
    {
      "code" : "0951",
      "display" : "Reason for Study",
      "definition" : "HL7-defined table of codes that provide additional information to the universal service identifier on why a test, study or review was ordered. Current suggested values are in support of the IHE LCC LAB-7 transaction.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.951"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.451"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0951"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.474"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0951"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBR-31"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "reasonForStudy"
        }
      ]
    },
    {
      "code" : "0952",
      "display" : "Confidentiality Classification",
      "definition" : "Table of codes that specify the security classification; the codes are non-overlapping n the following  hierarchical order:\r\n Very Restricted > Restricted > Normal > Moderate > Low > Unrestricted\r\nMore information may be found the HL7 Healthcare Privacy and Security Classification System (HCS), Release 1 (see: http://www.hl7.org/implement/standards/product_brief.cfm?product_id=345)\r\nFor the list of codes in the table, see the HL7 Webpage rendering.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.952"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.5.25"
        },
        {
          "code" : "v2cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.1.11.10228"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0952"
        },
        {
          "code" : "v2-cld",
          "valueString" : "3"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "Externally defined"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "inm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "MSH-26, ARV-7"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Confidentiality"
        }
      ]
    },
    {
      "code" : "0959",
      "display" : "Work Classification ODH",
      "definition" : "A patient's employment type as defined by work classification (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.).For the list of codes in the table, see the FHIR rendering.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.959"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.5.1139"
        },
        {
          "code" : "v2cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v3-WorkClassificationODH"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.1.11.20560"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0959"
        },
        {
          "code" : "v2-cld",
          "valueString" : "3"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "pher"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "ODH2-6"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "WorkClassificationODH"
        }
      ]
    },
    {
      "code" : "0960",
      "display" : "Data Absent Reason",
      "definition" : "Used to specify why the normally expected content of the data element is missing.  Note that this content is maintained in the FHIR product family.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.960"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.4.642.1.1048"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/data-absent-reason"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.4.642.3.5"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://hl7.org/fhir/ValueSet/data-absent-reason"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "OBX-32"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DataAbsentReason"
        }
      ]
    },
    {
      "code" : "0961",
      "display" : "Device Type",
      "definition" : "Contains codes used to identify medical devices.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.961"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.4.642.3.198"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0961"
        },
        {
          "code" : "v2-cld",
          "valueString" : "6"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DEV-3"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceType"
        }
      ]
    },
    {
      "code" : "0962",
      "display" : "Device Status",
      "definition" : "Contains codes describing the availability status of the device.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.962"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.4.642.4.210"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://hl7.org/fhir/device-status"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.4.642.3.209"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0962"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DEV-4"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceStatus"
        }
      ]
    },
    {
      "code" : "0963",
      "display" : "Device Safety",
      "definition" : "Contains codes used to identify medical devices safety characteristics.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.963"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.3.26.1.1"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "Not yet approved by HTA"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.4.642.3.213"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://hl7.org/fhir/ValueSet/device-safety"
        },
        {
          "code" : "v2-cld",
          "valueString" : "5"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7-EXT"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "DEV-14"
        },
        {
          "code" : "v2-binding",
          "valueString" : "1"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "DeviceSafety"
        }
      ]
    },
    {
      "code" : "0964",
      "display" : "Service Reason",
      "definition" : "Table of codes describing reasons why a service was performed.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.964"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "FT1-56"
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ServiceReason"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0964"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0964"
        }
      ]
    },
    {
      "code" : "0965",
      "display" : "Contract Type",
      "definition" : "Values describing the scope of contracts, for example Local, Regional and Global.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.965"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CTR-9"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContractType"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0965"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0965"
        }
      ]
    },
    {
      "code" : "0966",
      "display" : "Pricing Tier Level",
      "definition" : "Values the describing the declared level of pricing for a particular product under a contract, usually based on a discount for larger orders under the contract – often assigned numerically, for example: 01 = Tier 1, 02 = Tier 2, 03 = Tier 3\r\nNo suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.966"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "CTR-18"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "PricingTierLevel"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0966"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0966"
        }
      ]
    },
    {
      "code" : "0967",
      "display" : "Container Form",
      "definition" : "Values describing the shape or type of the container.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.967"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-47"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerForm"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0967"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0967"
        }
      ]
    },
    {
      "code" : "0968",
      "display" : "Container Material",
      "definition" : "Values describing the material a container is made of or indication that the container may be a virtual type.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.968"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-48"
        },
        {
          "code" : "v2-binding",
          "valueString" : "0"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerMaterial"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0968"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0968"
        }
      ]
    },
    {
      "code" : "0969",
      "display" : "Container Common Name",
      "definition" : "Codes created by an organization as a shorthand way to express a combination of container attributes.  No suggested values.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.969"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "oo"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "SAC-49"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "ContainerCommonName"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0969"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0969"
        }
      ]
    },
    {
      "code" : "0970",
      "display" : "Online Verification Result",
      "definition" : "Result Code of the online verification of insurance data",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.970"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.453"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0970"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.478"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0970"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-29"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OnlineVerificationResult"
        }
      ]
    },
    {
      "code" : "0971",
      "display" : "Online Verification Result Error Code",
      "definition" : "Error Code of the online verification of insurance data",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.971"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.454"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0971"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.479"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-0971"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "User"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "steward",
          "valueCode" : "fm"
        },
        {
          "code" : "v2-where-used",
          "valueString" : "IN3-30"
        },
        {
          "code" : "v2-binding",
          "valueString" : "2"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "OnlineVerificationResultErrorCode"
        }
      ]
    },
    {
      "code" : "4000",
      "display" : "Name/address representation",
      "definition" : "HL7-defined table of codes that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data.  It is used to provides hints for a receiver, so it can make choices regarding what it has been sent and what it is capable of displaying.",
      "property" : [
        {
          "code" : "v2-table-oid",
          "valueString" : "2.16.840.1.113883.12.4000"
        },
        {
          "code" : "v2-cs-oid",
          "valueString" : "2.16.840.1.113883.18.436"
        },
        {
          "code" : "v2-cs-uri",
          "valueString" : "http://terminology.hl7.org/CodeSystem/v2-4000"
        },
        {
          "code" : "v2-vs-oid",
          "valueString" : "2.16.840.1.113883.21.458"
        },
        {
          "code" : "v2-vs-uri",
          "valueString" : "http://terminology.hl7.org/ValueSet/v2-4000"
        },
        {
          "code" : "v2-cld",
          "valueString" : "1"
        },
        {
          "code" : "v2-table-type",
          "valueCode" : "HL7"
        },
        {
          "code" : "v2-cs-version",
          "valueInteger" : 10
        },
        {
          "code" : "v2-binding",
          "valueString" : "3"
        },
        {
          "code" : "v2-version-tbl-introduced",
          "valueString" : "2.3"
        },
        {
          "code" : "v2-version-csvs-introduced",
          "valueString" : "2.9"
        },
        {
          "code" : "vocab-domain",
          "valueString" : "Name_AddressRepresentation"
        }
      ]
    }
  ]
}

```
