# onlineVerificationResultErrorCodes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **onlineVerificationResultErrorCodes**

## CodeSystem: onlineVerificationResultErrorCodes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0971 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OnlineVerificationResultErrorCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.454 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code values representing a type of error from a failed operation to perform online verification of insurance data. 

 
Underlying Master Code System for V2 table 0971 (Online Verification Result Error Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOnlineVerificationResultErrorCodes](ValueSet-v2-0971.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0971",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0971",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.454"
    }
  ],
  "version" : "2.0.0",
  "name" : "OnlineVerificationResultErrorCodes",
  "title" : "onlineVerificationResultErrorCodes",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code values representing a type of error from a failed operation to perform online verification of insurance data.",
  "purpose" : "Underlying Master Code System for V2 table 0971 (Online Verification Result Error Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0971",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6791",
      "code" : "1",
      "display" : "Update technically not possible",
      "definition" : "English: update of insurance date on card technically not possible\r\n\r\nGerman: Aktualisierung VSD auf eGK technisch nicht möglich",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6792",
      "code" : "2",
      "display" : "Invalid Authentification certificate",
      "definition" : "English: authentication certificate is invalid\r\n\r\nGerman: Authentifizierungszertifikat eGK ungültig",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6793",
      "code" : "3",
      "display" : "Online verification technically not possible",
      "definition" : "English: online verification of authentication certificate is technically not possible\r\n\r\nGerman: Onlineprüfung des Authentifizierungszerti-fikats technisch nicht möglich",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6794",
      "code" : "4",
      "display" : "Update technically not possible due to offline time exceeded",
      "definition" : "English: update of insurance date is technically not possible due to maximum offline time exceeded\r\n\r\nGerman: Aktualisierung VSD auf eGK technisch nicht möglich weil maximaler Offline-Zeitraum überschritten",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
