# supplyRisk - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **supplyRisk**

## CodeSystem: supplyRisk 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0871 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SupplyRisk |
| *Other Identifiers:*OID:2.16.840.1.113883.18.410 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying any known or suspected hazard associated with this material item. Used in HL7 Version 2.x messaging in the ITM segment. 

 
Underlying Master Code System for V2 table 0871 (Supply Risk Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSupplyRiskCodes](ValueSet-v2-0871.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0871",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0871",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.410"
    }
  ],
  "version" : "2.0.0",
  "name" : "SupplyRisk",
  "title" : "supplyRisk",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any known or suspected hazard associated with this material item.  Used in HL7 Version 2.x messaging in the ITM segment.",
  "purpose" : "Underlying Master Code System for V2 table 0871 (Supply Risk Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0871",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6502",
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Corrosive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6503",
      "code" : "FLA",
      "display" : "Flammable",
      "definition" : "Flammable",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is highly flammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is highly flammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6504",
      "code" : "EXP",
      "display" : "Explosive",
      "definition" : "Explosive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6505",
      "code" : "INJ",
      "display" : "Injury Hazard",
      "definition" : "Injury Hazard",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6506",
      "code" : "TOX",
      "display" : "Toxic",
      "definition" : "Toxic",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is toxic to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is toxic to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6507",
      "code" : "RAD",
      "display" : "Radioactive",
      "definition" : "Radioactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6508",
      "code" : "UNK",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material hazard level is unknown."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material hazard level is unknown."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
