# Quantity Units - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Quantity Units**

## CodeSystem: Quantity Units 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0560 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QuantityUnits |
| *Other Identifiers:*OID:2.16.840.1.113883.18.455 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the adjustment quantity. 

 
Underlying Master Code System for V2 table 0560 (Quantity Units) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSQuantityUnits](ValueSet-v2-0560.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0560",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0560",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.455"
    }
  ],
  "version" : "2.0.0",
  "name" : "QuantityUnits",
  "title" : "Quantity Units",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the adjustment quantity.",
  "purpose" : "Underlying Master Code System for V2 table 0560 (Quantity Units)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0560",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "concept" : [
    {
      "id" : "55000",
      "code" : "FL",
      "display" : "Units",
      "definition" : "no definition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "55001",
      "code" : "DY",
      "display" : "Days",
      "definition" : "no definition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "55002",
      "code" : "HS",
      "display" : "Hours",
      "definition" : "no definition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "55003",
      "code" : "MN",
      "display" : "Month",
      "definition" : "no definition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "55004",
      "code" : "YY",
      "display" : "Years",
      "definition" : "no definition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
