# acknowledgmentCodes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **acknowledgmentCodes**

## CodeSystem: acknowledgmentCodes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0008 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AcknowledgmentCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.10 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. 

 
Underlying Master Code System for V2 table 0008 (Acknowledgment code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAcknowledgmentCode](ValueSet-v2-0008.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0008",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0008",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.10"
    }
  ],
  "version" : "2.0.0",
  "name" : "AcknowledgmentCodes",
  "title" : "acknowledgmentCodes",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying acknowledgment codes.  For details of usage, see message processing rules in the published Standard.  Used in HL7 Version 2.x messaging in the MSA segment.",
  "purpose" : "Underlying Master Code System for V2 table 0008 (Acknowledgment code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0008",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "629",
      "code" : "AA",
      "display" : "Original mode: Application Accept - Enhanced mode: Application acknowledgment: Accept",
      "definition" : "Original mode: Application Accept - Enhanced mode: Application acknowledgment: Accept",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "akzeptiert durch Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "630",
      "code" : "AE",
      "display" : "Original mode: Application Error - Enhanced mode: Application acknowledgment: Error",
      "definition" : "Original mode: Application Error - Enhanced mode: Application acknowledgment: Error",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fehler in Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "631",
      "code" : "AR",
      "display" : "Original mode: Application Reject - Enhanced mode: Application acknowledgment: Reject",
      "definition" : "Original mode: Application Reject - Enhanced mode: Application acknowledgment: Reject",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abgelehnt durch Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "632",
      "code" : "CA",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Accept",
      "definition" : "Enhanced mode: Accept acknowledgment: Commit Accept",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Bei Eingangsprüfung akzeptiert (\"committed\")"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "633",
      "code" : "CE",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Error",
      "definition" : "Enhanced mode: Accept acknowledgment: Commit Error",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fehler bei Eingangsprüfung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "634",
      "code" : "CR",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Reject",
      "definition" : "Enhanced mode: Accept acknowledgment: Commit Reject",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Bei Eingangsprüfung abgelehnt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
