# AllergyIntoleranceCertainty - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntoleranceCertainty**

## CodeSystem: AllergyIntoleranceCertainty 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/reaction-event-certainty | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AllergyIntoleranceCertainty |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1276 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AllergyIntoleranceCertainty](ValueSet-reaction-event-certainty.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "reaction-event-certainty",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/reaction-event-certainty",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1276"
    }
  ],
  "version" : "1.0.0",
  "name" : "AllergyIntoleranceCertainty",
  "title" : "AllergyIntoleranceCertainty",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/reaction-event-certainty",
  "content" : "complete",
  "concept" : [
    {
      "code" : "unlikely",
      "display" : "Unlikely",
      "definition" : "There is a low level of clinical certainty that the reaction was caused by the identified substance."
    },
    {
      "code" : "likely",
      "display" : "Likely",
      "definition" : "There is a high level of clinical certainty that the reaction was caused by the identified substance."
    },
    {
      "code" : "confirmed",
      "display" : "Confirmed",
      "definition" : "There is a very high level of clinical certainty that the reaction was due to the identified substance, which may include clinical evidence by testing or rechallenge."
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "The clinical certainty that the reaction was caused by the identified substance is unknown.  It is an explicit assertion that certainty is not known."
    }
  ]
}

```
