# QuestionnaireItemUsageMode - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QuestionnaireItemUsageMode**

## CodeSystem: QuestionnaireItemUsageMode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/questionnaire-usage-mode | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QuestionnaireItemUsageMode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1274 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [QuestionnaireItemUsageMode](ValueSet-questionnaire-usage-mode.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "questionnaire-usage-mode",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/questionnaire-usage-mode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1274"
    }
  ],
  "version" : "1.0.0",
  "name" : "QuestionnaireItemUsageMode",
  "title" : "QuestionnaireItemUsageMode",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/questionnaire-usage-mode",
  "content" : "complete",
  "concept" : [
    {
      "code" : "capture-display",
      "display" : "Capture & Display",
      "definition" : "Render the item regardless of usage mode."
    },
    {
      "code" : "capture",
      "display" : "Capture Only",
      "definition" : "Render the item only when capturing data."
    },
    {
      "code" : "display",
      "display" : "Display Only",
      "definition" : "Render the item only when displaying a completed form."
    },
    {
      "code" : "display-non-empty",
      "display" : "Display when Answered",
      "definition" : "Render the item only when displaying a completed form and the item has been answered (or has child items that have been answered)."
    },
    {
      "code" : "capture-display-non-empty",
      "display" : "Capture or, if answered, Display",
      "definition" : "Render the item when capturing data or when displaying a completed form and the item has been answered (or has child items that have been answered)."
    }
  ]
}

```
