# Published In Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Published In Type**

## CodeSystem: Published In Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/published-in-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:PublishedInType |

 
The type of publication such as book, database, or journal. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PublishedInType](ValueSet-published-in-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "published-in-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/published-in-type",
  "version" : "1.0.0",
  "name" : "PublishedInType",
  "title" : "Published In Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The type of publication such as book, database, or journal.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/published-in-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "D020492",
      "display" : "Periodical",
      "definition" : "Publication intended to be issued on an ongoing basis, generally more frequently than annually, containing separate articles, stories, or writings."
    },
    {
      "code" : "D019991",
      "display" : "Database",
      "definition" : "A structured file of information or a set of logically related data stored and retrieved using computer-based means."
    },
    {
      "code" : "D001877",
      "display" : "Book",
      "definition" : "Non-periodical written or printed works consisting of sheets of pages fastened or bound together within covers."
    },
    {
      "code" : "D064886",
      "display" : "Dataset",
      "definition" : "Works consisting of organized collections of data, which have been stored permanently in a formalized manner suitable for communication, interpretation, or processing."
    }
  ]
}

```
