# Professional Credential Status - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Professional Credential Status**

## CodeSystem: Professional Credential Status 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/professional-credential-status | *Version*:1.0.0 | | |
| Draft as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProfessionalCredentialStatus |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system establishes a series of codes designed to represent the status of professional credentials. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ProfessionalCredentialStatus](ValueSet-professional-credential-status.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "professional-credential-status",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/professional-credential-status",
  "version" : "1.0.0",
  "name" : "ProfessionalCredentialStatus",
  "title" : "Professional Credential Status",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system establishes a series of codes designed to represent the status of professional credentials.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/professional-credential-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "active",
      "display" : "active",
      "definition" : "The credential may be considered valid for use."
    },
    {
      "code" : "inactive",
      "display" : "inactive",
      "definition" : "The credential may not be considered valid for use."
    },
    {
      "code" : "issued-in-error",
      "display" : "issued in error",
      "definition" : "The credential was mistakenly assigned and should not be considered valid for use."
    },
    {
      "code" : "expired",
      "display" : "expired",
      "definition" : "The credential may not be considered valid for use."
    },
    {
      "code" : "revoked",
      "display" : "revoked",
      "definition" : "The credential was revoked by the issuing organization and should not be considered valid for use."
    },
    {
      "code" : "pending",
      "display" : "pending",
      "definition" : "The credential has not been officially assigned. It may or may not be considered valid for use."
    },
    {
      "code" : "provisional",
      "display" : "provisional",
      "definition" : "The credential is temporary and granted under specific conditions or limitations. It may or may not be considered valid for use."
    },
    {
      "code" : "unknown",
      "display" : "unknown",
      "definition" : "The status of this credential is unknown. It may or may not be considered valid for use."
    }
  ]
}

```
