# Process Priority Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Process Priority Codes**

## CodeSystem: Process Priority Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/processpriority | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessPriorityCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1155 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes the financial processing priority codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ProcessPriorityCodes](ValueSet-process-priority.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "processpriority",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/processpriority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1155"
    }
  ],
  "version" : "1.0.1",
  "name" : "ProcessPriorityCodes",
  "title" : "Process Priority Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes the financial processing priority codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/process-priority",
  "content" : "complete",
  "concept" : [
    {
      "code" : "stat",
      "display" : "Immediate",
      "definition" : "Immediately in real time."
    },
    {
      "code" : "normal",
      "display" : "Normal",
      "definition" : "With best effort."
    },
    {
      "code" : "deferred",
      "display" : "Deferred",
      "definition" : "Later, when possible."
    }
  ]
}

```
