# Primary-source-type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Primary-source-type**

## CodeSystem: Primary-source-type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/primary-source-type | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Primary_source_type |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.893 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Type of the validation primary source 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Primary_source_type](ValueSet-verificationresult-primary-source-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "primary-source-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/primary-source-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.893"
    }
  ],
  "version" : "1.0.1",
  "name" : "Primary_source_type",
  "title" : "Primary-source-type",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Type of the validation primary source",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-primary-source-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "lic-board",
      "display" : "License Board"
    },
    {
      "code" : "prim",
      "display" : "Primary Education"
    },
    {
      "code" : "cont-ed",
      "display" : "Continuing Education"
    },
    {
      "code" : "post-serv",
      "display" : "Postal Service"
    },
    {
      "code" : "rel-own",
      "display" : "Relationship owner"
    },
    {
      "code" : "reg-auth",
      "display" : "Registration Authority"
    },
    {
      "code" : "legal",
      "display" : "Legal source"
    },
    {
      "code" : "issuer",
      "display" : "Issuing source"
    },
    {
      "code" : "auth-source",
      "display" : "Authoritative source"
    }
  ]
}

```
