# MedicationRequest Course of Therapy Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Course of Therapy Codes**

## CodeSystem: MedicationRequest Course of Therapy Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationrequest-course-of-therapy | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationRequestCourseOfTherapyCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1327 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationRequest Course of Therapy Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationRequestCourseOfTherapyCodes](ValueSet-medicationrequest-course-of-therapy.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationrequest-course-of-therapy",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationrequest-course-of-therapy",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1327"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationRequestCourseOfTherapyCodes",
  "title" : "MedicationRequest Course of Therapy Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationRequest Course of Therapy Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationrequest-course-of-therapy",
  "content" : "complete",
  "concept" : [
    {
      "code" : "continuous",
      "display" : "Continuous long term therapy",
      "definition" : "A medication which is expected to be continued beyond the present order and which the patient should be assumed to be taking unless explicitly stopped."
    },
    {
      "code" : "acute",
      "display" : "Short course (acute) therapy",
      "definition" : "A medication which the patient is only expected to consume for the duration of the current order and which is not expected to be renewed."
    },
    {
      "code" : "seasonal",
      "display" : "Seasonal",
      "definition" : "A medication which is expected to be used on a part time basis at certain times of the year"
    }
  ]
}

```
