# MedicationAdministration Location Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationAdministration Location Codes**

## CodeSystem: MedicationAdministration Location Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medication-admin-location | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationAdministrationLocationCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationAdministration Location Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationAdministrationLocation](ValueSet-medication-admin-location.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-admin-location",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medication-admin-location",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationAdministrationLocationCodes",
  "title" : "MedicationAdministration Location Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationAdministration Location Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medication-admin-location",
  "content" : "complete",
  "concept" : [
    {
      "code" : "inpatient",
      "display" : "Inpatient",
      "definition" : "Includes administrations in an inpatient or acute care setting"
    },
    {
      "code" : "outpatient",
      "display" : "Outpatient",
      "definition" : "Includes administrations in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)"
    },
    {
      "code" : "community",
      "display" : "Community",
      "definition" : "Includes administrations by the patient in their home (this would include long term care or nursing homes, hospices, etc.)"
    }
  ]
}

```
