# LibraryType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LibraryType**

## CodeSystem: LibraryType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/library-type | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LibraryType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1230 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The type of knowledge asset this library contains. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [LibraryType](ValueSet-library-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "library-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/library-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1230"
    }
  ],
  "version" : "1.0.1",
  "name" : "LibraryType",
  "title" : "LibraryType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of knowledge asset this library contains.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/library-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "logic-library",
      "display" : "Logic Library",
      "definition" : "The resource is a shareable library of formalized knowledge."
    },
    {
      "code" : "model-definition",
      "display" : "Model Definition",
      "definition" : "The resource is a definition of an information model."
    },
    {
      "code" : "asset-collection",
      "display" : "Asset Collection",
      "definition" : "The resource is a collection of knowledge assets."
    },
    {
      "code" : "module-definition",
      "display" : "Module Definition",
      "definition" : "The resource defines the dependencies, parameters, and data requirements for a particular module or evaluation context."
    }
  ]
}

```
