# Goal priority - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Goal priority**

## CodeSystem: Goal priority 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/goal-priority | *Version*:1.0.1 | |
| Active as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GoalPriority |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1096 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Indicates the level of importance associated with reaching or sustaining a goal. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GoalPriority](ValueSet-goal-priority.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "goal-priority",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/goal-priority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1096"
    }
  ],
  "version" : "1.0.1",
  "name" : "GoalPriority",
  "title" : "Goal priority",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the level of importance associated with reaching or sustaining a goal.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/goal-priority",
  "content" : "complete",
  "concept" : [
    {
      "code" : "high-priority",
      "display" : "High Priority",
      "definition" : "Indicates that the goal is of considerable importance and should be a primary focus of care delivery."
    },
    {
      "code" : "medium-priority",
      "display" : "Medium Priority",
      "definition" : "Indicates that the goal has a reasonable degree of importance and that concrete action should be taken towards the goal.  Attainment is not as critical as high-priority goals."
    },
    {
      "code" : "low-priority",
      "display" : "Low Priority",
      "definition" : "The goal is desirable but is not sufficiently important to devote significant resources to.  Achievement of the goal may be sought when incidental to achieving other goals."
    }
  ]
}

```
