# Goal achievement status - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Goal achievement status**

## CodeSystem: Goal achievement status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/goal-achievement | *Version*:1.0.1 | |
| Active as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GoalAchievementStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1375 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Describes the progression, or lack thereof, towards the goal against the target. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GoalAchievementStatus](ValueSet-goal-achievement.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "goal-achievement",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/goal-achievement",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1375"
    }
  ],
  "version" : "1.0.1",
  "name" : "GoalAchievementStatus",
  "title" : "Goal achievement status",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Describes the progression, or lack thereof, towards the goal against the target.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/goal-achievement",
  "content" : "complete",
  "concept" : [
    {
      "code" : "in-progress",
      "display" : "In Progress",
      "definition" : "The goal is being sought but has not yet been reached. (Also applies if the goal was reached in the past but there has been regression and the goal is again being sought).",
      "concept" : [
        {
          "code" : "improving",
          "display" : "Improving",
          "definition" : "The goal is being sought, and is progressing."
        },
        {
          "code" : "worsening",
          "display" : "Worsening",
          "definition" : "The goal is being sought, but is regressing."
        },
        {
          "code" : "no-change",
          "display" : "No Change",
          "definition" : "The goal is being sought, but the trend is flat."
        }
      ]
    },
    {
      "code" : "achieved",
      "display" : "Achieved",
      "definition" : "The goal has been met.",
      "concept" : [
        {
          "code" : "sustaining",
          "display" : "Sustaining",
          "definition" : "The goal has been met, but ongoing activity is needed to sustain the goal objective."
        }
      ]
    },
    {
      "code" : "not-achieved",
      "display" : "Not Achieved",
      "definition" : "The goal has not been met and there might or might not have been progress towards target.",
      "concept" : [
        {
          "code" : "no-progress",
          "display" : "No Progress",
          "definition" : "The goal has not been met and little to no progress towards target."
        },
        {
          "code" : "not-attainable",
          "display" : "Not Attainable",
          "definition" : "The goal is not possible to be met."
        }
      ]
    }
  ]
}

```
