# Financial Task Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Financial Task Codes**

## CodeSystem: Financial Task Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/financialtaskcode | *Version*:1.0.0 | |
| Draft as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FinancialTaskCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1390 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This value set includes Financial Task codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FinancialTaskCodes](ValueSet-financial-taskcode.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "financialtaskcode",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "url" : "http://terminology.hl7.org/CodeSystem/financialtaskcode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1390"
    }
  ],
  "version" : "1.0.0",
  "name" : "FinancialTaskCodes",
  "title" : "Financial Task Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Financial Task codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/financial-taskcode",
  "content" : "complete",
  "concept" : [
    {
      "code" : "cancel",
      "display" : "Cancel",
      "definition" : "Cancel or reverse a resource, such as a claim or preauthorization, which is in-process or complete."
    },
    {
      "code" : "poll",
      "display" : "Poll",
      "definition" : "Retrieve selected or all queued resources or messages."
    },
    {
      "code" : "release",
      "display" : "Release",
      "definition" : "Release any reserved funds or material obligations associated with a resource. For example, any unused but reserved funds or treatment allowance associated with a preauthorization once treatment is complete."
    },
    {
      "code" : "reprocess",
      "display" : "Reprocess",
      "definition" : "Indication that the processing of a resource, such as a claim, for some or all of the required work is now being requested."
    },
    {
      "code" : "status",
      "display" : "Status check",
      "definition" : "Check on the processing status of a resource such as the adjudication of a claim."
    }
  ]
}

```
