# ExpansionParameterSource - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExpansionParameterSource**

## CodeSystem: ExpansionParameterSource 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/expansion-parameter-source | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExpansionParameterSource |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1279 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Declares what the source of a parameter is. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExpansionParameterSource](ValueSet-expansion-parameter-source.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "expansion-parameter-source",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/expansion-parameter-source",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1279"
    }
  ],
  "version" : "1.0.0",
  "name" : "ExpansionParameterSource",
  "title" : "ExpansionParameterSource",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Declares what the source of a parameter is.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/expansion-parameter-source",
  "content" : "complete",
  "concept" : [
    {
      "code" : "input",
      "display" : "Client Input",
      "definition" : "The parameter was supplied by the client in the $expand request."
    },
    {
      "code" : "server",
      "display" : "Server Engine",
      "definition" : "The parameter was added by the expansion engine on the server."
    },
    {
      "code" : "codesystem",
      "display" : "Code System",
      "definition" : "The parameter was added from one the code systems used in the $expand operation."
    }
  ]
}

```
