# Enteral Formula Additive Type Code - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Enteral Formula Additive Type Code**

## CodeSystem: Enteral Formula Additive Type Code 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/entformula-additive | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EnteralFormulaAdditiveTypeCode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1123 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EnteralFormulaAdditiveTypeCode](ValueSet-entformula-additive.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "entformula-additive",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/entformula-additive",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1123"
    }
  ],
  "version" : "1.0.1",
  "name" : "EnteralFormulaAdditiveTypeCode",
  "title" : "Enteral Formula Additive Type Code",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/entformula-additive",
  "content" : "complete",
  "concept" : [
    {
      "code" : "lipid",
      "display" : "Lipid",
      "definition" : "Modular lipid enteral formula component"
    },
    {
      "code" : "protein",
      "display" : "Protein",
      "definition" : "Modular protein enteral formula component"
    },
    {
      "code" : "carbohydrate",
      "display" : "Carbohydrate",
      "definition" : "Modular carbohydrate enteral formula component"
    },
    {
      "code" : "fiber",
      "display" : "Fiber",
      "definition" : "Modular fiber enteral formula component"
    },
    {
      "code" : "water",
      "display" : "Water",
      "definition" : "Added water"
    }
  ]
}

```
