# Endpoint Connection Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Endpoint Connection Type**

## CodeSystem: Endpoint Connection Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/endpoint-connection-type | *Version*:2.1.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EndpointConnectionType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1140 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.htmlSome content from IHE® Copyright © 2015 IHE International, Inc. The IHE concepts are from the IHE Technical Frameworks and Supplements, available for free download and use at http://www.ihe.net/Technical_Frameworks/ | | | |

 
This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EndpointConnectionType](ValueSet-endpoint-connection-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "endpoint-connection-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1140"
    }
  ],
  "version" : "2.1.1",
  "name" : "EndpointConnectionType",
  "title" : "Endpoint Connection Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html\r\rSome content from IHE® Copyright © 2015 IHE International, Inc.    The IHE concepts are from the IHE Technical Frameworks and Supplements, available for free download and use at http://www.ihe.net/Technical_Frameworks/",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/endpoint-connection-type",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "dicom-wado-rs",
      "display" : "DICOM WADO-RS",
      "definition" : "DICOMweb RESTful Image Retrieve - http://dicom.nema.org/medical/dicom/current/output/chtml/part18/sect_6.5.html",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "dicom-qido-rs",
      "display" : "DICOM QIDO-RS",
      "definition" : "DICOMweb RESTful Image query - http://dicom.nema.org/medical/dicom/current/output/chtml/part18/sect_6.7.html",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "dicom-stow-rs",
      "display" : "DICOM STOW-RS",
      "definition" : "DICOMweb RESTful image sending and storage - http://dicom.nema.org/medical/dicom/current/output/chtml/part18/sect_6.6.html",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "dicom-wado-uri",
      "display" : "DICOM WADO-URI",
      "definition" : "DICOMweb Image Retrieve - http://dicom.nema.org/dicom/2013/output/chtml/part18/sect_6.3.html",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "hl7-fhir-rest",
      "display" : "HL7 FHIR",
      "definition" : "Interact with the server interface using FHIR's RESTful interface. For details on its version/capabilities you should connect the value in Endpoint.address and retrieve the FHIR CapabilityStatement.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "hl7-fhir-msg",
      "display" : "HL7 FHIR Messaging",
      "definition" : "Use the servers FHIR Messaging interface. Details can be found on the messaging.html page in the FHIR Specification. The FHIR server's base address is specified in the Endpoint.address property.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "hl7v2-mllp",
      "display" : "HL7 v2 MLLP",
      "definition" : "HL7v2 messages over an LLP TCP connection",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "secure-email",
      "display" : "Secure email",
      "definition" : "Email delivery using a digital certificate to encrypt the content using the public key, receiver must have the private key to decrypt the content",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "direct-project",
      "display" : "Direct Project",
      "definition" : "Direct Project information - http://wiki.directproject.org/",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "cds-hooks-service",
      "display" : "CDS Hooks Service",
      "definition" : "A CDS Hooks Service connection. The address will be the base URL of the service as described in the CDS specification https://cds-hooks.hl7.org",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "ihe-xcpd",
      "display" : "IHE XCPD",
      "definition" : "IHE Cross Community Patient Discovery Profile (XCPD) - http://wiki.ihe.net/index.php/Cross-Community_Patient_Discovery",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "code" : "ihe-xca",
      "display" : "IHE XCA",
      "definition" : "IHE Cross Community Access Profile (XCA) - http://wiki.ihe.net/index.php/Cross-Community_Access",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "code" : "ihe-xdr",
      "display" : "IHE XDR",
      "definition" : "IHE Cross-Enterprise Document Reliable Exchange (XDR) - http://wiki.ihe.net/index.php/Cross-enterprise_Document_Reliable_Interchange",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "code" : "ihe-xds",
      "display" : "IHE XDS",
      "definition" : "IHE Cross-Enterprise Document Sharing (XDS) - http://wiki.ihe.net/index.php/Cross-Enterprise_Document_Sharing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "code" : "ihe-iid",
      "display" : "IHE IID",
      "definition" : "IHE Invoke Image Display (IID) - http://wiki.ihe.net/index.php/Invoke_Image_Display",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    }
  ]
}

```
