# Contributor Summary Source - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contributor Summary Source**

## CodeSystem: Contributor Summary Source 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contributor-summary-source | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ContributorSummarySource |

 
Used to code the producer or rule for creating the display string. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContributorSummarySource](ValueSet-contributor-summary-source.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contributor-summary-source",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contributor-summary-source",
  "version" : "1.0.0",
  "name" : "ContributorSummarySource",
  "title" : "Contributor Summary Source",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to code the producer or rule for creating the display string.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contributor-summary-source",
  "content" : "complete",
  "concept" : [
    {
      "code" : "publisher-data",
      "display" : "Publisher provided",
      "definition" : "Data copied by machine from publisher data."
    },
    {
      "code" : "article-copy",
      "display" : "Copied from article",
      "definition" : "Data copied by human from article text."
    },
    {
      "code" : "citation-manager",
      "display" : "Reported by citation manager",
      "definition" : "Data copied by machine from citation manager data."
    },
    {
      "code" : "custom",
      "display" : "custom format",
      "definition" : "Custom format (may be described in text note)."
    }
  ]
}

```
