# Concept Domains - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Concept Domains**

## CodeSystem: Concept Domains 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/conceptdomains | *Version*:3.0.0 | |
| Active as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConceptDomains |
| **Copyright/Legal**: Copyright HL7. Licensed under creative commons public domain | | |

 
Concept Domains - includes both v2 abd v3 concept domains 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "conceptdomains",
  "url" : "http://terminology.hl7.org/CodeSystem/conceptdomains",
  "version" : "3.0.0",
  "name" : "ConceptDomains",
  "title" : "Concept Domains",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Concept Domains - includes both v2 abd v3 concept domains",
  "copyright" : "Copyright HL7. Licensed under creative commons public domain",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "ConceptualSpaceForClassCode",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#ConceptualSpaceForClassCode",
      "description" : "Conceptual Space For ClassCode",
      "type" : "Coding"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "Date when the concept was deprecated.",
      "type" : "dateTime"
    },
    {
      "code" : "DeprecationInfo",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#DeprecationInfo",
      "description" : "Descriptive text about deprecation.",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Status of the domain; retired or deprecated otherwise active.",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    },
    {
      "code" : "contextBindingC1-effectiveDate",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingC1-effectiveDate",
      "description" : "C1 Binding Effective Date",
      "type" : "dateTime"
    },
    {
      "code" : "contextBindingC1-strength",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingC1-strength",
      "description" : "C1 Binding Coding Strength",
      "type" : "code"
    },
    {
      "code" : "contextBindingC1-valueSet",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingC1-valueSet",
      "description" : "C1 Bound ValueSet",
      "type" : "string"
    },
    {
      "code" : "contextBindingR1-effectiveDate",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingR1-effectiveDate",
      "description" : "R1 Binding Effective Date",
      "type" : "dateTime"
    },
    {
      "code" : "contextBindingR1-strength",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingR1-strength",
      "description" : "R1 Binding Coding Strength",
      "type" : "code"
    },
    {
      "code" : "contextBindingR1-valueSet",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingR1-valueSet",
      "description" : "R1 Bound ValueSet",
      "type" : "string"
    },
    {
      "code" : "contextBindingUS-effectiveDate",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUS-effectiveDate",
      "description" : "US Binding Effective Date",
      "type" : "dateTime"
    },
    {
      "code" : "contextBindingUS-strength",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUS-strength",
      "description" : "US Binding Coding Strength",
      "type" : "code"
    },
    {
      "code" : "contextBindingUS-valueSet",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUS-valueSet",
      "description" : "US Bound ValueSet",
      "type" : "string"
    },
    {
      "code" : "contextBindingUV-effectiveDate",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUV-effectiveDate",
      "description" : "UV Binding Effective Date",
      "type" : "dateTime"
    },
    {
      "code" : "contextBindingUV-strength",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUV-strength",
      "description" : "UV Binding Coding Strength",
      "type" : "code"
    },
    {
      "code" : "contextBindingUV-valueSet",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingUV-valueSet",
      "description" : "UV Bound ValueSet",
      "type" : "string"
    },
    {
      "code" : "contextBindingX1-effectiveDate",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingX1-effectiveDate",
      "description" : "X1 Binding Effective Date",
      "type" : "dateTime"
    },
    {
      "code" : "contextBindingX1-strength",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingX1-strength",
      "description" : "X1 Binding Coding Strength",
      "type" : "code"
    },
    {
      "code" : "contextBindingX1-valueSet",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#contextBindingX1-valueSet",
      "description" : "X1 Bound ValueSet",
      "type" : "string"
    },
    {
      "code" : "openIssue",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#openIssue",
      "description" : "Open Issue",
      "type" : "string"
    },
    {
      "code" : "source",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#source",
      "description" : "Source",
      "type" : "code"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AcknowledgementCondition",
      "display" : "AcknowledgementCondition",
      "definition" : "Acknowledgement Condition codes describe the conditions under which accept or application level acknowledgements are required to be returned in response to the message send operation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.155"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "AcknowledgementDetailCode",
      "display" : "AcknowledgementDetailCode",
      "definition" : "A site specific code indicating the specific problem being reported by this Ack Detail.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19638"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "AcknowledgementDetailNotSupportedCode",
          "display" : "AcknowledgementDetailNotSupportedCode",
          "definition" : "Refelects rejections because elements of the communication are not supported in the current context.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19640"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "AcknowledgementDetailSyntaxErrorCode",
          "display" : "AcknowledgementDetailSyntaxErrorCode",
          "definition" : "Reflects errors in the syntax or structure of the communication.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19639"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "AcknowledgementDetailType",
      "display" : "AcknowledgementDetailType",
      "definition" : "A code identifying the specific message to be provided.\r\n\r\nA textual value may be specified as the print name, or for non-coded messages, as the original text.*Discussion:*\r\n\r\n'Required attribute xxx is missing', 'System will be unavailable March 19 from 0100 to 0300'*Examples:*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19358"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "AcknowledgmentMessageType",
          "display" : "AcknowledgmentMessageType",
          "definition" : "Identifies the the kind of information specified in the acknowledgement message. Options are: Error, Warning or Information.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "AcknowledgementType",
      "display" : "AcknowledgementType",
      "definition" : "Acknowledgement code as described in HL7 message processing rules.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.8"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActAppointmentType",
      "display" : "ActAppointmentType",
      "definition" : "**Description:** Types of acts that can be scheduled.\r\n\r\n**Examples:**\r\n\r\n *  Follow-up appointment\r\n *  New referral appointment\r\n *  Consultation appointment\r\n *  Specimen Collection appointment\r\n *  Procedure appointment",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "ActClass",
      "display" : "ActClass",
      "definition" : "A code specifying the major type of Act that this Act-instance represents.\r\n\r\n*Constraints:* The classCode domain is a tightly controlled vocabulary, not an external or user-defined vocabulary.\r\n\r\nEvery Act-instance must have a classCode. If the act class is not further specified, the most general Act.classCode (ACT) is used.\r\n\r\nThe Act.classCode must be a generalization of the specific Act concept (e.g., as expressed in Act.code), in other words, the Act concepts conveyed in an Act must be specializations of the Act.classCode. Especially, Act.code is not a \"modifier\" that can alter the meaning of a class code. (See Act.code for contrast.)",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11527"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ActClassExposure",
          "display" : "ActClassExposure",
          "definition" : "**Description:**The interaction of entities whereupon a subject entity is brought into proximity to a physical, chemical or biological agent. This includes intended exposure (e.g. administering a drug product) as well as accidental or environmental exposure. (Note: This class deals only with proximity and not the effectiveness of the exposure, i.e. not all exposed will suffer actual harm or benefit.)\r\n\r\n**Examples:**Exposure to radiation, drug administration, inhalation of peanut aerosol or viral particles.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19832"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActClassGenomicObservation",
          "display" : "ActClassGenomicObservation",
          "definition" : "**Description:**An observation of genomic phenomena.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19824"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActClassPolicy",
          "display" : "ActClassPolicy",
          "definition" : "**Description:**A mandate, regulation, obligation, requirement, rule, or expectation unilaterally imposed by one party on:\r\n\r\n *  The activity of another party\r\n *  The behavior of another party\r\n *  The manner in which an act is executed",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19818"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActClassProcedure",
          "display" : "ActClassProcedure",
          "definition" : "An Act whose immediate and primary outcome (post-condition) is the alteration of the physical condition of the subject.\r\n\r\n*Examples:* : Procedures may involve the disruption of some body surface (e.g. an incision in a surgical procedure), but they also include conservative procedures such as reduction of a luxated join, chiropractic treatment, massage, balneotherapy, acupuncture, shiatsu, etc. Outside of clinical medicine, procedures may be such things as alteration of environments (e.g. straightening rivers, draining swamps, building dams) or the repair or change of machinery etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19665"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActClassStorage",
          "display" : "ActClassStorage",
          "definition" : "The act of putting something away for safe keeping. The \"something\" may be physical object such as a specimen, or information, such as observations regarding a specimen.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19664"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "SubjectPhysicalPosition",
          "display" : "SubjectPhysicalPosition",
          "definition" : "The spatial relationship of a subject whether human, other animal, or plant, to a frame of reference such as gravity or a collection device.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ImagingSubjectOrientation",
              "display" : "ImagingSubjectOrientation",
              "definition" : "A code specifying qualitatively the spatial relation between imaged object and imaging film or detector.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SubjectBodyPosition",
              "display" : "SubjectBodyPosition",
              "definition" : "Contains codes for defining the observed, physical position of a subject, such as during an observation, assessment, collection of a specimen, etc. ECG waveforms and vital signs, such as blood pressure, are two examples where a general, observed position typically needs to be noted.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19798"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CNE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "ActCode",
      "display" : "ActCode",
      "definition" : "The table that provides the detailed or rich codes for the Act classes.\r\n\r\n*Open Issue:* The hierarchy has issues and several of the existing domains may be moved under this new one; this must be examined and a proposal to clean up the hierarncy in the near future is needed\r\n\r\n*Open Issue:* The description of this domain seems odd and may be a leftover from long ago and needs improvement.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "ActAccountType",
          "display" : "ActAccountType",
          "definition" : "**Description:** Types of representation groupings of financial transactions that are tracked and reported together with a single balance.\r\n\r\n*Examples:* \r\n\r\n *  Patient billing accounts\r\n *  Cost center\r\n *  Cash",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACCT"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.14809"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActAdjudicationType",
          "display" : "ActAdjudicationType",
          "definition" : "**Description:** Types of responses that will occur as a result of the adjudication of an electronic invoice at a summary level and provides guidance on interpretation of the referenced adjudication results.\r\n\r\n*Examples:* \r\n\r\n *  adjudicated with adjustments\r\n *  adjudicated as refused\r\n *  adjudicated as submitted",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ADJUD"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.17616"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActAdjudicationInformationCode",
              "display" : "ActAdjudicationInformationCode",
              "definition" : "Explanatory codes that provide information derived by an Adjudicator during the course of adjudicating an Invoice. Codes from this domain are purely information and do not materially affect the adjudicated Invoice. That is, codes do not impact or explain financial adjustments to an Invoice.\r\n\r\nA companion domain (ActAdjudicationReason) includes information reasons which have a financial impact on an Invoice (claim).\r\n\r\nExample adjudication information code is 54540 - Patient has reached Plan Maximum for current year.\r\n\r\nCodes from this domain further rationalizes ActAdjudicationCodes (e.g. AA - Adjudicated with Adjustment), which are used to describe the process of adjudicating an Invoice.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "ADJUD"
                  }
                }
              ]
            },
            {
              "code" : "ActAdjudicationResultActionType",
              "display" : "ActAdjudicationResultActionType",
              "definition" : "**Description:** Actions to be carried out by the recipient of the Adjudication Result information.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.17472"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActCareProvisionCode",
          "display" : "ActCareProvisionCode",
          "definition" : "**Description:**The type and scope of responsibility taken-on by the performer of the Act for a specific subject of care.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "PCPR"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19789"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActCareProvisionRequestType",
              "display" : "ActCareProvisionRequestType",
              "definition" : "**Description:**Concepts identifying different types of referral requests. These concepts identify the general type of care or category of services requested. They are not used to represent the indication or diagnosis which triggered the need for the referral. E.g. Anger management service, Intensive Care service, Orthodontics service.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActCredentialedCareCode",
              "display" : "ActCredentialedCareCode",
              "definition" : "**Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by a credentialing agency, i.e. government or non-government agency. Failure in executing this Act may result in loss of credential to the person or organization who participates as performer of the Act. Excludes employment agreements.\r\n\r\n**Example:**Hospital license; physician license; clinic accreditation.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19790"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActCredentialedCareProvisionPersonCode",
                  "display" : "ActCredentialedCareProvisionPersonCode",
                  "definition" : "**Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by an agency for credentialing individuals.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19791"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActCredentialedCareProvisionProgramCode",
                  "display" : "ActCredentialedCareProvisionProgramCode",
                  "definition" : "**Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by an agency for credentialing programs within organizations.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19792"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActEncounterType",
              "display" : "ActEncounterType",
              "definition" : "Concepts representing types of patient encounter such as ambulatory encounter, inpatient encounter or emergency encounter.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "ActEncounterAmbulatoryType",
                  "display" : "ActEncounterAmbulatoryType",
                  "definition" : "**Definition:**A comprehensive term for health care provided in a healthcare facility (e.g. a practitioneraTMs office, clinic setting, or hospital) on a nonresident basis. The term ambulatory usually implies that the patient has come to the location and is not assigned to a bed. Sometimes referred to as an outpatient encounter.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20356"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterEmergencyType",
                  "display" : "ActEncounterEmergencyType",
                  "definition" : "**Definition:**A patient encounter that takes place at a dedicated healthcare service delivery location where the patient receives immediate evaluation and treatment, provided until the patient can be discharged or responsibility for the patient's care is transferred elsewhere (for example, the patient could be admitted as an inpatient or transferred to another facility.)",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20357"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterFieldType",
                  "display" : "ActEncounterFieldType",
                  "definition" : "**Definition:**A patient encounter that takes place both outside a dedicated service delivery location and outside a patient's residence. Example locations might include an accident site and at a supermarket.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20358"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterHomeHealthType",
                  "display" : "ActEncounterHomeHealthType",
                  "definition" : "**Definition:**Healthcare encounter that takes place in the residence of the patient or a designee",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20359"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterInpatientType",
                  "display" : "ActEncounterInpatientType",
                  "definition" : "**Definition:**A patient encounter where a patient is admitted by a hospital or equivalent facility, assigned to a location where patients generally stay at least overnight and provided with room, board, and continuous nursing service.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.16847"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterShortStayType",
                  "display" : "ActEncounterShortStayType",
                  "definition" : "**Definition:**An encounter where the patient is admitted to a health care facility for a predetermined length of time, usually less than 24 hours.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20360"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "ActEncounterVirtualType",
                  "display" : "ActEncounterVirtualType",
                  "definition" : "**Definition:**A patient encounter where the patient and the practitioner(s) are not in the same physical location. Examples include telephone conference, email exchange, robotic surgery, and televideo conference.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20361"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                },
                {
                  "code" : "EncounterAccident",
                  "display" : "EncounterAccident",
                  "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "ENC"
                      }
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "ActEncounterCode"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActEncounterCode",
              "display" : "ActEncounterCode",
              "definition" : "Concepts representing types of patient encounter such as ambulatory encounter, inpatient encounter or emergency encounter.  Note that this code is a synonym of ActEncounterType, and follows the original naming conventions for v3 Concept Domains, and is as published in the CDA R2 base; the naming conventions were corrected in later revisions of V3, but is kept here for backwards compatibility for the CDA R2 base.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "cda"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "ActEncounterType"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActCodeProcessStep",
          "display" : "ActCodeProcessStep",
          "definition" : "**Description:** Codes for general process steps.\r\n\r\n**Examples:**\r\n\r\n *  lab process steps\r\n *  diagnostic imaging process steps\r\n *  etc. *(Missing third example)*",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "SPCTRT"
              }
            },
            {
              "code" : "contextBindingX1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20340"
            },
            {
              "code" : "contextBindingX1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingX1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActLabProcessCodes",
              "display" : "ActLabProcessCodes",
              "definition" : "Codes for general laboratory process steps.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "ACT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ActInfoPersistCode",
                  "display" : "ActInfoPersistCode",
                  "definition" : "The act of storing information to long term storage.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "STORE"
                      }
                    }
                  ]
                },
                {
                  "code" : "ActObservationVerificationCode",
                  "display" : "ActObservationVerificationCode",
                  "definition" : "The act of verifying an observations. The subject act related to the observation verification (act relationship SUBJ) must be an observation (OBS)",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "OBS"
                      }
                    }
                  ]
                },
                {
                  "code" : "ActSpecimenAccessionCode",
                  "display" : "ActSpecimenAccessionCode",
                  "definition" : "The accession act related to a specimen or group of specimens.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "ACSN"
                      }
                    }
                  ]
                },
                {
                  "code" : "ActSpecimenLabelCode",
                  "display" : "ActSpecimenLabelCode",
                  "definition" : "The act of printing a specimen label. The printing of a label for a specimen container is a significant act in the workflow for collecting specimens.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "PROC"
                      }
                    }
                  ]
                },
                {
                  "code" : "ActSpecimenManifestCode",
                  "display" : "ActSpecimenManifestCode",
                  "definition" : "The act of adding a specimen to a transportation manifest. For example a laboratory will pack together in a carton all the specimens to be shipped to a reference lab. An electronic manifest showing all the specimens in the shippment is communicated to the reference lab.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "TRNS"
                      }
                    }
                  ]
                },
                {
                  "code" : "ActSpecimenTransportCode",
                  "display" : "ActSpecimenTransportCode",
                  "definition" : "Transportation of a specimen.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "TRNS"
                      }
                    }
                  ]
                },
                {
                  "code" : "LabResultReportingProcessStepCode",
                  "display" : "LabResultReportingProcessStepCode",
                  "definition" : "**Definition:**Used to identify if a lab result is reported as preliminary, final, or corrected. Provides a consistent way to distinguish the business or reporting status of the lab result.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingX1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20339"
                    },
                    {
                      "code" : "contextBindingX1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingX1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActCognitiveProfessionalServiceCode",
          "display" : "ActCognitiveProfessionalServiceCode",
          "definition" : "Denotes the specific service that has been performed. This is obtained from the professional service catalog pertaining to the discipline of the health service provider. Professional services are generally cognitive in nature and exclude surgical procedures. E.g. Provided training, Provided drug therapy review, Gave smoking-cessation counseling, etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ]
        },
        {
          "code" : "ActConsentType",
          "display" : "ActConsentType",
          "definition" : "**Definition:** The type of consent directive, e.g., to consent or dissent to collect, access, or use in specific ways within an EHRS or for health information exchange; or to disclose health information for purposes such as research.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "CONS"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20551"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActDataConsentType",
              "display" : "ActDataConsentType",
              "definition" : "**Description:**The type of data consent directive.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActFinancialParticipationConsentType",
              "display" : "ActFinancialParticipationConsentType",
              "definition" : "**Description:**The type of financial participation consent directive.\r\n\r\n**Examples:** The Advanced Beneficiary Notice that Medicare patients consent or dissent to prior to receiving health services in the U.S. \\\\ Current values include consent to financial responsibility (1) if the service is not deemed medically necessary; (2) will self pay for a service; or (3) requests that payer be billed.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActInformationAccessCode",
              "display" : "ActInformationAccessCode",
              "definition" : "**Description:** The type of health information to which the subject of the information or the subject&\\#039;s delegate consents or dissents.\r\n\r\n**Examples:**\r\n\r\n *  allergy information\r\n *  medication information\r\n *  professional services information",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19910"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "AdvanceBeneficiaryNoticeType",
              "display" : "AdvanceBeneficiaryNoticeType",
              "definition" : "**Description:**\r\n\r\nRepresents types of consent that patient must sign prior to receipt of service, which is required for billing purposes.\r\n\r\n**Examples:**\r\n\r\n *  Advanced beneficiary medically necessity notice.\r\n *  Advanced beneficiary agreement to pay notice.\r\n *  Advanced beneficiary requests payer billed.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CONS"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ActContractType",
          "display" : "ActContractType",
          "definition" : "An agreement of obligation between two or more parties that is subject to contractual law and enforcement.\r\n\r\n*Examples:* approvals granted by a regulatory agency; contracts measured in financial terms; insurance coverage contracts.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "CNTRCT"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActFinancialContractType",
              "display" : "ActFinancialContractType",
              "definition" : "A type of Act representing a contract whose value is measured in monetary terms.\r\n\r\n**Examples:**\r\n\r\n *  insurance policy\r\n *  providercontract\r\n *  billing arrangement",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "FCNTRCT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ActCoverageTypeCode",
                  "display" : "ActCoverageTypeCode",
                  "definition" : "**Definition:** Set of codes indicating the type of insurance policy or program that pays for the cost of benefits provided to covered parties.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "COV"
                      }
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19855"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ActCoverageEligibilityConfirmationCode",
                      "display" : "ActCoverageEligibilityConfirmationCode",
                      "definition" : "Indication of eligibility coverage for healthcare service(s) and/or product(s).",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "COV"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ActCoverageLimitCode",
                      "display" : "ActCoverageLimitCode",
                      "definition" : "Criteria that are applicable to the authorized coverage.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "COV"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ActCoverageQuantityLimitCode",
                          "display" : "ActCoverageQuantityLimitCode",
                          "definition" : "Maximum amount paid or maximum number of services/products covered; or maximum amount or number covered during a specified time period under the policy or program.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingC1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19933"
                            },
                            {
                              "code" : "contextBindingC1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingC1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "ActCoveredPartyLimitCode",
                          "display" : "ActCoveredPartyLimitCode",
                          "definition" : "Codes representing the types of covered parties that may receive covered benefits under a policy or program.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "ActCoveragePartyLimitGroupCode",
                              "display" : "ActCoveragePartyLimitGroupCode",
                              "definition" : "Codes representing the level of coverage provided under the policy or program in terms of the types of entities that may play covered parties based on their personal relationships or employment status.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "ActInsurancePolicyType",
                      "display" : "ActInsurancePolicyType",
                      "definition" : "**Description:** Types of insurance coverage legal documentation to cover healthcare costs.\r\n\r\n*Examples:* \r\n\r\n *  Automobile\r\n *  Extended healthcare\r\n *  Worker's compensation",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19350"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "ActInsuranceTypeCode",
                      "display" : "ActInsuranceTypeCode",
                      "definition" : "**Definition:** Set of codes indicating the type of insurance policy. Insurance, in law and economics, is a form of risk management primarily used to hedge against the risk of potential financial loss. Insurance is defined as the equitable transfer of the risk of a potential loss, from one entity to another, in exchange for a premium and duty of care. A policy holder is an individual or an organization enters into a contract with an underwriter which stipulates that, in exchange for payment of a sum of money (a premium), one or more covered parties (insureds) is guaranteed compensation for losses resulting from certain perils under specified conditions. The underwriter analyzes the risk of loss, makes a decision as to whether the risk is insurable, and prices the premium accordingly. A policy provides benefits that indemnify or cover the cost of a loss incurred by a covered party, and may include coverage for services required to remediate a loss. An insurance policy contains pertinent facts about the policy holder, the insurance coverage, the covered parties, and the insurer. A policy may include exemptions and provisions specifying the extent to which the indemnification clause cannot be enforced for intentional tortious conduct of a covered party, e.g., whether the covered parties are jointly or severably insured.\r\n\r\n*Discussion:* In contrast to programs, an insurance policy has one or more policy holders, who own the policy. The policy holder may be the covered party, a relative of the covered party, a partnership, or a corporation, e.g., an employer. A subscriber of a self-insured health insurance policy is a policy holder. A subscriber of an employer sponsored health insurance policy is holds a certificate of coverage, but is not a policy holder; the policy holder is the employer. See CoveredRoleType.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingC1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19856"
                        },
                        {
                          "code" : "contextBindingC1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingC1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ActHealthInsuranceTypeCode",
                          "display" : "ActHealthInsuranceTypeCode",
                          "definition" : "**Definition:** Set of codes indicating the type of health insurance policy that covers health services provided to covered parties. A health insurance policy is a written contract for insurance between the insurance company and the policyholder, and contains pertinent facts about the policy owner (the policy holder), the health insurance coverage, the insured subscribers and dependents, and the insurer. Health insurance is typically administered in accordance with a plan, which specifies (1) the type of health services and health conditions that will be covered under what circumstances (e.g., exclusion of a pre-existing condition, service must be deemed medically necessary; service must not be experimental; service must provided in accordance with a protocol; drug must be on a formulary; service must be prior authorized; or be a referral from a primary care provider); (2) the type and affiliation of providers (e.g., only allopathic physicians, only in network, only providers employed by an HMO); (3) financial participations required of covered parties (e.g., co-pays, coinsurance, deductibles, out-of-pocket); and (4) the manner in which services will be paid (e.g., under indemnity or fee-for-service health plans, the covered party typically pays out-of-pocket and then file a claim for reimbursement, while health plans that have contractual relationships with providers, i.e., network providers, typically do not allow the providers to bill the covered party for the cost of the service until after filing a claim with the payer and receiving reimbursement).",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingC1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19857"
                            },
                            {
                              "code" : "contextBindingC1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingC1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "ActProgramTypeCode",
                      "display" : "ActProgramTypeCode",
                      "definition" : "**Definition:** A set of codes used to indicate coverage under a program. A program is an organized structure for administering and funding coverage of a benefit package for covered parties meeting eligibility criteria, typically related to employment, health, financial, and demographic status. Programs are typically established or permitted by legislation with provisions for ongoing government oversight. Regulations may mandate the structure of the program, the manner in which it is funded and administered, covered benefits, provider types, eligibility criteria and financial participation. A government agency may be charged with implementing the program in accordance to the regulation. Risk of loss under a program in most cases would not meet what an underwriter would consider an insurable risk, i.e., the risk is not random in nature, not financially measurable, and likely requires subsidization with government funds.\r\n\r\n*Discussion:* Programs do not have policy holders or subscribers. Program eligibles are enrolled based on health status, statutory eligibility, financial status, or age. Program eligibles who are covered parties under the program may be referred to as members, beneficiaries, eligibles, or recipients. Programs risk are underwritten by not for profit organizations such as governmental entities, and the beneficiaries typically do not pay for any or some portion of the cost of coverage. See CoveredPartyRoleType.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingC1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19858"
                        },
                        {
                          "code" : "contextBindingC1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingC1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActFinancialTransactionType",
              "display" : "ActFinancialTransactionType",
              "definition" : "A type of Act representing any transaction between two accounts whose value is measured in monetary terms.\r\n\r\n**Examples:**\r\n\r\n *  patient account transaction\r\n *  encounter accounttransaction\r\n *  cost center transaction",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "XACT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ActBillingArrangementType",
                  "display" : "ActBillingArrangementType",
                  "definition" : "**Description:** Types of provision(s) made for reimbursing for the deliver of healthcare services and/or goods provided by a Provider for one or more occurrence or over a specified period.\r\n\r\n*Examples:* \r\n\r\n *  Contract\r\n *  Rostering\r\n *  Capitation",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.17478"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActDataOperationType",
          "display" : "ActDataOperationType",
          "definition" : "**Description:** Types of operations that may be performed on objects. Here, objects are broadly understood as information system-related entities (e.g., devices, files, records, tables, processes, programs, domains) containing or receiving information.\r\n\r\n**Examples:**\r\n\r\n *  Create\r\n *  Update\r\n *  Delete\r\n\r\n*Open Issue:* This is too restrictive to deal with what CBCC wants.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "CACT"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActDataAccessOperationType",
              "display" : "ActDataAccessOperationType",
              "definition" : "**Description:** Types of operations that may accomplish access of information. Here, objects are broadly understood as information system-related entities (e.g., devices, files, records, tables, processes, programs, domains) containing or receiving information.\r\n\r\n**Examples:**\r\n\r\n *  Query\r\n *  Search\r\n *  Transport\r\n *  Send\r\n *  Receive",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                }
              ]
            },
            {
              "code" : "ActDataCollectionOperationType",
              "display" : "ActDataCollectionOperationType",
              "definition" : "**Description:** Types of operations that may accomplish collection or related management of information. Here, objects are broadly understood as information system-related entities (e.g., devices, files, records, tables, processes, programs, domains) containing or receiving information.\r\n\r\n**Examples:**\r\n\r\n *  Create\r\n *  Store\r\n *  Archive",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                }
              ]
            },
            {
              "code" : "ActDataDisclosureOperationType",
              "display" : "ActDataDisclosureOperationType",
              "definition" : "**Description:** Types of operations that may accomplish disclosure of information. Here, objects are broadly understood as information system-related entities (e.g., devices, files, records, tables, processes, programs, domains) containing or receiving information.\r\n\r\n**Examples:**\r\n\r\n *  Disclose\r\n *  Forward\r\n *  Publish",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                }
              ]
            },
            {
              "code" : "ActDataUseOperationType",
              "display" : "ActDataUseOperationType",
              "definition" : "**Description:** Types of operations that may accomplish usage of information. Here, objects are broadly understood as information system-related entities (e.g., devices, files, records, tables, processes, programs, domains) containing or receiving information.\r\n\r\n**Examples:**\r\n\r\n *  Activate\r\n *  Release\r\n *  Execute Read\r\n *  Display\r\n *  Update\r\n *  Append\r\n *  Amend",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ActDetectedIssueManagementType",
          "display" : "ActDetectedIssueManagementType",
          "definition" : "**Description:** Issue management types that dealing with detected issue observations.\r\n\r\n*Rationale:* Allows for consistent specification and interpretation of issue management.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.16695"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActDisciplinaryActionCode",
          "display" : "ActDisciplinaryActionCode",
          "definition" : "Includes coded types of actions that can be taken by a supervising entity in response to inappropriate action (or inaction) on the part of a supervised entity.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "DISPACT"
              }
            }
          ]
        },
        {
          "code" : "ActEventCategoryWorkingListType",
          "display" : "ActEventCategoryWorkingListType",
          "definition" : "**Description:** List of broad catagorizations of clinical event records.\r\n\r\n**Examples:**\r\n\r\n *  Allergies\r\n *  Drugs\r\n *  Referrals",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "LIST"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActCommonCodedClinicalObservationCategoryListType",
              "display" : "ActCommonCodedClinicalObservationCategoryListType",
              "definition" : "**Description:**Lists of high-level categorizations for clinical coded observations that do not require numeric values with a specific unit of measure.\r\n\r\n**Examples:**\r\n\r\n *  Symptoms\r\n *  History\r\n *  Observations",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "LIST"
                  }
                }
              ]
            },
            {
              "code" : "ActSimpleMeasurableClinicalObservationCategoryListType",
              "display" : "ActSimpleMeasurableClinicalObservationCategoryListType",
              "definition" : "**Description:** of high-level categorization for clinical non-laboratory and non-diagnostic image measured observations with numeric values and specific units of measure.\r\n\r\n**Examples:**\r\n\r\n *  Vital Signs\r\n *  Physiological Measurements\r\n *  Procedure Results",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "LIST"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ActEventCriteriaType",
          "display" : "ActEventCriteriaType",
          "definition" : "**Description:** Describes types of criteria used when making observations, conducting procedures, and substance administrations.\r\n\r\n**Examples:**\r\n\r\n *  medications\r\n *  immunizations",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActProcedureEventCriteriaType",
              "display" : "ActProcedureEventCriteriaType",
              "definition" : "**Description:** of procedure used for evaluating a precondition, goal, or trigger.\r\n\r\n**Examples:**\r\n\r\n *  some radiology procedures\r\n *  respiratory therapy\r\n *  physical therapy",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
                    "code" : "EVN.CRT"
                  }
                }
              ]
            },
            {
              "code" : "ActSubstanceAdministrationEventCriteriaType",
              "display" : "ActSubstanceAdministrationEventCriteriaType",
              "definition" : "**Description:** Type of substance administration used for evaluating a precondition, goal, or trigger.\r\n\r\n**Examples:**\r\n\r\n *  other substance administrations\r\n *  respiratory therapy\r\n *  immunizations",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
                    "code" : "EVN.CRT"
                  }
                }
              ]
            },
            {
              "code" : "ObservationEventCriteriaType",
              "display" : "ObservationEventCriteriaType",
              "definition" : "**Description:** of observation used for evaluating a precondition, goal, or trigger.\r\n\r\n**Examples:**\r\n\r\n *  age-based criteria\r\n *  diagnostic-based criteria\r\n *  simple observation-based criteria (vital signs)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
                    "code" : "EVN.CRT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ObservationEventLabCriteriaType",
                  "display" : "ObservationEventLabCriteriaType",
                  "definition" : "**Description:** Type of observation used in lab for evaluating reference ranges.\r\n\r\n**Examples:**\r\n\r\n *  age-based criteria\r\n *  sex-based criteria\r\n *  condition-based criteria",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
                        "code" : "EVN.CRT"
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActExposureCode",
          "display" : "ActExposureCode",
          "definition" : "Concepts that identify the type or nature of exposure interaction. Examples include \"household\", \"care giver\", \"intimate partner\", \"common space\", \"common substance\", etc. to further describe the nature of interaction.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "EXPOS"
              }
            },
            {
              "code" : "contextBindingX1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19938"
            },
            {
              "code" : "contextBindingX1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingX1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActFinancialDetectedIssueManagementCode",
          "display" : "ActFinancialDetectedIssueManagementCode",
          "definition" : "Codes dealing with the management of Detected Issue observations for the financial acts domain.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ]
        },
        {
          "code" : "ActIncidentCode",
          "display" : "ActIncidentCode",
          "definition" : "**Definition:** Set of codes indicating the type of incident or accident.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "INC"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActPatientSafetyIncidentCode",
              "display" : "ActPatientSafetyIncidentCode",
              "definition" : "**Definition:** A code specifying the particular kind of Patient Safety Incident that the Incident class instance represents.\r\n\r\n**Examples:**\"Medication incident\", \"slips, trips and falls incident\".The actual value set for the domain will be determined by each (realm) implementation, whose Patient Safety terminology will be specific, although probably linked to the WHO Patient Safety Taxonomy that is currently under development\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActInformationTransferCode",
          "display" : "ActInformationTransferCode",
          "definition" : "**Description:** Conveyance of the type of information transfer protocol.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "TRFR"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20289"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActInvoiceElementCode",
          "display" : "ActInvoiceElementCode",
          "definition" : "Type of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "INVE"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19397"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActInvoiceDetailCode",
              "display" : "ActInvoiceDetailCode",
              "definition" : "Codes representing a service or product that is being invoiced (billed). The code can represent such concepts as \"office visit\", \"drug X\", \"wheelchair\" and other billable items such as taxes, service charges and discounts.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19401"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActInvoiceDetailClinicalProductCode",
                  "display" : "ActInvoiceDetailClinicalProductCode",
                  "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActInvoiceDetailClinicalServiceCode",
                  "display" : "ActInvoiceDetailClinicalServiceCode",
                  "definition" : "An identifying data string for healthcare procedures.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CPT4",
                      "display" : "CPT4",
                      "definition" : "**Description:**Physicians Current Procedural Terminology (CPT) Manual is a listing of descriptive terms and identifying codes for reporting medical services and procedures performed by physicians. Available for the AMA at the address listed for CPT above. These codes are found in Appendix A of CPT 2000 Standard Edition. (CPT 2000 Standard Edition, American Medical Association, Chicago, IL).\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "CPT5",
                      "display" : "CPT5",
                      "definition" : "**Description:**Physicians Current Procedural Terminology (CPT) Manual is a listing of descriptive terms and identifying codes for reporting medical services and procedures performed by physicians. Available for the AMA at the address listed for CPT above. These codes are found in Appendix A of CPT 2000 Standard Edition. (CPT 2000 Standard Edition, American Medical Association, Chicago, IL).\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "HCPCS",
                      "display" : "HCPCS",
                      "definition" : "**Description:**Health Care Financing Administration Common Procedural Coding System (HCPCS) Codes are procedure identifying codes. HCPCS is Health Care Finance AdministrationaTMs (HFCA) coding scheme to group procedures performed for payment to providers. contains codes for medical equipment, injectable drugs, transportation services, and other services not found in CPT4.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ICD10PCS",
                      "display" : "ICD10PCS",
                      "definition" : "**Description:**International Classification of Diseases, 10th Revision, Procedure Coding System (ICD-10-PCS) are procedure identifying codes. ICD-10-PCS describes the classification of inpatient procedures for statistical purposes.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ICD9PCS",
                      "display" : "ICD9PCS",
                      "definition" : "**Description:**International Classification of Diseases, 9th Revision, Procedure Coding System (ICD-9-PCS) are procedure identifying codes. ICD-9-PCS describes the classification of inpatient procedures for statistical purposes.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ActInvoiceDetailTaxType",
                  "display" : "ActInvoiceDetailTaxType",
                  "definition" : "**Description:** Types of tax associated with billable services or products.\r\n\r\n*Examples:* \r\n\r\n *  Provincial or State sales tax\r\n *  Harmonized sales tax\r\n *  Federal sales tax",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19409"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "HCPCSAccommodationCode",
                  "display" : "HCPCSAccommodationCode",
                  "definition" : "**Description:**External value set for accommodation types used in the U.S. Health Care Financing Administration (HCFA) Common Procedure Coding System (HCPCS) including modifiers.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActInvoiceElementSummaryType",
              "display" : "ActInvoiceElementSummaryType",
              "definition" : "**Description:** Types of summary information that can be reported by queries dealing with Statement of Financial Activity (SOFA). The summary information is generally used to help resolve balance discrepancies between providers and payors.\r\n\r\n*Examples:* \r\n\r\n *  number and total value of payable items;\r\n *  number and value of same period nullify items;\r\n *  number and value of prior nullify;\r\n *  number of non-payable nullify items;\r\n *  number of pending items;\r\n *  number of rejected items;\r\n *  number of adjudicated to zero items;\r\n *  reimbursement items (e.g., pay patient)\r\n *  Adjudicated non-payee payable prior-period electronic amount\r\n *  Adjudicated nullified prior-period electronic amount\r\n *  Adjudicated refused prior-period electronic amount",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.17522"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActInvoiceAdjudicationPaymentSummaryType",
                  "display" : "ActInvoiceAdjudicationPaymentSummaryType",
                  "definition" : "**Description:** Types of grouping of invoice elements (totals, sub-totals), reported through a Payment Advice or a Statement of Financial Activity (SOFA). The code can represent summaries by day, location, payee and other cost elements such as bonus, retroactive adjustment and transaction fees.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19413"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActInvoiceGroupType",
              "display" : "ActInvoiceGroupType",
              "definition" : "**Description:** Types of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results.\r\n\r\nInvoice elements of this type signify a grouping of one or more children (detail) invoice elements. They do not have intrinsic costing associated with them, but merely reflect the sum of all costing for its immediate children invoice elements.\r\n\r\n*Examples:* \r\n\r\n *  CPINV - Clinical product invoice\r\n *  CSINV- Clinical service invoice\r\n *  RXDINV - Drug invoice\r\n *  RXCINV - Compound invoice\r\n *  CSPINV - Combined service and clinical product invoice",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19398"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ActInvoiceOverrideType",
              "display" : "ActInvoiceOverrideType",
              "definition" : "**Description:** Types of responses that will occur as a result of the adjudication of an electronic invoice at a summary level and provides guidance on interpretation of the referenced adjudication results.\r\n\r\n*Examples:* \r\n\r\n *  Re-bill for the professional fee\r\n *  Good faith override\r\n *  Wasted Drug",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.17590"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActListCode",
          "display" : "ActListCode",
          "definition" : "Provides codes associated with ActClass value of LIST (working list)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "LIST"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19364"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActProcedureCategoryList",
              "display" : "ActProcedureCategoryList",
              "definition" : "**Description:**Describes the high level classification of professional services for grouping.\r\n\r\n**Examples:**Education, Counseling, Surgery, etc.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActTherapyDurationWorkingListCode",
              "display" : "ActTherapyDurationWorkingListCode",
              "definition" : "Codes used to identify different types of 'duration-based' working lists. Examples include \"Continuous/Chronic\", \"Short-Term\" and \"As-Needed\".",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19710"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActMedicationTherapyDurationWorkingListCode",
                  "display" : "ActMedicationTherapyDurationWorkingListCode",
                  "definition" : "**Definition:**A collection of concepts that identifies different types of 'duration-based' mediation working lists.\r\n\r\n**Examples:**\"Continuous/Chronic\" \"Short-Term\" and \"As Needed\"",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19788"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActMonitoringProtocolType",
          "display" : "ActMonitoringProtocolType",
          "definition" : "**Description:** Identifies types of monitoring programs such as tracking specified medication prescribing e.g. narcotic(s), identifying investigational studies or identifying programs regarding reimbursement or prescribing privileges.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.16231"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActNonObservationIndicationCode",
          "display" : "ActNonObservationIndicationCode",
          "definition" : "**Description:**Concepts representing indications (reasons for clinical action) other than diagnosis and symptoms.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19778"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActOrderCode",
          "display" : "ActOrderCode",
          "definition" : "The type of order that was fulfilled by the clinical service",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ]
        },
        {
          "code" : "ActPolicyType",
          "display" : "ActPolicyType",
          "definition" : "**Description:**Types of policies that further specify the ActClassPolicy value set.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "POLICY"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19886"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActPrivacyPolicyType",
              "display" : "ActPrivacyPolicyType",
              "definition" : "**Description:**Types of privacy policies that further specify the ActClassPolicy value set e.g. override policy, minor's rights to mask sensitive information policy, opt-in, opt-out policy.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20424"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActConsentDirectiveType",
                  "display" : "ActConsentDirectiveType",
                  "definition" : "**Description:**Specifies the type of consent directive indicated by an ActClassPolicy e.g., a 3rd party authorization to disclose or consent for a substitute decision maker (SDM) or a notice of privacy policy. Sibling to ActPrivacyPolicyType and Child of ActPolicyType.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20425"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActPrivacyLawPolicyType",
                  "display" : "ActPrivacyLawPolicyType",
                  "definition" : "**Description:** Types of jurisdictional mandates relating to privacy.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingX1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20426"
                    },
                    {
                      "code" : "contextBindingX1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingX1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActSensitivityPrivacyPolicyType",
                  "display" : "ActSensitivityPrivacyPolicyType",
                  "definition" : "A sensitivity policy is adopted by an enterprise or group of enterprises (a \"policy domain\") through a formal data use agreement that stipulates the value, importance, and vulnerability of information. A sensitivity code representing a sensitivity policy may be associated with criteria such as categories of information or sets of information identifiers (e.g., a value set of clinical codes or branch in a code system hierarchy). These criteria may in turn be used for the Policy Decision Point in a Security Engine. A sensitivity code may be used to set the confidentiality code used on information about Acts and Roles to trigger the security mechanisms required to control how security principals (i.e., a person, a machine, a software application) may act on the information (e.g., collection, access, use, or disclosure). Sensitivity codes are never assigned to the transport or business envelope containing patient specific information being exchanged outside of a policy domain as this would disclose the information intended to be protected by the policy. When sensitive information is exchanged with others outside of a policy domain, the confidentiality code on the transport or business envelope conveys the receiver's responsibilities and indicates the how the information is to be safeguarded without unauthorized disclosure of the sensitive information. This ensures that sensitive information is treated by receivers as the sender intends, accomplishing interoperability without point to point negotiations.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20428"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ActEntityInformationSensitivityPrivacyPolicyType",
                      "display" : "ActEntityInformationSensitivityPrivacyPolicyType",
                      "definition" : "**Description:** Types of Sensitivity policies that may apply to a sensitive attribute on an Entity.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActInformationSensitivityPrivacyPolicyType",
                      "display" : "ActInformationSensitivityPrivacyPolicyType",
                      "definition" : "**Description:** Types of sensitivity policies that apply to Acts.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActRoleInformationSensitivityPrivacyPolicyType",
                      "display" : "ActRoleInformationSensitivityPrivacyPolicyType",
                      "definition" : "**Description:** Types of sensitivity policies that apply to Roles.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20430"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActSecurityPolicyType",
              "display" : "ActSecurityPolicyType",
              "definition" : "Types of security policies that further specify the ActClassPolicy value set.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20444"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActObligationSecurityPolicyType",
                  "display" : "ActObligationSecurityPolicyType",
                  "definition" : "Conveys the mandated workflow action that an information custodian, receiver, or user must perform.\r\n\r\n*Usage Note:* Per ISO 22600-2, ObligationPolicy instances \"are event-triggered and define actions to be performed by manager agent\". Per HL7 Composite Security and Privacy Domain Analysis Model: This value set refers to the action required to receive the permission specified in the privacy rule. Per OASIS XACML, an obligation is an operation specified in a policy or policy that is performed in conjunction with the enforcement of an access control decision.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20445"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActRefrainSecurityPolicyType",
                  "display" : "ActRefrainSecurityPolicyType",
                  "definition" : "Conveys prohibited actions which an information custodian, receiver, or user is not permitted to perform unless otherwise authorized or permitted under specified circumstances.\r\n\r\n*Usage Notes:* ISO 22600-2 species that a Refrain Policy \"defines actions the subjects must refrain from performing\". Per HL7 Composite Security and Privacy Domain Analysis Model: May be used to indicate that a specific action is prohibited based on specific access control attributes e.g., purpose of use, information type, user role, etc.",
                  "property" : [
                    {
                      "code" : "HL7usageNotes",
                      "valueString" : "ISO 22600-2 species that a Refrain Policy \"defines actions the subjects must refrain from performing\".  Per HL7 Composite Security and Privacy Domain Analysis Model:  May be used to indicate that a specific action is prohibited based on specific access control attributes e.g., purpose of use, information type, user role, etc."
                    },
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20446"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActTrustPolicyType",
                  "display" : "ActTrustPolicyType",
                  "definition" : "A mandate, obligation, requirement, rule, or expectation conveyed as security metadata between senders and receivers required to establish the reliability, authenticity, and trustworthiness of their transactions.\r\n\r\nTrust security metadata are observation made about aspects of trust applicable to an IT resource (data, information object, service, or system capability).\r\n\r\nTrust applicable to IT resources is established and maintained in and among security domains, and may be comprised of observations about the domain's trust authority, trust framework, trust policy, trust interaction rules, means for assessing and monitoring adherence to trust policies, mechanisms that enforce trust, and quality and reliability measures of assurance in those mechanisms. \\[Based on ISO IEC 10181-1 and NIST SP 800-63-2\\]\r\n\r\nFor example, identity proofing level of assurance and Trust Framework.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20530"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActPreferenceType",
          "display" : "ActPreferenceType",
          "definition" : "Concepts representing a type of preference that can be specified.\r\n\r\n**Examples:** \r\n\r\n *  Food\r\n *  Drug\r\n *  Vegetarian\r\n *  Sweets",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActProcedureCode",
          "display" : "ActProcedureCode",
          "definition" : "**Description:** An identifying code for healthcare interventions/procedures.\r\n\r\n**Examples:**\r\n\r\n *  immunization\r\n *  appendectomy\r\n *  physiotherapy",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "PROC"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActBillableServiceCode",
              "display" : "ActBillableServiceCode",
              "definition" : "**Definition:** An identifying code for billable services, as opposed to codes for similar services used to identify them for functional purposes.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "ActBillableTreatmentPlanCode",
                  "display" : "ActBillableTreatmentPlanCode",
                  "definition" : "*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActMedicalBillableServiceCode",
                  "display" : "ActMedicalBillableServiceCode",
                  "definition" : "**Definition:** An identifying code for billable medical services, as opposed to codes for similar services to identify them for clinical purposes.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActNonMedicalBillableServiceCode",
                  "display" : "ActNonMedicalBillableServiceCode",
                  "definition" : "**Definition:** An identifying code for billable services that are not medical procedures, such as social services or governmental program services.\r\n\r\n**Example:** Building a wheelchair ramp, help with groceries, giving someone a ride, etc.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActMolecularInteractionType",
              "display" : "ActMolecularInteractionType",
              "definition" : "Chemical reactions in the widest sense of the word.\r\n\r\n*Examples:* Transcription (creating mRNA from a DNA gene), translation (creating a protein from mRNA), cleavage (hydrolysis of a peptide), substitution (replacing an element or residue with another, such as in glycosylation, phosphorylation), addition (adding a residue to a double bond), receptor binding.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActOralHealthProcedureCode",
              "display" : "ActOralHealthProcedureCode",
              "definition" : "**Description:**An identifying code for oral health interventions/procedures.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActOrderableProcedureCode",
              "display" : "ActOrderableProcedureCode",
              "definition" : "**Description:** Concept domain which includes those ActProcedureCodes which are appropriate for ordering.\r\n\r\n**Examples:**\r\n\r\n *  physical therapies\r\n *  excisions\r\n *  surgery",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "PROC"
                  }
                }
              ]
            },
            {
              "code" : "ActProductReconstitutionType",
              "display" : "ActProductReconstitutionType",
              "definition" : "DESCRIPTION\r\n\r\nIdentifies the nature (or type) of transformation that a (medicinal) product may undergo, prior to its administration to a patient.\r\n\r\n**Examples:**\r\n\r\n *  Dilution\r\n *  Dissolution\r\n *  Suspension",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActProfessionalServiceCode",
              "display" : "ActProfessionalServiceCode",
              "definition" : "**Description:** Denotes the specific professional service that has been performed. This is obtained from the professional service catalog pertaining to the discipline of the health service provider.\r\n\r\n**Examples:**\r\n\r\n *  adjustment of hearing aid\r\n *  excision of skin lesion\r\n *  stitching skin lacerations",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActSpecimenCollectionProcedureType",
              "display" : "ActSpecimenCollectionProcedureType",
              "definition" : "**Description:** Used to further classify the type of specimen collection procedure being documented.\r\n\r\n**Examples:**\r\n\r\n *  Venipuncture\r\n *  Swab\r\n *  Biopsy",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "SPECCOLLECT"
                  }
                }
              ]
            },
            {
              "code" : "ActSubstanceAdministrationCode",
              "display" : "ActSubstanceAdministrationCode",
              "definition" : "Describes the type of substance administration being performed. This should not be used to carry codes for identification of products. Use an associated role or entity to carry such information.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "SBADM"
                  }
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19708"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "SubstanceAdministrationActCode"
                }
              ],
              "concept" : [
                {
                  "code" : "ActSubstanceAdministrationImmunizationCode",
                  "display" : "ActSubstanceAdministrationImmunizationCode",
                  "definition" : "The introduction of ??? with the intent of stimulating an immune response, aimed at preventing subsequent infections by more viable agents.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19709"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    },
                    {
                      "code" : "subsumedBy",
                      "valueCode" : "SubstanceAdministrationActCode"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SubstanceAdministrationActCode",
              "display" : "SubstanceAdministrationActCode",
              "definition" : "Describes the type of substance administration being performed. This should not be used to carry codes for identification of products. Use an associated role or entity to carry such information.  Note that this code is a synonym of ActSubstanceAdministrationCode, and follows the original naming conventions for v3 Concept Domains, and is as published in the CDA R2 base; the naming conventions were corrected in later revisions of V3, but is kept here for backwards compatibility for the CDA R2 base.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "cda"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "SBADM"
                  }
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "ActSubstanceAdministrationCode"
                }
              ]
            },
            {
              "code" : "ActSubstanceDerivationType",
              "display" : "ActSubstanceDerivationType",
              "definition" : "Acts of producing a substance by processing input material in any way thus deriving the product substance from the inputs\r\n\r\n*Examples:* Fermentation, filtration, separation, extraction, or any complex procedure involving multiple such steps.\r\n\r\n*UsageNotes:* This domain may involve molecular interactions as components, but substance derivation - even if implementing a single defined reaction on the molecular level - implies not only that reaction but the methods and devices by which to induce that reaction.",
              "property" : [
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "This domain may involve molecular interactions as components, but substance derivation - even if implementing a single defined reaction on the molecular level - implies not only that reaction but the methods and devices by which to induce that reaction."
                },
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActSubstanceExtractionCode",
              "display" : "ActSubstanceExtractionCode",
              "definition" : "**Description:** In addition to the class code, further defines the type of substance extraction.\r\n\r\n**Examples:**\r\n\r\n *  excision\r\n *  surgical\r\n *  passive",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "ActBloodDonationType",
                  "display" : "ActBloodDonationType",
                  "definition" : "**Description:** Defines the type of blood donation.\r\n\r\n**Examples:**\r\n\r\n *  autologous\r\n *  directed\r\n *  volunteer",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "NutritionModificationType",
              "display" : "NutritionModificationType",
              "definition" : "Concepts that are used to convey modifications to the food or serving utensils that should be given in a diet order. These can be derived from patient allergies, intolerances, or preferences. They can also be specific to the order and not have any relationship to the allergies, intolerances, or preferences.\r\n\r\n**Examples:** \r\n\r\n *  Vegetarian\r\n *  Liquids separate from solids\r\n *  Small Portions\r\n *  disposable utensils (for psych or isolation rooms)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "DietTextureModificationType",
                  "display" : "DietTextureModificationType",
                  "definition" : "A set of concepts that identifies any texture modifications that should be made to a diet order.\r\n\r\n**Examples:** \r\n\r\n *  Pudding Thick\r\n *  Pureed\r\n *  Easy to Chew",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActProductApprovalType",
          "display" : "ActProductApprovalType",
          "definition" : "**Description:** An approval granted to a product by a regulatory agency or other government body.\r\n\r\n**Examples:**\r\n\r\n *  Approval to sell\r\n *  Approval to initiate clinical trial\r\n *  Approval to market (i.e., advertise)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "CNTRCT"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActProductApprovalApplicationType",
              "display" : "ActProductApprovalApplicationType",
              "definition" : "**Description:** A type of application made in order to obtain a product approval from a regulatory agency or other government body.\r\n\r\n**Examples:**\r\n\r\n *  Application for new approval\r\n *  Application for renewal of approval\r\n *  Application for variation of approval",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActProductApprovalProcessType",
              "display" : "ActProductApprovalProcessType",
              "definition" : "**Description:** A type of approval process by which a product approval is obtained from a regulatory agency or other government body.\r\n\r\n**Examples:**\r\n\r\n *  Centralized process approval\r\n *  Mutual recognition process approval\r\n *  National process approval",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActProvenanceEventCurrentStateType",
          "display" : "ActProvenanceEventCurrentStateType",
          "definition" : "Types of state an act may exist in.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingX1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20547"
            },
            {
              "code" : "contextBindingX1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingX1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActReactionActionTakenType",
          "display" : "ActReactionActionTakenType",
          "definition" : "**Description:** A type of act that indicates the action taken by a practitioner or other responsible party in response to the reaction/event that is reported in the ICSR.\r\n\r\n**Examples:**\r\n\r\n *  failing device replaced\r\n *  medication stopped\r\n *  medication dose adjusted",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ]
        },
        {
          "code" : "ActRecordOrganizerType",
          "display" : "ActRecordOrganizerType",
          "definition" : "**Description:** A code further classifying the type of record organizer. Used with the ActClassRecordOrganizer ActClass concept domain.\r\n\r\n**Examples:**\r\n\r\n *  CDA R2\r\n *  \r\n *  Electrolytes Battery\r\n *  Specimen Cluster",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "_ActClassRecordOrganizer"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActCompositionType",
              "display" : "ActCompositionType",
              "definition" : "A context representing a grouped commitment of information to the EHR. It is considered the unit of modification of the record, the unit of transmission in record extracts, and the unit of attestation by authorizing clinicians.\r\n\r\n*Examples:* document; authentication unit; transmission unit.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "COMPOSITION"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ActContextOfUseType",
                  "display" : "ActContextOfUseType",
                  "definition" : "Identifies the heading under which a document is to appear in a pre-defined, pro forma table of contents for a collection of documents within a regulatory category.\r\n\r\n**Examples:**\r\n\r\n *  m1-1-forms (eCTD module 1, forms)\r\n *  m1-1-1-fda-form-1571 (eCTD. Module 1, specific FDA form)\r\n *  m3-2-s-drug-substance (eCTD module 3, section 2, drug substance by substance)\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActKeywordsType",
                  "display" : "ActKeywordsType",
                  "definition" : "Codes for additional metadata to be assigned to document or context of use instances to organize a group of documents within the same table of contents heading. These external code systems specify the category or type of keyword (e.g. Species) and the applicable values.\r\n\r\n**Examples:**\r\n\r\n *  Species code system\r\n *  Species code\r\n *  Sponsor's manufacturing site code system\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActRegulatoryCategoryType",
                  "display" : "ActRegulatoryCategoryType",
                  "definition" : "Identifies the regulatory processes and/or submission contents specified in law or practice for a particular realm used to organize submitted materials.\r\n\r\n**Examples:**\r\n\r\n *  Application Type: NDA\r\n *  Submission Type: Efficacy Supplement\r\n *  Submission Unit Type: Amendment\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "DocumentType",
                  "display" : "DocumentType",
                  "definition" : "The kind of document. Possible values: discharge summary, progress note, Oncology note, etc.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "DOC"
                      }
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.10870"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ActFinancialSupportingAttachmentCode",
                      "display" : "ActFinancialSupportingAttachmentCode",
                      "definition" : "**Description:**Identifies the type of document that was attached to support the processing of claims, adjudication decision determination or extensions to coverage.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ActClaimAttachmentCode",
                          "display" : "ActClaimAttachmentCode",
                          "definition" : "**Description:**Contrains the type of attachment (document, XRAY, bit map image, etc.) included to support a healthcare claim. Vocabulary bound to this domain should be a specification for the type of document (i.e. WCB First Report of Acccident - Form 8).",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.20362"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "ActSpecialAuthorizationAttachmentCode",
                          "display" : "ActSpecialAuthorizationAttachmentCode",
                          "definition" : "**Description:**Identifies the type of document that is used to support a request which requires special authorization. Example values in this concept domain could be: coverage extensions, step therapy, medical report, lab result, etc.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "ActICSRDocumentType",
                      "display" : "ActICSRDocumentType",
                      "definition" : "**Description:** A type of document that has information related to the investigation of an adverse event or product problem report.\r\n\r\n**Examples:**\r\n\r\n *  Autopsy report\r\n *  toxicology report\r\n *  clinical journal article",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ActIdentityDocumentCode",
                      "display" : "ActIdentityDocumentCode",
                      "definition" : "Code identifying the type of identification document (e.g. passport, drivers license)\r\n\r\n**Implementation Note:**The proposal called for a domain, but a code was also provided. When codes are available for the value set the code IDENTDOC (identity document) will be used as the headcode for the specializable value set.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActInformationCategoryCode",
                      "display" : "ActInformationCategoryCode",
                      "definition" : "**Definition:**Indicates the set of information types which may be manipulated or referenced, such as for recommending access restrictions.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        },
                        {
                          "code" : "contextBindingC1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19752"
                        },
                        {
                          "code" : "contextBindingC1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingC1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "ActInformRequestType",
                      "display" : "ActInformRequestType",
                      "definition" : "**Description:** Information type for which a provider is requesting routing of health information. This could include messaging of results or documents especially in the context of a specific service delivery location.\r\n\r\n**Examples:**\r\n\r\n *  Diagnostic Image Interpretations\r\n *  Lab Test Results\r\n *  Electrocardiogram Reports",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ActMedicationDocumentCode",
                      "display" : "ActMedicationDocumentCode",
                      "definition" : "Indicates the types of documents that can be associated with a medication or group of medications.\r\n\r\n*Examples include:* Patient monographs, Provider monographs, Drug protocols, etc.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActProductDocumentationType",
                      "display" : "ActProductDocumentationType",
                      "definition" : "**Description:** \r\n\r\nA type of documentation that is used to convey information about a product or an aspect of its life as a product - ranging from production to disposition.\r\n\r\n**Examples:**\r\n\r\n *  Bill of lading\r\n *  product label\r\n *  Report of Product Disposal",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ActQualityMeasureDocumentType",
                      "display" : "ActQualityMeasureDocumentType",
                      "definition" : "A type of document used to represent a health quality measure (aka eMeasure).",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20365"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "ActRPSDocumentType",
                      "display" : "ActRPSDocumentType",
                      "definition" : "Identifies the document type from a regulator-defined set of codes similar to the ICH-defined File Tags used on clinical study documents in an eCTD.\r\n\r\n**Examples:**\r\n\r\n *  Pre-clinical study report\r\n *  Study report\r\n *  Sample CRF\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActSpecialAuthorizationCode",
                      "display" : "ActSpecialAuthorizationCode",
                      "definition" : "**Description:**Constrains vocabulary to that which describes the type of documents that can be attached to a financial transaction such as a Special Authorization Request.\r\n\r\nExample values under this concept domain could be: drug, device, service, etc.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                            "code" : "DOC"
                          }
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActGrouperType",
              "display" : "ActGrouperType",
              "definition" : "**Description:** Further defines the type of grouping of orders or events. This concept domain is intended to be used with the GROUPER Act class code.\r\n\r\n**Examples:**\r\n\r\n *  requisition\r\n *  pre-coordinated order set\r\n *  custom order set",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "GROUPER"
                  }
                }
              ]
            },
            {
              "code" : "ActICSRRecordOrganizerType",
              "display" : "ActICSRRecordOrganizerType",
              "definition" : "**Description:** A type of concept that is used within adverse event and product problem reporting to organize data - often clinical in nature - provided for an investigative subject or other party within the scope of the investigation.\r\n\r\n**Examples:**\r\n\r\n *  Medical history\r\n *  previous drug reactions\r\n *  immunization history",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CATEGORY"
                  }
                }
              ]
            },
            {
              "code" : "ActRecordContainerType",
              "display" : "ActRecordContainerType",
              "definition" : "**Description:** Container of clinical statements. Navigational. No semantic content. Knowledge of the section code is not required to interpret contained observations. Represents a heading in a heading structure, or \"container tree\".\r\n\r\n*Examples:*  category; document section; document body.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CONTAINER"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "DocumentSectionType",
                  "display" : "DocumentSectionType",
                  "definition" : "A type of document section (specialization of ActClass \"DOCSECT\").",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "DOCSECT"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ActQualityMeasureSectionType",
                      "display" : "ActQualityMeasureSectionType",
                      "definition" : "A type of document section within a health quality measure (aka eMeasure), used to cluster the various parts of the eMeasure into a more human navigable format.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20364"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActRegistryCode",
          "display" : "ActRegistryCode",
          "definition" : "This is the domain of registry types. Examples include Master Patient Registry, Staff Registry, Employee Registry, Tumor Registry.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "REG"
              }
            }
          ]
        },
        {
          "code" : "ActRPSRegulatoryPolicy",
          "display" : "ActRPSRegulatoryPolicy",
          "definition" : "Identifies different classes of regulatory policy that can be applied within a Regulated Product Submission.\r\n\r\n*Usage Note:* This Domain is used to administratively group its subdomains specifically for usage in the RPS model, and is not intended to participate in any binidngs.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ActRegulatoryStatusType",
              "display" : "ActRegulatoryStatusType",
              "definition" : "Identifies a temporary or final legal status assigned to a submission by a particular regulatory realm based on the laws and practices of the realm.\r\n\r\n**Examples:**\r\n\r\n *  Active (as authorized by section abc)\r\n *  Approved (under section xyz)\r\n *  Withdrawn (under section pqr)\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActRPSProductCategoryType",
              "display" : "ActRPSProductCategoryType",
              "definition" : "Identifies the legal or administrative category assigned to a regulated product that determines or influences the way in which its submission is reviewed.\r\n\r\n**Examples:**\r\n\r\n *  New active ingredients\r\n *  New ethical combination drug\r\n *  New administrative route\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActRPSReviewTimeType",
              "display" : "ActRPSReviewTimeType",
              "definition" : "Identifies the time period in which a submission of a given type is to be reviewed as established by law or practice in the particular regulatory realm.\r\n\r\n**Examples:**\r\n\r\n *  30 days, reduced time\r\n *  60 days, regular time\r\n *  90 days, extended time\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActServiceDeliveryLocationServiceType",
          "display" : "ActServiceDeliveryLocationServiceType",
          "definition" : "**Description:**Concepts representing the categorization of health services available at a particular delivery location site.\r\n\r\n**Examples:**\r\n\r\n *  anesthetic service\r\n *  colonoscopy service\r\n *  orthopedic service",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActServiceEventType",
          "display" : "ActServiceEventType",
          "definition" : "Concepts identifying the general type of care or category of services being documented.\r\n\r\n**Examples:** \r\n\r\n *  Colonoscopy\r\n *  appendectomy\r\n *  laboratory test",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActSubstanceAdminSubstitutionCode",
          "display" : "ActSubstanceAdminSubstitutionCode",
          "definition" : "**Definition:**Identifies the types of substitution that may be permitted when ordering a medication, as well as those which have actually occurred during the act of dispensing.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "SUBST"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.16621"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActSupplyType",
          "display" : "ActSupplyType",
          "definition" : "**Description:** Further defines the type of supply for order or distribution.\r\n\r\n**Examples:**\r\n\r\n *  central supply\r\n *  materials management\r\n *  nurse station supply",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "SPLY"
              }
            }
          ],
          "concept" : [
            {
              "code" : "ActPharmacySupplyType",
              "display" : "ActPharmacySupplyType",
              "definition" : "**Definition:**Identifies types of dispensing events.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16208"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ActProductAcquisitionType",
              "display" : "ActProductAcquisitionType",
              "definition" : "**Description:** Financial Acquisition Terms: categorizations of acquisition terms for a product.\r\n\r\nTypes of method a product can be obtained for use by the subject of the supply act (e.g. patient). Product examples are consumable or durable goods.\r\n\r\n*Examples:* \r\n\r\n *  Loan\r\n *  Rent\r\n *  Sale",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "SPLY"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.17958"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ActProductLifeCycleEventType",
              "display" : "ActProductLifeCycleEventType",
              "definition" : "**Description:** A type of activity that takes place during the life of a product as it moves from the point of production to the point of consumption, use, or disposition (most notably in the case of contaminated products). It will be possible for concepts at different levels of granularity to be included.\r\n\r\n**Examples:**\r\n\r\n *  Manufacture\r\n *  paint\r\n *  wholesale\r\n *  dispose",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "ACT"
                  }
                }
              ]
            },
            {
              "code" : "OralDietSupplyType",
              "display" : "OralDietSupplyType",
              "definition" : "Concepts representing diets that can be taken via the mouth.\r\n\r\n**Examples:** \r\n\r\n *  General\r\n *  Pureed\r\n *  Easy to Chew",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActTaskCode",
          "display" : "ActTaskCode",
          "definition" : "**Description:** A task or action that a user may perform in a clinical information system\r\n\r\n**Examples:**\r\n\r\n *  medication order entry\r\n *  laboratory test results review\r\n *  problem list entry",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19846"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActTransportationModeCode",
          "display" : "ActTransportationModeCode",
          "definition" : "Characterizes how a transportation act was or will be carried out.\r\n\r\n*Examples:* Via private transport, via public transit, via courier.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "TRNS"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19732"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActPatientTransportationModeCode",
              "display" : "ActPatientTransportationModeCode",
              "definition" : "Definition: Characterizes how a patient was or will be transported to the site of a patient encounter.\r\n\r\n*Examples:* Via ambulance, via public transit, on foot.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19733"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "AdverseEventProductRelatedInvestigationType",
          "display" : "AdverseEventProductRelatedInvestigationType",
          "definition" : "**Description:** Different types that are used to organize and classify product related investigations.\r\n\r\n**Examples:**\r\n\r\n *  Original source investigation\r\n *  Secondary party investigation\r\n *  Report to regulatory authority",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "DEADrugSchedule",
          "display" : "DEADrugSchedule",
          "definition" : "DEA schedule for a drug.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "HL7AccommodationCode",
          "display" : "HL7AccommodationCode",
          "definition" : "**Description:**Accommodation type. In Intent mood, represents the accommodation type requested. In Event mood, represents accommodation assigned/used. In Definition mood, represents the available accommodation type.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACCM"
              }
            }
          ]
        },
        {
          "code" : "HL7TriggerEventCode",
          "display" : "HL7TriggerEventCode",
          "definition" : "The trigger event referenced by the Control Act instance. Values are drawn from the available trigger events used in the release of HL7 identified by the versionCode.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "CACT"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20324"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "LaboratoryTriggerEventType",
              "display" : "LaboratoryTriggerEventType",
              "definition" : "**Description:** Trigger events associated with laboratory results.\r\n\r\n**Examples:**\r\n\r\n *  Lab result activate\r\n *  Lab result complete\r\n *  Lab result abort",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20299"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SpecimenProcessTriggerEventType",
              "display" : "SpecimenProcessTriggerEventType",
              "definition" : "**Description:** Trigger events associated with specimen process steps.\r\n\r\n**Examples:**\r\n\r\n *  Specimen process step activate\r\n *  Specimen process step complete\r\n *  Specimen process step abort",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "CACT"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ImmunizationForecastStatus",
          "display" : "ImmunizationForecastStatus",
          "definition" : "Used to represent the patient's status with respect to their immunization guideline as of an evaluation date.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.11.81"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ManufacturerActivityActType",
          "display" : "ManufacturerActivityActType",
          "definition" : "**Description:** The activity of businesses operating in the manufacture and distribution of products.\r\n\r\n**Examples:**\r\n\r\n *  manufacture\r\n *  repack\r\n *  import",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "ACT"
              }
            }
          ],
          "concept" : [
            {
              "code" : "MarketingActivityActType",
              "display" : "MarketingActivityActType",
              "definition" : "**Description:** The broad activity of businesses operating in the distribution of products, the general act of making a product available to the public.\r\n\r\n**Examples:**\r\n\r\n *  Marketing, (this is required as a singleton value set, as there may be no other use case for this than to distinguish one Act of handling products from other Acts, such as manufacturing.)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "ACT"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ObservationType",
          "display" : "ObservationType",
          "definition" : "Identifies the kinds of observations that can be performed",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "OBS"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.16226"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActDetectedIssueCode",
              "display" : "ActDetectedIssueCode",
              "definition" : "**Definition:**Identifies what type of issue detected during occurrence of an act (e.g. unrecognized identifiers, drug-drug contraindications, drug-allergy alerts).\r\n\r\n**Examples:**\r\n\r\n *  High dosage alert\r\n *  Conditional element missing\r\n *  Timing detected issue",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "ALRT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ActFinancialDetectedIssueCode",
                  "display" : "ActFinancialDetectedIssueCode",
                  "definition" : "Identifies types of detected issues for Act class \"ALRT\" for the financial acts domain.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ClinicalActionDetectedIssueCode",
                  "display" : "ClinicalActionDetectedIssueCode",
                  "definition" : "Identifies types of issues detected regarding the performance of a clinical action on a patient.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "MedicationIssueTypeCode",
                  "display" : "MedicationIssueTypeCode",
                  "definition" : "**Description:** Any type of issue that identifies a potential adverse situation that would or might occur with the described substance administration.\r\n\r\n**Examples:**\r\n\r\n *  adverse effect\r\n *  drug interaction\r\n *  drug-food interaction",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "ALRT"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "DrugActionDetectedIssueCode",
                      "display" : "DrugActionDetectedIssueCode",
                      "definition" : "Proposed therapy may be contraindicated or ineffective based on an existing or recent drug therapy\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActObservationVerificationType",
              "display" : "ActObservationVerificationType",
              "definition" : "Identifies the type of verification investigation being undertaken with respect to the subject of the verification activity.\r\n\r\n**Examples:**\r\n\r\n1.  Verification of eligibility for coverage under a policy or program - aka enrolled/covered by a policy or program\r\n2.  Verification of record - e.g., person has record in an immunization registry\r\n3.  Verification of enumeration - e.g. NPI\r\n4.  Verification of Board Certification - provider specific\r\n5.  Verification of Certification - e.g. JAHCO, NCQA, URAC\r\n6.  Verification of Conformance - e.g. entity use with HIPAA, conformant to the CCHIT EHR system criteria\r\n7.  Verification of Provider Credentials\r\n8.  Verification of no adverse findings - e.g. on National Provider Data Bank, Health Integrity Protection Data Base (HIPDB)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "VERIF"
                  }
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19794"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ActPatientAnnotationCode",
              "display" : "ActPatientAnnotationCode",
              "definition" : "**Description:**Provides a categorization for annotations recorded directly against the patient",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20329"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ActPrivilegeCategorization",
              "display" : "ActPrivilegeCategorization",
              "definition" : "An Act which characterizes a Privilege can have additional observations to provide a finer definition of the requested or conferred privilege. This domain describes the categories under which this additional information is classified.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "ActPrivilegeCategorizationType",
              "display" : "ActPrivilegeCategorizationType",
              "definition" : "This domain includes observations used to characterize a privilege, under which this additional information is classified.\r\n\r\n*Examples:*A privilege to prescribe drugs has a RESTRICTION that excludes prescribing narcotics; a surgical procedure privilege has a PRE-CONDITION that it requires prior Board approval.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActSecurityObjectCode",
              "display" : "ActSecurityObjectCode",
              "definition" : "**Description:**An access control object used to manage permissions and capabilities of users within information systems. (See HL7 RBAC specification fo examples of thes objects.)\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "AdverseSubstanceAdministrationEventActionTakenType",
              "display" : "AdverseSubstanceAdministrationEventActionTakenType",
              "definition" : "**Definition:** Indicates the class of actions taken with regard to a substance administration related adverse event. This characterization offers a judgment of the practitioner\"s response to the patient\"s problem.\r\n\r\n**Examples:** Example values include dose withdrawn, dose reduced, dose not changed.\r\n\r\n**NOTE:** The concept domain is currently supported by a value set created by the International Conference on Harmonization\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "AgeObservationType",
              "display" : "AgeObservationType",
              "definition" : "Categorization of types of observation that captures a person's age as a numeric quantity.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.11.79"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "CommonClinicalObservationType",
              "display" : "CommonClinicalObservationType",
              "definition" : "Used in a patient care message to report and query simple clinical (non-lab) observations.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "CommonCodedClinicalObservationType",
                  "display" : "CommonCodedClinicalObservationType",
                  "definition" : "**Description:** Identifies the type for a clinical observation whose value is expressed as a code.\r\n\r\n**Examples:**\r\n\r\n *  Home support level\r\n *  Tumor staging\r\n *  abdominal pain characteristic",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CommonCodedClinicalObservationComponentType",
                      "display" : "CommonCodedClinicalObservationComponentType",
                      "definition" : "**Description:** Represents the components of a coded clinical observation.\r\n\r\n**Examples:**\r\n\r\n *  ability to articulate\r\n *  ability to chop food\r\n *  ability to crouch",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "CultureObservationType",
              "display" : "CultureObservationType",
              "definition" : "**Description:**To be used to code and identify the Microbiology laboratory orderable and resultable observation question.\r\n\r\n**Examples:**\r\n\r\n *  Urine; Culture\r\n *  Deep Wound; Aerobic Culture\r\n *  Microscopic Examination; Gram Stain",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "OrganismIdentificationObservationType",
                  "display" : "OrganismIdentificationObservationType",
                  "definition" : "**Description:**To be used to code and identify the Microbiology laboratory observation code that relates to the microorganism identification.\r\n\r\n**Examples:**\r\n\r\n *  Bacteria identified\r\n *  Bacteria identified in tissue\r\n *  Fungus identified",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "OBS"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "DeviceCharacteristicObservationType",
              "display" : "DeviceCharacteristicObservationType",
              "definition" : "Identifies characteristics (physical, visual, clinical) that may be observed for a particular device or device type.\r\n\r\n**Examples:**\r\n\r\n *  Height\r\n *  Sterility\r\n *  External diameter",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "DiagnosticImageCode",
              "display" : "DiagnosticImageCode",
              "definition" : "Identifies the types of diagnostic image.\r\n\r\n*Examples:* Echocardiogram, electocardiogram, X-ray.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "DiagnosticImageReportObservationType",
              "display" : "DiagnosticImageReportObservationType",
              "definition" : "Identifies the type of diagnostic image report.\r\n\r\n**Examples:**\r\n\r\n *  Echocardiogram Report\r\n *  Ultrasound Report\r\n *  Nuclear Medicine Imaging Report",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "DiseaseCategorizationObservationType",
              "display" : "DiseaseCategorizationObservationType",
              "definition" : "**Description:** An observation that categorizes an existing observation of a disease, symptom or condition.\r\n\r\n*Usage Note:* The act being categorized should be an observation of a disease, symptom or condition; the categorizing act should be an observation of the category of that disease, symptom or condition, and the relationship between the two acts should be a \"has generalization\" relationship.\r\n\r\n**Examples:**\r\n\r\n *  \\[Observation of\\] \"thrombocytopenia\" is categorized as an observation of \"Haematologic system\" category\r\n *  \\[Observation of\\] \"duodenal ulcer\" is categorized as an observation of \"Gastro-intestinal system\" category\r\n *  \\[Observation of\\] \"eczema\" is categorized as an observation of \"Dermatologic system\" category",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ECGAnnotationType",
              "display" : "ECGAnnotationType",
              "definition" : "*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ECGControlVariable",
              "display" : "ECGControlVariable",
              "definition" : "Identifies types of observations about the parameters required for acquisition and processing of ECG data.\r\n\r\n**Examples:** \r\n\r\n *  item byte order\r\n *  sample rate\r\n *  displayed sweep rate",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "ECGObservationSequenceType",
              "display" : "ECGObservationSequenceType",
              "definition" : "*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "EventFrequencyObservationType",
              "display" : "EventFrequencyObservationType",
              "definition" : "**Description:** Identifies types of observations that describe or categorize an observation in terms of the frequency of the observed event occurring.\r\n\r\n**Examples:**\r\n\r\n *  Very common\r\n *  Uncommon\r\n *  Rare",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "FDALabelData",
              "display" : "FDALabelData",
              "definition" : "FDA label data\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "FinancialClinicalSupportingObservationType",
              "display" : "FinancialClinicalSupportingObservationType",
              "definition" : "**Description:**Describes the supporting information for financial transactions such as a Special Authorization Request.\r\n\r\nExample values under this concept domain could be: height, weight, duration of disease, site of fistula, etc.\r\n\r\nThis concept domain is intended to be used as part of a code/value pair within a generic structure that would convey ANY sort of information or proof of criteria that is needed to support a special authorization request.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "GeneticObservationType",
              "display" : "GeneticObservationType",
              "definition" : "**Description:** Identifies the kinds of genetic observations that can be performed.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20293"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ICSRContextualObservationType",
              "display" : "ICSRContextualObservationType",
              "definition" : "**Description:** A type of observation on an investigative subject or a related entity that might be collected to provide the medical and social context for an adverse event report.\r\n\r\n**Examples:**\r\n\r\n *  Diagnosis\r\n *  laboratory result\r\n *  autopsy determined cause of death",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ImmunizationForecastDate",
              "display" : "ImmunizationForecastDate",
              "definition" : "Specifies the type of date that is specified in an immunization forecast. The immunization forecast defines the schedule for a vaccine based on variables like the subject's age, the type of vaccine, and the supply unit. The immunization forecast may involve multiple administrations in a series or just one administration. Each of the administrations has one or more recommended dates.\r\n\r\n**Examples:** \r\n\r\n *  Earliest recommended date\r\n *  Recommended date\r\n *  Latest acceptable date\r\n *  Overdue date (date after which to start sending reminders)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.82"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ImmunizationObservationType",
              "display" : "ImmunizationObservationType",
              "definition" : "**Description:** Types of observations which describe characteristics of the immunization material.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20410"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "IndividualCaseSafetyReportType",
              "display" : "IndividualCaseSafetyReportType",
              "definition" : "Types of case safety report received from sender. The current code example reference is from the International Conference on Harmonization (ICH) Expert Workgroup guideline on Clinical Safety Data Management: Data Elements for Transmission of Individual Case Safety Reports. The unknown/unavailable option allows the transmission of information from a secondary sender where the initial sender did not specify the type of report.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20394"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ICSR_InvestigationAssessmentActType",
                  "display" : "ICSR_InvestigationAssessmentActType",
                  "definition" : "**Description:** Concepts that define the primary orientation of a product related investigation.\r\n\r\n**Examples:**\r\n\r\n *  Product defect\r\n *  adverse event",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "ACT"
                      }
                    }
                  ]
                },
                {
                  "code" : "IndividualCaseSafetyReportCriteria",
                  "display" : "IndividualCaseSafetyReportCriteria",
                  "definition" : "**Description:** Includes those concepts that are provided to justify the fact that an adverse event or product problem is required to be reported in an expedited fashion.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "INVSTG"
                      }
                    }
                  ]
                },
                {
                  "code" : "IndividualCaseSafetyReportProductCharacteristic",
                  "display" : "IndividualCaseSafetyReportProductCharacteristic",
                  "definition" : "**Description:** Includes relevant pieces of information about a product or its process of creation. The vocabulary domain is used to characterize products when they are cited in adverse event or product problem reports.\r\n\r\n**Examples:**Weight, color, dimensions.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "INVSTG"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "IsolateObservationType",
              "display" : "IsolateObservationType",
              "definition" : "**Description:**To be used in the message when there is a requirement to communicate a result observation code that relates to a specific isolate.\r\n\r\n**Examples:**\r\n\r\n *  Colony count\r\n *  Colony count; Viability count FDA method\r\n *  Growth rate; Visual method",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "KnowledgeSubjectObservationType",
              "display" : "KnowledgeSubjectObservationType",
              "definition" : "Categorization of types of observation that capture the main clinical knowledge subject which may be a medication, a laboratory test, a disease.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20384"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "KnowledgeSubTopicObservationType",
              "display" : "KnowledgeSubTopicObservationType",
              "definition" : "Categorization of types of observation that capture a knowledge subtopic which might be treatment, etiology, or prognosis.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20385"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "MedicationObservationType",
              "display" : "MedicationObservationType",
              "definition" : "Identifies types of observations that can be made about a particular drug or medication.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16226"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "MedicationSafetyReportObservationType",
                  "display" : "MedicationSafetyReportObservationType",
                  "definition" : "**Description:** Identifies types of observations about the Safety Reports required for a particular medication.\r\n\r\n**Examples:**\r\n\r\n *  \\[Observation of\\] International Birth Date\r\n *  \\[Observation of\\] Data Lock Point\r\n *  \\[Observation of\\] Frequency of Safety Report Submission",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "PhysicalCharacteristicsMedicationObservationType",
                  "display" : "PhysicalCharacteristicsMedicationObservationType",
                  "definition" : "Identifies physical characteristics that may be observed for a particular medicinal product or medicinal product package of types thereof.\r\n\r\n**Examples:**\r\n\r\n *  Height\r\n *  Imprint\r\n *  Shape\r\n *  Color",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ObservationActAgeGroupType",
              "display" : "ObservationActAgeGroupType",
              "definition" : "**Description:**To allow queries to specify useful information about the age of the patient without disclosing possible protected health information.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.11.80"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationAllergyTestCode",
              "display" : "ObservationAllergyTestCode",
              "definition" : "**Description:**Dianostic procedures ordered or performed to evaluate whether a sensitivity to a substance is present. This test may be associated with specimen collection and/or substance administration challenge actiivities.\r\n\r\n**Example:**Skin tests and eosinophilia evaluations.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationAllergyTestType",
              "display" : "ObservationAllergyTestType",
              "definition" : "Indicates the type of allergy test performed or to be performed. E.g. the specific antibody or skin test performed\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationCaseStatusType",
              "display" : "ObservationCaseStatusType",
              "definition" : "**Description:** A code used to further identify the type of case status observation. Used with the OBS ActClass.\r\n\r\n**Examples:**\r\n\r\n *  Clinical status\r\n *  Administrative status\r\n *  Reporting status",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationCausalityAssessmentType",
              "display" : "ObservationCausalityAssessmentType",
              "definition" : "**Description:**A kind of observation that allows a Secondary Observation (source act) to assert (at various levels of probability) that the target act of the association (which may be of any type of act) is implicated in the etiology of another observation that is named as the subject of the Secondary Observation\r\n\r\n**Example:**Causality assertions where an accident is the cause of a symptom; predisposition assertions where the genetic state plus environmental factors are implicated in the development of a disease; reaction assertions where a substance exposure is associated with a finding of wheezing.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationCoordinateAxisType",
              "display" : "ObservationCoordinateAxisType",
              "definition" : "**Description:** Identifies the individual coordinate in the coordinate system inclusive of any transformations or projections.\r\n\r\n**Examples:** meridian, range, township, longitude, latitude, lot, block, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20326"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationCoordinateSystemType",
              "display" : "ObservationCoordinateSystemType",
              "definition" : "**Description:** Identifies the coordinate system inclusive of any transformation projections.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20325"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationDosageDefinitionPreconditionType",
              "display" : "ObservationDosageDefinitionPreconditionType",
              "definition" : "**Definition:**\r\n\r\nThe set of observation type concepts that can be used to express pre-conditions to a particular dosage definition.\r\n\r\nRationale: Used to constrain the set of observations to those related to the applicability of a dosage, such as height, weight, age, pregnancy, liver function, kidney function, etc. For example, in drug master-file type records indicating when a specified dose is applicable.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationGenomicFamilyHistoryType",
              "display" : "ObservationGenomicFamilyHistoryType",
              "definition" : "*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationIndicationType",
              "display" : "ObservationIndicationType",
              "definition" : "Includes all codes defining types of indications such as diagnosis, symptom and other indications such as contrast agents for lab tests\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationIntoleranceType",
              "display" : "ObservationIntoleranceType",
              "definition" : "**Description:** Types of sensitivity caused by an exposure to a substance which results in an abnormal immunologic or non-immunologic response.\r\n\r\n**Examples:** \r\n\r\n *  Food allergy\r\n *  Environmental allergy\r\n *  Fod intolerance",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationInvestigationType",
              "display" : "ObservationInvestigationType",
              "definition" : "**Description:**  Used to further classify the type of investigation being documented. This concept domain is intended to be used with the INVSTG Act class code.\r\n\r\n**Examples:**\r\n\r\n *  Public health case investigation\r\n *  Safety investigation\r\n *  Surveillance investigation",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationIssueTriggerCodedObservationType",
              "display" : "ObservationIssueTriggerCodedObservationType",
              "definition" : "Distinguishes the kinds of coded observations that could be the trigger for clinical issue detection. These are observations that are not measurable, but instead can be defined with codes. Coded observation types include: Allergy, Intolerance, Medical Condition, Pregnancy status, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19712"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationIssueTriggerMeasuredObservationType",
              "display" : "ObservationIssueTriggerMeasuredObservationType",
              "definition" : "Distinguishes between the kinds of measurable observations that could be the trigger for clinical issue detection. Measurable observation types include: Lab Results, Height, Weight.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationLabReportType",
              "display" : "ObservationLabReportType",
              "definition" : "**Description:** A set of codes specifying the type of Laboratory Report.\r\n\r\n**Examples:**\r\n\r\n *  Hematology reports\r\n *  Chemistry reports\r\n *  Blood gas reports",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "ObservationOrderableType",
              "display" : "ObservationOrderableType",
              "definition" : "**Description:** Identifies the type of observations that can be ordered.\r\n\r\n**Examples:**\r\n\r\n *  lab tests\r\n *  diagnostic imaging\r\n *  device summary",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ObservationOrderableLabType",
                  "display" : "ObservationOrderableLabType",
                  "definition" : "**Description:** Identifies the ordered lab test. Also known as the lab order code or test code.\r\n\r\n**Examples:**\r\n\r\n *  red blood cell count\r\n *  components of a chemistry panel\r\n *  microbiology sensitivity testing",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                        "code" : "OBS"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ObservationOutbreakExtentType",
              "display" : "ObservationOutbreakExtentType",
              "definition" : "**Description:** A code used to further identify the type of Outbreak Extent Observation. Used with the OBS ActClass.\r\n\r\n**Examples:**\r\n\r\n *  Geographic extent\r\n *  Jurisdictional extent",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationPositionAccuracyType",
              "display" : "ObservationPositionAccuracyType",
              "definition" : "**Description:** Identifies the type of position accuracy carried in observation value.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationPublicHealthCaseType",
              "display" : "ObservationPublicHealthCaseType",
              "definition" : "**Definition:**Identifies the kinds of public health cases. Used only with the CASE Act class code.\r\n\r\nExamples of types of public health cases includes reportable disease cases, radiation exposure cases and chemical exposure cases.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationPublicHealthOutbreakType",
              "display" : "ObservationPublicHealthOutbreakType",
              "definition" : "**Description:** \r\n\r\nUsed to further classify the type of Outbreak being documented. This concept domain is intended to be used with the OUTB Act class code.\r\n\r\n**Examples:**\r\n\r\n *  Epidemic\r\n *  Pandemic\r\n *  Endemic",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationQualityMeasureAttributeType",
              "display" : "ObservationQualityMeasureAttributeType",
              "definition" : "Codes used to define various metadata aspects of a health quality measure (specialization of ActClass \"OBS\").",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20366"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationQueryMatchType",
              "display" : "ObservationQueryMatchType",
              "definition" : "**Definition:** An observation related to a query response.\r\n\r\n**Example:**The degree of match or match weight returned by a matching algorithm in a response to a query.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ObservationResultableType",
              "display" : "ObservationResultableType",
              "definition" : "**Description:** Identifies the type of observation that can be resulted. There are some labs which are not ordered and are performed and resulted when the outcome of an ordered test meets some criteria.\r\n\r\n**Examples:**\r\n\r\n *  outcomes of lab tests\r\n *  device summary\r\n *  therapeutic drug level testing",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "ObservationResultableLabType",
                  "display" : "ObservationResultableLabType",
                  "definition" : "**Description:** The type of lab observation being resulted. There are some lab tests which are not ordered and are performed and resulted when the outcome of an ordered test meets some criteria.\r\n\r\n**Examples:**\r\n\r\n *  red blood cell count\r\n *  results of micro sensitivity testing\r\n *  *Missing third example*",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ObservationVisionPrescriptionType",
              "display" : "ObservationVisionPrescriptionType",
              "definition" : "**Definition:** Identifies the type of Vision Prescription Observation that is being described.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "PatientCharacteristicObservationType",
              "display" : "PatientCharacteristicObservationType",
              "definition" : "Indicates the type of characteristics a patient should have for a given therapy to be appropriate. E.g. Weight, Age, certain lab values, etc.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "PatientImmunizationRelatedObservationType",
              "display" : "PatientImmunizationRelatedObservationType",
              "definition" : "**Description:** Reporting codes that are related to an immunization event.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20411"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PopulationInclusionObservationType",
              "display" : "PopulationInclusionObservationType",
              "definition" : "Observation types for specifying criteria used to assert that a subject is included in a particular population.\r\n\r\n**Examples:** \r\n\r\n *  denominator\r\n *  numerator\r\n *  initial population",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20476"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PrescriptionObservationType",
              "display" : "PrescriptionObservationType",
              "definition" : "Observations specific to a particular prescription to express concepts that cannot be expressed via other modeling approaches.\r\n\r\n*Examples:*  \"Patient Medication On Hand Quantity\", \"Patient Medication On Hand Days Supply\", \"Patient Expected Supply Run-out Date\", \"Percentage Dispensed\".",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SecurityObservationType",
              "display" : "SecurityObservationType",
              "definition" : "Type of security metadata observation made about an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security metadata are used in security labels.\r\n\r\n*Rationale:* According to ISO/TS 22600-3:2009(E) A.9.1.7 SECURITY LABEL MATCHING, Security label matching compares the initiatorÃs clearance to the targetÃs security label. All of the following must be true for authorization to be granted:\r\n\r\n *  The security policy identifiers shall be identical,\r\n *  The classification level of the initiator shall be greater than or equal to that of the target (that is, there shall be at least one value in the classification list of the clearance greater than or equal to the classification of the target), and\r\n *  For each security category in the target label, there shall be a security category of the same type in the initiatorÃs clearance and the initiatorÃs classification level shall dominate that of the target.\r\n\r\n*Usage Note:* SecurityObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the securty label tag set \"SecurityObservationValue\" value set.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20457"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "SecurityCategoryObservationType",
                  "display" : "SecurityCategoryObservationType",
                  "definition" : "Type of security metadata observation made about the category of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security category metadata is defined by ISO/IEC 2382-8:1998(E/F)/ T-REC-X.812-1995 as: \"A nonhierarchical grouping of sensitive information used to control access to data more finely than with hierarchical security classification alone.\"\r\n\r\n*Rationale:* A security category observation supports the requirement to specify the type of IT resource in order to facilitate application of appropriate levels of security according to a range of levels of impact or consequences that might result form the unauthorized disclosure, modification, or use of the information or information system. A resource is assigned to a specific category of information (e.g., privacy, medical, proprietary, financial, investigative, contractor sensitive, security management) defined by an organization or in some instances, by a specific law, Executive Order, directive, policy, or regulation. \\[FIPS 188\\]\r\n\r\n**Examples:** Types of security categories include:\r\n\r\n *  Compartment: A division of data into isolated blocks with separate security controls for the purpose of reducing risk. (ISO 2382-8). Security label metadata that \"segments\" an IT resource by indicating that access and use is restricted to members of a defined community or project. (HL7 Healthcare Classification System)\r\n *  Sensitivity: The characteristic of a resource which implies its value or importance and may include its vulnerability. (ISO 7492-2) Privacy metadata for information perceived as undesirable to share. (HL7 Healthcare Classification System)\r\n\r\n*Usage Note:* SecurityCategoryObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tage set \"SecurityCategoryObservatonValue\" value set.\r\n\r\nCodes may be drawn from the union of the following value sets: V:PrivacyPolicyType, V:ActPrivacyLaw, V:ActConsentDirective, V:InformationSensitivityPolicy, V:ActInformationSensitivityPolicy, V:RoleInformationSensitivityPolicy, EntitySensitivityPolicy, and V:ActConsentType. Could be bound R1 to a V:ActUSPrivacyPolicy in a future US Realm.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20459"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityClassificationObservationType",
                  "display" : "SecurityClassificationObservationType",
                  "definition" : "Type of security metadata observation made about the classification of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security classification is defined by ISO/IEC 2382-8:1998(E/F)/ T-REC-X.812-1995 as: \"The determination of which specific degree of protection against access the data or information requires, together with a designation of that degree of protection.\" Security classification metadata is based on an analysis of applicable policies and the risk of harm to an individual that could result from unauthorized disclosure.\r\n\r\n**Examples:** Types of security classification include: HL7 Confidentiality Codes such as very restricted, unrestricted, and normal. Intelligence community examples include top secret, security, and confidential.\r\n\r\n*Usage Note:* SecurityClassificationObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityClassificationObservationValue\" value set.\r\n\r\nNote that an Act or Role may be associated with an Observation coded as SecurityClassificationObservationType with a SecurityClassificationObservationValue coded with a confidentiality code from V:Confidentiality Code to indicate that the confidentiality level indicated by an Act or Role confidentiality attribute has been overridden by the entity responsible for assigning the SecurityClassificationObservationValue. This supports the business requirement for increasing or decreasing the level of confidentiality (classification or declassification) based on parameters beyond the original assignment of an Act or Role confidentiality.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20458"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityControlObservationType",
                  "display" : "SecurityControlObservationType",
                  "definition" : "Type of security metadata observation made about the control of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security control metadata convey instructions to users and receivers for secure distribution, transmission,and storage; dictate obligations or mandated actions; specify any action prohibited by refrain policy such as dissemination controls; and stipulate the permissible purpose of use of an IT resource.\r\n\r\n**Examples:** Types of security control metadata include handling:\r\n\r\n *  caveats\r\n *  dissemination controls\r\n *  obligations\r\n *  refrain policies\r\n *  purpose of use constraints\r\n\r\n*Usage Note:* SecurityControlObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityControlObservationValue\" value set. Codes may be drawn from the union of the following value sets: V:SecurityPolicy, V:ObligationiPolicy, V:RefrainPolicy, V:PurposeOfUse, and V:GeneralPurposeOfUse.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20460"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityIntegrityObservationType",
                  "display" : "SecurityIntegrityObservationType",
                  "definition" : "Type of security metadata observation made about the integrity of an IT resource (data, information object,service, or system capability), which may be used to make access control decisions.\r\n\r\n*Rationale:* Integrity security label fields support integrity models such as the Biba Integrity Model, the Lipner Full Integrity Model, and the Clar-Wilson Model. The value in the integrity label field indicates the degree of confidence that may be placed in the data and also indicates which measures the data requires for protection from modification and destruction.\r\n\r\n**Examples:** Types of security integrity observation metadata, which may value the observation include:\r\n\r\n *  Integrity status, which indicates the completeness or workflow status of a resource (data, information object, service, or system capability);\r\n *  Integrity confidence, which indicates the reliability and trustworthiness of the resource;\r\n *  Integrity control, which indicates pertinent handling caveats, obligations, refrain policies, and purpose of use for the resource;\r\n *  Data integrity, which indicate the security mechanisms used to ensure that the accuracy and consistency are preserved regardless of changes made (ISO/IEC DIS 2382-8);\r\n *  Alteration integrity, which indicate the security mechanisms used for authorized transformations of the resource;\r\n *  Integrity provenance, which indicates the second-hand origins of a reported or asserted resource.\r\n\r\n*Usage Note:* SecurityIntegrityObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityObservationValue\" value set.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "SecurityAlterationIntegrityObservationType",
                      "display" : "SecurityAlterationIntegrityObservationType",
                      "definition" : "Type of security metadata observation made about the alteration integrity of an altered IT resource (data, information object, service, or system capability), which indicates the mechanism used for authorized transformation of the resource.\r\n\r\n**Examples:** Types of security alteration integrity observation metadata, which may value the observation with a code used to indicate the mechanism used for authorized transformation of an IT resource, include:\r\n\r\n *  translation\r\n *  syntactic transformation\r\n *  semantic mapping\r\n *  redaction\r\n *  masking\r\n *  pseudonymization\r\n *  anonymization\r\n\r\n*Usage Note:* SecurityAlterationIntegrityObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityAlterationIntegrityObservationValue\" value set, which convey the mechanism used for authorized transformation of an IT resource.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20465"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityDataIntegrityObservationType",
                      "display" : "SecurityDataIntegrityObservationType",
                      "definition" : "Type of security metadata observation made about the data integrity of an IT resource (data, information object, service, or system capability), which indicates the security mechanism used to preserve resource accuracy and consistency. Data integrity is defined by ISO 22600-23.3.21 as: \"The property that data has not been altered or destroyed in an unauthorized manner\", and by ISO/IEC 2382-8: \"The property of data whose accuracy and consistency are preserved regardless of changes made.\"\r\n\r\n*Rationale:* In accordance with the HL7 RM-ES EHR-FM Profile Standard: The validity of a patient record entry requires an indelible statement (e.g., attestation or electronic signature) by the author(s) of completeness, accuracy, and affirmation that the record cannot be repudiated, assigning each author to his/her actual contributed content.\r\n\r\n**Examples:** Types of security data integrity observation metadata, which may value the observation, include:\r\n\r\n *  cryptographic hash function\r\n *  digital signature\r\n\r\n*Usage Note:* SecurityDataIntegrityObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityConfidenceObservationValue\" value set.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20464"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityIntegrityConfidenceObservationType",
                      "display" : "SecurityIntegrityConfidenceObservationType",
                      "definition" : "Type of security metadata observation made about the integrity confidence of an IT resource (data, information object,service, or system capability) that indicates the reliability or trustworthiness of a resource, which may be used to make access control decisions.\r\n\r\n**Examples:** Types of security integrity confidence observation metadata, which may value the observation, include:\r\n\r\n *  highly reliable\r\n *  uncertain reliability\r\n *  not reliable\r\n\r\n*Usage Note:* A security integrity confidence observation on an Act may indicated that a valued Act.uncertainty attribute has been overridden by the entity responsible for assigning the SecurityIntegrityConfidenceObservationValue. This supports the business requirements for increasing or decreasing the assessment of the reliability or trustworthiness of an IT resource based on parameters beyond the original assignment of an Act.uncertaintyCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20463"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityIntegrityProvenanceObservationType",
                      "display" : "SecurityIntegrityProvenanceObservationType",
                      "definition" : "Type of security metadata observation made about the provenance integrity of an IT resource (data, information object, service, or system capability), which indicates the lifecycle completeness and workflow status of an IT resource, such as create, modify, append, amend, suspend, archive, and delete; locations in which the resource has been collected or archived, from which it may be retrieved, and the history of its distribution and disclosure. Integrity provenance metadata about an IT resource may be used to assess its veracity, reliability, and trustworthiness.\r\n\r\n**Examples:** Types of security integrity provenance observation metadata, which may value the observation with a code used to indicate provenance, include the entity responsible for a report or assertion relayed \"second-hand\" about an IT resource.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityProvenanceObservationValue\" value set.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20466"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "SecurityIntegrityProvenanceAssertedByObservationType",
                          "display" : "SecurityIntegrityProvenanceAssertedByObservationType",
                          "definition" : "Type of security metadata observation made about the provenance integrity of an IT resource (data, information object, service, or system capability), which indicates the entity responsible for an assertion relayed \"second-hand\" about an IT resource.\r\n\r\n*Rationale:* In accordance with HL7 RM-ES EHR-FM Profile at IN:1.8: If more than one author contributed to the EHR content, then the system shall provide the ability to associate and maintain all authors/contributors with their content.\r\n\r\n**Examples:** Types of security integrity provenance asserted by observation metadata, which may value the observation, include assertions about an IT resource by a patient, a clinician, or a device.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceAssertedByObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityProvenanceAssertedByObservationValue\" value set.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.20468"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "SecurityIntegrityProvenanceReportedByObservationType",
                          "display" : "SecurityIntegrityProvenanceReportedByObservationType",
                          "definition" : "Type of security metadata observation made about the provenance integrity of an IT resource (data, information object, service, or system capability), which indicates the entity responsible for a report relayed \"second-hand\" about an IT resource.\r\n\r\n*Rationale:* In accordance with HL7 RM-ES EHR-FM Profile at IN:1.8: If more than one author contributed to the EHR content, then the system shall provide the ability to associate and maintain all authors/contributors with their content.\r\n\r\n**Examples:** Types of security integrity provenance observation metadata, which may value the observation with a code used to indicate provenance, include reports about an IT resource by a patient, a clinician, or a device.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceReportedByObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityProvenanceReportedByObservationValue\" value set.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.20467"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "SecurityIntegrityStatusObservationType",
                      "display" : "SecurityIntegrityStatusObservationType",
                      "definition" : "Type of security metadata observation made about the integrity status of an IT resource (data, information object,service, or system capability), which may be used to make access control decisions. Indicates the completeness or workflow status of an IT resource, which may impact which users that are authorized to access and use the resource.\r\n\r\n*Rationale:* In accordance with the HL7 RM-ES Profile Standard: The validity of a patient record entry requires an indelible statement (e.g., attestation or electronic signature) by the author(s) of completeness, accuracy, and affirmation that the record cannot be repudiated, assigning each author to his/her actual contributed content.\r\n\r\n**Examples:** Types of security integrity status observation metadata, which may value the observation, include codes from the HL7 DocumentCompletion value set such as:\r\n\r\n *  legally authenticated\r\n *  in progress\r\n *  incomplete\r\n\r\n*Usage Note:* SecurityIntegrityStatusObservationType concept domain designates a code system used to name a security label field type that may be valued with a \"security label tag\" such as a code from the security label tag set \"SecurityIntegrityStatusObservationValue\" concept domain, which may be valued with coded concepts from the HL7 DocumentCompletion value set.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20462"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustObservationType",
                  "display" : "SecurityTrustObservationType",
                  "definition" : "Type of security metadata observation made about aspects of trust applicable to an IT resource (data, information object, service, or system capability). Trust applicable to IT resources is established and maintained in and among security domains, and may be comprised of observations about the domain's trust authority, trust framework, trust policy, trust interaction rules, means for assessing and monitoring adherence to trust policies, mechanisms that enforce trust, and quality and reliability measures of assurance in those mechanisms. \\[Based on ISO IEC 10181-1 and NIST SP 800-63-2\\]\r\n\r\n*Usage Note:* SecurityTrustObservationType may be used as a trust attribute in a computable trust policy, trust credential, trust assertion, or trust label field in a security label and populated with trust observation values. The valued trust attributes may be used for used for authentication, authorization, and access control decisions. These may also be used to negotiate trust relationships, adjudicate or bridge trust policies, and to specify requirements for participation in a Trust Domain or for asserting compliance with a Trust Framework.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20531"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "SecurityTrustAccreditationObservationType",
                      "display" : "SecurityTrustAccreditationObservationType",
                      "definition" : "Type of security metadata observation made about the formal declaration by an authority or neutral third party that validates the technical, security, trust, and business practice conformance of Trust Agents to facilitate security, interoperability, and trust among participants within a security domain or trust framework.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20532"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityTrustAgreementObservationType",
                      "display" : "SecurityTrustAgreementObservationType",
                      "definition" : "Type of security metadata observation made about security requirements for a security domain. \\[ISO IEC 10181-1\\]",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20537"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityTrustAssuranceObservationType",
                      "display" : "SecurityTrustAssuranceObservationType",
                      "definition" : "Type of security metadata observation made about the digital quality or reliability of a trust assertion, activity, capability, information exchange, mechanism, process, or protocol.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20533"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityTrustCertificateObservationType",
                      "display" : "SecurityTrustCertificateObservationType",
                      "definition" : "Type of security metadata observation made about a set of security-relevant data issued by a security authority or trusted third party, together with security information which is used to provide the integrity and data origin authentication services for an IT resource (data, information object, service, or system capability). \\[Based on ISO IEC 10181-1\\]",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20534"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityTrustFrameworkObservationType",
                      "display" : "SecurityTrustFrameworkObservationType",
                      "definition" : "Type of security metadata observation made about a complete set of contracts, regulations, or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. \\[Kantara Initiative\\]",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20535"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityTrustMechanismObservationType",
                      "display" : "SecurityTrustMechanismObservationType",
                      "definition" : "Type of security metadata observation made about a security architecture system component that supports enforcement of security policies.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20536"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SeverityObservationType",
              "display" : "SeverityObservationType",
              "definition" : "Categorization of types of observation that capture the interpretation of the result of a laboratory test in terms of normality.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20386"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SimpleMeasurableClinicalObservationType",
              "display" : "SimpleMeasurableClinicalObservationType",
              "definition" : "Types of measurement observations typically performed in a clinical (non-lab) setting. E.g. Height, Weight, Blood-pressure\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "SimpleMeasurableClinicalObservationComponentType",
                  "display" : "SimpleMeasurableClinicalObservationComponentType",
                  "definition" : "**Description:** Represents the components of a measured clinical observation.\r\n\r\n**Examples:**\r\n\r\n *  the systolic and diastolic components of a blood pressure\r\n *  24-hour urine output\r\n *  ARAC gene",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SubstanceCharacteristicObservationType",
              "display" : "SubstanceCharacteristicObservationType",
              "definition" : "Distinguishing traits, qualities, or properties given about substances, including chemical structure (as encapsulated data in SMILES, MolFile, InChi), nucleic acid sequence, amino acid sequence, molecular sum formula; molecular mass; stereochemistry and optical activity properties; viscosity; pH, pKa, catalytic activity, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SusceptibilityBatteryType",
              "display" : "SusceptibilityBatteryType",
              "definition" : "**Description:**Ensures consistent coding of the susceptibility battery or panel.\r\n\r\n**Examples:**\r\n\r\n *  Bacterial susceptibility panel\r\n *  Fungal susceptibility panel\r\n *  Mycobacterial susceptibility panel\r\n *  Viral susceptibility panel",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            },
            {
              "code" : "SusceptibilityObservationType",
              "display" : "SusceptibilityObservationType",
              "definition" : "**Description:**Ensures consistent coding of antimicrobial information in the Microbiology lab message.\r\n\r\n**Examples:**\r\n\r\n *  Ciprofloxacin; Disk Diffusion (Kirby-Bauer)\r\n *  Vancomycin\r\n *  Tetracycline; Minimum Inhibitory Concentration",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "OBS"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "RegulationPolicyActType",
          "display" : "RegulationPolicyActType",
          "definition" : "**Description:** A rule set by regulators of product that somehow constrain the use of products. Regulator may be any organization with a mandate to issue such rules, regardless of level, regional, country, state, and local (e.g., an institutional Pharmaceutical and Treatment Committee.)\r\n\r\n**Examples:**\r\n\r\n *  Prescription Only\r\n *  Controlled Substance Schedule II\r\n *  Standard of Practice",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "POLICY"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20370"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ResearchStudyType",
          "display" : "ResearchStudyType",
          "definition" : "**Description:** Different types of research studies that may be conducted and reported on.\r\n\r\n**Examples:**\r\n\r\n *  Observational\r\n *  Investigational",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "INVSTG"
              }
            }
          ]
        },
        {
          "code" : "TriggerEventID",
          "display" : "TriggerEventID",
          "definition" : "**Description:** Trigger Event ID as published in the standard.\r\n\r\n***Deprecation Comment:*** This Domain has been deprecated as the Domain HL7TriggerEventCode is being used instead, along with its subDomains. Please update designs that refer to this Domain and instead refer to the appropriate Domain in the HL7TriggerEventCode hierarchy.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "DeprecationInfo",
              "valueString" : "deprecationEffectiveVersion=866 coremifText=This element was deprecated as of the release indicated."
            },
            {
              "code" : "deprecated",
              "valueDateTime" : "2009-04-18"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActContextLevel",
      "display" : "ActContextLevel",
      "definition" : "**Description:** Code specifying the level within a hierarchical Act composition structure and the kind of contextual information attached to composite Acts (\"containers\") and propagated to component Acts within those containers. The levelCode signifies the position within such a containment hierarchy and the applicable constraints.\r\n\r\n*Examples:* The \"extract level\" and the \"folder level\" must contain data about a single individual, whereas the \"multiple subject level\" may contain data about multiple individuals. While \"extract\" can originate from multiple sources, a \"folder\" should originate from a single source. The \"composition\" level usually has a single author.\r\n\r\n*Constraints:* The constraints applicable to a particular level may include differing requirements for participations (e.g. patient, source organization, author or other signatory), relationships to or inclusion of other Acts, documents or use of templates. The constraints pertaining to a level may also specify the permissible levels that may be contained as components of that level. Several nested levels with the same levelCode may be permitted, prohibited (or limited). Instance of the next subordinate level are usually permitted within any level but some levels may be omitted from a model and it may be permissible to skip several layers.\r\n\r\n*Discussion:* The levelCode concepts have been defined to meet specific health record transfer requirements. While these concepts are known to be applicable to some other types of transactions, they are not intended to a be a complete closed list. Options exist for other sets of orthogonal levels where required to meet a business purpose (e.g. a multiple patient communication may be subdivided by a super-ordinate level of subject areas).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "ActExposureLevelCode",
      "display" : "ActExposureLevelCode",
      "definition" : "A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as \"low\", \"medium\" and \"high\". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19939"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActInvoiceElementModifier",
      "display" : "ActInvoiceElementModifier",
      "definition" : "Processing consideration and clarification codes.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17704"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActMood",
      "display" : "ActMood",
      "definition" : "A code distinguishing whether an Act is conceived of as a factual statement or in some other manner as a command, possibility, goal, etc.\r\n\r\n*Constraints:* An Act-instance must have one and only one moodCode value.\r\n\r\nThe moodCode of a single Act-instance never changes. Mood is not state.\r\n\r\nTo describe the progression of a business activity from defined to planned to executed, etc. one must instantiate different Act-instances in the different moods and link them using ActRelationship of general type \"sequel\". (See ActRelationship.type.)\r\n\r\n*Discussion:* The Act.moodCode includes the following notions: (1) event, i.e., factual description of an actions that occurred; (2) definition of possible actions and action plans (the master file layer); (3) intent, i.e., an action plan instantiated for a patient as a care plan or order; (4) goal, i.e., an desired outcome attached to patient problems and plans; and (5) criterion, i.e., a predicate used as\r\n\r\nThe Act.moodCode modifies the meaning of the Act class in a controlled way, just as in natural language, grammatical form of a verb modify the meaning of a sentence in defined ways. For example, if the mood is factual (event,) then the entire act object represents a known fact. If the mood expresses a plan (intent,) the entire act object represents the expectation of what should be done. The mood does not change the meaning of individual act properties in peculiar ways.\r\n\r\nSince the mood code is a determining factor for the meaning of an entire Act object, the mood must always be known. This means, whenever an act object is instantiated, the mood attribute must be assigned to a valid code, and the mood assignment can not change throughout the lifetime of an act object.\r\n\r\nAs the meaning of an act object is factored in the mood code, the mood code affects the interpretation of the entire Act object and with it every property (attributes and associations.) Note that the mood code affects the interpretation of the act object, and the meaning of the act object in turn determines the meaning of the attributes. However, the mood code does not arbitrarily change the meaning of individual attributes.\r\n\r\n*Inert vs. descriptive properties of Acts:* Acts have two kinds of act properties, inert and descriptive properties. Inert properties are not affected by the mood, descriptive properties follow the mood of the object. For example, there is an identifier attribute Act.id, which gives a unique identification to an act object. Being a unique identifier for the object is in no way dependent on the mood of the act object. Therefore, the \"interpretation\" of the Act.id attribute is inert with respect to the act object's mood.\r\n\r\nBy contrast, most of the Act class' attributes are descriptive for what the Act statement expresses. Descriptive properties of the Act class give answer to the questions who, whom, where, with what, how and when the action is done. The questions who, whom, with what, and where are answered by Participatons, while how and when is answered by descriptive attributes and ActRelationships. The interpretation of a descriptive attribute is aligned to the interpretation of the entire act object, and controlled by the mood.\r\n\r\n*Examples:* To illustrate the effect of mood code, consider a \"blood glucose\" observation:\r\n\r\nThe DEFINITION mood specifies the Act of \"obtaining blood glucose\". Participations describe in general the characteristics of the people who must be involved in the act, and the required objects, e.g., specimen, facility, equipment, etc. involved. The Observation.value specifies the absolute domain (range) of the observation (e.g., 15-500 mg/dl.)\r\n\r\nIn INTENT mood the author of the intent expresses the intent that he or someone else \"should obtain blood glucose\". The participations are the people actually or supposedly involved in the intended act, especially the author of the intent or any individual assignments for group intents, and the objects actually or supposedly involved in the act (e.g., specimen sent, equipment requirements, etc.) The Observation.value is usually not specified, since the intent is not to measure blood glucose, not to measure blood glucose in a specific range. (But compare with GOAL below.)\r\n\r\nIn ORDER mood, a kind of intent, the author requests to \"please obtain blood glucose\". The Participations are the people actually and supposedly involved in the act, especially the placer and the designated filler, and the objects actually or supposedly involved in the act (e.g., specimen sent, equipment requirements, etc.) The Observation.value is usually not specified, since the order is not to measure blood glucose in a specific range.\r\n\r\nIn EVENT mood, the author states that \"blood glucose was obtained\". Participations are the people actually involved in the act, and the objects actually involved (e.g., specimen, facilities, equipment.) The Observation.value is the value actually obtained (e.g., 80 mg/dL, or <15 mg/dL.)\r\n\r\nIn event-CRITERION mood, an author considers a certain class of \"obtaining blood glucose\" possibly with a certain value (range) as outcome. The Participations constrain the criterion, for instance, to a particular patient. The Observation.value is the range in which the criterion would hold (e.g. > 180 mg/dL or 200?300 mg/dL.)\r\n\r\nIn GOAL mood (a kind of criterion) the author states that \"our goal is to be able to obtain blood glucose with the given value (range)\". The Participations are similar to intents, especially the author of the goal and the patient for whom the goal is made. The Observation.value is the range which defined when the goal is met (e.g. 80?120 mg/dl.)\r\n\r\n*Rationale:* The notion of \"mood\" is borrowed from natural language grammar, the mood of a verb (lat. modus verbi).\r\n\r\nThe notion of mood also resembles the various extensions of the logic of facts in modal logic and logic with modalities, where the moodCode specifies the modality (fact, possibility, intention, goal, etc.) under which the Act-statement is judged as appropriate or defective.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10196"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ActMoodProposal",
          "display" : "ActMoodProposal",
          "definition" : "A non-mandated intent to perform an act. Used to record intents that are explicitly not Orders. Professional responsibility for the 'proposal' may or may not be present.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19746"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActPriority",
      "display" : "ActPriority",
      "definition" : "A code or set of codes (e.g., for routine, emergency,) specifying the urgency under which the Act happened, can happen, is happening, is intended to happen, or is requested/demanded to happen.\r\n\r\n*Discussion:* This attribute is used in orders to indicate the ordered priority, and in event documentation it indicates the actual priority used to perform the act. In definition mood it indicates the available priorities.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16866"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ActEncounterPriority",
          "display" : "ActEncounterPriority",
          "definition" : "**Description:** Types of priorities to determine start of an encounter.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19457"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActIssuePriority",
          "display" : "ActIssuePriority",
          "definition" : "Indicates the importance or priority associated with a detected issue.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19358"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActReason",
      "display" : "ActReason",
      "definition" : "A code specifying the motivation, cause, or rationale of an Act, when such rationale is not reasonably representable as an ActRelationship of type \"has reason\" linking to another Act.\r\n\r\n*Examples:* Example reasons that might qualify for being coded in this field might be: \"routine requirement\", \"infectious disease reporting requirement\", \"on patient request\", \"required by law\".\r\n\r\nDiscussion\r\n\r\nMost reasons for acts can be clearly expressed by linking the new Act to another prior Act using an ActRelationship of type \"has reason\". This simply states that the prior Act is a reason for the new Act (see ActRelationship.) The prior act can then be a specific existing act or a textual explanation. This works for most cases, and the more specific the reason data is, the more should this reason ActRelationship be used instead of the reasonCode.\r\n\r\nThe reasonCode remains as a place for common reasons that are not related to a prior Act or any other condition expressed in Acts. Indicators that something was required by law or was on the request of a patient etc. may qualify. However, if that piece of legislation, regulation, or the contract or the patient request can be represented as an Act (and they usually can), the reasonCode should not be used.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "ActAdjudicationReason",
          "display" : "ActAdjudicationReason",
          "definition" : "Explanatory codes that describe reasons why an Adjudicator has financially adjusted an invoice (claim).\r\n\r\nA companion domain (ActAdjudicationInformationCode) includes information reasons which do not have a financial impact on an invoice (claim).\r\n\r\nExample adjudication reason code is AA-CLAIM-0011 - Only Basic Procedure/Test Eligible.\r\n\r\nCodes from this domain further rationalizes ActAdjudicationCodes (e.g. AA - Adjudicated with Adjustment), which are used to describe the process of adjudicating an invoice. For AS - Adjudicated as Submitted, there should be no specification of ActAdjudicationReason codes, as there are no financial adjustments against the invoice.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActAntigenInvalidReason",
          "display" : "ActAntigenInvalidReason",
          "definition" : "**Description:** Describe why an antigen is considered to be invalid for use.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20409"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActBillableServiceReason",
          "display" : "ActBillableServiceReason",
          "definition" : "**Definition:** This domain is used to document reasons for providing a billable service; the billable services may include both clinical services and social services.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ActBillableClinicalServiceReason",
              "display" : "ActBillableClinicalServiceReason",
              "definition" : "**Description:** May be sent to indicate one or more reasons for the performance of a billable clinical service or product, and not related or specified by a diagnosis.\r\n\r\n*Examples:*\r\n\r\n *  Duplicate Therapy\r\n *  Care protocol\r\n *  Insurance requirement",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "MedicallyNecessaryDuplicateProcedureReason",
                  "display" : "MedicallyNecessaryDuplicateProcedureReason",
                  "definition" : "**Definition:** This domain is used to document why the procedure is a duplicate of one ordered/charged previously for the same patient within the same date of service and has been determined to be medically necessary.\r\n\r\n**Example:** A doctor needs a different view in a chest X-Ray.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActBillableNonClinicalServiceReason",
              "display" : "ActBillableNonClinicalServiceReason",
              "definition" : "**Description:** Maybe sent to indicate one or more reasons for the performance of a non clinical service or product, and not related or specified by diagnosis.\r\n\r\n*Examples:*\r\n\r\n *  Fraudulent prescription\r\n *  Patient's preference\r\n *  Physiotherapy equipment",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "NonClinicalDuplicateServiceReason",
                  "display" : "NonClinicalDuplicateServiceReason",
                  "definition" : "**Description:** A duplicate non-clinical service or product is being re-billed.\r\n\r\n*Examples:*\r\n\r\n *  Duplicate transportation required for physician visit\r\n *  Wrong size of a product\r\n *  Rebuilding wheel chair ramp due to a weather condition",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActCoverageLevelRasonCode",
          "display" : "ActCoverageLevelRasonCode",
          "definition" : "**Description:**Represents the reason for the level of coverage provided under the policy or program in terms of the types of entities that may play covered parties based on their personal relationships or employment status.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActCoverageReason",
          "display" : "ActCoverageReason",
          "definition" : "**Description:**Codes used to specify reasons or criteria relating to coverage provided under a policy or program. May be used to convey reasons pertaining to coverage contractual provisions, including criteria for eligibility, coverage limitations, coverage maximums, or financial participation required of covered parties.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19871"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActCoverageProviderReason",
              "display" : "ActCoverageProviderReason",
              "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on characteristics of the provider, e.g., contractual relationship to payor, such as in or out-of-network; relationship of the covered party to the provider.\r\n\r\n**Example:**In closed managed care plan, a covered party is assigned a primary care provider who provides primary care services and authorizes referrals and ancillary and non-primary care services.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ActCoverageServiceReason",
              "display" : "ActCoverageServiceReason",
              "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on clinical efficacy criteria or practices prescribed by the payor.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CoverageExclusionReason",
              "display" : "CoverageExclusionReason",
              "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on coverage exclusions related the risk of adverse selection by covered parties.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CoverageFinancialParticipationReason",
              "display" : "CoverageFinancialParticipationReason",
              "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on financial participation responsibilities of the covered party.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CoverageLimitationReason",
              "display" : "CoverageLimitationReason",
              "definition" : "**Description:**Identifies the reason or rationale for limitations on the coverage of a service or product based on coverage contract provisions.\r\n\r\n**Example:**The maximum cost per unit; or the maximum number of units per period, which is typically the policy or program effective time.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "EligibilityActReasonCode",
              "display" : "EligibilityActReasonCode",
              "definition" : "Identifies the reason or rational for why a person is eligibile for benefits under an insurance policy or progam.\r\n\r\n*Examples:*  A person is a claimant under an automobile insurance policy are client deceased & adopted client has been given a new policy identifier. A new employee is eligible for health insurance as an employment benefit. A person meets a government program eligibility criteria for financial, age or health status.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19694"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "CoverageEligibilityReason",
                  "display" : "CoverageEligibilityReason",
                  "definition" : "Definition: Identifies the reason or rational for why a person is eligibile for benefits under an insurance policy or progam.\r\n\r\n*Examples:*  A person is a claimant under an automobile insurance policy are client deceased & adopted client has been given a new policy identifier. A new employee is eligible for health insurance as an employment benefit. A person meets a government program eligibility criteria for financial, age or health status.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19735"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ActEncounterReason",
          "display" : "ActEncounterReason",
          "definition" : "**Description:** Administration reasons for patient encounters.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19456"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActImmunizationReason",
          "display" : "ActImmunizationReason",
          "definition" : "Reasons why an immunization was administered.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActInformationManagementReason",
          "display" : "ActInformationManagementReason",
          "definition" : "**Description:** The rationale or purpose for an act relating to information management, such as archiving information for the purpose of complying with an enterprise data retention policy.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ActHealthInformationManagementReason",
              "display" : "ActHealthInformationManagementReason",
              "definition" : "**Description:** The rationale or purpose for an act relating to health information management, such as archiving information for the purpose of complying with an organization policy or jurisdictional law relating to data retention.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20447"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "ActConsentInformationAccessOverrideReason",
                  "display" : "ActConsentInformationAccessOverrideReason",
                  "definition" : "To perform one or more operations on information to which the patient has not consented as deemed necessary by authorized entities for providing care in the best interest of the patient; providing immediately needed health care for an emergent condition; or for protecting public or third party safety.\r\n\r\n*Usage Notes:* Used to convey the reason that a provider or other entity may or has accessed personal healthcare information. Typically, this involves overriding the subject's consent directives.",
                  "property" : [
                    {
                      "code" : "HL7usageNotes",
                      "valueString" : "Used to convey the reason that a provider or other entity may or has accessed personal healthcare information.  Typically, this involves overriding the subject's consent directives."
                    },
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19894"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "ActHealthInformationPrivacyReason",
                  "display" : "ActHealthInformationPrivacyReason",
                  "definition" : "**Description:** The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ActHealthInformationPurposeOfUseReason",
                  "display" : "ActHealthInformationPurposeOfUseReason",
                  "definition" : "Reason for performing one or more operations on information, which may be permitted by source system's security policy in accordance with one or more privacy policies and consent directives.\r\n\r\n*Usage Notes:* The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes.",
                  "property" : [
                    {
                      "code" : "HL7usageNotes",
                      "valueString" : "The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes."
                    },
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20449"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ActInformationAccessOverrideReason",
              "display" : "ActInformationAccessOverrideReason",
              "definition" : "**Description:** Use to convey the reason that a provider may or has accessed personal healthcare information. Typically, this involves overriding the subject's consent directives.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ActInformationPrivacyReason",
          "display" : "ActInformationPrivacyReason",
          "definition" : "**Description:** The rationale or purpose for an act relating to the management of personal information, such as disclosing personal tax information for the purpose of complying with a court order.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActNoImmunizationReason",
          "display" : "ActNoImmunizationReason",
          "definition" : "Reasons why a patient did not receive an immunization.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19717"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActPaymentReason",
          "display" : "ActPaymentReason",
          "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActPreferenceReason",
          "display" : "ActPreferenceReason",
          "definition" : "Reasons why a preference has been specified.\r\n\r\n**Examples:** \r\n\r\n *  Side Effects\r\n *  Religious\r\n *  Request",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActRPSRelatedApplicationReason",
          "display" : "ActRPSRelatedApplicationReason",
          "definition" : "Identifies the reason for citing a related application.\r\n\r\n**Examples:**\r\n\r\n *  Data protection period expiry reference\r\n *  Bioequivalence reference\r\n *  Drug Master File reference\r\n\r\n*Usage Note:* This usage is confined to a specific set of requirements related to regulatory documents in the context of RPS documents.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ActSupplyFulfillmentRefusalReason",
          "display" : "ActSupplyFulfillmentRefusalReason",
          "definition" : "Indicates why a fulfiller refused to fulfill a supply order, and considered it important to notify other providers of their decision. E.g. \"Suspect fraud\", \"Possible abuse\", \"Contraindicated\".\r\n\r\n(used when capturing 'refusal to fill' annotations)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19718"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ClinicalResearchReason",
          "display" : "ClinicalResearchReason",
          "definition" : "**Definition:**Contains domains for act reasons used in clinical research.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ClinicalResearchEventReason",
              "display" : "ClinicalResearchEventReason",
              "definition" : "**Definition:**Specifies the reason that an event occurred in a clinical research study.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ClinicalResearchObservationReason",
              "display" : "ClinicalResearchObservationReason",
              "definition" : "**Definition:**SSpecifies the reason that a test was performed or observation collected in a clinical research study.\r\n\r\n**Note:**This set of codes are not strictly reasons, but are used in the currently Normative standard. Future revisions of the specification will model these as ActRelationships and thes codes may subsequently be retired. Thus, these codes should not be used for new specifications.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "ControlActReason",
          "display" : "ControlActReason",
          "definition" : "**Description:** Indicates the motivation, cause or rationale of an Act which results in a trigger event.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19692"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "CombinedPharmacyOrderSuspendReasonCode",
              "display" : "CombinedPharmacyOrderSuspendReasonCode",
              "definition" : "**Description:**Indicates why the prescription should be suspended.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19779"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ConrolActNullificationReasonCode",
              "display" : "ConrolActNullificationReasonCode",
              "definition" : "**Description:**Identifies reasons for nullifying (retracting) a particular control act.\r\n\r\n**Examples:**\"Entered in error\", \"altered decision\", etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ControlActNullificationReasonCode",
              "display" : "ControlActNullificationReasonCode",
              "definition" : "**Description:**Identifies reasons for nullifying (retracting) a particular control act.\r\n\r\n**Examples:**\"Entered in error\", \"altered decision\", etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19826"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ControlActNullificationRefusalReasonType",
              "display" : "ControlActNullificationRefusalReasonType",
              "definition" : "**Description:** Indicates why a specific transaction which was requested to be undone; was not undone.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20421"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ControlActReasonConditionNullify",
              "display" : "ControlActReasonConditionNullify",
              "definition" : "Indicates why the ConditionaTMs status was changed to Nullified. *Examples* administrative error, diagnostic error.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "GenericUpdateReasonCode",
              "display" : "GenericUpdateReasonCode",
              "definition" : "**Description:**Identifies why a change is being made to a record.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19777"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "MedicationOrderAbortReasonCode",
              "display" : "MedicationOrderAbortReasonCode",
              "definition" : "**Description:**Indicates the reason the medication order should be aborted.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19781"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "MedicationOrderReleaseReasonCode",
              "display" : "MedicationOrderReleaseReasonCode",
              "definition" : "**Definition:**A collection of concepts that indicate why the prescription should be released from suspended state.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19782"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ModifyPrescriptionReasonType",
              "display" : "ModifyPrescriptionReasonType",
              "definition" : "Types of reason why a prescription is revised.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20508"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PatientProfileQueryReasonCode",
              "display" : "PatientProfileQueryReasonCode",
              "definition" : "**Definition:**A collection of concepts identifying why the patient's profile is being queried.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19784"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PharmacySupplyEventAbortReasonType",
              "display" : "PharmacySupplyEventAbortReasonType",
              "definition" : "**Definition:**Identifies why the dispense event was not completed",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20342"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PharmacySupplyEventStockReasonCode",
              "display" : "PharmacySupplyEventStockReasonCode",
              "definition" : "**Definition:**A collection of concepts that indicates the reason for a \"bulk supply\" of medication.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19785"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PharmacySupplyRequestFulfillerRevisionRefusalReasonCode",
              "display" : "PharmacySupplyRequestFulfillerRevisionRefusalReasonCode",
              "definition" : "**Definition:**Indicates why the request to transfer a prescription from one dispensing facility to another has been refused.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "PharmacySupplyRequestRenewalRefusalReasonCode",
              "display" : "PharmacySupplyRequestRenewalRefusalReasonCode",
              "definition" : "Identifies the reason why a request for a prescription renewal has been refused.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19786"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "StatusRevisionRefusalReasonType",
              "display" : "StatusRevisionRefusalReasonType",
              "definition" : "Indicates why the act revision (status update) is being refused.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20363"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SubstanceAdministrationPermissionRefusalReasonCode",
              "display" : "SubstanceAdministrationPermissionRefusalReasonCode",
              "definition" : "**Definition:**Indicates why the requested authorization to prescribe or dispense a medication has been refused.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20343"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SupplyOrderAbortReasonCode",
              "display" : "SupplyOrderAbortReasonCode",
              "definition" : "Indicates why the prescription should no longer be allowed to be dispensed (but can still administer what already has been dispensed).\r\n\r\n*UsageNote:* This is typically used in the scenario where the prescription allows for repeats or refills.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19787"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "NonPerformanceReasonCode",
          "display" : "NonPerformanceReasonCode",
          "definition" : "The reason the action was not performed, e.g. why the medication was not taken. If an action was not performed, it is often clinically important to know why the action was not taken.\r\n\r\n*Examples:*Patient refused, clinically inappropriate, absolute contraindication etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ReasonForNotEvaluatingDevice",
          "display" : "ReasonForNotEvaluatingDevice",
          "definition" : "Code assigned to indicate the rationale for not performing an evaluation investigation on a device for which a defect has been reported.\r\n\r\nExamples include: device received in a condition that made analysis impossible, device evaluation anticipated but not yet begun, device not made by company.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ReferralReasonCode",
          "display" : "ReferralReasonCode",
          "definition" : "The reason a referral was made.\r\n\r\n*Examples:*Specialized Medical Assistance, Other Care Requirements.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "RefusalReasonCode",
          "display" : "RefusalReasonCode",
          "definition" : "**Description:** Identifies why a request to add (or activate) a record is being refused. Examples include the receiving system not able to match the identifier and find that record in the receiving system, having no permission, or a detected issue exists which precludes the requested action.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20345"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "SafetyInvestigationReportReasonType",
          "display" : "SafetyInvestigationReportReasonType",
          "definition" : "**Description:** Possible reasons generating a report providing information developed during the investigation of an adverse event or a product problem.\r\n\r\n**Examples:**\r\n\r\n *  Correction\r\n *  Additional information/Follow-up\r\n *  Response to regulatory agency request",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "SubstanceAdminSubstitutionNotAllowedReason",
          "display" : "SubstanceAdminSubstitutionNotAllowedReason",
          "definition" : "Reasons why substitution of a substance administration request is not permitted.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19719"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "SubstanceAdminSubstitutionReason",
          "display" : "SubstanceAdminSubstitutionReason",
          "definition" : "Indicates the reason for substitution when substitution occurs, or reason for non-substitution when substitution is expected.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19377"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "SubstanceAdministrationNoSubstitutionReason",
              "display" : "SubstanceAdministrationNoSubstitutionReason",
              "definition" : "Indicates the reason for non-substitution when substitution was expected.\r\n\r\n**Examples:**\r\n\r\n *  prescriber request\r\n *  patient request\r\n *  continuing therapy (where this latter means that the prescribed item was not substituted, even though \"policy\" implied it should be, so as not to change from the item that the patient had previously received)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SubstanceAdministrationPerformedSubstitutionReason",
              "display" : "SubstanceAdministrationPerformedSubstitutionReason",
              "definition" : "Indicates the reason for substitution when substitution has occurred.\r\n\r\n**Examples:**\r\n\r\n *  formulary policy\r\n *  regulatory requirement\r\n *  out of stock (where this latter means that the prescribed item was out of stock and an equivalent product was substituted)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "UpdateRefusalReasonCode",
          "display" : "UpdateRefusalReasonCode",
          "definition" : "**Description:** Identifies why a request to update to a record is being refused. Examples include the receiving system not able to match the identifier and find that record in the receiving system, having no permission, or a detected issue exists which precludes the requested action.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20346"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActRelationshipCheckpoint",
      "display" : "ActRelationshipCheckpoint",
      "definition" : "A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., before the Act starts for the first time, before every repetition, after each repetition but not before the first, or throughout the entire time of the Act.)\r\n\r\n*Discussion:* This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Before each step is executed and has preconditions these conditions are tested and if the test is positive, the Act has clearance for execution. The repeatNumber may indicate that an Act may be repeatedly executed. The checkpointCode is specifies when the precondition is checked and is analogous to the various conditional statements and loop constructs in programming languages \"while-do\" vs. \"do-while\" or \"repeat-until\" vs. \"loop-exit\".\r\n\r\nFor all checkpointCodes, except \"end\", preconditions are being checked at the time when the preceding step of the plan has terminated and this step would be next in the sequence established by the sequenceNumber attribute.\r\n\r\nWhen the checkpointCode for a criterion of a repeatable Act is \"end\", the criterion is tested only at the end of each repetition of that Act. When the condition holds true, the next repetition is ready for execution.\r\n\r\nWhen the checkpointCode is \"entry\" the criterion is checked at the beginning of each repetition (if any) whereas \"beginning\" means the criterion is checked only once before the repetition \"loop\" starts.\r\n\r\nThe checkpointCode \"through\" is special in that it requires the condition to hold throughout the execution of the Act, even throughout a single execution. As soon as the condition turns false, the Act should receive an interrupt event (see interruptibleInd) and will eventually terminate.\r\n\r\nThe checkpointCode \"exit\" is only used on a special plan step that represents a loop exit step. This allows an action plan to exit due to a condition tested inside the execution of this plan. Such exit criteria are sequenced with the other plan components using the ActRelationship.sequenceNumber.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10349"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActRelationshipJoin",
      "display" : "ActRelationshipJoin",
      "definition" : "A code specifying how concurrent Acts are resynchronized in a parallel branch construct.\r\n\r\n*Discussion:* This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. Branches are parallel if the splitCode specifies that more than one branch can be executed at the same time. The joinCode then specifies if and how the braches are resynchronized.\r\n\r\nThe principal re-synchronization actions are (1) the control flow waits for a branch to terminate (wait-branch), (2) the branch that is not yet terminated is aborted (kill-branch), (3) the branch is not re-synchronized at all and continues in parallel (detached branch).\r\n\r\nA kill branch is only executed if there is at least one active wait (or exclusive wait) branch. If there is no other wait branch active, a kill branch is not started at all (rather than being aborted shortly after it is started.) Since a detached branch is unrelated to all other branches, active detached branches do not protect a kill-branch from being aborted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10360"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActRelationshipSplit",
      "display" : "ActRelationshipSplit",
      "definition" : "A code specifying how branches in an action plan are selected among other branches.\r\n\r\n*Discussion:* This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. The splitCode specifies whether a branch is executed exclusively (case-switch) or inclusively, i.e., in parallel with other branches.\r\n\r\nIn addition to exlusive and inclusive split the splitCode specifies how the pre-condition (also known as \"guard conditions\" on the branch) are evaluated. A guard condition may be evaluated once when the branching step is entered and if the conditions do not hold at that time, the branch is abandoned. Conversely execution of a branch may wait until the guard condition turns true.\r\n\r\nIn exclusive wait branches, the first branch whose guard conditions turn true will be executed and all other branches abandoned. In inclusive wait branches some branches may already be executed while other branches still wait for their guard conditions to turn true.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10355"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActRelationshipSubset",
      "display" : "ActRelationshipSubset",
      "definition" : "Used to indicate that the target of the relationship will be a filtered subset of the total related set of targets.\r\n\r\nUsed when there is a need to limit the number of components to the first, the last, the next, the total, the average or some other filtered or calculated subset.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19613"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ParticipationSubset",
          "display" : "ParticipationSubset",
          "definition" : "Used to indicate that the participation is a filtered subset of the total participations of the same type owned by the Act.\r\n\r\nUsed when there is a need to limit the participations to the first, the last, the next or some other filtered subset.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingUV-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19736"
            },
            {
              "code" : "contextBindingUV-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingUV-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActRelationshipType",
      "display" : "ActRelationshipType",
      "definition" : "A code specifying the meaning and purpose of every ActRelationship instance. Each of its values implies specific constraints to what kinds of Act objects can be related and in which way.\r\n\r\n*Discussion:* The types of act relationships fall under one of 5 categories:\r\n\r\n1.) (De)-composition, with composite (source) and component (target)\r\n\r\n2.) Sequel which includes follow-up, fulfillment, instantiation, replacement, transformation, etc. that all have in common that source and target are Acts of essentially the same kind but with variances in mood and other attributes, and where the target exists before the source and the source refers to the target that it links back to.\r\n\r\n3.) Pre-condition, trigger, reason, contraindication, with the conditioned Act at the source and the condition or reason at the target.\r\n\r\n4.) Post-condition, outcome, goal and risk, with the Act at the source having the outcome or goal at the target.\r\n\r\n5.) A host of functional relationships including support, cause, derivation, etc. generalized under the notion of \"pertinence\".",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10317"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ActRelationshipEntry",
          "display" : "ActRelationshipEntry",
          "definition" : "Used to enumerate the relationships between a CDA section and its contained entries.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19446"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActRelationshipEntryRelationship",
          "display" : "ActRelationshipEntryRelationship",
          "definition" : "Description still needed",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19447"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ActRelationshipRelatedOrder",
          "display" : "ActRelationshipRelatedOrder",
          "definition" : "Description still needed",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "ActSite",
      "display" : "ActSite",
      "definition" : "An anatomical location on an organism which can be the focus of an act.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "ActBloodDonationSite",
          "display" : "ActBloodDonationSite",
          "definition" : "**Description:** Sites used for blood donation.\r\n\r\n**Examples:**\r\n\r\n *  arm\r\n *  leg\r\n *  heel",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "AnimalActSite",
          "display" : "AnimalActSite",
          "definition" : "An anatomical location on a non-human animal which can be the focus of an act.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "HumanActSite",
          "display" : "HumanActSite",
          "definition" : "An anatomical location on a human which can be the focus of an act.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "HumanSubstanceAdministrationSite",
              "display" : "HumanSubstanceAdministrationSite",
              "definition" : "**Description:** The set of body locations to or through which a substance or product may be administered.\r\n\r\n**Examples:**\r\n\r\n *  buttock\r\n *  left upper arm\r\n *  bilateral eyes",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19724"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "InjuryActSite",
              "display" : "InjuryActSite",
              "definition" : "An anatomical location on a human of an injury or disease which is the focus of an act.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "ActStatus",
      "display" : "ActStatus",
      "definition" : "Concepts representing the states in the state-machine of the RIM Act class.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15933"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ActUncertainty",
      "display" : "ActUncertainty",
      "definition" : "A code indicating whether the Act statement as a whole, with its subordinate components has been asserted to be uncertain in any way.\r\n\r\n*Examples:* Patient might have had a cholecystectomy procedure in the past (but isn't sure).\r\n\r\n*Constraints:* Uncertainty asserted using this attribute applies to the combined meaning of the Act statement established by all descriptive attributes (e.g., Act.code, Act.effectiveTime, Observation.value, SubstanceAdministration.doseQuantity, etc.), and the meanings of any components.\r\n\r\n*Discussion:*This is not intended for use to replace or compete with uncertainty associated with a Observation.values alone or other individual attributes of the class. Such pointed indications of uncertainty should be specified by applying the PPD, UVP or UVN data type extensions to the specific attribute. Particularly if the uncertainty is uncertainty of a quantitative measurement value, this must still be represented by a PPD<PQ> in the value and NOT using the uncertaintyCode. Also, when differential diagnoses are enumerated or weighed for probability, the UVP<CD> or UVN<CD> must be used, not the uncertaintyCode. The use of the uncertaintyCode is appropriate only if the entirety of the Act and its dependent Acts is questioned.\r\n\r\nNote that very vague uncertainty may be thought related to negationInd, however, the two concepts are really independent. One may be very uncertain about an event, but that does not mean that one is certain about the negation of the event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16899"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "AddressPartType",
      "display" : "AddressPartType",
      "definition" : "Discussion: The hierarchical nature of these concepts shows composition. E.g. \"Street Name\" is part of \"Street Address Line\"",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10642"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "AdministrativeGender",
      "display" : "AdministrativeGender",
      "definition" : "The gender of a person used for adminstrative purposes (as opposed to clinical gender)",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.1"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "AttentionKeyword",
      "display" : "AttentionKeyword",
      "definition" : "Provides coded key words for attribute AttentionLine.keyWordText, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "AttentionLineValue",
      "display" : "AttentionLineValue",
      "definition" : "**Definition:**The domain of possible values used as the value of attention line specifications in AttentionLine directives.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "BatchName",
      "display" : "BatchName",
      "definition" : "Provides coded names for attribute Batch.name, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "Calendar",
      "display" : "Calendar",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17422"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CalendarCycle",
      "display" : "CalendarCycle",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10684"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "CalendarCycleOneLetter",
          "display" : "CalendarCycleOneLetter",
          "definition" : "One letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingUV-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10701"
            },
            {
              "code" : "contextBindingUV-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingUV-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "CalendarCycleTwoLetter",
          "display" : "CalendarCycleTwoLetter",
          "definition" : "Two letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingUV-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10685"
            },
            {
              "code" : "contextBindingUV-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingUV-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "CalendarType",
      "display" : "CalendarType",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10682"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CaseDetectionMethod",
      "display" : "CaseDetectionMethod",
      "definition" : "Code for the method by which the public health department was made aware of the case. Includes provider report, patient self-referral, laboratory report, case or outbreak investigation, contact investigation, active surveillance, routine physical, prenatal testing, perinatal testing, prison entry screening, occupational disease surveillance, medical record review, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "Charset",
      "display" : "Charset",
      "definition" : "Internet Assigned Numbers Authority (IANA) Charset Types",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14853"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CodingRationale",
      "display" : "CodingRationale",
      "definition" : "Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Since HL7 (or a government body) may mandate that codes from certain code systems be sent in conformant messages, other synonyms that are sent in the translation set need to be distinguished among the originally captured source, the HL7 specified code, or some future role. When this code is NULL, it indicates that the translation is an undefined type. When valued, this property must contain one of the following values:\r\n\r\nSRC - Source (or original) code HL7 - HL7 Specified or Mandated SH - both HL7 mandated and the original code (precoordination)\r\n\r\nThere may be additional values added to this value set as we work through the use of codes in messages and determine other Use Cases requiring special interpretation of the translations.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19250"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CommunicationFunctionType",
      "display" : "CommunicationFunctionType",
      "definition" : "Describes the type of communication function that the associated entity plays in the associated transmission.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16031"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CompliancePackageEntityType",
      "display" : "CompliancePackageEntityType",
      "definition" : "**Definition:**A container intended to contain sufficient material for more than one use, but grouped or organized to provide individual access to sufficient material for a single use. Often used to ensure that the proper type and amount of material is consumed/expended for each use.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16170"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "CompressionAlgorithm",
      "display" : "CompressionAlgorithm",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10620"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Confidentiality",
      "display" : "Confidentiality",
      "definition" : "Types of privacy metadata classifying an IT resource (data, information object, service, or system capability) according to its level of sensitivity, which is based on an analysis of applicable privacy policies and the risk of financial, reputational, or other harm to an individual or entity that could result if made available or disclosed to unauthorized individuals, entities, or processes.\r\n\r\n*Usage Note:* Confidentiality codes may be used in security labels and privacy markings to classify IT resources based on sensitivity to indicate the obligation of a custodian or receiver to ensure that the protected resource is not made available or disclosed to individuals, entities, or processes (security principals) unless authorized per applicable policies. Confidentiality codes may also be used in the clearances of initiators requesting access to protected resources.\r\n\r\n*Map:* Definition aligns with ISO 7498-2:1989 - Confidentiality is the property that information is not made available or disclosed to unauthorized individuals, entities, or processes.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10228"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ContainerCap",
      "display" : "ContainerCap",
      "definition" : "The type of cap associated with a container",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14049"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ContainerSeparator",
      "display" : "ContainerSeparator",
      "definition" : "A material in a blood collection container that facilites the separation of of blood cells from serum or plasma",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14054"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ContentProcessingMode",
      "display" : "ContentProcessingMode",
      "definition" : "**Description:**Identifies the order in which content should be processed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19823"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ContextConductionStyle",
      "display" : "ContextConductionStyle",
      "definition" : "The styles of context conduction usable by relationships within a static model derived from tyhe HL7 Reference Information Model.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20380"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ContextControl",
      "display" : "ContextControl",
      "definition" : "Identifies the control codes that are used to manage the propagation and scope of a particular ActRelationship or Participation within a set of Acts.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16478"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Country",
      "display" : "Country",
      "definition" : "Countries of the world. ISO 3166, part 1, alpha-3 set.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.171"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Currency",
      "display" : "Currency",
      "definition" : "The currency unit as defined in ISO 4217",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17388"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "DeviceAlertLevel",
      "display" : "DeviceAlertLevel",
      "definition" : "Domain values for the Device.Alert\\_levelCode",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14066"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "DocumentCompletion",
      "display" : "DocumentCompletion",
      "definition" : "Identifies the current completion state of a clinical document.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.271"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "DocumentStorage",
      "display" : "DocumentStorage",
      "definition" : "Identifies the storage status of a document.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.275"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EducationLevel",
      "display" : "EducationLevel",
      "definition" : "**Description:** Highest level of education a person has achieved.\r\n\r\n**Examples:**\r\n\r\n *  Elementary School\r\n *  College or baccalaureate degree complete\r\n *  High School\r\n\r\n*Rationale:* These are levels, not numeric years",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19175"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19175"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ElementName",
      "display" : "ElementName",
      "definition" : "Provides coded names for attribute SortControl.elementName , which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "EmployeeJob",
      "display" : "EmployeeJob",
      "definition" : "A code specifying the job performed by the employee for the employer. For example, accountant, programmer analyst, patient care associate, staff nurse, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "EmployeeJobClass",
      "display" : "EmployeeJobClass",
      "definition" : "A code qualifying the employment in various ways, such as, full-time vs. part time, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16036"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "EmployeeOccupationCode",
          "display" : "EmployeeOccupationCode",
          "definition" : "Industry and/or jurisdictional classification system for kind-of-work performed by an employee.\r\n\r\nOccupation codes are intended primarily as work descriptions that are suitable for a multitude of public uses e.g., job matching, employment counseling, occupational and career guidance, and labor market information services.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "EmployeeSalaryType",
      "display" : "EmployeeSalaryType",
      "definition" : "A value representing the method used by an employer to compute an employee's salary or wages.\r\n\r\n*Examples:* Hourly, annual, commission",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "EmploymentStatus",
      "display" : "EmploymentStatus",
      "definition" : "A code used to define the employment status of the insured individual identified in UB-92 FL 58. UB-92 Form locator 64:Employment Status Code of the Insured. Can be used with Employee\\_Employer\\_statusCode in HL7. Values include Employed Full Time, Employed Part Time, Not Employed, Retired, On Active Military Duty",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15930"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EncounterAcuity",
      "display" : "EncounterAcuity",
      "definition" : "A code depicting the acuity (complexity of patient care, resource intensiveness of the patient care) of a patient's medical condition upon arrival. Values may be derived from formal acuity coding schemes such as RBS.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "EncounterAdmissionSource",
      "display" : "EncounterAdmissionSource",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12234"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EncounterDischargeDisposition",
      "display" : "EncounterDischargeDisposition",
      "definition" : "A code indicating patient status as of the ending service date of the period covered on this bill, as reported in FL6, Statement Covers Period. Values such as: Discharged to home or self care; Discharged/transferred to SNF, Discharged/transferred to an intermediate care facility (ICF); Expired; Hospice-medical facility. NUBC Form Locator 22",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19453"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EncounterReferralSource",
      "display" : "EncounterReferralSource",
      "definition" : "A code used to define the place or organization responsible for the patient immediately prior to their admission; for example, in the United States, as this is identified in UB-92 Form Locator 20, Source of Adm(ission).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19454"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EncounterSpecialCourtesy",
      "display" : "EncounterSpecialCourtesy",
      "definition" : "A code identifying special courtesies extended to the patient. For example, no courtesies, extended courtesies, professional courtesy, VIP courtesies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12242"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityClass",
      "display" : "EntityClass",
      "definition" : "Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top is this HL7-defined domain of high-level categories (such as represented by the Entity subclasses). Each of these terms must be harmonized and is specializable.\r\n\r\nThe value sets beneath are encoded in Entity.code and are drawn from multiple, frequently external, domains that reflect much more fine-grained typing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10882"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityCode",
      "display" : "EntityCode",
      "definition" : "A value representing the specific kind of Entity the instance represents.\r\n\r\n*Examples:* A medical building, a Doberman Pinscher, a blood collection tube, a tissue biopsy.\r\n\r\n*Rationale:* For each Entity, the value for this attribute is drawn from one of several coding systems depending on the Entity classCode, such as living subjects (animal and plant taxonomies), chemical substance (e.g., IUPAC code), organizations, insurance company, government agency, hospital, park, lake, syringe, etc. It is possible that Entity.code may be so fine grained that it represents a single instance. An example is the CDC vaccine manufacturer code, modeled as a concept vocabulary, when in fact each concept refers to a single instance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16040"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "LivingSubjectEntityType",
          "display" : "LivingSubjectEntityType",
          "definition" : "Anything that essentially has the property of life, independent of current state (a dead human corpse is still essentially a living subject).\r\n\r\n*Examples:* persons, animals, trees .",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                "code" : "LIV"
              }
            }
          ],
          "concept" : [
            {
              "code" : "NonPersonLivingSubjectEntityType",
              "display" : "NonPersonLivingSubjectEntityType",
              "definition" : "**Description:**Types of NonPersonLivingSubjects for the EntityClass \"NLIV\"",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "NLIV"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "AnimalEntityType",
                  "display" : "AnimalEntityType",
                  "definition" : "**Description:** A categorizing and grouping mechanism for different types of animal in order to support treatment and reporting. The categories are expected to correspond to a single animal species, or to a related group of species.\r\n\r\n**Examples:**\r\n\r\n *  Dog\r\n *  Reptile\r\n *  Deer",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "ANM"
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "MaterialEntityClassType",
          "display" : "MaterialEntityClassType",
          "definition" : "Types of Material for EntityClass \"MAT\"",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                "code" : "MAT"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.16041"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ContainerEntityType",
              "display" : "ContainerEntityType",
              "definition" : "**Definition:**An object used to hold other entities.\r\n\r\n**Examples:**\r\n\r\n *  Test tube\r\n *  Shoe box\r\n *  Drinking glass",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "CONT"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16143"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "HolderEntityType",
                  "display" : "HolderEntityType",
                  "definition" : "**Description:** Holders are containers that hold other containers or holders.\r\n\r\n**Examples:**\r\n\r\n *  Tube rack\r\n *  Specimen carrier\r\n *  Tray",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "HOLD"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "DeviceGenericType",
              "display" : "DeviceGenericType",
              "definition" : "Includes the set of codes used to identify a device that may be referred to in an ICSR report. Example code set reference is the FDA Center for Devices and Radiological Health product code list.\r\n\r\nExample product codes include: FOZ = Catheter, Intravascular, Therapeutic, short-term less than 30 days, MOP = Rotator, Prosthetic Heart Valve.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "DrugEntity",
              "display" : "DrugEntity",
              "definition" : "A substance whose therapeutic effect is produced by chemical action within the body.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "ClinicalDrug",
                  "display" : "ClinicalDrug",
                  "definition" : "Any substance or mixture of substances manufactured, sold or represented for use in: (a) the diagnosis, treatment, mitigation or prevention of a disease, disorder, abnormal physical state, or its symptoms, in human beings or animals; (b) restoring, correcting or modifying organic functions in human beings or animals.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ActiveIngredientDrugEntityType",
                      "display" : "ActiveIngredientDrugEntityType",
                      "definition" : "Any substance which, when combined with other ingredients, delivers all or part of the therapeutic benefit associated with a medication.\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "ActiveMoitySubstanceType",
                      "display" : "ActiveMoitySubstanceType",
                      "definition" : "A molecular structure (molecule or part of a molecule) which is the part of the molecule causing the intended pharmacological action. The value set for ActiveMoietySubstanceType may often be a subset of a SubstanceType value set. Candidate value sets are subsets of ChEBI, PubChem CID, CAS Number, InChi Key, and UNII.\r\n\r\n**Examples:**\r\n\r\n *  Metoprolol (without the succinate or tartrate)\r\n *  Amoxicillin (anhydrous)\r\n *  Heparin (ion, without the matching Na or K cation)",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                            "code" : "MMAT"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ManufacturedDrug",
                      "display" : "ManufacturedDrug",
                      "definition" : "Identifies a drug or the use of a drug as produced by a specific manufacturer\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "PackagedDrugProductEntity",
                          "display" : "PackagedDrugProductEntity",
                          "definition" : "A drug product identified at the level of the package in which it is commonly distributed. Code systems such as UPC (Universal Product Code), NDC (National Drug Code), GTIN(Global Trade Item Number) might be bound to this domain in a given realm.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ExposureAgentEntityType",
              "display" : "ExposureAgentEntityType",
              "definition" : "Indicates the material to which the patient was exposed which is believed to be related to the adverse reaction\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "NonDrugAgentEntity",
                  "display" : "NonDrugAgentEntity",
                  "definition" : "Indicates types of allergy and intolerance agents which are non-drugs. (E.g. foods, latex, etc.)",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19699"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ManufacturedMaterialEntityType",
              "display" : "ManufacturedMaterialEntityType",
              "definition" : "An Entity or combination of Entities transformed for a particular purpose by a manufacturing process.\r\n\r\n*Examples:* Processed food products, disposable syringes, chemistry analyzer, saline for infusion",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "MMAT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "EntityDeviceType",
                  "display" : "EntityDeviceType",
                  "definition" : "A type of manufactured material used in an activity, without being substantially changed through that activity.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "DEV"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "EntityDeviceTrackingTagType",
                      "display" : "EntityDeviceTrackingTagType",
                      "definition" : "**Description:**The specific kind of location-tracking tag.\r\n\r\nExamples:\r\n\r\n *  RFID\r\n *  WiFi\r\n *  Infrared",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                            "code" : "DEV"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "FeedingDeviceType",
                      "display" : "FeedingDeviceType",
                      "definition" : "A manufactured material that is used during the nutrition process but is not changed via the process.\r\n\r\n**Examples:** \r\n\r\n *  Disposable Utensils\r\n *  Plate Guard\r\n *  Sippy Cup",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MaskableMaterialEntityType",
                  "display" : "MaskableMaterialEntityType",
                  "definition" : "**Description:** Indicates the types of products whose associated records are allowed to be masked.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "MMAT"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "MicroorganismEntityType",
              "display" : "MicroorganismEntityType",
              "definition" : "**Description:**To be used to identify a microorganism when required by an act.\r\n\r\n**Examples:**\r\n\r\n *  Escherichia coli\r\n *  Caulimoviridae\r\n *  Pseudomonas aeruginosa",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "NutritionalMaterialType",
              "display" : "NutritionalMaterialType",
              "definition" : "A material that is used to provide nutritional value.\r\n\r\n**Examples:** \r\n\r\n *  Food\r\n *  Formula\r\n *  Supplements",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ],
              "concept" : [
                {
                  "code" : "FoodType",
                  "display" : "FoodType",
                  "definition" : "Concepts that identify raw, cooked or edible substances or ingredients that are intended for consumption by humans or animals to supply nourishment.\r\n\r\n**Examples:** \r\n\r\n *  Orange\r\n *  Meat\r\n *  Milk",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "NutritionalFormulaType",
                      "display" : "NutritionalFormulaType",
                      "definition" : "Concepts that identify a type of natural or manufactured food product, typically liquid or powder mixed with water, for complete or supplemental feeding.\r\n\r\n**Examples:** \r\n\r\n *  Milk-based\r\n *  Breast-milk\r\n *  Soy-based\r\n *  Peptide-based\r\n *  Elemental",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "NutritionalSupplementType",
                      "display" : "NutritionalSupplementType",
                      "definition" : "Concepts that identify a type of natural or manufactured food product used to provide additional nutrients or nourishment replacements beyond those consumed in the normal diet.\r\n\r\n**Examples:** \r\n\r\n *  High-calorie\r\n *  High-protein\r\n *  Clear liquid\r\n *  Oral electrolyte Replacement",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "NutrientType",
                  "display" : "NutrientType",
                  "definition" : "Concepts that identify the component source substance (e.g., chemical compound class and/or element) that supply nourishment by providing energy or metabolic support.\r\n\r\n**Examples:** \r\n\r\n *  Carbohydrates\r\n *  Protein\r\n *  Fat\r\n *  Calcium\r\n *  Vitamin D\r\n *  Fiber",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "PackagedProductEntityType",
              "display" : "PackagedProductEntityType",
              "definition" : "**Description:** Identifies products such as (1) the GS1 (was UPC and EAN); (2) the U.S., the National Drug Code, which is the U.S. version of what is internationally named the (3) \"Medicinal Product Identifier\" (MPID). For device products such product code is also known as the \"Unique Device Identifier\" and may or may not use the GS1 system of product codes. In local contexts the product code can come from local coding systems also, as long as it is a code that denotes to a description of a manufactured product.\r\n\r\n**Examples:** \r\n\r\n *  0049-3980-41 (NDC for Geodon Roerig 80 mg capsules 10 capsules x 8 blister packs in a carton)",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "MMAT"
                  }
                }
              ]
            },
            {
              "code" : "ProductEntityType",
              "display" : "ProductEntityType",
              "definition" : "An identifying data string for healthcare products.\r\n\r\nExample code sets include Healthcare Common Procedure Coding System (HCPCS) and Universal Product Code (UPC).",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "MMAT"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "MedicalDeviceType",
                  "display" : "MedicalDeviceType",
                  "definition" : "**Definition:**A device with direct or indirect therapeutic purpose.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "DEV"
                      }
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.16188"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "ProductIngredientSubstanceEntityType",
              "display" : "ProductIngredientSubstanceEntityType",
              "definition" : "**Description:** A type of substance that is used as an ingredient within a product.\r\n\r\n**Examples:**\r\n\r\n *  Morphine\r\n *  wheat germ\r\n *  calcium",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "MMAT"
                  }
                }
              ]
            },
            {
              "code" : "SpecimenAdditiveEntityType",
              "display" : "SpecimenAdditiveEntityType",
              "definition" : "**Definition:**Materials introduced to a specimen. These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.\r\n\r\n**Examples:**\r\n\r\n *  Ammonium heparin\r\n *  Boric Acid\r\n *  Phenol",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "MAT"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16042"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SpecimenEntityType",
              "display" : "SpecimenEntityType",
              "definition" : "**Description:** A specimen is defined as a physical entity that is an individual, a group, an item, or a part representative of a larger group, class or whole that is the target of an observation or analysis for the purpose of drawing conclusions about the group, class, or whole. This can be used to code a component of the specimen that the observation diagnosis relates to. Note that any physical entity in the universe has the potential to become a specimen.\r\n\r\n**Examples:**\r\n\r\n *  Blood\r\n *  Water\r\n *  Animal cadaver",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "ENT"
                  }
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19464"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "HumanLabSpecimenEntityType",
                  "display" : "HumanLabSpecimenEntityType",
                  "definition" : "**Description:** To be used to code the anatomic component of the human-sourced specimen that the lab observation relates to.\r\n\r\n**Examples:**\r\n\r\n *  Endometrial biopsy\r\n *  Thyroid fine needle aspirate\r\n *  Urine",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "ENT"
                      }
                    }
                  ]
                },
                {
                  "code" : "ManufacturedMaterialSpecimenEntityType",
                  "display" : "ManufacturedMaterialSpecimenEntityType",
                  "definition" : "**Description:** A specimen that is manufactured or a specimen from a manufactured material. This may be a quality control specimen or a manufactured substance.\r\n\r\n**Examples:**\r\n\r\n *  Quality control specimen\r\n *  Aspirin\r\n *  Breakfast sausage",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                        "code" : "MMAT"
                      }
                    }
                  ]
                }
              ]
            },
            {
              "code" : "VaccineType",
              "display" : "VaccineType",
              "definition" : "Types of manufactured material that when administered are intended to confer protection against specific disease(s).",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.228"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "OrganizationEntityType",
          "display" : "OrganizationEntityType",
          "definition" : "Further classifies entities of EntityClass ORG.\r\n\r\n**Examples:**\r\n\r\n *  HL7 workgroup\r\n *  corporation\r\n *  fraternal organization",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                "code" : "ORG"
              }
            }
          ],
          "concept" : [
            {
              "code" : "IndividualCaseSafetyReportSenderType",
              "display" : "IndividualCaseSafetyReportSenderType",
              "definition" : "A code that is used to indicate the type of organization which is originating and sending the ICSR. The current code example reference is from the International Conference on Harmonisation (ICH) Expert Workgroup guideline on Clinical Safety Data Management: Data Elements for Transmission of Individual Case Safety Reports.\r\n\r\nExample concepts are: Pharmaceutical Company, Regulatory Authority, Health Professional, Regional Pharmacovigilence Center, World Health Organization Collaborating Center for International Drug Monitoring.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "ORG"
                  }
                }
              ]
            },
            {
              "code" : "VaccineManufacturer",
              "display" : "VaccineManufacturer",
              "definition" : "The manufacturer of a vaccine.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "ORG"
                  }
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.227"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "PlaceEntityType",
          "display" : "PlaceEntityType",
          "definition" : "A physical place or site with its containing structure. May be natural or man-made. The geographic position of a place may or may not be constant.\r\n\r\n*Examples:* dam; city; state.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                "code" : "PLC"
              }
            }
          ],
          "concept" : [
            {
              "code" : "NationEntityType",
              "display" : "NationEntityType",
              "definition" : "Codes identifying nation states. Allows for finer grained specification of Entity with classcode <= NAT\r\n\r\n*Example:*ISO3166 country codes.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "COUNTRY"
                  }
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19749"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "TerritoryEntityType",
              "display" : "TerritoryEntityType",
              "definition" : "**Description:** A territorial entity that may be cited as the body over which an agency exercises jurisdiction, or which defines a sphere in which a party has a particular responsibility.\r\n\r\n**Examples:**\r\n\r\n *  United States\r\n *  New York\r\n *  European Union",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                    "code" : "PLC"
                  }
                }
              ]
            }
          ]
        },
        {
          "code" : "ResourceGroupEntityType",
          "display" : "ResourceGroupEntityType",
          "definition" : "Codes to characterize a Resource Group using categories that typify its membership and/or function\r\n\r\n.\r\n\r\n*Example:* PractitionerGroup",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
                "code" : "RGRP"
              }
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19652"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "EntityDeterminer",
      "display" : "EntityDeterminer",
      "definition" : "EntityDeterminer in natural language grammar is the class of words that comprises articles, demonstrative pronouns, and quantifiers. In the RIM, determiner is a structural code in the Entity class to distinguish whether any given Entity object stands for some, any one, or a specific thing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10878"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityHandling",
      "display" : "EntityHandling",
      "definition" : "Special handling requirements for an Entity.\r\n\r\n*Example:*Keep at room temperature; Keep frozen below 0 C; Keep in a dry environment; Keep upright, do not turn upside down.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.13988"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityNamePartQualifier",
      "display" : "EntityNamePartQualifier",
      "definition" : "**Description:** The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15888"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityNamePartQualifierR2",
      "display" : "EntityNamePartQualifierR2",
      "definition" : "**Description:**The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20323"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityNamePartType",
      "display" : "EntityNamePartType",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15880"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityNamePartTypeR2",
      "display" : "EntityNamePartTypeR2",
      "definition" : "**Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20322"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityNameUse",
      "display" : "EntityNameUse",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15913"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "EntityNameSearchUse",
          "display" : "EntityNameSearchUse",
          "definition" : "A name intended for use in searching or matching",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "EntityNameUseR2",
      "display" : "EntityNameUseR2",
      "definition" : "**Description:**A set of codes advising a system or user which name in a set of names to select for a given purpose.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20321"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityRisk",
      "display" : "EntityRisk",
      "definition" : "**Description:**Risk associated with the handling of the material.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10405"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EntityStatus",
      "display" : "EntityStatus",
      "definition" : "The status of an instance of the RIM Entity class.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16005"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "EquipmentAlertLevel",
      "display" : "EquipmentAlertLevel",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10896"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Ethnicity",
      "display" : "Ethnicity",
      "definition" : "In the United States, federal standards for classifying data on ethnicity determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define ethnicity, and they recognize the absence of an anthropological or scientific basis for ethnicity classification. Instead, the federal standards acknowledge that ethnicity is a social-political construct in which an individual's own identification with a particular ethnicity is preferred to observer identification. The standards specify two minimum ethnicity categories: Hispanic or Latino, and Not Hispanic or Latino. The standards define a Hispanic or Latino as a person of \"Mexican, Puerto Rican, Cuban, South or Central America, or other Spanish culture or origin, regardless of race.\" The standards stipulate that ethnicity data need not be limited to the two minimum categories, but any expansion must be collapsible to those categories. In addition, the standards stipulate that an individual can be Hispanic or Latino or can be Not Hispanic or Latino, but cannot be both.\r\n\r\n*OpenIssue:* This concept domain definition does not align with current vocabulary practices and is much too US-centric to be appropriate as a \"universal\" domain.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15836"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ExposureMode",
      "display" : "ExposureMode",
      "definition" : "Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19940"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "GenderStatus",
      "display" : "GenderStatus",
      "definition" : "A value representing whether the primary reproductive organs of NonPersonLivingSubject are present.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11523"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "GTSAbbreviation",
      "display" : "GTSAbbreviation",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10720"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "HL7ITSVersionCode",
      "display" : "HL7ITSVersionCode",
      "definition" : "HL7 implementation technology specification versions. These codes will document the ITS type and version for message encoding. The code will appear in the instances based upon rules expressed in the ITS, and do not appear in the abstract message, either as it is presented to received from the ITS.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19449"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "HL7StandardVersionCode",
      "display" : "HL7StandardVersionCode",
      "definition" : "This is the domain of HL7 version codes for the Version 3 standards. Values are to be determined by HL7 and added with each new version of the HL7 Standard.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19373"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "HL7UpdateMode",
      "display" : "HL7UpdateMode",
      "definition" : "The possible modes of updating that occur when an attribute is received by a system that already contains values for that attribute.\r\n\r\n**Open Issue:**  From April 2008 harmonization: \"Definition needs to be modified. Make contents to HL7 content mode code system match contents in this table\" Clear that this needs to be revisited.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10018"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "HtmlLinkType",
      "display" : "HtmlLinkType",
      "definition" : "HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current document and the anchor that is the target of the link",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11017"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "IdentifierReliability",
      "display" : "IdentifierReliability",
      "definition" : "**Description:** The identifier was issued by the system responsible for constructing the instance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20277"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "IdentifierScope",
      "display" : "IdentifierScope",
      "definition" : "**Description:** Codes to specify the scope in which the identifier applies to the object with which it is associated, and used in the datatype property II.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20276"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "IndustryClassificationSystem",
      "display" : "IndustryClassificationSystem",
      "definition" : "North American Industry Classification System(NAICS) for the United States, a new economic classification system that replaces the 1987 Standard Industrial Classification (SIC) for statistical purposes. NAICS is a system for classifying establishments by type of economic activity. Its purposes are: (1) to facilitate the collection, tabulation, presentation, and analysis of data relating to establishments, and (2) to promote uniformity and comparability in the presentation of statistical data describing the economy. NAICS will be used by Federal statistical agencies that collect or publish data by industry. http://www.census.gov/epcd/www/naicsusr.html",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16039"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "IntegrityCheckAlgorithm",
      "display" : "IntegrityCheckAlgorithm",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17385"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "InvoiceElementModifier",
      "display" : "InvoiceElementModifier",
      "definition" : "Designates a modifier to the code attribute to provide additional information about the invoice element.\r\n\r\n*Examples:* Isolation allowance; After-hours service\r\n\r\n*Rationale:* This is not pre-coordinated into the CD attribute because the modifier code set may not be specifically designed for use with the Act.code code set. This violates the constraint for using the 'modifier' property that the modifier code set must be defined as part of, or specifically for the base code set.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "JobTitleName",
      "display" : "JobTitleName",
      "definition" : "Provides coded names for attribute Employee.jobTitleName, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "LanguageAbilityMode",
      "display" : "LanguageAbilityMode",
      "definition" : "A value representing the method of expression of the language.\r\n\r\n*Example:*Expressed spoken, expressed written, expressed signed, received spoken, received written, received signed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12249"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "LanguageAbilityProficiency",
      "display" : "LanguageAbilityProficiency",
      "definition" : "A value representing the level of proficiency in a language.\r\n\r\n*Example:*Excellent, good, fair, poor.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12199"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ListOwnershipLevel",
      "display" : "ListOwnershipLevel",
      "definition" : "A dynamic list of individual instances of Act which reflect the needs of an individual worker, team of workers, or an organization to view roups of Acts for clinical or administrative reasons.\r\n\r\n*Discussion:* The grouped Acts are related to the WorkingList via an ActRelationship of type 'COMP' component).\r\n\r\n*Examples:* Problem lists, goal lists, allergy lists, to-do lists, etc.\r\n\r\n*Design note:* This physical class contains but a single attribute, other than those that it inherits from Act. Use of that attribute in the design of RIM-based static models has been **DEPRECATED** in HL7 RIM Harmonization, effective November 2005. This action was based on ecommendations from the Patient Care Technical Committee.\r\n\r\nAs a consequence, this class will cease to be shown as a physical class in the RIM, once the attribute is retired. Nevertheless, use of this class via an Act.classCode value of 'LIST' is entirely appropriate so long as only the attibutes inherited from Act are used.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "LivingArrangement",
      "display" : "LivingArrangement",
      "definition" : "A code depicting the living arrangements of a person",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.220"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "LivingSubjectLanguageTypes",
      "display" : "LivingSubjectLanguageTypes",
      "definition" : "Types of language sourced from an entity that is a living subject.\r\n\r\n*Usage Note:* Intended to be used for CD or CV data types. Use HumanLanguage concept domain to convey languages represented in ED.Language or other CS data types.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11526"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "HumanLanguage",
          "display" : "HumanLanguage",
          "definition" : "Codes for the representation of the names of human languages.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingUV-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.11526"
            },
            {
              "code" : "contextBindingUV-strength",
              "valueCode" : "CNE"
            },
            {
              "code" : "contextBindingUV-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "LocalMarkupIgnore",
      "display" : "LocalMarkupIgnore",
      "definition" : "Tells a receiver to ignore just the local markup tags (local\\_markup, local\\_header, local\\_attr) when value=\"markup\", or to ignore the local markup tags and all contained content when value=\"all\"",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10975"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "LocalRemoteControlState",
      "display" : "LocalRemoteControlState",
      "definition" : "A value representing the current state of control associated with the device.\r\n\r\n*Examples:* A device can either work autonomously (localRemoteControlStateCode=\"Local\") or it can be controlled by another system (localRemoteControlStateCode=\"Remote\").\r\n\r\n*Rationale:* The control status of a device must be communicated between devices prior to remote commands being transmitted. If the device is not in \"Remote\" status then external commands will be ignored.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10893"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ManagedParticipationStatus",
      "display" : "ManagedParticipationStatus",
      "definition" : "The status of an instance of the RIM Participation class.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15992"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ManufacturerModelName",
      "display" : "ManufacturerModelName",
      "definition" : "Provides coded names for attribute Device.manufacturerModelName, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "MapRelationship",
      "display" : "MapRelationship",
      "definition" : "The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept identifier) and the source coding system. The values are patterned after the similar relationships used in the UMLS Metathesaurus. Because the HL7 coding sy",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11052"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "MaritalStatus",
      "display" : "MaritalStatus",
      "definition" : "The domestic partnership status of a person.\r\n\r\n*Example:*Married, separated, divorced, widowed, common-law marriage.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12212"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15929"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "MaterialForm",
      "display" : "MaterialForm",
      "definition" : "This identifies the physical state, nature or manifestation of the material.\r\n\r\n*Usage Notes:* When the Material class is specialised to Manufactured Material, which it is to routinely to describe Medicinal products and ingredient Substances, and to Containers and Devices, the Material Form attribute is used more explicitly to describe the form and manifestation of these types of concepts - for example for medicinal products, the formCode describes their dose form (tablet, ointment); and for containers, it is their physical type (box, carton, vial).\r\n\r\nExamples:\r\n\r\n *  Powder\r\n *  Liquid\r\n *  Gas",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "When the Material class is specialised to Manufactured Material, which it is to routinely to describe Medicinal products and ingredient Substances, and to Containers and Devices, the Material Form attribute is used more explicitly to describe the form and manifestation of these types of concepts - for example for medicinal products, the formCode describes their dose form (tablet, ointment); and for containers, it is their physical type (box, carton, vial). Examples:  Powder Liquid Gas"
        },
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19651"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "ContainerForm",
          "display" : "ContainerForm",
          "definition" : "Describes the nature (or type) of the container.\r\n\r\n**Examples:**\r\n\r\n *  Carton\r\n *  Bottle\r\n *  Vial\r\n\r\n**DesignNote:**The material of the container should be separately specified (e.g. the \"cardboard\" part of cardboard carton or the \"glass\" part of glass vial should be described elsewhere).\r\n\r\n**OpenIssue:**This usage of material form is used in Common Product Model,but it is at variance of what has been done in Specimen where the same information is captured in the Entity.code values. These differences need further study.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "DoseForm",
          "display" : "DoseForm",
          "definition" : "**Description:**The physical manifestation \"entity\" that contains the active and/or inactive ingredients that deliver a dose of medicine (i.e., drug). The key defining characteristics of the dose form can be the state of matter, delivery method, release characteristics, and the administration site or route for which the product is formulated. (Derived from ISO IDMP specification, and SNOMED CT).\r\n\r\n**Examples:**\r\n\r\n *  Tablet\r\n *  Capsule\r\n *  Oral solution",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "AdministrableDrugForm",
              "display" : "AdministrableDrugForm",
              "definition" : "Indicates the form in which the drug product should be administered.\r\n\r\nThis element only needs to be specified when (a) the form in which the drug is measured for dispensing differs from the form in which the drug is administered; and (b) the form in which the quantity of the administered drug being administered is not expressed as a discrete measured mass or volume, e.g. the dose is to be measured in \"number of actuations.\"",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.14570"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "AdministratableDrugForm"
                }
              ]
            },
            {
              "code" : "AdministratableDrugForm",
              "display" : "AdministratableDrugForm",
              "definition" : "Indicates the form in which the drug product should be administered.\r\n\r\nThis element only needs to be specified when (a) the form in which the drug is measured for dispensing differs from the form in which the drug is administered; and (b) the form in which the quantity of the administered drug being administered is not expressed as a discrete measured mass or volume, e.g. the dose is to be measured in \"number of actuations.\" Note that this code is a synonym of AdministrableDrugForm, and is the original misspelling as published in the CDA R2 base; the spelling was corrected in later revisions of V3, but is kept here for backwards compatibility.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "cda"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.14570"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "AdministrableDrugForm"
                },
                {
                  "code" : "openIssue",
                  "valueString" : "Seems to be a misspelling of the name of the ConceptDomain from v3; published this way in the CDA R2 base standard."
                }
              ]
            },
            {
              "code" : "CombinedDoseForm",
              "display" : "CombinedDoseForm",
              "definition" : "The description of this is: \"Identifies, as a single concept, a combination dose form description for those products that contain two or more manufactured items in a single authorized product\".\r\n\r\n*Usage Notes:* This element needs only to be specified when the product entity describes a complete product that contains two or more manufactured items (sometimes called a combination product or a kit product); it should not be valued for (normal) products which consist of a single manufactured item with a single dose form. The combined dose form describes the orderable (manufactured) dose form of each manufactured item and (if appropriate, separately) the administrable dose form of the pharmaceutical product (as in example one below).\r\n\r\n**Examples:** \r\n\r\n *  Powder and solvent for solution for injection\r\n *  Pessary and vaginal cream\r\n *  Tablets and capsules",
              "property" : [
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "This element needs only to be specified when the product entity describes a complete product that contains two or more manufactured items (sometimes called a combination product or a kit product); it should not be valued for (normal) products which consist of a single manufactured item with a single dose form.  The combined dose form describes the orderable (manufactured) dose form of each manufactured item and (if appropriate, separately) the administrable dose form of the pharmaceutical product (as in example one below)."
                },
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "OrderableDrugForm",
              "display" : "OrderableDrugForm",
              "definition" : "**Description:**Indicates the form in which the drug product must be, or has been manufactured, or extemporaneous/magistral prepared .",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.14411"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "MediaType",
      "display" : "MediaType",
      "definition" : "Internet Assigned Numbers Authority (IANA) Mime Media Types",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14824"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "MessageWaitingPriority",
      "display" : "MessageWaitingPriority",
      "definition" : "Indicates the highest importance level of the set of messages the acknowledging application has waiting on a queue for the receiving application.\r\n\r\n*Discussion:* These messages would need to be retrieved via a query. This facilitates receiving applications that cannot receive unsolicited messages (i.e. polling). The specific code specified identifies how important the most important waiting message is (and may govern how soon the receiving application is required to poll for the message).\r\n\r\nPriority may be used by local agreement to determine the timeframe in which the receiving application is expected to retrieve the messages from the queue.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19581"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ModifyIndicator",
      "display" : "ModifyIndicator",
      "definition" : "Indicates whether the subscription to a query is new or is being modified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.395"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "NullFlavor",
      "display" : "NullFlavor",
      "definition" : "Indication or reason why a valid value is not present.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10609"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ObservationInterpretation",
      "display" : "ObservationInterpretation",
      "definition" : "The domain of possible values for a categorical assessment of an observation value.\r\n\r\n *Discussion:*  These interpretation codes are sometimes called \"abnormal flags\", however, the judgment of normalcy is just one of the common rough interpretations, and is often not relevant. For example, the susceptibility interpretations are not about \"normalcy\", and for any observation of a pathologic condition, it does not make sense to state the normalcy, since pathologic conditions are never considered \"normal.\"",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.78"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "GeneticObservationInterpretation",
          "display" : "GeneticObservationInterpretation",
          "definition" : "Concepts that specify interpretation of genetic analysis.\r\n\r\n**Examples:** \r\n\r\n *  positive\r\n *  negative\r\n *  carrier\r\n *  responsive",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingX1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20291"
            },
            {
              "code" : "contextBindingX1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingX1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationChange",
          "display" : "ObservationInterpretationChange",
          "definition" : "Interpretations of change of quantity and/or severity.\r\n\r\n**Examples:** \r\n\r\n *  better\r\n *  worse\r\n *  increased",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10214"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationDetected",
          "display" : "ObservationInterpretationDetected",
          "definition" : "Interpretations of the presence or absence of a component / analyte or organism in a test or of a sign in a clinical observation. In keeping with laboratory data processing practice, this provides a categorical interpretation of the \"meaning\" of the quantitative value for the same observation.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20328"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationExceptions",
          "display" : "ObservationInterpretationExceptions",
          "definition" : "Technical exceptions resulting in the inability to provide an interpretation, such as \"off scale\". Does not include normality or severity.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10225"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationExpectation",
          "display" : "ObservationInterpretationExpectation",
          "definition" : "Interpretation of the observed result taking into account additional information (contraindicators) about the patient's situation. Concepts in this category are mutually exclusive, i.e., at most one is allowed.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20548"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationNormality",
          "display" : "ObservationInterpretationNormality",
          "definition" : "Interpretations of normality or degree of abnormality (including critical or \"alert\" level). Concepts in this category are mutually exclusive, i.e., at most one is allowed.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10206"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ObservationInterpretationSusceptibility",
          "display" : "ObservationInterpretationSusceptibility",
          "definition" : "Interpretations of anti-microbial susceptibility testing results (microbiology). At most one allowed.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.10219"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "ReactivityObservationInterpretation",
          "display" : "ReactivityObservationInterpretation",
          "definition" : "Interpretations of the presence and level of reactivity of the specified component / analyte with the reagent in the performed laboratory test.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20477"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "ObservationMethod",
      "display" : "ObservationMethod",
      "definition" : "A code that provides additional detail about the means or technique used to ascertain the observation.\r\n\r\n*Examples:* Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc.\r\n\r\n*Constraints:* In all observations the method is already partially specified by the Act.code. In this case, the methodCode NEED NOT be used at all. The methodCode MAY still be used to identify this method more clearly in addition to what is implied from the Act.code. However, an information consumer system or process SHOULD NOT depend on this methodCode information for method detail that is implied by the Act.code.\r\n\r\nIf the methodCode is used to express method detail that is also implied by the Act.code, the methodCode MUST NOT be in conflict with the implied method of the Act.code.\r\n\r\n*Discussion:* In all observations the method is already partially specified by simply knowing the kind of observation (observation definition, Act.code) and this implicit information about the method does not need to be specified in Observation.methodCode. Particularly, most LOINC codes are defined for specific methods as long as the method makes a practical difference in interpretation. For example, the difference between susceptibility studies using the \"minimal inhibitory concentration\" (MIC) or the \"agar diffusion method\" (Kirby-Baur) are specifically assigned to different LOINC codes. The methodCode therefore is only an additional qualifier to specify what may not be known already from the Act.code.\r\n\r\nAlso, some variances in methods may be tied to the particular device used. The methodCode should not be used to identify the specific device or test-kit material used in the observation. Such information about devices or test-kits should be associated with the observation as \"device\" participations.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14079"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "AllergyTestObservationMethod",
          "display" : "AllergyTestObservationMethod",
          "definition" : "**Description:**Provides additional methodology information not present in the associated AllergyTestCode term.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "CommonClinicalObservationMethod",
          "display" : "CommonClinicalObservationMethod",
          "definition" : "**Description:**Used in a patient care message to value simple clinical (non-lab) observation methods, such as found in SOAP (subjective, objective, assessment, plan) progress notes: subjective section (used for history from patient and other informants); objective section (used for physical exam, lab, and other common results), and assessment section (used for the clinicians assessment of the implications of subjective and objective sections).",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "DecisionObservationMethod",
          "display" : "DecisionObservationMethod",
          "definition" : "Provides codes for decision methods, initially for assessing the causality of events.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19378"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "GeneticObservationMethod",
          "display" : "GeneticObservationMethod",
          "definition" : "A code that provides additional detail about the means or technique used to ascertain the genetic analysis. Example, PCR, Micro Array.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingX1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20290"
            },
            {
              "code" : "contextBindingX1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingX1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "SusceptibilityObservationMethodType",
          "display" : "SusceptibilityObservationMethodType",
          "definition" : "**Description:**\r\n\r\n**Examples:**\r\n\r\n *  Disk Diffusion (Kirby-Bauer)\r\n *  Minimum Inhibitory Concentration\r\n *  Viral Genotype Susceptibility\r\n *  Gradient Strip (E-Strip)",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                "code" : "OBS"
              }
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20423"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "VerificationMethod",
          "display" : "VerificationMethod",
          "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "ObservationValue",
      "display" : "ObservationValue",
      "definition" : "This domain is the root domain to which all HL7-recognized value sets for the Observation.value attribute will be linked when Observation.value has a coded data type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "ActCoverageAssessmentObservationValue",
          "display" : "ActCoverageAssessmentObservationValue",
          "definition" : "Codes specify the category of observation, evidence, or document used to assess for services, e.g., discharge planning, or to establish eligibility for coverage under a policy or program. The type of evidence is coded as observation values.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19918"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "ActFinancialStatusObservationValue",
              "display" : "ActFinancialStatusObservationValue",
              "definition" : "Code specifying financial indicators used to assess or establish eligibility for coverage under a policy or program; e.g., pay stub; tax or income document; asset document; living expenses.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19924"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "AgeGroupObservationValue",
          "display" : "AgeGroupObservationValue",
          "definition" : "Observation value of a person's age group (e.g., newborn infant, child preschool, young adult).",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.11.75"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "AllergyTestValue",
          "display" : "AllergyTestValue",
          "definition" : "Indicates the result of a particular allergy test. E.g. Negative, Mild, Moderate, Severe",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19696"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "AnnotationValue",
          "display" : "AnnotationValue",
          "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "ECGAnnotationValue",
              "display" : "ECGAnnotationValue",
              "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "CaseDiseaseImported",
          "display" : "CaseDiseaseImported",
          "definition" : "Code that indicates whether the disease was likely acquired outside the jurisdiction of observation, and if so, the nature of the inter-jurisdictional relationship. Possible values include not imported, imported from another country, imported from another state, imported from another jurisdiction, and insufficient information to determine.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "CaseTransmissionMode",
          "display" : "CaseTransmissionMode",
          "definition" : "Code for the mechanism by which disease was acquired by the living subject involved in the public health case. Includes sexually transmitted, airborne, bloodborne, vectorborne, foodborne, zoonotic, nosocomial, mechanical, dermal, congenital, environmental exposure, indeterminate.\r\n\r\nOpenIssue: Consider moving this attribute to Observation.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19795"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "CommonClinicalObservationValue",
          "display" : "CommonClinicalObservationValue",
          "definition" : "**Description:**Used in a patient care message to value simple clinical (non-lab) observations.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "CommonClinicalObservationAssertionValue",
              "display" : "CommonClinicalObservationAssertionValue",
              "definition" : "**Definition:** The non-laboratory, non-DI (diagnostic imaging) coded observation if no value is also required to convey the full meaning of the observation. This may be a single concept code or a complex expression.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CommonClinicalObservationComponentValue",
              "display" : "CommonClinicalObservationComponentValue",
              "definition" : "**Description:** Represents observations for components of a clinical observation whose value is expressed as a code.\r\n\r\n**Examples:**\r\n\r\n *  results for individual components of an APGAR score\r\n *  aberrant\r\n *  ABO incompatibility reaction",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CommonClinicalObservationResultValue",
              "display" : "CommonClinicalObservationResultValue",
              "definition" : "**Definition:** The non-laboratory, non-diagnostic imaging coded result of the coded observable or \"question\" represented by the paired concept from the the NonLabDICodedObservationType domain.\r\n\r\n\\]\r\n\r\n**Examples:**An APGAR result, a functional assessment, etc. The value must not require a specific unit of measure.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "CoverageChemicalDependencyValue",
          "display" : "CoverageChemicalDependencyValue",
          "definition" : "**Definition:** The category of addiction used for coverage purposes that may refer to a substance, the consumption of which may result in physical or emotional harm.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "CoverageLimitObservationValue",
          "display" : "CoverageLimitObservationValue",
          "definition" : "**Description:**Coded observation values for coverage limitations, for e.g., types of claims or types of parties covered under a policy or program.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20280"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "CoverageItemLimitObservationValue",
              "display" : "CoverageItemLimitObservationValue",
              "definition" : "**Description:**Coded observation values for types or instances of items for which coverage is provided under a policy or program, e.g., a type of vehicle or a named work of art.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "CoverageLevelObservationValue",
              "display" : "CoverageLevelObservationValue",
              "definition" : "**Description:**Coded observation values for types of covered parties under a policy or program based on their personal relationships or employment status.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20283"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "CoverageLocationLimitObservationValue",
              "display" : "CoverageLocationLimitObservationValue",
              "definition" : "**Description:**Coded observation values for types or instances of locations for which coverage is provided under a policy or program, e.g., in the covered party home, in state or in the country.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "CriticalityObservationValue",
          "display" : "CriticalityObservationValue",
          "definition" : "Values that represent a clinical judgment as to the worst case result of a future exposure (including substance administration).\r\n\r\n**Examples:** \r\n\r\n *  High criticality\r\n *  Low criticality\r\n *  Unable to assess criticality",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20549"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "CultureObservationValue",
          "display" : "CultureObservationValue",
          "definition" : "**Description:**Used to code and identify the Microbiology laboratory result value when a result is reported.\r\n\r\n**Examples:**\r\n\r\n *  Gram Positive Rods\r\n *  Epithelial Cells\r\n *  Polymorphonuclear Leukocyte",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "Diagnosis",
          "display" : "Diagnosis",
          "definition" : "Set of codes depicting clinical disease and conditions",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingUS-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.15931"
            },
            {
              "code" : "contextBindingUS-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingUS-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "FinancialClinicalSupportingObservationValue",
          "display" : "FinancialClinicalSupportingObservationValue",
          "definition" : "**Description:**Contains the supporting information values for financial transactions such as a Special Authorization Request.\r\n\r\nThis concept domain is intended to be used as the \"value\" part of a code/value pair within a generic structure that would convey any sort of information or proof of criteria that is needed to support a special authorization request. For example:\r\n\r\nOne wishes to convey a patient's DSM IV diagnosis to support a special authorization request. One code/value pair is used:\r\n\r\nActSupportingInformationCode1 = DSM IV Diagnosis, value= 315.4",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "GeneticObservationValue",
          "display" : "GeneticObservationValue",
          "definition" : "**Description:** The domain contains genetic analysis specific observation values, e.g. Homozygote, Heterozygote, etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "GISPositionAccuracyTierCode",
          "display" : "GISPositionAccuracyTierCode",
          "definition" : "**Description:** Categorizes the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19768"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "IndicationValue",
          "display" : "IndicationValue",
          "definition" : "Indicates the specific observation result which is the reason for the action (prescription, lab test, etc.). E.g. Headache, Ear infection, planned diagnostic image (requiring contrast agent), etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "DiagnosisValue",
              "display" : "DiagnosisValue",
              "definition" : "Diagnosis Value",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "OtherIndicationValue",
              "display" : "OtherIndicationValue",
              "definition" : "Indicates an observed reason for a medical action other than an indication or symptom. E.g. Need for a contrast agent prior to a diagnostic image, need for anesthesia prior to surgery, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SymptomValue",
              "display" : "SymptomValue",
              "definition" : "Indicates an observed abnormality in the patientaTMs condition, but does not assert causation. E.g. Runny nose, swelling, flaky skin, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "IndividualCaseSafetyReportValueDomains",
          "display" : "IndividualCaseSafetyReportValueDomains",
          "definition" : "This domain is established as a parent to a variety of value domains being defined to support the communication of Individual Case Safety Reports to regulatory bodies. Arguably, this aggregation is not taxonomically pure, but the grouping will facilitate the management of these domains.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "CaseSeriousnessCriteria",
              "display" : "CaseSeriousnessCriteria",
              "definition" : "A code that provides information on the overall effect or outcome of the adverse reaction/adverse event reported in the ICSR. Note the criterion applies to the case as a whole and not to an individual reaction.\r\n\r\nExample concepts are: death, disability, hospitalization, congenital anomaly/ birth defect, and other medically important condition.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                    "code" : "CASESER"
                  }
                }
              ]
            },
            {
              "code" : "DeviceManufacturerEvaluationInterpretation",
              "display" : "DeviceManufacturerEvaluationInterpretation",
              "definition" : "A code set that includes codes that are used to characterize the outcome of the device evaluation process. The code defines the manufacturer's conclusions following the evaluation.\r\n\r\nExamples include: inadequate alarms, device maintenance contributed to event, device failed just prior to use, user error caused event",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "DeviceManufacturerEvaluationMethod",
              "display" : "DeviceManufacturerEvaluationMethod",
              "definition" : "Code assigned to indicate a relevant fact within the context of the evaluation of a reported product. There are a number of concept types including the status of the evaluation, the type of evaluation findings, and the type of activity carried out as part of the evaluation process.\r\n\r\nExamples include: Actual device involved in incident was evaluated, electrical tests performed, visual examination.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "DeviceManufacturerEvaluationResult",
              "display" : "DeviceManufacturerEvaluationResult",
              "definition" : "Code assigned to indicate an outcome of the manufacturer's investigation of a product for which a defect has been reported.\r\n\r\nExamples include:.component/subassembly failure: air cleaner, computer-, imaging system-, microprocessor-controlled device problem: cache memory, design -- not fail safe.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "PertinentReactionRelatedness",
              "display" : "PertinentReactionRelatedness",
              "definition" : "A code to capture the reporter's assessment of the extent to which the reaction is related to the suspect product reported in the ICSR.\r\n\r\nExample concepts include: related, not related, possibly related and unlikely related.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "ProductCharacterization",
              "display" : "ProductCharacterization",
              "definition" : "A code that characterizes the role that the primary reporter felt that the suspect intervention -- either a substance administration or a device related procedure - played in the incident being reported. This code will capture the primary reporter's assessment of the role that the suspect product played in the incident reported in the ICSR.\r\n\r\nExamples include: Suspect, Concomitant, Interacting, Re-challenge.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SubjectReaction",
              "display" : "SubjectReaction",
              "definition" : "A code to capture the kind of reaction that was suffered by the investigated subject, and that is being reported in the ICSR. At this point, SNOMED or MedDRA have been suggested as code systems to be used for providing this information.\r\n\r\nExample concepts include hives, swelling, rash, anaphylactic shock.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SubjectReactionEmphasis",
              "display" : "SubjectReactionEmphasis",
              "definition" : "Code that captures the emphasis that the reporter placed on this reaction.\r\n\r\nExamples include: highlighted by the reporter, NOT serious, Not highlighted by the reporter, NOT serious, Highlighted by the reporter, SERIOUS, Not highlighted by the reporter, SERIOUS.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "SubjectReactionOutcome",
              "display" : "SubjectReactionOutcome",
              "definition" : "Code that captures the type of outcome from an individual outcome of a reaction to the suspect product reported in the ICSR.\r\n\r\nExamples include: Recovered/resolved. Recovering/resolving, Not recovered/not resolved, Recovered/resolved with sequelae, Fatal.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "InjuryObservationValue",
          "display" : "InjuryObservationValue",
          "definition" : "Values for observations of injuries.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "IntoleranceValue",
          "display" : "IntoleranceValue",
          "definition" : "Codes identifying pariticular groupings of allergens and other agents which cause allergies and intolerances. E.g. the drug, allergen group, food or environmental agent which triggers the intolerance",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "IsolateObservationValue",
          "display" : "IsolateObservationValue",
          "definition" : "**Description:**Used to code and identify the Isolate observation result value when a coded result is reported.\r\n\r\n**Examples:**\r\n\r\n *  Heavy growth\r\n *  Scant growth\r\n *  Moderate growth",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "IssueTriggerObservationValue",
          "display" : "IssueTriggerObservationValue",
          "definition" : "The combined domain for different types of coded observation issue triggers, such as diagnoses, allergies, etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "KnowledgeSubjectObservationValue",
          "display" : "KnowledgeSubjectObservationValue",
          "definition" : "Observation values that document the types of observations belonging to the domain KnowledgeSubjectObservationType.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.11.76"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "KnowledgeSubTopicObservationValue",
          "display" : "KnowledgeSubTopicObservationValue",
          "definition" : "Observation values that document the types of observations belonging to the domain KnowledgeSubTopicObservationType.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.11.77"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "LabResultObservationValue",
          "display" : "LabResultObservationValue",
          "definition" : "**Description:** Used to code and identify the laboratory result value when a coded result is reported.\r\n\r\n**Examples:** \r\n\r\n *  Sickle cell trait\r\n *  Hereditary Spherocytosis\r\n *  Deficiency of butyryl-CoA dehydrogenase",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "MeasureAttributeObservationValue",
          "display" : "MeasureAttributeObservationValue",
          "definition" : "Observation values used for various types of coded measure attributes in a health quality measure (eMeasure).",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "MeasureAttributeItemsCountedObservationValue",
              "display" : "MeasureAttributeItemsCountedObservationValue",
              "definition" : "Observation values used for an items counted measure attribute in a health quality measure (eMeasure).",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "MeasureAttributeJurisdictionObservationValue",
              "display" : "MeasureAttributeJurisdictionObservationValue",
              "definition" : "Observation values used for a jurisdiction measure attribute in a health quality measure (eMeasure).\r\n\r\n**Examples:** \r\n\r\n *  ISO Country codes\r\n *  State and County codes\r\n *  FIPS value sets of postal codes\r\n *  districts\r\n *  regions",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "MeasureAttributeReporterTypeObservationValue",
              "display" : "MeasureAttributeReporterTypeObservationValue",
              "definition" : "Observation values used for a reporter type measure attribute in a health quality measure (eMeasure).\r\n\r\n**Examples:** \r\n\r\n *  Laboratory\r\n *  Healthcare Providers\r\n *  Hospitals\r\n *  Healthcare facilities that are NOT hospitals\r\n *  Schools\r\n *  Pharmacists\r\n *  Veterinary lab\r\n *  Veterinarian\r\n *  Prison/Jail\r\n *  Institutions\r\n *  Employers",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "MeasureAttributeServiceDeliveryLocationObservationValue",
              "display" : "MeasureAttributeServiceDeliveryLocationObservationValue",
              "definition" : "Observation values used for a service delivery location measure attribute in a health quality measure (eMeasure).",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16927"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationMeasureScoring",
              "display" : "ObservationMeasureScoring",
              "definition" : "Observation values used to indicate the type of scoring (e.g. proportion, ratio) used by a health quality measure.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20367"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ObservationMeasureType",
              "display" : "ObservationMeasureType",
              "definition" : "Observation values used to indicate whether a health quality measure is used to sample a process or outcome over time.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20368"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "ObservationCaseStatusValue",
          "display" : "ObservationCaseStatusValue",
          "definition" : "**Description:** A code used to identify the status of a case. Used with the OBS ActClass.\r\n\r\n**Examples:**\r\n\r\n *  Suspect\r\n *  Confirmed\r\n *  Probable",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ObservationCriteriaValue",
          "display" : "ObservationCriteriaValue",
          "definition" : "**Description:**Type of coded observation values in evaluating reference ranges.\r\n\r\n**Examples:**\r\n\r\n *  Surgically transgendered transsexual, female-to-male\r\n *  AIDS-associated disorder\r\n *  Asian race",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ObservationOutbreakExtentValue",
          "display" : "ObservationOutbreakExtentValue",
          "definition" : "**Description:** A code used to identify the extent of an outbreak. Used with the OBS.\r\n\r\n**Examples:**\r\n\r\n *  Local\r\n *  Regional\r\n *  National",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "ObservationPopulationInclusionType",
          "display" : "ObservationPopulationInclusionType",
          "definition" : "Observation values used to assert that a subject falls into a particular population.\r\n\r\n**Examples:**\r\n\r\n *  Included in denominator\r\n *  Included in numerator",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "DeprecationInfo",
              "valueString" : "deprecationEffectiveVersion=1221 coremifText=This element was deprecated as of the release indicated."
            },
            {
              "code" : "deprecated",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20369"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        },
        {
          "code" : "PreferenceStrengthObservationValue",
          "display" : "PreferenceStrengthObservationValue",
          "definition" : "Values that indicate how important a preference is to the target of the reporter.\r\n\r\n**Examples:** \r\n\r\n *  Very Important\r\n *  Important\r\n *  Suggested",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "PublicHealthCaseObservationValue",
          "display" : "PublicHealthCaseObservationValue",
          "definition" : "**Description:** The PublicHealthCaseObservationValue is used to identify the primary condition or disease associated with a Public Health Case.. This concept domain is intended to be used with the CASE Act class code and the ObservationInvestigationType ActCode concept domain.\r\n\r\n**Examples:**\r\n\r\n *  Tuberculosis\r\n *  Lyme Disease\r\n *  SARS\r\n *  Lung Cancer",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ],
          "concept" : [
            {
              "code" : "OutbreakObservationValue",
              "display" : "OutbreakObservationValue",
              "definition" : "**Description:** The OutbreakObservationValue is used to identify the primary condition or disease associated with an Outbreak. This concept domain is intended to be used with the OUTB Act class code and the ObservationPublicHealthOutbreakType ActCode concept domain.\r\n\r\n**Examples:**\r\n\r\n *  Tuberculosis\r\n *  Lyme Disease\r\n *  SARS",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "SecurityObservationValue",
          "display" : "SecurityObservationValue",
          "definition" : "Observation values used to indicate security observation metadata.\r\n\r\n**Examples:** \r\n\r\n *  Codes conveying the classification of an IT resource, such as confidentiality codes\r\n *  Codes conveying privacy law, sensitivity, and consent directive types governing an IT resource\r\n *  Codes conveying dissemination controls, handling caveats, purpose of use, refrain policies, and obligations to which an IT resource custodian or receiver must comply.\r\n *  Codes conveying an IT resource completeness, veracity, reliability, trustworthiness, and provenance\r\n *  Codes conveying the mechanism used to preserve the accuracy and consistency of an IT resource such as a digital signature and a cryptographic hash function\r\n *  Codes conveying the mechanism used to make authorized alterations of an IT resource, such as translation, masking, and anonymization\r\n\r\n*Usage Note:* SecurityObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityObservationType code. \\[FIPS 188\\]",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.20469"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "SecurityCategoryObservationValue",
              "display" : "SecurityCategoryObservationValue",
              "definition" : "Security observation values used to indicate security category metadata.\r\n\r\n**Examples:** Codes conveying the category of an IT resource such as:\r\n\r\n *  applicable privacy policy\r\n *  sensitivity\r\n *  consent directive type\r\n\r\n*Usage Note:* SecurityCategoryObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityCategoryObservationType code. \\[FIPS 188\\]",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20470"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SecurityClassificationObservationValue",
              "display" : "SecurityClassificationObservationValue",
              "definition" : "Security observation values used to indicate security classification metadata.\r\n\r\n**Examples:** Codes conveying the classification of an IT resource, such as confidentiality codes.\r\n\r\n*Usage Note:* SecurityClassificationObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityClassificationObservationType code. \\[FIPS 188\\]",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20479"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SecurityControlObservationValue",
              "display" : "SecurityControlObservationValue",
              "definition" : "Security observation values used to indicate security control metadata.\r\n\r\n**Examples:** Codes conveying dissemination controls, handling caveats, purpose of use, and obligations to which an IT resource custodian or receiver must comply.\r\n\r\n*Usage Note:* SecurityControlObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityControlObservationType code. \\[FIPS 188\\]",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20471"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SecurityIntegrityObservationValue",
              "display" : "SecurityIntegrityObservationValue",
              "definition" : "Security observation values used to indicate security integrity metadata.\r\n\r\n**Examples:** Codes conveying an IT resource:\r\n\r\n *  veracity\r\n *  reliability\r\n *  trustworthiness\r\n *  provenance\r\n\r\n*Usage Note:* SecurityIntegrityObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityIntegrityObservationType code. \\[FIPS 188\\]",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20481"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "SecurityAlterationIntegrityObservationValue",
                  "display" : "SecurityAlterationIntegrityObservationValue",
                  "definition" : "Security observation values used to indicate security alteration integrity metadata.\r\n\r\n**Examples:** Codes conveying the mechanisms used to make authorized alteration of an IT resource, such as:\r\n\r\n *  translation\r\n *  masking\r\n *  anonymization\r\n\r\n*Usage Note:* SecurityAlterationIntegrityObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityAlterationIntegrityObservationType code. \\[FIPS 188\\]",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20482"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityDataIntegrityObservationValue",
                  "display" : "SecurityDataIntegrityObservationValue",
                  "definition" : "Security observation values used to indicate security data integrity metadata.\r\n\r\n**Examples:** Codes conveying the mechanisms used to preserve the accuracy and consistency of an IT resource such as:\r\n\r\n *  a digital signature\r\n *  a cryptographic hash function\r\n\r\n*Usage Note:* SecurityDataIntegrityObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityDataIntegrityObservationType code. \\[FIPS 188\\]",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20483"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityIntegrityConfidenceObservationValue",
                  "display" : "SecurityIntegrityConfidenceObservationValue",
                  "definition" : "Security observation values used to indicate security integrity confidence metadata.\r\n\r\n**Examples:** Codes conveying the level of veracity, reliability, and trustworthiness of an IT resource.\r\n\r\n*Usage Note:* Codes conveying the level of veracity, reliability, and trustworthiness of an IT resource.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20484"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityIntegrityProvenanceObservationValue",
                  "display" : "SecurityIntegrityProvenanceObservationValue",
                  "definition" : "Security observation values used to indicate security alteration integrity metadata.\r\n\r\n**Examples:** Codes conveying the provenance of an IT resource such as the entity responsible for a report or assertion relayed \"second-hand\" about an IT resource.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityIntegrityProvenanceObservationType code. \\[FIPS 188\\]",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20485"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "SecurityIntegrityProvenanceAssertedByObservationValue",
                      "display" : "SecurityIntegrityProvenanceAssertedByObservationValue",
                      "definition" : "Security observation values used to indicate security integrity provenance asserted by metadata.\r\n\r\n**Examples:** Codes conveying the provenance metadata about the entity asserting an IT resource.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceAssertedByObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityIntegrityProvenanceAssertedByObservationType code. \\[FIPS 188\\]",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20486"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "SecurityIntegrityProvenanceReportedByObservationValue",
                      "display" : "SecurityIntegrityProvenanceReportedByObservationValue",
                      "definition" : "Security observation values used to indicate security integrity provenance reported by metadata.\r\n\r\n**Examples:** Codes conveying the provenance metadata about the entity reporting an IT resource.\r\n\r\n*Usage Note:* SecurityIntegrityProvenanceReportedByObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityIntegrityProvenanceReportedByObservationType code. \\[FIPS 188\\]",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20487"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "SecurityIntegrityStatusObservationValue",
                  "display" : "SecurityIntegrityStatusObservationValue",
                  "definition" : "Security observation values used to indicate security integrity status metadata.\r\n\r\n**Examples:** Codes conveying the completeness of an IT resource in terms of workflow status such as:\r\n\r\n *  authenticated\r\n *  legally authenticated\r\n *  in progress\r\n\r\n*Usage Note:* SecurityIntegrityStatusObservationValue codes are members of a security label \"tag set\" used to populate or \"tag\" a security label field named by the associated SecurityIntegrityStatusObservationType code. \\[FIPS 188\\]",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SecurityTrustObservationValue",
              "display" : "SecurityTrustObservationValue",
              "definition" : "Observation value used to indicate aspects of trust policy applicable to an IT resource (data, information object, service, or system capability).\r\n\r\nFor example, applicable trust framework, policy, or mechanisms.\r\n\r\n*Usage Note:* Security trust metadata values may be used as the trust attribute value populating a computable trust policy, trust credential, trust assertion, or trust label field in a security label and principally used for authentication, authorization, and access control decisions.\r\n\r\nSecurityTrustObservationValue may be used as a trust attribute value populating a computable trust policy, trust credential, trust assertion, or trust label field in a security label with trust observation values. The valued trust attributes may be used for used for authentication, authorization, and access control decisions. These may also be used to negotiate trust relationships, adjudicate or bridge trust policies, and to specify requirements for participation in a Trust Domain or for asserting compliance with a Trust Framework.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.20538"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "SecurityTrustAccreditationObservationValue",
                  "display" : "SecurityTrustAccreditationObservationValue",
                  "definition" : "Values for security metadata observation made about the formal declaration by an authority or neutral third party that validates the technical, security, trust, and business practice conformance of Trust Agents to facilitate security, interoperability, and trust among participants within a security domain or trust framework.\r\n\r\nFor example, DirectTrust, Kantara Initiative, Open Identity",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20539"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustAgreementObservationValue",
                  "display" : "SecurityTrustAgreementObservationValue",
                  "definition" : "Values for security metadata observation made about security requirements with which a security domain must comply. \\[ISO IEC 10181-1\\] Conveys the agreement of an asserter to comply with jurisdictional, community, or contractual (security domains) codes of conduct which an information custodian requires as a condition of authorizing collection, access, use or disclosure.\r\n\r\nFor example, DURSA, DIRECT Applicability Statement, HIPAA Covered Entity and Business Associate Agreement, and FTC PHR Vendor, Related Entity, and third party agreements.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20544"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustAssuranceObservationValue",
                  "display" : "SecurityTrustAssuranceObservationValue",
                  "definition" : "Values for security metadata observation made about the digital quality or reliability of a trust assertion, activity, capability, information exchange, mechanism, process, or protocol.\r\n\r\nFor example, authentication, identity proofing, and non-repudiation level of assurance.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20540"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustCertificateObservationValue",
                  "display" : "SecurityTrustCertificateObservationValue",
                  "definition" : "Values for security metadata observation made about a set of security-relevant data issued by a security authority or trusted third party, together with security information which is used to provide the integrity and data origin authentication services for an IT resource (data, information object, service, or system capability). \\[Based on ISO IEC 10181-1\\]\r\n\r\nFor example, a single use certificate, dual use certificate, digital signature certificate.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20541"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustFrameworkObservationValue",
                  "display" : "SecurityTrustFrameworkObservationValue",
                  "definition" : "Values for security metadata observation made about a complete set of contracts, regulations or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. \\[Kantara Initiative\\]\r\n\r\nFor example, FICAM, DirectTrust, and HITRUST.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20542"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                },
                {
                  "code" : "SecurityTrustMechanismObservationValue",
                  "display" : "SecurityTrustMechanismObservationValue",
                  "definition" : "Values for security metadata observation made about a security architecture system component that supports enforcement of security policies.\r\n\r\nFor example, Digital signature, authorization scheme, and certificate token.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20543"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "SeverityObservationValue",
          "display" : "SeverityObservationValue",
          "definition" : "**Description:** An indication of the seriousness of the subject's condition or issue.\r\n\r\n**Examples:** \r\n\r\n *  Mild\r\n *  Moderate\r\n *  Severe",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "SusceptibilityObservationValue",
          "display" : "SusceptibilityObservationValue",
          "definition" : "**Description:**Used to code and identify the Susceptibility Observation result value when a coded result is reported.\r\n\r\n**Examples:**\r\n\r\n *  Susceptible\r\n *  Resistant\r\n *  Moderately susceptible",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "VerificationOutcomeValue",
          "display" : "VerificationOutcomeValue",
          "definition" : "Values for observations of verification act results\r\n\r\n**Examples:** Verified, not verified, verified with warning.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19793"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ]
        }
      ]
    },
    {
      "code" : "OrganizationIndustryClass",
      "display" : "OrganizationIndustryClass",
      "definition" : "Domain provides classification systems for industries.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUS-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19298"
        },
        {
          "code" : "contextBindingUS-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUS-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ParameterItemSemanticsType",
      "display" : "ParameterItemSemanticsType",
      "definition" : "A code indicating the name of a parameter item. ParameterItem classes are defined in the RIM as name-value pairs and this domain provides the name part of the ParameterItem.\r\n\r\n**Examples:** Patient Name, Drug Code, Order Effective Date",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "ParticipationFunction",
      "display" : "ParticipationFunction",
      "definition" : "This code is used to specify the exact function an actor had in a service in all necessary detail. This domain may include local extensions (CWE).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "ConceptualSpaceForClassCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
            "code" : "PRF"
          }
        },
        {
          "code" : "contextBindingX1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10267"
        },
        {
          "code" : "contextBindingX1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingX1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ],
      "concept" : [
        {
          "code" : "AuthorizedParticipationFunction",
          "display" : "AuthorizedParticipationFunction",
          "definition" : "This code is used to specify the exact function an actor is authorized to have in a service in all necessary detail.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingC1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19929"
            },
            {
              "code" : "contextBindingC1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingC1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "AuthorizedReceiverParticipationFunction",
              "display" : "AuthorizedReceiverParticipationFunction",
              "definition" : "This code is used to specify the exact function an actor is authorized to have as a receiver of information that is the subject of a consent directive or consent override.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19932"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "ConsenterParticipationFunction",
              "display" : "ConsenterParticipationFunction",
              "definition" : "This code is used to specify the exact function an actor is authorized to have in authoring a consent directive.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19930"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "OverriderParticipationFunction",
              "display" : "OverriderParticipationFunction",
              "definition" : "This code is used to specify the exact function an actor is authorized to have in authoring a consent override.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19931"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "ConsultantParticipationFunction",
          "display" : "ConsultantParticipationFunction",
          "definition" : "**Description:** Identifies functions appropriate to consultant participations.\r\n\r\n**Examples:**\r\n\r\n *  cardiologist\r\n *  anesthetist\r\n *  dietician",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "CON"
              }
            }
          ]
        },
        {
          "code" : "CoverageParticipationFunction",
          "display" : "CoverageParticipationFunction",
          "definition" : "**Definition:** Set of codes indicating the manner in which sponsors, underwriters, and payers participate in a policy or program.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "contextBindingR1-valueSet",
              "valueString" : "2.16.840.1.113883.1.11.19903"
            },
            {
              "code" : "contextBindingR1-strength",
              "valueCode" : "CWE"
            },
            {
              "code" : "contextBindingR1-effectiveDate",
              "valueDateTime" : "2020-01-01"
            }
          ],
          "concept" : [
            {
              "code" : "PayorParticipationFunction",
              "display" : "PayorParticipationFunction",
              "definition" : "**Definition:** Set of codes indicating the manner in which payors participate in a policy or program.</",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19906"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "SponsorParticipationFunction",
              "display" : "SponsorParticipationFunction",
              "definition" : "**Definition:** Set of codes indicating the manner in which sponsors participate in a policy or program. NOTE: use only when the Sponsor is not further specified with a SponsorRoleType as being either a fully insured sponsor or a self insured sponsor.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19905"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "UnderwriterParticipationFunction",
              "display" : "UnderwriterParticipationFunction",
              "definition" : "**Definition:** Set of codes indicating the manner in which underwriters participate in a policy or program.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingC1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19904"
                },
                {
                  "code" : "contextBindingC1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingC1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "MolecularInteractionFunction",
          "display" : "MolecularInteractionFunction",
          "definition" : "Specific functiona that a participant may have in a molecular interaction.\r\n\r\n*Examples:* Receptor, allosteric inhibitor, co-factor, catalyst, co-enzyme, competitive inhibitor, etc.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "PerformerParticipationFunction",
          "display" : "PerformerParticipationFunction",
          "definition" : "**Description:** Identifies functions appropriate to performer participations.\r\n\r\n**Examples:**\r\n\r\n *  surgeon\r\n *  lab technician\r\n *  janitor",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "PRF"
              }
            }
          ]
        }
      ]
    },
    {
      "code" : "ParticipationMode",
      "display" : "ParticipationMode",
      "definition" : "Identifies a means by which an Entity participates in an Act.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.16543"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ParticipationSignature",
      "display" : "ParticipationSignature",
      "definition" : "A code specifying whether and how the participant has attested his participation through a signature and or whether such a signature is needed.\r\n\r\n*Examples:* A surgical Procedure act object (representing a procedure report) requires a signature of the performing and responsible surgeon, and possibly other participants. (See also: Participation.signatureText.)",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10282"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ParticipationType",
      "display" : "ParticipationType",
      "definition" : "A code specifying the kind of Participation or involvement the Entity playing the Role associated with the Participation has with regard to the associated Act.\r\n\r\n*Constraints:* The Participant.typeCode contains only categories that have crisp semantic relevance in the scope of HL7. It is a coded attribute without exceptions and no alternative coding systems allowed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10901"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "PatientImportance",
      "display" : "PatientImportance",
      "definition" : "Patient VIP code",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19265"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "PaymentTerms",
      "display" : "PaymentTerms",
      "definition" : "Describes payment terms for a financial transaction, used in an invoice.\r\n\r\nThis is typically expressed as a responsibility of the acceptor or payor of an invoice.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14908"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "PersonDisabilityType",
      "display" : "PersonDisabilityType",
      "definition" : "A code identifying a person's disability.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.295"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "PostalAddressUse",
      "display" : "PostalAddressUse",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10637"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ProbabilityDistributionType",
      "display" : "ProbabilityDistributionType",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10747"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ProcedureMethod",
      "display" : "ProcedureMethod",
      "definition" : "**Description:**A concept whose description/definition provides additional detail about the means or technique used for the procedure.\r\n\r\n**Examples:**\r\n\r\n *  neuromuscular reeducation\r\n *  functional activity\r\n *  Laparoscopic Gastric Bypass Roux-en-Y",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "BloodDonationProcedureMethod",
          "display" : "BloodDonationProcedureMethod",
          "definition" : "**Description:** Specific method used to extract the blood from the donor subject.\r\n\r\n**Examples:** *No examples supplied with proposal.*",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "EnteralAdministrationMethodType",
          "display" : "EnteralAdministrationMethodType",
          "definition" : "A concept that conveys how a material will be administered enterally.\r\n\r\n**Examples:** \r\n\r\n *  Continuous Tube Feeding\r\n *  Gravity Drip\r\n *  Bolus Feeding",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "ProcessingID",
      "display" : "ProcessingID",
      "definition" : "This attribute defines whether the message is part of a production, training, or debugging system.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.103"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ProcessingMode",
      "display" : "ProcessingMode",
      "definition" : "This attribute defines whether the message is being sent in current processing, archive mode, initial load mode, restore from archive mode, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.207"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "QueryParameterValue",
      "display" : "QueryParameterValue",
      "definition" : "The domain of coded values used as parameters within QueryByParameter queries.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "IssueFilterCode",
          "display" : "IssueFilterCode",
          "definition" : "**Description:**Indicates how result sets should be filtered based on whether they have associated issues.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        },
        {
          "code" : "PrescriptionDispenseFilterCode",
          "display" : "PrescriptionDispenseFilterCode",
          "definition" : "A \"helper\" vocabulary used to construct complex query filters based on how and whether a prescription has been dispensed.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            }
          ]
        }
      ]
    },
    {
      "code" : "QueryPriority",
      "display" : "QueryPriority",
      "definition" : "Identifies the time frame in which the response is expected.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.91"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "QueryRequestLimit",
      "display" : "QueryRequestLimit",
      "definition" : "Defines the units associated with the magnitude of the maximum size limit of a query response that can be accepted by the requesting application",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19911"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "QueryResponse",
      "display" : "QueryResponse",
      "definition" : "Values in this domain allow a query response system to return a precise response status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.208"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "QueryStatusCode",
      "display" : "QueryStatusCode",
      "definition" : "State attributes for Query event",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.18899"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Race",
      "display" : "Race",
      "definition" : "In the United States, federal standards for classifying data on race determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define race, and they recognize the absence of an anthropological or scientific basis for racial classification. Instead, the federal standards acknowledge that race is a social-political construct in which an individual's own identification with one more race categories is preferred to observer identification. The standards use a variety of features to define five minimum race categories. Among these features are descent from \"the original peoples\" of a specified region or nation. The minimum race categories are American Indian or Alaska Native, Asian, Black or African American, Native Hawaiian or Other Pacific Islander, and White. The federal standards stipulate that race data need not be limited to the five minimum categories, but any expansion must be collapsible to those categories.\r\n\r\n*OpenIssue:* This concept domain definition does not align with current vocabulary practices and is much too US-centric to be appropriate as a \"universal\" domain.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14914"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Realm",
      "display" : "Realm",
      "definition" : "**Description:** All binding realms allowed for linking concept domains to value sets.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20355"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RelationalName",
      "display" : "RelationalName",
      "definition" : "Provides coded names for attribute RelationalExpression.elementName, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "RelationalOperator",
      "display" : "RelationalOperator",
      "definition" : "Identifies common relational operators used in selection criteria.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.209"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RelationshipConjunction",
      "display" : "RelationshipConjunction",
      "definition" : "A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.g., and, or, exclusive-or.)\r\n\r\n*Constraints:* All AND criteria must be true. If OR and AND criteria occur together, one criterion out of the OR-group must be true and all AND criteria must be true also. If XOR criteria occur together with OR and AND criteria, exactly one of the XOR criteria must be true, and at least one of the OR criteria and all AND criteria must be true. In other words, the sets of AND, OR, and XOR criteria are in turn combined by a logical AND operator (all AND criteria and at least one OR criterion and exactly one XOR criterion.) To overcome this ordering, Act criteria can be nested in any way necessary.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10365"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ReligiousAffiliation",
      "display" : "ReligiousAffiliation",
      "definition" : "Assigment of spiritual faith affiliation",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19185"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ResponseLevel",
      "display" : "ResponseLevel",
      "definition" : "Specifies whether a response is expected from the addressee of this interaction and what level of detail that response should include",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14761"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ResponseModality",
      "display" : "ResponseModality",
      "definition" : "Defines the timing and grouping of the response instances.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.394"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "ResponseMode",
      "display" : "ResponseMode",
      "definition" : "Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its receiver responsibilities.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19650"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RoleClass",
      "display" : "RoleClass",
      "definition" : "This table includes codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role.\r\n\r\nThe role hierarchy stems from three core concepts, or abstract domains:\r\n\r\n *  **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity.\r\n *  **RoleClassPartitive** collects roles in which the playing entity is in some sense a \"part\" of the scoping entity.\r\n *  **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between:\r\n    \r\n     *  **RoleClassPassive** which are roles in which the playing entity is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping entity. The playing entity is passive in these roles in that the role exists without an agreement from the playing entity.\r\n     *  **RoleClassMutualRelationship** which are relationships based on mutual behavior of the two entities. The basis of these relationship may be formal agreements or they may be *de facto* behavior. Thus, this sub-domain is further divided into:\r\n        \r\n         *  **RoleClassRelationshipFormal** in which the relationship is formally defined, frequently by a contract or agreement.\r\n         *  **Personal relationship** which inks two people in a personal relationship.\r\n\r\nThe hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the \"Personal relationship\" which is a leaf concept.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11555"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RoleCode",
      "display" : "RoleCode",
      "definition" : "Specific classification codes for further qualifying RoleClass codes.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ],
      "concept" : [
        {
          "code" : "AssocativeRoleType",
          "display" : "AssocativeRoleType",
          "definition" : "A general association between two entities that is neither partitive nor ontological.\r\n\r\n*Examples:* affiliate; agent; birthplace.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                "code" : "_RoleClassAssociative"
              }
            }
          ],
          "concept" : [
            {
              "code" : "MutualRelationshipRoleType",
              "display" : "MutualRelationshipRoleType",
              "definition" : "**Description:**Concepts which further characterizing the type of mutual relationships. Used only with the abstract code\\_RoleClassMutualRelationship.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "_RoleClassMutualRelationship"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "AgentRoleType",
                  "display" : "AgentRoleType",
                  "definition" : "An entity (player) that acts or is authorized to act on behalf of another entity (scoper).\r\n\r\n*Examples:* next of kin; assigned entity; contact.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "AGNT"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "AdministrativeContactRoleType",
                      "display" : "AdministrativeContactRoleType",
                      "definition" : "**Description:**Indicates the role an entity (player) is playing as the appropriate contact on behalf of another entity (scoper).",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingX1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.17622"
                        },
                        {
                          "code" : "contextBindingX1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingX1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "AssignedRoleType",
                      "display" : "AssignedRoleType",
                      "definition" : "**Description:** A role type that is used to further qualify an entity playing a role where the role class attribute is set to RoleClass AssignedEntity. The suggested values from V2.x include clinic receptionist, referral agent, staff physician, courtesy physician, resident, physician assistant, physical therapist, psychiatrist, psychologist, pharmacist, registered nurse, licensed practical nurse, licensed vocational nurse, nurse practitioner, etc.\r\n\r\n**Examples:**\r\n\r\n *  Janitor\r\n *  Chief of Staff\r\n *  Referral Agent\r\n *  Security Guard\r\n *  ICU Runner\r\n *  Visiting professor\r\n\r\n*Open Issue:* There needs to be work undertaken to clean up the hierarchy under this Domain as there seems to be some muddling between D:ProductLifecycleAssginedRoleType and D:ClinicalOrganizationRoleType and this new D:AssignedNonLivingSubjectRoleType. There may be other issues that need improvement in this hierarchy, and there may be some issue with the corresponding hierarchy in the code system. (identified in 11/2014 cycle)",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "ASSIGNED"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "AssignedNonLivingSubjectRoleType",
                          "display" : "AssignedNonLivingSubjectRoleType",
                          "definition" : "A role type that is used to further qualify an inanimate subject playing a role where the playing entity acts or is authorized to act on behalf of a scoping entity.\r\n\r\n**Examples:** \r\n\r\n *  Assistive device for impaired or challenged person\r\n *  Non-living entities that may participate as assigned therapeutic agents\r\n *  Entities that may be provided to patients to improve general mood, decrease depression and loneliness, and distract from stress-inducing concerns to improve quality of life.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "ProvenanceAssignedDeviceRoleType",
                              "display" : "ProvenanceAssignedDeviceRoleType",
                              "definition" : "A role type, which indicates the type of device that authors or in some manner contributes to the generation, management, and/or transmission of health information, the use of which may be tracked for purposes of determining the provenance of health information. The playing device acts or is authorized to act on behalf of a scoping entity..\r\n\r\n**Examples:** \r\n\r\n *  Patient selected home monitoring device e.g., to detect and report falls\r\n *  Provider selected medication adherence monitoring, reporting, and alerting device\r\n *  Provider designated EKG measuring and reporting device",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                },
                                {
                                  "code" : "ConceptualSpaceForClassCode",
                                  "valueCoding" : {
                                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                    "code" : "ASSIGNED"
                                  }
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "AssignedNonPersonLivingSubjectRoleType",
                          "display" : "AssignedNonPersonLivingSubjectRoleType",
                          "definition" : "**Description:**A role type that is used to further qualify a non-person subject playing a role where the role class attribute is set to RoleClass AssignedEntity\r\n\r\n*Open Issue:* The definition should be modified to clarify the fact that it is a living non-person subject. (AK 11/2014 cycle)",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            },
                            {
                              "code" : "contextBindingX1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19869"
                            },
                            {
                              "code" : "contextBindingX1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingX1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "ClinicalOrganizationRoleType",
                          "display" : "ClinicalOrganizationRoleType",
                          "definition" : "A role of an organization that further classifies the clincial responsibility for the healthcare care delivered during an encounter. E.g. cardiology service, pediatric service, nursing services.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            }
                          ]
                        },
                        {
                          "code" : "CommissioningPartyRoleType",
                          "display" : "CommissioningPartyRoleType",
                          "definition" : "*OpenIssue:* This concept domain has **no valid description**.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "COMPAR"
                              }
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "GrantorRoleType",
                              "display" : "GrantorRoleType",
                              "definition" : "**Description:** The specific kinds of roles that issue information privacy grants that permit or prohibit potential actions on information artifacts.\r\n\r\n**Examples:**\r\n\r\n *  Parent\r\n *  Legal Guardian\r\n *  Health Information Exchange",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                },
                                {
                                  "code" : "ConceptualSpaceForClassCode",
                                  "valueCoding" : {
                                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                    "code" : "ASSIGNED"
                                  }
                                }
                              ],
                              "concept" : [
                                {
                                  "code" : "GrantorOrganizationRoleType",
                                  "display" : "GrantorOrganizationRoleType",
                                  "definition" : "**Description:** The specific kinds of organizational roles that issue information privacy grants that permit or prohibit potential actions on information artifacts.\r\n\r\n**Examples:**\r\n\r\n *  Clearinghouse\r\n *  Billing Service\r\n *  Health Information Exchange",
                                  "property" : [
                                    {
                                      "code" : "source",
                                      "valueCode" : "v3"
                                    }
                                  ]
                                },
                                {
                                  "code" : "GrantorPersonRoleType",
                                  "display" : "GrantorPersonRoleType",
                                  "definition" : "**Description:** The specific kinds of person roles that issue information privacy grants that permit or prohibit potential actions on information artifacts.\r\n\r\n**Examples:**\r\n\r\n *  Self\r\n *  Parent\r\n *  Legal Guardian",
                                  "property" : [
                                    {
                                      "code" : "source",
                                      "valueCode" : "v3"
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "DeviceOperatorType",
                          "display" : "DeviceOperatorType",
                          "definition" : "Indicates the type of person that is responsible for operating the device related to the incident reported in ICSR.\r\n\r\nExamples include: Physician, Nurse, Medical Technician, Respiratory Technician.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            }
                          ]
                        },
                        {
                          "code" : "HealthcareProviderRoleType",
                          "display" : "HealthcareProviderRoleType",
                          "definition" : "A role type that is used to categorize an entity that delivers health care in an expected and professional manner to a subject in need of health care services.\r\n\r\n**Examples:**\r\n\r\n *  Registered Nurse\r\n *  Physician\r\n *  Custodial Care Clinic",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19465"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "LabSpecimenCollectionProviders",
                              "display" : "LabSpecimenCollectionProviders",
                              "definition" : "**Description:**Providers used in Laboratory messaging.",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                },
                                {
                                  "code" : "ConceptualSpaceForClassCode",
                                  "valueCoding" : {
                                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                    "code" : "PROV"
                                  }
                                },
                                {
                                  "code" : "contextBindingX1-valueSet",
                                  "valueString" : "2.16.840.1.113883.1.11.19748"
                                },
                                {
                                  "code" : "contextBindingX1-strength",
                                  "valueCode" : "CWE"
                                },
                                {
                                  "code" : "contextBindingX1-effectiveDate",
                                  "valueDateTime" : "2020-01-01"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "ICSRReportingRoleType",
                          "display" : "ICSRReportingRoleType",
                          "definition" : "**Description:** A role that is played by a party which is involved in the process originating or managing reports of adverse events or product problems.\r\n\r\n**Examples:**\r\n\r\n *  Marketing Authorization Holder\r\n *  Regulatory Agency\r\n *  Healthcare Practitioner",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "ASSIGNED"
                              }
                            }
                          ]
                        },
                        {
                          "code" : "PersonalAndLegalAssignedRoleType",
                          "display" : "PersonalAndLegalAssignedRoleType",
                          "definition" : "A \"personal and legal\" assigned relationship records the role of a person in relation to another person, or a person to himself or herself. These concepts are to be used when recording relationships based on personal or family ties or through legal assignment of responsibility.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingX1-valueSet",
                              "valueString" : "2.16.840.1.113883.11.20.12.1"
                            },
                            {
                              "code" : "contextBindingX1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingX1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "ProductLifecycleAssignedRoleType",
                          "display" : "ProductLifecycleAssignedRoleType",
                          "definition" : "A code specifying a type of responsibility that an entity may take on with respect the lifecycle of a product.\r\n\r\n**Examples:**\r\n\r\n *  Manufacturer\r\n *  Distributor\r\n *  Retailer",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "ContactRoleType",
                      "display" : "ContactRoleType",
                      "definition" : "**Description:** A role type that is used to further qualify or describe the role of the contact person or organization.\r\n\r\n**Examples:**\r\n\r\n *  Legal representative\r\n *  Primary contact\r\n *  Alternative contact",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "CON"
                          }
                        },
                        {
                          "code" : "contextBindingX1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.15920"
                        },
                        {
                          "code" : "contextBindingX1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingX1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "GuardianRoleType",
                      "display" : "GuardianRoleType",
                      "definition" : "Qualify the holder or scope of a guardianship relationship over a living subject.\r\n\r\n**Examples:**\r\n\r\n *  Guardianship held jointly by separated parents\r\n *  Guardianship held jointly by parent and another person\r\n *  Natural guardian\r\n *  Special guardian\r\n *  Guardian of property",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "GUARD"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ProductSafetyReportPartyRoleType",
                      "display" : "ProductSafetyReportPartyRoleType",
                      "definition" : "**Description:**Captures the different roles that are recorded to characterize the qualifications or stations in life of persons or organizations who participate as senders or as receivers of adverse event or product problem reports.\r\n\r\n**Example:**Example values may include: physician, healthcare facility, attorney, family member, regulatory agency. Initial effort to find defined concepts for this value set will focus on the HIPAA provider taxonomy.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "AGNT"
                          }
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "FormalRelationshipRoleType",
                  "display" : "FormalRelationshipRoleType",
                  "definition" : "A relationship between two entities that is formally recognized, frequently by a contract or similar agreement.\r\n\r\n*Examples:* agent; guarantor; patient.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "_RoleClassRelationshipFormal"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "AffiliationRoleType",
                      "display" : "AffiliationRoleType",
                      "definition" : "Concepts characterizing the type of association formed by player and scoper when there is a recognized Affiliate role by which the two parties are related.\r\n\r\n*Examples:* Business Partner, Business Associate, Colleague",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "AFFL"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CoverageSponsorRoleType",
                          "display" : "CoverageSponsorRoleType",
                          "definition" : "**Description:**Codes that indicate a specific type of sponsor. Used when the sponsor's role is only either as a fully insured sponsor or only as a self-insured sponsor. NOTE: Where a sponsor may be either, use the SponsorParticipationFunction.code (fully insured or self insured) to indicate the type of responsibility. (CO6-0057)",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19877"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "PayorRoleType",
                          "display" : "PayorRoleType",
                          "definition" : "**Description:**PayorRoleType for a particular type of policy or program benefit package or plan where more detail about the coverage administration role of the Payor is required. The functions performed by a Payor qualified by a PayorRoleType may be specified by the PayorParticpationFunction value set.\r\n\r\n**Examples:**A Payor that is a TPA may administer a managed care plan without underwriting the risk.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19853"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        },
                        {
                          "code" : "ResponsibleParty",
                          "display" : "ResponsibleParty",
                          "definition" : "The role played by a party who has legal responsibility for another party.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19830"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "PowerOfAttorney",
                              "display" : "PowerOfAttorney",
                              "definition" : "A relationship between two people in which one person authorizes another to act for him in a manner which is a legally binding upon the person giving such authority as if he or she personally were to do the acts.",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                },
                                {
                                  "code" : "contextBindingR1-valueSet",
                                  "valueString" : "2.16.840.1.113883.1.11.19831"
                                },
                                {
                                  "code" : "contextBindingR1-strength",
                                  "valueCode" : "CWE"
                                },
                                {
                                  "code" : "contextBindingR1-effectiveDate",
                                  "valueDateTime" : "2020-01-01"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "CitizenRoleType",
                      "display" : "CitizenRoleType",
                      "definition" : "A role type used to qualify a person's legal status within a country or nation.\r\n\r\n**Examples:**\r\n\r\n *  Full citizen\r\n *  Asylum seeker\r\n *  Permit card holder",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "CIT"
                          }
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20371"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "CoveredPartyRoleType",
                      "display" : "CoveredPartyRoleType",
                      "definition" : "A role recognized through the eligibility of an identified living subject for benefits covered under an insurance policy or a program. Eligibility as a covered party may be conditioned on a relationship with (1) the policy holder such as the policy holder who is covered as an individual under a poliy or as a party sponsored for coverage by the policy holder.\r\n\r\n**Example:**An employee as a subscriber; or (2) on being scoped another covered party such as the subscriber, as in the case of a dependent.\r\n\r\n**Discussion:** The Abstract Value Set \"CoverageRoleType\", which was developed for use in the Canadian realm \"pre-coordinate\" coverage roles with other roles that a covered party must play in order to be eligible for coverage, e.g., \"handicapped dependent\". Other codes in the Abstract Value Set CoveredPartyRoleType domain can be \"post-coordinated\" with the EligiblePartyRoleType codes to denote comparable concepts. Decoupling the concepts is intended to support a wider range of concepts and semantic comparability of coded concepts.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "COVPTY"
                          }
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19805"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "StudentRoleType",
                          "display" : "StudentRoleType",
                          "definition" : "Type of role attendance the covered party has at a recognized educational institution as defined by a particular insurance policy.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "NAMED"
                              }
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19671"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "EmployeeRoleType",
                      "display" : "EmployeeRoleType",
                      "definition" : "**Description:** A role type that is used to further qualify an entity playing a role where the role class attribute is set to RoleClass Employee. This specifies the relationship the staff person has with the institution for whom he/she provides services.\r\n\r\n**Examples:**\r\n\r\n *  Employee\r\n *  Volunteer\r\n *  Consultant",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "EMP"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "InvestigatedSubjectRoleType",
                      "display" : "InvestigatedSubjectRoleType",
                      "definition" : "**Description:** A code further classifying the type of investigated subject role. Used with the INVSBJ role class code.\r\n\r\n**Examples:**\r\n\r\n *  Case subject\r\n *  Suspect\r\n *  Person of interest",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "INVSBJ"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ResearchSubjectRoleBasis",
                          "display" : "ResearchSubjectRoleBasis",
                          "definition" : "Specifies the administrative functionality within a formal experimental design for which the ResearchSubject role was established. Examples: screening - role is used for pre-enrollment evaluation portion of the design; enrolled - role is used for subjects admitted to the active treatment portion of the design.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "RESBJ"
                              }
                            },
                            {
                              "code" : "contextBindingR1-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19417"
                            },
                            {
                              "code" : "contextBindingR1-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingR1-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "LicensedRoleType",
                      "display" : "LicensedRoleType",
                      "definition" : "*OpenIssue:* This concept domain has **no valid description**.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "LIC"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ProviderCodes",
                          "display" : "ProviderCodes",
                          "definition" : "Healthcare Provider Taxonomy Codes",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "PROV"
                              }
                            },
                            {
                              "code" : "contextBindingUS-valueSet",
                              "valueString" : "2.16.840.1.113883.1.11.19465"
                            },
                            {
                              "code" : "contextBindingUS-strength",
                              "valueCode" : "CWE"
                            },
                            {
                              "code" : "contextBindingUS-effectiveDate",
                              "valueDateTime" : "2020-01-01"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "QualifiedRoleType",
                      "display" : "QualifiedRoleType",
                      "definition" : "**Description:** A category to which a person can be assigned on the basis of professional qualification, experience, and/or job assignment.\r\n\r\n**Examples:**\r\n\r\n *  Physician\r\n *  Registered Nurse\r\n *  Product Quality Manager",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "QUAL"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CertifiedEntityType",
                          "display" : "CertifiedEntityType",
                          "definition" : "Defines types of certifications for all entities",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "QUAL"
                              }
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "PractitionerCertifiedEntityType",
                              "display" : "PractitionerCertifiedEntityType",
                              "definition" : "Defines types of certifications for practitioners\r\n\r\n*OpenIssue:* This concept domain should be reviewed to determine whether it needs a \"ConceptualSpaceForClassCode\" property to link to a RIM classCode.",
                              "property" : [
                                {
                                  "code" : "source",
                                  "valueCode" : "v3"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "PersonalRelationshipRoleType",
                  "display" : "PersonalRelationshipRoleType",
                  "definition" : "**Description:** Types of personal relationships between two living subjects.\r\n\r\n**Examples:**\r\n\r\n *  Parent\r\n *  sibling\r\n *  unrelated friend\r\n *  neighbor",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "PRS"
                      }
                    },
                    {
                      "code" : "contextBindingR1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.19563"
                    },
                    {
                      "code" : "contextBindingR1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingR1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "FamilyMemberRelationshipRoleType",
                      "display" : "FamilyMemberRelationshipRoleType",
                      "definition" : "The type of familial relationship between a living subject and another living subject.\r\n\r\n**Examples:**\r\n\r\n *  Father\r\n *  Mother\r\n *  Uncle",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19579"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "PassiveRoleType",
              "display" : "PassiveRoleType",
              "definition" : "An association for a playing Entity that is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping Entity. The playing Entity is passive in these roles (even though it may be active in other roles), in the sense that the kinds of things done to it in this role happen without an agreement from the playing Entity.\r\n\r\n*Examples:* birthplace; owned entity; used entity.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "_RoleClassPassive"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "AdministrativeLocationRoleType",
                  "display" : "AdministrativeLocationRoleType",
                  "definition" : "*OpenIssue:* This concept domain has **no valid description**.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "_RoleClassPassive"
                      }
                    }
                  ]
                },
                {
                  "code" : "HealthcareServiceLocation",
                  "display" : "HealthcareServiceLocation",
                  "definition" : "A set of concepts representing locations and settings where healthcare services are provided.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "SDLOC"
                      }
                    },
                    {
                      "code" : "contextBindingC1-valueSet",
                      "valueString" : "2.16.840.1.113883.1.11.20275"
                    },
                    {
                      "code" : "contextBindingC1-strength",
                      "valueCode" : "CWE"
                    },
                    {
                      "code" : "contextBindingC1-effectiveDate",
                      "valueDateTime" : "2020-01-01"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "DedicatedServiceDeliveryLocationRoleType",
                      "display" : "DedicatedServiceDeliveryLocationRoleType",
                      "definition" : "A role of a place that further classifies a setting that is intended to house the provision of services.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "DSDLOC"
                          }
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19450"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "IncidentalServiceDeliveryLocationRoleType",
                      "display" : "IncidentalServiceDeliveryLocationRoleType",
                      "definition" : "Types of locations,that are not designed for the purpose of providing health care services but where care provision takes place.\r\n\r\n**Examples:**\r\n\r\n *  Accident site\r\n *  Patient's residence\r\n *  School\r\n *  Work site",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "ISDLOC"
                          }
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.19451"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "IdentifiedEntityType",
                  "display" : "IdentifiedEntityType",
                  "definition" : "**Definition:** A code representing the type of identifier that has been assigned to the identified entity (IDENT).\r\n\r\n**Examples:** Example values include Social Insurance Number, Product Catalog ID, Product Model Number.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "IDENT"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LocationIdentifiedEntityRoleType",
                      "display" : "LocationIdentifiedEntityRoleType",
                      "definition" : "**Description:**Describes types of identifiers other than the primary location registry identifier for a service delivery location. Identifiers may be assigned by a local service delivery organization, a formal body capable of accrediting the location for the capability to provide specific services or the identifier may be assigned at a jurisdictional level.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "contextBindingR1-valueSet",
                          "valueString" : "2.16.840.1.113883.1.11.20422"
                        },
                        {
                          "code" : "contextBindingR1-strength",
                          "valueCode" : "CWE"
                        },
                        {
                          "code" : "contextBindingR1-effectiveDate",
                          "valueDateTime" : "2020-01-01"
                        }
                      ]
                    },
                    {
                      "code" : "PersonIdentifierRoleType",
                      "display" : "PersonIdentifierRoleType",
                      "definition" : "Types of identifiers for persons.\r\n\r\n**Examples:** \r\n\r\n *  Social insurance number\r\n *  Passport number\r\n *  Drivers license number\r\n *  Jurisdiction health number",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        }
                      ]
                    },
                    {
                      "code" : "SpecimenIdentifierRoleType",
                      "display" : "SpecimenIdentifierRoleType",
                      "definition" : "**Description:** A role by which one can communicate additional identifiers for a specimen.\r\n\r\n**Examples:**\r\n\r\n *  specimen identifier\r\n *  accession identifier\r\n *  container identifier",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "IDENT"
                          }
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MolecularBondRoleType",
                  "display" : "MolecularBondRoleType",
                  "definition" : "The nature of the bonds by which two molecular parts may be connected.\r\n\r\n*Examples:* (1) simple bonds such as, single bond, double bond, triple bond, (2) specialized bonds such as peptide bond, disulfide bond, etc., (3) weak bonds such as van-der-Waals, chelate, and ion-associations.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "BOND"
                      }
                    }
                  ]
                },
                {
                  "code" : "MolecularFeatureRoleType",
                  "display" : "MolecularFeatureRoleType",
                  "definition" : "The generalization of molecular parts (partitive role) and molecular bonds (associative role), or possibly any other role type used for the expression of structural molecular features.\r\n\r\n*Examples:* (1) acetyl group (a moiety), (2) disulfide bond (a bond), (3) O-linked glycosylation (a moiety).",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "NDCRelatedDrugEntityType",
                  "display" : "NDCRelatedDrugEntityType",
                  "definition" : "NDC Regulated Drug Entity Type",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "RGPR"
                      }
                    }
                  ]
                },
                {
                  "code" : "ProductProcessingOrganizationRoleType",
                  "display" : "ProductProcessingOrganizationRoleType",
                  "definition" : "**Description:** Indicates the role that an organization takes in the process by which a product goes from an original manufacturer to the eventual consumer.\r\n\r\n**Examples:**Manufacturer, re-processor\r\n\r\n**Note:**These two values are currently used in adverse event and product problem reporting.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "MANU"
                      }
                    }
                  ]
                },
                {
                  "code" : "ProductRegulatoryServicesLocationRoleType",
                  "display" : "ProductRegulatoryServicesLocationRoleType",
                  "definition" : "**Description:** Provides the description of the role of a place in terms of its provision of services and functions in the product regulatory domain.\r\n\r\n**Examples:**\r\n\r\n *  pharmacovigilance masterfile location\r\n *  COSHH (Control of Substances Hazardous to Health) masterfile location\r\n *  regulatory dossier storage location\r\n *  batch release masterfile location",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "ProductRelatedRoleType",
                  "display" : "ProductRelatedRoleType",
                  "definition" : "**Description:**Concepts characterizing product related roles.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "_RoleClassPassive"
                      }
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "DistributedMaterialRoleType",
                      "display" : "DistributedMaterialRoleType",
                      "definition" : "**Description:**Codes that further characterize the distribution of a material. Used only with the DST (distributed material) role classCode.\r\n\r\n**Examples:**Intensive distribution, Selective distribution and Exclusive distribution.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "DST"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "ManufacturedProductRoleType",
                      "display" : "ManufacturedProductRoleType",
                      "definition" : "**Description:**A role type that is used to further qualify an entity playing a role where the role class attribute is set to RoleClass ManufacturedProduct.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "MANU"
                          }
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "VisionProductRoleType",
                          "display" : "VisionProductRoleType",
                          "definition" : "**Description:**A role type that is used to further qualify an entity playing a role where the role is that of a vision product such as lenses, frames, etc.",
                          "property" : [
                            {
                              "code" : "source",
                              "valueCode" : "v3"
                            },
                            {
                              "code" : "ConceptualSpaceForClassCode",
                              "valueCoding" : {
                                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                                "code" : "MANU"
                              }
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "RegulatedProductRoleType",
                      "display" : "RegulatedProductRoleType",
                      "definition" : "**Description:**Codes that further characterize a regulated product role. Used only with the RGPR (regulated product) role classCode.\r\n\r\n**Example:** Regulated drug and regulated device.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "RGPR"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "RetailedMaterialRoleType",
                      "display" : "RetailedMaterialRoleType",
                      "definition" : "**Description:**Codes that further characterize the association of a material playing the role of a retailed material to the scoper which retails the material. Used only with the RET (retailed material) role classCode.\r\n\r\n**Examples:** Department store, Self-service and Online.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "RET"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "TheraputicAgentRoleType",
                      "display" : "TheraputicAgentRoleType",
                      "definition" : "**Description:**Codes that further characterize the Theraputic Agent as a manufactured product. Used only with the THER (therapeutic agent) role classCode.\r\n\r\n**Examples:** Generic and Brand name.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "THER"
                          }
                        }
                      ]
                    },
                    {
                      "code" : "WarrantedProductRoleType",
                      "display" : "WarrantedProductRoleType",
                      "definition" : "**Description:**Codes that further characterize a warranted product role. Used only with the WRTE (warranted product) role classCode.\r\n\r\n**Example:** Express warranty, Implied Warranty and Lifetime Warranty.",
                      "property" : [
                        {
                          "code" : "source",
                          "valueCode" : "v3"
                        },
                        {
                          "code" : "ConceptualSpaceForClassCode",
                          "valueCoding" : {
                            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                            "code" : "WRTE"
                          }
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ProvenancePassiveDeviceRoleType",
                  "display" : "ProvenancePassiveDeviceRoleType",
                  "definition" : "A role type, which indicates the type of device that in some manner contributes to the generation, management, and/or transmission of health information, the use of which may be tracked for purposes of determining the provenance of health information. The playing device is passive in these roles in the sense that the device is not authorized to act on behalf of a scoping entity.\r\n\r\n**Examples:** \r\n\r\n *  Software that aggregates pre-existing content to facilitate the authorship of a new artifact by an assigned entity\r\n *  Software that translates pre-existing content to facilitate the management of that content by an assigned entity\r\n *  Software that transmits content to facilitate the exchange of that content by an assigned entity\r\n *  Privacy protective software that facilitates privacy protection and security enforcement by filtering health information and applying protections such as de-identification, masking, or redaction, and privacy marking.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "_RoleClassPassive"
                      }
                    }
                  ]
                },
                {
                  "code" : "RoleAccessType",
                  "display" : "RoleAccessType",
                  "definition" : "Type of material that provides access to another entity.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "ACCESS"
                      }
                    }
                  ]
                },
                {
                  "code" : "TerritorialAuthorityRoleType",
                  "display" : "TerritorialAuthorityRoleType",
                  "definition" : "**Description:** Concepts which further characterizing the type of territorial authority. Used only with the TERR (territorial authority) role classCode.\r\n\r\n**Example:** public health authority, judicial authority and national authority.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    },
                    {
                      "code" : "ConceptualSpaceForClassCode",
                      "valueCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                        "code" : "TERR"
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ICSRParticipantRoleQualificationType",
          "display" : "ICSRParticipantRoleQualificationType",
          "definition" : "**Description:**Different types of qualification that could be applicable for a party involved in sending or receiving a case safety report, providing the original notification or report of an adverse event or product problem.\r\n\r\n**Examples:**\r\n\r\n *  Physician\r\n *  Veterinarian\r\n *  Lawyer\r\n *  Member of the public",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                "code" : "QUAL"
              }
            }
          ]
        },
        {
          "code" : "IDMPRoleCodeType",
          "display" : "IDMPRoleCodeType",
          "definition" : "Defines elements of the IDMP model, whether concepts defined by role, or relationships between concepts defined by role, that cannot otherwise easily be distinguished within the Common Product Model structures and associated vocabulary. This domain is a collector for the different types of semantics associated with the IDMP role concept spaces.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                "code" : "ROL"
              }
            }
          ],
          "concept" : [
            {
              "code" : "IDMPProductType",
              "display" : "IDMPProductType",
              "definition" : "Provides a set of values for defining the type of Pharmaceutical Product that is related to a PhPID. This in turn determines the type of information that may be conveyed when using the Common Product Model as a vehicle for IDMP model data.\r\n\r\n**Examples:**\r\n\r\n *  Chemical Type\r\n *  Radionuclides (radioactive) Type\r\n *  Biological Substance",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            },
            {
              "code" : "IDMPRelationType",
              "display" : "IDMPRelationType",
              "definition" : "Provides a set of values for defining the relationship between different concepts when using the Common Product Model as a vehicle for IDMP model data\r\n\r\n**Examples:**\r\n\r\n *  Medicinal identifier\r\n *  Pharmaceutical identifier\r\n *  Underlying pharmaceutical concept identifier",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                }
              ]
            }
          ]
        },
        {
          "code" : "OntologicalRoleType",
          "display" : "OntologicalRoleType",
          "definition" : "A relationship in which the scoping Entity defines or specifies what the playing Entity is. Thus, the player's \"being\" (Greek: ontos) is specified.\r\n\r\n*Examples:* sameness; instance; generalization.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                "code" : "_RoleClassOntological"
              }
            }
          ],
          "concept" : [
            {
              "code" : "EquivalenceEvaluationRoleType",
              "display" : "EquivalenceEvaluationRoleType",
              "definition" : "A code specifying in what way two products are considered equivalent. One example for a value set in the US can be found in U.S. FDA \"Orange Book\" at the FDA website but the concept is universal and not a U.S. only issue.\r\n\r\n**Examples:**\r\n\r\n *  No known or suspected bioequivalence problems\r\n *  Potential bioequivalence problems have been resolved with evidence supporting bioequivalence\r\n *  Bioequivalence problems have not been fully resolved",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "EQUIV"
                  }
                }
              ]
            },
            {
              "code" : "MedicationGeneralizationRoleType",
              "display" : "MedicationGeneralizationRoleType",
              "definition" : "Identifies the specific hierarchical relationship between the playing and scoping medications.\r\n\r\n*Examples:* Generic, Generic Formulation, Therapeutic Class, etc.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "GEN"
                  }
                },
                {
                  "code" : "contextBindingR1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.19720"
                },
                {
                  "code" : "contextBindingR1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingR1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            }
          ]
        },
        {
          "code" : "PartitiveRoleType",
          "display" : "PartitiveRoleType",
          "definition" : "An association between two Entities where the playing Entity is considered in some way \"part\" of the scoping Entity, e.g., as a member, component, ingredient, or content. Being \"part\" in the broadest sense of the word can mean anything from being an integral structural component to a mere incidental temporary association of a playing Entity with a (generally larger) scoping Entity.\r\n\r\n*Examples:* part; member; ingredient.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "v3"
            },
            {
              "code" : "ConceptualSpaceForClassCode",
              "valueCoding" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                "code" : "_RoleClassPartitive"
              }
            }
          ],
          "concept" : [
            {
              "code" : "LocatedEntityRoleType",
              "display" : "LocatedEntityRoleType",
              "definition" : "**Description:** Constrains the concepts used to further characterize the association between an entity and itaTMs location. Used only with the LOCE (located entity) role classCode.\r\n\r\n**Example:** home, business and vacation home.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "LOCE"
                  }
                }
              ]
            },
            {
              "code" : "MemberRoleType",
              "display" : "MemberRoleType",
              "definition" : "A classification for further qualifying an entity playing a Member RoleClass.\r\n\r\n*Examples:* \r\n\r\n *  tribal member\r\n *  elected member\r\n *  *ex officio* member\r\n *  part-time member",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "contextBindingX1-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.15925"
                },
                {
                  "code" : "contextBindingX1-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingX1-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ]
            },
            {
              "code" : "PartRoleType",
              "display" : "PartRoleType",
              "definition" : "**Description:** Concepts which further characterizing the association two Entities where the playing Entity (the part) is a component of the whole (scoper). Used only with the PART (part) role classCode.\r\n\r\nExample: Body part, organization part and moiety.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "PART"
                  }
                }
              ],
              "concept" : [
                {
                  "code" : "MolecularPartRoleType",
                  "display" : "MolecularPartRoleType",
                  "definition" : "The senses in which a molecule may be conceptually or actually divided into parts.\r\n\r\n*Examples:* \r\n\r\n1.  sub-unit of a protein (i.e., sequences held together usually by disulfide bonds);\r\n2.  domain of a protein or component of a nucleic acid sequence (i.e., a sub-sequence identified to have a certain folding structure or function, e.g. signaling peptide of a protein precursor or promoter and open reading frame of a nucleic acid);\r\n3.  residue on a molecular base skeleton; atom of a molecule (e.g., to identify substitution with a radioactive isotope);\r\n4.  dissociable ion.\r\n\r\n*UsageNotes:* The specific code system and concepts are left to be externally defined. However, when the positionNumber attribute is to be used with the part role to indicate where the part is placed, the part role code must specify how the position number vector is to be interpreted. For example, for subunits of a protein oligomer (such as fibrinogen) held together by disulfide bonds, the part relationship would need to specify the position of the links",
                  "property" : [
                    {
                      "code" : "HL7usageNotes",
                      "valueString" : "The specific code system and concepts are left to be externally defined. However, when the positionNumber attribute is to be used with the part role to indicate where the part is placed, the part role code must specify how the position number vector is to be interpreted. For example, for subunits of a protein oligomer (such as fibrinogen) held together by disulfide bonds, the part relationship would need to specify the position of the links"
                    },
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                },
                {
                  "code" : "OrganizationPartRoleType",
                  "display" : "OrganizationPartRoleType",
                  "definition" : "Concepts which further characterize the association between two Entities which are organizations where the playing Entity (the part) is a component of the whole (scoper). Used only with the PART (part) role classCode.\r\n\r\n**Examples:** \r\n\r\n *  business unit\r\n *  department\r\n *  executive team",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SpecimenRoleType",
              "display" : "SpecimenRoleType",
              "definition" : "**Description:** Further classifies the types of specimen roles.\r\n\r\n**Examples:** Examples include Quality control specimens, grouped specimens and patient specimens.",
              "property" : [
                {
                  "code" : "source",
                  "valueCode" : "v3"
                },
                {
                  "code" : "ConceptualSpaceForClassCode",
                  "valueCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
                    "code" : "SPEC"
                  }
                },
                {
                  "code" : "contextBindingUV-valueSet",
                  "valueString" : "2.16.840.1.113883.1.11.16515"
                },
                {
                  "code" : "contextBindingUV-strength",
                  "valueCode" : "CWE"
                },
                {
                  "code" : "contextBindingUV-effectiveDate",
                  "valueDateTime" : "2020-01-01"
                }
              ],
              "concept" : [
                {
                  "code" : "DerivedSpecimenRoleType",
                  "display" : "DerivedSpecimenRoleType",
                  "definition" : "**Description:** Specimen types which further classify the types of specimens that are derived from other specimens.\r\n\r\n**Examples:** Examples include specimen sections and specimen components.",
                  "property" : [
                    {
                      "code" : "source",
                      "valueCode" : "v3"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "RoleLinkStatus",
      "display" : "RoleLinkStatus",
      "definition" : "**Description:**The status of an instance of the RIM RoleLink class.\r\n\r\n**Constraint:** It is intended to be used based on usage of the ParticipationType concept domain.\r\n\r\n**Examples:** \r\n\r\n *  Active\r\n *  No longer active\r\n *  Nullified",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.20413"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RoleLinkType",
      "display" : "RoleLinkType",
      "definition" : "A code specifying the kind of connection represented by this RoleLink, e.g., has-part, has-authority.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11603"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RoleStatus",
      "display" : "RoleStatus",
      "definition" : "The status of an instance of the RIM Role class.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.15999"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "RouteOfAdministration",
      "display" : "RouteOfAdministration",
      "definition" : "**Description:**This describes which path the administered medication takes to get into the body or into contact with the body and constitutes part of the *where* (the other part being site - see below). It is the *way in* or the course the medication must take to get to its destination.\r\n\r\nNote that a path is in no sense a description of a *final destination*; it is a stylized description of the path taken. For example, an oral antibiotic may be used to treat a severe infection on a toe; the oral route is used to get the medicine to be able to reach and treat the infection in the toe. For some specific routes of administration there may be an incidental sense of *final destination*, for example an ocular administration usually occurs when treatment of an eye condition is required. However, this is in no sense definitional: rectal administration of a medicine may be for a local effect (a steroid foam for treatment of colitis) or for a systemic effect (metronidazole for treatment of infection). The route of administration of a medicine should only be a description of the path taken and not the form.\r\n\r\n**Examples:**\r\n\r\n *  oral\r\n *  rectal\r\n *  intravenous (IV)\r\n *  subcutaneous (SC)\r\n *  intramuscular (IM)",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14581"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "Sequencing",
      "display" : "Sequencing",
      "definition" : "**DESCRIPTION:**\r\n\r\nSpecifies direction of sort.\r\n\r\n**Examples:**\r\n\r\n *  Ascending\r\n *  Descending\r\n *  None",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.390"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "SetOperator",
      "display" : "SetOperator",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17416"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "SoftwareName",
      "display" : "SoftwareName",
      "definition" : "Provides coded names for attribute Device.softwareName, which has data type SC.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "SpecialArrangement",
      "display" : "SpecialArrangement",
      "definition" : "A code indicating the type of special arrangements provided for a patient encounter (e.g., wheelchair, stretcher, interpreter, attendant, seeing eye dog). For encounters in intention moods, this information can be used to identify special arrangements that will need to be made for the incoming patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "StyleType",
      "display" : "StyleType",
      "definition" : "(abstract) Used within an instance to give the author some control over various aspects of rendering",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19602"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "SubstitutionCondition",
      "display" : "SubstitutionCondition",
      "definition" : "Identifies what sort of change is permitted or has occurred between the item that was ordered/requested and the one that was/will be provided.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.17719"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TableCellHorizontalAlign",
      "display" : "TableCellHorizontalAlign",
      "definition" : "These values are defined within the XHTML 4.0 Table Model",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10981"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TableCellScope",
      "display" : "TableCellScope",
      "definition" : "These values are defined within the XHTML 4.0 Table Model",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11012"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TableCellVerticalAlign",
      "display" : "TableCellVerticalAlign",
      "definition" : "These values are defined within the XHTML 4.0 Table Model",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10987"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TableFrame",
      "display" : "TableFrame",
      "definition" : "These values are defined within the XHTML 4.0 Table Model",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10992"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TableRules",
      "display" : "TableRules",
      "definition" : "These values are defined within the XHTML 4.0 Table Model",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingC1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.11002"
        },
        {
          "code" : "contextBindingC1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingC1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TargetAwareness",
      "display" : "TargetAwareness",
      "definition" : "A code specifying the extent to which the Entity playing the participating Role (usually as a target Participation) is aware of the associated Act.\r\n\r\n*Examples:* For diagnostic observations, is the patient, family member or other participant aware of his terminal illness?\r\n\r\n*Discussion:* If the awareness, denial, unconsciousness, etc. is the subject of medical considerations (e.g., part of the problem list), one should use explicit observations in these matters as well, and should not solely rely on this simple attribute in the Participation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingR1-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10310"
        },
        {
          "code" : "contextBindingR1-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingR1-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TelecommunicationAddressUse",
      "display" : "TelecommunicationAddressUse",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.201"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TelecommunicationCapabilities",
      "display" : "TelecommunicationCapabilities",
      "definition" : "**Description:** Concepts that define the telecommunication capabilities of a particular device. Used to identify the expected capabilities to be found at a particular telecommunication address.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        }
      ]
    },
    {
      "code" : "TimingEvent",
      "display" : "TimingEvent",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.10706"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TransmissionRelationshipType",
      "display" : "TransmissionRelationshipType",
      "definition" : "A codes specifying the meaning and purpose of every TransmissionRelationship instance. Each of the values implies specific constraints to what kinds of Transmission objects can be related and in which way.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "DeprecationInfo",
          "valueString" : "deprecationEffectiveVersion=822 coremifText=This element was deprecated as of the release indicated."
        },
        {
          "code" : "deprecated",
          "valueDateTime" : "2009-02-27"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19833"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "TransmissionRelationshipTypeCode",
      "display" : "TransmissionRelationshipTypeCode",
      "definition" : "**Description:**A code specifying the meaning and purpose of every TransmissionRelationship instance. Each of its values implies specific constraints to what kinds of Transmission objects can be related and in which way.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.19833"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CWE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "UnitsOfMeasureCaseSensitive",
      "display" : "UnitsOfMeasureCaseSensitive",
      "definition" : "\\*\\*\\*\\* MISSING DEFINITIONS \\*\\*\\*\\*",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.12839"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "URLScheme",
      "display" : "URLScheme",
      "definition" : "A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet standard RFC 1738 \\[http://www.isi.edu/in-notes/rfc1738.txt\\]. The URL specifies the protocol and the contact point defined by that protocol for the resource.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v3"
        },
        {
          "code" : "contextBindingUV-valueSet",
          "valueString" : "2.16.840.1.113883.1.11.14866"
        },
        {
          "code" : "contextBindingUV-strength",
          "valueCode" : "CNE"
        },
        {
          "code" : "contextBindingUV-effectiveDate",
          "valueDateTime" : "2020-01-01"
        }
      ]
    },
    {
      "code" : "AdministrativeSex",
      "display" : "Administrative Sex (0001)",
      "definition" : "The domain of possible values for a patient's sex.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2MaritalStatus",
      "display" : "Marital Status (0002)",
      "definition" : "The domain of possible values for a person's marital (civil/legal) status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventType",
      "display" : "Event Type (0003)",
      "definition" : "The domain of possible values for the trigger event for Version 2.x interface messages.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientClass",
      "display" : "Patient Class (0004)",
      "definition" : "The domain of possible values that systems to categorize patients by site in HL7 Version 2.x interfaces.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2Race",
      "display" : "Race (0005)",
      "definition" : "The domain of possible values for the patient's race.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Religion",
      "display" : "Religion (0006)",
      "definition" : "The domain of possible values for a person's religion.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdmissionType",
      "display" : "Admission Type (0007)",
      "definition" : "The domain of possible values for the circumstances under which the patient was or will be admitted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AcknowledgmentCode",
      "display" : "Acknowledgment code (0008)",
      "definition" : "The domain of possible values for acknowledgment codes used in Version 2.x message.  For details of usage, see message processing rules in the published Standard.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AmbulatoryStatus",
      "display" : "Ambulatory Status (0009)",
      "definition" : "The domain of possible values for permanent or transient handicapped conditions of a person.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransactionType",
      "display" : "Transaction Type (0017)",
      "definition" : "The domain of possible values for a type of financial transaction.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientType",
      "display" : "Patient Type (0018)",
      "definition" : "The domain of possible values for the patient type.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AnesthesiaCode",
      "display" : "Anesthesia Code (0019)",
      "definition" : "The domain of possible values for the anesthesia used during the procedure.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BadDebtAgencyCode",
      "display" : "Bad Debt Agency Code (0021)",
      "definition" : "The domain of possible values for the bad debt agency to which the account was transferred.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BillingStatus",
      "display" : "Billing Status (0022)",
      "definition" : "The domain of possible values for whether the particular insurance has been billed and, if so, the type of bill.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdmitSource",
      "display" : "Admit Source (0023)",
      "definition" : "The domain of possible values for where the patient was admitted.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "FeeSchedule",
      "display" : "Fee Schedule (0024)",
      "definition" : "The domain of possible values for the appropriate fee schedule to be used for this transaction posting.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Priority",
      "display" : "Priority (0027)",
      "definition" : "The domain of possible values for the allowed priorities for obtaining the specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Charge_PriceIndicator",
      "display" : "Charge/Price Indicator (0032)",
      "definition" : "The domain of possible values for which price schedule is to be used for room and bed charges.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrderStatus",
      "display" : "Order status (0038)",
      "definition" : "The domain of possible values for the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent.  Only the filler can originate these values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CompanyPlanCode",
      "display" : "Company Plan Code (0042)",
      "definition" : "The domain of possible values for an insurance company plan uniquely.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConditionCode",
      "display" : "Condition Code (0043)",
      "definition" : "The domain of possible values for the condition code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContractCode",
      "display" : "Contract Code (0044)",
      "definition" : "The domain of possible values for the type of contract entered into by the healthcare facility and the guarantor for the purpose of settling outstanding account balances.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CourtesyCode",
      "display" : "Courtesy Code (0045)",
      "definition" : "The domain of possible values for whether the patient will be extended certain special courtesies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CreditRating",
      "display" : "Credit Rating (0046)",
      "definition" : "The domain of possible values for past credit experience.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DepartmentCode",
      "display" : "Department Code (0049)",
      "definition" : "The domain of possible values for the department that controls a specified transaction code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AccidentCode",
      "display" : "Accident Code (0050)",
      "definition" : "The domain of possible values for the type of accident.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosisCode",
      "display" : "Diagnosis Code (0051)",
      "definition" : "The domain of possible values for the primary diagnosis code for billing purposes.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosisType",
      "display" : "Diagnosis Type (0052)",
      "definition" : "The domain of possible values that specify a type of diagnosis being sent.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosisRelatedGroup",
      "display" : "Diagnosis Related Group (0055)",
      "definition" : "The domain of possible values for the diagnostic related group (DRG) for the transaction.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgGrouperReviewCode",
      "display" : "DRG Grouper Review Code (0056)",
      "definition" : "The domain of possible values for that the grouper results have been reviewed and approved.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentCode",
      "display" : "Consent Code (0059)",
      "definition" : "The domain of possible values for the type of consent that was obtained for permission to treat the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CheckDigitScheme",
      "display" : "Check Digit Scheme (0061)",
      "definition" : "The domain of possible values for the check digit scheme employed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventReason",
      "display" : "Event Reason (0062)",
      "definition" : "The domain of possible values for the reason for an event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Relationship",
      "display" : "Relationship (0063)",
      "definition" : "The domain of possible values for an actual personal relationship that the next of kin/associated party has to a patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "FinancialClass",
      "display" : "Financial Class (0064)",
      "definition" : "The domain of possible values for the financial class assigned to a person.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenActionCode",
      "display" : "Specimen Action Code (0065)",
      "definition" : "The domain of possible values for actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EmploymentStatusV2",
      "display" : "Employment Status (0066)",
      "definition" : "The domain of possible values for the guarantor's employment status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GuarantorType",
      "display" : "Guarantor Type (0068)",
      "definition" : "The domain of possible values for the type of guarantor, e.g., individual, institution, etc.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "HospitalService",
      "display" : "Hospital Service (0069)",
      "definition" : "The domain of possible values for the treatment or type of surgery the patient is scheduled to receive.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InsurancePlanId",
      "display" : "Insurance Plan ID (0072)",
      "definition" : "The domain of possible values for the identifier of an insurance plan with which a transaction should be associated.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InterestRateCode",
      "display" : "Interest Rate Code (0073)",
      "definition" : "The domain of possible values for the amount of interest that will be charged the guarantor on any outstanding amounts.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosticServiceSectionId",
      "display" : "Diagnostic Service Section ID (0074)",
      "definition" : "The domain of possible values for a section of a diagnostic service where an observation may be performed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MessageType",
      "display" : "Message Type (0076)",
      "definition" : "The domain of possible values for message types.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InterpretationCodes",
      "display" : "Interpretation Codes (0078)",
      "definition" : "The domain of possible values for a categorical assessment of an observation value.\r\nDiscussion: These interpretation codes are sometimes called \"abnormal flags\", however, the judgment of normalcy is just one of the common rough interpretations, and is often not relevant. For example, the susceptibility interpretations are not about \"normalcy\", and for any observation of a pathologic condition, it does not make sense to state the normalcy, since pathologic conditions are never considered \"normal.\"",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NatureOfAbnormalTesting",
      "display" : "Nature of Abnormal Testing (0080)",
      "definition" : "The domain of possible values for the nature of an abnormal test.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OutlierType",
      "display" : "Outlier Type (0083)",
      "definition" : "The domain of possible values for the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PerformedBy",
      "display" : "Performed by (0084)",
      "definition" : "The domain of possible values for a composite number/name of a person/group that performed a test/procedure/transaction, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ObservationResultStatusCodesInterpretation",
      "display" : "Observation Result Status Codes Interpretation (0085)",
      "definition" : "The domain of possible values for observation result status. These codes reflect the current completion status of the results for one Observation Identifier.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PlanId",
      "display" : "Plan ID (0086)",
      "definition" : "The domain of possible values for the coding structure that identifies the various plan types (i.e., Medicare, Medicaid, Blue Cross, HMO, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Pre-admitTestIndicator",
      "display" : "Pre-Admit Test Indicator (0087)",
      "definition" : "The domain of possible values for whether the patient must have pre-admission testing done in order to be admitted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcedureCode",
      "display" : "Procedure Code (0088)",
      "definition" : "The domain of possible values for a unique identifier assigned to a procedure, if any, associated with a charge.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2QueryPriority",
      "display" : "Query Priority (0091)",
      "definition" : "The domain of possible values for a time frame in which a querry response is expected.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Re-admissionIndicator",
      "display" : "Re-Admission Indicator (0092)",
      "definition" : "The domain of possible values which are used to specify that a patient is being re-admitted to a healthcare facility from which they were discharged, and indicates the circumstances around such re-admission.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReleaseInformation",
      "display" : "Release Information (0093)",
      "definition" : "The domain of possible values for whether the healthcare provider can release information about a patient and what information can be released.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TypeOfAgreement",
      "display" : "Type of Agreement (0098)",
      "definition" : "The domain of possible values for codes to further identify an insurance plan.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VipIndicator",
      "display" : "VIP Indicator (0099)",
      "definition" : "The domain of possible values for a type of VIP.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InvocationEvent",
      "display" : "Invocation event (0100)",
      "definition" : "The domain of possible values for codes for an event precipitating/triggering a charge activity.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessingId",
      "display" : "Processing ID (0103)",
      "definition" : "The domain of possible values for whether the message is part of a production, training or debugging system.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VersionId",
      "display" : "Version ID (0104)",
      "definition" : "The domain of possible values which are used to identify an HL7 version in the Version 2.x family of published standards.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SourceOfComment",
      "display" : "Source of Comment (0105)",
      "definition" : "The domain of possible values which are used to specify the source of a comment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransferToBadDebtCode",
      "display" : "Transfer to Bad Debt Code (0110)",
      "definition" : "The domain of possible values for that the account was transferred to bad debts and gives the reason.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeleteAccountCode",
      "display" : "Delete Account Code (0111)",
      "definition" : "The domain of possible values for that the account was deleted from the file and gives the reason.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DischargeDisposition",
      "display" : "Discharge Disposition (0112)",
      "definition" : "The domain of possible values for the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.).  No suggested values.  In the US, this field should use the Official Uniform Billing (UB) 04 2008 numeric codes found on form locator 17.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DischargedToLocation",
      "display" : "Discharged to Location (0113)",
      "definition" : "The domain of possible values for the healthcare facility to which the patient was discharged.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DietType",
      "display" : "Diet Type (0114)",
      "definition" : "The domain of possible values for a special diet type for a patient.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ServicingFacilities",
      "display" : "Servicing Facilities (0115)",
      "definition" : "The domain of possible values for the healthcare facility with which this visit is associated in a multiple facility environment.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BedStatus",
      "display" : "Bed Status (0116)",
      "definition" : "The domain of possible values for the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AccountStatus",
      "display" : "Account Status (0117)",
      "definition" : "The domain of possible values for the account status.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MajorDiagnosticCategory",
      "display" : "Major Diagnostic Category (0118)",
      "definition" : "The domain of possible values for the major diagnostic category.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrderControlCodes",
      "display" : "Order Control Codes (0119)",
      "definition" : "The domain of possible values which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ResponseFlag",
      "display" : "Response Flag (0121)",
      "definition" : "The domain of possible values allowing the placer (sending) application to determine the amount of information to be returned from the filler.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ChargeType",
      "display" : "Charge Type (0122)",
      "definition" : "The domain of possible values for someone or something other than the patient to be billed for a service.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ResultStatus",
      "display" : "Result Status (0123)",
      "definition" : "The domain of possible values for a status of results for an order.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransportationMode",
      "display" : "Transportation Mode (0124)",
      "definition" : "The domain of possible values for how (or whether) to transport a patient, when applicable, for an ordered service.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ValueType",
      "display" : "Value Type (0125)",
      "definition" : "The domain of possible values for the format of the observation value in the Observation Result (OBX).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "QuantityLimitedRequest",
      "display" : "Quantity Limited Request (0126)",
      "definition" : "The domain of possible values for the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AllergenType",
      "display" : "Allergen Type (0127)",
      "definition" : "The domain of possible values fora classification of general allergy categories (drug, food, pollen, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AllergySeverity",
      "display" : "Allergy Severity (0128)",
      "definition" : "The domain of possible values for the general severity of an allergy.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AccommodationCode",
      "display" : "Accommodation Code (0129)",
      "definition" : "The domain of possible values for the fiancial accommodation type of the bed or room which implies the rate to be used when occupied by a patient under specific medical conditions, which determines how it is billed.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VisitUserCode",
      "display" : "Visit User Code (0130)",
      "definition" : "The domain of possible values for categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContactRole",
      "display" : "Contact Role (0131)",
      "definition" : "The domain of possible values for a relationship role that the next of kin/associated parties plays with regard to a patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that issued a referral.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransactionCode",
      "display" : "Transaction Code (0132)",
      "definition" : "The domain of possible values that are used by an institution for the purpose of uniquely identifying a transaction based on the Transaction Type.  For example, procedure, supply item, or test for charges; or to identify the payment medium for payments.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AssignmentOfBenefits",
      "display" : "Assignment of Benefits (0135)",
      "definition" : "The domain of possible values which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider.  If so, the insurance will pay the provider directly.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Yes/noIndicator",
      "display" : "Yes/no Indicator (0136)",
      "definition" : "The domain of possible values for either Yes or No used in fields containing binary answers generally user-specified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MailClaimParty",
      "display" : "Mail Claim Party (0137)",
      "definition" : "The domain of possible values for a party to which a claim should be mailed when claims are sent by mail.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EmployerInformationData",
      "display" : "Employer Information Data (0139)",
      "definition" : "The domain of possible values for the required employer information data for UB82 form locator 71.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MilitaryService",
      "display" : "Military Service (0140)",
      "definition" : "The domain of possible values for the military branch.  This field is defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MilitaryRank/grade",
      "display" : "Military Rank/Grade (0141)",
      "definition" : "The domain of possible values for the military rank/grade of the patient.\r\nAustralia: https://en.wikipedia.org/wiki/Australian_Defence_Force_ranks\r\nCanada: http://www.forces.gc.ca/en/honours-history-badges-insignia/rank.page\r\nUnited States: published in the Defense Travel Administrator's Manual, Appendix M: Military Rank/Civilian Pay Grade Abbreviations and Service Agency Names, http://www.defensetravel.dod.mil/Docs/Training/DTA_App_M.pdf",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MilitaryStatus",
      "display" : "Military Status (0142)",
      "definition" : "The domain of possible values for the military status of the patient.  This field is defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Non-coveredInsuranceCode",
      "display" : "Non-covered Insurance Code (0143)",
      "definition" : "The domain of possible values for the reason a service is not covered.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EligibilitySource",
      "display" : "Eligibility Source (0144)",
      "definition" : "The domain of possible values for the source of information about the insured's eligibility for benefits.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RoomType",
      "display" : "Room Type (0145)",
      "definition" : "The domain of possible values for the room type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AmountType",
      "display" : "Amount Type (0146)",
      "definition" : "The domain of possible values for amount quantity type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PolicyType",
      "display" : "Policy Type (0147)",
      "definition" : "The domain of possible values for the policy type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MoneyOrPercentageIndicator",
      "display" : "Money or Percentage Indicator (0148)",
      "definition" : "The domain of possible values for whether the amount is currency or a percentage.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DayType",
      "display" : "Day Type (0149)",
      "definition" : "The domain of possible values for whether the days are denied, pending or approved.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificationPatientType",
      "display" : "Certification Patient Type (0150)",
      "definition" : "The domain of possible values for the category or type of patient for which this certification is requested.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SecondOpinionStatus",
      "display" : "Second Opinion Status (0151)",
      "definition" : "The domain of possible values for the status of the second opinion.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SecondOpinionDocumentationReceived",
      "display" : "Second Opinion Documentation Received (0152)",
      "definition" : "The domain of possible values for if accompanying documentation has been received by the provider.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ValueCode",
      "display" : "Value Code (0153)",
      "definition" : "The domain of possible values for the National Uniform Billing Committee (NUBC) code.  In the US, the codes defined in code system 2.16.840.1.113883.6.301.6 nubc-ValueCode-cs are often used.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AcknowledgmentConditions",
      "display" : "Accept/Application Acknowledgment Conditions (0155)",
      "definition" : "The domain of possible values which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DietCodeSpecificationType",
      "display" : "Diet Code Specification Type (0159)",
      "definition" : "The domain of possible values for the type of diet.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TrayType",
      "display" : "Tray Type (0160)",
      "definition" : "The domain of possible values for the type of dietary tray.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AllowSubstitution",
      "display" : "Allow Substitution (0161)",
      "definition" : "The domain of possible values for whether substitutions are allowed and, if so, the type of substitutions allowed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2RouteOfAdministration",
      "display" : "Route of Administration (0162)",
      "definition" : "The domain of possible values for the route of administration.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BodySite",
      "display" : "Body Site (0163)",
      "definition" : "The domain of possible values that specify a body site from which a specimen is obtained.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdministrationDevice",
      "display" : "Administration Device (0164)",
      "definition" : "The domain of possible values for the mechanical device used to aid in the administration of the drug or other treatment.  Common examples are IV-sets of different types.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdministrationMethod",
      "display" : "Administration Method (0165)",
      "definition" : "The domain of possible values for the specific method requested for the administration of the drug or treatment to the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RxComponentType",
      "display" : "RX Component Type (0166)",
      "definition" : "The domain of possible values for the RX component type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubstitutionStatus",
      "display" : "Substitution Status (0167)",
      "definition" : "The domain of possible values for the substitution status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessingPriority",
      "display" : "Processing Priority (0168)",
      "definition" : "The domain of possible values for one or more available priorities for performing the observation or test.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReportingPriority",
      "display" : "Reporting Priority (0169)",
      "definition" : "The domain of possible values for the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DerivedSpecimen",
      "display" : "Derived Specimen (0170)",
      "definition" : "The domain of possible values for the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture).  The process also produces new \"specimens\" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Citizenship",
      "display" : "Citizenship (0171)",
      "definition" : "The domain of possible values for the information related to a person's country citizenship.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VeteransMilitaryStatus",
      "display" : "Veterans Military Status (0172)",
      "definition" : "The domain of possible values for the military status assigned to a veteran.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CoordinationOfBenefits",
      "display" : "Coordination of Benefits (0173)",
      "definition" : "The domain of possible values for whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NatureOfService_Test_Observation",
      "display" : "Nature of Service/Test/Observation (0174)",
      "definition" : "The domain of possible values for an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MasterFileIdentifierCode",
      "display" : "Master File Identifier Code (0175)",
      "definition" : "The domain of possible values which are represented by codes identifying HL7 Versions 2.x Master Files.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConfidentialityCode",
      "display" : "Confidentiality Code (0177)",
      "definition" : "The domain of possible values for the degree to which special confidentiality protection should be applied to the observation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ],
      "concept" : [
        {
          "code" : "x_BasicConfidentialityKind",
          "display" : "x_BasicConfidentialityKind",
          "definition" : "Domain of possible values for basic confidentiality, as used and defined in the CDA base R2 standard.",
          "property" : [
            {
              "code" : "source",
              "valueCode" : "cda"
            },
            {
              "code" : "openIssue",
              "valueString" : "Violates ConceptDomain naming rules, and appears to be an erroneous error using the value set name as the concept domain name."
            }
          ]
        }
      ]
    },
    {
      "code" : "FileLevelEventCode",
      "display" : "File Level Event Code (0178)",
      "definition" : "The domain of possible values for file-level events for master files.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ResponseLevel",
      "display" : "Response Level (0179)",
      "definition" : "The domain of possible values for application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MasterfileActionCode",
      "display" : "Record-level Event Code (0180)",
      "definition" : "The domain of possible values for a record-level event for a master file record.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MfnRecord-levelErrorReturn",
      "display" : "MFN Record-level Error Return (0181)",
      "definition" : "The domain of possible values for the status of the requested update.  Site-defined table, specific to each master file being updated via this transaction.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "StaffType",
      "display" : "Staff type (0182)",
      "definition" : "The domain of possible values for the staff person's sex.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Active/Inactive",
      "display" : "Active/Inactive (0183)",
      "definition" : "The domain of possible values for whether a person is currently a valid staff member.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Department",
      "display" : "Department (0184)",
      "definition" : "The domain of possible values for the institution department to which this person reports or belongs.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PreferredMethodOfContact",
      "display" : "Preferred Method of Contact (0185)",
      "definition" : "The domain of possible values for which of a group of multiple phone numbers is the preferred method of contact for this person.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PractitionerCategory",
      "display" : "Practitioner Category (0186)",
      "definition" : "The domain of possible values for the category of practitioner.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProviderBilling",
      "display" : "Provider Billing (0187)",
      "definition" : "The domain of possible values for how provider services are billed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EthnicGroup",
      "display" : "Ethnic Group (0189)",
      "definition" : "The domain of possible values further defining a patient's ancestry.  In the US, a current use is to use these codes to report ethnicity in line with US federal standards for Hispanic origin.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AddressType",
      "display" : "Address Type (0190)",
      "definition" : "The domain of possible values for types or kinds of addresses.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TypeOfReferencedData",
      "display" : "Type of Referenced Data (0191)",
      "definition" : "The domain of possible values declaring the general type of media data that is encoded.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AmountClass",
      "display" : "Amount Class (0193)",
      "definition" : "The domain of possible values for the amount quantity class.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NameType",
      "display" : "Name Type (0200)",
      "definition" : "The domain of possible values for types of names for persons.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TelecommunicationUseCode",
      "display" : "Telecommunication Use Code (0201)",
      "definition" : "The domain of possible values for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TelecommunicationEquipmentType",
      "display" : "Telecommunication Equipment Type (0202)",
      "definition" : "The domain of possible values  for specifying a type of telecommunication equipment.  Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IdentifierType",
      "display" : "Identifier Type (0203)",
      "definition" : "The domain of possible values for the type of identifier.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrganizationalNameType",
      "display" : "Organizational Name Type (0204)",
      "definition" : "The domain of possible values that specify the type of name for an organization i.e., legal name, display name.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PriceType",
      "display" : "Price Type (0205)",
      "definition" : "The domain of possible values to identify the intent for the dollar amount on a pricing transaction.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SegmentActionCode",
      "display" : "Segment Action Code (0206)",
      "definition" : "The domain of possible values for actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ProcessingMode",
      "display" : "Processing Mode (0207)",
      "definition" : "The domain of possible values that indicate an archival process or an initial load process.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "QueryResponseStatus",
      "display" : "Query Response Status (0208)",
      "definition" : "The domain of possible values defining precise response status concepts in support of HL7 Version 2 query messaging.  It is commonly used to indicate no data is found that matches the query parameters, but no error.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2RelationalOperator",
      "display" : "Relational Operator (0209)",
      "definition" : "The domain of possible values to define the relationship between HL7 segment field names identified in a query construct.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RelationalConjunction",
      "display" : "Relational Conjunction (0210)",
      "definition" : "The domain of possible values used with relational operator values to group more than one segment field name.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AlternateCharacterSets",
      "display" : "Alternate Character Sets (0211)",
      "definition" : "The domain of possible values that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Nationality",
      "display" : "Nationality (0212)",
      "definition" : "The domain of possible values that identify the nation or national grouping to which the person belongs.  This information may be different from a person’s citizenship in countries in which multiple nationalities are recognized (for example, Spain: Basque, Catalan, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PurgeStatusCode",
      "display" : "Purge Status Code (0213)",
      "definition" : "The domain of possible values that define the state of a visit relative to its place in a purge workflow.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecialProgramCode",
      "display" : "Special Program Code (0214)",
      "definition" : "The domain of possible values that record a health insurance program required for healthcare visit reimbursement.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PublicityCode",
      "display" : "Publicity Code (0215)",
      "definition" : "The domain of possible values for a level of publicity of information about a patient for a specific visit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientStatusCode",
      "display" : "Patient Status Code (0216)",
      "definition" : "The domain of possible values that define the state of a care episode for a patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VisitPriorityCode",
      "display" : "Visit Priority Code (0217)",
      "definition" : "The domain of possible values that define a relative level of urgency applied to a patient visit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientChargeAdjustment",
      "display" : "Patient Charge Adjustment (0218)",
      "definition" : "The domain of possible values that indicate which adjustments should be made to a guarantor’s charges.  For example, when a hospital agrees to adjust a guarantor’s charges to a sliding scale.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RecurringServiceCode",
      "display" : "Recurring Service Code (0219)",
      "definition" : "The domain of possible values that indicate whether a treatment is continuous.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2LivingArrangement",
      "display" : "Living Arrangement (0220)",
      "definition" : "The domain of possible values characterizing the situation that patient-associated parties live in at their residential address.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContactReason",
      "display" : "Contact Reason (0222)",
      "definition" : "The domain of possible values that indicate a reason for contacting a guarantor, for example, to phone a guarantor if payments are late.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LivingDependency",
      "display" : "Living Dependency (0223)",
      "definition" : "The domain of possible values identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransportArranged",
      "display" : "Transport Arranged (0224)",
      "definition" : "The domain of possible values defining whether patient transportation preparations are in place.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EscortRequired",
      "display" : "Escort Required (0225)",
      "definition" : "The domain of possible values indicating whether a patient must be accompanied while travelling to a diagnostic service department.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ManufacturersOfVaccines",
      "display" : "Manufacturers of Vaccines (code=MVX) (0227)",
      "definition" : "The domain of possible values for the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP.  The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosisClassification",
      "display" : "Diagnosis Classification (0228)",
      "definition" : "The domain of possible values that classify whether a patient visit can be related to a diagnosis.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgPayor",
      "display" : "DRG Payor (0229)",
      "definition" : "The domain of possible values that identify a Diagnostic Resource Group Payor.  US Realm.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcedureFunctionalType",
      "display" : "Procedure Functional Type (0230)",
      "definition" : "The domain of possible values that classify a procedure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "StudentStatus",
      "display" : "Student Status (0231)",
      "definition" : "The domain of possible values that designate whether a guarantor is a full or part time student.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InsuranceCompanyContactReason",
      "display" : "- Insurance Company Contact Reason (0232)",
      "definition" : "The domain of possible values that describe why an insurance company has been contacted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Non-concurCode_Description",
      "display" : "Non-Concur Code/Description (0233)",
      "definition" : "The domain of possible values that specify a non-concur code and description for a denied request, used in insurance claims processing.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReportTiming",
      "display" : "Report Timing (0234)",
      "definition" : "The domain of possible values to identify the time span of a report or the reason for a report sent to a regulatory agency.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReportSource",
      "display" : "Report Source (0235)",
      "definition" : "The domain of possible values to identify where a report sender learned about an event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventReportedTo",
      "display" : "Event Reported To (0236)",
      "definition" : "The domain of possible values to identify the type of entity to which the event has been reported.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventQualification",
      "display" : "Event Qualification (0237)",
      "definition" : "The domain of possible values to qualify an event related to a product experience.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventSeriousness",
      "display" : "Event Seriousness (0238)",
      "definition" : "The domain of possible values to a sender to designate an event as serious or significant.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventExpected",
      "display" : "Event Expected (0239)",
      "definition" : "The domain of possible values to communicate whether an event has been judged to be expected or unexpected.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventConsequence",
      "display" : "Event Consequence (0240)",
      "definition" : "The domain of possible values to describe the impact of an event on a patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientOutcome",
      "display" : "Patient Outcome (0241)",
      "definition" : "The domain of possible values to describe the overall state of a patient as a result of patient care.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrimaryObserversQualification",
      "display" : "Primary Observer's Qualification (0242)",
      "definition" : "The domain of possible values to provide a general description of the kind of health care professional who provided the primary observation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IdentityMayBeDivulged",
      "display" : "Identity May Be Divulged (0243)",
      "definition" : "The domain of possible values to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SingleUseDevice",
      "display" : "Single Use Device (0244)",
      "definition" : "The domain of possible values that indicate whether a product is designed for a single use.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProductProblem",
      "display" : "Product Problem (0245)",
      "definition" : "The domain of possible values that indicate if a product problem would exist if a product malfunction could lead to death or serious injury.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProductAvailableForInspection",
      "display" : "Product Available for Inspection (0246)",
      "definition" : "The domain of possible values that indicate that the product is available for analysis. No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "StatusOfEvaluation",
      "display" : "Status of Evaluation (0247)",
      "definition" : "The domain of possible values that describes the status of product evaluation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProductSource",
      "display" : "Product Source (0248)",
      "definition" : "The domain of possible values to describe the evaluation state of a product identified in an incident.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GenericProduct",
      "display" : "Generic Product (0249)",
      "definition" : "The domain of possible values that indicate whether the product used is a generic or a branded product. No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RelatednessAssessment",
      "display" : "Relatedness Assessment (0250)",
      "definition" : "The domain of possible values to provide an estimate of whether an issue with a  product was the cause of an event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ActionTakenInResponseToTheEvent",
      "display" : "Action Taken in Response to the Event (0251)",
      "definition" : "The domain of possible values to define the action taken as a result of an event related to a product issue.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CausalityObservations",
      "display" : "Causality Observations (0252)",
      "definition" : "The domain of possible values to record event observations regarding what may have caused a product related event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IndirectExposureMechanism",
      "display" : "Indirect Exposure Mechanism (0253)",
      "definition" : "The domain of possible values to identify the mechanism of product transmission when the product has not been directly applied to the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "KindOfQuantity",
      "display" : "Kind of Quantity (0254)",
      "definition" : "The domain of possible values that describe the underlying kind of property represented by an observation.  The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth.  These are discussed more fully in the LOINC Users' Manual.   They are derived from the approach described in 1995 edition of the IUPAC Silver Book.  These distinctions are used in IUPAC and LOINC standard codes.    The distinctions of true quantities in this table are based primarily on dimensional analyses. The table contains a number of \"families,\" those related to simple counts (number, number concentration, etc.), to mass (mass, mass concentration, etc.), to enzyme activity (catalytic content, catalytic concentration, etc.), and molar or equivalents (substance content, substance concentration).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DurationCategories",
      "display" : "Duration Categories (0255)",
      "definition" : "The domain of possible values that classify an observation definition as intended to measure a patient's state at a point in time.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TimeDelayPostChallenge",
      "display" : "Time Delay Post Challenge (0256)",
      "definition" : "The domain of possible values to classify an observation definition as being a component of a challenge test.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NatureOfChallenge",
      "display" : "Nature of Challenge (0257)",
      "definition" : "The domain of possible values to further describe an observation definition that is characterized as a challenge observation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RelationshipModifier",
      "display" : "Relationship Modifier (0258)",
      "definition" : "The domain of possible values to an observation definition to describe the subject of an observation in relation to a patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Modality",
      "display" : "Modality (0259)",
      "definition" : "The domain of possible values that define the imaging apparatus expected to be used to acquire an observation.  This table has been removed from the standard as of 2.7 in favor of table 0910.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientLocationType",
      "display" : "Patient Location Type (0260)",
      "definition" : "The domain of possible values that identify the kind of location described in the location definition.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationEquipment",
      "display" : "Location Equipment (0261)",
      "definition" : "The domain of possible values that identify the equipment available in a location definition identified as a room or bed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrivacyLevel",
      "display" : "Privacy Level (0262)",
      "definition" : "The domain of possible values that identify the level of privacy a patient will be afforded when assigned to this location definition.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LevelOfCare",
      "display" : "Level of Care (0263)",
      "definition" : "The domain of possible values that identify the level of care a patient may be afforded when assigned to this location definition.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationDepartment",
      "display" : "Location Department (0264)",
      "definition" : "The domain of possible values used to specify the institution’s department to which a location belongs, or its cost center.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecialtyType",
      "display" : "Specialty Type (0265)",
      "definition" : "The domain of possible values that identify the specialty of the care professional who is supported when using this location definition.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DaysOfTheWeek",
      "display" : "Days of the Week (0267)",
      "definition" : "The domain of possible values to identify the day(s) of the week when a location may be scheduled for appointments.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Override",
      "display" : "Override (0268)",
      "definition" : "The domain of possible values that define whether a Charge Description Master description may be overridden or if it must be overridden.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ChargeOnIndicator",
      "display" : "Charge On Indicator (0269)",
      "definition" : "The domain of possible values that define the event upon which a charge should be generated.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2DocumentType",
      "display" : "Document Type (0270)",
      "definition" : "The domain of possible values that identify the kind of patient document.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DocumentCompletionStatus",
      "display" : "Document Completion Status (0271)",
      "definition" : "The domain of possible values to record the state of a document in a workflow.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DocumentConfidentialityStatus",
      "display" : "Document Confidentiality Status (0272)",
      "definition" : "The domain of possible values that specify the degree to which special confidentiality protection should be applied to  information.  The assignment of data elements to these categories is left to the discretion of the healthcare organization.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DocumentAvailabilityStatus",
      "display" : "Document Availability Status (0273)",
      "definition" : "The domain of possible values to define whether a patient document is appropriate or available for use in patient care.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DocumentStorageStatus",
      "display" : "Document Storage Status (0275)",
      "definition" : "The domain of possible values to describe the availability of a document in relation to the type of storage.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AppointmentReasonCodes",
      "display" : "Appointment reason codes (0276)",
      "definition" : "The domain of possible values that describe the kind of appointment or the reason why an appointment has been scheduled.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AppointmentTypeCodes",
      "display" : "Appointment Type Codes (0277)",
      "definition" : "The domain of possible values that an appointment request to describe the kind of appointment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "FillerStatusCodes",
      "display" : "Filler status codes (0278)",
      "definition" : "The domain of possible values that describe an appointment status from the perspective of the entity assigned to fulfill the appointment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AllowSubstitutionCodes",
      "display" : "Allow Substitution Codes (0279)",
      "definition" : "The domain of possible values that indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralPriority",
      "display" : "Referral Priority (0280)",
      "definition" : "The domain of possible values that designate the urgency of a  referral.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralType",
      "display" : "Referral Type (0281)",
      "definition" : "The domain of possible values that identify the general category of healthcare professional desired to satisfy a referral.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralDisposition",
      "display" : "Referral Disposition (0282)",
      "definition" : "The domain of possible values that identify the expected response from the healthcare professional receiving a referral.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralStatus",
      "display" : "Referral Status (0283)",
      "definition" : "The domain of possible values that define the state of a  referral.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralCategory",
      "display" : "Referral Category (0284)",
      "definition" : "The domain of possible values that describe the patient care setting where a referral should take place.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InsuranceCompanyIdCodes",
      "display" : "Insurance Company ID Codes (0285)",
      "definition" : "The domain of possible values for the identification of the insurance company or other entity that administers the authorizing coverage plan.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralProviderRole",
      "display" : "Provider Role (0286)",
      "definition" : "The domain of possible values that define the relationship between a referral recipient and a patient or between a referral initiator and a patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Problem_GoalActionCode",
      "display" : "Problem/Goal Action Code (0287)",
      "definition" : "The domain of possible values to Patient Care for the intent of a problem or goal.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CensusTract",
      "display" : "Census Tract (0288)",
      "definition" : "The domain of possible values for the census tract in which the specified address resides.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "County/Parish",
      "display" : "County/Parish (0289)",
      "definition" : "The domain of possible values for the county or parish in which the specified address resides.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubtypeOfReferencedData",
      "display" : "Subtype of Referenced Data (0291)",
      "definition" : "The domain of possible values for a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VaccinesAdministered",
      "display" : "Vaccines Administered (0292)",
      "definition" : "The domain of possible values for the administered vaccines.   The values are maintained by the US Centers of Disease Control..  The code system is maintained by the CDC, and may be found at URL;  https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.292\r\nThe value set is maintained by the CDC and may be found at URL: https://phinvads.cdc.gov/vads/ViewValueSet.action?id=ABDEE003-77C3-48E7-B941-EBF92B6B81FC",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BillingCategory",
      "display" : "Billing Category (0293)",
      "definition" : "The domain of possible values for the billing category codes for any classification systems needed, for example, general ledger codes and UB92 categories.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TimeSelectionCriteriaParameterClassCodes",
      "display" : "Time Selection Criteria Parameter Class Codes (0294)",
      "definition" : "The domain of possible values that describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Handicap",
      "display" : "Handicap (0295)",
      "definition" : "The domain of possible values for an associated party's disability.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrimaryLanguage",
      "display" : "Primary Language (0296)",
      "definition" : "The domain of possible values for the patient's primary language.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CnIdSource",
      "display" : "CN ID Source (0297)",
      "definition" : "The domain of possible values for the CN identification source.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CpRangeType",
      "display" : "CP Range Type (0298)",
      "definition" : "The domain of possible values that specify whether a composite price range is experssed as a flat rate or a percentage.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Encoding",
      "display" : "Encoding (0299)",
      "definition" : "The domain of possible values identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters.  These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NamespaceId",
      "display" : "Namespace ID (0300)",
      "definition" : "The domain of possible values for the unique name of the system that stores the data.   It was previously named the Application ID.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "UniversalIdType",
      "display" : "Universal ID Type (0301)",
      "definition" : "The domain of possible values for the type of UID (Universal Identifier).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PointOfCare",
      "display" : "Point of Care (0302)",
      "definition" : "The domain of possible values for the point where patient care is administered.  It is conditional on Person Location Type (e.g., nursing unit or department or clinic).   No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Room",
      "display" : "Room (0303)",
      "definition" : "The domain of possible values for the patient's room.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Bed",
      "display" : "Bed (0304)",
      "definition" : "The domain of possible values for the patient's bed.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PersonLocationType",
      "display" : "Person Location Type (0305)",
      "definition" : "The domain of possible values for the categorization of the person's location.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationStatus",
      "display" : "Location Status (0306)",
      "definition" : "The domain of possible values for the status or availability of the location, such as the bed status.   No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Building",
      "display" : "Building (0307)",
      "definition" : "The domain of possible values for the building where the person is located.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Floor",
      "display" : "Floor (0308)",
      "definition" : "The domain of possible values for the floor where the person is located.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CoverageType",
      "display" : "Coverage Type (0309)",
      "definition" : "The domain of possible values for the type of insurance coverage or what types of services are covered for the purposes of a billing system.  For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "JobStatus",
      "display" : "Job Status (0311)",
      "definition" : "The domain of possible values for a next of kin/associated party's job status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PolicyScope",
      "display" : "Policy Scope (0312)",
      "definition" : "The domain of possible values for the extent of insurance coverage for a participating member (e.g., single, family, etc.).  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PolicySource",
      "display" : "Policy Source (0313)",
      "definition" : "The domain of possible values for how an insurance policy is established.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LivingWillCode",
      "display" : "Living Will Code (0315)",
      "definition" : "The domain of possible values for whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility.  If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrganDonorCode",
      "display" : "Organ Donor Code (0316)",
      "definition" : "The domain of possible values for whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Annotations",
      "display" : "Annotations (0317)",
      "definition" : "The domain of possible values for the coded entry associated with a given point in time during the waveform recording.  Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DepartmentCostCenter",
      "display" : "Department Cost Center (0319)",
      "definition" : "The domain of possible values for the accounting code that identifies the department in order to charge for the item.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ItemNaturalAccountCode",
      "display" : "Item Natural Account Code (0320)",
      "definition" : "The domain of possible values identifying an item in order to charge for the item.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DispenseMethod",
      "display" : "Dispense Method (0321)",
      "definition" : "The domain of possible values for the method by which treatment is dispensed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CompletionStatus",
      "display" : "Completion Status (0322)",
      "definition" : "The domain of possible values for the status of the treatment administration event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationCharacteristicId",
      "display" : "Location Characteristic ID (0324)",
      "definition" : "The domain of possible values for an identifier code to show which characteristic is being communicated with the segment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationRelationshipId",
      "display" : "Location Relationship ID (0325)",
      "definition" : "The domain of possible values for an identifier code to show which relationship is being communicated with the segment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VisitIndicator",
      "display" : "Visit Indicator (0326)",
      "definition" : "The domain of possible values for the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to indicate that the data sent in the message are at the visit level.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "JobCode",
      "display" : "Job Code (0327)",
      "definition" : "The domain of possible values that specify a person's job code.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EmployeeClassification",
      "display" : "Employee Classification (0328)",
      "definition" : "The domain of possible values that specify a person's employee classification.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "QuantityMethod",
      "display" : "Quantity Method (0329)",
      "definition" : "The domain of possible values to specify the method by which the quantity distributed is measured.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MarketingBasis",
      "display" : "Marketing Basis (0330)",
      "definition" : "The domain of possible values to specify the basis for marketing approval.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "FacilityType",
      "display" : "Facility Type (0331)",
      "definition" : "The domain of possible values to specify the type of facility.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SourceType",
      "display" : "Source Type (0332)",
      "definition" : "The domain of possible values to indicate (in certain systems) whether a lower level source identifier is an initiate or accept type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DriversLicenseIssuingAuthority",
      "display" : "Driver's License Issuing Authority (0333)",
      "definition" : "The domain of possible values for the driver's license issuing authority.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DisabledPersonCode",
      "display" : "Disabled Person Code (0334)",
      "definition" : "The domain of possible values that specify to which person the disability information relates in the message.  For example, if the value is PT, the disability information relates to the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RepeatPattern",
      "display" : "Repeat Pattern (0335)",
      "definition" : "The domain of possible values that specify the interval between repeated services. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns illustrating the syntax used to construct expressions using the codes and other modifiers.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralReason",
      "display" : "Referral Reason (0336)",
      "definition" : "The domain of possible values that specify the reason for which the referral will take place.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificationStatus",
      "display" : "Certification Status (0337)",
      "definition" : "The domain of possible values to specify the status of the practitioner's speciality certification.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PractitionerIdNumberType",
      "display" : "Practitioner ID Number Type (0338)",
      "definition" : "The domain of possible values for the type of number used for the practitioner identification.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdvancedBeneficiaryNoticeCode",
      "display" : "Advanced Beneficiary Notice Code (0339)",
      "definition" : "The domain of possible values for the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcedureCodeModifier",
      "display" : "Procedure Code Modifier (0340)",
      "definition" : "The domain of possible values that specify a procedure code modifier to a procedure code.  Procedure code modifiers are defined by regulatory agencies such as CMS and the AMA.  Multiple modifiers may be reported.  The modifiers are sequenced in priority according to user entry.  This is a requirement of the UB and the 1500 claim forms.  Multiple modifiers are allowed and the order placed on the form affects reimbursement.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GuarantorCreditRatingCode",
      "display" : "Guarantor Credit Rating Code (0341)",
      "definition" : "The domain of possible values that specify a guarantor's credit rating.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MilitaryRecipient",
      "display" : "Military Recipient (0342)",
      "definition" : "The domain of possible values that specify a designation as a military recipient.  This field is defined by CMS or other regulatory agencies.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MilitaryHandicappedProgramCode",
      "display" : "Military Handicapped Program Code (0343)",
      "definition" : "The domain of possible values that specify a military program for the handicapped in which a patient is enrolled.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Patient'sRelationshipToInsured",
      "display" : "Patient's Relationship to Insured (0344)",
      "definition" : "The domain of possible values that specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AppealReason",
      "display" : "Appeal Reason (0345)",
      "definition" : "The domain of possible values that specify  reasons an appeal was made on a non-concur for certification.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificationAgency",
      "display" : "Certification Agency (0346)",
      "definition" : "The domain of possible values that specify a certification agency.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CountrySubdivision",
      "display" : "State/Province (0347)",
      "definition" : "The domain of possible values for the names of the principal country subdivisions (e.g., provinces or states).  The values in the table are country specific.  For example, in the US, the Federal Information Processing Standard (FIPS) alpha codes may be used by local agreement.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OccurrenceCode",
      "display" : "Occurrence Code (0350)",
      "definition" : "The domain of possible values that specify the event or occurrence relating to a bill that may affect payer processing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OccurrenceSpan",
      "display" : "Occurrence Span (0351)",
      "definition" : "The domain of possible values that identify an event that relates to the payment of a claim.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CweStatuses",
      "display" : "CWE statuses (0353)",
      "definition" : "The domain of possible values that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended).  These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MessageStructure",
      "display" : "Message Structure (0354)",
      "definition" : "The domain of possible values of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrimaryKeyValueType",
      "display" : "Primary Key Value Type (0355)",
      "definition" : "The domain of possible values to specify the type for the master file record identifier.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AlternateCharacterSetHandlingScheme",
      "display" : "Alternate Character Set Handling Scheme (0356)",
      "definition" : "The domain of possible values that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MessageErrorConditionCodes",
      "display" : "Message Error Condition Codes (0357)",
      "definition" : "The domain of possible values for the HL7 (communications) error code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PractitionerGroup",
      "display" : "Practitioner Group (0358)",
      "definition" : "The domain of possible values for the name and/or code of a group of practitioners to which this practitioner belongs.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DiagnosisPriority",
      "display" : "Diagnosis Priority (0359)",
      "definition" : "The domain of possible values that identify the significance or priority of the diagnosis code.  Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Degree/License/Certificate",
      "display" : "Degree/License/Certificate (0360)",
      "definition" : "The domain of possible values for an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Application",
      "display" : "Application (0361)",
      "definition" : "The domain of possible values that identify a sending application among all other applications within the network enterprise.  The network enterprise consists of all those applications that participate in the exchange of HL7 messages within the enterprise.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Facility",
      "display" : "Facility (0362)",
      "definition" : "The domain of possible values for the site-specific name for the facility used by this application.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AssigningAuthority",
      "display" : "Assigning Authority (0363)",
      "definition" : "The domain of possible values for a unique name of the system (or organization or agency or department) that creates the data.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CommentType",
      "display" : "Comment Type (0364)",
      "definition" : "The domain of possible values that identify the type of comment text being sent in the specific comment record.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EquipmentState",
      "display" : "Equipment State (0365)",
      "definition" : "The domain of possible values that identify the status the equipment was in at the time the transaction was initiated.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Local_RemoteControlState",
      "display" : "Local/Remote Control State (0366)",
      "definition" : "The domain of possible values that identify the current state of control associated with the equipment.   Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AlertLevel",
      "display" : "Alert Level (0367)",
      "definition" : "The domain of possible values that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RemoteControlCommand",
      "display" : "Remote Control Command (0368)",
      "definition" : "The domain of possible values that identify the comment the component is to initiate.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenRole",
      "display" : "Specimen Role (0369)",
      "definition" : "The domain of possible values that identify the role of a sample.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerStatus",
      "display" : "Container Status (0370)",
      "definition" : "The domain of possible values that identify the status of the unique container in which the specimen resides at the time the transaction was initiated.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Additive/Preservative",
      "display" : "Additive/Preservative (0371)",
      "definition" : "The domain of possible values for any additive introduced to the specimen before or at the time of collection.  These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenComponent",
      "display" : "Specimen Component (0372)",
      "definition" : "The domain of possible values that identify the specimen component, e.g., supernatant, sediment, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Treatment",
      "display" : "Treatment (0373)",
      "definition" : "The domain of possible values that identify the specimen treatment performed during lab processing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SystemInducedContaminants",
      "display" : "System Induced Contaminants (0374)",
      "definition" : "The domain of possible values that identify the specimen contaminant identifier associated with the specimen in the container.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ArtificialBlood",
      "display" : "Artificial Blood (0375)",
      "definition" : "The domain of possible values that identify the artificial blood identifier associated with the specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecialHandlingCode",
      "display" : "Special Handling Code (0376)",
      "definition" : "The domain of possible values describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OtherEnvironmentalFactors",
      "display" : "Other Environmental Factors (0377)",
      "definition" : "The domain of possible values that identify the other environmental factors associated with the specimen in a specific container, e.g., atmospheric exposure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CarrierType",
      "display" : "Carrier Type (0378)",
      "definition" : "The domain of possible values that identify a type of carrier.  Because the geometry can be different, the carrier type should, if possible, express the number of positions in the carrier.  The definition assumes hierarchical nesting using the following phrases: container is located in a carrier, carrier is located in a tray.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerTrayType",
      "display" : "Tray Type (0379)",
      "definition" : "The domain of possible values that identify a type of tray.  Because the geometry can be different, the tray type should, if possible, express the number of positions in the tray.  The definition assumes hierarchical nesting using the following phrases: container is located in a carrier, carrier is located in a tray.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SeparatorType",
      "display" : "Separator Type (0380)",
      "definition" : "The domain of possible values that identify a type of separator being used (e.g., a gel separator in a container - not to be confused with the communication separators).  It is recommended the first table entry be \"NO\" meaning \"No Separator\".  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CapType",
      "display" : "Cap Type (0381)",
      "definition" : "The domain of possible values that identify a type of cap that is to be used with a container for decapping, piercing or other mechanisms.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrugInterference",
      "display" : "Drug Interference (0382)",
      "definition" : "The domain of possible values that identify a drug interference  associated with a specimen.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubstanceStatus",
      "display" : "Substance Status (0383)",
      "definition" : "The domain of possible values identifying the status of the inventoried item.  The status indicates the current status of the substance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubstanceType",
      "display" : "Substance Type (0384)",
      "definition" : "The domain of possible values identifying the type of substance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ManufacturerIdentifier",
      "display" : "Manufacturer Identifier (0385)",
      "definition" : "The domain of possible values that identify a manufacturer of a substance.  Relevant external code systems may be used, e.g., HIBCC Manufacturers Labeler ID Code (LIC), UPC, NDC, etc.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SupplierIdentifier",
      "display" : "Supplier Identifier (0386)",
      "definition" : "The domain of possible values that identify a supplier of a substance.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CommandResponse",
      "display" : "Command Response (0387)",
      "definition" : "The domain of possible values identifying the response of the previously issued command.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessingType",
      "display" : "Processing Type (0388)",
      "definition" : "The domain of possible values identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AnalyteRepeatStatus",
      "display" : "Analyte Repeat Status (0389)",
      "definition" : "The domain of possible values identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex).  The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as \"Panic\" or mechanical failures).  Repeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits).  Reflex test — this test is performed as the consequence of rules triggered based on other test result(s).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SegmentGroup",
      "display" : "Segment Group (0391)",
      "definition" : "The domain of possible values for the optional segment groups which are to be included in a response.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MatchReason",
      "display" : "Match Reason (0392)",
      "definition" : "The domain of possible values identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels.  It provides a method for passing a descriptive indication of the reason a particular record was found.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MatchAlgorithms",
      "display" : "Match Algorithms (0393)",
      "definition" : "The domain of possible values identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ResponseModality",
      "display" : "Response Modality (0394)",
      "definition" : "The domain of possible values identifying the timing and grouping of the response message(s).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ModifyIndicator",
      "display" : "Modify Indicator (0395)",
      "definition" : "The domain of possible values identifying whether the subscription is new or is being modified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CodingSystem",
      "display" : "Coding System (0396)",
      "definition" : "The domain of possible values of specifying the coding system.  This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2Sequencing",
      "display" : "Sequencing (0397)",
      "definition" : "The domain of possible values identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContinuationStyleCode",
      "display" : "Continuation Style Code (0398)",
      "definition" : "The domain of possible values identifying whether it is a fragmented message or part of an interactive continuation message.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CountryCode",
      "display" : "Country Code (0399)",
      "definition" : "The domain of possible values that identifies a country of origin for a message.  It will be used primarily to specify default elements, such as currency denominations. The values to be used are those of ISO 3166. The ISO 3166 table has three separate forms of the country code: HL7 specifies that the 3-character (alphabetic) form be used for the country code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GovernmentReimbursementProgram",
      "display" : "Government Reimbursement Program (0401)",
      "definition" : "The domain of possible values for codes that indicate an agency that the practitioner is authorized to bill for medical services.  Existing codes only for use in the United States.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SchoolType",
      "display" : "School Type (0402)",
      "definition" : "The domain of possible values for a categorization of an academic institution that grants a degree to a Staff Member.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LanguageAbility",
      "display" : "Language Ability (0403)",
      "definition" : "The domain of possible values for codes that indicate the ability that a Staff Member possesses with respect to the language.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LanguageProficiency",
      "display" : "Language Proficiency (0404)",
      "definition" : "The domain of possible values which specify the level of knowledge a person possesses with respect to a language ability identified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrganizationUnit",
      "display" : "Organization Unit (0405)",
      "definition" : "The domain of possible values which specify the hierarchical components of an organization unit, as defined by the institution.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ParticipantOrganizationUnitType",
      "display" : "Participant Organization Unit Type (0406)",
      "definition" : "The domain of possible values that specify the environment in which the provider acts in the role associated with the provider type, and inludes codes for venues outside of formal organized healthcare settings, such as Home. The provider environment is not the specialty for the provider.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ApplicationChangeType",
      "display" : "Application Change Type (0409)",
      "definition" : "The domain of possible values that specify a type of change being requested (if NMR query) or announced (if NMD unsolicited update).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SupplementalServiceInformationValues",
      "display" : "Supplemental Service Information Values (0411)",
      "definition" : "The domain of possible values that specify supplemental service information sent between a placer system and a filler system for the universal procedure code reported in OBR-4 Universal Service ID. This specifies ordering information detail that is not available in other specific tables for fields in the OBR segment.  These might be details such as whether a study is to be done on the right or left, for example, where the study is of the arm and the order master file does not distinguish right from left, or whether a study is to be done with or without contrast (when the order master file does not make such distinctions).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CategoryIdentifier",
      "display" : "Category Identifier (0412)",
      "definition" : "The domain of possible values that specify a category name (term given to a group of service items for the purpose of classification). Examples: Laboratory, Pharmacy, Diagnostic Imaging, etc.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentIdentifier",
      "display" : "Consent Identifier (0413)",
      "definition" : "The domain of possible values that provide an identifier for the consent specified for a service item.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "UnitsOfTime",
      "display" : "Units of Time (0414)",
      "definition" : "The domain of possible values that specify a unit of time.  No suggested values.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransferType",
      "display" : "Transfer Type (0415)",
      "definition" : "The domain of possible values that specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG's), for example, exempt or non-exempt.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcedureDrgType",
      "display" : "Procedure DRG Type (0416)",
      "definition" : "The domain of possible values that specify a procedure's priority ranking relative to its DRG.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TissueTypeCode",
      "display" : "Tissue Type Code (0417)",
      "definition" : "The domain of possible values that specify the type of tissue removed from a patient during a procedure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcedurePriority",
      "display" : "Procedure Priority (0418)",
      "definition" : "The domain of possible values specifying a number that identifies the significance or priority of the procedure code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SeverityOfIllnessCode",
      "display" : "Severity of Illness Code (0421)",
      "definition" : "The domain of possible values specifying the severity ranking of a patient's illness.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TriageCode",
      "display" : "Triage Code (0422)",
      "definition" : "The domain of possible values specifying a patient's prioritization within the context of this abstract.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CaseCategoryCode",
      "display" : "Case Category Code (0423)",
      "definition" : "The domain of possible values specifying the reason a non-urgent patient presents to the emergency room for treatment instead of a clinic or physican office.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GestationCategoryCode",
      "display" : "Gestation Category Code (0424)",
      "definition" : "The domain of possible values specifying the status of the birth in relation to the gestation",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NewbornCode",
      "display" : "Newborn Code (0425)",
      "definition" : "The domain of possible values specifying whether the baby was born in or out of the facility.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BloodProductCode",
      "display" : "Blood Product Code (0426)",
      "definition" : "The domain of possible values specifying the blood product code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RiskManagementIncidentCode",
      "display" : "Risk Management Incident Code (0427)",
      "definition" : "The domain of possible values specifying the incident that occurred during a patient's stay.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IncidentTypeCode",
      "display" : "Incident Type Code (0428)",
      "definition" : "The domain of possible values specifying a classification of the incident type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProductionClassCode",
      "display" : "Production Class Code (0429)",
      "definition" : "The domain of possible values specifying the code and/or text indicating the primary use for which the living subject was bred or grown.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ModeOfArrivalCode",
      "display" : "Mode of Arrival Code (0430)",
      "definition" : "The domain of possible values specifying how the patient was brought to the healthcare facility.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RecreationalDrugUseCode",
      "display" : "Recreational Drug Use Code (0431)",
      "definition" : "The domain of possible values specifying what recreational drugs the patient uses.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdmissionLevelOfCareCode",
      "display" : "Admission Level of Care Code (0432)",
      "definition" : "The domain of possible values specifying the acuity level assigned to the patient at the time of admission.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrecautionCode",
      "display" : "Precaution Code (0433)",
      "definition" : "The domain of possible values specifying non-clincal precautions that need to be taken with the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientConditionCode",
      "display" : "Patient Condition Code (0434)",
      "definition" : "The domain of possible values specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdvanceDirectiveCode",
      "display" : "Advance Directive Code (0435)",
      "definition" : "The domain of possible values specifying the patient's instructions to the healthcare facility.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SensitivityToCausativeAgentCode",
      "display" : "Sensitivity to Causative Agent Code (0436)",
      "definition" : "The domain of possible values specifying the reason the patient should not be exposed to a substance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AlertDeviceCode",
      "display" : "Alert Device Code (0437)",
      "definition" : "The domain of possible values specifying any type of allergy alert device the patient may be carrying or wearing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AllergyClinicalStatus",
      "display" : "Allergy Clinical Status (0438)",
      "definition" : "The domain of possible values specifying the verification status for the allergy.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DataTypes",
      "display" : "Data Types (0440)",
      "definition" : "The domain of possible values specifying the data type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ImmunizationRegistryStatus",
      "display" : "Immunization Registry Status (0441)",
      "definition" : "The domain of possible values for the immunization registry status of the patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationServiceCode",
      "display" : "Location Service Code (0442)",
      "definition" : "The domain of possible values specifying the types of services provided by the location.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProviderRole",
      "display" : "Provider Role (0443)",
      "definition" : "The domain of possible values for the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NameAssemblyOrder",
      "display" : "Name Assembly Order (0444)",
      "definition" : "The domain of possible values specifying the preferred display order of the components of this person name.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IdentityReliabilityCode",
      "display" : "Identity Reliability Code (0445)",
      "definition" : "The domain of possible values for the reliability of patient/person identifying data transmitted via a transaction.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpeciesCode",
      "display" : "Species Code (0446)",
      "definition" : "The domain of possible values for the species of living organism.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BreedCode",
      "display" : "Breed Code (0447)",
      "definition" : "The domain of possible values for the specific breed of animal.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NameContext",
      "display" : "Name Context (0448)",
      "definition" : "The domain of possible values specifying the context in which a name is used.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EQPEventType",
      "display" : "Event Type (0450)",
      "definition" : "The domain of possible values specifying the type of event of the message.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubstanceIdentifier",
      "display" : "Substance Identifier (0451)",
      "definition" : "The domain of possible values specifying the substance that is in inventory.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "HealthCareProviderTypeCode",
      "display" : "Health Care Provider Type Code (0452)",
      "definition" : "The domain of possible values for the major grouping of the service or occupation of a practitioner at a specific organization unit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "HealthCareProviderClassification",
      "display" : "Health Care Provider Classification (0453)",
      "definition" : "The domain of possible values for the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "HealthCareProviderAreaOfSpecialization",
      "display" : "Health Care Provider Area of Specialization (0454)",
      "definition" : "The domain of possible values for the segment of the population that a health care provider chooses to service, a specific medical service, a specialization in treating a specific disease, or any other descriptive characteristic about a provider’s practice relating to the services rendered of a practitioner at a specific organization unit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TypeOfBillCode",
      "display" : "Type of Bill Code (0455)",
      "definition" : "The domain of possible values specifying the specific type of bill with digit 1 showing type of facility, digit 2 showing bill classification and digit 3 showing frequency.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RevenueCode",
      "display" : "Revenue code (0456)",
      "definition" : "The domain of possible values specifying a service line revenue code.  These are claim codes indicating the identifying number for the product or service provided.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OverallClaimDispositionCode",
      "display" : "Overall Claim Disposition Code (0457)",
      "definition" : "The domain of possible values specifying the final status of the claim.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OceEditCode",
      "display" : "OCE Edit Code (0458)",
      "definition" : "The domain of possible values that specify the edits that result from processing the HCPCS/CPT procedures for a record after evaluating all the codes, revenue codes, and modifiers.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReimbursementActionCode",
      "display" : "Reimbursement Action Code (0459)",
      "definition" : "The domain of possible values for the action to be taken during reimbursement calculations.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DenialOrRejectionCode",
      "display" : "Denial or Rejection Code (0460)",
      "definition" : "The domain of possible values for the OCE status of the line item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LicenseNumber",
      "display" : "License Number (0461)",
      "definition" : "The domain of possible values for the license number for the facility.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LocationCostCenter",
      "display" : "Location Cost Center (0462)",
      "definition" : "The domain of possible values for the cost center to which this location belongs.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InventoryNumber",
      "display" : "Inventory Number (0463)",
      "definition" : "The domain of possible values specifying an identifying stock number, if any, which might be used, for example, as a cross reference for materials management.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "FacilityId",
      "display" : "Facility ID (0464)",
      "definition" : "The domain of possible values for the facility of the institution for which a specified price is valid.  For use when needing multi-facility pricing.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Name_AddressRepresentation",
      "display" : "Name/Address Representation (0465)",
      "definition" : "The domain of possible values for an indication of the representation provided by the data item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AmbulatoryPaymentClassificationCode",
      "display" : "Ambulatory Payment Classification Code (0466)",
      "definition" : "The domain of possible values for the derived Ambulatory Payment Classification (APC) code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ModifierEditCode",
      "display" : "Modifier Edit Code (0467)",
      "definition" : "The domain of possible values that specify the edits of the modifiers for each line or HCPCS/CPT.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PaymentAdjustmentCode",
      "display" : "Payment Adjustment Code (0468)",
      "definition" : "The domain of possible values for any payment adjustment due to drugs or medical devices.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PackagingStatusCode",
      "display" : "Packaging Status Code (0469)",
      "definition" : "The domain of possible values for the packaging status of the service.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReimbursementTypeCode",
      "display" : "Reimbursement Type Code (0470)",
      "definition" : "The domain of possible values for the fee schedule reimbursement type applied to a line item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "QueryName",
      "display" : "Query Name (0471)",
      "definition" : "The domain of possible values for the name of a query.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TqConjunctionId",
      "display" : "TQ Conjunction ID (0472)",
      "definition" : "The domain of possible values for that a second timing specification is to follow using the repeat delimiter.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ServiceFormularyStatus",
      "display" : "Formulary Status (0473)",
      "definition" : "The domain of possible values for whether or not the service (pharmaceutical) is in the formulary.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PractitionerOrganizationUnitType",
      "display" : "Practitioner Organization Unit Type (0474)",
      "definition" : "The domain of possible values for the classification of the organization unit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ChargeTypeReason",
      "display" : "Charge Type Reason (0475)",
      "definition" : "The domain of possible values for the choice of, and providing the clinical rationale for, a selected charge type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2MedicallyNecessaryDuplicateProcedureReason",
      "display" : "Medically Necessary Duplicate Procedure Reason (0476)",
      "definition" : "The domain of possible values specifying the reason the procedure code found in OBR-44 Procedure Code is a duplicate of one ordered/charged previously for the same patient within the same date of service and has been determined to be medically necessary.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ControlledSubstanceSchedule",
      "display" : "Controlled Substance Schedule (0477)",
      "definition" : "The domain of possible values for the class of the drug or other substance if its usage is controlled by legislation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SubstanceFormularyStatus",
      "display" : "Formulary Status (0478)",
      "definition" : "The domain of possible values for whether or not the pharmaceutical substance is part of the local formulary.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PharmaceuticalSubstances",
      "display" : "Pharmaceutical Substances (0479)",
      "definition" : "The domain of possible values for a medical substance or treatment that has been ordered to be given to a patient, as encoded by a pharmacy or treatment supplier.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PharmacyOrderTypes",
      "display" : "Pharmacy Order Types (0480)",
      "definition" : "The domain of possible values for the general category of pharmacy order which may be used to determine the processing path the order will take.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrderType",
      "display" : "Order Type (0482)",
      "definition" : "The domain of possible values for whether the order is to be executed in an inpatient setting or an outpatient setting.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AuthorizationMode",
      "display" : "Authorization Mode (0483)",
      "definition" : "The domain of possible values of forms of authorization a recorder may receive from the responsible practitioner to create or change an order.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DispenseType",
      "display" : "Dispense Type (0484)",
      "definition" : "The domain of possible values for the type of dispensing event that occurred.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ExtendedPriorityCodes",
      "display" : "Extended Priority Codes (0485)",
      "definition" : "The domain of possible values describing the urgency of a request carried in an order.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenType",
      "display" : "Specimen Type (0487)",
      "definition" : "The domain of possible values that describe the precise nature of an entity that may be used as the source material for an observation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenCollectionMethod",
      "display" : "Specimen Collection Method (0488)",
      "definition" : "The domain of possible values for the specimen collection method.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RiskCodes",
      "display" : "Risk Codes (0489)",
      "definition" : "The domain of possible values for any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenRejectReason",
      "display" : "Specimen Reject Reason (0490)",
      "definition" : "The domain of possible values for the reasons a specimen may be rejected for a specified observation/result/analysis.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenQuality",
      "display" : "Specimen Quality (0491)",
      "definition" : "The domain of possible values for the degree or grade of excellence of the specimen at receipt.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenAppropriateness",
      "display" : "Specimen Appropriateness (0492)",
      "definition" : "The domain of possible values for the suitability of the specimen for the particular planned use as determined by the filler.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenCondition",
      "display" : "Specimen Condition (0493)",
      "definition" : "The domain of possible values for a mode or state of being that describes the nature of a specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenChildRole",
      "display" : "Specimen Child Role (0494)",
      "definition" : "The domain of possible values for for child specimens the relationship between this specimen and the parent specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BodySiteModifier",
      "display" : "Body Site Modifier (0495)",
      "definition" : "The domain of possible values for the modifier for the body site.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentType",
      "display" : "Consent Type (0496)",
      "definition" : "The domain of possible values for to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentMode",
      "display" : "Consent Mode (0497)",
      "definition" : "The domain of possible values for the method in which a subject provides consent.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentStatus",
      "display" : "Consent Status (0498)",
      "definition" : "The domain of possible values for whether the consent has been sought and granted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentBypassReason",
      "display" : "Consent Bypass Reason (0499)",
      "definition" : "The domain of possible values for the reason the subject's consent was not sought.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentDisclosureLevel",
      "display" : "Consent Disclosure Level (0500)",
      "definition" : "The domain of possible values to specify how much information was disclosed to the subject as part of the informed consent process.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConsentNon-disclosureReason",
      "display" : "Consent Non-Disclosure Reason (0501)",
      "definition" : "The domain of possible values that specify a reason the subject did not receive full disclosure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Non-subjectConsenterReason",
      "display" : "Non-Subject Consenter Reason (0502)",
      "definition" : "The domain of possible values to specify a reason consent was granted by a person other than the subject of the consent.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Sequence_ResultsFlag",
      "display" : "Sequence/Results Flag (0503)",
      "definition" : "The domain of possible values to specify the sequencing relationship between the current service request and a related service request(s) specified in the same information model structure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SequenceConditionCode",
      "display" : "Sequence Condition Code (0504)",
      "definition" : "The domain of possible values to specify the relationship between the start/end of the related service request(s) and the current service request.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CyclicEntry_ExitIndicator",
      "display" : "Cyclic Entry/Exit Indicator (0505)",
      "definition" : "The domain of possible values to specify if this service request is the first or last service request in a cyclic series of service requests.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ServiceRequestRelationship",
      "display" : "Service Request Relationship (0506)",
      "definition" : "The domain of possible values to specify an additional or alternate relationship between this service request and other service requests.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ObservationResultHandling",
      "display" : "Observation Result Handling (0507)",
      "definition" : "The domain of possible values regarding the handling of a result.  For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BloodProductProcessingRequirements",
      "display" : "Blood Product Processing Requirements (0508)",
      "definition" : "The domain of possible values that specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IndicationForUse",
      "display" : "Indication for Use (0509)",
      "definition" : "The domain of possible values that specify the reason the blood product was ordered.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BloodProductDispenseStatus",
      "display" : "Blood Product Dispense Status (0510)",
      "definition" : "The domain of possible values to specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product.  When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been \"dispensed\".",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BpObservationStatusCodesInterpretation",
      "display" : "BP Observation Status Codes Interpretation (0511)",
      "definition" : "The domain of possible values to specify the interpretation for the blood product observation status codes.  A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary.  However, once the product is transfused, the status would be considered final.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CommercialProduct",
      "display" : "Commercial Product (0512)",
      "definition" : "The domain of possible values that specify a commercial product.  Examples of commercial products are blood derivatives such as Rh Immune Globulin and Factor VIII concentrate, Leukoreduction filters and blood administration sets.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BloodProductTransfusion_DispositionStatus",
      "display" : "Blood Product Transfusion/Disposition Status (0513)",
      "definition" : "The domain of possible values to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransfusionAdverseReaction",
      "display" : "Transfusion Adverse Reaction (0514)",
      "definition" : "The domain of possible values that specify the type of adverse reaction that the recipient of the blood product experienced.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransfusionInterruptedReason",
      "display" : "Transfusion Interrupted Reason (0515)",
      "definition" : "The domain of possible values that specify the reason the transfusion of the blood product was interrupted.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ErrorSeverity",
      "display" : "Error Severity (0516)",
      "definition" : "The domain of possible values for the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InformPersonCode",
      "display" : "Inform Person Code (0517)",
      "definition" : "The domain of possible values that specify who (if anyone) shouldor should not be informed of an error.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OverrideType",
      "display" : "Override Type (0518)",
      "definition" : "The domain of possible values that specify what type of override can be used to override the specific error identified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OverrideReason",
      "display" : "Override Reason (0519)",
      "definition" : "The domain of possible values that specify the override codes that can be used to override enforcement of the application rule that generated an error.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2MessageWaitingPriority",
      "display" : "Message Waiting Priority (0520)",
      "definition" : "The domain of possible values to specify how important the most important waiting mesasge is.  For example, if there are 3 low priority messages, 1 medium priority message and 1 high priority message, the message waiting priority would be \"high\", because that is the highest priority of any new message waiting.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OverrideCode",
      "display" : "Override Code (0521)",
      "definition" : "The domain of possible values that specify the reason for the business rule override.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ComputationType",
      "display" : "Computation Type (0523)",
      "definition" : "The domain of possible values to specify if the change is computed as a percent change or as an absolute change.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Privilege",
      "display" : "Privilege (0525)",
      "definition" : "The domain of possible values that specify the institutional privilege.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PrivilegeClass",
      "display" : "Privilege Class (0526)",
      "definition" : "The domain of possible values that specify the class category of institutional privilege.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CalendarAlignment",
      "display" : "Calendar Alignment (0527)",
      "definition" : "The domain of possible values to specify an alignment of the repetition to a calendar (e.g., to distinguish every  30 days from \"the 5th of every month\").",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EventRelatedPeriod",
      "display" : "Event Related Period (0528)",
      "definition" : "The domain of possible values to specify a common (periodical) activity of daily living.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Organization_Agency_Department",
      "display" : "Organization, Agency, Department (0530)",
      "definition" : "The domain of possible values that specify the agency or department that assigned a specified identifier.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Institution",
      "display" : "Institution (0531)",
      "definition" : "The domain of possible values that specify the institution where a staff member is or was active.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ExpandedYes_NoIndicator",
      "display" : "Expanded Yes/no Indicator (0532)",
      "definition" : "The domain of possible values to specify an expansion on the original Yes/No indicator table by including \"flavors of null\".  It is intended to be applied to fields where the response is not limited to \"yes\" or \"no\".",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ApplicationErrorCode",
      "display" : "Application Error Code (0533)",
      "definition" : "The domain of possible values that specify the application specific code identifying the specific error that occurred.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NotifyClergyCode",
      "display" : "Notify Clergy Code (0534)",
      "definition" : "The domain of possible values that specify whether the clergy should be notified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SignatureCode",
      "display" : "Signature Code (0535)",
      "definition" : "The domain of possible values that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificateStatus",
      "display" : "Certificate Status (0536)",
      "definition" : "The domain of possible values that specify the status of the certificate held by a health professional.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Institution2",
      "display" : "Institution (0537)",
      "definition" : "The domain of possible values that specify the institution a specified practitioner began or intends to begin practicing at (e.g., at hospital, at physician organization, at managed care network).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InstitutionRelationshipType",
      "display" : "Institution Relationship Type (0538)",
      "definition" : "The domain of possible values that specify the relationship the staff person has with the institution for whom he/she provides services.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CostCenterCode",
      "display" : "Cost Center Code (0539)",
      "definition" : "The domain of possible values that specify the organization unit in the General Ledger to which the staff member is currently assigned.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InactiveReasonCode",
      "display" : "Inactive Reason Code (0540)",
      "definition" : "The domain of possible values that specify the reason the staff member is inactive.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenTypeModifier",
      "display" : "Specimen Type Modifier (0541)",
      "definition" : "The domain of possible values that specify the modifying or qualifying description(s) about the specimen type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenSourceTypeModifier",
      "display" : "Specimen Source Type Modifier (0542)",
      "definition" : "The domain of possible values that specify the modifying or qualifying description(s) about the specimen source site.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SpecimenCollectionSite",
      "display" : "Specimen Collection Site (0543)",
      "definition" : "The domain of possible values that specify the modifying or qualifying description(s) about the specimen collection site.  This Domain differs from SpecimenSourceSite in those cases where the source site must be approached via a particular site (e.g., anatomic location). For example, in the case where a liver biopsy is obtained via a percutaneous needle, the collection site would be the point of entry of the needle. For venous blood collected from the left radial vein, the collection site could be “antecubital fossa”.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerCondition",
      "display" : "Container Condition (0544)",
      "definition" : "The domain of possible values to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "JurisdictionalBreadth",
      "display" : "Jurisdictional Breadth (0547)",
      "definition" : "The domain of possible values that specify the breadth/extent of the jurisdiction where the qualification is valid.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SignatorysRelationshipToSubject",
      "display" : "Signatory's Relationship to Subject (0548)",
      "definition" : "The domain of possible values that specify the relationship of the consenter to the subject.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "NdcCodes",
      "display" : "NDC Codes (0549)",
      "definition" : "The domain of possible values that specify the National Drug Codes (NDC) that are required by the Health Insurance Portability and Accountability Act (HIPAA) for electronic claims for pharmacy charges.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BodyParts",
      "display" : "Body Parts (0550)",
      "definition" : "The domain of possible values to specify the part of the body.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdvancedBeneficiaryNoticeOverrideReason",
      "display" : "Advanced Beneficiary Notice Override Reason (0552)",
      "definition" : "The domain of possible values that specify the reason the patient did not sign an Advanced Beneficiary Notice.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InvoiceControlCode",
      "display" : "Invoice Control Code (0553)",
      "definition" : "The domain of possible values that specify what invoice action is being performed by this message.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InvoiceReasonCodes",
      "display" : "Invoice Reason Codes (0554)",
      "definition" : "The domain of possible values that specify the reason for an invoice.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InvoiceType",
      "display" : "Invoice Type (0555)",
      "definition" : "The domain of possible values that specify the type of invoice.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BenefitGroup",
      "display" : "Benefit Group (0556)",
      "definition" : "The domain of possible values that specify the benefit group.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PayeeType",
      "display" : "Payee Type (0557)",
      "definition" : "The domain of possible values that specify the type of payee (e.g., organization, person).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PayeeRelationshipToInvoice",
      "display" : "Payee Relationship to Invoice (0558)",
      "definition" : "The domain of possible values used to specify the relationship to the invoice for Person Payee Types.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Product_ServiceStatus",
      "display" : "Product/Service Status (0559)",
      "definition" : "The domain of possible values that specify the processing status for the Product/Service Code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "QuantityUnits",
      "display" : "Quantity Units (0560)",
      "definition" : "The domain of possible values that specify the adjustment quantity.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Product_ServicesClarificationCodes",
      "display" : "Product/Services Clarification Codes (0561)",
      "definition" : "The domain of possible values that specify the Product/Service Code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessingConsiderationCodes",
      "display" : "Processing Consideration Codes (0562)",
      "definition" : "The domain of possible values that specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdjustmentCategoryCode",
      "display" : "Adjustment Category Code (0564)",
      "definition" : "The domain of possible values used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProviderAdjustmentReasonCode",
      "display" : "Provider Adjustment Reason Code (0565)",
      "definition" : "The domain of possible values used to specify the reason for this adjustment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BloodUnitType",
      "display" : "Blood Unit Type (0566)",
      "definition" : "The domain of possible values used to specify the type of blood unit",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "WeightUnits",
      "display" : "Weight Units (0567)",
      "definition" : "The domain of possible values of units of measure that are used to specify weight.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VolumeUnits",
      "display" : "Volume Units (0568)",
      "definition" : "The domain of possible values of units of measure that are used to specify volume.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AdjustmentAction",
      "display" : "Adjustment Action (0569)",
      "definition" : "The domain of possible values used to specify the action requested of a party that receives an adjustment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PaymentMethodCode",
      "display" : "Payment Method Code (0570)",
      "definition" : "The domain of possible values used to specify the method for the movement of payment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "InvoiceProcessingResultsStatus",
      "display" : "Invoice Processing Results Status (0571)",
      "definition" : "The domain of possible values used to specify the processing status for an Invoice Processing Result.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TaxStatus",
      "display" : "Tax status (0572)",
      "definition" : "The domain of possible values used to specify the tax status of a provider.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "UserAuthenticationCredentialTypeCode",
      "display" : "User Authentication Credential Type Code (0615)",
      "definition" : "The domain of possible values for a type of user authentication credential.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AddressExpirationReason",
      "display" : "Address Expiration Reason (0616)",
      "definition" : "The domain of possible values for the reason this address was marked as \"ended\".",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AddressUsage",
      "display" : "Address Usage (0617)",
      "definition" : "The domain of possible values for how an address is intended to be used.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProtectionCode",
      "display" : "Protection Code (0618)",
      "definition" : "The domain of possible values for that an address needs to be treated with special care or sensitivity.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ItemStatusCodes",
      "display" : "Item Status Codes (0625)",
      "definition" : "The domain of possible values for the state of an inventory item within the context of an inventory location.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ItemImportanceCodes",
      "display" : "Item Importance Codes (0634)",
      "definition" : "The domain of possible values that denote a level or importance of an inventory item within the context of an inventory location.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReorderTheoryCodes",
      "display" : "Reorder Theory Codes (0642)",
      "definition" : "The domain of possible values for the calculation method used to determine the resupply schedule.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LaborCalculationType",
      "display" : "Labor Calculation Type (0651)",
      "definition" : "The domain of possible values for the method used to calculate employee labor and measure employee productivity.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DateFormat",
      "display" : "Date Format (0653)",
      "definition" : "The domain of possible values for the date format for a decontamination/sterilization instance.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceType",
      "display" : "Device Type (0657)",
      "definition" : "The domain of possible values for the kind of device as defined by the manufacturer.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LotControl",
      "display" : "Lot Control (0659)",
      "definition" : "The domain of possible values for whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceDataState",
      "display" : "Device Data State (0667)",
      "definition" : "The domain of possible values for the state of the data as provided from a device.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LoadStatus",
      "display" : "Load Status (0669)",
      "definition" : "The domain of possible values for the status of the information provided in a device sterilization or decontamination cycle.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceStatus",
      "display" : "Device Status (0682)",
      "definition" : "The domain of possible values for the state of a device.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CycleType",
      "display" : "Cycle Type (0702)",
      "definition" : "The domain of possible values for the type of cycle that is being executed.  A cycle type is a specific sterilization method used for a specific type of supply item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AccessRestrictionValue",
      "display" : "Access Restriction Value (0717)",
      "definition" : "The domain of possible values for the policies governing the information to which access is contolled.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AccessRestrictionReasonCode",
      "display" : "Access Restriction Reason Code (0719)",
      "definition" : "The domain of possible values for the reason for the restricted access.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MoodCodes",
      "display" : "Mood Codes (0725)",
      "definition" : "The domain of possible values for the functional state of an order.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CclValue",
      "display" : "CCL Value (0728)",
      "definition" : "The domain of possible values for the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgDiagnosisDeterminationStatus",
      "display" : "DRG Diagnosis Determination Status (0731)",
      "definition" : "The domain of possible values for the status of a diagnosis for a diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "GrouperStatus",
      "display" : "Grouper Status (0734)",
      "definition" : "The domain of possible values for the status of a grouper in general.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgStatusPatient",
      "display" : "DRG Status Patient (0739)",
      "definition" : "The domain of possible values for whether the length of stay is normal or respectively shorter or longer than normal.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgStatusFinancialCalculation",
      "display" : "DRG Status Financial Calculation (0742)",
      "definition" : "The domain of possible values for the status of the diagnosis related group (DRG) calculation regarding the financial aspects.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgGroupingStatus",
      "display" : "DRG Grouping Status (0749)",
      "definition" : "The domain of possible values for the status of the use of the gender information for diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "StatusWeightAtBirth",
      "display" : "Status Weight At Birth (0755)",
      "definition" : "The domain of possible values for the status of the use of the weight at birth for diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DrgStatusRespirationMinutes",
      "display" : "DRG Status Respiration Minutes (0757)",
      "definition" : "The domain of possible values for the status of the use of the respiration minutes information for diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "StatusAdmission",
      "display" : "Status Admission (0759)",
      "definition" : "The domain of possible values for the admission status for the diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DRGProcedureDeterminationStatus",
      "display" : "DRG Procedure Determination Status (0761)",
      "definition" : "The domain of possible values for the status of the use of this particular procedure for the diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DRGProcedureRelevance",
      "display" : "DRG Procedure Relevance (0763)",
      "definition" : "The domain of possible values for the relevance of this particular procedure for the diagnosis related group (DRG) determination.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ResourceTypeOrCategory",
      "display" : "Resource Type or Category (0771)",
      "definition" : "The domain of possible values for a high level categorization of resources.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ItemStatus",
      "display" : "Item Status (0776)",
      "definition" : "The domain of possible values for the status (useful for reporting and item usage purposes) that applies to an item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ItemType",
      "display" : "Item Type (0778)",
      "definition" : "The domain of possible values for a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ApprovingRegulatoryAgency",
      "display" : "Approving Regulatory Agency (0790)",
      "definition" : "The domain of possible values for the regulatory agency by which the item has been approved, such as the FDA or AMA.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RulingAct",
      "display" : "Ruling Act (0793)",
      "definition" : "The domain of possible values for an act containing a rule that the item is legally required to be included in notification reporting.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SterilizationType",
      "display" : "Sterilization Type (0806)",
      "definition" : "The domain of possible values specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MaintenanceCycle",
      "display" : "Maintenance Cycle (0809)",
      "definition" : "The domain of possible values specifying the maintenance cycle used for the inventory supply item, such as the number of times to sharpen after five uses.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MaintenanceType",
      "display" : "Maintenance Type (0811)",
      "definition" : "The domain of possible values specifying the type of maintenance performed on the inventory supply item.  This is different than the maintenance cycle in the sense that it can describe the number of maintenance cycles that can be performed before disposing of the inventory supply item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Package",
      "display" : "Package (0818)",
      "definition" : "The domain of possible values specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MimeTypes",
      "display" : "MIME Types (0834)",
      "definition" : "The domain of possible values specifying the general type of data.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProblemSeverity",
      "display" : "Problem Severity (0836)",
      "definition" : "The domain of possible values specifying the severity of a problem.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProblemPerspective",
      "display" : "Problem Perspective (0838)",
      "definition" : "The domain of possible values specifying from whose perspective a problem was identified.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ReferralDocumentationCompletionStatus",
      "display" : "Referral Documentation Completion Status (0865)",
      "definition" : "The domain of possible values specifying to the receiving provider that the clinical history in the message is incomplete and that more will follow.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TelecommunicationExpirationReason",
      "display" : "Telecommunication Expiration Reason (0868)",
      "definition" : "The domain of possible values specifying the reason this contact number/email was marked as \"ended\".",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SupplyRiskCodes",
      "display" : "Supply Risk Codes (0871)",
      "definition" : "The domain of possible values specifying any known or suspected hazard associated with this material item.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Product_ServiceCode",
      "display" : "Product/Service Code (0879)",
      "definition" : "The domain of possible values specifying what service was delivered/received.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Product_ServiceCodeModifier",
      "display" : "Product/Service Code Modifier (0880)",
      "definition" : "The domain of possible values specifying additional optional modifier(s) for the Product/Service Code (e.g., after hours - evening, after hours - weekend).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RoleExecutingPhysician",
      "display" : "Role Executing Physician (0881)",
      "definition" : "The domain of possible values specifying the account role of the physician, for example, only billing for the professional part, the technical part or both.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MedicalRoleExecutingPhysician",
      "display" : "Medical Role Executing Physician (0882)",
      "definition" : "The domain of possible values specifying the role of the physician (\"self-employed\" or \"employed\").",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SideOfBody",
      "display" : "Side of body (0894)",
      "definition" : "The domain of possible values specifying the side of the body (\"left\" or \"right\").",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PresentOnAdmissionIndicator",
      "display" : "Present On Admission (POA) Indicator (0895)",
      "definition" : "The domain of possible values specifying the present on admission indicator for this particular diagnosis.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SecurityCheckScheme",
      "display" : "Security Check Scheme (0904)",
      "definition" : "The domain of possible values specifying the scheme for a security check.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ShipmentStatus",
      "display" : "Shipment Status (0905)",
      "definition" : "The domain of possible values specifying the status of a shipment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ActPriority",
      "display" : "ActPriority (0906)",
      "definition" : "The domain of possible values specifying the priority for a shipment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2Confidentiality",
      "display" : "Confidentiality (0907)",
      "definition" : "The domain of possible values specifying the confidentiality for a shipment.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PackageType",
      "display" : "Package Type (0908)",
      "definition" : "The domain of possible values specifying the type of package.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PatientResultsReleaseCategorizationScheme",
      "display" : "Patient Results Release Categorization Scheme (0909)",
      "definition" : "The domain of possible values specifying the scheme for the patient results release categorization.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "AcquisitionModality",
      "display" : "Acquisition Modality (0910)",
      "definition" : "The domain of possible values specifying the modality for the acquisition of an image.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Participation",
      "display" : "Participation (0912)",
      "definition" : "The domain of possible values that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "MonetaryDenominationCode",
      "display" : "Monetary Denomination Code (0913)",
      "definition" : "The domain of possible values specifying the denomination in which the quantity is expressed. Values commonly used are the three-character codes specified in  ISO-4217 (1.0.4217 iso4217).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RootCause",
      "display" : "Root Cause (0914)",
      "definition" : "The domain of possible values specifying a root cause.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessControlCode",
      "display" : "Process Control Code (0915)",
      "definition" : "The domain of possible values specifying a process control code.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RelevantClinicialInformation",
      "display" : "Relevant Clincial Information (0916)",
      "definition" : "The domain of possible values for additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "BolusType",
      "display" : "Bolus Type (0917)",
      "definition" : "The domain of possible values specifying a type of bolus.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PcaType",
      "display" : "PCA Type (0918)",
      "definition" : "The domain of possible values specifying a type of PCA.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ExclusiveTest",
      "display" : "Exclusive Test (0919)",
      "definition" : "The domain of possible values that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PreferredSpecimen_AttributeStatus",
      "display" : "Preferred Specimen/Attribute Status (0920)",
      "definition" : "The domain of possible values that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificationTypeCode",
      "display" : "Certification Type Code (0921)",
      "definition" : "The domain of possible values specifying the code for a certification type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CertificationCategoryCode",
      "display" : "Certification Category Code (0922)",
      "definition" : "The domain of possible values specifying the code for a certification category.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessInterruption",
      "display" : "Process Interruption (0923)",
      "definition" : "The domain of possible values specifying whether a process was interrrupted and whether a needle had been inserted in the donor's arm prior to the interruption.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CumulativeDosageLimitUom",
      "display" : "Cumulative Dosage Limit UoM (0924)",
      "definition" : "The domain of possible values specifying the unit of measure (UoM) for the cumulative dosage limit.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PhlebotomyIssue",
      "display" : "Phlebotomy Issue (0925)",
      "definition" : "The domain of possible values specifying a phlebotomy issue.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PhlebotomyStatus",
      "display" : "Phlebotomy Status (0926)",
      "definition" : "The domain of possible values specifying the status of a phlebotomy.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ArmStick",
      "display" : "Arm Stick (0927)",
      "definition" : "The domain of possible values specifying the arm(s) receiving a stick.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "WeightUnitsSNAFU",
      "display" : "Weight Units (0929)",
      "definition" : "The domain of possible values of units of measure that are used to specify weight.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "VolumeUnitsSNAFU",
      "display" : "Volume Units (0930)",
      "definition" : "The domain of possible values of units of measure that are used to specify volume.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TemperatureUnits",
      "display" : "Temperature Units (0931)",
      "definition" : "The domain of possible values specifying  the units of transport temperature.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DonationDurationUnits",
      "display" : "Donation Duration Units (0932)",
      "definition" : "The domain of possible values specifying the units of donation duration.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "IntendedProcedureType",
      "display" : "Intended Procedure Type (0933)",
      "definition" : "The domain of possible values specifying the type of intended procedure.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OrderWorkflowProfile",
      "display" : "Order Workflow Profile (0934)",
      "definition" : "The domain of possible values specifying the profile of the order workflow.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ProcessInterruptionReason",
      "display" : "Process Interruption Reason (0935)",
      "definition" : "The domain of possible values specifying the reason for a process interruption.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "V2ObservationType",
      "display" : "Observation Type (0936)",
      "definition" : "The domain of possible values for types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ObservationSub-type",
      "display" : "Observation Sub-Type (0937)",
      "definition" : "The domain of possible values specifying an observation sub-type.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CollectionEvent_ProcessStepLimit",
      "display" : "Collection Event/Process Step Limit (0938)",
      "definition" : "The domain of possible values specifying the limit for a collection event or process step.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "CommunicationLocation",
      "display" : "Communication Location (0939)",
      "definition" : "The domain of possible values specifying a communication location.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "LimitationTypeCodes",
      "display" : "Limitation Type Codes (0940)",
      "definition" : "The domain of possible values specifying a type of limitation.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PayerCoverageProcedureCode",
      "display" : "Procedure Code (0941)",
      "definition" : "The domain of possible values specifying procedure codes that may impact payer coverage requirements, for example procedure code 1234 is not covered by a payer ABCD or may be covered in conjunction with a specific diagnosis code which can be identifeid in DPS-1 Diagnosis Code. The procedure codes should be drawn from appropriate externally defined procedure codes, for example in the US Realm these include CPT-4 codes defined by the American Medical Association and ICD codes published by CMS.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "EquipmentStateIndicatorTypeCode",
      "display" : "Equipment State Indicator Type Code (0942)",
      "definition" : "The domain of possible values that specify the type of measurement of the state of an automated laboratory instrument.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransportDestination",
      "display" : "Transport Destination (0943)",
      "definition" : "The domain of possible values that identify the destination for transport of a specific container.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "TransportRoute",
      "display" : "Transport Route (0944)",
      "definition" : "The domain of possible values that identify the route for transport of a specific container.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "Auto-dilutionType",
      "display" : "Auto-Dilution Type (0945)",
      "definition" : "The domain of possible values for the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "SupplierType",
      "display" : "Supplier Type (0946)",
      "definition" : "The domain of possible values for the type of supplier that will distribute the supply items associated to a contract number.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ClassOfTrade",
      "display" : "Class of Trade (0947)",
      "definition" : "The domain of possible values for the purchasing channel with which the contract is associated  such as Hospital, Retail, etc.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "RelationshipType",
      "display" : "Relationship Type (0948)",
      "definition" : "The domain of possible values for the type of relationship that is established between the instances of Source Information and  Target Information.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "orderControlCodeReason",
      "display" : "Order Control Code Reason (0949)",
      "definition" : "The domain of possible values that describe reasons for the chosen order control codes.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "orderStatusModifier",
      "display" : "Order Status Modifier (0950)",
      "definition" : "The domain of possible values that further define an identified status.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "reasonForStudy",
      "display" : "Reason for Study (0951)",
      "definition" : "The domain of possible values that provide additional information to the universal service identifier on why a test, study or review was ordered.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ConfidentialityV2",
      "display" : "Confidentiality Classification (0952)",
      "definition" : "Types of privacy metadata classifying an IT resource (data, information object, service, or system capability) according to its level of sensitivity, which is based on an analysis of applicable privacy policies and the risk of financial, reputational, or other harm to an individual or entity that could result if made available or disclosed to unauthorized individuals, entities, or processes.\r\nUsage Note : Confidentiality codes may be used in security labels and privacy markings to classify IT resources based on sensitivity to indicate the obligation of a custodian or receiver to ensure that the protected resource is not made available or disclosed to individuals, entities, or processes (security principals) unless authorized per applicable policies. Confidentiality codes may also be used in the clearances of initiators requesting access to protected resources.\r\nMap: Definition aligns with ISO 7498-2:1989 - Confidentiality is the property that information is not made available or disclosed to unauthorized individuals, entities, or processes",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "WorkClassificationODH",
      "display" : "Work Classification ODH (0959)",
      "definition" : "Types of a person’s employment type as defined by compensation and sector (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.).",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DataAbsentReason",
      "display" : "Data Absent Reason (0960)",
      "definition" : "??",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceTypeSNAFU",
      "display" : "Device Type (0961)",
      "definition" : "Domain of concepts describing what kind a particular device is. Focus here is on devices used in the medical field.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceStatusSNAFU",
      "display" : "Device Status (0962)",
      "definition" : "The domain describing the availability status of a device.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "DeviceSafety",
      "display" : "Device Safety (0963)",
      "definition" : "The domain describing safety characteristics of medical devices.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ServiceReason",
      "display" : "Service Reason (0964)",
      "definition" : "Domain of concepts describing reasons why a particular service was performed.\r\nThis could be explaining why something was ordered differently than typically done, or explain that it was ordered by mistake.\r\n\tPatient disability requires it\r\n\tNo provider in network\r\n\tPatient paid out of pocket",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContractType",
      "display" : "Contract Type (0965)",
      "definition" : "The domain of possible values describing the scope of contracts in a masterfile, e.g.:\r\n•\tLocal\r\n•\tRegional\r\n•\tGlobal",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "PricingTierLevel",
      "display" : "Pricing Tier Level (0966)",
      "definition" : "The domain of possible values describing the declared level of pricing for a particular product under a contract, usually based on a discount for larger orders under the contract – often assigned numerically, e.g.:\r\n•\tTier 1\r\n•\tTier 2\r\n•\tTier 3",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerFormV2",
      "display" : "Container Form (0967)",
      "definition" : "The domain of possible values describing shape or type of the container, e.g.:\r\n•\tTube/vial\r\n•\tJar\r\n•\tBag\r\n•\tBlock\r\n•\tSlide",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerMaterial",
      "display" : "Container Material (0968)",
      "definition" : "The domain of possible values describing the material a container is made of or indication that the container may be a virtual type, e.g.:\r\n•\tGlass\r\n•\tPlastic\r\n•\tWhole Slide Image",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "ContainerCommonName",
      "display" : "Container Common Name (0969)",
      "definition" : "Codes created by an organization as a shorthand way to express a combination of container attributes; for example the combination of SAC-47 (Container Form) of “Tube/vial” + SAC-48 (Container Material) of “Glass” + SAC-27 (Additive) of “EDTA” may be referenced commonly in an organization as a “Lavender Top”, e.g.:\r\n•\tLavender Top\r\n•\tWet Mount (slides for parasitology)\r\n•\tLJ plate (for Mycobacterium cultures)",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OnlineVerificationResult",
      "display" : "Online Verification Result (0970)",
      "definition" : "Domain of values for the results of an operation to perform online verification of insurance data",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    },
    {
      "code" : "OnlineVerificationResultErrorCode",
      "display" : "Online Verification Result Error Code (0971)",
      "definition" : "Domain of values representing a type of error from a failed operation to perform online verification of insurance data.",
      "property" : [
        {
          "code" : "source",
          "valueCode" : "v2"
        }
      ]
    }
  ]
}

```
