# CommunicationTopic - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CommunicationTopic**

## CodeSystem: CommunicationTopic 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/communication-topic | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CommunicationTopic |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1078 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes describing the purpose or content of the communication. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CommunicationTopic](ValueSet-communication-topic.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "communication-topic",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/communication-topic",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1078"
    }
  ],
  "version" : "1.0.1",
  "name" : "CommunicationTopic",
  "title" : "CommunicationTopic",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes describing the purpose or content of the communication.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/communication-topic",
  "content" : "complete",
  "concept" : [
    {
      "code" : "prescription-refill-request",
      "display" : "Prescription Refill Request",
      "definition" : "The purpose or content of the communication is a prescription refill request."
    },
    {
      "code" : "progress-update",
      "display" : "Progress Update",
      "definition" : "The purpose or content of the communication is a progress update."
    },
    {
      "code" : "report-labs",
      "display" : "Report Labs",
      "definition" : "The purpose or content of the communication is to report labs."
    },
    {
      "code" : "appointment-reminder",
      "display" : "Appointment Reminder",
      "definition" : "The purpose or content of the communication is an appointment reminder."
    },
    {
      "code" : "phone-consult",
      "display" : "Phone Consult",
      "definition" : "The purpose or content of the communication is a phone consult."
    },
    {
      "code" : "summary-report",
      "display" : "Summary Report",
      "definition" : "The purpose or content of the communication is a summary report."
    }
  ]
}

```
