# Cited Artifact Status Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Artifact Status Type**

## CodeSystem: Cited Artifact Status Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-artifact-status-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedArtifactStatusType |

 
Cited Artifact Status Type 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedArtifactStatusType](ValueSet-cited-artifact-status-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-artifact-status-type",
  "meta" : {
    "lastUpdated" : "2021-03-11T10:55:11.085+11:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-artifact-status-type",
  "version" : "1.0.0",
  "name" : "CitedArtifactStatusType",
  "title" : "Cited Artifact Status Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T10:55:11.085+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Cited Artifact Status Type",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-artifact-status-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "created",
      "display" : "Created",
      "definition" : "The content was originally constructed or composed."
    },
    {
      "code" : "submitted",
      "display" : "Submitted",
      "definition" : "The content was sent to the publisher for consideration of publication."
    },
    {
      "code" : "withdrawn",
      "display" : "Withdrawn",
      "definition" : "The content that was not published has been removed from consideration for publishing by the submitter."
    },
    {
      "code" : "pre-review",
      "display" : "Pre review",
      "definition" : "The content is awaiting assignment and delivery to reviewer(s)."
    },
    {
      "code" : "under-review",
      "display" : "Under review",
      "definition" : "The content is in a state of being reviewed."
    },
    {
      "code" : "post-review-pre-published",
      "display" : "Post review pre published",
      "definition" : "The content is in a state between the review(s) being completed and being published."
    },
    {
      "code" : "rejected",
      "display" : "Rejected",
      "definition" : "The content that was not published has been removed from consideration for publishing by a publisher or editor."
    },
    {
      "code" : "published-early-form",
      "display" : "Published early form",
      "definition" : "The content is published but future changes to the published version are expected."
    },
    {
      "code" : "published-final-form",
      "display" : "Published final form",
      "definition" : "The content is published and further changes to the content are not expected."
    },
    {
      "code" : "accepted",
      "display" : "Accepted",
      "definition" : "The content that was not published yet has been approved for publication by the publisher and/or editor."
    },
    {
      "code" : "archived",
      "display" : "Archived",
      "definition" : "The content is retired or considered no longer current but still available as part of the public record."
    },
    {
      "code" : "retracted",
      "display" : "Retracted",
      "definition" : "The content that was published is removed from publication and should no longer be considered part of the public record."
    },
    {
      "code" : "draft",
      "display" : "Draft",
      "definition" : "The content is considered unfinished or incomplete and not representative of the current state desired by the content creator."
    },
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "The content is considered complete for its current state by the content creator."
    },
    {
      "code" : "approved",
      "display" : "Approved",
      "definition" : "The content has been approved for a state transition, with the focus of approval described in the text associated with this coding."
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "The status of the content is not recorded in the metadata."
    }
  ]
}

```
