# Citation Classification Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Citation Classification Type**

## CodeSystem: Citation Classification Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/citation-classification-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitationClassificationType |

 
Citation classification type 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitationClassificationType](ValueSet-citation-classification-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "citation-classification-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/citation-classification-type",
  "version" : "1.0.0",
  "name" : "CitationClassificationType",
  "title" : "Citation Classification Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T10:55:11.085+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Citation classification type",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/citation-classification-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "citation-source",
      "display" : "Citation Source",
      "definition" : "Citation repository where this citation was created or copied from"
    },
    {
      "code" : "medline-owner",
      "display" : "MEDLINE Citation Owner",
      "definition" : "The party responsible for creating and validating the MEDLINE citation"
    },
    {
      "code" : "fevir-platform-use",
      "display" : "FEvIR Platform Use",
      "definition" : "Used for Citation sharing on the Fast Evidence Interoperability Resources (FEvIR) Platform"
    }
  ]
}

```
