# Basic Resource Types - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Resource Types**

## CodeSystem: Basic Resource Types 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/basic-resource-type | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BasicResourceTypes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1072 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR. Many of the codes listed here will eventually be turned into official resources. However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here. Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BasicResourceTypes](ValueSet-basic-resource-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "basic-resource-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/basic-resource-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1072"
    }
  ],
  "version" : "1.0.1",
  "name" : "BasicResourceTypes",
  "title" : "Basic Resource Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR.  Many of the codes listed here will eventually be turned into official resources.  However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here.  Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/basic-resource-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "consent",
      "display" : "Consent",
      "definition" : "An assertion of permission for an activity or set of activities to occur, possibly subject to particular limitations; e.g. surgical consent, information disclosure consent, etc."
    },
    {
      "code" : "referral",
      "display" : "Referral",
      "definition" : "A request that care of a particular type be provided to a patient.  Could involve the transfer of care, a consult, etc."
    },
    {
      "code" : "advevent",
      "display" : "Adverse Event",
      "definition" : "An undesired reaction caused by exposure to some agent (e.g. a medication, immunization, food, or environmental agent)."
    },
    {
      "code" : "aptmtreq",
      "display" : "Appointment Request",
      "definition" : "A request that a time be scheduled for a type of service for a specified patient, potentially subject to other constraints"
    },
    {
      "code" : "transfer",
      "display" : "Transfer",
      "definition" : "The transition of a patient or set of material from one location to another"
    },
    {
      "code" : "diet",
      "display" : "Diet",
      "definition" : "The specification of a set of food and/or other nutritional material to be delivered to a patient."
    },
    {
      "code" : "adminact",
      "display" : "Administrative Activity",
      "definition" : "An occurrence of a non-care-related event in the healthcare domain, such as approvals, reviews, etc."
    },
    {
      "code" : "exposure",
      "display" : "Exposure",
      "definition" : "Record of a situation where a subject was exposed to a substance.  Usually of interest to public health."
    },
    {
      "code" : "investigation",
      "display" : "Investigation",
      "definition" : "A formalized inquiry into the circumstances surrounding a particular unplanned event or potential event for the purposes of identifying possible causes and contributing factors for the event"
    },
    {
      "code" : "account",
      "display" : "Account",
      "definition" : "A financial instrument used to track costs, charges or other amounts."
    },
    {
      "code" : "invoice",
      "display" : "Invoice",
      "definition" : "A request for payment for goods and/or services.  Includes the idea of a healthcare insurance claim."
    },
    {
      "code" : "adjudicat",
      "display" : "Invoice Adjudication",
      "definition" : "The determination of what will be paid against a particular invoice based on coverage, plan rules, etc."
    },
    {
      "code" : "predetreq",
      "display" : "Pre-determination Request",
      "definition" : "A request for a pre-determination of the cost that would be paid under an insurance plan for a hypothetical claim for goods or services"
    },
    {
      "code" : "predetermine",
      "display" : "Predetermination",
      "definition" : "An adjudication of what would be paid under an insurance plan for a hypothetical claim for goods or services"
    },
    {
      "code" : "study",
      "display" : "Study",
      "definition" : "An investigation to determine information about a particular therapy or product"
    },
    {
      "code" : "protocol",
      "display" : "Protocol",
      "definition" : "A set of (possibly conditional) steps to be taken to achieve some aim.  Includes study protocols, treatment protocols, emergency protocols, etc."
    }
  ]
}

```
