# AllergyIntolerance Clinical Status Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance Clinical Status Codes**

## CodeSystem: AllergyIntolerance Clinical Status Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AllergyIntoleranceClinicalStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1373 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Preferred value set for AllergyIntolerance Clinical Status. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AllergyIntoleranceClinicalStatusCodes](ValueSet-allergyintolerance-clinical.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allergyintolerance-clinical",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1373"
    }
  ],
  "version" : "1.0.1",
  "name" : "AllergyIntoleranceClinicalStatusCodes",
  "title" : "AllergyIntolerance Clinical Status Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Preferred value set for AllergyIntolerance Clinical Status.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/allergyintolerance-clinical",
  "content" : "complete",
  "concept" : [
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "The subject is currently experiencing, or is at risk of, a reaction to the identified substance."
    },
    {
      "code" : "inactive",
      "display" : "Inactive",
      "definition" : "The subject is no longer at risk of a reaction to the identified substance.",
      "concept" : [
        {
          "code" : "resolved",
          "display" : "Resolved",
          "definition" : "A reaction to the identified substance has been clinically reassessed by testing or re-exposure and is considered no longer to be present. Re-exposure could be accidental, unplanned, or outside of any clinical setting."
        }
      ]
    }
  ]
}

```
