# ActivityDefinitionCategory - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActivityDefinitionCategory**

## CodeSystem: ActivityDefinitionCategory 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/activity-definition-category | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActivityDefinitionCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1243 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
High-level categorization of the type of activity. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActivityDefinitionCategory](ValueSet-activity-definition-category.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "activity-definition-category",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/activity-definition-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1243"
    }
  ],
  "version" : "1.0.0",
  "name" : "ActivityDefinitionCategory",
  "title" : "ActivityDefinitionCategory",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "High-level categorization of the type of activity.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/activity-definition-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "treatment",
      "display" : "Treatment",
      "definition" : "The activity is intended to provide or is related to treatment of the patient."
    },
    {
      "code" : "education",
      "display" : "Education",
      "definition" : "The activity is intended to provide or is related to education of the patient."
    },
    {
      "code" : "assessment",
      "display" : "Assessment",
      "definition" : "The activity is intended to perform or is related to assessment of the patient."
    }
  ]
}

```
