# CMS Place of Service Codes (POS) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Place of Service Codes (POS)**

## CodeSystem: CMS Place of Service Codes (POS) 

| | |
| :--- | :--- |
| *Official URL*:https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set | *Version*:20240502 |
| Active as of 2025-04-26 | *Responsible:*Centers for Medicare & Medicaid Services /td>*Computable Name*:CMSPlaceofServiceCodes*Other Identifiers:*OID:2.16.840.1.113883.15.5Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.This code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider.This Code system is referenced in the content logical definition of the following value sets:* [CMSPlaceOfServiceCodes](ValueSet-CMSPlaceOfServiceCodes.md)
* [HealthcareServiceLocation](ValueSet-v3-HealthcareServiceLocation.md)
-------
**History** |



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "CMSPlaceofServiceCodes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/artifact-version",
      "valueString" : "20250426"
    }
  ],
  "url" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.15.5"
    }
  ],
  "version" : "20240502",
  "name" : "CMSPlaceofServiceCodes",
  "title" : "CMS Place of Service Codes (POS)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-04-26T00:00:00-00:00",
  "publisher" : "Centers for Medicare & Medicaid Services",
  "description" : "Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.\r\n\r\nThis code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider.",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "01",
      "display" : "Pharmacy",
      "definition" : "A facility or location where drugs and other medically related items and services are sold, dispensed, or otherwise provided directly to patients. (Effective October 1, 2003) (Revised, effective October 1, 2005)"
    },
    {
      "code" : "02",
      "display" : "Telehealth Provided Other than in Patient’s Home",
      "definition" : "The location where health services and health related services are provided or received, through telecommunication technology. Patient is not located in their home when receiving health services or health related services through telecommunication technology.  (Effective January 1, 2017) (Description change effective January 1, 2022, and applicable for Medicare April 1, 2022.)"
    },
    {
      "code" : "03",
      "display" : "School",
      "definition" : "A facility whose primary purpose is education. (Effective January 1, 2003)"
    },
    {
      "code" : "04",
      "display" : "Homeless Shelter",
      "definition" : "A facility or location whose primary purpose is to provide temporary housing to homeless individuals (e.g., emergency shelters, individual or family shelters).  (Effective January 1, 2003)"
    },
    {
      "code" : "05",
      "display" : "Indian Health Service Free-standing Facility",
      "definition" : "A facility or location, owned and operated by the Indian Health Service, which provides diagnostic, therapeutic (surgical and non-surgical), and rehabilitation services to American Indians and Alaska Natives who do not require hospitalization. (Effective January 1, 2003)"
    },
    {
      "code" : "06",
      "display" : "Indian Health ServiceProvider-based Facility",
      "definition" : "A facility or location, owned and operated by the Indian Health Service, which provides diagnostic, therapeutic (surgical and non-surgical), and rehabilitation services rendered by, or under the supervision of, physicians to American Indians and Alaska Natives admitted as inpatients or outpatients. (Effective January 1, 2003)"
    },
    {
      "code" : "07",
      "display" : "Tribal 638 Free-standing Facility",
      "definition" : "A facility or location owned and operated by a federally recognized American Indian or Alaska Native tribe or tribal organization under a 638 agreement, which provides diagnostic, therapeutic (surgical and non-surgical), and rehabilitation services to tribal members who do not require hospitalization.  (Effective January 1, 2003)"
    },
    {
      "code" : "08",
      "display" : "Tribal 638 Provider-based Facility",
      "definition" : "A facility or location owned and operated by a federally recognized American Indian or Alaska Native tribe or tribal organization under a 638 agreement, which provides diagnostic, therapeutic (surgical and non-surgical), and rehabilitation services to tribal members admitted as inpatients or outpatients. (Effective January 1, 2003)"
    },
    {
      "code" : "09",
      "display" : "Prison/ Correctional Facility",
      "definition" : "A prison, jail, reformatory, work farm, detention center, or any other similar facility maintained by either Federal, State or local authorities for the purpose of confinement or rehabilitation of adult or juvenile criminal offenders. (Effective July 1, 2006)"
    },
    {
      "code" : "10",
      "display" : "Telehealth Provided in Patient’s Home",
      "definition" : "The location where health services and health related services are provided or received, through telecommunication technology. Patient is located in their home (which is a location other than a hospital or other facility where the patient receives care in a private residence) when receiving health services or health related services through telecommunication technology. (This code is effective January 1, 2022, and available to Medicare April 1, 2022.)"
    },
    {
      "code" : "11",
      "display" : "Office",
      "definition" : "Location, other than a hospital, skilled nursing facility (SNF), military treatment facility, community health center, State or local public health clinic, or intermediate care facility (ICF), where the health professional routinely provides health examinations, diagnosis, and treatment of illness or injury on an ambulatory basis."
    },
    {
      "code" : "12",
      "display" : "Home",
      "definition" : "Location, other than a hospital or other facility, where the patient receives care in a private residence."
    },
    {
      "code" : "13",
      "display" : "Assisted Living Facility",
      "definition" : "Congregate residential facility with self-contained living units providing assessment of each resident's needs and on-site support 24 hours a day, 7 days a week, with the capacity to deliver or arrange for services including some health care and other services.  (Effective October 1, 2003)"
    },
    {
      "code" : "14",
      "display" : "Group Home",
      "definition" : "A residence, with shared living areas, where clients receive supervision and other services such as social and/or behavioral services, custodial service, and minimal services (e.g., medication administration).  (Effective October 1, 2003) (Revised, effective April 1, 2004)"
    },
    {
      "code" : "15",
      "display" : "Mobile Unit",
      "definition" : "A facility/unit that moves from place-to-place equipped to provide preventive, screening, diagnostic, and/or treatment services. (Effective January 1, 2003)"
    },
    {
      "code" : "16",
      "display" : "Temporary Lodging",
      "definition" : "A short term accommodation such as a hotel, camp ground, hostel, cruise ship or resort where the patient receives care, and which is not identified by any other POS code. (Effective January 1, 2008)"
    },
    {
      "code" : "17",
      "display" : "Walk-in Retail Health Clinic",
      "definition" : "A walk-in health clinic, other than an office, urgent care facility, pharmacy or independent clinic and not described by any other Place of Service code, that is located within a retail operation and provides, on an ambulatory basis, preventive and primary care services.  (This code is available for use immediately with a final effective date of May 1, 2010)"
    },
    {
      "code" : "18",
      "display" : "Worksite",
      "definition" : "A location, not described by any other POS code, owned or operated by a public or private entity where the patient is employed, and where a health professional provides on-going or episodic occupational medical, therapeutic or rehabilitative services to the individual. (This code is available for use effective January 1, 2013 but no later than May 1, 2013)"
    },
    {
      "code" : "19",
      "display" : "Off Campus-Outpatient Hospital",
      "definition" : "A portion of an off-campus hospital provider based department which provides diagnostic, therapeutic (both surgical and nonsurgical), and rehabilitation services to sick or injured persons who do not require hospitalization or institutionalization. (Effective January 1, 2016)"
    },
    {
      "code" : "20",
      "display" : "Urgent Care Facility",
      "definition" : "Location, distinct from a hospital emergency room, an office, or a clinic, whose purpose is to diagnose and treat illness or injury for unscheduled, ambulatory patients seeking immediate medical attention.  (Effective January 1, 2003)"
    },
    {
      "code" : "21",
      "display" : "Inpatient Hospital",
      "definition" : "A facility, other than psychiatric, which primarily provides diagnostic, therapeutic (both surgical and nonsurgical), and rehabilitation services by, or under, the supervision of physicians to patients admitted for a variety of medical conditions."
    },
    {
      "code" : "22",
      "display" : "On Campus-Outpatient Hospital",
      "definition" : "A portion of a hospital’s main campus which provides diagnostic, therapeutic (both surgical and nonsurgical), and rehabilitation services to sick or injured persons who do not require hospitalization or institutionalization.  (Description change effective January 1, 2016)"
    },
    {
      "code" : "23",
      "display" : "Emergency Room – Hospital",
      "definition" : "A portion of a hospital where emergency diagnosis and treatment of illness or injury is provided."
    },
    {
      "code" : "24",
      "display" : "Ambulatory Surgical Center",
      "definition" : "A freestanding facility, other than a physician's office, where surgical and diagnostic services are provided on an ambulatory basis."
    },
    {
      "code" : "25",
      "display" : "Birthing Center",
      "definition" : "A facility, other than a hospital's maternity facilities or a physician's office, which provides a setting for labor, delivery, and immediate post-partum care as well as immediate care of new born infants."
    },
    {
      "code" : "26",
      "display" : "Military Treatment Facility",
      "definition" : "A medical facility operated by one or more of the Uniformed Services. Military Treatment Facility (MTF) also refers to certain former U.S. Public Health Service (USPHS) facilities now designated as Uniformed Service Treatment Facilities (USTF)."
    },
    {
      "code" : "27",
      "display" : "Outreach Site/ Street",
      "definition" : "A non-permanent location on the street or found environment, not described by any other POS code, where health professionals provide preventive, screening, diagnostic, and/or treatment services to unsheltered homeless individuals. (Effective October 1, 2023)"
    },
    {
      "code" : "31",
      "display" : "Skilled Nursing Facility",
      "definition" : "A facility which primarily provides inpatient skilled nursing care and related services to patients who require medical, nursing, or rehabilitative services but does not provide the level of care or treatment available in a hospital."
    },
    {
      "code" : "32",
      "display" : "Nursing Facility",
      "definition" : "A facility which primarily provides to residents skilled nursing care and related services for the rehabilitation of injured, disabled, or sick persons, or, on a regular basis, health-related care services above the level of custodial care to other than individuals with intellectual disabilities."
    },
    {
      "code" : "33",
      "display" : "Custodial Care Facility",
      "definition" : "A facility which provides room, board and other personal assistance services, generally on a long-term basis, and which does not include a medical component."
    },
    {
      "code" : "34",
      "display" : "Hospice",
      "definition" : "A facility, other than a patient's home, in which palliative and supportive care for terminally ill patients and their families are provided."
    },
    {
      "code" : "41",
      "display" : "Ambulance - Land",
      "definition" : "A land vehicle specifically designed, equipped and staffed for lifesaving and transporting the sick or injured."
    },
    {
      "code" : "42",
      "display" : "Ambulance – Air or Water",
      "definition" : "An air or water vehicle specifically designed, equipped and staffed for lifesaving and transporting the sick or injured."
    },
    {
      "code" : "49",
      "display" : "Independent Clinic",
      "definition" : "A location, not part of a hospital and not described by any other Place of Service code, that is organized and operated to provide preventive, diagnostic, therapeutic, rehabilitative, or palliative services to outpatients only. (Effective October 1, 2023)"
    },
    {
      "code" : "50",
      "display" : "Federally Qualified Health Center",
      "definition" : "A facility located in a medically underserved area that provides Medicare beneficiaries preventive primary medical care under the general direction of a physician."
    },
    {
      "code" : "51",
      "display" : "Inpatient Psychiatric Facility",
      "definition" : "A facility that provides inpatient psychiatric services for the diagnosis and treatment of mental illness on a 24-hour basis, by or under the supervision of a physician."
    },
    {
      "code" : "52",
      "display" : "Psychiatric Facility-Partial Hospitalization",
      "definition" : "A facility for the diagnosis and treatment of mental illness that provides a planned therapeutic program for patients who do not require full time hospitalization, but who need broader programs than are possible from outpatient visits to a hospital-based or hospital-affiliated facility."
    },
    {
      "code" : "53",
      "display" : "Community Mental Health Center",
      "definition" : "A facility that provides the following services: outpatient services, including specialized outpatient services for children, the elderly, individuals who are chronically ill, and residents of the CMHC's mental health services area who have been discharged from inpatient treatment at a mental health facility; 24 hour a day emergency care services; day treatment, other partial hospitalization services, or psychosocial rehabilitation services; screening for patients being considered for admission to State mental health facilities to determine the appropriateness of such admission; and consultation and education services."
    },
    {
      "code" : "54",
      "display" : "Intermediate Care Facility/ Individuals with Intellectual Disabilities",
      "definition" : "A facility which primarily provides health-related care and services above the level of custodial care to individuals but does not provide the level of care or treatment available in a hospital or SNF."
    },
    {
      "code" : "55",
      "display" : "Residential Substance Abuse Treatment Facility",
      "definition" : "A facility which provides treatment for substance (alcohol and drug) abuse to live-in residents who do not require acute medical care. Services include individual and group therapy and counseling, family counseling, laboratory tests, drugs and supplies, psychological testing, and room and board."
    },
    {
      "code" : "56",
      "display" : "Psychiatric Residential Treatment Center",
      "definition" : "A facility or distinct part of a facility for psychiatric care which provides a total 24-hour therapeutically planned and professionally staffed group living and learning environment."
    },
    {
      "code" : "57",
      "display" : "Non-residential Substance Abuse Treatment Facility",
      "definition" : "A location which provides treatment for substance (alcohol and drug) abuse on an ambulatory basis.  Services include individual and group therapy and counseling, family counseling, laboratory tests, drugs and supplies, and psychological testing. (Effective October 1, 2023)"
    },
    {
      "code" : "58",
      "display" : "Non-residential Opioid Treatment Facility",
      "definition" : "A location that provides treatment for opioid use disorder on an ambulatory basis. Services include methadone and other forms of Medication Assisted Treatment (MAT) (Effective January 1, 2020)"
    },
    {
      "code" : "60",
      "display" : "Mass Immunization Center",
      "definition" : "A location where providers administer pneumococcal pneumonia and influenza virus vaccinations and submit these services as electronic media claims, paper claims, or using the roster billing method. This generally takes place in a mass immunization setting, such as, a public health center, pharmacy, or mall but may include a physician office setting."
    },
    {
      "code" : "61",
      "display" : "Comprehensive Inpatient Rehabilitation Facility",
      "definition" : "A facility that provides comprehensive rehabilitation services under the supervision of a physician to inpatients with physical disabilities. Services include physical therapy, occupational therapy, speech pathology, social or psychological services, and orthotics and prosthetics services."
    },
    {
      "code" : "62",
      "display" : "Comprehensive Outpatient Rehabilitation Facility",
      "definition" : "A facility that provides comprehensive rehabilitation services under the supervision of a physician to outpatients with physical disabilities. Services include physical therapy, occupational therapy, and speech pathology services."
    },
    {
      "code" : "65",
      "display" : "End-Stage Renal Disease Treatment Facility",
      "definition" : "A facility other than a hospital, which provides dialysis treatment, maintenance, and/or training to patients or caregivers on an ambulatory or home-care basis."
    },
    {
      "code" : "66",
      "display" : "Programs of All-Inclusive Care for the Elderly (PACE) Center*",
      "definition" : "A facility or location providing comprehensive medical and social services as part of the Programs of All-Inclusive Care for the Elderly (PACE).  This includes, but is not limited to, primary care; social work services; restorative therapies, including physical and occupational therapy; personal care and supportive services; nutritional counseling; recreational therapy; and meals when the individual is enrolled in PACE. (Effective August 1, 2024)"
    },
    {
      "code" : "71",
      "display" : "Public Health Clinic",
      "definition" : "A facility maintained by either State or local health departments that provides ambulatory primary medical care under the general direction of a physician."
    },
    {
      "code" : "72",
      "display" : "Rural Health Clinic",
      "definition" : "A certified facility which is located in a rural medically underserved area that provides ambulatory primary medical care under the general direction of a physician."
    },
    {
      "code" : "81",
      "display" : "Independent Laboratory",
      "definition" : "A laboratory certified to perform diagnostic and/or clinical tests independent of an institution or a physician's office."
    },
    {
      "code" : "99",
      "display" : "Other Place of Service",
      "definition" : "Other place of service not identified above."
    }
  ]
}

```
