/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.PositiveForce;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealLine;
import net.sourceforge.plantuml.real.RealMoveable;
import net.sourceforge.plantuml.real.RealOrigin;

class RealImpl
extends RealMoveable
implements RealOrigin {
    private double currentValue;

    public RealImpl(String name, RealLine line, double currentValue) {
        super(line, name);
        this.currentValue = currentValue;
    }

    @Override
    void move(double delta) {
        this.currentValue += delta;
    }

    @Override
    double getCurrentValueInternal() {
        return this.currentValue;
    }

    @Override
    public Real addAtLeast(double delta) {
        RealImpl result = new RealImpl(this.getName() + ".addAtLeast" + delta, this.getLine(), this.currentValue + delta);
        this.getLine().addForce(new PositiveForce(this, result, delta));
        return result;
    }

    @Override
    public void ensureBiggerThan(Real other) {
        this.getLine().addForce(new PositiveForce(other, this, 0.0));
    }

    @Override
    public void compileNow() {
        this.getLine().compile();
    }
}

