# V3 Value Sets - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Value Sets**](valuesets.md)
* **V3 Value Sets**

## V3 Value Sets

 Value Sets defined and maintained by HL7 as part of the HL7 Version 3 family of International Standards. This has historically been published in the Version 3 coremif file format. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [v3-Abenakian](ValueSet-v3-Abenakian.md)
  * Name: Abenakian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AccessMedicalDev…](ValueSet-v3-AccessMedicalDevice.md)
  * Name: AccessMedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device used to allow access to a part of a body
* Identity: [v3-AcknowledgementC…](ValueSet-v3-AcknowledgementCondition.md)
  * Name: AcknowledgementCondition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Acknowledgement Condition codes describe the conditions under which accept or application level ack…
* Identity: [v3-AcknowledgementD…](ValueSet-v3-AcknowledgementDetailCode.md)
  * Name: AcknowledgementDetailCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A site specific problem code
* Identity: [v3-AcknowledgementD…](ValueSet-v3-AcknowledgementDetailNotSupportedCode.md)
  * Name: AcknowledgementDetailNotSupportedCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Refelects rejections because elements of the communication are not supported in the current context.
* Identity: [v3-AcknowledgementD…](ValueSet-v3-AcknowledgementDetailSyntaxErrorCode.md)
  * Name: AcknowledgementDetailSyntaxErrorCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Reflects errors in the syntax or structure of the communication.
* Identity: [v3-AcknowledgementD…](ValueSet-v3-AcknowledgementDetailType.md)
  * Name: AcknowledgementDetailType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code identifying the specific message to be provided.A textual value may be specified as the …
* Identity: [v3-AcknowledgementT…](ValueSet-v3-AcknowledgementType.md)
  * Name: AcknowledgementType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Acknowledgement code as described in HL7 message processing rules.
* Identity: [v3-ActAccommodation…](ValueSet-v3-ActAccommodationReason.md)
  * Name: ActAccommodationReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the reason the patient is assigned to this accommodation type
* Identity: [v3-ActAccountCode](ValueSet-v3-ActAccountCode.md)
  * Name: ActAccountCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An account represents a grouping of financial transactions that are tracked and reported together w…
* Identity: [v3-ActAdjudicationC…](ValueSet-v3-ActAdjudicationCode.md)
  * Name: ActAdjudicationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Includes coded responses that will occur as a result of the adjudication of an electronic invoice a…
* Identity: [v3-ActAdjudicationG…](ValueSet-v3-ActAdjudicationGroupCode.md)
  * Name: ActAdjudicationGroupCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Catagorization of grouping criteria for the associated transactions and/or summary (totals, subtota…
* Identity: [v3-ActAdjudicationR…](ValueSet-v3-ActAdjudicationResultActionCode.md)
  * Name: ActAdjudicationResultActionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Actions to be carried out by the recipient of the Adjudication Result information.
* Identity: [v3-ActAdministrativ…](ValueSet-v3-ActAdministrativeAuthorizationDetectedIssueCode.md)
  * Name: ActAdministrativeAuthorizationDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActAdministrativ…](ValueSet-v3-ActAdministrativeDetectedIssueCode.md)
  * Name: ActAdministrativeDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies types of detectyed issues for Act class "ALRT" for the administrative and patient admini…
* Identity: [v3-ActAdministrativ…](ValueSet-v3-ActAdministrativeDetectedIssueManagementCode.md)
  * Name: ActAdministrativeDetectedIssueManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes dealing with the management of Detected Issue observations for the administrative and patient…
* Identity: [v3-ActAdministrativ…](ValueSet-v3-ActAdministrativeRuleDetectedIssueCode.md)
  * Name: ActAdministrativeRuleDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActAmbulatoryEnc…](ValueSet-v3-ActAmbulatoryEncounterCode.md)
  * Name: ActAmbulatoryEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A comprehensive term for health care provided in a healthcare facility (e.g. a pract…
* Identity: [v3-ActAntigenInvali…](ValueSet-v3-ActAntigenInvalidReason.md)
  * Name: ActAntigenInvalidReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Coded reasons why an antigen is considered invalid.
* Identity: [v3-ActBillableModif…](ValueSet-v3-ActBillableModifierCode.md)
  * Name: ActBillableModifierCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An identifying modifier code for healthcare interventions or procedures.
* Identity: [v3-ActBillingArrang…](ValueSet-v3-ActBillingArrangementCode.md)
  * Name: ActBillingArrangementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The type of provision(s) made for reimbursing for the deliver of healthcare services and/or goods p…
* Identity: [v3-ActBoundedROICode](ValueSet-v3-ActBoundedROICode.md)
  * Name: ActBoundedROICode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of bounded ROI.
* Identity: [v3-ActCareProvision…](ValueSet-v3-ActCareProvisionCode.md)
  * Name: ActCareProvisionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The type and scope of responsibility taken-on by the performer of the Act for a spe…
* Identity: [v3-ActClaimAttachme…](ValueSet-v3-ActClaimAttachmentCategoryCode.md)
  * Name: ActClaimAttachmentCategoryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClass](ValueSet-v3-ActClass.md)
  * Name: ActClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the major type of Act that this Act-instance represents.**Constraints:**The cl…
* Identity: [v3-ActClassAccession](ValueSet-v3-ActClassAccession.md)
  * Name: ActClassAccession
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A unit of work, a grouper of work items as defined by the system performing that work. Typically so…
* Identity: [v3-ActClassAccommod…](ValueSet-v3-ActClassAccommodation.md)
  * Name: ActClassAccommodation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An accommodation is a service provided for a Person or other LivingSubject in which a place is prov…
* Identity: [v3-ActClassAccount](ValueSet-v3-ActClassAccount.md)
  * Name: ActClassAccount
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A financial account established to track the net result of financial acts.
* Identity: [v3-ActClassAcquisit…](ValueSet-v3-ActClassAcquisitionExposure.md)
  * Name: ActClassAcquisitionExposure
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An acquisition exposure act describes the proximity (location and time) throug…
* Identity: [v3-ActClassAction](ValueSet-v3-ActClassAction.md)
  * Name: ActClassAction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sender asks addressee to do something depending on the focal Act of the payload. An example is "ful…
* Identity: [v3-ActClassBattery](ValueSet-v3-ActClassBattery.md)
  * Name: ActClassBattery
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A battery specifies a set of observations. These observations typically have a logi…
* Identity: [v3-ActClassBioSeque…](ValueSet-v3-ActClassBioSequence.md)
  * Name: ActClassBioSequence
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A sequence of biomolecule like the DNA, RNA, protein and the like.
* Identity: [v3-ActClassBioSeque…](ValueSet-v3-ActClassBioSequenceVariation.md)
  * Name: ActClassBioSequenceVariation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A variation in a sequence as described by BioSequence.
* Identity: [v3-ActClassBoundedR…](ValueSet-v3-ActClassBoundedRoi.md)
  * Name: ActClassBoundedRoi
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A Region of Interest (ROI) specified for a multidimensional observation, such as an Observation Ser…
* Identity: [v3-ActClassCareProv…](ValueSet-v3-ActClassCareProvision.md)
  * Name: ActClassCareProvision
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An**Act**that of taking on whole or partial responsibility for, or attention to, safety and well-…
* Identity: [v3-ActClassCategory](ValueSet-v3-ActClassCategory.md)
  * Name: ActClassCategory
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A group of entries within a composition or topic that have a common characteristic - for example, E…
* Identity: [v3-ActClassCdaLevel…](ValueSet-v3-ActClassCdaLevelOneClinicalDocument.md)
  * Name: ActClassCdaLevelOneClinicalDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A clinical document that conforms to Level One of the HL7 Clinical Document Architecture (CDA)
* Identity: [v3-ActClassClinical…](ValueSet-v3-ActClassClinicalDocument.md)
  * Name: ActClassClinicalDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A clinical document is a documentation of clinical observations and services, with the following ch…
* Identity: [v3-ActClassClinical…](ValueSet-v3-ActClassClinicalTrial.md)
  * Name: ActClassClinicalTrial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The set of actions that define an experiment to assess the effectiveness and/or safety of a biophar…
* Identity: [v3-ActClassClinical…](ValueSet-v3-ActClassClinicalTrialTimepointEvent.md)
  * Name: ActClassClinicalTrialTimepointEvent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An identified point during a clinical trial at which one or more actions are scheduled to be perfor…
* Identity: [v3-ActClassCluster](ValueSet-v3-ActClassCluster.md)
  * Name: ActClassCluster
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A group of entries within a composition, topic or category that have a logical association with one…
* Identity: [v3-ActClassComposit…](ValueSet-v3-ActClassCompositeOrder.md)
  * Name: ActClassCompositeOrder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassComposit…](ValueSet-v3-ActClassComposition.md)
  * Name: ActClassComposition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A context representing a grouped commitment of information to the EHR. It is considered the unit of…
* Identity: [v3-ActClassConcern](ValueSet-v3-ActClassConcern.md)
  * Name: ActClassConcern
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassCondition](ValueSet-v3-ActClassCondition.md)
  * Name: ActClassCondition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observable finding or state that persists over time and tends to require intervention or managem…
* Identity: [v3-ActClassConsent](ValueSet-v3-ActClassConsent.md)
  * Name: ActClassConsent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The Consent class represents informed consents and all similar medico-legal transactions between th…
* Identity: [v3-ActClassContainer](ValueSet-v3-ActClassContainer.md)
  * Name: ActClassContainer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to group a set of acts sharing a common context. Container structures can nest within other co…
* Identity: [v3-ActClassContaine…](ValueSet-v3-ActClassContainerRegistration.md)
  * Name: ActClassContainerRegistration
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act where a container is registered either via an automated sensor, such as a barcode reader, or…
* Identity: [v3-ActClassContract](ValueSet-v3-ActClassContract.md)
  * Name: ActClassContract
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An agreement of obligation between two or more parties that is subject to contractual law and enfor…
* Identity: [v3-ActClassControlA…](ValueSet-v3-ActClassControlAct.md)
  * Name: ActClassControlAct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An act representing a system action such as the change of state of another act or the initiation of…
* Identity: [v3-ActClassCorrelat…](ValueSet-v3-ActClassCorrelatedObservationSequences.md)
  * Name: ActClassCorrelatedObservationSequences
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Container for Observation Sequences (Observations whose values are contained in LIST<>'s) having va…
* Identity: [v3-ActClassCoverage](ValueSet-v3-ActClassCoverage.md)
  * Name: ActClassCoverage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: When used in the EVN mood, this concept means with respect to a covered party:1. A health care…

* Identity: [v3-ActClassDetected…](ValueSet-v3-ActClassDetectedIssue.md)
  * Name: ActClassDetectedIssue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation identifying a potential adverse outcome as a result of an Act or combination of Acts…
* Identity: [v3-ActClassDetermin…](ValueSet-v3-ActClassDeterminantPeptide.md)
  * Name: ActClassDeterminantPeptide
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A determinant peptide in a polypeptide as described by polypeptide.
* Identity: [v3-ActClassDiagnost…](ValueSet-v3-ActClassDiagnosticImage.md)
  * Name: ActClassDiagnosticImage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Class for holding attributes unique to diagnostic images.
* Identity: [v3-ActClassDiet](ValueSet-v3-ActClassDiet.md)
  * Name: ActClassDiet
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassDiscipli…](ValueSet-v3-ActClassDisciplinaryAction.md)
  * Name: ActClassDisciplinaryAction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An action taken with respect to a subject Entity by a regulatory or authoritative body with supervi…
* Identity: [v3-ActClassDocument](ValueSet-v3-ActClassDocument.md)
  * Name: ActClassDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specialization of Act to add the characteristics unique to document management services.
* Identity: [v3-ActClassDocument…](ValueSet-v3-ActClassDocumentBody.md)
  * Name: ActClassDocumentBody
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A context that distinguishes the body of a document from the document header. This is seen, for ins…
* Identity: [v3-ActClassDocument…](ValueSet-v3-ActClassDocumentSection.md)
  * Name: ActClassDocumentSection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A context that subdivides the body of a document. Document sections are typically used for human na…
* Identity: [v3-ActClassElectron…](ValueSet-v3-ActClassElectronicHealthRecord.md)
  * Name: ActClassElectronicHealthRecord
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A context that comprises all compositions. The EHR is an extract that includes the entire chart.…
* Identity: [v3-ActClassEncounter](ValueSet-v3-ActClassEncounter.md)
  * Name: ActClassEncounter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An interaction between a patient and healthcare participant(s) for the purpose of providing patient…
* Identity: [v3-ActClassExposure](ValueSet-v3-ActClassExposure.md)
  * Name: ActClassExposure
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The action of coming into sufficient physical proximity to allow physical or chemical interaction. …
* Identity: [v3-ActClassExpressi…](ValueSet-v3-ActClassExpressionLevel.md)
  * Name: ActClassExpressionLevel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An expression level of genes/proteins or other expressed genomic entities.
* Identity: [v3-ActClassExtract](ValueSet-v3-ActClassExtract.md)
  * Name: ActClassExtract
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This context represents the part of a patient record conveyed in a single communication. It is draw…
* Identity: [v3-ActClassFinancia…](ValueSet-v3-ActClassFinancialAdjudication.md)
  * Name: ActClassFinancialAdjudication
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A transformation process where a requested invoice is transformed into an agreed invoice. Represent…
* Identity: [v3-ActClassFinancia…](ValueSet-v3-ActClassFinancialContract.md)
  * Name: ActClassFinancialContract
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A contract whose value is measured in monetary terms.
* Identity: [v3-ActClassFinancia…](ValueSet-v3-ActClassFinancialTransaction.md)
  * Name: ActClassFinancialTransaction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A sub-class of Act representing any transaction between two accounts whose value is measured in mon…
* Identity: [v3-ActClassFolder](ValueSet-v3-ActClassFolder.md)
  * Name: ActClassFolder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassGenomicO…](ValueSet-v3-ActClassGenomicObservation.md)
  * Name: ActClassGenomicObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An observation of genomic phenomena.
* Identity: [v3-ActClassGrouper](ValueSet-v3-ActClassGrouper.md)
  * Name: ActClassGrouper
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassIncident](ValueSet-v3-ActClassIncident.md)
  * Name: ActClassIncident
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An event that occurred outside of the control of one or more of the parties involved. Includes the …
* Identity: [v3-ActClassInform](ValueSet-v3-ActClassInform.md)
  * Name: ActClassInform
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The act of transmitting information and understanding about a topic to a subject where the particip…
* Identity: [v3-ActClassInformat…](ValueSet-v3-ActClassInformation.md)
  * Name: ActClassInformation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sender sends payload to addressee as information. Addressee does not have responsibilities beyond s…
* Identity: [v3-ActClassInvestig…](ValueSet-v3-ActClassInvestigation.md)
  * Name: ActClassInvestigation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An formalized inquiry into the circumstances surrounding a particular unplanned event or potential …
* Identity: [v3-ActClassInvoiceE…](ValueSet-v3-ActClassInvoiceElement.md)
  * Name: ActClassInvoiceElement
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Represents concepts related to invoice processing in health care
* Identity: [v3-ActClassJurisdic…](ValueSet-v3-ActClassJurisdictionalPolicy.md)
  * Name: ActClassJurisdictionalPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A mandate, regulation, obligation, requirement, rule, or expectation unilaterally i…
* Identity: [v3-ActClassLocus](ValueSet-v3-ActClassLocus.md)
  * Name: ActClassLocus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The position of a gene (or other significant sequence) on the genome.
* Identity: [v3-ActClassMonitori…](ValueSet-v3-ActClassMonitoringProgram.md)
  * Name: ActClassMonitoringProgram
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An officially or unofficially instituted program to track acts of a particular type or categorizati…
* Identity: [v3-ActClassObservat…](ValueSet-v3-ActClassObservation.md)
  * Name: ActClassObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An act that is intended to result in new information about a subject. The main diff…
* Identity: [v3-ActClassObservat…](ValueSet-v3-ActClassObservationSeries.md)
  * Name: ActClassObservationSeries
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Container for Correlated Observation Sequences sharing a common frame of reference. All Observation…
* Identity: [v3-ActClassOrganiza…](ValueSet-v3-ActClassOrganizationalPolicy.md)
  * Name: ActClassOrganizationalPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A mandate, obligation, requirement, rule, or expectation unilaterally imposed by an…
* Identity: [v3-ActClassOutbreak](ValueSet-v3-ActClassOutbreak.md)
  * Name: ActClassOutbreak
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An outbreak represents a series of public health cases. The date on which an outbreak starts is the…
* Identity: [v3-ActClassOutbreak2](ValueSet-v3-ActClassOutbreak2.md)
  * Name: ActClassOutbreak2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Outbreak is a concern resulting from a series of public health cases.
* Identity: [v3-ActClassOverlayR…](ValueSet-v3-ActClassOverlayRoi.md)
  * Name: ActClassOverlayRoi
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A Region of Interest (ROI) specified for an image using an overlay shape. Typically used to make re…
* Identity: [v3-ActClassPhenotype](ValueSet-v3-ActClassPhenotype.md)
  * Name: ActClassPhenotype
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A genomic phenomenon that is expressed externally in the organism.
* Identity: [v3-ActClassPolicy](ValueSet-v3-ActClassPolicy.md)
  * Name: ActClassPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A mandate, regulation, obligation, requirement, rule, or expectation unilaterally i…
* Identity: [v3-ActClassPolypept…](ValueSet-v3-ActClassPolypeptide.md)
  * Name: ActClassPolypeptide
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A polypeptide resulting from the translation of a gene.
* Identity: [v3-ActClassPosition](ValueSet-v3-ActClassPosition.md)
  * Name: ActClassPosition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation denoting the physical location of a person or thing based on a reference coordinate …
* Identity: [v3-ActClassPosition…](ValueSet-v3-ActClassPositionAccuracy.md)
  * Name: ActClassPositionAccuracy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An observation representing the degree to which the assignment of the spatial coord…
* Identity: [v3-ActClassPosition…](ValueSet-v3-ActClassPositionCoordinate.md)
  * Name: ActClassPositionCoordinate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An observation representing one of a set of numerical values used to determine the …
* Identity: [v3-ActClassProcedure](ValueSet-v3-ActClassProcedure.md)
  * Name: ActClassProcedure
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act whose immediate and primary outcome (post-condition) is the alteration of the physical condi…
* Identity: [v3-ActClassProcessS…](ValueSet-v3-ActClassProcessStep.md)
  * Name: ActClassProcessStep
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **ActCodeProcessStep**- Property applies to value sets that contain classCode values in structura…
* Identity: [v3-ActClassPublicHe…](ValueSet-v3-ActClassPublicHealthCase.md)
  * Name: ActClassPublicHealthCase
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A public health case is an Observation representing a condition or event that has a specific signif…
* Identity: [v3-ActClassPublicHe…](ValueSet-v3-ActClassPublicHealthCase2.md)
  * Name: ActClassPublicHealthCase2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A public health case is a Concern about an observation or event that has a specific significance fo…
* Identity: [v3-ActClassROI](ValueSet-v3-ActClassROI.md)
  * Name: ActClassROI
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Regions of Interest (ROI) within a subject Act. Primarily used for making secondary observations on…
* Identity: [v3-ActClassRecordOr…](ValueSet-v3-ActClassRecordOrganizer.md)
  * Name: ActClassRecordOrganizer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassRegistra…](ValueSet-v3-ActClassRegistration.md)
  * Name: ActClassRegistration
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Represents the act of maintaining information about the registration of its associated registered s…
* Identity: [v3-ActClassReview](ValueSet-v3-ActClassReview.md)
  * Name: ActClassReview
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The act of examining and evaluating the subject, usually another act. For example, "This prescripti…
* Identity: [v3-ActClassRoot](ValueSet-v3-ActClassRoot.md)
  * Name: ActClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A record of something that is being done, has been done, can be done, or is intended or requested t…
* Identity: [v3-ActClassScopeOfP…](ValueSet-v3-ActClassScopeOfPracticePolicy.md)
  * Name: ActClassScopeOfPracticePolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An ethical or clinical obligation, requirement, rule, or expectation imposed or str…
* Identity: [v3-ActClassSpecimen…](ValueSet-v3-ActClassSpecimenCollection.md)
  * Name: ActClassSpecimenCollection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A procedure for obtaining a specimen from a source entity.
* Identity: [v3-ActClassSpecimen…](ValueSet-v3-ActClassSpecimenObservation.md)
  * Name: ActClassSpecimenObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation on a specimen in a laboratory environment that may affect processing, analysis or re…
* Identity: [v3-ActClassSpecimen…](ValueSet-v3-ActClassSpecimenTreatment.md)
  * Name: ActClassSpecimenTreatment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A procedure or treatment performed on a specimen to prepare it for analysis
* Identity: [v3-ActClassStandard…](ValueSet-v3-ActClassStandardOfPracticePolicy.md)
  * Name: ActClassStandardOfPracticePolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A requirement, rule, or expectation typically documented as guidelines, protocols, …
* Identity: [v3-ActClassStateTra…](ValueSet-v3-ActClassStateTransitionControl.md)
  * Name: ActClassStateTransitionControl
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sender transmits a status change pertaining to the focal act of the payload. This status of the foc…
* Identity: [v3-ActClassStorage](ValueSet-v3-ActClassStorage.md)
  * Name: ActClassStorage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The act of putting something away for safe keeping. The "something" may be physical object such as …
* Identity: [v3-ActClassSubjectP…](ValueSet-v3-ActClassSubjectPhysicalPosition.md)
  * Name: ActClassSubjectPhysicalPosition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The spatial relationship of a subject whether human, other animal, or plant, to a frame of referenc…
* Identity: [v3-ActClassSubstanc…](ValueSet-v3-ActClassSubstanceAdministration.md)
  * Name: ActClassSubstanceAdministration
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The act of introducing or otherwise applying a substance to the subject.**Discussion:**The effec…
* Identity: [v3-ActClassSubstanc…](ValueSet-v3-ActClassSubstanceExtraction.md)
  * Name: ActClassSubstanceExtraction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActClassSubstitu…](ValueSet-v3-ActClassSubstitution.md)
  * Name: ActClassSubstitution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Definition: Indicates that the subject Act has undergone or should undergo substitution of a type i…
* Identity: [v3-ActClassSupply](ValueSet-v3-ActClassSupply.md)
  * Name: ActClassSupply
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Supply orders and deliveries are simple Acts that focus on the delivered product. The product is as…
* Identity: [v3-ActClassTopic](ValueSet-v3-ActClassTopic.md)
  * Name: ActClassTopic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A group of entries within a composition that are related to a common clinical theme - such as a spe…
* Identity: [v3-ActClassTransfer](ValueSet-v3-ActClassTransfer.md)
  * Name: ActClassTransfer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The act of transferring information without the intent of imparting understanding a…
* Identity: [v3-ActClassTransmis…](ValueSet-v3-ActClassTransmissionExposure.md)
  * Name: ActClassTransmissionExposure
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A transmission exposure act describes the proximity (time and location) over w…
* Identity: [v3-ActClassTranspor…](ValueSet-v3-ActClassTransportation.md)
  * Name: ActClassTransportation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transportation is the moving of a payload (people or material) from a location of origin to a desti…
* Identity: [v3-ActClassVerifica…](ValueSet-v3-ActClassVerification.md)
  * Name: ActClassVerification
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An act which describes the process whereby a 'verifying party' validates either the existence of th…
* Identity: [v3-ActClassWorkingL…](ValueSet-v3-ActClassWorkingList.md)
  * Name: ActClassWorkingList
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Working list collects a dynamic list of individual instances of Act via ActRelationship which refle…
* Identity: [v3-ActCode](ValueSet-v3-ActCode.md)
  * Name: v3 Code System ActCode
  * Version: 3.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2018-08-12
  * Description: A code specifying the particular kind of Act that the Act-instance represents within its class. Co…
* Identity: [v3-ActCodeProcessSt…](ValueSet-v3-ActCodeProcessStep.md)
  * Name: ActCodeProcessStep
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActConditionList](ValueSet-v3-ActConditionList.md)
  * Name: ActConditionList
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: List of condition observations.
* Identity: [v3-ActConsentDirect…](ValueSet-v3-ActConsentDirective.md)
  * Name: ActConsentDirective
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ActConsentDirective codes are used to specify the type of Consent Directive to which a Consent Dire…
* Identity: [v3-ActConsentDirect…](ValueSet-v3-ActConsentDirectiveType.md)
  * Name: ActConsentDirectiveType
  * Version: 3.0.0
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: ActConsentDirective and ActConsentType codes are used to specify the type of Consent Directive or C…
* Identity: [v3-ActConsentInform…](ValueSet-v3-ActConsentInformationAccessOverrideReason.md)
  * Name: ActConsentInformationAccessOverrideReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Use to convey the reason that a provider may or has accessed personal healthcare in…
* Identity: [v3-ActConsentType](ValueSet-v3-ActConsentType.md)
  * Name: ActConsentType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The type of consent directive, e.g., to consent or dissent to collect, access, or u…
* Identity: [v3-ActContainerRegi…](ValueSet-v3-ActContainerRegistrationCode.md)
  * Name: ActContainerRegistrationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Constrains the ActCode to the domain of Container Registration
* Identity: [v3-ActControlVariab…](ValueSet-v3-ActControlVariable.md)
  * Name: ActControlVariable
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation form that determines parameters or attributes of an Act. Examples are the settings o…
* Identity: [v3-ActCoverageAsses…](ValueSet-v3-ActCoverageAssessmentObservationValue.md)
  * Name: ActCoverageAssessmentObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes specify the category of observation, evidence, or document used to assess for services, e.g.,…
* Identity: [v3-ActCoverageAutho…](ValueSet-v3-ActCoverageAuthorizationConfirmationCode.md)
  * Name: ActCoverageAuthorizationConfirmationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indication of authorization for healthcare service(s) and/or product(s). If authorization is approv…
* Identity: [v3-ActCoverageConfi…](ValueSet-v3-ActCoverageConfirmationCode.md)
  * Name: ActCoverageConfirmationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Response to an insurance coverage eligibility query or authorization request.
* Identity: [v3-ActCoverageLimit…](ValueSet-v3-ActCoverageLimitCode.md)
  * Name: ActCoverageLimitCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Criteria that are applicable to the authorized coverage.
* Identity: [v3-ActCoverageMaxim…](ValueSet-v3-ActCoverageMaximaCodes.md)
  * Name: ActCoverageMaximaCodes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Codes representing the maximum coverate or financial participation requirements.
* Identity: [v3-ActCoverageQuant…](ValueSet-v3-ActCoverageQuantityLimitCode.md)
  * Name: ActCoverageQuantityLimitCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Maximum amount paid or maximum number of services/products covered; or maximum amount or number cov…
* Identity: [v3-ActCoverageReason](ValueSet-v3-ActCoverageReason.md)
  * Name: ActCoverageReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Codes used to specify reasons or criteria relating to coverage provided under a pol…
* Identity: [v3-ActCoverageTypeC…](ValueSet-v3-ActCoverageTypeCode.md)
  * Name: ActCoverageTypeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the type of insurance policy or program that pays for the c…
* Identity: [v3-ActCredentialedC…](ValueSet-v3-ActCredentialedCareCode.md)
  * Name: ActCredentialedCareCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The type and scope of legal and/or professional responsibility taken-on by the perf…
* Identity: [v3-ActCredentialedC…](ValueSet-v3-ActCredentialedCareProvisionPersonCode.md)
  * Name: ActCredentialedCareProvisionPersonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The type and scope of legal and/or professional responsibility taken-on by the perf…
* Identity: [v3-ActCredentialedC…](ValueSet-v3-ActCredentialedCareProvisionProgramCode.md)
  * Name: ActCredentialedCareProvisionProgramCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The type and scope of legal and/or professional responsibility taken-on by the perf…
* Identity: [v3-ActDetectedIssue…](ValueSet-v3-ActDetectedIssueCode.md)
  * Name: ActDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies types of detected issues for Act class "ALRT"
* Identity: [v3-ActDetectedIssue…](ValueSet-v3-ActDetectedIssueManagementCode.md)
  * Name: ActDetectedIssueManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes dealing with the management of Detected Issue observations
* Identity: [v3-ActDietCode](ValueSet-v3-ActDietCode.md)
  * Name: ActDietCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code set to define specialized/allowed diets
* Identity: [v3-ActEmergencyEnco…](ValueSet-v3-ActEmergencyEncounterCode.md)
  * Name: ActEmergencyEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A patient encounter that takes place at a dedicated healthcare service delivery loca…
* Identity: [v3-ActEncounterAcco…](ValueSet-v3-ActEncounterAccommodationCode.md)
  * Name: ActEncounterAccommodationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Accommodation type. In Intent mood, represents the accommodation type requested. In Event mood, rep…
* Identity: [v3-ActEncounterCode](ValueSet-v3-ActEncounterCode.md)
  * Name: ActEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Domain provides codes that qualify the ActEncounterClass (ENC)
* Identity: [v3-ActExposureCode](ValueSet-v3-ActExposureCode.md)
  * Name: ActExposureCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Concepts that identify the type or nature of exposure interaction. Examples include "household", "c…
* Identity: [v3-ActExposureLevel…](ValueSet-v3-ActExposureLevelCode.md)
  * Name: ActExposureLevelCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A qualitative measure of the degree of exposure to the causative agent. This includes concepts such…
* Identity: [v3-ActFieldEncounte…](ValueSet-v3-ActFieldEncounterCode.md)
  * Name: ActFieldEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A patient encounter that takes place both outside a dedicated service delivery locat…
* Identity: [v3-ActFinancialStat…](ValueSet-v3-ActFinancialStatusObservationValue.md)
  * Name: ActFinancialStatusObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying financial indicators used to assess or establish eligibility for coverage under a p…
* Identity: [v3-ActFinancialTran…](ValueSet-v3-ActFinancialTransactionCode.md)
  * Name: ActFinancialTransactionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActHealthInforma…](ValueSet-v3-ActHealthInformationManagementReason.md)
  * Name: ActHealthInformationManagementReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The rationale or purpose for an act relating to health information management, such as archiving in…
* Identity: [v3-ActHealthInsuran…](ValueSet-v3-ActHealthInsuranceTypeCode.md)
  * Name: ActHealthInsuranceTypeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the type of health insurance policy that covers health serv…
* Identity: [v3-ActHomeHealthEnc…](ValueSet-v3-ActHomeHealthEncounterCode.md)
  * Name: ActHomeHealthEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Healthcare encounter that takes place in the residence of the patient or a designee
* Identity: [v3-ActIncidentCode](ValueSet-v3-ActIncidentCode.md)
  * Name: ActIncidentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Set of codes indicating the type of incident or accident.
* Identity: [v3-ActIneligibility…](ValueSet-v3-ActIneligibilityReason.md)
  * Name: ActIneligibilityReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the reason or rational for why a person is not eligibile for benefits under an insurance…
* Identity: [v3-ActInformationAc…](ValueSet-v3-ActInformationAccess.md)
  * Name: ActInformationAccess
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Consent to access healthcare information.
* Identity: [v3-ActInformationAc…](ValueSet-v3-ActInformationAccessCode.md)
  * Name: ActInformationAccessCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The type of personal health information to which the subject of the information, or the delegate of…
* Identity: [v3-ActInformationAc…](ValueSet-v3-ActInformationAccessContextCode.md)
  * Name: ActInformationAccessContextCode
  * Version: 3.0.0
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Conveyance of the type of context in which authorization given under jurisdictional law, by organiz…
* Identity: [v3-ActInformationCa…](ValueSet-v3-ActInformationCategoryCode.md)
  * Name: ActInformationCategoryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Indicates the set of information types which may be manipulated or referenced, such …
* Identity: [v3-ActInformationSe…](ValueSet-v3-ActInformationSensitivityPolicy.md)
  * Name: ActInformationSensitivityPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ActSensitivity codes are used to bind information to an Act.confidentialityCode according to local …
* Identity: [v3-ActInformationTr…](ValueSet-v3-ActInformationTransferCode.md)
  * Name: ActInformationTransferCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Conveyance of the type of information transfer protocol.
* Identity: [v3-ActInjuryCodeCSA](ValueSet-v3-ActInjuryCodeCSA.md)
  * Name: ActInjuryCodeCSA
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActInpatientEnco…](ValueSet-v3-ActInpatientEncounterCode.md)
  * Name: ActInpatientEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An inpatient encounter is an encounter in which the patient is admitted to a hospital or equivalent…
* Identity: [v3-ActInsurancePoli…](ValueSet-v3-ActInsurancePolicyCode.md)
  * Name: ActInsurancePolicyCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Set of codes indicating the type of insurance policy or other source of funds to cover healthcare c…
* Identity: [v3-ActInsuranceType…](ValueSet-v3-ActInsuranceTypeCode.md)
  * Name: ActInsuranceTypeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the type of insurance policy. Insurance, in law and economi…
* Identity: [v3-ActInvoiceAdjudi…](ValueSet-v3-ActInvoiceAdjudicationPaymentCode.md)
  * Name: ActInvoiceAdjudicationPaymentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing a grouping of invoice elements (totals, sub-totals), reported through a Payment …
* Identity: [v3-ActInvoiceAdjudi…](ValueSet-v3-ActInvoiceAdjudicationPaymentGroupCode.md)
  * Name: ActInvoiceAdjudicationPaymentGroupCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing adjustments to a Payment Advice such as retroactive, clawback, garnishee, etc.
* Identity: [v3-ActInvoiceAdjudi…](ValueSet-v3-ActInvoiceAdjudicationPaymentSummaryCode.md)
  * Name: ActInvoiceAdjudicationPaymentSummaryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing a grouping of invoice elements (totals, sub-totals), reported through a Payment …
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailClinicalProductCode.md)
  * Name: ActInvoiceDetailClinicalProductCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An identifying data string for healthcare products.
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailCode.md)
  * Name: ActInvoiceDetailCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing a service or product that is being invoiced (billed). The code can represent suc…
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailDrugProductCode.md)
  * Name: ActInvoiceDetailDrugProductCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An identifying data string for A substance used as a medication or in the preparation of medication.
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailGenericAdjudicatorCode.md)
  * Name: ActInvoiceDetailGenericAdjudicatorCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable item codes to identify adjudicator specified components to the total billing of a clai…
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailGenericCode.md)
  * Name: ActInvoiceDetailGenericCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The detail item codes to identify charges or changes to the total billing of a claim due to insuran…
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailGenericModifierCode.md)
  * Name: ActInvoiceDetailGenericModifierCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable item codes to identify modifications to a billable item charge. As for example after h…
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailGenericProviderCode.md)
  * Name: ActInvoiceDetailGenericProviderCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable item codes to identify provider supplied charges or changes to the total billing of a …
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailPreferredAccommodationCode.md)
  * Name: ActInvoiceDetailPreferredAccommodationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An identifying data string for medical facility accommodations.
* Identity: [v3-ActInvoiceDetail…](ValueSet-v3-ActInvoiceDetailTaxCode.md)
  * Name: ActInvoiceDetailTaxCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable item codes to identify modifications to a billable item charge by a tax factor applied…
* Identity: [v3-ActInvoiceElemen…](ValueSet-v3-ActInvoiceElementCode.md)
  * Name: ActInvoiceElementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of invoice element that is used to assist in describing an Invoice that is either submitted fo…
* Identity: [v3-ActInvoiceElemen…](ValueSet-v3-ActInvoiceElementModifier.md)
  * Name: ActInvoiceElementModifier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Processing consideration and clarification codes.
* Identity: [v3-ActInvoiceElemen…](ValueSet-v3-ActInvoiceElementSummaryCode.md)
  * Name: ActInvoiceElementSummaryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the different types of summary information that can be reported by queries dealing with …
* Identity: [v3-ActInvoiceGroupC…](ValueSet-v3-ActInvoiceGroupCode.md)
  * Name: ActInvoiceGroupCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of invoice element that is used to assist in describing an Invoice that is either submitted fo…
* Identity: [v3-ActInvoiceInterG…](ValueSet-v3-ActInvoiceInterGroupCode.md)
  * Name: ActInvoiceInterGroupCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of invoice element that is used to assist in describing an Invoice that is either submitted fo…
* Identity: [v3-ActInvoiceOverri…](ValueSet-v3-ActInvoiceOverrideCode.md)
  * Name: ActInvoiceOverrideCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Includes coded responses that will occur as a result of the adjudication of an electronic invoice a…
* Identity: [v3-ActInvoicePaymen…](ValueSet-v3-ActInvoicePaymentCode.md)
  * Name: ActInvoicePaymentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActInvoiceRootGr…](ValueSet-v3-ActInvoiceRootGroupCode.md)
  * Name: ActInvoiceRootGroupCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of invoice element that is used to assist in describing an Invoice that is either submitted fo…
* Identity: [v3-ActListCode](ValueSet-v3-ActListCode.md)
  * Name: ActListCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Provides codes associated with ActClass value of LIST (working list)
* Identity: [v3-ActMedicalServic…](ValueSet-v3-ActMedicalServiceCode.md)
  * Name: ActMedicalServiceCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: General category of medical service provided to the patient during their encounter.
* Identity: [v3-ActMedicationList](ValueSet-v3-ActMedicationList.md)
  * Name: ActMedicationList
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: List of medications.
* Identity: [v3-ActMedicationThe…](ValueSet-v3-ActMedicationTherapyDurationWorkingListCode.md)
  * Name: ActMedicationTherapyDurationWorkingListCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActMonitoringPro…](ValueSet-v3-ActMonitoringProtocolCode.md)
  * Name: ActMonitoringProtocolCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies types of monitoring programs
* Identity: [v3-ActMood](ValueSet-v3-ActMood.md)
  * Name: ActMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code distinguishing whether an Act is conceived of as a factual statement or in some other manner…
* Identity: [v3-ActMoodActRequest](ValueSet-v3-ActMoodActRequest.md)
  * Name: ActMoodActRequest
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActMoodAppointme…](ValueSet-v3-ActMoodAppointment.md)
  * Name: ActMoodAppointment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A planned Act for a specific time and place.
* Identity: [v3-ActMoodAppointme…](ValueSet-v3-ActMoodAppointmentRequest.md)
  * Name: ActMoodAppointmentRequest
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A request for the booking of an appointment.
* Identity: [v3-ActMoodCompletio…](ValueSet-v3-ActMoodCompletionTrack.md)
  * Name: ActMoodCompletionTrack
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These are moods describing activities as they progress in the business cycle, from defined, through…
* Identity: [v3-ActMoodCriterion](ValueSet-v3-ActMoodCriterion.md)
  * Name: ActMoodCriterion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A criterion or condition over actual and potential services that must apply for an associated servi…
* Identity: [v3-ActMoodDefinition](ValueSet-v3-ActMoodDefinition.md)
  * Name: ActMoodDefinition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A definition of a service (master).Historical note: in previous RIM versions, the definition mo…
* Identity: [v3-ActMoodDesire](ValueSet-v3-ActMoodDesire.md)
  * Name: ActMoodDesire
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActMoodEventCrit…](ValueSet-v3-ActMoodEventCriterion.md)
  * Name: ActMoodEventCriterion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A criterion or condition over service events that must apply for an associated service to be consid…
* Identity: [v3-ActMoodEventOccu…](ValueSet-v3-ActMoodEventOccurrence.md)
  * Name: ActMoodEventOccurrence
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A service that actually happens, may be an ongoing service or a documentation of a past service.…
* Identity: [v3-ActMoodExpectati…](ValueSet-v3-ActMoodExpectation.md)
  * Name: ActMoodExpectation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An act that is considered likely to occur in the future. The essential feature of an…
* Identity: [v3-ActMoodGoal](ValueSet-v3-ActMoodGoal.md)
  * Name: ActMoodGoal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An observation that is considered to be desirable to occur in the future. The essent…
* Identity: [v3-ActMoodIntent](ValueSet-v3-ActMoodIntent.md)
  * Name: ActMoodIntent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An intention or plan to perform a service. Historical note: in previous RIM versions, the intent mo…
* Identity: [v3-ActMoodOption](ValueSet-v3-ActMoodOption.md)
  * Name: ActMoodOption
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An option is an alternative set of property-value bindings. Options specify alternative sets of val…
* Identity: [v3-ActMoodPermission](ValueSet-v3-ActMoodPermission.md)
  * Name: ActMoodPermission
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A kind of service which is authorized to be performed.
* Identity: [v3-ActMoodPermissio…](ValueSet-v3-ActMoodPermissionRequest.md)
  * Name: ActMoodPermissionRequest
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A request for authorization to perform a kind of service.This is distinct from RQO which is a r…
* Identity: [v3-ActMoodPotential](ValueSet-v3-ActMoodPotential.md)
  * Name: ActMoodPotential
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActMoodPredicate](ValueSet-v3-ActMoodPredicate.md)
  * Name: ActMoodPredicate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Any of the above service moods (e.g., event, intent, or goal) can be turned into a predicate used a…
* Identity: [v3-ActMoodPromise](ValueSet-v3-ActMoodPromise.md)
  * Name: ActMoodPromise
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An intent to perform a service that has the strength of a commitment, i.e., other parties may rely …
* Identity: [v3-ActMoodProposal](ValueSet-v3-ActMoodProposal.md)
  * Name: ActMoodProposal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A non-mandated intent to perform an act. Used to record intents that are explicitly not Orders. Pro…
* Identity: [v3-ActMoodRecommend…](ValueSet-v3-ActMoodRecommendation.md)
  * Name: ActMoodRecommendation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A non-mandated intent to perform an act where a level of professional responsibility is being accep…
* Identity: [v3-ActMoodRequest](ValueSet-v3-ActMoodRequest.md)
  * Name: ActMoodRequest
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A request or order for a service is an intent directed from a placer (request author) to a fulfille…
* Identity: [v3-ActMoodResourceS…](ValueSet-v3-ActMoodResourceSlot.md)
  * Name: ActMoodResourceSlot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Periods of time on a schedule for a resource. Appointments occupy sets of one or more booked slots.…
* Identity: [v3-ActMoodRisk](ValueSet-v3-ActMoodRisk.md)
  * Name: ActMoodRisk
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An act that may occur in the future and which is regarded as undesirable. The essent…
* Identity: [v3-ActNoImmunizatio…](ValueSet-v3-ActNoImmunizationReason.md)
  * Name: ActNoImmunizationReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A coded description of the reason for why a patient did not receive a scheduled immunization.(i…
* Identity: [v3-ActNonObservatio…](ValueSet-v3-ActNonObservationIndicationCode.md)
  * Name: ActNonObservationIndicationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Concepts representing indications (reasons for clinical action) other than diagnosi…
* Identity: [v3-ActObservationLi…](ValueSet-v3-ActObservationList.md)
  * Name: ActObservationList
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActObservationVe…](ValueSet-v3-ActObservationVerificationType.md)
  * Name: ActObservationVerificationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the type of verification investigation being undertaken with respect to the subject of t…
* Identity: [v3-ActPatientAnnota…](ValueSet-v3-ActPatientAnnotationType.md)
  * Name: ActPatientAnnotationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Provides a categorization for annotations recorded directly against the patient
* Identity: [v3-ActPatientTransp…](ValueSet-v3-ActPatientTransportationModeCode.md)
  * Name: ActPatientTransportationModeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Definition: Characterizes how a patient was or will be transported to the site of a patient encount…
* Identity: [v3-ActPaymentCode](ValueSet-v3-ActPaymentCode.md)
  * Name: ActPaymentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code identifying the method or the movement of payment instructions.Codes are drawn from X12 da…
* Identity: [v3-ActPharmacySuppl…](ValueSet-v3-ActPharmacySupplyType.md)
  * Name: ActPharmacySupplyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies types of dispensing events
* Identity: [v3-ActPolicyType](ValueSet-v3-ActPolicyType.md)
  * Name: ActPolicyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Types of policies that further specify the ActClassPolicy value set.
* Identity: [v3-ActPriority](ValueSet-v3-ActPriority.md)
  * Name: ActPriority
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code or set of codes (e.g., for routine, emergency,) specifying the urgency under which the Act h…
* Identity: [v3-ActPriorityCallb…](ValueSet-v3-ActPriorityCallback.md)
  * Name: ActPriorityCallback
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Filler should contact the placer (or target) to schedule the service. (Was "C" in HL7 version 2.3's…
* Identity: [v3-ActPrivacyLaw](ValueSet-v3-ActPrivacyLaw.md)
  * Name: ActPrivacyLaw
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ActPrivacyLaw codes may be associated with an Act or a Role to indicate the legal provision to whic…
* Identity: [v3-ActPrivacyPolicy](ValueSet-v3-ActPrivacyPolicy.md)
  * Name: ActPrivacyPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ActPrivacyPolicyType codes support the designation of the 1..* policies that are applicable to an …
* Identity: [v3-ActProductAcquis…](ValueSet-v3-ActProductAcquisitionCode.md)
  * Name: ActProductAcquisitionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The method that a product is obtained for use by the subject of the supply act (e.g. patient). Prod…
* Identity: [v3-ActProgramTypeCo…](ValueSet-v3-ActProgramTypeCode.md)
  * Name: ActProgramTypeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A set of codes used to indicate coverage under a program. A program is an organized…
* Identity: [v3-ActReason](ValueSet-v3-ActReason.md)
  * Name: v3 Code System ActReason
  * Version: 3.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2018-08-12
  * Description: A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is no…
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAccounting.md)
  * Name: ActRelationshipAccounting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes that describe the relationship between an Act and a financial instrument such as a financial …
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipActProvenance.md)
  * Name: ActRelationshipActProvenance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Used to convey the relationship between two or more Acts for purpose of tracking provenance relatio…
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipActiveImmunizationAgainst.md)
  * Name: ActRelationshipActiveImmunizationAgainst
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAdjunctCurativeIndication.md)
  * Name: ActRelationshipAdjunctCurativeIndication
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAdjunctMitigation.md)
  * Name: ActRelationshipAdjunctMitigation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAdjunctiveTreatment.md)
  * Name: ActRelationshipAdjunctiveTreatment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipArrival.md)
  * Name: ActRelationshipArrival
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The relationship that links to a Transportation Act (target) from another Act (source) indicating t…
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAssignsName.md)
  * Name: ActRelationshipAssignsName
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to assign a "name" to a condition thread. Source is a condition node, target can be any servic…
* Identity: [v3-ActRelationshipA…](ValueSet-v3-ActRelationshipAuthorizedBy.md)
  * Name: ActRelationshipAuthorizedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the target act authorizes or certifies the source act.
* Identity: [v3-ActRelationshipB…](ValueSet-v3-ActRelationshipBlocks.md)
  * Name: ActRelationshipBlocks
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The source act is performed to block the effects of the target act. This act relati…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpoint.md)
  * Name: ActRelationshipCheckpoint
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., befor…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpointBeginning.md)
  * Name: ActRelationshipCheckpointBeginning
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Condition is tested every time before execution of the service (WHILE condition DO service).
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpointEnd.md)
  * Name: ActRelationshipCheckpointEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Condition is tested at the end of a repeated service execution. The service is repeated only if the…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpointEntry.md)
  * Name: ActRelationshipCheckpointEntry
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Condition is tested once before the service is executed (IF condition THEN service).
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpointExit.md)
  * Name: ActRelationshipCheckpointExit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Condition is a loop checkpoint, i.e. it is a step of an activity plan and, if negative causes the c…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCheckpointThrough.md)
  * Name: ActRelationshipCheckpointThrough
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Condition must be true throughout the execution and the service is interrupted (asynchronously) as …
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCompliesWith.md)
  * Name: ActRelationshipCompliesWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipConcurrentWith.md)
  * Name: ActRelationshipConcurrentWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipConditional.md)
  * Name: ActRelationshipConditional
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specifies under what circumstances (target Act) the source-Act may, must, must not or has occurred
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipContainsEndOf.md)
  * Name: ActRelationshipContainsEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipContainsStartOf.md)
  * Name: ActRelationshipContainsStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipContainsStartOfEndsBeforeEndOf.md)
  * Name: ActRelationshipContainsStartOfEndsBeforeEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipContainsTimeOf.md)
  * Name: ActRelationshipContainsTimeOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCostTracking.md)
  * Name: ActRelationshipCostTracking
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Expresses values for describing the relationship relationship between an InvoiceElement or InvoiceE…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCoveredBy.md)
  * Name: ActRelationshipCoveredBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the source act is covered by or is under the authority of a target act. A f…
* Identity: [v3-ActRelationshipC…](ValueSet-v3-ActRelationshipCurativeIndication.md)
  * Name: ActRelationshipCurativeIndication
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDeparture.md)
  * Name: ActRelationshipDeparture
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The relationship that links to a Transportation Act (target) from another Act (source) indicating t…
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDiagnosis.md)
  * Name: ActRelationshipDiagnosis
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDocumentHQMF.md)
  * Name: ActRelationshipDocumentHQMF
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: The reasons that may be used when relating a Quality Measure Document to other document types.
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDocumentProvenance.md)
  * Name: ActRelationshipDocumentProvenance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Used to convey the relationship between two or more Documents for purpose of tracking provenance re…
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDocuments.md)
  * Name: ActRelationshipDocuments
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source act documents the target act.
* Identity: [v3-ActRelationshipD…](ValueSet-v3-ActRelationshipDuring.md)
  * Name: ActRelationshipDuring
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsAfterEndOf.md)
  * Name: ActRelationshipEndsAfterEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithEndOf.md)
  * Name: ActRelationshipEndsAfterOrConcurrentWithEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithStartOf.md)
  * Name: ActRelationshipEndsAfterOrConcurrentWithStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsAfterStartOf.md)
  * Name: ActRelationshipEndsAfterStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsBeforeEnd.md)
  * Name: ActRelationshipEndsBeforeEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Act ends after the end of the target Act (i.e. if we say "ActOne EBE ActTwo", it means t…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithEndOf.md)
  * Name: ActRelationshipEndsBeforeOrConcurrentWithEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithStartOf.md)
  * Name: ActRelationshipEndsBeforeOrConcurrentWithStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsBeforeStartOf.md)
  * Name: ActRelationshipEndsBeforeStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsConcurrentWith.md)
  * Name: ActRelationshipEndsConcurrentWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsConcurrentWithStart.md)
  * Name: ActRelationshipEndsConcurrentWithStart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Act ends when the target act starts (i.e. if we say "ActOne ECWS ActTwo", it means that …
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsDuring.md)
  * Name: ActRelationshipEndsDuring
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsNearEnd.md)
  * Name: ActRelationshipEndsNearEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEndsNearStarts.md)
  * Name: ActRelationshipEndsNearStarts
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEpisodelink.md)
  * Name: ActRelationshipEpisodelink
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Expresses an association that links two instances of the same act over time, indicating that the in…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipEvaluatesGoal.md)
  * Name: ActRelationshipEvaluatesGoal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A goal-evaluation links an observation (intent or actual) to a goal to indicate that the observatio…
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipExacerbatredBy.md)
  * Name: ActRelationshipExacerbatredBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipExcerpt.md)
  * Name: ActRelationshipExcerpt
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source is an excerpt from the target.
* Identity: [v3-ActRelationshipE…](ValueSet-v3-ActRelationshipExcerptVerbatim.md)
  * Name: ActRelationshipExcerptVerbatim
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source is a direct quote from the target.
* Identity: [v3-ActRelationshipF…](ValueSet-v3-ActRelationshipFulfills.md)
  * Name: ActRelationshipFulfills
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source act fulfills (in whole or in part) the target act. Source act must be in a mood equal or…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasBaseline.md)
  * Name: ActRelationshipHasBaseline
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasBoundedSupport.md)
  * Name: ActRelationshipHasBoundedSupport
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A specialization of "has support" (SPRT), used to relate a secondary observation to a Region of Int…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasCharge.md)
  * Name: ActRelationshipHasCharge
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship that provides an ability to associate a financial transaction (target) as a charge t…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasComponent.md)
  * Name: ActRelationshipHasComponent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A collection of sub-services as steps or subtasks performed for the source service. Services may be…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasContinuingObjective.md)
  * Name: ActRelationshipHasContinuingObjective
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A desired state that a service action aims to maintain. E.g., keep systolic blood pressure between …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasContra-indication.md)
  * Name: ActRelationshipHasContra-indication
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A contraindication is just a negation of a reason, i.e. it gives a condition under which the action…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasControlVariable.md)
  * Name: ActRelationshipHasControlVariable
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship from an Act to a Control Variable. For example, if a Device makes an Observation, th…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasCost.md)
  * Name: ActRelationshipHasCost
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship that provides an ability to associate a financial transaction (target) as a cost to …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasCredit.md)
  * Name: ActRelationshipHasCredit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A credit relationship ties a financial transaction (target) to an account (source). A credit, once …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasDebit.md)
  * Name: ActRelationshipHasDebit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A debit relationship ties a financial transaction (target) to an account (source). A debit, once ap…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasExplanation.md)
  * Name: ActRelationshipHasExplanation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This is the inversion of support. Used to indicate that a given observation is explained by another…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasFinalObjective.md)
  * Name: ActRelationshipHasFinalObjective
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A desired outcome that a service action aims to meet finally. Source is any service (typically an i…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasGeneralization.md)
  * Name: ActRelationshipHasGeneralization
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The generalization relationship can be used to express categorical knowledge about services (e.g., …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasGoal.md)
  * Name: ActRelationshipHasGoal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A goal that one defines given a patient's health condition. Subsequently planned actions aim to mee…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasMember.md)
  * Name: ActRelationshipHasMember
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasMetadata.md)
  * Name: ActRelationshipHasMetadata
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasOption.md)
  * Name: ActRelationshipHasOption
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between a source Act that provides more detailed properties to the target Act.Th…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasPart.md)
  * Name: ActRelationshipHasPart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasPre-condition.md)
  * Name: ActRelationshipHasPre-condition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A requirement to be true before a service is performed. The target can be any service in criterion …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasPreviousInstance.md)
  * Name: ActRelationshipHasPreviousInstance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the target act is a predecessor instance to the source act. Generally each …
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasQualifier.md)
  * Name: ActRelationshipHasQualifier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasReferenceValues.md)
  * Name: ActRelationshipHasReferenceValues
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Reference ranges are essentially descriptors of a class of result values assumed to be "normal", "a…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasRisk.md)
  * Name: ActRelationshipHasRisk
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A noteworthy undesired outcome of a patient's condition that is either likely enough to become an i…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasStep.md)
  * Name: ActRelationshipHasStep
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasSubject.md)
  * Name: ActRelationshipHasSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates an Act to its subject Act that the first Act is primarily concerned with.Examples1.…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasSupport.md)
  * Name: ActRelationshipHasSupport
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to indicate that an existing service is suggesting evidence for a new observation. The assumpt…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasTrigger.md)
  * Name: ActRelationshipHasTrigger
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A pre-condition that if true should result in the source Act being executed. The target is in typic…
* Identity: [v3-ActRelationshipH…](ValueSet-v3-ActRelationshipHasValue.md)
  * Name: ActRelationshipHasValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipICSRInvestigation.md)
  * Name: ActRelationshipICSRInvestigation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The ways that product safety Investigations, about which information is captured i…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipImmunizationAgainst.md)
  * Name: ActRelationshipImmunizationAgainst
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipIndependentOfTimeOf.md)
  * Name: ActRelationshipIndependentOfTimeOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipInstantiatesMaster.md)
  * Name: ActRelationshipInstantiatesMaster
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to capture the link between a potential service ("master" or plan) and an actual service, wher…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipInterferedBy.md)
  * Name: ActRelationshipInterferedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipIsAppendage.md)
  * Name: ActRelationshipIsAppendage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An addendum (source) to an existing service object (target), containing supplemental information. T…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipIsDerivedFrom.md)
  * Name: ActRelationshipIsDerivedFrom
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Associates a derived Act with its input parameters. E.G., an anion-gap observation can be associate…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipIsEtiologyFor.md)
  * Name: ActRelationshipIsEtiologyFor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An assertion that a new observation was assumed to be the cause for another existing observation. T…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipIsManifestationOf.md)
  * Name: ActRelationshipIsManifestationOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An assertion that a new observation may be the manifestation of another existing observation or act…
* Identity: [v3-ActRelationshipI…](ValueSet-v3-ActRelationshipItemsLocated.md)
  * Name: ActRelationshipItemsLocated
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Items located
* Identity: [v3-ActRelationshipJ…](ValueSet-v3-ActRelationshipJoin.md)
  * Name: ActRelationshipJoin
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying how concurrent Acts are resynchronized in a parallel branch construct.*Discus…
* Identity: [v3-ActRelationshipJ…](ValueSet-v3-ActRelationshipJoinDetached.md)
  * Name: ActRelationshipJoinDetached
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Detach this branch from the other branches so it will not be resynchronized with the other branches.
* Identity: [v3-ActRelationshipJ…](ValueSet-v3-ActRelationshipJoinExclusiveWait.md)
  * Name: ActRelationshipJoinExclusiveWait
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Wait for any one of the branches in the set of exclusive wait branches to terminate, then discontin…
* Identity: [v3-ActRelationshipJ…](ValueSet-v3-ActRelationshipJoinKill.md)
  * Name: ActRelationshipJoinKill
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: When all other concurrent branches are terminated, interrupt and discontinue this branch.
* Identity: [v3-ActRelationshipJ…](ValueSet-v3-ActRelationshipJoinWait.md)
  * Name: ActRelationshipJoinWait
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Wait for this branch to terminate.
* Identity: [v3-ActRelationshipL…](ValueSet-v3-ActRelationshipLimitedBy.md)
  * Name: ActRelationshipLimitedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship that limits or restricts the source act by the elements of the target act. For examp…
* Identity: [v3-ActRelationshipM…](ValueSet-v3-ActRelationshipMaintenanceTreatment.md)
  * Name: ActRelationshipMaintenanceTreatment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipM…](ValueSet-v3-ActRelationshipMatchesTrigger.md)
  * Name: ActRelationshipMatchesTrigger
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A trigger-match links an actual service (e.g., an observation or procedure that took place) with a …
* Identity: [v3-ActRelationshipM…](ValueSet-v3-ActRelationshipMitigates.md)
  * Name: ActRelationshipMitigates
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source act removes or lessens the occurrence or effect of the target act.
* Identity: [v3-ActRelationshipM…](ValueSet-v3-ActRelationshipModifies.md)
  * Name: ActRelationshipModifies
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Definition: Used to link a newer version or 'snapshot' of a business object (source) to an older ve…
* Identity: [v3-ActRelationshipO…](ValueSet-v3-ActRelationshipObjective.md)
  * Name: ActRelationshipObjective
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The target act is a desired outcome of the source act. Source is any act (typically an intervention…
* Identity: [v3-ActRelationshipO…](ValueSet-v3-ActRelationshipOccurrence.md)
  * Name: ActRelationshipOccurrence
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source act is a single occurrence of a repeatable target act. The source and target act can be …
* Identity: [v3-ActRelationshipO…](ValueSet-v3-ActRelationshipOutcome.md)
  * Name: ActRelationshipOutcome
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation that should follow or does actually follow as a result or consequence of a condition…
* Identity: [v3-ActRelationshipO…](ValueSet-v3-ActRelationshipOverlapsWith.md)
  * Name: ActRelationshipOverlapsWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipPalliates.md)
  * Name: ActRelationshipPalliates
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipPassiveImmunizationAgainst.md)
  * Name: ActRelationshipPassiveImmunizationAgainst
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipPertains.md)
  * Name: ActRelationshipPertains
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This is a very unspecific relationship from one item of clinical information to another. It does no…
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipPosting.md)
  * Name: ActRelationshipPosting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Expresses values for describing the relationship between a FinancialTransaction and an Account.
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipProphylaxisOf.md)
  * Name: ActRelationshipProphylaxisOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipP…](ValueSet-v3-ActRelationshipProvidesEvidenceFor.md)
  * Name: ActRelationshipProvidesEvidenceFor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates that the target Act provides evidence in support of the action represented by the source …
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipRe-challenge.md)
  * Name: ActRelationshipRe-challenge
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A relationship in which the target act is carried out to determine whether an effec…
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipReason.md)
  * Name: ActRelationshipReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The reason or rationale for a service. A reason link is weaker than a trigger, it only suggests tha…
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipRecovery.md)
  * Name: ActRelationshipRecovery
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The source act is performed to recover from the effects of the target act.
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipReferencesOrder.md)
  * Name: ActRelationshipReferencesOrder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates either an appointment request or an appointment to the order for the service being schedule…
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipRefersTo.md)
  * Name: ActRelationshipRefersTo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the target act is referred to by the source act. This permits a simple refe…
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipRelievedBy.md)
  * Name: ActRelationshipRelievedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipReplaces.md)
  * Name: ActRelationshipReplaces
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A replacement source act replaces an existing target act. The state of the target act being replace…
* Identity: [v3-ActRelationshipR…](ValueSet-v3-ActRelationshipReverses.md)
  * Name: ActRelationshipReverses
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between a source Act that seeks to reverse or undo the action of the prior target Ac…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSchedulesRequest.md)
  * Name: ActRelationshipSchedulesRequest
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Associates a specific time (and associated resources) with a scheduling request or other intent.
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSequel.md)
  * Name: ActRelationshipSequel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An act relationship indicating that the source act follows the target act. The source act should in…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSplit.md)
  * Name: ActRelationshipSplit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying how branches in an action plan are selected among other branches.*Discussion:…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSplitExclusiveTryOnce.md)
  * Name: ActRelationshipSplitExclusiveTryOnce
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The pre-condition associated with the branch is evaluated once and if true the branch may be entere…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSplitExclusiveWait.md)
  * Name: ActRelationshipSplitExclusiveWait
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A branch is selected as soon as the pre-condition associated with the branch evaluates to true. If …
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSplitInclusiveTryOnce.md)
  * Name: ActRelationshipSplitInclusiveTryOnce
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A branch is executed if its associated preconditions permit. If associated preconditions do not per…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSplitInclusiveWait.md)
  * Name: ActRelationshipSplitInclusiveWait
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A branch is executed as soon as its associated conditions permit. If the condition is false, the br…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartAfterStartOfContainsEndOf.md)
  * Name: ActRelationshipStartAfterStartOfContainsEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterEndOf.md)
  * Name: ActRelationshipStartsAfterEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A relationship in which the target act takes place with a defined temporal relation…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithEndOf.md)
  * Name: ActRelationshipStartsAfterOrConcurrentWithEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithStartOf.md)
  * Name: ActRelationshipStartsAfterOrConcurrentWithStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterStartOf.md)
  * Name: ActRelationshipStartsAfterStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Act starts after the start of the target Act (i.e. if we say "ActOne SAS ActTwo", it mea…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterStartOfEndsWith.md)
  * Name: ActRelationshipStartsAfterStartOfEndsWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsAfterStartofEndsAfterEndOf.md)
  * Name: ActRelationshipStartsAfterStartofEndsAfterEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeEnd.md)
  * Name: ActRelationshipStartsBeforeEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Act starts after the end of the target Act (i.e. if we say "ActOne SBE ActTwo", it means…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithEndOf.md)
  * Name: ActRelationshipStartsBeforeOrConcurrentWithEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithStartOf.md)
  * Name: ActRelationshipStartsBeforeOrConcurrentWithStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeStartOf.md)
  * Name: ActRelationshipStartsBeforeStartOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsBeforeEndOf.md)
  * Name: ActRelationshipStartsBeforeStartOfEndsBeforeEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsWith.md)
  * Name: ActRelationshipStartsBeforeStartOfEndsWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsConcurrentWith.md)
  * Name: ActRelationshipStartsConcurrentWith
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsConcurrentWithEnd.md)
  * Name: ActRelationshipStartsConcurrentWithEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Act starts when the target act ends (i.e. if we say "ActOne SCWE ActTwo", it means that …
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsDuring.md)
  * Name: ActRelationshipStartsDuring
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsNearEnd.md)
  * Name: ActRelationshipStartsNearEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsNearStart.md)
  * Name: ActRelationshipStartsNearStart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsWithEndsAfterEndOf.md)
  * Name: ActRelationshipStartsWithEndsAfterEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipStartsWithEndsBeforeEndOf.md)
  * Name: ActRelationshipStartsWithEndsBeforeEndOf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSubset.md)
  * Name: ActRelationshipSubset
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to indicate that the target of the relationship will be a filtered subset of the total related…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSucceeds.md)
  * Name: ActRelationshipSucceeds
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A new act that carries forward the intention of the original act, but does not comp…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSummarizedBy.md)
  * Name: ActRelationshipSummarizedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An act that contains summary values for a list or set of subordinate acts. For example, a summary o…
* Identity: [v3-ActRelationshipS…](ValueSet-v3-ActRelationshipSymptomaticRelief.md)
  * Name: ActRelationshipSymptomaticRelief
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used in the diagnosis of the indicated disease.
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTemporallyPertains.md)
  * Name: ActRelationshipTemporallyPertains
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTemporallyPertainsApproximates.md)
  * Name: ActRelationshipTemporallyPertainsApproximates
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Pro-forma value set for each head code in the ActRelationshipType code system; all codes present an…
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md)
  * Name: ActRelationshipTemporallyPertainsEnd
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md)
  * Name: ActRelationshipTemporallyPertainsStart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTransformation.md)
  * Name: ActRelationshipTransformation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used when the target Act is a transformation of the source Act. (For instance, used to show that a …
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipTreats.md)
  * Name: ActRelationshipTreats
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActRelationshipT…](ValueSet-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every ActRelationship instance. Each of its values imp…
* Identity: [v3-ActRelationshipU…](ValueSet-v3-ActRelationshipUpdatesCondition.md)
  * Name: ActRelationshipUpdatesCondition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A condition thread relationship specifically links condition nodes together to form a condition thr…
* Identity: [v3-ActRelationshipU…](ValueSet-v3-ActRelationshipUses.md)
  * Name: ActRelationshipUses
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActResearchInfor…](ValueSet-v3-ActResearchInformationAccess.md)
  * Name: ActResearchInformationAccess
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Consent to have healthcare information in an electronic health record accessed for …
* Identity: [v3-ActShortStayEnco…](ValueSet-v3-ActShortStayEncounterCode.md)
  * Name: ActShortStayEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An encounter where the patient is admitted to a health care facility for a predeterm…
* Identity: [v3-ActSite](ValueSet-v3-ActSite.md)
  * Name: v3 Value Set ActSite
  * Version: 1.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2018-08-12
  * Description: An anatomical location on an organism which can be the focus of an act.
* Identity: [v3-ActSpecObsCode](ValueSet-v3-ActSpecObsCode.md)
  * Name: ActSpecObsCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the type of observation that is made about a specimen that may affect its processing, an…
* Identity: [v3-ActSpecObsDiluti…](ValueSet-v3-ActSpecObsDilutionCode.md)
  * Name: ActSpecObsDilutionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation that reports the dilution of a sample.
* Identity: [v3-ActSpecObsInterf…](ValueSet-v3-ActSpecObsInterferenceCode.md)
  * Name: ActSpecObsInterferenceCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation that relates to factors that may potentially cause interference with the observation
* Identity: [v3-ActSpecObsVolume…](ValueSet-v3-ActSpecObsVolumeCode.md)
  * Name: ActSpecObsVolumeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation that reports the volume of a sample.
* Identity: [v3-ActSpecimenTreat…](ValueSet-v3-ActSpecimenTreatmentCode.md)
  * Name: ActSpecimenTreatmentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Set of codes related to specimen treatments
* Identity: [v3-ActStatus](ValueSet-v3-ActStatus.md)
  * Name: ActStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Contains the names (codes) for each of the states in the state-machine of the RIM Act class.
* Identity: [v3-ActStatusAborted](ValueSet-v3-ActStatusAborted.md)
  * Name: ActStatusAborted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The Act has been terminated prior to the originally intended completion.
* Identity: [v3-ActStatusAborted…](ValueSet-v3-ActStatusAbortedCancelledCompleted.md)
  * Name: ActStatusAbortedCancelledCompleted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The status of an assessment for indications of an abnormal condition.
* Identity: [v3-ActStatusActive](ValueSet-v3-ActStatusActive.md)
  * Name: ActStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The Act can be performed or is being performed
* Identity: [v3-ActStatusActiveA…](ValueSet-v3-ActStatusActiveAborted.md)
  * Name: ActStatusActiveAborted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: ** none supplied **
* Identity: [v3-ActStatusActiveS…](ValueSet-v3-ActStatusActiveSuspendedObsolete.md)
  * Name: ActStatusActiveSuspendedObsolete
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: ** none supplied **
* Identity: [v3-ActStatusCancell…](ValueSet-v3-ActStatusCancelled.md)
  * Name: ActStatusCancelled
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The Act has been abandoned before activation.
* Identity: [v3-ActStatusComplet…](ValueSet-v3-ActStatusCompleted.md)
  * Name: ActStatusCompleted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act that has terminated normally after all of its constituents have been performed.
* Identity: [v3-ActStatusHeld](ValueSet-v3-ActStatusHeld.md)
  * Name: ActStatusHeld
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act that is still in the preparatory stages has been put aside. No action can occur until the Ac…
* Identity: [v3-ActStatusNew](ValueSet-v3-ActStatusNew.md)
  * Name: ActStatusNew
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act that is in the preparatory stages and may not yet be acted upon
* Identity: [v3-ActStatusNormal](ValueSet-v3-ActStatusNormal.md)
  * Name: ActStatusNormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Encompasses the expected states of an Act, but excludes "nullified" and "obsolete" which represent …
* Identity: [v3-ActStatusNullifi…](ValueSet-v3-ActStatusNullified.md)
  * Name: ActStatusNullified
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This Act instance was created in error and has been 'removed' and is treated as though it never exi…
* Identity: [v3-ActStatusObsolete](ValueSet-v3-ActStatusObsolete.md)
  * Name: ActStatusObsolete
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This Act instance has been replaced by a new instance.
* Identity: [v3-ActStatusSuspend…](ValueSet-v3-ActStatusSuspended.md)
  * Name: ActStatusSuspended
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Act that has been activated (actions could or have been performed against it), but has been temp…
* Identity: [v3-ActSubstanceAdmi…](ValueSet-v3-ActSubstanceAdminSubstitutionCode.md)
  * Name: ActSubstanceAdminSubstitutionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActSubstanceAdmi…](ValueSet-v3-ActSubstanceAdministrationCode.md)
  * Name: ActSubstanceAdministrationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Describes the type of substance administration being performed.
* Identity: [v3-ActSubstanceAdmi…](ValueSet-v3-ActSubstanceAdministrationImmunizationCode.md)
  * Name: ActSubstanceAdministrationImmunizationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The introduction of an immunogen with the intent of stimulating an immune response, aimed at preven…
* Identity: [v3-ActSuppliedItemD…](ValueSet-v3-ActSuppliedItemDetectedIssueCode.md)
  * Name: ActSuppliedItemDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies types of detected issues regarding the administration or supply of an item to a patient.
* Identity: [v3-ActSupplyFulfill…](ValueSet-v3-ActSupplyFulfillmentRefusalReason.md)
  * Name: ActSupplyFulfillmentRefusalReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates why a fulfiller refused to fulfill a supply order, and considered it important to notify …
* Identity: [v3-ActTaskClinicalN…](ValueSet-v3-ActTaskClinicalNoteEntryCode.md)
  * Name: ActTaskClinicalNoteEntryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A clinician enters a clinical note about a given patient
* Identity: [v3-ActTaskClinicalN…](ValueSet-v3-ActTaskClinicalNoteReviewCode.md)
  * Name: ActTaskClinicalNoteReviewCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person reviews a clinical note of a given patient.
* Identity: [v3-ActTaskCode](ValueSet-v3-ActTaskCode.md)
  * Name: ActTaskCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A task or action that a user may perform in a clinical information system.
* Identity: [v3-ActTaskMedicatio…](ValueSet-v3-ActTaskMedicationListReviewCode.md)
  * Name: ActTaskMedicationListReviewCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person reviews a list of medication orders submitted to a given patient
* Identity: [v3-ActTaskMicrobiol…](ValueSet-v3-ActTaskMicrobiologyResultsReviewCode.md)
  * Name: ActTaskMicrobiologyResultsReviewCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person reviews a list of microbiology results of a given patient.
* Identity: [v3-ActTaskOrderEntr…](ValueSet-v3-ActTaskOrderEntryCode.md)
  * Name: ActTaskOrderEntryCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ActTaskPatientDo…](ValueSet-v3-ActTaskPatientDocumentationCode.md)
  * Name: ActTaskPatientDocumentationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person enters documentation about a given patient.
* Identity: [v3-ActTaskPatientIn…](ValueSet-v3-ActTaskPatientInformationReviewCode.md)
  * Name: ActTaskPatientInformationReviewCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person (e.g., clinician, the patient herself) reviews patient information in the electronic medic…
* Identity: [v3-ActTaskRiskAsses…](ValueSet-v3-ActTaskRiskAssessmentInstrumentCode.md)
  * Name: ActTaskRiskAssessmentInstrumentCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person reviews a Risk Assessment Instrument report of a given patient.
* Identity: [v3-ActTherapyDurati…](ValueSet-v3-ActTherapyDurationWorkingListCode.md)
  * Name: ActTherapyDurationWorkingListCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes used to identify different types of 'duration-based' working lists. Examples include "Continu…
* Identity: [v3-ActTransportatio…](ValueSet-v3-ActTransportationModeCode.md)
  * Name: ActTransportationModeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Characterizes how a transportation act was or will be carried out.**Examples:**Via private trans…
* Identity: [v3-ActUSPrivacyLaw](ValueSet-v3-ActUSPrivacyLaw.md)
  * Name: ActUSPrivacyLaw
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **Deprecation Comment:** **Content moved to ActCode, and is now represented in value set ActPrivacy…
* Identity: [v3-ActUncertainty](ValueSet-v3-ActUncertainty.md)
  * Name: ActUncertainty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code indicating whether the Act statement as a whole, with its subordinate components has been as…
* Identity: [v3-ActVirtualEncoun…](ValueSet-v3-ActVirtualEncounterCode.md)
  * Name: ActVirtualEncounterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A patient encounter where the patient and the practitioner(s) are not in the same ph…
* Identity: [v3-AdditionalLocator](ValueSet-v3-AdditionalLocator.md)
  * Name: AdditionalLocator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This can be a unit designator, such as apartment number, suite number, or floor. There may be sever…
* Identity: [v3-AddressLine](ValueSet-v3-AddressLine.md)
  * Name: AddressLine
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An address line is for either an additional locator, a delivery address or a stree…
* Identity: [v3-AddressPartType](ValueSet-v3-AddressPartType.md)
  * Name: AddressPartType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Discussion: The hierarchical nature of these concepts shows composition. E.g. "Street Name" is part…
* Identity: [v3-AddressRepresent…](ValueSet-v3-AddressRepresentationUse.md)
  * Name: AddressRepresentationUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies the different representations of a Address. The representation may affec…
* Identity: [v3-AddressUse](ValueSet-v3-AddressUse.md)
  * Name: AddressUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AdjudicatedWithA…](ValueSet-v3-AdjudicatedWithAdjustments.md)
  * Name: AdjudicatedWithAdjustments
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The invoice element has been accepted for payment but one or more adjustment(s) have been made to o…
* Identity: [v3-AdministrableDru…](ValueSet-v3-AdministrableDrugForm.md)
  * Name: AdministrableDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates the form in which the drug product should be administered.This element only needs to …
* Identity: [v3-AdministrationDe…](ValueSet-v3-AdministrationDetectedIssueCode.md)
  * Name: AdministrationDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Administration of the proposed therapy may be inappropriate or contraindicated as proposed
* Identity: [v3-AdministrationMe…](ValueSet-v3-AdministrationMedicalDevice.md)
  * Name: AdministrationMedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device intended to administer a substance to a subject
* Identity: [v3-AdministrativeCo…](ValueSet-v3-AdministrativeContactRoleType.md)
  * Name: AdministrativeContactRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role type that is used to further qualify an entity playing a role where the role class attribute…
* Identity: [v3-AdministrativeGe…](ValueSet-v3-AdministrativeGender.md)
  * Name: AdministrativeGender
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The gender of a person used for adminstrative purposes (as opposed to clinical gender)
* Identity: [v3-AdoptedChild](ValueSet-v3-AdoptedChild.md)
  * Name: AdoptedChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child taken into a family through legal means and raised by the scoping…
* Identity: [v3-AerosolDrugForm](ValueSet-v3-AerosolDrugForm.md)
  * Name: AerosolDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AgeDetectedIssue…](ValueSet-v3-AgeDetectedIssueCode.md)
  * Name: AgeDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate or contraindicated due to patient age
* Identity: [v3-AgeGroupObservat…](ValueSet-v3-AgeGroupObservationValue.md)
  * Name: AgeGroupObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-16
  * Description: Observation values used to indicate the age group of a person in terms of age group concept codes.
* Identity: [v3-Aleut](ValueSet-v3-Aleut.md)
  * Name: Aleut
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Algic](ValueSet-v3-Algic.md)
  * Name: Algic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Algonquian](ValueSet-v3-Algonquian.md)
  * Name: Algonquian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AlgorithmicDecis…](ValueSet-v3-AlgorithmicDecisionObservationMethod.md)
  * Name: AlgorithmicDecisionObservationMethod
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Reaching a decision through the application of an algorithm designed to weigh the different factors…
* Identity: [v3-AllergyStatus](ValueSet-v3-AllergyStatus.md)
  * Name: Allergy Status
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The clinical status of an allergy disposition (Clinical Focus)Used in Program: C-CDA, C-CDA R2.…
* Identity: [v3-AllergyTestValue](ValueSet-v3-AllergyTestValue.md)
  * Name: AllergyTestValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates the result of a particular allergy test. E.g. Negative, Mild, Moderate, Severe
* Identity: [v3-Ambulance](ValueSet-v3-Ambulance.md)
  * Name: Ambulance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AmericanIndianAl…](ValueSet-v3-AmericanIndianAlaskaNativeLanguages.md)
  * Name: AmericanIndianAlaskaNativeLanguages
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AmnioticFluidSac…](ValueSet-v3-AmnioticFluidSacRoute.md)
  * Name: AmnioticFluidSacRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Amniotic fluid sac
* Identity: [v3-AnnotationType](ValueSet-v3-AnnotationType.md)
  * Name: AnnotationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Apachean](ValueSet-v3-Apachean.md)
  * Name: Apachean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ApplicationMedia…](ValueSet-v3-ApplicationMediaType.md)
  * Name: ApplicationMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Application specific media type.
* Identity: [v3-AppropriatenessD…](ValueSet-v3-AppropriatenessDetectedIssueCode.md)
  * Name: AppropriatenessDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ArapahoGrosVentre](ValueSet-v3-ArapahoGrosVentre.md)
  * Name: ArapahoGrosVentre
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Arapahoan](ValueSet-v3-Arapahoan.md)
  * Name: Arapahoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ArtificialDentit…](ValueSet-v3-ArtificialDentition.md)
  * Name: ArtificialDentition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Artificial dentition, artificial subsitutes for the natural dentition
* Identity: [v3-AskedButUnknown](ValueSet-v3-AskedButUnknown.md)
  * Name: AskedButUnknown
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Information was sought but not found (e.g., patient was asked but didn't know)
* Identity: [v3-AssignedNonPerso…](ValueSet-v3-AssignedNonPersonLivingSubjectRoleType.md)
  * Name: AssignedNonPersonLivingSubjectRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role type that is used to further qualify a non-person subject playing a role whe…
* Identity: [v3-Athapaskan](ValueSet-v3-Athapaskan.md)
  * Name: Athapaskan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AthapaskanEyak](ValueSet-v3-AthapaskanEyak.md)
  * Name: AthapaskanEyak
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AudioMediaType](ValueSet-v3-AudioMediaType.md)
  * Name: AudioMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Audio media type.
* Identity: [v3-AuthorizationIss…](ValueSet-v3-AuthorizationIssueManagementCode.md)
  * Name: AuthorizationIssueManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-AuthorizedPartic…](ValueSet-v3-AuthorizedParticipationFunction.md)
  * Name: AuthorizedParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This code is used to specify the exact function an actor is authorized to have in a service in all …
* Identity: [v3-AuthorizedReceiv…](ValueSet-v3-AuthorizedReceiverParticipationFunction.md)
  * Name: AuthorizedReceiverParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This code is used to specify the exact function an actor is authorized to have as a receiver of inf…
* Identity: [v3-AutomobileInsura…](ValueSet-v3-AutomobileInsurancePolicy.md)
  * Name: AutomobileInsurancePolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**An insurance policy for losses sustained in an automobile accident that typically c…
* Identity: [v3-BarDrugForm](ValueSet-v3-BarDrugForm.md)
  * Name: BarDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-BarSoapDrugForm](ValueSet-v3-BarSoapDrugForm.md)
  * Name: BarSoapDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-BiliaryRoute](ValueSet-v3-BiliaryRoute.md)
  * Name: BiliaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Biliary tract
* Identity: [v3-BindingRealm](ValueSet-v3-BindingRealm.md)
  * Name: BindingRealm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**All coded binding realms for terminology constraint context binding.
* Identity: [v3-BiotherapeuticNo…](ValueSet-v3-BiotherapeuticNon-personLivingSubjectRoleType.md)
  * Name: BiotherapeuticNon-personLivingSubjectRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Animals, including fish and insects, and microorganisms which may participate as as…
* Identity: [v3-BlisterPackEntit…](ValueSet-v3-BlisterPackEntityType.md)
  * Name: BlisterPackEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A bubblepack. Medications sealed individually, separated into doses.
* Identity: [v3-BodySurfaceRoute](ValueSet-v3-BodySurfaceRoute.md)
  * Name: BodySurfaceRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Body surface
* Identity: [v3-BottleEntityType](ValueSet-v3-BottleEntityType.md)
  * Name: BottleEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container, typically rounded, either glass or plastic with a narrow neck and capable of storing l…
* Identity: [v3-BuccalMucosaRoute](ValueSet-v3-BuccalMucosaRoute.md)
  * Name: BuccalMucosaRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Buccal mucosa
* Identity: [v3-BuccalTablet](ValueSet-v3-BuccalTablet.md)
  * Name: BuccalTablet
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-BuildingNumber](ValueSet-v3-BuildingNumber.md)
  * Name: BuildingNumber
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The number of a building, house or lot alongside the street. Also known as "primary street number".…
* Identity: [v3-CUI](ValueSet-v3-CUI.md)
  * Name: CUI
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Information the US Government creates or possesses, or that an entity creates or possesses for or o…
* Identity: [v3-CUILabel](ValueSet-v3-CUILabel.md)
  * Name: CUILabel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Information the US Government creates or possesses, or that an entity creates or possesses for or o…
* Identity: [v3-CVDiagTherPracti…](ValueSet-v3-CVDiagTherPracticeSetting.md)
  * Name: CVDiagTherPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A practice setting where cardiovascular diagnostic procedures or therapeutic interventions are perf…
* Identity: [v3-Caddoan](ValueSet-v3-Caddoan.md)
  * Name: Caddoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Cahitan](ValueSet-v3-Cahitan.md)
  * Name: Cahitan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Calendar](ValueSet-v3-Calendar.md)
  * Name: Calendar
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CalendarCycle](ValueSet-v3-CalendarCycle.md)
  * Name: CalendarCycle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CalendarCycleOne…](ValueSet-v3-CalendarCycleOneLetter.md)
  * Name: CalendarCycleOneLetter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: One letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed)
* Identity: [v3-CalendarCycleTwo…](ValueSet-v3-CalendarCycleTwoLetter.md)
  * Name: CalendarCycleTwoLetter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Two letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed)
* Identity: [v3-CalendarType](ValueSet-v3-CalendarType.md)
  * Name: CalendarType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CaliforniaAthapa…](ValueSet-v3-CaliforniaAthapaskan.md)
  * Name: CaliforniaAthapaskan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CapsuleDrugForm](ValueSet-v3-CapsuleDrugForm.md)
  * Name: CapsuleDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A solid dosage form in which the drug is enclosed within either a hard or soft soluble container or…
* Identity: [v3-CardClinPractice…](ValueSet-v3-CardClinPracticeSetting.md)
  * Name: CardClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CaseTransmission…](ValueSet-v3-CaseTransmissionMode.md)
  * Name: CaseTransmissionMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code for the mechanism by which disease was acquired by the living subject involved in the public h…
* Identity: [v3-Catawba](ValueSet-v3-Catawba.md)
  * Name: Catawba
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CecostomyRoute](ValueSet-v3-CecostomyRoute.md)
  * Name: CecostomyRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Cecostomy
* Identity: [v3-CentralAlaskaYuk…](ValueSet-v3-CentralAlaskaYukon.md)
  * Name: CentralAlaskaYukon
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CentralMuskogean](ValueSet-v3-CentralMuskogean.md)
  * Name: CentralMuskogean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CentralNumic](ValueSet-v3-CentralNumic.md)
  * Name: CentralNumic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CentralSalish](ValueSet-v3-CentralSalish.md)
  * Name: CentralSalish
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CervicalRoute](ValueSet-v3-CervicalRoute.md)
  * Name: CervicalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Cervix of the uterus
* Identity: [v3-Charset](ValueSet-v3-Charset.md)
  * Name: Charset
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Internet Assigned Numbers Authority (IANA) Charset Types
* Identity: [v3-Chew](ValueSet-v3-Chew.md)
  * Name: Chew
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Chew
* Identity: [v3-Child](ValueSet-v3-Child.md)
  * Name: Child
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child of the scoping entity.
* Identity: [v3-ChildInLaw](ValueSet-v3-ChildInLaw.md)
  * Name: ChildInLaw
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is the spouse of scoping person's child.
* Identity: [v3-Chimakuan](ValueSet-v3-Chimakuan.md)
  * Name: Chimakuan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Chinookan](ValueSet-v3-Chinookan.md)
  * Name: Chinookan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ChiwereWinnebago](ValueSet-v3-ChiwereWinnebago.md)
  * Name: ChiwereWinnebago
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ChronicCareFacil…](ValueSet-v3-ChronicCareFacility.md)
  * Name: ChronicCareFacility
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (1) A hospital including a physical plant and personnel that provides multidisciplinary diagnosis a…
* Identity: [v3-CitizenRoleType](ValueSet-v3-CitizenRoleType.md)
  * Name: CitizenRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role type used to qualify a person's legal status within a country or nation.**Examples:**…
* Identity: [v3-ClaimantCoveredP…](ValueSet-v3-ClaimantCoveredPartyRoleType.md)
  * Name: ClaimantCoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description**A role recognized through the eligibility of a party play a claimant for benefits co…
* Identity: [v3-ClassNullFlavor](ValueSet-v3-ClassNullFlavor.md)
  * Name: ClassNullFlavor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Subset of null flavors, used for associations as needed for the ITS, and used in I…
* Identity: [v3-ClinicalResearch…](ValueSet-v3-ClinicalResearchEventReason.md)
  * Name: ClinicalResearchEventReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Specifies the reason that an event occurred in a clinical research study.
* Identity: [v3-ClinicalResearch…](ValueSet-v3-ClinicalResearchObservationReason.md)
  * Name: ClinicalResearchObservationReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**SSpecifies the reason that a test was performed or observation collected in a clinic…
* Identity: [v3-ClinicalResearch…](ValueSet-v3-ClinicalResearchReason.md)
  * Name: ClinicalResearchReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Contains domains for act reasons used in clinical research.
* Identity: [v3-CochimiYuman](ValueSet-v3-CochimiYuman.md)
  * Name: CochimiYuman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CodeIsNotValid](ValueSet-v3-CodeIsNotValid.md)
  * Name: CodeIsNotValid
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CodeSystem](ValueSet-v3-CodeSystem.md)
  * Name: CodeSystem
  * Version: 2.0.0
  * Status: retired
  * Owner: n/a
  * Copyright: n/a
  * Date: 2014-03-26
  * Description: Code systems used in HL7 standards.
* Identity: [v3-CodeSystemType](ValueSet-v3-CodeSystemType.md)
  * Name: CodeSystemType
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: How a code system is maintained by HL7
* Identity: [v3-CodingRationale](ValueSet-v3-CodingRationale.md)
  * Name: CodingRationale
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Si…
* Identity: [v3-CombinedPharmacy…](ValueSet-v3-CombinedPharmacyOrderSuspendReasonCode.md)
  * Name: CombinedPharmacyOrderSuspendReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Indicates why the prescription should be suspended.
* Identity: [v3-CommunicationFun…](ValueSet-v3-CommunicationFunctionType.md)
  * Name: CommunicationFunctionType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Describes the type of communication function that the associated entity plays in the associated tra…
* Identity: [v3-Compartment](ValueSet-v3-Compartment.md)
  * Name: Compartment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A named tag set for metadata used to populate a security category label field that "segments" an IT…
* Identity: [v3-ComplianceAlert](ValueSet-v3-ComplianceAlert.md)
  * Name: ComplianceAlert
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ComplianceDetect…](ValueSet-v3-ComplianceDetectedIssueCode.md)
  * Name: ComplianceDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: There may be an issue with the patient complying with the intentions of the proposed therapy
* Identity: [v3-CompliancePackag…](ValueSet-v3-CompliancePackageEntityType.md)
  * Name: CompliancePackageEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container intended to contain sufficient material for more than one use, but grouped or organized…
* Identity: [v3-CompositeMeasure…](ValueSet-v3-CompositeMeasureScoring.md)
  * Name: CompositeMeasureScoring
  * Version: 3.0.0
  * Status: active
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Observation values that communicate the method used in a quality measure to combine the component m…
* Identity: [v3-CompressionAlgor…](ValueSet-v3-CompressionAlgorithm.md)
  * Name: CompressionAlgorithm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ConceptPropertyId](ValueSet-v3-ConceptPropertyId.md)
  * Name: ConceptPropertyId
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Property identifiers for a concept code
* Identity: [v3-ConditionDetecte…](ValueSet-v3-ConditionDetectedIssueCode.md)
  * Name: ConditionDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate or contraindicated due to an existing/recent patient conditio…
* Identity: [v3-Conditional](ValueSet-v3-Conditional.md)
  * Name: Conditional
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Some conditions may be attached to an allowable substitution. An allowable substitution is based on…
* Identity: [v3-Confidentiality](ValueSet-v3-Confidentiality.md)
  * Name: Confidentiality
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Set of codes used to value Act.Confidentiality and Role.Confidentiality attribute in accordance wit…
* Identity: [v3-ConfidentialityM…](ValueSet-v3-ConfidentialityModifiers.md)
  * Name: ConfidentialityModifiers
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Modifiers of role based access rights (multiple allowed)**Usage Note:**All codes that are refere…
* Identity: [v3-ConsenterPartici…](ValueSet-v3-ConsenterParticipationFunction.md)
  * Name: ConsenterParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This code is used to specify the exact function an actor is authorized to have in authoring a conse…
* Identity: [v3-ConsultedPrescri…](ValueSet-v3-ConsultedPrescriberManagementCode.md)
  * Name: ConsultedPrescriberManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Consulted prescriber, therapy confirmed
* Identity: [v3-ContactRoleType](ValueSet-v3-ContactRoleType.md)
  * Name: ContactRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Types of contact for Role code "CON"
* Identity: [v3-ContainerCap](ValueSet-v3-ContainerCap.md)
  * Name: ContainerCap
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The type of cap associated with a container
* Identity: [v3-ContainerEntityT…](ValueSet-v3-ContainerEntityType.md)
  * Name: ContainerEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Material intended to hold another material for purpose of storage or transport.
* Identity: [v3-ContainerSeparat…](ValueSet-v3-ContainerSeparator.md)
  * Name: ContainerSeparator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A material in a blood collection container that facilites the separation of of blood cells from ser…
* Identity: [v3-ContentProcessin…](ValueSet-v3-ContentProcessingMode.md)
  * Name: ContentProcessingMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies the order in which content should be processed.
* Identity: [v3-ContextConductio…](ValueSet-v3-ContextConductionStyle.md)
  * Name: ContextConductionStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ContextControl](ValueSet-v3-ContextControl.md)
  * Name: ContextControl
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code that specifies how an ActRelationship or Participation contributes to the context of an Act,…
* Identity: [v3-ContextControlAd…](ValueSet-v3-ContextControlAdditive.md)
  * Name: ContextControlAdditive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association adds to the existing context associated with the Act. Both this association and any…
* Identity: [v3-ContextControlAd…](ValueSet-v3-ContextControlAdditiveNon-propagating.md)
  * Name: ContextControlAdditiveNon-propagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association adds to the existing context associated with the Act, but will not propagate to any…
* Identity: [v3-ContextControlAd…](ValueSet-v3-ContextControlAdditivePropagating.md)
  * Name: ContextControlAdditivePropagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association adds to the existing context associated with the Act, and will propagate to any des…
* Identity: [v3-ContextControlNo…](ValueSet-v3-ContextControlNonPropagating.md)
  * Name: ContextControlNonPropagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association applies only to the current Act and will not propagate to any child Acts that are r…
* Identity: [v3-ContextControlOv…](ValueSet-v3-ContextControlOverriding.md)
  * Name: ContextControlOverriding
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association adds to the existing context associated with the Act, but replaces associations pro…
* Identity: [v3-ContextControlOv…](ValueSet-v3-ContextControlOverridingNon-propagating.md)
  * Name: ContextControlOverridingNon-propagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association is added to the existing context associated with the Act, but overrides an associat…
* Identity: [v3-ContextControlOv…](ValueSet-v3-ContextControlOverridingPropagating.md)
  * Name: ContextControlOverridingPropagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association is added to the existing context associated with the Act, but overrides an associat…
* Identity: [v3-ContextControlPr…](ValueSet-v3-ContextControlPropagating.md)
  * Name: ContextControlPropagating
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The association propagates to any child Acts that are related via a conducting ActRelationship (ref…
* Identity: [v3-ControlActNullif…](ValueSet-v3-ControlActNullificationReasonCode.md)
  * Name: ControlActNullificationReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies reasons for nullifying (retracting) a particular control act.**Examp…
* Identity: [v3-ControlActNullif…](ValueSet-v3-ControlActNullificationRefusalReasonType.md)
  * Name: ControlActNullificationRefusalReasonType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ControlActReason](ValueSet-v3-ControlActReason.md)
  * Name: ControlActReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies why a specific query, request, or other trigger event occurred.
* Identity: [v3-ControlledSubsta…](ValueSet-v3-ControlledSubstanceMonitoringProtocol.md)
  * Name: ControlledSubstanceMonitoringProtocol
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A monitoring program that focuses on narcotics and/or commonly abused substances that are subject t…
* Identity: [v3-Coosan](ValueSet-v3-Coosan.md)
  * Name: Coosan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Country](ValueSet-v3-Country.md)
  * Name: Country
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Countries of the world. ISO 3166, part 1, alpha-3 set.
* Identity: [v3-Country2](ValueSet-v3-Country2.md)
  * Name: Country2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Countries of the world. ISO 3166, part 1, alpha-2 set.
* Identity: [v3-CountryEntityType](ValueSet-v3-CountryEntityType.md)
  * Name: CountryEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A set of codes identifying specific countries.
* Identity: [v3-CoverageEligibil…](ValueSet-v3-CoverageEligibilityReason.md)
  * Name: CoverageEligibilityReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies the reason or rational for why a person is eligible for benefits under a…
* Identity: [v3-CoverageLevelObs…](ValueSet-v3-CoverageLevelObservationValue.md)
  * Name: CoverageLevelObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Coded observation values for types of covered parties under a policy or program bas…
* Identity: [v3-CoverageLimitObs…](ValueSet-v3-CoverageLimitObservationValue.md)
  * Name: CoverageLimitObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Coded observation values for coverage limitations, for e.g., types of claims or typ…
* Identity: [v3-CoverageParticip…](ValueSet-v3-CoverageParticipationFunction.md)
  * Name: CoverageParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the manner in which sponsors, underwriters, and payers part…
* Identity: [v3-CoverageRoleType](ValueSet-v3-CoverageRoleType.md)
  * Name: CoverageRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Role recognized through the issuance of insurance coverage to an identified covered party who has t…
* Identity: [v3-CoverageSponsorR…](ValueSet-v3-CoverageSponsorRoleType.md)
  * Name: CoverageSponsorRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Codes that indicate a specific type of sponsor. Used when the sponsor's role is onl…
* Identity: [v3-CoveredPartyRole…](ValueSet-v3-CoveredPartyRoleType.md)
  * Name: CoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role recognized through the eligibility of an identified living subject for benefits covered unde…
* Identity: [v3-CreamDrugForm](ValueSet-v3-CreamDrugForm.md)
  * Name: CreamDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A semisolid dosage form containing one or more drug substances dissolved or dispersed in a suitable…
* Identity: [v3-CreditCard](ValueSet-v3-CreditCard.md)
  * Name: CreditCard
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Cree](ValueSet-v3-Cree.md)
  * Name: Cree
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CreeMontagnais](ValueSet-v3-CreeMontagnais.md)
  * Name: CreeMontagnais
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-CriticalityObser…](ValueSet-v3-CriticalityObservationValue.md)
  * Name: CriticalityObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Recommended values for criticality observations> **Steward:**Security WG
* Identity: [v3-Cupan](ValueSet-v3-Cupan.md)
  * Name: Cupan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Currency](ValueSet-v3-Currency.md)
  * Name: Currency
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The currency unit as defined in ISO 4217
* Identity: [v3-Dakotan](ValueSet-v3-Dakotan.md)
  * Name: Dakotan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DecisionObservat…](ValueSet-v3-DecisionObservationMethod.md)
  * Name: Decision Observation Method
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Provides codes for decision methods, initially for assessing the causality of events.
* Identity: [v3-DedicatedClinica…](ValueSet-v3-DedicatedClinicalLocationRoleType.md)
  * Name: DedicatedClinicalLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place that further classifies the clinical setting (e.g., cardiology clinic, primary ca…
* Identity: [v3-DedicatedNonClin…](ValueSet-v3-DedicatedNonClinicalLocationRoleType.md)
  * Name: DedicatedNonClinicalLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place that further classifies a setting that is intended to house the provision of non-…
* Identity: [v3-DedicatedService…](ValueSet-v3-DedicatedServiceDeliveryLocationRoleType.md)
  * Name: DedicatedServiceDeliveryLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place that further classifies a setting that is intended to house the provision of serv…
* Identity: [v3-Delawaran](ValueSet-v3-Delawaran.md)
  * Name: Delawaran
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DeliveryAddressL…](ValueSet-v3-DeliveryAddressLine.md)
  * Name: DeliveryAddressLine
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A delivery address line is frequently used instead of breaking out delivery mode, delivery installa…
* Identity: [v3-DeltaCalifornia](ValueSet-v3-DeltaCalifornia.md)
  * Name: DeltaCalifornia
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Dentition](ValueSet-v3-Dentition.md)
  * Name: Dentition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DependentCovered…](ValueSet-v3-DependentCoveredPartyRoleType.md)
  * Name: DependentCoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role recognized through the eligibility of a party to play a dependent for benef…
* Identity: [v3-DeviceAlertLevel](ValueSet-v3-DeviceAlertLevel.md)
  * Name: DeviceAlertLevel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Domain values for the Device.Alert_levelCode
* Identity: [v3-Dhegiha](ValueSet-v3-Dhegiha.md)
  * Name: Dhegiha
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DiagTherPractice…](ValueSet-v3-DiagTherPracticeSetting.md)
  * Name: DiagTherPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A practice setting where diagnostic procedures or therapeutic interventions are performed
* Identity: [v3-DiagnosisICD9CM](ValueSet-v3-DiagnosisICD9CM.md)
  * Name: DiagnosisICD9CM
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Diegueno](ValueSet-v3-Diegueno.md)
  * Name: Diegueno
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Diffusion](ValueSet-v3-Diffusion.md)
  * Name: Diffusion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Diffusion
* Identity: [v3-DiseaseProgram](ValueSet-v3-DiseaseProgram.md)
  * Name: DiseaseProgram
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A public or government health program that administers and funds coverage for healt…
* Identity: [v3-DispensableDrugF…](ValueSet-v3-DispensableDrugForm.md)
  * Name: DispensableDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Dissolve](ValueSet-v3-Dissolve.md)
  * Name: Dissolve
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Dissolve
* Identity: [v3-DocumentCompleti…](ValueSet-v3-DocumentCompletion.md)
  * Name: DocumentCompletion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the current completion state of a clinical document.
* Identity: [v3-DocumentSectionT…](ValueSet-v3-DocumentSectionType.md)
  * Name: DocumentSectionType
  * Version: 3.0.0
  * Status: active
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The type of document section. Possible values: review of systems, medical history, family history, …
* Identity: [v3-DocumentStorage](ValueSet-v3-DocumentStorage.md)
  * Name: DocumentStorage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the storage status of a document.
* Identity: [v3-DocumentStorageA…](ValueSet-v3-DocumentStorageActive.md)
  * Name: DocumentStorageActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A storage status in which a document is available on-line.
* Identity: [v3-DosageProblem](ValueSet-v3-DosageProblem.md)
  * Name: DosageProblem
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DosageProblemDet…](ValueSet-v3-DosageProblemDetectedIssueCode.md)
  * Name: DosageProblemDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed dosage instructions for therapy differ from standard practice.
* Identity: [v3-DoseDurationDete…](ValueSet-v3-DoseDurationDetectedIssueCode.md)
  * Name: DoseDurationDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed length of therpay differs from standard practice
* Identity: [v3-DoseDurationHigh…](ValueSet-v3-DoseDurationHighDetectedIssueCode.md)
  * Name: DoseDurationHighDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed length of therapy is longer than standard practice
* Identity: [v3-DoseDurationLowD…](ValueSet-v3-DoseDurationLowDetectedIssueCode.md)
  * Name: DoseDurationLowDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed length of therapy is shorter than that necessary for therapeutic effect
* Identity: [v3-DoseHighDetected…](ValueSet-v3-DoseHighDetectedIssueCode.md)
  * Name: DoseHighDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed dosage exceeds standard practice
* Identity: [v3-DoseIntervalDete…](ValueSet-v3-DoseIntervalDetectedIssueCode.md)
  * Name: DoseIntervalDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed dosage interval/timing differs from standard practice
* Identity: [v3-DoseLowDetectedI…](ValueSet-v3-DoseLowDetectedIssueCode.md)
  * Name: DoseLowDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed dosage is below suggested therapeutic levels
* Identity: [v3-Douche](ValueSet-v3-Douche.md)
  * Name: Douche
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Douche
* Identity: [v3-DropsDrugForm](ValueSet-v3-DropsDrugForm.md)
  * Name: DropsDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-DrugEntity](ValueSet-v3-DrugEntity.md)
  * Name: Drug Entity
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: A value representing the specific kind of Drug Entity the instance represents.
* Identity: [v3-DuplicateTherapy…](ValueSet-v3-DuplicateTherapyAlert.md)
  * Name: DuplicateTherapyAlert
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ECGObservationSe…](ValueSet-v3-ECGObservationSeriesType.md)
  * Name: ECGObservationSeriesType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ERPracticeSetting](ValueSet-v3-ERPracticeSetting.md)
  * Name: ERPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The section of a health care facility for providing rapid treatment to victims of sudden illness or…
* Identity: [v3-EasternAlgonquin](ValueSet-v3-EasternAlgonquin.md)
  * Name: EasternAlgonquin
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EasternApachean](ValueSet-v3-EasternApachean.md)
  * Name: EasternApachean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EasternMiwok](ValueSet-v3-EasternMiwok.md)
  * Name: EasternMiwok
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EducationLevel](ValueSet-v3-EducationLevel.md)
  * Name: EducationLevel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ElectroOsmosisRo…](ValueSet-v3-ElectroOsmosisRoute.md)
  * Name: ElectroOsmosisRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Electro-osmosis
* Identity: [v3-EligibilityActRe…](ValueSet-v3-EligibilityActReasonCode.md)
  * Name: EligibilityActReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies the reason or rational for why a person is eligible for benefits under a…
* Identity: [v3-EmergencyPharmac…](ValueSet-v3-EmergencyPharmacySupplyType.md)
  * Name: EmergencyPharmacySupplyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A supply action where there is no 'valid' order for the supplied medication. E.g. Emergency vacatio…
* Identity: [v3-EmployeeJobClass](ValueSet-v3-EmployeeJobClass.md)
  * Name: EmployeeJobClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code qualifying the employment in various ways, such as, full-time vs. part time, etc.
* Identity: [v3-EmploymentStatus…](ValueSet-v3-EmploymentStatusUB92.md)
  * Name: EmploymentStatusUB92
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EncounterAdmissi…](ValueSet-v3-EncounterAdmissionSource.md)
  * Name: EncounterAdmissionSource
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EncounterSpecial…](ValueSet-v3-EncounterSpecialCourtesy.md)
  * Name: EncounterSpecialCourtesy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code identifying special courtesies extended to the patient. For example, no courtesies, extended…
* Identity: [v3-EndocervicalRoute](ValueSet-v3-EndocervicalRoute.md)
  * Name: EndocervicalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Endocervical
* Identity: [v3-EndocrinologyCli…](ValueSet-v3-EndocrinologyClinic.md)
  * Name: EndocrinologyClinic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Enema](ValueSet-v3-Enema.md)
  * Name: Enema
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Enema
* Identity: [v3-EnteralRoute](ValueSet-v3-EnteralRoute.md)
  * Name: EnteralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Enteral
* Identity: [v3-EntericCoatedCap…](ValueSet-v3-EntericCoatedCapsule.md)
  * Name: EntericCoatedCapsule
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntericCoatedTab…](ValueSet-v3-EntericCoatedTablet.md)
  * Name: EntericCoatedTablet
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntityClass](ValueSet-v3-EntityClass.md)
  * Name: EntityClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top …
* Identity: [v3-EntityClassAnimal](ValueSet-v3-EntityClassAnimal.md)
  * Name: EntityClassAnimal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A living subject from the animal kingdom.
* Identity: [v3-EntityClassCerti…](ValueSet-v3-EntityClassCertificateRepresentation.md)
  * Name: EntityClassCertificateRepresentation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A physical artifact that stores information about the granting of authorization.
* Identity: [v3-EntityClassChemi…](ValueSet-v3-EntityClassChemicalSubstance.md)
  * Name: EntityClassChemicalSubstance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A substance that is fully defined by an organic or inorganic chemical formula, includes mixtures of…
* Identity: [v3-EntityClassCityO…](ValueSet-v3-EntityClassCityOrTown.md)
  * Name: EntityClassCityOrTown
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The territory of a city, town or other municipality.
* Identity: [v3-EntityClassConta…](ValueSet-v3-EntityClassContainer.md)
  * Name: EntityClassContainer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container of other entities.
* Identity: [v3-EntityClassCount…](ValueSet-v3-EntityClassCountry.md)
  * Name: EntityClassCountry
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The territory of a sovereign nation.
* Identity: [v3-EntityClassCount…](ValueSet-v3-EntityClassCountyOrParish.md)
  * Name: EntityClassCountyOrParish
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The territory of a county, parish or other division of a state or province.
* Identity: [v3-EntityClassDevice](ValueSet-v3-EntityClassDevice.md)
  * Name: EntityClassDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A subtype of ManufacturedMaterial used in an activity, without being substantially changed through …
* Identity: [v3-EntityClassFood](ValueSet-v3-EntityClassFood.md)
  * Name: EntityClassFood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Naturally occurring, processed or manufactured entities that are primarily used as food for humans …
* Identity: [v3-EntityClassGroup](ValueSet-v3-EntityClassGroup.md)
  * Name: EntityClassGroup
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A grouping of resources (personnel, material, or places) to be used for scheduling purposes. May be…
* Identity: [v3-EntityClassHealt…](ValueSet-v3-EntityClassHealthChartEntity.md)
  * Name: EntityClassHealthChartEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A health chart included to serve as a document receiving entity in the management of medical record…
* Identity: [v3-EntityClassHolder](ValueSet-v3-EntityClassHolder.md)
  * Name: EntityClassHolder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A type of container that can hold other containers or other holders.
* Identity: [v3-EntityClassImagi…](ValueSet-v3-EntityClassImagingModality.md)
  * Name: EntityClassImagingModality
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Class to contain unique attributes of diagnostic imaging equipment.
* Identity: [v3-EntityClassLivin…](ValueSet-v3-EntityClassLivingSubject.md)
  * Name: EntityClassLivingSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Anything that essentially has the property of life, independent of current state (a dead human corp…
* Identity: [v3-EntityClassManuf…](ValueSet-v3-EntityClassManufacturedMaterial.md)
  * Name: EntityClassManufacturedMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the ManufacturedMaterial class
* Identity: [v3-EntityClassMater…](ValueSet-v3-EntityClassMaterial.md)
  * Name: EntityClassMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Any thing that has extension in space and mass, may be of living or non-living origin.
* Identity: [v3-EntityClassMicro…](ValueSet-v3-EntityClassMicroorganism.md)
  * Name: EntityClassMicroorganism
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: All single celled living organisms including protozoa, bacteria, yeast, viruses, etc.
* Identity: [v3-EntityClassNation](ValueSet-v3-EntityClassNation.md)
  * Name: EntityClassNation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A politically organized body of people bonded by territory and known as a nation.
* Identity: [v3-EntityClassNonPe…](ValueSet-v3-EntityClassNonPersonLivingSubject.md)
  * Name: EntityClassNonPersonLivingSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntityClassOrgan…](ValueSet-v3-EntityClassOrganization.md)
  * Name: EntityClassOrganization
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A social or legal structure formed by human beings.
* Identity: [v3-EntityClassPerson](ValueSet-v3-EntityClassPerson.md)
  * Name: EntityClassPerson
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A living subject of the species homo sapiens.
* Identity: [v3-EntityClassPlace](ValueSet-v3-EntityClassPlace.md)
  * Name: EntityClassPlace
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A physicial place or site with its containing structure. May be natural or man-made. The geographic…
* Identity: [v3-EntityClassPlant](ValueSet-v3-EntityClassPlant.md)
  * Name: EntityClassPlant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A living subject from the order of plants.
* Identity: [v3-EntityClassPubli…](ValueSet-v3-EntityClassPublicInstitution.md)
  * Name: EntityClassPublicInstitution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An agency of the people of a state often assuming some authority over a certain matter. Includes go…
* Identity: [v3-EntityClassRoot](ValueSet-v3-EntityClassRoot.md)
  * Name: EntityClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the Entity class
* Identity: [v3-EntityClassState](ValueSet-v3-EntityClassState.md)
  * Name: EntityClassState
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A politically organized body of people bonded by territory, culture, or ethnicity, having sovereign…
* Identity: [v3-EntityClassState…](ValueSet-v3-EntityClassStateOrProvince.md)
  * Name: EntityClassStateOrProvince
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The territory of a state, province, department or other division of a sovereign country.
* Identity: [v3-EntityCode](ValueSet-v3-EntityCode.md)
  * Name: EntityCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing the specific kind of Entity the instance represents.**Examples:**A medical …
* Identity: [v3-EntityDeterminer](ValueSet-v3-EntityDeterminer.md)
  * Name: EntityDeterminer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: EntityDeterminer in natural language grammar is the class of words that comprises articles, demonst…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerDescribedGroup.md)
  * Name: EntityDeterminerDescribedGroup
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A standard value set allowing reference to all EntityDeterminer codes that are equal to or speciali…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerDescribedQuantified.md)
  * Name: EntityDeterminerDescribedQuantified
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: The described quantified determiner indicates that the given Entity is taken as a general descripti…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerDetermined.md)
  * Name: EntityDeterminerDetermined
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The described determiner is used to indicate that the given Entity is taken as a general descriptio…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerSpecific.md)
  * Name: EntityDeterminerSpecific
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The specific determiner indicates that the given Entity is taken as one specific thing instance. Fo…
* Identity: [v3-EntityDeterminer…](ValueSet-v3-EntityDeterminerSpecificGroup.md)
  * Name: EntityDeterminerSpecificGroup
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A standard value set allowing reference to all EntityDeterminer codes that are equal to or speciali…
* Identity: [v3-EntityHandling](ValueSet-v3-EntityHandling.md)
  * Name: EntityHandling
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Special handling requirements for an Entity.*Example:*Keep at room temperature; Keep frozen bel…
* Identity: [v3-EntityInformatio…](ValueSet-v3-EntityInformationSensitivityPolicy.md)
  * Name: EntityInformationSensitivityPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: EntitySensitivity codes are used to convey a policy that is applicable to sensitive information con…
* Identity: [v3-EntityNamePartQu…](ValueSet-v3-EntityNamePartQualifier.md)
  * Name: EntityNamePartQualifier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntityNamePartQu…](ValueSet-v3-EntityNamePartQualifierR2.md)
  * Name: EntityNamePartQualifierR2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The qualifier is a set of codes each of which specifies a certain subcategory of th…
* Identity: [v3-EntityNamePartTy…](ValueSet-v3-EntityNamePartType.md)
  * Name: EntityNamePartType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntityNamePartTy…](ValueSet-v3-EntityNamePartTypeR2.md)
  * Name: EntityNamePartTypeR2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc.
* Identity: [v3-EntityNameUse](ValueSet-v3-EntityNameUse.md)
  * Name: EntityNameUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EntityNameUseR2](ValueSet-v3-EntityNameUseR2.md)
  * Name: EntityNameUseR2
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A set of codes advising a system or user which name in a set of names to select for…
* Identity: [v3-EntityRisk](ValueSet-v3-EntityRisk.md)
  * Name: EntityRisk
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The vocabulary table for the Entity.riskCode attribute
* Identity: [v3-EntityStatus](ValueSet-v3-EntityStatus.md)
  * Name: EntityStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing the defined possible states of an Entity, as defined by the Entity class state m…
* Identity: [v3-EntityStatusActi…](ValueSet-v3-EntityStatusActive.md)
  * Name: EntityStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the fact that the Entity record is currently active.
* Identity: [v3-EntityStatusInac…](ValueSet-v3-EntityStatusInactive.md)
  * Name: EntityStatusInactive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The state representing the fact that the entity is inactive.
* Identity: [v3-EntityStatusNorm…](ValueSet-v3-EntityStatusNormal.md)
  * Name: EntityStatusNormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The 'typical' state. Excludes "nullified" which represents the termination state of an Entity recor…
* Identity: [v3-EntityStatusNull…](ValueSet-v3-EntityStatusNullified.md)
  * Name: EntityStatusNullified
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the termination of an Entity record instance that was created in error.
* Identity: [v3-EpiduralRoute](ValueSet-v3-EpiduralRoute.md)
  * Name: EpiduralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Epidural
* Identity: [v3-EquipmentAlertLe…](ValueSet-v3-EquipmentAlertLevel.md)
  * Name: EquipmentAlertLevel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EskimoAleut](ValueSet-v3-EskimoAleut.md)
  * Name: EskimoAleut
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Eskimoan](ValueSet-v3-Eskimoan.md)
  * Name: Eskimoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Ethnicity](ValueSet-v3-Ethnicity.md)
  * Name: Ethnicity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: In the United States, federal standards for classifying data on ethnicity determine the categories …
* Identity: [v3-EthnicityHispanic](ValueSet-v3-EthnicityHispanic.md)
  * Name: EthnicityHispanic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EthnicityHispani…](ValueSet-v3-EthnicityHispanicCentralAmerican.md)
  * Name: EthnicityHispanicCentralAmerican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EthnicityHispani…](ValueSet-v3-EthnicityHispanicMexican.md)
  * Name: EthnicityHispanicMexican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EthnicityHispani…](ValueSet-v3-EthnicityHispanicSouthAmerican.md)
  * Name: EthnicityHispanicSouthAmerican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-EthnicityHispani…](ValueSet-v3-EthnicityHispanicSpaniard.md)
  * Name: EthnicityHispanicSpaniard
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ExpectedSubset](ValueSet-v3-ExpectedSubset.md)
  * Name: ExpectedSubset
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An occurrence that is scheduled to occur in the future. An Act whose effective time is greater than…
* Identity: [v3-ExposureMode](ValueSet-v3-ExposureMode.md)
  * Name: ExposureMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the pa…
* Identity: [v3-ExtendedReleaseC…](ValueSet-v3-ExtendedReleaseCapsule.md)
  * Name: ExtendedReleaseCapsule
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A solid dosage form in which the drug is enclosed within either a hard or soft soluble container ma…
* Identity: [v3-ExtendedReleaseS…](ValueSet-v3-ExtendedReleaseSuspension.md)
  * Name: ExtendedReleaseSuspension
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ExtendedReleaseT…](ValueSet-v3-ExtendedReleaseTablet.md)
  * Name: ExtendedReleaseTablet
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A solid dosage form containing a drug which allows at least a reduction in dosing frequency as comp…
* Identity: [v3-ExtraAmnioticRou…](ValueSet-v3-ExtraAmnioticRoute.md)
  * Name: ExtraAmnioticRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Extra-amniotic
* Identity: [v3-ExtracorporealCi…](ValueSet-v3-ExtracorporealCirculationRoute.md)
  * Name: ExtracorporealCirculationRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Extracorporeal circulation
* Identity: [v3-FamilyMember](ValueSet-v3-FamilyMember.md)
  * Name: FamilyMember
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between two people characterizing their "familial" relationship
* Identity: [v3-FirstFillPharmac…](ValueSet-v3-FirstFillPharmacySupplyType.md)
  * Name: FirstFillPharmacySupplyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The initial fill against an order. (This includes initial fills against refill orders.)
* Identity: [v3-Flush](ValueSet-v3-Flush.md)
  * Name: Flush
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Flush
* Identity: [v3-FoamDrugForm](ValueSet-v3-FoamDrugForm.md)
  * Name: FoamDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-FontStyle](ValueSet-v3-FontStyle.md)
  * Name: FontStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (abstract) Defines font rendering characteristics
* Identity: [v3-FosterChild](ValueSet-v3-FosterChild.md)
  * Name: FosterChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child receiving parental care and nurture from the scoping person (pare…
* Identity: [v3-GIClinicPractice…](ValueSet-v3-GIClinicPracticeSetting.md)
  * Name: GIClinicPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-GIDiagTherPracti…](ValueSet-v3-GIDiagTherPracticeSetting.md)
  * Name: GIDiagTherPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A practice setting where GI procedures (such as endoscopies) are performed
* Identity: [v3-GTIN](ValueSet-v3-GTIN.md)
  * Name: GTIN
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Global Trade Item Number is an identifier for trade items developed by GS1 (compris…
* Identity: [v3-GTSAbbreviation](ValueSet-v3-GTSAbbreviation.md)
  * Name: GTSAbbreviation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-GTSAbbreviationB…](ValueSet-v3-GTSAbbreviationBase.md)
  * Name: GTSAbbreviationBase
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Basic abbreviations defined for the General timing Specification data type.
* Identity: [v3-GTSAbbreviationH…](ValueSet-v3-GTSAbbreviationHolidays.md)
  * Name: GTSAbbreviationHolidays
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Holidays
* Identity: [v3-GTSAbbreviationH…](ValueSet-v3-GTSAbbreviationHolidaysChristianRoman.md)
  * Name: GTSAbbreviationHolidaysChristianRoman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Christian Holidays (Roman/Gregorian "Western" Tradition.)
* Identity: [v3-GTSAbbreviationH…](ValueSet-v3-GTSAbbreviationHolidaysUSNational.md)
  * Name: GTSAbbreviationHolidaysUSNational
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: United States National Holidays (public holidays for federal employees established by U.S. Federal …
* Identity: [v3-GTSAbbreviationO…](ValueSet-v3-GTSAbbreviationOther.md)
  * Name: GTSAbbreviationOther
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Other, more specific, abbreviations defined for the General timing Specification da…
* Identity: [v3-GasDrugForm](ValueSet-v3-GasDrugForm.md)
  * Name: GasDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Any elastic aeriform fluid in which the molecules are separated from one another and have free path…
* Identity: [v3-GasLiquidMixture](ValueSet-v3-GasLiquidMixture.md)
  * Name: GasLiquidMixture
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-GasSolidSpray](ValueSet-v3-GasSolidSpray.md)
  * Name: GasSolidSpray
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-GastricRoute](ValueSet-v3-GastricRoute.md)
  * Name: GastricRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Gastric
* Identity: [v3-GelDrugForm](ValueSet-v3-GelDrugForm.md)
  * Name: GelDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A semisolid system consisting of either suspensions made up of small inorganic particles or large o…
* Identity: [v3-GenderStatus](ValueSet-v3-GenderStatus.md)
  * Name: GenderStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing whether the primary reproductive organs of NonPersonLivingSubject are present.
* Identity: [v3-GeneralAcuteCare…](ValueSet-v3-GeneralAcuteCareHospital.md)
  * Name: GeneralAcuteCareHospital
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (X12N 282N00000N)
* Identity: [v3-GeneralAddressUse](ValueSet-v3-GeneralAddressUse.md)
  * Name: GeneralAddressUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-GeneralPurposeOf…](ValueSet-v3-GeneralPurposeOfUse.md)
  * Name: GeneralPurposeOfUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Supports communication of purpose of use at a general level.
* Identity: [v3-GenericUpdateRea…](ValueSet-v3-GenericUpdateReasonCode.md)
  * Name: GenericUpdateReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies why a change is being made to a record.
* Identity: [v3-GeneticObservati…](ValueSet-v3-GeneticObservationInterpretation.md)
  * Name: GeneticObservationInterpretation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes that specify interpretation of genetic analysis, such as "positive", "negative", "carrier", "…
* Identity: [v3-GeneticObservati…](ValueSet-v3-GeneticObservationMethod.md)
  * Name: GeneticObservationMethod
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code that provides additional detail about the means or technique used to ascertain the genetic a…
* Identity: [v3-GeneticObservati…](ValueSet-v3-GeneticObservationType.md)
  * Name: GeneticObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Identifies the kinds of genetic observations that can be performed.
* Identity: [v3-GeneticObservati…](ValueSet-v3-GeneticObservationValue.md)
  * Name: GeneticObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The domain contains genetic analysis specific observation values, e.g. Homozygote,…
* Identity: [v3-GenitourinaryRou…](ValueSet-v3-GenitourinaryRoute.md)
  * Name: GenitourinaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Genitourinary
* Identity: [v3-GingivalRoute](ValueSet-v3-GingivalRoute.md)
  * Name: GingivalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Gingival
* Identity: [v3-GrandChild](ValueSet-v3-GrandChild.md)
  * Name: GrandChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child of the scoping person's son or daughter.
* Identity: [v3-Grandparent](ValueSet-v3-Grandparent.md)
  * Name: Grandparent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: parent of a parent of the subject
* Identity: [v3-GreatGrandparent](ValueSet-v3-GreatGrandparent.md)
  * Name: GreatGrandparent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a parent of the scoping person's grandparent.
* Identity: [v3-GregorianCalenda…](ValueSet-v3-GregorianCalendarCycle.md)
  * Name: GregorianCalendarCycle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-HL7Accommodation…](ValueSet-v3-HL7AccommodationCode.md)
  * Name: HL7AccommodationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Accommodation type. In Intent mood, represents the accommodation type requested. In…
* Identity: [v3-HL7CalendarCycle](ValueSet-v3-HL7CalendarCycle.md)
  * Name: HL7CalendarCycle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-HL7FormatCodes](ValueSet-v3-HL7FormatCodes.md)
  * Name: HL7 ValueSet of Format Codes for use with Document Sharing
  * Version: 2.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: The HL7-FormatCodes value set is defined to be the set of FormatCode(s) defined by implementation g…
* Identity: [v3-HL7ITSVersionCode](ValueSet-v3-HL7ITSVersionCode.md)
  * Name: HL7ITSVersionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: HL7 implementation technology specification versions. These codes will document the ITS type and ve…
* Identity: [v3-HL7SearchUse](ValueSet-v3-HL7SearchUse.md)
  * Name: HL7SearchUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-HL7StandardVersi…](ValueSet-v3-HL7StandardVersionCode.md)
  * Name: HL7StandardVersionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This is the domain of HL7 version codes for the Version 3 standards. Values are to be determined by…
* Identity: [v3-HL7UpdateMode](ValueSet-v3-HL7UpdateMode.md)
  * Name: HL7UpdateMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The possible modes of updating that occur when an attribute is received by a system that already co…
* Identity: [v3-HairRoute](ValueSet-v3-HairRoute.md)
  * Name: HairRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hair
* Identity: [v3-HalfSibling](ValueSet-v3-HalfSibling.md)
  * Name: HalfSibling
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is related to the scoping entity by sharing only one biological parent.
* Identity: [v3-HealthCareCommon…](ValueSet-v3-HealthCareCommonProcedureCodingSystem.md)
  * Name: HealthCareCommonProcedureCodingSystem
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-10-11
  * Description: This value set includes all HCPCS Level II codes.
* Identity: [v3-HealthQualityMea…](ValueSet-v3-HealthQualityMeasureDocument.md)
  * Name: HealthQualityMeasureDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-14
  * Description: ** **No description** **
* Identity: [v3-HealthcareServic…](ValueSet-v3-HealthcareServiceLocation.md)
  * Name: HealthcareServiceLocation
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A comprehensive classification of locations and settings where healthcare services are provided. Th…
* Identity: [v3-HeightSurfaceAre…](ValueSet-v3-HeightSurfaceAreaAlert.md)
  * Name: HeightSurfaceAreaAlert
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate based on the patient's height or body surface area
* Identity: [v3-HemClinPracticeS…](ValueSet-v3-HemClinPracticeSetting.md)
  * Name: HemClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Hokan](ValueSet-v3-Hokan.md)
  * Name: Hokan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-HomeAddress](ValueSet-v3-HomeAddress.md)
  * Name: HomeAddress
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Homeless](ValueSet-v3-Homeless.md)
  * Name: Homeless
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Living arrangements lacking a permanent residence.
* Identity: [v3-HospitalPractice…](ValueSet-v3-HospitalPracticeSetting.md)
  * Name: HospitalPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An acute care institution that provides medical, surgical, or psychiatric care and treatment for th…
* Identity: [v3-HospitalUnitPrac…](ValueSet-v3-HospitalUnitPracticeSetting.md)
  * Name: HospitalUnitPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-HtmlLinkType](ValueSet-v3-HtmlLinkType.md)
  * Name: HtmlLinkType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current docum…
* Identity: [v3-HumanActSite](ValueSet-v3-HumanActSite.md)
  * Name: HumanActSite
  * Version: 2.0.0
  * Status: retired
  * Owner: n/a
  * Copyright: n/a
  * Date: 2014-03-26
  * Description: An anatomical location on a human which can be the focus of an act.**OpenIssue:**This value set …
* Identity: [v3-HumanSubstanceAd…](ValueSet-v3-HumanSubstanceAdministrationSite.md)
  * Name: HumanSubstanceAdministrationSite
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The set of body locations to or through which a drug product may be administered.
* Identity: [v3-ICUPracticeSetti…](ValueSet-v3-ICUPracticeSetting.md)
  * Name: ICUPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-IDClinPracticeSe…](ValueSet-v3-IDClinPracticeSetting.md)
  * Name: IDClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-IdentifierReliab…](ValueSet-v3-IdentifierReliability.md)
  * Name: IdentifierReliability
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The identifier was issued by the system responsible for constructing the instance.
* Identity: [v3-IdentifierScope](ValueSet-v3-IdentifierScope.md)
  * Name: IdentifierScope
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Codes to specify the scope in which the identifier applies to the object with whic…
* Identity: [v3-ImageMediaType](ValueSet-v3-ImageMediaType.md)
  * Name: ImageMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Image media type.
* Identity: [v3-ImmunizationObse…](ValueSet-v3-ImmunizationObservationType.md)
  * Name: ImmunizationObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Indicates the valid antigen count.
* Identity: [v3-Implantation](ValueSet-v3-Implantation.md)
  * Name: Implantation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Implantation
* Identity: [v3-IncidentalServic…](ValueSet-v3-IncidentalServiceDeliveryLocationRoleType.md)
  * Name: IncidentalServiceDeliveryLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-IndividualCaseSa…](ValueSet-v3-IndividualCaseSafetyReportType.md)
  * Name: IndividualCaseSafetyReportType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: All codes from code system ActCode._IndividualCaseSafetyReportType
* Identity: [v3-IndividualInsure…](ValueSet-v3-IndividualInsuredCoveredPartyRoleType.md)
  * Name: IndividualInsuredCoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description**A role recognized through the eligibility of a party to play an individual insured f…
* Identity: [v3-IndividualPackag…](ValueSet-v3-IndividualPackageEntityType.md)
  * Name: IndividualPackageEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Container intended to contain sufficient material for only one use.
* Identity: [v3-IndustryClassifi…](ValueSet-v3-IndustryClassificationSystem.md)
  * Name: IndustryClassificationSystem
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-InformationSensi…](ValueSet-v3-InformationSensitivityPolicy.md)
  * Name: InformationSensitivityPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sensitivity codes are not useful for interoperability outside of a policy domain because sensitivit…
* Identity: [v3-Infusion](ValueSet-v3-Infusion.md)
  * Name: Infusion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Infusion
* Identity: [v3-InhalantDrugForm](ValueSet-v3-InhalantDrugForm.md)
  * Name: InhalantDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Inhalation](ValueSet-v3-Inhalation.md)
  * Name: Inhalation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Inhalation
* Identity: [v3-InhalerMedicalDe…](ValueSet-v3-InhalerMedicalDevice.md)
  * Name: InhalerMedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A small device used for inhaling medicine in the form of a vapour or gas in order to ease a respira…
* Identity: [v3-Injection](ValueSet-v3-Injection.md)
  * Name: Injection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection
* Identity: [v3-InjectionMedical…](ValueSet-v3-InjectionMedicalDevice.md)
  * Name: InjectionMedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device intended to administer liquid into a subject via a
* Identity: [v3-Insertion](ValueSet-v3-Insertion.md)
  * Name: Insertion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Insertion
* Identity: [v3-Instillation](ValueSet-v3-Instillation.md)
  * Name: Instillation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Instillation
* Identity: [v3-Institution](ValueSet-v3-Institution.md)
  * Name: Institution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Institution
* Identity: [v3-IntegrityCheckAl…](ValueSet-v3-IntegrityCheckAlgorithm.md)
  * Name: IntegrityCheckAlgorithm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-InteractionDetec…](ValueSet-v3-InteractionDetectedIssueCode.md)
  * Name: InteractionDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-InterameningealR…](ValueSet-v3-InterameningealRoute.md)
  * Name: InterameningealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interameningeal
* Identity: [v3-InteriorSalish](ValueSet-v3-InteriorSalish.md)
  * Name: InteriorSalish
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-InterstitialRoute](ValueSet-v3-InterstitialRoute.md)
  * Name: InterstitialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interstitial
* Identity: [v3-IntraabdominalRo…](ValueSet-v3-IntraabdominalRoute.md)
  * Name: IntraabdominalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intra-abdominal
* Identity: [v3-IntraarterialInj…](ValueSet-v3-IntraarterialInjection.md)
  * Name: IntraarterialInjection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection, intraarterial
* Identity: [v3-IntraarterialRou…](ValueSet-v3-IntraarterialRoute.md)
  * Name: IntraarterialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intra-arterial
* Identity: [v3-IntraarticularRo…](ValueSet-v3-IntraarticularRoute.md)
  * Name: IntraarticularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraarticular
* Identity: [v3-IntrabronchialRo…](ValueSet-v3-IntrabronchialRoute.md)
  * Name: IntrabronchialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrabronchial
* Identity: [v3-IntrabursalRoute](ValueSet-v3-IntrabursalRoute.md)
  * Name: IntrabursalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrabursal
* Identity: [v3-IntracardiacInje…](ValueSet-v3-IntracardiacInjection.md)
  * Name: IntracardiacInjection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection, intracardiac
* Identity: [v3-IntracardiacRoute](ValueSet-v3-IntracardiacRoute.md)
  * Name: IntracardiacRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracardiac
* Identity: [v3-Intracartilagino…](ValueSet-v3-IntracartilaginousRoute.md)
  * Name: IntracartilaginousRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracartilaginous
* Identity: [v3-IntracaudalRoute](ValueSet-v3-IntracaudalRoute.md)
  * Name: IntracaudalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracaudal
* Identity: [v3-IntracavernosalR…](ValueSet-v3-IntracavernosalRoute.md)
  * Name: IntracavernosalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracavernosal
* Identity: [v3-IntracavitaryRou…](ValueSet-v3-IntracavitaryRoute.md)
  * Name: IntracavitaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracavitary
* Identity: [v3-IntracerebralRou…](ValueSet-v3-IntracerebralRoute.md)
  * Name: IntracerebralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracerebral
* Identity: [v3-IntracervicalRou…](ValueSet-v3-IntracervicalRoute.md)
  * Name: IntracervicalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracervical
* Identity: [v3-IntracisternalRo…](ValueSet-v3-IntracisternalRoute.md)
  * Name: IntracisternalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracisternal
* Identity: [v3-IntracornealRoute](ValueSet-v3-IntracornealRoute.md)
  * Name: IntracornealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracorneal
* Identity: [v3-IntracoronalRoute](ValueSet-v3-IntracoronalRoute.md)
  * Name: IntracoronalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracoronal (dental)
* Identity: [v3-IntracoronaryInj…](ValueSet-v3-IntracoronaryInjection.md)
  * Name: IntracoronaryInjection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection, intracoronary
* Identity: [v3-IntracoronaryRou…](ValueSet-v3-IntracoronaryRoute.md)
  * Name: IntracoronaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracoronary
* Identity: [v3-IntracorpusCaver…](ValueSet-v3-IntracorpusCavernosumRoute.md)
  * Name: IntracorpusCavernosumRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intracorpus cavernosum
* Identity: [v3-IntradermalRoute](ValueSet-v3-IntradermalRoute.md)
  * Name: IntradermalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intradermal
* Identity: [v3-IntradiscalRoute](ValueSet-v3-IntradiscalRoute.md)
  * Name: IntradiscalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intradiscal
* Identity: [v3-IntraductalRoute](ValueSet-v3-IntraductalRoute.md)
  * Name: IntraductalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraductal
* Identity: [v3-IntraduodenalRou…](ValueSet-v3-IntraduodenalRoute.md)
  * Name: IntraduodenalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraduodenal
* Identity: [v3-IntraduralRoute](ValueSet-v3-IntraduralRoute.md)
  * Name: IntraduralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intradural
* Identity: [v3-IntraepidermalRo…](ValueSet-v3-IntraepidermalRoute.md)
  * Name: IntraepidermalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraepidermal
* Identity: [v3-IntraepithelialR…](ValueSet-v3-IntraepithelialRoute.md)
  * Name: IntraepithelialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraepithelial
* Identity: [v3-IntraesophagealR…](ValueSet-v3-IntraesophagealRoute.md)
  * Name: IntraesophagealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraesophageal
* Identity: [v3-IntragastricRoute](ValueSet-v3-IntragastricRoute.md)
  * Name: IntragastricRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intragastric
* Identity: [v3-IntrailealRoute](ValueSet-v3-IntrailealRoute.md)
  * Name: IntrailealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraileal
* Identity: [v3-IntralesionalRou…](ValueSet-v3-IntralesionalRoute.md)
  * Name: IntralesionalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intralesional
* Identity: [v3-IntraluminalRoute](ValueSet-v3-IntraluminalRoute.md)
  * Name: IntraluminalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraluminal
* Identity: [v3-IntralymphaticRo…](ValueSet-v3-IntralymphaticRoute.md)
  * Name: IntralymphaticRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intralymphatic
* Identity: [v3-IntramedullaryRo…](ValueSet-v3-IntramedullaryRoute.md)
  * Name: IntramedullaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intramedullary
* Identity: [v3-IntramuscularInj…](ValueSet-v3-IntramuscularInjection.md)
  * Name: IntramuscularInjection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection, intramuscular
* Identity: [v3-IntramuscularRou…](ValueSet-v3-IntramuscularRoute.md)
  * Name: IntramuscularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intramuscular
* Identity: [v3-IntraocularRoute](ValueSet-v3-IntraocularRoute.md)
  * Name: IntraocularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraocular
* Identity: [v3-IntraosseousRoute](ValueSet-v3-IntraosseousRoute.md)
  * Name: IntraosseousRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraosseous
* Identity: [v3-IntraovarianRoute](ValueSet-v3-IntraovarianRoute.md)
  * Name: IntraovarianRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraovarian
* Identity: [v3-Intrapericardial…](ValueSet-v3-IntrapericardialRoute.md)
  * Name: IntrapericardialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrapericardial
* Identity: [v3-IntraperitonealR…](ValueSet-v3-IntraperitonealRoute.md)
  * Name: IntraperitonealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraperitoneal
* Identity: [v3-IntrapleuralRoute](ValueSet-v3-IntrapleuralRoute.md)
  * Name: IntrapleuralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrapleural
* Identity: [v3-IntraprostaticRo…](ValueSet-v3-IntraprostaticRoute.md)
  * Name: IntraprostaticRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraprostatic
* Identity: [v3-IntrapulmonaryRo…](ValueSet-v3-IntrapulmonaryRoute.md)
  * Name: IntrapulmonaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrapulmonary
* Identity: [v3-IntrasinalRoute](ValueSet-v3-IntrasinalRoute.md)
  * Name: IntrasinalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrasinal
* Identity: [v3-IntraspinalRoute](ValueSet-v3-IntraspinalRoute.md)
  * Name: IntraspinalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraspinal
* Identity: [v3-IntrasternalRoute](ValueSet-v3-IntrasternalRoute.md)
  * Name: IntrasternalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrasternal
* Identity: [v3-IntrasynovialRou…](ValueSet-v3-IntrasynovialRoute.md)
  * Name: IntrasynovialRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrasynovial
* Identity: [v3-IntratendinousRo…](ValueSet-v3-IntratendinousRoute.md)
  * Name: IntratendinousRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratendinous
* Identity: [v3-IntratesticularR…](ValueSet-v3-IntratesticularRoute.md)
  * Name: IntratesticularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratesticular
* Identity: [v3-IntrathecalRoute](ValueSet-v3-IntrathecalRoute.md)
  * Name: IntrathecalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrathecal
* Identity: [v3-IntrathoracicRou…](ValueSet-v3-IntrathoracicRoute.md)
  * Name: IntrathoracicRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrathoracic
* Identity: [v3-IntratrachealRou…](ValueSet-v3-IntratrachealRoute.md)
  * Name: IntratrachealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratracheal
* Identity: [v3-IntratubularRoute](ValueSet-v3-IntratubularRoute.md)
  * Name: IntratubularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratubular
* Identity: [v3-IntratumorRoute](ValueSet-v3-IntratumorRoute.md)
  * Name: IntratumorRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratumor
* Identity: [v3-IntratympanicRou…](ValueSet-v3-IntratympanicRoute.md)
  * Name: IntratympanicRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intratympanic
* Identity: [v3-IntrauterineRoute](ValueSet-v3-IntrauterineRoute.md)
  * Name: IntrauterineRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intrauterine
* Identity: [v3-IntravascularRou…](ValueSet-v3-IntravascularRoute.md)
  * Name: IntravascularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intravascular
* Identity: [v3-IntravenousInfus…](ValueSet-v3-IntravenousInfusion.md)
  * Name: IntravenousInfusion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Infusion, intravenous
* Identity: [v3-IntravenousInjec…](ValueSet-v3-IntravenousInjection.md)
  * Name: IntravenousInjection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Injection, intravenous
* Identity: [v3-IntravenousRoute](ValueSet-v3-IntravenousRoute.md)
  * Name: IntravenousRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intravenous
* Identity: [v3-Intraventricular…](ValueSet-v3-IntraventricularRoute.md)
  * Name: IntraventricularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intraventricular
* Identity: [v3-IntravesicleRoute](ValueSet-v3-IntravesicleRoute.md)
  * Name: IntravesicleRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intravesicle
* Identity: [v3-IntravitrealRoute](ValueSet-v3-IntravitrealRoute.md)
  * Name: IntravitrealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Intravitreal
* Identity: [v3-InuitInupiaq](ValueSet-v3-InuitInupiaq.md)
  * Name: InuitInupiaq
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-InvoiceElementAd…](ValueSet-v3-InvoiceElementAdjudicated.md)
  * Name: InvoiceElementAdjudicated
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Total counts and total net amounts adjudicated for all Invoice Groupings that were adjudicated with…
* Identity: [v3-InvoiceElementPa…](ValueSet-v3-InvoiceElementPaid.md)
  * Name: InvoiceElementPaid
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Total counts and total net amounts paid for all Invoice Groupings that were paid within a time peri…
* Identity: [v3-InvoiceElementSu…](ValueSet-v3-InvoiceElementSubmitted.md)
  * Name: InvoiceElementSubmitted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Total counts and total net amounts billed for all Invoice Groupings that were submitted within a ti…
* Identity: [v3-IontophoresisRou…](ValueSet-v3-IontophoresisRoute.md)
  * Name: IontophoresisRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Iontophoresis
* Identity: [v3-Iroquoian](ValueSet-v3-Iroquoian.md)
  * Name: Iroquoian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Irrigation](ValueSet-v3-Irrigation.md)
  * Name: Irrigation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Irrigation
* Identity: [v3-IrrigationSoluti…](ValueSet-v3-IrrigationSolution.md)
  * Name: IrrigationSolution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A sterile solution intended to bathe or flush open wounds or body cavities; they're used topically,…
* Identity: [v3-IssueFilterCode](ValueSet-v3-IssueFilterCode.md)
  * Name: IssueFilterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Indicates how result sets should be filtered based on whether they have associated …
* Identity: [v3-JejunumRoute](ValueSet-v3-JejunumRoute.md)
  * Name: JejunumRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Jejunum
* Identity: [v3-Kalapuyan](ValueSet-v3-Kalapuyan.md)
  * Name: Kalapuyan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Keresan](ValueSet-v3-Keresan.md)
  * Name: Keresan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-KiowaTanoan](ValueSet-v3-KiowaTanoan.md)
  * Name: KiowaTanoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-KitEntityType](ValueSet-v3-KitEntityType.md)
  * Name: KitEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container for a diverse collection of products intended to be used together for some purpose (e.g…
* Identity: [v3-KnowledgeSubject…](ValueSet-v3-KnowledgeSubjectObservationCode.md)
  * Name: KnowledgeSubjectObservationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-KnowledgeSubject…](ValueSet-v3-KnowledgeSubjectObservationValue.md)
  * Name: KnowledgeSubjectObservationValue
  * Version: 5.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-16
  * Description: Observation values used to indicate a knowledge subject of interest for which knowledge content is …
* Identity: [v3-KnowledgeSubtopi…](ValueSet-v3-KnowledgeSubtopicObservationCode.md)
  * Name: KnowledgeSubtopicObservationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-KnowledgeSubtopi…](ValueSet-v3-KnowledgeSubtopicObservationValue.md)
  * Name: KnowledgeSubtopicObservationValue
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-16
  * Description: Observation values used to indicate a knowledge subtopic of interest for which knowledge content is…
* Identity: [v3-KoyukonIngalik](ValueSet-v3-KoyukonIngalik.md)
  * Name: KoyukonIngalik
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-KutchinHan](ValueSet-v3-KutchinHan.md)
  * Name: KutchinHan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-LOINCObservation…](ValueSet-v3-LOINCObservationActContextAgeDefinitionCode.md)
  * Name: LOINCObservationActContextAgeDefinitionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-16
  * Description: Identifies a type of observation that captures the age of an entity involved in an act with no impl…
* Identity: [v3-LOINCObservation…](ValueSet-v3-LOINCObservationActContextAgeType.md)
  * Name: LOINCObservationActContextAgeType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The set of LOINC codes for the act of determining the period of time that has elapse…
* Identity: [v3-LabResultReporti…](ValueSet-v3-LabResultReportingProcessStepCode.md)
  * Name: LabResultReportingProcessStepCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-LabResultTrigger…](ValueSet-v3-LabResultTriggerEvents.md)
  * Name: LabResultTriggerEvents
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Trigger Event ID as published in the standard.
* Identity: [v3-LabSpecimenColle…](ValueSet-v3-LabSpecimenCollectionProviders.md)
  * Name: LabSpecimenCollectionProviders
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-LacrimalPunctaRo…](ValueSet-v3-LacrimalPunctaRoute.md)
  * Name: LacrimalPunctaRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Lacrimal puncta
* Identity: [v3-LanguageAbilityM…](ValueSet-v3-LanguageAbilityMode.md)
  * Name: LanguageAbilityMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing the method of expression of the language.*Example:*Expressed spoken, expre…
* Identity: [v3-LanguageAbilityP…](ValueSet-v3-LanguageAbilityProficiency.md)
  * Name: LanguageAbilityProficiency
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing the level of proficiency in a language.*Example:*Excellent, good, fair, po…
* Identity: [v3-LaryngealRoute](ValueSet-v3-LaryngealRoute.md)
  * Name: LaryngealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Laryngeal
* Identity: [v3-LavageRoute](ValueSet-v3-LavageRoute.md)
  * Name: LavageRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Lavage
* Identity: [v3-LengthOutOfRange](ValueSet-v3-LengthOutOfRange.md)
  * Name: LengthOutOfRange
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-LifeInsurancePol…](ValueSet-v3-LifeInsurancePolicy.md)
  * Name: LifeInsurancePolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A policy under which the insurer agrees to pay a sum of money upon the occurrence o…
* Identity: [v3-LineAccessMedica…](ValueSet-v3-LineAccessMedicalDevice.md)
  * Name: LineAccessMedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A hollow tube used to administer a substance into a vein, artery or body cavity
* Identity: [v3-LingualRoute](ValueSet-v3-LingualRoute.md)
  * Name: LingualRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Lingual
* Identity: [v3-Liquid](ValueSet-v3-Liquid.md)
  * Name: Liquid
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A state of substance that is an intermediate one entered into as matter goes from solid to gas; liq…
* Identity: [v3-LiquidCleanser](ValueSet-v3-LiquidCleanser.md)
  * Name: LiquidCleanser
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-LiquidLiquidEmul…](ValueSet-v3-LiquidLiquidEmulsion.md)
  * Name: LiquidLiquidEmulsion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A two-phase system in which one liquid is dispersed throughout another liquid in the form of small …
* Identity: [v3-LiquidSolidSuspe…](ValueSet-v3-LiquidSolidSuspension.md)
  * Name: LiquidSolidSuspension
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A liquid preparation which consists of solid particles dispersed throughout a liquid phase in which…
* Identity: [v3-ListStyle](ValueSet-v3-ListStyle.md)
  * Name: ListStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Defines list rendering characteristics
* Identity: [v3-LivingArrangement](ValueSet-v3-LivingArrangement.md)
  * Name: LivingArrangement
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code depicting the living arrangements of a person
* Identity: [v3-LivingSubjectPro…](ValueSet-v3-LivingSubjectProductionClass.md)
  * Name: LivingSubjectProductionClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code indicating the primary use for which a living subject is bred or grown
* Identity: [v3-Loan](ValueSet-v3-Loan.md)
  * Name: Loan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Temporary supply of a product without transfer of ownership for the product.
* Identity: [v3-LocalMarkupIgnore](ValueSet-v3-LocalMarkupIgnore.md)
  * Name: LocalMarkupIgnore
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Tells a receiver to ignore just the local markup tags (local_markup, local_header, local_attr) w…
* Identity: [v3-LocalRemoteContr…](ValueSet-v3-LocalRemoteControlState.md)
  * Name: LocalRemoteControlState
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing the current state of control associated with the device.**Examples:**A devi…
* Identity: [v3-LogicalObservati…](ValueSet-v3-LogicalObservationIdentifierNamesAndCodes.md)
  * Name: LogicalObservationIdentifierNamesAndCodes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The LOINC database provides a set of universal names and ID codes for identifying laboratory and cl…
* Identity: [v3-LoincDocumentOnt…](ValueSet-v3-LoincDocumentOntologyInternational.md)
  * Name: LoincDocumentOntologyInternational
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-14
  * Description: The LOINC Document Ontology constrained for usage in the Universal Realm by removal of "regional" D…
* Identity: [v3-LotionDrugForm](ValueSet-v3-LotionDrugForm.md)
  * Name: LotionDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The term "lotion" has been used to categorize many topical suspensions, solutions and emulsions int…
* Identity: [v3-Maiduan](ValueSet-v3-Maiduan.md)
  * Name: Maiduan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ManagedCarePolicy](ValueSet-v3-ManagedCarePolicy.md)
  * Name: ManagedCarePolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Government mandated program providing coverage, disability income, and vocational r…
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatus.md)
  * Name: ManagedParticipationStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing the defined possible states of a Managed Participation, as defined by the Manage…
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusActive.md)
  * Name: ManagedParticipationStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the fact that the Participation is in progress.
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusCancelled.md)
  * Name: ManagedParticipationStatusCancelled
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The terminal state resulting from cancellation of the Participation prior to activation.
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusCompleted.md)
  * Name: ManagedParticipationStatusCompleted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The terminal state representing the successful completion of the Participation.
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusNormal.md)
  * Name: ManagedParticipationStatusNormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The 'typical' state. Excludes "nullified" which represents the termination state of a participation…
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusNullified.md)
  * Name: ManagedParticipationStatusNullified
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the termination of a Participation instance that was created in error.
* Identity: [v3-ManagedParticipa…](ValueSet-v3-ManagedParticipationStatusPending.md)
  * Name: ManagedParticipationStatusPending
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing that fact that the Participation has not yet become active.
* Identity: [v3-ManufacturerMode…](ValueSet-v3-ManufacturerModelNameExample.md)
  * Name: Manufacturer Model Name Example
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: An example value set representing the ManufacturerModelName concept domain used to convey a coded …
* Identity: [v3-MapRelationship](ValueSet-v3-MapRelationship.md)
  * Name: MapRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept …
* Identity: [v3-MaritalStatus](ValueSet-v3-MaritalStatus.md)
  * Name: MaritalStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The domestic partnership status of a person.*Example:*Married, separated, divorced, widowed, co…
* Identity: [v3-MaterialDangerIn…](ValueSet-v3-MaterialDangerInfectious.md)
  * Name: MaterialDangerInfectious
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Material known to be infectious with human pathogenic microorganisms. Those who handle this materia…
* Identity: [v3-MaterialDangerIn…](ValueSet-v3-MaterialDangerInflammable.md)
  * Name: MaterialDangerInflammable
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Material is highly inflammable and in certain mixtures (with air) may lead to explosions. Keep away…
* Identity: [v3-MaterialEntityCl…](ValueSet-v3-MaterialEntityClassType.md)
  * Name: MaterialEntityClassType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Types of Material for EntityClass "MAT"
* Identity: [v3-MedOncClinPracti…](ValueSet-v3-MedOncClinPracticeSetting.md)
  * Name: MedOncClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-MediaType](ValueSet-v3-MediaType.md)
  * Name: MediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Internet Assigned Numbers Authority (IANA) Mime Media Types
* Identity: [v3-MedicalDevice](ValueSet-v3-MedicalDevice.md)
  * Name: MedicalDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device with direct or indirect therapeutic purpose. Values for EntityCode when EntityClass = "DEV"
* Identity: [v3-MedicationCap](ValueSet-v3-MedicationCap.md)
  * Name: MedicationCap
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Cap types for medication containers
* Identity: [v3-MedicationGenera…](ValueSet-v3-MedicationGeneralizationRoleType.md)
  * Name: MedicationGeneralizationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the specific hierarchical relationship between the playing and scoping medications.*…
* Identity: [v3-MedicationObserv…](ValueSet-v3-MedicationObservationType.md)
  * Name: MedicationObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-MedicationOrderA…](ValueSet-v3-MedicationOrderAbortReasonCode.md)
  * Name: MedicationOrderAbortReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-MedicationOrderR…](ValueSet-v3-MedicationOrderReleaseReasonCode.md)
  * Name: MedicationOrderReleaseReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A collection of concepts that indicate why the prescription should be released from …
* Identity: [v3-MemberRoleType](ValueSet-v3-MemberRoleType.md)
  * Name: MemberRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role type that is used to further qualify an entity playing a role where the role class attribute…
* Identity: [v3-MessageWaitingPr…](ValueSet-v3-MessageWaitingPriority.md)
  * Name: MessageWaitingPriority
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates the highest importance level of the set of messages the acknowledging application has wai…
* Identity: [v3-MilitaryHospital](ValueSet-v3-MilitaryHospital.md)
  * Name: MilitaryHospital
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A health care facility operated by the Department of Defense or other military operation.
* Identity: [v3-MilitaryRoleType](ValueSet-v3-MilitaryRoleType.md)
  * Name: MilitaryRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A person playing the role of program eligible under a program based on military sta…
* Identity: [v3-MississippiValley](ValueSet-v3-MississippiValley.md)
  * Name: MississippiValley
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-MissouriRiver](ValueSet-v3-MissouriRiver.md)
  * Name: MissouriRiver
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Miwokan](ValueSet-v3-Miwokan.md)
  * Name: Miwokan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-MobileUnit](ValueSet-v3-MobileUnit.md)
  * Name: MobileUnit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Location (mobile) where healthcare service was delivered.
* Identity: [v3-MobilityImpaired](ValueSet-v3-MobilityImpaired.md)
  * Name: MobilityImpaired
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ModelMediaType](ValueSet-v3-ModelMediaType.md)
  * Name: ModelMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Model media type.
* Identity: [v3-ModifyIndicator](ValueSet-v3-ModifyIndicator.md)
  * Name: ModifyIndicator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates whether the subscription to a query is new or is being modified.
* Identity: [v3-ModifyPrescripti…](ValueSet-v3-ModifyPrescriptionReasonType.md)
  * Name: ModifyPrescriptionReasonType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates why an existing prescription is changed.
* Identity: [v3-MucosalAbsorptio…](ValueSet-v3-MucosalAbsorptionRoute.md)
  * Name: MucosalAbsorptionRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Mucosal absorption
* Identity: [v3-MucousMembraneRo…](ValueSet-v3-MucousMembraneRoute.md)
  * Name: MucousMembraneRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Mucous membrane
* Identity: [v3-MultiUseContaine…](ValueSet-v3-MultiUseContainerEntityType.md)
  * Name: MultiUseContainerEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container intended to contain sufficient material for more than one use. (I.e. Material is intend…
* Identity: [v3-MultipartMediaTy…](ValueSet-v3-MultipartMediaType.md)
  * Name: MultipartMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Multipart Media Type
* Identity: [v3-Muskogean](ValueSet-v3-Muskogean.md)
  * Name: Muskogean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NUCCProviderCodes](ValueSet-v3-NUCCProviderCodes.md)
  * Name: NUCCProviderCodes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: In the absence of an all-encompassing Provider Classification System, both X12N and the National Pr…
* Identity: [v3-Nadene](ValueSet-v3-Nadene.md)
  * Name: Nadene
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NailRoute](ValueSet-v3-NailRoute.md)
  * Name: NailRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Nail
* Identity: [v3-NameLegalUse](ValueSet-v3-NameLegalUse.md)
  * Name: NameLegalUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NasalInhalation](ValueSet-v3-NasalInhalation.md)
  * Name: NasalInhalation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Inhalation, nasal
* Identity: [v3-NasalRoute](ValueSet-v3-NasalRoute.md)
  * Name: NasalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Nasal
* Identity: [v3-NationEntityType](ValueSet-v3-NationEntityType.md)
  * Name: NationEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes identifying nation states. Allows for finer grained specification of Entity with classcode <=…
* Identity: [v3-NativeEntityAlas…](ValueSet-v3-NativeEntityAlaska.md)
  * Name: NativeEntityAlaska
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: NATIVE ENTITIES WITHIN THE STATE OF ALASKA RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNI…
* Identity: [v3-NativeEntityCont…](ValueSet-v3-NativeEntityContiguous.md)
  * Name: NativeEntityContiguous
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: NATIVE ENTITIES WITHIN THE CONTIGUOUS 48 STATES
* Identity: [v3-NaturalChild](ValueSet-v3-NaturalChild.md)
  * Name: NaturalChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A child as determined by birth.
* Identity: [v3-NaturalParent](ValueSet-v3-NaturalParent.md)
  * Name: NaturalParent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NaturalSibling](ValueSet-v3-NaturalSibling.md)
  * Name: NaturalSibling
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role has both biological parents in common with the scoping entity.
* Identity: [v3-Nebulization](ValueSet-v3-Nebulization.md)
  * Name: Nebulization
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Nebulization
* Identity: [v3-NebulizationInha…](ValueSet-v3-NebulizationInhalation.md)
  * Name: NebulizationInhalation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Inhalation, nebulization
* Identity: [v3-NephClinPractice…](ValueSet-v3-NephClinPracticeSetting.md)
  * Name: NephClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NieceNephew](ValueSet-v3-NieceNephew.md)
  * Name: NieceNephew
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child of scoping person's brother or sister or of the brother or sister…
* Identity: [v3-NoInformation](ValueSet-v3-NoInformation.md)
  * Name: NoInformation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The value is exceptional (missing, omitted, incomplete, improper). No information a…
* Identity: [v3-NonDrugAgentEnti…](ValueSet-v3-NonDrugAgentEntity.md)
  * Name: NonDrugAgentEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates types of allergy and intolerance agents which are non-drugs. (E.g. foods, latex, etc.)
* Identity: [v3-NonRigidContaine…](ValueSet-v3-NonRigidContainerEntityType.md)
  * Name: NonRigidContainerEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container having dimensions that adjust somewhat based on the amount and shape of the material pl…
* Identity: [v3-Nootkan](ValueSet-v3-Nootkan.md)
  * Name: Nootkan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NorthernCaddoan](ValueSet-v3-NorthernCaddoan.md)
  * Name: NorthernCaddoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NorthernIroquoian](ValueSet-v3-NorthernIroquoian.md)
  * Name: NorthernIroquoian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NullFlavor](ValueSet-v3-NullFlavor.md)
  * Name: NullFlavor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Numic](ValueSet-v3-Numic.md)
  * Name: Numic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-NursingOrCustodi…](ValueSet-v3-NursingOrCustodialCarePracticeSetting.md)
  * Name: NursingOrCustodialCarePracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObligationPolicy](ValueSet-v3-ObligationPolicy.md)
  * Name: ObligationPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Conveys the mandated workflow action that an information custodian, receiver, or user must perform.…
* Identity: [v3-ObservationActCo…](ValueSet-v3-ObservationActContextAgeGroupType.md)
  * Name: ObservationActContextAgeGroupType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-16
  * Description: Identifies a type of observation that captures the age of a person in terms of age group concept co…
* Identity: [v3-ObservationActCo…](ValueSet-v3-ObservationActContextAgeType.md)
  * Name: ObservationActContextAgeType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The ways the age of an entity involved in an act can be measured, calculated or othe…
* Identity: [v3-ObservationAlert](ValueSet-v3-ObservationAlert.md)
  * Name: ObservationAlert
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationAller…](ValueSet-v3-ObservationAllergyType.md)
  * Name: ObservationAllergyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity to an agent caused by an immunologic response to an initial exposure.
* Identity: [v3-ObservationAsset…](ValueSet-v3-ObservationAssetValue.md)
  * Name: ObservationAssetValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes specifying asset indicators used to assess or establish eligibility for coverage under a poli…
* Identity: [v3-ObservationCateg…](ValueSet-v3-ObservationCategory.md)
  * Name: ObservationCategory
  * Version: 3.0.0
  * Status: active
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: High level observation categories for the general type of observation being made.**Steward:**OO …
* Identity: [v3-ObservationCoord…](ValueSet-v3-ObservationCoordinateAxisType.md)
  * Name: ObservationCoordinateAxisType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationCoord…](ValueSet-v3-ObservationCoordinateSystemType.md)
  * Name: ObservationCoordinateSystemType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationDetec…](ValueSet-v3-ObservationDetectedIssueCode.md)
  * Name: ObservationDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate or contraindicated due to conditions or characteristics of th…
* Identity: [v3-ObservationDiagn…](ValueSet-v3-ObservationDiagnosisTypes.md)
  * Name: ObservationDiagnosisTypes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An observation about the presence (or absence) of a particular disease state in a subject.
* Identity: [v3-ObservationDrugI…](ValueSet-v3-ObservationDrugIntoleranceType.md)
  * Name: ObservationDrugIntoleranceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity resulting in an adverse reaction upon exposure to a drug.
* Identity: [v3-ObservationEligi…](ValueSet-v3-ObservationEligibilityIndicatorValue.md)
  * Name: ObservationEligibilityIndicatorValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying eligibility indicators used to assess or establish eligibility for coverage under a…
* Identity: [v3-ObservationEnvir…](ValueSet-v3-ObservationEnvironmentalIntoleranceType.md)
  * Name: ObservationEnvironmentalIntoleranceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity resulting in an adverse reaction upon exposure to environmental conditions.
* Identity: [v3-ObservationFoodI…](ValueSet-v3-ObservationFoodIntoleranceType.md)
  * Name: ObservationFoodIntoleranceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity resulting in an adverse reaction upon exposure to food.
* Identity: [v3-ObservationHealt…](ValueSet-v3-ObservationHealthStatusValue.md)
  * Name: ObservationHealthStatusValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying non-clinical indicators related to health status used to assess or establish eligib…
* Identity: [v3-ObservationIncom…](ValueSet-v3-ObservationIncomeValue.md)
  * Name: ObservationIncomeValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying financial indicators used to assess or establish eligibility for coverage under a p…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretation.md)
  * Name: ObservationInterpretation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: One or more codes providing a rough qualitative interpretation of the observation,such as "normal" …
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationChange.md)
  * Name: ObservationInterpretationChange
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretations of change of quantity and/or severity, such as "better", "worse", "increased", etc.…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationDetected.md)
  * Name: ObservationInterpretationDetected
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretations of the presence or absence of a component / analyte or organism in a test or of a s…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationExceptions.md)
  * Name: ObservationInterpretationExceptions
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Technical exceptions resulting in the inability to provide an interpretation. At most one allowed. …
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationExpectation.md)
  * Name: ObservationInterpretationExpectation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Observation interpretation codes for expected results based on additional information (contraindica…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationNormality.md)
  * Name: ObservationInterpretationNormality
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretation of normality or degree of abnormality (including critical or "alert" level). Concept…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationNormalityAbnormal.md)
  * Name: ObservationInterpretationNormalityAbnormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretation of degree of abnormality (including critical or "alert" level). Concepts in this cat…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationNormalityCriticallyAbnormal.md)
  * Name: ObservationInterpretationNormalityCriticallyAbnormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Interpretation of a critical (or "alert") degree of abnormality. Concepts in this category are mutu…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationNormalityHigh.md)
  * Name: ObservationInterpretationNormalityHigh
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretation for a quantitative observation of degree of abnormality (including critical or "aler…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationNormalityLow.md)
  * Name: ObservationInterpretationNormalityLow
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretation for a quantitative observation of degree of abnormality (including critical or "aler…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationOustsideThreshold.md)
  * Name: ObservationInterpretationOustsideThreshold
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The observation/test result is interpreted as being outside the inclusion range for a particular pr…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationProtocolInclusion.md)
  * Name: ObservationInterpretationProtocolInclusion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The observation/test result is interpreted as being outside the inclusion range for a particular pr…
* Identity: [v3-ObservationInter…](ValueSet-v3-ObservationInterpretationSusceptibility.md)
  * Name: ObservationInterpretationSusceptibility
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretations of anti-microbial susceptibility testing results (microbiology). At most one allowe…
* Identity: [v3-ObservationIntol…](ValueSet-v3-ObservationIntoleranceType.md)
  * Name: ObservationIntoleranceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity resulting in an adverse reaction upon exposure to an agent.
* Identity: [v3-ObservationIssue…](ValueSet-v3-ObservationIssueTriggerCodedObservationType.md)
  * Name: ObservationIssueTriggerCodedObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Distinguishes the kinds of coded observations that could be the trigger for clinical issue detectio…
* Identity: [v3-ObservationLivin…](ValueSet-v3-ObservationLivingDependencyValue.md)
  * Name: ObservationLivingDependencyValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Continued living in private residence requires functional and health care assistance from spouse or…
* Identity: [v3-ObservationLivin…](ValueSet-v3-ObservationLivingExpenseValue.md)
  * Name: ObservationLivingExpenseValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes specifying living expense indicators used to assess or establish eligibility for coverage und…
* Identity: [v3-ObservationLivin…](ValueSet-v3-ObservationLivingSituationValue.md)
  * Name: ObservationLivingSituationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying observations related to living situation for a person in a private residence.
* Identity: [v3-ObservationMeasu…](ValueSet-v3-ObservationMeasureCountableItems.md)
  * Name: ObservationMeasureCountableItems
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-22
  * Description: A collection of items that can be counted by a quality measure (e.g., patients, encounters, procedu…
* Identity: [v3-ObservationMeasu…](ValueSet-v3-ObservationMeasureScoring.md)
  * Name: ObservationMeasureScoring
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationMeasu…](ValueSet-v3-ObservationMeasureType.md)
  * Name: ObservationMeasureType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Observation values used to indicate what kind of health quality measure is used.
* Identity: [v3-ObservationMethod](ValueSet-v3-ObservationMethod.md)
  * Name: ObservationMethod
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code that provides additional detail about the means or technique used to ascertain the observati…
* Identity: [v3-ObservationMetho…](ValueSet-v3-ObservationMethodAggregate.md)
  * Name: ObservationMethodAggregate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A set of codes that defines how a set of values are summarized in an aggregated computation, for us…
* Identity: [v3-ObservationNonAl…](ValueSet-v3-ObservationNonAllergyIntoleranceType.md)
  * Name: ObservationNonAllergyIntoleranceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Hypersensitivity to an agent caused by a mechanism other than an immunologic response to an initial…
* Identity: [v3-ObservationPopul…](ValueSet-v3-ObservationPopulationInclusion.md)
  * Name: ObservationPopulationInclusion
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Observation values used to assert various populations that a subject falls into.
* Identity: [v3-ObservationQuali…](ValueSet-v3-ObservationQualityMeasureAttribute.md)
  * Name: ObservationQualityMeasureAttribute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes used to define various metadata aspects of a health quality measure.
* Identity: [v3-ObservationSeque…](ValueSet-v3-ObservationSequenceType.md)
  * Name: ObservationSequenceType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationSerie…](ValueSet-v3-ObservationSeriesType.md)
  * Name: ObservationSeriesType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ObservationSocio…](ValueSet-v3-ObservationSocioEconomicStatusValue.md)
  * Name: ObservationSocioEconomicStatusValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Code specifying observations or indicators related to socio-economic status used to assess to asses…
* Identity: [v3-ObservationType](ValueSet-v3-ObservationType.md)
  * Name: ObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the kinds of observations that can be performed
* Identity: [v3-OilDrugForm](ValueSet-v3-OilDrugForm.md)
  * Name: OilDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An unctuous, combustible substance which is liquid, or easily liquefiable, on warming, and is solub…
* Identity: [v3-OintmentDrugForm](ValueSet-v3-OintmentDrugForm.md)
  * Name: OintmentDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A semisolid preparation intended for external application to the skin or mucous membranes.
* Identity: [v3-Ojibwayan](ValueSet-v3-Ojibwayan.md)
  * Name: Ojibwayan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OphthalmicRoute](ValueSet-v3-OphthalmicRoute.md)
  * Name: OphthalmicRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Ophthalmic
* Identity: [v3-OralCapsule](ValueSet-v3-OralCapsule.md)
  * Name: OralCapsule
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OralInhalation](ValueSet-v3-OralInhalation.md)
  * Name: OralInhalation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Inhalation, oral
* Identity: [v3-OralRoute](ValueSet-v3-OralRoute.md)
  * Name: OralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Oral
* Identity: [v3-OralSolution](ValueSet-v3-OralSolution.md)
  * Name: OralSolution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OralSuspension](ValueSet-v3-OralSuspension.md)
  * Name: OralSuspension
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OralTablet](ValueSet-v3-OralTablet.md)
  * Name: OralTablet
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OrderableDrugForm](ValueSet-v3-OrderableDrugForm.md)
  * Name: OrderableDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OrderedListStyle](ValueSet-v3-OrderedListStyle.md)
  * Name: OrderedListStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Defines rendering characteristics for ordered lists
* Identity: [v3-OregonAthapaskan](ValueSet-v3-OregonAthapaskan.md)
  * Name: OregonAthapaskan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OrganizationEnti…](ValueSet-v3-OrganizationEntityType.md)
  * Name: OrganizationEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Further classifies entities of classCode ORG.
* Identity: [v3-OrganizationIndu…](ValueSet-v3-OrganizationIndustryClassNAICS.md)
  * Name: OrganizationIndustryClassNAICS
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OrganizationName…](ValueSet-v3-OrganizationNamePartQualifier.md)
  * Name: OrganizationNamePartQualifier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OrganizationName…](ValueSet-v3-OrganizationNameUse.md)
  * Name: OrganizationNameUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OromucosalRoute](ValueSet-v3-OromucosalRoute.md)
  * Name: OromucosalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Oromucosal
* Identity: [v3-OropharyngealRou…](ValueSet-v3-OropharyngealRoute.md)
  * Name: OropharyngealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Oropharyngeal
* Identity: [v3-OrthoClinPractic…](ValueSet-v3-OrthoClinPracticeSetting.md)
  * Name: OrthoClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Other](ValueSet-v3-Other.md)
  * Name: Other
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The actual value is not an element in the value domain of a variable. (e.g., concept not provided b…
* Identity: [v3-OtherActionTaken…](ValueSet-v3-OtherActionTakenManagementCode.md)
  * Name: OtherActionTakenManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Order is performed as issued, but other action taken to mitigate potential adverse effects
* Identity: [v3-OticRoute](ValueSet-v3-OticRoute.md)
  * Name: OticRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Otic
* Identity: [v3-OutpatientFacili…](ValueSet-v3-OutpatientFacilityPracticeSetting.md)
  * Name: OutpatientFacilityPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-OverriderPartici…](ValueSet-v3-OverriderParticipationFunction.md)
  * Name: OverriderParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This code is used to specify the exact function an actor is authorized to have in authoring a conse…
* Identity: [v3-PacificCoastAtha…](ValueSet-v3-PacificCoastAthapaskan.md)
  * Name: PacificCoastAthapaskan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PackageEntityType](ValueSet-v3-PackageEntityType.md)
  * Name: PackageEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A material intended to hold other materials for purposes of storage or transportation
* Identity: [v3-PadDrugForm](ValueSet-v3-PadDrugForm.md)
  * Name: PadDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Pai](ValueSet-v3-Pai.md)
  * Name: Pai
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Palaihnihan](ValueSet-v3-Palaihnihan.md)
  * Name: Palaihnihan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ParanasalSinuses…](ValueSet-v3-ParanasalSinusesRoute.md)
  * Name: ParanasalSinusesRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Paranasal sinuses
* Identity: [v3-Parent](ValueSet-v3-Parent.md)
  * Name: Parent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: one that begets or brings forth offspring or a person who brings up and cares for another (Webster'…
* Identity: [v3-ParentInLaw](ValueSet-v3-ParentInLaw.md)
  * Name: ParentInLaw
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is the parent of scoping person's husband or wife.
* Identity: [v3-ParenteralRoute](ValueSet-v3-ParenteralRoute.md)
  * Name: ParenteralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Parenteral
* Identity: [v3-PartialCompletio…](ValueSet-v3-PartialCompletionScale.md)
  * Name: PartialCompletionScale
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ParticipationAdm…](ValueSet-v3-ParticipationAdmitter.md)
  * Name: ParticipationAdmitter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The practitioner who is responsible for admitting a patient to a patient encounter.
* Identity: [v3-ParticipationAna…](ValueSet-v3-ParticipationAnalyte.md)
  * Name: ParticipationAnalyte
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ParticipationAnc…](ValueSet-v3-ParticipationAncillary.md)
  * Name: ParticipationAncillary
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Participations related, but not primary to an act. The Referring, Admitting, and Discharging practi…
* Identity: [v3-ParticipationAtt…](ValueSet-v3-ParticipationAttender.md)
  * Name: ParticipationAttender
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The practitioner that has responsibility for overseeing a patient's care during a patient encounter.
* Identity: [v3-ParticipationAut…](ValueSet-v3-ParticipationAuthenticator.md)
  * Name: ParticipationAuthenticator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A verifier who attests to the accuracy of an act, but who does not have privileges to legally authe…
* Identity: [v3-ParticipationAut…](ValueSet-v3-ParticipationAuthorOriginator.md)
  * Name: ParticipationAuthorOriginator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A party that originates the Act and therefore has responsibility for the informatio…
* Identity: [v3-ParticipationBaby](ValueSet-v3-ParticipationBaby.md)
  * Name: ParticipationBaby
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: In an obstetric service, the baby.
* Identity: [v3-ParticipationBen…](ValueSet-v3-ParticipationBeneficiary.md)
  * Name: ParticipationBeneficiary
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Target on behalf of whom the service happens, but that is not necessarily present in the service. C…
* Identity: [v3-ParticipationCal…](ValueSet-v3-ParticipationCallbackContact.md)
  * Name: ParticipationCallbackContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person or organization who should be contacted for follow-up questions about the act in place of …
* Identity: [v3-ParticipationCat…](ValueSet-v3-ParticipationCatalyst.md)
  * Name: ParticipationCatalyst
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ParticipationCau…](ValueSet-v3-ParticipationCausativeAgent.md)
  * Name: ParticipationCausativeAgent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Definition: A factor, such as a microorganism, chemical substance, or form of radiation, whose pres…
* Identity: [v3-ParticipationCon…](ValueSet-v3-ParticipationConsultant.md)
  * Name: ParticipationConsultant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An advisor participating in the service by performing evaluations and making recommendations.
* Identity: [v3-ParticipationCon…](ValueSet-v3-ParticipationConsumable.md)
  * Name: ParticipationConsumable
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Target that is taken up, is diminished, and disappears in the service.
* Identity: [v3-ParticipationCov…](ValueSet-v3-ParticipationCoverageTarget.md)
  * Name: ParticipationCoverageTarget
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The target participation for an individual in a health care coverage act in which the target role i…
* Identity: [v3-ParticipationCus…](ValueSet-v3-ParticipationCustodian.md)
  * Name: ParticipationCustodian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity (person, organization or device) that is in charge of maintaining the information of this…
* Identity: [v3-ParticipationDat…](ValueSet-v3-ParticipationDataEntryPerson.md)
  * Name: ParticipationDataEntryPerson
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person entering the data into the originating system. The data entry person is collected optional…
* Identity: [v3-ParticipationDes…](ValueSet-v3-ParticipationDestination.md)
  * Name: ParticipationDestination
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The destination for services. May be a static building (or room therein) or a movable facility (e.g…
* Identity: [v3-ParticipationDis…](ValueSet-v3-ParticipationDischarger.md)
  * Name: ParticipationDischarger
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The practitioner who is responsible for the discharge of a patient from a patient encounter.
* Identity: [v3-ParticipationDis…](ValueSet-v3-ParticipationDistributor.md)
  * Name: ParticipationDistributor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Distributes material used in or generated during the act.
* Identity: [v3-ParticipationDon…](ValueSet-v3-ParticipationDonor.md)
  * Name: ParticipationDonor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: In some organ transplantation services and rarely in transfusion services a donor will be a target …
* Identity: [v3-ParticipationEnt…](ValueSet-v3-ParticipationEntryLocation.md)
  * Name: ParticipationEntryLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A location where data about an Act was entered.
* Identity: [v3-ParticipationEsc…](ValueSet-v3-ParticipationEscort.md)
  * Name: ParticipationEscort
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Only with Transportation services. A person who escorts the patient.
* Identity: [v3-ParticipationExp…](ValueSet-v3-ParticipationExposureagent.md)
  * Name: ParticipationExposureagent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The entity playing the associated role is the physical (including energy), chemica…
* Identity: [v3-ParticipationExp…](ValueSet-v3-ParticipationExposureparticipation.md)
  * Name: ParticipationExposureparticipation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Direct participation in an exposure act where it is unknown that the participant is…
* Identity: [v3-ParticipationExp…](ValueSet-v3-ParticipationExposuresource.md)
  * Name: ParticipationExposuresource
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The entity playing the associated role is the source of exposure.
* Identity: [v3-ParticipationExp…](ValueSet-v3-ParticipationExposuretarget.md)
  * Name: ParticipationExposuretarget
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The entity playing the associated role is the target (contact) of exposure.
* Identity: [v3-ParticipationFun…](ValueSet-v3-ParticipationFunction.md)
  * Name: ParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This code is used to specify the exact function an actor had in a service in all necessary detail. …
* Identity: [v3-ParticipationGua…](ValueSet-v3-ParticipationGuarantorParty.md)
  * Name: ParticipationGuarantorParty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The target person or organization contractually recognized by the issuer as a participant who has a…
* Identity: [v3-ParticipationHol…](ValueSet-v3-ParticipationHolder.md)
  * Name: ParticipationHolder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Participant who posses an instrument such as a financial contract (insurance policy) usually based …
* Identity: [v3-ParticipationInd…](ValueSet-v3-ParticipationIndirectTarget.md)
  * Name: ParticipationIndirectTarget
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Target that is not substantially present in the act and which is not directly affected by the act, …
* Identity: [v3-ParticipationInf…](ValueSet-v3-ParticipationInformant.md)
  * Name: ParticipationInformant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A source of reported information (e.g., a next of kin who answers questions about the patient's his…
* Identity: [v3-ParticipationInf…](ValueSet-v3-ParticipationInformationGenerator.md)
  * Name: ParticipationInformationGenerator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Parties that may or should contribute or have contributed information to the Act. Such information …
* Identity: [v3-ParticipationInf…](ValueSet-v3-ParticipationInformationRecipient.md)
  * Name: ParticipationInformationRecipient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A party, who may or should receive or who has recieved the Act or subsequent or derivative informat…
* Identity: [v3-ParticipationInf…](ValueSet-v3-ParticipationInformationTranscriber.md)
  * Name: ParticipationInformationTranscriber
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity entering the data into the originating system. The data entry entity is collected optiona…
* Identity: [v3-ParticipationLeg…](ValueSet-v3-ParticipationLegalAuthenticator.md)
  * Name: ParticipationLegalAuthenticator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A verifier who legally authenticates the accuracy of an act. An example would be a staff physician …
* Identity: [v3-ParticipationMode](ValueSet-v3-ParticipationMode.md)
  * Name: ParticipationMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the primary means by which an Entity participates in an Act.
* Identity: [v3-ParticipationMod…](ValueSet-v3-ParticipationModeElectronicData.md)
  * Name: ParticipationModeElectronicData
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Participation by non-human-languaged based electronic signal
* Identity: [v3-ParticipationMod…](ValueSet-v3-ParticipationModeVerbal.md)
  * Name: ParticipationModeVerbal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Participation by voice communication
* Identity: [v3-ParticipationMod…](ValueSet-v3-ParticipationModeWritten.md)
  * Name: ParticipationModeWritten
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Participation by human language recorded on a physical material
* Identity: [v3-ParticipationNon…](ValueSet-v3-ParticipationNon-reuseableDevice.md)
  * Name: ParticipationNon-reuseableDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device that changes ownership due to the service, e.g., a pacemaker, a prosthesis, an insulin inj…
* Identity: [v3-ParticipationOri…](ValueSet-v3-ParticipationOrigin.md)
  * Name: ParticipationOrigin
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The location of origin for services. May be a static building (or room therein) or a movable facili…
* Identity: [v3-ParticipationPar…](ValueSet-v3-ParticipationParticipation.md)
  * Name: ParticipationParticipation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates that the target of the participation is involved in some manner in the act, but does not …
* Identity: [v3-ParticipationPhy…](ValueSet-v3-ParticipationPhysicalPerformer.md)
  * Name: ParticipationPhysicalPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person who actually and principally carries out the action. Need not be the principal responsible…
* Identity: [v3-ParticipationPri…](ValueSet-v3-ParticipationPrimaryInformationRecipient.md)
  * Name: ParticipationPrimaryInformationRecipient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Information recipient to whom an act statement is primarily directed. E.g., a primary care provider…
* Identity: [v3-ParticipationPri…](ValueSet-v3-ParticipationPrimaryPerformer.md)
  * Name: ParticipationPrimaryPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The principal or primary performer of the act.
* Identity: [v3-ParticipationPro…](ValueSet-v3-ParticipationProduct.md)
  * Name: ParticipationProduct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A material target that is brought forth (produced) in the service (e.g., specimen in a specimen col…
* Identity: [v3-ParticipationRec…](ValueSet-v3-ParticipationReceiver.md)
  * Name: ParticipationReceiver
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The person (or organization) who receives the product of an Act.
* Identity: [v3-ParticipationRec…](ValueSet-v3-ParticipationRecordTarget.md)
  * Name: ParticipationRecordTarget
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The record target indicates whose medical record holds the documentation of this act. This is espec…
* Identity: [v3-ParticipationRef…](ValueSet-v3-ParticipationReferredBy.md)
  * Name: ParticipationReferredBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A participant (e.g. provider) who has referred the subject of an act (e.g. patient).Typically, …
* Identity: [v3-ParticipationRef…](ValueSet-v3-ParticipationReferredTo.md)
  * Name: ParticipationReferredTo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The person who receives the patient
* Identity: [v3-ParticipationRef…](ValueSet-v3-ParticipationReferrer.md)
  * Name: ParticipationReferrer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person having referred the subject of the service to the performer (referring physician). Typical…
* Identity: [v3-ParticipationRem…](ValueSet-v3-ParticipationRemote.md)
  * Name: ParticipationRemote
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Some services take place at multiple concurrent locations (e.g., telemedicine, telephone consultati…
* Identity: [v3-ParticipationRes…](ValueSet-v3-ParticipationResponsibleParty.md)
  * Name: ParticipationResponsibleParty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The person or organization that has primary responsibility for the act. The responsible party is no…
* Identity: [v3-ParticipationReu…](ValueSet-v3-ParticipationReusableDevice.md)
  * Name: ParticipationReusableDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A device that does not change ownership due to the service, i.e., a surgical instrument or tool or …
* Identity: [v3-ParticipationSec…](ValueSet-v3-ParticipationSecondaryPerformer.md)
  * Name: ParticipationSecondaryPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person assisting in an act through his substantial presence and involvement This includes: assist…
* Identity: [v3-ParticipationSig…](ValueSet-v3-ParticipationSignature.md)
  * Name: ParticipationSignature
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying whether and how the participant has attested his participation through a signatur…
* Identity: [v3-ParticipationSpe…](ValueSet-v3-ParticipationSpecimen.md)
  * Name: ParticipationSpecimen
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The subject of non-clinical (e.g. laboratory) observation services is a specimen.
* Identity: [v3-ParticipationSub…](ValueSet-v3-ParticipationSubset.md)
  * Name: ParticipationSubset
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to indicate that the participation is a filtered subset of the total participations of the sam…
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetDevice.md)
  * Name: ParticipationTargetDevice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Something used in delivering the service without being substantially affected by the service (i.e. …
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetDirect.md)
  * Name: ParticipationTargetDirect
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Target that is substantially present in the service and which is directly affected by the service a…
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetLocation.md)
  * Name: ParticipationTargetLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The facility where the service is done. May be a static building (or room therein) or a moving loca…
* Identity: [v3-ParticipationTar…](ValueSet-v3-ParticipationTargetSubject.md)
  * Name: ParticipationTargetSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The principle target that the service acts on. E.g. the patient in physical examination, a specimen…
* Identity: [v3-ParticipationTra…](ValueSet-v3-ParticipationTracker.md)
  * Name: ParticipationTracker
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A secondary information recipient, who receives copies (e.g., a primary care provider receiving cop…
* Identity: [v3-ParticipationType](ValueSet-v3-ParticipationType.md)
  * Name: ParticipationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every Participation instance. Each of its values impli…
* Identity: [v3-ParticipationTyp…](ValueSet-v3-ParticipationTypeCDASectionOverride.md)
  * Name: ParticipationTypeCDASectionOverride
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the set of participation types context that can be blocked (overridden) at the CDA secti…
* Identity: [v3-ParticipationUge…](ValueSet-v3-ParticipationUgentNotificationContact.md)
  * Name: ParticipationUgentNotificationContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An information recipient to notify for urgent matters about this Act. (e.g., in a laboratory order,…
* Identity: [v3-ParticipationVer…](ValueSet-v3-ParticipationVerifier.md)
  * Name: ParticipationVerifier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person who verifies the correctness and appropriateness of the service (plan, order, event, etc.)…
* Identity: [v3-ParticipationVia](ValueSet-v3-ParticipationVia.md)
  * Name: ParticipationVia
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: For services, an intermediate location that specifies a path between origin an destination.
* Identity: [v3-ParticipationWit…](ValueSet-v3-ParticipationWitness.md)
  * Name: ParticipationWitness
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Only with service events. A person witnessing the action happening without doing anything. A witnes…
* Identity: [v3-PastSubset](ValueSet-v3-PastSubset.md)
  * Name: PastSubset
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An occurrence that occurred or was scheduled to occur in the past. An Act whose effective time is l…
* Identity: [v3-PasteDrugForm](ValueSet-v3-PasteDrugForm.md)
  * Name: PasteDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A semisolid dosage form that contains one or more drug substances intended for topical application.
* Identity: [v3-PatchDrugForm](ValueSet-v3-PatchDrugForm.md)
  * Name: PatchDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A drug delivery system that contains an adhesived backing and that permits its ingredients to diffu…
* Identity: [v3-PatientImmunizat…](ValueSet-v3-PatientImmunizationRelatedObservationType.md)
  * Name: PatientImmunizationRelatedObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Reporting codes that are related to an immunization event.
* Identity: [v3-PatientImportance](ValueSet-v3-PatientImportance.md)
  * Name: PatientImportance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Patient VIP code
* Identity: [v3-PatientProfileQu…](ValueSet-v3-PatientProfileQueryReasonCode.md)
  * Name: PatientProfileQueryReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PaymentTerms](ValueSet-v3-PaymentTerms.md)
  * Name: PaymentTerms
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Describes payment terms for a financial transaction, used in an invoice.This is typically expre…
* Identity: [v3-PayorParticipati…](ValueSet-v3-PayorParticipationFunction.md)
  * Name: PayorParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the manner in which payors participate in a policy or progr…
* Identity: [v3-PayorRoleType](ValueSet-v3-PayorRoleType.md)
  * Name: PayorRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**PayorRoleType for a particular type of policy or program benefit package or plan wh…
* Identity: [v3-PedsClinPractice…](ValueSet-v3-PedsClinPracticeSetting.md)
  * Name: PedsClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PedsICUPracticeS…](ValueSet-v3-PedsICUPracticeSetting.md)
  * Name: PedsICUPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PedsPracticeSett…](ValueSet-v3-PedsPracticeSetting.md)
  * Name: PedsPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Penutian](ValueSet-v3-Penutian.md)
  * Name: Penutian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PerianalRoute](ValueSet-v3-PerianalRoute.md)
  * Name: PerianalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Perianal
* Identity: [v3-PeriarticularRou…](ValueSet-v3-PeriarticularRoute.md)
  * Name: PeriarticularRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Periarticular
* Identity: [v3-PeriduralRoute](ValueSet-v3-PeriduralRoute.md)
  * Name: PeriduralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Peridural
* Identity: [v3-PerinealRoute](ValueSet-v3-PerinealRoute.md)
  * Name: PerinealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Perineal
* Identity: [v3-PerineuralRoute](ValueSet-v3-PerineuralRoute.md)
  * Name: PerineuralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Perineural
* Identity: [v3-PeriodontalRoute](ValueSet-v3-PeriodontalRoute.md)
  * Name: PeriodontalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Periodontal
* Identity: [v3-PermanentDentiti…](ValueSet-v3-PermanentDentition.md)
  * Name: PermanentDentition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Permanent dentition, the natural teeth of adulthood that replace or are added to the deciduous teeth
* Identity: [v3-PersonDisability…](ValueSet-v3-PersonDisabilityType.md)
  * Name: PersonDisabilityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code identifying a person's disability.
* Identity: [v3-PersonNameUse](ValueSet-v3-PersonNameUse.md)
  * Name: PersonNameUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code indicating the type of name (e.g. nickname, alias, maiden name, legal, adopted)
* Identity: [v3-PersonalAndLegal…](ValueSet-v3-PersonalAndLegalRelationshipRoleType.md)
  * Name: PersonalAndLegalRelationshipRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: A â€˜personal and legalâ€™ relationship records the role of a person in relation to another person,…
* Identity: [v3-PersonalRelation…](ValueSet-v3-PersonalRelationshipRoleType.md)
  * Name: PersonalRelationshipRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Types of personal relationships between two living subjects.*Example:*Parent, sibling, unrelate…
* Identity: [v3-PharmacySupplyEv…](ValueSet-v3-PharmacySupplyEventAbortReason.md)
  * Name: PharmacySupplyEventAbortReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Identifies why the dispense event was not completed
* Identity: [v3-PharmacySupplyEv…](ValueSet-v3-PharmacySupplyEventStockReasonCode.md)
  * Name: PharmacySupplyEventStockReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PharmacySupplyRe…](ValueSet-v3-PharmacySupplyRequestFulfillerRevisionRefusalReasonCode.md)
  * Name: PharmacySupplyRequestFulfillerRevisionRefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Definition:**Indicates why the request to transfer a prescription from one dispensing facility to…
* Identity: [v3-PharmacySupplyRe…](ValueSet-v3-PharmacySupplyRequestRenewalRefusalReasonCode.md)
  * Name: PharmacySupplyRequestRenewalRefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A collection of concepts that identifies why a renewal prescription has been refused.
* Identity: [v3-Pidgin](ValueSet-v3-Pidgin.md)
  * Name: Pidgin
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PillDrugForm](ValueSet-v3-PillDrugForm.md)
  * Name: PillDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A small, round solid dosage form containing a medicinal agent intended for oral administration.
* Identity: [v3-PlaceEntityType](ValueSet-v3-PlaceEntityType.md)
  * Name: PlaceEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Types of places for EntityClass "PLC"
* Identity: [v3-PlasticBottleEnt…](ValueSet-v3-PlasticBottleEntityType.md)
  * Name: PlasticBottleEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A bottle made of plastic
* Identity: [v3-PlateauPenutian](ValueSet-v3-PlateauPenutian.md)
  * Name: PlateauPenutian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PolicyOrProgramC…](ValueSet-v3-PolicyOrProgramCoverageRoleType.md)
  * Name: PolicyOrProgramCoverageRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role recognized through the eligibility of an identified party for benefits cove…
* Identity: [v3-Pomoan](ValueSet-v3-Pomoan.md)
  * Name: Pomoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PopulationInclus…](ValueSet-v3-PopulationInclusionObservationType.md)
  * Name: PopulationInclusionObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Observation types for specifying criteria used to assert that a subject is included in a particular…
* Identity: [v3-PostalAddressUse](ValueSet-v3-PostalAddressUse.md)
  * Name: PostalAddressUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-PowderDrugForm](ValueSet-v3-PowderDrugForm.md)
  * Name: PowderDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An intimate mixture of dry, finely divided drugs and/or chemicals that may be intended for internal…
* Identity: [v3-PowerOfAttorney](ValueSet-v3-PowerOfAttorney.md)
  * Name: PowerOfAttorney
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between two people in which one person authorizes another to act for him in a manner…
* Identity: [v3-PrescriptionDisp…](ValueSet-v3-PrescriptionDispenseFilterCode.md)
  * Name: PrescriptionDispenseFilterCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A "helper" vocabulary used to construct complex query filters based on how and whether a prescripti…
* Identity: [v3-PrimaryDentition](ValueSet-v3-PrimaryDentition.md)
  * Name: PrimaryDentition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Primary dentition, the first teeth to errupt and usually replaced with permanent dentition
* Identity: [v3-PrivacyMark](ValueSet-v3-PrivacyMark.md)
  * Name: PrivacyMark
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes used for human readable marks indicating, e.g., the level of confidentiality protection, an a…
* Identity: [v3-PrivateResidence](ValueSet-v3-PrivateResidence.md)
  * Name: PrivateResidence
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A living arrangement within a private residence for single family.
* Identity: [v3-ProbabilityDistr…](ValueSet-v3-ProbabilityDistributionType.md)
  * Name: ProbabilityDistributionType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ProcessingID](ValueSet-v3-ProcessingID.md)
  * Name: ProcessingID
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This attribute defines whether the message is part of a production, training, or debugging system.
* Identity: [v3-ProcessingMode](ValueSet-v3-ProcessingMode.md)
  * Name: ProcessingMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This attribute defines whether the message is being sent in current processing, archive mode, initi…
* Identity: [v3-ProgramEligibleC…](ValueSet-v3-ProgramEligibleCoveredPartyRoleType.md)
  * Name: ProgramEligibleCoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role recognized through the eligibility of a party to play a program eligible for…
* Identity: [v3-ProvenanceEventC…](ValueSet-v3-ProvenanceEventCurrentState.md)
  * Name: ProvenanceEventCurrentState
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Specifies the state change of a target Act, such as a document or an entry, from its previous state…
* Identity: [v3-ProvenanceEventC…](ValueSet-v3-ProvenanceEventCurrentState-AS.md)
  * Name: ProvenanceEventCurrentState-AS
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Specifies the state change of a target Act, using ActStatus codes, from its previous state as a pre…
* Identity: [v3-ProvenanceEventC…](ValueSet-v3-ProvenanceEventCurrentState-DC.md)
  * Name: ProvenanceEventCurrentState-DC
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Specifies the state change of a target Act using DocuymentCompletion codes, from its previous state…
* Identity: [v3-PublicHealthcare…](ValueSet-v3-PublicHealthcareProgram.md)
  * Name: PublicHealthcareProgram
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A a public or governmental health program with an organized structure for administe…
* Identity: [v3-PulmonaryRoute](ValueSet-v3-PulmonaryRoute.md)
  * Name: PulmonaryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Pulmonary
* Identity: [v3-PurposeOfUse](ValueSet-v3-PurposeOfUse.md)
  * Name: PurposeOfUse
  * Version: 3.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: Supports communication of purpose of use at a general level.
* Identity: [v3-QualityMeasureSe…](ValueSet-v3-QualityMeasureSectionType.md)
  * Name: QualityMeasureSectionType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-14
  * Description: A type of document section within a health quality measure (aka eMeasure), used to cluster the vari…
* Identity: [v3-QualitySpecimenR…](ValueSet-v3-QualitySpecimenRoleType.md)
  * Name: QualitySpecimenRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A specimen specifically used to verify the sensitivity, specificity, accuracy or other perfomance p…
* Identity: [v3-QueryPriority](ValueSet-v3-QueryPriority.md)
  * Name: QueryPriority
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies the time frame in which the response is expected.
* Identity: [v3-QueryRequestLimit](ValueSet-v3-QueryRequestLimit.md)
  * Name: QueryRequestLimit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The number of matching instances (number of focal classes). The document header cla…
* Identity: [v3-QueryResponse](ValueSet-v3-QueryResponse.md)
  * Name: QueryResponse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code classifying the general nature of the response to a given query. Includes whether or not dat…
* Identity: [v3-QueryStatusCode](ValueSet-v3-QueryStatusCode.md)
  * Name: QueryStatusCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the state of the Query.
* Identity: [v3-ROIOverlayShape](ValueSet-v3-ROIOverlayShape.md)
  * Name: ROIOverlayShape
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Shape of the region on the object being referenced
* Identity: [v3-Race](ValueSet-v3-Race.md)
  * Name: Race
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: In the United States, federal standards for classifying data on race determine the categories used …
* Identity: [v3-RaceAfricanAmeri…](ValueSet-v3-RaceAfricanAmericanAfrican.md)
  * Name: RaceAfricanAmericanAfrican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanIndian](ValueSet-v3-RaceAlaskanIndian.md)
  * Name: RaceAlaskanIndian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanIndia…](ValueSet-v3-RaceAlaskanIndianAthabascan.md)
  * Name: RaceAlaskanIndianAthabascan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNative](ValueSet-v3-RaceAlaskanNative.md)
  * Name: RaceAlaskanNative
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleut.md)
  * Name: RaceAlaskanNativeAleut
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleutAlutiiq.md)
  * Name: RaceAlaskanNativeAleutAlutiiq
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleutBristolBay.md)
  * Name: RaceAlaskanNativeAleutBristolBay
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleutChugach.md)
  * Name: RaceAlaskanNativeAleutChugach
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleutKoniag.md)
  * Name: RaceAlaskanNativeAleutKoniag
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeAleutUnangan.md)
  * Name: RaceAlaskanNativeAleutUnangan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeEskimo.md)
  * Name: RaceAlaskanNativeEskimo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeInupiatEskimo.md)
  * Name: RaceAlaskanNativeInupiatEskimo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeSiberianEskimo.md)
  * Name: RaceAlaskanNativeSiberianEskimo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAlaskanNativ…](ValueSet-v3-RaceAlaskanNativeYupikEskimo.md)
  * Name: RaceAlaskanNativeYupikEskimo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndian.md)
  * Name: RaceAmericanIndian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianApache.md)
  * Name: RaceAmericanIndianApache
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianArapaho.md)
  * Name: RaceAmericanIndianArapaho
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianAssiniboineSioux.md)
  * Name: RaceAmericanIndianAssiniboineSioux
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCaddo.md)
  * Name: RaceAmericanIndianCaddo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCahuilla.md)
  * Name: RaceAmericanIndianCahuilla
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCalifornia.md)
  * Name: RaceAmericanIndianCalifornia
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChemakuan.md)
  * Name: RaceAmericanIndianChemakuan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCherokee.md)
  * Name: RaceAmericanIndianCherokee
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCheyenne.md)
  * Name: RaceAmericanIndianCheyenne
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChickahominy.md)
  * Name: RaceAmericanIndianChickahominy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChinook.md)
  * Name: RaceAmericanIndianChinook
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChippewa.md)
  * Name: RaceAmericanIndianChippewa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChippewaCree.md)
  * Name: RaceAmericanIndianChippewaCree
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChoctaw.md)
  * Name: RaceAmericanIndianChoctaw
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianChumash.md)
  * Name: RaceAmericanIndianChumash
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianComanche.md)
  * Name: RaceAmericanIndianComanche
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCoushatta.md)
  * Name: RaceAmericanIndianCoushatta
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCreek.md)
  * Name: RaceAmericanIndianCreek
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianCupeno.md)
  * Name: RaceAmericanIndianCupeno
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianDelaware.md)
  * Name: RaceAmericanIndianDelaware
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianDiegueno.md)
  * Name: RaceAmericanIndianDiegueno
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianEasternTribes.md)
  * Name: RaceAmericanIndianEasternTribes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianGrosVentres.md)
  * Name: RaceAmericanIndianGrosVentres
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianHoopa.md)
  * Name: RaceAmericanIndianHoopa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianIowa.md)
  * Name: RaceAmericanIndianIowa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianIroquois.md)
  * Name: RaceAmericanIndianIroquois
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianKickapoo.md)
  * Name: RaceAmericanIndianKickapoo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianKiowa.md)
  * Name: RaceAmericanIndianKiowa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianKlallam.md)
  * Name: RaceAmericanIndianKlallam
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianLongIsland.md)
  * Name: RaceAmericanIndianLongIsland
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianLuiseno.md)
  * Name: RaceAmericanIndianLuiseno
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianMaidu.md)
  * Name: RaceAmericanIndianMaidu
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianMiami.md)
  * Name: RaceAmericanIndianMiami
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianMicmac.md)
  * Name: RaceAmericanIndianMicmac
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianNavajo.md)
  * Name: RaceAmericanIndianNavajo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianNorthwestTribes.md)
  * Name: RaceAmericanIndianNorthwestTribes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianOttawa.md)
  * Name: RaceAmericanIndianOttawa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPaiute.md)
  * Name: RaceAmericanIndianPaiute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPassamaquoddy.md)
  * Name: RaceAmericanIndianPassamaquoddy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPawnee.md)
  * Name: RaceAmericanIndianPawnee
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPeoria.md)
  * Name: RaceAmericanIndianPeoria
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPequot.md)
  * Name: RaceAmericanIndianPequot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPima.md)
  * Name: RaceAmericanIndianPima
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPomo.md)
  * Name: RaceAmericanIndianPomo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPonca.md)
  * Name: RaceAmericanIndianPonca
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPotawatomi.md)
  * Name: RaceAmericanIndianPotawatomi
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPueblo.md)
  * Name: RaceAmericanIndianPueblo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianPugetSoundSalish.md)
  * Name: RaceAmericanIndianPugetSoundSalish
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianSacFox.md)
  * Name: RaceAmericanIndianSacFox
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianSeminole.md)
  * Name: RaceAmericanIndianSeminole
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianSerrano.md)
  * Name: RaceAmericanIndianSerrano
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianShawnee.md)
  * Name: RaceAmericanIndianShawnee
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianShoshone.md)
  * Name: RaceAmericanIndianShoshone
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianShoshonePaiute.md)
  * Name: RaceAmericanIndianShoshonePaiute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianSioux.md)
  * Name: RaceAmericanIndianSioux
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianTohonoOOdham.md)
  * Name: RaceAmericanIndianTohonoOOdham
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianUmpqua.md)
  * Name: RaceAmericanIndianUmpqua
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianUte.md)
  * Name: RaceAmericanIndianUte
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianWampanoag.md)
  * Name: RaceAmericanIndianWampanoag
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianWashoe.md)
  * Name: RaceAmericanIndianWashoe
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianWinnebago.md)
  * Name: RaceAmericanIndianWinnebago
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianYuman.md)
  * Name: RaceAmericanIndianYuman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAmericanIndi…](ValueSet-v3-RaceAmericanIndianYurok.md)
  * Name: RaceAmericanIndianYurok
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceAsian](ValueSet-v3-RaceAsian.md)
  * Name: RaceAsian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceBlackOrAfric…](ValueSet-v3-RaceBlackOrAfricanAmerican.md)
  * Name: RaceBlackOrAfricanAmerican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceCanadianLati…](ValueSet-v3-RaceCanadianLatinIndian.md)
  * Name: RaceCanadianLatinIndian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceHawaiianOrPa…](ValueSet-v3-RaceHawaiianOrPacificIsland.md)
  * Name: RaceHawaiianOrPacificIsland
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceNativeAmeric…](ValueSet-v3-RaceNativeAmerican.md)
  * Name: RaceNativeAmerican
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RacePacificIslan…](ValueSet-v3-RacePacificIslandMelanesian.md)
  * Name: RacePacificIslandMelanesian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RacePacificIslan…](ValueSet-v3-RacePacificIslandMicronesian.md)
  * Name: RacePacificIslandMicronesian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RacePacificIslan…](ValueSet-v3-RacePacificIslandPolynesian.md)
  * Name: RacePacificIslandPolynesian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceSoutheastAla…](ValueSet-v3-RaceSoutheastAlaskanIndian.md)
  * Name: RaceSoutheastAlaskanIndian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceSoutheastAla…](ValueSet-v3-RaceSoutheastAlaskanIndianTlingit.md)
  * Name: RaceSoutheastAlaskanIndianTlingit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceSoutheastAla…](ValueSet-v3-RaceSoutheastAlaskanIndianTsimshian.md)
  * Name: RaceSoutheastAlaskanIndianTsimshian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceWhite](ValueSet-v3-RaceWhite.md)
  * Name: RaceWhite
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceWhiteArab](ValueSet-v3-RaceWhiteArab.md)
  * Name: RaceWhiteArab
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceWhiteEuropean](ValueSet-v3-RaceWhiteEuropean.md)
  * Name: RaceWhiteEuropean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RaceWhiteMiddleE…](ValueSet-v3-RaceWhiteMiddleEast.md)
  * Name: RaceWhiteMiddleEast
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RadDiagTherPract…](ValueSet-v3-RadDiagTherPracticeSetting.md)
  * Name: RadDiagTherPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A practice setting where radiology services (diagnostic or therapeutic) are provided (X12N 261QR020…
* Identity: [v3-ReactionDetected…](ValueSet-v3-ReactionDetectedIssueCode.md)
  * Name: ReactionDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate or contraindicated based on the potential for a patient react…
* Identity: [v3-ReactionParticip…](ValueSet-v3-ReactionParticipant.md)
  * Name: ReactionParticipant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ReactivityObserv…](ValueSet-v3-ReactivityObservationInterpretation.md)
  * Name: ReactivityObservationInterpretation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Interpretations of the presence and level of reactivity of the specified component / analyte with t…
* Identity: [v3-RectalInstillati…](ValueSet-v3-RectalInstillation.md)
  * Name: RectalInstillation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Instillation, rectal
* Identity: [v3-RectalRoute](ValueSet-v3-RectalRoute.md)
  * Name: RectalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Rectal
* Identity: [v3-RefillPharmacySu…](ValueSet-v3-RefillPharmacySupplyType.md)
  * Name: RefillPharmacySupplyType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A fill against an order that has already been filled (or partially filled) at least once.
* Identity: [v3-RefrainPolicy](ValueSet-v3-RefrainPolicy.md)
  * Name: RefrainPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Conveys prohibited actions which an information custodian, receiver, or user is not permitted to pe…
* Identity: [v3-RefusalReasonCode](ValueSet-v3-RefusalReasonCode.md)
  * Name: RefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RegulationPolicy…](ValueSet-v3-RegulationPolicyActCode.md)
  * Name: RegulationPolicyActCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A rule set by regulators of product that somehow constrain the use of products. Re…
* Identity: [v3-RehabilitationHo…](ValueSet-v3-RehabilitationHospital.md)
  * Name: RehabilitationHospital
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (X12N 283X00000N)
* Identity: [v3-RelatedReactionD…](ValueSet-v3-RelatedReactionDetectedIssueCode.md)
  * Name: RelatedReactionDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate or contraindicated because of a potential patient reaction to…
* Identity: [v3-RelationalOperat…](ValueSet-v3-RelationalOperator.md)
  * Name: RelationalOperator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies common relational operators used in selection criteria.
* Identity: [v3-RelationshipConj…](ValueSet-v3-RelationshipConjunction.md)
  * Name: RelationshipConjunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.…
* Identity: [v3-ReligiousAffilia…](ValueSet-v3-ReligiousAffiliation.md)
  * Name: ReligiousAffiliation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Assigment of spiritual faith affiliation
* Identity: [v3-RepetitionsOutOf…](ValueSet-v3-RepetitionsOutOfRange.md)
  * Name: RepetitionsOutOfRange
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ResearchSubjectR…](ValueSet-v3-ResearchSubjectRoleBasis.md)
  * Name: ResearchSubjectRoleBasis
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specifies the administrative functionality within a formal experimental design for which the Resear…
* Identity: [v3-ResidentialTreat…](ValueSet-v3-ResidentialTreatmentPracticeSetting.md)
  * Name: ResidentialTreatmentPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ResourceGroupEnt…](ValueSet-v3-ResourceGroupEntityType.md)
  * Name: ResourceGroupEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes to characterize a Resource Group using categories that typify its membership and/or function …
* Identity: [v3-RespiratoryTract…](ValueSet-v3-RespiratoryTractRoute.md)
  * Name: RespiratoryTractRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Respiratory tract
* Identity: [v3-ResponseLevel](ValueSet-v3-ResponseLevel.md)
  * Name: ResponseLevel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specifies whether a response is expected from the addressee of this interaction and what level of d…
* Identity: [v3-ResponseModality](ValueSet-v3-ResponseModality.md)
  * Name: ResponseModality
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Defines the timing and grouping of the response instances.
* Identity: [v3-ResponseMode](ValueSet-v3-ResponseMode.md)
  * Name: ResponseMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its…
* Identity: [v3-ResponsibleParty](ValueSet-v3-ResponsibleParty.md)
  * Name: ResponsibleParty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The role played by a party who has legal responsibility for another party.
* Identity: [v3-RetrobulbarRoute](ValueSet-v3-RetrobulbarRoute.md)
  * Name: RetrobulbarRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Retrobulbar
* Identity: [v3-RheumClinPractic…](ValueSet-v3-RheumClinPracticeSetting.md)
  * Name: RheumClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RigidContainerEn…](ValueSet-v3-RigidContainerEntityType.md)
  * Name: RigidContainerEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A container having a fixed and inflexible dimensions and volume
* Identity: [v3-Rinse](ValueSet-v3-Rinse.md)
  * Name: Rinse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Rinse
* Identity: [v3-Ritwan](ValueSet-v3-Ritwan.md)
  * Name: Ritwan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-River](ValueSet-v3-River.md)
  * Name: River
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClass](ValueSet-v3-RoleClass.md)
  * Name: RoleClass
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This table includes codes for the Role class hierarchy. The values in this hierarchy, represent a R…
* Identity: [v3-RoleClassAccess](ValueSet-v3-RoleClassAccess.md)
  * Name: RoleClassAccess
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role in which the playing entity (material) provides access to another entity. The principal use …
* Identity: [v3-RoleClassActiveI…](ValueSet-v3-RoleClassActiveIngredient.md)
  * Name: RoleClassActiveIngredient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A therapeutically active ingredient (player) in a mixture (scoper), where the mixture is typically …
* Identity: [v3-RoleClassActiveI…](ValueSet-v3-RoleClassActiveIngredientBasis.md)
  * Name: RoleClassActiveIngredientBasis
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassActiveI…](ValueSet-v3-RoleClassActiveIngredientMoietyBasis.md)
  * Name: RoleClassActiveIngredientMoietyBasis
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassActiveI…](ValueSet-v3-RoleClassActiveIngredientReferenceBasis.md)
  * Name: RoleClassActiveIngredientReferenceBasis
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassActiveM…](ValueSet-v3-RoleClassActiveMoiety.md)
  * Name: RoleClassActiveMoiety
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The molecule or ion that is responsible for the intended pharmacological action of the drug substan…
* Identity: [v3-RoleClassAdditive](ValueSet-v3-RoleClassAdditive.md)
  * Name: RoleClassAdditive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An ingredient (player) that is added to a base (scoper), that amounts to a minor part of the overal…
* Identity: [v3-RoleClassAdjacen…](ValueSet-v3-RoleClassAdjacency.md)
  * Name: RoleClassAdjacency
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassAdjuvant](ValueSet-v3-RoleClassAdjuvant.md)
  * Name: RoleClassAdjuvant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassAdminis…](ValueSet-v3-RoleClassAdministerableMaterial.md)
  * Name: RoleClassAdministerableMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A material (player) that can be administered to an Entity (scoper).
* Identity: [v3-RoleClassAffilia…](ValueSet-v3-RoleClassAffiliate.md)
  * Name: RoleClassAffiliate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Player of the Affiliate role has a business/professional relationship with scoper. Player and scope…
* Identity: [v3-RoleClassAgent](ValueSet-v3-RoleClassAgent.md)
  * Name: RoleClassAgent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity (player) that acts or is authorized to act on behalf of another entity (scoper).
* Identity: [v3-RoleClassAliquot](ValueSet-v3-RoleClassAliquot.md)
  * Name: RoleClassAliquot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A portion (player) of an original or source specimen (scoper) used for testing or transportation.
* Identity: [v3-RoleClassAssigne…](ValueSet-v3-RoleClassAssignedEntity.md)
  * Name: RoleClassAssignedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An agent role in which the agent is an Entity acting in the employ of an organization. The focus is…
* Identity: [v3-RoleClassAssocia…](ValueSet-v3-RoleClassAssociative.md)
  * Name: RoleClassAssociative
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A general association between two entities that is neither partitive nor ontological.
* Identity: [v3-RoleClassBase](ValueSet-v3-RoleClassBase.md)
  * Name: RoleClassBase
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A base ingredient (player) is what comprises the major part of a mixture (scoper). E.g., Water in m…
* Identity: [v3-RoleClassBirthpl…](ValueSet-v3-RoleClassBirthplace.md)
  * Name: RoleClassBirthplace
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a place (playing Entity) as the location where a living subject (scoping Entity) was born.
* Identity: [v3-RoleClassCaregiv…](ValueSet-v3-RoleClassCaregiver.md)
  * Name: RoleClassCaregiver
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person responsible for the primary care of a patient at home.
* Identity: [v3-RoleClassCaseSub…](ValueSet-v3-RoleClassCaseSubject.md)
  * Name: RoleClassCaseSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person, non-person living subject, or place that is the subject of an investigation related to a …
* Identity: [v3-RoleClassChild](ValueSet-v3-RoleClassChild.md)
  * Name: RoleClassChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: The player of the role is a child of the scoping entity, in a generic sense.
* Identity: [v3-RoleClassCitizen](ValueSet-v3-RoleClassCitizen.md)
  * Name: RoleClassCitizen
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Citizen of apolitical entity
* Identity: [v3-RoleClassClaimant](ValueSet-v3-RoleClassClaimant.md)
  * Name: RoleClassClaimant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a party making a claim for coverage under a policy or program. A …
* Identity: [v3-RoleClassClinica…](ValueSet-v3-RoleClassClinicalResearchInvestigator.md)
  * Name: RoleClassClinicalResearchInvestigator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a provider, always a person, who has agency authority from a Clinical Research Spo…
* Identity: [v3-RoleClassClinica…](ValueSet-v3-RoleClassClinicalResearchSponsor.md)
  * Name: RoleClassClinicalResearchSponsor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an entity, usually an organization, that is the sponsor of a clinical research tri…
* Identity: [v3-RoleClassColorAd…](ValueSet-v3-RoleClassColorAdditive.md)
  * Name: RoleClassColorAdditive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A substance (player) influencing the optical aspect of material (scoper).
* Identity: [v3-RoleClassCommiss…](ValueSet-v3-RoleClassCommissioningParty.md)
  * Name: RoleClassCommissioningParty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Entity that is authorized to issue or instantiate permissions, privileges, credentials or other …
* Identity: [v3-RoleClassConnect…](ValueSet-v3-RoleClassConnection.md)
  * Name: RoleClassConnection
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassContact](ValueSet-v3-RoleClassContact.md)
  * Name: RoleClassContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person or an organization (player) which provides or receives information regarding another entit…
* Identity: [v3-RoleClassContact…](ValueSet-v3-RoleClassContactCode.md)
  * Name: RoleClassContactCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassContami…](ValueSet-v3-RoleClassContaminantIngredient.md)
  * Name: RoleClassContaminantIngredient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassContent](ValueSet-v3-RoleClassContent.md)
  * Name: RoleClassContent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a material as the content (player) to a container (scoper). Unlike ingredients, the content…
* Identity: [v3-RoleClassContinu…](ValueSet-v3-RoleClassContinuity.md)
  * Name: RoleClassContinuity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassCoverag…](ValueSet-v3-RoleClassCoverageSponsor.md)
  * Name: RoleClassCoverageSponsor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an entity, usually an organization that is the sponsor of an insurance plan or a h…
* Identity: [v3-RoleClassCovered…](ValueSet-v3-RoleClassCoveredParty.md)
  * Name: RoleClassCoveredParty
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A relationship between a party that receives benefit coverage under the terms of a…
* Identity: [v3-RoleClassCredent…](ValueSet-v3-RoleClassCredentialedEntity.md)
  * Name: RoleClassCredentialedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: A role played by an entity that receives credentials from the scoping entity.
* Identity: [v3-RoleClassDedicat…](ValueSet-v3-RoleClassDedicatedServiceDeliveryLocation.md)
  * Name: RoleClassDedicatedServiceDeliveryLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place (player) that is intended to house the provision of services. Scoper is the Entit…
* Identity: [v3-RoleClassDepende…](ValueSet-v3-RoleClassDependent.md)
  * Name: RoleClassDependent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a person covered under a policy or program based on an associatio…
* Identity: [v3-RoleClassDistrib…](ValueSet-v3-RoleClassDistributedMaterial.md)
  * Name: RoleClassDistributedMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A material (player) distributed by a distributor (scoper) who functions between a manufacturer and …
* Identity: [v3-RoleClassEmergen…](ValueSet-v3-RoleClassEmergencyContact.md)
  * Name: RoleClassEmergencyContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity to be contacted in the event of an emergency.
* Identity: [v3-RoleClassEmployee](ValueSet-v3-RoleClassEmployee.md)
  * Name: RoleClassEmployee
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between a person or organization and a person or organization formed for the purpose…
* Identity: [v3-RoleClassEquival…](ValueSet-v3-RoleClassEquivalentEntity.md)
  * Name: RoleClassEquivalentEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassEventLo…](ValueSet-v3-RoleClassEventLocation.md)
  * Name: RoleClassEventLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassExposed…](ValueSet-v3-RoleClassExposedEntity.md)
  * Name: RoleClassExposedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an entity that has been exposed to a person or animal suffering a contagious disea…
* Identity: [v3-RoleClassExposur…](ValueSet-v3-RoleClassExposureAgentCarrier.md)
  * Name: RoleClassExposureAgentCarrier
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An exposure agent carrier is an entity that is capable of conveying an exposure agent from one enti…
* Identity: [v3-RoleClassExposur…](ValueSet-v3-RoleClassExposureVector.md)
  * Name: RoleClassExposureVector
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A vector is a living subject that carries an exposure agent. The vector does not c…
* Identity: [v3-RoleClassFlavorA…](ValueSet-v3-RoleClassFlavorAdditive.md)
  * Name: RoleClassFlavorAdditive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A substance (player) added to a mixture (scoper) to make it taste a certain way. In food the use is…
* Identity: [v3-RoleClassFomite](ValueSet-v3-RoleClassFomite.md)
  * Name: RoleClassFomite
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A fomite is a non-living entity that is capable of conveying exposure agent from o…
* Identity: [v3-RoleClassGuarant…](ValueSet-v3-RoleClassGuarantor.md)
  * Name: RoleClassGuarantor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person or organization (player) that serves as a financial guarantor for another person or organi…
* Identity: [v3-RoleClassGuardian](ValueSet-v3-RoleClassGuardian.md)
  * Name: RoleClassGuardian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Guardian of a ward
* Identity: [v3-RoleClassHasGene…](ValueSet-v3-RoleClassHasGeneric.md)
  * Name: RoleClassHasGeneric
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A special link between pharmaceuticals indicating that the target (scoper) is a generic for the sou…
* Identity: [v3-RoleClassHealthC…](ValueSet-v3-RoleClassHealthChart.md)
  * Name: RoleClassHealthChart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The role of a material (player) that is the physical health chart belonging to an organization (sco…
* Identity: [v3-RoleClassHealthc…](ValueSet-v3-RoleClassHealthcareProvider.md)
  * Name: RoleClassHealthcareProvider
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Entity (player) that is authorized to provide health care services by some authorizing agency (s…
* Identity: [v3-RoleClassHeldEnt…](ValueSet-v3-RoleClassHeldEntity.md)
  * Name: RoleClassHeldEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Entity that is currently in the possession of a holder (scoper), who holds, or uses it, usually bas…
* Identity: [v3-RoleClassICSRInv…](ValueSet-v3-RoleClassICSRInvestigationSubject.md)
  * Name: RoleClassICSRInvestigationSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The class of the primary role by which the party is identified as the subject of a…
* Identity: [v3-RoleClassIdentif…](ValueSet-v3-RoleClassIdentifiedEntity.md)
  * Name: RoleClassIdentifiedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Roles played by entities and scoped by entities that identify them for various purposes.
* Identity: [v3-RoleClassInactiv…](ValueSet-v3-RoleClassInactiveIngredient.md)
  * Name: RoleClassInactiveIngredient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassInciden…](ValueSet-v3-RoleClassIncidentalServiceDeliveryLocation.md)
  * Name: RoleClassIncidentalServiceDeliveryLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a place at which health care services may be provided without prior designation or…
* Identity: [v3-RoleClassIndivid…](ValueSet-v3-RoleClassIndividual.md)
  * Name: RoleClassIndividual
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a party covered under a policy as the policy holder. An individua…
* Identity: [v3-RoleClassIngredi…](ValueSet-v3-RoleClassIngredientEntity.md)
  * Name: RoleClassIngredientEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a component (player) to a mixture (scoper). E.g., Glucose and Water are ingredients of D5W,…
* Identity: [v3-RoleClassInstance](ValueSet-v3-RoleClassInstance.md)
  * Name: RoleClassInstance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An individual piece of material (player) instantiating a class of material (scoper).
* Identity: [v3-RoleClassInvesti…](ValueSet-v3-RoleClassInvestigationSubject.md)
  * Name: RoleClassInvestigationSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity that is the subject of an investigation. This role is scoped by the party responsible for…
* Identity: [v3-RoleClassInvoice…](ValueSet-v3-RoleClassInvoicePayor.md)
  * Name: RoleClassInvoicePayor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The role of an organization that undertakes to accept claims invoices, assess the coverage or payme…
* Identity: [v3-RoleClassIsSpeci…](ValueSet-v3-RoleClassIsSpeciesEntity.md)
  * Name: RoleClassIsSpeciesEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a specialized material concept (player) to its generalization (scoper).
* Identity: [v3-RoleClassIsolate](ValueSet-v3-RoleClassIsolate.md)
  * Name: RoleClassIsolate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A microorganism that has been isolated from other microorganisms or a source matrix.
* Identity: [v3-RoleClassLicense…](ValueSet-v3-RoleClassLicensedEntity.md)
  * Name: RoleClassLicensedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the scoper certifies the player ( e. g. a medical care giver, a medical dev…
* Identity: [v3-RoleClassLocated…](ValueSet-v3-RoleClassLocatedEntity.md)
  * Name: RoleClassLocatedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates an entity (player) to a location (scoper) at which it is present in some way. This presence…
* Identity: [v3-RoleClassMaintai…](ValueSet-v3-RoleClassMaintainedEntity.md)
  * Name: RoleClassMaintainedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity (player) that is maintained by another entity (scoper). This is typical role held by dura…
* Identity: [v3-RoleClassManaged…](ValueSet-v3-RoleClassManagedEntity.md)
  * Name: RoleClassManagedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A value set of role classCodes related to entity management.
* Identity: [v3-RoleClassManufac…](ValueSet-v3-RoleClassManufacturedProduct.md)
  * Name: RoleClassManufacturedProduct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Scoped by the manufacturer
* Identity: [v3-RoleClassMechani…](ValueSet-v3-RoleClassMechanicalIngredient.md)
  * Name: RoleClassMechanicalIngredient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassMember](ValueSet-v3-RoleClassMember.md)
  * Name: RoleClassMember
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an entity that is a member of a group. The group provides the scope for this role.…
* Identity: [v3-RoleClassMilitar…](ValueSet-v3-RoleClassMilitaryPerson.md)
  * Name: RoleClassMilitaryPerson
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a member of a military service. Scoper is the military service (e.g. Army, Navy, A…
* Identity: [v3-RoleClassMolecul…](ValueSet-v3-RoleClassMolecularBond.md)
  * Name: RoleClassMolecularBond
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassMolecul…](ValueSet-v3-RoleClassMolecularFeatures.md)
  * Name: RoleClassMolecularFeatures
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassMolecul…](ValueSet-v3-RoleClassMolecularPart.md)
  * Name: RoleClassMolecularPart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassMutualR…](ValueSet-v3-RoleClassMutualRelationship.md)
  * Name: RoleClassMutualRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship that is based on mutual behavior of the two Entities as being related. The basis of …
* Identity: [v3-RoleClassNamedIn…](ValueSet-v3-RoleClassNamedInsured.md)
  * Name: RoleClassNamedInsured
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a party to an insurance policy to which the insurer agrees to ind…
* Identity: [v3-RoleClassNextOfK…](ValueSet-v3-RoleClassNextOfKin.md)
  * Name: RoleClassNextOfKin
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An individual designated for notification as the next of kin for a given entity.
* Identity: [v3-RoleClassNotaryP…](ValueSet-v3-RoleClassNotaryPublic.md)
  * Name: RoleClassNotaryPublic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleClassNurse](ValueSet-v3-RoleClassNurse.md)
  * Name: RoleClassNurse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-RoleClassNursePr…](ValueSet-v3-RoleClassNursePractitioner.md)
  * Name: RoleClassNursePractitioner
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-RoleClassOntolog…](ValueSet-v3-RoleClassOntological.md)
  * Name: RoleClassOntological
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship in which the scoping Entity defines or specifies what the playing Entity is. Thus, t…
* Identity: [v3-RoleClassOwnedEn…](ValueSet-v3-RoleClassOwnedEntity.md)
  * Name: RoleClassOwnedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An Entity (player) for which someone (scoper) is granted by law the right to call the material (pla…
* Identity: [v3-RoleClassPart](ValueSet-v3-RoleClassPart.md)
  * Name: RoleClassPart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An association between two Entities where the playing Entity is considered in some way "part" of th…
* Identity: [v3-RoleClassPartiti…](ValueSet-v3-RoleClassPartitive.md)
  * Name: RoleClassPartitive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An association between two Entities where the playing Entity is considered in some way "part" of th…
* Identity: [v3-RoleClassPassive](ValueSet-v3-RoleClassPassive.md)
  * Name: RoleClassPassive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An association for a playing Entity that is used, known, treated, handled, built, or destroyed, etc…
* Identity: [v3-RoleClassPatient](ValueSet-v3-RoleClassPatient.md)
  * Name: RoleClassPatient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A Role of a LivingSubject (player) as a recipient of health care services from a he…
* Identity: [v3-RoleClassPayee](ValueSet-v3-RoleClassPayee.md)
  * Name: RoleClassPayee
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The role of an organization or individual designated to receive payment for a claim against a parti…
* Identity: [v3-RoleClassPersona…](ValueSet-v3-RoleClassPersonalRelationship.md)
  * Name: RoleClassPersonalRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Links two people in a personal relationship. The character of the relationship must be defined by a…
* Identity: [v3-RoleClassPhysici…](ValueSet-v3-RoleClassPhysician.md)
  * Name: RoleClassPhysician
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-RoleClassPhysici…](ValueSet-v3-RoleClassPhysicianAssistant.md)
  * Name: RoleClassPhysicianAssistant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: ** **No description** **
* Identity: [v3-RoleClassPlaceOf…](ValueSet-v3-RoleClassPlaceOfDeath.md)
  * Name: RoleClassPlaceOfDeath
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Definition: Relates a place (playing Entity) as the location where a living subject (scoping Entity…
* Identity: [v3-RoleClassPolicyH…](ValueSet-v3-RoleClassPolicyHolder.md)
  * Name: RoleClassPolicyHolder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a person or organization that holds an insurance policy. The underwriter of that p…
* Identity: [v3-RoleClassPreserv…](ValueSet-v3-RoleClassPreservative.md)
  * Name: RoleClassPreservative
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A substance (player) added to a mixture (scoper) to prevent microorganisms (fungi, bacteria) to spo…
* Identity: [v3-RoleClassProduct…](ValueSet-v3-RoleClassProductRelated.md)
  * Name: RoleClassProductRelated
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A value set of product related role classCodes
* Identity: [v3-RoleClassProgram…](ValueSet-v3-RoleClassProgramEligible.md)
  * Name: RoleClassProgramEligible
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a party that meets the eligibility criteria for coverage under a …
* Identity: [v3-RoleClassQualifi…](ValueSet-v3-RoleClassQualifiedEntity.md)
  * Name: RoleClassQualifiedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An entity (player) that has been recognized as having certain training/experience or other characte…
* Identity: [v3-RoleClassRegulat…](ValueSet-v3-RoleClassRegulatedProduct.md)
  * Name: RoleClassRegulatedProduct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A product regulated by some governmentatl orgnization. The role is played by Material and scoped by…
* Identity: [v3-RoleClassRelatio…](ValueSet-v3-RoleClassRelationshipFormal.md)
  * Name: RoleClassRelationshipFormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A relationship between two entities that is formally recognized, frequently by a contract or simila…
* Identity: [v3-RoleClassResearc…](ValueSet-v3-RoleClassResearchSubject.md)
  * Name: RoleClassResearchSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Specifies the administrative functionality within a formal experimental design for w…
* Identity: [v3-RoleClassRetaile…](ValueSet-v3-RoleClassRetailedMaterial.md)
  * Name: RoleClassRetailedMaterial
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Material (player) sold by a retailer (scoper), who also give advice to prospective buyers.
* Identity: [v3-RoleClassRoot](ValueSet-v3-RoleClassRoot.md)
  * Name: RoleClassRoot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Corresponds to the Role class
* Identity: [v3-RoleClassSame](ValueSet-v3-RoleClassSame.md)
  * Name: RoleClassSame
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The "same" roleclass asserts an identity between playing and scoping entities: that they are in fac…
* Identity: [v3-RoleClassService…](ValueSet-v3-RoleClassServiceDeliveryLocation.md)
  * Name: RoleClassServiceDeliveryLocation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a place at which services may be provided.
* Identity: [v3-RoleClassSigning…](ValueSet-v3-RoleClassSigningAuthorityOrOfficer.md)
  * Name: RoleClassSigningAuthorityOrOfficer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The role of a person (player) who is the officer or signature authority for of a scoping entity, us…
* Identity: [v3-RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md)
  * Name: RoleClassSpecimen
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a material entity that is a specimen for an act. It is scoped by the source of the…
* Identity: [v3-RoleClassStabili…](ValueSet-v3-RoleClassStabilizer.md)
  * Name: RoleClassStabilizer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A stabilizer (player) added to a mixture (scoper) in order to prevent the molecular disintegration …
* Identity: [v3-RoleClassStoredE…](ValueSet-v3-RoleClassStoredEntity.md)
  * Name: RoleClassStoredEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates an entity (player) (e.g. a device) to a location (scoper) at which it is normally found or …
* Identity: [v3-RoleClassStudent](ValueSet-v3-RoleClassStudent.md)
  * Name: RoleClassStudent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an individual who is a student of a school, which is the scoping entity.
* Identity: [v3-RoleClassSubscri…](ValueSet-v3-RoleClassSubscriber.md)
  * Name: RoleClassSubscriber
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role played by a person covered under a policy based on association with a spons…
* Identity: [v3-RoleClassSubstan…](ValueSet-v3-RoleClassSubstancePresence.md)
  * Name: RoleClassSubstancePresence
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The presence of an bio-chemical entity (substance) at a location or environment, such as an ingredi…
* Identity: [v3-RoleClassSubsume…](ValueSet-v3-RoleClassSubsumedBy.md)
  * Name: RoleClassSubsumedBy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a prevailing record of an Entity (scoper) with another record (player) that it subsumes.…
* Identity: [v3-RoleClassSubsumer](ValueSet-v3-RoleClassSubsumer.md)
  * Name: RoleClassSubsumer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2012-03-15
  * Description: An entity that subsumes the identity of another. Used in the context of merging documented entity i…
* Identity: [v3-RoleClassTerrito…](ValueSet-v3-RoleClassTerritoryOfAuthority.md)
  * Name: RoleClassTerritoryOfAuthority
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a place entity (player) as the region over which the scoper (typically an Organization) has…
* Identity: [v3-RoleClassTherape…](ValueSet-v3-RoleClassTherapeuticAgent.md)
  * Name: RoleClassTherapeuticAgent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A manufactured material (player) that is used for its therapeutic properties. The manufacturer is t…
* Identity: [v3-RoleClassUnderwr…](ValueSet-v3-RoleClassUnderwriter.md)
  * Name: RoleClassUnderwriter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by a person or an organization. It is the party that1. accepts fiscal responsibi…

* Identity: [v3-RoleClassUsedEnt…](ValueSet-v3-RoleClassUsedEntity.md)
  * Name: RoleClassUsedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**An entity (player) that is used by another entity (scoper)
* Identity: [v3-RoleClassWarrant…](ValueSet-v3-RoleClassWarrantedProduct.md)
  * Name: RoleClassWarrantedProduct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role a product plays when a guarantee is given to the purchaser by the seller (scoping entity) st…
* Identity: [v3-RoleCode](ValueSet-v3-RoleCode.md)
  * Name: v3 Code System RoleCode
  * Version: 3.0.0
  * Status: active
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2018-08-12
  * Description: A set of codes further specifying the kind of Role; specific classification codes for further qual…
* Identity: [v3-RoleInformationS…](ValueSet-v3-RoleInformationSensitivityPolicy.md)
  * Name: RoleInformationSensitivityPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: RoleSensitivity codes are used to bind information to a Role.confidentialityCode per organizational…
* Identity: [v3-RoleLinkHasConta…](ValueSet-v3-RoleLinkHasContact.md)
  * Name: RoleLinkHasContact
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkHasDirec…](ValueSet-v3-RoleLinkHasDirectAuthorityOver.md)
  * Name: RoleLinkHasDirectAuthorityOver
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Role has direct authority over the target role in a chain of authority.
* Identity: [v3-RoleLinkHasIndir…](ValueSet-v3-RoleLinkHasIndirectAuthorityOver.md)
  * Name: RoleLinkHasIndirectAuthorityOver
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The source Role has indirect authority over the target role in a chain of authority.
* Identity: [v3-RoleLinkHasPart](ValueSet-v3-RoleLinkHasPart.md)
  * Name: RoleLinkHasPart
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The target Role is part of the Source Role.
* Identity: [v3-RoleLinkIdentifi…](ValueSet-v3-RoleLinkIdentification.md)
  * Name: RoleLinkIdentification
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**The source role provides identification for the target role. The source role must b…
* Identity: [v3-RoleLinkIsBackup…](ValueSet-v3-RoleLinkIsBackupFor.md)
  * Name: RoleLinkIsBackupFor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This relationship indicates the source Role is available to the target Role as a backup. An entity …
* Identity: [v3-RoleLinkRelated](ValueSet-v3-RoleLinkRelated.md)
  * Name: RoleLinkRelated
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An action taken with respect to a subject Entity by a regulatory or authoritative body with supervi…
* Identity: [v3-RoleLinkReplaces](ValueSet-v3-RoleLinkReplaces.md)
  * Name: RoleLinkReplaces
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: This relationship indicates that the source Role replaces (or subsumes) the target Role. Allows for…
* Identity: [v3-RoleLinkStatus](ValueSet-v3-RoleLinkStatus.md)
  * Name: RoleLinkStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusAc…](ValueSet-v3-RoleLinkStatusActive.md)
  * Name: RoleLinkStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusCa…](ValueSet-v3-RoleLinkStatusCancelled.md)
  * Name: RoleLinkStatusCancelled
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusCo…](ValueSet-v3-RoleLinkStatusCompleted.md)
  * Name: RoleLinkStatusCompleted
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusNo…](ValueSet-v3-RoleLinkStatusNormal.md)
  * Name: RoleLinkStatusNormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusNu…](ValueSet-v3-RoleLinkStatusNullified.md)
  * Name: RoleLinkStatusNullified
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkStatusPe…](ValueSet-v3-RoleLinkStatusPending.md)
  * Name: RoleLinkStatusPending
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-RoleLinkType](ValueSet-v3-RoleLinkType.md)
  * Name: RoleLinkType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies sp…
* Identity: [v3-RoleLocationIden…](ValueSet-v3-RoleLocationIdentifiedEntity.md)
  * Name: RoleLocationIdentifiedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Describes types of identifiers other than the primary location registry identifier …
* Identity: [v3-RoleStatus](ValueSet-v3-RoleStatus.md)
  * Name: RoleStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Codes representing the defined possible states of an Role, as defined by the Role class state machi…
* Identity: [v3-RoleStatusActive](ValueSet-v3-RoleStatusActive.md)
  * Name: RoleStatusActive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the fact that the Entity is currently active in the Role.
* Identity: [v3-RoleStatusCancel…](ValueSet-v3-RoleStatusCancelled.md)
  * Name: RoleStatusCancelled
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The terminal state resulting from cancellation of the role prior to activation.
* Identity: [v3-RoleStatusNormal](ValueSet-v3-RoleStatusNormal.md)
  * Name: RoleStatusNormal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The 'typical' state. Excludes "nullified" which represents the termination state of a Role instance…
* Identity: [v3-RoleStatusNullif…](ValueSet-v3-RoleStatusNullified.md)
  * Name: RoleStatusNullified
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the termination of a Role instance that was created in error.
* Identity: [v3-RoleStatusPending](ValueSet-v3-RoleStatusPending.md)
  * Name: RoleStatusPending
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing that fact that the role has not yet become active.
* Identity: [v3-RoleStatusSuspen…](ValueSet-v3-RoleStatusSuspended.md)
  * Name: RoleStatusSuspended
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state that represents a suspension of the Entity playing the Role. This state is arrived at fro…
* Identity: [v3-RoleStatusTermin…](ValueSet-v3-RoleStatusTerminated.md)
  * Name: RoleStatusTerminated
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The state representing the successful termination of the Role.
* Identity: [v3-RouteByMethod](ValueSet-v3-RouteByMethod.md)
  * Name: RouteByMethod
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Route of substance administration classified by administration method.
* Identity: [v3-RouteBySite](ValueSet-v3-RouteBySite.md)
  * Name: RouteBySite
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Route of substance administration classified by site.
* Identity: [v3-RouteOfAdministr…](ValueSet-v3-RouteOfAdministration.md)
  * Name: RouteOfAdministration
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The path the administered medication takes to get into the body or into contact with the body.
* Identity: [v3-SCDHEC-GISSpatia…](ValueSet-v3-SCDHEC-GISSpatialAccuracyTiers.md)
  * Name: SCDHEC-GISSpatialAccuracyTiers
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The South Carolina Department of Health and Environmental Control GIS Spatial Data…
* Identity: [v3-Sahaptian](ValueSet-v3-Sahaptian.md)
  * Name: Sahaptian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Salishan](ValueSet-v3-Salishan.md)
  * Name: Salishan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SaukFoxKickapoo](ValueSet-v3-SaukFoxKickapoo.md)
  * Name: SaukFoxKickapoo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ScalpRoute](ValueSet-v3-ScalpRoute.md)
  * Name: ScalpRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Scalp
* Identity: [v3-SchedulingActRea…](ValueSet-v3-SchedulingActReason.md)
  * Name: SchedulingActReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Reasons for cancelling or rescheduling an Appointment
* Identity: [v3-SecurityAlterati…](ValueSet-v3-SecurityAlterationIntegrityObservationType.md)
  * Name: SecurityAlterationIntegrityObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: <pType of security metadata observation made about the alteration integrity of an IT resource (data…
* Identity: [v3-SecurityAlterati…](ValueSet-v3-SecurityAlterationIntegrityObservationValue.md)
  * Name: SecurityAlterationIntegrityObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SecurityCategory…](ValueSet-v3-SecurityCategoryObservationType.md)
  * Name: SecurityCategoryObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the category of an IT resource (data, information …
* Identity: [v3-SecurityCategory…](ValueSet-v3-SecurityCategoryObservationValue.md)
  * Name: SecurityCategoryObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Security observation values used to indicate security category metadata. V:SecurityCategoryObservat…
* Identity: [v3-SecurityClassifi…](ValueSet-v3-SecurityClassificationObservationType.md)
  * Name: SecurityClassificationObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the classification of an IT resource (data, inform…
* Identity: [v3-SecurityClassifi…](ValueSet-v3-SecurityClassificationObservationValue.md)
  * Name: SecurityClassificationObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Security observation values used to indicate security classification metadata.
* Identity: [v3-SecurityControlO…](ValueSet-v3-SecurityControlObservationType.md)
  * Name: SecurityControlObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the control of an IT resource (data, information o…
* Identity: [v3-SecurityControlO…](ValueSet-v3-SecurityControlObservationValue.md)
  * Name: SecurityControlObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Security observation values used to indicate security control metadata. V:SecurityControl is the un…
* Identity: [v3-SecurityDataInte…](ValueSet-v3-SecurityDataIntegrityObservationType.md)
  * Name: SecurityDataIntegrityObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the data integrity of an IT resource (data, inform…
* Identity: [v3-SecurityDataInte…](ValueSet-v3-SecurityDataIntegrityObservationValue.md)
  * Name: SecurityDataIntegrityObservationValue
  * Version: 3.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: Type of security metadata observation made about the data integrity of an IT resource (data, inform…
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityConfidenceObservationType.md)
  * Name: SecurityIntegrityConfidenceObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the integrity confidence of an IT resource (data, …
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityConfidenceObservationValue.md)
  * Name: SecurityIntegrityConfidenceObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityObservationType.md)
  * Name: SecurityIntegrityObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the integrity of an IT resource (data, information…
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityObservationValue.md)
  * Name: SecurityIntegrityObservationValue
  * Version: 3.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: Type of security metadata observation made about the integrity of an IT resource (data, information…
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationType.md)
  * Name: SecurityIntegrityProvenanceAssertedByObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Type of security metadata observation made about the integrity provenance of an IT resource (data, …
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationValue.md)
  * Name: SecurityIntegrityProvenanceAssertedByObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: ** **No description** **
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceObservationType.md)
  * Name: SecurityIntegrityProvenanceObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the provenance integrity of an IT resource (data, …
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceObservationValue.md)
  * Name: SecurityIntegrityProvenanceObservationValue
  * Version: 3.1.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: Type of security metadata observation made about the provenance integrity of an IT resource (data, …
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationType.md)
  * Name: SecurityIntegrityProvenanceReportedByObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Type of security metadata observation made about the integrity provenance of an IT resource (data, …
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationValue.md)
  * Name: SecurityIntegrityProvenanceReportedByObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: ** **No description** **
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityStatusObservation.md)
  * Name: SecurityIntegrityStatusObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Security observation values used to indicate security integrity status metadata.
* Identity: [v3-SecurityIntegrit…](ValueSet-v3-SecurityIntegrityStatusObservationType.md)
  * Name: SecurityIntegrityStatusObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Type of security metadata observation made about the integrity status of an IT resource (data, info…
* Identity: [v3-SecurityLabelMark](ValueSet-v3-SecurityLabelMark.md)
  * Name: SecurityLabelMark
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes used for displayed Security Label tags. Supports selection of SecurityLabelMark value set wit…
* Identity: [v3-SecurityLabelMar…](ValueSet-v3-SecurityLabelMarkLabel.md)
  * Name: SecurityLabelMarkLabel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes used for displayed Security Label tags. Supports the selection of SecurityLabelMark leaf conc…
* Identity: [v3-SecurityObservat…](ValueSet-v3-SecurityObservationType.md)
  * Name: SecurityObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: Type of security metadata observation made about an IT resource (data, information object, service,…
* Identity: [v3-SecurityObservat…](ValueSet-v3-SecurityObservationValue.md)
  * Name: SecurityObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Observation values used to indicate security observation metadata.
* Identity: [v3-SecurityPolicy](ValueSet-v3-SecurityPolicy.md)
  * Name: SecurityPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Types of security policies that further specify the ActClassPolicy value set.**Examples:**…
* Identity: [v3-SecurityTrustAcc…](ValueSet-v3-SecurityTrustAccreditationObservationType.md)
  * Name: SecurityTrustAccreditationObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about the formal declaration by an authority or neutral …
* Identity: [v3-SecurityTrustAcc…](ValueSet-v3-SecurityTrustAccreditationObservationValue.md)
  * Name: SecurityTrustAccreditationObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about the formal declaration by an authority or neutr…
* Identity: [v3-SecurityTrustAgr…](ValueSet-v3-SecurityTrustAgreementObservationType.md)
  * Name: SecurityTrustAgreementObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about security requirements for a security domain. [ISO…
* Identity: [v3-SecurityTrustAgr…](ValueSet-v3-SecurityTrustAgreementObservationValue.md)
  * Name: SecurityTrustAgreementObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about security requirements for a security domain. [ISO…
* Identity: [v3-SecurityTrustAss…](ValueSet-v3-SecurityTrustAssuranceObservationType.md)
  * Name: SecurityTrustAssuranceObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about the digital quality or reliability of a trust a…
* Identity: [v3-SecurityTrustAss…](ValueSet-v3-SecurityTrustAssuranceObservationValue.md)
  * Name: SecurityTrustAssuranceObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about the digital quality or reliability of a trust a…
* Identity: [v3-SecurityTrustCer…](ValueSet-v3-SecurityTrustCertificateObservationType.md)
  * Name: SecurityTrustCertificateObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about a set of security-relevant data issued by a securi…
* Identity: [v3-SecurityTrustCer…](ValueSet-v3-SecurityTrustCertificateObservationValue.md)
  * Name: SecurityTrustCertificateObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about a set of security-relevant data issued by a sec…
* Identity: [v3-SecurityTrustFra…](ValueSet-v3-SecurityTrustFrameworkObservationType.md)
  * Name: SecurityTrustFrameworkObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about a complete set of contracts, regulations, or commi…
* Identity: [v3-SecurityTrustFra…](ValueSet-v3-SecurityTrustFrameworkObservationValue.md)
  * Name: SecurityTrustFrameworkObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about a complete set of contracts, regulations, or co…
* Identity: [v3-SecurityTrustMec…](ValueSet-v3-SecurityTrustMechanismObservationType.md)
  * Name: SecurityTrustMechanismObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Type of security metadata observation made about a complete set of contracts, regulations, or commi…
* Identity: [v3-SecurityTrustMec…](ValueSet-v3-SecurityTrustMechanismObservationValue.md)
  * Name: SecurityTrustMechanismObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-08-07
  * Description: Values for security metadata observation made about a complete set of contracts, regulations, or co…
* Identity: [v3-SecurityTrustObs…](ValueSet-v3-SecurityTrustObservationType.md)
  * Name: SecurityTrustObservationType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: Type of security metadata observation made about aspects of trust applicable to an IT resource (dat…
* Identity: [v3-SecurityTrustObs…](ValueSet-v3-SecurityTrustObservationValue.md)
  * Name: SecurityTrustObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: Values for security metadata observation made about aspects of trust applicable to an IT resource (…
* Identity: [v3-Sequencing](ValueSet-v3-Sequencing.md)
  * Name: Sequencing
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Specifies sequence of sort order.
* Identity: [v3-SerranoGabrielino](ValueSet-v3-SerranoGabrielino.md)
  * Name: SerranoGabrielino
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-ServiceDeliveryL…](ValueSet-v3-ServiceDeliveryLocationRoleType.md)
  * Name: ServiceDeliveryLocationRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role of a place that further classifies the setting (e.g., accident site, road side, work site, c…
* Identity: [v3-SetOperator](ValueSet-v3-SetOperator.md)
  * Name: SetOperator
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SeverityObservat…](ValueSet-v3-SeverityObservation.md)
  * Name: SeverityObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Potential values for observations of severity.
* Identity: [v3-SeverityObservat…](ValueSet-v3-SeverityObservationCode.md)
  * Name: SeverityObservationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Shasta](ValueSet-v3-Shasta.md)
  * Name: Shasta
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Sibling](ValueSet-v3-Sibling.md)
  * Name: Sibling
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: One person who shares a parent or parents with another.
* Identity: [v3-SiblingInLaw](ValueSet-v3-SiblingInLaw.md)
  * Name: SiblingInLaw
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is: (1) a sibling of the scoping person's spouse, or (2) the spouse of the s…
* Identity: [v3-SignificantOther…](ValueSet-v3-SignificantOtherRoleType.md)
  * Name: SignificantOtherRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person who is important to one's well being; especially a spouse or one in a similar relationship…
* Identity: [v3-SinusUnspecified…](ValueSet-v3-SinusUnspecifiedRoute.md)
  * Name: SinusUnspecifiedRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sinus, unspecified
* Identity: [v3-Siouan](ValueSet-v3-Siouan.md)
  * Name: Siouan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SiouanCatawba](ValueSet-v3-SiouanCatawba.md)
  * Name: SiouanCatawba
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SirenikskiYupik](ValueSet-v3-SirenikskiYupik.md)
  * Name: SirenikskiYupik
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SkinRoute](ValueSet-v3-SkinRoute.md)
  * Name: SkinRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Skin
* Identity: [v3-SnodentAnteriorI…](ValueSet-v3-SnodentAnteriorInterarchDeviationTypeInternational.md)
  * Name: SnodentAnteriorInterarchDeviationTypeInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for dental anterior inter-arch deviations utilized to calculate the Salzman…
* Identity: [v3-SnodentCraniofac…](ValueSet-v3-SnodentCraniofacialAnomalyInternational.md)
  * Name: SnodentCraniofacialAnomalyInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the most common craniofacial anomalies that may influence the course of…
* Identity: [v3-SnodentDentalAbn…](ValueSet-v3-SnodentDentalAbnormalityInternational.md)
  * Name: SnodentDentalAbnormalityInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for tooth-specific abnormalities that impact orthodontic treatment.This…
* Identity: [v3-SnodentDentalFre…](ValueSet-v3-SnodentDentalFrenumRegionInternational.md)
  * Name: SnodentDentalFrenumRegionInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the regions of the human frenum within the mouth.This value set con…
* Identity: [v3-SnodentDentalPer…](ValueSet-v3-SnodentDentalPeriodontalProbingPositionInternational.md)
  * Name: SnodentDentalPeriodontalProbingPositionInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the relative positions around the tooth that are probed and measured in…
* Identity: [v3-SnodentDentalToo…](ValueSet-v3-SnodentDentalToothFurcationSiteInternational.md)
  * Name: SnodentDentalToothFurcationSiteInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the relative location of a human tooth root that is being observed for …
* Identity: [v3-SnodentDentalToo…](ValueSet-v3-SnodentDentalToothMobilityMillerClassificationInternational.md)
  * Name: SnodentDentalToothMobilityMillerClassificationInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the recognized grades of tooth mobility according to the Miller Classif…
* Identity: [v3-SnodentDentalUni…](ValueSet-v3-SnodentDentalUniversalNumberingSystemInternational.md)
  * Name: SnodentDentalUniversalNumberingSystemInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for all of the possible human teeth, both adult and adolescent.This val…
* Identity: [v3-SnodentDentition…](ValueSet-v3-SnodentDentitionStateInternational.md)
  * Name: SnodentDentitionStateInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the stages of dentition an individual progresses through during a lifet…
* Identity: [v3-SnodentJawTypeIn…](ValueSet-v3-SnodentJawTypeInternational.md)
  * Name: SnodentJawTypeInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the two jaws (mandible and maxilla).This value set contains content…
* Identity: [v3-SnodentOralCavit…](ValueSet-v3-SnodentOralCavityAreaInternational.md)
  * Name: SnodentOralCavityAreaInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for regions in the mouth utilized to calculate the Salzmann Malocclusion Se…
* Identity: [v3-SnodentOrthodont…](ValueSet-v3-SnodentOrthodonticDiagnosticFeatureInternational.md)
  * Name: SnodentOrthodonticDiagnosticFeatureInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for gross patient findings that inform the course of orthodontic treatment …
* Identity: [v3-SnodentOrthodont…](ValueSet-v3-SnodentOrthodonticTreatmentPreconditionInternational.md)
  * Name: SnodentOrthodonticTreatmentPreconditionInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for patient conditions that may preclude starting orthodontic treatment.…
* Identity: [v3-SnodentPosterior…](ValueSet-v3-SnodentPosteriorInterarchDeviationTypeInternational.md)
  * Name: SnodentPosteriorInterarchDeviationTypeInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for dental posterior inter-arch deviations utilized to calculate the Salzma…
* Identity: [v3-SnodentSalzmannI…](ValueSet-v3-SnodentSalzmannInterarchDeviationMaxillaryToothInternational.md)
  * Name: SnodentSalzmannInterarchDeviationMaxillaryToothInternational
  * Version: 3.0.0
  * Status: active
  * Owner: att?
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The SNODENT identifiers for the teeth in the maxilla assessed for tooth-specific inter-arch deviati…
* Identity: [v3-SoftTissueRoute](ValueSet-v3-SoftTissueRoute.md)
  * Name: SoftTissueRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Soft tissue
* Identity: [v3-SoftwareNameExam…](ValueSet-v3-SoftwareNameExample.md)
  * Name: Software Name Example
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: An example value set representing the SoftwareName concept domain used to convey a coded name for a…
* Identity: [v3-SolidDrugForm](ValueSet-v3-SolidDrugForm.md)
  * Name: SolidDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SolutionDrugForm](ValueSet-v3-SolutionDrugForm.md)
  * Name: SolutionDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A liquid preparation that contains one or more chemical substances dissolved, i.e., molecularly dis…
* Identity: [v3-SouthernAlaska](ValueSet-v3-SouthernAlaska.md)
  * Name: SouthernAlaska
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SouthernCaddoan](ValueSet-v3-SouthernCaddoan.md)
  * Name: SouthernCaddoan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SouthernNumic](ValueSet-v3-SouthernNumic.md)
  * Name: SouthernNumic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SpecimenAdditive…](ValueSet-v3-SpecimenAdditiveEntity.md)
  * Name: SpecimenAdditiveEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Set of codes related to specimen additives
* Identity: [v3-SpecimenEntityTy…](ValueSet-v3-SpecimenEntityType.md)
  * Name: SpecimenEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SpecimenRoleType](ValueSet-v3-SpecimenRoleType.md)
  * Name: SpecimenRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SponsorParticipa…](ValueSet-v3-SponsorParticipationFunction.md)
  * Name: SponsorParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the manner in which sponsors participate in a policy or pro…
* Identity: [v3-Spouse](ValueSet-v3-Spouse.md)
  * Name: Spouse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A relationship between two people characterizing their "familial" relationship
* Identity: [v3-StatusRevisionRe…](ValueSet-v3-StatusRevisionRefusalReasonCode.md)
  * Name: StatusRevisionRefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Indicates why the act revision (status update) is being refused.
* Identity: [v3-StepChild](ValueSet-v3-StepChild.md)
  * Name: StepChild
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child of the scoping person's spouse by a previous union.
* Identity: [v3-StepParent](ValueSet-v3-StepParent.md)
  * Name: StepParent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is the spouse of the scoping person's parent and not the scoping person's na…
* Identity: [v3-StepSibling](ValueSet-v3-StepSibling.md)
  * Name: StepSibling
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The player of the role is a child of the scoping person's stepparent.
* Identity: [v3-StreetAddressLine](ValueSet-v3-StreetAddressLine.md)
  * Name: StreetAddressLine
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-StreetName](ValueSet-v3-StreetName.md)
  * Name: StreetName
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-StudentRoleType](ValueSet-v3-StudentRoleType.md)
  * Name: StudentRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Covered party to an insurance policy has coverage through full-time or part-time attendance at a re…
* Identity: [v3-StyleType](ValueSet-v3-StyleType.md)
  * Name: StyleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (abstract) Used within an instance to give the author some control over various aspects of rendering
* Identity: [v3-SubarachnoidRoute](ValueSet-v3-SubarachnoidRoute.md)
  * Name: SubarachnoidRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Subarachnoid
* Identity: [v3-SubconjunctivalR…](ValueSet-v3-SubconjunctivalRoute.md)
  * Name: SubconjunctivalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Subconjunctival
* Identity: [v3-SubcutaneousRoute](ValueSet-v3-SubcutaneousRoute.md)
  * Name: SubcutaneousRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Subcutaneous
* Identity: [v3-SublesionalRoute](ValueSet-v3-SublesionalRoute.md)
  * Name: SublesionalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sublesional
* Identity: [v3-SublingualRoute](ValueSet-v3-SublingualRoute.md)
  * Name: SublingualRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Sublingual
* Identity: [v3-SubmucosalRoute](ValueSet-v3-SubmucosalRoute.md)
  * Name: SubmucosalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Submucosal
* Identity: [v3-SubscriberCovere…](ValueSet-v3-SubscriberCoveredPartyRoleType.md)
  * Name: SubscriberCoveredPartyRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A role recognized through the eligibility of a party to play a subscriber for bene…
* Identity: [v3-SubsidizedHealth…](ValueSet-v3-SubsidizedHealthProgram.md)
  * Name: SubsidizedHealthProgram
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A government health program that provides coverage for health services to persons m…
* Identity: [v3-SubstanceAdminGe…](ValueSet-v3-SubstanceAdminGenericSubstitution.md)
  * Name: SubstanceAdminGenericSubstitution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Substitution occurred or is permitted with another product in the same generic ingredient.
* Identity: [v3-SubstanceAdminSu…](ValueSet-v3-SubstanceAdminSubstitutionNotAllowedReason.md)
  * Name: SubstanceAdminSubstitutionNotAllowedReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Reasons why substitution of a substance administration request is not permitted.
* Identity: [v3-SubstanceAdminSu…](ValueSet-v3-SubstanceAdminSubstitutionReason.md)
  * Name: SubstanceAdminSubstitutionReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SubstanceAdminis…](ValueSet-v3-SubstanceAdministrationPermissionRefusalReasonCode.md)
  * Name: SubstanceAdministrationPermissionRefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Indicates why the requested authorization to prescribe or dispense a medication has …
* Identity: [v3-SubstitutionCond…](ValueSet-v3-SubstitutionCondition.md)
  * Name: SubstitutionCondition
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Identifies what sort of change is permitted or has occurred between the item that was ordered/reque…
* Identity: [v3-SupernumeraryToo…](ValueSet-v3-SupernumeraryTooth.md)
  * Name: SupernumeraryTooth
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Supernumerary tooth, any tooth in addition to the normal permanent and primary dentition
* Identity: [v3-SupplyAppropriat…](ValueSet-v3-SupplyAppropriateManagementCode.md)
  * Name: SupplyAppropriateManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Confirmed supply action appropriate
* Identity: [v3-SupplyDetectedIs…](ValueSet-v3-SupplyDetectedIssueCode.md)
  * Name: SupplyDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Supplying the product at this time may be inappropriate or indicate compliance issues with the asso…
* Identity: [v3-SupplyOrderAbort…](ValueSet-v3-SupplyOrderAbortReasonCode.md)
  * Name: SupplyOrderAbortReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**A collection of concepts that indicates why the prescription should no longer be all…
* Identity: [v3-SuppositoryDrugF…](ValueSet-v3-SuppositoryDrugForm.md)
  * Name: SuppositoryDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A solid body of various weights and shapes, adapted for introduction into the rectal, vaginal, or u…
* Identity: [v3-SuppositoryRoute](ValueSet-v3-SuppositoryRoute.md)
  * Name: SuppositoryRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Suppository
* Identity: [v3-SurgClinPractice…](ValueSet-v3-SurgClinPracticeSetting.md)
  * Name: SurgClinPracticeSetting
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SusceptibilityOb…](ValueSet-v3-SusceptibilityObservationMethodType.md)
  * Name: SusceptibilityObservationMethodType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: **Description:**Test methods designed to determine a microorganism's susceptibility to an antibioti…
* Identity: [v3-SuspensionDrugFo…](ValueSet-v3-SuspensionDrugForm.md)
  * Name: SuspensionDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-SwabDrugForm](ValueSet-v3-SwabDrugForm.md)
  * Name: SwabDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A wad of absorbent material usually wound around one end of a small stick and used for applying med…
* Identity: [v3-Swish](ValueSet-v3-Swish.md)
  * Name: Swish
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Swish
* Identity: [v3-TableCellHorizon…](ValueSet-v3-TableCellHorizontalAlign.md)
  * Name: TableCellHorizontalAlign
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellScope](ValueSet-v3-TableCellScope.md)
  * Name: TableCellScope
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellVertica…](ValueSet-v3-TableCellVerticalAlign.md)
  * Name: TableCellVerticalAlign
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableFrame](ValueSet-v3-TableFrame.md)
  * Name: TableFrame
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableRuleStyle](ValueSet-v3-TableRuleStyle.md)
  * Name: TableRuleStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: (abstract) Defines table cell rendering characteristics
* Identity: [v3-TableRules](ValueSet-v3-TableRules.md)
  * Name: TableRules
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TabletDrugForm](ValueSet-v3-TabletDrugForm.md)
  * Name: TabletDrugForm
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A solid dosage form containing medicinal substances with or without suitable diluents.
* Identity: [v3-Takelman](ValueSet-v3-Takelman.md)
  * Name: Takelman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Takic](ValueSet-v3-Takic.md)
  * Name: Takic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Tanana](ValueSet-v3-Tanana.md)
  * Name: Tanana
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TananaTutchone](ValueSet-v3-TananaTutchone.md)
  * Name: TananaTutchone
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Taracahitan](ValueSet-v3-Taracahitan.md)
  * Name: Taracahitan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TargetAwareness](ValueSet-v3-TargetAwareness.md)
  * Name: TargetAwareness
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A code specifying the extent to which the Entity playing the participating Role (usually as a targe…
* Identity: [v3-Telecommunicatio…](ValueSet-v3-TelecommunicationAddressUse.md)
  * Name: TelecommunicationAddressUse
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Telecommunicatio…](ValueSet-v3-TelecommunicationCapabilities.md)
  * Name: TelecommunicationCapabilities
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Concepts that define the telecommunication capabilities of a particular device. Us…
* Identity: [v3-Tepiman](ValueSet-v3-Tepiman.md)
  * Name: Tepiman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TextMediaType](ValueSet-v3-TextMediaType.md)
  * Name: TextMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: For any text
* Identity: [v3-TherapeuticProdu…](ValueSet-v3-TherapeuticProductDetectedIssueCode.md)
  * Name: TherapeuticProductDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may interact with an existing or recent therapeutic product
* Identity: [v3-TherapyAppropria…](ValueSet-v3-TherapyAppropriateManagementCode.md)
  * Name: TherapyAppropriateManagementCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Confirmed drug therapy appropriate
* Identity: [v3-TimingDetectedIs…](ValueSet-v3-TimingDetectedIssueCode.md)
  * Name: TimingDetectedIssueCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TimingEvent](ValueSet-v3-TimingEvent.md)
  * Name: TimingEvent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Tiwa](ValueSet-v3-Tiwa.md)
  * Name: Tiwa
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TopicalAbsorptio…](ValueSet-v3-TopicalAbsorptionRoute.md)
  * Name: TopicalAbsorptionRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Topical absorption
* Identity: [v3-TopicalApplicati…](ValueSet-v3-TopicalApplication.md)
  * Name: TopicalApplication
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Topical application
* Identity: [v3-TopicalPowder](ValueSet-v3-TopicalPowder.md)
  * Name: TopicalPowder
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TopicalSolution](ValueSet-v3-TopicalSolution.md)
  * Name: TopicalSolution
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TracheostomyRoute](ValueSet-v3-TracheostomyRoute.md)
  * Name: TracheostomyRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Tracheostomy
* Identity: [v3-Transdermal](ValueSet-v3-Transdermal.md)
  * Name: Transdermal
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transdermal
* Identity: [v3-TransdermalPatch](ValueSet-v3-TransdermalPatch.md)
  * Name: TransdermalPatch
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Transfer](ValueSet-v3-Transfer.md)
  * Name: Transfer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transfer of ownership for a product.
* Identity: [v3-TransferActReason](ValueSet-v3-TransferActReason.md)
  * Name: TransferActReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The explanation for why a patient is moved from one location to another within the organization
* Identity: [v3-TransmissionRela…](ValueSet-v3-TransmissionRelationshipTypeCode.md)
  * Name: TransmissionRelationshipTypeCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**A code specifying the meaning and purpose of every TransmissionRelationship instanc…
* Identity: [v3-TransmucosalRoute](ValueSet-v3-TransmucosalRoute.md)
  * Name: TransmucosalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transmucosal
* Identity: [v3-TransplacentalRo…](ValueSet-v3-TransplacentalRoute.md)
  * Name: TransplacentalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transplacental
* Identity: [v3-TranstrachealRou…](ValueSet-v3-TranstrachealRoute.md)
  * Name: TranstrachealRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transtracheal
* Identity: [v3-TranstympanicRou…](ValueSet-v3-TranstympanicRoute.md)
  * Name: TranstympanicRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Transtympanic
* Identity: [v3-TribalEntityUS](ValueSet-v3-TribalEntityUS.md)
  * Name: TribalEntityUS
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN…
* Identity: [v3-TriggerEventID](ValueSet-v3-TriggerEventID.md)
  * Name: TriggerEventID
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-TrustPolicy](ValueSet-v3-TrustPolicy.md)
  * Name: TrustPolicy
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-02
  * Description: A mandate, obligation, requirement, rule, or expectation conveyed as security metadata between send…
* Identity: [v3-Tsamosan](ValueSet-v3-Tsamosan.md)
  * Name: Tsamosan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Tsimshianic](ValueSet-v3-Tsimshianic.md)
  * Name: Tsimshianic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-UNSPSC](ValueSet-v3-UNSPSC.md)
  * Name: UNSPSC
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**United Nations Standard Products and Services Classification, managed by Uniform Co…
* Identity: [v3-UPC](ValueSet-v3-UPC.md)
  * Name: UPC
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Universal Product Code is one of a wide variety of bar code languages widely used i…
* Identity: [v3-URLScheme](ValueSet-v3-URLScheme.md)
  * Name: URLScheme
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet st…
* Identity: [v3-USEncounterDisch…](ValueSet-v3-USEncounterDischargeDisposition.md)
  * Name: USEncounterDischargeDisposition
  * Version: 5.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: These codes cannot be displayed because of AHA's NUBC Patient Discharge Status Codes Intellectual P…
* Identity: [v3-USEncounterRefer…](ValueSet-v3-USEncounterReferralSource.md)
  * Name: USEncounterReferralSource
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-UnderwriterParti…](ValueSet-v3-UnderwriterParticipationFunction.md)
  * Name: UnderwriterParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**Set of codes indicating the manner in which underwriters participate in a policy or…
* Identity: [v3-UnitsOfMeasureCa…](ValueSet-v3-UnitsOfMeasureCaseSensitive.md)
  * Name: UnitsOfMeasureCaseSensitive
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**All units of measure.
* Identity: [v3-Unknown](ValueSet-v3-Unknown.md)
  * Name: Unknown
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A proper value is applicable, but not known.
* Identity: [v3-UnorderedListSty…](ValueSet-v3-UnorderedListStyle.md)
  * Name: UnorderedListStyle
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Defines rendering characteristics for unordered lists
* Identity: [v3-UpdateRefusalRea…](ValueSet-v3-UpdateRefusalReasonCode.md)
  * Name: UpdateRefusalReasonCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-UpperChinook](ValueSet-v3-UpperChinook.md)
  * Name: UpperChinook
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-UreteralRoute](ValueSet-v3-UreteralRoute.md)
  * Name: UreteralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Ureteral
* Identity: [v3-UrethralRoute](ValueSet-v3-UrethralRoute.md)
  * Name: UrethralRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Urethral
* Identity: [v3-UrinaryBladderIr…](ValueSet-v3-UrinaryBladderIrrigation.md)
  * Name: UrinaryBladderIrrigation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Irrigation, urinary bladder
* Identity: [v3-UrinaryBladderRo…](ValueSet-v3-UrinaryBladderRoute.md)
  * Name: UrinaryBladderRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Urinary bladder
* Identity: [v3-UrinaryTractRoute](ValueSet-v3-UrinaryTractRoute.md)
  * Name: UrinaryTractRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Urinary tract
* Identity: [v3-Utian](ValueSet-v3-Utian.md)
  * Name: Utian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-UtoAztecan](ValueSet-v3-UtoAztecan.md)
  * Name: UtoAztecan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VaccineEntityType](ValueSet-v3-VaccineEntityType.md)
  * Name: VaccineEntityType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A Type of medicine that creates an immune protection without the recipient experiencing the disease.
* Identity: [v3-VaccineManufactu…](ValueSet-v3-VaccineManufacturer.md)
  * Name: VaccineManufacturer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The manufacturer of a vaccine.
* Identity: [v3-VaccineType](ValueSet-v3-VaccineType.md)
  * Name: VaccineType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The kind of vaccine.
* Identity: [v3-VaginalCream](ValueSet-v3-VaginalCream.md)
  * Name: VaginalCream
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VaginalFoam](ValueSet-v3-VaginalFoam.md)
  * Name: VaginalFoam
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VaginalGel](ValueSet-v3-VaginalGel.md)
  * Name: VaginalGel
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VaginalOintment](ValueSet-v3-VaginalOintment.md)
  * Name: VaginalOintment
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VaginalRoute](ValueSet-v3-VaginalRoute.md)
  * Name: VaginalRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Vaginal
* Identity: [v3-ValidationIssue](ValueSet-v3-ValidationIssue.md)
  * Name: ValidationIssue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VerificationMeth…](ValueSet-v3-VerificationMethod.md)
  * Name: VerificationMethod
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-VerificationOutc…](ValueSet-v3-VerificationOutcomeValue.md)
  * Name: VerificationOutcomeValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Values for observations of verification act results**Examples:**Verified, not verified, verifi…
* Identity: [v3-VideoMediaType](ValueSet-v3-VideoMediaType.md)
  * Name: VideoMediaType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Video media type.
* Identity: [v3-VitreousHumourRo…](ValueSet-v3-VitreousHumourRoute.md)
  * Name: VitreousHumourRoute
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Vitreous humour
* Identity: [v3-Wakashan](ValueSet-v3-Wakashan.md)
  * Name: Wakashan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WeightAlert](ValueSet-v3-WeightAlert.md)
  * Name: WeightAlert
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Proposed therapy may be inappropriate based on the patient's weight
* Identity: [v3-WesternApachean](ValueSet-v3-WesternApachean.md)
  * Name: WesternApachean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WesternMiwok](ValueSet-v3-WesternMiwok.md)
  * Name: WesternMiwok
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WesternMuskogean](ValueSet-v3-WesternMuskogean.md)
  * Name: WesternMuskogean
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WesternNumic](ValueSet-v3-WesternNumic.md)
  * Name: WesternNumic
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Wintuan](ValueSet-v3-Wintuan.md)
  * Name: Wintuan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Wiyot](ValueSet-v3-Wiyot.md)
  * Name: Wiyot
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WorkClassificati…](ValueSet-v3-WorkClassificationODH.md)
  * Name: WorkClassificationODH
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Provide the concepts for the value element of the C-CDA Work Classification Observation entry templ…
* Identity: [v3-WorkPlace](ValueSet-v3-WorkPlace.md)
  * Name: WorkPlace
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-WorkScheduleODH](ValueSet-v3-WorkScheduleODH.md)
  * Name: WorkScheduleODH
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Describes an individual's typical arrangement of working hours for an occupation.
* Identity: [v3-Yaqui](ValueSet-v3-Yaqui.md)
  * Name: Yaqui
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Yokuts](ValueSet-v3-Yokuts.md)
  * Name: Yokuts
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Yokutsan](ValueSet-v3-Yokutsan.md)
  * Name: Yokutsan
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Yukian](ValueSet-v3-Yukian.md)
  * Name: Yukian
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-Yuman](ValueSet-v3-Yuman.md)
  * Name: Yuman
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-employmentStatus…](ValueSet-v3-employmentStatusODH.md)
  * Name: employmentStatusODH
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Concepts representing whether a person does or does not currently have a job or is not currently in…
* Identity: [v3-immunizationFore…](ValueSet-v3-immunizationForecastDate.md)
  * Name: immunizationForecastDate
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2013-03-11
  * Description: Set of LOINC codes that identify the type of date that is specified within an immunization forecast…
* Identity: [v3-immunizationFore…](ValueSet-v3-immunizationForecastStatusObservationValue.md)
  * Name: immunizationForecastStatusObservationValue
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2010-03-22
  * Description: Represents the patient's status with respect to their immunization guideline as of an evaluation da…
* Identity: [v3-materialForm](ValueSet-v3-materialForm.md)
  * Name: materialForm
  * Version: 3.0.0
  * Status: retired
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A value representing the state (solid, liquid, gas) and nature of the material.
* Identity: [v3-tst0272](ValueSet-v3-tst0272.md)
  * Name: _0272
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Testing to measure the minimum concentration of the antibacterial agent in a given culture medium b…
* Identity: [v3-tst0275a](ValueSet-v3-tst0275a.md)
  * Name: _0275a
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-tst0280](ValueSet-v3-tst0280.md)
  * Name: _0280
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Test methods designed to determine a microorganismaTMs susceptibility to being killed by an antibio…
* Identity: [v3-xAccommodationRe…](ValueSet-v3-xAccommodationRequestorRole.md)
  * Name: x_AccommodationRequestorRole
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActBillableCode](ValueSet-v3-xActBillableCode.md)
  * Name: x_ActBillableCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActClassCarePro…](ValueSet-v3-xActClassCareProvisionEncounter.md)
  * Name: x_ActClassCareProvisionEncounter
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Definition:**When identifying the "request" that resulted in an encounter, there is a need to di…
* Identity: [v3-xActClassCarePro…](ValueSet-v3-xActClassCareProvisionObservation.md)
  * Name: x_ActClassCareProvisionObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActClassCarePro…](ValueSet-v3-xActClassCareProvisionProcedure.md)
  * Name: x_ActClassCareProvisionProcedure
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActClassDocumen…](ValueSet-v3-xActClassDocumentEntryAct.md)
  * Name: x_ActClassDocumentEntryAct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The set of Act class codes allowed for the ACT class clone in the CDA Clinical Statement model. The…
* Identity: [v3-xActClassDocumen…](ValueSet-v3-xActClassDocumentEntryOrganizer.md)
  * Name: x_ActClassDocumentEntryOrganizer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActEncounterRea…](ValueSet-v3-xActEncounterReason.md)
  * Name: x_ActEncounterReason
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Administrative reasons for patient encounters.*Example:*Medical necessity, patient request and …
* Identity: [v3-xActFinancialPro…](ValueSet-v3-xActFinancialProductAcquisitionCode.md)
  * Name: x_ActFinancialProductAcquisitionCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The method that a product is obtained for use by the subject of the supply act (e.g. patient), with…
* Identity: [v3-xActInvoiceDetai…](ValueSet-v3-xActInvoiceDetailPharmacyCode.md)
  * Name: x_ActInvoiceDetailPharmacyCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable codes selected for use for Pharmacy Invoices. Steward is Financial Management.
* Identity: [v3-xActInvoiceDetai…](ValueSet-v3-xActInvoiceDetailPreferredAccommodationCode.md)
  * Name: x_ActInvoiceDetailPreferredAccommodationCode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The billable codes selected for use for Preferred Accommodation Invoices. Steward is Financial Mana…
* Identity: [v3-xActMoodCompleti…](ValueSet-v3-xActMoodCompletionCriterion.md)
  * Name: x_ActMoodCompletionCriterion
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**These are moods describing activities as they progress in the business cycle, from …
* Identity: [v3-xActMoodDefEvn](ValueSet-v3-xActMoodDefEvn.md)
  * Name: x_ActMoodDefEvn
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A grouping of Definition, Event. These specific moods are used in control wrapper override acts. Th…
* Identity: [v3-xActMoodDefEvnRqo](ValueSet-v3-xActMoodDefEvnRqo.md)
  * Name: x_ActMoodDefEvnRqo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActMoodDefEvnRq…](ValueSet-v3-xActMoodDefEvnRqoPrmsPrp.md)
  * Name: x_ActMoodDefEvnRqoPrmsPrp
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActMoodDocument…](ValueSet-v3-xActMoodDocumentObservation.md)
  * Name: x_ActMoodDocumentObservation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an observation can take within the body of a clinical document.
* Identity: [v3-xActMoodEvnOrdPr…](ValueSet-v3-xActMoodEvnOrdPrmsPrp.md)
  * Name: x_ActMoodEvnOrdPrmsPrp
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActMoodIntentEv…](ValueSet-v3-xActMoodIntentEvent.md)
  * Name: x_ActMoodIntentEvent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A constraint domain for RMIM design.
* Identity: [v3-xActMoodOrdPrms](ValueSet-v3-xActMoodOrdPrms.md)
  * Name: x_ActMoodOrdPrms
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A grouping of Order, Promise. These specific moods are used in orders.
* Identity: [v3-xActMoodOrdPrmsE…](ValueSet-v3-xActMoodOrdPrmsEvn.md)
  * Name: x_ActMoodOrdPrmsEvn
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A grouping of Order, Promise and Event moods.
* Identity: [v3-xActMoodPermPerm…](ValueSet-v3-xActMoodPermPermrq.md)
  * Name: x_ActMoodPermPermrq
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Enumerates the moods that an Act can take when describing privileges.
* Identity: [v3-xActMoodRequestE…](ValueSet-v3-xActMoodRequestEvent.md)
  * Name: x_ActMoodRequestEvent
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActMoodRqoPrpAp…](ValueSet-v3-xActMoodRqoPrpAptArq.md)
  * Name: x_ActMoodRqoPrpAptArq
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActOrderableOrB…](ValueSet-v3-xActOrderableOrBillable.md)
  * Name: x_ActOrderableOrBillable
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipDocument.md)
  * Name: x_ActRelationshipDocument
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between two clinical documents for document management.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipDocumentSPL.md)
  * Name: x_ActRelationshipDocumentSPL
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipEntry.md)
  * Name: x_ActRelationshipEntry
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between a CDA section and its contained entries.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipEntryRelationship.md)
  * Name: x_ActRelationshipEntryRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between two CDA entries.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipExternalReference.md)
  * Name: x_ActRelationshipExternalReference
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the relationships between a CDA entry and an externally referenced act.
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipPatientTransport.md)
  * Name: x_ActRelationshipPatientTransport
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Relates a patient encounter act (source) to the transportation act (target) representing the patien…
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipPertinentInfo.md)
  * Name: x_ActRelationshipPertinentInfo
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActRelationship…](ValueSet-v3-xActRelationshipRelatedAuthorizations.md)
  * Name: x_ActRelationshipRelatedAuthorizations
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActReplaceOrRev…](ValueSet-v3-xActReplaceOrRevise.md)
  * Name: x_ActReplaceOrRevise
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActStatusActive…](ValueSet-v3-xActStatusActiveComplete.md)
  * Name: x_ActStatusActiveComplete
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActStatusActive…](ValueSet-v3-xActStatusActiveSuspended.md)
  * Name: x_ActStatusActiveSuspended
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xActStatusPrevio…](ValueSet-v3-xActStatusPrevious.md)
  * Name: x_ActStatusPrevious
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Cancelled, nullified and obsolete .
* Identity: [v3-xAdministeredSub…](ValueSet-v3-xAdministeredSubstance.md)
  * Name: x_AdministeredSubstance
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A type of Manufactured Material that is administered to a living subject, either by a healthcare pr…
* Identity: [v3-xAdverseEventCau…](ValueSet-v3-xAdverseEventCausalityAssessmentMethods.md)
  * Name: x_AdverseEventCausalityAssessmentMethods
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Value set provides methods used to assess the causality of adverse events. New codes should not be …
* Identity: [v3-xBasicConfidenti…](ValueSet-v3-xBasicConfidentialityKind.md)
  * Name: x_BasicConfidentialityKind
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Used to enumerate the typical confidentiality constraints placed upon a clinical d…
* Identity: [v3-xBillableProduct](ValueSet-v3-xBillableProduct.md)
  * Name: x_BillableProduct
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**The billable codes selected for Clinical Product Invoices. Steward is Financial Man…
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementActMood.md)
  * Name: x_ClinicalStatementActMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementEncounterMood.md)
  * Name: x_ClinicalStatementEncounterMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementExposureMood.md)
  * Name: x_ClinicalStatementExposureMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementObservationMood.md)
  * Name: x_ClinicalStatementObservationMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementProcedureMood.md)
  * Name: x_ClinicalStatementProcedureMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementSubstanceMood.md)
  * Name: x_ClinicalStatementSubstanceMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xClinicalStateme…](ValueSet-v3-xClinicalStatementSupplyMood.md)
  * Name: x_ClinicalStatementSupplyMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xDeterminerInsta…](ValueSet-v3-xDeterminerInstanceKind.md)
  * Name: x_DeterminerInstanceKind
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xDocumentActMood](ValueSet-v3-xDocumentActMood.md)
  * Name: x_DocumentActMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an act can take within the body of a clinical document.
* Identity: [v3-xDocumentEncount…](ValueSet-v3-xDocumentEncounterMood.md)
  * Name: x_DocumentEncounterMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that an encounter can take within the body of a clinical document.
* Identity: [v3-xDocumentEntrySu…](ValueSet-v3-xDocumentEntrySubject.md)
  * Name: x_DocumentEntrySubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to represent the role(s) of those who can serve as subjects of the contents of a clinical docu…
* Identity: [v3-xDocumentProcedu…](ValueSet-v3-xDocumentProcedureMood.md)
  * Name: x_DocumentProcedureMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that a procedure can take within the body of a clinical document.
* Identity: [v3-xDocumentStatus](ValueSet-v3-xDocumentStatus.md)
  * Name: x_DocumentStatus
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Status of a clinical document.
* Identity: [v3-xDocumentSubject](ValueSet-v3-xDocumentSubject.md)
  * Name: x_DocumentSubject
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xDocumentSubstan…](ValueSet-v3-xDocumentSubstanceMood.md)
  * Name: x_DocumentSubstanceMood
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the moods that a substance administration can take within the body of a clinical …
* Identity: [v3-xEncounterAdmiss…](ValueSet-v3-xEncounterAdmissionUrgency.md)
  * Name: x_EncounterAdmissionUrgency
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The urgency for starting a patient encounter.*Example:*Routine, urgent, emergency, and elective.
* Identity: [v3-xEncounterPartic…](ValueSet-v3-xEncounterParticipant.md)
  * Name: x_EncounterParticipant
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Clones using this x_domain should have a name "encounterParticipant".
* Identity: [v3-xEncounterPerfor…](ValueSet-v3-xEncounterPerformerParticipation.md)
  * Name: x_EncounterPerformerParticipation
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to enumerate the ways in which a clinician can directly participate during an encounter which …
* Identity: [v3-xEntityClassDocu…](ValueSet-v3-xEntityClassDocumentReceiving.md)
  * Name: x_EntityClassDocumentReceiving
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xEntityClassPers…](ValueSet-v3-xEntityClassPersonOrOrgReceiving.md)
  * Name: x_EntityClassPersonOrOrgReceiving
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xInformationReci…](ValueSet-v3-xInformationRecipient.md)
  * Name: x_InformationRecipient
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to represent participant(s) who should receive a copy of a document.
* Identity: [v3-xInformationReci…](ValueSet-v3-xInformationRecipientRole.md)
  * Name: x_InformationRecipientRole
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Used to represent the role(s) of those who should receive a copy of a document.
* Identity: [v3-xLabProcessClass…](ValueSet-v3-xLabProcessClassCodes.md)
  * Name: x_LabProcessClassCodes
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xMedicationOrImm…](ValueSet-v3-xMedicationOrImmunization.md)
  * Name: x_MedicationOrImmunization
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xMedicine](ValueSet-v3-xMedicine.md)
  * Name: x_Medicine
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A type of Administered Substance that is manufactured from raw organic or inorganic ingredients and…
* Identity: [v3-xOrganizationNam…](ValueSet-v3-xOrganizationNamePartType.md)
  * Name: x_OrganizationNamePartType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A name for an organization, such as "Health Level Seven, Inc." An organization name consists only o…
* Identity: [v3-xParticipationAu…](ValueSet-v3-xParticipationAuthorPerformer.md)
  * Name: x_ParticipationAuthorPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: One who initiates the control act event, either as its author or its physical performer.
* Identity: [v3-xParticipationEn…](ValueSet-v3-xParticipationEntVrf.md)
  * Name: x_ParticipationEntVrf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person that contributed to recording or validating the act.
* Identity: [v3-xParticipationPr…](ValueSet-v3-xParticipationPrfEntVrf.md)
  * Name: x_ParticipationPrfEntVrf
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A person that performed, contributed in recording or validating the act.
* Identity: [v3-xParticipationVr…](ValueSet-v3-xParticipationVrfRespSprfWit.md)
  * Name: x_ParticipationVrfRespSprfWit
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: One who oversees a control act event. Includes either a type of accountability, as in responsible p…
* Identity: [v3-xPayeeRelationsh…](ValueSet-v3-xPayeeRelationshipRoleType.md)
  * Name: x_PayeeRelationshipRoleType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The specification of the relationship to the covered party of the payee in the case when an insurer…
* Identity: [v3-xPersonNamePartT…](ValueSet-v3-xPersonNamePartType.md)
  * Name: x_PersonNamePartType
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xPhoneOrEmailURL…](ValueSet-v3-xPhoneOrEmailURLScheme.md)
  * Name: x_PhoneOrEmailURLScheme
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Restricts scheme to e-mail or phone numbers at which a human can be reached
* Identity: [v3-xPhoneURLScheme](ValueSet-v3-xPhoneURLScheme.md)
  * Name: x_PhoneURLScheme
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Restricts scheme to phone numbers at which a human can be reached
* Identity: [v3-xPhysicalVerbalP…](ValueSet-v3-xPhysicalVerbalParticipationMode.md)
  * Name: x_PhysicalVerbalParticipationMode
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Restricts participation to either physical or verbal
* Identity: [v3-xRoleClassAccomm…](ValueSet-v3-xRoleClassAccommodationRequestor.md)
  * Name: x_RoleClassAccommodationRequestor
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The requestor for the accommodation. Steward is Financial Management Technical Committee
* Identity: [v3-xRoleClassCovera…](ValueSet-v3-xRoleClassCoverage.md)
  * Name: x_RoleClassCoverage
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An abstract domain that encompasses the roles that arise in the context of providing, purchasing, a…
* Identity: [v3-xRoleClassCovera…](ValueSet-v3-xRoleClassCoverageInvoice.md)
  * Name: x_RoleClassCoverageInvoice
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: An abstract domain that encompasses the roles involved in submitting, responding to and managing in…
* Identity: [v3-xRoleClassCreden…](ValueSet-v3-xRoleClassCredentialedEntity.md)
  * Name: x_RoleClassCredentialedEntity
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: A role played by an entity that receives credentials from the scoping entity.
* Identity: [v3-xRoleClassPayeeP…](ValueSet-v3-xRoleClassPayeePolicyRelationship.md)
  * Name: x_RoleClassPayeePolicyRelationship
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: The specification of the relationship of the Payee to the invoice. Can be used in cases when an ins…
* Identity: [v3-xSUCCREPLPREV](ValueSet-v3-xSUCCREPLPREV.md)
  * Name: x_SUCC_REPL_PREV
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: ** **No description** **
* Identity: [v3-xServiceEventPer…](ValueSet-v3-xServiceEventPerformer.md)
  * Name: x_ServiceEventPerformer
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Clones using this x_domain should have a name "performer".
* Identity: [v3-xSubstitutionCon…](ValueSet-v3-xSubstitutionConditionNoneOrUnconditional.md)
  * Name: x_SubstitutionConditionNoneOrUnconditional
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: Restricts substitution to effectively a yes/no decision
* Identity: [v3-xVeryBasicConfid…](ValueSet-v3-xVeryBasicConfidentialityKind.md)
  * Name: x_VeryBasicConfidentialityKind
  * Version: 3.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2014-03-26
  * Description: **Description:**Limits confidentiality to effectively a yes/no decision.*Usage Note:*x_VeryBas…

Showing 1734 of 1734 entries

