# Documentation - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* **Documentation**

## Documentation

 This page contains documentation and background information about the HL7 Terminology. The material contained herein has been drawn from the Standards and other documents published by HL7 and the Vocablary WorkGroup. 

### Introductory Information

 The HL7 Terminology viewable here rendered as web pages represents a new way for HL7 to publish its terminology and vocabulary, which hitherto has been largely contained within various Standards and Guides in the different HL7 Product families. These web pages represent an attempt to gather all of the information that the HL7 community needs in order to implement systems and interfaces, based on the published HL7 Standards, in one place and eailly accessible. The information on these pages will be updated frequently as requested and agreed changes and enhancemments are made. 

### Terminology Maintenance at HL7

 The new HL7 process for governance and maintenance of the vocabulary published here by HL7 is called Unified Terminology Governance, or "UTG"; for more information on this please see the documentation on the [Vocabulary Maintenance at HL7 Page](https://confluence.hl7.org/display/VMAH/Vocabulary+Maintenance+at+HL7). This process employs a community-wide, consensus-based, continuous process for updates to the terminology. Major changes from pre-UTG HL7 terminology management process include: 

1. Vocabulary harmonization has transitioned from a static, 3 times per year process to a continuous process managed using JIRA;
1. All HL7 terminology artifacts needed by implementers are now available in one place
1. Older means of identification of versions of V2, V3 and base CDA terminology Value Set and Code System idenfierss have been updated to incorporate a new, base value (see discussion below on Versions);
1. The base Value Set and Code System URLs have been set to http://terminology.hl7.org/CodeSystem/ and http://terminology.hl7.org/ValueSet/

 A number of items have not changed in this new process. These include: 

1. Value Sets and Code Systems defined as an integral part of the FHIR specification are still managed by the FHIR governance processes;
1. Value Sets and Code Systems defined as part of the C-CDA specification (not in the base) are not are not managed by the C-CDA governance processes;
1. Value Sets and Code Systems which are "ballot bound" (meaning they explicitly mirror balloted model structures) in V2 and V3 continue to be managed through the traditional ballot process (but ballot preparation formerly done in harmonization will take advantage of the new governance process).

 Platform independent tooling has been developed to support consensus-based authoring and reviewing of proposed changes to content among worldwide stakeholders. Note that certain identified terminology artifacts are tightly bound to model structures in HL7, and thus are not subject to a unified consensus change process; these artifacts (primarily code systems, but include some lue sets and other objects as well) must be changed and approved through the regular HL7 Standards balloting process. Copies of these may be found on these pages with the other content for the convenience of the HL7 community. 

#### Terminology Maintenance Education, Training, and Documentation

 A set of educational training sessions have been created for the different groups of people using the HL7 Terminology. It is highly recommended that HL7 Terminology users view these sessions based on their use or involvement in the maintenance of the HL7 Terminology. These recordings are all available from the 'Education' area on the [Vocabulary Maintenance at HL7 Page](https://confluence.hl7.org/display/VMAH/Vocabulary+Maintenance+at+HL7) 

 This page also provides an overview of the process, links to documentation and education materials, and information about participating in consensus review or change proposal submission. Anyone can sign up to be a vocabulary reviewer or change submitter through this page. 

 All change requests are managed on HL7 Jira in the [UTG (UP) Jira project](https://jira.hl7.org/projects/UP/). 

### Common (Unified) Characteristics

 HL7 has adopted a common overall notional architecture for terminology across all of its product families. This architecture is focussed on representing all terminology in Code Systems and Value Sets. Work has been done to adapt all related vocabulary and termminology designs across the HL7 product famillies to these common structures. See the secitons below for discussions of how this has been done for the different product families. The common form used by these new designs are based on FHIR CodeSystem and ValueSet resources, and includes a number of extensions and special properties to correctly capture, in a machine-processable way, all of the older information in the HL7 product family terminology structures. This mapping has been done in order to facilitate maintenance and publishing (on these pages) of all of the HL7 Terminology, and to eanble the content to be unified where appropriate in the future. 

#### Content

 The HL7 Terminology consists of Code Systems, Value Sets, Concept Maps, and Naming Systems. Code Systems and Value Sets are core components of all of the HL7 product families. In addition, Naming Systems and Concept Maps are defined within the FHIR specifications. 

*  **Code Systems** are managed collections of concepts.
*  **Value Sets** are managed collections of concept drawn from one or more Code Systems.
*  **Naming Systems** are collections of objects with known identifiers.
*  **Concept Maps** are objects containing relationship information between concepts across code systems
*  **V3 Concept Domains** have been represented in the new HL7 Terminology process and publication as a single Code System of concepts, with each Concept Domain represented as a concept with an extensive set of properties. These are found in the set of Unified Code Systems.
*  **V2 Tables** have been represented in the new HL7 Terinology process and publication as a single Code System of concepts, with each table being a concept with an extensive set of properties. These are found in the set of Unified Code Systems.

#### External Terminology

 There are hundreds of terminologies and code sets used to support Healthcare systems, persistence, and communication in use in the world, maintained and published by many organizations outside of HL7, and across many many nations. Virtually all implementations based on HL7 Standards include one or more of these terminologies in the implementation guidance and conformance rules, both those publshed outside of HL7, and those defined, maintained, and published by HL7. For the convenience of implementers and users, certain of these have been explicitly identified over the years by the HIT community, and the technical components for their unambiguous identification and use have been published in the HL7 Standards and Guides. In addtion, a few of these have had their content encapsulated in the designs of HL7 terminology structues to facilitate their use by the HL7 communinity. These have been imported to this new publishing form for the convenience of the community, and the terms of compliancit is hoped that it be used in a common way across all of the HL7 product families that need to reference or use these external terminologies. 

#### Version Control and Display

 The versioning policy has been approved by the Terminology Services Management Group and can be found on the [THO Artifact Versioning Policy](https://confluence.hl7.org/spaces/TSMG/pages/175605503/HL7+Terminology+Artifact+Versioning+Policy) page. 

#### Terminology Expectations for IG developers

 The policy around using and creating terminology codes or code systems for HL7 implementation guides as been approved by the Terminology Services Management Group and can be found on the [Terminology Expectations for IG Developers](https://confluence.hl7.org/spaces/TSMG/pages/161063724/Terminology+Expectations+for+IG+Developers) page. 

