# V3 Code Systems - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**HL7 Code Systems**](codesystems.md)
* **V3 Code Systems**

## V3 Code Systems

 This page contains those code systems defined by HL7, and that have been historically published in the Version 3 coremif for the Version 3 product family. Note that the coremif file generated from the content below is accessible for download on these pages as well. 

 Each of these HL7-maintained code systems is listed in an indivudal html document generated directly from the underlying xml resource, which is a UTG code system resource. See the background information pages in this site for more information about the similarities and differences between the UTG CodeSystem resouces and the standard FHIR CodeSystem resources. There is one code system per file, which may be accessed by clicking on the hyperlinked name of the code system in the list below. Each linked page shows the complete content of the code system. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Content: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [triggerEventID](CodeSystem-triggerEventID.md)
  * Name: Trigger Event ID
  * Version: 3.0.0
  * Status: active
  * Content: fragment
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**This code system contains all HL7 artifacts of type TE (Trigger Event) that are cr…
* Identity: [v3-AcknowledgementC…](CodeSystem-v3-AcknowledgementCondition.md)
  * Name: AcknowledgementCondition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The codes identify the conditions under which accept acknowledgements are required to be returned i…
* Identity: [v3-AcknowledgementD…](CodeSystem-v3-AcknowledgementDetailCode.md)
  * Name: AcknowledgementDetailCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: *OpenIssue:*Missing description.
* Identity: [v3-AcknowledgementD…](CodeSystem-v3-AcknowledgementDetailType.md)
  * Name: AcknowledgementDetailType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code identifying the specific message to be provided.**Discussion:**A textual value may be spe…
* Identity: [v3-AcknowledgementT…](CodeSystem-v3-AcknowledgementType.md)
  * Name: AcknowledgementType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This attribute contains an acknowledgement code as described in the HL7 message processing rules. …
* Identity: [v3-ActClass](CodeSystem-v3-ActClass.md)
  * Name: ActClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the major type of Act that this Act-instance represents.**Constraints:**The cl…
* Identity: [v3-ActCode](CodeSystem-v3-ActCode.md)
  * Name: ActCode
  * Version: 9.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: A code specifying the particular kind of Act that the Act-instance represents within its class.…
* Identity: [v3-ActExposureLevel…](CodeSystem-v3-ActExposureLevelCode.md)
  * Name: ActExposureLevelCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A qualitative measure of the degree of exposure to the causative agent. This includes concepts such…
* Identity: [v3-ActInvoiceElemen…](CodeSystem-v3-ActInvoiceElementModifier.md)
  * Name: ActInvoiceElementModifier
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Processing consideration and clarification codes.
* Identity: [v3-ActMood](CodeSystem-v3-ActMood.md)
  * Name: ActMood
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept defi…
* Identity: [v3-ActPriority](CodeSystem-v3-ActPriority.md)
  * Name: ActPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A set of codes (e.g., for routine, emergency), specifying the urgency under which the Act happened,…
* Identity: [v3-ActReason](CodeSystem-v3-ActReason.md)
  * Name: ActReason
  * Version: 3.1.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not…
* Identity: [v3-ActRelationshipC…](CodeSystem-v3-ActRelationshipCheckpoint.md)
  * Name: ActRelationshipCheckpoint
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., befor…
* Identity: [v3-ActRelationshipJ…](CodeSystem-v3-ActRelationshipJoin.md)
  * Name: ActRelationshipJoin
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying how concurrent Acts are resynchronized in a parallel branch construct.*Discus…
* Identity: [v3-ActRelationshipS…](CodeSystem-v3-ActRelationshipSplit.md)
  * Name: ActRelationshipSplit
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying how branches in an action plan are selected among other branches.*Discussion:…
* Identity: [v3-ActRelationshipS…](CodeSystem-v3-ActRelationshipSubset.md)
  * Name: ActRelationshipSubset
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Used to indicate that the target of the relationship will be a filtered subset of the total related…
* Identity: [v3-ActRelationshipT…](CodeSystem-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The source is an excerpt from the target.
* Identity: [v3-ActSite](CodeSystem-v3-ActSite.md)
  * Name: ActSite
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: An anatomical location on an organism which can be the focus of an act.
* Identity: [v3-ActStatus](CodeSystem-v3-ActStatus.md)
  * Name: ActStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Act, as defined by the Act class state machine.
* Identity: [v3-ActUSPrivacyLaw](CodeSystem-v3-ActUSPrivacyLaw.md)
  * Name: ActUSPrivacyLaw
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A jurisdictional mandate in the US relating to privacy.** **Deprecation Comment:** **Content moved…
* Identity: [v3-ActUncertainty](CodeSystem-v3-ActUncertainty.md)
  * Name: ActUncertainty
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing Description
* Identity: [v3-AddressPartType](CodeSystem-v3-AddressPartType.md)
  * Name: AddressPartType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Code that specifies whether an address part names the street, city, country, posta…
* Identity: [v3-AddressUse](CodeSystem-v3-AddressUse.md)
  * Name: AddressUse
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes that provide guidance around the circumstances in which a given address should be used.
* Identity: [v3-AdministrativeGe…](CodeSystem-v3-AdministrativeGender.md)
  * Name: AdministrativeGender
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The gender of a person used for adminstrative purposes (as opposed to clinical gender)
* Identity: [v3-AmericanIndianAl…](CodeSystem-v3-AmericanIndianAlaskaNativeLanguages.md)
  * Name: AmericanIndianAlaskaNativeLanguages
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: American Indian and Alaska Native languages currently being used in the United States.
* Identity: [v3-Calendar](CodeSystem-v3-Calendar.md)
  * Name: Calendar
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system for specifying a type of calendar
* Identity: [v3-CalendarCycle](CodeSystem-v3-CalendarCycle.md)
  * Name: Calendar Cycle Codes
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Calendar cycle identifiers
* Identity: [v3-CalendarType](CodeSystem-v3-CalendarType.md)
  * Name: CalendarType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system for specifying a type of calendar
* Identity: [v3-Charset](CodeSystem-v3-Charset.md)
  * Name: Charset
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Internet Assigned Numbers Authority (IANA) Charset Types
* Identity: [v3-CodingRationale](CodeSystem-v3-CodingRationale.md)
  * Name: CodingRationale
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Si…
* Identity: [v3-CommunicationFun…](CodeSystem-v3-CommunicationFunctionType.md)
  * Name: CommunicationFunctionType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Describes the type of communication function that the associated entity plays in the associated tra…
* Identity: [v3-CompressionAlgor…](CodeSystem-v3-CompressionAlgorithm.md)
  * Name: CompressionAlgorithm
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Type of compression algorithm used
* Identity: [v3-ConceptGenerality](CodeSystem-v3-ConceptGenerality.md)
  * Name: ConceptGenerality
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: Indicates whether the concept that is the target should be interpreted as itself, or whether it sho…
* Identity: [v3-ConceptProperty](CodeSystem-v3-ConceptProperty.md)
  * Name: HL7 Value Set and Coded Concept Property Codes
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-ConceptStatus](CodeSystem-v3-ConceptStatus.md)
  * Name: HL7 Coded Concept Status
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-Confidentiality](CodeSystem-v3-Confidentiality.md)
  * Name: Confidentiality
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: A set of codes specifying the security classification of acts and roles in accordance with the defi…
* Identity: [v3-ContainerCap](CodeSystem-v3-ContainerCap.md)
  * Name: ContainerCap
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The type of cap associated with a container
* Identity: [v3-ContainerSeparat…](CodeSystem-v3-ContainerSeparator.md)
  * Name: ContainerSeparator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A material in a blood collection container that facilites the separation of of blood cells from ser…
* Identity: [v3-ContentProcessin…](CodeSystem-v3-ContentProcessingMode.md)
  * Name: ContentProcessingMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Identifies the order in which content should be processed.
* Identity: [v3-ContextControl](CodeSystem-v3-ContextControl.md)
  * Name: ContextControl
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code that specifies how an ActRelationship or Participation contributes to the context of an Act,…
* Identity: [v3-DataOperation](CodeSystem-v3-DataOperation.md)
  * Name: DataOperation
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-Dentition](CodeSystem-v3-Dentition.md)
  * Name: Dentition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-DeviceAlertLevel](CodeSystem-v3-DeviceAlertLevel.md)
  * Name: DeviceAlertLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Domain values for the Device.Alert_levelCode
* Identity: [v3-DocumentCompleti…](CodeSystem-v3-DocumentCompletion.md)
  * Name: DocumentCompletion
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the current completion state of a clinical document.
* Identity: [v3-DocumentStorage](CodeSystem-v3-DocumentStorage.md)
  * Name: DocumentStorage
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the storage status of a document.
* Identity: [v3-EditStatus](CodeSystem-v3-EditStatus.md)
  * Name: EditStatus
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: The status of an entry as it pertains to its review and incorporation into the HL7 domain specifica…
* Identity: [v3-EducationLevel](CodeSystem-v3-EducationLevel.md)
  * Name: Education Level
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Years of education that a person has completed
* Identity: [v3-EmployeeJobClass](CodeSystem-v3-EmployeeJobClass.md)
  * Name: EmployeeJobClass
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code qualifying the employment in various ways, such as, full-time vs. part time, etc.
* Identity: [v3-EncounterAdmissi…](CodeSystem-v3-EncounterAdmissionSource.md)
  * Name: EncounterAdmissionSource
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EncounterReferra…](CodeSystem-v3-EncounterReferralSource.md)
  * Name: EncounterReferralSource
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: This domain is defined in UB92 and applies to US realm only**Deprecation Comment:**Deprecated …
* Identity: [v3-EncounterSpecial…](CodeSystem-v3-EncounterSpecialCourtesy.md)
  * Name: EncounterSpecialCourtesy
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityClass](CodeSystem-v3-EntityClass.md)
  * Name: EntityClass
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top …
* Identity: [v3-EntityCode](CodeSystem-v3-EntityCode.md)
  * Name: EntityCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing description.
* Identity: [v3-EntityDeterminer](CodeSystem-v3-EntityDeterminer.md)
  * Name: EntityDeterminer
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: EntityDeterminer in natural language grammar is the class of words that comprises articles, demonst…
* Identity: [v3-EntityHandling](CodeSystem-v3-EntityHandling.md)
  * Name: EntityHandling
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Special handling requirements for an Entity.*Example:*Keep at room temperature; Keep frozen bel…
* Identity: [v3-EntityNamePartQu…](CodeSystem-v3-EntityNamePartQualifier.md)
  * Name: EntityNamePartQualifier
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Needs description
* Identity: [v3-EntityNamePartQu…](CodeSystem-v3-EntityNamePartQualifierR2.md)
  * Name: EntityNamePartQualifierR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**The qualifier is a set of codes each of which specifies a certain subcategory of th…
* Identity: [v3-EntityNamePartTy…](CodeSystem-v3-EntityNamePartType.md)
  * Name: EntityNamePartType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityNamePartTy…](CodeSystem-v3-EntityNamePartTypeR2.md)
  * Name: EntityNamePartTypeR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc.
* Identity: [v3-EntityNameUse](CodeSystem-v3-EntityNameUse.md)
  * Name: EntityNameUse
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityNameUseR2](CodeSystem-v3-EntityNameUseR2.md)
  * Name: EntityNameUseR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**A set of codes advising a system or user which name in a set of names to select for…
* Identity: [v3-EntityRisk](CodeSystem-v3-EntityRisk.md)
  * Name: EntityRisk
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Kinds of risks associated with the handling of the material..
* Identity: [v3-EntityStatus](CodeSystem-v3-EntityStatus.md)
  * Name: EntityStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Entity, as defined by the Entity class state m…
* Identity: [v3-EquipmentAlertLe…](CodeSystem-v3-EquipmentAlertLevel.md)
  * Name: EquipmentAlertLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-Ethnicity](CodeSystem-v3-Ethnicity.md)
  * Name: Ethnicity
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-01-30
  * Description: **Deprecation Information:**Deprecated due to UP-265. This code system in NOT the acknowledged sou…
* Identity: [v3-ExposureMode](CodeSystem-v3-ExposureMode.md)
  * Name: ExposureMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the pa…
* Identity: [v3-GTSAbbreviation](CodeSystem-v3-GTSAbbreviation.md)
  * Name: GTSAbbreviation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Open Issue:**It appears that the printnames are suboptimal and should be improved for many of the …
* Identity: [v3-GenderStatus](CodeSystem-v3-GenderStatus.md)
  * Name: GenderStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing whether the primary reproductive organs of NonPersonLivingSubject are present.
* Identity: [v3-HL7ContextConduc…](CodeSystem-v3-HL7ContextConductionStyle.md)
  * Name: HL7ContextConductionStyle
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The styles of context conduction usable by relationships within a static model derived from tyhe HL…
* Identity: [v3-HL7DocumentForma…](CodeSystem-v3-HL7DocumentFormatCodes.md)
  * Name: HL7 Document Format Codes
  * Version: 4.1.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-11-10
  * Description: This codeSystem contains codes which specify the technical format of a document. Each code provides…
* Identity: [v3-HL7StandardVersi…](CodeSystem-v3-HL7StandardVersionCode.md)
  * Name: HL7StandardVersionCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This code system holds version codes for the Version 3 standards. Values are to be determined by HL…
* Identity: [v3-HL7UpdateMode](CodeSystem-v3-HL7UpdateMode.md)
  * Name: HL7UpdateMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The possible modes of updating that occur when an attribute is received by a system that already co…
* Identity: [v3-HtmlLinkType](CodeSystem-v3-HtmlLinkType.md)
  * Name: HtmlLinkType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current docum…
* Identity: [v3-IdentifierReliab…](CodeSystem-v3-IdentifierReliability.md)
  * Name: IdentifierReliability
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies the reliability with which the identifier is known. This attribute MAY be used to assist …
* Identity: [v3-IdentifierScope](CodeSystem-v3-IdentifierScope.md)
  * Name: IdentifierScope
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes to specify the scope in which the identifier applies to the object with whic…
* Identity: [v3-IntegrityCheckAl…](CodeSystem-v3-IntegrityCheckAlgorithm.md)
  * Name: IntegrityCheckAlgorithm
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-LanguageAbilityM…](CodeSystem-v3-LanguageAbilityMode.md)
  * Name: LanguageAbilityMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the method of expression of the language.*Example:*Expressed spoken, expre…
* Identity: [v3-LanguageAbilityP…](CodeSystem-v3-LanguageAbilityProficiency.md)
  * Name: LanguageAbilityProficiency
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the level of proficiency in a language.*Example:*Excellent, good, fair, po…
* Identity: [v3-LivingArrangement](CodeSystem-v3-LivingArrangement.md)
  * Name: LivingArrangement
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code depicting the living arrangements of a person
* Identity: [v3-LocalMarkupIgnore](CodeSystem-v3-LocalMarkupIgnore.md)
  * Name: LocalMarkupIgnore
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Tells a receiver to ignore just the local markup tags (local_markup, local_header, local_attr) w…
* Identity: [v3-LocalRemoteContr…](CodeSystem-v3-LocalRemoteControlState.md)
  * Name: LocalRemoteControlState
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the current state of control associated with the device.**Examples:**A devi…
* Identity: [v3-MDFAttributeType](CodeSystem-v3-MDFAttributeType.md)
  * Name: MDFAttributeType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-MDFSubjectAreaPr…](CodeSystem-v3-MDFSubjectAreaPrefix.md)
  * Name: MDFSubjectAreaPrefix
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: The standard prefixes used in Rose for RIM subject areas that determine the role or function of eac…
* Identity: [v3-ManagedParticipa…](CodeSystem-v3-ManagedParticipationStatus.md)
  * Name: ManagedParticipationStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of a Managed Participation, as defined by the Manage…
* Identity: [v3-ManufacturerMode…](CodeSystem-v3-ManufacturerModelNameExample.md)
  * Name: ManufacturerModelNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the ManufacturerModelName concept domain used to convey a coded …
* Identity: [v3-MapRelationship](CodeSystem-v3-MapRelationship.md)
  * Name: MapRelationship
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept …
* Identity: [v3-MaritalStatus](CodeSystem-v3-MaritalStatus.md)
  * Name: MaritalStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: * * * No description supplied * * ***Open Issue:**The specific meanings of these codes can…
* Identity: [v3-MdfHmdMetSourceT…](CodeSystem-v3-MdfHmdMetSourceType.md)
  * Name: MdfHmdMetSourceType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: Code to identify the source of a Message Element Type represented in the 'of MET' column of an HMD.…
* Identity: [v3-MdfHmdRowType](CodeSystem-v3-MdfHmdRowType.md)
  * Name: MdfHmdRowType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: The row type codes for the tabular representation of a Hierarchical Message Description.**Depre…
* Identity: [v3-MdfRmimRowType](CodeSystem-v3-MdfRmimRowType.md)
  * Name: MdfRmimRowType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: The row types for the tabular representation of an R-MIM.**Deprecation Comment:**Deprecated as…
* Identity: [v3-MessageCondition](CodeSystem-v3-MessageCondition.md)
  * Name: MessageCondition
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-MessageWaitingPr…](CodeSystem-v3-MessageWaitingPriority.md)
  * Name: MessageWaitingPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Indicates that the receiver has messages for the sender**OpenIssue:**Description does not make s…
* Identity: [v3-ModifyIndicator](CodeSystem-v3-ModifyIndicator.md)
  * Name: ModifyIndicator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Indicates whether the subscription to a query is new or is being modified.
* Identity: [v3-NullFlavor](CodeSystem-v3-NullFlavor.md)
  * Name: NullFlavor
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A collection of codes specifying why a valid value is not present.
* Identity: [v3-ObservationCateg…](CodeSystem-v3-ObservationCategory.md)
  * Name: ObservationCategory
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: High level observation categories for the general type of observation being made.URL: http://hl…
* Identity: [v3-ObservationInter…](CodeSystem-v3-ObservationInterpretation.md)
  * Name: ObservationInterpretation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: One or more codes providing a rough qualitative interpretation of the observation, such as "normal"…
* Identity: [v3-ObservationMethod](CodeSystem-v3-ObservationMethod.md)
  * Name: ObservationMethod
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code that provides additional detail about the means or technique used to ascertain the observati…
* Identity: [v3-ObservationValue](CodeSystem-v3-ObservationValue.md)
  * Name: ObservationValue
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: This code system covers all concepts of HL7-defined values for the Observation value element, when …
* Identity: [v3-OrganizationName…](CodeSystem-v3-OrganizationNameType.md)
  * Name: OrganizationNameType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-ParameterizedDat…](CodeSystem-v3-ParameterizedDataType.md)
  * Name: ParameterizedDataType
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7…
* Identity: [v3-ParticipationFun…](CodeSystem-v3-ParticipationFunction.md)
  * Name: ParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This code is used to specify the exact function an actor had in a service in all necessary detail. …
* Identity: [v3-ParticipationMode](CodeSystem-v3-ParticipationMode.md)
  * Name: ParticipationMode
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2021-08-10
  * Description: A set of codes specifying the modality by which the Entity playing the Role is participating in the…
* Identity: [v3-ParticipationSig…](CodeSystem-v3-ParticipationSignature.md)
  * Name: ParticipationSignature
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A set of codes specifying whether and how the participant has attested his participation through a …
* Identity: [v3-ParticipationType](CodeSystem-v3-ParticipationType.md)
  * Name: ParticipationType
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the meaning and purpose of every Participation instance. Each of its values impli…
* Identity: [v3-PatientImportance](CodeSystem-v3-PatientImportance.md)
  * Name: PatientImportance
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Patient VIP code
* Identity: [v3-PaymentTerms](CodeSystem-v3-PaymentTerms.md)
  * Name: PaymentTerms
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Describes payment terms for a financial transaction, used in an invoice.This is typically expre…
* Identity: [v3-PersonDisability…](CodeSystem-v3-PersonDisabilityType.md)
  * Name: PersonDisabilityType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code identifying a person's disability.
* Identity: [v3-PostalAddressUse](CodeSystem-v3-PostalAddressUse.md)
  * Name: PostalAddressUse
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**This code system was deprecated as of the November 2007 harmonization meetin…
* Identity: [v3-ProbabilityDistr…](CodeSystem-v3-ProbabilityDistributionType.md)
  * Name: ProbabilityDistributionType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-ProcessingID](CodeSystem-v3-ProcessingID.md)
  * Name: ProcessingID
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes used to specify whether a message is part of a production, training, or debugging system.
* Identity: [v3-ProcessingMode](CodeSystem-v3-ProcessingMode.md)
  * Name: ProcessingMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This attribute defines whether the message is being sent in current processing, archive mode, initi…
* Identity: [v3-QueryParameterVa…](CodeSystem-v3-QueryParameterValue.md)
  * Name: QueryParameterValue
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The domain of coded values used as parameters within QueryByParameter queries.
* Identity: [v3-QueryPriority](CodeSystem-v3-QueryPriority.md)
  * Name: QueryPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the time frame in which the response is expected.
* Identity: [v3-QueryQuantityUnit](CodeSystem-v3-QueryQuantityUnit.md)
  * Name: QueryQuantityUnit
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: Values in this domain specify the units of a query quantity limited request.**Deprecation Comme…
* Identity: [v3-QueryRequestLimit](CodeSystem-v3-QueryRequestLimit.md)
  * Name: QueryRequestLimit
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Definition:**Defines the units associated with the magnitude of the maximum size limit of a quer…
* Identity: [v3-QueryResponse](CodeSystem-v3-QueryResponse.md)
  * Name: QueryResponse
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code classifying the general nature of the response to a given query. Includes whether or not dat…
* Identity: [v3-QueryStatusCode](CodeSystem-v3-QueryStatusCode.md)
  * Name: QueryStatusCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the state of the Query.
* Identity: [v3-Race](CodeSystem-v3-Race.md)
  * Name: Race
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-01-05
  * Description: **Deprecation Information:**Deprecated per UP-263. This code system is NOT the acknowledged source…
* Identity: [v3-RelationalOperat…](CodeSystem-v3-RelationalOperator.md)
  * Name: RelationalOperator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies common relational operators used in selection criteria.
* Identity: [v3-RelationshipConj…](CodeSystem-v3-RelationshipConjunction.md)
  * Name: RelationshipConjunction
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.…
* Identity: [v3-ReligiousAffilia…](CodeSystem-v3-ReligiousAffiliation.md)
  * Name: Religious Affiliation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Assigment of spiritual faith affiliation
* Identity: [v3-ResponseLevel](CodeSystem-v3-ResponseLevel.md)
  * Name: ResponseLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies whether a response is expected from the addressee of this interaction and what level of d…
* Identity: [v3-ResponseModality](CodeSystem-v3-ResponseModality.md)
  * Name: ResponseModality
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Defines the timing and grouping of the response instances.**OpenIssue:**Description copied from …
* Identity: [v3-ResponseMode](CodeSystem-v3-ResponseMode.md)
  * Name: ResponseMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its…
* Identity: [v3-RoleClass](CodeSystem-v3-RoleClass.md)
  * Name: RoleClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an asso…
* Identity: [v3-RoleCode](CodeSystem-v3-RoleCode.md)
  * Name: RoleCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-15
  * Description: A set of codes further specifying the kind of Role; specific classification codes for further quali…
* Identity: [v3-RoleLinkStatus](CodeSystem-v3-RoleLinkStatus.md)
  * Name: RoleLinkStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes representing possible states of a RoleLink, as defined by the RoleLink class …
* Identity: [v3-RoleLinkType](CodeSystem-v3-RoleLinkType.md)
  * Name: RoleLinkType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies sp…
* Identity: [v3-RoleStatus](CodeSystem-v3-RoleStatus.md)
  * Name: RoleStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Role, as defined by the Role class state machi…
* Identity: [v3-RouteOfAdministr…](CodeSystem-v3-RouteOfAdministration.md)
  * Name: RouteOfAdministration
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The path the administered medication takes to get into the body or into contact with the body.
* Identity: [v3-Sequencing](CodeSystem-v3-Sequencing.md)
  * Name: Sequencing
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies sequence of sort order.
* Identity: [v3-SetOperator](CodeSystem-v3-SetOperator.md)
  * Name: SetOperator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-SoftwareNameExam…](CodeSystem-v3-SoftwareNameExample.md)
  * Name: SoftwareNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the SoftwareName concept domain used to convey a coded name for …
* Identity: [v3-SpecimenType](CodeSystem-v3-SpecimenType.md)
  * Name: SpecimenType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-SubstitutionCond…](CodeSystem-v3-SubstitutionCondition.md)
  * Name: SubstitutionCondition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies what sort of change is permitted or has occurred between the item that was ordered/reque…
* Identity: [v3-TableCellHorizon…](CodeSystem-v3-TableCellHorizontalAlign.md)
  * Name: TableCellHorizontalAlign
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellScope](CodeSystem-v3-TableCellScope.md)
  * Name: TableCellScope
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellVertica…](CodeSystem-v3-TableCellVerticalAlign.md)
  * Name: TableCellVerticalAlign
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableFrame](CodeSystem-v3-TableFrame.md)
  * Name: TableFrame
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableRules](CodeSystem-v3-TableRules.md)
  * Name: TableRules
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TargetAwareness](CodeSystem-v3-TargetAwareness.md)
  * Name: TargetAwareness
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the extent to which the Entity playing the participating Role (usually as a targe…
* Identity: [v3-Telecommunicatio…](CodeSystem-v3-TelecommunicationAddressUse.md)
  * Name: TelecommunicationAddressUse
  * Version: 2.0.1
  * Status: retired
  * Content: complete
  * Owner: HL7
  * Copyright: n/a
  * Date: 2019-03-20
  * Description: **Deprecation Comment:**This code system was deprecated as of the November 2007 harmonization meetin…
* Identity: [v3-Telecommunicatio…](CodeSystem-v3-TelecommunicationCapabilities.md)
  * Name: TelecommunicationCapabilities
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Concepts that define the telecommunication capabilities of a particular device. Us…
* Identity: [v3-TimingEvent](CodeSystem-v3-TimingEvent.md)
  * Name: TimingEvent
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-TransmissionRela…](CodeSystem-v3-TransmissionRelationshipTypeCode.md)
  * Name: TransmissionRelationshipTypeCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**A code specifying the meaning and purpose of every TransmissionRelationship instanc…
* Identity: [v3-TribalEntityUS](CodeSystem-v3-TribalEntityUS.md)
  * Name: TribalEntityUS
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN…
* Identity: [v3-URLScheme](CodeSystem-v3-URLScheme.md)
  * Name: Universal Resource Locator Scheme
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet st…
* Identity: [v3-VaccineManufactu…](CodeSystem-v3-VaccineManufacturer.md)
  * Name: VaccineManufacturer
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The manufacturer of a vaccine.
* Identity: [v3-VaccineType](CodeSystem-v3-VaccineType.md)
  * Name: VaccineType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The kind of vaccine.
* Identity: [v3-WorkClassificati…](CodeSystem-v3-WorkClassificationODH.md)
  * Name: Work Classification (Occupational Data for Health)
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system of concepts representing a person's job type as defined by compensation and sector (e.g…
* Identity: [v3-hl7ApprovalStatus](CodeSystem-v3-hl7ApprovalStatus.md)
  * Name: HL7ApprovalStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for concepts describing the approval level of HL7 artifacts. This code syste…
* Identity: [v3-hl7CMETAttributi…](CodeSystem-v3-hl7CMETAttribution.md)
  * Name: HL7CMETAttribution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DEFINITIONS ****
* Identity: [v3-hl7ITSType](CodeSystem-v3-hl7ITSType.md)
  * Name: HL7ITSType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes identifying types of HL7 Implementation Technology Specifications
* Identity: [v3-hl7ITSVersionCode](CodeSystem-v3-hl7ITSVersionCode.md)
  * Name: HL7 ITS Version Code
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: HL7 implementation technology specification versions. These codes will document the ITS type and ve…
* Identity: [v3-hl7PublishingDom…](CodeSystem-v3-hl7PublishingDomain.md)
  * Name: HL7PublishingDomain
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing domains (specific content area)
* Identity: [v3-hl7PublishingSec…](CodeSystem-v3-hl7PublishingSection.md)
  * Name: HL7PublishingSection
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing sections (major business categories)
* Identity: [v3-hl7PublishingSub…](CodeSystem-v3-hl7PublishingSubSection.md)
  * Name: HL7PublishingSubSection
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing sub-sections (business sub-categories)
* Identity: [v3-hl7V3Conformance](CodeSystem-v3-hl7V3Conformance.md)
  * Name: HL7V3Conformance
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Identifies allowed codes for HL7aTMs v3 conformance property.
* Identity: [v3-hl7VoteResolution](CodeSystem-v3-hl7VoteResolution.md)
  * Name: HL7VoteResolution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Based on concepts for resolutions from HL7 ballot spreadsheet according to HL7's G…
* Identity: [v3-mediaType](CodeSystem-v3-mediaType.md)
  * Name: Media Type
  * Version: 3.0.0
  * Status: active
  * Content: fragment
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Internet Assigned Numbers Authority (IANA) Mime Media Types. Identifies the type of the encapsulate…
* Identity: [v3-orderableDrugForm](CodeSystem-v3-orderableDrugForm.md)
  * Name: Orderable Drug Form
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing description.
* Identity: [v3-styleType](CodeSystem-v3-styleType.md)
  * Name: Style Type
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The style code is used within the CDA/SPL narrative block to give the instance author some control …
* Identity: [v3-substanceAdminSu…](CodeSystem-v3-substanceAdminSubstitution.md)
  * Name: Substance Admin Substitution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies what sort of change is permitted or has occurred between the therapy that was ordered an…

Showing 163 of 163 entries

