# SnodentDentalUniversalNumberingSystemInternational - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SnodentDentalUniversalNumberingSystemInternational**

## ValueSet: SnodentDentalUniversalNumberingSystemInternational 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-SnodentDentalUniversalNumberingSystemInternational | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SnodentDentalUniversalNumberingSystemInternational |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20556 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The SNODENT identifiers for all of the possible human teeth, both adult and adolescent. 
This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. 
http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent 
**Steward:** Attachments WG 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-SnodentDentalUniversalNumberingSystemInternational",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "att"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/v3-SnodentDentalUniversalNumberingSystemInternational",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20556"
    }
  ],
  "version" : "3.0.0",
  "name" : "SnodentDentalUniversalNumberingSystemInternational",
  "title" : "SnodentDentalUniversalNumberingSystemInternational",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The SNODENT identifiers for all of the possible human teeth, both adult and adolescent.\r\n\r\nThis value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA.\r\n\r\nhttp://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent\r\n\r\n*Steward:* Attachments WG",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.ada.org/snodent",
        "concept" : [
          {
            "code" : "160654D"
          },
          {
            "code" : "160704D"
          },
          {
            "code" : "160770D"
          },
          {
            "code" : "160817D"
          },
          {
            "code" : "160840D"
          },
          {
            "code" : "160903D"
          },
          {
            "code" : "160957D"
          },
          {
            "code" : "161006D"
          },
          {
            "code" : "161010D"
          },
          {
            "code" : "161068D"
          },
          {
            "code" : "161109D"
          },
          {
            "code" : "161121D"
          },
          {
            "code" : "161132D"
          },
          {
            "code" : "161150D"
          },
          {
            "code" : "161178D"
          },
          {
            "code" : "161197D"
          },
          {
            "code" : "161227D"
          },
          {
            "code" : "161258D"
          },
          {
            "code" : "161262D"
          },
          {
            "code" : "161291D"
          },
          {
            "code" : "161317D"
          },
          {
            "code" : "161329D"
          },
          {
            "code" : "161372D"
          },
          {
            "code" : "161412D"
          },
          {
            "code" : "161454D"
          },
          {
            "code" : "161477D"
          },
          {
            "code" : "161496D"
          },
          {
            "code" : "161514D"
          },
          {
            "code" : "161533D"
          },
          {
            "code" : "161546D"
          },
          {
            "code" : "161607D"
          },
          {
            "code" : "161892D"
          },
          {
            "code" : "161941D"
          },
          {
            "code" : "161956D"
          },
          {
            "code" : "162004D"
          },
          {
            "code" : "162062D"
          },
          {
            "code" : "162091D"
          },
          {
            "code" : "162129D"
          },
          {
            "code" : "162206D"
          },
          {
            "code" : "162234D"
          },
          {
            "code" : "162268D"
          },
          {
            "code" : "162309D"
          },
          {
            "code" : "162321D"
          },
          {
            "code" : "162345D"
          },
          {
            "code" : "162350D"
          },
          {
            "code" : "162418D"
          },
          {
            "code" : "162425D"
          },
          {
            "code" : "162441D"
          },
          {
            "code" : "162494D"
          },
          {
            "code" : "162537D"
          },
          {
            "code" : "162585D"
          },
          {
            "code" : "162619D"
          },
          {
            "code" : "177259D"
          },
          {
            "code" : "177263D"
          },
          {
            "code" : "177271D"
          },
          {
            "code" : "177285D"
          },
          {
            "code" : "177292D"
          },
          {
            "code" : "177302D"
          },
          {
            "code" : "177318D"
          },
          {
            "code" : "177325D"
          },
          {
            "code" : "177339D"
          },
          {
            "code" : "177341D"
          },
          {
            "code" : "177356D"
          },
          {
            "code" : "177360D"
          },
          {
            "code" : "177373D"
          },
          {
            "code" : "177387D"
          },
          {
            "code" : "177394D"
          },
          {
            "code" : "177409D"
          },
          {
            "code" : "177413D"
          },
          {
            "code" : "177421D"
          },
          {
            "code" : "177432D"
          },
          {
            "code" : "177445D"
          },
          {
            "code" : "177450D"
          },
          {
            "code" : "177466D"
          },
          {
            "code" : "177478D"
          },
          {
            "code" : "177484D"
          },
          {
            "code" : "177497D"
          },
          {
            "code" : "177506D"
          },
          {
            "code" : "177510D"
          },
          {
            "code" : "177523D"
          },
          {
            "code" : "177534D"
          },
          {
            "code" : "177547D"
          },
          {
            "code" : "177552D"
          },
          {
            "code" : "177568D"
          },
          {
            "code" : "177575D"
          },
          {
            "code" : "177581D"
          },
          {
            "code" : "177599D"
          },
          {
            "code" : "177608D"
          },
          {
            "code" : "177612D"
          },
          {
            "code" : "177620D"
          },
          {
            "code" : "177631D"
          },
          {
            "code" : "177649D"
          },
          {
            "code" : "177654D"
          },
          {
            "code" : "177665D"
          },
          {
            "code" : "177677D"
          },
          {
            "code" : "177683D"
          },
          {
            "code" : "177696D"
          },
          {
            "code" : "177704D"
          },
          {
            "code" : "177715D"
          },
          {
            "code" : "177727D"
          },
          {
            "code" : "177736D"
          },
          {
            "code" : "177743D"
          },
          {
            "code" : "177758D"
          },
          {
            "code" : "177762D"
          }
        ]
      }
    ]
  }
}

```
