# SecurityControlObservationValue - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SecurityControlObservationValue**

## ValueSet: SecurityControlObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-SecurityControlObservationValue | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SecurityControlObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20471 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Security observation values used to indicate security control metadata. V:SecurityControl is the union of V:SecurityPolicy, V:ObligationPolicy, V:RefrainPolicy, V:PurposeOfUse, and V:GeneralPurpose of Use, V:PrivacyMark, V:SecurityLabelMark, and V:ControlledUnclassifiedInformation used to populate the SecurityControlObservationValue attribute in order to convey one or more nonhierarchical security control metadata dictating handling caveats including, purpose of use, obligation policy, refrain policy, dissemination controls and privacy marks to which a custodian or receiver is required to comply. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-SecurityControlObservationValue",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-SecurityControlObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20471"
    }
  ],
  "version" : "3.0.0",
  "name" : "SecurityControlObservationValue",
  "title" : "SecurityControlObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Security observation values used to indicate security control metadata. V:SecurityControl is the union of V:SecurityPolicy, V:ObligationPolicy, V:RefrainPolicy, V:PurposeOfUse, and V:GeneralPurpose of Use, V:PrivacyMark, V:SecurityLabelMark, and V:ControlledUnclassifiedInformation used to populate the SecurityControlObservationValue attribute in order to convey one or more nonhierarchical security control metadata dictating handling caveats including, purpose of use, obligation policy, refrain policy, dissemination controls and privacy marks to which a custodian or receiver is required to comply.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-SecurityPolicy"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ObligationPolicy"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-RefrainPolicy"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-PurposeOfUse"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-GeneralPurposeOfUse"]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationValue"
      }
    ]
  }
}

```
