# Study Design - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Study Design**

## ValueSet: Study Design 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/study-design | *Version*:1.0.0 | | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StudyDesign |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This is a set of terms for study design characteristics. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "study-design",
  "meta" : {
    "lastUpdated" : "2022-05-12T12:40:00+00:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/study-design",
  "version" : "1.0.0",
  "name" : "StudyDesign",
  "title" : "Study Design",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-08-24T12:40:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This is a set of terms for study design characteristics.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "https://fevir.net/sevco",
        "version" : "2.0",
        "concept" : [
          {
            "code" : "SEVCO:01001",
            "display" : "interventional research",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design in which an independent variable (an exposure or intervention) is prospectively assigned or modified by the investigator to evaluate a response in the dependent variable (an effect or outcome)."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "interventional study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "interventional study design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "interventional primary research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "international method of research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "experimental research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "experimental study"
              }
            ]
          },
          {
            "code" : "SEVCO:01003",
            "display" : "randomized assignment",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "An interventional study design in which an independent variable (an exposure or intervention) is prospectively assigned or modified by random chance to separate groups."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "interventional research with randomized assignment"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "randomized trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "randomized controlled trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RCT"
              }
            ]
          },
          {
            "code" : "SEVCO:01006",
            "display" : "simple randomization",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A randomized assignment in which each participant has the same prespecified likelihood of being assigned to a group as all other participants, independent of the assignment of any other participant."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "unrestricted randomization"
              }
            ]
          },
          {
            "code" : "SEVCO:01007",
            "display" : "stratified randomization",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A randomized assignment in which participants are stratified into groups based on prognostic variables and then randomized into balanced treatment groups"
              }
            ]
          },
          {
            "code" : "SEVCO:01008",
            "display" : "block randomization",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A randomized assignment in which a pre-specified number of subjects is assigned to a block containing the same pre-specified ratio of group assignments in random order."
              }
            ]
          },
          {
            "code" : "SEVCO:01009",
            "display" : "adaptive randomization",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A randomized assignment in which a participant’s group assignment probability is adjusted based on any factor such that the likelihood of assignment is not the same for all participants."
              }
            ]
          },
          {
            "code" : "SEVCO:01005",
            "display" : "non-randomized assignment",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "An interventional study design in which an independent variable (an exposure or intervention) is prospectively assigned or modified by methods other than random chance to separate groups."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "interventional research with non-randomized assignment"
              }
            ]
          },
          {
            "code" : "SEVCO:01004",
            "display" : "quasi-randomized assignment",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "An interventional study design with a method of allocation that is not limited to random chance but is intended to produce similar baseline groups for experimentation."
              }
            ]
          },
          {
            "code" : "SEVCO:01029",
            "display" : "clinical trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Interventional research in which one or more healthcare-related actions (i.e., a diagnostic, prognostic, therapeutic, preventive or screening method or intervention) is evaluated for effects on health-related biomedical or behavioral processes and/or outcomes."
              }
            ]
          },
          {
            "code" : "SEVCO:01041",
            "display" : "pragmatic clinical trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial conducted under conditions of routine clinical practice."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "pragmatic trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01038",
            "display" : "expanded access study",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial that provides a means for obtaining an experimental drug or device for patients who are not adequately treated by existing therapy, who do not meet the eligibility criteria for enrollment, or who are otherwise unable to participate in another clinical study."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "compassionate use trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "compassionate use study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "expanded access trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01030",
            "display" : "phase 1 trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial to gather initial evidence in humans to support further investigation of an intervention."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase I trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 1 study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase I clinical trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01031",
            "display" : "exploratory investigational new drug study",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial that is conducted early in phase 1, involves very limited human exposure, and has no therapeutic or diagnostic intent (e.g., screening studies, microdose studies)."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 0 study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "pre-clinical trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "exploratory ind study"
              }
            ]
          },
          {
            "code" : "SEVCO:01032",
            "display" : "phase 1/phase 2 trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial with a component meeting the definition of phase 1 trial and a component meeting the definition of phase 2 trial."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase I/II trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 1-2 trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 1/2 trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "trial phase 1-2"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "trial phase 1/2"
              }
            ]
          },
          {
            "code" : "SEVCO:01033",
            "display" : "phase 2 trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial to gather evidence of effectiveness and safety for an intervention in patients with the disease or condition under study, but not intended to provide an adequate basis for regulatory approval for clinical use."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase II trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 2 study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "exploratory clinical study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase II clinical trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01034",
            "display" : "phase 2/phase 3 trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial with a component meeting the definition of phase 2 trial and a component meeting the definition of phase 3 trial."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase II/III trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 2-3 trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 2/3 trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "trial phase 2-3"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "trial phase 2/3"
              }
            ]
          },
          {
            "code" : "SEVCO:01035",
            "display" : "phase 3 trial",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial to gather the evidence of effectiveness and safety of an intervention, intended to provide an adequate basis for regulatory approval for clinical use."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase III trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 3 study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "confirmatory clinical study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase III clinical trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01036",
            "display" : "post-marketing study",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A clinical trial to gather additional evidence of effectiveness and safety of an intervention for an already approved clinical use."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase IV trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 4 trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "phase 4 study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "trial phase 4"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "post-approval study"
              }
            ]
          },
          {
            "code" : "SEVCO:01002",
            "display" : "observational research",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design in which the independent variables (exposures or interventions) are not prospectively assigned or modified by the investigator."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational study design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational primary research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational method of research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "non-interventional research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational study design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "observational primary research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "non-interventional research"
              }
            ]
          },
          {
            "code" : "SEVCO:01037",
            "display" : "post-marketing surveillance study",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "An observational study to identify adverse events related to the use of an approved clinical intervention."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "postmarketing evaluation study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "postmarketing evaluation study"
              }
            ]
          },
          {
            "code" : "SEVCO:01010",
            "display" : "comparative study design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design in which two or more groups are compared."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "comparative research"
              }
            ]
          },
          {
            "code" : "SEVCO:01011",
            "display" : "parallel cohort design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A comparative study design in which the groups are compared concurrently and participants are expected to remain in the groups being compared for the entire duration of participation in the study."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "concurrent cohort study"
              }
            ]
          },
          {
            "code" : "SEVCO:01012",
            "display" : "crossover cohort design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A comparative study design in which participants receive two or more alternative exposures during separate periods of time."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "crossover study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "crossover trial"
              }
            ]
          },
          {
            "code" : "SEVCO:01024",
            "display" : "controlled crossover cohort design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A crossover cohort design in which two or more cohorts have different orders of exposures."
              }
            ]
          },
          {
            "code" : "SEVCO:01025",
            "display" : "single-arm crossover design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A crossover cohort design in which all participants are in a single cohort with the same order of exposures."
              }
            ]
          },
          {
            "code" : "SEVCO:01013",
            "display" : "case control design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A comparative study design in which the groups being compared are defined by outcome presence (case) or absence (control)."
              }
            ]
          },
          {
            "code" : "SEVCO:01014",
            "display" : "matching for comparison",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A comparative study design in which individual participants in different groups being compared are paired or matched into sets based on selected attributes for within-set analysis."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "matched study design"
              }
            ]
          },
          {
            "code" : "SEVCO:01020",
            "display" : "family study design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A matched study design in which related or non-related family members are compared."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "familial study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "family study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "family based study"
              }
            ]
          },
          {
            "code" : "SEVCO:01021",
            "display" : "twin study design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A family study design in which twin siblings are compared."
              }
            ]
          },
          {
            "code" : "SEVCO:01015",
            "display" : "cluster as unit of allocation",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A comparative study design in which participants are allocated to exposures (interventions) by their membership in groups (called clusters) rather than by individualized assignments."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "clustering for comparison"
              }
            ]
          },
          {
            "code" : "SEVCO:01023",
            "display" : "non-comparative study design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design with no comparisons between groups with different exposures and no comparisons between groups with different outcomes."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "non-comparative research"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "descriptive study"
              }
            ]
          },
          {
            "code" : "SEVCO:01016",
            "display" : "uncontrolled cohort design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A non-comparative study design in which two or more participants are evaluated in a single group (or cohort)."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "single cohort design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "case series design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "non-controlled cohort design"
              }
            ]
          },
          {
            "code" : "SEVCO:01017",
            "display" : "case report",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A non-comparative study design in which a single participant is evaluated."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "case study"
              }
            ]
          },
          {
            "code" : "SEVCO:01022",
            "display" : "population-based design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design in which the unit of observation is a population or community."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "population study"
              }
            ]
          },
          {
            "code" : "SEVCO:01044",
            "display" : "ecological design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design in which the unit of observation is a population or community defined by social relationships or physical surroundings."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "ecologic study"
              }
            ]
          },
          {
            "code" : "SEVCO:01027",
            "display" : "cross sectional data collection",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which data is collected at a single point in time."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "cross-sectional study"
              }
            ]
          },
          {
            "code" : "SEVCO:01028",
            "display" : "longitudinal data collection",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which data is collected at two or more points in time."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "longitudinal study"
              }
            ]
          },
          {
            "code" : "SEVCO:01018",
            "display" : "time series design",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A longitudinal data collection which includes a set of time-ordered observations."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "multiple time point comparison"
              }
            ]
          },
          {
            "code" : "SEVCO:01019",
            "display" : "before and after comparison",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A time series design which includes comparisons of observations before and after an event or exposure."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "before and after design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "pre-post design"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "before-after comparison"
              }
            ]
          },
          {
            "code" : "SEVCO:01045",
            "display" : "primary data collection",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the data are recorded and collected during the study for the purpose of the same study."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "study-generated data collection"
              }
            ]
          },
          {
            "code" : "SEVCO:01026",
            "display" : "real world data collection",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the study data are obtained from a source of data collected during a routine process in the natural environment rather than using a process designed or controlled by the researcher."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection"
              }
            ]
          },
          {
            "code" : "SEVCO:01039",
            "display" : "real world data collection from healthcare records",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Real world data collection from data obtained routinely for a purpose of recording healthcare delivery in a record controlled by a healthcare professional."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection from clinical care records"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD from health care records"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD from healthcare delivery records"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "real world data collection from medical records"
              }
            ]
          },
          {
            "code" : "SEVCO:01050",
            "display" : "real world data collection from personal health records",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Real world data collection from data obtained routinely for a purpose of recording data related to personal health in a record controlled by the person, guardian, or caretaker."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "real world data collection from personal care records"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection from personal medical records"
              }
            ]
          },
          {
            "code" : "SEVCO:01040",
            "display" : "real world data collection from healthcare financing records",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Real world data collection from data obtained routinely for a purpose of recording healthcare financing."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection from healthcare financing records"
              }
            ]
          },
          {
            "code" : "SEVCO:01048",
            "display" : "real world data collection from testing procedures",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Real world data collection from data obtained routinely for a purpose of testing, such as diagnostic testing or screening examination."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection from testing procedures"
              }
            ]
          },
          {
            "code" : "SEVCO:01046",
            "display" : "real world data collection from monitoring procedures",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "Real world data collection from data obtained routinely for a purpose of repeated testing."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "RWD collection from monitoring procedures"
              }
            ]
          },
          {
            "code" : "SEVCO:01049",
            "display" : "secondary data collection from prior research",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the data are collected from data obtained during a different study than the current study."
              }
            ]
          },
          {
            "code" : "SEVCO:01042",
            "display" : "secondary data collection from a registry",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the data are collected from a system organized to obtain and maintain uniform data for discovery and analysis, and this system is organized prior to the current study."
              }
            ]
          },
          {
            "code" : "SEVCO:01051",
            "display" : "multisite data collection",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which data are collected from two or more geographic locations."
              }
            ]
          },
          {
            "code" : "SEVCO:01086",
            "display" : "quantitative analysis",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which data are analyzed with mathematical or statistical methods and formulas."
              }
            ]
          },
          {
            "code" : "SEVCO:01087",
            "display" : "qualitative analysis",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which data are analyzed, without primary reliance on mathematical or statistical techniques, by coding and organizing data to provide interpretation or understanding of experiences or hypotheses."
              }
            ]
          },
          {
            "code" : "SEVCO:01060",
            "display" : "blinding of study participants",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which study participants are not informed of their intervention assignment."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of study participants"
              }
            ]
          },
          {
            "code" : "SEVCO:01061",
            "display" : "blinding of intervention providers",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the people administering the intervention are not informed of the intervention assignment."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of intervention providers"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "blinding of intervention deliverers"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of intervention deliverers"
              }
            ]
          },
          {
            "code" : "SEVCO:01062",
            "display" : "blinding of outcome assessors",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the people determining the outcome are not informed of the intervention assignment."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of outcome assessors"
              }
            ]
          },
          {
            "code" : "SEVCO:01063",
            "display" : "blinding of data analysts",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which the people managing or processing the data and statistical analysis are not informed of the intervention assignment."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of data analysts"
              }
            ]
          },
          {
            "code" : "SEVCO:01064",
            "display" : "allocation concealment",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design process in which all parties influencing study enrollment and allocation to study groups are unaware of the group assignment for the study participant at the time of enrollment and allocation."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "blinding of randomization assignment"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "masking of randomization assignment"
              }
            ]
          },
          {
            "code" : "SEVCO:01043",
            "display" : "multicentric",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which two or more institutions are responsible for the conduct of the study."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "multi-institutional study"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "multicenter trial"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "multicenter study"
              }
            ]
          },
          {
            "code" : "SEVCO:01052",
            "display" : "includes patient-reported outcome",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which one or more outcomes are reported directly from the patient without interpretation by a clinician or researcher."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes patient-reported outcomes"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "PRO"
              }
            ]
          },
          {
            "code" : "SEVCO:01053",
            "display" : "includes patient-centered outcome",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which one or more measures are outcomes that patients directly care about, i.e. outcomes that are directly related to patients' experience of their life."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes patient-oriented outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes patient-important outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes patient-relevant outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes clinical outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes patient-centered outcome measure"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes clinical outcome measure"
              }
            ]
          },
          {
            "code" : "SEVCO:01054",
            "display" : "includes disease-oriented outcome",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which one or more measures are outcomes that relate to a health or illness condition but are not outcomes which patients directly care about."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes disease-oriented outcome measure"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes surrogate outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes surrogate outcome measure"
              }
            ]
          },
          {
            "code" : "SEVCO:01085",
            "display" : "includes process measure",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which one or more outcomes are actions or behaviors of a healthcare professional or care team."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes process outcome"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "includes process outcome measure"
              }
            ]
          },
          {
            "code" : "SEVCO:01089",
            "display" : "study goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature specifying the intent of the study."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "study aim"
              }
            ]
          },
          {
            "code" : "SEVCO:01096",
            "display" : "evaluation goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal to assess the efficiency, effectiveness, and impact of a given program, process, person or piece of equipment."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "evaluation study goal"
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "evaluation aim"
              }
            ]
          },
          {
            "code" : "SEVCO:01097",
            "display" : "derivation goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal with the intent to generate a predictive algorithm."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "derivation study goal"
              }
            ]
          },
          {
            "code" : "SEVCO:01098",
            "display" : "validation goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal with the intent to determine the reliability and/or performance of a procedure for a specific predictive, classification, measurement, or communication purpose."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "validation study goal"
              }
            ]
          },
          {
            "code" : "SEVCO:01088",
            "display" : "comparison goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which the study intent is to compare two or more interventions or exposures."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "comparative analysis goal"
              }
            ]
          },
          {
            "code" : "SEVCO:01091",
            "display" : "comparative effectiveness goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which the study intent is to compare two or more interventions with respect to benefits and/or harms."
              }
            ]
          },
          {
            "code" : "SEVCO:01090",
            "display" : "comparative efficacy goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which the study intent is to compare two or more interventions with respect to effectiveness in ideal conditions."
              }
            ]
          },
          {
            "code" : "SEVCO:01092",
            "display" : "comparative safety goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature in which the study intent is to compare two or more interventions with respect to harms."
              }
            ]
          },
          {
            "code" : "SEVCO:01093",
            "display" : "equivalence goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal with the intent to compare two or more interventions or exposures and determine that any difference in effects is within a prespecified range representing absence of a meaningful difference."
              }
            ]
          },
          {
            "code" : "SEVCO:01094",
            "display" : "non-inferiority goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal with the intent to compare two or more interventions or exposures and determine that any difference in effects is below a prespecified value representing a threshold between a meaningful difference and absence of a meaningful difference."
              }
            ]
          },
          {
            "code" : "SEVCO:01095",
            "display" : "superiority goal",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study goal with the intent to compare two or more interventions or exposures and detect a difference in effects."
              },
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym (core metadata concept)"
                },
                "value" : "superiority study goal"
              }
            ]
          },
          {
            "code" : "SEVCO:01100",
            "display" : "allocation ratio",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition (core metadata concept)"
                },
                "value" : "A study design feature describing the intended relative proportion of assignment across groups."
              }
            ]
          }
        ]
      }
    ]
  }
}

```
