# SNOMED International Global Patient Set (GPS) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SNOMED International Global Patient Set (GPS)**

## ValueSet: SNOMED International Global Patient Set (GPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/snomed-intl-gps | *Version*:20200930 | |
| Active as of 2021-06-05 | *Responsible:*[Health Level Seven International](http://www.hl7.org) | *Computable Name*:SnomedIntlGps |
| **Copyright/Legal**: The GPS is produced by SNOMED International under the terms of the [Creative Commons Attribution 4.0 International Public License](https://creativecommons.org/licenses/by/4.0/)Additional information about this license specific to SNOMED International’s release of the GPS:* SNOMED CT is © and ® SNOMED International. The right to maintain the GPS remains vested exclusively in SNOMED International.
* The Licensee can redistribute the GPS.
* The Licensee can create derivatives or implementation-related products and services based on the GPS.
* The Licensee cannot claim that SNOMED International or any of its Members endorses the Licensee’s derivative because it uses content from the GPS.
* Neither SNOMED International nor any of the contributors accept any liability for the Licensee’s use or redistribution of the GPS.
* SNOMED CT® was originally created by the College of American Pathologists.
Without obtaining prior written permission from SNOMED International, you are expressly prohibited from using, distributing or reproducing the SNOMED International, SNOMED CT or SNOMED GPS logo, service mark or trademark. Please review all terms and conditions of use [here](http://www.snomed.org/terms-and-conditions). | | |

 
SNOMED International Global Patient Set (GPS) value set. The value set includes all of the codes from the SNOMED International Global Patient Set (GPS) subset of SNOMED CT. The current version of the value set contains all concepts (26,158) from the September 2020 release of the GPS (based on the July 2020 SNOMED CT International Edition release). 
This value set is provided as a FHIR ValueSet resource instance for the convenience of implementers. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Definition

This value set has a large enumerated (extensional) definition which is not described here.

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "snomed-intl-gps",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://terminology.hl7.org/ValueSet/snomed-intl-gps",
  "version" : "20200930",
  "name" : "SnomedIntlGps",
  "title" : "SNOMED International Global Patient Set (GPS)",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-06-05",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "SNOMED International Global Patient Set (GPS) value set.    The value set includes all of the codes from the SNOMED International Global Patient Set (GPS)    subset of SNOMED CT.  The current version of the value set contains all concepts (26,158) from    the September 2020 release of the GPS (based on the July 2020 SNOMED CT International Edition    release).   \n\n   This value set is provided as a FHIR ValueSet resource instance for the convenience of implementers.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "The GPS is produced by SNOMED International under the terms of the [Creative Commons Attribution 4.0 International Public License](https://creativecommons.org/licenses/by/4.0/)\n\nAdditional information about this license specific to SNOMED International’s release of the GPS:\n* SNOMED CT is © and ® SNOMED International. The right to maintain the GPS remains vested exclusively in SNOMED International.\n* The Licensee can redistribute the GPS.\n* The Licensee can create derivatives or implementation-related products and services based on the GPS.\n* The Licensee cannot claim that SNOMED International or any of its Members endorses the Licensee’s derivative because it uses content from the GPS.\n* Neither SNOMED International nor any of the contributors accept any liability for the Licensee’s use or redistribution of the GPS.\n* SNOMED CT® was originally created by the College of American Pathologists.\n\nWithout obtaining prior written permission from SNOMED International, you are expressly prohibited from using, distributing or reproducing the SNOMED International, SNOMED CT or SNOMED GPS logo, service mark or trademark. Please review all terms and conditions of use [here](http://www.snomed.org/terms-and-conditions).",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/900000000000207008/version/20200731",
        "concept" : [
          {
            "code" : "109006",
            "display" : "Anxiety disorder of childhood OR adolescence (disorder)"
          },
          {
            "code" : "111002",
            "display" : "Parathyroid structure (body structure)"
          },
          {
            "code" : "125001",
            "display" : "Ferrous (59-Fe) sulfate (substance)"
          },
          {
            "code" : "140004",
            "display" : "Chronic pharyngitis (disorder)"
          },
          {
            "code" : "187006",
            "display" : "Cyanocobalamin (57-Co) (substance)"
          },
          {
            "code" : "219006",
            "display" : "Current drinker of alcohol (finding)"
          },
          {
            "code" : "252000",
            "display" : "Acinetobacter johnsonii (organism)"
          },
          {
            "code" : "270002",
            "display" : "Female first cousin (person)"
          },
          {
            "code" : "271003",
            "display" : "Bone plate, device (physical object)"
          },
          {
            "code" : "281004",
            "display" : "Dementia associated with alcoholism (disorder)"
          },
          {
            "code" : "283001",
            "display" : "Structure of central axillary lymph node (body structure)"
          },
          {
            "code" : "286009",
            "display" : "Czech (ethnic group)"
          },
          {
            "code" : "290006",
            "display" : "Melnick-Fraser syndrome (disorder)"
          },
          {
            "code" : "297009",
            "display" : "Acute myringitis (disorder)"
          },
          {
            "code" : "300004",
            "display" : "Miniature schnauzer (organism)"
          },
          {
            "code" : "315003",
            "display" : "Skin structure of umbilicus (body structure)"
          },
          {
            "code" : "317006",
            "display" : "Reactive hypoglycemia (disorder)"
          },
          {
            "code" : "330007",
            "display" : "Occipital headache (finding)"
          },
          {
            "code" : "345000",
            "display" : "Atrioventricular bundle structure (body structure)"
          },
          {
            "code" : "359007",
            "display" : "Kernicterus due to isoimmunization (disorder)"
          },
          {
            "code" : "368009",
            "display" : "Heart valve disorder (disorder)"
          },
          {
            "code" : "385006",
            "display" : "Secondary peripheral neuropathy (disorder)"
          },
          {
            "code" : "400003",
            "display" : "Pinzgauer cattle breed (organism)"
          },
          {
            "code" : "409002",
            "display" : "Food allergy diet (finding)"
          },
          {
            "code" : "432003",
            "display" : "Carminic acid stain (substance)"
          },
          {
            "code" : "439007",
            "display" : "Therapeutic radioisotope (product)"
          },
          {
            "code" : "461002",
            "display" : "Structure of lateral corticospinal tract (body structure)"
          },
          {
            "code" : "485005",
            "display" : "Transverse colon structure (body structure)"
          },
          {
            "code" : "507002",
            "display" : "Standard poodle (organism)"
          },
          {
            "code" : "524008",
            "display" : "Multifocal (qualifier value)"
          },
          {
            "code" : "548004",
            "display" : "13p partial trisomy syndrome (disorder)"
          },
          {
            "code" : "563001",
            "display" : "Nystagmus (disorder)"
          },
          {
            "code" : "568005",
            "display" : "Tic disorder (disorder)"
          },
          {
            "code" : "583000",
            "display" : "Wirehaired vizsla (organism)"
          },
          {
            "code" : "589001",
            "display" : "Interventricular septum structure (body structure)"
          },
          {
            "code" : "596004",
            "display" : "Premenstrual dysphoric disorder (disorder)"
          },
          {
            "code" : "606003",
            "display" : "Terrier (organism)"
          },
          {
            "code" : "638008",
            "display" : "Legionella oakridgensis (organism)"
          },
          {
            "code" : "661005",
            "display" : "Jaw region structure (body structure)"
          },
          {
            "code" : "684003",
            "display" : "Pygmy goat (organism)"
          },
          {
            "code" : "739006",
            "display" : "Bicycle ergometer, device (physical object)"
          },
          {
            "code" : "774007",
            "display" : "Structure of head and/or neck (body structure)"
          },
          {
            "code" : "787001",
            "display" : "Rheumatic mitral stenosis with regurgitation (disorder)"
          },
          {
            "code" : "788006",
            "display" : "Disease-related diet (finding)"
          },
          {
            "code" : "792004",
            "display" : "Jakob-Creutzfeldt disease (disorder)"
          },
          {
            "code" : "795002",
            "display" : "Deep (qualifier value)"
          },
          {
            "code" : "796001",
            "display" : "Product containing digoxin (medicinal product)"
          },
          {
            "code" : "805002",
            "display" : "Pneumoconiosis caused by silica (disorder)"
          },
          {
            "code" : "811004",
            "display" : "Flail motion (finding)"
          },
          {
            "code" : "813001",
            "display" : "Ankle instability (finding)"
          },
          {
            "code" : "815008",
            "display" : "Episcleritis (disorder)"
          },
          {
            "code" : "832007",
            "display" : "Moderate major depression (disorder)"
          },
          {
            "code" : "834008",
            "display" : "Chair-seated facing coital position (finding)"
          },
          {
            "code" : "865004",
            "display" : "Hyperalimentation formula for ileus (finding)"
          },
          {
            "code" : "873008",
            "display" : "Urethan (substance)"
          },
          {
            "code" : "891003",
            "display" : "Suicide by self-administered drug (event)"
          },
          {
            "code" : "909007",
            "display" : "Mycobacterium parafortuitum (organism)"
          },
          {
            "code" : "919001",
            "display" : "Pseudohomosexual state (finding)"
          },
          {
            "code" : "925002",
            "display" : "Sodium iodipamide (substance)"
          },
          {
            "code" : "932006",
            "display" : "Flat affect (finding)"
          },
          {
            "code" : "944009",
            "display" : "Brown Welsh cattle breed (organism)"
          },
          {
            "code" : "955009",
            "display" : "Bronchial structure (body structure)"
          },
          {
            "code" : "965003",
            "display" : "Toxic amblyopia (disorder)"
          },
          {
            "code" : "967006",
            "display" : "Medication education (procedure)"
          },
          {
            "code" : "976004",
            "display" : "Structure of ovarian vein (body structure)"
          },
          {
            "code" : "1006005",
            "display" : "Percheron horse (organism)"
          },
          {
            "code" : "1023001",
            "display" : "Apnea (finding)"
          },
          {
            "code" : "1048003",
            "display" : "Capillary specimen collection (procedure)"
          },
          {
            "code" : "1055001",
            "display" : "Stenosis of precerebral artery (disorder)"
          },
          {
            "code" : "1085006",
            "display" : "Candidiasis of vulva (disorder)"
          },
          {
            "code" : "1101003",
            "display" : "Cranial cavity structure (body structure)"
          },
          {
            "code" : "1107004",
            "display" : "Early latent syphilis, positive serology, negative cerebrospinal fluid, with relapse after treatment (disorder)"
          },
          {
            "code" : "1118004",
            "display" : "Viking horse (organism)"
          },
          {
            "code" : "1145003",
            "display" : "Developmental speech disorder (disorder)"
          },
          {
            "code" : "1166006",
            "display" : "Titanium (substance)"
          },
          {
            "code" : "1182007",
            "display" : "Hypotensive agent (product)"
          },
          {
            "code" : "1193009",
            "display" : "Structure of teres major muscle (body structure)"
          },
          {
            "code" : "1194003",
            "display" : "Disease condition determination, well controlled (finding)"
          },
          {
            "code" : "1201005",
            "display" : "Benign essential hypertension (disorder)"
          },
          {
            "code" : "1202003",
            "display" : "Mastication (observable entity)"
          },
          {
            "code" : "1210002",
            "display" : "Struck by falling lumber (event)"
          },
          {
            "code" : "1211003",
            "display" : "Treadmill, device (physical object)"
          },
          {
            "code" : "1231004",
            "display" : "Meninges structure (body structure)"
          },
          {
            "code" : "1239002",
            "display" : "Congenital anteversion of femur (disorder)"
          },
          {
            "code" : "1240000",
            "display" : "Prone body position (finding)"
          },
          {
            "code" : "1247002",
            "display" : "Clydesdale horse (organism)"
          },
          {
            "code" : "1250004",
            "display" : "Decreased (qualifier value)"
          },
          {
            "code" : "1261007",
            "display" : "Fracture of multiple ribs (disorder)"
          },
          {
            "code" : "1290001",
            "display" : "Mycoplasma hominis (organism)"
          },
          {
            "code" : "1305003",
            "display" : "Double (qualifier value)"
          },
          {
            "code" : "1307006",
            "display" : "Glottis structure (body structure)"
          },
          {
            "code" : "1335005",
            "display" : "Induratio penis plastica (disorder)"
          },
          {
            "code" : "1340002",
            "display" : "Malays (ethnic group)"
          },
          {
            "code" : "1346008",
            "display" : "Blue shade eosin stain (substance)"
          },
          {
            "code" : "1366004",
            "display" : "Inhalation therapy procedure (procedure)"
          },
          {
            "code" : "1368003",
            "display" : "Iodine-131 (substance)"
          },
          {
            "code" : "1376001",
            "display" : "Obsessive compulsive personality disorder (disorder)"
          },
          {
            "code" : "1380006",
            "display" : "Agoraphobia without history of panic disorder with limited symptom attacks (disorder)"
          },
          {
            "code" : "1386000",
            "display" : "Intracranial hemorrhage (disorder)"
          },
          {
            "code" : "1402001",
            "display" : "Fear (finding)"
          },
          {
            "code" : "1415005",
            "display" : "Lymphangitis (disorder)"
          },
          {
            "code" : "1420005",
            "display" : "German longhaired pointer (organism)"
          },
          {
            "code" : "1439000",
            "display" : "Structure of paravesicular lymph node (body structure)"
          },
          {
            "code" : "1451003",
            "display" : "Greeks (ethnic group)"
          },
          {
            "code" : "1475003",
            "display" : "Herpes labialis (disorder)"
          },
          {
            "code" : "1482004",
            "display" : "Cyst of meibomian gland (disorder)"
          },
          {
            "code" : "1483009",
            "display" : "Angular (qualifier value)"
          },
          {
            "code" : "1489008",
            "display" : "Hordeolum externum (disorder)"
          },
          {
            "code" : "1507005",
            "display" : "Mycobacterium kansasii (organism)"
          },
          {
            "code" : "1514007",
            "display" : "Bedlington terrier (organism)"
          },
          {
            "code" : "1522000",
            "display" : "Plaque (morphologic abnormality)"
          },
          {
            "code" : "1532007",
            "display" : "Viral pharyngitis (disorder)"
          },
          {
            "code" : "1539003",
            "display" : "Acquired trigger finger (disorder)"
          },
          {
            "code" : "1542009",
            "display" : "Omphalocele with obstruction (disorder)"
          },
          {
            "code" : "1563006",
            "display" : "Protein S deficiency disease (disorder)"
          },
          {
            "code" : "1658003",
            "display" : "Closed fracture of acromial end of clavicle (disorder)"
          },
          {
            "code" : "1663004",
            "display" : "G2 grade (finding)"
          },
          {
            "code" : "1679003",
            "display" : "Arthritis associated with another disorder (disorder)"
          },
          {
            "code" : "1686006",
            "display" : "Sedative, hypnotic AND/OR anxiolytic-induced anxiety disorder (disorder)"
          },
          {
            "code" : "1705000",
            "display" : "Closed fracture of base of neck of femur (disorder)"
          },
          {
            "code" : "1710001",
            "display" : "Uric acid (substance)"
          },
          {
            "code" : "1732005",
            "display" : "Thoracic duct structure (body structure)"
          },
          {
            "code" : "1742007",
            "display" : "Female hypererotism (finding)"
          },
          {
            "code" : "1748006",
            "display" : "Thrombophlebitis of deep femoral vein (disorder)"
          },
          {
            "code" : "1755008",
            "display" : "Old myocardial infarction (disorder)"
          },
          {
            "code" : "1759002",
            "display" : "Assessment of nutritional status (procedure)"
          },
          {
            "code" : "1761006",
            "display" : "Biliary cirrhosis (disorder)"
          },
          {
            "code" : "1776003",
            "display" : "Renal tubular acidosis (disorder)"
          },
          {
            "code" : "1789009",
            "display" : "Trakehner horse (organism)"
          },
          {
            "code" : "1807002",
            "display" : "Forceps delivery failed (situation)"
          },
          {
            "code" : "1809004",
            "display" : "Rex cat breed (organism)"
          },
          {
            "code" : "1816003",
            "display" : "Panic disorder with agoraphobia, severe agoraphobic avoidance AND mild panic attacks (disorder)"
          },
          {
            "code" : "1829003",
            "display" : "Microcephalus (disorder)"
          },
          {
            "code" : "1847009",
            "display" : "Endophthalmitis (disorder)"
          },
          {
            "code" : "1855002",
            "display" : "Developmental academic disorder (disorder)"
          },
          {
            "code" : "1857005",
            "display" : "Congenital rubella syndrome (disorder)"
          },
          {
            "code" : "1860003",
            "display" : "Fluid volume disorder (disorder)"
          },
          {
            "code" : "1881003",
            "display" : "Increased nutritional requirement (finding)"
          },
          {
            "code" : "1896004",
            "display" : "Ectopic breast tissue (disorder)"
          },
          {
            "code" : "1902009",
            "display" : "Skin structure of ear (body structure)"
          },
          {
            "code" : "1910005",
            "display" : "Entire ear (body structure)"
          },
          {
            "code" : "1912002",
            "display" : "Fall (event)"
          },
          {
            "code" : "1918003",
            "display" : "Structure of suprarenal aorta (body structure)"
          },
          {
            "code" : "1919006",
            "display" : "Egyptians (ethnic group)"
          },
          {
            "code" : "1929004",
            "display" : "Non-Hodgkin lymphoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "1963002",
            "display" : "Paroxysmal nocturnal hemoglobinuria (disorder)"
          },
          {
            "code" : "1974006",
            "display" : "Retriever (organism)"
          },
          {
            "code" : "1985008",
            "display" : "Vomitus (substance)"
          },
          {
            "code" : "1993008",
            "display" : "Operation of a transportation device, function (observable entity)"
          },
          {
            "code" : "2008008",
            "display" : "Gallium-67 (substance)"
          },
          {
            "code" : "2032001",
            "display" : "Cerebral edema (disorder)"
          },
          {
            "code" : "2043009",
            "display" : "Alcoholic gastritis (disorder)"
          },
          {
            "code" : "2048000",
            "display" : "Lingual tonsil structure (body structure)"
          },
          {
            "code" : "2055003",
            "display" : "Recurrent erosion of cornea (disorder)"
          },
          {
            "code" : "2059009",
            "display" : "Skin structure of ear lobule (body structure)"
          },
          {
            "code" : "2062007",
            "display" : "Dachshund superbreed of dog (organism)"
          },
          {
            "code" : "2070002",
            "display" : "Burning sensation in eye (finding)"
          },
          {
            "code" : "2073000",
            "display" : "Delusions (finding)"
          },
          {
            "code" : "2088005",
            "display" : "Page blue G-90 stain (substance)"
          },
          {
            "code" : "2089002",
            "display" : "Osteitis deformans (disorder)"
          },
          {
            "code" : "2092003",
            "display" : "Malignant melanoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "2095001",
            "display" : "Nasal sinus structure (body structure)"
          },
          {
            "code" : "2099007",
            "display" : "Hemangioma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "2109003",
            "display" : "Isolated somatotropin deficiency (disorder)"
          },
          {
            "code" : "2124007",
            "display" : "Rambouillet sheep (organism)"
          },
          {
            "code" : "2145000",
            "display" : "Anal penetration (finding)"
          },
          {
            "code" : "2159007",
            "display" : "Azorubin S stain (substance)"
          },
          {
            "code" : "2160002",
            "display" : "Structure of ligamentum arteriosum (body structure)"
          },
          {
            "code" : "2177002",
            "display" : "Postherpetic neuralgia (disorder)"
          },
          {
            "code" : "2237002",
            "display" : "Pleuritic pain (finding)"
          },
          {
            "code" : "2268003",
            "display" : "Victim of homosexual aggression (finding)"
          },
          {
            "code" : "2272004",
            "display" : "Half-sister (person)"
          },
          {
            "code" : "2282003",
            "display" : "Prosthetic breast implant (physical object)"
          },
          {
            "code" : "2304001",
            "display" : "Discitis (disorder)"
          },
          {
            "code" : "2309006",
            "display" : "Gold (substance)"
          },
          {
            "code" : "2314005",
            "display" : "Unprotected sexual intercourse (finding)"
          },
          {
            "code" : "2321005",
            "display" : "Delivery by Ritgen maneuver (procedure)"
          },
          {
            "code" : "2334006",
            "display" : "Structure of calyx (body structure)"
          },
          {
            "code" : "2339001",
            "display" : "Sexual overexposure (finding)"
          },
          {
            "code" : "2400006",
            "display" : "Structure of permanent mandibular left first premolar tooth (body structure)"
          },
          {
            "code" : "2403008",
            "display" : "Psychoactive substance dependence (disorder)"
          },
          {
            "code" : "2415007",
            "display" : "Lumbosacral radiculopathy (disorder)"
          },
          {
            "code" : "2423009",
            "display" : "Chikungunya virus (organism)"
          },
          {
            "code" : "2424003",
            "display" : "Sarcoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "2435008",
            "display" : "Ascariasis (disorder)"
          },
          {
            "code" : "2472002",
            "display" : "Anuria (finding)"
          },
          {
            "code" : "2477008",
            "display" : "Superficial thrombophlebitis (disorder)"
          },
          {
            "code" : "2492009",
            "display" : "Nutritional disorder (disorder)"
          },
          {
            "code" : "2506003",
            "display" : "Early onset dysthymia (disorder)"
          },
          {
            "code" : "2528003",
            "display" : "Viremia (finding)"
          },
          {
            "code" : "2556008",
            "display" : "Periodontal disease (disorder)"
          },
          {
            "code" : "2576002",
            "display" : "Trachoma (disorder)"
          },
          {
            "code" : "2606006",
            "display" : "Furuncle of perineum (disorder)"
          },
          {
            "code" : "2615004",
            "display" : "Follicular cyst of ovary (disorder)"
          },
          {
            "code" : "2617007",
            "display" : "Fall from scaffold (event)"
          },
          {
            "code" : "2622007",
            "display" : "Infected ulcer of skin (disorder)"
          },
          {
            "code" : "2651006",
            "display" : "Closed traumatic dislocation of elbow joint (disorder)"
          },
          {
            "code" : "2667000",
            "display" : "Absent (qualifier value)"
          },
          {
            "code" : "2688009",
            "display" : "Tristan da Cunhans (ethnic group)"
          },
          {
            "code" : "2705002",
            "display" : "Arsenic-72 (substance)"
          },
          {
            "code" : "2720008",
            "display" : "Hututu (ethnic group)"
          },
          {
            "code" : "2733002",
            "display" : "Heel pain (finding)"
          },
          {
            "code" : "2739003",
            "display" : "Endometrial structure (body structure)"
          },
          {
            "code" : "2748008",
            "display" : "Spinal cord structure (body structure)"
          },
          {
            "code" : "2776000",
            "display" : "Delirium (disorder)"
          },
          {
            "code" : "2785000",
            "display" : "Genus Enterococcus (organism)"
          },
          {
            "code" : "2799001",
            "display" : "Methylbenzethonium chloride (substance)"
          },
          {
            "code" : "2812003",
            "display" : "Structure of head of femur (body structure)"
          },
          {
            "code" : "2815001",
            "display" : "Sexual pyromania (disorder)"
          },
          {
            "code" : "2841007",
            "display" : "Structure of renal artery (body structure)"
          },
          {
            "code" : "2852001",
            "display" : "Bhutanese (ethnic group)"
          },
          {
            "code" : "2858002",
            "display" : "Puerperal sepsis (disorder)"
          },
          {
            "code" : "2861001",
            "display" : "Entire gland (organ) (body structure)"
          },
          {
            "code" : "2864009",
            "display" : "Rotavirus group E (organism)"
          },
          {
            "code" : "2869004",
            "display" : "Acetic acid (substance)"
          },
          {
            "code" : "2897005",
            "display" : "Immune thrombocytopenia (disorder)"
          },
          {
            "code" : "2901004",
            "display" : "Melena (disorder)"
          },
          {
            "code" : "2904007",
            "display" : "Male infertility (disorder)"
          },
          {
            "code" : "2910007",
            "display" : "Discharge from penis (finding)"
          },
          {
            "code" : "2929001",
            "display" : "Occlusion of artery (disorder)"
          },
          {
            "code" : "2942001",
            "display" : "Carbon (14-C) xylose (substance)"
          },
          {
            "code" : "2985005",
            "display" : "Paget's disease, mammary (morphologic abnormality)"
          },
          {
            "code" : "2999009",
            "display" : "Injury of ear (disorder)"
          },
          {
            "code" : "3006004",
            "display" : "Disturbance of consciousness (finding)"
          },
          {
            "code" : "3027009",
            "display" : "Barium-133 (substance)"
          },
          {
            "code" : "3040004",
            "display" : "Technetium (99m-Tc) disofenin (substance)"
          },
          {
            "code" : "3058005",
            "display" : "Peripheral nervous system structure (body structure)"
          },
          {
            "code" : "3092008",
            "display" : "Staphylococcus aureus (organism)"
          },
          {
            "code" : "3099004",
            "display" : "Romney marsh sheep (organism)"
          },
          {
            "code" : "3110003",
            "display" : "Acute otitis media (disorder)"
          },
          {
            "code" : "3120008",
            "display" : "Pleural membrane structure (body structure)"
          },
          {
            "code" : "3128001",
            "display" : "Legionella israelensis (organism)"
          },
          {
            "code" : "3133002",
            "display" : "Patient discharge, deceased, autopsy (procedure)"
          },
          {
            "code" : "3135009",
            "display" : "Otitis externa (disorder)"
          },
          {
            "code" : "3158007",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in partial remission AND panic attacks in partial remission (disorder)"
          },
          {
            "code" : "3159004",
            "display" : "Structure of costocervical trunk (body structure)"
          },
          {
            "code" : "3194006",
            "display" : "Endocardium of right atrium (body structure)"
          },
          {
            "code" : "3199001",
            "display" : "Sprain of shoulder (disorder)"
          },
          {
            "code" : "3200003",
            "display" : "Sacrocoxalgia (finding)"
          },
          {
            "code" : "3216001",
            "display" : "Lincoln red cattle breed (organism)"
          },
          {
            "code" : "3218000",
            "display" : "Mycosis (disorder)"
          },
          {
            "code" : "3227004",
            "display" : "Left coronary artery main stem (body structure)"
          },
          {
            "code" : "3228009",
            "display" : "Closed fracture of shaft of radius (disorder)"
          },
          {
            "code" : "3236000",
            "display" : "Structure of posterior segment of right upper lobe of lung (body structure)"
          },
          {
            "code" : "3238004",
            "display" : "Pericarditis (disorder)"
          },
          {
            "code" : "3243006",
            "display" : "Structure of parametrial lymph node (body structure)"
          },
          {
            "code" : "3253007",
            "display" : "Discoloration of skin (finding)"
          },
          {
            "code" : "3260001",
            "display" : "Duroc pig (organism)"
          },
          {
            "code" : "3282008",
            "display" : "Welders' keratitis (disorder)"
          },
          {
            "code" : "3289004",
            "display" : "Anisometropia (disorder)"
          },
          {
            "code" : "3291007",
            "display" : "Closed fracture of two ribs (disorder)"
          },
          {
            "code" : "3305006",
            "display" : "Disorder of lymphatic vessel (disorder)"
          },
          {
            "code" : "3321001",
            "display" : "Renal abscess (disorder)"
          },
          {
            "code" : "3325005",
            "display" : "Lipopolysaccharide (substance)"
          },
          {
            "code" : "3345002",
            "display" : "Idiopathic osteoporosis (disorder)"
          },
          {
            "code" : "3347005",
            "display" : "Dandie Dinmont terrier (organism)"
          },
          {
            "code" : "3351007",
            "display" : "Genus Anaplasma (organism)"
          },
          {
            "code" : "3353005",
            "display" : "Pueblo (ethnic group)"
          },
          {
            "code" : "3354004",
            "display" : "Havana brown cat (organism)"
          },
          {
            "code" : "3415004",
            "display" : "Cyanosis (finding)"
          },
          {
            "code" : "3418002",
            "display" : "Chondrectomy of spine (procedure)"
          },
          {
            "code" : "3424008",
            "display" : "Tachycardia (finding)"
          },
          {
            "code" : "3430008",
            "display" : "Radiation therapist (occupation)"
          },
          {
            "code" : "3457005",
            "display" : "Patient referral (procedure)"
          },
          {
            "code" : "3468005",
            "display" : "Neonatal infective mastitis (disorder)"
          },
          {
            "code" : "3502005",
            "display" : "Cervical lymphadenitis (disorder)"
          },
          {
            "code" : "3515001",
            "display" : "Replacement of electronic heart device, pulse generator (procedure)"
          },
          {
            "code" : "3528008",
            "display" : "Restricted carbohydrate fat controlled diet (finding)"
          },
          {
            "code" : "3545003",
            "display" : "Diastolic dysfunction (finding)"
          },
          {
            "code" : "3548001",
            "display" : "Brachial plexus disorder (disorder)"
          },
          {
            "code" : "3566006",
            "display" : "Southdown sheep (organism)"
          },
          {
            "code" : "3577000",
            "display" : "Retinal lattice degeneration (disorder)"
          },
          {
            "code" : "3583002",
            "display" : "Caudal (qualifier value)"
          },
          {
            "code" : "3589003",
            "display" : "Syphilitic pericarditis (disorder)"
          },
          {
            "code" : "3653002",
            "display" : "Balinese cat (organism)"
          },
          {
            "code" : "3674001",
            "display" : "Siberian huskie (organism)"
          },
          {
            "code" : "3677008",
            "display" : "Academic problem (finding)"
          },
          {
            "code" : "3696007",
            "display" : "Nonulcer dyspepsia (disorder)"
          },
          {
            "code" : "3698008",
            "display" : "Micronesians (ethnic group)"
          },
          {
            "code" : "3699000",
            "display" : "Transverse deficiency of upper limb (disorder)"
          },
          {
            "code" : "3704008",
            "display" : "Diffuse endocapillary proliferative glomerulonephritis (disorder)"
          },
          {
            "code" : "3713005",
            "display" : "Release for de Quervain's tenosynovitis of hand (procedure)"
          },
          {
            "code" : "3716002",
            "display" : "Goiter (disorder)"
          },
          {
            "code" : "3723001",
            "display" : "Arthritis (disorder)"
          },
          {
            "code" : "3738000",
            "display" : "Viral hepatitis (disorder)"
          },
          {
            "code" : "3744001",
            "display" : "Hyperlipoproteinemia (disorder)"
          },
          {
            "code" : "3754002",
            "display" : "Dysplasia of vagina (disorder)"
          },
          {
            "code" : "3818007",
            "display" : "Senegalese (ethnic group)"
          },
          {
            "code" : "3829006",
            "display" : "Iron (substance)"
          },
          {
            "code" : "3839000",
            "display" : "Lipid-rich carcinoma (morphologic abnormality)"
          },
          {
            "code" : "3855007",
            "display" : "Disorder of pancreas (disorder)"
          },
          {
            "code" : "3885002",
            "display" : "ABO isoimmunization affecting pregnancy (disorder)"
          },
          {
            "code" : "3895009",
            "display" : "Application of dressing (procedure)"
          },
          {
            "code" : "3898006",
            "display" : "Neoplasm, benign (morphologic abnormality)"
          },
          {
            "code" : "3900008",
            "display" : "Mixed sensory-motor polyneuropathy (disorder)"
          },
          {
            "code" : "3903005",
            "display" : "Traumatic pneumothorax without open wound into thorax (disorder)"
          },
          {
            "code" : "3916005",
            "display" : "Structure of occipital lymph node (body structure)"
          },
          {
            "code" : "3921008",
            "display" : "Airedale terrier (organism)"
          },
          {
            "code" : "3924000",
            "display" : "Structure of pericardiophrenic artery (body structure)"
          },
          {
            "code" : "3932008",
            "display" : "Copper-64 (substance)"
          },
          {
            "code" : "3937002",
            "display" : "Structure of entorhinal cortex (body structure)"
          },
          {
            "code" : "3951002",
            "display" : "Proctitis (disorder)"
          },
          {
            "code" : "3954005",
            "display" : "Lacrimal sac structure (body structure)"
          },
          {
            "code" : "3960005",
            "display" : "Olfactory tract structure (body structure)"
          },
          {
            "code" : "3972004",
            "display" : "Primary insomnia (disorder)"
          },
          {
            "code" : "3974003",
            "display" : "Contact with sharp leaves (event)"
          },
          {
            "code" : "3995008",
            "display" : "Manx (organism)"
          },
          {
            "code" : "3997000",
            "display" : "Pony (organism)"
          },
          {
            "code" : "4009004",
            "display" : "Lower urinary tract infectious disease (disorder)"
          },
          {
            "code" : "4019005",
            "display" : "Structure of posterior commissure of labia majora (body structure)"
          },
          {
            "code" : "4042003",
            "display" : "Somali cat (organism)"
          },
          {
            "code" : "4046000",
            "display" : "Degenerative spondylolisthesis (disorder)"
          },
          {
            "code" : "4064007",
            "display" : "Specimen aliquoting (procedure)"
          },
          {
            "code" : "4073004",
            "display" : "Palauans (ethnic group)"
          },
          {
            "code" : "4082005",
            "display" : "Syphilitic myocarditis (disorder)"
          },
          {
            "code" : "4103001",
            "display" : "Complex partial seizure with impairment of consciousness (disorder)"
          },
          {
            "code" : "4106009",
            "display" : "Rotator cuff syndrome (disorder)"
          },
          {
            "code" : "4120002",
            "display" : "Bronchiolitis (disorder)"
          },
          {
            "code" : "4127004",
            "display" : "Prostatic obstruction (disorder)"
          },
          {
            "code" : "4147007",
            "display" : "Mass (morphologic abnormality)"
          },
          {
            "code" : "4199009",
            "display" : "18p partial trisomy syndrome (disorder)"
          },
          {
            "code" : "4210003",
            "display" : "Ocular hypertension (disorder)"
          },
          {
            "code" : "4223005",
            "display" : "Parkinsonism caused by drug (disorder)"
          },
          {
            "code" : "4241002",
            "display" : "Listeriosis (disorder)"
          },
          {
            "code" : "4258007",
            "display" : "Structure of posterior tibial vein (body structure)"
          },
          {
            "code" : "4264000",
            "display" : "Chronic pericoronitis (disorder)"
          },
          {
            "code" : "4273008",
            "display" : "Closed posterior dislocation of elbow (disorder)"
          },
          {
            "code" : "4298009",
            "display" : "Shigella sonnei (organism)"
          },
          {
            "code" : "4299001",
            "display" : "Marathas (ethnic group)"
          },
          {
            "code" : "4307007",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class F (disorder)"
          },
          {
            "code" : "4317002",
            "display" : "Structure of spinalis muscle (body structure)"
          },
          {
            "code" : "4322002",
            "display" : "Military field hospital (environment)"
          },
          {
            "code" : "4356008",
            "display" : "Gingival recession (disorder)"
          },
          {
            "code" : "4373005",
            "display" : "Clubbing of nail (disorder)"
          },
          {
            "code" : "4382004",
            "display" : "Centrally acting hypotensive agent (product)"
          },
          {
            "code" : "4386001",
            "display" : "Bronchospasm (finding)"
          },
          {
            "code" : "4406004",
            "display" : "Congenital anomaly of male genital system (disorder)"
          },
          {
            "code" : "4412009",
            "display" : "Injury of digital nerve (disorder)"
          },
          {
            "code" : "4432005",
            "display" : "Structure of ductus arteriosus (body structure)"
          },
          {
            "code" : "4447001",
            "display" : "Autopsy, gross and microscopic examination, stillborn or newborn without central nervous system (procedure)"
          },
          {
            "code" : "4473006",
            "display" : "Migraine with aura (disorder)"
          },
          {
            "code" : "4483005",
            "display" : "Syphilitic punched out ulcer (disorder)"
          },
          {
            "code" : "4506002",
            "display" : "Educational problem (finding)"
          },
          {
            "code" : "4512007",
            "display" : "Group sex play (finding)"
          },
          {
            "code" : "4521008",
            "display" : "Fall from cliff (event)"
          },
          {
            "code" : "4525004",
            "display" : "Emergency department patient visit (procedure)"
          },
          {
            "code" : "4550001",
            "display" : "Special infant formula (finding)"
          },
          {
            "code" : "4554005",
            "display" : "Intraventricular conduction defect (disorder)"
          },
          {
            "code" : "4556007",
            "display" : "Gastritis (disorder)"
          },
          {
            "code" : "4557003",
            "display" : "Preinfarction syndrome (disorder)"
          },
          {
            "code" : "4563007",
            "display" : "Hospital admission, transfer from other hospital or health care facility (procedure)"
          },
          {
            "code" : "4568003",
            "display" : "Retrosternal pain (finding)"
          },
          {
            "code" : "4574003",
            "display" : "Shropshire sheep (organism)"
          },
          {
            "code" : "4578000",
            "display" : "Skin structure of posterior surface of thigh (body structure)"
          },
          {
            "code" : "4596009",
            "display" : "Laryngeal structure (body structure)"
          },
          {
            "code" : "4598005",
            "display" : "Osteomalacia (disorder)"
          },
          {
            "code" : "4619009",
            "display" : "Generalized-onset seizures (disorder)"
          },
          {
            "code" : "4625008",
            "display" : "Apical pulse taking (procedure)"
          },
          {
            "code" : "4631006",
            "display" : "Tubular adenocarcinoma (morphologic abnormality)"
          },
          {
            "code" : "4649006",
            "display" : "Toxoplasma gondii (organism)"
          },
          {
            "code" : "4656000",
            "display" : "Alcian blue 8GX stain (substance)"
          },
          {
            "code" : "4658004",
            "display" : "Skin structure of nuchal region (body structure)"
          },
          {
            "code" : "4661003",
            "display" : "Calculus of bile duct with obstruction (disorder)"
          },
          {
            "code" : "4668009",
            "display" : "Genus Yersinia (organism)"
          },
          {
            "code" : "4683004",
            "display" : "Living condition (observable entity)"
          },
          {
            "code" : "4693006",
            "display" : "Chromium (51-Cr) albumin (substance)"
          },
          {
            "code" : "4711003",
            "display" : "Congenital anomaly of bile ducts (disorder)"
          },
          {
            "code" : "4716008",
            "display" : "Entamoeba histolytica (organism)"
          },
          {
            "code" : "4740000",
            "display" : "Herpes zoster (disorder)"
          },
          {
            "code" : "4751000",
            "display" : "Leisure physical activity (observable entity)"
          },
          {
            "code" : "4754008",
            "display" : "Gynecomastia (disorder)"
          },
          {
            "code" : "4770005",
            "display" : "Colporrhaphy for repair of urethrocele (procedure)"
          },
          {
            "code" : "4776004",
            "display" : "Lichen planus (disorder)"
          },
          {
            "code" : "4779006",
            "display" : "Cryptosporidium muris (organism)"
          },
          {
            "code" : "4787007",
            "display" : "Fetal or neonatal effect of breech delivery and extraction (disorder)"
          },
          {
            "code" : "4788002",
            "display" : "Closed fracture of zygoma (disorder)"
          },
          {
            "code" : "4800001",
            "display" : "Pyuria (finding)"
          },
          {
            "code" : "4821001",
            "display" : "Contusion of cheek (disorder)"
          },
          {
            "code" : "4832001",
            "display" : "Technetium (99m-Tc) mebrofenin (substance)"
          },
          {
            "code" : "4834000",
            "display" : "Typhoid fever (disorder)"
          },
          {
            "code" : "4851007",
            "display" : "Chronic endocarditis (disorder)"
          },
          {
            "code" : "4853005",
            "display" : "Dry coitus (finding)"
          },
          {
            "code" : "4854004",
            "display" : "Acquired hemolytic anemia (disorder)"
          },
          {
            "code" : "4855003",
            "display" : "Retinopathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "4886009",
            "display" : "Premature birth of newborn male (finding)"
          },
          {
            "code" : "4927003",
            "display" : "Acute anterior uveitis (disorder)"
          },
          {
            "code" : "4932002",
            "display" : "Panic disorder with agoraphobia, moderate agoraphobic avoidance AND mild panic attacks (disorder)"
          },
          {
            "code" : "4942000",
            "display" : "Lower limb lymph node structure (body structure)"
          },
          {
            "code" : "4958002",
            "display" : "Amygdaloid structure (body structure)"
          },
          {
            "code" : "4960000",
            "display" : "Peruvian Paso horse (organism)"
          },
          {
            "code" : "4969004",
            "display" : "Sinus headache (finding)"
          },
          {
            "code" : "4970003",
            "display" : "Venography (procedure)"
          },
          {
            "code" : "4996001",
            "display" : "Hypophosphatemia (disorder)"
          },
          {
            "code" : "4997005",
            "display" : "Thyrotoxicosis factitia (disorder)"
          },
          {
            "code" : "5043000",
            "display" : "Erythrosin Y stain (substance)"
          },
          {
            "code" : "5048009",
            "display" : "External cephalic version with tocolysis (procedure)"
          },
          {
            "code" : "5049001",
            "display" : "Abnormal angle of erection (finding)"
          },
          {
            "code" : "5050001",
            "display" : "Senile angioma (disorder)"
          },
          {
            "code" : "5056007",
            "display" : "Mycoplasma genitalium (organism)"
          },
          {
            "code" : "5076001",
            "display" : "Structure of infrasternal angle (body structure)"
          },
          {
            "code" : "5084002",
            "display" : "Primary female infertility (disorder)"
          },
          {
            "code" : "5085001",
            "display" : "Gonococcemia (disorder)"
          },
          {
            "code" : "5132005",
            "display" : "Keratosis pilaris (disorder)"
          },
          {
            "code" : "5140004",
            "display" : "Structure of maxillary right first molar tooth (body structure)"
          },
          {
            "code" : "5148006",
            "display" : "Hypertensive heart disease with congestive heart failure (disorder)"
          },
          {
            "code" : "5158005",
            "display" : "Gilles de la Tourette's syndrome (disorder)"
          },
          {
            "code" : "5164003",
            "display" : "Montdale sheep (organism)"
          },
          {
            "code" : "5187006",
            "display" : "Prune belly syndrome (disorder)"
          },
          {
            "code" : "5210005",
            "display" : "Rubella virus (organism)"
          },
          {
            "code" : "5217008",
            "display" : "Stiff-man syndrome (disorder)"
          },
          {
            "code" : "5227002",
            "display" : "Oxford sandy block pig (organism)"
          },
          {
            "code" : "5244003",
            "display" : "Intraductal papilloma (morphologic abnormality)"
          },
          {
            "code" : "5247005",
            "display" : "Bordetella pertussis (organism)"
          },
          {
            "code" : "5272005",
            "display" : "Skin structure of lateral portion of neck (body structure)"
          },
          {
            "code" : "5291005",
            "display" : "Hypocalcemia (disorder)"
          },
          {
            "code" : "5294002",
            "display" : "Developmental disorder (disorder)"
          },
          {
            "code" : "5296000",
            "display" : "Structure of anterior mediastinal lymph node (body structure)"
          },
          {
            "code" : "5306005",
            "display" : "Manchester terrier superbreed (organism)"
          },
          {
            "code" : "5313005",
            "display" : "Derangement of posterior horn of medial meniscus (disorder)"
          },
          {
            "code" : "5318001",
            "display" : "Posterior subcapsular polar senile cataract (disorder)"
          },
          {
            "code" : "5366008",
            "display" : "Hippocampal structure (body structure)"
          },
          {
            "code" : "5368009",
            "display" : "Drug-induced diabetes mellitus (disorder)"
          },
          {
            "code" : "5370000",
            "display" : "Atrial flutter (disorder)"
          },
          {
            "code" : "5394000",
            "display" : "Structure of uterine paracervical lymph node (body structure)"
          },
          {
            "code" : "5405008",
            "display" : "Cobalt-60 (substance)"
          },
          {
            "code" : "5413009",
            "display" : "Abnormal male sexual function (finding)"
          },
          {
            "code" : "5438004",
            "display" : "French alpine goat (organism)"
          },
          {
            "code" : "5441008",
            "display" : "Tinea capitis (disorder)"
          },
          {
            "code" : "5442001",
            "display" : "Page blue 83 stain (substance)"
          },
          {
            "code" : "5447007",
            "display" : "Transfusion (procedure)"
          },
          {
            "code" : "5467003",
            "display" : "Normal respiratory rhythm (finding)"
          },
          {
            "code" : "5505005",
            "display" : "Acute bronchiolitis (disorder)"
          },
          {
            "code" : "5509004",
            "display" : "Panic disorder with agoraphobia AND severe panic attacks (disorder)"
          },
          {
            "code" : "5510009",
            "display" : "Organic delusional disorder (disorder)"
          },
          {
            "code" : "5540006",
            "display" : "Calcium (substance)"
          },
          {
            "code" : "5549007",
            "display" : "Living in temporary quarters (finding)"
          },
          {
            "code" : "5552004",
            "display" : "Disorder of ovary (disorder)"
          },
          {
            "code" : "5556001",
            "display" : "Manually assisted spontaneous delivery (procedure)"
          },
          {
            "code" : "5587004",
            "display" : "Corneal dystrophy (disorder)"
          },
          {
            "code" : "5595000",
            "display" : "Salmonella enterica subspecies enterica serovar Typhi (organism)"
          },
          {
            "code" : "5602001",
            "display" : "Opioid abuse (disorder)"
          },
          {
            "code" : "5609005",
            "display" : "Sinus arrest (disorder)"
          },
          {
            "code" : "5619004",
            "display" : "Bardet-Biedl syndrome (disorder)"
          },
          {
            "code" : "5639000",
            "display" : "Late tooth eruption (disorder)"
          },
          {
            "code" : "5660006",
            "display" : "Volitional phonation (observable entity)"
          },
          {
            "code" : "5662003",
            "display" : "Contusion of hand (disorder)"
          },
          {
            "code" : "5665001",
            "display" : "Retinal structure (body structure)"
          },
          {
            "code" : "5689008",
            "display" : "Chronic periodontitis (disorder)"
          },
          {
            "code" : "5692007",
            "display" : "Cyanocobalamin (58-Co) (substance)"
          },
          {
            "code" : "5712003",
            "display" : "Sessile (qualifier value)"
          },
          {
            "code" : "5713008",
            "display" : "Submandibular triangle structure (body structure)"
          },
          {
            "code" : "5727003",
            "display" : "Structure of anterior cervical lymph node (body structure)"
          },
          {
            "code" : "5758002",
            "display" : "Bacteremia (finding)"
          },
          {
            "code" : "5781000",
            "display" : "Operation on nasal septum (procedure)"
          },
          {
            "code" : "5785009",
            "display" : "Forensic autopsy (procedure)"
          },
          {
            "code" : "5794003",
            "display" : "Country dweller (finding)"
          },
          {
            "code" : "5798000",
            "display" : "Diaphragm structure (body structure)"
          },
          {
            "code" : "5851001",
            "display" : "Corynebacterium diphtheriae (organism)"
          },
          {
            "code" : "5856006",
            "display" : "N3 category (finding)"
          },
          {
            "code" : "5874002",
            "display" : "Anticipatory anxiety, severe (finding)"
          },
          {
            "code" : "5876000",
            "display" : "Acquired pancytopenia (disorder)"
          },
          {
            "code" : "5880005",
            "display" : "Physical examination procedure (procedure)"
          },
          {
            "code" : "5883007",
            "display" : "Physiological change of voice, function (observable entity)"
          },
          {
            "code" : "5885000",
            "display" : "Mycobacterium flavescens (organism)"
          },
          {
            "code" : "5888003",
            "display" : "Keratitis (disorder)"
          },
          {
            "code" : "5902003",
            "display" : "History and physical examination, complete (procedure)"
          },
          {
            "code" : "5913000",
            "display" : "Fracture of neck of femur (disorder)"
          },
          {
            "code" : "5916008",
            "display" : "Dalmatian dog (organism)"
          },
          {
            "code" : "5928000",
            "display" : "Great cardiac vein structure (body structure)"
          },
          {
            "code" : "5931004",
            "display" : "Technetium (99m-Tc) sulfur colloid (substance)"
          },
          {
            "code" : "5935008",
            "display" : "Oral contraception (finding)"
          },
          {
            "code" : "5969009",
            "display" : "Diabetes mellitus associated with genetic syndrome (disorder)"
          },
          {
            "code" : "5972002",
            "display" : "Delay when starting to pass urine (finding)"
          },
          {
            "code" : "5984000",
            "display" : "Fetal or neonatal effect of malpresentation, malposition and/or disproportion during labor and/or delivery (disorder)"
          },
          {
            "code" : "6012004",
            "display" : "Hearing aid, device (physical object)"
          },
          {
            "code" : "6020002",
            "display" : "Tinea pedis (disorder)"
          },
          {
            "code" : "6025007",
            "display" : "Laparoscopic appendectomy (procedure)"
          },
          {
            "code" : "6041008",
            "display" : "Flat (qualifier value)"
          },
          {
            "code" : "6053007",
            "display" : "Dekalb hybrid pig line 33 (organism)"
          },
          {
            "code" : "6055000",
            "display" : "Burn of upper limb (disorder)"
          },
          {
            "code" : "6058003",
            "display" : "Residual foreign body in soft tissue (disorder)"
          },
          {
            "code" : "6062009",
            "display" : "Structure of deciduous mandibular right canine tooth (body structure)"
          },
          {
            "code" : "6064005",
            "display" : "Topical route (qualifier value)"
          },
          {
            "code" : "6072007",
            "display" : "Bleeding from anus (disorder)"
          },
          {
            "code" : "6077001",
            "display" : "Foot-drop (finding)"
          },
          {
            "code" : "6096002",
            "display" : "Breech presentation (finding)"
          },
          {
            "code" : "6103004",
            "display" : "Jack Russell terrier dog breed (organism)"
          },
          {
            "code" : "6112002",
            "display" : "Meusse-Rhine-Ijssel cattle breed (organism)"
          },
          {
            "code" : "6118003",
            "display" : "Demyelinating disease of central nervous system (disorder)"
          },
          {
            "code" : "6141006",
            "display" : "Retinal edema (disorder)"
          },
          {
            "code" : "6142004",
            "display" : "Influenza (disorder)"
          },
          {
            "code" : "6154004",
            "display" : "Open wound of forearm with tendon involvement (disorder)"
          },
          {
            "code" : "6185008",
            "display" : "Helicobacter-associated disease (disorder)"
          },
          {
            "code" : "6199007",
            "display" : "Mycobacterium diernhoferi (organism)"
          },
          {
            "code" : "6208003",
            "display" : "Clonic seizure (finding)"
          },
          {
            "code" : "6215006",
            "display" : "Acute cholangitis (disorder)"
          },
          {
            "code" : "6217003",
            "display" : "Structure of piriform recess (body structure)"
          },
          {
            "code" : "6220006",
            "display" : "Galiceno horse (organism)"
          },
          {
            "code" : "6229007",
            "display" : "Lacrimal bone structure (body structure)"
          },
          {
            "code" : "6234006",
            "display" : "Second degree perineal laceration (disorder)"
          },
          {
            "code" : "6240004",
            "display" : "Operative procedure on knee (procedure)"
          },
          {
            "code" : "6246005",
            "display" : "Treponema pallidum ss. pertenue (organism)"
          },
          {
            "code" : "6257000",
            "display" : "Sodium (22-Na) chloride (substance)"
          },
          {
            "code" : "6273006",
            "display" : "Priapism (disorder)"
          },
          {
            "code" : "6284004",
            "display" : "Abscess of neck (disorder)"
          },
          {
            "code" : "6285003",
            "display" : "Tachyarrhythmia (disorder)"
          },
          {
            "code" : "6300007",
            "display" : "Exposed to noise (event)"
          },
          {
            "code" : "6301006",
            "display" : "Tantalum-178 (substance)"
          },
          {
            "code" : "6329009",
            "display" : "Lean meat exchange list (finding)"
          },
          {
            "code" : "6334008",
            "display" : "Cervical inunction (finding)"
          },
          {
            "code" : "6373008",
            "display" : "Choco (ethnic group)"
          },
          {
            "code" : "6374002",
            "display" : "Bundle branch block (disorder)"
          },
          {
            "code" : "6383007",
            "display" : "Premature labor (finding)"
          },
          {
            "code" : "6387008",
            "display" : "Vibrio furnissii (organism)"
          },
          {
            "code" : "6400008",
            "display" : "Xanthoma of eyelid (disorder)"
          },
          {
            "code" : "6413002",
            "display" : "Structure of presymphysial lymph node (body structure)"
          },
          {
            "code" : "6415009",
            "display" : "Human respiratory syncytial virus (organism)"
          },
          {
            "code" : "6423006",
            "display" : "Supraspinatus muscle structure (body structure)"
          },
          {
            "code" : "6425004",
            "display" : "Product containing histamine receptor antagonist (product)"
          },
          {
            "code" : "6431001",
            "display" : "Leicester sheep (organism)"
          },
          {
            "code" : "6456007",
            "display" : "Supraventricular tachycardia (disorder)"
          },
          {
            "code" : "6461009",
            "display" : "Amygdalolith (disorder)"
          },
          {
            "code" : "6471006",
            "display" : "Suicidal thoughts (finding)"
          },
          {
            "code" : "6475002",
            "display" : "Primary degenerative dementia of the Alzheimer type, presenile onset, uncomplicated (disorder)"
          },
          {
            "code" : "6497000",
            "display" : "Decreased body mass index (finding)"
          },
          {
            "code" : "6511003",
            "display" : "Structure of distal portion of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "6516008",
            "display" : "Indium (111-In) ferric hydroxide (substance)"
          },
          {
            "code" : "6525002",
            "display" : "Dependent drug abuse (disorder)"
          },
          {
            "code" : "6530003",
            "display" : "Structure of cardiac valve leaflet (body structure)"
          },
          {
            "code" : "6533001",
            "display" : "Structure of colonic haustra (body structure)"
          },
          {
            "code" : "6538005",
            "display" : "Structure of thyrocervical trunk (body structure)"
          },
          {
            "code" : "6552007",
            "display" : "Lactose free infant formula (finding)"
          },
          {
            "code" : "6574001",
            "display" : "Necrosis (morphologic abnormality)"
          },
          {
            "code" : "6631009",
            "display" : "Thrombocytosis (disorder)"
          },
          {
            "code" : "6654000",
            "display" : "Acquired hallux rigidus (disorder)"
          },
          {
            "code" : "6655004",
            "display" : "Acute laryngitis (disorder)"
          },
          {
            "code" : "6660000",
            "display" : "Atypical intraductal hyperplasia (morphologic abnormality)"
          },
          {
            "code" : "6698000",
            "display" : "Closed trimalleolar fracture (disorder)"
          },
          {
            "code" : "6701008",
            "display" : "Lissamine fast red B stain (substance)"
          },
          {
            "code" : "6703006",
            "display" : "Breast lobule hyperplasia (disorder)"
          },
          {
            "code" : "6706003",
            "display" : "Transrectal approach (qualifier value)"
          },
          {
            "code" : "6708002",
            "display" : "Intrauterine cordocentesis (procedure)"
          },
          {
            "code" : "6725000",
            "display" : "Methylene blue stain (substance)"
          },
          {
            "code" : "6736007",
            "display" : "Moderate (severity modifier) (qualifier value)"
          },
          {
            "code" : "6738008",
            "display" : "Female infertility (disorder)"
          },
          {
            "code" : "6740003",
            "display" : "Cystic fibroadenosis of breast (disorder)"
          },
          {
            "code" : "6744007",
            "display" : "Painful bladder spasm (finding)"
          },
          {
            "code" : "6797001",
            "display" : "Mean blood pressure (observable entity)"
          },
          {
            "code" : "6832004",
            "display" : "Atherectomy (procedure)"
          },
          {
            "code" : "6836001",
            "display" : "Injury of brachial plexus (disorder)"
          },
          {
            "code" : "6849006",
            "display" : "Rupture of quadriceps tendon (disorder)"
          },
          {
            "code" : "6858004",
            "display" : "Capsulitis (disorder)"
          },
          {
            "code" : "6866008",
            "display" : "Structure of habenular commissure (body structure)"
          },
          {
            "code" : "6871001",
            "display" : "Structure of visceral pericardium (body structure)"
          },
          {
            "code" : "6893006",
            "display" : "First stage of labor (finding)"
          },
          {
            "code" : "6895004",
            "display" : "Tahyna virus (organism)"
          },
          {
            "code" : "6929003",
            "display" : "Urethral caruncle (disorder)"
          },
          {
            "code" : "6934004",
            "display" : "Permanent (qualifier value)"
          },
          {
            "code" : "6936002",
            "display" : "Cleft lip sequence (disorder)"
          },
          {
            "code" : "6942003",
            "display" : "Level of consciousness (observable entity)"
          },
          {
            "code" : "6962006",
            "display" : "Hypertensive retinopathy (disorder)"
          },
          {
            "code" : "6973004",
            "display" : "Chromium (51-Cr) chloride (substance)"
          },
          {
            "code" : "6990005",
            "display" : "Fracture of shaft of tibia (disorder)"
          },
          {
            "code" : "6996004",
            "display" : "Congenital absence of pulmonary valve (disorder)"
          },
          {
            "code" : "7006003",
            "display" : "Clumsiness (finding)"
          },
          {
            "code" : "7011001",
            "display" : "Hallucinations (finding)"
          },
          {
            "code" : "7033004",
            "display" : "Petit mal status (disorder)"
          },
          {
            "code" : "7058009",
            "display" : "Noncompliance with treatment (finding)"
          },
          {
            "code" : "7087005",
            "display" : "Intermittent (qualifier value)"
          },
          {
            "code" : "7093002",
            "display" : "Renal colic (finding)"
          },
          {
            "code" : "7121006",
            "display" : "Structure of maxillary right second molar tooth (body structure)"
          },
          {
            "code" : "7140000",
            "display" : "Radiographic contrast media (product)"
          },
          {
            "code" : "7163005",
            "display" : "Urinary tract obstruction (disorder)"
          },
          {
            "code" : "7180009",
            "display" : "Meningitis (disorder)"
          },
          {
            "code" : "7183006",
            "display" : "Anophthalmos (disorder)"
          },
          {
            "code" : "7199000",
            "display" : "Tuberous sclerosis syndrome (disorder)"
          },
          {
            "code" : "7200002",
            "display" : "Alcoholism (disorder)"
          },
          {
            "code" : "7231009",
            "display" : "Bullous dermatosis (disorder)"
          },
          {
            "code" : "7281000",
            "display" : "Technetium (99m-Tc) lidofenin (substance)"
          },
          {
            "code" : "7285009",
            "display" : "Milk free infant formula (finding)"
          },
          {
            "code" : "7292004",
            "display" : "Product containing indocyanine green (medicinal product)"
          },
          {
            "code" : "7293009",
            "display" : "Heavy-for-dates at birth regardless of gestation period (disorder)"
          },
          {
            "code" : "7297005",
            "display" : "Generalized seborrheic dermatitis of infants (disorder)"
          },
          {
            "code" : "7305005",
            "display" : "Coarctation of aorta (disorder)"
          },
          {
            "code" : "7339009",
            "display" : "Polyneuropathy caused by drug (disorder)"
          },
          {
            "code" : "7349007",
            "display" : "Yodelling (observable entity)"
          },
          {
            "code" : "7389001",
            "display" : "Time frame (qualifier value)"
          },
          {
            "code" : "7393007",
            "display" : "Disorder of nasal sinus (disorder)"
          },
          {
            "code" : "7426009",
            "display" : "Central corneal ulcer (disorder)"
          },
          {
            "code" : "7434003",
            "display" : "Erythrosin B stain (substance)"
          },
          {
            "code" : "7456000",
            "display" : "Poisoning caused by wasp sting (disorder)"
          },
          {
            "code" : "7476006",
            "display" : "Special care of dentures (regime/therapy)"
          },
          {
            "code" : "7484005",
            "display" : "Double outlet right ventricle (disorder)"
          },
          {
            "code" : "7487003",
            "display" : "200 milligram calcium diet (finding)"
          },
          {
            "code" : "7510005",
            "display" : "Color vision examination (procedure)"
          },
          {
            "code" : "7520000",
            "display" : "Pyrexia of unknown origin (finding)"
          },
          {
            "code" : "7527002",
            "display" : "Genus Legionella (organism)"
          },
          {
            "code" : "7542004",
            "display" : "Personal status (observable entity)"
          },
          {
            "code" : "7550008",
            "display" : "Transitory tachypnea of newborn (disorder)"
          },
          {
            "code" : "7551007",
            "display" : "Closed fracture of neck of metacarpal bone (disorder)"
          },
          {
            "code" : "7562007",
            "display" : "Radioisotope study of endocrine system (procedure)"
          },
          {
            "code" : "7564008",
            "display" : "Liquid cardiac diet (finding)"
          },
          {
            "code" : "7569003",
            "display" : "Finger structure (body structure)"
          },
          {
            "code" : "7573000",
            "display" : "Classical phenylketonuria (disorder)"
          },
          {
            "code" : "7620006",
            "display" : "Crohn's disease of large bowel (disorder)"
          },
          {
            "code" : "7623008",
            "display" : "American paint horse (organism)"
          },
          {
            "code" : "7631003",
            "display" : "Infant formula with medium chain triglycerides (finding)"
          },
          {
            "code" : "7632005",
            "display" : "Dermatographic urticaria (disorder)"
          },
          {
            "code" : "7653001",
            "display" : "Self-feeding deficit (finding)"
          },
          {
            "code" : "7657000",
            "display" : "Structure of femoral artery (body structure)"
          },
          {
            "code" : "7668000",
            "display" : "Pseudomasturbation (finding)"
          },
          {
            "code" : "7674000",
            "display" : "Greater trochanteric pain syndrome (disorder)"
          },
          {
            "code" : "7678002",
            "display" : "Cytomegaloviral pneumonia (disorder)"
          },
          {
            "code" : "7695005",
            "display" : "Germans (ethnic group)"
          },
          {
            "code" : "7699004",
            "display" : "Adhesive middle ear disease (disorder)"
          },
          {
            "code" : "7725007",
            "display" : "Radiation nephritis (disorder)"
          },
          {
            "code" : "7751009",
            "display" : "Visual discomfort (finding)"
          },
          {
            "code" : "7757008",
            "display" : "Genus Acinetobacter (organism)"
          },
          {
            "code" : "7765006",
            "display" : "Epidermal burn of scalp (disorder)"
          },
          {
            "code" : "7770004",
            "display" : "Strontium-89 (substance)"
          },
          {
            "code" : "7771000",
            "display" : "Left (qualifier value)"
          },
          {
            "code" : "7791007",
            "display" : "Soy protein (substance)"
          },
          {
            "code" : "7792000",
            "display" : "Placenta previa without hemorrhage (disorder)"
          },
          {
            "code" : "7832008",
            "display" : "Abdominal aorta structure (body structure)"
          },
          {
            "code" : "7843000",
            "display" : "Horned Hereford (organism)"
          },
          {
            "code" : "7844006",
            "display" : "Sternoclavicular joint structure (body structure)"
          },
          {
            "code" : "7847004",
            "display" : "Cheilitis (disorder)"
          },
          {
            "code" : "7890003",
            "display" : "Contracture of joint (disorder)"
          },
          {
            "code" : "7895008",
            "display" : "Poisoning caused by drug AND/OR medicinal substance (disorder)"
          },
          {
            "code" : "7916009",
            "display" : "Alcoholic polyneuropathy (disorder)"
          },
          {
            "code" : "7919002",
            "display" : "Impaired skin integrity (finding)"
          },
          {
            "code" : "7934008",
            "display" : "Passive physical exercise (observable entity)"
          },
          {
            "code" : "7947003",
            "display" : "Product containing aspirin (medicinal product)"
          },
          {
            "code" : "7951001",
            "display" : "Tailor's bunion (disorder)"
          },
          {
            "code" : "7964000",
            "display" : "Congenital listeriosis (disorder)"
          },
          {
            "code" : "7973008",
            "display" : "Abnormal vision (finding)"
          },
          {
            "code" : "7991003",
            "display" : "Skin structure of glans penis (body structure)"
          },
          {
            "code" : "7996008",
            "display" : "Fetal intrauterine distress first noted during labor AND/OR delivery in liveborn infant (finding)"
          },
          {
            "code" : "8001006",
            "display" : "Structure of mucous membrane of tongue (body structure)"
          },
          {
            "code" : "8004003",
            "display" : "Teething syndrome (finding)"
          },
          {
            "code" : "8009008",
            "display" : "Nocturnal enuresis (finding)"
          },
          {
            "code" : "8011004",
            "display" : "Dysarthria (finding)"
          },
          {
            "code" : "8012006",
            "display" : "Structure of anterior communicating artery (body structure)"
          },
          {
            "code" : "8014007",
            "display" : "Brow presentation (finding)"
          },
          {
            "code" : "8017000",
            "display" : "Structure of inflow tract of right ventricle (body structure)"
          },
          {
            "code" : "8034008",
            "display" : "Painful penile erection (finding)"
          },
          {
            "code" : "8069005",
            "display" : "Implantation of tricuspid valve prosthesis or synthetic device (procedure)"
          },
          {
            "code" : "8089006",
            "display" : "Welsh walking horse (organism)"
          },
          {
            "code" : "8098009",
            "display" : "Sexually transmitted infectious disease (disorder)"
          },
          {
            "code" : "8124001",
            "display" : "West Africans (ethnic group)"
          },
          {
            "code" : "8128003",
            "display" : "Supraaortic valve area structure (body structure)"
          },
          {
            "code" : "8147000",
            "display" : "Legionella wadsworthii (organism)"
          },
          {
            "code" : "8180007",
            "display" : "Fiberoptic colonoscopy through colostomy (procedure)"
          },
          {
            "code" : "8185002",
            "display" : "Panic disorder with agoraphobia AND moderate panic attacks (disorder)"
          },
          {
            "code" : "8186001",
            "display" : "Cardiomegaly (disorder)"
          },
          {
            "code" : "8202008",
            "display" : "Potassium-43 (substance)"
          },
          {
            "code" : "8205005",
            "display" : "Wrist region structure (body structure)"
          },
          {
            "code" : "8217007",
            "display" : "Arachnoiditis (disorder)"
          },
          {
            "code" : "8218002",
            "display" : "Chronic hypertension complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "8220004",
            "display" : "Endocervical polyp (disorder)"
          },
          {
            "code" : "8225009",
            "display" : "Accessory atrioventricular bundle (body structure)"
          },
          {
            "code" : "8227001",
            "display" : "Ruthenium-106 (substance)"
          },
          {
            "code" : "8229003",
            "display" : "Vasomotor rhinitis (disorder)"
          },
          {
            "code" : "8317005",
            "display" : "At risk for deficient parenting (finding)"
          },
          {
            "code" : "8334002",
            "display" : "Structure of lumbar lymph node (body structure)"
          },
          {
            "code" : "8342001",
            "display" : "Brilliant cresyl blue stain (substance)"
          },
          {
            "code" : "8348002",
            "display" : "Product containing cyclopentolate (medicinal product)"
          },
          {
            "code" : "8349005",
            "display" : "Sexual exposure (finding)"
          },
          {
            "code" : "8351009",
            "display" : "Smooth fox terrier (organism)"
          },
          {
            "code" : "8356004",
            "display" : "Structure of colic lymph node (body structure)"
          },
          {
            "code" : "8357008",
            "display" : "Reduced libido (finding)"
          },
          {
            "code" : "8359006",
            "display" : "Automated (qualifier value)"
          },
          {
            "code" : "8360001",
            "display" : "Pleomorphic adenoma (morphologic abnormality)"
          },
          {
            "code" : "8367003",
            "display" : "Clipping nails of patient (procedure)"
          },
          {
            "code" : "8378006",
            "display" : "Trimming (procedure)"
          },
          {
            "code" : "8386006",
            "display" : "Clostridium botulinum, type E (organism)"
          },
          {
            "code" : "8392000",
            "display" : "Non-smoker (finding)"
          },
          {
            "code" : "8414002",
            "display" : "Abscess of nose (disorder)"
          },
          {
            "code" : "8419007",
            "display" : "Domestic longhaired cat (organism)"
          },
          {
            "code" : "8422009",
            "display" : "Destruction of hemorrhoids by sclerotherapy (procedure)"
          },
          {
            "code" : "8429000",
            "display" : "Brilliant orange stain (substance)"
          },
          {
            "code" : "8442000",
            "display" : "Purulent rhinitis (disorder)"
          },
          {
            "code" : "8467002",
            "display" : "Dengue virus, type 3 (organism)"
          },
          {
            "code" : "8483002",
            "display" : "Structure of mesial surface of tooth (body structure)"
          },
          {
            "code" : "8493009",
            "display" : "Chronic gastritis (disorder)"
          },
          {
            "code" : "8499008",
            "display" : "Pulse, function (observable entity)"
          },
          {
            "code" : "8510008",
            "display" : "Reduced mobility (finding)"
          },
          {
            "code" : "8516002",
            "display" : "Dekalb hybrid pig line 51 (organism)"
          },
          {
            "code" : "8517006",
            "display" : "Ex-smoker (finding)"
          },
          {
            "code" : "8522006",
            "display" : "Klismaphilia (disorder)"
          },
          {
            "code" : "8555001",
            "display" : "Syphilis of lung (disorder)"
          },
          {
            "code" : "8592001",
            "display" : "Irrigation following insertion of catheter (procedure)"
          },
          {
            "code" : "8598002",
            "display" : "Vestibulocochlear nerve structure (body structure)"
          },
          {
            "code" : "8616005",
            "display" : "Rhinocheiloplasty repair for cleft lip (procedure)"
          },
          {
            "code" : "8619003",
            "display" : "Infertile (finding)"
          },
          {
            "code" : "8625004",
            "display" : "Legal status (observable entity)"
          },
          {
            "code" : "8629005",
            "display" : "Structure of superior right pulmonary vein (body structure)"
          },
          {
            "code" : "8635005",
            "display" : "Alcohol withdrawal delirium (disorder)"
          },
          {
            "code" : "8644006",
            "display" : "Epigastric fullness (finding)"
          },
          {
            "code" : "8666004",
            "display" : "Supernumerary teeth (disorder)"
          },
          {
            "code" : "8672004",
            "display" : "Coccidioides (organism)"
          },
          {
            "code" : "8686000",
            "display" : "Cocaine-induced sexual dysfunction (finding)"
          },
          {
            "code" : "8715000",
            "display" : "Hospital admission, elective (procedure)"
          },
          {
            "code" : "8722008",
            "display" : "Aortic valve disorder (disorder)"
          },
          {
            "code" : "8762007",
            "display" : "Chronic hypertension in obstetric context (disorder)"
          },
          {
            "code" : "8763002",
            "display" : "German landrace pig (organism)"
          },
          {
            "code" : "8765009",
            "display" : "Hematemesis (disorder)"
          },
          {
            "code" : "8782006",
            "display" : "Radical perineal prostatectomy (procedure)"
          },
          {
            "code" : "8801005",
            "display" : "Secondary diabetes mellitus (disorder)"
          },
          {
            "code" : "8821006",
            "display" : "Structure of peroneal artery (body structure)"
          },
          {
            "code" : "8836009",
            "display" : "Gallocyanine stain (substance)"
          },
          {
            "code" : "8847002",
            "display" : "Spondylosis (disorder)"
          },
          {
            "code" : "8858006",
            "display" : "Strontium (85-Sr) nitrate (substance)"
          },
          {
            "code" : "8873007",
            "display" : "Structure of permanent mandibular right second premolar tooth (body structure)"
          },
          {
            "code" : "8874001",
            "display" : "Arthroscopy of knee with medial and lateral meniscectomy (procedure)"
          },
          {
            "code" : "8887007",
            "display" : "Structure of brachiocephalic vein (body structure)"
          },
          {
            "code" : "8889005",
            "display" : "Excisional biopsy (procedure)"
          },
          {
            "code" : "8900005",
            "display" : "Hypoproteinemia (disorder)"
          },
          {
            "code" : "8913004",
            "display" : "Primary physiologic amenorrhea (finding)"
          },
          {
            "code" : "8920006",
            "display" : "Repair of retina for retinal detachment (procedure)"
          },
          {
            "code" : "8926000",
            "display" : "Azure B stain (substance)"
          },
          {
            "code" : "8928004",
            "display" : "Inguinal lymph node structure (body structure)"
          },
          {
            "code" : "8931003",
            "display" : "Structure of coracoid process of scapula (body structure)"
          },
          {
            "code" : "8943002",
            "display" : "Weight gain (finding)"
          },
          {
            "code" : "8948006",
            "display" : "Assisted ventilation therapy, pressure or volume preset, initiation and management (procedure)"
          },
          {
            "code" : "8954007",
            "display" : "Sequestrum of jaw bone (disorder)"
          },
          {
            "code" : "8970009",
            "display" : "French landrace pig (organism)"
          },
          {
            "code" : "8971008",
            "display" : "Psychalgia (finding)"
          },
          {
            "code" : "8989009",
            "display" : "Ayrshire cattle breed (organism)"
          },
          {
            "code" : "8993003",
            "display" : "Structure of hepatic vein (body structure)"
          },
          {
            "code" : "8997002",
            "display" : "Ventricular systole, function (observable entity)"
          },
          {
            "code" : "9009001",
            "display" : "Low compliance bladder (disorder)"
          },
          {
            "code" : "9010006",
            "display" : "Methyl blue stain (substance)"
          },
          {
            "code" : "9014002",
            "display" : "Psoriasis (disorder)"
          },
          {
            "code" : "9015001",
            "display" : "Brain injury without open intracranial wound (disorder)"
          },
          {
            "code" : "9021002",
            "display" : "Carbaryl (substance)"
          },
          {
            "code" : "9040008",
            "display" : "Ascending colon structure (body structure)"
          },
          {
            "code" : "9041007",
            "display" : "Campylobacter hyointestinalis (organism)"
          },
          {
            "code" : "9061001",
            "display" : "Check artificial pacemaker (procedure)"
          },
          {
            "code" : "9078005",
            "display" : "Polyp of vocal cord (disorder)"
          },
          {
            "code" : "9083002",
            "display" : "Pedophilia, opposite sex (disorder)"
          },
          {
            "code" : "9097005",
            "display" : "Stigma (finding)"
          },
          {
            "code" : "9126005",
            "display" : "Menstrual spotting (finding)"
          },
          {
            "code" : "9131007",
            "display" : "Standard Manchester terrier (organism)"
          },
          {
            "code" : "9135003",
            "display" : "OIC pig (organism)"
          },
          {
            "code" : "9158000",
            "display" : "Liberians (ethnic group)"
          },
          {
            "code" : "9166009",
            "display" : "Injection of anesthetic substance, diagnostic, subarachnoid, continuous (procedure)"
          },
          {
            "code" : "9177003",
            "display" : "Histiocytic vasculitis of skin (disorder)"
          },
          {
            "code" : "9190005",
            "display" : "Product containing tropicamide (medicinal product)"
          },
          {
            "code" : "9194001",
            "display" : "Jamestown Canyon virus (organism)"
          },
          {
            "code" : "9209005",
            "display" : "Acute abdomen (disorder)"
          },
          {
            "code" : "9230001",
            "display" : "Camarron goat (organism)"
          },
          {
            "code" : "9241004",
            "display" : "Gonococcal heart disease (disorder)"
          },
          {
            "code" : "9265001",
            "display" : "Specimen processing (procedure)"
          },
          {
            "code" : "9277006",
            "display" : "Polled Hereford (organism)"
          },
          {
            "code" : "9283009",
            "display" : "Second degree uterine prolapse (disorder)"
          },
          {
            "code" : "9351000",
            "display" : "Palladium-103 (substance)"
          },
          {
            "code" : "9389005",
            "display" : "Herpes simplex keratitis (disorder)"
          },
          {
            "code" : "9414007",
            "display" : "Impaired glucose tolerance (disorder)"
          },
          {
            "code" : "9418005",
            "display" : "Necrobiosis lipoidica (disorder)"
          },
          {
            "code" : "9427006",
            "display" : "Autopsy review (procedure)"
          },
          {
            "code" : "9431000",
            "display" : "Phase of life problem (finding)"
          },
          {
            "code" : "9454009",
            "display" : "Structure of subclavian vein (body structure)"
          },
          {
            "code" : "9468002",
            "display" : "Closed fracture of carpal bone (disorder)"
          },
          {
            "code" : "9528004",
            "display" : "Flat-coated retriever (organism)"
          },
          {
            "code" : "9533000",
            "display" : "Dutch (ethnic group)"
          },
          {
            "code" : "9560007",
            "display" : "Crushing injury of upper limb (disorder)"
          },
          {
            "code" : "9617008",
            "display" : "Hyperlipoproteinemia diet, type I (finding)"
          },
          {
            "code" : "9631008",
            "display" : "Ankylosing spondylitis (disorder)"
          },
          {
            "code" : "9642004",
            "display" : "Left superior vena cava (body structure)"
          },
          {
            "code" : "9651007",
            "display" : "Long QT syndrome (disorder)"
          },
          {
            "code" : "9659009",
            "display" : "Infraclavicular lymph node (body structure)"
          },
          {
            "code" : "9679001",
            "display" : "Mycobacterium moriokaense (organism)"
          },
          {
            "code" : "9682006",
            "display" : "Fracture of scapula (disorder)"
          },
          {
            "code" : "9707006",
            "display" : "Intestinal volvulus (disorder)"
          },
          {
            "code" : "9713002",
            "display" : "Prostatitis (disorder)"
          },
          {
            "code" : "9718006",
            "display" : "Polymerase chain reaction analysis (procedure)"
          },
          {
            "code" : "9721008",
            "display" : "Phencyclidine (substance)"
          },
          {
            "code" : "9726003",
            "display" : "Equal (qualifier value)"
          },
          {
            "code" : "9740002",
            "display" : "Macroencephaly (disorder)"
          },
          {
            "code" : "9748009",
            "display" : "Dyskinesia (finding)"
          },
          {
            "code" : "9761009",
            "display" : "Chihuahua superbreed (organism)"
          },
          {
            "code" : "9763007",
            "display" : "Expiratory wheezing (finding)"
          },
          {
            "code" : "9775002",
            "display" : "Structure of left carotid sinus (body structure)"
          },
          {
            "code" : "9794007",
            "display" : "Endolymphatic hydrops (disorder)"
          },
          {
            "code" : "9799002",
            "display" : "Burn patient diet, high calorie, high protein (finding)"
          },
          {
            "code" : "9826008",
            "display" : "Conjunctivitis (disorder)"
          },
          {
            "code" : "9859006",
            "display" : "Acanthosis nigricans due to type 2 diabetes mellitus (disorder)"
          },
          {
            "code" : "9861002",
            "display" : "Streptococcus pneumoniae (organism)"
          },
          {
            "code" : "9875009",
            "display" : "Thymus gland structure (body structure)"
          },
          {
            "code" : "9888007",
            "display" : "Excision of intracranial lesion (procedure)"
          },
          {
            "code" : "9892000",
            "display" : "Campylobacter concisus (organism)"
          },
          {
            "code" : "9901000",
            "display" : "Essential hypertension complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "9904008",
            "display" : "Congenital anomaly of cardiovascular system (disorder)"
          },
          {
            "code" : "9908006",
            "display" : "Normal psychomotor development (finding)"
          },
          {
            "code" : "9939008",
            "display" : "Mycobacterium fallax (organism)"
          },
          {
            "code" : "9947008",
            "display" : "Natural father (person)"
          },
          {
            "code" : "9953008",
            "display" : "Acute alcoholic liver disease (disorder)"
          },
          {
            "code" : "9957009",
            "display" : "Urethral discharge (finding)"
          },
          {
            "code" : "9964006",
            "display" : "Flexion, function (observable entity)"
          },
          {
            "code" : "9991008",
            "display" : "Abdominal colic (finding)"
          },
          {
            "code" : "10008004",
            "display" : "Ewe (ethnic group)"
          },
          {
            "code" : "10017004",
            "display" : "Occlusal wear of teeth (disorder)"
          },
          {
            "code" : "10029008",
            "display" : "Suicide precautions (procedure)"
          },
          {
            "code" : "10040000",
            "display" : "Pomeranian dog (organism)"
          },
          {
            "code" : "10050004",
            "display" : "Contusion of chest (disorder)"
          },
          {
            "code" : "10085004",
            "display" : "Metatarsalgia (finding)"
          },
          {
            "code" : "10117001",
            "display" : "Finns (ethnic group)"
          },
          {
            "code" : "10119003",
            "display" : "Structure of deep volar arch of radial artery (body structure)"
          },
          {
            "code" : "10132008",
            "display" : "Burns of multiple sites (disorder)"
          },
          {
            "code" : "10136006",
            "display" : "Singapura cat (organism)"
          },
          {
            "code" : "10139004",
            "display" : "Difficulty adjusting to work situation (finding)"
          },
          {
            "code" : "10184002",
            "display" : "Recurrent cholangitis (disorder)"
          },
          {
            "code" : "10197000",
            "display" : "Psychiatric interview and evaluation (procedure)"
          },
          {
            "code" : "10200004",
            "display" : "Liver structure (body structure)"
          },
          {
            "code" : "10209003",
            "display" : "Structure of parotid lymph node (body structure)"
          },
          {
            "code" : "10217006",
            "display" : "Third degree perineal laceration (disorder)"
          },
          {
            "code" : "10227000",
            "display" : "Herpetic infection of penis (disorder)"
          },
          {
            "code" : "10247008",
            "display" : "Chrysoidine R stain (substance)"
          },
          {
            "code" : "10249006",
            "display" : "Agar (substance)"
          },
          {
            "code" : "10261003",
            "display" : "Belgium landrace pig (organism)"
          },
          {
            "code" : "10262005",
            "display" : "Enterococcus malodoratus (organism)"
          },
          {
            "code" : "10266008",
            "display" : "Insertion of bridge pontic (procedure)"
          },
          {
            "code" : "10292001",
            "display" : "Guamians (ethnic group)"
          },
          {
            "code" : "10293006",
            "display" : "Structure of iliac artery (body structure)"
          },
          {
            "code" : "10326007",
            "display" : "Coronary artery bypass with autogenous graft, three grafts (procedure)"
          },
          {
            "code" : "10337008",
            "display" : "Incompetence of any valvular structure (finding)"
          },
          {
            "code" : "10345003",
            "display" : "Primary syphilis of tonsils (disorder)"
          },
          {
            "code" : "10369004",
            "display" : "Briard dog (organism)"
          },
          {
            "code" : "10376009",
            "display" : "Papillary carcinoma in situ (morphologic abnormality)"
          },
          {
            "code" : "10380004",
            "display" : "Crushing injury of finger (disorder)"
          },
          {
            "code" : "10383002",
            "display" : "Counseling for termination of pregnancy (procedure)"
          },
          {
            "code" : "10396001",
            "display" : "Radiation diet (finding)"
          },
          {
            "code" : "10406007",
            "display" : "Lesch-Nyhan syndrome (disorder)"
          },
          {
            "code" : "10432001",
            "display" : "Onge (ethnic group)"
          },
          {
            "code" : "10458001",
            "display" : "Evacuation of intracerebral hematoma (procedure)"
          },
          {
            "code" : "10461000",
            "display" : "Nonvenomous insect bite with infection (disorder)"
          },
          {
            "code" : "10509002",
            "display" : "Acute bronchitis (disorder)"
          },
          {
            "code" : "10514003",
            "display" : "Norwalk virus (organism)"
          },
          {
            "code" : "10517005",
            "display" : "External capsule of brain (body structure)"
          },
          {
            "code" : "10528009",
            "display" : "Lupus vulgaris (disorder)"
          },
          {
            "code" : "10531005",
            "display" : "Free-standing ambulatory surgery facility (environment)"
          },
          {
            "code" : "10544000",
            "display" : "Smooth collie (organism)"
          },
          {
            "code" : "10562009",
            "display" : "Malignant hypertension complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "10572007",
            "display" : "13q partial trisomy syndrome (disorder)"
          },
          {
            "code" : "10586006",
            "display" : "Occupation-related stress disorder (disorder)"
          },
          {
            "code" : "10598001",
            "display" : "Contact with hand tool (event)"
          },
          {
            "code" : "10601006",
            "display" : "Pain in lower limb (finding)"
          },
          {
            "code" : "10623005",
            "display" : "Fibrous dysplasia of bone (disorder)"
          },
          {
            "code" : "10626002",
            "display" : "Multifocal premature ventricular complexes (disorder)"
          },
          {
            "code" : "10629009",
            "display" : "Tetany (disorder)"
          },
          {
            "code" : "10639003",
            "display" : "Solitary plasmacytoma of bone (morphologic abnormality)"
          },
          {
            "code" : "10665004",
            "display" : "Mumps pancreatitis (disorder)"
          },
          {
            "code" : "10701001",
            "display" : "Javanese cat (organism)"
          },
          {
            "code" : "10712001",
            "display" : "Product containing glucagon (medicinal product)"
          },
          {
            "code" : "10725009",
            "display" : "Benign hypertension (disorder)"
          },
          {
            "code" : "10738001",
            "display" : "Yttrium-86 (substance)"
          },
          {
            "code" : "10740006",
            "display" : "Sudan blue stain (substance)"
          },
          {
            "code" : "10743008",
            "display" : "Irritable bowel syndrome (disorder)"
          },
          {
            "code" : "10781003",
            "display" : "Sodium phosphate (32-P) (substance)"
          },
          {
            "code" : "10783000",
            "display" : "Symptomatic pedophilia (disorder)"
          },
          {
            "code" : "10828004",
            "display" : "Positive (qualifier value)"
          },
          {
            "code" : "10842007",
            "display" : "Ibizan hound (organism)"
          },
          {
            "code" : "10847001",
            "display" : "Bronchoscopy (procedure)"
          },
          {
            "code" : "10849003",
            "display" : "Removal of foreign body (procedure)"
          },
          {
            "code" : "10885003",
            "display" : "Premenstrual symptom (finding)"
          },
          {
            "code" : "10888001",
            "display" : "Liquid diet (finding)"
          },
          {
            "code" : "10893003",
            "display" : "Tuberculous adenitis (disorder)"
          },
          {
            "code" : "10904000",
            "display" : "Orthostatic body position (finding)"
          },
          {
            "code" : "10930001",
            "display" : "Congenital atresia of pulmonary artery (disorder)"
          },
          {
            "code" : "10944007",
            "display" : "Taurine (substance)"
          },
          {
            "code" : "10981006",
            "display" : "Severe mixed bipolar I disorder with psychotic features (disorder)"
          },
          {
            "code" : "11000004",
            "display" : "Caudate nucleus structure (body structure)"
          },
          {
            "code" : "11049006",
            "display" : "Cervical radiculitis (disorder)"
          },
          {
            "code" : "11050006",
            "display" : "Closure of vesicouterine fistula with hysterectomy (procedure)"
          },
          {
            "code" : "11069001",
            "display" : "Azure C stain (substance)"
          },
          {
            "code" : "11070000",
            "display" : "Capsular (qualifier value)"
          },
          {
            "code" : "11089000",
            "display" : "Structure of superior cerebellar peduncle (body structure)"
          },
          {
            "code" : "11092001",
            "display" : "Sinus tachycardia (finding)"
          },
          {
            "code" : "11101003",
            "display" : "Percutaneous transluminal coronary angioplasty (procedure)"
          },
          {
            "code" : "11114002",
            "display" : "Sore gums (finding)"
          },
          {
            "code" : "11136004",
            "display" : "Methoxyflurane (substance)"
          },
          {
            "code" : "11157007",
            "display" : "Ventricular bigeminy (disorder)"
          },
          {
            "code" : "11161001",
            "display" : "Dekalb hybrid pig line 77 (organism)"
          },
          {
            "code" : "11196001",
            "display" : "Poisoning caused by opiate AND/OR related narcotic (disorder)"
          },
          {
            "code" : "11201005",
            "display" : "Solochrome black 6B stain (substance)"
          },
          {
            "code" : "11214006",
            "display" : "Reactive (qualifier value)"
          },
          {
            "code" : "11223009",
            "display" : "Congenital anomaly of pharynx (disorder)"
          },
          {
            "code" : "11226001",
            "display" : "Fuchs' heterochromic cyclitis (disorder)"
          },
          {
            "code" : "11251000",
            "display" : "Irradiation cystitis (disorder)"
          },
          {
            "code" : "11256005",
            "display" : "Melanosis coli (disorder)"
          },
          {
            "code" : "11279006",
            "display" : "Structure of circle of Willis (body structure)"
          },
          {
            "code" : "11296007",
            "display" : "Stenosis of trachea (disorder)"
          },
          {
            "code" : "11314008",
            "display" : "Polyp of corpus uteri (disorder)"
          },
          {
            "code" : "11338007",
            "display" : "Syphilitic episcleritis (disorder)"
          },
          {
            "code" : "11366004",
            "display" : "Singers' nodes (disorder)"
          },
          {
            "code" : "11381005",
            "display" : "Acne vulgaris (disorder)"
          },
          {
            "code" : "11385001",
            "display" : "Assault and battery (event)"
          },
          {
            "code" : "11386000",
            "display" : "Open wound of ear (disorder)"
          },
          {
            "code" : "11387009",
            "display" : "Psychoactive substance-induced organic mental disorder (disorder)"
          },
          {
            "code" : "11397000",
            "display" : "Autotransfusion of whole blood (procedure)"
          },
          {
            "code" : "11401008",
            "display" : "Dilation and curettage of uterus (procedure)"
          },
          {
            "code" : "11403006",
            "display" : "Financially poor (finding)"
          },
          {
            "code" : "11409005",
            "display" : "Left occipitoanterior position (finding)"
          },
          {
            "code" : "11422002",
            "display" : "Combined form of senile cataract (disorder)"
          },
          {
            "code" : "11424001",
            "display" : "Ambulance-based care (environment)"
          },
          {
            "code" : "11428003",
            "display" : "Western equine encephalomyelitis virus (organism)"
          },
          {
            "code" : "11429006",
            "display" : "Consultation (procedure)"
          },
          {
            "code" : "11437003",
            "display" : "Contusion of back (disorder)"
          },
          {
            "code" : "11441004",
            "display" : "Prostatism (disorder)"
          },
          {
            "code" : "11458009",
            "display" : "Anticipatory anxiety, mild (finding)"
          },
          {
            "code" : "11466000",
            "display" : "Cesarean section (procedure)"
          },
          {
            "code" : "11477006",
            "display" : "Irish setter (organism)"
          },
          {
            "code" : "11480007",
            "display" : "Idiopathic granulomatous interstitial nephropathy (disorder)"
          },
          {
            "code" : "11496005",
            "display" : "Mercuric chloride (substance)"
          },
          {
            "code" : "11512006",
            "display" : "Normal sexual function (finding)"
          },
          {
            "code" : "11526002",
            "display" : "Aspartame (substance)"
          },
          {
            "code" : "11530004",
            "display" : "Brittle diabetes mellitus (finding)"
          },
          {
            "code" : "11538006",
            "display" : "Quadriplegia (disorder)"
          },
          {
            "code" : "11543004",
            "display" : "Otosclerosis (disorder)"
          },
          {
            "code" : "11554009",
            "display" : "Adduction, function (observable entity)"
          },
          {
            "code" : "11584001",
            "display" : "Skin structure of anterior portion of neck (body structure)"
          },
          {
            "code" : "11612004",
            "display" : "Chorioamnionitis (disorder)"
          },
          {
            "code" : "11614003",
            "display" : "Congenital stenosis of pulmonary veins (disorder)"
          },
          {
            "code" : "11618000",
            "display" : "Intra-amniotic infection of fetus (disorder)"
          },
          {
            "code" : "11625007",
            "display" : "Torus mandibularis (disorder)"
          },
          {
            "code" : "11628009",
            "display" : "Structure of telencephalon (body structure)"
          },
          {
            "code" : "11645004",
            "display" : "Spirit soluble aniline blue stain (substance)"
          },
          {
            "code" : "11654001",
            "display" : "Achilles tendinitis (disorder)"
          },
          {
            "code" : "11671000",
            "display" : "Adenoid cystic carcinoma (morphologic abnormality)"
          },
          {
            "code" : "11674008",
            "display" : "Parenteral nutrient (finding)"
          },
          {
            "code" : "11687002",
            "display" : "Gestational diabetes mellitus (disorder)"
          },
          {
            "code" : "11708003",
            "display" : "Hypogastric region structure (body structure)"
          },
          {
            "code" : "11712009",
            "display" : "Structure of maxillary right lateral incisor tooth (body structure)"
          },
          {
            "code" : "11713004",
            "display" : "Water (substance)"
          },
          {
            "code" : "11723008",
            "display" : "Contact with (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "11727009",
            "display" : "Indophenol from naphthol stain (substance)"
          },
          {
            "code" : "11736008",
            "display" : "Vibrio parahaemolyticus (organism)"
          },
          {
            "code" : "11739001",
            "display" : "High residue diet (finding)"
          },
          {
            "code" : "11740004",
            "display" : "Structure of prevesicular lymph node (body structure)"
          },
          {
            "code" : "11746005",
            "display" : "Australian cattle dog (organism)"
          },
          {
            "code" : "11776003",
            "display" : "Vibrio mimicus (organism)"
          },
          {
            "code" : "11780008",
            "display" : "Durazol red stain (substance)"
          },
          {
            "code" : "11791001",
            "display" : "Necrotizing vasculitis (disorder)"
          },
          {
            "code" : "11794009",
            "display" : "Kenyans (ethnic group)"
          },
          {
            "code" : "11805005",
            "display" : "Injury of groin (disorder)"
          },
          {
            "code" : "11806006",
            "display" : "Separation anxiety disorder of childhood (disorder)"
          },
          {
            "code" : "11816003",
            "display" : "Diet education (procedure)"
          },
          {
            "code" : "11833005",
            "display" : "Dry cough (finding)"
          },
          {
            "code" : "11836002",
            "display" : "Primary bacterial peritonitis (disorder)"
          },
          {
            "code" : "11840006",
            "display" : "Traveler's diarrhea (disorder)"
          },
          {
            "code" : "11851006",
            "display" : "Mitral valve disorder (disorder)"
          },
          {
            "code" : "11868005",
            "display" : "Burn of multiple sites of trunk (disorder)"
          },
          {
            "code" : "11882005",
            "display" : "Juvenile masturbation (finding)"
          },
          {
            "code" : "11894001",
            "display" : "Clostridium botulinum toxin (substance)"
          },
          {
            "code" : "11896004",
            "display" : "Intermediate (qualifier value)"
          },
          {
            "code" : "11899006",
            "display" : "Structure of esophageal lymph node (body structure)"
          },
          {
            "code" : "11906007",
            "display" : "Chronic gonococcal vulvovaginitis (disorder)"
          },
          {
            "code" : "11934000",
            "display" : "Ptosis of eyelid (disorder)"
          },
          {
            "code" : "11939005",
            "display" : "Acute arthritis (disorder)"
          },
          {
            "code" : "11941006",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in full remission AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "11959009",
            "display" : "Product containing procainamide (medicinal product)"
          },
          {
            "code" : "11967001",
            "display" : "Kerry Hill sheep (organism)"
          },
          {
            "code" : "11980003",
            "display" : "Burn of foot (disorder)"
          },
          {
            "code" : "11993008",
            "display" : "Male first cousin (person)"
          },
          {
            "code" : "11999007",
            "display" : "Inactive tuberculosis (disorder)"
          },
          {
            "code" : "12001002",
            "display" : "Thionine stain (substance)"
          },
          {
            "code" : "12006007",
            "display" : "Ureaplasma urealyticum (organism)"
          },
          {
            "code" : "12010005",
            "display" : "Osteodystrophy (disorder)"
          },
          {
            "code" : "12026006",
            "display" : "Paroxysmal tachycardia (disorder)"
          },
          {
            "code" : "12030009",
            "display" : "Sudan II stain (substance)"
          },
          {
            "code" : "12052000",
            "display" : "Structure of ovarian artery (body structure)"
          },
          {
            "code" : "12063002",
            "display" : "Rectal hemorrhage (disorder)"
          },
          {
            "code" : "12091005",
            "display" : "Brittany spaniel (organism)"
          },
          {
            "code" : "12119009",
            "display" : "Water soluble nigrosine stain (substance)"
          },
          {
            "code" : "12123001",
            "display" : "Internal jugular vein structure (body structure)"
          },
          {
            "code" : "12130007",
            "display" : "Intra-articular route (qualifier value)"
          },
          {
            "code" : "12131006",
            "display" : "Miniature pinscher dog (organism)"
          },
          {
            "code" : "12132004",
            "display" : "Langenbeck operation, cleft palate repair (procedure)"
          },
          {
            "code" : "12136001",
            "display" : "Anal psychosexual phase (finding)"
          },
          {
            "code" : "12169001",
            "display" : "Granular cell tumor (morphologic abnormality)"
          },
          {
            "code" : "12184005",
            "display" : "Visual field defect (finding)"
          },
          {
            "code" : "12188008",
            "display" : "Parainfluenza (disorder)"
          },
          {
            "code" : "12196003",
            "display" : "Structure of subscapular axillary lymph node (body structure)"
          },
          {
            "code" : "12204004",
            "display" : "Closed fracture of multiple ribs (disorder)"
          },
          {
            "code" : "12220009",
            "display" : "Genus Coxiella (organism)"
          },
          {
            "code" : "12232008",
            "display" : "Syphilitic aneurysm of aorta (disorder)"
          },
          {
            "code" : "12239004",
            "display" : "Throat clearing (observable entity)"
          },
          {
            "code" : "12261009",
            "display" : "Writing (observable entity)"
          },
          {
            "code" : "12274003",
            "display" : "Acute peptic ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "12295008",
            "display" : "Bronchiectasis (disorder)"
          },
          {
            "code" : "12309006",
            "display" : "Posterior nasal fricative, function (observable entity)"
          },
          {
            "code" : "12312009",
            "display" : "Premature infancy (finding)"
          },
          {
            "code" : "12335007",
            "display" : "Product containing amidotrizoate (medicinal product)"
          },
          {
            "code" : "12337004",
            "display" : "Disorder of uterus (disorder)"
          },
          {
            "code" : "12351004",
            "display" : "Crowding of teeth (disorder)"
          },
          {
            "code" : "12360007",
            "display" : "Missouri fox trotting horse (organism)"
          },
          {
            "code" : "12373006",
            "display" : "Chronic gonococcal bartholinitis (disorder)"
          },
          {
            "code" : "12380008",
            "display" : "Sedative, hypnotic AND/OR anxiolytic-induced sexual dysfunction (finding)"
          },
          {
            "code" : "12390000",
            "display" : "American pit bull terrier (organism)"
          },
          {
            "code" : "12398007",
            "display" : "Excision of endometrial synechiae (procedure)"
          },
          {
            "code" : "12402003",
            "display" : "Scar (morphologic abnormality)"
          },
          {
            "code" : "12405001",
            "display" : "Spitting (observable entity)"
          },
          {
            "code" : "12407009",
            "display" : "Swedish landrace pig (organism)"
          },
          {
            "code" : "12430003",
            "display" : "Furuncle of buttock (disorder)"
          },
          {
            "code" : "12454008",
            "display" : "Cauda equina syndrome with neurogenic bladder (disorder)"
          },
          {
            "code" : "12463005",
            "display" : "Infectious gastroenteritis (disorder)"
          },
          {
            "code" : "12503006",
            "display" : "Aluminium (substance)"
          },
          {
            "code" : "12510000",
            "display" : "Eucalyptus oil (substance)"
          },
          {
            "code" : "12519004",
            "display" : "Sprain of sacroiliac ligament (disorder)"
          },
          {
            "code" : "12556008",
            "display" : "Tamils (ethnic group)"
          },
          {
            "code" : "12574004",
            "display" : "Noninfectious gastroenteritis (disorder)"
          },
          {
            "code" : "12584003",
            "display" : "Bone pain (finding)"
          },
          {
            "code" : "12597001",
            "display" : "Tin (substance)"
          },
          {
            "code" : "12611008",
            "display" : "Bone structure of tibia (body structure)"
          },
          {
            "code" : "12631007",
            "display" : "Calcium restricted diet (finding)"
          },
          {
            "code" : "12658000",
            "display" : "Operation on female genital organs (procedure)"
          },
          {
            "code" : "12660003",
            "display" : "Repair of complete shoulder cuff avulsion, chronic (procedure)"
          },
          {
            "code" : "12676007",
            "display" : "Fracture of radius (disorder)"
          },
          {
            "code" : "12691009",
            "display" : "Structure of brachiocephalic artery (body structure)"
          },
          {
            "code" : "12710003",
            "display" : "Hematoxylin stain (substance)"
          },
          {
            "code" : "12720008",
            "display" : "Femininity (finding)"
          },
          {
            "code" : "12728001",
            "display" : "Structure of superficial popliteal lymph node (body structure)"
          },
          {
            "code" : "12729009",
            "display" : "Prolonged rupture of membranes (disorder)"
          },
          {
            "code" : "12738006",
            "display" : "Brain structure (body structure)"
          },
          {
            "code" : "12770006",
            "display" : "Cyanotic congenital heart disease (disorder)"
          },
          {
            "code" : "12800002",
            "display" : "Structure of atrioventricular node branch of right coronary artery (body structure)"
          },
          {
            "code" : "12801003",
            "display" : "Iodamide meglumine (substance)"
          },
          {
            "code" : "12820001",
            "display" : "Disorder of sacrum (disorder)"
          },
          {
            "code" : "12826007",
            "display" : "Dorrance operation, push-back operation for cleft palate (procedure)"
          },
          {
            "code" : "12847006",
            "display" : "Acute duodenal ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "12852001",
            "display" : "Internal rotation, function (observable entity)"
          },
          {
            "code" : "12866006",
            "display" : "Administration of vaccine product containing only Streptococcus pneumoniae antigen (procedure)"
          },
          {
            "code" : "12867002",
            "display" : "Fetal distress affecting management of mother (disorder)"
          },
          {
            "code" : "12872006",
            "display" : "Head of rib structure (body structure)"
          },
          {
            "code" : "12881000",
            "display" : "Bone structure of proximal radius (body structure)"
          },
          {
            "code" : "12882007",
            "display" : "Coital endurance (finding)"
          },
          {
            "code" : "12905008",
            "display" : "Hypoglycemia diet (finding)"
          },
          {
            "code" : "12921003",
            "display" : "Structure of pelvis (body structure)"
          },
          {
            "code" : "12958003",
            "display" : "Spinal cord gray matter structure (body structure)"
          },
          {
            "code" : "12962009",
            "display" : "Histoplasmosis (disorder)"
          },
          {
            "code" : "13024002",
            "display" : "Tendon structure (body structure)"
          },
          {
            "code" : "13045009",
            "display" : "Anisocoria (disorder)"
          },
          {
            "code" : "13050003",
            "display" : "Structure of purkinje fibers (body structure)"
          },
          {
            "code" : "13059002",
            "display" : "Congenital ichthyosis of skin (disorder)"
          },
          {
            "code" : "13080008",
            "display" : "Clostridium botulinum (organism)"
          },
          {
            "code" : "13091001",
            "display" : "Dilation and curettage (procedure)"
          },
          {
            "code" : "13094009",
            "display" : "Apnea in the newborn (finding)"
          },
          {
            "code" : "13095005",
            "display" : "Primary symptomatic early syphilis (disorder)"
          },
          {
            "code" : "13126002",
            "display" : "Vaccinia virus (organism)"
          },
          {
            "code" : "13132007",
            "display" : "Product containing dextran (medicinal product)"
          },
          {
            "code" : "13164000",
            "display" : "Reduced visual acuity (finding)"
          },
          {
            "code" : "13197004",
            "display" : "Contraception (finding)"
          },
          {
            "code" : "13200003",
            "display" : "Peptic ulcer (disorder)"
          },
          {
            "code" : "13213009",
            "display" : "Congenital heart disease (disorder)"
          },
          {
            "code" : "13233008",
            "display" : "Flathead (ethnic group)"
          },
          {
            "code" : "13236000",
            "display" : "Congenital spondylolisthesis (disorder)"
          },
          {
            "code" : "13237009",
            "display" : "Cesium-131 (substance)"
          },
          {
            "code" : "13248002",
            "display" : "Chesapeake Bay retriever (organism)"
          },
          {
            "code" : "13254001",
            "display" : "Abdominal hysterectomy with colpo-urethrocystopexy, Marshall-Marchetti-Krantz type (procedure)"
          },
          {
            "code" : "13267003",
            "display" : "Gastric motor function disorder (disorder)"
          },
          {
            "code" : "13277001",
            "display" : "Cystic acne (disorder)"
          },
          {
            "code" : "13278006",
            "display" : "Fall from swing (event)"
          },
          {
            "code" : "13283003",
            "display" : "Tissue processing technique (procedure)"
          },
          {
            "code" : "13284009",
            "display" : "Yorkshire terrier (organism)"
          },
          {
            "code" : "13290008",
            "display" : "Aneurysm of iliac artery (disorder)"
          },
          {
            "code" : "13301002",
            "display" : "Cellulitis of knee (disorder)"
          },
          {
            "code" : "13310005",
            "display" : "Taboparesis (disorder)"
          },
          {
            "code" : "13363002",
            "display" : "Structure of posterior tibial artery (body structure)"
          },
          {
            "code" : "13370002",
            "display" : "Plantar fascial fibromatosis (disorder)"
          },
          {
            "code" : "13383001",
            "display" : "Structure of apex of heart (body structure)"
          },
          {
            "code" : "13418002",
            "display" : "Structure of outflow tract of left ventricle (body structure)"
          },
          {
            "code" : "13438001",
            "display" : "Overanxious disorder of childhood (disorder)"
          },
          {
            "code" : "13440006",
            "display" : "Tanganyikans (ethnic group)"
          },
          {
            "code" : "13445001",
            "display" : "Ménière's disease (disorder)"
          },
          {
            "code" : "13468005",
            "display" : "Sensitive dentin (disorder)"
          },
          {
            "code" : "13482005",
            "display" : "Structure of lymph node of head (body structure)"
          },
          {
            "code" : "13487004",
            "display" : "Shire horse (organism)"
          },
          {
            "code" : "13506008",
            "display" : "Maternal age (observable entity)"
          },
          {
            "code" : "13529000",
            "display" : "Nasal septoplasty (procedure)"
          },
          {
            "code" : "13544004",
            "display" : "Belted Galloway cattle breed (organism)"
          },
          {
            "code" : "13561001",
            "display" : "Lacrimal gland structure (body structure)"
          },
          {
            "code" : "13576009",
            "display" : "Fetal umbilical vein structure (body structure)"
          },
          {
            "code" : "13577000",
            "display" : "Nut (substance)"
          },
          {
            "code" : "13595002",
            "display" : "Torsion of ovary (disorder)"
          },
          {
            "code" : "13600006",
            "display" : "Folliculitis (disorder)"
          },
          {
            "code" : "13601005",
            "display" : "Paranoid personality disorder (disorder)"
          },
          {
            "code" : "13607009",
            "display" : "Manual examination of breast (procedure)"
          },
          {
            "code" : "13617004",
            "display" : "Tracheobronchitis (disorder)"
          },
          {
            "code" : "13619001",
            "display" : "Thyroidectomy (procedure)"
          },
          {
            "code" : "13629008",
            "display" : "Hypothermia of newborn (disorder)"
          },
          {
            "code" : "13644009",
            "display" : "Hypercholesterolemia (disorder)"
          },
          {
            "code" : "13645005",
            "display" : "Chronic obstructive lung disease (disorder)"
          },
          {
            "code" : "13647002",
            "display" : "Right coronary artery structure (body structure)"
          },
          {
            "code" : "13648007",
            "display" : "Urethral structure (body structure)"
          },
          {
            "code" : "13652007",
            "display" : "Silicone (substance)"
          },
          {
            "code" : "13653002",
            "display" : "Cestrum parqui (organism)"
          },
          {
            "code" : "13662000",
            "display" : "Anastomosis of pulmonary-subclavian artery by Blalock-Taussig operation (procedure)"
          },
          {
            "code" : "13687007",
            "display" : "Human herpes simplex virus type 2 (organism)"
          },
          {
            "code" : "13689005",
            "display" : "Congenital anomaly of aortic valve (disorder)"
          },
          {
            "code" : "13711007",
            "display" : "Fall from slide (event)"
          },
          {
            "code" : "13714004",
            "display" : "Arthroscopy (procedure)"
          },
          {
            "code" : "13731006",
            "display" : "Secondary symptomatic early syphilis (disorder)"
          },
          {
            "code" : "13744001",
            "display" : "Methyl red stain (substance)"
          },
          {
            "code" : "13746004",
            "display" : "Bipolar disorder (disorder)"
          },
          {
            "code" : "13753008",
            "display" : "Hemifacial spasm (finding)"
          },
          {
            "code" : "13755001",
            "display" : "Corynebacterium diphtheriae type mitis (organism)"
          },
          {
            "code" : "13758004",
            "display" : "Paraphimosis (disorder)"
          },
          {
            "code" : "13791008",
            "display" : "Asthenia (finding)"
          },
          {
            "code" : "13793006",
            "display" : "Extracapsular extraction of lens (procedure)"
          },
          {
            "code" : "13802001",
            "display" : "Abscess of axilla (disorder)"
          },
          {
            "code" : "13867009",
            "display" : "Preductal coarctation of aorta (disorder)"
          },
          {
            "code" : "13879009",
            "display" : "Acinetobacter junii (organism)"
          },
          {
            "code" : "13881006",
            "display" : "Zygomatic bone structure (body structure)"
          },
          {
            "code" : "13910004",
            "display" : "Combined anteroposterior colporrhaphy (procedure)"
          },
          {
            "code" : "13920009",
            "display" : "Hepatic encephalopathy (disorder)"
          },
          {
            "code" : "13931001",
            "display" : "Osmium tetroxide (substance)"
          },
          {
            "code" : "13934009",
            "display" : "Panama sheep (organism)"
          },
          {
            "code" : "13935005",
            "display" : "Fall down elevator shaft (event)"
          },
          {
            "code" : "13942005",
            "display" : "Toy Manchester terrier (organism)"
          },
          {
            "code" : "13953004",
            "display" : "Vesicular stomatitis virus, Brazil (organism)"
          },
          {
            "code" : "13954005",
            "display" : "Ischemic ulcer (disorder)"
          },
          {
            "code" : "13958008",
            "display" : "Structure of superior fronto-occipital fasciculus (body structure)"
          },
          {
            "code" : "13964001",
            "display" : "Iron supplement infant formula (finding)"
          },
          {
            "code" : "13973009",
            "display" : "Grand mal status (disorder)"
          },
          {
            "code" : "14016003",
            "display" : "Bone marrow structure (body structure)"
          },
          {
            "code" : "14044002",
            "display" : "Sodium restricted diet, 20 milliequivalents (finding)"
          },
          {
            "code" : "14045001",
            "display" : "Caucasian (ethnic group)"
          },
          {
            "code" : "14047009",
            "display" : "Fall from building (event)"
          },
          {
            "code" : "14058000",
            "display" : "Asynclitism (finding)"
          },
          {
            "code" : "14063001",
            "display" : "FHC elite pig 9 (organism)"
          },
          {
            "code" : "14070001",
            "display" : "Multi-infarct dementia with depression (disorder)"
          },
          {
            "code" : "14071002",
            "display" : "Strontium-90 (substance)"
          },
          {
            "code" : "14080002",
            "display" : "Illegitimate pregnancy, life event (finding)"
          },
          {
            "code" : "14089001",
            "display" : "Red blood cell count (procedure)"
          },
          {
            "code" : "14094001",
            "display" : "Excessive vomiting in pregnancy (disorder)"
          },
          {
            "code" : "14106009",
            "display" : "Cardiac pacemaker, device (physical object)"
          },
          {
            "code" : "14121003",
            "display" : "Legionella steigerwaltii (organism)"
          },
          {
            "code" : "14140009",
            "display" : "Hyperkalemia (disorder)"
          },
          {
            "code" : "14151009",
            "display" : "Hyperesthesia (finding)"
          },
          {
            "code" : "14152002",
            "display" : "Intravenous infusion (procedure)"
          },
          {
            "code" : "14156004",
            "display" : "Racemose aneurysm (morphologic abnormality)"
          },
          {
            "code" : "14176005",
            "display" : "Danes (ethnic group)"
          },
          {
            "code" : "14189004",
            "display" : "Measles (disorder)"
          },
          {
            "code" : "14205002",
            "display" : "Lithotomy position (finding)"
          },
          {
            "code" : "14223005",
            "display" : "Esophageal varices without bleeding (disorder)"
          },
          {
            "code" : "14245006",
            "display" : "Rottweiler dog (organism)"
          },
          {
            "code" : "14286004",
            "display" : "Fornication (finding)"
          },
          {
            "code" : "14302001",
            "display" : "Amenorrhea (finding)"
          },
          {
            "code" : "14304000",
            "display" : "Disorder of thyroid gland (disorder)"
          },
          {
            "code" : "14336007",
            "display" : "Ruptured abdominal aortic aneurysm (disorder)"
          },
          {
            "code" : "14345008",
            "display" : "Parent/child conflict (finding)"
          },
          {
            "code" : "14350002",
            "display" : "Angiomatosis (morphologic abnormality)"
          },
          {
            "code" : "14357004",
            "display" : "Ischemic optic neuropathy (disorder)"
          },
          {
            "code" : "14366000",
            "display" : "Exposure keratoconjunctivitis (disorder)"
          },
          {
            "code" : "14402002",
            "display" : "Wood (substance)"
          },
          {
            "code" : "14410001",
            "display" : "T3 category (finding)"
          },
          {
            "code" : "14414005",
            "display" : "Peripheral (qualifier value)"
          },
          {
            "code" : "14423008",
            "display" : "Adhesive bandage, device (physical object)"
          },
          {
            "code" : "14443002",
            "display" : "Substance with aminoglycoside structure and antibacterial mechanism of action (substance)"
          },
          {
            "code" : "14448006",
            "display" : "Swallowed foreign body (disorder)"
          },
          {
            "code" : "14456009",
            "display" : "Measuring height of patient (procedure)"
          },
          {
            "code" : "14466001",
            "display" : "Bread exchange list (finding)"
          },
          {
            "code" : "14468000",
            "display" : "Sports activity (observable entity)"
          },
          {
            "code" : "14470009",
            "display" : "Tutsi (ethnic group)"
          },
          {
            "code" : "14502000",
            "display" : "Supination, function (observable entity)"
          },
          {
            "code" : "14510004",
            "display" : "Structure of angle of rib (body structure)"
          },
          {
            "code" : "14520009",
            "display" : "Lid retraction (finding)"
          },
          {
            "code" : "14529005",
            "display" : "Gadolinium-153 (substance)"
          },
          {
            "code" : "14532008",
            "display" : "Congenital anomaly of trachea (disorder)"
          },
          {
            "code" : "14537002",
            "display" : "Hodgkin lymphoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "14544006",
            "display" : "Methyl violet 6B stain (substance)"
          },
          {
            "code" : "14560005",
            "display" : "Dermal mycosis (disorder)"
          },
          {
            "code" : "14590003",
            "display" : "Chlamydophila psittaci (organism)"
          },
          {
            "code" : "14621004",
            "display" : "Anticipatory grief (finding)"
          },
          {
            "code" : "14627000",
            "display" : "Increased protein diet (finding)"
          },
          {
            "code" : "14661003",
            "display" : "Diminished libido due to mood (finding)"
          },
          {
            "code" : "14664006",
            "display" : "Epidermal burn of hand (disorder)"
          },
          {
            "code" : "14669001",
            "display" : "Acute renal failure syndrome (disorder)"
          },
          {
            "code" : "14691008",
            "display" : "Yttrium-90 (substance)"
          },
          {
            "code" : "14734007",
            "display" : "Administrative procedure (procedure)"
          },
          {
            "code" : "14738005",
            "display" : "Globus pallidus structure (body structure)"
          },
          {
            "code" : "14742008",
            "display" : "Structure of large intestine (body structure)"
          },
          {
            "code" : "14747002",
            "display" : "Elective immunization for international travel (procedure)"
          },
          {
            "code" : "14756005",
            "display" : "Parotitis (disorder)"
          },
          {
            "code" : "14760008",
            "display" : "Constipation (finding)"
          },
          {
            "code" : "14766002",
            "display" : "Aspiration (procedure)"
          },
          {
            "code" : "14769009",
            "display" : "Tilt test (procedure)"
          },
          {
            "code" : "14770005",
            "display" : "Structure of deciduous mandibular left lateral incisor tooth (body structure)"
          },
          {
            "code" : "14783006",
            "display" : "Hyperbilirubinemia (disorder)"
          },
          {
            "code" : "14799000",
            "display" : "Neoplasm, metastatic (morphologic abnormality)"
          },
          {
            "code" : "14804005",
            "display" : "Creatine (substance)"
          },
          {
            "code" : "14806007",
            "display" : "Bone structure of atlas (body structure)"
          },
          {
            "code" : "14812002",
            "display" : "Cellulitis of penis (disorder)"
          },
          {
            "code" : "14876008",
            "display" : "Pharaoh hound (organism)"
          },
          {
            "code" : "14892003",
            "display" : "Lateral funiculus structure (body structure)"
          },
          {
            "code" : "14893008",
            "display" : "Burn of hand (disorder)"
          },
          {
            "code" : "14895001",
            "display" : "Fat exchange list (finding)"
          },
          {
            "code" : "14900002",
            "display" : "Radiotherapy-induced hypopituitarism (disorder)"
          },
          {
            "code" : "14901003",
            "display" : "Ankylosis of tooth (disorder)"
          },
          {
            "code" : "14910006",
            "display" : "Inspiration (observable entity)"
          },
          {
            "code" : "14911005",
            "display" : "Subphrenic interposition syndrome (disorder)"
          },
          {
            "code" : "14926007",
            "display" : "pM1 category (finding)"
          },
          {
            "code" : "14944004",
            "display" : "Primitive aortic structure (body structure)"
          },
          {
            "code" : "14949009",
            "display" : "Old disruption of ligament of knee (disorder)"
          },
          {
            "code" : "14951008",
            "display" : "Fatherhood (observable entity)"
          },
          {
            "code" : "14958002",
            "display" : "Naphthol green B stain (substance)"
          },
          {
            "code" : "14973001",
            "display" : "Renal sclerosis with hypertension (disorder)"
          },
          {
            "code" : "14975008",
            "display" : "Forearm structure (body structure)"
          },
          {
            "code" : "14981000",
            "display" : "Urethral fistula (disorder)"
          },
          {
            "code" : "14990007",
            "display" : "Chondrosarcoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "14999008",
            "display" : "Welsh (ethnic group)"
          },
          {
            "code" : "15013002",
            "display" : "Vitreous floaters (disorder)"
          },
          {
            "code" : "15018006",
            "display" : "Laparoscopic repair of inguinal hernia (procedure)"
          },
          {
            "code" : "15020009",
            "display" : "Domestic shorthaired cat (organism)"
          },
          {
            "code" : "15023006",
            "display" : "Thromboendarterectomy with graft of carotid artery by neck incision (procedure)"
          },
          {
            "code" : "15028002",
            "display" : "Abnormal fetal presentation (finding)"
          },
          {
            "code" : "15033003",
            "display" : "Peritonsillar abscess (disorder)"
          },
          {
            "code" : "15037002",
            "display" : "Formication (finding)"
          },
          {
            "code" : "15086000",
            "display" : "African American (ethnic group)"
          },
          {
            "code" : "15108003",
            "display" : "Restricted fiber diet (finding)"
          },
          {
            "code" : "15119000",
            "display" : "Accessory nerve structure (body structure)"
          },
          {
            "code" : "15158005",
            "display" : "Air (substance)"
          },
          {
            "code" : "15167005",
            "display" : "Alcohol abuse (disorder)"
          },
          {
            "code" : "15171008",
            "display" : "Poodle superbreed (organism)"
          },
          {
            "code" : "15182000",
            "display" : "Coffin-Lowry syndrome (disorder)"
          },
          {
            "code" : "15185003",
            "display" : "Contact with machinery (event)"
          },
          {
            "code" : "15188001",
            "display" : "Hearing loss (disorder)"
          },
          {
            "code" : "15203004",
            "display" : "Sudden visual loss (disorder)"
          },
          {
            "code" : "15220000",
            "display" : "Laboratory test (procedure)"
          },
          {
            "code" : "15238002",
            "display" : "Esophageal bleeding (disorder)"
          },
          {
            "code" : "15241006",
            "display" : "Disorder of autonomic nervous system (disorder)"
          },
          {
            "code" : "15250008",
            "display" : "Disorder of cornea (disorder)"
          },
          {
            "code" : "15258001",
            "display" : "Subclavian steal syndrome (disorder)"
          },
          {
            "code" : "15280003",
            "display" : "Decreased bowel sounds (finding)"
          },
          {
            "code" : "15296000",
            "display" : "Sterility (finding)"
          },
          {
            "code" : "15302007",
            "display" : "Human herpes simplex virus type 1 (organism)"
          },
          {
            "code" : "15346004",
            "display" : "Familial hypoalphalipoproteinemia (disorder)"
          },
          {
            "code" : "15361003",
            "display" : "Operation of a device, function (observable entity)"
          },
          {
            "code" : "15362005",
            "display" : "Hyperalimentation formula for severe diarrhea (finding)"
          },
          {
            "code" : "15376006",
            "display" : "Infant development screening (procedure)"
          },
          {
            "code" : "15384005",
            "display" : "Erotic stimulus (finding)"
          },
          {
            "code" : "15385006",
            "display" : "Closed fracture of medial malleolus (disorder)"
          },
          {
            "code" : "15394000",
            "display" : "Toxemia of pregnancy (disorder)"
          },
          {
            "code" : "15405008",
            "display" : "Late ejaculation (finding)"
          },
          {
            "code" : "15413009",
            "display" : "High forceps delivery with episiotomy (procedure)"
          },
          {
            "code" : "15415002",
            "display" : "Injection of amnion (procedure)"
          },
          {
            "code" : "15422005",
            "display" : "Structure of mandibular right central incisor tooth (body structure)"
          },
          {
            "code" : "15425007",
            "display" : "Peritoneum (serous membrane) structure (body structure)"
          },
          {
            "code" : "15443006",
            "display" : "Yuca pig (organism)"
          },
          {
            "code" : "15454001",
            "display" : "Increased size (finding)"
          },
          {
            "code" : "15459006",
            "display" : "Endocardial cushion defect (disorder)"
          },
          {
            "code" : "15483003",
            "display" : "Administration of vaccine product containing only Salmonella enterica subspecies enterica serovar Typhi antigen (procedure)"
          },
          {
            "code" : "15497006",
            "display" : "Ovarian structure (body structure)"
          },
          {
            "code" : "15502008",
            "display" : "Wound treatment education (procedure)"
          },
          {
            "code" : "15504009",
            "display" : "Rupture of gravid uterus (disorder)"
          },
          {
            "code" : "15508007",
            "display" : "High risk of (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "15529003",
            "display" : "Rosolic acid sodium salt stain (substance)"
          },
          {
            "code" : "15544002",
            "display" : "Restrictive cardiomyopathy secondary to infiltrations (disorder)"
          },
          {
            "code" : "15550007",
            "display" : "Open wound of wrist with tendon involvement (disorder)"
          },
          {
            "code" : "15555002",
            "display" : "Acute pericarditis (disorder)"
          },
          {
            "code" : "15574005",
            "display" : "Fracture of foot (disorder)"
          },
          {
            "code" : "15617002",
            "display" : "Ligation of varicose vein of lower limb (procedure)"
          },
          {
            "code" : "15628003",
            "display" : "Gonorrhea (disorder)"
          },
          {
            "code" : "15639000",
            "display" : "Moderate major depression, single episode (disorder)"
          },
          {
            "code" : "15662003",
            "display" : "Senile dementia (disorder)"
          },
          {
            "code" : "15665001",
            "display" : "Structure of latissimus dorsi muscle (body structure)"
          },
          {
            "code" : "15672000",
            "display" : "Structure of superficial temporal artery (body structure)"
          },
          {
            "code" : "15689008",
            "display" : "Pseudohypoaldosteronism, type 2 (disorder)"
          },
          {
            "code" : "15690004",
            "display" : "Tortuosity (morphologic abnormality)"
          },
          {
            "code" : "15698006",
            "display" : "Lysergic acid diethylamide (substance)"
          },
          {
            "code" : "15721002",
            "display" : "Protein supplementary feedings diet (finding)"
          },
          {
            "code" : "15763003",
            "display" : "Structure of perforating artery of kidney (body structure)"
          },
          {
            "code" : "15771004",
            "display" : "Diabetes insipidus (disorder)"
          },
          {
            "code" : "15775008",
            "display" : "Structure of corneal epithelium (body structure)"
          },
          {
            "code" : "15776009",
            "display" : "Pancreatic structure (body structure)"
          },
          {
            "code" : "15801006",
            "display" : "Kapingas (ethnic group)"
          },
          {
            "code" : "15802004",
            "display" : "Dystonia (disorder)"
          },
          {
            "code" : "15803009",
            "display" : "Bladder pain (finding)"
          },
          {
            "code" : "15805002",
            "display" : "Acute sinusitis (disorder)"
          },
          {
            "code" : "15825003",
            "display" : "Aortic structure (body structure)"
          },
          {
            "code" : "15840001",
            "display" : "Symptomatic fetishism (disorder)"
          },
          {
            "code" : "15842009",
            "display" : "Thrombosis of renal vein (disorder)"
          },
          {
            "code" : "15848008",
            "display" : "Noninflammatory disorder of broad ligament (disorder)"
          },
          {
            "code" : "15859004",
            "display" : "Chronic hemodialysis diet (finding)"
          },
          {
            "code" : "15867007",
            "display" : "Intersexuality (finding)"
          },
          {
            "code" : "15869005",
            "display" : "Dosimeter, device (physical object)"
          },
          {
            "code" : "15886004",
            "display" : "Screening for cancer (procedure)"
          },
          {
            "code" : "15896008",
            "display" : "Methyl violet 2B stain (substance)"
          },
          {
            "code" : "15902003",
            "display" : "Gastric ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "15924003",
            "display" : "Maxillary sinus structure (body structure)"
          },
          {
            "code" : "15938005",
            "display" : "Eclampsia (disorder)"
          },
          {
            "code" : "15961007",
            "display" : "British saddleback pig (organism)"
          },
          {
            "code" : "15966002",
            "display" : "Short coat chihuahua (organism)"
          },
          {
            "code" : "15993004",
            "display" : "Alveolar hypoventilation (finding)"
          },
          {
            "code" : "15997003",
            "display" : "Postoperative wound abscess (disorder)"
          },
          {
            "code" : "16001004",
            "display" : "Otalgia (finding)"
          },
          {
            "code" : "16013009",
            "display" : "Hyperalimentation formula for short bowel syndrome (finding)"
          },
          {
            "code" : "16015002",
            "display" : "Anglo nubian goat (organism)"
          },
          {
            "code" : "16041008",
            "display" : "Female hypogonadism syndrome (disorder)"
          },
          {
            "code" : "16046003",
            "display" : "Muscle rigidity (finding)"
          },
          {
            "code" : "16050005",
            "display" : "Structure of pancreaticosplenic lymph node (body structure)"
          },
          {
            "code" : "16051009",
            "display" : "Structure of apical axillary lymph node (body structure)"
          },
          {
            "code" : "16070004",
            "display" : "Syphilitic cirrhosis (disorder)"
          },
          {
            "code" : "16114001",
            "display" : "Fracture of ankle (disorder)"
          },
          {
            "code" : "16116004",
            "display" : "Acute lymphadenopathic toxoplasmosis (disorder)"
          },
          {
            "code" : "16124009",
            "display" : "Sexual inadequacy (finding)"
          },
          {
            "code" : "16146001",
            "display" : "Viral bronchitis (disorder)"
          },
          {
            "code" : "16196000",
            "display" : "Cytomegaloviral mononucleosis (disorder)"
          },
          {
            "code" : "16207008",
            "display" : "Postmature infancy (finding)"
          },
          {
            "code" : "16208003",
            "display" : "Low fat diet (finding)"
          },
          {
            "code" : "16217003",
            "display" : "Shock due to anesthesia (disorder)"
          },
          {
            "code" : "16228004",
            "display" : "Structure of paravaginal lymph node (body structure)"
          },
          {
            "code" : "16239001",
            "display" : "Structure of myocardium of inferolateral region (body structure)"
          },
          {
            "code" : "16241000",
            "display" : "Genus Chlamydia (organism)"
          },
          {
            "code" : "16251004",
            "display" : "Skin structure of upper lip (body structure)"
          },
          {
            "code" : "16269008",
            "display" : "Neuralgia (finding)"
          },
          {
            "code" : "16294009",
            "display" : "Splenomegaly (disorder)"
          },
          {
            "code" : "16297002",
            "display" : "Congenital hydronephrosis (disorder)"
          },
          {
            "code" : "16310003",
            "display" : "Diagnostic ultrasonography (procedure)"
          },
          {
            "code" : "16331000",
            "display" : "Heartburn (finding)"
          },
          {
            "code" : "16349000",
            "display" : "Orthopedic device (physical object)"
          },
          {
            "code" : "16356006",
            "display" : "Multiple pregnancy (disorder)"
          },
          {
            "code" : "16358007",
            "display" : "Chronic disease of tonsils AND/OR adenoids (disorder)"
          },
          {
            "code" : "16361008",
            "display" : "Autopsy, gross and microscopic examination, stillborn or newborn (procedure)"
          },
          {
            "code" : "16362001",
            "display" : "Human poliovirus 3 (organism)"
          },
          {
            "code" : "16379007",
            "display" : "Water-electrolyte balance, function (observable entity)"
          },
          {
            "code" : "16386004",
            "display" : "Dry skin (finding)"
          },
          {
            "code" : "16399001",
            "display" : "Difficulty coping with pain (finding)"
          },
          {
            "code" : "16402000",
            "display" : "Sickle cell trait (disorder)"
          },
          {
            "code" : "16430000",
            "display" : "Oral psychosexual phase (finding)"
          },
          {
            "code" : "16439004",
            "display" : "Trichinella spiralis (organism)"
          },
          {
            "code" : "16445007",
            "display" : "Homosexual forcible assault (event)"
          },
          {
            "code" : "16459000",
            "display" : "Cheilosis (disorder)"
          },
          {
            "code" : "16487009",
            "display" : "Female adolescent sexual promiscuity (finding)"
          },
          {
            "code" : "16506000",
            "display" : "Mixed bipolar I disorder (disorder)"
          },
          {
            "code" : "16528000",
            "display" : "Bombay cat (organism)"
          },
          {
            "code" : "16545005",
            "display" : "Operation on nervous system (procedure)"
          },
          {
            "code" : "16564004",
            "display" : "Hartmann operation, rectal resection (procedure)"
          },
          {
            "code" : "16567006",
            "display" : "Mesocardia (disorder)"
          },
          {
            "code" : "16584000",
            "display" : "Administration of vaccine product containing only Hepatitis B virus antigen (procedure)"
          },
          {
            "code" : "16596007",
            "display" : "Esotropia (disorder)"
          },
          {
            "code" : "16607004",
            "display" : "Missed abortion (disorder)"
          },
          {
            "code" : "16611005",
            "display" : "Relative frigidity (finding)"
          },
          {
            "code" : "16621002",
            "display" : "Skin structure of temporal region (body structure)"
          },
          {
            "code" : "16630005",
            "display" : "Parietal lobe structure (body structure)"
          },
          {
            "code" : "16631009",
            "display" : "Transverse myelopathy syndrome (disorder)"
          },
          {
            "code" : "16644004",
            "display" : "Radial neuropathy (disorder)"
          },
          {
            "code" : "16726004",
            "display" : "Renal osteodystrophy (disorder)"
          },
          {
            "code" : "16736007",
            "display" : "Transcatheter therapy for embolization (procedure)"
          },
          {
            "code" : "16761005",
            "display" : "Esophagitis (disorder)"
          },
          {
            "code" : "16788000",
            "display" : "Naphthalene black 12B stain (substance)"
          },
          {
            "code" : "16809003",
            "display" : "Open wound of abdominal wall with complication (disorder)"
          },
          {
            "code" : "16811007",
            "display" : "Structure of buccal mucosa (body structure)"
          },
          {
            "code" : "16814004",
            "display" : "Pneumococcal infectious disease (disorder)"
          },
          {
            "code" : "16819009",
            "display" : "Delivery of face presentation (procedure)"
          },
          {
            "code" : "16836001",
            "display" : "Azure A stain (substance)"
          },
          {
            "code" : "16838000",
            "display" : "Mediastinal emphysema (disorder)"
          },
          {
            "code" : "16851005",
            "display" : "Mitochondrial myopathy (disorder)"
          },
          {
            "code" : "16857009",
            "display" : "Vaginal route (qualifier value)"
          },
          {
            "code" : "16914000",
            "display" : "Mycobacterium piscium (organism)"
          },
          {
            "code" : "16922007",
            "display" : "Hereditary coagulation factor deficiency (disorder)"
          },
          {
            "code" : "16932000",
            "display" : "Nausea and vomiting (disorder)"
          },
          {
            "code" : "16943008",
            "display" : "Chrysoidine Y stain (substance)"
          },
          {
            "code" : "16950007",
            "display" : "Fourth degree perineal laceration involving anal mucosa (disorder)"
          },
          {
            "code" : "16953009",
            "display" : "Elbow joint structure (body structure)"
          },
          {
            "code" : "16958000",
            "display" : "Complete congenital absence of teeth (disorder)"
          },
          {
            "code" : "16965008",
            "display" : "Insertion of intra-aortic balloon counterpulsation (procedure)"
          },
          {
            "code" : "16973004",
            "display" : "Limping (finding)"
          },
          {
            "code" : "16982005",
            "display" : "Shoulder region structure (body structure)"
          },
          {
            "code" : "16983000",
            "display" : "Death in hospital (event)"
          },
          {
            "code" : "16985007",
            "display" : "Fasting (finding)"
          },
          {
            "code" : "17044007",
            "display" : "Victim of statutory rape (finding)"
          },
          {
            "code" : "17059001",
            "display" : "Prepatellar bursitis (disorder)"
          },
          {
            "code" : "17069007",
            "display" : "Chromic phosphate (32-P) (substance)"
          },
          {
            "code" : "17076002",
            "display" : "pMX category (finding)"
          },
          {
            "code" : "17079009",
            "display" : "Acute bacterial pericarditis (disorder)"
          },
          {
            "code" : "17083009",
            "display" : "Legionella feeleii (organism)"
          },
          {
            "code" : "17095009",
            "display" : "Norwegians (ethnic group)"
          },
          {
            "code" : "17107009",
            "display" : "Mitral valve prosthesis (physical object)"
          },
          {
            "code" : "17137000",
            "display" : "Structure of brachial artery (body structure)"
          },
          {
            "code" : "17140000",
            "display" : "Neonatal jaundice due to delayed conjugation (disorder)"
          },
          {
            "code" : "17155009",
            "display" : "Trichotillomania (disorder)"
          },
          {
            "code" : "17172002",
            "display" : "Dibromofluorescein stain (substance)"
          },
          {
            "code" : "17173007",
            "display" : "Excessive thirst (finding)"
          },
          {
            "code" : "17182001",
            "display" : "Agranulocytosis (disorder)"
          },
          {
            "code" : "17190001",
            "display" : "Congenital diaphragmatic hernia (disorder)"
          },
          {
            "code" : "17209001",
            "display" : "Coitus inversus (finding)"
          },
          {
            "code" : "17222009",
            "display" : "Closed fracture of distal end of radius (disorder)"
          },
          {
            "code" : "17226007",
            "display" : "Adjustment disorder (disorder)"
          },
          {
            "code" : "17232002",
            "display" : "Structure of middle cerebral artery (body structure)"
          },
          {
            "code" : "17235000",
            "display" : "Spherocytosis (finding)"
          },
          {
            "code" : "17261001",
            "display" : "Problem of aging (finding)"
          },
          {
            "code" : "17276009",
            "display" : "Decreased fertility (finding)"
          },
          {
            "code" : "17284008",
            "display" : "Pornographic stimulation (finding)"
          },
          {
            "code" : "17293009",
            "display" : "Bilateral segmental vasectomy and ligation (procedure)"
          },
          {
            "code" : "17298000",
            "display" : "Legionella rubrilucens (organism)"
          },
          {
            "code" : "17305005",
            "display" : "Acute gonorrhea of genitourinary tract (disorder)"
          },
          {
            "code" : "17322007",
            "display" : "Disease caused by parasite (disorder)"
          },
          {
            "code" : "17329003",
            "display" : "Ureteric colic (finding)"
          },
          {
            "code" : "17338001",
            "display" : "Ventricular premature beats (disorder)"
          },
          {
            "code" : "17366009",
            "display" : "Atrial arrhythmia (disorder)"
          },
          {
            "code" : "17369002",
            "display" : "Miscarriage (disorder)"
          },
          {
            "code" : "17382005",
            "display" : "Cervical incompetence (disorder)"
          },
          {
            "code" : "17383000",
            "display" : "Toxic effect of carbon monoxide (disorder)"
          },
          {
            "code" : "17388009",
            "display" : "Structure of anterior spinal artery (body structure)"
          },
          {
            "code" : "17394001",
            "display" : "Ebstein's anomaly with atrial septal defect (disorder)"
          },
          {
            "code" : "17399006",
            "display" : "Structure of costal groove (body structure)"
          },
          {
            "code" : "17414004",
            "display" : "Contusion to heart (disorder)"
          },
          {
            "code" : "17433009",
            "display" : "Ruptured ectopic pregnancy (disorder)"
          },
          {
            "code" : "17440005",
            "display" : "Anal spasm (disorder)"
          },
          {
            "code" : "17450006",
            "display" : "Myoclonus (finding)"
          },
          {
            "code" : "17463000",
            "display" : "Closed fracture of lumbar vertebra without spinal cord injury (disorder)"
          },
          {
            "code" : "17467004",
            "display" : "Hypertrophy of nasal turbinates (disorder)"
          },
          {
            "code" : "17489000",
            "display" : "Body height normal for age (finding)"
          },
          {
            "code" : "17496003",
            "display" : "Organic anxiety disorder (disorder)"
          },
          {
            "code" : "17505006",
            "display" : "Structure of deciduous maxillary right first molar tooth (body structure)"
          },
          {
            "code" : "17532001",
            "display" : "Breech malpresentation successfully converted to cephalic presentation (disorder)"
          },
          {
            "code" : "17535004",
            "display" : "Lying in bed (finding)"
          },
          {
            "code" : "17542004",
            "display" : "Accident while engaged in work-related activity (event)"
          },
          {
            "code" : "17551007",
            "display" : "Chronic diarrhea of unknown origin (disorder)"
          },
          {
            "code" : "17552000",
            "display" : "Dental calculus (disorder)"
          },
          {
            "code" : "17561000",
            "display" : "Cardiologist (occupation)"
          },
          {
            "code" : "17579001",
            "display" : "Genus Cryptococcus (organism)"
          },
          {
            "code" : "17589002",
            "display" : "Non-calcified (qualifier value)"
          },
          {
            "code" : "17600005",
            "display" : "Diagnostic radioisotope (product)"
          },
          {
            "code" : "17602002",
            "display" : "Amyloidosis (disorder)"
          },
          {
            "code" : "17621005",
            "display" : "Normal (qualifier value)"
          },
          {
            "code" : "17623008",
            "display" : "Structure of ulnar vein (body structure)"
          },
          {
            "code" : "17629007",
            "display" : "Prenatal care education (procedure)"
          },
          {
            "code" : "17636008",
            "display" : "Specimen collection (procedure)"
          },
          {
            "code" : "17663009",
            "display" : "Tibetan terrier (organism)"
          },
          {
            "code" : "17681007",
            "display" : "Hepatitis caused by acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "17688001",
            "display" : "Klebsiella pneumoniae ss. rhinoscleromatis (organism)"
          },
          {
            "code" : "17693003",
            "display" : "Acriflavine stain (substance)"
          },
          {
            "code" : "17704007",
            "display" : "Masturbation (finding)"
          },
          {
            "code" : "17709002",
            "display" : "Bleeding esophageal varices (disorder)"
          },
          {
            "code" : "17717005",
            "display" : "Pic Cambourgh pig (organism)"
          },
          {
            "code" : "17741008",
            "display" : "Acute tonsillitis (disorder)"
          },
          {
            "code" : "17744000",
            "display" : "Subtotal hysterectomy after cesarean delivery (procedure)"
          },
          {
            "code" : "17759006",
            "display" : "Rheumatic aortic stenosis with regurgitation (disorder)"
          },
          {
            "code" : "17789004",
            "display" : "Papuans (ethnic group)"
          },
          {
            "code" : "17790008",
            "display" : "Disorder of nail (disorder)"
          },
          {
            "code" : "17849001",
            "display" : "Respiratory condition of fetus OR newborn (disorder)"
          },
          {
            "code" : "17860005",
            "display" : "Low forceps delivery with episiotomy (procedure)"
          },
          {
            "code" : "17861009",
            "display" : "Waldeyer's ring structure (body structure)"
          },
          {
            "code" : "17872004",
            "display" : "Neisseria meningitidis (organism)"
          },
          {
            "code" : "17883008",
            "display" : "Sprain of hip (disorder)"
          },
          {
            "code" : "17886000",
            "display" : "Fall from wheelchair (event)"
          },
          {
            "code" : "17894007",
            "display" : "Larva of Taenia solium (organism)"
          },
          {
            "code" : "17901006",
            "display" : "Primary hyperoxaluria (disorder)"
          },
          {
            "code" : "17902004",
            "display" : "Hyperlipoproteinemia diet, type IIb and type III (finding)"
          },
          {
            "code" : "17910003",
            "display" : "Bromine-75 (substance)"
          },
          {
            "code" : "17920008",
            "display" : "Portal vein thrombosis (disorder)"
          },
          {
            "code" : "17941002",
            "display" : "Arteriolosclerosis (morphologic abnormality)"
          },
          {
            "code" : "17945006",
            "display" : "Natural grandmother (person)"
          },
          {
            "code" : "17949000",
            "display" : "Meningoencephalitis due to acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "17957002",
            "display" : "Skin structure of antecubital fossa (body structure)"
          },
          {
            "code" : "17966003",
            "display" : "Taenia solium (organism)"
          },
          {
            "code" : "17971005",
            "display" : "Sedated (finding)"
          },
          {
            "code" : "17982002",
            "display" : "Exposure to attack by reptile (event)"
          },
          {
            "code" : "18003009",
            "display" : "Gender identity disorder of adulthood (disorder)"
          },
          {
            "code" : "18016009",
            "display" : "Phlebosclerosis (morphologic abnormality)"
          },
          {
            "code" : "18027006",
            "display" : "Transplantation of liver (procedure)"
          },
          {
            "code" : "18040001",
            "display" : "Senile osteoporosis (disorder)"
          },
          {
            "code" : "18054009",
            "display" : "Rickettsia rickettsii (organism)"
          },
          {
            "code" : "18065004",
            "display" : "Clostridium botulinum, type A (organism)"
          },
          {
            "code" : "18070006",
            "display" : "Impacted cerumen (disorder)"
          },
          {
            "code" : "18081009",
            "display" : "Enteric campylobacteriosis (disorder)"
          },
          {
            "code" : "18085000",
            "display" : "Compulsive gambling (disorder)"
          },
          {
            "code" : "18102001",
            "display" : "Mammary ductogram (procedure)"
          },
          {
            "code" : "18112008",
            "display" : "Structure of hepatic artery proper (body structure)"
          },
          {
            "code" : "18114009",
            "display" : "Prenatal examination and care of mother (procedure)"
          },
          {
            "code" : "18115005",
            "display" : "Pathologic calcification, calcified structure (morphologic abnormality)"
          },
          {
            "code" : "18149002",
            "display" : "Coccygeal vertebra structure (body structure)"
          },
          {
            "code" : "18165001",
            "display" : "Jaundice (finding)"
          },
          {
            "code" : "18167009",
            "display" : "Black African (ethnic group)"
          },
          {
            "code" : "18171007",
            "display" : "Fracture of phalanx of finger (disorder)"
          },
          {
            "code" : "18186001",
            "display" : "True compulsive fetishism (disorder)"
          },
          {
            "code" : "18193002",
            "display" : "Hypochondriasis (disorder)"
          },
          {
            "code" : "18212001",
            "display" : "Boar power pig 72 (organism)"
          },
          {
            "code" : "18214000",
            "display" : "Legionella anisa (organism)"
          },
          {
            "code" : "18220004",
            "display" : "Thyroid hormone (substance)"
          },
          {
            "code" : "18232000",
            "display" : "Difficulty coping (finding)"
          },
          {
            "code" : "18234004",
            "display" : "Optic nerve structure (body structure)"
          },
          {
            "code" : "18260003",
            "display" : "Postpartum psychosis (disorder)"
          },
          {
            "code" : "18265008",
            "display" : "Exophthalmos (disorder)"
          },
          {
            "code" : "18279000",
            "display" : "Chlamydophila psittaci variant ovis (organism)"
          },
          {
            "code" : "18283000",
            "display" : "Acquired deformity of nose (disorder)"
          },
          {
            "code" : "18286008",
            "display" : "Catheter ablation of tissue of heart (procedure)"
          },
          {
            "code" : "18302006",
            "display" : "Therapeutic abortion by hysterotomy (procedure)"
          },
          {
            "code" : "18346003",
            "display" : "Structure of serratus anterior muscle (body structure)"
          },
          {
            "code" : "18347007",
            "display" : "Spinal stenosis of lumbar region (disorder)"
          },
          {
            "code" : "18400002",
            "display" : "Klebsiella pneumoniae ss. pneumoniae (organism)"
          },
          {
            "code" : "18410006",
            "display" : "Scarred macula (disorder)"
          },
          {
            "code" : "18416000",
            "display" : "Essential hypertension complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "18417009",
            "display" : "Oligomeganephronic hypoplasia of kidney (disorder)"
          },
          {
            "code" : "18430005",
            "display" : "Gleason grade score 4 out of 10 (finding)"
          },
          {
            "code" : "18444004",
            "display" : "Structure of mucous membrane of upper lip (body structure)"
          },
          {
            "code" : "18457007",
            "display" : "Structure of hemolymph node (body structure)"
          },
          {
            "code" : "18472006",
            "display" : "Sexual relaxation (finding)"
          },
          {
            "code" : "18504008",
            "display" : "Toxic shock syndrome (disorder)"
          },
          {
            "code" : "18508006",
            "display" : "Plasmodium ovale (organism)"
          },
          {
            "code" : "18526009",
            "display" : "Disorder of appendix (disorder)"
          },
          {
            "code" : "18545000",
            "display" : "Dura mater structure (body structure)"
          },
          {
            "code" : "18546004",
            "display" : "Congenital stenosis of aortic valve (disorder)"
          },
          {
            "code" : "18557009",
            "display" : "Closure by suture (procedure)"
          },
          {
            "code" : "18559007",
            "display" : "Frank breech presentation (finding)"
          },
          {
            "code" : "18575005",
            "display" : "Oceanian (ethnic group)"
          },
          {
            "code" : "18583004",
            "display" : "Estonians (ethnic group)"
          },
          {
            "code" : "18590009",
            "display" : "Cardiac pacing (procedure)"
          },
          {
            "code" : "18619003",
            "display" : "Scleral structure (body structure)"
          },
          {
            "code" : "18625004",
            "display" : "Low forceps delivery (procedure)"
          },
          {
            "code" : "18629005",
            "display" : "Administration of drug or medicament (procedure)"
          },
          {
            "code" : "18632008",
            "display" : "Patient status determination, deceased (finding)"
          },
          {
            "code" : "18643000",
            "display" : "Ethmoidal sinusitis (disorder)"
          },
          {
            "code" : "18653004",
            "display" : "Alcohol intoxication delirium (disorder)"
          },
          {
            "code" : "18656007",
            "display" : "Grand multipara (finding)"
          },
          {
            "code" : "18664001",
            "display" : "Xavante (ethnic group)"
          },
          {
            "code" : "18665000",
            "display" : "Acute gastric mucosal erosion (disorder)"
          },
          {
            "code" : "18676001",
            "display" : "Ineffective family coping: disabling (finding)"
          },
          {
            "code" : "18686000",
            "display" : "Pectoralis minor muscle structure (body structure)"
          },
          {
            "code" : "18692006",
            "display" : "Bypass gastroenterostomy (procedure)"
          },
          {
            "code" : "18718003",
            "display" : "Gingival disease (disorder)"
          },
          {
            "code" : "18726006",
            "display" : "Senile asthenia (finding)"
          },
          {
            "code" : "18735004",
            "display" : "Congenital omphalocele (disorder)"
          },
          {
            "code" : "18755003",
            "display" : "Supragingival dental calculus (disorder)"
          },
          {
            "code" : "18773000",
            "display" : "Cyclical vomiting syndrome (disorder)"
          },
          {
            "code" : "18818009",
            "display" : "Moderate recurrent major depression (disorder)"
          },
          {
            "code" : "18820007",
            "display" : "Preauricular cyst (disorder)"
          },
          {
            "code" : "18834007",
            "display" : "Crystal arthropathy (disorder)"
          },
          {
            "code" : "18842008",
            "display" : "Corticobasal degeneration (disorder)"
          },
          {
            "code" : "18857001",
            "display" : "Vaginal introitus structure (body structure)"
          },
          {
            "code" : "18876004",
            "display" : "Pain in finger (finding)"
          },
          {
            "code" : "18905000",
            "display" : "Left occipitolateral position (finding)"
          },
          {
            "code" : "18911002",
            "display" : "Penile structure (body structure)"
          },
          {
            "code" : "18941000",
            "display" : "Oppositional defiant disorder (disorder)"
          },
          {
            "code" : "18946005",
            "display" : "Epidural anesthesia (procedure)"
          },
          {
            "code" : "18949003",
            "display" : "Change of dressing (procedure)"
          },
          {
            "code" : "18962004",
            "display" : "Structure of nasopharyngeal cavity (body structure)"
          },
          {
            "code" : "18963009",
            "display" : "Mood swings (finding)"
          },
          {
            "code" : "18973006",
            "display" : "Uterovaginal prolapse (disorder)"
          },
          {
            "code" : "19030005",
            "display" : "Human immunodeficiency virus (organism)"
          },
          {
            "code" : "19034001",
            "display" : "Hyperparathyroidism due to renal insufficiency (disorder)"
          },
          {
            "code" : "19041007",
            "display" : "Tolazoline hydrochloride (substance)"
          },
          {
            "code" : "19063003",
            "display" : "Arthroplasty of knee (procedure)"
          },
          {
            "code" : "19072006",
            "display" : "Libido control (finding)"
          },
          {
            "code" : "19078005",
            "display" : "Collie (organism)"
          },
          {
            "code" : "19084008",
            "display" : "Clostridium butyricum (organism)"
          },
          {
            "code" : "19085009",
            "display" : "Saipanese (ethnic group)"
          },
          {
            "code" : "19086005",
            "display" : "Radioisotope study of respiratory system (procedure)"
          },
          {
            "code" : "19087001",
            "display" : "Tinea kerion (disorder)"
          },
          {
            "code" : "19100000",
            "display" : "Structure of lower inner quadrant of breast (body structure)"
          },
          {
            "code" : "19130008",
            "display" : "Traumatic abnormality (morphologic abnormality)"
          },
          {
            "code" : "19133005",
            "display" : "Neurofibromatosis syndrome (disorder)"
          },
          {
            "code" : "19189001",
            "display" : "Forepleasure (finding)"
          },
          {
            "code" : "19206003",
            "display" : "Syphilitic acoustic neuritis (disorder)"
          },
          {
            "code" : "19220005",
            "display" : "Complication of implant (disorder)"
          },
          {
            "code" : "19227008",
            "display" : "Foreign body (morphologic abnormality)"
          },
          {
            "code" : "19242006",
            "display" : "Pulmonary edema (disorder)"
          },
          {
            "code" : "19267009",
            "display" : "Lupus anticoagulant disorder (disorder)"
          },
          {
            "code" : "19273005",
            "display" : "Repair of recurrent inguinal hernia (procedure)"
          },
          {
            "code" : "19290004",
            "display" : "Clutton's joints (disorder)"
          },
          {
            "code" : "19303008",
            "display" : "Alcohol myopathy (disorder)"
          },
          {
            "code" : "19307009",
            "display" : "Drug-induced immune thrombocytopenia (disorder)"
          },
          {
            "code" : "19309007",
            "display" : "Glaucoma associated with vascular disorder (disorder)"
          },
          {
            "code" : "19311003",
            "display" : "Collagenous colitis (disorder)"
          },
          {
            "code" : "19346006",
            "display" : "Marfan's syndrome (disorder)"
          },
          {
            "code" : "19349004",
            "display" : "Struck by falling tree (event)"
          },
          {
            "code" : "19351000",
            "display" : "Acute glomerulonephritis (disorder)"
          },
          {
            "code" : "19354008",
            "display" : "Ganglion cyst of tendon sheath (disorder)"
          },
          {
            "code" : "19356005",
            "display" : "Hunter horse (organism)"
          },
          {
            "code" : "19362000",
            "display" : "Cutaneous larva migrans (disorder)"
          },
          {
            "code" : "19390001",
            "display" : "Partial breech delivery with forceps to aftercoming head (procedure)"
          },
          {
            "code" : "19399000",
            "display" : "Acute exudative otitis media (disorder)"
          },
          {
            "code" : "19408000",
            "display" : "pM0 category (finding)"
          },
          {
            "code" : "19410003",
            "display" : "Macrocephaly (disorder)"
          },
          {
            "code" : "19416009",
            "display" : "Congenital anomaly of eye (disorder)"
          },
          {
            "code" : "19418005",
            "display" : "Psychopathic personality trait (finding)"
          },
          {
            "code" : "19429009",
            "display" : "Chronic ulcer of skin (disorder)"
          },
          {
            "code" : "19434008",
            "display" : "French (ethnic group)"
          },
          {
            "code" : "19442009",
            "display" : "Heterozygous thalassemia (disorder)"
          },
          {
            "code" : "19443004",
            "display" : "Radioactive implant, device (physical object)"
          },
          {
            "code" : "19471005",
            "display" : "Lymphadenitis (disorder)"
          },
          {
            "code" : "19491003",
            "display" : "Injury of nose (disorder)"
          },
          {
            "code" : "19494006",
            "display" : "Current tear of semilunar cartilage (disorder)"
          },
          {
            "code" : "19495007",
            "display" : "Technetium (99m-Tc) sodium pertechnetate (substance)"
          },
          {
            "code" : "19512009",
            "display" : "Fear of insects (finding)"
          },
          {
            "code" : "19527009",
            "display" : "Single episode of major depression in full remission (disorder)"
          },
          {
            "code" : "19550003",
            "display" : "22q partial monosomy syndrome (disorder)"
          },
          {
            "code" : "19551004",
            "display" : "Human herpesvirus 3 (organism)"
          },
          {
            "code" : "19560007",
            "display" : "Exostosis of external ear canal (disorder)"
          },
          {
            "code" : "19578002",
            "display" : "Arthrodesis (procedure)"
          },
          {
            "code" : "19579005",
            "display" : "Juvenile osteochondritis (disorder)"
          },
          {
            "code" : "19593003",
            "display" : "Movement partial seizure (finding)"
          },
          {
            "code" : "19598007",
            "display" : "Generalized epilepsy (disorder)"
          },
          {
            "code" : "19620000",
            "display" : "Rhegmatogenous retinal detachment (disorder)"
          },
          {
            "code" : "19636003",
            "display" : "Monocytosis (disorder)"
          },
          {
            "code" : "19648000",
            "display" : "Diffuse (qualifier value)"
          },
          {
            "code" : "19660004",
            "display" : "Disorder of soft tissue (disorder)"
          },
          {
            "code" : "19665009",
            "display" : "Tubular adenoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "19695001",
            "display" : "Hypochondriac region structure (body structure)"
          },
          {
            "code" : "19705003",
            "display" : "Sexual harassment by male (finding)"
          },
          {
            "code" : "19708001",
            "display" : "Melao virus (organism)"
          },
          {
            "code" : "19715009",
            "display" : "Structure of basilic vein (body structure)"
          },
          {
            "code" : "19766004",
            "display" : "Panic disorder with agoraphobia, mild agoraphobic avoidance AND severe panic attacks (disorder)"
          },
          {
            "code" : "19769006",
            "display" : "High-renin essential hypertension (disorder)"
          },
          {
            "code" : "19770007",
            "display" : "Hereford pig (organism)"
          },
          {
            "code" : "19776001",
            "display" : "Decreased size (finding)"
          },
          {
            "code" : "19782003",
            "display" : "Sexual hypesthesia (finding)"
          },
          {
            "code" : "19829001",
            "display" : "Disorder of lung (disorder)"
          },
          {
            "code" : "19843006",
            "display" : "Hypertrophic scar (disorder)"
          },
          {
            "code" : "19850005",
            "display" : "Acute gastric ulcer with perforation (disorder)"
          },
          {
            "code" : "19877001",
            "display" : "Rhinophyma (disorder)"
          },
          {
            "code" : "19887002",
            "display" : "Claustrophobia (finding)"
          },
          {
            "code" : "19893005",
            "display" : "Potassium dichromate (substance)"
          },
          {
            "code" : "19905009",
            "display" : "Chronic prostatitis (disorder)"
          },
          {
            "code" : "19922006",
            "display" : "Compulsive sexual sadism (disorder)"
          },
          {
            "code" : "19923001",
            "display" : "Catheter, device (physical object)"
          },
          {
            "code" : "19928005",
            "display" : "Fibromatosis (morphologic abnormality)"
          },
          {
            "code" : "19939008",
            "display" : "Subacute (qualifier value)"
          },
          {
            "code" : "19943007",
            "display" : "Cirrhosis of liver (disorder)"
          },
          {
            "code" : "19952003",
            "display" : "Elastic vascular sclerosis (morphologic abnormality)"
          },
          {
            "code" : "19965007",
            "display" : "Human herpes simplex virus (organism)"
          },
          {
            "code" : "19997007",
            "display" : "Hypnotherapy (regime/therapy)"
          },
          {
            "code" : "20010003",
            "display" : "Borderline personality disorder (disorder)"
          },
          {
            "code" : "20016009",
            "display" : "Menarche (finding)"
          },
          {
            "code" : "20017000",
            "display" : "Clostridium botulinum, type C (organism)"
          },
          {
            "code" : "20018005",
            "display" : "Occlusion of ureter (disorder)"
          },
          {
            "code" : "20021007",
            "display" : "Displacement of lumbar intervertebral disc without myelopathy (disorder)"
          },
          {
            "code" : "20022000",
            "display" : "Hemiparesis (disorder)"
          },
          {
            "code" : "20044005",
            "display" : "Pietrain pig (organism)"
          },
          {
            "code" : "20078004",
            "display" : "Substance abuse treatment center (environment)"
          },
          {
            "code" : "20100009",
            "display" : "Closed fracture of intracapsular section of femur (disorder)"
          },
          {
            "code" : "20115005",
            "display" : "Structure of brachial vein (body structure)"
          },
          {
            "code" : "20135006",
            "display" : "Screening procedure (procedure)"
          },
          {
            "code" : "20140003",
            "display" : "Hawaiians (ethnic group)"
          },
          {
            "code" : "20141004",
            "display" : "Mycobacterium scrofulaceum (organism)"
          },
          {
            "code" : "20165001",
            "display" : "Hyperphosphatemia (disorder)"
          },
          {
            "code" : "20230008",
            "display" : "Vital new red stain (substance)"
          },
          {
            "code" : "20233005",
            "display" : "Scrotal structure (body structure)"
          },
          {
            "code" : "20262006",
            "display" : "Ataxia (finding)"
          },
          {
            "code" : "20280002",
            "display" : "Hampshire pig (organism)"
          },
          {
            "code" : "20291009",
            "display" : "Lacandon (ethnic group)"
          },
          {
            "code" : "20292002",
            "display" : "Atlantooccipital joint structure (body structure)"
          },
          {
            "code" : "20298003",
            "display" : "Structure of xiphoid process of sternum (body structure)"
          },
          {
            "code" : "20301004",
            "display" : "Dysphasia (finding)"
          },
          {
            "code" : "20319008",
            "display" : "Normal enjoyment of sex (finding)"
          },
          {
            "code" : "20342001",
            "display" : "Calculus in urethra (disorder)"
          },
          {
            "code" : "20376005",
            "display" : "Benign neoplastic disease (disorder)"
          },
          {
            "code" : "20381001",
            "display" : "Injection of anesthetic substance, therapeutic, subarachnoid, differential (procedure)"
          },
          {
            "code" : "20418004",
            "display" : "Wedge resection (procedure)"
          },
          {
            "code" : "20425006",
            "display" : "Labyrinthine disorder (disorder)"
          },
          {
            "code" : "20427003",
            "display" : "Postphlebitic syndrome (disorder)"
          },
          {
            "code" : "20430005",
            "display" : "Heterosexual (finding)"
          },
          {
            "code" : "20449009",
            "display" : "Javanese (ethnic group)"
          },
          {
            "code" : "20475008",
            "display" : "Bilateral endoscopic occlusion of fallopian tubes (procedure)"
          },
          {
            "code" : "20498000",
            "display" : "Mycobacterium chubuense (organism)"
          },
          {
            "code" : "20502007",
            "display" : "Pain in scrotum (finding)"
          },
          {
            "code" : "20511007",
            "display" : "Fracture of hand (disorder)"
          },
          {
            "code" : "20543007",
            "display" : "Fungus stain method (procedure)"
          },
          {
            "code" : "20544001",
            "display" : "Secondarily generalized seizures (finding)"
          },
          {
            "code" : "20573003",
            "display" : "Ineffective breathing pattern (finding)"
          },
          {
            "code" : "20587003",
            "display" : "Paternal age (observable entity)"
          },
          {
            "code" : "20607006",
            "display" : "Gingivostomatitis (disorder)"
          },
          {
            "code" : "20610004",
            "display" : "Fourth nerve palsy (disorder)"
          },
          {
            "code" : "20616005",
            "display" : "Abnormal psychosexual phase (finding)"
          },
          {
            "code" : "20623006",
            "display" : "T & A liquid diet (finding)"
          },
          {
            "code" : "20636006",
            "display" : "Vertical heterophoria (disorder)"
          },
          {
            "code" : "20639004",
            "display" : "Candidiasis of the esophagus (disorder)"
          },
          {
            "code" : "20674003",
            "display" : "Oral fistula (disorder)"
          },
          {
            "code" : "20676001",
            "display" : "Sodium diet (finding)"
          },
          {
            "code" : "20678000",
            "display" : "Extreme insulin resistance with acanthosis nigricans, hirsutism AND autoantibodies to the insulin receptors (disorder)"
          },
          {
            "code" : "20681005",
            "display" : "Perforation of cardiac device (disorder)"
          },
          {
            "code" : "20696009",
            "display" : "Peripheral venous insufficiency (disorder)"
          },
          {
            "code" : "20699002",
            "display" : "Structure of cephalic vein (body structure)"
          },
          {
            "code" : "20701002",
            "display" : "Open reduction of fracture with internal fixation (procedure)"
          },
          {
            "code" : "20717008",
            "display" : "Atherosclerotic fibrous plaque (morphologic abnormality)"
          },
          {
            "code" : "20721001",
            "display" : "Tricuspid valve disorder (disorder)"
          },
          {
            "code" : "20733006",
            "display" : "Living place (observable entity)"
          },
          {
            "code" : "20734000",
            "display" : "Psychologic conversion disorder (disorder)"
          },
          {
            "code" : "20735004",
            "display" : "Syphilitic aortitis (disorder)"
          },
          {
            "code" : "20760004",
            "display" : "Bone structure of shaft of humerus (body structure)"
          },
          {
            "code" : "20785008",
            "display" : "Clostridium botulinum, type B (organism)"
          },
          {
            "code" : "20793008",
            "display" : "Scapulalgia (finding)"
          },
          {
            "code" : "20805001",
            "display" : "Rhinoseptoplasty (procedure)"
          },
          {
            "code" : "20824003",
            "display" : "Chronic cholecystitis (disorder)"
          },
          {
            "code" : "20845005",
            "display" : "Meconium in amniotic fluid affecting management of mother (disorder)"
          },
          {
            "code" : "20848007",
            "display" : "Infestation caused by Pediculus (disorder)"
          },
          {
            "code" : "20902002",
            "display" : "Fall from bed (event)"
          },
          {
            "code" : "20917003",
            "display" : "Chronic glomerulonephritis (disorder)"
          },
          {
            "code" : "20927009",
            "display" : "Dengue hemorrhagic fever (disorder)"
          },
          {
            "code" : "20943002",
            "display" : "Acute gonococcal cervicitis (disorder)"
          },
          {
            "code" : "20944008",
            "display" : "Congenital postural scoliosis (disorder)"
          },
          {
            "code" : "20973006",
            "display" : "Mycobacterium thermoresistibile (organism)"
          },
          {
            "code" : "20982000",
            "display" : "Structure of capillary blood vessel (organ) (body structure)"
          },
          {
            "code" : "21008007",
            "display" : "Cystadenocarcinoma (morphologic abnormality)"
          },
          {
            "code" : "21018002",
            "display" : "Inflammatory neuropathy (disorder)"
          },
          {
            "code" : "21021000",
            "display" : "Large black pig (organism)"
          },
          {
            "code" : "21039009",
            "display" : "Puli dog (organism)"
          },
          {
            "code" : "21047009",
            "display" : "Aleuts (ethnic group)"
          },
          {
            "code" : "21058000",
            "display" : "Structure of tubal tonsil (body structure)"
          },
          {
            "code" : "21065008",
            "display" : "Music therapy (regime/therapy)"
          },
          {
            "code" : "21082005",
            "display" : "Entire mouth region (body structure)"
          },
          {
            "code" : "21111006",
            "display" : "Complete trisomy 13 syndrome (disorder)"
          },
          {
            "code" : "21114003",
            "display" : "Oblique (qualifier value)"
          },
          {
            "code" : "21117005",
            "display" : "Conjunctival hemorrhage (disorder)"
          },
          {
            "code" : "21120002",
            "display" : "Osteomyelitis of lower leg (disorder)"
          },
          {
            "code" : "21133008",
            "display" : "Bone structure of shaft of ulna (body structure)"
          },
          {
            "code" : "21134002",
            "display" : "Disability (finding)"
          },
          {
            "code" : "21150005",
            "display" : "Schipperke dog (organism)"
          },
          {
            "code" : "21161002",
            "display" : "Glossopharyngeal nerve structure (body structure)"
          },
          {
            "code" : "21173002",
            "display" : "Benign adenoma of prostate (disorder)"
          },
          {
            "code" : "21186006",
            "display" : "Chronic otitis media (disorder)"
          },
          {
            "code" : "21208000",
            "display" : "Saanen goat (organism)"
          },
          {
            "code" : "21234008",
            "display" : "Congenital stenosis of aorta (disorder)"
          },
          {
            "code" : "21278004",
            "display" : "Passive movement (observable entity)"
          },
          {
            "code" : "21295007",
            "display" : "Morgan horse (organism)"
          },
          {
            "code" : "21306003",
            "display" : "Jejunal structure (body structure)"
          },
          {
            "code" : "21312008",
            "display" : "Oral penile stimulation (finding)"
          },
          {
            "code" : "21313003",
            "display" : "Whispered voice (observable entity)"
          },
          {
            "code" : "21326004",
            "display" : "Combined small cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "21333004",
            "display" : "Derangement of lateral meniscus (disorder)"
          },
          {
            "code" : "21351003",
            "display" : "Fracture of phalanx of foot (disorder)"
          },
          {
            "code" : "21371007",
            "display" : "Operation on abdominal region (procedure)"
          },
          {
            "code" : "21379009",
            "display" : "Ruptured sinus of Valsalva (disorder)"
          },
          {
            "code" : "21381006",
            "display" : "Fat necrosis of breast (disorder)"
          },
          {
            "code" : "21387005",
            "display" : "Hyoid bone structure (body structure)"
          },
          {
            "code" : "21409006",
            "display" : "Enthesopathy of ankle AND/OR tarsus (disorder)"
          },
          {
            "code" : "21418008",
            "display" : "English cocker spaniel (organism)"
          },
          {
            "code" : "21419000",
            "display" : "Closed fracture of medial condyle of humerus (disorder)"
          },
          {
            "code" : "21433000",
            "display" : "Mycobacterium nonchromogenicum (organism)"
          },
          {
            "code" : "21454007",
            "display" : "Subarachnoid intracranial hemorrhage (disorder)"
          },
          {
            "code" : "21479005",
            "display" : "Structure of carotid sinus (body structure)"
          },
          {
            "code" : "21483005",
            "display" : "Structure of central nervous system (body structure)"
          },
          {
            "code" : "21522001",
            "display" : "Abdominal pain (finding)"
          },
          {
            "code" : "21523006",
            "display" : "Syphilitic gumma of central nervous system (disorder)"
          },
          {
            "code" : "21553004",
            "display" : "Luing cattle breed (organism)"
          },
          {
            "code" : "21572004",
            "display" : "Iodine-123 (substance)"
          },
          {
            "code" : "21574003",
            "display" : "Repair of aneurysm of abdominal aorta with graft (procedure)"
          },
          {
            "code" : "21576001",
            "display" : "Nitrogen-13 (substance)"
          },
          {
            "code" : "21584002",
            "display" : "Syndrome of infant of diabetic mother (disorder)"
          },
          {
            "code" : "21586000",
            "display" : "Munchausen's syndrome (disorder)"
          },
          {
            "code" : "21592006",
            "display" : "Tartrazine stain (substance)"
          },
          {
            "code" : "21594007",
            "display" : "Malignant (qualifier value)"
          },
          {
            "code" : "21626009",
            "display" : "Cutaneous hypersensitivity (disorder)"
          },
          {
            "code" : "21634003",
            "display" : "Borjeson-Forssman-Lehmann syndrome (disorder)"
          },
          {
            "code" : "21637005",
            "display" : "Egyptian mau cat (organism)"
          },
          {
            "code" : "21638000",
            "display" : "Acute periodontitis (disorder)"
          },
          {
            "code" : "21639008",
            "display" : "Hypervolemia (disorder)"
          },
          {
            "code" : "21647008",
            "display" : "Amphetamine dependence (disorder)"
          },
          {
            "code" : "21649006",
            "display" : "Altered growth and development: communication skills (finding)"
          },
          {
            "code" : "21664006",
            "display" : "Chronic meningitis (disorder)"
          },
          {
            "code" : "21672008",
            "display" : "Skin of parietal region (body structure)"
          },
          {
            "code" : "21698002",
            "display" : "Open fracture of phalanx of finger (disorder)"
          },
          {
            "code" : "21708004",
            "display" : "Osteosarcoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "21711003",
            "display" : "Hydrosalpinx (disorder)"
          },
          {
            "code" : "21719001",
            "display" : "Allergic rhinitis caused by pollen (disorder)"
          },
          {
            "code" : "21726001",
            "display" : "American wirehaired cat (organism)"
          },
          {
            "code" : "21763005",
            "display" : "Injury of teeth (disorder)"
          },
          {
            "code" : "21779006",
            "display" : "Retractile testis (disorder)"
          },
          {
            "code" : "21782001",
            "display" : "Drug-induced constipation (disorder)"
          },
          {
            "code" : "21783006",
            "display" : "Mechanical lagophthalmos (disorder)"
          },
          {
            "code" : "21793004",
            "display" : "Connective tissue structure (body structure)"
          },
          {
            "code" : "21794005",
            "display" : "Radial styloid tenosynovitis (disorder)"
          },
          {
            "code" : "21801002",
            "display" : "Menopausal symptom (finding)"
          },
          {
            "code" : "21807003",
            "display" : "Structure of left branch of hepatic artery (body structure)"
          },
          {
            "code" : "21814001",
            "display" : "Cardiac ventricular structure (body structure)"
          },
          {
            "code" : "21840007",
            "display" : "Date of last menstrual period (observable entity)"
          },
          {
            "code" : "21850008",
            "display" : "Plagiocephaly (disorder)"
          },
          {
            "code" : "21868006",
            "display" : "Madagascans (ethnic group)"
          },
          {
            "code" : "21870002",
            "display" : "Transluminal extraction catheter, device (physical object)"
          },
          {
            "code" : "21875007",
            "display" : "Structure of pararectal lymph node (body structure)"
          },
          {
            "code" : "21877004",
            "display" : "Osler hemorrhagic telangiectasia syndrome (disorder)"
          },
          {
            "code" : "21882006",
            "display" : "Face presentation (finding)"
          },
          {
            "code" : "21897009",
            "display" : "Generalized anxiety disorder (disorder)"
          },
          {
            "code" : "21902005",
            "display" : "Struck by falling rock or stone (event)"
          },
          {
            "code" : "21921002",
            "display" : "Canadian cattle breed (organism)"
          },
          {
            "code" : "21927003",
            "display" : "Bacillus anthracis (organism)"
          },
          {
            "code" : "21941007",
            "display" : "30 gram fat diet (finding)"
          },
          {
            "code" : "21951008",
            "display" : "Alizarin cyanine green stain (substance)"
          },
          {
            "code" : "21959005",
            "display" : "Single parent family (finding)"
          },
          {
            "code" : "21964009",
            "display" : "Malignant lymphoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "21974007",
            "display" : "Tongue structure (body structure)"
          },
          {
            "code" : "21983002",
            "display" : "Hashimoto thyroiditis (disorder)"
          },
          {
            "code" : "21993009",
            "display" : "Indonesians (ethnic group)"
          },
          {
            "code" : "21996001",
            "display" : "Mycobacterium haemophilum (organism)"
          },
          {
            "code" : "22007004",
            "display" : "Shoshone (ethnic group)"
          },
          {
            "code" : "22021002",
            "display" : "Methyl green stain (substance)"
          },
          {
            "code" : "22024005",
            "display" : "Lipoadenoma (morphologic abnormality)"
          },
          {
            "code" : "22033007",
            "display" : "Fetal growth retardation (disorder)"
          },
          {
            "code" : "22036004",
            "display" : "Pseudoaneurysm (morphologic abnormality)"
          },
          {
            "code" : "22039006",
            "display" : "Ruptured aneurysm (morphologic abnormality)"
          },
          {
            "code" : "22049009",
            "display" : "Mammary duct ectasia (disorder)"
          },
          {
            "code" : "22053006",
            "display" : "Klinefelter syndrome (disorder)"
          },
          {
            "code" : "22058002",
            "display" : "Inattention (finding)"
          },
          {
            "code" : "22066006",
            "display" : "Strabismus (disorder)"
          },
          {
            "code" : "22073001",
            "display" : "Regular wired jaw diet (finding)"
          },
          {
            "code" : "22075008",
            "display" : "Snow blindness (disorder)"
          },
          {
            "code" : "22083002",
            "display" : "Structure of splenic artery (body structure)"
          },
          {
            "code" : "22120004",
            "display" : "Structure of maxillary right central incisor tooth (body structure)"
          },
          {
            "code" : "22121000",
            "display" : "Depressed bipolar I disorder in full remission (disorder)"
          },
          {
            "code" : "22125009",
            "display" : "Panniculitis (disorder)"
          },
          {
            "code" : "22173004",
            "display" : "Excessive fetal growth affecting management of mother (disorder)"
          },
          {
            "code" : "22180002",
            "display" : "Skin structure of buttock (body structure)"
          },
          {
            "code" : "22181003",
            "display" : "Diplacusis (disorder)"
          },
          {
            "code" : "22193007",
            "display" : "Degenerative joint disease of hand (disorder)"
          },
          {
            "code" : "22220005",
            "display" : "Genuine stress incontinence (finding)"
          },
          {
            "code" : "22230001",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in partial remission AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "22232009",
            "display" : "Hospital (environment)"
          },
          {
            "code" : "22240003",
            "display" : "Pericoronitis (disorder)"
          },
          {
            "code" : "22247000",
            "display" : "Dehiscence of surgical wound (disorder)"
          },
          {
            "code" : "22253000",
            "display" : "Pain (finding)"
          },
          {
            "code" : "22268004",
            "display" : "Legal problem (finding)"
          },
          {
            "code" : "22270008",
            "display" : "Structure of anterior segment of upper division of left upper lobe of lung (body structure)"
          },
          {
            "code" : "22286001",
            "display" : "External carotid artery structure (body structure)"
          },
          {
            "code" : "22298006",
            "display" : "Myocardial infarction (disorder)"
          },
          {
            "code" : "22325002",
            "display" : "Abnormal gait (finding)"
          },
          {
            "code" : "22356005",
            "display" : "Bone structure of ilium (body structure)"
          },
          {
            "code" : "22386003",
            "display" : "Syphilitic optic atrophy (disorder)"
          },
          {
            "code" : "22396007",
            "display" : "Adolescence (finding)"
          },
          {
            "code" : "22439003",
            "display" : "Forcible intercourse (event)"
          },
          {
            "code" : "22445006",
            "display" : "Structure of deciduous mandibular right lateral incisor tooth (body structure)"
          },
          {
            "code" : "22451001",
            "display" : "Idiopathic torsion dystonia (disorder)"
          },
          {
            "code" : "22455005",
            "display" : "Cytomegaloviral retinitis (disorder)"
          },
          {
            "code" : "22484001",
            "display" : "Oral clitoral stimulation (finding)"
          },
          {
            "code" : "22506004",
            "display" : "British lop pig (organism)"
          },
          {
            "code" : "22523008",
            "display" : "Vasectomy (procedure)"
          },
          {
            "code" : "22533000",
            "display" : "Coxiella burnetii (organism)"
          },
          {
            "code" : "22540004",
            "display" : "Multisystemic disseminated toxoplasmosis (disorder)"
          },
          {
            "code" : "22562004",
            "display" : "Contusion of scalp (disorder)"
          },
          {
            "code" : "22580008",
            "display" : "Human poliovirus 1 (organism)"
          },
          {
            "code" : "22591001",
            "display" : "Degeneration of cartilage AND/OR meniscus of knee (disorder)"
          },
          {
            "code" : "22592008",
            "display" : "Legionella birminghamensis (organism)"
          },
          {
            "code" : "22607003",
            "display" : "Asbestosis (disorder)"
          },
          {
            "code" : "22631008",
            "display" : "Unsteady when walking (finding)"
          },
          {
            "code" : "22633006",
            "display" : "Vaginal delivery, medical personnel present (procedure)"
          },
          {
            "code" : "22668006",
            "display" : "Subglottic stenosis (disorder)"
          },
          {
            "code" : "22677004",
            "display" : "Autopsy, gross examination, teaching, limited (procedure)"
          },
          {
            "code" : "22687000",
            "display" : "Large cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "22688005",
            "display" : "Skeletal muscle structure of head (body structure)"
          },
          {
            "code" : "22694002",
            "display" : "Adenocarcinoma with apocrine metaplasia (morphologic abnormality)"
          },
          {
            "code" : "22696000",
            "display" : "Product containing hydralazine (medicinal product)"
          },
          {
            "code" : "22697009",
            "display" : "American cocker spaniel (organism)"
          },
          {
            "code" : "22716005",
            "display" : "Platelet disorder (disorder)"
          },
          {
            "code" : "22720009",
            "display" : "Belgian horse (organism)"
          },
          {
            "code" : "22722001",
            "display" : "Idiopathic peripheral neuropathy (disorder)"
          },
          {
            "code" : "22745007",
            "display" : "Purine restricted diet (finding)"
          },
          {
            "code" : "22749001",
            "display" : "Victoria blue B stain (substance)"
          },
          {
            "code" : "22754005",
            "display" : "Staphylococcal pneumonia (disorder)"
          },
          {
            "code" : "22765000",
            "display" : "Structure of marginal branch of right coronary artery (body structure)"
          },
          {
            "code" : "22778000",
            "display" : "Venipuncture (procedure)"
          },
          {
            "code" : "22823000",
            "display" : "Structure of sternocleidomastoid muscle (body structure)"
          },
          {
            "code" : "22878006",
            "display" : "Contusion of knee (disorder)"
          },
          {
            "code" : "22890008",
            "display" : "Augmentation mammoplasty (procedure)"
          },
          {
            "code" : "22911007",
            "display" : "Closed traumatic dislocation of joint of shoulder region (disorder)"
          },
          {
            "code" : "22927000",
            "display" : "Suspicious behavior (finding)"
          },
          {
            "code" : "22931006",
            "display" : "Evans blue stain (substance)"
          },
          {
            "code" : "22943007",
            "display" : "Trunk structure (body structure)"
          },
          {
            "code" : "22945000",
            "display" : "Inner ear structure (body structure)"
          },
          {
            "code" : "22950006",
            "display" : "Blindness of one eye (disorder)"
          },
          {
            "code" : "22968009",
            "display" : "Sunset yellow FCF stain (substance)"
          },
          {
            "code" : "22979004",
            "display" : "Oleic acid (125-I) (substance)"
          },
          {
            "code" : "23045005",
            "display" : "Insulin dependent diabetes mellitus type IA (disorder)"
          },
          {
            "code" : "23053002",
            "display" : "Iophenoxic acid (substance)"
          },
          {
            "code" : "23056005",
            "display" : "Sciatica (disorder)"
          },
          {
            "code" : "23074001",
            "display" : "Structure of facial artery (body structure)"
          },
          {
            "code" : "23085004",
            "display" : "Increased stress (finding)"
          },
          {
            "code" : "23130000",
            "display" : "Paroxysmal hypertension (disorder)"
          },
          {
            "code" : "23132008",
            "display" : "Amyloid light-chain amyloidosis (disorder)"
          },
          {
            "code" : "23141003",
            "display" : "Gasping for breath (finding)"
          },
          {
            "code" : "23153004",
            "display" : "Ileocecal valve structure (body structure)"
          },
          {
            "code" : "23154005",
            "display" : "Increased diastolic arterial pressure (finding)"
          },
          {
            "code" : "23159000",
            "display" : "Japanese spaniel (organism)"
          },
          {
            "code" : "23171006",
            "display" : "Delayed AND/OR secondary postpartum hemorrhage (disorder)"
          },
          {
            "code" : "23172004",
            "display" : "Bismuth (substance)"
          },
          {
            "code" : "23180006",
            "display" : "Pia mater structure (body structure)"
          },
          {
            "code" : "23182003",
            "display" : "Cereal (substance)"
          },
          {
            "code" : "23186000",
            "display" : "Menstrual migraine (disorder)"
          },
          {
            "code" : "23198005",
            "display" : "Structure of medial lacunar lymph node (body structure)"
          },
          {
            "code" : "23213005",
            "display" : "Vulval vestibule structure (body structure)"
          },
          {
            "code" : "23226009",
            "display" : "Structure of permanent maxillary left second premolar tooth (body structure)"
          },
          {
            "code" : "23238000",
            "display" : "Common variable agammaglobulinemia (disorder)"
          },
          {
            "code" : "23242002",
            "display" : "Knee-chest position (finding)"
          },
          {
            "code" : "23260002",
            "display" : "Fibroadenosis of breast (disorder)"
          },
          {
            "code" : "23268009",
            "display" : "Malingering (finding)"
          },
          {
            "code" : "23285006",
            "display" : "Painful sexual act of male (finding)"
          },
          {
            "code" : "23287003",
            "display" : "Contusion of scrotum (disorder)"
          },
          {
            "code" : "23289000",
            "display" : "Abnormal color vision (finding)"
          },
          {
            "code" : "23293006",
            "display" : "Rupture of eye with partial loss of intraocular tissue (disorder)"
          },
          {
            "code" : "23321002",
            "display" : "Struck by sports equipment (event)"
          },
          {
            "code" : "23328008",
            "display" : "Rape trauma syndrome: compound reaction (finding)"
          },
          {
            "code" : "23344004",
            "display" : "Lumbar hernia (disorder)"
          },
          {
            "code" : "23347006",
            "display" : "Structure of splenium of corpus callosum (body structure)"
          },
          {
            "code" : "23351008",
            "display" : "T1 category (finding)"
          },
          {
            "code" : "23374007",
            "display" : "Atypical absence seizure (disorder)"
          },
          {
            "code" : "23388006",
            "display" : "Visual field scotoma (finding)"
          },
          {
            "code" : "23397005",
            "display" : "Normal growth and development for age (finding)"
          },
          {
            "code" : "23406007",
            "display" : "Fracture of upper limb (disorder)"
          },
          {
            "code" : "23407003",
            "display" : "Congenital pes planus (disorder)"
          },
          {
            "code" : "23413007",
            "display" : "Sexual harassment by female (finding)"
          },
          {
            "code" : "23414001",
            "display" : "Peripheral demyelinating neuropathy (disorder)"
          },
          {
            "code" : "23415000",
            "display" : "Sprain of jaw (disorder)"
          },
          {
            "code" : "23416004",
            "display" : "Bone structure of ulna (body structure)"
          },
          {
            "code" : "23426006",
            "display" : "Measurement of respiratory function (procedure)"
          },
          {
            "code" : "23427002",
            "display" : "Structure of maxillary left first molar tooth (body structure)"
          },
          {
            "code" : "23438002",
            "display" : "Structure of profunda femoris vein (body structure)"
          },
          {
            "code" : "23439005",
            "display" : "Coccidioides immitis (organism)"
          },
          {
            "code" : "23451007",
            "display" : "Adrenal structure (body structure)"
          },
          {
            "code" : "23484007",
            "display" : "Candidiasis of nails (disorder)"
          },
          {
            "code" : "23498004",
            "display" : "Vesicular stomatitis Indiana virus (organism)"
          },
          {
            "code" : "23502006",
            "display" : "Lyme disease (disorder)"
          },
          {
            "code" : "23513009",
            "display" : "Herpesvirus infection (disorder)"
          },
          {
            "code" : "23517005",
            "display" : "Polynesians (ethnic group)"
          },
          {
            "code" : "23534002",
            "display" : "Melanesians (ethnic group)"
          },
          {
            "code" : "23550005",
            "display" : "Syphilis of bursa (disorder)"
          },
          {
            "code" : "23560001",
            "display" : "Asperger's disorder (disorder)"
          },
          {
            "code" : "23566007",
            "display" : "Genus Listeria (organism)"
          },
          {
            "code" : "23568008",
            "display" : "Metatarsus adductus (disorder)"
          },
          {
            "code" : "23615008",
            "display" : "Spongiotic dermatitis (disorder)"
          },
          {
            "code" : "23623005",
            "display" : "Infective mastitis (disorder)"
          },
          {
            "code" : "23627006",
            "display" : "Chronic pericarditis (disorder)"
          },
          {
            "code" : "23629009",
            "display" : "Hays converter cattle breed (organism)"
          },
          {
            "code" : "23645006",
            "display" : "Organic mood disorder (disorder)"
          },
          {
            "code" : "23670006",
            "display" : "Decreased intraocular pressure (finding)"
          },
          {
            "code" : "23685000",
            "display" : "Rheumatic heart disease (disorder)"
          },
          {
            "code" : "23687008",
            "display" : "Coronary artery spasm (disorder)"
          },
          {
            "code" : "23697004",
            "display" : "Crush syndrome (disorder)"
          },
          {
            "code" : "23713006",
            "display" : "Contusion of cerebral cortex (disorder)"
          },
          {
            "code" : "23714000",
            "display" : "Nasal vestibulitis (disorder)"
          },
          {
            "code" : "23717007",
            "display" : "Benign essential hypertension complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "23719005",
            "display" : "Transplantation of bone marrow (procedure)"
          },
          {
            "code" : "23730008",
            "display" : "Papilloma, no International Classification of Diseases for Oncology subtype (except papilloma of bladder M-81201) (morphologic abnormality)"
          },
          {
            "code" : "23737006",
            "display" : "Chickenpox with complication (disorder)"
          },
          {
            "code" : "23747009",
            "display" : "Skin structure of chin (body structure)"
          },
          {
            "code" : "23771002",
            "display" : "Structure of left gastric artery (body structure)"
          },
          {
            "code" : "23777003",
            "display" : "Open wound of finger with tendon involvement (disorder)"
          },
          {
            "code" : "23786008",
            "display" : "Malignant hypertension complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "23788009",
            "display" : "Ruthenium-97 (substance)"
          },
          {
            "code" : "23852006",
            "display" : "Cardiac monitoring (regime/therapy)"
          },
          {
            "code" : "23890000",
            "display" : "Calcaneal apophysitis (disorder)"
          },
          {
            "code" : "23900009",
            "display" : "Closed fracture of upper end of tibia (disorder)"
          },
          {
            "code" : "23913003",
            "display" : "External hemorrhoids (disorder)"
          },
          {
            "code" : "23919004",
            "display" : "Labyrinthitis (disorder)"
          },
          {
            "code" : "23922002",
            "display" : "Batutsi (ethnic group)"
          },
          {
            "code" : "23924001",
            "display" : "Tight chest (finding)"
          },
          {
            "code" : "23930001",
            "display" : "Francisella tularensis subspecies mediasiatica (organism)"
          },
          {
            "code" : "23935006",
            "display" : "Diversional activity deficit (finding)"
          },
          {
            "code" : "23954006",
            "display" : "Acromion presentation (finding)"
          },
          {
            "code" : "23968004",
            "display" : "Excision of colon (procedure)"
          },
          {
            "code" : "23986001",
            "display" : "Glaucoma (disorder)"
          },
          {
            "code" : "23995009",
            "display" : "Bull terrier (organism)"
          },
          {
            "code" : "24010005",
            "display" : "Aphakia (disorder)"
          },
          {
            "code" : "24020000",
            "display" : "Horizontal (qualifier value)"
          },
          {
            "code" : "24028007",
            "display" : "Right (qualifier value)"
          },
          {
            "code" : "24042004",
            "display" : "Chronic hypertension complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "24062007",
            "display" : "Structure of innermost intercostal muscle (body structure)"
          },
          {
            "code" : "24079001",
            "display" : "Atopic dermatitis (disorder)"
          },
          {
            "code" : "24095001",
            "display" : "Placenta previa partialis (disorder)"
          },
          {
            "code" : "24097009",
            "display" : "Bone structure of hand (body structure)"
          },
          {
            "code" : "24099007",
            "display" : "Oxygen (substance)"
          },
          {
            "code" : "24109003",
            "display" : "Bromhidrosiphobia (finding)"
          },
          {
            "code" : "24111007",
            "display" : "FHC elite pig 3 (organism)"
          },
          {
            "code" : "24121004",
            "display" : "Insomnia disorder related to another mental disorder (disorder)"
          },
          {
            "code" : "24135002",
            "display" : "Ultrasonography of total body (procedure)"
          },
          {
            "code" : "24136001",
            "display" : "Hip joint structure (body structure)"
          },
          {
            "code" : "24139008",
            "display" : "Endoscopy of urinary bladder (procedure)"
          },
          {
            "code" : "24142002",
            "display" : "Nipple structure (body structure)"
          },
          {
            "code" : "24154002",
            "display" : "Musculoskeletal extension, function (observable entity)"
          },
          {
            "code" : "24162005",
            "display" : "Ovarian follicle structure (body structure)"
          },
          {
            "code" : "24167004",
            "display" : "Fast green FCF stain (substance)"
          },
          {
            "code" : "24172008",
            "display" : "Crisis intervention (regime/therapy)"
          },
          {
            "code" : "24184005",
            "display" : "Finding of increased blood pressure (finding)"
          },
          {
            "code" : "24194000",
            "display" : "Complete bilateral cleft palate (disorder)"
          },
          {
            "code" : "24199005",
            "display" : "Feeling agitated (finding)"
          },
          {
            "code" : "24203005",
            "display" : "Extreme insulin resistance with acanthosis nigricans, hirsutism AND abnormal insulin receptors (disorder)"
          },
          {
            "code" : "24215009",
            "display" : "Picric acid (substance)"
          },
          {
            "code" : "24224000",
            "display" : "Brucella abortus (organism)"
          },
          {
            "code" : "24225004",
            "display" : "Tonic pupillary reaction (disorder)"
          },
          {
            "code" : "24299002",
            "display" : "Skye terrier (organism)"
          },
          {
            "code" : "24301009",
            "display" : "Gold-198 (substance)"
          },
          {
            "code" : "24319000",
            "display" : "Boar power pig 414 (organism)"
          },
          {
            "code" : "24369008",
            "display" : "Pulmonary sarcoidosis (disorder)"
          },
          {
            "code" : "24385003",
            "display" : "Foreign body in lung (disorder)"
          },
          {
            "code" : "24389009",
            "display" : "Injection site granuloma (morphologic abnormality)"
          },
          {
            "code" : "24420007",
            "display" : "Sigmoidoscopy (procedure)"
          },
          {
            "code" : "24422004",
            "display" : "Axial (qualifier value)"
          },
          {
            "code" : "24424003",
            "display" : "Closed fracture of phalanx of finger (disorder)"
          },
          {
            "code" : "24441001",
            "display" : "Health maintenance alteration (finding)"
          },
          {
            "code" : "24443003",
            "display" : "Total thyroidectomy (procedure)"
          },
          {
            "code" : "24483006",
            "display" : "Skin structure of postauricular region (body structure)"
          },
          {
            "code" : "24484000",
            "display" : "Severe (severity modifier) (qualifier value)"
          },
          {
            "code" : "24496007",
            "display" : "Hemorrhoidectomy (procedure)"
          },
          {
            "code" : "24511001",
            "display" : "Technetium (99m-Tc) succimer (substance)"
          },
          {
            "code" : "24514009",
            "display" : "Gleason grade score 10 out of 10 (finding)"
          },
          {
            "code" : "24516006",
            "display" : "Meldola blue stain (substance)"
          },
          {
            "code" : "24526004",
            "display" : "Inflammatory bowel disease (disorder)"
          },
          {
            "code" : "24527008",
            "display" : "Skin structure of palmar area of wrist (body structure)"
          },
          {
            "code" : "24532009",
            "display" : "Structure of foramen magnum (body structure)"
          },
          {
            "code" : "24548005",
            "display" : "Cyst of vagina (disorder)"
          },
          {
            "code" : "24573005",
            "display" : "Structure of permanent mandibular left second premolar tooth (body structure)"
          },
          {
            "code" : "24587005",
            "display" : "Image analysis (procedure)"
          },
          {
            "code" : "24595009",
            "display" : "Primary gout (disorder)"
          },
          {
            "code" : "24596005",
            "display" : "Venous retinal branch occlusion (disorder)"
          },
          {
            "code" : "24612001",
            "display" : "Wheeze - rhonchi (finding)"
          },
          {
            "code" : "24618002",
            "display" : "Mycobacterium gilvum (organism)"
          },
          {
            "code" : "24623002",
            "display" : "Screening mammography (procedure)"
          },
          {
            "code" : "24630008",
            "display" : "Listeria meningoencephalitis (disorder)"
          },
          {
            "code" : "24662006",
            "display" : "Influenza caused by Influenza B virus (disorder)"
          },
          {
            "code" : "24693007",
            "display" : "Fibromyositis (disorder)"
          },
          {
            "code" : "24700007",
            "display" : "Multiple sclerosis (disorder)"
          },
          {
            "code" : "24750000",
            "display" : "Townes syndrome (disorder)"
          },
          {
            "code" : "24763006",
            "display" : "Vibrio cholerae serotype Hikojima (organism)"
          },
          {
            "code" : "24781009",
            "display" : "Panic disorder with agoraphobia, mild agoraphobic avoidance AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "24782002",
            "display" : "Hypertrophic condition of skin (disorder)"
          },
          {
            "code" : "24789006",
            "display" : "Viral gastroenteritis caused by Norwalk-like agent (disorder)"
          },
          {
            "code" : "24790002",
            "display" : "Proximal renal tubular acidosis (disorder)"
          },
          {
            "code" : "24803000",
            "display" : "Injury caused by exposure to ionizing radiation (disorder)"
          },
          {
            "code" : "24806008",
            "display" : "Anesthesia for cesarean hysterectomy (procedure)"
          },
          {
            "code" : "24807004",
            "display" : "Bleeding gastric varices (disorder)"
          },
          {
            "code" : "24812003",
            "display" : "Mongol (ethnic group)"
          },
          {
            "code" : "24840008",
            "display" : "CPF pig (organism)"
          },
          {
            "code" : "24853006",
            "display" : "Radium-223 (substance)"
          },
          {
            "code" : "24863003",
            "display" : "Postprandial (qualifier value)"
          },
          {
            "code" : "24864009",
            "display" : "Sprain of interphalangeal joint of toe (disorder)"
          },
          {
            "code" : "24865005",
            "display" : "Structure of posterior sinus of Valsalva (body structure)"
          },
          {
            "code" : "24867002",
            "display" : "Severe adrenal insufficiency (disorder)"
          },
          {
            "code" : "24868007",
            "display" : "Acute gonococcal cystitis (disorder)"
          },
          {
            "code" : "24871004",
            "display" : "Mycobacterium gordonae (organism)"
          },
          {
            "code" : "24889003",
            "display" : "Structure of pyloric lymph node (body structure)"
          },
          {
            "code" : "24900003",
            "display" : "Procion brilliant blue MRS stain (substance)"
          },
          {
            "code" : "24911006",
            "display" : "Perinatal jaundice from excessive hemolysis (disorder)"
          },
          {
            "code" : "24924006",
            "display" : "Parietal bone structure (body structure)"
          },
          {
            "code" : "24930006",
            "display" : "Vegan (finding)"
          },
          {
            "code" : "24940009",
            "display" : "Non group A rotavirus (organism)"
          },
          {
            "code" : "24967003",
            "display" : "Oriental shorthaired cat (organism)"
          },
          {
            "code" : "24976005",
            "display" : "Uterine prolapse (disorder)"
          },
          {
            "code" : "24982008",
            "display" : "Diplopia (disorder)"
          },
          {
            "code" : "24986006",
            "display" : "Borrelia turicatae (organism)"
          },
          {
            "code" : "25062003",
            "display" : "Feeding tube, device (physical object)"
          },
          {
            "code" : "25064002",
            "display" : "Headache (finding)"
          },
          {
            "code" : "25079009",
            "display" : "Lissamine fast yellow stain (substance)"
          },
          {
            "code" : "25082004",
            "display" : "Resting tremor (finding)"
          },
          {
            "code" : "25091000",
            "display" : "Solochrome cyanine R stain (substance)"
          },
          {
            "code" : "25093002",
            "display" : "Disorder of eye due to diabetes mellitus (disorder)"
          },
          {
            "code" : "25097001",
            "display" : "Hound (organism)"
          },
          {
            "code" : "25126001",
            "display" : "Pedunculated (qualifier value)"
          },
          {
            "code" : "25156005",
            "display" : "Intravenous feeding of patient (regime/therapy)"
          },
          {
            "code" : "25171009",
            "display" : "Redbone coonhound (organism)"
          },
          {
            "code" : "25197003",
            "display" : "Sodium measurement (procedure)"
          },
          {
            "code" : "25211005",
            "display" : "Aunt (person)"
          },
          {
            "code" : "25225006",
            "display" : "Disease caused by Adenovirus (disorder)"
          },
          {
            "code" : "25235000",
            "display" : "Necking (finding)"
          },
          {
            "code" : "25238003",
            "display" : "Cranial nerve structure (body structure)"
          },
          {
            "code" : "25243005",
            "display" : "Toy poodle (organism)"
          },
          {
            "code" : "25247006",
            "display" : "Structure of anterior auricular lymph node (body structure)"
          },
          {
            "code" : "25264009",
            "display" : "German wirehaired pointer (organism)"
          },
          {
            "code" : "25289003",
            "display" : "Hyperacusis (disorder)"
          },
          {
            "code" : "25296001",
            "display" : "Delivery by Scanzoni maneuver (procedure)"
          },
          {
            "code" : "25322007",
            "display" : "Dilatation (morphologic abnormality)"
          },
          {
            "code" : "25327001",
            "display" : "Dorset sheep superbreed (organism)"
          },
          {
            "code" : "25342003",
            "display" : "Middle ear structure (body structure)"
          },
          {
            "code" : "25347009",
            "display" : "Venography of lower extremity, bilateral (procedure)"
          },
          {
            "code" : "25351006",
            "display" : "Fluorescein sodium stain (substance)"
          },
          {
            "code" : "25353009",
            "display" : "Craniotomy (procedure)"
          },
          {
            "code" : "25364007",
            "display" : "Heteromanipulatory vulvoclitoral habituation (finding)"
          },
          {
            "code" : "25369002",
            "display" : "Westphalian horse (organism)"
          },
          {
            "code" : "25374005",
            "display" : "Gastroenteritis (disorder)"
          },
          {
            "code" : "25385007",
            "display" : "Incestuous concubinage with girls (finding)"
          },
          {
            "code" : "25415003",
            "display" : "Closed fracture of femur (disorder)"
          },
          {
            "code" : "25416002",
            "display" : "Peripheral neuralgia (finding)"
          },
          {
            "code" : "25419009",
            "display" : "Product containing barium sulfate (medicinal product)"
          },
          {
            "code" : "25437005",
            "display" : "Cardiac dyskinesia (finding)"
          },
          {
            "code" : "25440005",
            "display" : "Tetrachlorodibenzodioxin poisoning (disorder)"
          },
          {
            "code" : "25447008",
            "display" : "Structure of posterior mediastinal lymph node (body structure)"
          },
          {
            "code" : "25458004",
            "display" : "Acute gastritis (disorder)"
          },
          {
            "code" : "25479004",
            "display" : "Foreign body in pharynx (disorder)"
          },
          {
            "code" : "25488008",
            "display" : "Left ventricular hypertrophy by electrocardiogram (finding)"
          },
          {
            "code" : "25489000",
            "display" : "Pericardial cavity structure (body structure)"
          },
          {
            "code" : "25501002",
            "display" : "Social phobia (disorder)"
          },
          {
            "code" : "25510005",
            "display" : "Cardiac valve prosthesis (physical object)"
          },
          {
            "code" : "25540007",
            "display" : "Tooth loss (finding)"
          },
          {
            "code" : "25569003",
            "display" : "Ventricular tachycardia (disorder)"
          },
          {
            "code" : "25577004",
            "display" : "Right ear structure (body structure)"
          },
          {
            "code" : "25594002",
            "display" : "Moderate risk of (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "25604001",
            "display" : "Traumatic injury of common peroneal nerve (disorder)"
          },
          {
            "code" : "25622003",
            "display" : "Support system deficit (finding)"
          },
          {
            "code" : "25660007",
            "display" : "Barbados sheep (organism)"
          },
          {
            "code" : "25674000",
            "display" : "Lichen sclerosus et atrophicus (disorder)"
          },
          {
            "code" : "25681007",
            "display" : "Sexually transmitted disease clinic (environment)"
          },
          {
            "code" : "25683005",
            "display" : "Structure of retropharyngeal lymph node (body structure)"
          },
          {
            "code" : "25702006",
            "display" : "Alcohol intoxication (disorder)"
          },
          {
            "code" : "25748002",
            "display" : "Structure of maxillary left lateral incisor tooth (body structure)"
          },
          {
            "code" : "25750005",
            "display" : "Admiralty Islanders (ethnic group)"
          },
          {
            "code" : "25761002",
            "display" : "Glutamine (substance)"
          },
          {
            "code" : "25763004",
            "display" : "Skin of anterior surface of lower leg (body structure)"
          },
          {
            "code" : "25766007",
            "display" : "Mixed receptive-expressive language disorder (disorder)"
          },
          {
            "code" : "25786006",
            "display" : "Abnormal behavior (finding)"
          },
          {
            "code" : "25804004",
            "display" : "English (ethnic group)"
          },
          {
            "code" : "25813002",
            "display" : "Holsteiner horse (organism)"
          },
          {
            "code" : "25821008",
            "display" : "Focal glomerular sclerosis (disorder)"
          },
          {
            "code" : "25828002",
            "display" : "Mid forceps delivery with episiotomy (procedure)"
          },
          {
            "code" : "25856007",
            "display" : "Boar power pig 929 (organism)"
          },
          {
            "code" : "25875002",
            "display" : "Hypoallergenic infant formula (finding)"
          },
          {
            "code" : "25876001",
            "display" : "Emergency (qualifier value)"
          },
          {
            "code" : "25899002",
            "display" : "Closed bimalleolar fracture (disorder)"
          },
          {
            "code" : "25906001",
            "display" : "Disorder of ear (disorder)"
          },
          {
            "code" : "25910003",
            "display" : "Papillary carcinoma (morphologic abnormality)"
          },
          {
            "code" : "25924004",
            "display" : "Calculus of gallbladder with cholecystitis (disorder)"
          },
          {
            "code" : "25937001",
            "display" : "Neurostimulator, device (physical object)"
          },
          {
            "code" : "25941002",
            "display" : "Orange II stain (substance)"
          },
          {
            "code" : "25943004",
            "display" : "Structure of atrioventricular node (body structure)"
          },
          {
            "code" : "25944005",
            "display" : "Rape trauma syndrome: silent reaction (finding)"
          },
          {
            "code" : "25953003",
            "display" : "Colostomy management and care (regime/therapy)"
          },
          {
            "code" : "25971005",
            "display" : "Pedophilia, exclusive type (disorder)"
          },
          {
            "code" : "25990002",
            "display" : "Renal pelvis structure (body structure)"
          },
          {
            "code" : "25991003",
            "display" : "Cerebellar cortex structure (body structure)"
          },
          {
            "code" : "26006005",
            "display" : "Allergic gastroenteritis (disorder)"
          },
          {
            "code" : "26025008",
            "display" : "Residual schizophrenia (disorder)"
          },
          {
            "code" : "26036001",
            "display" : "Obstruction (morphologic abnormality)"
          },
          {
            "code" : "26039008",
            "display" : "Neurosyphilis (disorder)"
          },
          {
            "code" : "26041009",
            "display" : "Potassium restricted diet (finding)"
          },
          {
            "code" : "26045000",
            "display" : "Chronic allergic conjunctivitis (disorder)"
          },
          {
            "code" : "26046004",
            "display" : "Cardiovascular stress test using bicycle ergometer (procedure)"
          },
          {
            "code" : "26057009",
            "display" : "Exotic shorthaired cat (organism)"
          },
          {
            "code" : "26078007",
            "display" : "Hypertension secondary to renal disease complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "26079004",
            "display" : "Tremor (finding)"
          },
          {
            "code" : "26105007",
            "display" : "Holstein-Friesian cattle breed (organism)"
          },
          {
            "code" : "26110006",
            "display" : "Spiritual distress (finding)"
          },
          {
            "code" : "26135000",
            "display" : "Syphilitic encephalitis (disorder)"
          },
          {
            "code" : "26140008",
            "display" : "Uvula palatina structure (body structure)"
          },
          {
            "code" : "26141007",
            "display" : "ST segment depression (finding)"
          },
          {
            "code" : "26146002",
            "display" : "Complete transposition of great vessels (disorder)"
          },
          {
            "code" : "26159005",
            "display" : "Clostridium tetani toxin (substance)"
          },
          {
            "code" : "26179002",
            "display" : "Congenital atresia of esophagus (disorder)"
          },
          {
            "code" : "26194003",
            "display" : "Tungsten (substance)"
          },
          {
            "code" : "26206000",
            "display" : "Hepatic coma due to viral hepatitis B (disorder)"
          },
          {
            "code" : "26212005",
            "display" : "Replacement of aortic valve (procedure)"
          },
          {
            "code" : "26215007",
            "display" : "South Asian Aborigine (ethnic group)"
          },
          {
            "code" : "26216008",
            "display" : "Central (qualifier value)"
          },
          {
            "code" : "26229008",
            "display" : "Nova Scotia duck tolling retriever (organism)"
          },
          {
            "code" : "26230003",
            "display" : "Structure of uncinate fasciculus (body structure)"
          },
          {
            "code" : "26237000",
            "display" : "Ankle edema (finding)"
          },
          {
            "code" : "26242008",
            "display" : "Mixed (qualifier value)"
          },
          {
            "code" : "26250004",
            "display" : "Genus Brucella (organism)"
          },
          {
            "code" : "26283006",
            "display" : "Superficial (qualifier value)"
          },
          {
            "code" : "26284000",
            "display" : "Ulcer of mouth (disorder)"
          },
          {
            "code" : "26294005",
            "display" : "Radical prostatectomy (procedure)"
          },
          {
            "code" : "26298008",
            "display" : "Ketoacidotic coma due to diabetes mellitus (disorder)"
          },
          {
            "code" : "26313002",
            "display" : "Delivery by vacuum extraction with episiotomy (procedure)"
          },
          {
            "code" : "26322001",
            "display" : "Bleeding from ear (disorder)"
          },
          {
            "code" : "26329005",
            "display" : "Poor concentration (finding)"
          },
          {
            "code" : "26332008",
            "display" : "Norwich terrier (organism)"
          },
          {
            "code" : "26352009",
            "display" : "Junin virus (organism)"
          },
          {
            "code" : "26370007",
            "display" : "Medicinal product acting as hemostatic (product)"
          },
          {
            "code" : "26373009",
            "display" : "Thrombosed external hemorrhoids (disorder)"
          },
          {
            "code" : "26382003",
            "display" : "Japanese bobtail cat (organism)"
          },
          {
            "code" : "26386000",
            "display" : "Vitreous cavity structure (body structure)"
          },
          {
            "code" : "26389007",
            "display" : "Toxic multinodular goiter (disorder)"
          },
          {
            "code" : "26390003",
            "display" : "Total colectomy (procedure)"
          },
          {
            "code" : "26412008",
            "display" : "Endotracheal tube, device (physical object)"
          },
          {
            "code" : "26416006",
            "display" : "Drug abuse (disorder)"
          },
          {
            "code" : "26442006",
            "display" : "Closed fracture of shaft of femur (disorder)"
          },
          {
            "code" : "26444007",
            "display" : "Shoulder girdle structure (body structure)"
          },
          {
            "code" : "26458009",
            "display" : "Product containing diphenhydramine (medicinal product)"
          },
          {
            "code" : "26460006",
            "display" : "Slipped upper femoral epiphysis (disorder)"
          },
          {
            "code" : "26476002",
            "display" : "Operation on bronchus (procedure)"
          },
          {
            "code" : "26493002",
            "display" : "Structure of jugular notch of sternum (body structure)"
          },
          {
            "code" : "26507005",
            "display" : "Spouse committed adultery (finding)"
          },
          {
            "code" : "26523005",
            "display" : "Product containing dobutamine (medicinal product)"
          },
          {
            "code" : "26525003",
            "display" : "White Park cattle breed (organism)"
          },
          {
            "code" : "26527006",
            "display" : "Inverse Trendelenburg position (finding)"
          },
          {
            "code" : "26533002",
            "display" : "Apartment building living (finding)"
          },
          {
            "code" : "26538006",
            "display" : "Degeneration of lumbar intervertebral disc (disorder)"
          },
          {
            "code" : "26544005",
            "display" : "Muscle weakness (finding)"
          },
          {
            "code" : "26578004",
            "display" : "Hysterotomy with removal of hydatidiform mole (procedure)"
          },
          {
            "code" : "26587008",
            "display" : "Sexual nondevelopment (finding)"
          },
          {
            "code" : "26593000",
            "display" : "Paroxysmal (qualifier value)"
          },
          {
            "code" : "26614003",
            "display" : "Hydrocele of testis (disorder)"
          },
          {
            "code" : "26629001",
            "display" : "Short bowel syndrome (disorder)"
          },
          {
            "code" : "26630006",
            "display" : "Yellow fever virus (organism)"
          },
          {
            "code" : "26636000",
            "display" : "Sudden death (event)"
          },
          {
            "code" : "26639007",
            "display" : "Toy fox terrier (organism)"
          },
          {
            "code" : "26643006",
            "display" : "Oral route (qualifier value)"
          },
          {
            "code" : "26649005",
            "display" : "Chronic ulcer of lower extremity (disorder)"
          },
          {
            "code" : "26650005",
            "display" : "Acute tracheitis (disorder)"
          },
          {
            "code" : "26660001",
            "display" : "Dilatation of aorta (disorder)"
          },
          {
            "code" : "26665006",
            "display" : "Antisocial personality disorder (disorder)"
          },
          {
            "code" : "26671000",
            "display" : "Structure of pulp of tooth (body structure)"
          },
          {
            "code" : "26677001",
            "display" : "Sleep pattern disturbance (finding)"
          },
          {
            "code" : "26681001",
            "display" : "Endometriosis of pelvis (disorder)"
          },
          {
            "code" : "26682008",
            "display" : "Homozygous beta thalassemia (disorder)"
          },
          {
            "code" : "26699009",
            "display" : "New Forest pony (organism)"
          },
          {
            "code" : "26703007",
            "display" : "Structure of anterior tibial vein (body structure)"
          },
          {
            "code" : "26715006",
            "display" : "Steroid-induced myopathy (disorder)"
          },
          {
            "code" : "26733000",
            "display" : "Mycobacterium lepraemurium (organism)"
          },
          {
            "code" : "26748006",
            "display" : "Hypocalcification of teeth (disorder)"
          },
          {
            "code" : "26758005",
            "display" : "Albumin measurement (procedure)"
          },
          {
            "code" : "26762004",
            "display" : "Autopsy, gross examination, teaching, complete (procedure)"
          },
          {
            "code" : "26764003",
            "display" : "Genus Leptospira (organism)"
          },
          {
            "code" : "26786002",
            "display" : "Scleral buckling (procedure)"
          },
          {
            "code" : "26795005",
            "display" : "Skin structure of thenar region of palm (body structure)"
          },
          {
            "code" : "26800000",
            "display" : "Product containing midazolam (medicinal product)"
          },
          {
            "code" : "26805005",
            "display" : "Structure of small saphenous vein (body structure)"
          },
          {
            "code" : "26818002",
            "display" : "Superficial palmar arch structure (body structure)"
          },
          {
            "code" : "26837006",
            "display" : "American cream horse (organism)"
          },
          {
            "code" : "26843008",
            "display" : "Antiphospholipid syndrome (disorder)"
          },
          {
            "code" : "26883000",
            "display" : "Abscess of knee (disorder)"
          },
          {
            "code" : "26889001",
            "display" : "Myositis (disorder)"
          },
          {
            "code" : "26893007",
            "display" : "Inguinal region structure (body structure)"
          },
          {
            "code" : "26929004",
            "display" : "Alzheimer's disease (disorder)"
          },
          {
            "code" : "26947005",
            "display" : "Open wound of lower limb (disorder)"
          },
          {
            "code" : "26973000",
            "display" : "American trotter horse (organism)"
          },
          {
            "code" : "27016007",
            "display" : "Alizarin yellow GG stain (substance)"
          },
          {
            "code" : "27029007",
            "display" : "Hyperalimentation formula (finding)"
          },
          {
            "code" : "27034006",
            "display" : "Fertility problem (finding)"
          },
          {
            "code" : "27054007",
            "display" : "Cobalt-57 (substance)"
          },
          {
            "code" : "27059002",
            "display" : "Postoperative hypothyroidism (disorder)"
          },
          {
            "code" : "27065002",
            "display" : "Surgical suture, device (physical object)"
          },
          {
            "code" : "27081007",
            "display" : "Xenon-127 (substance)"
          },
          {
            "code" : "27088001",
            "display" : "Spinal cord white matter structure (body structure)"
          },
          {
            "code" : "27090000",
            "display" : "Transitional cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "27120008",
            "display" : "Malachite green stain (substance)"
          },
          {
            "code" : "27125003",
            "display" : "Korat cat (organism)"
          },
          {
            "code" : "27142009",
            "display" : "Mycobacterium bovis (organism)"
          },
          {
            "code" : "27151001",
            "display" : "Post-laminectomy syndrome (disorder)"
          },
          {
            "code" : "27174002",
            "display" : "Pyelitis (disorder)"
          },
          {
            "code" : "27175001",
            "display" : "Structure of testicular artery (body structure)"
          },
          {
            "code" : "27179007",
            "display" : "Disturbance in role performance (finding)"
          },
          {
            "code" : "27182002",
            "display" : "Sprain of acromioclavicular ligament (disorder)"
          },
          {
            "code" : "27194006",
            "display" : "Corneal edema (disorder)"
          },
          {
            "code" : "27214003",
            "display" : "Atonic postpartum hemorrhage (disorder)"
          },
          {
            "code" : "27268008",
            "display" : "Genus Salmonella (organism)"
          },
          {
            "code" : "27286006",
            "display" : "Penis captivus (finding)"
          },
          {
            "code" : "27301002",
            "display" : "Paez (ethnic group)"
          },
          {
            "code" : "27305006",
            "display" : "Phonatory interruption, function (observable entity)"
          },
          {
            "code" : "27315000",
            "display" : "Removal of breast implant (procedure)"
          },
          {
            "code" : "27334000",
            "display" : "Genus Ehrlichia (organism)"
          },
          {
            "code" : "27337007",
            "display" : "Unifocal premature ventricular complexes (disorder)"
          },
          {
            "code" : "27342004",
            "display" : "Anemia of pregnancy (disorder)"
          },
          {
            "code" : "27355003",
            "display" : "Toothache (finding)"
          },
          {
            "code" : "27365009",
            "display" : "Mycobacterium austroafricanum (organism)"
          },
          {
            "code" : "27372005",
            "display" : "Regional anesthesia (procedure)"
          },
          {
            "code" : "27379001",
            "display" : "Sexual maladjustment (finding)"
          },
          {
            "code" : "27385008",
            "display" : "Field spaniel (organism)"
          },
          {
            "code" : "27398004",
            "display" : "Omentum structure (body structure)"
          },
          {
            "code" : "27405005",
            "display" : "Central sleep apnea syndrome (disorder)"
          },
          {
            "code" : "27431007",
            "display" : "Fibrocystic breast changes (finding)"
          },
          {
            "code" : "27433005",
            "display" : "Sexual anesthesia (finding)"
          },
          {
            "code" : "27444002",
            "display" : "Belgian tervuren dog (organism)"
          },
          {
            "code" : "27460003",
            "display" : "Primary syphilis of breast (disorder)"
          },
          {
            "code" : "27468005",
            "display" : "Naming (observable entity)"
          },
          {
            "code" : "27477003",
            "display" : "Fracture of face bones (disorder)"
          },
          {
            "code" : "27480002",
            "display" : "Excision of bunion (procedure)"
          },
          {
            "code" : "27483000",
            "display" : "Diagnostic radiography with contrast media (procedure)"
          },
          {
            "code" : "27503000",
            "display" : "Gilbert's syndrome (disorder)"
          },
          {
            "code" : "27550009",
            "display" : "Disorder of blood vessel (disorder)"
          },
          {
            "code" : "27561001",
            "display" : "Cellulitis of finger (disorder)"
          },
          {
            "code" : "27606000",
            "display" : "Dental prosthesis, device (physical object)"
          },
          {
            "code" : "27612005",
            "display" : "Trigeminal nerve structure (body structure)"
          },
          {
            "code" : "27615007",
            "display" : "Great dane dog (organism)"
          },
          {
            "code" : "27624003",
            "display" : "Chronic disease (disorder)"
          },
          {
            "code" : "27635008",
            "display" : "Aching pain (finding)"
          },
          {
            "code" : "27637000",
            "display" : "Dextrocardia (disorder)"
          },
          {
            "code" : "27658006",
            "display" : "Product containing amoxicillin (medicinal product)"
          },
          {
            "code" : "27671009",
            "display" : "Rhodamine B stain (substance)"
          },
          {
            "code" : "27678003",
            "display" : "Myokymia (finding)"
          },
          {
            "code" : "27681008",
            "display" : "Chronic gonorrhea (disorder)"
          },
          {
            "code" : "27683006",
            "display" : "Ainu (ethnic group)"
          },
          {
            "code" : "27700004",
            "display" : "Iraqi (ethnic group)"
          },
          {
            "code" : "27706005",
            "display" : "Structure of left pulmonary vein (body structure)"
          },
          {
            "code" : "27717006",
            "display" : "Abscess of scrotum (disorder)"
          },
          {
            "code" : "27718001",
            "display" : "Maple syrup urine disease (disorder)"
          },
          {
            "code" : "27720003",
            "display" : "Dermatitis factitia (disorder)"
          },
          {
            "code" : "27741009",
            "display" : "Calcific tendinitis of shoulder (disorder)"
          },
          {
            "code" : "27789000",
            "display" : "Infrequent (qualifier value)"
          },
          {
            "code" : "27812008",
            "display" : "Electric heating pad, device (physical object)"
          },
          {
            "code" : "27813003",
            "display" : "Intra-articular injection (procedure)"
          },
          {
            "code" : "27836007",
            "display" : "Pertussis (disorder)"
          },
          {
            "code" : "27844007",
            "display" : "Benzo fast scarlet stain (substance)"
          },
          {
            "code" : "27855007",
            "display" : "Structure of deciduous maxillary right second molar tooth (body structure)"
          },
          {
            "code" : "27872000",
            "display" : "Specimen freezing (procedure)"
          },
          {
            "code" : "27885002",
            "display" : "Complete atrioventricular block (disorder)"
          },
          {
            "code" : "27887005",
            "display" : "Skin structure of medial canthus (body structure)"
          },
          {
            "code" : "27916005",
            "display" : "Abscess of liver (disorder)"
          },
          {
            "code" : "27925004",
            "display" : "Nodule (morphologic abnormality)"
          },
          {
            "code" : "27938007",
            "display" : "Bland diet, stage 3 (finding)"
          },
          {
            "code" : "27942005",
            "display" : "Shock (disorder)"
          },
          {
            "code" : "27947004",
            "display" : "Epigastric region structure (body structure)"
          },
          {
            "code" : "27949001",
            "display" : "Intertarsal joint structure (body structure)"
          },
          {
            "code" : "28012007",
            "display" : "Closed fracture of shaft of tibia (disorder)"
          },
          {
            "code" : "28017001",
            "display" : "Daytime (qualifier value)"
          },
          {
            "code" : "28032008",
            "display" : "Insulin dependent diabetes mellitus type IB (disorder)"
          },
          {
            "code" : "28035005",
            "display" : "Structure of teeth, gums, and supporting structures (body structure)"
          },
          {
            "code" : "28078000",
            "display" : "Closed fracture of shaft of bone of forearm (disorder)"
          },
          {
            "code" : "28079008",
            "display" : "Multiparous (finding)"
          },
          {
            "code" : "28104001",
            "display" : "Vascular complication of medical care (disorder)"
          },
          {
            "code" : "28109006",
            "display" : "Legionella erythra (organism)"
          },
          {
            "code" : "28119000",
            "display" : "Renal hypertension (disorder)"
          },
          {
            "code" : "28121005",
            "display" : "Iophendylate (substance)"
          },
          {
            "code" : "28122003",
            "display" : "Pulmonary eosinophilic granuloma (disorder)"
          },
          {
            "code" : "28127009",
            "display" : "Social drinker (finding)"
          },
          {
            "code" : "28154007",
            "display" : "Abnormal female sexual function (finding)"
          },
          {
            "code" : "28188001",
            "display" : "Brain injury with open intracranial wound (disorder)"
          },
          {
            "code" : "28189009",
            "display" : "Mobitz type II atrioventricular block (disorder)"
          },
          {
            "code" : "28198007",
            "display" : "Primary syphilis of lip (disorder)"
          },
          {
            "code" : "28205006",
            "display" : "Structure of infrarenal aorta (body structure)"
          },
          {
            "code" : "28229004",
            "display" : "Optometrist (occupation)"
          },
          {
            "code" : "28230009",
            "display" : "Poultry (substance)"
          },
          {
            "code" : "28231008",
            "display" : "Gallbladder structure (body structure)"
          },
          {
            "code" : "28243009",
            "display" : "Radium-226 (substance)"
          },
          {
            "code" : "28271003",
            "display" : "Noninflammatory disorder of vulva (disorder)"
          },
          {
            "code" : "28273000",
            "display" : "Bile duct structure (body structure)"
          },
          {
            "code" : "28277004",
            "display" : "Behavior showing increased motor activity (finding)"
          },
          {
            "code" : "28288005",
            "display" : "Middle-age (finding)"
          },
          {
            "code" : "28293008",
            "display" : "Hereditary factor VIII deficiency disease (disorder)"
          },
          {
            "code" : "28330007",
            "display" : "Structure of subcarinal lymph node (body structure)"
          },
          {
            "code" : "28332004",
            "display" : "Family disruption (finding)"
          },
          {
            "code" : "28335002",
            "display" : "Rift Valley fever virus (organism)"
          },
          {
            "code" : "28347008",
            "display" : "External ear structure (body structure)"
          },
          {
            "code" : "28360002",
            "display" : "Swiss alpine goat (organism)"
          },
          {
            "code" : "28382009",
            "display" : "Vibrio metschnikovii (organism)"
          },
          {
            "code" : "28390009",
            "display" : "Medial longitudinal fasciculus structure (body structure)"
          },
          {
            "code" : "28391008",
            "display" : "Localized retinal edema (disorder)"
          },
          {
            "code" : "28409002",
            "display" : "Spaniards (ethnic group)"
          },
          {
            "code" : "28432003",
            "display" : "Abscess of breast (disorder)"
          },
          {
            "code" : "28442001",
            "display" : "Polyuria (finding)"
          },
          {
            "code" : "28475009",
            "display" : "Severe recurrent major depression with psychotic features (disorder)"
          },
          {
            "code" : "28480000",
            "display" : "Structure of mandibular right first molar tooth (body structure)"
          },
          {
            "code" : "28483003",
            "display" : "Simmental cattle breed (organism)"
          },
          {
            "code" : "28499009",
            "display" : "Rickettsia prowazekii (organism)"
          },
          {
            "code" : "28520004",
            "display" : "Venipuncture for blood test (procedure)"
          },
          {
            "code" : "28528006",
            "display" : "Adult habitual masturbation (finding)"
          },
          {
            "code" : "28534004",
            "display" : "Spastic paralysis due to intracranial birth injury (disorder)"
          },
          {
            "code" : "28550007",
            "display" : "Congenital capsular cataract (disorder)"
          },
          {
            "code" : "28562006",
            "display" : "Poles (ethnic group)"
          },
          {
            "code" : "28572009",
            "display" : "Chronic gonorrhea of genitourinary tract (disorder)"
          },
          {
            "code" : "28590005",
            "display" : "Chronic acquired lymphedema (disorder)"
          },
          {
            "code" : "28622002",
            "display" : "Alizarin yellow R stain (substance)"
          },
          {
            "code" : "28625000",
            "display" : "Taenia (organism)"
          },
          {
            "code" : "28626004",
            "display" : "Vesicocolic fistula (disorder)"
          },
          {
            "code" : "28647000",
            "display" : "Meat (substance)"
          },
          {
            "code" : "28651003",
            "display" : "Orthostatic hypotension (disorder)"
          },
          {
            "code" : "28663008",
            "display" : "Severe manic bipolar I disorder with psychotic features (disorder)"
          },
          {
            "code" : "28670008",
            "display" : "Esophageal varices (disorder)"
          },
          {
            "code" : "28700002",
            "display" : "Structure of carina of trachea (body structure)"
          },
          {
            "code" : "28701003",
            "display" : "Low maternal weight gain (finding)"
          },
          {
            "code" : "28715001",
            "display" : "Objective tinnitus (finding)"
          },
          {
            "code" : "28726007",
            "display" : "Corneal structure (body structure)"
          },
          {
            "code" : "28732002",
            "display" : "Snowshoe hare virus (organism)"
          },
          {
            "code" : "28743005",
            "display" : "Productive cough (finding)"
          },
          {
            "code" : "28744004",
            "display" : "Black Welsh cattle breed (organism)"
          },
          {
            "code" : "28751008",
            "display" : "Chow Chow (organism)"
          },
          {
            "code" : "28768007",
            "display" : "Incisional biopsy of breast mass (procedure)"
          },
          {
            "code" : "28769004",
            "display" : "Osteomyelitis of ankle AND/OR foot (disorder)"
          },
          {
            "code" : "28770003",
            "display" : "Polycystic kidney disease, infantile type (disorder)"
          },
          {
            "code" : "28792004",
            "display" : "Preoperative preparation of skin (procedure)"
          },
          {
            "code" : "28796001",
            "display" : "Siamese (ethnic group)"
          },
          {
            "code" : "28812006",
            "display" : "Hemodialysis education (procedure)"
          },
          {
            "code" : "28821007",
            "display" : "Easter Islanders (ethnic group)"
          },
          {
            "code" : "28826002",
            "display" : "Sialolithiasis (disorder)"
          },
          {
            "code" : "28835009",
            "display" : "Retinitis pigmentosa (disorder)"
          },
          {
            "code" : "28845006",
            "display" : "Acute appendicitis with generalized peritonitis (disorder)"
          },
          {
            "code" : "28870006",
            "display" : "Structure of epitrochlear lymph node (body structure)"
          },
          {
            "code" : "28884001",
            "display" : "Moderate bipolar I disorder, single manic episode (disorder)"
          },
          {
            "code" : "28899001",
            "display" : "Squamous cell carcinoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "28913000",
            "display" : "Tonsillectomy and adenoidectomy (procedure)"
          },
          {
            "code" : "28926001",
            "display" : "Eruption caused by drug (disorder)"
          },
          {
            "code" : "28944009",
            "display" : "Cytomegalovirus infection (disorder)"
          },
          {
            "code" : "28960008",
            "display" : "Arteriosclerosis (morphologic abnormality)"
          },
          {
            "code" : "28978003",
            "display" : "Progressive supranuclear ophthalmoplegia (disorder)"
          },
          {
            "code" : "28998008",
            "display" : "Retinal hemorrhage (disorder)"
          },
          {
            "code" : "29003001",
            "display" : "Spastic dysphonia (disorder)"
          },
          {
            "code" : "29050005",
            "display" : "Acute iritis (disorder)"
          },
          {
            "code" : "29074008",
            "display" : "Polyp of maxillary sinus (disorder)"
          },
          {
            "code" : "29092000",
            "display" : "Venous structure (body structure)"
          },
          {
            "code" : "29111009",
            "display" : "Mycobacterium agri (organism)"
          },
          {
            "code" : "29155003",
            "display" : "Ectromelia of upper limb (disorder)"
          },
          {
            "code" : "29159009",
            "display" : "Familial dysautonomia (disorder)"
          },
          {
            "code" : "29164008",
            "display" : "Disturbance in speech (finding)"
          },
          {
            "code" : "29185008",
            "display" : "Fatty degeneration (morphologic abnormality)"
          },
          {
            "code" : "29212009",
            "display" : "Alcohol-induced organic mental disorder (disorder)"
          },
          {
            "code" : "29218008",
            "display" : "Indium (111-In) pentetate (substance)"
          },
          {
            "code" : "29223008",
            "display" : "Boar power pig 565 (organism)"
          },
          {
            "code" : "29235007",
            "display" : "Pic line pig 26 (organism)"
          },
          {
            "code" : "29240004",
            "display" : "Autopsy examination (procedure)"
          },
          {
            "code" : "29252006",
            "display" : "Acridine orange stain (substance)"
          },
          {
            "code" : "29259002",
            "display" : "Malignant hypertension complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "29260007",
            "display" : "Immunoglobulin A deficiency (disorder)"
          },
          {
            "code" : "29268000",
            "display" : "Contact hypersensitivity (disorder)"
          },
          {
            "code" : "29281007",
            "display" : "Aseptic necrosis of head AND/OR neck of femur (disorder)"
          },
          {
            "code" : "29303009",
            "display" : "Electrocardiographic procedure (procedure)"
          },
          {
            "code" : "29342009",
            "display" : "Kenacid blue R stain (substance)"
          },
          {
            "code" : "29343004",
            "display" : "Bulgarian (ethnic group)"
          },
          {
            "code" : "29348008",
            "display" : "Ytterbium (169-Yb) pentetate calcium trisodium (substance)"
          },
          {
            "code" : "29353003",
            "display" : "Skin structure of clitoris (body structure)"
          },
          {
            "code" : "29384001",
            "display" : "Disorder of stomach (disorder)"
          },
          {
            "code" : "29399001",
            "display" : "Elderly primigravida (finding)"
          },
          {
            "code" : "29426003",
            "display" : "Paralytic syndrome (disorder)"
          },
          {
            "code" : "29445007",
            "display" : "Conjunctival structure (body structure)"
          },
          {
            "code" : "29460005",
            "display" : "Copper (67-Cu) ceruloplasmin (substance)"
          },
          {
            "code" : "29483008",
            "display" : "Calcified atheromatous plaque (morphologic abnormality)"
          },
          {
            "code" : "29522004",
            "display" : "Tolonium chloride (substance)"
          },
          {
            "code" : "29534007",
            "display" : "Ciliary body structure (body structure)"
          },
          {
            "code" : "29544009",
            "display" : "Intolerance, function (observable entity)"
          },
          {
            "code" : "29553002",
            "display" : "Peg-shaped teeth (disorder)"
          },
          {
            "code" : "29555009",
            "display" : "Retinal disorder (disorder)"
          },
          {
            "code" : "29565003",
            "display" : "Structure of right lobe of thyroid gland (body structure)"
          },
          {
            "code" : "29599000",
            "display" : "Chronic undifferentiated schizophrenia (disorder)"
          },
          {
            "code" : "29608009",
            "display" : "Acute epiglottitis (disorder)"
          },
          {
            "code" : "29613008",
            "display" : "Delivery by double application of forceps (procedure)"
          },
          {
            "code" : "29660000",
            "display" : "Structure of inferior phrenic artery (body structure)"
          },
          {
            "code" : "29679002",
            "display" : "Carrier of disorder (finding)"
          },
          {
            "code" : "29680004",
            "display" : "Genus Ureaplasma (organism)"
          },
          {
            "code" : "29700009",
            "display" : "Structure of right subclavian artery (body structure)"
          },
          {
            "code" : "29707007",
            "display" : "Toe structure (body structure)"
          },
          {
            "code" : "29717002",
            "display" : "Premature beats (disorder)"
          },
          {
            "code" : "29724001",
            "display" : "Genus Orthopoxvirus (organism)"
          },
          {
            "code" : "29738008",
            "display" : "Proteinuria (finding)"
          },
          {
            "code" : "29740003",
            "display" : "Nutritional marasmus (disorder)"
          },
          {
            "code" : "29749002",
            "display" : "Closed fracture of scapula (disorder)"
          },
          {
            "code" : "29753000",
            "display" : "Partial seizure (disorder)"
          },
          {
            "code" : "29786001",
            "display" : "Listeria conjunctivitis (disorder)"
          },
          {
            "code" : "29827000",
            "display" : "Bilateral salpingectomy with oophorectomy (procedure)"
          },
          {
            "code" : "29836001",
            "display" : "Hip region structure (body structure)"
          },
          {
            "code" : "29850006",
            "display" : "Iliac crest structure (body structure)"
          },
          {
            "code" : "29857009",
            "display" : "Chest pain (finding)"
          },
          {
            "code" : "29862005",
            "display" : "Paraumbilical hernia (disorder)"
          },
          {
            "code" : "29864006",
            "display" : "Acute gonococcal urethritis (disorder)"
          },
          {
            "code" : "29870000",
            "display" : "Umbilical cord structure (body structure)"
          },
          {
            "code" : "29881002",
            "display" : "Connor prairie pig (organism)"
          },
          {
            "code" : "29885006",
            "display" : "Sacroiliac instability (finding)"
          },
          {
            "code" : "29915004",
            "display" : "Autopsy, clerical with coding procedure (procedure)"
          },
          {
            "code" : "29943008",
            "display" : "Herpes simplex dendritic keratitis (disorder)"
          },
          {
            "code" : "29951006",
            "display" : "Chronic laryngitis (disorder)"
          },
          {
            "code" : "29958000",
            "display" : "Protein hydrolysate (finding)"
          },
          {
            "code" : "29966009",
            "display" : "Hypertrichosis (disorder)"
          },
          {
            "code" : "29976007",
            "display" : "Trachoma, initial stage (disorder)"
          },
          {
            "code" : "30017007",
            "display" : "Vascular dilatation, function (observable entity)"
          },
          {
            "code" : "30020004",
            "display" : "Plasmodium falciparum (organism)"
          },
          {
            "code" : "30021000",
            "display" : "Structure of lower extremity from knee to ankle (body structure)"
          },
          {
            "code" : "30024008",
            "display" : "Structure of sigmoid lymph node (body structure)"
          },
          {
            "code" : "30037006",
            "display" : "Anal fissure (disorder)"
          },
          {
            "code" : "30041005",
            "display" : "Acute angle-closure glaucoma (disorder)"
          },
          {
            "code" : "30044002",
            "display" : "Full thickness burn of foot (disorder)"
          },
          {
            "code" : "30058000",
            "display" : "Therapeutic drug monitoring assay (regime/therapy)"
          },
          {
            "code" : "30059008",
            "display" : "Panic disorder with agoraphobia, severe agoraphobic avoidance AND moderate panic attacks (disorder)"
          },
          {
            "code" : "30080002",
            "display" : "Secondary syphilitic iridocyclitis (disorder)"
          },
          {
            "code" : "30085007",
            "display" : "Morton's metatarsalgia (disorder)"
          },
          {
            "code" : "30089001",
            "display" : "Toggenburg goat (organism)"
          },
          {
            "code" : "30105008",
            "display" : "Acute renal failure diet (finding)"
          },
          {
            "code" : "30114003",
            "display" : "Medial lemniscus structure (body structure)"
          },
          {
            "code" : "30123000",
            "display" : "Repair of atrial septal defect with prosthesis by closed heart technique (procedure)"
          },
          {
            "code" : "30128009",
            "display" : "Tietze's disease (disorder)"
          },
          {
            "code" : "30140009",
            "display" : "Enteritis presumed infectious (disorder)"
          },
          {
            "code" : "30156004",
            "display" : "Cribriform carcinoma (morphologic abnormality)"
          },
          {
            "code" : "30171000",
            "display" : "Disorder of adrenal gland (disorder)"
          },
          {
            "code" : "30180000",
            "display" : "Tunica adventitia (body structure)"
          },
          {
            "code" : "30188007",
            "display" : "Alpha-1-antitrypsin deficiency (disorder)"
          },
          {
            "code" : "30233002",
            "display" : "Swallowing painful (finding)"
          },
          {
            "code" : "30238006",
            "display" : "Secondary female infertility (disorder)"
          },
          {
            "code" : "30240001",
            "display" : "Incomplete masturbation (finding)"
          },
          {
            "code" : "30242009",
            "display" : "Scarlet fever (disorder)"
          },
          {
            "code" : "30250000",
            "display" : "Acute otitis externa (disorder)"
          },
          {
            "code" : "30281009",
            "display" : "Disorder of prostate (disorder)"
          },
          {
            "code" : "30288003",
            "display" : "Ventricular septal defect (disorder)"
          },
          {
            "code" : "30292005",
            "display" : "Mononeuritis multiplex (disorder)"
          },
          {
            "code" : "30315005",
            "display" : "Structure of small intestine (body structure)"
          },
          {
            "code" : "30332009",
            "display" : "Altered growth and development: self-care skills (finding)"
          },
          {
            "code" : "30345008",
            "display" : "Genus Treponema (organism)"
          },
          {
            "code" : "30347000",
            "display" : "Italian greyhound (organism)"
          },
          {
            "code" : "30384003",
            "display" : "Brahma cattle breed (organism)"
          },
          {
            "code" : "30399003",
            "display" : "Structure of anterior horn of lateral ventricle (body structure)"
          },
          {
            "code" : "30434006",
            "display" : "La Crosse virus (organism)"
          },
          {
            "code" : "30448006",
            "display" : "Lacombe pig (organism)"
          },
          {
            "code" : "30473006",
            "display" : "Pain in pelvis (finding)"
          },
          {
            "code" : "30476003",
            "display" : "Barton's forceps delivery (procedure)"
          },
          {
            "code" : "30492008",
            "display" : "Medicinal product acting as diuretic (product)"
          },
          {
            "code" : "30518006",
            "display" : "Bone structure of scaphoid (body structure)"
          },
          {
            "code" : "30542005",
            "display" : "Implantation of umbrella into vena cava (procedure)"
          },
          {
            "code" : "30549001",
            "display" : "Removal of suture (procedure)"
          },
          {
            "code" : "30556007",
            "display" : "Recurrent dislocation of shoulder region (disorder)"
          },
          {
            "code" : "30565000",
            "display" : "Cocker spaniel, any solid color other than black (organism)"
          },
          {
            "code" : "30588004",
            "display" : "Ischemic colitis (disorder)"
          },
          {
            "code" : "30592006",
            "display" : "Brachymetatarsia (disorder)"
          },
          {
            "code" : "30598005",
            "display" : "Skin structure of epigastric area (body structure)"
          },
          {
            "code" : "30608006",
            "display" : "Skeletal muscle structure of upper limb (body structure)"
          },
          {
            "code" : "30611007",
            "display" : "Idiopathic scoliosis AND/OR kyphoscoliosis (disorder)"
          },
          {
            "code" : "30618001",
            "display" : "Structure of deciduous maxillary right canine tooth (body structure)"
          },
          {
            "code" : "30620003",
            "display" : "Spina bifida of dorsal region (disorder)"
          },
          {
            "code" : "30634003",
            "display" : "Tamworth pig (organism)"
          },
          {
            "code" : "30654002",
            "display" : "Hypertrophy of nail (disorder)"
          },
          {
            "code" : "30664006",
            "display" : "Multiple endocrine neoplasia, type 1 (disorder)"
          },
          {
            "code" : "30667004",
            "display" : "Right bundle branch block AND left anterior fascicular block (disorder)"
          },
          {
            "code" : "30689000",
            "display" : "Adhesion of abdominal wall (disorder)"
          },
          {
            "code" : "30714006",
            "display" : "Resistant (qualifier value)"
          },
          {
            "code" : "30720007",
            "display" : "Boar power pig 84 (organism)"
          },
          {
            "code" : "30721006",
            "display" : "Intention tremor (finding)"
          },
          {
            "code" : "30730003",
            "display" : "Sagittal (qualifier value)"
          },
          {
            "code" : "30731004",
            "display" : "Glossodynia (disorder)"
          },
          {
            "code" : "30746006",
            "display" : "Lymphadenopathy (disorder)"
          },
          {
            "code" : "30753002",
            "display" : "Normal pressure hydrocephalus (disorder)"
          },
          {
            "code" : "30769009",
            "display" : "Rickettsia akari (organism)"
          },
          {
            "code" : "30793004",
            "display" : "Posterior auricular lymph node (body structure)"
          },
          {
            "code" : "30800001",
            "display" : "Vaginitis (disorder)"
          },
          {
            "code" : "30807003",
            "display" : "Benign (qualifier value)"
          },
          {
            "code" : "30811009",
            "display" : "Ulcer of esophagus (disorder)"
          },
          {
            "code" : "30833006",
            "display" : "Vulvar vestibulitis (disorder)"
          },
          {
            "code" : "30846001",
            "display" : "Arterial bruit (finding)"
          },
          {
            "code" : "30852000",
            "display" : "General diet for child (finding)"
          },
          {
            "code" : "30880003",
            "display" : "Trabeculectomy ab externo (procedure)"
          },
          {
            "code" : "30904006",
            "display" : "Vascular surgery procedure (procedure)"
          },
          {
            "code" : "30905007",
            "display" : "Closed supracondylar fracture of femur (disorder)"
          },
          {
            "code" : "30911005",
            "display" : "Cryoglobulinemia (disorder)"
          },
          {
            "code" : "30913008",
            "display" : "Disorder of iron metabolism (disorder)"
          },
          {
            "code" : "30917009",
            "display" : "Clostridium tetani (organism)"
          },
          {
            "code" : "30935000",
            "display" : "Manic bipolar I disorder in full remission (disorder)"
          },
          {
            "code" : "30949009",
            "display" : "Enterococcus casseliflavus (organism)"
          },
          {
            "code" : "30950009",
            "display" : "Bland diet, stage 4 (finding)"
          },
          {
            "code" : "30953006",
            "display" : "Drinking (observable entity)"
          },
          {
            "code" : "30956003",
            "display" : "Subtotal thyroidectomy (procedure)"
          },
          {
            "code" : "30959005",
            "display" : "Erotic day dreaming (finding)"
          },
          {
            "code" : "30974007",
            "display" : "Rickettsia canadensis (organism)"
          },
          {
            "code" : "30976009",
            "display" : "Vocal fold adduction, function (observable entity)"
          },
          {
            "code" : "30989003",
            "display" : "Knee pain (finding)"
          },
          {
            "code" : "31002004",
            "display" : "Controlled potassium, controlled sodium and controlled protein diet (finding)"
          },
          {
            "code" : "31006001",
            "display" : "Kingdom Plantae (organism)"
          },
          {
            "code" : "31015008",
            "display" : "Primary anal syphilis (disorder)"
          },
          {
            "code" : "31031000",
            "display" : "Orthopedic internal fixation system, device (physical object)"
          },
          {
            "code" : "31053003",
            "display" : "Disorder of lacrimal system (disorder)"
          },
          {
            "code" : "31054009",
            "display" : "Ureteric stone (disorder)"
          },
          {
            "code" : "31065004",
            "display" : "Occipital lobe structure (body structure)"
          },
          {
            "code" : "31070006",
            "display" : "Epididymitis (disorder)"
          },
          {
            "code" : "31077009",
            "display" : "Shih tzu dog (organism)"
          },
          {
            "code" : "31085000",
            "display" : "Rheumatic mitral regurgitation (disorder)"
          },
          {
            "code" : "31094006",
            "display" : "Structure of lobe of lung (body structure)"
          },
          {
            "code" : "31097004",
            "display" : "Post poliomyelitis syndrome (disorder)"
          },
          {
            "code" : "31099001",
            "display" : "Systemic (qualifier value)"
          },
          {
            "code" : "31105004",
            "display" : "Gargling (observable entity)"
          },
          {
            "code" : "31113003",
            "display" : "Diverticulum (morphologic abnormality)"
          },
          {
            "code" : "31114009",
            "display" : "Place in family order: oldest sibling (finding)"
          },
          {
            "code" : "31137003",
            "display" : "Early latent syphilis, positive serology, negative cerebrospinal fluid, less than 2 years after infection (disorder)"
          },
          {
            "code" : "31145008",
            "display" : "Structure of occipital artery (body structure)"
          },
          {
            "code" : "31150002",
            "display" : "Medium fat meat exchange list (finding)"
          },
          {
            "code" : "31162003",
            "display" : "Structure of coronary sinus of left atrial septum (body structure)"
          },
          {
            "code" : "31169007",
            "display" : "Clostridium baratii (organism)"
          },
          {
            "code" : "31171007",
            "display" : "Structure of fibular lymph node (body structure)"
          },
          {
            "code" : "31177006",
            "display" : "Attention deficit hyperactivity disorder, combined type (disorder)"
          },
          {
            "code" : "31186001",
            "display" : "Chondroma (morphologic abnormality)"
          },
          {
            "code" : "31192007",
            "display" : "Ferrous (59-Fe) chloride (substance)"
          },
          {
            "code" : "31208007",
            "display" : "Medical induction of labor (procedure)"
          },
          {
            "code" : "31216003",
            "display" : "Profound intellectual disability (disorder)"
          },
          {
            "code" : "31258000",
            "display" : "Cyst of pancreas (disorder)"
          },
          {
            "code" : "31260003",
            "display" : "Methylene violet stain (Bernthsen) (substance)"
          },
          {
            "code" : "31273004",
            "display" : "Urethral syndrome (disorder)"
          },
          {
            "code" : "31281003",
            "display" : "English coonhound (organism)"
          },
          {
            "code" : "31301004",
            "display" : "Chronic gastric ulcer with perforation (disorder)"
          },
          {
            "code" : "31306009",
            "display" : "Product containing quinidine (medicinal product)"
          },
          {
            "code" : "31312004",
            "display" : "Complete denture, including adjustments (procedure)"
          },
          {
            "code" : "31341008",
            "display" : "Vitreous hemorrhage (disorder)"
          },
          {
            "code" : "31351009",
            "display" : "Postartificial menopausal syndrome (disorder)"
          },
          {
            "code" : "31358003",
            "display" : "Coprophilia (disorder)"
          },
          {
            "code" : "31377001",
            "display" : "Rough collie (organism)"
          },
          {
            "code" : "31384009",
            "display" : "Polymyositis (disorder)"
          },
          {
            "code" : "31387002",
            "display" : "Exercise-induced asthma (disorder)"
          },
          {
            "code" : "31389004",
            "display" : "Oropharyngeal structure (body structure)"
          },
          {
            "code" : "31392000",
            "display" : "American eskimo dog (organism)"
          },
          {
            "code" : "31394004",
            "display" : "Light therapy (procedure)"
          },
          {
            "code" : "31401003",
            "display" : "Bicornuate uterus (disorder)"
          },
          {
            "code" : "31407004",
            "display" : "Pre-existing hypertension complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "31428008",
            "display" : "Corpus striatum structure (body structure)"
          },
          {
            "code" : "31435000",
            "display" : "Fallopian tube structure (body structure)"
          },
          {
            "code" : "31437008",
            "display" : "Lymphocytic-plasmacytic colitis (disorder)"
          },
          {
            "code" : "31446002",
            "display" : "Bipolar I disorder, most recent episode hypomanic (disorder)"
          },
          {
            "code" : "31477000",
            "display" : "Left occipitoposterior position (finding)"
          },
          {
            "code" : "31487001",
            "display" : "Disseminated idiopathic skeletal hyperostosis (disorder)"
          },
          {
            "code" : "31492004",
            "display" : "Fear of school (finding)"
          },
          {
            "code" : "31515003",
            "display" : "Hypoventilation (finding)"
          },
          {
            "code" : "31527000",
            "display" : "Sodium (24-Na) chloride (substance)"
          },
          {
            "code" : "31541009",
            "display" : "Sarcoidosis (disorder)"
          },
          {
            "code" : "31551005",
            "display" : "Rotavirus group C (organism)"
          },
          {
            "code" : "31568009",
            "display" : "Listeria meningitis (disorder)"
          },
          {
            "code" : "31572008",
            "display" : "Inspiratory wheezing (finding)"
          },
          {
            "code" : "31574009",
            "display" : "Systolic murmur (finding)"
          },
          {
            "code" : "31609009",
            "display" : "Infant formula for metabolic dysfunction (finding)"
          },
          {
            "code" : "31611000",
            "display" : "Multiple personality disorder (disorder)"
          },
          {
            "code" : "31633003",
            "display" : "Yorkshire coach horse (organism)"
          },
          {
            "code" : "31636006",
            "display" : "Anterior chamber of eye structure (body structure)"
          },
          {
            "code" : "31637002",
            "display" : "Italians (ethnic group)"
          },
          {
            "code" : "31639004",
            "display" : "Nasal air emission (observable entity)"
          },
          {
            "code" : "31640002",
            "display" : "Occipital bone structure (body structure)"
          },
          {
            "code" : "31642005",
            "display" : "Acute gingivitis (disorder)"
          },
          {
            "code" : "31653004",
            "display" : "Fibromuscular dysplasia (morphologic abnormality)"
          },
          {
            "code" : "31658008",
            "display" : "Chronic paranoid schizophrenia (disorder)"
          },
          {
            "code" : "31677005",
            "display" : "Structure of profunda femoris artery (body structure)"
          },
          {
            "code" : "31681005",
            "display" : "Trigeminal neuralgia (disorder)"
          },
          {
            "code" : "31688004",
            "display" : "Structure of testicular vein (body structure)"
          },
          {
            "code" : "31701002",
            "display" : "Ventral funiculus structure (body structure)"
          },
          {
            "code" : "31712002",
            "display" : "Primary biliary cholangitis (disorder)"
          },
          {
            "code" : "31714001",
            "display" : "New fuchsin stain (substance)"
          },
          {
            "code" : "31724009",
            "display" : "Measurement of venous pressure (procedure)"
          },
          {
            "code" : "31742004",
            "display" : "Arteriohepatic dysplasia (disorder)"
          },
          {
            "code" : "31763002",
            "display" : "Ocular motility observable (observable entity)"
          },
          {
            "code" : "31764008",
            "display" : "Structure of trapezius muscle (body structure)"
          },
          {
            "code" : "31781004",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in partial remission AND mild panic attacks (disorder)"
          },
          {
            "code" : "31811003",
            "display" : "Carbon dioxide (substance)"
          },
          {
            "code" : "31822004",
            "display" : "Urethritis (disorder)"
          },
          {
            "code" : "31825002",
            "display" : "Abnormal granulation tissue (disorder)"
          },
          {
            "code" : "31842008",
            "display" : "Normal shape (qualifier value)"
          },
          {
            "code" : "31845005",
            "display" : "Retraction of nipple (disorder)"
          },
          {
            "code" : "31848007",
            "display" : "Calcinosis, Raynaud's phenomenon, esophageal dysmotility, sclerodactyly, and telangiectasia syndrome (disorder)"
          },
          {
            "code" : "31871009",
            "display" : "Infection AND/OR inflammatory reaction due to internal prosthetic device, implant AND/OR graft (disorder)"
          },
          {
            "code" : "31875000",
            "display" : "Anergy (finding)"
          },
          {
            "code" : "31879006",
            "display" : "Lives in a community (finding)"
          },
          {
            "code" : "31892009",
            "display" : "Hemothorax (disorder)"
          },
          {
            "code" : "31895006",
            "display" : "Substance with gonadotropin mechanism of action (substance)"
          },
          {
            "code" : "31908003",
            "display" : "Vaginal dryness (disorder)"
          },
          {
            "code" : "31928004",
            "display" : "Abscess of skin and/or subcutaneous tissue (disorder)"
          },
          {
            "code" : "31932005",
            "display" : "Tympanomastoidectomy (procedure)"
          },
          {
            "code" : "31934006",
            "display" : "Structure of acromion (body structure)"
          },
          {
            "code" : "31953001",
            "display" : "Strontium (87-Sr) nitrate (substance)"
          },
          {
            "code" : "31956009",
            "display" : "Cocaine dependence (disorder)"
          },
          {
            "code" : "31971008",
            "display" : "American water spaniel (organism)"
          },
          {
            "code" : "31975004",
            "display" : "Fracture of navicular bone of wrist (disorder)"
          },
          {
            "code" : "31978002",
            "display" : "Fracture of tibia (disorder)"
          },
          {
            "code" : "31982000",
            "display" : "Structure of maxillary left central incisor tooth (body structure)"
          },
          {
            "code" : "31992008",
            "display" : "Secondary hypertension (disorder)"
          },
          {
            "code" : "31996006",
            "display" : "Vasculitis (disorder)"
          },
          {
            "code" : "31999004",
            "display" : "Chronic gonococcal endometritis (disorder)"
          },
          {
            "code" : "32000005",
            "display" : "Difficulty using verbal communication (finding)"
          },
          {
            "code" : "32021005",
            "display" : "Pulp abscess of finger (disorder)"
          },
          {
            "code" : "32022003",
            "display" : "Degenerative progressive high myopia (disorder)"
          },
          {
            "code" : "32035007",
            "display" : "Chronic lymphadenitis (disorder)"
          },
          {
            "code" : "32045009",
            "display" : "Georgians (ethnic group)"
          },
          {
            "code" : "32048006",
            "display" : "Adenoma, no subtype (morphologic abnormality)"
          },
          {
            "code" : "32062004",
            "display" : "Common carotid artery structure (body structure)"
          },
          {
            "code" : "32074000",
            "display" : "Long term care hospital (environment)"
          },
          {
            "code" : "32114007",
            "display" : "Structure of occipital vein (body structure)"
          },
          {
            "code" : "32145006",
            "display" : "Romanov sheep (organism)"
          },
          {
            "code" : "32150000",
            "display" : "Periodontic procedure (procedure)"
          },
          {
            "code" : "32178004",
            "display" : "Serra do Navio virus (organism)"
          },
          {
            "code" : "32185000",
            "display" : "Lateral decubitus position (finding)"
          },
          {
            "code" : "32219008",
            "display" : "Craniorachischisis (disorder)"
          },
          {
            "code" : "32230006",
            "display" : "Malabsorption syndrome (disorder)"
          },
          {
            "code" : "32232003",
            "display" : "Spina bifida of cervical region (disorder)"
          },
          {
            "code" : "32273002",
            "display" : "Idiopathic thrombocytopenic purpura (disorder)"
          },
          {
            "code" : "32297006",
            "display" : "Boar power pig 48 (organism)"
          },
          {
            "code" : "32307003",
            "display" : "Polyp of nasal sinus (disorder)"
          },
          {
            "code" : "32318003",
            "display" : "Vascular constriction, function (observable entity)"
          },
          {
            "code" : "32348000",
            "display" : "Open wound of finger with complication (disorder)"
          },
          {
            "code" : "32361000",
            "display" : "Popliteal fossa structure (body structure)"
          },
          {
            "code" : "32381004",
            "display" : "Portal (qualifier value)"
          },
          {
            "code" : "32388005",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in partial remission AND moderate panic attacks (disorder)"
          },
          {
            "code" : "32390006",
            "display" : "Panhypopituitarism (disorder)"
          },
          {
            "code" : "32398004",
            "display" : "Bronchitis (disorder)"
          },
          {
            "code" : "32400000",
            "display" : "Preaxial (qualifier value)"
          },
          {
            "code" : "32402008",
            "display" : "Facial spasm (finding)"
          },
          {
            "code" : "32410009",
            "display" : "Pederasty (disorder)"
          },
          {
            "code" : "32413006",
            "display" : "Transplantation of heart (procedure)"
          },
          {
            "code" : "32422007",
            "display" : "Hemi-neglect (finding)"
          },
          {
            "code" : "32452004",
            "display" : "Hepatitis A virus (organism)"
          },
          {
            "code" : "32457005",
            "display" : "Body fluid (substance)"
          },
          {
            "code" : "32477003",
            "display" : "Heart-lung transplant with recipient cardiectomy-pneumonectomy (procedure)"
          },
          {
            "code" : "32482005",
            "display" : "Orthostatic proteinuria (finding)"
          },
          {
            "code" : "32485007",
            "display" : "Hospital admission (procedure)"
          },
          {
            "code" : "32488009",
            "display" : "Salmonella Paratyphi C (organism)"
          },
          {
            "code" : "32505007",
            "display" : "Phosphorus-32 (substance)"
          },
          {
            "code" : "32513008",
            "display" : "Dyaks (ethnic group)"
          },
          {
            "code" : "32553006",
            "display" : "Hangover (finding)"
          },
          {
            "code" : "32591006",
            "display" : "Kerry blue terrier (organism)"
          },
          {
            "code" : "32595002",
            "display" : "Mononeuritis (disorder)"
          },
          {
            "code" : "32620007",
            "display" : "Pulpitis (disorder)"
          },
          {
            "code" : "32622004",
            "display" : "Descending colon structure (body structure)"
          },
          {
            "code" : "32651000",
            "display" : "Arteriolosclerosis with fibrinoid necrosis (morphologic abnormality)"
          },
          {
            "code" : "32670005",
            "display" : "Great Pyrenee dog (organism)"
          },
          {
            "code" : "32671009",
            "display" : "Hyperlipoproteinemia diet, type IIa (finding)"
          },
          {
            "code" : "32672002",
            "display" : "Structure of descending thoracic aorta (body structure)"
          },
          {
            "code" : "32683006",
            "display" : "FHC elite pig 7 (organism)"
          },
          {
            "code" : "32691002",
            "display" : "Rickettsia conorii (organism)"
          },
          {
            "code" : "32713005",
            "display" : "Cecum structure (body structure)"
          },
          {
            "code" : "32721004",
            "display" : "Bulimia nervosa, purging type (disorder)"
          },
          {
            "code" : "32750006",
            "display" : "Inspection (procedure)"
          },
          {
            "code" : "32758004",
            "display" : "Right bundle branch block with left bundle branch block (disorder)"
          },
          {
            "code" : "32764006",
            "display" : "Portal vein structure (body structure)"
          },
          {
            "code" : "32798002",
            "display" : "Parkinsonism (disorder)"
          },
          {
            "code" : "32805004",
            "display" : "Fractures of multiple bones of lower limb (disorder)"
          },
          {
            "code" : "32829006",
            "display" : "Clostridium botulinum, type F (organism)"
          },
          {
            "code" : "32836007",
            "display" : "Sodium acetrizoate (substance)"
          },
          {
            "code" : "32849002",
            "display" : "Esophageal structure (body structure)"
          },
          {
            "code" : "32858009",
            "display" : "Hemolytic disease of fetus OR newborn due to ABO immunization (disorder)"
          },
          {
            "code" : "32859001",
            "display" : "Structure of inferior mesenteric vein (body structure)"
          },
          {
            "code" : "32861005",
            "display" : "Erythema nodosum (disorder)"
          },
          {
            "code" : "32864002",
            "display" : "Senility (observable entity)"
          },
          {
            "code" : "32873005",
            "display" : "Bloods (ethnic group)"
          },
          {
            "code" : "32911000",
            "display" : "Homeless (finding)"
          },
          {
            "code" : "32913002",
            "display" : "Medullary carcinoma (morphologic abnormality)"
          },
          {
            "code" : "32914008",
            "display" : "Restless legs (disorder)"
          },
          {
            "code" : "32916005",
            "display" : "Nephrosclerosis (disorder)"
          },
          {
            "code" : "32919003",
            "display" : "Fusion with defective stereopsis (disorder)"
          },
          {
            "code" : "32938007",
            "display" : "Gir cattle breed (organism)"
          },
          {
            "code" : "32968003",
            "display" : "Inflammatory carcinoma (morphologic abnormality)"
          },
          {
            "code" : "32976001",
            "display" : "Open wound of leg with complication (disorder)"
          },
          {
            "code" : "32984002",
            "display" : "Neonatal polycythemia (disorder)"
          },
          {
            "code" : "33008008",
            "display" : "Dust (substance)"
          },
          {
            "code" : "33010005",
            "display" : "Floppy infant syndrome (disorder)"
          },
          {
            "code" : "33013007",
            "display" : "Gleason grade score 8 out of 10 (finding)"
          },
          {
            "code" : "33022008",
            "display" : "Hospital-based outpatient department (environment)"
          },
          {
            "code" : "33036003",
            "display" : "Fall on same level (event)"
          },
          {
            "code" : "33048000",
            "display" : "Peripheral visual field defect (finding)"
          },
          {
            "code" : "33050008",
            "display" : "Pulmonary resuscitation (procedure)"
          },
          {
            "code" : "33060004",
            "display" : "Cerebellar white matter structure (body structure)"
          },
          {
            "code" : "33084007",
            "display" : "Personal identity confusion (finding)"
          },
          {
            "code" : "33096000",
            "display" : "Vertical (qualifier value)"
          },
          {
            "code" : "33118001",
            "display" : "Closed fracture of acetabulum (disorder)"
          },
          {
            "code" : "33129002",
            "display" : "Postmastectomy lymphedema syndrome (disorder)"
          },
          {
            "code" : "33135002",
            "display" : "Recurrent major depression in partial remission (disorder)"
          },
          {
            "code" : "33149006",
            "display" : "Pancreatectomy (procedure)"
          },
          {
            "code" : "33167004",
            "display" : "Complication of transplanted liver (disorder)"
          },
          {
            "code" : "33168009",
            "display" : "Entropion of eyelid (disorder)"
          },
          {
            "code" : "33173003",
            "display" : "Closed fracture of clavicle (disorder)"
          },
          {
            "code" : "33182009",
            "display" : "Trukese (ethnic group)"
          },
          {
            "code" : "33192001",
            "display" : "Closed fracture of lower end of radius AND ulna (disorder)"
          },
          {
            "code" : "33195004",
            "display" : "Teleradiotherapy procedure (procedure)"
          },
          {
            "code" : "33209009",
            "display" : "Idiopathic progressive polyneuropathy (disorder)"
          },
          {
            "code" : "33211000",
            "display" : "Complication of anesthesia (disorder)"
          },
          {
            "code" : "33212007",
            "display" : "Boar power pig 616 (organism)"
          },
          {
            "code" : "33252009",
            "display" : "Product containing beta adrenergic receptor antagonist (product)"
          },
          {
            "code" : "33261009",
            "display" : "Abscess of tonsil (disorder)"
          },
          {
            "code" : "33262002",
            "display" : "Osteoarthrosis involving multiple sites but not designated as generalized (disorder)"
          },
          {
            "code" : "33271006",
            "display" : "Iodohippurate (131-I) sodium (substance)"
          },
          {
            "code" : "33272004",
            "display" : "Structure of myocardium of posterolateral region (body structure)"
          },
          {
            "code" : "33300005",
            "display" : "Feeling powerless (finding)"
          },
          {
            "code" : "33325001",
            "display" : "Compensatory emphysema (disorder)"
          },
          {
            "code" : "33334006",
            "display" : "Foreign body in digestive tract (disorder)"
          },
          {
            "code" : "33339001",
            "display" : "Psoriasis with arthropathy (disorder)"
          },
          {
            "code" : "33367005",
            "display" : "Coronary angiography (procedure)"
          },
          {
            "code" : "33389009",
            "display" : "Transfusion of whole blood (procedure)"
          },
          {
            "code" : "33396006",
            "display" : "Nickel (substance)"
          },
          {
            "code" : "33401005",
            "display" : "Wirehaired pointing griffon dog (organism)"
          },
          {
            "code" : "33413000",
            "display" : "Ectopic beats (disorder)"
          },
          {
            "code" : "33439002",
            "display" : "Enthesopathy of wrist AND/OR carpus (disorder)"
          },
          {
            "code" : "33449004",
            "display" : "Personality disorder (disorder)"
          },
          {
            "code" : "33458006",
            "display" : "Bernese mountain dog (organism)"
          },
          {
            "code" : "33489005",
            "display" : "Renal disease diet (finding)"
          },
          {
            "code" : "33496007",
            "display" : "Reconstruction of breast (procedure)"
          },
          {
            "code" : "33528003",
            "display" : "Bullous myringitis (disorder)"
          },
          {
            "code" : "33551003",
            "display" : "Kentucky red berkshire pig (organism)"
          },
          {
            "code" : "33553000",
            "display" : "Widowed (finding)"
          },
          {
            "code" : "33559001",
            "display" : "Pineal hyperplasia AND diabetes mellitus syndrome (disorder)"
          },
          {
            "code" : "33564002",
            "display" : "Structure of lower outer quadrant of breast (body structure)"
          },
          {
            "code" : "33586001",
            "display" : "Sitting position (finding)"
          },
          {
            "code" : "33590004",
            "display" : "Weak mother-infant attachment (finding)"
          },
          {
            "code" : "33593002",
            "display" : "Vascular wall degeneration (morphologic abnormality)"
          },
          {
            "code" : "33595009",
            "display" : "Arachnoid cyst (disorder)"
          },
          {
            "code" : "33603003",
            "display" : "Complication of renal dialysis (disorder)"
          },
          {
            "code" : "33610009",
            "display" : "Attenuated Mycobacterium bovis (organism)"
          },
          {
            "code" : "33617007",
            "display" : "Oral penetration (finding)"
          },
          {
            "code" : "33626005",
            "display" : "Structure of left auricular appendage (body structure)"
          },
          {
            "code" : "33627001",
            "display" : "Prolonged first stage of labor (disorder)"
          },
          {
            "code" : "33629003",
            "display" : "Drusen of optic disc (finding)"
          },
          {
            "code" : "33633005",
            "display" : "Prescription of drug (procedure)"
          },
          {
            "code" : "33647009",
            "display" : "Anatomical narrow angle glaucoma (disorder)"
          },
          {
            "code" : "33653009",
            "display" : "Absence of sensation (finding)"
          },
          {
            "code" : "33655002",
            "display" : "Chronic cystitis (disorder)"
          },
          {
            "code" : "33659008",
            "display" : "Keloid scar (disorder)"
          },
          {
            "code" : "33669002",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class D (disorder)"
          },
          {
            "code" : "33687004",
            "display" : "Dietetic gastroenteritis (disorder)"
          },
          {
            "code" : "33688009",
            "display" : "Cholestasis (finding)"
          },
          {
            "code" : "33693007",
            "display" : "Compensation neurosis (disorder)"
          },
          {
            "code" : "33712006",
            "display" : "Skin structure of hand (body structure)"
          },
          {
            "code" : "33723005",
            "display" : "Structure of middle cerebellar peduncle (body structure)"
          },
          {
            "code" : "33737001",
            "display" : "Fracture of rib (disorder)"
          },
          {
            "code" : "33747003",
            "display" : "Glucose measurement, blood (procedure)"
          },
          {
            "code" : "33763006",
            "display" : "Hypercalcemic nephropathy (disorder)"
          },
          {
            "code" : "33770006",
            "display" : "Structure of lateral axillary lymph node (body structure)"
          },
          {
            "code" : "33785000",
            "display" : "Iodine (125-I) liothyronine (substance)"
          },
          {
            "code" : "33795007",
            "display" : "Structure of inferior mesenteric artery (body structure)"
          },
          {
            "code" : "33806008",
            "display" : "Endarteritis (disorder)"
          },
          {
            "code" : "33839006",
            "display" : "Genital herpes simplex (disorder)"
          },
          {
            "code" : "33843005",
            "display" : "Efferent (qualifier value)"
          },
          {
            "code" : "33861001",
            "display" : "Weight maintenance regimen (finding)"
          },
          {
            "code" : "33870003",
            "display" : "Cohabitatio lateralis (finding)"
          },
          {
            "code" : "33879002",
            "display" : "Administration of vaccine to produce active immunity (procedure)"
          },
          {
            "code" : "33889003",
            "display" : "Atypical lobular hyperplasia (morphologic abnormality)"
          },
          {
            "code" : "33890007",
            "display" : "Foreign body in nostril (disorder)"
          },
          {
            "code" : "33897005",
            "display" : "Chinese (ethnic group)"
          },
          {
            "code" : "33910007",
            "display" : "Postoperative infection (disorder)"
          },
          {
            "code" : "33927004",
            "display" : "Hypogonadotropic hypogonadism (disorder)"
          },
          {
            "code" : "33930006",
            "display" : "Structure of subarachnoid space of brain (body structure)"
          },
          {
            "code" : "33958003",
            "display" : "Disorder of penis (disorder)"
          },
          {
            "code" : "33995003",
            "display" : "Megacolon, not Hirschsprung's (disorder)"
          },
          {
            "code" : "34000006",
            "display" : "Crohn's disease (disorder)"
          },
          {
            "code" : "34014006",
            "display" : "Viral disease (disorder)"
          },
          {
            "code" : "34020007",
            "display" : "Pneumonia caused by Streptococcus (disorder)"
          },
          {
            "code" : "34026001",
            "display" : "Semiprone position (finding)"
          },
          {
            "code" : "34043003",
            "display" : "Dental consultation and report (procedure)"
          },
          {
            "code" : "34063005",
            "display" : "Homonymous hemianopia (finding)"
          },
          {
            "code" : "34068001",
            "display" : "Heart valve replacement (procedure)"
          },
          {
            "code" : "34095006",
            "display" : "Dehydration (disorder)"
          },
          {
            "code" : "34106002",
            "display" : "Trendelenburg position (finding)"
          },
          {
            "code" : "34108001",
            "display" : "Coiled position (finding)"
          },
          {
            "code" : "34116005",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in full remission AND severe panic attacks (disorder)"
          },
          {
            "code" : "34124000",
            "display" : "Foreign body in vagina (disorder)"
          },
          {
            "code" : "34127007",
            "display" : "Krypton-85 (substance)"
          },
          {
            "code" : "34128002",
            "display" : "Chrome azurol S stain (substance)"
          },
          {
            "code" : "34139004",
            "display" : "Intervertebral disc disorder of lumbar region with myelopathy (disorder)"
          },
          {
            "code" : "34165000",
            "display" : "Gestational proteinuria (disorder)"
          },
          {
            "code" : "34170007",
            "display" : "Adult diabetes diet (finding)"
          },
          {
            "code" : "34200004",
            "display" : "Standardbred horse (organism)"
          },
          {
            "code" : "34202007",
            "display" : "Aortic valve structure (body structure)"
          },
          {
            "code" : "34206005",
            "display" : "Subcutaneous route (qualifier value)"
          },
          {
            "code" : "34212000",
            "display" : "Colorado tick fever virus (organism)"
          },
          {
            "code" : "34227000",
            "display" : "Computerized axial tomography of brain (procedure)"
          },
          {
            "code" : "34250006",
            "display" : "Benign mucous membrane pemphigoid (disorder)"
          },
          {
            "code" : "34262005",
            "display" : "Fourth degree perineal laceration involving rectal mucosa (disorder)"
          },
          {
            "code" : "34268009",
            "display" : "Closed fracture of lateral malleolus (disorder)"
          },
          {
            "code" : "34296003",
            "display" : "Frog-like posture (finding)"
          },
          {
            "code" : "34318004",
            "display" : "Bone structure of proximal ulna (body structure)"
          },
          {
            "code" : "34319007",
            "display" : "Induration of skin (disorder)"
          },
          {
            "code" : "34334001",
            "display" : "New Caledonians (ethnic group)"
          },
          {
            "code" : "34340008",
            "display" : "Structure of venous network (body structure)"
          },
          {
            "code" : "34348001",
            "display" : "Dengue virus (organism)"
          },
          {
            "code" : "34360000",
            "display" : "Fibrous histiocytoma, malignant (morphologic abnormality)"
          },
          {
            "code" : "34361001",
            "display" : "Traumatic cataract (disorder)"
          },
          {
            "code" : "34363003",
            "display" : "Pruritus of vagina (disorder)"
          },
          {
            "code" : "34394003",
            "display" : "Hyperalimentation formula for burn hypermetabolism (finding)"
          },
          {
            "code" : "34402009",
            "display" : "Rectum structure (body structure)"
          },
          {
            "code" : "34411009",
            "display" : "Broad ligament structure (body structure)"
          },
          {
            "code" : "34420000",
            "display" : "Storage disease (disorder)"
          },
          {
            "code" : "34430009",
            "display" : "Rupture of uterus (disorder)"
          },
          {
            "code" : "34431008",
            "display" : "Physiotherapy of chest (regime/therapy)"
          },
          {
            "code" : "34436003",
            "display" : "Blood in urine (finding)"
          },
          {
            "code" : "34486009",
            "display" : "Hyperthyroidism (disorder)"
          },
          {
            "code" : "34516001",
            "display" : "Ileal structure (body structure)"
          },
          {
            "code" : "34517005",
            "display" : "Pharyngeal stop, function (observable entity)"
          },
          {
            "code" : "34536000",
            "display" : "Amniocentesis (procedure)"
          },
          {
            "code" : "34563004",
            "display" : "Fear of getting cancer (finding)"
          },
          {
            "code" : "34565006",
            "display" : "Closed anterior dislocation of humerus (disorder)"
          },
          {
            "code" : "34571000",
            "display" : "Anovulation (finding)"
          },
          {
            "code" : "34580000",
            "display" : "Duodenal ulcer without hemorrhage, without perforation AND without obstruction (disorder)"
          },
          {
            "code" : "34595003",
            "display" : "Boar power pig 828 (organism)"
          },
          {
            "code" : "34615008",
            "display" : "Hemospermia (finding)"
          },
          {
            "code" : "34618005",
            "display" : "Bos taurus (organism)"
          },
          {
            "code" : "34624004",
            "display" : "Pulse deficit (finding)"
          },
          {
            "code" : "34625003",
            "display" : "Structure of medial common iliac lymph node (body structure)"
          },
          {
            "code" : "34630004",
            "display" : "Pityriasis (disorder)"
          },
          {
            "code" : "34631000",
            "display" : "Administration of vaccine product containing only Rabies lyssavirus antigen (procedure)"
          },
          {
            "code" : "34635009",
            "display" : "Structure of lumbar artery (body structure)"
          },
          {
            "code" : "34649000",
            "display" : "Closed fracture of malar AND/OR maxillary bones (disorder)"
          },
          {
            "code" : "34652008",
            "display" : "Xenophobia (finding)"
          },
          {
            "code" : "34694006",
            "display" : "Pre-existing hypertension complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "34700000",
            "display" : "Fast blue B salt stain (substance)"
          },
          {
            "code" : "34706006",
            "display" : "Plasmodium (organism)"
          },
          {
            "code" : "34707002",
            "display" : "Biliary tract structure (body structure)"
          },
          {
            "code" : "34711008",
            "display" : "Traction detachment of retina (disorder)"
          },
          {
            "code" : "34713006",
            "display" : "Vitamin D deficiency (disorder)"
          },
          {
            "code" : "34730008",
            "display" : "Primate erythroparvovirus 1 infection (disorder)"
          },
          {
            "code" : "34742003",
            "display" : "Portal hypertension (disorder)"
          },
          {
            "code" : "34752004",
            "display" : "Sealyham terrier (organism)"
          },
          {
            "code" : "34759008",
            "display" : "Urethral catheter, device (physical object)"
          },
          {
            "code" : "34763001",
            "display" : "Potassium hydroxide (substance)"
          },
          {
            "code" : "34775006",
            "display" : "Structure of cubital lymph node (body structure)"
          },
          {
            "code" : "34781003",
            "display" : "Vertebral artery syndrome (disorder)"
          },
          {
            "code" : "34789001",
            "display" : "Pain in the coccyx (finding)"
          },
          {
            "code" : "34801009",
            "display" : "Ectopic pregnancy (disorder)"
          },
          {
            "code" : "34818008",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class B (disorder)"
          },
          {
            "code" : "34840004",
            "display" : "Tendinitis (disorder)"
          },
          {
            "code" : "34842007",
            "display" : "Antepartum hemorrhage (disorder)"
          },
          {
            "code" : "34870009",
            "display" : "Irish water spaniel (organism)"
          },
          {
            "code" : "34872001",
            "display" : "Genus Vibrio (organism)"
          },
          {
            "code" : "34879005",
            "display" : "Automanipulatory vulvoclitoral habituation (finding)"
          },
          {
            "code" : "34882000",
            "display" : "Giant fibroadenoma (morphologic abnormality)"
          },
          {
            "code" : "34926004",
            "display" : "Skin of submental area (body structure)"
          },
          {
            "code" : "34936007",
            "display" : "Chronic dermatitis (disorder)"
          },
          {
            "code" : "34938008",
            "display" : "Alcohol-induced anxiety disorder (disorder)"
          },
          {
            "code" : "34969007",
            "display" : "Operation on retroperitoneum (procedure)"
          },
          {
            "code" : "35007000",
            "display" : "Utes (ethnic group)"
          },
          {
            "code" : "35025007",
            "display" : "Manual pelvic examination (procedure)"
          },
          {
            "code" : "35029001",
            "display" : "Babesia (organism)"
          },
          {
            "code" : "35039007",
            "display" : "Uterine structure (body structure)"
          },
          {
            "code" : "35046003",
            "display" : "Disorder of lactation (disorder)"
          },
          {
            "code" : "35055000",
            "display" : "Band-shaped keratopathy (disorder)"
          },
          {
            "code" : "35064005",
            "display" : "Dark stools (finding)"
          },
          {
            "code" : "35065006",
            "display" : "Primary chronic pseudo-obstruction of colon (disorder)"
          },
          {
            "code" : "35089004",
            "display" : "Urogenital infection caused by Trichomonas vaginalis (disorder)"
          },
          {
            "code" : "35094004",
            "display" : "Tropaeolin O stain (substance)"
          },
          {
            "code" : "35105006",
            "display" : "Increased (qualifier value)"
          },
          {
            "code" : "35183001",
            "display" : "Acute transudative otitis media (disorder)"
          },
          {
            "code" : "35185008",
            "display" : "Enthesopathy of elbow region (disorder)"
          },
          {
            "code" : "35195001",
            "display" : "Frostbite of foot (disorder)"
          },
          {
            "code" : "35202002",
            "display" : "Scanning or imaging with vascular flow (procedure)"
          },
          {
            "code" : "35222003",
            "display" : "Chronic neurogenic ulcer of lower limb (disorder)"
          },
          {
            "code" : "35229007",
            "display" : "Chianina cattle breed (organism)"
          },
          {
            "code" : "35240004",
            "display" : "Iron deficiency (disorder)"
          },
          {
            "code" : "35252006",
            "display" : "Disorganized schizophrenia (disorder)"
          },
          {
            "code" : "35253001",
            "display" : "Attention deficit hyperactivity disorder, predominantly inattentive type (disorder)"
          },
          {
            "code" : "35259002",
            "display" : "Structure of deltoid muscle (body structure)"
          },
          {
            "code" : "35265002",
            "display" : "Mallory-Weiss syndrome (disorder)"
          },
          {
            "code" : "35298007",
            "display" : "Slow transit constipation (disorder)"
          },
          {
            "code" : "35303009",
            "display" : "Benign essential hypertension complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "35304003",
            "display" : "Cardiac tamponade (disorder)"
          },
          {
            "code" : "35321007",
            "display" : "Fluorodeoxyglucose (18-F) (substance)"
          },
          {
            "code" : "35332007",
            "display" : "Formation of vowels, function (observable entity)"
          },
          {
            "code" : "35337001",
            "display" : "Gallium-68 (substance)"
          },
          {
            "code" : "35347003",
            "display" : "Delayed delivery after artificial rupture of membranes (disorder)"
          },
          {
            "code" : "35350000",
            "display" : "Implantation of aortic valve prosthesis or synthetic device (procedure)"
          },
          {
            "code" : "35352008",
            "display" : "Fluorescent stain (substance)"
          },
          {
            "code" : "35354009",
            "display" : "Equus caballus (organism)"
          },
          {
            "code" : "35360009",
            "display" : "Isometric physical exercise (observable entity)"
          },
          {
            "code" : "35363006",
            "display" : "Infantile colic (finding)"
          },
          {
            "code" : "35408001",
            "display" : "Genus Campylobacter (organism)"
          },
          {
            "code" : "35425004",
            "display" : "Normal body mass index (finding)"
          },
          {
            "code" : "35429005",
            "display" : "Anticipatory anxiety (finding)"
          },
          {
            "code" : "35439004",
            "display" : "Seoul virus (organism)"
          },
          {
            "code" : "35459000",
            "display" : "Autopsy, gross examination, stillborn or newborn (procedure)"
          },
          {
            "code" : "35468003",
            "display" : "Crushed in between objects (event)"
          },
          {
            "code" : "35481005",
            "display" : "Mixed bipolar I disorder in remission (disorder)"
          },
          {
            "code" : "35486000",
            "display" : "Subdural intracranial hemorrhage (disorder)"
          },
          {
            "code" : "35489007",
            "display" : "Depressive disorder (disorder)"
          },
          {
            "code" : "35491004",
            "display" : "Maladjustment to married life (finding)"
          },
          {
            "code" : "35497000",
            "display" : "Restraint maintenance (procedure)"
          },
          {
            "code" : "35498005",
            "display" : "Stasis dermatitis (disorder)"
          },
          {
            "code" : "35532006",
            "display" : "Vena caval structure (body structure)"
          },
          {
            "code" : "35546006",
            "display" : "Mesangial proliferative glomerulonephritis (disorder)"
          },
          {
            "code" : "35547002",
            "display" : "Polyotia (disorder)"
          },
          {
            "code" : "35566002",
            "display" : "Hematoma (morphologic abnormality)"
          },
          {
            "code" : "35600002",
            "display" : "Strabismic amblyopia (disorder)"
          },
          {
            "code" : "35601003",
            "display" : "Monoclonal gammopathy of undetermined significance (morphologic abnormality)"
          },
          {
            "code" : "35607004",
            "display" : "Panic disorder with agoraphobia (disorder)"
          },
          {
            "code" : "35609001",
            "display" : "Azophloxin stain (substance)"
          },
          {
            "code" : "35621002",
            "display" : "Cardiac blood pool imaging (procedure)"
          },
          {
            "code" : "35625006",
            "display" : "Keratosis of middle ear (disorder)"
          },
          {
            "code" : "35637008",
            "display" : "Alcohol rehabilitation (regime/therapy)"
          },
          {
            "code" : "35646002",
            "display" : "Excision of lesion of skin (procedure)"
          },
          {
            "code" : "35664009",
            "display" : "Structure of inferior fronto-occipital fasciculus (body structure)"
          },
          {
            "code" : "35678005",
            "display" : "Multiple joint pain (finding)"
          },
          {
            "code" : "35688006",
            "display" : "Complication of medical care (disorder)"
          },
          {
            "code" : "35721009",
            "display" : "Structure of deep popliteal lymph node (body structure)"
          },
          {
            "code" : "35724001",
            "display" : "Lacmoid stain (substance)"
          },
          {
            "code" : "35726004",
            "display" : "Sprain of lateral collateral ligament of knee (disorder)"
          },
          {
            "code" : "35728003",
            "display" : "Familial cardiomyopathy (disorder)"
          },
          {
            "code" : "35739000",
            "display" : "Skin structure of lateral border of sole of foot (body structure)"
          },
          {
            "code" : "35742006",
            "display" : "Congenital syphilis (disorder)"
          },
          {
            "code" : "35745008",
            "display" : "Umbilical discharge (finding)"
          },
          {
            "code" : "35757004",
            "display" : "Echocardiography for determining ventricular contraction (procedure)"
          },
          {
            "code" : "35759001",
            "display" : "Ribose-phosphate pyrophosphokinase overactivity (disorder)"
          },
          {
            "code" : "35764002",
            "display" : "Brain ventricle structure (body structure)"
          },
          {
            "code" : "35783009",
            "display" : "Structure of aortic lymph node (body structure)"
          },
          {
            "code" : "35802007",
            "display" : "Fox terrier superbreed (organism)"
          },
          {
            "code" : "35819009",
            "display" : "Structure of splenic vein (body structure)"
          },
          {
            "code" : "35860002",
            "display" : "Repair by nailing (procedure)"
          },
          {
            "code" : "35868009",
            "display" : "Carcinoid syndrome (disorder)"
          },
          {
            "code" : "35874009",
            "display" : "Normal labor (finding)"
          },
          {
            "code" : "35884005",
            "display" : "Povidone iodine (131-I) (substance)"
          },
          {
            "code" : "35885006",
            "display" : "Hyperuricemia (disorder)"
          },
          {
            "code" : "35900000",
            "display" : "Skin of penis (body structure)"
          },
          {
            "code" : "35908007",
            "display" : "Chronic arthritis (disorder)"
          },
          {
            "code" : "35917007",
            "display" : "Adenocarcinoma, no subtype (morphologic abnormality)"
          },
          {
            "code" : "35918002",
            "display" : "Fourth ventricle structure (body structure)"
          },
          {
            "code" : "35919005",
            "display" : "Pervasive developmental disorder (disorder)"
          },
          {
            "code" : "35923002",
            "display" : "Chronic maxillary sinusitis (disorder)"
          },
          {
            "code" : "35951006",
            "display" : "Subarachnoid space structure (body structure)"
          },
          {
            "code" : "35963001",
            "display" : "Removal of staples (procedure)"
          },
          {
            "code" : "35971002",
            "display" : "Ambulatory care site (environment)"
          },
          {
            "code" : "35978008",
            "display" : "Californium-252 (substance)"
          },
          {
            "code" : "35984006",
            "display" : "Tuberculosis of vertebral column (disorder)"
          },
          {
            "code" : "35999006",
            "display" : "Blighted ovum (disorder)"
          },
          {
            "code" : "36046008",
            "display" : "Ischiorectal abscess (disorder)"
          },
          {
            "code" : "36060005",
            "display" : "Hemangiopericytoma (morphologic abnormality)"
          },
          {
            "code" : "36071006",
            "display" : "Chondromalacia of patella (disorder)"
          },
          {
            "code" : "36074003",
            "display" : "Abyssinian cat (organism)"
          },
          {
            "code" : "36083008",
            "display" : "Sick sinus syndrome (disorder)"
          },
          {
            "code" : "36086000",
            "display" : "Structure of obturator lymph node (body structure)"
          },
          {
            "code" : "36094007",
            "display" : "Listeria monocytogenes (organism)"
          },
          {
            "code" : "36111002",
            "display" : "Kleen leen black pig (organism)"
          },
          {
            "code" : "36115006",
            "display" : "Human immunodeficiency virus type 2 (organism)"
          },
          {
            "code" : "36118008",
            "display" : "Pneumothorax (disorder)"
          },
          {
            "code" : "36141000",
            "display" : "Skin structure of cheek (body structure)"
          },
          {
            "code" : "36152006",
            "display" : "Structure of mucous membrane of floor of mouth (body structure)"
          },
          {
            "code" : "36169008",
            "display" : "Insular structure (body structure)"
          },
          {
            "code" : "36171008",
            "display" : "Glomerulonephritis (disorder)"
          },
          {
            "code" : "36176003",
            "display" : "Thrombin (substance)"
          },
          {
            "code" : "36179005",
            "display" : "Reversible ischemic neurologic deficit syndrome (disorder)"
          },
          {
            "code" : "36184004",
            "display" : "Aneurysm of renal artery (disorder)"
          },
          {
            "code" : "36186002",
            "display" : "Polyarthropathy (disorder)"
          },
          {
            "code" : "36187006",
            "display" : "Spotted pig (organism)"
          },
          {
            "code" : "36188001",
            "display" : "Shigellosis (disorder)"
          },
          {
            "code" : "36191001",
            "display" : "Perforation (morphologic abnormality)"
          },
          {
            "code" : "36202009",
            "display" : "Fracture of tooth (disorder)"
          },
          {
            "code" : "36209000",
            "display" : "Chloasma (disorder)"
          },
          {
            "code" : "36222008",
            "display" : "Carcinoid heart disease (disorder)"
          },
          {
            "code" : "36225005",
            "display" : "Acute renal failure due to procedure (disorder)"
          },
          {
            "code" : "36228007",
            "display" : "Ophthalmic examination and evaluation (procedure)"
          },
          {
            "code" : "36241006",
            "display" : "Non-toxic multinodular goiter (disorder)"
          },
          {
            "code" : "36249008",
            "display" : "Mycobacterium komossence (organism)"
          },
          {
            "code" : "36251007",
            "display" : "Structure of intestinal lymph node (body structure)"
          },
          {
            "code" : "36262007",
            "display" : "Pygmalionism (disorder)"
          },
          {
            "code" : "36265009",
            "display" : "Poisoning caused by local anti-inflammatory drug (disorder)"
          },
          {
            "code" : "36274006",
            "display" : "Wirehaired standard dachshund (organism)"
          },
          {
            "code" : "36276008",
            "display" : "Syphilitic retrobulbar neuritis (disorder)"
          },
          {
            "code" : "36329002",
            "display" : "Slovak (ethnic group)"
          },
          {
            "code" : "36348003",
            "display" : "Primary hyperparathyroidism (disorder)"
          },
          {
            "code" : "36349006",
            "display" : "Burning pain (finding)"
          },
          {
            "code" : "36354002",
            "display" : "Mycobacterium tuberculosis hominis (organism)"
          },
          {
            "code" : "36360002",
            "display" : "Floor of mouth structure (body structure)"
          },
          {
            "code" : "36371001",
            "display" : "Structure of left sinus of Valsalva (body structure)"
          },
          {
            "code" : "36386007",
            "display" : "Overt sexual harassment by male (finding)"
          },
          {
            "code" : "36427004",
            "display" : "Intervertebral disc disorder (disorder)"
          },
          {
            "code" : "36438004",
            "display" : "Lhasa apso (organism)"
          },
          {
            "code" : "36440009",
            "display" : "Failure to gain weight (finding)"
          },
          {
            "code" : "36455000",
            "display" : "Metacarpal bone structure (body structure)"
          },
          {
            "code" : "36474008",
            "display" : "Severe recurrent major depression without psychotic features (disorder)"
          },
          {
            "code" : "36485005",
            "display" : "Restrictive lung disease (disorder)"
          },
          {
            "code" : "36492000",
            "display" : "Structure of permanent maxillary right second premolar tooth (body structure)"
          },
          {
            "code" : "36547009",
            "display" : "Right occipitoposterior position (finding)"
          },
          {
            "code" : "36570001",
            "display" : "Dekalb hybrid pig line 31 (organism)"
          },
          {
            "code" : "36571002",
            "display" : "Oryctolagus cuniculus (organism)"
          },
          {
            "code" : "36572009",
            "display" : "Sudan black B stain (substance)"
          },
          {
            "code" : "36582005",
            "display" : "Brachial plexus structure (body structure)"
          },
          {
            "code" : "36583000",
            "display" : "Mixed bipolar I disorder in partial remission (disorder)"
          },
          {
            "code" : "36611001",
            "display" : "Long coat chihuahua (organism)"
          },
          {
            "code" : "36631002",
            "display" : "Hepatomphalocele (disorder)"
          },
          {
            "code" : "36641004",
            "display" : "Potassium (K-42) chloride (substance)"
          },
          {
            "code" : "36646009",
            "display" : "Anticipatory anxiety, moderate (finding)"
          },
          {
            "code" : "36653000",
            "display" : "Rubella (disorder)"
          },
          {
            "code" : "36656008",
            "display" : "Beriberi (disorder)"
          },
          {
            "code" : "36672000",
            "display" : "Structure of distal portion of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "36689008",
            "display" : "Acute pyelonephritis (disorder)"
          },
          {
            "code" : "36700002",
            "display" : "Dengue virus, type 4 (organism)"
          },
          {
            "code" : "36715001",
            "display" : "Erythema multiforme (disorder)"
          },
          {
            "code" : "36755004",
            "display" : "Talipes cavus (disorder)"
          },
          {
            "code" : "36758002",
            "display" : "Late effect of fracture of lower extremities (disorder)"
          },
          {
            "code" : "36760000",
            "display" : "Hepatosplenomegaly (disorder)"
          },
          {
            "code" : "36764009",
            "display" : "Vibrio cincinnatiensis (organism)"
          },
          {
            "code" : "36765005",
            "display" : "Structure of subclavian artery (body structure)"
          },
          {
            "code" : "36778005",
            "display" : "Fracture of distal phalanx of finger (disorder)"
          },
          {
            "code" : "36787001",
            "display" : "Contusion of trunk (disorder)"
          },
          {
            "code" : "36813001",
            "display" : "Placenta previa (disorder)"
          },
          {
            "code" : "36823005",
            "display" : "Normal diet (finding)"
          },
          {
            "code" : "36833002",
            "display" : "Rotavirus group G (organism)"
          },
          {
            "code" : "36855005",
            "display" : "Canis lupus (organism)"
          },
          {
            "code" : "36857002",
            "display" : "Onychia of finger (disorder)"
          },
          {
            "code" : "36879007",
            "display" : "Water soluble eosin stain (substance)"
          },
          {
            "code" : "36900006",
            "display" : "Sodium Iodohippurate (125-I) (substance)"
          },
          {
            "code" : "36923009",
            "display" : "Major depression, single episode (disorder)"
          },
          {
            "code" : "36924003",
            "display" : "Closed fracture of metatarsal bone (disorder)"
          },
          {
            "code" : "36948007",
            "display" : "Fasciitis (disorder)"
          },
          {
            "code" : "36955009",
            "display" : "Loss of taste (finding)"
          },
          {
            "code" : "36969009",
            "display" : "Placement of stent in coronary artery (procedure)"
          },
          {
            "code" : "36971009",
            "display" : "Sinusitis (disorder)"
          },
          {
            "code" : "36976004",
            "display" : "Hypoparathyroidism (disorder)"
          },
          {
            "code" : "36989005",
            "display" : "Mumps (disorder)"
          },
          {
            "code" : "36994005",
            "display" : "Transient visual loss (disorder)"
          },
          {
            "code" : "36995006",
            "display" : "Drainage of external ear (procedure)"
          },
          {
            "code" : "37017009",
            "display" : "Helminth (navigational concept)"
          },
          {
            "code" : "37024005",
            "display" : "Welsh corgi superbreed (organism)"
          },
          {
            "code" : "37031009",
            "display" : "Motion sickness (finding)"
          },
          {
            "code" : "37035000",
            "display" : "Structure of cerebral cingulum (body structure)"
          },
          {
            "code" : "37040008",
            "display" : "Right occipitolateral position (finding)"
          },
          {
            "code" : "37042000",
            "display" : "Guttate psoriasis (disorder)"
          },
          {
            "code" : "37058002",
            "display" : "Foreign body giant cell granuloma (morphologic abnormality)"
          },
          {
            "code" : "37064009",
            "display" : "Hyperproteinemia (disorder)"
          },
          {
            "code" : "37081000",
            "display" : "Clostridium botulinum, type D (organism)"
          },
          {
            "code" : "37083002",
            "display" : "Male hypererotism (finding)"
          },
          {
            "code" : "37098000",
            "display" : "Cellulitis of external nose (disorder)"
          },
          {
            "code" : "37102008",
            "display" : "Disorder of endocrine ovary (disorder)"
          },
          {
            "code" : "37108007",
            "display" : "Skin structure of nasolabial fold (body structure)"
          },
          {
            "code" : "37116003",
            "display" : "Belgian malinois dog (organism)"
          },
          {
            "code" : "37117007",
            "display" : "Right inguinal region structure (body structure)"
          },
          {
            "code" : "37146000",
            "display" : "Typhus vaccine (medicinal product)"
          },
          {
            "code" : "37151006",
            "display" : "Erythromelalgia (disorder)"
          },
          {
            "code" : "37153009",
            "display" : "Implantation of heart valve with tissue graft (procedure)"
          },
          {
            "code" : "37155002",
            "display" : "Glaucoma associated with ocular inflammation (disorder)"
          },
          {
            "code" : "37161004",
            "display" : "Rectal route (qualifier value)"
          },
          {
            "code" : "37197008",
            "display" : "Anterolateral (qualifier value)"
          },
          {
            "code" : "37214009",
            "display" : "Alternating exotropia (disorder)"
          },
          {
            "code" : "37216006",
            "display" : "Career frustration (finding)"
          },
          {
            "code" : "37220005",
            "display" : "Histoplasma duboisii (organism)"
          },
          {
            "code" : "37225000",
            "display" : "Manganese-52 (substance)"
          },
          {
            "code" : "37231002",
            "display" : "Macular retinal edema (disorder)"
          },
          {
            "code" : "37235006",
            "display" : "Occipitoposterior position (finding)"
          },
          {
            "code" : "37236007",
            "display" : "Dermabrasion (procedure)"
          },
          {
            "code" : "37240003",
            "display" : "Ineffective family coping: compromised (finding)"
          },
          {
            "code" : "37274004",
            "display" : "Structure of gastroduodenal artery (body structure)"
          },
          {
            "code" : "37279009",
            "display" : "Amyloid tumor (morphologic abnormality)"
          },
          {
            "code" : "37285002",
            "display" : "Bone structure of manubrium (body structure)"
          },
          {
            "code" : "37320007",
            "display" : "Acquired absence of teeth (disorder)"
          },
          {
            "code" : "37323009",
            "display" : "Recurrent herpes simplex (disorder)"
          },
          {
            "code" : "37340000",
            "display" : "Motor neuron disease (disorder)"
          },
          {
            "code" : "37344009",
            "display" : "Cannabis abuse (disorder)"
          },
          {
            "code" : "37372002",
            "display" : "Upper gastrointestinal hemorrhage (disorder)"
          },
          {
            "code" : "37373007",
            "display" : "Meckel's diverticulum (disorder)"
          },
          {
            "code" : "37383006",
            "display" : "Exposure to attack by mammal (event)"
          },
          {
            "code" : "37384000",
            "display" : "Birth injury to scalp (disorder)"
          },
          {
            "code" : "37389005",
            "display" : "Biliary colic (finding)"
          },
          {
            "code" : "37396007",
            "display" : "Furuncle of face (disorder)"
          },
          {
            "code" : "37430004",
            "display" : "Syphilis of synovium (disorder)"
          },
          {
            "code" : "37450000",
            "display" : "Corneal foreign body (disorder)"
          },
          {
            "code" : "37453003",
            "display" : "Setter (organism)"
          },
          {
            "code" : "37471005",
            "display" : "Extrinsic allergic alveolitis (disorder)"
          },
          {
            "code" : "37474002",
            "display" : "Ghanaians (ethnic group)"
          },
          {
            "code" : "37497004",
            "display" : "Enteric hyperoxaluria (disorder)"
          },
          {
            "code" : "37508003",
            "display" : "Operation on neck (procedure)"
          },
          {
            "code" : "37512009",
            "display" : "Neurohypophysis structure (body structure)"
          },
          {
            "code" : "37573006",
            "display" : "Bland diet, stage 2 (finding)"
          },
          {
            "code" : "37575004",
            "display" : "Carmoisine A stain (substance)"
          },
          {
            "code" : "37605006",
            "display" : "Senile osteopenia (disorder)"
          },
          {
            "code" : "37606007",
            "display" : "Parental nudity (finding)"
          },
          {
            "code" : "37610005",
            "display" : "Inflammation of cervix (disorder)"
          },
          {
            "code" : "37618003",
            "display" : "Chronic hypertension complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "37657006",
            "display" : "Disorder of esophagus (disorder)"
          },
          {
            "code" : "37671003",
            "display" : "Skin structure of lateral canthus (body structure)"
          },
          {
            "code" : "37706002",
            "display" : "Hypokinesis of cardiac wall (finding)"
          },
          {
            "code" : "37737002",
            "display" : "Intraluminal route (qualifier value)"
          },
          {
            "code" : "37739004",
            "display" : "Mood disorder due to a general medical condition (disorder)"
          },
          {
            "code" : "37743000",
            "display" : "History and physical examination, monitoring (regime/therapy)"
          },
          {
            "code" : "37746008",
            "display" : "Avoidant personality disorder (disorder)"
          },
          {
            "code" : "37754005",
            "display" : "Asymptomatic neurosyphilis (disorder)"
          },
          {
            "code" : "37760005",
            "display" : "Left anterior fascicular block (disorder)"
          },
          {
            "code" : "37777005",
            "display" : "Female juvenile homoerotism (finding)"
          },
          {
            "code" : "37783008",
            "display" : "Bone structure of acetabulum (body structure)"
          },
          {
            "code" : "37785001",
            "display" : "Patellar tendonitis (disorder)"
          },
          {
            "code" : "37796009",
            "display" : "Migraine (disorder)"
          },
          {
            "code" : "37799002",
            "display" : "Urinary bladder training (regime/therapy)"
          },
          {
            "code" : "37824006",
            "display" : "Basic hospital diet (finding)"
          },
          {
            "code" : "37843006",
            "display" : "Fulani (ethnic group)"
          },
          {
            "code" : "37849005",
            "display" : "Congenital uterine anomaly (disorder)"
          },
          {
            "code" : "37868008",
            "display" : "Anxiety disorder of adolescence (disorder)"
          },
          {
            "code" : "37869000",
            "display" : "Chilblains (disorder)"
          },
          {
            "code" : "37871000",
            "display" : "Acute hepatitis (disorder)"
          },
          {
            "code" : "37872007",
            "display" : "Avoidant disorder of childhood OR adolescence (disorder)"
          },
          {
            "code" : "37895003",
            "display" : "Osteoarthrosis of the carpometacarpal joint of the thumb (disorder)"
          },
          {
            "code" : "37899009",
            "display" : "Hypoglossal nerve structure (body structure)"
          },
          {
            "code" : "37900004",
            "display" : "Trichinella (organism)"
          },
          {
            "code" : "37907001",
            "display" : "Contusion of abdominal wall (disorder)"
          },
          {
            "code" : "37926009",
            "display" : "Microbial stain method (procedure)"
          },
          {
            "code" : "37941009",
            "display" : "Rumination disorder (disorder)"
          },
          {
            "code" : "37992001",
            "display" : "Pancreatic insufficiency (disorder)"
          },
          {
            "code" : "38000004",
            "display" : "Lymph (substance)"
          },
          {
            "code" : "38004008",
            "display" : "Enterococcus mundtii (organism)"
          },
          {
            "code" : "38048003",
            "display" : "Uncle (person)"
          },
          {
            "code" : "38049006",
            "display" : "Incomplete breech presentation (finding)"
          },
          {
            "code" : "38063000",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class C (disorder)"
          },
          {
            "code" : "38086007",
            "display" : "Laryngomalacia (disorder)"
          },
          {
            "code" : "38101003",
            "display" : "Hypermetropia (disorder)"
          },
          {
            "code" : "38102005",
            "display" : "Cholecystectomy (procedure)"
          },
          {
            "code" : "38106008",
            "display" : "Crohn's disease of ileum (disorder)"
          },
          {
            "code" : "38144004",
            "display" : "Athabascans (ethnic group)"
          },
          {
            "code" : "38151008",
            "display" : "Magnesium measurement (procedure)"
          },
          {
            "code" : "38160000",
            "display" : "Abnormal voice (finding)"
          },
          {
            "code" : "38184008",
            "display" : "Bulldog (organism)"
          },
          {
            "code" : "38199008",
            "display" : "Tooth structure (body structure)"
          },
          {
            "code" : "38214006",
            "display" : "Internal hemorrhoids without complication (disorder)"
          },
          {
            "code" : "38217004",
            "display" : "Cellulitis of upper arm (disorder)"
          },
          {
            "code" : "38226001",
            "display" : "Bland diet (finding)"
          },
          {
            "code" : "38239002",
            "display" : "Intraperitoneal route (qualifier value)"
          },
          {
            "code" : "38242008",
            "display" : "Male internal genitalia structure (body structure)"
          },
          {
            "code" : "38258006",
            "display" : "Hyperalimentation formula for inflammatory bowel disease (finding)"
          },
          {
            "code" : "38266002",
            "display" : "Entire body as a whole (body structure)"
          },
          {
            "code" : "38271009",
            "display" : "Saffron stain (substance)"
          },
          {
            "code" : "38280009",
            "display" : "Hematometra (disorder)"
          },
          {
            "code" : "38285004",
            "display" : "Irregular alveolar process (disorder)"
          },
          {
            "code" : "38322001",
            "display" : "Legionella parisiensis (organism)"
          },
          {
            "code" : "38324000",
            "display" : "Entamoeba (organism)"
          },
          {
            "code" : "38328002",
            "display" : "Panic disorder with agoraphobia, severe agoraphobic avoidance AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "38341003",
            "display" : "Hypertensive disorder, systemic arterial (disorder)"
          },
          {
            "code" : "38342005",
            "display" : "Toxic effect of lead compound (disorder)"
          },
          {
            "code" : "38343000",
            "display" : "Vaginal pain (finding)"
          },
          {
            "code" : "38344006",
            "display" : "Sodium iodomethamate (substance)"
          },
          {
            "code" : "38354005",
            "display" : "Open wound of head (disorder)"
          },
          {
            "code" : "38356007",
            "display" : "Venography of upper extremity (procedure)"
          },
          {
            "code" : "38361009",
            "display" : "Koreans (ethnic group)"
          },
          {
            "code" : "38362002",
            "display" : "Dengue (disorder)"
          },
          {
            "code" : "38365000",
            "display" : "Peptic ulcer without hemorrhage, without perforation AND without obstruction (disorder)"
          },
          {
            "code" : "38394007",
            "display" : "Chronic purulent otitis media (disorder)"
          },
          {
            "code" : "38403006",
            "display" : "Vertigo of central origin (disorder)"
          },
          {
            "code" : "38407007",
            "display" : "Skin structure of antitragus (body structure)"
          },
          {
            "code" : "38424001",
            "display" : "Strontium (87-Sr) chloride (substance)"
          },
          {
            "code" : "38449002",
            "display" : "Curly-coated retriever (organism)"
          },
          {
            "code" : "38479009",
            "display" : "Frank breech delivery (procedure)"
          },
          {
            "code" : "38481006",
            "display" : "Hypertensive renal disease (disorder)"
          },
          {
            "code" : "38523005",
            "display" : "Syphilitic parkinsonism (disorder)"
          },
          {
            "code" : "38526002",
            "display" : "Vaginoscopy with biopsy of cervix (procedure)"
          },
          {
            "code" : "38542009",
            "display" : "Nodular glomerulosclerosis (morphologic abnormality)"
          },
          {
            "code" : "38543004",
            "display" : "Lissamine green B stain (substance)"
          },
          {
            "code" : "38577009",
            "display" : "Effects of lightning (disorder)"
          },
          {
            "code" : "38586004",
            "display" : "Laser-generated electromagnetic radiation (physical force)"
          },
          {
            "code" : "38592005",
            "display" : "Dental behavior management (regime/therapy)"
          },
          {
            "code" : "38598009",
            "display" : "Administration of vaccine product containing only Measles morbillivirus and Mumps orthorubulavirus and Rubella virus antigens (procedure)"
          },
          {
            "code" : "38617005",
            "display" : "Dental phobia (finding)"
          },
          {
            "code" : "38628009",
            "display" : "Homosexual (finding)"
          },
          {
            "code" : "38691007",
            "display" : "Sexual neglect (finding)"
          },
          {
            "code" : "38707008",
            "display" : "Celestine blue B stain (substance)"
          },
          {
            "code" : "38708003",
            "display" : "Cholesteatoma of attic (disorder)"
          },
          {
            "code" : "38713004",
            "display" : "Astrocytoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "38716007",
            "display" : "Atherosclerosis (morphologic abnormality)"
          },
          {
            "code" : "38717003",
            "display" : "Longitudinal (qualifier value)"
          },
          {
            "code" : "38739001",
            "display" : "Hepatic vein thrombosis (disorder)"
          },
          {
            "code" : "38742007",
            "display" : "Central retinal artery occlusion (disorder)"
          },
          {
            "code" : "38750003",
            "display" : "Bororo (ethnic group)"
          },
          {
            "code" : "38774000",
            "display" : "Pectus carinatum (disorder)"
          },
          {
            "code" : "38804009",
            "display" : "Turner syndrome (disorder)"
          },
          {
            "code" : "38822007",
            "display" : "Cystitis (disorder)"
          },
          {
            "code" : "38823002",
            "display" : "Aural headache (finding)"
          },
          {
            "code" : "38829003",
            "display" : "Partial excision (procedure)"
          },
          {
            "code" : "38848004",
            "display" : "Duodenal structure (body structure)"
          },
          {
            "code" : "38850007",
            "display" : "Chronic arthropathy (disorder)"
          },
          {
            "code" : "38864007",
            "display" : "Perineal structure (body structure)"
          },
          {
            "code" : "38866009",
            "display" : "Body part structure (body structure)"
          },
          {
            "code" : "38880002",
            "display" : "Rigor (finding)"
          },
          {
            "code" : "38896004",
            "display" : "Structure of deciduous mandibular left first molar tooth (body structure)"
          },
          {
            "code" : "38898003",
            "display" : "Xanthogranulomatous pyelonephritis (disorder)"
          },
          {
            "code" : "38902009",
            "display" : "Solochrome dark blue stain (substance)"
          },
          {
            "code" : "38907003",
            "display" : "Varicella (disorder)"
          },
          {
            "code" : "38911009",
            "display" : "Hereditary hemolytic anemia (disorder)"
          },
          {
            "code" : "38921001",
            "display" : "Measles with complication (disorder)"
          },
          {
            "code" : "38934000",
            "display" : "Upper eyelid structure (body structure)"
          },
          {
            "code" : "38936003",
            "display" : "Abnormal blood pressure (finding)"
          },
          {
            "code" : "38941006",
            "display" : "Neuroleptic-induced tardive dyskinesia (disorder)"
          },
          {
            "code" : "38991005",
            "display" : "Structure of superior phrenic artery (body structure)"
          },
          {
            "code" : "38994002",
            "display" : "Structure of permanent mandibular right third molar tooth (body structure)"
          },
          {
            "code" : "38996000",
            "display" : "External hemorrhoids without complication (disorder)"
          },
          {
            "code" : "39000009",
            "display" : "Hemangiosarcoma (morphologic abnormality)"
          },
          {
            "code" : "39007007",
            "display" : "Black Jews (ethnic group)"
          },
          {
            "code" : "39018007",
            "display" : "Renal arterial hypertension (disorder)"
          },
          {
            "code" : "39020005",
            "display" : "Brain injury, without skull fracture (disorder)"
          },
          {
            "code" : "39021009",
            "display" : "Disorder of refraction (disorder)"
          },
          {
            "code" : "39057004",
            "display" : "Pulmonary valve structure (body structure)"
          },
          {
            "code" : "39058009",
            "display" : "Lumbosacral radiculoplexus neuropathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "39085002",
            "display" : "Secondary syphilis of mucous membrane (disorder)"
          },
          {
            "code" : "39093002",
            "display" : "Post-trauma response (finding)"
          },
          {
            "code" : "39104002",
            "display" : "Illness (finding)"
          },
          {
            "code" : "39109007",
            "display" : "Fall involving sports equipment (event)"
          },
          {
            "code" : "39154008",
            "display" : "Clinical diagnosis (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "39181008",
            "display" : "Radiculoplexus neuropathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "39200002",
            "display" : "Iodinated (131-I) albumin (substance)"
          },
          {
            "code" : "39202005",
            "display" : "Coronary artery bypass with autogenous graft, four grafts (procedure)"
          },
          {
            "code" : "39273001",
            "display" : "Apical periodontitis (disorder)"
          },
          {
            "code" : "39288006",
            "display" : "Purulent otitis media (disorder)"
          },
          {
            "code" : "39290007",
            "display" : "Barium (substance)"
          },
          {
            "code" : "39322007",
            "display" : "Trochlear nerve structure (body structure)"
          },
          {
            "code" : "39335003",
            "display" : "Closed fracture of four ribs (disorder)"
          },
          {
            "code" : "39343008",
            "display" : "Administration of vaccine product containing only Bordetella pertussis antigen (procedure)"
          },
          {
            "code" : "39348004",
            "display" : "Maltese dog (organism)"
          },
          {
            "code" : "39350007",
            "display" : "Private physicians' group office (environment)"
          },
          {
            "code" : "39352004",
            "display" : "Joint structure (body structure)"
          },
          {
            "code" : "39379000",
            "display" : "Forcible sexual assault (event)"
          },
          {
            "code" : "39402007",
            "display" : "Pelvic congestion syndrome (disorder)"
          },
          {
            "code" : "39403002",
            "display" : "Decreased nutritional requirement (finding)"
          },
          {
            "code" : "39406005",
            "display" : "Legally induced abortion (disorder)"
          },
          {
            "code" : "39419009",
            "display" : "Hypovolemic shock (disorder)"
          },
          {
            "code" : "39423001",
            "display" : "Stuttering (finding)"
          },
          {
            "code" : "39446004",
            "display" : "Female infertility of tubal origin (disorder)"
          },
          {
            "code" : "39450006",
            "display" : "Senile cataract (disorder)"
          },
          {
            "code" : "39462005",
            "display" : "Thyroglossal duct cyst (disorder)"
          },
          {
            "code" : "39477002",
            "display" : "Feces (substance)"
          },
          {
            "code" : "39479004",
            "display" : "Telogen effluvium (disorder)"
          },
          {
            "code" : "39481002",
            "display" : "Upper dental arch structure (body structure)"
          },
          {
            "code" : "39491008",
            "display" : "Altered sexuality patterns (finding)"
          },
          {
            "code" : "39525005",
            "display" : "Tumor necrosis factor alpha (substance)"
          },
          {
            "code" : "39526006",
            "display" : "Redundant prepuce (disorder)"
          },
          {
            "code" : "39532001",
            "display" : "Norman coach horse (organism)"
          },
          {
            "code" : "39539005",
            "display" : "Abnormal renal function (finding)"
          },
          {
            "code" : "39543009",
            "display" : "Administration of insulin (procedure)"
          },
          {
            "code" : "39545002",
            "display" : "Low cholesterol-low saturated fat diet (finding)"
          },
          {
            "code" : "39575007",
            "display" : "Urine looks dark (finding)"
          },
          {
            "code" : "39579001",
            "display" : "Anaphylaxis (disorder)"
          },
          {
            "code" : "39607008",
            "display" : "Lung structure (body structure)"
          },
          {
            "code" : "39621005",
            "display" : "Disorder of gallbladder (disorder)"
          },
          {
            "code" : "39623008",
            "display" : "At risk for poisoning injury (finding)"
          },
          {
            "code" : "39629007",
            "display" : "Pyogenic granuloma of skin (disorder)"
          },
          {
            "code" : "39677007",
            "display" : "Internal medicine specialist (occupation)"
          },
          {
            "code" : "39687006",
            "display" : "Skin structure of inguinal region (body structure)"
          },
          {
            "code" : "39723000",
            "display" : "Sacroiliac joint structure (body structure)"
          },
          {
            "code" : "39727004",
            "display" : "Hypertension secondary to renal disease complicating AND/OR reason for care during puerperium (disorder)"
          },
          {
            "code" : "39739007",
            "display" : "Legionella jordanis (organism)"
          },
          {
            "code" : "39743006",
            "display" : "Structure of anterior segment of right upper lobe of lung (body structure)"
          },
          {
            "code" : "39764005",
            "display" : "Bantu (ethnic group)"
          },
          {
            "code" : "39772007",
            "display" : "Rectal polyp (disorder)"
          },
          {
            "code" : "39777001",
            "display" : "Sudan III stain (substance)"
          },
          {
            "code" : "39790008",
            "display" : "Non-electric heating pad, device (physical object)"
          },
          {
            "code" : "39812007",
            "display" : "Contusion of forearm (disorder)"
          },
          {
            "code" : "39823006",
            "display" : "Generalized atherosclerosis (disorder)"
          },
          {
            "code" : "39826003",
            "display" : "Struck by explosion (event)"
          },
          {
            "code" : "39837002",
            "display" : "Alternating esotropia (disorder)"
          },
          {
            "code" : "39839004",
            "display" : "Diaphragmatic hernia (disorder)"
          },
          {
            "code" : "39844006",
            "display" : "Structure of mandibular left canine tooth (body structure)"
          },
          {
            "code" : "39845007",
            "display" : "Anterior colporrhaphy (procedure)"
          },
          {
            "code" : "39848009",
            "display" : "Whiplash injury to neck (disorder)"
          },
          {
            "code" : "39855006",
            "display" : "Wiltshire horn sheep (organism)"
          },
          {
            "code" : "39857003",
            "display" : "Weighing patient (procedure)"
          },
          {
            "code" : "39871006",
            "display" : "Chronic respiratory failure (disorder)"
          },
          {
            "code" : "39882003",
            "display" : "Silky terrier (organism)"
          },
          {
            "code" : "39889007",
            "display" : "Right occipitoanterior position (finding)"
          },
          {
            "code" : "39898005",
            "display" : "Sleep disorder (disorder)"
          },
          {
            "code" : "39905002",
            "display" : "Scimitar syndrome (disorder)"
          },
          {
            "code" : "39908000",
            "display" : "Food exchange list (finding)"
          },
          {
            "code" : "39913001",
            "display" : "Residential school infirmary (environment)"
          },
          {
            "code" : "39937001",
            "display" : "Skin structure (body structure)"
          },
          {
            "code" : "39980005",
            "display" : "Fat controlled diet (finding)"
          },
          {
            "code" : "40005008",
            "display" : "Structure of mandibular right second molar tooth (body structure)"
          },
          {
            "code" : "40024006",
            "display" : "Retinal defect (disorder)"
          },
          {
            "code" : "40039007",
            "display" : "Vesicular stomatitis virus, Argentina (organism)"
          },
          {
            "code" : "40043006",
            "display" : "Bottle feeding of patient (regime/therapy)"
          },
          {
            "code" : "40055000",
            "display" : "Chronic sinusitis (disorder)"
          },
          {
            "code" : "40059006",
            "display" : "Creation of aortofemoral shunt (procedure)"
          },
          {
            "code" : "40068008",
            "display" : "Hydroureteronephrosis (disorder)"
          },
          {
            "code" : "40069000",
            "display" : "Skin structure of lower eyelid (body structure)"
          },
          {
            "code" : "40070004",
            "display" : "Infection caused by Molluscum contagiosum (disorder)"
          },
          {
            "code" : "40076005",
            "display" : "Erie garnet stain (substance)"
          },
          {
            "code" : "40100001",
            "display" : "Obliterative bronchiolitis (disorder)"
          },
          {
            "code" : "40104005",
            "display" : "Fall in home (event)"
          },
          {
            "code" : "40108008",
            "display" : "Thalassemia (disorder)"
          },
          {
            "code" : "40121001",
            "display" : "Miniature poodle (organism)"
          },
          {
            "code" : "40122008",
            "display" : "Pneumoconiosis (disorder)"
          },
          {
            "code" : "40130009",
            "display" : "Spina bifida without hydrocephalus (disorder)"
          },
          {
            "code" : "40144003",
            "display" : "Morning stiffness - joint (finding)"
          },
          {
            "code" : "40146001",
            "display" : "Structure of cerebral cortex (body structure)"
          },
          {
            "code" : "40149008",
            "display" : "Gonococcal keratitis (disorder)"
          },
          {
            "code" : "40165009",
            "display" : "Buriats (ethnic group)"
          },
          {
            "code" : "40174006",
            "display" : "Isolation procedure (procedure)"
          },
          {
            "code" : "40178009",
            "display" : "Allergic urticaria (disorder)"
          },
          {
            "code" : "40182006",
            "display" : "Gypsies (ethnic group)"
          },
          {
            "code" : "40196000",
            "display" : "Mild pain (finding)"
          },
          {
            "code" : "40198004",
            "display" : "Thrombophlebitis of deep veins of lower extremity (disorder)"
          },
          {
            "code" : "40199007",
            "display" : "Supine body position (finding)"
          },
          {
            "code" : "40219000",
            "display" : "Delivery by Malstrom's extraction with episiotomy (procedure)"
          },
          {
            "code" : "40242007",
            "display" : "Structure of lateral external iliac lymph node (body structure)"
          },
          {
            "code" : "40250003",
            "display" : "Interatrial transposition of venous return (procedure)"
          },
          {
            "code" : "40254007",
            "display" : "Structure of digital artery of hand (body structure)"
          },
          {
            "code" : "40257000",
            "display" : "Contusion of shoulder region (disorder)"
          },
          {
            "code" : "40265002",
            "display" : "Structure of arch of vertebra (body structure)"
          },
          {
            "code" : "40266001",
            "display" : "Lobular (qualifier value)"
          },
          {
            "code" : "40275004",
            "display" : "Contact dermatitis (disorder)"
          },
          {
            "code" : "40283005",
            "display" : "Thrombophlebitis of superficial veins of lower extremity (disorder)"
          },
          {
            "code" : "40300007",
            "display" : "Structure of internal iliac vein (body structure)"
          },
          {
            "code" : "40333002",
            "display" : "Mycobacterium triviale (organism)"
          },
          {
            "code" : "40342009",
            "display" : "Thiamylal sodium (substance)"
          },
          {
            "code" : "40354009",
            "display" : "De Lange syndrome (disorder)"
          },
          {
            "code" : "40365004",
            "display" : "Anesthesia for procedure on lumbosacral spinal cord (procedure)"
          },
          {
            "code" : "40379007",
            "display" : "Mild recurrent major depression (disorder)"
          },
          {
            "code" : "40388003",
            "display" : "Implant, device (physical object)"
          },
          {
            "code" : "40400008",
            "display" : "Plott hound (organism)"
          },
          {
            "code" : "40403005",
            "display" : "Catheterization of right heart (procedure)"
          },
          {
            "code" : "40415009",
            "display" : "Proximal (qualifier value)"
          },
          {
            "code" : "40425004",
            "display" : "Postconcussion syndrome (disorder)"
          },
          {
            "code" : "40445007",
            "display" : "Heart valve regurgitation (disorder)"
          },
          {
            "code" : "40468003",
            "display" : "Viral hepatitis, type A (disorder)"
          },
          {
            "code" : "40492006",
            "display" : "Bladder dysfunction (finding)"
          },
          {
            "code" : "40505001",
            "display" : "Orthoptic training (regime/therapy)"
          },
          {
            "code" : "40537000",
            "display" : "Cold exposure (event)"
          },
          {
            "code" : "40539002",
            "display" : "Hypothyroidism following radioiodine therapy (disorder)"
          },
          {
            "code" : "40541001",
            "display" : "Acute pulmonary edema (disorder)"
          },
          {
            "code" : "40546006",
            "display" : "Sodium restricted diet, 90 milliequivalents (finding)"
          },
          {
            "code" : "40547002",
            "display" : "Longhaired manx (organism)"
          },
          {
            "code" : "40565003",
            "display" : "Carbon-11 (substance)"
          },
          {
            "code" : "40568001",
            "display" : "Recurrent brief depressive disorder (disorder)"
          },
          {
            "code" : "40608009",
            "display" : "Hypertropia (disorder)"
          },
          {
            "code" : "40614002",
            "display" : "Campylobacter coli (organism)"
          },
          {
            "code" : "40617009",
            "display" : "Artificial respiration (procedure)"
          },
          {
            "code" : "40631009",
            "display" : "Skew deviation (disorder)"
          },
          {
            "code" : "40638003",
            "display" : "Structure of both eyes (body structure)"
          },
          {
            "code" : "40650009",
            "display" : "Obstruction of colon (disorder)"
          },
          {
            "code" : "40654000",
            "display" : "Operation on eyelid (procedure)"
          },
          {
            "code" : "40684008",
            "display" : "Structure of inferior gluteal lymph node (body structure)"
          },
          {
            "code" : "40689003",
            "display" : "Testis structure (body structure)"
          },
          {
            "code" : "40700009",
            "display" : "Severe intellectual disability (disorder)"
          },
          {
            "code" : "40701008",
            "display" : "Echocardiography (procedure)"
          },
          {
            "code" : "40710000",
            "display" : "Iodopyracet (substance)"
          },
          {
            "code" : "40713003",
            "display" : "Mycobacterium ulcerans (organism)"
          },
          {
            "code" : "40718007",
            "display" : "Fast red B salt stain (substance)"
          },
          {
            "code" : "40719004",
            "display" : "Erosive esophagitis (disorder)"
          },
          {
            "code" : "40725000",
            "display" : "Muscular steatosis (disorder)"
          },
          {
            "code" : "40727008",
            "display" : "West Highland white terrier (organism)"
          },
          {
            "code" : "40733004",
            "display" : "Infectious disease (disorder)"
          },
          {
            "code" : "40739000",
            "display" : "Dysphagia (disorder)"
          },
          {
            "code" : "40740003",
            "display" : "Genus Trypanosoma (organism)"
          },
          {
            "code" : "40754006",
            "display" : "Puumala virus (organism)"
          },
          {
            "code" : "40772000",
            "display" : "Fibrous plaque (morphologic abnormality)"
          },
          {
            "code" : "40779009",
            "display" : "Discoid atelectasis (disorder)"
          },
          {
            "code" : "40791000",
            "display" : "Preparation of disability evaluation report (procedure)"
          },
          {
            "code" : "40799003",
            "display" : "Subacromial bursitis (disorder)"
          },
          {
            "code" : "40807001",
            "display" : "Brother-sister sex play (finding)"
          },
          {
            "code" : "40808006",
            "display" : "Oil red O stain (substance)"
          },
          {
            "code" : "40835002",
            "display" : "Coffee ground vomiting (disorder)"
          },
          {
            "code" : "40862005",
            "display" : "Local excision of skin and subcutaneous tissue (procedure)"
          },
          {
            "code" : "40867004",
            "display" : "Structure of isthmus of thyroid gland (body structure)"
          },
          {
            "code" : "40886007",
            "display" : "Klebsiella oxytoca (organism)"
          },
          {
            "code" : "40890009",
            "display" : "Esophageal dysphagia (disorder)"
          },
          {
            "code" : "40898002",
            "display" : "Welsh Springer spaniel (organism)"
          },
          {
            "code" : "40915004",
            "display" : "Orgasm impairment (finding)"
          },
          {
            "code" : "40917007",
            "display" : "Clouded consciousness (finding)"
          },
          {
            "code" : "40923002",
            "display" : "Tissue processing technique, routine, embed, cut and stain, per surgical specimen (procedure)"
          },
          {
            "code" : "40926005",
            "display" : "Moderate mixed bipolar I disorder (disorder)"
          },
          {
            "code" : "40930008",
            "display" : "Hypothyroidism (disorder)"
          },
          {
            "code" : "40937006",
            "display" : "Iodine-124 (substance)"
          },
          {
            "code" : "40951006",
            "display" : "Primary hyperoxaluria, type II (disorder)"
          },
          {
            "code" : "40956001",
            "display" : "Guillain-Barré syndrome (disorder)"
          },
          {
            "code" : "40970001",
            "display" : "Chronic osteomyelitis (disorder)"
          },
          {
            "code" : "40979000",
            "display" : "Lack of exercise (finding)"
          },
          {
            "code" : "40980002",
            "display" : "Spastic paralysis due to birth injury (disorder)"
          },
          {
            "code" : "40983000",
            "display" : "Structure of upper extremity between shoulder and elbow (body structure)"
          },
          {
            "code" : "40987004",
            "display" : "Intermittent explosive disorder (disorder)"
          },
          {
            "code" : "41040004",
            "display" : "Complete trisomy 21 syndrome (disorder)"
          },
          {
            "code" : "41059002",
            "display" : "Cesarean hysterectomy (procedure)"
          },
          {
            "code" : "41076003",
            "display" : "Mozambiquans (ethnic group)"
          },
          {
            "code" : "41088001",
            "display" : "Administration of vaccine product containing only Neisseria meningitidis antigen (procedure)"
          },
          {
            "code" : "41090000",
            "display" : "Chlamydophila psittaci variant bovis (organism)"
          },
          {
            "code" : "41092008",
            "display" : "Cleveland bay horse (organism)"
          },
          {
            "code" : "41109008",
            "display" : "South River virus (organism)"
          },
          {
            "code" : "41111004",
            "display" : "Bone structure of shaft of femur (body structure)"
          },
          {
            "code" : "41112006",
            "display" : "150 milligram calcium diet (finding)"
          },
          {
            "code" : "41114007",
            "display" : "Mild pre-eclampsia (disorder)"
          },
          {
            "code" : "41119002",
            "display" : "Akinetic seizure without atonia (finding)"
          },
          {
            "code" : "41137001",
            "display" : "Bicipital tenosynovitis (disorder)"
          },
          {
            "code" : "41145006",
            "display" : "Structure of lateral common iliac lymph node (body structure)"
          },
          {
            "code" : "41174002",
            "display" : "Acute lymphadenitis (disorder)"
          },
          {
            "code" : "41179007",
            "display" : "Increased erection of penis (finding)"
          },
          {
            "code" : "41188003",
            "display" : "Disorder of oral soft tissues (disorder)"
          },
          {
            "code" : "41207000",
            "display" : "Adenoviral pneumonia (disorder)"
          },
          {
            "code" : "41216001",
            "display" : "Prostatic structure (body structure)"
          },
          {
            "code" : "41256004",
            "display" : "Presbyopia (disorder)"
          },
          {
            "code" : "41263004",
            "display" : "Papillon dog (organism)"
          },
          {
            "code" : "41291007",
            "display" : "Angioedema (disorder)"
          },
          {
            "code" : "41296002",
            "display" : "Iris structure (body structure)"
          },
          {
            "code" : "41299009",
            "display" : "Iatrogenic Cushing's disease (disorder)"
          },
          {
            "code" : "41304005",
            "display" : "Mycobacterium obuense (organism)"
          },
          {
            "code" : "41308008",
            "display" : "Acute follicular conjunctivitis (disorder)"
          },
          {
            "code" : "41309000",
            "display" : "Alcoholic liver damage (disorder)"
          },
          {
            "code" : "41310005",
            "display" : "Skin structure of upper eyelid (body structure)"
          },
          {
            "code" : "41313007",
            "display" : "Structure of internal intercostal muscle (body structure)"
          },
          {
            "code" : "41320000",
            "display" : "Basset hound (organism)"
          },
          {
            "code" : "41328007",
            "display" : "Dengue virus, type 2 (organism)"
          },
          {
            "code" : "41334000",
            "display" : "Angina, class II (disorder)"
          },
          {
            "code" : "41339005",
            "display" : "Coronary angioplasty (procedure)"
          },
          {
            "code" : "41345002",
            "display" : "Rickets (disorder)"
          },
          {
            "code" : "41366005",
            "display" : "Subgingival dental calculus (disorder)"
          },
          {
            "code" : "41381004",
            "display" : "Pneumonia caused by Pseudomonas (disorder)"
          },
          {
            "code" : "41411008",
            "display" : "Fall from playground equipment (event)"
          },
          {
            "code" : "41440006",
            "display" : "Radioisotope brain imaging (procedure)"
          },
          {
            "code" : "41446000",
            "display" : "Blepharitis (disorder)"
          },
          {
            "code" : "41449007",
            "display" : "General diet (finding)"
          },
          {
            "code" : "41453009",
            "display" : "Strabismus surgery (procedure)"
          },
          {
            "code" : "41497008",
            "display" : "Febrile convulsion (finding)"
          },
          {
            "code" : "41501003",
            "display" : "Threatening suicide (finding)"
          },
          {
            "code" : "41510006",
            "display" : "Anoxic seizure (finding)"
          },
          {
            "code" : "41524005",
            "display" : "Flagellantism (disorder)"
          },
          {
            "code" : "41538003",
            "display" : "Bichons frise dog (organism)"
          },
          {
            "code" : "41549009",
            "display" : "Product containing angiotensin-converting enzyme inhibitor (product)"
          },
          {
            "code" : "41550009",
            "display" : "Skin structure of posterior surface of forearm (body structure)"
          },
          {
            "code" : "41554000",
            "display" : "Autopsy, gross and microscopic examination with brain and spinal cord (procedure)"
          },
          {
            "code" : "41561001",
            "display" : "Dekalb hybrid pig line 30 (organism)"
          },
          {
            "code" : "41565005",
            "display" : "Periodontitis (disorder)"
          },
          {
            "code" : "41581000",
            "display" : "Muscular hypertonicity (disorder)"
          },
          {
            "code" : "41582007",
            "display" : "Streptococcal tonsillitis (disorder)"
          },
          {
            "code" : "41584008",
            "display" : "Wire fox terrier (organism)"
          },
          {
            "code" : "41587001",
            "display" : "Third trimester pregnancy (finding)"
          },
          {
            "code" : "41598000",
            "display" : "Estrogen (substance)"
          },
          {
            "code" : "41601005",
            "display" : "Structure of shaft of rib (body structure)"
          },
          {
            "code" : "41608004",
            "display" : "Closed fractures of tarsal AND metatarsal bones (disorder)"
          },
          {
            "code" : "41633001",
            "display" : "Intraocular pressure (observable entity)"
          },
          {
            "code" : "41652007",
            "display" : "Pain in eye (finding)"
          },
          {
            "code" : "41663005",
            "display" : "Disorder of pinna (disorder)"
          },
          {
            "code" : "41695006",
            "display" : "Scalp structure (body structure)"
          },
          {
            "code" : "41699000",
            "display" : "Effusion (morphologic abnormality)"
          },
          {
            "code" : "41704008",
            "display" : "Borrelia parkeri (organism)"
          },
          {
            "code" : "41706005",
            "display" : "Perendale sheep (organism)"
          },
          {
            "code" : "41729002",
            "display" : "Horseshoe kidney (disorder)"
          },
          {
            "code" : "41738000",
            "display" : "Palomino horse (organism)"
          },
          {
            "code" : "41750006",
            "display" : "Brazilin stain (substance)"
          },
          {
            "code" : "41754002",
            "display" : "Lipizzaner horse (organism)"
          },
          {
            "code" : "41758004",
            "display" : "Ytterbium-169 (substance)"
          },
          {
            "code" : "41770000",
            "display" : "Autopsy, gross and microscopic examination (procedure)"
          },
          {
            "code" : "41788008",
            "display" : "Hereditary factor IX deficiency disease (disorder)"
          },
          {
            "code" : "41798002",
            "display" : "Caroline Islanders (ethnic group)"
          },
          {
            "code" : "41801008",
            "display" : "Coronary artery structure (body structure)"
          },
          {
            "code" : "41817002",
            "display" : "Closure of patent foramen ovale (procedure)"
          },
          {
            "code" : "41829006",
            "display" : "Dietary finding (finding)"
          },
          {
            "code" : "41842006",
            "display" : "Radioisotope study of hematopoietic system (procedure)"
          },
          {
            "code" : "41844007",
            "display" : "Free-standing geriatric clinic (environment)"
          },
          {
            "code" : "41879009",
            "display" : "Structure of distal portion of right coronary artery (body structure)"
          },
          {
            "code" : "41888000",
            "display" : "Temporomandibular joint disorder (disorder)"
          },
          {
            "code" : "41905003",
            "display" : "Career choice problem (finding)"
          },
          {
            "code" : "41918006",
            "display" : "External resorption of tooth (disorder)"
          },
          {
            "code" : "41919003",
            "display" : "Juvenile carcinoma of the breast (morphologic abnormality)"
          },
          {
            "code" : "41944006",
            "display" : "Amputee (finding)"
          },
          {
            "code" : "41967008",
            "display" : "Silver (substance)"
          },
          {
            "code" : "41975002",
            "display" : "Insomnia with sleep apnea (disorder)"
          },
          {
            "code" : "41976001",
            "display" : "Cardiac catheterization (procedure)"
          },
          {
            "code" : "41982003",
            "display" : "Male climacteric (finding)"
          },
          {
            "code" : "42024000",
            "display" : "Murine poliovirus (organism)"
          },
          {
            "code" : "42035005",
            "display" : "Bisexual (finding)"
          },
          {
            "code" : "42052009",
            "display" : "Omphalitis of the newborn (disorder)"
          },
          {
            "code" : "42059000",
            "display" : "Retinal detachment (disorder)"
          },
          {
            "code" : "42085001",
            "display" : "Victim of rape (finding)"
          },
          {
            "code" : "42096009",
            "display" : "Dental liquid diet (finding)"
          },
          {
            "code" : "42101009",
            "display" : "Penetrating keratoplasty (procedure)"
          },
          {
            "code" : "42112009",
            "display" : "Urinary incontinence of non-organic origin (finding)"
          },
          {
            "code" : "42116007",
            "display" : "Prolapse of vaginal vault after hysterectomy (disorder)"
          },
          {
            "code" : "42131003",
            "display" : "Abnormal menstrual cycle (finding)"
          },
          {
            "code" : "42157000",
            "display" : "Closed fracture of vertebral column (disorder)"
          },
          {
            "code" : "42177007",
            "display" : "Pulse slow (finding)"
          },
          {
            "code" : "42182000",
            "display" : "Cystic medial necrosis (morphologic abnormality)"
          },
          {
            "code" : "42188001",
            "display" : "Closed fracture of ankle (disorder)"
          },
          {
            "code" : "42239005",
            "display" : "Carbohydrate diet (finding)"
          },
          {
            "code" : "42248000",
            "display" : "Methyl orange stain (substance)"
          },
          {
            "code" : "42250008",
            "display" : "Boxer dog (organism)"
          },
          {
            "code" : "42252000",
            "display" : "German shepherd dog (organism)"
          },
          {
            "code" : "42258001",
            "display" : "Superior mesenteric artery structure (body structure)"
          },
          {
            "code" : "42262007",
            "display" : "Total shoulder replacement (procedure)"
          },
          {
            "code" : "42265009",
            "display" : "Idiopathic urticaria (disorder)"
          },
          {
            "code" : "42284007",
            "display" : "Administration of vaccine product containing only live attenuated Mycobacterium bovis antigen (procedure)"
          },
          {
            "code" : "42288005",
            "display" : "Absence of ejaculation (finding)"
          },
          {
            "code" : "42289002",
            "display" : "Wired jaw diet (finding)"
          },
          {
            "code" : "42320003",
            "display" : "Structure of left seminal vesicle (body structure)"
          },
          {
            "code" : "42323001",
            "display" : "Eruption cyst of jaw (disorder)"
          },
          {
            "code" : "42343007",
            "display" : "Congestive heart failure (disorder)"
          },
          {
            "code" : "42344001",
            "display" : "Alcohol-induced psychosis (disorder)"
          },
          {
            "code" : "42345000",
            "display" : "Polyneuropathy (disorder)"
          },
          {
            "code" : "42385006",
            "display" : "Lactocele (disorder)"
          },
          {
            "code" : "42394000",
            "display" : "Domestic nudity (finding)"
          },
          {
            "code" : "42399005",
            "display" : "Renal failure syndrome (disorder)"
          },
          {
            "code" : "42416001",
            "display" : "Lanolin (substance)"
          },
          {
            "code" : "42417005",
            "display" : "Carbon (14-C) triolein (substance)"
          },
          {
            "code" : "42425007",
            "display" : "Equivocal (qualifier value)"
          },
          {
            "code" : "42427004",
            "display" : "At risk for suffocation (finding)"
          },
          {
            "code" : "42448002",
            "display" : "Herpes zoster keratoconjunctivitis (disorder)"
          },
          {
            "code" : "42452002",
            "display" : "Thoracic radiculopathy (disorder)"
          },
          {
            "code" : "42458003",
            "display" : "Hemothorax due to trauma (disorder)"
          },
          {
            "code" : "42472007",
            "display" : "Structure of medial external iliac lymph node (body structure)"
          },
          {
            "code" : "42479003",
            "display" : "Injury of buttock (disorder)"
          },
          {
            "code" : "42513006",
            "display" : "Punctate keratitis (disorder)"
          },
          {
            "code" : "42541005",
            "display" : "Irritant gastritis (disorder)"
          },
          {
            "code" : "42570001",
            "display" : "Pruritus senilis (disorder)"
          },
          {
            "code" : "42571002",
            "display" : "Failed induction of labor (disorder)"
          },
          {
            "code" : "42575006",
            "display" : "Structure of pituitary fossa (body structure)"
          },
          {
            "code" : "42632009",
            "display" : "Andamanese (ethnic group)"
          },
          {
            "code" : "42633004",
            "display" : "Bland diet, stage 1 (finding)"
          },
          {
            "code" : "42636007",
            "display" : "Closed fracture of upper end of humerus (disorder)"
          },
          {
            "code" : "42643001",
            "display" : "Disorder of urinary bladder (disorder)"
          },
          {
            "code" : "42644007",
            "display" : "Basic coital position (finding)"
          },
          {
            "code" : "42653000",
            "display" : "Calcification of pericardium (disorder)"
          },
          {
            "code" : "42655007",
            "display" : "Complete bilateral paralysis of vocal cords (disorder)"
          },
          {
            "code" : "42658009",
            "display" : "Disorder of the peripheral nervous system (disorder)"
          },
          {
            "code" : "42665001",
            "display" : "Nursing home (environment)"
          },
          {
            "code" : "42681006",
            "display" : "Islet cell hyperplasia (disorder)"
          },
          {
            "code" : "42695009",
            "display" : "Thalamic structure (body structure)"
          },
          {
            "code" : "42700002",
            "display" : "Round shape (qualifier value)"
          },
          {
            "code" : "42711005",
            "display" : "Necrosis of the pulp (disorder)"
          },
          {
            "code" : "42712003",
            "display" : "Cri du chat (finding)"
          },
          {
            "code" : "42724005",
            "display" : "American saddlebred horse (organism)"
          },
          {
            "code" : "42728008",
            "display" : "Indium (113-In) pentetate (substance)"
          },
          {
            "code" : "42737008",
            "display" : "Masculinity (finding)"
          },
          {
            "code" : "42746002",
            "display" : "Gonorrhea of rectum (disorder)"
          },
          {
            "code" : "42752001",
            "display" : "Due to (attribute)"
          },
          {
            "code" : "42770003",
            "display" : "Syphilis of tricuspid valve (disorder)"
          },
          {
            "code" : "42786005",
            "display" : "Snapping thumb syndrome (disorder)"
          },
          {
            "code" : "42798000",
            "display" : "Area (qualifier value)"
          },
          {
            "code" : "42800007",
            "display" : "Fine tremor (finding)"
          },
          {
            "code" : "42810003",
            "display" : "Major depression in remission (disorder)"
          },
          {
            "code" : "42818005",
            "display" : "Closed fracture of navicular bone of wrist (disorder)"
          },
          {
            "code" : "42861008",
            "display" : "Thrombophlebitis of iliac vein (disorder)"
          },
          {
            "code" : "42902003",
            "display" : "White bull terrier (organism)"
          },
          {
            "code" : "42932006",
            "display" : "Structure of forceps minor (body structure)"
          },
          {
            "code" : "42937000",
            "display" : "Restoration, crown, single (procedure)"
          },
          {
            "code" : "42942008",
            "display" : "Compression fracture of vertebral column (disorder)"
          },
          {
            "code" : "42948007",
            "display" : "Norwegian landrace pig (organism)"
          },
          {
            "code" : "42954008",
            "display" : "Diabetes mellitus associated with receptor abnormality (disorder)"
          },
          {
            "code" : "42973007",
            "display" : "Structure of thoracic inlet (body structure)"
          },
          {
            "code" : "42982001",
            "display" : "Sialoadenitis (disorder)"
          },
          {
            "code" : "42984000",
            "display" : "Night sweats (finding)"
          },
          {
            "code" : "43019009",
            "display" : "Nelson syndrome (disorder)"
          },
          {
            "code" : "43029002",
            "display" : "Abnormal posture (finding)"
          },
          {
            "code" : "43038000",
            "display" : "Cardiovascular examination and evaluation (procedure)"
          },
          {
            "code" : "43045000",
            "display" : "Lacrimal caruncle structure (body structure)"
          },
          {
            "code" : "43056000",
            "display" : "Cuna (ethnic group)"
          },
          {
            "code" : "43064006",
            "display" : "Hydronephrosis (disorder)"
          },
          {
            "code" : "43067004",
            "display" : "Skin structure of scalp (body structure)"
          },
          {
            "code" : "43068009",
            "display" : "Motherhood (observable entity)"
          },
          {
            "code" : "43075005",
            "display" : "Partial resection of colon (procedure)"
          },
          {
            "code" : "43077002",
            "display" : "Cyst of epididymis (disorder)"
          },
          {
            "code" : "43081002",
            "display" : "Skin structure of neck (body structure)"
          },
          {
            "code" : "43084005",
            "display" : "Adolescent unwed mother (finding)"
          },
          {
            "code" : "43091008",
            "display" : "Listeria seeligeri (organism)"
          },
          {
            "code" : "43100002",
            "display" : "Late cortical cerebellar atrophy (disorder)"
          },
          {
            "code" : "43106008",
            "display" : "Pyronine G stain (substance)"
          },
          {
            "code" : "43116000",
            "display" : "Eczema (disorder)"
          },
          {
            "code" : "43119007",
            "display" : "Structure of posterior communicating artery (body structure)"
          },
          {
            "code" : "43141007",
            "display" : "Inhibition of lactation procedure (procedure)"
          },
          {
            "code" : "43144004",
            "display" : "Cyst of jaw (disorder)"
          },
          {
            "code" : "43150009",
            "display" : "Panic disorder without agoraphobia with severe panic attacks (disorder)"
          },
          {
            "code" : "43153006",
            "display" : "Myxedema (disorder)"
          },
          {
            "code" : "43199008",
            "display" : "Vibrio fluvialis (organism)"
          },
          {
            "code" : "43219001",
            "display" : "Birman cat (organism)"
          },
          {
            "code" : "43230003",
            "display" : "Rubber (substance)"
          },
          {
            "code" : "43239002",
            "display" : "Selenium-75 (substance)"
          },
          {
            "code" : "43240000",
            "display" : "Diarrhea of presumed infectious origin (disorder)"
          },
          {
            "code" : "43252007",
            "display" : "Cochlear prosthesis, device (physical object)"
          },
          {
            "code" : "43272002",
            "display" : "Communicating (observable entity)"
          },
          {
            "code" : "43275000",
            "display" : "Otitis (disorder)"
          },
          {
            "code" : "43281008",
            "display" : "Structure of deciduous mandibular left canine tooth (body structure)"
          },
          {
            "code" : "43295006",
            "display" : "Closed fracture of humerus (disorder)"
          },
          {
            "code" : "43299000",
            "display" : "Miliary aneurysm (morphologic abnormality)"
          },
          {
            "code" : "43311000",
            "display" : "Latent homosexual state (finding)"
          },
          {
            "code" : "43339004",
            "display" : "Hypokalemia (disorder)"
          },
          {
            "code" : "43363007",
            "display" : "Posterior uveitis (disorder)"
          },
          {
            "code" : "43364001",
            "display" : "Abdominal discomfort (finding)"
          },
          {
            "code" : "43381005",
            "display" : "Passive smoker (finding)"
          },
          {
            "code" : "43396009",
            "display" : "Hemoglobin A1c measurement (procedure)"
          },
          {
            "code" : "43422002",
            "display" : "Crushing injury of foot (disorder)"
          },
          {
            "code" : "43424001",
            "display" : "Tetanus neonatorum (disorder)"
          },
          {
            "code" : "43437003",
            "display" : "Submucous cleft of hard palate (disorder)"
          },
          {
            "code" : "43454006",
            "display" : "Treponema pallidum ss. pallidum (organism)"
          },
          {
            "code" : "43478001",
            "display" : "Abdominal tenderness (finding)"
          },
          {
            "code" : "43486001",
            "display" : "Hemiplegic cerebral palsy (disorder)"
          },
          {
            "code" : "43491000",
            "display" : "Acute epididymitis (disorder)"
          },
          {
            "code" : "43492007",
            "display" : "Streptococcus agalactiae (organism)"
          },
          {
            "code" : "43498006",
            "display" : "Body fluid retention (disorder)"
          },
          {
            "code" : "43500007",
            "display" : "Boar power pig 454 (organism)"
          },
          {
            "code" : "43520008",
            "display" : "Operation of a therapeutic device, function (observable entity)"
          },
          {
            "code" : "43526002",
            "display" : "Operative site (morphologic abnormality)"
          },
          {
            "code" : "43529009",
            "display" : "Chartreux cat (organism)"
          },
          {
            "code" : "43538006",
            "display" : "Non radiopaque medium (substance)"
          },
          {
            "code" : "43548008",
            "display" : "Mittelschmerz (finding)"
          },
          {
            "code" : "43549000",
            "display" : "Solochrome azurine (BS) stain (substance)"
          },
          {
            "code" : "43577009",
            "display" : "Vegetable exchange list (finding)"
          },
          {
            "code" : "43608005",
            "display" : "Australian Aborigines (ethnic group)"
          },
          {
            "code" : "43612004",
            "display" : "Shigella dysenteriae (organism)"
          },
          {
            "code" : "43614003",
            "display" : "Autistic disorder of childhood onset (disorder)"
          },
          {
            "code" : "43622005",
            "display" : "Structure of deciduous maxillary left lateral incisor tooth (body structure)"
          },
          {
            "code" : "43650005",
            "display" : "Decreased cardiac function (finding)"
          },
          {
            "code" : "43674008",
            "display" : "Apical (qualifier value)"
          },
          {
            "code" : "43724002",
            "display" : "Chill (finding)"
          },
          {
            "code" : "43735007",
            "display" : "Sulfur (substance)"
          },
          {
            "code" : "43752006",
            "display" : "Inflammation of small intestine and colon (disorder)"
          },
          {
            "code" : "43756009",
            "display" : "Traumatic rupture of spleen (disorder)"
          },
          {
            "code" : "43769008",
            "display" : "Mild mixed bipolar I disorder (disorder)"
          },
          {
            "code" : "43783005",
            "display" : "Moderate drinker (finding)"
          },
          {
            "code" : "43797002",
            "display" : "Stricture of bile duct (disorder)"
          },
          {
            "code" : "43799004",
            "display" : "Thoracic cavity structure (body structure)"
          },
          {
            "code" : "43815004",
            "display" : "Implantation of cochlear prosthetic device, single channel (procedure)"
          },
          {
            "code" : "43829003",
            "display" : "Chronic osteoarthritis (disorder)"
          },
          {
            "code" : "43854003",
            "display" : "Retraction of eyelid (disorder)"
          },
          {
            "code" : "43863001",
            "display" : "Structure of superior left pulmonary vein (body structure)"
          },
          {
            "code" : "43878008",
            "display" : "Streptococcal sore throat (disorder)"
          },
          {
            "code" : "43890005",
            "display" : "Dieguenos (ethnic group)"
          },
          {
            "code" : "43899006",
            "display" : "Structure of popliteal artery (body structure)"
          },
          {
            "code" : "43902009",
            "display" : "Hard vocal attack, function (observable entity)"
          },
          {
            "code" : "43914001",
            "display" : "Laryngeal voice function (observable entity)"
          },
          {
            "code" : "43935004",
            "display" : "Vascular ectasia of gastric antrum (disorder)"
          },
          {
            "code" : "43939005",
            "display" : "Autopsy service by diener (procedure)"
          },
          {
            "code" : "43941006",
            "display" : "Pseudohypoaldosteronism, type 1 (disorder)"
          },
          {
            "code" : "43959009",
            "display" : "Cataract of eye due to diabetes mellitus (disorder)"
          },
          {
            "code" : "43967001",
            "display" : "Entire anterior cardiac vein (body structure)"
          },
          {
            "code" : "43982006",
            "display" : "Solar degeneration (disorder)"
          },
          {
            "code" : "44001008",
            "display" : "Premature ejaculation (finding)"
          },
          {
            "code" : "44027008",
            "display" : "Seafood (substance)"
          },
          {
            "code" : "44054006",
            "display" : "Diabetes mellitus type 2 (disorder)"
          },
          {
            "code" : "44057004",
            "display" : "Conductive hearing loss (disorder)"
          },
          {
            "code" : "44062003",
            "display" : "Early menarche (finding)"
          },
          {
            "code" : "44077006",
            "display" : "Numbness (finding)"
          },
          {
            "code" : "44081006",
            "display" : "Kuru agent (organism)"
          },
          {
            "code" : "44103008",
            "display" : "Ventricular arrhythmia (disorder)"
          },
          {
            "code" : "44106000",
            "display" : "Treponema pallidum ss. endemicum (organism)"
          },
          {
            "code" : "44132006",
            "display" : "Abscess (morphologic abnormality)"
          },
          {
            "code" : "44169009",
            "display" : "Loss of sense of smell (finding)"
          },
          {
            "code" : "44172002",
            "display" : "Human poliovirus (organism)"
          },
          {
            "code" : "44186003",
            "display" : "Dyssomnia (disorder)"
          },
          {
            "code" : "44188002",
            "display" : "Fall in shower (event)"
          },
          {
            "code" : "44201003",
            "display" : "Mumps meningitis (disorder)"
          },
          {
            "code" : "44216000",
            "display" : "Retained products of conception, following delivery with hemorrhage (disorder)"
          },
          {
            "code" : "44218004",
            "display" : "Implantation of cochlear electrode (procedure)"
          },
          {
            "code" : "44219007",
            "display" : "Pseudoexfoliation of lens capsule (disorder)"
          },
          {
            "code" : "44223004",
            "display" : "Premature rupture of membranes (disorder)"
          },
          {
            "code" : "44230005",
            "display" : "Brown Swiss cattle breed (organism)"
          },
          {
            "code" : "44241007",
            "display" : "Heart valve stenosis (disorder)"
          },
          {
            "code" : "44268007",
            "display" : "Retinoschisis (disorder)"
          },
          {
            "code" : "44276009",
            "display" : "Habitual promiscuity (finding)"
          },
          {
            "code" : "44279002",
            "display" : "Miliaria crystallina (disorder)"
          },
          {
            "code" : "44298000",
            "display" : "Lymph node abscess (disorder)"
          },
          {
            "code" : "44300000",
            "display" : "Entire vertebral column (body structure)"
          },
          {
            "code" : "44301001",
            "display" : "Suicide (event)"
          },
          {
            "code" : "44318002",
            "display" : "Posthitis (disorder)"
          },
          {
            "code" : "44323002",
            "display" : "Tuberculosis of kidney (disorder)"
          },
          {
            "code" : "44324008",
            "display" : "Hemodynamic measurements (procedure)"
          },
          {
            "code" : "44337006",
            "display" : "Incision of gallbladder (procedure)"
          },
          {
            "code" : "44376007",
            "display" : "Dissociative disorder (disorder)"
          },
          {
            "code" : "44378008",
            "display" : "Partial colectomy with anastomosis (procedure)"
          },
          {
            "code" : "44401000",
            "display" : "Tis category (finding)"
          },
          {
            "code" : "44402007",
            "display" : "Loss of teeth due to extraction (disorder)"
          },
          {
            "code" : "44412000",
            "display" : "Chronic gonococcal urethritis (disorder)"
          },
          {
            "code" : "44428005",
            "display" : "Cellulitis of buttock (disorder)"
          },
          {
            "code" : "44441009",
            "display" : "Flexible fiberoptic sigmoidoscopy (procedure)"
          },
          {
            "code" : "44455001",
            "display" : "Hypersomnia disorder related to a known organic factor (disorder)"
          },
          {
            "code" : "44460002",
            "display" : "Turks (ethnic group)"
          },
          {
            "code" : "44465007",
            "display" : "Sprain of ankle (disorder)"
          },
          {
            "code" : "44470000",
            "display" : "Haemophilus influenzae (organism)"
          },
          {
            "code" : "44488008",
            "display" : "Bismark brown R stain (substance)"
          },
          {
            "code" : "44491008",
            "display" : "Fluoroscopy (procedure)"
          },
          {
            "code" : "44523003",
            "display" : "Vocal attack, function (observable entity)"
          },
          {
            "code" : "44532001",
            "display" : "Effects of air pressure (disorder)"
          },
          {
            "code" : "44548000",
            "display" : "Hyperactive behavior (finding)"
          },
          {
            "code" : "44558001",
            "display" : "Repair of inguinal hernia (procedure)"
          },
          {
            "code" : "44564008",
            "display" : "Loss of voice (finding)"
          },
          {
            "code" : "44567001",
            "display" : "Tracheal structure (body structure)"
          },
          {
            "code" : "44568006",
            "display" : "Syphilitic interstitial keratitis (disorder)"
          },
          {
            "code" : "44578009",
            "display" : "Core needle biopsy of breast (procedure)"
          },
          {
            "code" : "44588005",
            "display" : "Iodine (substance)"
          },
          {
            "code" : "44598004",
            "display" : "Leiomyoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "44612009",
            "display" : "Structure of sternal angle (body structure)"
          },
          {
            "code" : "44627009",
            "display" : "Structure of outflow tract of right ventricle (body structure)"
          },
          {
            "code" : "44635007",
            "display" : "Fecal impaction (disorder)"
          },
          {
            "code" : "44651004",
            "display" : "Contraceptive use education (procedure)"
          },
          {
            "code" : "44653001",
            "display" : "Erysipelas (disorder)"
          },
          {
            "code" : "44666001",
            "display" : "Microcytic hypochromic anemia (disorder)"
          },
          {
            "code" : "44695005",
            "display" : "Paralysis (finding)"
          },
          {
            "code" : "44696006",
            "display" : "Beagle (organism)"
          },
          {
            "code" : "44714003",
            "display" : "Structure of upper lobe of left lung (body structure)"
          },
          {
            "code" : "44730006",
            "display" : "Uremia (disorder)"
          },
          {
            "code" : "44743006",
            "display" : "Gonococcal infection of joint (disorder)"
          },
          {
            "code" : "44756004",
            "display" : "C3 certainty (qualifier value)"
          },
          {
            "code" : "44760001",
            "display" : "Mycobacterium asiaticum (organism)"
          },
          {
            "code" : "44771000",
            "display" : "Microcalcifications of the breast (disorder)"
          },
          {
            "code" : "44772007",
            "display" : "Maternal obesity syndrome (disorder)"
          },
          {
            "code" : "44777001",
            "display" : "Creation of conduit between right ventricle and pulmonary artery (procedure)"
          },
          {
            "code" : "44788007",
            "display" : "Right pleura structure (body structure)"
          },
          {
            "code" : "44801007",
            "display" : "Contusion of hip (disorder)"
          },
          {
            "code" : "44808001",
            "display" : "Conduction disorder of the heart (disorder)"
          },
          {
            "code" : "44812007",
            "display" : "Inhalation anesthesia, machine system, closed, no rebreathing of primary agent (procedure)"
          },
          {
            "code" : "44830000",
            "display" : "Structure of lateral plantar artery (body structure)"
          },
          {
            "code" : "44835005",
            "display" : "Debouillet sheep (organism)"
          },
          {
            "code" : "44855006",
            "display" : "Tonkinese cat (organism)"
          },
          {
            "code" : "44865000",
            "display" : "Secondary polycythemia (disorder)"
          },
          {
            "code" : "44868003",
            "display" : "Acupuncture (procedure)"
          },
          {
            "code" : "44870007",
            "display" : "Misused drugs in past (finding)"
          },
          {
            "code" : "44882003",
            "display" : "Balanitis (disorder)"
          },
          {
            "code" : "44897000",
            "display" : "Mesenteric lymphadenitis (disorder)"
          },
          {
            "code" : "44909008",
            "display" : "Sympathetic trunk structure (body structure)"
          },
          {
            "code" : "44912006",
            "display" : "Clitoral erection (finding)"
          },
          {
            "code" : "44914007",
            "display" : "Upper limb lymph node structure (body structure)"
          },
          {
            "code" : "44946007",
            "display" : "Repair of umbilical hernia (procedure)"
          },
          {
            "code" : "44947003",
            "display" : "Structure of erector spinae muscle (body structure)"
          },
          {
            "code" : "44963006",
            "display" : "General diet for pregnancy and lactation (finding)"
          },
          {
            "code" : "44984001",
            "display" : "Structure of ulnar artery (body structure)"
          },
          {
            "code" : "45001002",
            "display" : "Bone matrix (substance)"
          },
          {
            "code" : "45007003",
            "display" : "Low blood pressure (disorder)"
          },
          {
            "code" : "45048000",
            "display" : "Neck structure (body structure)"
          },
          {
            "code" : "45058001",
            "display" : "Syphilis of pulmonary valve (disorder)"
          },
          {
            "code" : "45106005",
            "display" : "Congo red stain (substance)"
          },
          {
            "code" : "45154002",
            "display" : "Glycosuria (finding)"
          },
          {
            "code" : "45170000",
            "display" : "Encephalitis (disorder)"
          },
          {
            "code" : "45177002",
            "display" : "Swelling of structure of eye (finding)"
          },
          {
            "code" : "45181002",
            "display" : "Schmorl's nodes (disorder)"
          },
          {
            "code" : "45206002",
            "display" : "Nasal structure (body structure)"
          },
          {
            "code" : "45211000",
            "display" : "Catheterization (procedure)"
          },
          {
            "code" : "45215009",
            "display" : "Tantalum (substance)"
          },
          {
            "code" : "45224000",
            "display" : "Struck by missile (event)"
          },
          {
            "code" : "45227007",
            "display" : "Hypertrophic obstructive cardiomyopathy (disorder)"
          },
          {
            "code" : "45234009",
            "display" : "Structure of deciduous maxillary left first molar tooth (body structure)"
          },
          {
            "code" : "45261009",
            "display" : "Viral conjunctivitis (disorder)"
          },
          {
            "code" : "45281005",
            "display" : "Atherosclerosis of renal artery (disorder)"
          },
          {
            "code" : "45284002",
            "display" : "Maine Anjou cattle breed (organism)"
          },
          {
            "code" : "45289007",
            "display" : "Parotid gland structure (body structure)"
          },
          {
            "code" : "45292006",
            "display" : "Vulval structure (body structure)"
          },
          {
            "code" : "45316007",
            "display" : "Radionuclide localization of tumor (procedure)"
          },
          {
            "code" : "45326000",
            "display" : "Shoulder pain (finding)"
          },
          {
            "code" : "45330002",
            "display" : "Restoration, inlay, metallic (procedure)"
          },
          {
            "code" : "45341000",
            "display" : "Structure of trunk of pulmonary artery (body structure)"
          },
          {
            "code" : "45346005",
            "display" : "Alteration in nutrition: more than body requirements (finding)"
          },
          {
            "code" : "45352006",
            "display" : "Spasm (finding)"
          },
          {
            "code" : "45356009",
            "display" : "Closed fracture of one rib (disorder)"
          },
          {
            "code" : "45361006",
            "display" : "Imprisonment (finding)"
          },
          {
            "code" : "45369008",
            "display" : "Neurohypophyseal diabetes insipidus (disorder)"
          },
          {
            "code" : "45372001",
            "display" : "Insertion of pessary into vagina (procedure)"
          },
          {
            "code" : "45377007",
            "display" : "Acute gonococcal salpingitis (disorder)"
          },
          {
            "code" : "45404002",
            "display" : "Inkoo virus (organism)"
          },
          {
            "code" : "45460008",
            "display" : "Intrauterine transfusion (procedure)"
          },
          {
            "code" : "45465003",
            "display" : "Basques (ethnic group)"
          },
          {
            "code" : "45475000",
            "display" : "Indigo carmine stain (substance)"
          },
          {
            "code" : "45477008",
            "display" : "Exposed to vibration (event)"
          },
          {
            "code" : "45503006",
            "display" : "Common ventricle (disorder)"
          },
          {
            "code" : "45534005",
            "display" : "Glossitis (disorder)"
          },
          {
            "code" : "45559001",
            "display" : "Focal fibrosis (morphologic abnormality)"
          },
          {
            "code" : "45561005",
            "display" : "Black and tan coonhound (organism)"
          },
          {
            "code" : "45564002",
            "display" : "Achalasia of esophagus (disorder)"
          },
          {
            "code" : "45582004",
            "display" : "Rubinstein-Taybi syndrome (disorder)"
          },
          {
            "code" : "45591000",
            "display" : "Skin structure of intertragal incisure (body structure)"
          },
          {
            "code" : "45595009",
            "display" : "Laparoscopic cholecystectomy (procedure)"
          },
          {
            "code" : "45613006",
            "display" : "Contusion of lower leg (disorder)"
          },
          {
            "code" : "45618002",
            "display" : "Skilled nursing facility (environment)"
          },
          {
            "code" : "45625009",
            "display" : "Spaniel (organism)"
          },
          {
            "code" : "45626005",
            "display" : "Nontraumatic hemoperitoneum (disorder)"
          },
          {
            "code" : "45631007",
            "display" : "Structure of radial artery (body structure)"
          },
          {
            "code" : "45633005",
            "display" : "Peritoneal dialyzer, device (physical object)"
          },
          {
            "code" : "45635003",
            "display" : "FHC elite pig 1 (organism)"
          },
          {
            "code" : "45653009",
            "display" : "Structure of upper lobe of lung (body structure)"
          },
          {
            "code" : "45662006",
            "display" : "Mycobacterium terrae (organism)"
          },
          {
            "code" : "45681003",
            "display" : "Staging operation involving incision, exploration and biopsy (procedure)"
          },
          {
            "code" : "45688009",
            "display" : "Pars planitis (disorder)"
          },
          {
            "code" : "45690005",
            "display" : "Mouflon sheep (organism)"
          },
          {
            "code" : "45704003",
            "display" : "At risk for noncompliance (finding)"
          },
          {
            "code" : "45718005",
            "display" : "Vaginal delivery with forceps including postpartum care (procedure)"
          },
          {
            "code" : "45749000",
            "display" : "Vibrio alginolyticus (organism)"
          },
          {
            "code" : "45757002",
            "display" : "Labor problem (finding)"
          },
          {
            "code" : "45781009",
            "display" : "Peripheral nerve entrapment syndrome (disorder)"
          },
          {
            "code" : "45790002",
            "display" : "American Albino horse (organism)"
          },
          {
            "code" : "45793000",
            "display" : "Pineal structure (body structure)"
          },
          {
            "code" : "45795007",
            "display" : "Melanosis oculi (disorder)"
          },
          {
            "code" : "45804006",
            "display" : "Autonomous breathing, function (observable entity)"
          },
          {
            "code" : "45806008",
            "display" : "Reduction deformity of upper limb (disorder)"
          },
          {
            "code" : "45816000",
            "display" : "Pyelonephritis (disorder)"
          },
          {
            "code" : "45828008",
            "display" : "Anemia in mother complicating pregnancy, childbirth AND/OR puerperium (disorder)"
          },
          {
            "code" : "45838003",
            "display" : "Powassan virus (organism)"
          },
          {
            "code" : "45849009",
            "display" : "Technetium (99m-Tc) sodium glucoheptonate (substance)"
          },
          {
            "code" : "45861001",
            "display" : "Pes anserinus tendinitis (disorder)"
          },
          {
            "code" : "45899008",
            "display" : "Free-standing laboratory facility (environment)"
          },
          {
            "code" : "45913009",
            "display" : "Laryngitis (disorder)"
          },
          {
            "code" : "45921003",
            "display" : "Removal of cardiac pacemaker electrodes with replacement (procedure)"
          },
          {
            "code" : "45924006",
            "display" : "Necrophilia (disorder)"
          },
          {
            "code" : "45929001",
            "display" : "Half-brother (person)"
          },
          {
            "code" : "45939007",
            "display" : "Leg length inequality (disorder)"
          },
          {
            "code" : "45945004",
            "display" : "Mechanical complication due to breast prosthesis (disorder)"
          },
          {
            "code" : "45965006",
            "display" : "Implantation of automatic cardioverter/defibrillator, total system (procedure)"
          },
          {
            "code" : "45979003",
            "display" : "Abdominal wind pain (finding)"
          },
          {
            "code" : "45981001",
            "display" : "Skin structure of anterior surface of upper arm (body structure)"
          },
          {
            "code" : "45993005",
            "display" : "Cholecystectomy with exploration of common duct (procedure)"
          },
          {
            "code" : "45994004",
            "display" : "Erotic vomiting (disorder)"
          },
          {
            "code" : "46014006",
            "display" : "Corn of toe (disorder)"
          },
          {
            "code" : "46023009",
            "display" : "Pedophilia, same AND opposite sex (disorder)"
          },
          {
            "code" : "46027005",
            "display" : "Structure of common iliac vein (body structure)"
          },
          {
            "code" : "46030003",
            "display" : "Tricuspid valve structure (body structure)"
          },
          {
            "code" : "46053002",
            "display" : "Distal (qualifier value)"
          },
          {
            "code" : "46055009",
            "display" : "Structure of submental lymph node (body structure)"
          },
          {
            "code" : "46059003",
            "display" : "N2 category (finding)"
          },
          {
            "code" : "46085004",
            "display" : "Thrombosis of retinal vein (disorder)"
          },
          {
            "code" : "46090001",
            "display" : "Balanoposthitis (disorder)"
          },
          {
            "code" : "46109009",
            "display" : "Subendocardial ischemia (disorder)"
          },
          {
            "code" : "46110004",
            "display" : "Somalis (ethnic group)"
          },
          {
            "code" : "46113002",
            "display" : "Hypertensive heart failure (disorder)"
          },
          {
            "code" : "46116005",
            "display" : "Excision of malignant tumor of breast (procedure)"
          },
          {
            "code" : "46136006",
            "display" : "Electrocardiogram with exercise test (procedure)"
          },
          {
            "code" : "46139004",
            "display" : "Martius yellow stain (substance)"
          },
          {
            "code" : "46152009",
            "display" : "Tear film insufficiency (disorder)"
          },
          {
            "code" : "46157003",
            "display" : "Structure of appendicular lymph node (body structure)"
          },
          {
            "code" : "46177005",
            "display" : "End-stage renal disease (disorder)"
          },
          {
            "code" : "46206005",
            "display" : "Mood disorder (disorder)"
          },
          {
            "code" : "46207001",
            "display" : "Pneumonitis caused by acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "46210008",
            "display" : "Cyst of eyelid (disorder)"
          },
          {
            "code" : "46212000",
            "display" : "Juvenile fibroadenoma (morphologic abnormality)"
          },
          {
            "code" : "46224007",
            "display" : "Vaccination clinic (environment)"
          },
          {
            "code" : "46229002",
            "display" : "Severe mixed bipolar I disorder without psychotic features (disorder)"
          },
          {
            "code" : "46239008",
            "display" : "Komondor dog (organism)"
          },
          {
            "code" : "46244001",
            "display" : "Recurrent major depression in full remission (disorder)"
          },
          {
            "code" : "46249006",
            "display" : "Artificial insemination, heterologous (procedure)"
          },
          {
            "code" : "46255001",
            "display" : "Pharmacist (occupation)"
          },
          {
            "code" : "46319007",
            "display" : "Right bundle branch block AND left posterior fascicular block (disorder)"
          },
          {
            "code" : "46353006",
            "display" : "Structure of mucous membrane of lower lip (body structure)"
          },
          {
            "code" : "46385009",
            "display" : "Glenoid structure (body structure)"
          },
          {
            "code" : "46392004",
            "display" : "Delaine merino sheep (organism)"
          },
          {
            "code" : "46408008",
            "display" : "American pony (organism)"
          },
          {
            "code" : "46422008",
            "display" : "Closed fracture of shaft of metacarpal bone (disorder)"
          },
          {
            "code" : "46464008",
            "display" : "Enterococcus durans (organism)"
          },
          {
            "code" : "46466005",
            "display" : "Genus Bordetella (organism)"
          },
          {
            "code" : "46481004",
            "display" : "Low-renin essential hypertension (disorder)"
          },
          {
            "code" : "46500003",
            "display" : "Dryness of vulva (disorder)"
          },
          {
            "code" : "46522005",
            "display" : "Fruit exchange list (finding)"
          },
          {
            "code" : "46557008",
            "display" : "Disorder of hard tissues of teeth (disorder)"
          },
          {
            "code" : "46576005",
            "display" : "Product containing flecainide (medicinal product)"
          },
          {
            "code" : "46578006",
            "display" : "Lumbosacral radiculitis (disorder)"
          },
          {
            "code" : "46602004",
            "display" : "Electron (substance)"
          },
          {
            "code" : "46619002",
            "display" : "Congenital heart block (disorder)"
          },
          {
            "code" : "46621007",
            "display" : "Atelectasis (disorder)"
          },
          {
            "code" : "46635009",
            "display" : "Diabetes mellitus type 1 (disorder)"
          },
          {
            "code" : "46651001",
            "display" : "Isolated (qualifier value)"
          },
          {
            "code" : "46659004",
            "display" : "Von Hippel-Lindau syndrome (disorder)"
          },
          {
            "code" : "46662001",
            "display" : "Examination of breast (procedure)"
          },
          {
            "code" : "46665004",
            "display" : "Cryptosporidium meleagridis (organism)"
          },
          {
            "code" : "46674002",
            "display" : "Nondiabetic proliferative retinopathy (disorder)"
          },
          {
            "code" : "46677009",
            "display" : "Gleason grade score 3 out of 10 (finding)"
          },
          {
            "code" : "46681009",
            "display" : "Cerclage of cervix during pregnancy by abdominal approach (procedure)"
          },
          {
            "code" : "46689006",
            "display" : "Hypertrophy of tonsils (disorder)"
          },
          {
            "code" : "46699001",
            "display" : "Bursitis caused by Neisseria gonorrhoeae (disorder)"
          },
          {
            "code" : "46701001",
            "display" : "Acute myocarditis (disorder)"
          },
          {
            "code" : "46706006",
            "display" : "Replacement of contraceptive intrauterine device (procedure)"
          },
          {
            "code" : "46713006",
            "display" : "Nasal route (qualifier value)"
          },
          {
            "code" : "46716003",
            "display" : "Microalbuminuria measurement (procedure)"
          },
          {
            "code" : "46720004",
            "display" : "Lipoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "46722007",
            "display" : "Congenital anomaly of pleural folds (disorder)"
          },
          {
            "code" : "46723002",
            "display" : "Badagas (ethnic group)"
          },
          {
            "code" : "46725009",
            "display" : "Pembroke Welsh corgi (organism)"
          },
          {
            "code" : "46742003",
            "display" : "Skin ulcer (disorder)"
          },
          {
            "code" : "46750007",
            "display" : "Structure of hilum of lung (body structure)"
          },
          {
            "code" : "46752004",
            "display" : "Torus palatinus (disorder)"
          },
          {
            "code" : "46764007",
            "display" : "Severe pre-eclampsia (disorder)"
          },
          {
            "code" : "46775006",
            "display" : "Respiratory distress syndrome in the newborn (disorder)"
          },
          {
            "code" : "46785007",
            "display" : "Familial juvenile gout (disorder)"
          },
          {
            "code" : "46795000",
            "display" : "Actinic cheilitis (disorder)"
          },
          {
            "code" : "46799006",
            "display" : "Dysenteric diarrhea (disorder)"
          },
          {
            "code" : "46802002",
            "display" : "Smokers' cough (disorder)"
          },
          {
            "code" : "46825001",
            "display" : "Electrocardiographic monitoring (procedure)"
          },
          {
            "code" : "46851004",
            "display" : "Contact with plants (event)"
          },
          {
            "code" : "46862004",
            "display" : "Buttock structure (body structure)"
          },
          {
            "code" : "46866001",
            "display" : "Fracture of lower limb (disorder)"
          },
          {
            "code" : "46869008",
            "display" : "Pressure ulcer prevention education (procedure)"
          },
          {
            "code" : "46876003",
            "display" : "Cellulitis of trunk (disorder)"
          },
          {
            "code" : "46894009",
            "display" : "Gestational diabetes mellitus, class A>2< (disorder)"
          },
          {
            "code" : "46903006",
            "display" : "Hydrotherapy (regime/therapy)"
          },
          {
            "code" : "46917002",
            "display" : "Anterior asynclitism (finding)"
          },
          {
            "code" : "46964002",
            "display" : "Diversional therapy (regime/therapy)"
          },
          {
            "code" : "46970008",
            "display" : "Pneumonia caused by Mycoplasma pneumoniae (disorder)"
          },
          {
            "code" : "46973005",
            "display" : "Blood pressure taking (procedure)"
          },
          {
            "code" : "46975003",
            "display" : "Cocaine-induced organic mental disorder (disorder)"
          },
          {
            "code" : "47016003",
            "display" : "Hyperalimentation formula for pancreatitis (finding)"
          },
          {
            "code" : "47020004",
            "display" : "Ventriculoperitoneal shunt (procedure)"
          },
          {
            "code" : "47028006",
            "display" : "Congenital hiatus hernia (disorder)"
          },
          {
            "code" : "47030008",
            "display" : "Insoluble berlin blue stain (substance)"
          },
          {
            "code" : "47032000",
            "display" : "Congenital hydrocephalus (disorder)"
          },
          {
            "code" : "47040006",
            "display" : "Disorder of aorta (disorder)"
          },
          {
            "code" : "47055002",
            "display" : "Structure of mandibular right canine tooth (body structure)"
          },
          {
            "code" : "47075006",
            "display" : "Doberman pinscher (organism)"
          },
          {
            "code" : "47079000",
            "display" : "Ultrasonography of breast (procedure)"
          },
          {
            "code" : "47099006",
            "display" : "Irregular astigmatism (disorder)"
          },
          {
            "code" : "47100003",
            "display" : "Anemia of prematurity (disorder)"
          },
          {
            "code" : "47109002",
            "display" : "Structure of lymph node of thorax (body structure)"
          },
          {
            "code" : "47147007",
            "display" : "Congenital anomaly of lung (disorder)"
          },
          {
            "code" : "47188007",
            "display" : "Injection of anesthetic substance, therapeutic, subarachnoid, continuous (procedure)"
          },
          {
            "code" : "47192000",
            "display" : "Meglumine amidotrizoate (substance)"
          },
          {
            "code" : "47197006",
            "display" : "Autopsy, gross examination with brain and spinal cord (procedure)"
          },
          {
            "code" : "47200007",
            "display" : "High risk pregnancy (finding)"
          },
          {
            "code" : "47222000",
            "display" : "Friction injury of tooth (disorder)"
          },
          {
            "code" : "47224004",
            "display" : "Skin of posterior surface of lower leg (body structure)"
          },
          {
            "code" : "47235009",
            "display" : "Contact with power tool (event)"
          },
          {
            "code" : "47250000",
            "display" : "Bruneians (ethnic group)"
          },
          {
            "code" : "47252008",
            "display" : "Alteration in patterns of urinary elimination (finding)"
          },
          {
            "code" : "47270006",
            "display" : "Hypercortisolism (disorder)"
          },
          {
            "code" : "47284001",
            "display" : "Aggressive fibromatosis (morphologic abnormality)"
          },
          {
            "code" : "47295007",
            "display" : "Psychomotor agitation (finding)"
          },
          {
            "code" : "47307007",
            "display" : "Factor VIII inhibitor disorder (disorder)"
          },
          {
            "code" : "47327008",
            "display" : "Mexican Indians (ethnic group)"
          },
          {
            "code" : "47372000",
            "display" : "Adjustment disorder with anxious mood (disorder)"
          },
          {
            "code" : "47374004",
            "display" : "Tarsal tunnel syndrome (disorder)"
          },
          {
            "code" : "47382004",
            "display" : "Dermatophytosis (disorder)"
          },
          {
            "code" : "47398006",
            "display" : "Marginal corneal ulcer (disorder)"
          },
          {
            "code" : "47411002",
            "display" : "Implantation of penile prosthesis (procedure)"
          },
          {
            "code" : "47429007",
            "display" : "Associated with (attribute)"
          },
          {
            "code" : "47432005",
            "display" : "Implantation of heart valve prosthesis or synthetic device (procedure)"
          },
          {
            "code" : "47435007",
            "display" : "Administration of vaccine product containing only Measles morbillivirus antigen (procedure)"
          },
          {
            "code" : "47451004",
            "display" : "Administration of electrolytes (procedure)"
          },
          {
            "code" : "47465002",
            "display" : "Vesicular stomatitis New Jersey virus (organism)"
          },
          {
            "code" : "47471008",
            "display" : "Popliteal lymph node structure (body structure)"
          },
          {
            "code" : "47486002",
            "display" : "Fast red ITR stain (substance)"
          },
          {
            "code" : "47488001",
            "display" : "Intracystic papillary adenoma (morphologic abnormality)"
          },
          {
            "code" : "47505003",
            "display" : "Posttraumatic stress disorder (disorder)"
          },
          {
            "code" : "47525004",
            "display" : "Coarse respiratory crackles (finding)"
          },
          {
            "code" : "47534009",
            "display" : "Decompression of median nerve (procedure)"
          },
          {
            "code" : "47542005",
            "display" : "Petit Basset Griffon Vendéen dog (organism)"
          },
          {
            "code" : "47546008",
            "display" : "Warfarin overdosage (disorder)"
          },
          {
            "code" : "47563007",
            "display" : "Nutritional deficiency (finding)"
          },
          {
            "code" : "47588004",
            "display" : "Lead-203 (substance)"
          },
          {
            "code" : "47604008",
            "display" : "Miliary tuberculosis (disorder)"
          },
          {
            "code" : "47609003",
            "display" : "Foreign body in esophagus (disorder)"
          },
          {
            "code" : "47625008",
            "display" : "Intravenous route (qualifier value)"
          },
          {
            "code" : "47631006",
            "display" : "Adventitial degeneration (morphologic abnormality)"
          },
          {
            "code" : "47639008",
            "display" : "Pilonidal cyst (disorder)"
          },
          {
            "code" : "47659007",
            "display" : "Basenji (organism)"
          },
          {
            "code" : "47686007",
            "display" : "Incomplete bilateral cleft palate (disorder)"
          },
          {
            "code" : "47693006",
            "display" : "Rupture of appendix (disorder)"
          },
          {
            "code" : "47695004",
            "display" : "Inability to cope (finding)"
          },
          {
            "code" : "47699005",
            "display" : "Soft-coated wheaten terrier (organism)"
          },
          {
            "code" : "47703008",
            "display" : "Lactose (substance)"
          },
          {
            "code" : "47717004",
            "display" : "Abnormal deglutition (finding)"
          },
          {
            "code" : "47728000",
            "display" : "Bone structure of shaft of radius (body structure)"
          },
          {
            "code" : "47729008",
            "display" : "Potassium (K-43) chloride (substance)"
          },
          {
            "code" : "47795006",
            "display" : "FHC elite pig 4 (organism)"
          },
          {
            "code" : "47812002",
            "display" : "Functional diarrhea (disorder)"
          },
          {
            "code" : "47821001",
            "display" : "Postpartum hemorrhage (disorder)"
          },
          {
            "code" : "47841006",
            "display" : "Chronic nasopharyngitis (disorder)"
          },
          {
            "code" : "47842004",
            "display" : "Canadian horse (organism)"
          },
          {
            "code" : "47847005",
            "display" : "Autopsy, gross examination, limited, regional (procedure)"
          },
          {
            "code" : "47898004",
            "display" : "Product containing verapamil (medicinal product)"
          },
          {
            "code" : "47903000",
            "display" : "Vitamin B deficiency (disorder)"
          },
          {
            "code" : "47933007",
            "display" : "Foot pain (finding)"
          },
          {
            "code" : "47944004",
            "display" : "Malocclusion of teeth (disorder)"
          },
          {
            "code" : "47949009",
            "display" : "Normal libido (finding)"
          },
          {
            "code" : "47962008",
            "display" : "Structure of myocardium of apex of heart (body structure)"
          },
          {
            "code" : "47975008",
            "display" : "Structure of root of tongue (body structure)"
          },
          {
            "code" : "47985009",
            "display" : "Structure of celiac lymph node (body structure)"
          },
          {
            "code" : "47995002",
            "display" : "Alcohol soluble nigrosine stain (substance)"
          },
          {
            "code" : "48014002",
            "display" : "Skin structure of perineum (body structure)"
          },
          {
            "code" : "48015001",
            "display" : "Fall through window (event)"
          },
          {
            "code" : "48023004",
            "display" : "Breast self-examination technique education (procedure)"
          },
          {
            "code" : "48046002",
            "display" : "Symptomatic sexual masochism (disorder)"
          },
          {
            "code" : "48079002",
            "display" : "Disturbance in mood (finding)"
          },
          {
            "code" : "48118002",
            "display" : "Yapese (ethnic group)"
          },
          {
            "code" : "48123002",
            "display" : "Contusion of wrist (disorder)"
          },
          {
            "code" : "48130008",
            "display" : "Hypogonadism (disorder)"
          },
          {
            "code" : "48134004",
            "display" : "Mycobacterium aurum (organism)"
          },
          {
            "code" : "48145001",
            "display" : "Obstruction of Eustachian tube (disorder)"
          },
          {
            "code" : "48146000",
            "display" : "Diastolic hypertension (disorder)"
          },
          {
            "code" : "48167000",
            "display" : "Amnesia (finding)"
          },
          {
            "code" : "48188009",
            "display" : "Azoospermia (finding)"
          },
          {
            "code" : "48194001",
            "display" : "Pregnancy-induced hypertension (disorder)"
          },
          {
            "code" : "48204000",
            "display" : "Spontaneous unassisted delivery, medical personnel present (procedure)"
          },
          {
            "code" : "48210000",
            "display" : "Lumbosacral spondylosis without myelopathy (disorder)"
          },
          {
            "code" : "48230001",
            "display" : "First degree uterine prolapse (disorder)"
          },
          {
            "code" : "48245008",
            "display" : "Bacterial arthritis (disorder)"
          },
          {
            "code" : "48247000",
            "display" : "Postcoital period (finding)"
          },
          {
            "code" : "48263008",
            "display" : "Eating (observable entity)"
          },
          {
            "code" : "48273005",
            "display" : "Aneurysm of popliteal artery (disorder)"
          },
          {
            "code" : "48277006",
            "display" : "Impetigo (disorder)"
          },
          {
            "code" : "48294008",
            "display" : "Solomon Islanders (ethnic group)"
          },
          {
            "code" : "48309007",
            "display" : "Pedophilia, nonexclusive type (disorder)"
          },
          {
            "code" : "48311003",
            "display" : "Veteran's administration hospital (environment)"
          },
          {
            "code" : "48317004",
            "display" : "Brucella suis (organism)"
          },
          {
            "code" : "48325002",
            "display" : "Hyperalimentation formula for peritonitis (finding)"
          },
          {
            "code" : "48334007",
            "display" : "Congenital dislocation of hip (disorder)"
          },
          {
            "code" : "48338005",
            "display" : "Structure of right colic flexure (body structure)"
          },
          {
            "code" : "48340000",
            "display" : "Incontinence (finding)"
          },
          {
            "code" : "48341001",
            "display" : "Iridium-192 (substance)"
          },
          {
            "code" : "48345005",
            "display" : "Superior vena cava structure (body structure)"
          },
          {
            "code" : "48367006",
            "display" : "Structure of urinary bladder cavity (body structure)"
          },
          {
            "code" : "48375000",
            "display" : "Seminole (ethnic group)"
          },
          {
            "code" : "48387007",
            "display" : "Incision of trachea (procedure)"
          },
          {
            "code" : "48394005",
            "display" : "Beltsville pig (organism)"
          },
          {
            "code" : "48402004",
            "display" : "Structure of mandibular left second molar tooth (body structure)"
          },
          {
            "code" : "48409008",
            "display" : "Respiratory crackles (finding)"
          },
          {
            "code" : "48428001",
            "display" : "Cardiovascular monitoring (regime/therapy)"
          },
          {
            "code" : "48434008",
            "display" : "Atheroma (morphologic abnormality)"
          },
          {
            "code" : "48440001",
            "display" : "Arthritis due to gout (disorder)"
          },
          {
            "code" : "48469005",
            "display" : "Cytologic material (specimen)"
          },
          {
            "code" : "48470006",
            "display" : "Boar power pig 656 (organism)"
          },
          {
            "code" : "48475001",
            "display" : "Disorder of diaphragm (disorder)"
          },
          {
            "code" : "48477009",
            "display" : "Lip structure (body structure)"
          },
          {
            "code" : "48499001",
            "display" : "Increased body mass index (finding)"
          },
          {
            "code" : "48500005",
            "display" : "Delusional disorder (disorder)"
          },
          {
            "code" : "48501009",
            "display" : "Alteration in nutrition: potential for more than body requirements (finding)"
          },
          {
            "code" : "48522003",
            "display" : "Spinal cord disorder (disorder)"
          },
          {
            "code" : "48524002",
            "display" : "Mastiff dog (organism)"
          },
          {
            "code" : "48531003",
            "display" : "Achalasia (finding)"
          },
          {
            "code" : "48532005",
            "display" : "Muscle strain (disorder)"
          },
          {
            "code" : "48540004",
            "display" : "Patent blue V sodium salt stain (substance)"
          },
          {
            "code" : "48544008",
            "display" : "Structure of right lower quadrant of abdomen (body structure)"
          },
          {
            "code" : "48552006",
            "display" : "Hypertension secondary to renal disease complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "48603004",
            "display" : "Product containing warfarin (medicinal product)"
          },
          {
            "code" : "48606007",
            "display" : "Drug resistance to insulin (disorder)"
          },
          {
            "code" : "48611009",
            "display" : "Darier disease (disorder)"
          },
          {
            "code" : "48631008",
            "display" : "Pyonephrosis (disorder)"
          },
          {
            "code" : "48661000",
            "display" : "Peritonitis (disorder)"
          },
          {
            "code" : "48679001",
            "display" : "Bogobos (ethnic group)"
          },
          {
            "code" : "48694002",
            "display" : "Anxiety (finding)"
          },
          {
            "code" : "48697009",
            "display" : "Clun Forest sheep (organism)"
          },
          {
            "code" : "48698004",
            "display" : "Product containing calcium channel blocker (product)"
          },
          {
            "code" : "48702000",
            "display" : "Limousin cattle breed (organism)"
          },
          {
            "code" : "48713002",
            "display" : "Amyloid nephropathy (disorder)"
          },
          {
            "code" : "48721008",
            "display" : "Quadriplegic cerebral palsy (disorder)"
          },
          {
            "code" : "48723006",
            "display" : "Male hypogonadism (disorder)"
          },
          {
            "code" : "48724000",
            "display" : "Mitral valve regurgitation (disorder)"
          },
          {
            "code" : "48761009",
            "display" : "Motor behavior (observable entity)"
          },
          {
            "code" : "48782003",
            "display" : "Delivery normal (finding)"
          },
          {
            "code" : "48796009",
            "display" : "Congenital nephrotic syndrome (disorder)"
          },
          {
            "code" : "48813009",
            "display" : "Lymphocytopenia (disorder)"
          },
          {
            "code" : "48835001",
            "display" : "Esophagogastric fundoplasty (procedure)"
          },
          {
            "code" : "48851009",
            "display" : "Impaired tissue integrity (finding)"
          },
          {
            "code" : "48867003",
            "display" : "Bradycardia (finding)"
          },
          {
            "code" : "48880000",
            "display" : "Postcoital bleeding (finding)"
          },
          {
            "code" : "48895003",
            "display" : "Indium-113m (substance)"
          },
          {
            "code" : "48906005",
            "display" : "Breech presentation, double footling (finding)"
          },
          {
            "code" : "48918001",
            "display" : "Structure of facial lymph node (body structure)"
          },
          {
            "code" : "48926009",
            "display" : "Pain in spine (finding)"
          },
          {
            "code" : "48947008",
            "display" : "Abnormal tooth attrition (finding)"
          },
          {
            "code" : "48988008",
            "display" : "Alprostadil (substance)"
          },
          {
            "code" : "49011004",
            "display" : "Internal injury of abdominal organ (disorder)"
          },
          {
            "code" : "49049000",
            "display" : "Parkinson's disease (disorder)"
          },
          {
            "code" : "49076000",
            "display" : "Knee joint structure (body structure)"
          },
          {
            "code" : "49082002",
            "display" : "Structure of small cardiac vein (body structure)"
          },
          {
            "code" : "49084001",
            "display" : "Dermatitis caused by radiation (disorder)"
          },
          {
            "code" : "49120005",
            "display" : "Retroperitoneal fibrosis (disorder)"
          },
          {
            "code" : "49130001",
            "display" : "Disorder of external ear (disorder)"
          },
          {
            "code" : "49139000",
            "display" : "70 gram fat diet (finding)"
          },
          {
            "code" : "49168004",
            "display" : "Complete breech presentation (finding)"
          },
          {
            "code" : "49176002",
            "display" : "Arteriosclerotic gangrene (disorder)"
          },
          {
            "code" : "49198006",
            "display" : "Torsion of spermatic cord (disorder)"
          },
          {
            "code" : "49202008",
            "display" : "Gilbertese (ethnic group)"
          },
          {
            "code" : "49209004",
            "display" : "Subtotal gastrectomy (procedure)"
          },
          {
            "code" : "49215004",
            "display" : "Struck by building collapse (event)"
          },
          {
            "code" : "49218002",
            "display" : "Hip pain (finding)"
          },
          {
            "code" : "49220004",
            "display" : "Hypertensive renal failure (disorder)"
          },
          {
            "code" : "49226005",
            "display" : "Brachymetapody (disorder)"
          },
          {
            "code" : "49232000",
            "display" : "Chronic peptic ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "49240006",
            "display" : "Palouse pig (organism)"
          },
          {
            "code" : "49252004",
            "display" : "Otitic barotrauma (disorder)"
          },
          {
            "code" : "49263001",
            "display" : "Spermatocele (disorder)"
          },
          {
            "code" : "49330006",
            "display" : "Structure of deciduous mandibular left second molar tooth (body structure)"
          },
          {
            "code" : "49346003",
            "display" : "Closed fracture of orbital floor (blow-out) (disorder)"
          },
          {
            "code" : "49359006",
            "display" : "Brother-brother sex play (finding)"
          },
          {
            "code" : "49370004",
            "display" : "Lateral (qualifier value)"
          },
          {
            "code" : "49388007",
            "display" : "Sprain of foot (disorder)"
          },
          {
            "code" : "49394004",
            "display" : "Structure of superior mesenteric lymph node (body structure)"
          },
          {
            "code" : "49408009",
            "display" : "Male sterility (finding)"
          },
          {
            "code" : "49421002",
            "display" : "Welsh terrier (organism)"
          },
          {
            "code" : "49430005",
            "display" : "Liposarcoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "49436004",
            "display" : "Atrial fibrillation (disorder)"
          },
          {
            "code" : "49445003",
            "display" : "Genus Hantavirus (organism)"
          },
          {
            "code" : "49453006",
            "display" : "Cerebral herniation (disorder)"
          },
          {
            "code" : "49455004",
            "display" : "Polyneuropathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "49460000",
            "display" : "Soft palate structure (body structure)"
          },
          {
            "code" : "49462008",
            "display" : "FHC elite pig 6 (organism)"
          },
          {
            "code" : "49468007",
            "display" : "Depressed bipolar I disorder (disorder)"
          },
          {
            "code" : "49472006",
            "display" : "Megaloblastic anemia due to vitamin B>12< deficiency (disorder)"
          },
          {
            "code" : "49496001",
            "display" : "Double ureter (disorder)"
          },
          {
            "code" : "49509003",
            "display" : "Operation on lymphatic structure (procedure)"
          },
          {
            "code" : "49512000",
            "display" : "Depressed bipolar I disorder in partial remission (disorder)"
          },
          {
            "code" : "49526009",
            "display" : "Presbycusis (disorder)"
          },
          {
            "code" : "49530007",
            "display" : "Afferent (qualifier value)"
          },
          {
            "code" : "49534003",
            "display" : "Congenital atresia of ureter (disorder)"
          },
          {
            "code" : "49561003",
            "display" : "Rupture of gravid uterus before onset of labor (disorder)"
          },
          {
            "code" : "49563000",
            "display" : "Periorbital edema (disorder)"
          },
          {
            "code" : "49564006",
            "display" : "Panic disorder with agoraphobia, mild agoraphobic avoidance AND moderate panic attacks (disorder)"
          },
          {
            "code" : "49567004",
            "display" : "Coitus intramenstrous (finding)"
          },
          {
            "code" : "49584005",
            "display" : "Acute cor pulmonale (disorder)"
          },
          {
            "code" : "49601007",
            "display" : "Disorder of cardiovascular system (disorder)"
          },
          {
            "code" : "49608001",
            "display" : "Irregular (qualifier value)"
          },
          {
            "code" : "49650001",
            "display" : "Dysuria (finding)"
          },
          {
            "code" : "49687009",
            "display" : "Coriphosphine stain (substance)"
          },
          {
            "code" : "49699002",
            "display" : "Rheumatic disease of tricuspid valve (disorder)"
          },
          {
            "code" : "49703004",
            "display" : "Coitus reservatus (finding)"
          },
          {
            "code" : "49706007",
            "display" : "Neonatal acne (disorder)"
          },
          {
            "code" : "49708008",
            "display" : "Anemia of chronic renal failure (disorder)"
          },
          {
            "code" : "49710005",
            "display" : "Sinus bradycardia (disorder)"
          },
          {
            "code" : "49723003",
            "display" : "Intussusception of intestine (disorder)"
          },
          {
            "code" : "49727002",
            "display" : "Cough (finding)"
          },
          {
            "code" : "49730009",
            "display" : "Post-operative follow-up, anesthesia (procedure)"
          },
          {
            "code" : "49746001",
            "display" : "Engorgement of breasts (finding)"
          },
          {
            "code" : "49755003",
            "display" : "Morphologically abnormal structure (morphologic abnormality)"
          },
          {
            "code" : "49765009",
            "display" : "Hyperpigmentation of skin (disorder)"
          },
          {
            "code" : "49795001",
            "display" : "Total pneumonectomy (procedure)"
          },
          {
            "code" : "49808004",
            "display" : "Old-age (finding)"
          },
          {
            "code" : "49841001",
            "display" : "Third ventricle structure (body structure)"
          },
          {
            "code" : "49848007",
            "display" : "Structure of myocardium of left ventricle (body structure)"
          },
          {
            "code" : "49852007",
            "display" : "Structure of median cubital vein (body structure)"
          },
          {
            "code" : "49872002",
            "display" : "Virus (organism)"
          },
          {
            "code" : "49878003",
            "display" : "Gleason grade score 2 out of 10 (finding)"
          },
          {
            "code" : "49882001",
            "display" : "Viral exanthem (disorder)"
          },
          {
            "code" : "49883006",
            "display" : "Candidiasis of skin (disorder)"
          },
          {
            "code" : "49915006",
            "display" : "Tricuspid valve stenosis (disorder)"
          },
          {
            "code" : "49916007",
            "display" : "Chronic duodenal ulcer with perforation (disorder)"
          },
          {
            "code" : "49918008",
            "display" : "Plasmodium knowlesi (organism)"
          },
          {
            "code" : "49919000",
            "display" : "Home safety education (procedure)"
          },
          {
            "code" : "49923008",
            "display" : "Syphilis of tendon (disorder)"
          },
          {
            "code" : "49978002",
            "display" : "Preparation of written report for lawyer (procedure)"
          },
          {
            "code" : "49998007",
            "display" : "Sufentanil (substance)"
          },
          {
            "code" : "50016007",
            "display" : "Structure of costal cartilage (body structure)"
          },
          {
            "code" : "50026000",
            "display" : "Psychoactive substance-induced organic anxiety disorder (disorder)"
          },
          {
            "code" : "50043002",
            "display" : "Disorder of respiratory system (disorder)"
          },
          {
            "code" : "50048006",
            "display" : "At risk for deficient fluid volume (finding)"
          },
          {
            "code" : "50049003",
            "display" : "Urostomy management and care (regime/therapy)"
          },
          {
            "code" : "50062004",
            "display" : "Fuchsin basic stain (substance)"
          },
          {
            "code" : "50063009",
            "display" : "Femoral hernia (disorder)"
          },
          {
            "code" : "50084004",
            "display" : "Battery (event)"
          },
          {
            "code" : "50112006",
            "display" : "Retrograde ejaculation (finding)"
          },
          {
            "code" : "50121007",
            "display" : "Eye glasses, device (physical object)"
          },
          {
            "code" : "50125003",
            "display" : "Shetland sheepdog (organism)"
          },
          {
            "code" : "50127006",
            "display" : "Tibialis tendinitis (disorder)"
          },
          {
            "code" : "50136005",
            "display" : "Salmonella Typhimurium (organism)"
          },
          {
            "code" : "50172003",
            "display" : "Lumbar spinal fusion (procedure)"
          },
          {
            "code" : "50177009",
            "display" : "Body temperature above reference range (finding)"
          },
          {
            "code" : "50193000",
            "display" : "Intermediate external iliac lymph node (body structure)"
          },
          {
            "code" : "50216001",
            "display" : "Replacement of mitral valve with tissue graft (procedure)"
          },
          {
            "code" : "50219008",
            "display" : "Hoarse (finding)"
          },
          {
            "code" : "50228009",
            "display" : "Contusion of ear (disorder)"
          },
          {
            "code" : "50239007",
            "display" : "Wandering (finding)"
          },
          {
            "code" : "50255000",
            "display" : "Genus Francisella (organism)"
          },
          {
            "code" : "50269000",
            "display" : "Staphylococcus aureus ss. anaerobius (organism)"
          },
          {
            "code" : "50299009",
            "display" : "Paraphilia (disorder)"
          },
          {
            "code" : "50318003",
            "display" : "Product containing progesterone (medicinal product)"
          },
          {
            "code" : "50325005",
            "display" : "Alcoholic fatty liver (disorder)"
          },
          {
            "code" : "50333006",
            "display" : "Autopsy, gross examination, macerated stillborn (procedure)"
          },
          {
            "code" : "50360004",
            "display" : "Reading (observable entity)"
          },
          {
            "code" : "50384007",
            "display" : "Mumps virus (organism)"
          },
          {
            "code" : "50397009",
            "display" : "Closed fracture of distal end of ulna (disorder)"
          },
          {
            "code" : "50405005",
            "display" : "Senoi (ethnic group)"
          },
          {
            "code" : "50408007",
            "display" : "Structure of left pulmonary artery (body structure)"
          },
          {
            "code" : "50415004",
            "display" : "Moderate pain (finding)"
          },
          {
            "code" : "50417007",
            "display" : "Lower respiratory tract infection (disorder)"
          },
          {
            "code" : "50438001",
            "display" : "Peripheral vertigo (disorder)"
          },
          {
            "code" : "50441005",
            "display" : "Turkish angora cat (organism)"
          },
          {
            "code" : "50442003",
            "display" : "Palindromic rheumatism (disorder)"
          },
          {
            "code" : "50445001",
            "display" : "Mastoidectomy (procedure)"
          },
          {
            "code" : "50448004",
            "display" : "Fracture of vertebral column (disorder)"
          },
          {
            "code" : "50465008",
            "display" : "Hernia repair (procedure)"
          },
          {
            "code" : "50471002",
            "display" : "Zika virus (organism)"
          },
          {
            "code" : "50485007",
            "display" : "Low tension glaucoma (disorder)"
          },
          {
            "code" : "50490005",
            "display" : "Hypertensive encephalopathy (disorder)"
          },
          {
            "code" : "50519007",
            "display" : "Structure of right upper quadrant of abdomen (body structure)"
          },
          {
            "code" : "50528008",
            "display" : "Syphilis of bone (disorder)"
          },
          {
            "code" : "50536004",
            "display" : "Structure of umbilical artery (body structure)"
          },
          {
            "code" : "50563003",
            "display" : "Seborrheic dermatitis (disorder)"
          },
          {
            "code" : "50570003",
            "display" : "Aneurysm of coronary vessels (disorder)"
          },
          {
            "code" : "50581000",
            "display" : "Goodpasture's syndrome (disorder)"
          },
          {
            "code" : "50582007",
            "display" : "Hemiplegia (disorder)"
          },
          {
            "code" : "50583002",
            "display" : "Administration of vaccine product containing only Mumps orthorubulavirus antigen (procedure)"
          },
          {
            "code" : "50590007",
            "display" : "Trephine biopsy (procedure)"
          },
          {
            "code" : "50607009",
            "display" : "Singular (qualifier value)"
          },
          {
            "code" : "50620007",
            "display" : "Autonomic neuropathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "50633001",
            "display" : "Normal female sexual function (finding)"
          },
          {
            "code" : "50672002",
            "display" : "Hafnium (substance)"
          },
          {
            "code" : "50676004",
            "display" : "Implantation of cochlear prosthetic device, multiple channels (procedure)"
          },
          {
            "code" : "50697003",
            "display" : "General anesthesia (procedure)"
          },
          {
            "code" : "50711007",
            "display" : "Viral hepatitis type C (disorder)"
          },
          {
            "code" : "50715003",
            "display" : "Pure red cell aplasia (disorder)"
          },
          {
            "code" : "50717006",
            "display" : "Cheviot sheep (organism)"
          },
          {
            "code" : "50723001",
            "display" : "Blood pressure taking education (procedure)"
          },
          {
            "code" : "50755001",
            "display" : "Structure of scalenus anterior muscle (body structure)"
          },
          {
            "code" : "50792001",
            "display" : "Corneal erosion (disorder)"
          },
          {
            "code" : "50793006",
            "display" : "Crushing injury of hand (disorder)"
          },
          {
            "code" : "50807007",
            "display" : "Femoral-popliteal artery bypass graft with vein (procedure)"
          },
          {
            "code" : "50808002",
            "display" : "Atheroma of artery (disorder)"
          },
          {
            "code" : "50818007",
            "display" : "Painful ejaculation (finding)"
          },
          {
            "code" : "50821009",
            "display" : "Arterial retinal branch occlusion (disorder)"
          },
          {
            "code" : "50829006",
            "display" : "Basic learning problem (finding)"
          },
          {
            "code" : "50849002",
            "display" : "Emergency room admission (procedure)"
          },
          {
            "code" : "50882004",
            "display" : "Traumatic ulcer of oral mucosa (disorder)"
          },
          {
            "code" : "50916005",
            "display" : "Fibrosing adenosis (morphologic abnormality)"
          },
          {
            "code" : "50920009",
            "display" : "Myocarditis (disorder)"
          },
          {
            "code" : "50921008",
            "display" : "Periarthritis (disorder)"
          },
          {
            "code" : "50923006",
            "display" : "Leukoplakia of cervix (disorder)"
          },
          {
            "code" : "50959000",
            "display" : "Tarentaise cattle breed (organism)"
          },
          {
            "code" : "50960005",
            "display" : "Hemorrhage (morphologic abnormality)"
          },
          {
            "code" : "50970007",
            "display" : "Acute gonorrhea of upper genitourinary tract (disorder)"
          },
          {
            "code" : "50983008",
            "display" : "Panic disorder with agoraphobia, mild agoraphobic avoidance AND panic attacks in partial remission (disorder)"
          },
          {
            "code" : "51002006",
            "display" : "Diabetes mellitus associated with pancreatic disease (disorder)"
          },
          {
            "code" : "51023000",
            "display" : "Tennessee walking horse (organism)"
          },
          {
            "code" : "51030006",
            "display" : "Cellulitis of lip (disorder)"
          },
          {
            "code" : "51036000",
            "display" : "Acute appendicitis with peritoneal abscess (disorder)"
          },
          {
            "code" : "51037009",
            "display" : "Fracture of patella (disorder)"
          },
          {
            "code" : "51044000",
            "display" : "After-cataract not obscuring vision following extraction of cataract (disorder)"
          },
          {
            "code" : "51070004",
            "display" : "Varicocele (disorder)"
          },
          {
            "code" : "51089004",
            "display" : "Birthmark (disorder)"
          },
          {
            "code" : "51098001",
            "display" : "Skin structure of cavity of concha (body structure)"
          },
          {
            "code" : "51114001",
            "display" : "Arterial structure (body structure)"
          },
          {
            "code" : "51159009",
            "display" : "Structure of teres minor muscle (body structure)"
          },
          {
            "code" : "51185008",
            "display" : "Thoracic structure (body structure)"
          },
          {
            "code" : "51197009",
            "display" : "Stomach cramps (finding)"
          },
          {
            "code" : "51204001",
            "display" : "Zygomatic arch structure (body structure)"
          },
          {
            "code" : "51221005",
            "display" : "Chronic contact dermatitis (disorder)"
          },
          {
            "code" : "51226000",
            "display" : "Round hole of retina without detachment (disorder)"
          },
          {
            "code" : "51239001",
            "display" : "Sexual masochism (disorder)"
          },
          {
            "code" : "51249003",
            "display" : "Structure of inferior left pulmonary vein (body structure)"
          },
          {
            "code" : "51274000",
            "display" : "Atherosclerosis of arteries of the extremities (disorder)"
          },
          {
            "code" : "51282000",
            "display" : "Bone structure of spine (body structure)"
          },
          {
            "code" : "51283005",
            "display" : "Palatine bone structure (body structure)"
          },
          {
            "code" : "51292008",
            "display" : "Hepatorenal syndrome (disorder)"
          },
          {
            "code" : "51299004",
            "display" : "Bone structure of clavicle (body structure)"
          },
          {
            "code" : "51320008",
            "display" : "Mycobacterium africanum (organism)"
          },
          {
            "code" : "51339003",
            "display" : "Polysubstance dependence (disorder)"
          },
          {
            "code" : "51345006",
            "display" : "Carotid body structure (body structure)"
          },
          {
            "code" : "51387008",
            "display" : "Acidosis (disorder)"
          },
          {
            "code" : "51398009",
            "display" : "Hamartoma (morphologic abnormality)"
          },
          {
            "code" : "51420009",
            "display" : "Silicon (substance)"
          },
          {
            "code" : "51440002",
            "display" : "Right and left (qualifier value)"
          },
          {
            "code" : "51459000",
            "display" : "Mycobacterium neoaurum (organism)"
          },
          {
            "code" : "51476001",
            "display" : "Nasopharyngitis (disorder)"
          },
          {
            "code" : "51477005",
            "display" : "Seduction (finding)"
          },
          {
            "code" : "51490003",
            "display" : "Disease caused by Rubivirus (disorder)"
          },
          {
            "code" : "51493001",
            "display" : "Cocaine-induced anxiety disorder (disorder)"
          },
          {
            "code" : "51500006",
            "display" : "Complete trisomy 18 syndrome (disorder)"
          },
          {
            "code" : "51504002",
            "display" : "Cryptosporidium parvum (organism)"
          },
          {
            "code" : "51526001",
            "display" : "Francisella tularensis (organism)"
          },
          {
            "code" : "51530003",
            "display" : "Pneumonia caused by Escherichia coli (disorder)"
          },
          {
            "code" : "51549004",
            "display" : "Leiomyosarcoma, no subtype (morphologic abnormality)"
          },
          {
            "code" : "51551000",
            "display" : "Bleeding hemorrhoids (disorder)"
          },
          {
            "code" : "51563005",
            "display" : "Free-standing mental health clinic (environment)"
          },
          {
            "code" : "51567006",
            "display" : "Sirius red F3B stain (substance)"
          },
          {
            "code" : "51599000",
            "display" : "Edema of larynx (disorder)"
          },
          {
            "code" : "51611005",
            "display" : "Chronic urticaria (disorder)"
          },
          {
            "code" : "51615001",
            "display" : "Fibrosis of lung (disorder)"
          },
          {
            "code" : "51655004",
            "display" : "Congenital anomaly of skull (disorder)"
          },
          {
            "code" : "51668007",
            "display" : "Mycotic aneurysm (morphologic abnormality)"
          },
          {
            "code" : "51678005",
            "display" : "Structure of deciduous maxillary left central incisor tooth (body structure)"
          },
          {
            "code" : "51683002",
            "display" : "Radial keratotomy (procedure)"
          },
          {
            "code" : "51689003",
            "display" : "Dystrophy of vulva (disorder)"
          },
          {
            "code" : "51692004",
            "display" : "Devon rex cat breed (organism)"
          },
          {
            "code" : "51698000",
            "display" : "Structure of dorsal aspect of scapula (body structure)"
          },
          {
            "code" : "51742006",
            "display" : "Disorder of anterior pituitary (disorder)"
          },
          {
            "code" : "51771007",
            "display" : "Postviral fatigue syndrome (disorder)"
          },
          {
            "code" : "51795009",
            "display" : "Musculoskeletal torsion (observable entity)"
          },
          {
            "code" : "51800004",
            "display" : "Radon-222 (substance)"
          },
          {
            "code" : "51827000",
            "display" : "Oriental Jews (ethnic group)"
          },
          {
            "code" : "51845000",
            "display" : "Anatomical position (finding)"
          },
          {
            "code" : "51852003",
            "display" : "Embryonic vascular structure (body structure)"
          },
          {
            "code" : "51868009",
            "display" : "Ulcer of duodenum (disorder)"
          },
          {
            "code" : "51885006",
            "display" : "Morning sickness (finding)"
          },
          {
            "code" : "51905005",
            "display" : "Mustard (substance)"
          },
          {
            "code" : "51908007",
            "display" : "Product containing prenylamine (medicinal product)"
          },
          {
            "code" : "51920004",
            "display" : "Precipitate labor (disorder)"
          },
          {
            "code" : "51928006",
            "display" : "General paresis - neurosyphilis (disorder)"
          },
          {
            "code" : "51937006",
            "display" : "Jersey cattle breed (organism)"
          },
          {
            "code" : "51943008",
            "display" : "Structure of deciduous maxillary left second molar tooth (body structure)"
          },
          {
            "code" : "51960003",
            "display" : "Secondary syphilis of pharynx (disorder)"
          },
          {
            "code" : "51995000",
            "display" : "Rubeosis iridis (disorder)"
          },
          {
            "code" : "51998003",
            "display" : "Therapeutic exercise (regime/therapy)"
          },
          {
            "code" : "52002008",
            "display" : "Serous detachment of retinal pigment epithelium (disorder)"
          },
          {
            "code" : "52011008",
            "display" : "Injury of finger (disorder)"
          },
          {
            "code" : "52012001",
            "display" : "Acquired genu valgum (disorder)"
          },
          {
            "code" : "52017007",
            "display" : "Medicinal product acting as antiemetic agent (product)"
          },
          {
            "code" : "52019005",
            "display" : "External rotation, function (observable entity)"
          },
          {
            "code" : "52034004",
            "display" : "Skin structure of toe (body structure)"
          },
          {
            "code" : "52052004",
            "display" : "Rehabilitation therapy (regime/therapy)"
          },
          {
            "code" : "52073004",
            "display" : "Oligomenorrhea (finding)"
          },
          {
            "code" : "52075006",
            "display" : "Congolese (ethnic group)"
          },
          {
            "code" : "52082005",
            "display" : "Structure of ligament (body structure)"
          },
          {
            "code" : "52089001",
            "display" : "Arteritis (disorder)"
          },
          {
            "code" : "52101004",
            "display" : "Present (qualifier value)"
          },
          {
            "code" : "52105008",
            "display" : "Vizsla superbreed (organism)"
          },
          {
            "code" : "52124006",
            "display" : "Central venous catheter, device (physical object)"
          },
          {
            "code" : "52163004",
            "display" : "Mechanical penile stimulation (finding)"
          },
          {
            "code" : "52184009",
            "display" : "Parent-child problem (finding)"
          },
          {
            "code" : "52247003",
            "display" : "Repair of aortic valve with tissue graft (procedure)"
          },
          {
            "code" : "52253003",
            "display" : "Newfoundland dog (organism)"
          },
          {
            "code" : "52254009",
            "display" : "Nephrotic syndrome (disorder)"
          },
          {
            "code" : "52298009",
            "display" : "Linear sebaceous nevus sequence (disorder)"
          },
          {
            "code" : "52311001",
            "display" : "Homocystinemia (disorder)"
          },
          {
            "code" : "52324001",
            "display" : "Mediastinal lymphadenopathy (disorder)"
          },
          {
            "code" : "52359001",
            "display" : "Structure of radial vein (body structure)"
          },
          {
            "code" : "52374004",
            "display" : "Ethmoid bone structure (body structure)"
          },
          {
            "code" : "52404001",
            "display" : "Mastoiditis (disorder)"
          },
          {
            "code" : "52405000",
            "display" : "Burn of trunk (disorder)"
          },
          {
            "code" : "52408003",
            "display" : "Iodinated (131-I) gamma globulin (substance)"
          },
          {
            "code" : "52414005",
            "display" : "Secondary syphilis of vulva (disorder)"
          },
          {
            "code" : "52421005",
            "display" : "Incipient cataract (disorder)"
          },
          {
            "code" : "52433000",
            "display" : "Structure of proximal portion of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "52441000",
            "display" : "Atrophic vaginitis (disorder)"
          },
          {
            "code" : "52448006",
            "display" : "Dementia (disorder)"
          },
          {
            "code" : "52454007",
            "display" : "Albumin (substance)"
          },
          {
            "code" : "52455008",
            "display" : "Ineffective parenthood (finding)"
          },
          {
            "code" : "52457000",
            "display" : "Ileitis (disorder)"
          },
          {
            "code" : "52462004",
            "display" : "Legionella cherrii (organism)"
          },
          {
            "code" : "52475004",
            "display" : "Xeroderma (disorder)"
          },
          {
            "code" : "52486002",
            "display" : "Necrotizing fasciitis (disorder)"
          },
          {
            "code" : "52497002",
            "display" : "Foreign body in conjunctival sac (disorder)"
          },
          {
            "code" : "52506002",
            "display" : "Chronic ulcerative rectosigmoiditis (disorder)"
          },
          {
            "code" : "52509009",
            "display" : "Structure of body of sternum (body structure)"
          },
          {
            "code" : "52515009",
            "display" : "Hernia of abdominal cavity (disorder)"
          },
          {
            "code" : "52526003",
            "display" : "Sweating problem (finding)"
          },
          {
            "code" : "52554005",
            "display" : "Superior medial inguinal lymph node (body structure)"
          },
          {
            "code" : "52583008",
            "display" : "Vocal fold abduction, function (observable entity)"
          },
          {
            "code" : "52584002",
            "display" : "Measles morbillivirus (organism)"
          },
          {
            "code" : "52585001",
            "display" : "Sciatic neuropathy (disorder)"
          },
          {
            "code" : "52612000",
            "display" : "Lumbar region back structure (body structure)"
          },
          {
            "code" : "52613005",
            "display" : "Excessive sweating (finding)"
          },
          {
            "code" : "52636001",
            "display" : "Actinic reticuloid (disorder)"
          },
          {
            "code" : "52637005",
            "display" : "Test tube ovum fertilization (procedure)"
          },
          {
            "code" : "52643007",
            "display" : "Candidal balanitis (disorder)"
          },
          {
            "code" : "52659007",
            "display" : "Vitamin K restricted diet during anticoagulation therapy (finding)"
          },
          {
            "code" : "52660002",
            "display" : "Induced abortion following intra-amniotic injection with hysterotomy (procedure)"
          },
          {
            "code" : "52674009",
            "display" : "Ischemia (disorder)"
          },
          {
            "code" : "52684005",
            "display" : "Assault (event)"
          },
          {
            "code" : "52685006",
            "display" : "Administration of analgesic (procedure)"
          },
          {
            "code" : "52687003",
            "display" : "Bone structure of shaft of tibia (body structure)"
          },
          {
            "code" : "52698002",
            "display" : "Transient hypertension (disorder)"
          },
          {
            "code" : "52702003",
            "display" : "Chronic fatigue syndrome (disorder)"
          },
          {
            "code" : "52734007",
            "display" : "Total replacement of hip (procedure)"
          },
          {
            "code" : "52745005",
            "display" : "Chromium-51 (substance)"
          },
          {
            "code" : "52754008",
            "display" : "Polymenorrhea (finding)"
          },
          {
            "code" : "52757001",
            "display" : "Congenital supravalvular pulmonary stenosis (disorder)"
          },
          {
            "code" : "52765003",
            "display" : "Intubation (procedure)"
          },
          {
            "code" : "52767006",
            "display" : "Neonatal hypoglycemia (disorder)"
          },
          {
            "code" : "52779006",
            "display" : "Hantaan virus (organism)"
          },
          {
            "code" : "52781008",
            "display" : "Congenital hip dysplasia (disorder)"
          },
          {
            "code" : "52791002",
            "display" : "Female mature sexual state (finding)"
          },
          {
            "code" : "52812002",
            "display" : "Trachoma, active stage (disorder)"
          },
          {
            "code" : "52813007",
            "display" : "Ego-dystonic sexual orientation (finding)"
          },
          {
            "code" : "52824009",
            "display" : "Developmental reading disorder (disorder)"
          },
          {
            "code" : "52833006",
            "display" : "Hyposexuality state (finding)"
          },
          {
            "code" : "52836003",
            "display" : "Paraformaldehyde (substance)"
          },
          {
            "code" : "52845002",
            "display" : "Nephritis (disorder)"
          },
          {
            "code" : "52852000",
            "display" : "Insertion of bilateral breast prostheses (procedure)"
          },
          {
            "code" : "52856002",
            "display" : "Cylindroid aneurysm (morphologic abnormality)"
          },
          {
            "code" : "52876008",
            "display" : "Skin structure of dorsal area of wrist (body structure)"
          },
          {
            "code" : "52897009",
            "display" : "Onychogryposis (disorder)"
          },
          {
            "code" : "52910006",
            "display" : "Anxiety disorder due to a general medical condition (disorder)"
          },
          {
            "code" : "52914002",
            "display" : "Anal candidiasis (disorder)"
          },
          {
            "code" : "52931009",
            "display" : "Thrombosed internal hemorrhoids (disorder)"
          },
          {
            "code" : "52943005",
            "display" : "Structure of posterior horn of lateral ventricle (body structure)"
          },
          {
            "code" : "52946002",
            "display" : "Affenpinscher (organism)"
          },
          {
            "code" : "52952001",
            "display" : "Irish wolfhound (organism)"
          },
          {
            "code" : "52953006",
            "display" : "Skin structure of medial border of sole of foot (body structure)"
          },
          {
            "code" : "52954000",
            "display" : "Schizoid personality disorder (disorder)"
          },
          {
            "code" : "52967002",
            "display" : "Myelofibrosis (disorder)"
          },
          {
            "code" : "52988006",
            "display" : "Lesion (morphologic abnormality)"
          },
          {
            "code" : "52994003",
            "display" : "Internal resorption of tooth (disorder)"
          },
          {
            "code" : "53031002",
            "display" : "Dexter cattle breed (organism)"
          },
          {
            "code" : "53043001",
            "display" : "Primary idiopathic dilated cardiomyopathy (disorder)"
          },
          {
            "code" : "53057004",
            "display" : "Hand pain (finding)"
          },
          {
            "code" : "53059001",
            "display" : "Replacement of mitral valve (procedure)"
          },
          {
            "code" : "53074004",
            "display" : "Structure of hilar lymph node (body structure)"
          },
          {
            "code" : "53084003",
            "display" : "Bacterial pneumonia (disorder)"
          },
          {
            "code" : "53085002",
            "display" : "Right cardiac ventricular structure (body structure)"
          },
          {
            "code" : "53114006",
            "display" : "Mycobacterium smegmatis (organism)"
          },
          {
            "code" : "53118009",
            "display" : "Structure of inferior horn of lateral ventricle (body structure)"
          },
          {
            "code" : "53120007",
            "display" : "Upper limb structure (body structure)"
          },
          {
            "code" : "53132006",
            "display" : "Zollinger-Ellison syndrome (disorder)"
          },
          {
            "code" : "53151000",
            "display" : "Fatty streaks (morphologic abnormality)"
          },
          {
            "code" : "53165003",
            "display" : "Megaloblastic anemia (disorder)"
          },
          {
            "code" : "53181008",
            "display" : "Scratch marks (finding)"
          },
          {
            "code" : "53195006",
            "display" : "Kirghiz (ethnic group)"
          },
          {
            "code" : "53208009",
            "display" : "Peroneal tendinitis (disorder)"
          },
          {
            "code" : "53209001",
            "display" : "Decisional conflict (finding)"
          },
          {
            "code" : "53226007",
            "display" : "Talipes planus (disorder)"
          },
          {
            "code" : "53228008",
            "display" : "Alaskan malamute (organism)"
          },
          {
            "code" : "53233007",
            "display" : "Enterococcus gallinarum (organism)"
          },
          {
            "code" : "53238003",
            "display" : "Optic tract structure (body structure)"
          },
          {
            "code" : "53266006",
            "display" : "Operation on diaphragm (procedure)"
          },
          {
            "code" : "53277000",
            "display" : "Vulvovaginitis (disorder)"
          },
          {
            "code" : "53286005",
            "display" : "Medial epicondylitis of elbow joint (disorder)"
          },
          {
            "code" : "53294003",
            "display" : "Subglottic pressure (observable entity)"
          },
          {
            "code" : "53295002",
            "display" : "Chronic otitis externa (disorder)"
          },
          {
            "code" : "53298000",
            "display" : "Hematuria syndrome (disorder)"
          },
          {
            "code" : "53304009",
            "display" : "Parathyroidectomy (procedure)"
          },
          {
            "code" : "53315004",
            "display" : "Germanium-68 (substance)"
          },
          {
            "code" : "53318002",
            "display" : "Spina bifida with hydrocephalus (disorder)"
          },
          {
            "code" : "53332000",
            "display" : "Spinal arthritis deformans (disorder)"
          },
          {
            "code" : "53339009",
            "display" : "Dysfunctional grieving (finding)"
          },
          {
            "code" : "53342003",
            "display" : "Internal nose structure (body structure)"
          },
          {
            "code" : "53350007",
            "display" : "Prosthesis, device (physical object)"
          },
          {
            "code" : "53360003",
            "display" : "Oxford Down sheep (organism)"
          },
          {
            "code" : "53406005",
            "display" : "Juvenile osteochondrosis of spine (disorder)"
          },
          {
            "code" : "53417006",
            "display" : "Articular cartilage disorder (disorder)"
          },
          {
            "code" : "53430007",
            "display" : "Pain of breast (finding)"
          },
          {
            "code" : "53431006",
            "display" : "Boar power pig 59 (organism)"
          },
          {
            "code" : "53438000",
            "display" : "Radiation therapy procedure or service (procedure)"
          },
          {
            "code" : "53442002",
            "display" : "Excision of stomach structure (procedure)"
          },
          {
            "code" : "53443007",
            "display" : "Prolonged labor (disorder)"
          },
          {
            "code" : "53447008",
            "display" : "Rickettsia australis (organism)"
          },
          {
            "code" : "53460002",
            "display" : "Serbs (ethnic group)"
          },
          {
            "code" : "53467004",
            "display" : "Anxiety disorder of childhood (disorder)"
          },
          {
            "code" : "53505006",
            "display" : "Anal structure (body structure)"
          },
          {
            "code" : "53511009",
            "display" : "Tropaeolin OO stain (substance)"
          },
          {
            "code" : "53520000",
            "display" : "Autonomic nerve structure (body structure)"
          },
          {
            "code" : "53529004",
            "display" : "Chronic gonococcal salpingitis (disorder)"
          },
          {
            "code" : "53549008",
            "display" : "Structure of ophthalmic artery (body structure)"
          },
          {
            "code" : "53567001",
            "display" : "Suffolk horse (organism)"
          },
          {
            "code" : "53570002",
            "display" : "Removal of foreign body from eye (procedure)"
          },
          {
            "code" : "53585008",
            "display" : "Radioisotope study of gastrointestinal system (procedure)"
          },
          {
            "code" : "53603007",
            "display" : "Entire pulmonary vein (great vessel) (body structure)"
          },
          {
            "code" : "53610001",
            "display" : "Nasal septoplasty with graft (procedure)"
          },
          {
            "code" : "53617003",
            "display" : "Monitoring of respiration (regime/therapy)"
          },
          {
            "code" : "53620006",
            "display" : "Temporomandibular joint structure (body structure)"
          },
          {
            "code" : "53623008",
            "display" : "N1 category (finding)"
          },
          {
            "code" : "53627009",
            "display" : "Closed fracture of radius AND ulna (disorder)"
          },
          {
            "code" : "53654007",
            "display" : "Fibrosarcoma (morphologic abnormality)"
          },
          {
            "code" : "53655008",
            "display" : "Structure of posterior descending branch of right coronary artery (body structure)"
          },
          {
            "code" : "53664003",
            "display" : "Gonococcal spondylitis (disorder)"
          },
          {
            "code" : "53700003",
            "display" : "Copper-67 (substance)"
          },
          {
            "code" : "53713009",
            "display" : "Works as prostitute (finding)"
          },
          {
            "code" : "53724006",
            "display" : "Sexual recrudescence in elderly male (finding)"
          },
          {
            "code" : "53726008",
            "display" : "Acute conjunctivitis (disorder)"
          },
          {
            "code" : "53727004",
            "display" : "Left pleura structure (body structure)"
          },
          {
            "code" : "53741008",
            "display" : "Coronary arteriosclerosis (disorder)"
          },
          {
            "code" : "53763004",
            "display" : "Sexual aggression (finding)"
          },
          {
            "code" : "53767003",
            "display" : "Endoscopic biopsy (procedure)"
          },
          {
            "code" : "53772007",
            "display" : "Vitreous detachment (disorder)"
          },
          {
            "code" : "53785005",
            "display" : "Injury to brachial plexus as birth trauma (disorder)"
          },
          {
            "code" : "53787002",
            "display" : "Laryngismus (finding)"
          },
          {
            "code" : "53792000",
            "display" : "Closed fracture of shaft of ulna (disorder)"
          },
          {
            "code" : "53827007",
            "display" : "Excessive salivation (disorder)"
          },
          {
            "code" : "53840002",
            "display" : "Structure of calf of leg (body structure)"
          },
          {
            "code" : "53843000",
            "display" : "Structure of rectouterine pouch (body structure)"
          },
          {
            "code" : "53854005",
            "display" : "Chorioretinal scar (disorder)"
          },
          {
            "code" : "53874003",
            "display" : "Acute periendocarditis (disorder)"
          },
          {
            "code" : "53888004",
            "display" : "Disturbance in sleep behavior (finding)"
          },
          {
            "code" : "53889007",
            "display" : "Nuclear cataract (disorder)"
          },
          {
            "code" : "53891004",
            "display" : "Lichen simplex chronicus (disorder)"
          },
          {
            "code" : "53896009",
            "display" : "Tolerant ex-smoker (finding)"
          },
          {
            "code" : "53922000",
            "display" : "Japanese chin dog (organism)"
          },
          {
            "code" : "53929009",
            "display" : "Mass of scrotum (finding)"
          },
          {
            "code" : "53936005",
            "display" : "Alcohol-induced mood disorder (disorder)"
          },
          {
            "code" : "53951001",
            "display" : "Technetium (99m-Tc) oxidronate (substance)"
          },
          {
            "code" : "53956006",
            "display" : "Panic disorder without agoraphobia with panic attacks in partial remission (disorder)"
          },
          {
            "code" : "53958007",
            "display" : "Harvesting of donor material (procedure)"
          },
          {
            "code" : "53963006",
            "display" : "Excessive attrition of teeth (disorder)"
          },
          {
            "code" : "53967007",
            "display" : "Structure of external intercostal muscle (body structure)"
          },
          {
            "code" : "53976000",
            "display" : "Arthrodesis by anterior interbody technique of cervical region below C2 with bone graft (procedure)"
          },
          {
            "code" : "54002007",
            "display" : "Saccular aneurysm (morphologic abnormality)"
          },
          {
            "code" : "54012000",
            "display" : "Posttraumatic headache (finding)"
          },
          {
            "code" : "54016002",
            "display" : "Mobitz type I incomplete atrioventricular block (disorder)"
          },
          {
            "code" : "54019009",
            "display" : "Submandibular salivary apparatus (body structure)"
          },
          {
            "code" : "54048003",
            "display" : "Threatened abortion (disorder)"
          },
          {
            "code" : "54066008",
            "display" : "Pharyngeal structure (body structure)"
          },
          {
            "code" : "54070000",
            "display" : "Postpartum education (procedure)"
          },
          {
            "code" : "54084005",
            "display" : "Cervical tuberculous lymphadenitis (disorder)"
          },
          {
            "code" : "54097007",
            "display" : "White blood cell disorder (disorder)"
          },
          {
            "code" : "54098002",
            "display" : "Arabian horse (organism)"
          },
          {
            "code" : "54102005",
            "display" : "G1 grade (finding)"
          },
          {
            "code" : "54123004",
            "display" : "Sodium restricted diet, 40 milliequivalents (finding)"
          },
          {
            "code" : "54150009",
            "display" : "Upper respiratory infection (disorder)"
          },
          {
            "code" : "54165005",
            "display" : "Structure of cisterna magna (body structure)"
          },
          {
            "code" : "54200006",
            "display" : "Tonic-clonic seizure (finding)"
          },
          {
            "code" : "54220007",
            "display" : "Fissure of nipple (disorder)"
          },
          {
            "code" : "54221006",
            "display" : "Orange G stain (substance)"
          },
          {
            "code" : "54231004",
            "display" : "Rape trauma syndrome (finding)"
          },
          {
            "code" : "54232006",
            "display" : "Welsh pig (organism)"
          },
          {
            "code" : "54247002",
            "display" : "Ascending aorta structure (body structure)"
          },
          {
            "code" : "54258006",
            "display" : "Root canal therapy, comprehensive (procedure)"
          },
          {
            "code" : "54261007",
            "display" : "Excision of uterus and supporting structures (procedure)"
          },
          {
            "code" : "54268001",
            "display" : "Pelvic lymph node structure (body structure)"
          },
          {
            "code" : "54274001",
            "display" : "Primary syphilis of fingers (disorder)"
          },
          {
            "code" : "54296007",
            "display" : "Partial thickness burn of hand (disorder)"
          },
          {
            "code" : "54300008",
            "display" : "Vaginal approach (qualifier value)"
          },
          {
            "code" : "54302000",
            "display" : "Discharge from nipple (disorder)"
          },
          {
            "code" : "54307006",
            "display" : "Zoophobia (finding)"
          },
          {
            "code" : "54319003",
            "display" : "Disruptive behavior disorder (disorder)"
          },
          {
            "code" : "54329005",
            "display" : "Acute myocardial infarction of anterior wall (disorder)"
          },
          {
            "code" : "54355006",
            "display" : "Intracranial injury, without skull fracture (disorder)"
          },
          {
            "code" : "54365000",
            "display" : "Yersinia pestis (organism)"
          },
          {
            "code" : "54380006",
            "display" : "Translocation syndrome (finding)"
          },
          {
            "code" : "54385001",
            "display" : "Exanthema subitum (disorder)"
          },
          {
            "code" : "54398005",
            "display" : "Acute upper respiratory infection (disorder)"
          },
          {
            "code" : "54404000",
            "display" : "Cervical radiculopathy (disorder)"
          },
          {
            "code" : "54409005",
            "display" : "Structure of carotid siphon (body structure)"
          },
          {
            "code" : "54432009",
            "display" : "Alizarin blue S stain (substance)"
          },
          {
            "code" : "54440003",
            "display" : "Skin structure of upper trunk (body structure)"
          },
          {
            "code" : "54441004",
            "display" : "Fracture of shaft of femur (disorder)"
          },
          {
            "code" : "54446009",
            "display" : "Lysolecithin (substance)"
          },
          {
            "code" : "54447000",
            "display" : "Haflinger horse (organism)"
          },
          {
            "code" : "54468004",
            "display" : "Skin structure of nipple (body structure)"
          },
          {
            "code" : "54486001",
            "display" : "Left sacrolateral position (finding)"
          },
          {
            "code" : "54493002",
            "display" : "Intramural hematoma (morphologic abnormality)"
          },
          {
            "code" : "54500007",
            "display" : "Clear fluid diet (finding)"
          },
          {
            "code" : "54535009",
            "display" : "Cone biopsy of cervix (procedure)"
          },
          {
            "code" : "54556006",
            "display" : "Fracture of ulna (disorder)"
          },
          {
            "code" : "54586004",
            "display" : "Lower abdominal pain (finding)"
          },
          {
            "code" : "54587008",
            "display" : "Simple phobia (disorder)"
          },
          {
            "code" : "54609002",
            "display" : "Ulcer of rectum (disorder)"
          },
          {
            "code" : "54640009",
            "display" : "Aortography (procedure)"
          },
          {
            "code" : "54641008",
            "display" : "Closed fracture of base of metacarpal bone other than first metacarpal (disorder)"
          },
          {
            "code" : "54657008",
            "display" : "Hygiene education (procedure)"
          },
          {
            "code" : "54670004",
            "display" : "Slipping (event)"
          },
          {
            "code" : "54687002",
            "display" : "Arterial embolism (disorder)"
          },
          {
            "code" : "54699009",
            "display" : "American miniature horse (organism)"
          },
          {
            "code" : "54711002",
            "display" : "Gingival enlargement (disorder)"
          },
          {
            "code" : "54719000",
            "display" : "Exposure to human stampede (event)"
          },
          {
            "code" : "54721005",
            "display" : "Pharyngeal stage of deglutition (observable entity)"
          },
          {
            "code" : "54723008",
            "display" : "State of erotic tension (finding)"
          },
          {
            "code" : "54731003",
            "display" : "Deglutition (observable entity)"
          },
          {
            "code" : "54735007",
            "display" : "Bone structure of sacrum (body structure)"
          },
          {
            "code" : "54746005",
            "display" : "Erotophobia (finding)"
          },
          {
            "code" : "54791001",
            "display" : "Metanil yellow stain (substance)"
          },
          {
            "code" : "54792008",
            "display" : "Erythematosquamous dermatosis (disorder)"
          },
          {
            "code" : "54823002",
            "display" : "Subclinical hypothyroidism (disorder)"
          },
          {
            "code" : "54825009",
            "display" : "Acute gonorrhea of lower genitourinary tract (disorder)"
          },
          {
            "code" : "54840006",
            "display" : "Failure to thrive (disorder)"
          },
          {
            "code" : "54858000",
            "display" : "Scottish deerhound (organism)"
          },
          {
            "code" : "54866009",
            "display" : "Initial implantation of cardiac single-chamber device (procedure)"
          },
          {
            "code" : "54885007",
            "display" : "Extraction of cataract (procedure)"
          },
          {
            "code" : "54888009",
            "display" : "Sprain of knee (disorder)"
          },
          {
            "code" : "54925005",
            "display" : "Mycobacterium vaccae (organism)"
          },
          {
            "code" : "54956002",
            "display" : "Gastrostomy (procedure)"
          },
          {
            "code" : "54967001",
            "display" : "Double kidney (disorder)"
          },
          {
            "code" : "54970002",
            "display" : "Monoamine restricted diet (finding)"
          },
          {
            "code" : "54973000",
            "display" : "Total breech delivery with forceps to aftercoming head (procedure)"
          },
          {
            "code" : "54974006",
            "display" : "Insertion of permanent pacemaker with transvenous electrodes, ventricular (procedure)"
          },
          {
            "code" : "54993008",
            "display" : "Cardiac index (observable entity)"
          },
          {
            "code" : "55004003",
            "display" : "Syndrome of inappropriate vasopressin secretion (disorder)"
          },
          {
            "code" : "55011004",
            "display" : "Steady (qualifier value)"
          },
          {
            "code" : "55024004",
            "display" : "Optic canal structure (body structure)"
          },
          {
            "code" : "55032007",
            "display" : "Listeria ivanovii (organism)"
          },
          {
            "code" : "55033002",
            "display" : "Muscle contracture (disorder)"
          },
          {
            "code" : "55042009",
            "display" : "Contusion of ankle (disorder)"
          },
          {
            "code" : "55058007",
            "display" : "Griffon dog (organism)"
          },
          {
            "code" : "55060009",
            "display" : "Frontal sinus structure (body structure)"
          },
          {
            "code" : "55117002",
            "display" : "Cesium-137 (substance)"
          },
          {
            "code" : "55130001",
            "display" : "Laryngotracheitis (disorder)"
          },
          {
            "code" : "55146009",
            "display" : "Inflammation of sacroiliac joint (disorder)"
          },
          {
            "code" : "55162003",
            "display" : "Tooth extraction (procedure)"
          },
          {
            "code" : "55167009",
            "display" : "Appaloosa horse (organism)"
          },
          {
            "code" : "55174004",
            "display" : "Human poliovirus 2 (organism)"
          },
          {
            "code" : "55180007",
            "display" : "Potassium diet (finding)"
          },
          {
            "code" : "55199003",
            "display" : "Hypoplasia (morphologic abnormality)"
          },
          {
            "code" : "55222007",
            "display" : "Breast tenderness (finding)"
          },
          {
            "code" : "55225009",
            "display" : "Neonatal death of female (within 7 days, World Health Organization) (event)"
          },
          {
            "code" : "55233005",
            "display" : "Structure of inferior longitudinal fasciculus (body structure)"
          },
          {
            "code" : "55235003",
            "display" : "C-reactive protein measurement (procedure)"
          },
          {
            "code" : "55244002",
            "display" : "Arthroscopically aided anterior cruciate ligament repair (procedure)"
          },
          {
            "code" : "55253009",
            "display" : "Replacement of tricuspid valve with tissue graft (procedure)"
          },
          {
            "code" : "55260003",
            "display" : "Calcaneal spur (finding)"
          },
          {
            "code" : "55275006",
            "display" : "Nodular vasculitis (disorder)"
          },
          {
            "code" : "55288009",
            "display" : "Vesiculovirus (organism)"
          },
          {
            "code" : "55300003",
            "display" : "Cramp (finding)"
          },
          {
            "code" : "55308005",
            "display" : "Poisoning caused by insect venom (disorder)"
          },
          {
            "code" : "55310007",
            "display" : "Mucous polyp of cervix (disorder)"
          },
          {
            "code" : "55342001",
            "display" : "Neoplastic disease (disorder)"
          },
          {
            "code" : "55382008",
            "display" : "Cerebral atherosclerosis (disorder)"
          },
          {
            "code" : "55406008",
            "display" : "Hyperalgesia (finding)"
          },
          {
            "code" : "55408009",
            "display" : "Senile entropion (disorder)"
          },
          {
            "code" : "55462008",
            "display" : "Shigella boydii (organism)"
          },
          {
            "code" : "55464009",
            "display" : "Systemic lupus erythematosus (disorder)"
          },
          {
            "code" : "55468007",
            "display" : "Ocular slit lamp examination (procedure)"
          },
          {
            "code" : "55494003",
            "display" : "Technetium (99m-Tc) albumin microspheres (substance)"
          },
          {
            "code" : "55499008",
            "display" : "Structure of lesser trochanter of femur (body structure)"
          },
          {
            "code" : "55525008",
            "display" : "Paralytic ileus (disorder)"
          },
          {
            "code" : "55530007",
            "display" : "La Mancha goat (organism)"
          },
          {
            "code" : "55539008",
            "display" : "Physical stress (finding)"
          },
          {
            "code" : "55554002",
            "display" : "Suicide attempt by inadequate means (event)"
          },
          {
            "code" : "55555001",
            "display" : "Trachomatous pannus (disorder)"
          },
          {
            "code" : "55561003",
            "display" : "Active (qualifier value)"
          },
          {
            "code" : "55566008",
            "display" : "Accidental physical contact (event)"
          },
          {
            "code" : "55570000",
            "display" : "Asthma without status asthmaticus (disorder)"
          },
          {
            "code" : "55584005",
            "display" : "Embolus (morphologic abnormality)"
          },
          {
            "code" : "55590009",
            "display" : "Normal angle of erection (finding)"
          },
          {
            "code" : "55607006",
            "display" : "Problem (finding)"
          },
          {
            "code" : "55608001",
            "display" : "Prurigo simplex (disorder)"
          },
          {
            "code" : "55668003",
            "display" : "Adjustment disorder with mixed emotional features (disorder)"
          },
          {
            "code" : "55673009",
            "display" : "Product containing sodium iothalamate (125-I) (medicinal product)"
          },
          {
            "code" : "55678000",
            "display" : "Structure of spinous process of vertebra (body structure)"
          },
          {
            "code" : "55680006",
            "display" : "Drug overdose (disorder)"
          },
          {
            "code" : "55705006",
            "display" : "Spinal arthrodesis (procedure)"
          },
          {
            "code" : "55735004",
            "display" : "Respiratory syncytial virus infection (disorder)"
          },
          {
            "code" : "55745002",
            "display" : "Product containing propranolol (medicinal product)"
          },
          {
            "code" : "55765009",
            "display" : "Hyperlipoproteinemia diet, type V (finding)"
          },
          {
            "code" : "55768006",
            "display" : "Syphilitic leukoderma (disorder)"
          },
          {
            "code" : "55804002",
            "display" : "History and physical examination, administrative (procedure)"
          },
          {
            "code" : "55814006",
            "display" : "Iodinated (131-I) aggregated albumin (substance)"
          },
          {
            "code" : "55822004",
            "display" : "Hyperlipidemia (disorder)"
          },
          {
            "code" : "55827005",
            "display" : "Left ventricular hypertrophy (disorder)"
          },
          {
            "code" : "55830003",
            "display" : "Product containing human menopausal gonadotropin (medicinal product)"
          },
          {
            "code" : "55831004",
            "display" : "Xylene cyanol FF stain (substance)"
          },
          {
            "code" : "55833001",
            "display" : "Disorder of bursa of shoulder region (disorder)"
          },
          {
            "code" : "55852007",
            "display" : "Complete phocomelia of lower limb (disorder)"
          },
          {
            "code" : "55855009",
            "display" : "Disorder of pericardium (disorder)"
          },
          {
            "code" : "55864004",
            "display" : "Kneeling (finding)"
          },
          {
            "code" : "55867006",
            "display" : "Product containing aminophylline (medicinal product)"
          },
          {
            "code" : "55892009",
            "display" : "Nocturnal erection of penis (finding)"
          },
          {
            "code" : "55899000",
            "display" : "Foreign body on external eye (disorder)"
          },
          {
            "code" : "55905000",
            "display" : "Vibrio vulnificus (organism)"
          },
          {
            "code" : "55921005",
            "display" : "Multiple myeloma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "55923008",
            "display" : "Infant diet (finding)"
          },
          {
            "code" : "55929007",
            "display" : "Feeling irritable (finding)"
          },
          {
            "code" : "55940004",
            "display" : "Adenoidal structure (body structure)"
          },
          {
            "code" : "55959002",
            "display" : "Blue tick coonhound (organism)"
          },
          {
            "code" : "55967005",
            "display" : "Phencyclidine-induced anxiety disorder (disorder)"
          },
          {
            "code" : "55990000",
            "display" : "Inca (ethnic group)"
          },
          {
            "code" : "55995005",
            "display" : "Hereditary spherocytosis (disorder)"
          },
          {
            "code" : "56018004",
            "display" : "Wheezing (finding)"
          },
          {
            "code" : "56021002",
            "display" : "Seroma (morphologic abnormality)"
          },
          {
            "code" : "56034001",
            "display" : "Compulsive exhibitionism (disorder)"
          },
          {
            "code" : "56038003",
            "display" : "Staphylococcal infectious disease (disorder)"
          },
          {
            "code" : "56052001",
            "display" : "Facial nerve structure (body structure)"
          },
          {
            "code" : "56056003",
            "display" : "Belgians (ethnic group)"
          },
          {
            "code" : "56060000",
            "display" : "Repair of musculotendinous cuff of shoulder (procedure)"
          },
          {
            "code" : "56062008",
            "display" : "Repair of sliding inguinal hernia (procedure)"
          },
          {
            "code" : "56084008",
            "display" : "Boar power pig 292 (organism)"
          },
          {
            "code" : "56086005",
            "display" : "Paso Fino horse (organism)"
          },
          {
            "code" : "56095002",
            "display" : "Necrosadism (disorder)"
          },
          {
            "code" : "56097005",
            "display" : "Migraine without aura (disorder)"
          },
          {
            "code" : "56102008",
            "display" : "Neonatal death of female (within 4 weeks, United States of America) (event)"
          },
          {
            "code" : "56110009",
            "display" : "Birth trauma of fetus (disorder)"
          },
          {
            "code" : "56169002",
            "display" : "Break-through bleeding (finding)"
          },
          {
            "code" : "56170001",
            "display" : "Photopsia (disorder)"
          },
          {
            "code" : "56177003",
            "display" : "Cubital tunnel syndrome (disorder)"
          },
          {
            "code" : "56193007",
            "display" : "Oculomotor nerve structure (body structure)"
          },
          {
            "code" : "56202001",
            "display" : "Retinal detachment with retinal defect (disorder)"
          },
          {
            "code" : "56208002",
            "display" : "Ulcer (morphologic abnormality)"
          },
          {
            "code" : "56218007",
            "display" : "Systolic hypertension (disorder)"
          },
          {
            "code" : "56226004",
            "display" : "Stricture of intestine (disorder)"
          },
          {
            "code" : "56243001",
            "display" : "Wirehaired miniature dachshund (organism)"
          },
          {
            "code" : "56251003",
            "display" : "Nebulizer therapy (procedure)"
          },
          {
            "code" : "56265001",
            "display" : "Heart disease (disorder)"
          },
          {
            "code" : "56267009",
            "display" : "Multi-infarct dementia (disorder)"
          },
          {
            "code" : "56283009",
            "display" : "Transplantation of small intestine (procedure)"
          },
          {
            "code" : "56294008",
            "display" : "Nicotine dependence (disorder)"
          },
          {
            "code" : "56306000",
            "display" : "Cosmetic surgery (procedure)"
          },
          {
            "code" : "56307009",
            "display" : "Fall from table (event)"
          },
          {
            "code" : "56317004",
            "display" : "Alopecia (disorder)"
          },
          {
            "code" : "56329008",
            "display" : "Pituitary structure (body structure)"
          },
          {
            "code" : "56335008",
            "display" : "Infection caused by Trichomonas (disorder)"
          },
          {
            "code" : "56342008",
            "display" : "Temperature taking (procedure)"
          },
          {
            "code" : "56353002",
            "display" : "Staple, device (physical object)"
          },
          {
            "code" : "56361007",
            "display" : "Excision of soft tissue (procedure)"
          },
          {
            "code" : "56395006",
            "display" : "Plasmodium malariae (organism)"
          },
          {
            "code" : "56400007",
            "display" : "Structure of renal vein (body structure)"
          },
          {
            "code" : "56415008",
            "display" : "Klebsiella pneumoniae (organism)"
          },
          {
            "code" : "56417000",
            "display" : "Autopsy, gross and microscopic examination with brain (procedure)"
          },
          {
            "code" : "56441002",
            "display" : "Sexual harassment (finding)"
          },
          {
            "code" : "56454009",
            "display" : "Pityriasis versicolor (disorder)"
          },
          {
            "code" : "56459004",
            "display" : "Foot structure (body structure)"
          },
          {
            "code" : "56468002",
            "display" : "Venous hemangioma (morphologic abnormality)"
          },
          {
            "code" : "56492005",
            "display" : "Fear of oncoming retirement (finding)"
          },
          {
            "code" : "56557000",
            "display" : "Fibrositis (disorder)"
          },
          {
            "code" : "56576003",
            "display" : "Panic disorder without agoraphobia (disorder)"
          },
          {
            "code" : "56578002",
            "display" : "Moderate smoker (20 or less per day) (finding)"
          },
          {
            "code" : "56596006",
            "display" : "Histoplasma capsulatum (organism)"
          },
          {
            "code" : "56604005",
            "display" : "Cohen syndrome (disorder)"
          },
          {
            "code" : "56608008",
            "display" : "Pain in wrist (finding)"
          },
          {
            "code" : "56609000",
            "display" : "Indium-111 (substance)"
          },
          {
            "code" : "56620000",
            "display" : "Delivery of placenta following delivery of infant outside of hospital (procedure)"
          },
          {
            "code" : "56681004",
            "display" : "Cerebral alteration (finding)"
          },
          {
            "code" : "56689002",
            "display" : "Crohn's disease of small intestine (disorder)"
          },
          {
            "code" : "56713002",
            "display" : "Dysfunction of eustachian tube (disorder)"
          },
          {
            "code" : "56717001",
            "display" : "Tuberculosis (disorder)"
          },
          {
            "code" : "56718006",
            "display" : "Hyperlipoproteinemia diet (finding)"
          },
          {
            "code" : "56727007",
            "display" : "Vitiligo (disorder)"
          },
          {
            "code" : "56731001",
            "display" : "Increased muscle tone (finding)"
          },
          {
            "code" : "56757003",
            "display" : "Scraping (procedure)"
          },
          {
            "code" : "56771006",
            "display" : "Heavy smoker (over 20 per day) (finding)"
          },
          {
            "code" : "56783008",
            "display" : "Incision AND drainage (procedure)"
          },
          {
            "code" : "56786000",
            "display" : "Pulmonic valve stenosis (disorder)"
          },
          {
            "code" : "56789007",
            "display" : "Structure of ostium of right coronary artery (body structure)"
          },
          {
            "code" : "56792006",
            "display" : "Measurement of skull circumference (procedure)"
          },
          {
            "code" : "56819008",
            "display" : "Endocarditis (disorder)"
          },
          {
            "code" : "56849005",
            "display" : "Structure of popliteal vein (body structure)"
          },
          {
            "code" : "56851009",
            "display" : "Maximal (qualifier value)"
          },
          {
            "code" : "56871000",
            "display" : "Localized amyloidosis (disorder)"
          },
          {
            "code" : "56873002",
            "display" : "Bone structure of sternum (body structure)"
          },
          {
            "code" : "56882008",
            "display" : "Anorexia nervosa (disorder)"
          },
          {
            "code" : "56890008",
            "display" : "Victim of sexual aggression (finding)"
          },
          {
            "code" : "56905009",
            "display" : "Perforation of intestine (disorder)"
          },
          {
            "code" : "56917006",
            "display" : "Cornish rex cat breed (organism)"
          },
          {
            "code" : "56921004",
            "display" : "Perinatal jaundice due to hereditary hemolytic anemia (disorder)"
          },
          {
            "code" : "56925008",
            "display" : "Abnormal sexual function (finding)"
          },
          {
            "code" : "56951005",
            "display" : "Poisoning caused by cardiotonic glycoside (disorder)"
          },
          {
            "code" : "56953008",
            "display" : "Osmolality (observable entity)"
          },
          {
            "code" : "56962005",
            "display" : "Fall on snow (event)"
          },
          {
            "code" : "56975005",
            "display" : "Strawberry nevus of skin (disorder)"
          },
          {
            "code" : "56984005",
            "display" : "Drever dog (organism)"
          },
          {
            "code" : "57019003",
            "display" : "Verruca vulgaris (disorder)"
          },
          {
            "code" : "57034009",
            "display" : "Aortic arch structure (body structure)"
          },
          {
            "code" : "57044006",
            "display" : "Cyst of Bartholin's gland duct (disorder)"
          },
          {
            "code" : "57054005",
            "display" : "Acute myocardial infarction (disorder)"
          },
          {
            "code" : "57092006",
            "display" : "Flexural eczema (disorder)"
          },
          {
            "code" : "57097000",
            "display" : "Altered growth and development: social skills (finding)"
          },
          {
            "code" : "57120006",
            "display" : "Treeing walker coonhound (organism)"
          },
          {
            "code" : "57126000",
            "display" : "Glue (substance)"
          },
          {
            "code" : "57134006",
            "display" : "Instrument, device (physical object)"
          },
          {
            "code" : "57141000",
            "display" : "Apocrine adenocarcinoma (morphologic abnormality)"
          },
          {
            "code" : "57148006",
            "display" : "Congenital anomaly of brain (disorder)"
          },
          {
            "code" : "57160007",
            "display" : "Felty's syndrome (disorder)"
          },
          {
            "code" : "57168000",
            "display" : "Operation on bone (procedure)"
          },
          {
            "code" : "57177007",
            "display" : "Family history with explicit context (situation)"
          },
          {
            "code" : "57182000",
            "display" : "Nerve injury (disorder)"
          },
          {
            "code" : "57183005",
            "display" : "Along edge (qualifier value)"
          },
          {
            "code" : "57190000",
            "display" : "Myopia (disorder)"
          },
          {
            "code" : "57194009",
            "display" : "Adjustment disorder with depressed mood (disorder)"
          },
          {
            "code" : "57195005",
            "display" : "Basal (qualifier value)"
          },
          {
            "code" : "57203004",
            "display" : "Disorder of pulp of tooth (disorder)"
          },
          {
            "code" : "57206007",
            "display" : "Singing (observable entity)"
          },
          {
            "code" : "57207003",
            "display" : "Bullous keratopathy (disorder)"
          },
          {
            "code" : "57217008",
            "display" : "Thompson operation, cleft lip repair (procedure)"
          },
          {
            "code" : "57219006",
            "display" : "Craniosynostosis syndrome (disorder)"
          },
          {
            "code" : "57233006",
            "display" : "Artificial insemination with sperm washing and capacitation (procedure)"
          },
          {
            "code" : "57238002",
            "display" : "Selective embolization of artery (procedure)"
          },
          {
            "code" : "57246001",
            "display" : "Chronic gastric ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "57257006",
            "display" : "Transurethral approach (qualifier value)"
          },
          {
            "code" : "57271003",
            "display" : "Extraperitoneal cesarean section (procedure)"
          },
          {
            "code" : "57311007",
            "display" : "West Nile virus (organism)"
          },
          {
            "code" : "57349006",
            "display" : "Long and short coat chihuahua (organism)"
          },
          {
            "code" : "57383004",
            "display" : "Structure of right branch of atrioventricular bundle (body structure)"
          },
          {
            "code" : "57396003",
            "display" : "Structure of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "57403001",
            "display" : "Gleason grade score 7 out of 10 (finding)"
          },
          {
            "code" : "57405008",
            "display" : "Chenchu (ethnic group)"
          },
          {
            "code" : "57406009",
            "display" : "Carpal tunnel syndrome (disorder)"
          },
          {
            "code" : "57411006",
            "display" : "Colpoperineorrhaphy following delivery (procedure)"
          },
          {
            "code" : "57419008",
            "display" : "Gastroenteritis presumed infectious (disorder)"
          },
          {
            "code" : "57429001",
            "display" : "Longhaired miniature dachshund (organism)"
          },
          {
            "code" : "57438004",
            "display" : "Autopsy, gross and microscopic examination, regional (procedure)"
          },
          {
            "code" : "57485005",
            "display" : "Oxygen therapy (procedure)"
          },
          {
            "code" : "57494004",
            "display" : "Senile exhaustion (finding)"
          },
          {
            "code" : "57514000",
            "display" : "3-Oxo-5 alpha-steroid delta 4-dehydrogenase deficiency (disorder)"
          },
          {
            "code" : "57534004",
            "display" : "Retinal vascular disorder (disorder)"
          },
          {
            "code" : "57539009",
            "display" : "Navaho (ethnic group)"
          },
          {
            "code" : "57597008",
            "display" : "Adenosis (morphologic abnormality)"
          },
          {
            "code" : "57613003",
            "display" : "Kleen leen white pig (organism)"
          },
          {
            "code" : "57630001",
            "display" : "First trimester pregnancy (finding)"
          },
          {
            "code" : "57650002",
            "display" : "Persistent primary tooth (disorder)"
          },
          {
            "code" : "57651003",
            "display" : "Structure of iliocostalis muscle (body structure)"
          },
          {
            "code" : "57653000",
            "display" : "Multiple organ failure (disorder)"
          },
          {
            "code" : "57662003",
            "display" : "Injury of blood vessel (disorder)"
          },
          {
            "code" : "57671007",
            "display" : "Vas deferens structure (body structure)"
          },
          {
            "code" : "57676002",
            "display" : "Joint pain (finding)"
          },
          {
            "code" : "57684003",
            "display" : "Parenchymal renal hypertension (disorder)"
          },
          {
            "code" : "57713008",
            "display" : "Inflammation of vocal cord (disorder)"
          },
          {
            "code" : "57720001",
            "display" : "Anise oil (substance)"
          },
          {
            "code" : "57726007",
            "display" : "Skin structure of crus of helix (body structure)"
          },
          {
            "code" : "57741007",
            "display" : "Fall from bridge (event)"
          },
          {
            "code" : "57748001",
            "display" : "Bleeding ulcer of esophagus (disorder)"
          },
          {
            "code" : "57753006",
            "display" : "Brilliant yellow stain (substance)"
          },
          {
            "code" : "57754000",
            "display" : "Varicose aneurysm (morphologic abnormality)"
          },
          {
            "code" : "57759005",
            "display" : "First degree perineal laceration (disorder)"
          },
          {
            "code" : "57773001",
            "display" : "Rectal prolapse (disorder)"
          },
          {
            "code" : "57781000",
            "display" : "Disorder of vocal cord (disorder)"
          },
          {
            "code" : "57797005",
            "display" : "Induced termination of pregnancy (disorder)"
          },
          {
            "code" : "57805002",
            "display" : "Alternating exotropia with V pattern (disorder)"
          },
          {
            "code" : "57823005",
            "display" : "Structure of left posterior lateral branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "57826002",
            "display" : "Structure of permanent maxillary right first premolar tooth (body structure)"
          },
          {
            "code" : "57849000",
            "display" : "Gordon setter (organism)"
          },
          {
            "code" : "57850000",
            "display" : "Structure of celiac artery (body structure)"
          },
          {
            "code" : "57883007",
            "display" : "Renin test diet (finding)"
          },
          {
            "code" : "57886004",
            "display" : "Protein-deficient diabetes mellitus (disorder)"
          },
          {
            "code" : "57891003",
            "display" : "Term infant (finding)"
          },
          {
            "code" : "57920007",
            "display" : "Herpetic gingivostomatitis (disorder)"
          },
          {
            "code" : "57943003",
            "display" : "Extreme old age (over 100 years) (finding)"
          },
          {
            "code" : "57947002",
            "display" : "Giant schnauzer (organism)"
          },
          {
            "code" : "57952007",
            "display" : "Medicinal product acting as antilipemic agent (product)"
          },
          {
            "code" : "57982001",
            "display" : "Self-bathing/hygiene deficit (finding)"
          },
          {
            "code" : "57993004",
            "display" : "Benign mammary dysplasia (disorder)"
          },
          {
            "code" : "58000006",
            "display" : "Patient discharge (procedure)"
          },
          {
            "code" : "58047002",
            "display" : "Barundi (ethnic group)"
          },
          {
            "code" : "58056005",
            "display" : "Syphilis of mitral valve (disorder)"
          },
          {
            "code" : "58075000",
            "display" : "Contusion of toe (disorder)"
          },
          {
            "code" : "58095006",
            "display" : "Interatrial septum structure (body structure)"
          },
          {
            "code" : "58098008",
            "display" : "Vaccine product containing Clostridium tetani toxoid antigen adsorbed (medicinal product)"
          },
          {
            "code" : "58100008",
            "display" : "Intra-arterial route (qualifier value)"
          },
          {
            "code" : "58103005",
            "display" : "Perianal fistula (disorder)"
          },
          {
            "code" : "58108001",
            "display" : "Golden retriever (organism)"
          },
          {
            "code" : "58116005",
            "display" : "Otter hound (organism)"
          },
          {
            "code" : "58126003",
            "display" : "Postoperative wound infection (disorder)"
          },
          {
            "code" : "58130000",
            "display" : "Structure of jugular lymph node (body structure)"
          },
          {
            "code" : "58150001",
            "display" : "Fracture of clavicle (disorder)"
          },
          {
            "code" : "58170007",
            "display" : "Viral meningitis (disorder)"
          },
          {
            "code" : "58188004",
            "display" : "Traumatic arthropathy (disorder)"
          },
          {
            "code" : "58190003",
            "display" : "Vascular flow, function (observable entity)"
          },
          {
            "code" : "58214004",
            "display" : "Schizophrenia (disorder)"
          },
          {
            "code" : "58219009",
            "display" : "Lactation problem (finding)"
          },
          {
            "code" : "58227000",
            "display" : "Secondary syphilis of viscera (disorder)"
          },
          {
            "code" : "58234003",
            "display" : "Genus Arenavirus (organism)"
          },
          {
            "code" : "58242002",
            "display" : "Mycobacterium leprae (organism)"
          },
          {
            "code" : "58250006",
            "display" : "Scalding pain on urination (finding)"
          },
          {
            "code" : "58261003",
            "display" : "Sacroposterior position (finding)"
          },
          {
            "code" : "58264006",
            "display" : "Pinto (organism)"
          },
          {
            "code" : "58265007",
            "display" : "Giardiasis (disorder)"
          },
          {
            "code" : "58281002",
            "display" : "Gadolinium (substance)"
          },
          {
            "code" : "58311005",
            "display" : "Dutch landrace pig (organism)"
          },
          {
            "code" : "58320001",
            "display" : "Traumatic dislocation of knee joint (disorder)"
          },
          {
            "code" : "58322009",
            "display" : "Expiration (observable entity)"
          },
          {
            "code" : "58341007",
            "display" : "Rough and smooth collie (organism)"
          },
          {
            "code" : "58349009",
            "display" : "Exhibitionism (disorder)"
          },
          {
            "code" : "58381000",
            "display" : "Hypersplenism (disorder)"
          },
          {
            "code" : "58390007",
            "display" : "Allogeneic bone marrow transplantation (procedure)"
          },
          {
            "code" : "58411009",
            "display" : "Broken tooth with complication (disorder)"
          },
          {
            "code" : "58424009",
            "display" : "Overeating (finding)"
          },
          {
            "code" : "58432001",
            "display" : "Saint Louis encephalitis virus (organism)"
          },
          {
            "code" : "58436003",
            "display" : "Increased libido (finding)"
          },
          {
            "code" : "58437007",
            "display" : "Tuberculosis of meninges (disorder)"
          },
          {
            "code" : "58440007",
            "display" : "Non-erotic stimulus (finding)"
          },
          {
            "code" : "58460004",
            "display" : "Blood group O (finding)"
          },
          {
            "code" : "58497009",
            "display" : "Tardy ulnar nerve palsy (finding)"
          },
          {
            "code" : "58503001",
            "display" : "Mycobacterium, avium-intracellulare group (organism)"
          },
          {
            "code" : "58532003",
            "display" : "Unwanted pregnancy (finding)"
          },
          {
            "code" : "58533008",
            "display" : "Artificial insemination (procedure)"
          },
          {
            "code" : "58535001",
            "display" : "Physical AND emotional exhaustion state (disorder)"
          },
          {
            "code" : "58538004",
            "display" : "Bumped into other person (event)"
          },
          {
            "code" : "58541008",
            "display" : "Sodium-24 (substance)"
          },
          {
            "code" : "58554001",
            "display" : "Empyema of pleura (disorder)"
          },
          {
            "code" : "58557008",
            "display" : "Spina bifida aperta (disorder)"
          },
          {
            "code" : "58580000",
            "display" : "Closed supracondylar fracture of humerus (disorder)"
          },
          {
            "code" : "58588007",
            "display" : "Cutis laxa (disorder)"
          },
          {
            "code" : "58602004",
            "display" : "Flank structure (body structure)"
          },
          {
            "code" : "58607005",
            "display" : "Neutron (substance)"
          },
          {
            "code" : "58611004",
            "display" : "Epidural injection of anesthetic substance, therapeutic, lumbar, continuous (procedure)"
          },
          {
            "code" : "58612006",
            "display" : "Acute myocardial infarction of lateral wall (disorder)"
          },
          {
            "code" : "58631000",
            "display" : "Eriochrome blue black SE stain (substance)"
          },
          {
            "code" : "58646007",
            "display" : "Structure of deciduous mandibular right first molar tooth (body structure)"
          },
          {
            "code" : "58648008",
            "display" : "Benign monoclonal gammopathy (disorder)"
          },
          {
            "code" : "58663006",
            "display" : "Mycobacterium xenopi (organism)"
          },
          {
            "code" : "58690002",
            "display" : "Parasomnia (disorder)"
          },
          {
            "code" : "58703003",
            "display" : "Postpartum depression (disorder)"
          },
          {
            "code" : "58718002",
            "display" : "Rheumatic fever (disorder)"
          },
          {
            "code" : "58742003",
            "display" : "Structure of sesamoid bone of foot (body structure)"
          },
          {
            "code" : "58755002",
            "display" : "Water soluble anthracene brown stain (substance)"
          },
          {
            "code" : "58756001",
            "display" : "Huntington's chorea (disorder)"
          },
          {
            "code" : "58759008",
            "display" : "Intertrigo (disorder)"
          },
          {
            "code" : "58762006",
            "display" : "Encephalomalacia (disorder)"
          },
          {
            "code" : "58768005",
            "display" : "Mycobacterium poriferae (organism)"
          },
          {
            "code" : "58776007",
            "display" : "Autologous bone marrow transplant (procedure)"
          },
          {
            "code" : "58790005",
            "display" : "T0 category (finding)"
          },
          {
            "code" : "58797008",
            "display" : "Complication of transplanted kidney (disorder)"
          },
          {
            "code" : "58833000",
            "display" : "Pseudohypoparathyroidism type I A (disorder)"
          },
          {
            "code" : "58840004",
            "display" : "Decreased breath sounds (finding)"
          },
          {
            "code" : "58849003",
            "display" : "Aspiration of food (finding)"
          },
          {
            "code" : "58855008",
            "display" : "Symptomatic exhibitionism (disorder)"
          },
          {
            "code" : "58863009",
            "display" : "Initial implantation of cardiac dual-chamber device (procedure)"
          },
          {
            "code" : "58869008",
            "display" : "Mycobacterium marinum (organism)"
          },
          {
            "code" : "58888001",
            "display" : "Parti-color cocker spaniel (organism)"
          },
          {
            "code" : "58895005",
            "display" : "Central convulsion (finding)"
          },
          {
            "code" : "58903006",
            "display" : "Breech presentation, single footling (finding)"
          },
          {
            "code" : "58908002",
            "display" : "Exposure to attack by amphibian (event)"
          },
          {
            "code" : "58923007",
            "display" : "Legionella cincinnatiensis (organism)"
          },
          {
            "code" : "58925000",
            "display" : "Gleason grade score 9 out of 10 (finding)"
          },
          {
            "code" : "58928003",
            "display" : "Campylobacter sputorum ss. sputorum (organism)"
          },
          {
            "code" : "58939000",
            "display" : "Legionella hackeliae (organism)"
          },
          {
            "code" : "58949002",
            "display" : "Tubo-ovarian abscess (disorder)"
          },
          {
            "code" : "58963008",
            "display" : "Acrophobia (finding)"
          },
          {
            "code" : "58972000",
            "display" : "Dribbling of urine (finding)"
          },
          {
            "code" : "58976002",
            "display" : "Pseudohypoparathyroidism (disorder)"
          },
          {
            "code" : "59011009",
            "display" : "Structure of basilar artery (body structure)"
          },
          {
            "code" : "59021001",
            "display" : "Angina decubitus (disorder)"
          },
          {
            "code" : "59026006",
            "display" : "Blepharospasm (disorder)"
          },
          {
            "code" : "59037007",
            "display" : "Intolerance to drug (finding)"
          },
          {
            "code" : "59050008",
            "display" : "Initial insomnia (disorder)"
          },
          {
            "code" : "59057006",
            "display" : "Product containing antihemophilic factor agent (medicinal product)"
          },
          {
            "code" : "59058001",
            "display" : "General physician (occupation)"
          },
          {
            "code" : "59066005",
            "display" : "Mastoid structure (body structure)"
          },
          {
            "code" : "59073000",
            "display" : "Tactile hypesthesia (finding)"
          },
          {
            "code" : "59079001",
            "display" : "Diabetes mellitus associated with hormonal etiology (disorder)"
          },
          {
            "code" : "59082006",
            "display" : "Urokinase (substance)"
          },
          {
            "code" : "59083001",
            "display" : "Genus Neisseria (organism)"
          },
          {
            "code" : "59108006",
            "display" : "Injection (procedure)"
          },
          {
            "code" : "59112000",
            "display" : "Skin structure of anus (body structure)"
          },
          {
            "code" : "59118001",
            "display" : "Right bundle branch block (disorder)"
          },
          {
            "code" : "59174009",
            "display" : "Fetishism (disorder)"
          },
          {
            "code" : "59210004",
            "display" : "Navajo sheep (organism)"
          },
          {
            "code" : "59213002",
            "display" : "Repair of ruptured supraspinatus tendon, acute (procedure)"
          },
          {
            "code" : "59214008",
            "display" : "Reduction mammoplasty (procedure)"
          },
          {
            "code" : "59218006",
            "display" : "Temporary transcutaneous pacing (procedure)"
          },
          {
            "code" : "59223006",
            "display" : "Juvenile (finding)"
          },
          {
            "code" : "59233003",
            "display" : "Secondary syphilis of skin (disorder)"
          },
          {
            "code" : "59250001",
            "display" : "Ehrlichia chaffeensis (organism)"
          },
          {
            "code" : "59274003",
            "display" : "Intentional drug overdose (disorder)"
          },
          {
            "code" : "59276001",
            "display" : "Proliferative retinopathy due to diabetes mellitus (disorder)"
          },
          {
            "code" : "59282003",
            "display" : "Pulmonary embolism (disorder)"
          },
          {
            "code" : "59300005",
            "display" : "Operation on spleen (procedure)"
          },
          {
            "code" : "59307008",
            "display" : "Syphilitic alopecia (disorder)"
          },
          {
            "code" : "59351004",
            "display" : "Citrate (substance)"
          },
          {
            "code" : "59366001",
            "display" : "Ibo (ethnic group)"
          },
          {
            "code" : "59374000",
            "display" : "Traveler's aid clinic (environment)"
          },
          {
            "code" : "59393003",
            "display" : "Hidradenitis suppurativa (disorder)"
          },
          {
            "code" : "59394009",
            "display" : "Sexual sadism (disorder)"
          },
          {
            "code" : "59397002",
            "display" : "C5 certainty (qualifier value)"
          },
          {
            "code" : "59400006",
            "display" : "Analgesic nephropathy (disorder)"
          },
          {
            "code" : "59403008",
            "display" : "Premature birth of newborn female (finding)"
          },
          {
            "code" : "59438005",
            "display" : "Structure of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "59441001",
            "display" : "Structure of lymph node (body structure)"
          },
          {
            "code" : "59450004",
            "display" : "Mixed sex play (finding)"
          },
          {
            "code" : "59455009",
            "display" : "Metabolic acidosis (disorder)"
          },
          {
            "code" : "59466002",
            "display" : "Second trimester pregnancy (finding)"
          },
          {
            "code" : "59479006",
            "display" : "Mesangiocapillary glomerulonephritis, type II (disorder)"
          },
          {
            "code" : "59487007",
            "display" : "Syrians (ethnic group)"
          },
          {
            "code" : "59492009",
            "display" : "Longhaired standard dachshund (organism)"
          },
          {
            "code" : "59503006",
            "display" : "Structure of submandibular lymph node (body structure)"
          },
          {
            "code" : "59510000",
            "display" : "Struck by cave-in (event)"
          },
          {
            "code" : "59523007",
            "display" : "Herpes simplex disciform keratitis (disorder)"
          },
          {
            "code" : "59527008",
            "display" : "Congenital cytomegalovirus infection (disorder)"
          },
          {
            "code" : "59528003",
            "display" : "Saluki dog (organism)"
          },
          {
            "code" : "59530001",
            "display" : "Syphilis of kidney (disorder)"
          },
          {
            "code" : "59533004",
            "display" : "Food additive (substance)"
          },
          {
            "code" : "59543001",
            "display" : "Autopsy, clerical procedure (procedure)"
          },
          {
            "code" : "59545008",
            "display" : "Pesticide (substance)"
          },
          {
            "code" : "59552005",
            "display" : "Normal ejaculation (finding)"
          },
          {
            "code" : "59566000",
            "display" : "Oligohydramnios (disorder)"
          },
          {
            "code" : "59573005",
            "display" : "Potassium measurement (procedure)"
          },
          {
            "code" : "59582004",
            "display" : "Hepatitis B core antibody measurement (procedure)"
          },
          {
            "code" : "59597001",
            "display" : "Marshallese (ethnic group)"
          },
          {
            "code" : "59614000",
            "display" : "Occult blood in stools (finding)"
          },
          {
            "code" : "59617007",
            "display" : "Severe depressed bipolar I disorder with psychotic features (disorder)"
          },
          {
            "code" : "59621000",
            "display" : "Essential hypertension (disorder)"
          },
          {
            "code" : "59631007",
            "display" : "Anomalous pulmonary venous drainage (disorder)"
          },
          {
            "code" : "59643008",
            "display" : "French bulldog (organism)"
          },
          {
            "code" : "59645001",
            "display" : "Bulimia nervosa, nonpurging type (disorder)"
          },
          {
            "code" : "59652004",
            "display" : "Atrial structure (body structure)"
          },
          {
            "code" : "59657005",
            "display" : "Intestinal bypass for morbid obesity (procedure)"
          },
          {
            "code" : "59667000",
            "display" : "FHC elite pig 2 (organism)"
          },
          {
            "code" : "59698003",
            "display" : "Disorder of conjunctiva (disorder)"
          },
          {
            "code" : "59703009",
            "display" : "Cervical arthrodesis by anterior technique (procedure)"
          },
          {
            "code" : "59712006",
            "display" : "Evacuation of subdural hematoma (procedure)"
          },
          {
            "code" : "59720008",
            "display" : "Sustained diastolic hypertension (disorder)"
          },
          {
            "code" : "59749000",
            "display" : "Structure of lacrimal artery (body structure)"
          },
          {
            "code" : "59752008",
            "display" : "Dorsal funiculus structure (body structure)"
          },
          {
            "code" : "59754009",
            "display" : "Brief atonic seizure (finding)"
          },
          {
            "code" : "59770006",
            "display" : "Dyslexia (finding)"
          },
          {
            "code" : "59774002",
            "display" : "Monkeypox virus (organism)"
          },
          {
            "code" : "59801003",
            "display" : "Rhodium (substance)"
          },
          {
            "code" : "59819007",
            "display" : "Herpetic ulceration of vulva (disorder)"
          },
          {
            "code" : "59820001",
            "display" : "Blood vessel structure (body structure)"
          },
          {
            "code" : "59843005",
            "display" : "Furuncle (morphologic abnormality)"
          },
          {
            "code" : "59844004",
            "display" : "Potassium-42 (substance)"
          },
          {
            "code" : "59848001",
            "display" : "Obstructive hyperbilirubinemia (disorder)"
          },
          {
            "code" : "59857007",
            "display" : "Branchial cleft cyst (disorder)"
          },
          {
            "code" : "59881000",
            "display" : "Rabies virus (organism)"
          },
          {
            "code" : "59883002",
            "display" : "Cellulitis of abdominal wall (disorder)"
          },
          {
            "code" : "59890007",
            "display" : "Paralytic lagophthalmos (finding)"
          },
          {
            "code" : "59913009",
            "display" : "Gastric ulcer without hemorrhage, without perforation AND without obstruction (disorder)"
          },
          {
            "code" : "59923000",
            "display" : "Panic disorder with agoraphobia AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "59927004",
            "display" : "Hepatic failure (disorder)"
          },
          {
            "code" : "59934002",
            "display" : "Secondary syphilitic adenopathy (disorder)"
          },
          {
            "code" : "59935001",
            "display" : "Functional heart murmur (finding)"
          },
          {
            "code" : "59941008",
            "display" : "Product containing diltiazem (medicinal product)"
          },
          {
            "code" : "59972007",
            "display" : "Atrial systole, function (observable entity)"
          },
          {
            "code" : "59975009",
            "display" : "English foxhound (organism)"
          },
          {
            "code" : "59978006",
            "display" : "Cigar smoker (finding)"
          },
          {
            "code" : "60001007",
            "display" : "Not pregnant (finding)"
          },
          {
            "code" : "60005003",
            "display" : "Pectoralis major muscle structure (body structure)"
          },
          {
            "code" : "60028002",
            "display" : "Structure of uterine vein (body structure)"
          },
          {
            "code" : "60032008",
            "display" : "Unable to concentrate (finding)"
          },
          {
            "code" : "60046008",
            "display" : "Pleural effusion (disorder)"
          },
          {
            "code" : "60057003",
            "display" : "Thallium-201 (substance)"
          },
          {
            "code" : "60058008",
            "display" : "Sprain of cruciate ligament of knee (disorder)"
          },
          {
            "code" : "60074003",
            "display" : "Abduction, function (observable entity)"
          },
          {
            "code" : "60098005",
            "display" : "Cyst of vulva (disorder)"
          },
          {
            "code" : "60105000",
            "display" : "Structure of tapetum of corpus callosum (body structure)"
          },
          {
            "code" : "60106004",
            "display" : "Common arterial trunk and separate origin of pulmonary arteries (disorder)"
          },
          {
            "code" : "60113004",
            "display" : "Disorder of eyelid (disorder)"
          },
          {
            "code" : "60119000",
            "display" : "Exhaustion (finding)"
          },
          {
            "code" : "60132005",
            "display" : "Generalized (qualifier value)"
          },
          {
            "code" : "60157000",
            "display" : "Ellice Islanders (ethnic group)"
          },
          {
            "code" : "60168000",
            "display" : "Osteomyelitis (disorder)"
          },
          {
            "code" : "60176003",
            "display" : "Structure of anterior cerebral artery (body structure)"
          },
          {
            "code" : "60184004",
            "display" : "Sigmoid colon structure (body structure)"
          },
          {
            "code" : "60189009",
            "display" : "Vitreous degeneration (disorder)"
          },
          {
            "code" : "60198007",
            "display" : "Furuncle of axilla (disorder)"
          },
          {
            "code" : "60213007",
            "display" : "Intramedullary route (qualifier value)"
          },
          {
            "code" : "60227002",
            "display" : "Subaortic common iliac lymph node (body structure)"
          },
          {
            "code" : "60234000",
            "display" : "Aortic valve regurgitation (disorder)"
          },
          {
            "code" : "60241006",
            "display" : "Female urinary stress incontinence (finding)"
          },
          {
            "code" : "60252000",
            "display" : "Pug dog (organism)"
          },
          {
            "code" : "60257006",
            "display" : "Neonatal death of male (within 7 days, World Health Organization) (event)"
          },
          {
            "code" : "60280003",
            "display" : "Normal intraocular pressure (finding)"
          },
          {
            "code" : "60331006",
            "display" : "Abnormal auditory perception (disorder)"
          },
          {
            "code" : "60332004",
            "display" : "Trichiasis (disorder)"
          },
          {
            "code" : "60342002",
            "display" : "Movement disorder (disorder)"
          },
          {
            "code" : "60366008",
            "display" : "Injury of pulmonary vein (disorder)"
          },
          {
            "code" : "60369001",
            "display" : "Bathing patient (procedure)"
          },
          {
            "code" : "60380001",
            "display" : "Narcolepsy (disorder)"
          },
          {
            "code" : "60389000",
            "display" : "Paraplegia (disorder)"
          },
          {
            "code" : "60393006",
            "display" : "Juvenile homoerotism (finding)"
          },
          {
            "code" : "60404007",
            "display" : "Cerebral abscess (disorder)"
          },
          {
            "code" : "60423000",
            "display" : "Sinus node dysfunction (disorder)"
          },
          {
            "code" : "60441008",
            "display" : "Trypan blue stain (substance)"
          },
          {
            "code" : "60442001",
            "display" : "Perforation of tympanic membrane (disorder)"
          },
          {
            "code" : "60459006",
            "display" : "Iron (59-Fe) dextran (substance)"
          },
          {
            "code" : "60476005",
            "display" : "Deep overbite (disorder)"
          },
          {
            "code" : "60477001",
            "display" : "Entire posterior vein of left ventricle (body structure)"
          },
          {
            "code" : "60496002",
            "display" : "Skin structure of foot (body structure)"
          },
          {
            "code" : "60498001",
            "display" : "Congenital viral hepatitis B infection (disorder)"
          },
          {
            "code" : "60502008",
            "display" : "Francisella tularensis subspecies holarctica (organism)"
          },
          {
            "code" : "60507002",
            "display" : "Hiatal hernia with gangrene AND obstruction (disorder)"
          },
          {
            "code" : "60517007",
            "display" : "Cardigan Welsh corgi (organism)"
          },
          {
            "code" : "60528006",
            "display" : "Secondary syphilis of mouth (disorder)"
          },
          {
            "code" : "60533005",
            "display" : "Medicinal product acting as astringent (product)"
          },
          {
            "code" : "60558000",
            "display" : "Mycobacterium thamnophis (organism)"
          },
          {
            "code" : "60573004",
            "display" : "Aortic valve stenosis (disorder)"
          },
          {
            "code" : "60583000",
            "display" : "Postaxial (qualifier value)"
          },
          {
            "code" : "60585007",
            "display" : "Slum area living (finding)"
          },
          {
            "code" : "60588009",
            "display" : "Dengue virus, type 1 (organism)"
          },
          {
            "code" : "60594001",
            "display" : "Fall while being carried (event)"
          },
          {
            "code" : "60600009",
            "display" : "Disorder of the larynx (disorder)"
          },
          {
            "code" : "60614009",
            "display" : "Natural brother (person)"
          },
          {
            "code" : "60621009",
            "display" : "Body mass index (observable entity)"
          },
          {
            "code" : "60656008",
            "display" : "Corneal transplant (procedure)"
          },
          {
            "code" : "60667009",
            "display" : "Closed fracture of rib (disorder)"
          },
          {
            "code" : "60689008",
            "display" : "Home care of patient (regime/therapy)"
          },
          {
            "code" : "60698006",
            "display" : "Hemorrhagic esophagitis (disorder)"
          },
          {
            "code" : "60700002",
            "display" : "Sensorineural hearing loss (disorder)"
          },
          {
            "code" : "60704006",
            "display" : "Penile erection (finding)"
          },
          {
            "code" : "60713008",
            "display" : "Burn of neck (disorder)"
          },
          {
            "code" : "60728008",
            "display" : "Swollen abdomen (finding)"
          },
          {
            "code" : "60732002",
            "display" : "Atrial septal defect with endocardial cushion defect, partial type (disorder)"
          },
          {
            "code" : "60734001",
            "display" : "Great saphenous vein structure (body structure)"
          },
          {
            "code" : "60735000",
            "display" : "Lagophthalmos (finding)"
          },
          {
            "code" : "60739006",
            "display" : "Waxoline blue stain (substance)"
          },
          {
            "code" : "60797005",
            "display" : "Cardiac wall motion, function (observable entity)"
          },
          {
            "code" : "60812006",
            "display" : "Giant cell myocarditis (disorder)"
          },
          {
            "code" : "60817000",
            "display" : "Campylobacter fetus ss. venerealis (organism)"
          },
          {
            "code" : "60819002",
            "display" : "Cheek structure (body structure)"
          },
          {
            "code" : "60826002",
            "display" : "Coccidioidomycosis (disorder)"
          },
          {
            "code" : "60835009",
            "display" : "Structure of postductal region of aortic arch (body structure)"
          },
          {
            "code" : "60845006",
            "display" : "Dyspnea on exertion (finding)"
          },
          {
            "code" : "60853003",
            "display" : "Disorder of magnesium metabolism (disorder)"
          },
          {
            "code" : "60862001",
            "display" : "Tinnitus (finding)"
          },
          {
            "code" : "60864000",
            "display" : "Autopsy review for conference (procedure)"
          },
          {
            "code" : "60876000",
            "display" : "Gardner syndrome (disorder)"
          },
          {
            "code" : "60890002",
            "display" : "Female sterilization (procedure)"
          },
          {
            "code" : "60897004",
            "display" : "Contusion of nose (disorder)"
          },
          {
            "code" : "60899001",
            "display" : "Hypertensive heart disease without congestive heart failure (disorder)"
          },
          {
            "code" : "60911003",
            "display" : "Temporal bone structure (body structure)"
          },
          {
            "code" : "60920007",
            "display" : "Fuchsin acid stain (substance)"
          },
          {
            "code" : "60927005",
            "display" : "Chlamydophila psittaci variant felis (organism)"
          },
          {
            "code" : "60929008",
            "display" : "Miscellaneous diet (finding)"
          },
          {
            "code" : "60937000",
            "display" : "Degeneration of lumbosacral intervertebral disc (disorder)"
          },
          {
            "code" : "60944009",
            "display" : "Skin structure of external genitalia (body structure)"
          },
          {
            "code" : "60958006",
            "display" : "Maryland pig (organism)"
          },
          {
            "code" : "60965003",
            "display" : "Structure of epigastric lymph node (body structure)"
          },
          {
            "code" : "60996007",
            "display" : "Structure of deep lymph node (body structure)"
          },
          {
            "code" : "61020000",
            "display" : "Product containing thyroid hormone (medicinal product)"
          },
          {
            "code" : "61026006",
            "display" : "G3 grade (finding)"
          },
          {
            "code" : "61036003",
            "display" : "Boar power pig 545 (organism)"
          },
          {
            "code" : "61048000",
            "display" : "Gonococcal endocarditis (disorder)"
          },
          {
            "code" : "61068006",
            "display" : "Thioflavine T stain (substance)"
          },
          {
            "code" : "61078009",
            "display" : "Progesterone receptor (substance)"
          },
          {
            "code" : "61083001",
            "display" : "Minnesota pig (organism)"
          },
          {
            "code" : "61086009",
            "display" : "Pulse irregular (finding)"
          },
          {
            "code" : "61088005",
            "display" : "Plastic (substance)"
          },
          {
            "code" : "61152003",
            "display" : "Moderate intellectual disability (disorder)"
          },
          {
            "code" : "61157009",
            "display" : "Combat fatigue (disorder)"
          },
          {
            "code" : "61167004",
            "display" : "Thyroid stimulating hormone measurement (procedure)"
          },
          {
            "code" : "61170000",
            "display" : "Stomatitis (disorder)"
          },
          {
            "code" : "61212007",
            "display" : "Panic disorder with agoraphobia, severe agoraphobic avoidance AND severe panic attacks (disorder)"
          },
          {
            "code" : "61242005",
            "display" : "Lateral canthus structure (body structure)"
          },
          {
            "code" : "61248009",
            "display" : "Skin structure of anterior surface of thigh (body structure)"
          },
          {
            "code" : "61253004",
            "display" : "Erosion of cervix (disorder)"
          },
          {
            "code" : "61261009",
            "display" : "Hemolytic anemia (disorder)"
          },
          {
            "code" : "61267008",
            "display" : "Retinal neovascularization (disorder)"
          },
          {
            "code" : "61281005",
            "display" : "Bloodstained sputum (finding)"
          },
          {
            "code" : "61286000",
            "display" : "Pudelpointer (organism)"
          },
          {
            "code" : "61288004",
            "display" : "Poisoning caused by venomous snake (disorder)"
          },
          {
            "code" : "61310001",
            "display" : "Nutrition education (procedure)"
          },
          {
            "code" : "61320006",
            "display" : "Tahltan bear dog (organism)"
          },
          {
            "code" : "61336008",
            "display" : "Hypocholesterolemia (disorder)"
          },
          {
            "code" : "61347001",
            "display" : "Acute duodenal ulcer with perforation (disorder)"
          },
          {
            "code" : "61372001",
            "display" : "Aggressive behavior (finding)"
          },
          {
            "code" : "61387006",
            "display" : "Moderate anxiety (finding)"
          },
          {
            "code" : "61397002",
            "display" : "Subcapsular (qualifier value)"
          },
          {
            "code" : "61399004",
            "display" : "Keystone virus (organism)"
          },
          {
            "code" : "61401005",
            "display" : "Gastric hemorrhage (disorder)"
          },
          {
            "code" : "61403008",
            "display" : "Severe depressed bipolar I disorder without psychotic features (disorder)"
          },
          {
            "code" : "61405001",
            "display" : "Scottish terrier (organism)"
          },
          {
            "code" : "61419001",
            "display" : "Giardia (organism)"
          },
          {
            "code" : "61420007",
            "display" : "Tube feeding of patient (regime/therapy)"
          },
          {
            "code" : "61462000",
            "display" : "Malaria (disorder)"
          },
          {
            "code" : "61486003",
            "display" : "Sacral back pain (finding)"
          },
          {
            "code" : "61490001",
            "display" : "Angina, class I (disorder)"
          },
          {
            "code" : "61492009",
            "display" : "Structure of hepatic lymph node (body structure)"
          },
          {
            "code" : "61498008",
            "display" : "Complete external hemorrhoidectomy (procedure)"
          },
          {
            "code" : "61501008",
            "display" : "Forensic autopsy, extensive (procedure)"
          },
          {
            "code" : "61536007",
            "display" : "Peripheral retinal degeneration (disorder)"
          },
          {
            "code" : "61552005",
            "display" : "Ventricular rhythm from artificial pacing (finding)"
          },
          {
            "code" : "61569007",
            "display" : "Agoraphobia without history of panic disorder (disorder)"
          },
          {
            "code" : "61578001",
            "display" : "Abnormal digestive tract function (finding)"
          },
          {
            "code" : "61582004",
            "display" : "Allergic rhinitis (disorder)"
          },
          {
            "code" : "61586001",
            "display" : "Delivery by vacuum extraction (procedure)"
          },
          {
            "code" : "61593002",
            "display" : "Ultrasonic guidance procedure (procedure)"
          },
          {
            "code" : "61599003",
            "display" : "Phlebitis (disorder)"
          },
          {
            "code" : "61612001",
            "display" : "Syphilitic aortic incompetence (disorder)"
          },
          {
            "code" : "61627001",
            "display" : "Hyperchlorhydria (disorder)"
          },
          {
            "code" : "61660003",
            "display" : "Entire umbilical portion of portal vein (body structure)"
          },
          {
            "code" : "61661004",
            "display" : "Operative procedure on foot (procedure)"
          },
          {
            "code" : "61671002",
            "display" : "Structure of internal acoustic meatus of temporal bone (body structure)"
          },
          {
            "code" : "61683000",
            "display" : "Drop attack (finding)"
          },
          {
            "code" : "61685007",
            "display" : "Lower limb structure (body structure)"
          },
          {
            "code" : "61686008",
            "display" : "Physical exercise (observable entity)"
          },
          {
            "code" : "61695000",
            "display" : "Tunica media vasorum (body structure)"
          },
          {
            "code" : "61700007",
            "display" : "Influenza with non-respiratory manifestation (disorder)"
          },
          {
            "code" : "61708000",
            "display" : "Mycobacterium farcinogenes (organism)"
          },
          {
            "code" : "61716009",
            "display" : "Krypton-81m (substance)"
          },
          {
            "code" : "61719002",
            "display" : "Skin of vertex (body structure)"
          },
          {
            "code" : "61745006",
            "display" : "High protein, high fat, low carbohydrate diet (finding)"
          },
          {
            "code" : "61746007",
            "display" : "Taking patient vital signs (procedure)"
          },
          {
            "code" : "61753003",
            "display" : "Colorpoint shorthaired cat (organism)"
          },
          {
            "code" : "61758007",
            "display" : "Exstrophy of bladder sequence (disorder)"
          },
          {
            "code" : "61773008",
            "display" : "Lidocaine hydrochloride (substance)"
          },
          {
            "code" : "61774002",
            "display" : "Repair of rotator cuff by suture (procedure)"
          },
          {
            "code" : "61789006",
            "display" : "Dye (substance)"
          },
          {
            "code" : "61804006",
            "display" : "Alveolitis of jaw (disorder)"
          },
          {
            "code" : "61819007",
            "display" : "Rachischisis (disorder)"
          },
          {
            "code" : "61846002",
            "display" : "Male adolescent aberrant sex behavior (finding)"
          },
          {
            "code" : "61853006",
            "display" : "Spinal canal structure (body structure)"
          },
          {
            "code" : "61868007",
            "display" : "Structure of deciduous mandibular right second molar tooth (body structure)"
          },
          {
            "code" : "61897005",
            "display" : "Structure of permanent maxillary left first premolar tooth (body structure)"
          },
          {
            "code" : "61917005",
            "display" : "Bitemporal hemianopia (finding)"
          },
          {
            "code" : "61919008",
            "display" : "Giving patient an enema (procedure)"
          },
          {
            "code" : "61928009",
            "display" : "Platelet count (procedure)"
          },
          {
            "code" : "61937009",
            "display" : "Simple chronic bronchitis (disorder)"
          },
          {
            "code" : "61946003",
            "display" : "Product containing estrogen (product)"
          },
          {
            "code" : "61947007",
            "display" : "Deaf mutism (disorder)"
          },
          {
            "code" : "61949005",
            "display" : "Toxoplasma (organism)"
          },
          {
            "code" : "61959006",
            "display" : "Common truncus arteriosus (disorder)"
          },
          {
            "code" : "61960001",
            "display" : "Lordosis deformity of spine (disorder)"
          },
          {
            "code" : "61962009",
            "display" : "Midbrain structure (body structure)"
          },
          {
            "code" : "61968008",
            "display" : "Syringe, device (physical object)"
          },
          {
            "code" : "61973002",
            "display" : "Dekalb hybrid pig line 61 (organism)"
          },
          {
            "code" : "61977001",
            "display" : "Chronic type B viral hepatitis (disorder)"
          },
          {
            "code" : "62013009",
            "display" : "Ambulating patient (procedure)"
          },
          {
            "code" : "62014003",
            "display" : "Adverse reaction caused by drug (disorder)"
          },
          {
            "code" : "62026008",
            "display" : "Left posterior fascicular block (disorder)"
          },
          {
            "code" : "62064005",
            "display" : "Mesothelioma, malignant (morphologic abnormality)"
          },
          {
            "code" : "62065006",
            "display" : "Genus Rickettsia (organism)"
          },
          {
            "code" : "62067003",
            "display" : "Hypoplastic left heart syndrome (disorder)"
          },
          {
            "code" : "62106007",
            "display" : "Concussion with no loss of consciousness (disorder)"
          },
          {
            "code" : "62137007",
            "display" : "Labrador retriever (organism)"
          },
          {
            "code" : "62141006",
            "display" : "Radical excision (procedure)"
          },
          {
            "code" : "62153005",
            "display" : "Blonde d'Aquitaine (organism)"
          },
          {
            "code" : "62189002",
            "display" : "Ulcerated atheromatous plaque (morphologic abnormality)"
          },
          {
            "code" : "62195001",
            "display" : "Lumbosacral neuritis (disorder)"
          },
          {
            "code" : "62207008",
            "display" : "Syphilitic ostial coronary disease (disorder)"
          },
          {
            "code" : "62224002",
            "display" : "Abscess of appendix (disorder)"
          },
          {
            "code" : "62228004",
            "display" : "English Springer spaniel (organism)"
          },
          {
            "code" : "62247001",
            "display" : "Family medicine specialist (occupation)"
          },
          {
            "code" : "62296006",
            "display" : "Natural grandfather (person)"
          },
          {
            "code" : "62315008",
            "display" : "Diarrhea (finding)"
          },
          {
            "code" : "62330004",
            "display" : "Decreased muscle function (finding)"
          },
          {
            "code" : "62351001",
            "display" : "Generalized social phobia (disorder)"
          },
          {
            "code" : "62372003",
            "display" : "Segmental (qualifier value)"
          },
          {
            "code" : "62377009",
            "display" : "Postpartum cardiomyopathy (disorder)"
          },
          {
            "code" : "62382002",
            "display" : "Calcinosis, Raynaud's phenomenon, sclerodactyly, and telangiectasia syndrome (disorder)"
          },
          {
            "code" : "62394006",
            "display" : "Female pelvic peritoneal adhesions (disorder)"
          },
          {
            "code" : "62413002",
            "display" : "Bone structure of radius (body structure)"
          },
          {
            "code" : "62415009",
            "display" : "Delayed articulatory and language development (finding)"
          },
          {
            "code" : "62430000",
            "display" : "Breathy attack, function (observable entity)"
          },
          {
            "code" : "62438007",
            "display" : "Transplantation of pancreas (procedure)"
          },
          {
            "code" : "62442005",
            "display" : "Chloriodized oil (substance)"
          },
          {
            "code" : "62452009",
            "display" : "Subjective tinnitus (finding)"
          },
          {
            "code" : "62455006",
            "display" : "N0 category (finding)"
          },
          {
            "code" : "62459000",
            "display" : "Chronic persistent (qualifier value)"
          },
          {
            "code" : "62476001",
            "display" : "Disorientated (finding)"
          },
          {
            "code" : "62479008",
            "display" : "Acquired immune deficiency syndrome (disorder)"
          },
          {
            "code" : "62480006",
            "display" : "Psychiatric hospital (environment)"
          },
          {
            "code" : "62482003",
            "display" : "Low (qualifier value)"
          },
          {
            "code" : "62491004",
            "display" : "Frotteurism (disorder)"
          },
          {
            "code" : "62496009",
            "display" : "Genus Bartonella (organism)"
          },
          {
            "code" : "62507009",
            "display" : "Pins and needles (finding)"
          },
          {
            "code" : "62508004",
            "display" : "Mid forceps delivery (procedure)"
          },
          {
            "code" : "62517004",
            "display" : "Sodium chromate (51-Cr) (substance)"
          },
          {
            "code" : "62531004",
            "display" : "Placenta previa marginalis (disorder)"
          },
          {
            "code" : "62548007",
            "display" : "Nocturnal cough (finding)"
          },
          {
            "code" : "62555009",
            "display" : "Structure of atlantoaxial joint (body structure)"
          },
          {
            "code" : "62564004",
            "display" : "Concussion with loss of consciousness (disorder)"
          },
          {
            "code" : "62579006",
            "display" : "Structure of vestibular surface of tooth (body structure)"
          },
          {
            "code" : "62587007",
            "display" : "Jerry Slough virus (organism)"
          },
          {
            "code" : "62598008",
            "display" : "Venezuelan Indians (ethnic group)"
          },
          {
            "code" : "62607004",
            "display" : "Orgasm incapacity (finding)"
          },
          {
            "code" : "62619007",
            "display" : "Ill-defined disorder of eye (disorder)"
          },
          {
            "code" : "62629000",
            "display" : "Diastasis recti (disorder)"
          },
          {
            "code" : "62644004",
            "display" : "Mycobacterium pulveris (organism)"
          },
          {
            "code" : "62647006",
            "display" : "Painful spasm of anus (disorder)"
          },
          {
            "code" : "62667002",
            "display" : "Congenital deviation of nasal septum (disorder)"
          },
          {
            "code" : "62682007",
            "display" : "50 gram fat diet (finding)"
          },
          {
            "code" : "62683002",
            "display" : "Mediastinal lymph node structure (body structure)"
          },
          {
            "code" : "62695002",
            "display" : "Acute anteroseptal myocardial infarction (disorder)"
          },
          {
            "code" : "62709005",
            "display" : "Suburban dweller (finding)"
          },
          {
            "code" : "62718007",
            "display" : "Dribbling from mouth (finding)"
          },
          {
            "code" : "62736007",
            "display" : "Lower eyelid structure (body structure)"
          },
          {
            "code" : "62742006",
            "display" : "Cradle cap (disorder)"
          },
          {
            "code" : "62744007",
            "display" : "Orthopnea (finding)"
          },
          {
            "code" : "62745008",
            "display" : "Injury of ulnar nerve (disorder)"
          },
          {
            "code" : "62748005",
            "display" : "Borrelia hermsii (organism)"
          },
          {
            "code" : "62786001",
            "display" : "Restoration, inlay, composite/resin (procedure)"
          },
          {
            "code" : "62790004",
            "display" : "Norfolk terrier (organism)"
          },
          {
            "code" : "62792007",
            "display" : "Urophilia (disorder)"
          },
          {
            "code" : "62815003",
            "display" : "Incomplete bilateral cleft lip (disorder)"
          },
          {
            "code" : "62818001",
            "display" : "Adenohypophysis structure (body structure)"
          },
          {
            "code" : "62824007",
            "display" : "Transverse (qualifier value)"
          },
          {
            "code" : "62834003",
            "display" : "Upper gastrointestinal tract structure (body structure)"
          },
          {
            "code" : "62837005",
            "display" : "Cellulitis of hand (disorder)"
          },
          {
            "code" : "62851005",
            "display" : "Impaction of intestine (disorder)"
          },
          {
            "code" : "62856000",
            "display" : "Nonobliterative otosclerosis involving oval window (disorder)"
          },
          {
            "code" : "62861003",
            "display" : "Secondary syphilis, relapse (untreated) (disorder)"
          },
          {
            "code" : "62869001",
            "display" : "Structure of central vein of the retina (body structure)"
          },
          {
            "code" : "62872008",
            "display" : "Structure of anterior commissure (body structure)"
          },
          {
            "code" : "62881002",
            "display" : "Removal of cardiac pacemaker (procedure)"
          },
          {
            "code" : "62909004",
            "display" : "Ectropion of eyelid (disorder)"
          },
          {
            "code" : "62914000",
            "display" : "Cerebrovascular disease (disorder)"
          },
          {
            "code" : "62944002",
            "display" : "Hepatitis C virus (organism)"
          },
          {
            "code" : "62987004",
            "display" : "Vibrio cholerae, O1 (organism)"
          },
          {
            "code" : "62994001",
            "display" : "Tracheitis (disorder)"
          },
          {
            "code" : "63016009",
            "display" : "Total resection of urinary bladder (procedure)"
          },
          {
            "code" : "63029009",
            "display" : "Skin structure of gluteal fold (body structure)"
          },
          {
            "code" : "63042009",
            "display" : "Congenital atresia of tricuspid valve (disorder)"
          },
          {
            "code" : "63102001",
            "display" : "Visual disturbance (disorder)"
          },
          {
            "code" : "63103006",
            "display" : "Xanthomatosis (disorder)"
          },
          {
            "code" : "63112008",
            "display" : "Bone wire, device (physical object)"
          },
          {
            "code" : "63130001",
            "display" : "Surgical scar (morphologic abnormality)"
          },
          {
            "code" : "63144007",
            "display" : "Vulvitis (disorder)"
          },
          {
            "code" : "63161005",
            "display" : "Principal (qualifier value)"
          },
          {
            "code" : "63181006",
            "display" : "Paranoid schizophrenia in remission (disorder)"
          },
          {
            "code" : "63183009",
            "display" : "Primary idiopathic hypertrophic cardiomyopathy (disorder)"
          },
          {
            "code" : "63195009",
            "display" : "Sexual exhaustion (finding)"
          },
          {
            "code" : "63198006",
            "display" : "Chondromalacia (disorder)"
          },
          {
            "code" : "63225009",
            "display" : "Offensive body odor (finding)"
          },
          {
            "code" : "63234004",
            "display" : "Divorce, life event (finding)"
          },
          {
            "code" : "63238001",
            "display" : "Dead on arrival at hospital (finding)"
          },
          {
            "code" : "63247009",
            "display" : "Williams syndrome (disorder)"
          },
          {
            "code" : "63249007",
            "display" : "Manic bipolar I disorder in partial remission (disorder)"
          },
          {
            "code" : "63264007",
            "display" : "Carcinosarcoma (morphologic abnormality)"
          },
          {
            "code" : "63269002",
            "display" : "American coonhound (organism)"
          },
          {
            "code" : "63287004",
            "display" : "Benign essential hypertension in obstetric context (disorder)"
          },
          {
            "code" : "63289001",
            "display" : "Surgical metal nail, device (physical object)"
          },
          {
            "code" : "63305008",
            "display" : "Stricture of esophagus (disorder)"
          },
          {
            "code" : "63332003",
            "display" : "History AND physical examination (procedure)"
          },
          {
            "code" : "63337009",
            "display" : "Structure of abdominopelvic segment of trunk (body structure)"
          },
          {
            "code" : "63338004",
            "display" : "Drug flavoring (product)"
          },
          {
            "code" : "63339007",
            "display" : "Disorder of uterine cervix (disorder)"
          },
          {
            "code" : "63360001",
            "display" : "Zirconium-89 (substance)"
          },
          {
            "code" : "63363004",
            "display" : "Superior vena cava syndrome (disorder)"
          },
          {
            "code" : "63384009",
            "display" : "Distorted body image (finding)"
          },
          {
            "code" : "63390008",
            "display" : "Portuguese water dog (organism)"
          },
          {
            "code" : "63398001",
            "display" : "Bacterial infection caused by Pseudomonas (disorder)"
          },
          {
            "code" : "63409001",
            "display" : "Struck by firearm discharge (event)"
          },
          {
            "code" : "63438003",
            "display" : "Coitus condomatus (finding)"
          },
          {
            "code" : "63440008",
            "display" : "Verruca plantaris (disorder)"
          },
          {
            "code" : "63457007",
            "display" : "Maya (ethnic group)"
          },
          {
            "code" : "63467002",
            "display" : "Left bundle branch block (disorder)"
          },
          {
            "code" : "63480004",
            "display" : "Chronic bronchitis (disorder)"
          },
          {
            "code" : "63487001",
            "display" : "Assisted fertilization (procedure)"
          },
          {
            "code" : "63491006",
            "display" : "Intermittent claudication (finding)"
          },
          {
            "code" : "63501000",
            "display" : "Prurigo nodularis (disorder)"
          },
          {
            "code" : "63507001",
            "display" : "Structure of external iliac vein (body structure)"
          },
          {
            "code" : "63526009",
            "display" : "Cardiac semi-soft 2 gram sodium diet (finding)"
          },
          {
            "code" : "63532004",
            "display" : "Multiple diverticula of intestine (finding)"
          },
          {
            "code" : "63537005",
            "display" : "Protected sexual intercourse (finding)"
          },
          {
            "code" : "63557009",
            "display" : "Sex exploration (finding)"
          },
          {
            "code" : "63562005",
            "display" : "Cervical collar, device (physical object)"
          },
          {
            "code" : "63565007",
            "display" : "Congenital anemia (disorder)"
          },
          {
            "code" : "63567004",
            "display" : "Uranostaphyloschisis (disorder)"
          },
          {
            "code" : "63593006",
            "display" : "Supraventricular premature beats (disorder)"
          },
          {
            "code" : "63634009",
            "display" : "Glioblastoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "63643000",
            "display" : "Derangement of knee (disorder)"
          },
          {
            "code" : "63697000",
            "display" : "Cardiopulmonary bypass operation (procedure)"
          },
          {
            "code" : "63701002",
            "display" : "Panic disorder with agoraphobia, mild agoraphobic avoidance AND mild panic attacks (disorder)"
          },
          {
            "code" : "63702009",
            "display" : "Alstrom syndrome (disorder)"
          },
          {
            "code" : "63722008",
            "display" : "Chronic vomiting (disorder)"
          },
          {
            "code" : "63732001",
            "display" : "New Hebrideans (ethnic group)"
          },
          {
            "code" : "63736003",
            "display" : "Taiwanese (ethnic group)"
          },
          {
            "code" : "63740007",
            "display" : "Mechanical regular diet (finding)"
          },
          {
            "code" : "63750008",
            "display" : "Oblique lie (disorder)"
          },
          {
            "code" : "63751007",
            "display" : "Secondary syphilis of bone (disorder)"
          },
          {
            "code" : "63754004",
            "display" : "Yttrium (substance)"
          },
          {
            "code" : "63762007",
            "display" : "Both breasts (body structure)"
          },
          {
            "code" : "63766005",
            "display" : "Flour (substance)"
          },
          {
            "code" : "63835008",
            "display" : "Voyeurism (disorder)"
          },
          {
            "code" : "63871009",
            "display" : "Third degree uterine prolapse (disorder)"
          },
          {
            "code" : "63901009",
            "display" : "Pain in testicle (finding)"
          },
          {
            "code" : "63909006",
            "display" : "Panic disorder with agoraphobia AND panic attacks in partial remission (disorder)"
          },
          {
            "code" : "63929007",
            "display" : "Alkali blue 6B stain (substance)"
          },
          {
            "code" : "63938009",
            "display" : "Chlamydia trachomatis (organism)"
          },
          {
            "code" : "63951004",
            "display" : "Miliaria (disorder)"
          },
          {
            "code" : "63972001",
            "display" : "Ocicat (organism)"
          },
          {
            "code" : "63973006",
            "display" : "Seduction of female (finding)"
          },
          {
            "code" : "63988001",
            "display" : "Intermittent exotropia (disorder)"
          },
          {
            "code" : "64008009",
            "display" : "Hemimelia of upper limb (disorder)"
          },
          {
            "code" : "64009001",
            "display" : "Basilar artery syndrome (disorder)"
          },
          {
            "code" : "64033007",
            "display" : "Kidney structure (body structure)"
          },
          {
            "code" : "64038003",
            "display" : "Intercostal lymph node (body structure)"
          },
          {
            "code" : "64044004",
            "display" : "Self-esteem disturbance (finding)"
          },
          {
            "code" : "64060000",
            "display" : "Panic disorder with agoraphobia, moderate agoraphobic avoidance AND panic attacks in full remission (disorder)"
          },
          {
            "code" : "64102008",
            "display" : "Syphilitic gumma (disorder)"
          },
          {
            "code" : "64109004",
            "display" : "Costal chondritis (disorder)"
          },
          {
            "code" : "64112001",
            "display" : "Fast blue RR salt stain (substance)"
          },
          {
            "code" : "64117007",
            "display" : "Vitamin B12 deficiency (non anemic) (disorder)"
          },
          {
            "code" : "64121000",
            "display" : "Peptic ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "64131007",
            "display" : "Inferior vena cava structure (body structure)"
          },
          {
            "code" : "64144002",
            "display" : "Pruritic rash (disorder)"
          },
          {
            "code" : "64156001",
            "display" : "Thrombophlebitis (disorder)"
          },
          {
            "code" : "64158000",
            "display" : "Angora goat (organism)"
          },
          {
            "code" : "64165008",
            "display" : "Avoidant disorder of childhood (disorder)"
          },
          {
            "code" : "64206003",
            "display" : "Hypomenorrhea (finding)"
          },
          {
            "code" : "64226004",
            "display" : "Colitis (disorder)"
          },
          {
            "code" : "64228003",
            "display" : "Paralysis of diaphragm (disorder)"
          },
          {
            "code" : "64229006",
            "display" : "Traumatic lesion during delivery (disorder)"
          },
          {
            "code" : "64233004",
            "display" : "Embryonic cyst of fimbria of fallopian tube (disorder)"
          },
          {
            "code" : "64234005",
            "display" : "Bone structure of patella (body structure)"
          },
          {
            "code" : "64253000",
            "display" : "Implantation of heart assist system (procedure)"
          },
          {
            "code" : "64266000",
            "display" : "Sister-sister sex play (finding)"
          },
          {
            "code" : "64298006",
            "display" : "Acquired deformity of distal interphalangeal joint of finger due to trauma (disorder)"
          },
          {
            "code" : "64300006",
            "display" : "Oxalate restricted diet (finding)"
          },
          {
            "code" : "64309007",
            "display" : "Trigeminal nerve disorder (disorder)"
          },
          {
            "code" : "64313000",
            "display" : "Alteration in family processes (finding)"
          },
          {
            "code" : "64318009",
            "display" : "Diagnostic radiography, stereotactic localization (procedure)"
          },
          {
            "code" : "64368001",
            "display" : "Partial mastectomy (procedure)"
          },
          {
            "code" : "64375000",
            "display" : "Acute laryngotracheitis (disorder)"
          },
          {
            "code" : "64379006",
            "display" : "Decrease in appetite (finding)"
          },
          {
            "code" : "64386003",
            "display" : "Sedative abuse (disorder)"
          },
          {
            "code" : "64411004",
            "display" : "Hepatitis C antibody measurement (procedure)"
          },
          {
            "code" : "64433002",
            "display" : "Left sacroanterior position (finding)"
          },
          {
            "code" : "64455005",
            "display" : "Fracture of acetabulum (disorder)"
          },
          {
            "code" : "64458007",
            "display" : "Contusion of lip (disorder)"
          },
          {
            "code" : "64460009",
            "display" : "Hyperalimentation formula for intestinal fistula (finding)"
          },
          {
            "code" : "64468002",
            "display" : "Structure of bronchial artery (body structure)"
          },
          {
            "code" : "64479007",
            "display" : "Pneumonia caused by Klebsiella pneumoniae (disorder)"
          },
          {
            "code" : "64483007",
            "display" : "Indians (Hindi-speaking) (ethnic group)"
          },
          {
            "code" : "64488003",
            "display" : "Iodinated (125-I) human serum albumin (substance)"
          },
          {
            "code" : "64520006",
            "display" : "Protamine sulfate (substance)"
          },
          {
            "code" : "64531003",
            "display" : "Nasal discharge (finding)"
          },
          {
            "code" : "64552006",
            "display" : "Noninflammatory disorder of fallopian tube (disorder)"
          },
          {
            "code" : "64556009",
            "display" : "Structure of intermediate common iliac lymph node (body structure)"
          },
          {
            "code" : "64557000",
            "display" : "Disorder of male genital organ (disorder)"
          },
          {
            "code" : "64572001",
            "display" : "Disease (disorder)"
          },
          {
            "code" : "64576003",
            "display" : "Abscess of buttock (disorder)"
          },
          {
            "code" : "64586002",
            "display" : "Carotid artery stenosis (disorder)"
          },
          {
            "code" : "64589009",
            "display" : "Campylobacter fetus ss. fetus (organism)"
          },
          {
            "code" : "64591001",
            "display" : "Karakul sheep (organism)"
          },
          {
            "code" : "64605006",
            "display" : "Bone structure of distal tibia (body structure)"
          },
          {
            "code" : "64613007",
            "display" : "Inflammation of small intestine (disorder)"
          },
          {
            "code" : "64634000",
            "display" : "Corneal opacity (disorder)"
          },
          {
            "code" : "64635004",
            "display" : "Congenital nystagmus (disorder)"
          },
          {
            "code" : "64658001",
            "display" : "Structure of subcostal muscle (body structure)"
          },
          {
            "code" : "64665009",
            "display" : "Closed fracture of calcaneus (disorder)"
          },
          {
            "code" : "64667001",
            "display" : "Interstitial pneumonia (disorder)"
          },
          {
            "code" : "64688005",
            "display" : "Bone structure of coccyx (body structure)"
          },
          {
            "code" : "64693008",
            "display" : "Hungarian (ethnic group)"
          },
          {
            "code" : "64694002",
            "display" : "Human rotavirus (organism)"
          },
          {
            "code" : "64702000",
            "display" : "Tear production, function (observable entity)"
          },
          {
            "code" : "64715009",
            "display" : "Hypertensive heart disease (disorder)"
          },
          {
            "code" : "64728002",
            "display" : "Fracture of spine due to birth trauma (disorder)"
          },
          {
            "code" : "64730000",
            "display" : "Normal sinus rhythm (finding)"
          },
          {
            "code" : "64739004",
            "display" : "Seminal vesicle structure (body structure)"
          },
          {
            "code" : "64766004",
            "display" : "Ulcerative colitis (disorder)"
          },
          {
            "code" : "64779008",
            "display" : "Blood coagulation disorder (disorder)"
          },
          {
            "code" : "64817005",
            "display" : "Anesthesia for vaginal delivery (procedure)"
          },
          {
            "code" : "64859006",
            "display" : "Osteoporosis (disorder)"
          },
          {
            "code" : "64889004",
            "display" : "Haemophilus ducreyi (organism)"
          },
          {
            "code" : "64902007",
            "display" : "Closed fracture of olecranon process of ulna (disorder)"
          },
          {
            "code" : "64905009",
            "display" : "Paranoid schizophrenia (disorder)"
          },
          {
            "code" : "64915003",
            "display" : "Operation on heart (procedure)"
          },
          {
            "code" : "64917006",
            "display" : "Parainfluenza virus pneumonia (disorder)"
          },
          {
            "code" : "64930007",
            "display" : "Legionella spiritensis (organism)"
          },
          {
            "code" : "64957009",
            "display" : "Uncertain (qualifier value)"
          },
          {
            "code" : "64969001",
            "display" : "Partial congenital absence of teeth (disorder)"
          },
          {
            "code" : "64970000",
            "display" : "Substance type unknown (finding)"
          },
          {
            "code" : "64978007",
            "display" : "Radionuclide therapy for hyperthyroidism (procedure)"
          },
          {
            "code" : "64979004",
            "display" : "California encephalitis virus (organism)"
          },
          {
            "code" : "64991008",
            "display" : "Soluble berlin blue stain (substance)"
          },
          {
            "code" : "64996003",
            "display" : "Intermenstrual bleeding - irregular (finding)"
          },
          {
            "code" : "65001009",
            "display" : "Recurrent pyogenic cholangitis (disorder)"
          },
          {
            "code" : "65017003",
            "display" : "Hereditary peripheral neuropathy (disorder)"
          },
          {
            "code" : "65046005",
            "display" : "Infertility therapy (procedure)"
          },
          {
            "code" : "65054007",
            "display" : "Zinc-62 (substance)"
          },
          {
            "code" : "65064003",
            "display" : "Panic disorder without agoraphobia with moderate panic attacks (disorder)"
          },
          {
            "code" : "65074000",
            "display" : "Iritis (disorder)"
          },
          {
            "code" : "65108000",
            "display" : "At risk for violence (finding)"
          },
          {
            "code" : "65118005",
            "display" : "Marital problems (finding)"
          },
          {
            "code" : "65120008",
            "display" : "Generalized convulsive epilepsy (disorder)"
          },
          {
            "code" : "65123005",
            "display" : "Choline (substance)"
          },
          {
            "code" : "65124004",
            "display" : "Swelling (finding)"
          },
          {
            "code" : "65147003",
            "display" : "Twin pregnancy (disorder)"
          },
          {
            "code" : "65153003",
            "display" : "Art therapy (regime/therapy)"
          },
          {
            "code" : "65172003",
            "display" : "Pemphigus (disorder)"
          },
          {
            "code" : "65186004",
            "display" : "Klebsiella pneumoniae ss. ozaenae (organism)"
          },
          {
            "code" : "65187008",
            "display" : "Black faced Highland sheep (organism)"
          },
          {
            "code" : "65194006",
            "display" : "Night blindness (disorder)"
          },
          {
            "code" : "65197004",
            "display" : "Structure of anulus fibrosus of mitral orifice (body structure)"
          },
          {
            "code" : "65198009",
            "display" : "Arterial thrombosis (disorder)"
          },
          {
            "code" : "65200003",
            "display" : "Insertion of intrauterine contraceptive device (procedure)"
          },
          {
            "code" : "65205008",
            "display" : "Blastomyces (organism)"
          },
          {
            "code" : "65216001",
            "display" : "Cerebrospinal fluid (substance)"
          },
          {
            "code" : "65240009",
            "display" : "Obstetrical version (procedure)"
          },
          {
            "code" : "65255000",
            "display" : "Yersinia enterocolitica (organism)"
          },
          {
            "code" : "65260001",
            "display" : "Cervical spondylosis with myelopathy (disorder)"
          },
          {
            "code" : "65266007",
            "display" : "Structure of deep inguinal lymph node (body structure)"
          },
          {
            "code" : "65275009",
            "display" : "Acute cholecystitis (disorder)"
          },
          {
            "code" : "65295003",
            "display" : "Acute gonococcal endometritis (disorder)"
          },
          {
            "code" : "65323003",
            "display" : "Polymyalgia rheumatica (disorder)"
          },
          {
            "code" : "65340007",
            "display" : "Aneurysm of heart (disorder)"
          },
          {
            "code" : "65344003",
            "display" : "Marchigiana cattle breed (organism)"
          },
          {
            "code" : "65345002",
            "display" : "Epoxy resin (substance)"
          },
          {
            "code" : "65349008",
            "display" : "Structure of external iliac lymph node (body structure)"
          },
          {
            "code" : "65355003",
            "display" : "Right common carotid artery structure (body structure)"
          },
          {
            "code" : "65358001",
            "display" : "Acquired hallux valgus (disorder)"
          },
          {
            "code" : "65362007",
            "display" : "Acquired cavovarus deformity of foot (disorder)"
          },
          {
            "code" : "65363002",
            "display" : "Otitis media (disorder)"
          },
          {
            "code" : "65364008",
            "display" : "Both ureters (body structure)"
          },
          {
            "code" : "65388005",
            "display" : "Ultrasonic guidance for amniocentesis (procedure)"
          },
          {
            "code" : "65399007",
            "display" : "Langerhans cell histiocytosis (disorder)"
          },
          {
            "code" : "65402008",
            "display" : "Pre-existing hypertension complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "65410009",
            "display" : "Compulsive sexual masochism (disorder)"
          },
          {
            "code" : "65421000",
            "display" : "Living in tent (finding)"
          },
          {
            "code" : "65431007",
            "display" : "Structure of corneal endothelium (body structure)"
          },
          {
            "code" : "65443008",
            "display" : "Malignant hypertensive renal disease (disorder)"
          },
          {
            "code" : "65445001",
            "display" : "Ethyl violet stain (substance)"
          },
          {
            "code" : "65492002",
            "display" : "Lincoln sheep (organism)"
          },
          {
            "code" : "65508009",
            "display" : "Granuloma annulare (disorder)"
          },
          {
            "code" : "65518004",
            "display" : "Labile diastolic hypertension (disorder)"
          },
          {
            "code" : "65520001",
            "display" : "Primary hyperoxaluria, type I (disorder)"
          },
          {
            "code" : "65551008",
            "display" : "Radical retropubic prostatectomy (procedure)"
          },
          {
            "code" : "65553006",
            "display" : "Aspergillosis (disorder)"
          },
          {
            "code" : "65565005",
            "display" : "T4 category (finding)"
          },
          {
            "code" : "65568007",
            "display" : "Cigarette smoker (finding)"
          },
          {
            "code" : "65576009",
            "display" : "Polyp of cervix (disorder)"
          },
          {
            "code" : "65577000",
            "display" : "X-ray shield, device (physical object)"
          },
          {
            "code" : "65579002",
            "display" : "Chronic renal failure diet (finding)"
          },
          {
            "code" : "65580004",
            "display" : "Alizarin red S stain (substance)"
          },
          {
            "code" : "65587001",
            "display" : "Congenital anomaly of cerebrovascular system (disorder)"
          },
          {
            "code" : "65598000",
            "display" : "Glottal stop, function (observable entity)"
          },
          {
            "code" : "65613000",
            "display" : "Mycobacterium szulgai (organism)"
          },
          {
            "code" : "65615007",
            "display" : "Blastomyces dermatitidis (organism)"
          },
          {
            "code" : "65619001",
            "display" : "Rectovaginal fistula (disorder)"
          },
          {
            "code" : "65624003",
            "display" : "Structure of deciduous maxillary right lateral incisor tooth (body structure)"
          },
          {
            "code" : "65636009",
            "display" : "Keratoconus (disorder)"
          },
          {
            "code" : "65656005",
            "display" : "Natural mother (person)"
          },
          {
            "code" : "65659003",
            "display" : "Atherectomy by rotary cutter (procedure)"
          },
          {
            "code" : "65668001",
            "display" : "Otorrhea (disorder)"
          },
          {
            "code" : "65680009",
            "display" : "Sensorineural hearing loss of combined sites (disorder)"
          },
          {
            "code" : "65690001",
            "display" : "Structure of paratracheal lymph node (body structure)"
          },
          {
            "code" : "65692009",
            "display" : "Spindle cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "65694005",
            "display" : "Siamese cat (organism)"
          },
          {
            "code" : "65709003",
            "display" : "Disseminated (qualifier value)"
          },
          {
            "code" : "65710008",
            "display" : "Acute respiratory failure (disorder)"
          },
          {
            "code" : "65727000",
            "display" : "Intrauterine pregnancy (finding)"
          },
          {
            "code" : "65730007",
            "display" : "Ponceau 3R stain (substance)"
          },
          {
            "code" : "65754002",
            "display" : "Primary dysmenorrhea (disorder)"
          },
          {
            "code" : "65774009",
            "display" : "Digitalis (organism)"
          },
          {
            "code" : "65776006",
            "display" : "Blackfeet (ethnic group)"
          },
          {
            "code" : "65801008",
            "display" : "Excision (procedure)"
          },
          {
            "code" : "65814009",
            "display" : "Subluxation of lens (disorder)"
          },
          {
            "code" : "65818007",
            "display" : "Stent (physical object)"
          },
          {
            "code" : "65854006",
            "display" : "Reexcision (procedure)"
          },
          {
            "code" : "65877006",
            "display" : "Fibroadenoma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "65911000",
            "display" : "Hepatitis B surface antibody measurement (procedure)"
          },
          {
            "code" : "65937002",
            "display" : "Imperforate hymen (disorder)"
          },
          {
            "code" : "65956007",
            "display" : "Legal blindness (disorder)"
          },
          {
            "code" : "65958008",
            "display" : "Hiccoughs (finding)"
          },
          {
            "code" : "65959000",
            "display" : "Beta thalassemia (disorder)"
          },
          {
            "code" : "65966004",
            "display" : "Fracture of forearm (disorder)"
          },
          {
            "code" : "65978000",
            "display" : "Injury of chest wall (disorder)"
          },
          {
            "code" : "66019005",
            "display" : "Limb structure (body structure)"
          },
          {
            "code" : "66071002",
            "display" : "Viral hepatitis type B (disorder)"
          },
          {
            "code" : "66108005",
            "display" : "Primary degenerative dementia of the Alzheimer type, senile onset, uncomplicated (disorder)"
          },
          {
            "code" : "66112004",
            "display" : "Closed fracture of sternum (disorder)"
          },
          {
            "code" : "66123000",
            "display" : "Ulcer on tongue (disorder)"
          },
          {
            "code" : "66130006",
            "display" : "Left to right cardiovascular shunt (finding)"
          },
          {
            "code" : "66168008",
            "display" : "Hanoverian horse (organism)"
          },
          {
            "code" : "66187002",
            "display" : "Fatty stool (finding)"
          },
          {
            "code" : "66214007",
            "display" : "Substance abuse (disorder)"
          },
          {
            "code" : "66257002",
            "display" : "Psychosexual phase (finding)"
          },
          {
            "code" : "66281009",
            "display" : "Secondary syphilitic chorioretinitis (disorder)"
          },
          {
            "code" : "66288003",
            "display" : "Skin structure of infraclavicular region (body structure)"
          },
          {
            "code" : "66303006",
            "display" : "Structure of maxillary left second molar tooth (body structure)"
          },
          {
            "code" : "66308002",
            "display" : "Fracture of humerus (disorder)"
          },
          {
            "code" : "66314009",
            "display" : "Longhorn cattle breed (organism)"
          },
          {
            "code" : "66344007",
            "display" : "Recurrent major depression (disorder)"
          },
          {
            "code" : "66347000",
            "display" : "Impulse control disorder (disorder)"
          },
          {
            "code" : "66377006",
            "display" : "Radionuclide localization of tumor, limited area (procedure)"
          },
          {
            "code" : "66379009",
            "display" : "Bacterial overgrowth syndrome (disorder)"
          },
          {
            "code" : "66381006",
            "display" : "Adjustment disorder with mixed disturbance of emotions AND conduct (disorder)"
          },
          {
            "code" : "66383009",
            "display" : "Gingivitis (disorder)"
          },
          {
            "code" : "66391000",
            "display" : "Traction (procedure)"
          },
          {
            "code" : "66402002",
            "display" : "Peritoneal dialysis education (procedure)"
          },
          {
            "code" : "66406004",
            "display" : "Huasteco (ethnic group)"
          },
          {
            "code" : "66459002",
            "display" : "Unilateral (qualifier value)"
          },
          {
            "code" : "66471008",
            "display" : "Oral stage of deglutition (observable entity)"
          },
          {
            "code" : "66485003",
            "display" : "Retinal scar (disorder)"
          },
          {
            "code" : "66493003",
            "display" : "Product containing theophylline (medicinal product)"
          },
          {
            "code" : "66495005",
            "display" : "Cavalier King Charles spaniel (organism)"
          },
          {
            "code" : "66539004",
            "display" : "Carbohydrate restricted diet (finding)"
          },
          {
            "code" : "66540002",
            "display" : "Back strain of thoracic region (disorder)"
          },
          {
            "code" : "66543000",
            "display" : "Campylobacter jejuni (organism)"
          },
          {
            "code" : "66559000",
            "display" : "Structure of common hepatic artery (body structure)"
          },
          {
            "code" : "66562002",
            "display" : "Cigarette smoking tobacco (substance)"
          },
          {
            "code" : "66569006",
            "display" : "Retained dental root (disorder)"
          },
          {
            "code" : "66590003",
            "display" : "Alcohol dependence (disorder)"
          },
          {
            "code" : "66601000",
            "display" : "Artificial insemination, homologous (procedure)"
          },
          {
            "code" : "66631006",
            "display" : "Moderate depressed bipolar I disorder (disorder)"
          },
          {
            "code" : "66635002",
            "display" : "Vibrio cholerae serotype Ogawa (organism)"
          },
          {
            "code" : "66643007",
            "display" : "Skin structure of back (body structure)"
          },
          {
            "code" : "66657009",
            "display" : "Paroxysmal ventricular tachycardia (disorder)"
          },
          {
            "code" : "66677002",
            "display" : "Compulsive overt homosexual state (finding)"
          },
          {
            "code" : "66692001",
            "display" : "Repair of ruptured supraspinatus tendon, chronic (procedure)"
          },
          {
            "code" : "66712005",
            "display" : "Bouvier des Flandres (organism)"
          },
          {
            "code" : "66720007",
            "display" : "Lateral ventricle structure (body structure)"
          },
          {
            "code" : "66739002",
            "display" : "Abdominal approach (qualifier value)"
          },
          {
            "code" : "66754008",
            "display" : "Appendix structure (body structure)"
          },
          {
            "code" : "66760008",
            "display" : "Optic neuritis (disorder)"
          },
          {
            "code" : "66787007",
            "display" : "Cephalic (qualifier value)"
          },
          {
            "code" : "66838002",
            "display" : "Mycobacterium duvalii (organism)"
          },
          {
            "code" : "66857006",
            "display" : "Hemoptysis (finding)"
          },
          {
            "code" : "66859009",
            "display" : "Product containing dipyridamole (medicinal product)"
          },
          {
            "code" : "66862007",
            "display" : "Radiologist (occupation)"
          },
          {
            "code" : "66887000",
            "display" : "Late syphilis, latent (positive serology, negative cephalospinal fluid 2 years after) (disorder)"
          },
          {
            "code" : "66889002",
            "display" : "Terminal esophageal web (disorder)"
          },
          {
            "code" : "66893008",
            "display" : "Subacute endocarditis (disorder)"
          },
          {
            "code" : "66911005",
            "display" : "Galloway cattle breed (organism)"
          },
          {
            "code" : "66920001",
            "display" : "Amerind (ethnic group)"
          },
          {
            "code" : "66925006",
            "display" : "Copper (substance)"
          },
          {
            "code" : "66926007",
            "display" : "Closed fracture of femoral condyle of femur (disorder)"
          },
          {
            "code" : "66931009",
            "display" : "Hypercalcemia (disorder)"
          },
          {
            "code" : "66934001",
            "display" : "Skin structure of lower lip (body structure)"
          },
          {
            "code" : "66940008",
            "display" : "Mycobacterium aichiense (organism)"
          },
          {
            "code" : "66944004",
            "display" : "Autoimmune thyroiditis (disorder)"
          },
          {
            "code" : "66948001",
            "display" : "Cleft palate with cleft lip (disorder)"
          },
          {
            "code" : "66951008",
            "display" : "Carotid endarterectomy (procedure)"
          },
          {
            "code" : "66961001",
            "display" : "Natural childbirth class education (procedure)"
          },
          {
            "code" : "66962008",
            "display" : "Suture granuloma (disorder)"
          },
          {
            "code" : "66985009",
            "display" : "18q partial trisomy syndrome (disorder)"
          },
          {
            "code" : "66999008",
            "display" : "Hyperparathyroidism (disorder)"
          },
          {
            "code" : "67023009",
            "display" : "Lymphocytosis (disorder)"
          },
          {
            "code" : "67038005",
            "display" : "Nonspecific ulcerative proctitis (disorder)"
          },
          {
            "code" : "67046006",
            "display" : "Structure of fovea centralis (body structure)"
          },
          {
            "code" : "67088002",
            "display" : "English toy spaniel (organism)"
          },
          {
            "code" : "67101007",
            "display" : "TX category (finding)"
          },
          {
            "code" : "67125004",
            "display" : "Latent syphilis with positive serology (disorder)"
          },
          {
            "code" : "67148009",
            "display" : "Arthritis of great toe due to gout (disorder)"
          },
          {
            "code" : "67162002",
            "display" : "Smells of urine (finding)"
          },
          {
            "code" : "67165000",
            "display" : "Lapps (ethnic group)"
          },
          {
            "code" : "67168003",
            "display" : "Cryptococcus neoformans (organism)"
          },
          {
            "code" : "67170007",
            "display" : "Lumen of artery (body structure)"
          },
          {
            "code" : "67175002",
            "display" : "Impaired home maintenance management (finding)"
          },
          {
            "code" : "67190003",
            "display" : "Free-standing clinic (environment)"
          },
          {
            "code" : "67195008",
            "display" : "Acute stress disorder (disorder)"
          },
          {
            "code" : "67198005",
            "display" : "Paroxysmal supraventricular tachycardia (disorder)"
          },
          {
            "code" : "67223001",
            "display" : "Fall on escalator (event)"
          },
          {
            "code" : "67224007",
            "display" : "Reactive arthritis triad (disorder)"
          },
          {
            "code" : "67227000",
            "display" : "Pedophilia, same sex (disorder)"
          },
          {
            "code" : "67270000",
            "display" : "Hip prosthesis, device (physical object)"
          },
          {
            "code" : "67278007",
            "display" : "Congenital stenosis of pulmonary valve (disorder)"
          },
          {
            "code" : "67279004",
            "display" : "Injury of median nerve (disorder)"
          },
          {
            "code" : "67289000",
            "display" : "Anterior open bite (disorder)"
          },
          {
            "code" : "67308009",
            "display" : "Administration of vaccine product containing only Yellow fever virus antigen (procedure)"
          },
          {
            "code" : "67315001",
            "display" : "Degenerative joint disease of shoulder region (disorder)"
          },
          {
            "code" : "67321002",
            "display" : "Acquired deformity of hip (disorder)"
          },
          {
            "code" : "67324005",
            "display" : "Rice (substance)"
          },
          {
            "code" : "67338003",
            "display" : "Cardiac catheterization, left heart, transseptal (procedure)"
          },
          {
            "code" : "67341007",
            "display" : "Longitudinal deficiency of limb (disorder)"
          },
          {
            "code" : "67359005",
            "display" : "Pre-eclampsia added to pre-existing hypertension (disorder)"
          },
          {
            "code" : "67362008",
            "display" : "Aortic aneurysm (disorder)"
          },
          {
            "code" : "67372006",
            "display" : "Conjunctivitis caused by acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "67391006",
            "display" : "Syphilitic endocarditis (disorder)"
          },
          {
            "code" : "67406007",
            "display" : "Disseminated intravascular coagulation (disorder)"
          },
          {
            "code" : "67414001",
            "display" : "Cotswold sheep (organism)"
          },
          {
            "code" : "67437007",
            "display" : "Lumbar spondylosis with myelopathy (disorder)"
          },
          {
            "code" : "67438002",
            "display" : "Poisoning caused by anticoagulant (disorder)"
          },
          {
            "code" : "67439005",
            "display" : "Msutu (ethnic group)"
          },
          {
            "code" : "67440007",
            "display" : "Product containing alpha adrenergic receptor antagonist (product)"
          },
          {
            "code" : "67448000",
            "display" : "German Fleck-Vieh cattle breed (organism)"
          },
          {
            "code" : "67453005",
            "display" : "Bone structure of talus (body structure)"
          },
          {
            "code" : "67507000",
            "display" : "Medicinal product acting as antiarrhythmic agent (product)"
          },
          {
            "code" : "67515002",
            "display" : "Corriedale sheep (organism)"
          },
          {
            "code" : "67531005",
            "display" : "Spina bifida (disorder)"
          },
          {
            "code" : "67536000",
            "display" : "Arthropathy associated with a neurological disorder (disorder)"
          },
          {
            "code" : "67557008",
            "display" : "Laparoscopic cholecystectomy with exploration of common duct (procedure)"
          },
          {
            "code" : "67564005",
            "display" : "Social maladjustment (finding)"
          },
          {
            "code" : "67569000",
            "display" : "Bronchopulmonary dysplasia of newborn (disorder)"
          },
          {
            "code" : "67591007",
            "display" : "School maladjustment (finding)"
          },
          {
            "code" : "67599009",
            "display" : "Pulmonary congestion (disorder)"
          },
          {
            "code" : "67617000",
            "display" : "Intraductal hyperplasia (morphologic abnormality)"
          },
          {
            "code" : "67624004",
            "display" : "Abscess of Bartholin's gland (disorder)"
          },
          {
            "code" : "67629009",
            "display" : "Catheterization of left heart (procedure)"
          },
          {
            "code" : "67673008",
            "display" : "T2 category (finding)"
          },
          {
            "code" : "67678004",
            "display" : "Acute atopic conjunctivitis (disorder)"
          },
          {
            "code" : "67684001",
            "display" : "Pekingese dog (organism)"
          },
          {
            "code" : "67690002",
            "display" : "Sodium iodide (123-I) (substance)"
          },
          {
            "code" : "67696008",
            "display" : "Rheumatic tricuspid valve regurgitation (disorder)"
          },
          {
            "code" : "67701001",
            "display" : "Inferior cerebellar peduncle structure (body structure)"
          },
          {
            "code" : "67716003",
            "display" : "Epidural injection of anesthetic substance, therapeutic, caudal, continuous (procedure)"
          },
          {
            "code" : "67720004",
            "display" : "FHC elite pig 5 (organism)"
          },
          {
            "code" : "67722007",
            "display" : "At risk for joint contractures (finding)"
          },
          {
            "code" : "67732000",
            "display" : "Khasan virus (organism)"
          },
          {
            "code" : "67750007",
            "display" : "Ineffective airway clearance (finding)"
          },
          {
            "code" : "67754003",
            "display" : "Aortic valve sclerosis (disorder)"
          },
          {
            "code" : "67763001",
            "display" : "Hypotensive episode (disorder)"
          },
          {
            "code" : "67766009",
            "display" : "Intestinal adhesions with obstruction (disorder)"
          },
          {
            "code" : "67782005",
            "display" : "Acute respiratory distress syndrome (disorder)"
          },
          {
            "code" : "67787004",
            "display" : "Tongue tie (disorder)"
          },
          {
            "code" : "67793007",
            "display" : "Allo-erotism (finding)"
          },
          {
            "code" : "67801009",
            "display" : "Tenosynovitis (disorder)"
          },
          {
            "code" : "67834006",
            "display" : "Structure of deciduous mandibular right central incisor tooth (body structure)"
          },
          {
            "code" : "67849003",
            "display" : "Excruciating pain (finding)"
          },
          {
            "code" : "67873006",
            "display" : "Isolated prolactin deficiency (disorder)"
          },
          {
            "code" : "67882000",
            "display" : "Pruritus of vulva (disorder)"
          },
          {
            "code" : "67905004",
            "display" : "Acute-on-chronic respiratory failure (disorder)"
          },
          {
            "code" : "67931002",
            "display" : "Aztec (ethnic group)"
          },
          {
            "code" : "67937003",
            "display" : "Structure of axillary artery (body structure)"
          },
          {
            "code" : "67941004",
            "display" : "Structure of superior tracheobronchial lymph node (body structure)"
          },
          {
            "code" : "67956008",
            "display" : "Neutral red stain (substance)"
          },
          {
            "code" : "67966000",
            "display" : "Enema tube, device (physical object)"
          },
          {
            "code" : "67972000",
            "display" : "Single home living (finding)"
          },
          {
            "code" : "67977006",
            "display" : "Clumber spaniel (organism)"
          },
          {
            "code" : "68019004",
            "display" : "Recurrent major depression in remission (disorder)"
          },
          {
            "code" : "68033004",
            "display" : "Tracheostomy complication (disorder)"
          },
          {
            "code" : "68052005",
            "display" : "Pulmonary aspiration (finding)"
          },
          {
            "code" : "68053000",
            "display" : "Structure of anterior tibial artery (body structure)"
          },
          {
            "code" : "68062003",
            "display" : "Fall at construction site (event)"
          },
          {
            "code" : "68070008",
            "display" : "Cross-sexual pubertal traits (finding)"
          },
          {
            "code" : "68085002",
            "display" : "Structure of permanent maxillary right third molar tooth (body structure)"
          },
          {
            "code" : "68086001",
            "display" : "Persian cat (organism)"
          },
          {
            "code" : "68097001",
            "display" : "Increased calorie diet (finding)"
          },
          {
            "code" : "68109007",
            "display" : "Stricture of artery (disorder)"
          },
          {
            "code" : "68124003",
            "display" : "Penile insertion (finding)"
          },
          {
            "code" : "68130003",
            "display" : "Physical activity (observable entity)"
          },
          {
            "code" : "68142008",
            "display" : "Contusion of upper limb (disorder)"
          },
          {
            "code" : "68154008",
            "display" : "Chronic cough (finding)"
          },
          {
            "code" : "68168001",
            "display" : "Marital counseling (procedure)"
          },
          {
            "code" : "68171009",
            "display" : "Axillary lymph node structure (body structure)"
          },
          {
            "code" : "68183006",
            "display" : "Bone screw, device (physical object)"
          },
          {
            "code" : "68184000",
            "display" : "Autopsy review, consultation and report (procedure)"
          },
          {
            "code" : "68208009",
            "display" : "Vaccine product containing Clostridium tetani toxoid adsorbed and Corynebacterium diphtheriae toxoid antigens (medicinal product)"
          },
          {
            "code" : "68225006",
            "display" : "Alopecia areata (disorder)"
          },
          {
            "code" : "68226007",
            "display" : "Acute cystitis (disorder)"
          },
          {
            "code" : "68235000",
            "display" : "Nasal congestion (finding)"
          },
          {
            "code" : "68237008",
            "display" : "Partial anomalous pulmonary venous connection (disorder)"
          },
          {
            "code" : "68241007",
            "display" : "Glaucoma associated with ocular trauma (disorder)"
          },
          {
            "code" : "68254000",
            "display" : "Removal of intrauterine device (procedure)"
          },
          {
            "code" : "68263003",
            "display" : "Janus green B stain (substance)"
          },
          {
            "code" : "68265005",
            "display" : "Operation on the ear (procedure)"
          },
          {
            "code" : "68267002",
            "display" : "Benign intracranial hypertension (disorder)"
          },
          {
            "code" : "68272006",
            "display" : "Acute maxillary sinusitis (disorder)"
          },
          {
            "code" : "68274007",
            "display" : "Fall into hole (event)"
          },
          {
            "code" : "68276009",
            "display" : "Bottle, device (physical object)"
          },
          {
            "code" : "68300000",
            "display" : "Structure of right auricular appendage (body structure)"
          },
          {
            "code" : "68322007",
            "display" : "Administration of antibiotic (procedure)"
          },
          {
            "code" : "68339009",
            "display" : "Superficial intraparotid lymph node (body structure)"
          },
          {
            "code" : "68345001",
            "display" : "Apraxia (finding)"
          },
          {
            "code" : "68360003",
            "display" : "Closed fracture of multiple sites of phalanges of hand (disorder)"
          },
          {
            "code" : "68367000",
            "display" : "Thigh structure (body structure)"
          },
          {
            "code" : "68372009",
            "display" : "Upper respiratory tract obstruction (disorder)"
          },
          {
            "code" : "68433009",
            "display" : "Childhood (finding)"
          },
          {
            "code" : "68451005",
            "display" : "Chronic arthritis due to gout (disorder)"
          },
          {
            "code" : "68453008",
            "display" : "Carcinoma, no subtype (morphologic abnormality)"
          },
          {
            "code" : "68457009",
            "display" : "Percutaneous transluminal balloon angioplasty (procedure)"
          },
          {
            "code" : "68459007",
            "display" : "Crystal ponceau stain (substance)"
          },
          {
            "code" : "68478007",
            "display" : "Central retinal vein occlusion (disorder)"
          },
          {
            "code" : "68486007",
            "display" : "Austrians (ethnic group)"
          },
          {
            "code" : "68493006",
            "display" : "Gutter (qualifier value)"
          },
          {
            "code" : "68496003",
            "display" : "Polyp of colon (disorder)"
          },
          {
            "code" : "68505006",
            "display" : "Structure of left lower quadrant of abdomen (body structure)"
          },
          {
            "code" : "68512002",
            "display" : "Boar power pig 141 (organism)"
          },
          {
            "code" : "68523003",
            "display" : "Cerebral white matter structure (body structure)"
          },
          {
            "code" : "68550008",
            "display" : "Disturbance of temperature regulation of newborn (disorder)"
          },
          {
            "code" : "68551007",
            "display" : "Limb reduction-ichthyosis syndrome (disorder)"
          },
          {
            "code" : "68566005",
            "display" : "Urinary tract infectious disease (disorder)"
          },
          {
            "code" : "68569003",
            "display" : "Manic bipolar I disorder (disorder)"
          },
          {
            "code" : "68580003",
            "display" : "Iron-59 (substance)"
          },
          {
            "code" : "68589002",
            "display" : "Rear entry coital position (finding)"
          },
          {
            "code" : "68598004",
            "display" : "Skin structure of ala nasi (body structure)"
          },
          {
            "code" : "68618008",
            "display" : "Rett's disorder (disorder)"
          },
          {
            "code" : "68630002",
            "display" : "Iodine-125 (substance)"
          },
          {
            "code" : "68638009",
            "display" : "Bovine spongiform encephalopathy agent (organism)"
          },
          {
            "code" : "68653001",
            "display" : "Anal pain (finding)"
          },
          {
            "code" : "68659002",
            "display" : "Blepharoconjunctivitis (disorder)"
          },
          {
            "code" : "68660007",
            "display" : "Punch biopsy (procedure)"
          },
          {
            "code" : "68670009",
            "display" : "Contact dermatitis of eyelid (disorder)"
          },
          {
            "code" : "68675004",
            "display" : "Degeneration of thoracic intervertebral disc (disorder)"
          },
          {
            "code" : "68684004",
            "display" : "Hazara virus (organism)"
          },
          {
            "code" : "68698007",
            "display" : "Skin structure of forehead (body structure)"
          },
          {
            "code" : "68703001",
            "display" : "Choroidal structure (body structure)"
          },
          {
            "code" : "68704007",
            "display" : "Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "68705008",
            "display" : "Structure of axillary vein (body structure)"
          },
          {
            "code" : "68732003",
            "display" : "Non-virginal state (finding)"
          },
          {
            "code" : "68764005",
            "display" : "Juvenile taboparesis (disorder)"
          },
          {
            "code" : "68787002",
            "display" : "Structure of proximal portion of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "68792000",
            "display" : "Wardill operation, cleft palate repair (procedure)"
          },
          {
            "code" : "68796002",
            "display" : "Radioisotope study of musculoskeletal system (procedure)"
          },
          {
            "code" : "68811000",
            "display" : "Menopausal problem (finding)"
          },
          {
            "code" : "68815009",
            "display" : "Systemic lupus erythematosus glomerulonephritis syndrome (disorder)"
          },
          {
            "code" : "68819003",
            "display" : "Closed fracture of coronoid process of ulna (disorder)"
          },
          {
            "code" : "68854005",
            "display" : "Closed fracture of head of radius (disorder)"
          },
          {
            "code" : "68878000",
            "display" : "Structure of lymph node of epiploic foramen (body structure)"
          },
          {
            "code" : "68881005",
            "display" : "Structure of superior rectal lymph node (body structure)"
          },
          {
            "code" : "68890003",
            "display" : "Schizoaffective disorder (disorder)"
          },
          {
            "code" : "68893001",
            "display" : "Contusion of buttock (disorder)"
          },
          {
            "code" : "68894007",
            "display" : "Placing restraint (procedure)"
          },
          {
            "code" : "68905002",
            "display" : "Regular astigmatism (disorder)"
          },
          {
            "code" : "68913001",
            "display" : "Alpha thalassemia (disorder)"
          },
          {
            "code" : "68915008",
            "display" : "Structure of lateral cervical lymph node (body structure)"
          },
          {
            "code" : "68962001",
            "display" : "Muscle pain (finding)"
          },
          {
            "code" : "68967007",
            "display" : "Iodocholesterol (131-I) (substance)"
          },
          {
            "code" : "68978004",
            "display" : "Hyperventilation (finding)"
          },
          {
            "code" : "69031006",
            "display" : "Excision of breast tissue (procedure)"
          },
          {
            "code" : "69067004",
            "display" : "Shetland pony (organism)"
          },
          {
            "code" : "69076006",
            "display" : "Strontium (85-Sr) chloride (substance)"
          },
          {
            "code" : "69089000",
            "display" : "Iron-52 (substance)"
          },
          {
            "code" : "69105007",
            "display" : "Carotid artery structure (body structure)"
          },
          {
            "code" : "69129000",
            "display" : "Struck by sharp object (event)"
          },
          {
            "code" : "69130005",
            "display" : "Stapedectomy (procedure)"
          },
          {
            "code" : "69133007",
            "display" : "Sudan IV stain (substance)"
          },
          {
            "code" : "69158002",
            "display" : "Intra-atrial pacing (procedure)"
          },
          {
            "code" : "69165005",
            "display" : "Struck by falling earth (event)"
          },
          {
            "code" : "69192004",
            "display" : "Trachyonychia (disorder)"
          },
          {
            "code" : "69195002",
            "display" : "Degeneration of cervical intervertebral disc (disorder)"
          },
          {
            "code" : "69215007",
            "display" : "Intolerant of heat (finding)"
          },
          {
            "code" : "69236009",
            "display" : "Product containing amiodarone (medicinal product)"
          },
          {
            "code" : "69245005",
            "display" : "Intra-arterial infusion of thrombolytic agent (procedure)"
          },
          {
            "code" : "69249004",
            "display" : "Weimaraner (organism)"
          },
          {
            "code" : "69254008",
            "display" : "Denture stomatitis (disorder)"
          },
          {
            "code" : "69255009",
            "display" : "Structure of hypogastric lymph node (body structure)"
          },
          {
            "code" : "69270005",
            "display" : "Rupture of uterus during AND/OR after labor (disorder)"
          },
          {
            "code" : "69322001",
            "display" : "Psychotic disorder (disorder)"
          },
          {
            "code" : "69327007",
            "display" : "Structure of internal thoracic artery (body structure)"
          },
          {
            "code" : "69339004",
            "display" : "Bird-fanciers' lung (disorder)"
          },
          {
            "code" : "69352009",
            "display" : "Varicose veins of lower extremity with ulcer AND inflammation (disorder)"
          },
          {
            "code" : "69380006",
            "display" : "Venous catheterization for renal dialysis (procedure)"
          },
          {
            "code" : "69421009",
            "display" : "Structure of right branch of hepatic artery (body structure)"
          },
          {
            "code" : "69422002",
            "display" : "Trial forceps delivery (procedure)"
          },
          {
            "code" : "69430001",
            "display" : "Abscess of vulva (disorder)"
          },
          {
            "code" : "69461005",
            "display" : "Chester white pig (organism)"
          },
          {
            "code" : "69474004",
            "display" : "Samoyed dog (organism)"
          },
          {
            "code" : "69479009",
            "display" : "Anxiety hyperventilation (disorder)"
          },
          {
            "code" : "69482004",
            "display" : "Korsakoff's psychosis (disorder)"
          },
          {
            "code" : "69494008",
            "display" : "Eustachian tube disorder (disorder)"
          },
          {
            "code" : "69529009",
            "display" : "Border terrier (organism)"
          },
          {
            "code" : "69536005",
            "display" : "Head structure (body structure)"
          },
          {
            "code" : "69559004",
            "display" : "Mass of retroperitoneal structure (finding)"
          },
          {
            "code" : "69592005",
            "display" : "Standard schnauzer (organism)"
          },
          {
            "code" : "69595007",
            "display" : "Secondary syphilitic periostitis (disorder)"
          },
          {
            "code" : "69602006",
            "display" : "Kleen leen pig (organism)"
          },
          {
            "code" : "69691007",
            "display" : "Structure of pectoral axillary lymph node (body structure)"
          },
          {
            "code" : "69695003",
            "display" : "Stomach structure (body structure)"
          },
          {
            "code" : "69724002",
            "display" : "Implantation of prosthetic intraocular lens (procedure)"
          },
          {
            "code" : "69736008",
            "display" : "Vocational assessment (procedure)"
          },
          {
            "code" : "69741000",
            "display" : "Hidradenitis (disorder)"
          },
          {
            "code" : "69748006",
            "display" : "Thyroid structure (body structure)"
          },
          {
            "code" : "69771008",
            "display" : "Congenital anomaly of esophagus (disorder)"
          },
          {
            "code" : "69783005",
            "display" : "Iodipamide meglumine (substance)"
          },
          {
            "code" : "69787006",
            "display" : "Contusion of finger (disorder)"
          },
          {
            "code" : "69805005",
            "display" : "Insulin pump, device (physical object)"
          },
          {
            "code" : "69825009",
            "display" : "Mucocele of salivary gland (disorder)"
          },
          {
            "code" : "69833005",
            "display" : "Structure of right femoral artery (body structure)"
          },
          {
            "code" : "69839009",
            "display" : "Povidone iodine (125-I) (substance)"
          },
          {
            "code" : "69840006",
            "display" : "Normal breast feeding (finding)"
          },
          {
            "code" : "69849007",
            "display" : "Genital psychosexual phase (finding)"
          },
          {
            "code" : "69855002",
            "display" : "American shorthair cat (organism)"
          },
          {
            "code" : "69862006",
            "display" : "Smooth standard dachshund (organism)"
          },
          {
            "code" : "69865008",
            "display" : "Fijian (ethnic group)"
          },
          {
            "code" : "69866009",
            "display" : "Closed fracture of vault of skull without intracranial injury (disorder)"
          },
          {
            "code" : "69896004",
            "display" : "Rheumatoid arthritis (disorder)"
          },
          {
            "code" : "69909000",
            "display" : "Eclampsia added to pre-existing hypertension (disorder)"
          },
          {
            "code" : "69914001",
            "display" : "Stricture of anus (disorder)"
          },
          {
            "code" : "69930009",
            "display" : "Pancreatic duct structure (body structure)"
          },
          {
            "code" : "69954004",
            "display" : "Thrombophlebitis of breast (disorder)"
          },
          {
            "code" : "69983001",
            "display" : "Irani (ethnic group)"
          },
          {
            "code" : "70007007",
            "display" : "Substantia nigra structure (body structure)"
          },
          {
            "code" : "70028003",
            "display" : "Vertex presentation (finding)"
          },
          {
            "code" : "70036007",
            "display" : "Haemophilus influenzae pneumonia (disorder)"
          },
          {
            "code" : "70068004",
            "display" : "Persistent occipitoposterior position (disorder)"
          },
          {
            "code" : "70070008",
            "display" : "Torticollis (disorder)"
          },
          {
            "code" : "70074004",
            "display" : "Right main bronchus structure (body structure)"
          },
          {
            "code" : "70076002",
            "display" : "Rhinitis (disorder)"
          },
          {
            "code" : "70090004",
            "display" : "Cowpox (disorder)"
          },
          {
            "code" : "70092007",
            "display" : "Contusion of kidney (disorder)"
          },
          {
            "code" : "70105001",
            "display" : "Structure of optic radiation (body structure)"
          },
          {
            "code" : "70106000",
            "display" : "Lipid (substance)"
          },
          {
            "code" : "70142008",
            "display" : "Atrial septal defect (disorder)"
          },
          {
            "code" : "70147002",
            "display" : "Living in trailer (finding)"
          },
          {
            "code" : "70150004",
            "display" : "Bile (substance)"
          },
          {
            "code" : "70153002",
            "display" : "Hemorrhoids (disorder)"
          },
          {
            "code" : "70154008",
            "display" : "Sodium iodide (125-I) (substance)"
          },
          {
            "code" : "70156005",
            "display" : "Anomaly of chromosome pair 21 (disorder)"
          },
          {
            "code" : "70173007",
            "display" : "5p partial monosomy syndrome (disorder)"
          },
          {
            "code" : "70183006",
            "display" : "Subcutaneous mastectomy (procedure)"
          },
          {
            "code" : "70190001",
            "display" : "Peritoneal adhesion (disorder)"
          },
          {
            "code" : "70204006",
            "display" : "Closed fracture of fifth metatarsal bone (disorder)"
          },
          {
            "code" : "70208009",
            "display" : "Normal sexual state and development (finding)"
          },
          {
            "code" : "70211005",
            "display" : "Acute myocardial infarction of anterolateral wall (disorder)"
          },
          {
            "code" : "70215001",
            "display" : "Structure of genu of corpus callosum (body structure)"
          },
          {
            "code" : "70218004",
            "display" : "Displacement of intervertebral disc without myelopathy (disorder)"
          },
          {
            "code" : "70232002",
            "display" : "Frequent (qualifier value)"
          },
          {
            "code" : "70238003",
            "display" : "Structure of inflow tract of left ventricle (body structure)"
          },
          {
            "code" : "70241007",
            "display" : "Nutritional deficiency disorder (disorder)"
          },
          {
            "code" : "70253006",
            "display" : "Structure of left main branch of portal vein (body structure)"
          },
          {
            "code" : "70256003",
            "display" : "Finding of sexual intercourse (finding)"
          },
          {
            "code" : "70258002",
            "display" : "Ankle joint structure (body structure)"
          },
          {
            "code" : "70272006",
            "display" : "Malignant hypertension (disorder)"
          },
          {
            "code" : "70295002",
            "display" : "Statutory rape (finding)"
          },
          {
            "code" : "70323002",
            "display" : "Eye strain (finding)"
          },
          {
            "code" : "70342003",
            "display" : "Cholelithiasis without obstruction (disorder)"
          },
          {
            "code" : "70382005",
            "display" : "Structure of posterior cerebral artery (body structure)"
          },
          {
            "code" : "70407001",
            "display" : "Stridor (finding)"
          },
          {
            "code" : "70422006",
            "display" : "Acute subendocardial infarction (disorder)"
          },
          {
            "code" : "70431006",
            "display" : "Alpine goat (organism)"
          },
          {
            "code" : "70449006",
            "display" : "Amaurosis (disorder)"
          },
          {
            "code" : "70457009",
            "display" : "Icelandic horse (organism)"
          },
          {
            "code" : "70463000",
            "display" : "Mycobacterium gastri (organism)"
          },
          {
            "code" : "70466008",
            "display" : "Bruit (finding)"
          },
          {
            "code" : "70520000",
            "display" : "Ponceau xylidine stain (substance)"
          },
          {
            "code" : "70534000",
            "display" : "Occult spinal dysraphism sequence (disorder)"
          },
          {
            "code" : "70536003",
            "display" : "Transplant of kidney (procedure)"
          },
          {
            "code" : "70544003",
            "display" : "Gold-199 (substance)"
          },
          {
            "code" : "70545002",
            "display" : "Narcotic drug user (finding)"
          },
          {
            "code" : "70558001",
            "display" : "Nodular episcleritis (disorder)"
          },
          {
            "code" : "70559009",
            "display" : "Skin structure of anterior surface of forearm (body structure)"
          },
          {
            "code" : "70582006",
            "display" : "Scar of skin (disorder)"
          },
          {
            "code" : "70594002",
            "display" : "Amelanotic melanoma (morphologic abnormality)"
          },
          {
            "code" : "70611002",
            "display" : "Perinatal intraventricular hemorrhage (disorder)"
          },
          {
            "code" : "70637004",
            "display" : "Cellulitis of toe (disorder)"
          },
          {
            "code" : "70650003",
            "display" : "Urinary bladder stone (disorder)"
          },
          {
            "code" : "70653001",
            "display" : "British shorthaired cat (organism)"
          },
          {
            "code" : "70660007",
            "display" : "Hydrocele of tunica vaginalis (disorder)"
          },
          {
            "code" : "70691001",
            "display" : "Agoraphobia (disorder)"
          },
          {
            "code" : "70693003",
            "display" : "At risk for impaired skin integrity (finding)"
          },
          {
            "code" : "70694009",
            "display" : "Diabetes mellitus AND insipidus with optic atrophy AND deafness (disorder)"
          },
          {
            "code" : "70704007",
            "display" : "Sprain of wrist (disorder)"
          },
          {
            "code" : "70733008",
            "display" : "Limitation of joint movement (finding)"
          },
          {
            "code" : "70736000",
            "display" : "Osteochondritis (disorder)"
          },
          {
            "code" : "70747007",
            "display" : "Major depression single episode, in partial remission (disorder)"
          },
          {
            "code" : "70759006",
            "display" : "Pyoderma (disorder)"
          },
          {
            "code" : "70762009",
            "display" : "Skin structure of head (body structure)"
          },
          {
            "code" : "70777001",
            "display" : "Urine specimen collection, catheterized (procedure)"
          },
          {
            "code" : "70791007",
            "display" : "Structure of artery of lower extremity (body structure)"
          },
          {
            "code" : "70801007",
            "display" : "Mycobacterium microti (organism)"
          },
          {
            "code" : "70822001",
            "display" : "Cardiac ejection fraction, function (observable entity)"
          },
          {
            "code" : "70847004",
            "display" : "Structure of amnion (body structure)"
          },
          {
            "code" : "70871006",
            "display" : "Incisional biopsy (procedure)"
          },
          {
            "code" : "70876001",
            "display" : "Corynebacterium diphtheriae type intermedius (organism)"
          },
          {
            "code" : "70887009",
            "display" : "Skin structure of palmar area of hand (body structure)"
          },
          {
            "code" : "70922000",
            "display" : "Compulsive pedophilia (disorder)"
          },
          {
            "code" : "70925003",
            "display" : "Bone structure of maxilla (body structure)"
          },
          {
            "code" : "70936005",
            "display" : "Multi-infarct dementia, uncomplicated (disorder)"
          },
          {
            "code" : "70944005",
            "display" : "Impaired gas exchange (finding)"
          },
          {
            "code" : "70984001",
            "display" : "Serpentine aneurysm (morphologic abnormality)"
          },
          {
            "code" : "70995007",
            "display" : "Pulmonary hypertension (disorder)"
          },
          {
            "code" : "70997004",
            "display" : "Mild anxiety (finding)"
          },
          {
            "code" : "71057007",
            "display" : "Infection caused by Escherichia coli (disorder)"
          },
          {
            "code" : "71092004",
            "display" : "Living in retirement community (finding)"
          },
          {
            "code" : "71099008",
            "display" : "Living in residence with no sanitation (finding)"
          },
          {
            "code" : "71111008",
            "display" : "Glaucoma of childhood (disorder)"
          },
          {
            "code" : "71128006",
            "display" : "Molybdenum (substance)"
          },
          {
            "code" : "71133005",
            "display" : "Structure of caudate lobe of liver (body structure)"
          },
          {
            "code" : "71166009",
            "display" : "Forceps delivery with rotation of fetal head (procedure)"
          },
          {
            "code" : "71173004",
            "display" : "Compression (morphologic abnormality)"
          },
          {
            "code" : "71175006",
            "display" : "Bullmastiff (organism)"
          },
          {
            "code" : "71176007",
            "display" : "Pygmies (ethnic group)"
          },
          {
            "code" : "71186008",
            "display" : "Croup (disorder)"
          },
          {
            "code" : "71192002",
            "display" : "Peritoneal dialysis (procedure)"
          },
          {
            "code" : "71232009",
            "display" : "Borderline phyllodes tumor (morphologic abnormality)"
          },
          {
            "code" : "71252005",
            "display" : "Cervix uteri structure (body structure)"
          },
          {
            "code" : "71271007",
            "display" : "Structure of coronary sinus ostium (body structure)"
          },
          {
            "code" : "71286001",
            "display" : "Spinal cord compression (disorder)"
          },
          {
            "code" : "71303008",
            "display" : "Atypical facial pain (finding)"
          },
          {
            "code" : "71315007",
            "display" : "Dyspareunia (finding)"
          },
          {
            "code" : "71325002",
            "display" : "Lipodystrophy (disorder)"
          },
          {
            "code" : "71341001",
            "display" : "Bone structure of femur (body structure)"
          },
          {
            "code" : "71379006",
            "display" : "Erythroplakia (morphologic abnormality)"
          },
          {
            "code" : "71384000",
            "display" : "Warmer, device (physical object)"
          },
          {
            "code" : "71388002",
            "display" : "Procedure (procedure)"
          },
          {
            "code" : "71393004",
            "display" : "Soreness (finding)"
          },
          {
            "code" : "71395006",
            "display" : "Age factor (observable entity)"
          },
          {
            "code" : "71425003",
            "display" : "Copper-61 (substance)"
          },
          {
            "code" : "71442009",
            "display" : "Coital position (finding)"
          },
          {
            "code" : "71444005",
            "display" : "Cerebral arterial thrombosis (disorder)"
          },
          {
            "code" : "71457002",
            "display" : "Oropharyngeal dysphagia (disorder)"
          },
          {
            "code" : "71489006",
            "display" : "Machupo virus (organism)"
          },
          {
            "code" : "71493000",
            "display" : "Transfusion of packed red blood cells (procedure)"
          },
          {
            "code" : "71512009",
            "display" : "Precoital stimulation (finding)"
          },
          {
            "code" : "71553001",
            "display" : "Prostatic urethra structure (body structure)"
          },
          {
            "code" : "71583005",
            "display" : "Toxic gastroenteritis (disorder)"
          },
          {
            "code" : "71585003",
            "display" : "Structure of external jugular vein (body structure)"
          },
          {
            "code" : "71604005",
            "display" : "Forensic autopsy, coroner's call (procedure)"
          },
          {
            "code" : "71616004",
            "display" : "Skeletal and/or smooth muscle structure (body structure)"
          },
          {
            "code" : "71620000",
            "display" : "Fracture of femur (disorder)"
          },
          {
            "code" : "71633006",
            "display" : "Sodium-22 (substance)"
          },
          {
            "code" : "71636003",
            "display" : "Fibrinogen (123-I) (substance)"
          },
          {
            "code" : "71639005",
            "display" : "Galactorrhea associated with childbirth (disorder)"
          },
          {
            "code" : "71642004",
            "display" : "Fracture of skull (disorder)"
          },
          {
            "code" : "71647005",
            "display" : "Carbon-14 (substance)"
          },
          {
            "code" : "71651007",
            "display" : "Mammography (procedure)"
          },
          {
            "code" : "71758008",
            "display" : "Structure of peroneal vein (body structure)"
          },
          {
            "code" : "71759000",
            "display" : "Product containing glyceryl trinitrate (medicinal product)"
          },
          {
            "code" : "71760005",
            "display" : "Cervico-occipital neuralgia (finding)"
          },
          {
            "code" : "71772004",
            "display" : "Vasospasm (finding)"
          },
          {
            "code" : "71781005",
            "display" : "Decrease in height (finding)"
          },
          {
            "code" : "71787009",
            "display" : "Psychologic vaginismus (disorder)"
          },
          {
            "code" : "71792006",
            "display" : "Nodal rhythm disorder (disorder)"
          },
          {
            "code" : "71809002",
            "display" : "Fat diet (finding)"
          },
          {
            "code" : "71820002",
            "display" : "Urgent desire for stool (finding)"
          },
          {
            "code" : "71833008",
            "display" : "Crohn's disease of small AND large intestines (disorder)"
          },
          {
            "code" : "71836000",
            "display" : "Nasopharyngeal structure (body structure)"
          },
          {
            "code" : "71854001",
            "display" : "Colon structure (body structure)"
          },
          {
            "code" : "71874008",
            "display" : "Benign essential hypertension complicating AND/OR reason for care during childbirth (disorder)"
          },
          {
            "code" : "71878006",
            "display" : "Calcium measurement (procedure)"
          },
          {
            "code" : "71884009",
            "display" : "Precordial pain (finding)"
          },
          {
            "code" : "71892000",
            "display" : "Cardiac asthma (disorder)"
          },
          {
            "code" : "71893005",
            "display" : "Struck by falling object (event)"
          },
          {
            "code" : "71897006",
            "display" : "Venous stasis (finding)"
          },
          {
            "code" : "71906005",
            "display" : "Paronychia (disorder)"
          },
          {
            "code" : "71908006",
            "display" : "Ventricular fibrillation (disorder)"
          },
          {
            "code" : "71922006",
            "display" : "Immune defect (finding)"
          },
          {
            "code" : "71923001",
            "display" : "Italian landrace pig (organism)"
          },
          {
            "code" : "71932004",
            "display" : "Cardiac dilatation (disorder)"
          },
          {
            "code" : "71938000",
            "display" : "Hypercalciuria (disorder)"
          },
          {
            "code" : "71949006",
            "display" : "Chippewa (ethnic group)"
          },
          {
            "code" : "71957009",
            "display" : "Phloxin B stain (substance)"
          },
          {
            "code" : "71966008",
            "display" : "Subcutaneous tissue structure (body structure)"
          },
          {
            "code" : "71984005",
            "display" : "Mild manic bipolar I disorder (disorder)"
          },
          {
            "code" : "72001000",
            "display" : "Bone structure of lower limb (body structure)"
          },
          {
            "code" : "72005009",
            "display" : "Skin structure of areola (body structure)"
          },
          {
            "code" : "72007001",
            "display" : "Duodenitis (disorder)"
          },
          {
            "code" : "72010008",
            "display" : "Removal of internal fixation device (procedure)"
          },
          {
            "code" : "72011007",
            "display" : "Rheumatic aortic stenosis (disorder)"
          },
          {
            "code" : "72015003",
            "display" : "Iodinated (125-I) albumin (substance)"
          },
          {
            "code" : "72021004",
            "display" : "Structure of superior thyroid artery (body structure)"
          },
          {
            "code" : "72022006",
            "display" : "Essential hypertension in obstetric context (disorder)"
          },
          {
            "code" : "72027000",
            "display" : "Radial pulse taking (procedure)"
          },
          {
            "code" : "72042002",
            "display" : "Incontinence of feces (finding)"
          },
          {
            "code" : "72047008",
            "display" : "Juvenile osteochondrosis of tibial tubercle (disorder)"
          },
          {
            "code" : "72059007",
            "display" : "Destructive procedure on fetus to facilitate delivery (procedure)"
          },
          {
            "code" : "72083004",
            "display" : "Late syphilis (disorder)"
          },
          {
            "code" : "72092001",
            "display" : "Arteriosclerotic vascular disease (disorder)"
          },
          {
            "code" : "72093006",
            "display" : "Administration of vaccine product containing only Human poliovirus antigen (procedure)"
          },
          {
            "code" : "72100002",
            "display" : "Solar lentigo (disorder)"
          },
          {
            "code" : "72107004",
            "display" : "Structure of azygous vein (body structure)"
          },
          {
            "code" : "72128008",
            "display" : "Disorder of refraction AND/OR accommodation (disorder)"
          },
          {
            "code" : "72129000",
            "display" : "Acquired acanthosis nigricans (disorder)"
          },
          {
            "code" : "72130005",
            "display" : "Mycobacterium rhodesiae (organism)"
          },
          {
            "code" : "72159005",
            "display" : "Cyanocobalamin (60-Co) (substance)"
          },
          {
            "code" : "72164009",
            "display" : "Inositol (substance)"
          },
          {
            "code" : "72166006",
            "display" : "Fibroelastosis (morphologic abnormality)"
          },
          {
            "code" : "72184008",
            "display" : "Structure of neck of rib (body structure)"
          },
          {
            "code" : "72201005",
            "display" : "Hobe (ethnic group)"
          },
          {
            "code" : "72203008",
            "display" : "Structure of lingual surface of tooth (body structure)"
          },
          {
            "code" : "72215007",
            "display" : "Male juvenile homoerotism (finding)"
          },
          {
            "code" : "72242008",
            "display" : "Postductal coarctation of aorta (disorder)"
          },
          {
            "code" : "72248007",
            "display" : "Kikuyu (ethnic group)"
          },
          {
            "code" : "72274001",
            "display" : "Nerve root disorder (disorder)"
          },
          {
            "code" : "72275000",
            "display" : "Relapsing polychondritis (disorder)"
          },
          {
            "code" : "72292009",
            "display" : "Congenital anomaly of larynx (disorder)"
          },
          {
            "code" : "72310004",
            "display" : "Circumcision (procedure)"
          },
          {
            "code" : "72315009",
            "display" : "Inclusion body myositis (disorder)"
          },
          {
            "code" : "72325004",
            "display" : "Cyst of thyroid (disorder)"
          },
          {
            "code" : "72329005",
            "display" : "Finnish landrace sheep (organism)"
          },
          {
            "code" : "72337002",
            "display" : "Brazilian Indians (ethnic group)"
          },
          {
            "code" : "72342005",
            "display" : "Shave biopsy (procedure)"
          },
          {
            "code" : "72352009",
            "display" : "Bicuspid aortic valve (disorder)"
          },
          {
            "code" : "72366004",
            "display" : "Eating disorder (disorder)"
          },
          {
            "code" : "72371006",
            "display" : "Fast violet B salt stain (substance)"
          },
          {
            "code" : "72394007",
            "display" : "American tunis horse (organism)"
          },
          {
            "code" : "72410000",
            "display" : "Mediastinal structure (body structure)"
          },
          {
            "code" : "72413003",
            "display" : "Seduction of male (finding)"
          },
          {
            "code" : "72454006",
            "display" : "Technetium-99m (substance)"
          },
          {
            "code" : "72477006",
            "display" : "Mycobacterium tokaiense (organism)"
          },
          {
            "code" : "72481006",
            "display" : "Structure of middle lobe of right lung (body structure)"
          },
          {
            "code" : "72492007",
            "display" : "Footling breech delivery (procedure)"
          },
          {
            "code" : "72495009",
            "display" : "Mucinous adenocarcinoma (morphologic abnormality)"
          },
          {
            "code" : "72506001",
            "display" : "Implantable defibrillator, device (physical object)"
          },
          {
            "code" : "72511004",
            "display" : "Fruit (substance)"
          },
          {
            "code" : "72542009",
            "display" : "Structure of myocardium of diaphragmatic region (body structure)"
          },
          {
            "code" : "72552008",
            "display" : "Feeding problems in newborn (finding)"
          },
          {
            "code" : "72556006",
            "display" : "Injury of trigeminal nerve (disorder)"
          },
          {
            "code" : "72572003",
            "display" : "Diamond black stain (substance)"
          },
          {
            "code" : "72573008",
            "display" : "Infraspinatus muscle structure (body structure)"
          },
          {
            "code" : "72592005",
            "display" : "Structure of left colic flexure (body structure)"
          },
          {
            "code" : "72598009",
            "display" : "Autopsy, gross examination, limited (procedure)"
          },
          {
            "code" : "72605008",
            "display" : "Candidal vulvovaginitis (disorder)"
          },
          {
            "code" : "72607000",
            "display" : "Intrathecal route (qualifier value)"
          },
          {
            "code" : "72620002",
            "display" : "Nodular degeneration of cornea (disorder)"
          },
          {
            "code" : "72621003",
            "display" : "Chronic gingivitis (disorder)"
          },
          {
            "code" : "72641008",
            "display" : "Administration of sedative (procedure)"
          },
          {
            "code" : "72648002",
            "display" : "Suffolk sheep (organism)"
          },
          {
            "code" : "72654001",
            "display" : "Supraventricular arrhythmia (disorder)"
          },
          {
            "code" : "72658003",
            "display" : "Prickly heat (disorder)"
          },
          {
            "code" : "72674008",
            "display" : "Bronchopulmonary segment structure (body structure)"
          },
          {
            "code" : "72696002",
            "display" : "Knee region structure (body structure)"
          },
          {
            "code" : "72717003",
            "display" : "Magnesium (substance)"
          },
          {
            "code" : "72738009",
            "display" : "Fall from carousel (event)"
          },
          {
            "code" : "72779005",
            "display" : "Anorectal fistula (disorder)"
          },
          {
            "code" : "72791001",
            "display" : "Laryngectomy (procedure)"
          },
          {
            "code" : "72809004",
            "display" : "Icelanders (ethnic group)"
          },
          {
            "code" : "72814000",
            "display" : "Legionella santicrucis (organism)"
          },
          {
            "code" : "72829003",
            "display" : "Brucella melitensis (organism)"
          },
          {
            "code" : "72861004",
            "display" : "Panic disorder without agoraphobia with mild panic attacks (disorder)"
          },
          {
            "code" : "72863001",
            "display" : "Snoring (finding)"
          },
          {
            "code" : "72866009",
            "display" : "Varicose veins of lower extremity (disorder)"
          },
          {
            "code" : "72876007",
            "display" : "Structure of maxillary left canine tooth (body structure)"
          },
          {
            "code" : "72892002",
            "display" : "Normal pregnancy (finding)"
          },
          {
            "code" : "72893007",
            "display" : "Brachial neuritis (disorder)"
          },
          {
            "code" : "72900001",
            "display" : "Familial multiple polyposis syndrome (disorder)"
          },
          {
            "code" : "72904005",
            "display" : "Treponema pallidum (organism)"
          },
          {
            "code" : "72925005",
            "display" : "Congenital cystic disease of liver (disorder)"
          },
          {
            "code" : "72934000",
            "display" : "Candidiasis of vagina (disorder)"
          },
          {
            "code" : "72939005",
            "display" : "Skin structure of posterior surface of upper arm (body structure)"
          },
          {
            "code" : "72951007",
            "display" : "Gastroschisis (disorder)"
          },
          {
            "code" : "73002000",
            "display" : "Measurement of systemic arterial pressure (regime/therapy)"
          },
          {
            "code" : "73005003",
            "display" : "FHC elite pig 8 (organism)"
          },
          {
            "code" : "73030000",
            "display" : "Hypertensive renal disease in obstetric context (disorder)"
          },
          {
            "code" : "73049001",
            "display" : "Scottish fold cat (organism)"
          },
          {
            "code" : "73050001",
            "display" : "Structure of myocardium of anterolateral region (body structure)"
          },
          {
            "code" : "73056007",
            "display" : "Right breast structure (body structure)"
          },
          {
            "code" : "73058008",
            "display" : "Skin of structure of labium pudendum (body structure)"
          },
          {
            "code" : "73063007",
            "display" : "Colicky pain (finding)"
          },
          {
            "code" : "73065000",
            "display" : "Gallium (67-Ga) citrate (substance)"
          },
          {
            "code" : "73103007",
            "display" : "Polyp of middle ear (disorder)"
          },
          {
            "code" : "73105000",
            "display" : "Pes anserinus bursitis (disorder)"
          },
          {
            "code" : "73117003",
            "display" : "Sphenoid bone structure (body structure)"
          },
          {
            "code" : "73125001",
            "display" : "Empyema of gallbladder (disorder)"
          },
          {
            "code" : "73147001",
            "display" : "Direct inguinal hernia (disorder)"
          },
          {
            "code" : "73149003",
            "display" : "Encopresis with constipation AND overflow incontinence (finding)"
          },
          {
            "code" : "73152006",
            "display" : "Administration of vaccine product containing only Clostridium tetani and Corynebacterium diphtheriae antigens (procedure)"
          },
          {
            "code" : "73161006",
            "display" : "Transverse lie (disorder)"
          },
          {
            "code" : "73166001",
            "display" : "Structure of aortic bifurcation (body structure)"
          },
          {
            "code" : "73181007",
            "display" : "Recurrent pterygium (disorder)"
          },
          {
            "code" : "73191001",
            "display" : "American merino sheep (organism)"
          },
          {
            "code" : "73211009",
            "display" : "Diabetes mellitus (disorder)"
          },
          {
            "code" : "73212002",
            "display" : "Product containing iodipamide (medicinal product)"
          },
          {
            "code" : "73219006",
            "display" : "Angiolipoma (morphologic abnormality)"
          },
          {
            "code" : "73237007",
            "display" : "Chronic ethmoidal sinusitis (disorder)"
          },
          {
            "code" : "73244003",
            "display" : "Closed fracture of surgical neck of humerus (disorder)"
          },
          {
            "code" : "73251007",
            "display" : "Auramine G stain (substance)"
          },
          {
            "code" : "73271003",
            "display" : "Domestic leopard cat (organism)"
          },
          {
            "code" : "73297009",
            "display" : "Muscular dystrophy (disorder)"
          },
          {
            "code" : "73305009",
            "display" : "Fibrillary glomerulonephritis (disorder)"
          },
          {
            "code" : "73318001",
            "display" : "Pointer (organism)"
          },
          {
            "code" : "73319009",
            "display" : "Coonhound (organism)"
          },
          {
            "code" : "73373003",
            "display" : "Specimen centrifugation (procedure)"
          },
          {
            "code" : "73384005",
            "display" : "Infant nutrition, function (observable entity)"
          },
          {
            "code" : "73391008",
            "display" : "Dysplasia of cervix (disorder)"
          },
          {
            "code" : "73400003",
            "display" : "Structure of transverse process of vertebra (body structure)"
          },
          {
            "code" : "73410007",
            "display" : "Benign secondary renovascular hypertension (disorder)"
          },
          {
            "code" : "73415002",
            "display" : "Noise-induced hearing loss (disorder)"
          },
          {
            "code" : "73416001",
            "display" : "Urine specimen collection, clean catch (procedure)"
          },
          {
            "code" : "73425007",
            "display" : "Inactive (qualifier value)"
          },
          {
            "code" : "73430006",
            "display" : "Sleep apnea (disorder)"
          },
          {
            "code" : "73438004",
            "display" : "Unemployed (finding)"
          },
          {
            "code" : "73442001",
            "display" : "Stevens-Johnson syndrome (disorder)"
          },
          {
            "code" : "73452002",
            "display" : "Abscess of lung (disorder)"
          },
          {
            "code" : "73517007",
            "display" : "Bhanja virus (organism)"
          },
          {
            "code" : "73524008",
            "display" : "Caingang (ethnic group)"
          },
          {
            "code" : "73525009",
            "display" : "Salmonella Enteritidis (organism)"
          },
          {
            "code" : "73544002",
            "display" : "Operation on heart valve (procedure)"
          },
          {
            "code" : "73573004",
            "display" : "Congenital anomaly of musculoskeletal system (disorder)"
          },
          {
            "code" : "73576007",
            "display" : "Mycobacterium malmoense (organism)"
          },
          {
            "code" : "73580002",
            "display" : "Structure of middle cardiac vein (body structure)"
          },
          {
            "code" : "73583000",
            "display" : "Epicondylitis (disorder)"
          },
          {
            "code" : "73589001",
            "display" : "Intervertebral disc prolapse (disorder)"
          },
          {
            "code" : "73590005",
            "display" : "Injury of peripheral nerve (disorder)"
          },
          {
            "code" : "73595000",
            "display" : "Stress (finding)"
          },
          {
            "code" : "73632009",
            "display" : "Laparoscopy (procedure)"
          },
          {
            "code" : "73634005",
            "display" : "Common iliac artery structure (body structure)"
          },
          {
            "code" : "73648005",
            "display" : "Wessex saddleback pig (organism)"
          },
          {
            "code" : "73660006",
            "display" : "Congenital subaortic stenosis (disorder)"
          },
          {
            "code" : "73666000",
            "display" : "Oral-genital stimulation (finding)"
          },
          {
            "code" : "73678001",
            "display" : "Natural sister (person)"
          },
          {
            "code" : "73685002",
            "display" : "Thallous (201-Ti) chloride (substance)"
          },
          {
            "code" : "73692007",
            "display" : "Fixed drug eruption (disorder)"
          },
          {
            "code" : "73699003",
            "display" : "Common arterial trunk and common origin of pulmonary arteries (disorder)"
          },
          {
            "code" : "73725006",
            "display" : "Thickening of pleura (disorder)"
          },
          {
            "code" : "73736004",
            "display" : "Maori (ethnic group)"
          },
          {
            "code" : "73744004",
            "display" : "Hypersexuality state (finding)"
          },
          {
            "code" : "73749009",
            "display" : "Neonatal jaundice associated with preterm delivery (disorder)"
          },
          {
            "code" : "73761001",
            "display" : "Colonoscopy (procedure)"
          },
          {
            "code" : "73762008",
            "display" : "Chronic conjunctivitis (disorder)"
          },
          {
            "code" : "73770003",
            "display" : "Hospital-based outpatient emergency care center (environment)"
          },
          {
            "code" : "73774007",
            "display" : "Subacute bacterial endocarditis (disorder)"
          },
          {
            "code" : "73789003",
            "display" : "Diet for special test (finding)"
          },
          {
            "code" : "73795002",
            "display" : "Acute myocardial infarction of inferior wall (disorder)"
          },
          {
            "code" : "73817000",
            "display" : "Enteritis caused by radiation (disorder)"
          },
          {
            "code" : "73829009",
            "display" : "Right atrial structure (body structure)"
          },
          {
            "code" : "73852008",
            "display" : "Enterococcus hirae (organism)"
          },
          {
            "code" : "73861008",
            "display" : "Polyp of duodenum (disorder)"
          },
          {
            "code" : "73867007",
            "display" : "Severe major depression with psychotic features (disorder)"
          },
          {
            "code" : "73877009",
            "display" : "Chronic tophaceous gout (disorder)"
          },
          {
            "code" : "73892005",
            "display" : "Carmine stain (substance)"
          },
          {
            "code" : "73893000",
            "display" : "Congenital toxoplasmosis (disorder)"
          },
          {
            "code" : "73897004",
            "display" : "Skin structure of face (body structure)"
          },
          {
            "code" : "73930003",
            "display" : "Structure of levator costae muscle (body structure)"
          },
          {
            "code" : "73931004",
            "display" : "Structure of right main branch of portal vein (body structure)"
          },
          {
            "code" : "73937000",
            "display" : "Structure of deciduous maxillary left canine tooth (body structure)"
          },
          {
            "code" : "73944009",
            "display" : "Minnesota pig #1 (organism)"
          },
          {
            "code" : "73949004",
            "display" : "Product containing atropine (medicinal product)"
          },
          {
            "code" : "73958006",
            "display" : "Skin structure of medial surface of thigh (body structure)"
          },
          {
            "code" : "73998008",
            "display" : "Prolapse of female genital organs (disorder)"
          },
          {
            "code" : "74010007",
            "display" : "Panic disorder with agoraphobia, severe agoraphobic avoidance AND panic attacks in partial remission (disorder)"
          },
          {
            "code" : "74013009",
            "display" : "Gleason grade score 5 out of 10 (finding)"
          },
          {
            "code" : "74016001",
            "display" : "Radiologic examination of knee (procedure)"
          },
          {
            "code" : "74021003",
            "display" : "Bifascicular block (disorder)"
          },
          {
            "code" : "74028009",
            "display" : "Mycobacterium paratuberculosis (organism)"
          },
          {
            "code" : "74031005",
            "display" : "Left bundle branch structure (body structure)"
          },
          {
            "code" : "74036000",
            "display" : "Pregnancy detection examination (procedure)"
          },
          {
            "code" : "74107003",
            "display" : "Acromegaly (disorder)"
          },
          {
            "code" : "74135004",
            "display" : "Meniscus structure of joint (body structure)"
          },
          {
            "code" : "74142004",
            "display" : "Feeding disorder of infancy OR early childhood (disorder)"
          },
          {
            "code" : "74156002",
            "display" : "Structure of medial plantar artery (body structure)"
          },
          {
            "code" : "74159009",
            "display" : "Melanuans (ethnic group)"
          },
          {
            "code" : "74160004",
            "display" : "Skin structure of chest (body structure)"
          },
          {
            "code" : "74173000",
            "display" : "Rhodesian ridgeback dog (organism)"
          },
          {
            "code" : "74176008",
            "display" : "Coitus brevis (finding)"
          },
          {
            "code" : "74203007",
            "display" : "Structure of prelaryngeal lymph node (body structure)"
          },
          {
            "code" : "74212009",
            "display" : "Mycobacterium senegalense (organism)"
          },
          {
            "code" : "74227009",
            "display" : "Apraxic aphonia (disorder)"
          },
          {
            "code" : "74262004",
            "display" : "Oral cavity structure (body structure)"
          },
          {
            "code" : "74280008",
            "display" : "Glycogen-rich carcinoma (morphologic abnormality)"
          },
          {
            "code" : "74285003",
            "display" : "Mass of pelvic structure (finding)"
          },
          {
            "code" : "74297002",
            "display" : "Injury of cervical nerve roots (disorder)"
          },
          {
            "code" : "74302004",
            "display" : "Apache (ethnic group)"
          },
          {
            "code" : "74308000",
            "display" : "Structure of right seminal vesicle (body structure)"
          },
          {
            "code" : "74323005",
            "display" : "Pain in elbow (finding)"
          },
          {
            "code" : "74333002",
            "display" : "Spasmodic torticollis (disorder)"
          },
          {
            "code" : "74344005",
            "display" : "Structure of permanent mandibular left third molar tooth (body structure)"
          },
          {
            "code" : "74345006",
            "display" : "Congenital disorder due to abnormality of chromosome number OR structure (disorder)"
          },
          {
            "code" : "74348008",
            "display" : "Autopsy, gross and microscopic examination, limited (procedure)"
          },
          {
            "code" : "74364000",
            "display" : "Small cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "74372003",
            "display" : "Gonorrhea of pharynx (disorder)"
          },
          {
            "code" : "74386004",
            "display" : "Nasal bone structure (body structure)"
          },
          {
            "code" : "74390002",
            "display" : "Wolff-Parkinson-White pattern (disorder)"
          },
          {
            "code" : "74391003",
            "display" : "Pauciarticular juvenile rheumatoid arthritis (disorder)"
          },
          {
            "code" : "74395007",
            "display" : "Open fracture of phalanx of foot (disorder)"
          },
          {
            "code" : "74397004",
            "display" : "Living quarters (observable entity)"
          },
          {
            "code" : "74400008",
            "display" : "Appendicitis (disorder)"
          },
          {
            "code" : "74417001",
            "display" : "Mucopurulent chronic bronchitis (disorder)"
          },
          {
            "code" : "74424000",
            "display" : "Infant diet 6 months: rice, barley, iron, no honey (finding)"
          },
          {
            "code" : "74444006",
            "display" : "Limb prosthesis, device (physical object)"
          },
          {
            "code" : "74451002",
            "display" : "Secondary diastolic hypertension (disorder)"
          },
          {
            "code" : "74472004",
            "display" : "Late effect of intracranial injury without skull fracture (disorder)"
          },
          {
            "code" : "74474003",
            "display" : "Gastrointestinal hemorrhage (disorder)"
          },
          {
            "code" : "74506000",
            "display" : "Bereavement due to life event (finding)"
          },
          {
            "code" : "74517004",
            "display" : "Montana pig (organism)"
          },
          {
            "code" : "74530003",
            "display" : "Uncompensated sensory deficit (finding)"
          },
          {
            "code" : "74536009",
            "display" : "Belgian groenendael dog (organism)"
          },
          {
            "code" : "74541001",
            "display" : "Fall from bench (event)"
          },
          {
            "code" : "74551000",
            "display" : "Circumference (qualifier value)"
          },
          {
            "code" : "74554008",
            "display" : "Iodophthalein (substance)"
          },
          {
            "code" : "74568001",
            "display" : "Red wattle pig (organism)"
          },
          {
            "code" : "74576004",
            "display" : "Acquired thrombocytopenia (disorder)"
          },
          {
            "code" : "74598008",
            "display" : "Periapical abscess with sinus tract (disorder)"
          },
          {
            "code" : "74601003",
            "display" : "Struck by instrument of aggression (event)"
          },
          {
            "code" : "74615001",
            "display" : "Tachycardia-bradycardia (disorder)"
          },
          {
            "code" : "74626007",
            "display" : "Drug diluent (product)"
          },
          {
            "code" : "74627003",
            "display" : "Complication due to diabetes mellitus (disorder)"
          },
          {
            "code" : "74641007",
            "display" : "Ill-defined disease (finding)"
          },
          {
            "code" : "74670003",
            "display" : "Wrist joint structure (body structure)"
          },
          {
            "code" : "74680004",
            "display" : "Structure of trunk of portal vein (body structure)"
          },
          {
            "code" : "74682007",
            "display" : "Crushing injury of toe (disorder)"
          },
          {
            "code" : "74683002",
            "display" : "Struck by falling machine equipment (event)"
          },
          {
            "code" : "74686005",
            "display" : "Mild depressed bipolar I disorder (disorder)"
          },
          {
            "code" : "74699008",
            "display" : "Foreign body in nose (disorder)"
          },
          {
            "code" : "74715005",
            "display" : "Battered woman syndrome (finding)"
          },
          {
            "code" : "74728003",
            "display" : "Hypopituitarism (disorder)"
          },
          {
            "code" : "74732009",
            "display" : "Mental disorder (disorder)"
          },
          {
            "code" : "74745008",
            "display" : "Rock alpine goat (organism)"
          },
          {
            "code" : "74746009",
            "display" : "Plasmodium vivax (organism)"
          },
          {
            "code" : "74770008",
            "display" : "Exploratory laparotomy (procedure)"
          },
          {
            "code" : "74776002",
            "display" : "Itching of eye (finding)"
          },
          {
            "code" : "74783009",
            "display" : "Stenosis of lacrimal punctum (disorder)"
          },
          {
            "code" : "74791000",
            "display" : "Pedophilia, limited to incest (disorder)"
          },
          {
            "code" : "74808006",
            "display" : "Acquired deviated nasal septum (disorder)"
          },
          {
            "code" : "74814004",
            "display" : "Contusion of foot (disorder)"
          },
          {
            "code" : "74820003",
            "display" : "Congenital coxa vara (disorder)"
          },
          {
            "code" : "74872008",
            "display" : "Frontal bone structure (body structure)"
          },
          {
            "code" : "74877002",
            "display" : "Congenital anomaly of spine (disorder)"
          },
          {
            "code" : "74883004",
            "display" : "Thoracic aortic aneurysm without rupture (disorder)"
          },
          {
            "code" : "74899005",
            "display" : "Boar power pig (organism)"
          },
          {
            "code" : "74917007",
            "display" : "Mycobacterium gadium (organism)"
          },
          {
            "code" : "74921000",
            "display" : "Dekalb hybrid pig line (organism)"
          },
          {
            "code" : "74930008",
            "display" : "Hyperalimentation formula for renal failure (finding)"
          },
          {
            "code" : "74937006",
            "display" : "Complicated atheromatous plaque (morphologic abnormality)"
          },
          {
            "code" : "74942003",
            "display" : "Echinococcosis (disorder)"
          },
          {
            "code" : "74947009",
            "display" : "Gaseous substance (substance)"
          },
          {
            "code" : "74949007",
            "display" : "Infestation caused by Anoplura (disorder)"
          },
          {
            "code" : "74968005",
            "display" : "Structure of cave of septum pellucidum (body structure)"
          },
          {
            "code" : "74970001",
            "display" : "Boar power pig 161 (organism)"
          },
          {
            "code" : "75007009",
            "display" : "Algophobia (finding)"
          },
          {
            "code" : "75022004",
            "display" : "Gestational diabetes mellitus, class A>1< (disorder)"
          },
          {
            "code" : "75032006",
            "display" : "Genus Klebsiella (organism)"
          },
          {
            "code" : "75038005",
            "display" : "Cerebellar hemorrhage (disorder)"
          },
          {
            "code" : "75040000",
            "display" : "Deep intraparotid lymph node (body structure)"
          },
          {
            "code" : "75042008",
            "display" : "Arachnoid structure (body structure)"
          },
          {
            "code" : "75053002",
            "display" : "Acute febrile mucocutaneous lymph node syndrome (disorder)"
          },
          {
            "code" : "75065003",
            "display" : "Endemic cretinism (disorder)"
          },
          {
            "code" : "75084000",
            "display" : "Severe major depression without psychotic features (disorder)"
          },
          {
            "code" : "75088002",
            "display" : "Urgent desire to urinate (finding)"
          },
          {
            "code" : "75093004",
            "display" : "Skin structure of abdomen (body structure)"
          },
          {
            "code" : "75100008",
            "display" : "Abdominal abscess (disorder)"
          },
          {
            "code" : "75118006",
            "display" : "Feeding patient (regime/therapy)"
          },
          {
            "code" : "75129005",
            "display" : "Bone structure of distal radius (body structure)"
          },
          {
            "code" : "75137002",
            "display" : "Closed traumatic dislocation of joint of finger (disorder)"
          },
          {
            "code" : "75148009",
            "display" : "Employment problem (finding)"
          },
          {
            "code" : "75150001",
            "display" : "Renal disease in pregnancy AND/OR puerperium without hypertension (disorder)"
          },
          {
            "code" : "75170007",
            "display" : "Extraction of lens of eye (procedure)"
          },
          {
            "code" : "75183008",
            "display" : "Abnormal liver function (finding)"
          },
          {
            "code" : "75229002",
            "display" : "Hyphema (disorder)"
          },
          {
            "code" : "75236001",
            "display" : "Anorectal abscess (disorder)"
          },
          {
            "code" : "75245000",
            "display" : "Left main bronchus structure (body structure)"
          },
          {
            "code" : "75252003",
            "display" : "Inspiratory crackles (finding)"
          },
          {
            "code" : "75258004",
            "display" : "Food poisoning (disorder)"
          },
          {
            "code" : "75294000",
            "display" : "Descending (qualifier value)"
          },
          {
            "code" : "75299005",
            "display" : "Spastic spinal syphilitic paralysis (disorder)"
          },
          {
            "code" : "75301003",
            "display" : "Mapuche (ethnic group)"
          },
          {
            "code" : "75319007",
            "display" : "Structure of clavicular notch of sternum (body structure)"
          },
          {
            "code" : "75326007",
            "display" : "Labradors (ethnic group)"
          },
          {
            "code" : "75354000",
            "display" : "Fall on ice (event)"
          },
          {
            "code" : "75356003",
            "display" : "Mycobacterium fortuitum ss. acetamidolytica (organism)"
          },
          {
            "code" : "75367002",
            "display" : "Blood pressure (observable entity)"
          },
          {
            "code" : "75372006",
            "display" : "Congenital anomaly of mitral valve (disorder)"
          },
          {
            "code" : "75375008",
            "display" : "Bacterial enteritis (disorder)"
          },
          {
            "code" : "75382007",
            "display" : "Differentiated vocalization (observable entity)"
          },
          {
            "code" : "75397005",
            "display" : "Structure of preductal region of aortic arch (body structure)"
          },
          {
            "code" : "75403004",
            "display" : "Cardiac sarcoidosis (disorder)"
          },
          {
            "code" : "75408008",
            "display" : "Feeling angry (finding)"
          },
          {
            "code" : "75441006",
            "display" : "Foreign body in ear (disorder)"
          },
          {
            "code" : "75461000",
            "display" : "Infant care education (procedure)"
          },
          {
            "code" : "75467001",
            "display" : "Intervertebral disc disorder of cervical region with myelopathy (disorder)"
          },
          {
            "code" : "75478009",
            "display" : "Poisoning (disorder)"
          },
          {
            "code" : "75483001",
            "display" : "Breathing painful (finding)"
          },
          {
            "code" : "75494002",
            "display" : "Irish terrier (organism)"
          },
          {
            "code" : "75516001",
            "display" : "Psychotherapy (regime/therapy)"
          },
          {
            "code" : "75524006",
            "display" : "Malnutrition related diabetes mellitus (disorder)"
          },
          {
            "code" : "75531005",
            "display" : "Structure of artery of upper extremity (body structure)"
          },
          {
            "code" : "75540009",
            "display" : "High (qualifier value)"
          },
          {
            "code" : "75543006",
            "display" : "Cerebral embolism (disorder)"
          },
          {
            "code" : "75544000",
            "display" : "Opioid dependence (disorder)"
          },
          {
            "code" : "75570004",
            "display" : "Viral pneumonia (disorder)"
          },
          {
            "code" : "75572007",
            "display" : "Polyradiculopathy (disorder)"
          },
          {
            "code" : "75573002",
            "display" : "Tonsillar structure (palatine) (body structure)"
          },
          {
            "code" : "75591007",
            "display" : "Fracture of fibula (disorder)"
          },
          {
            "code" : "75630004",
            "display" : "Derangement of temporomandibular joint (disorder)"
          },
          {
            "code" : "75682002",
            "display" : "Diabetes mellitus caused by insulin receptor antibodies (disorder)"
          },
          {
            "code" : "75694006",
            "display" : "Pancreatitis (disorder)"
          },
          {
            "code" : "75696008",
            "display" : "Titanium-45 (substance)"
          },
          {
            "code" : "75702008",
            "display" : "Brucellosis (disorder)"
          },
          {
            "code" : "75704009",
            "display" : "Toba (ethnic group)"
          },
          {
            "code" : "75705005",
            "display" : "Red eye (disorder)"
          },
          {
            "code" : "75709004",
            "display" : "Pic pig (organism)"
          },
          {
            "code" : "75732000",
            "display" : "Vitrectomy (procedure)"
          },
          {
            "code" : "75739009",
            "display" : "Salzmann nodular degeneration (disorder)"
          },
          {
            "code" : "75753009",
            "display" : "Blood clot (morphologic abnormality)"
          },
          {
            "code" : "75772009",
            "display" : "Bone structure of navicular (body structure)"
          },
          {
            "code" : "75777003",
            "display" : "Cytokine (substance)"
          },
          {
            "code" : "75789001",
            "display" : "Onycholysis (disorder)"
          },
          {
            "code" : "75800005",
            "display" : "C4 certainty (qualifier value)"
          },
          {
            "code" : "75803007",
            "display" : "Posterior rhinorrhea (disorder)"
          },
          {
            "code" : "75817003",
            "display" : "Cellulitis of breast (disorder)"
          },
          {
            "code" : "75857000",
            "display" : "Fracture of radius AND ulna (disorder)"
          },
          {
            "code" : "75878002",
            "display" : "Abdominal aortic aneurysm without rupture (disorder)"
          },
          {
            "code" : "75888001",
            "display" : "Mesangiocapillary glomerulonephritis, type I (disorder)"
          },
          {
            "code" : "75902001",
            "display" : "Structure of atrioventricular branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "75911001",
            "display" : "Bearded collie (organism)"
          },
          {
            "code" : "75934005",
            "display" : "Metabolic disease (disorder)"
          },
          {
            "code" : "75941004",
            "display" : "Tripping (event)"
          },
          {
            "code" : "75955007",
            "display" : "Thrombosed hemorrhoids (disorder)"
          },
          {
            "code" : "75956008",
            "display" : "Hematein stain (substance)"
          },
          {
            "code" : "75958009",
            "display" : "Bounded by (attribute)"
          },
          {
            "code" : "75959001",
            "display" : "Product containing tamoxifen (medicinal product)"
          },
          {
            "code" : "75969007",
            "display" : "Product containing gonadotropin releasing factor (product)"
          },
          {
            "code" : "75971007",
            "display" : "Choroidal retinal neovascularization (disorder)"
          },
          {
            "code" : "75976002",
            "display" : "Mild risk of (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "75993002",
            "display" : "Atrophic vulvovaginitis (disorder)"
          },
          {
            "code" : "76001002",
            "display" : "Pyronine B stain (substance)"
          },
          {
            "code" : "76009000",
            "display" : "Esophagogastroduodenoscopy (procedure)"
          },
          {
            "code" : "76015000",
            "display" : "Hepatic artery (body structure)"
          },
          {
            "code" : "76025005",
            "display" : "Correction of ventricular septal defect (procedure)"
          },
          {
            "code" : "76030009",
            "display" : "Prepubertal orgasm (finding)"
          },
          {
            "code" : "76039005",
            "display" : "Disturbance of attention (finding)"
          },
          {
            "code" : "76047005",
            "display" : "Oophoritis (disorder)"
          },
          {
            "code" : "76048000",
            "display" : "Azocarmine G (GX) stain (substance)"
          },
          {
            "code" : "76067001",
            "display" : "Sneezing (finding)"
          },
          {
            "code" : "76069003",
            "display" : "Disorder of bone (disorder)"
          },
          {
            "code" : "76072005",
            "display" : "Skin structure of supraclavicular region of neck (body structure)"
          },
          {
            "code" : "76075007",
            "display" : "Play therapy (regime/therapy)"
          },
          {
            "code" : "76102007",
            "display" : "Male homosexual (finding)"
          },
          {
            "code" : "76105009",
            "display" : "Cyclothymia (disorder)"
          },
          {
            "code" : "76107001",
            "display" : "Spinal stenosis (disorder)"
          },
          {
            "code" : "76117006",
            "display" : "Structure of central retinal artery (body structure)"
          },
          {
            "code" : "76155001",
            "display" : "Product containing iopanoic acid (medicinal product)"
          },
          {
            "code" : "76169001",
            "display" : "Ascorbic acid deficiency (disorder)"
          },
          {
            "code" : "76171001",
            "display" : "Air trapping (finding)"
          },
          {
            "code" : "76197007",
            "display" : "Hyperplasia (morphologic abnormality)"
          },
          {
            "code" : "76201007",
            "display" : "Mechanical ptosis (disorder)"
          },
          {
            "code" : "76204004",
            "display" : "Painful clitoral erection (finding)"
          },
          {
            "code" : "76223006",
            "display" : "Bat ear (disorder)"
          },
          {
            "code" : "76231001",
            "display" : "Osteopath (occupation)"
          },
          {
            "code" : "76248009",
            "display" : "Entire elbow region (body structure)"
          },
          {
            "code" : "76253004",
            "display" : "Zulu (ethnic group)"
          },
          {
            "code" : "76261009",
            "display" : "Skin structure of axilla (body structure)"
          },
          {
            "code" : "76267008",
            "display" : "Pulmonary valve disorder (disorder)"
          },
          {
            "code" : "76272004",
            "display" : "Syphilis (disorder)"
          },
          {
            "code" : "76290003",
            "display" : "Structure of superior gluteal lymph node (body structure)"
          },
          {
            "code" : "76302002",
            "display" : "Spanish mustang horse (organism)"
          },
          {
            "code" : "76318008",
            "display" : "Disorder of tendon of shoulder region (disorder)"
          },
          {
            "code" : "76321005",
            "display" : "C2 certainty (qualifier value)"
          },
          {
            "code" : "76327009",
            "display" : "Borrelia burgdorferi (organism)"
          },
          {
            "code" : "76334006",
            "display" : "Immunotherapy (procedure)"
          },
          {
            "code" : "76349003",
            "display" : "Extrapyramidal disease (disorder)"
          },
          {
            "code" : "76351004",
            "display" : "Whippet dog (organism)"
          },
          {
            "code" : "76364003",
            "display" : "Boar power pig 27 (organism)"
          },
          {
            "code" : "76365002",
            "display" : "Structure of upper outer quadrant of breast (body structure)"
          },
          {
            "code" : "76376003",
            "display" : "Endometriosis of uterus (disorder)"
          },
          {
            "code" : "76388001",
            "display" : "ST segment elevation (finding)"
          },
          {
            "code" : "76426001",
            "display" : "Calorie diet (finding)"
          },
          {
            "code" : "76439002",
            "display" : "Fat red 7B stain (substance)"
          },
          {
            "code" : "76441001",
            "display" : "Severe major depression, single episode, without psychotic features (disorder)"
          },
          {
            "code" : "76460008",
            "display" : "Yanomama (ethnic group)"
          },
          {
            "code" : "76467006",
            "display" : "Quarter horse (organism)"
          },
          {
            "code" : "76497003",
            "display" : "Gelbveih cattle breed (organism)"
          },
          {
            "code" : "76498008",
            "display" : "Postmenopausal state (finding)"
          },
          {
            "code" : "76505004",
            "display" : "Thumb structure (body structure)"
          },
          {
            "code" : "76534005",
            "display" : "Myocarditis due to acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "76554006",
            "display" : "Belgian laeken dog (organism)"
          },
          {
            "code" : "76571007",
            "display" : "Septic shock (disorder)"
          },
          {
            "code" : "76574004",
            "display" : "Swiss (ethnic group)"
          },
          {
            "code" : "76581006",
            "display" : "Cholecystitis (disorder)"
          },
          {
            "code" : "76583009",
            "display" : "Chondrodermatitis nodularis helicis (disorder)"
          },
          {
            "code" : "76601001",
            "display" : "Intramuscular injection (procedure)"
          },
          {
            "code" : "76604009",
            "display" : "Nellore cattle breed (organism)"
          },
          {
            "code" : "76605005",
            "display" : "Biebrich scarlet stain (substance)"
          },
          {
            "code" : "76611008",
            "display" : "Atherectomy by laser (procedure)"
          },
          {
            "code" : "76612001",
            "display" : "Hypercoagulability state (finding)"
          },
          {
            "code" : "76616003",
            "display" : "Disorder of lymph node (disorder)"
          },
          {
            "code" : "76618002",
            "display" : "Urethral stricture (disorder)"
          },
          {
            "code" : "76633005",
            "display" : "Fast red TR salt stain (substance)"
          },
          {
            "code" : "76649007",
            "display" : "Sebaceous cyst of skin of breast (disorder)"
          },
          {
            "code" : "76652004",
            "display" : "Pseudofrigidity (finding)"
          },
          {
            "code" : "76659008",
            "display" : "Structure of pancreaticoduodenal lymph node (body structure)"
          },
          {
            "code" : "76668005",
            "display" : "Administration of vaccine product containing only Corynebacterium diphtheriae antigen (procedure)"
          },
          {
            "code" : "76679000",
            "display" : "Vibratory fluttering (observable entity)"
          },
          {
            "code" : "76704003",
            "display" : "Superior lateral inguinal lymph node (body structure)"
          },
          {
            "code" : "76710003",
            "display" : "Structure of external limiting membrane of retina (body structure)"
          },
          {
            "code" : "76713001",
            "display" : "Protein diet (finding)"
          },
          {
            "code" : "76723005",
            "display" : "Skin structure of prepuce of clitoris (body structure)"
          },
          {
            "code" : "76724004",
            "display" : "Harrier dog (organism)"
          },
          {
            "code" : "76742009",
            "display" : "Postmenopausal bleeding (finding)"
          },
          {
            "code" : "76746007",
            "display" : "Cardiovascular stress testing (procedure)"
          },
          {
            "code" : "76751001",
            "display" : "Diabetes mellitus in mother complicating pregnancy, childbirth AND/OR puerperium (disorder)"
          },
          {
            "code" : "76752008",
            "display" : "Breast structure (body structure)"
          },
          {
            "code" : "76759004",
            "display" : "Product containing disopyramide (medicinal product)"
          },
          {
            "code" : "76768002",
            "display" : "Filipinos (ethnic group)"
          },
          {
            "code" : "76775001",
            "display" : "Ugandans (ethnic group)"
          },
          {
            "code" : "76776000",
            "display" : "Rickettsia bellii (organism)"
          },
          {
            "code" : "76783007",
            "display" : "Chronic hepatitis (disorder)"
          },
          {
            "code" : "76784001",
            "display" : "Vaginal structure (body structure)"
          },
          {
            "code" : "76795007",
            "display" : "Acute type B viral hepatitis (disorder)"
          },
          {
            "code" : "76802005",
            "display" : "Chronic gonococcal cervicitis (disorder)"
          },
          {
            "code" : "76807004",
            "display" : "Cervicobrachialgia (finding)"
          },
          {
            "code" : "76810006",
            "display" : "Diagnostic dilation and curettage of uterus (procedure)"
          },
          {
            "code" : "76812003",
            "display" : "Panic disorder with agoraphobia, moderate agoraphobic avoidance AND panic attacks in partial remission (disorder)"
          },
          {
            "code" : "76828008",
            "display" : "Babesia microti (organism)"
          },
          {
            "code" : "76838003",
            "display" : "Structure of supraclavicular lymph node (body structure)"
          },
          {
            "code" : "76844004",
            "display" : "Local infection of wound (disorder)"
          },
          {
            "code" : "76847006",
            "display" : "Gratification (finding)"
          },
          {
            "code" : "76848001",
            "display" : "Pericardial structure (body structure)"
          },
          {
            "code" : "76862008",
            "display" : "Structure of ostium of left coronary artery (body structure)"
          },
          {
            "code" : "76865005",
            "display" : "Closed fracture of distal phalanx of finger (disorder)"
          },
          {
            "code" : "76868007",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in full remission AND mild panic attacks (disorder)"
          },
          {
            "code" : "76878005",
            "display" : "Structure of lymph node of greater curvature of stomach (body structure)"
          },
          {
            "code" : "76883002",
            "display" : "Huichol (ethnic group)"
          },
          {
            "code" : "76902006",
            "display" : "Tetanus (disorder)"
          },
          {
            "code" : "76925007",
            "display" : "Alkali blue 5B (4B) stain (substance)"
          },
          {
            "code" : "76927004",
            "display" : "Radioisotope study of genitourinary system (procedure)"
          },
          {
            "code" : "76948002",
            "display" : "Severe pain (finding)"
          },
          {
            "code" : "76949005",
            "display" : "Gonioscopy (procedure)"
          },
          {
            "code" : "76956004",
            "display" : "Amputation of finger, except thumb (procedure)"
          },
          {
            "code" : "76976005",
            "display" : "Optic atrophy (disorder)"
          },
          {
            "code" : "76994004",
            "display" : "Norwegian elkhound (organism)"
          },
          {
            "code" : "77004003",
            "display" : "Fluorine-18 (substance)"
          },
          {
            "code" : "77012006",
            "display" : "Amniotic fluid (substance)"
          },
          {
            "code" : "77028001",
            "display" : "Secondary syphilis of anus (disorder)"
          },
          {
            "code" : "77045006",
            "display" : "Acinetobacter haemolyticus (organism)"
          },
          {
            "code" : "77063006",
            "display" : "Hyperlipoproteinemia diet, type IV (finding)"
          },
          {
            "code" : "77073008",
            "display" : "Nile blue stain (substance)"
          },
          {
            "code" : "77075001",
            "display" : "Primary open angle glaucoma (disorder)"
          },
          {
            "code" : "77080005",
            "display" : "Neurotrophic keratoconjunctivitis (disorder)"
          },
          {
            "code" : "77090002",
            "display" : "Bullous pemphigoid (disorder)"
          },
          {
            "code" : "77091003",
            "display" : "Malnutrition of moderate degree (Gomez: 60% to less than 75% of standard weight) (disorder)"
          },
          {
            "code" : "77096008",
            "display" : "Social isolation (rejection) (finding)"
          },
          {
            "code" : "77116006",
            "display" : "Infection caused by Bordetella parapertussis (disorder)"
          },
          {
            "code" : "77130001",
            "display" : "Structure of mandibular left lateral incisor tooth (body structure)"
          },
          {
            "code" : "77150002",
            "display" : "History and physical examination, school (procedure)"
          },
          {
            "code" : "77157004",
            "display" : "Disorder of optic nerve (disorder)"
          },
          {
            "code" : "77166000",
            "display" : "Percutaneous balloon valvuloplasty of aortic valve (procedure)"
          },
          {
            "code" : "77176002",
            "display" : "Smoker (finding)"
          },
          {
            "code" : "77181006",
            "display" : "Implantation of mitral valve prosthesis or synthetic device (procedure)"
          },
          {
            "code" : "77182004",
            "display" : "Membranous glomerulonephritis (disorder)"
          },
          {
            "code" : "77199003",
            "display" : "Rickettsia montanensis (organism)"
          },
          {
            "code" : "77213006",
            "display" : "Afghan hound (organism)"
          },
          {
            "code" : "77224008",
            "display" : "Spina bifida of lumbar region (disorder)"
          },
          {
            "code" : "77225009",
            "display" : "Blind loop syndrome (disorder)"
          },
          {
            "code" : "77235003",
            "display" : "San Angelo virus (organism)"
          },
          {
            "code" : "77236002",
            "display" : "Large white pig (organism)"
          },
          {
            "code" : "77248004",
            "display" : "Infection control procedure (procedure)"
          },
          {
            "code" : "77252004",
            "display" : "Pityriasis rosea (disorder)"
          },
          {
            "code" : "77259008",
            "display" : "Prolonged second stage of labor (disorder)"
          },
          {
            "code" : "77265008",
            "display" : "Furuncle of toe (disorder)"
          },
          {
            "code" : "77281003",
            "display" : "Calcofluor white stain (procedure)"
          },
          {
            "code" : "77296004",
            "display" : "Infarction of breast (disorder)"
          },
          {
            "code" : "77313009",
            "display" : "Technetium (99m-Tc) exametazime (substance)"
          },
          {
            "code" : "77318000",
            "display" : "General diet for adult (finding)"
          },
          {
            "code" : "77329001",
            "display" : "Mouth breathing (finding)"
          },
          {
            "code" : "77332003",
            "display" : "Partialism (disorder)"
          },
          {
            "code" : "77343006",
            "display" : "Angiography (procedure)"
          },
          {
            "code" : "77352002",
            "display" : "Genus Shigella (organism)"
          },
          {
            "code" : "77377001",
            "display" : "Leptospirosis (disorder)"
          },
          {
            "code" : "77386006",
            "display" : "Pregnant (finding)"
          },
          {
            "code" : "77414002",
            "display" : "Cheilognathoschisis (disorder)"
          },
          {
            "code" : "77416000",
            "display" : "Jealousy (finding)"
          },
          {
            "code" : "77427003",
            "display" : "Activity intolerance (finding)"
          },
          {
            "code" : "77444004",
            "display" : "Bone pin, device (physical object)"
          },
          {
            "code" : "77465005",
            "display" : "Transplantation (procedure)"
          },
          {
            "code" : "77477000",
            "display" : "Computerized axial tomography (procedure)"
          },
          {
            "code" : "77480004",
            "display" : "Congenital biliary atresia (disorder)"
          },
          {
            "code" : "77489003",
            "display" : "Pterygium (disorder)"
          },
          {
            "code" : "77493009",
            "display" : "Fracture of pelvis (disorder)"
          },
          {
            "code" : "77502007",
            "display" : "Atacamenos (ethnic group)"
          },
          {
            "code" : "77506005",
            "display" : "Infection caused by Trypanosoma cruzi (disorder)"
          },
          {
            "code" : "77507001",
            "display" : "Mixed conductive AND sensorineural hearing loss (disorder)"
          },
          {
            "code" : "77528005",
            "display" : "Cholelithiasis with obstruction (disorder)"
          },
          {
            "code" : "77543007",
            "display" : "Ligation of fallopian tube (procedure)"
          },
          {
            "code" : "77545000",
            "display" : "Chronic hypotension (disorder)"
          },
          {
            "code" : "77547008",
            "display" : "Degeneration of intervertebral disc (disorder)"
          },
          {
            "code" : "77568009",
            "display" : "Back structure, excluding neck (body structure)"
          },
          {
            "code" : "77583004",
            "display" : "Structure of anulus fibrosus of aorta (body structure)"
          },
          {
            "code" : "77588008",
            "display" : "Exposure to animate mechanical force (event)"
          },
          {
            "code" : "77595004",
            "display" : "Reduction deformity of lower limb (disorder)"
          },
          {
            "code" : "77599005",
            "display" : "Toeing-in (finding)"
          },
          {
            "code" : "77621008",
            "display" : "Structure of supraclavicular region of neck (body structure)"
          },
          {
            "code" : "77671006",
            "display" : "Antidiuretic hormone (substance)"
          },
          {
            "code" : "77674003",
            "display" : "Hemianopia (finding)"
          },
          {
            "code" : "77686000",
            "display" : "Kwakiutl (ethnic group)"
          },
          {
            "code" : "77692006",
            "display" : "Hypersomnia (disorder)"
          },
          {
            "code" : "77698005",
            "display" : "Protein exchange list (finding)"
          },
          {
            "code" : "77702009",
            "display" : "Malnutrition of mild degree (Gomez: 75% to less than 90% of standard weight) (disorder)"
          },
          {
            "code" : "77712002",
            "display" : "Francisella novicida (organism)"
          },
          {
            "code" : "77720000",
            "display" : "Clip, device (physical object)"
          },
          {
            "code" : "77721001",
            "display" : "Opioid intoxication (disorder)"
          },
          {
            "code" : "77740007",
            "display" : "Struck by falling tool (event)"
          },
          {
            "code" : "77777004",
            "display" : "Bone staple, device (physical object)"
          },
          {
            "code" : "77778009",
            "display" : "Structure of pancreatic lymph node (body structure)"
          },
          {
            "code" : "77797009",
            "display" : "Hereditary corneal dystrophy (disorder)"
          },
          {
            "code" : "77806000",
            "display" : "Calorie restricted diet (finding)"
          },
          {
            "code" : "77831004",
            "display" : "Structure of upper inner quadrant of breast (body structure)"
          },
          {
            "code" : "77854008",
            "display" : "Failed medical induction of labor (disorder)"
          },
          {
            "code" : "77860008",
            "display" : "Derangement of posterior horn of lateral meniscus (disorder)"
          },
          {
            "code" : "77867006",
            "display" : "Shortened QT interval (finding)"
          },
          {
            "code" : "77880009",
            "display" : "Rectal pain (finding)"
          },
          {
            "code" : "77896007",
            "display" : "Cytopathology procedure, cell block and smear preparation (procedure)"
          },
          {
            "code" : "77939001",
            "display" : "Syphilitic disseminated retinochoroiditis (disorder)"
          },
          {
            "code" : "77943002",
            "display" : "Selected 20 gram protein diet (finding)"
          },
          {
            "code" : "77945009",
            "display" : "Simple renal cyst (disorder)"
          },
          {
            "code" : "77956009",
            "display" : "Steinert myotonic dystrophy syndrome (disorder)"
          },
          {
            "code" : "77970009",
            "display" : "Benign hypertensive heart disease without congestive heart failure (disorder)"
          },
          {
            "code" : "77971008",
            "display" : "Iridocyclitis (disorder)"
          },
          {
            "code" : "77993003",
            "display" : "Exposure to attack by other person (event)"
          },
          {
            "code" : "77994009",
            "display" : "Primary localized osteoarthrosis of pelvic region (disorder)"
          },
          {
            "code" : "78004001",
            "display" : "Bulimia nervosa (disorder)"
          },
          {
            "code" : "78014005",
            "display" : "Urine (substance)"
          },
          {
            "code" : "78018008",
            "display" : "Complete phocomelia of upper limb (disorder)"
          },
          {
            "code" : "78023008",
            "display" : "Strontium-87m (substance)"
          },
          {
            "code" : "78031003",
            "display" : "Rheumatic aortic regurgitation (disorder)"
          },
          {
            "code" : "78048006",
            "display" : "Candidiasis (disorder)"
          },
          {
            "code" : "78065002",
            "display" : "Enterococcus faecalis (organism)"
          },
          {
            "code" : "78067005",
            "display" : "Placental structure (body structure)"
          },
          {
            "code" : "78076003",
            "display" : "Structure of lens of eye (body structure)"
          },
          {
            "code" : "78077007",
            "display" : "Battered spouse syndrome (finding)"
          },
          {
            "code" : "78078002",
            "display" : "Struck by falling liquid matter (event)"
          },
          {
            "code" : "78092008",
            "display" : "Drug rehabilitation (regime/therapy)"
          },
          {
            "code" : "78112006",
            "display" : "Mycobacterium phlei (organism)"
          },
          {
            "code" : "78129009",
            "display" : "Thrombotic thrombocytopenic purpura (disorder)"
          },
          {
            "code" : "78141002",
            "display" : "Erb-Duchenne paralysis (disorder)"
          },
          {
            "code" : "78150000",
            "display" : "Soft diet (finding)"
          },
          {
            "code" : "78152008",
            "display" : "Multiple cranial nerve palsy (disorder)"
          },
          {
            "code" : "78153003",
            "display" : "City dweller (finding)"
          },
          {
            "code" : "78164000",
            "display" : "Feeding problem (finding)"
          },
          {
            "code" : "78167007",
            "display" : "Larva of genus Taenia (organism)"
          },
          {
            "code" : "78181009",
            "display" : "Giardia lamblia (organism)"
          },
          {
            "code" : "78197004",
            "display" : "Comedocarcinoma, noninfiltrating (morphologic abnormality)"
          },
          {
            "code" : "78214003",
            "display" : "Lakeland terrier (organism)"
          },
          {
            "code" : "78222005",
            "display" : "Denial - mental defense mechanism (finding)"
          },
          {
            "code" : "78246003",
            "display" : "Mexican hairless dog (organism)"
          },
          {
            "code" : "78267003",
            "display" : "Cocaine abuse (disorder)"
          },
          {
            "code" : "78269000",
            "display" : "Bipolar I disorder, single manic episode, in partial remission (disorder)"
          },
          {
            "code" : "78275009",
            "display" : "Obstructive sleep apnea syndrome (disorder)"
          },
          {
            "code" : "78277001",
            "display" : "Temporal lobe structure (body structure)"
          },
          {
            "code" : "78314001",
            "display" : "Osteogenesis imperfecta (disorder)"
          },
          {
            "code" : "78318003",
            "display" : "History and physical examination, annual for health maintenance (procedure)"
          },
          {
            "code" : "78331008",
            "display" : "Fall from gymnastic bars (event)"
          },
          {
            "code" : "78361000",
            "display" : "Engaged in falling (event)"
          },
          {
            "code" : "78370002",
            "display" : "Scleritis (disorder)"
          },
          {
            "code" : "78418002",
            "display" : "Operation on heart and pericardium (procedure)"
          },
          {
            "code" : "78420004",
            "display" : "Viral enteritis (disorder)"
          },
          {
            "code" : "78421000",
            "display" : "Intramuscular route (qualifier value)"
          },
          {
            "code" : "78427001",
            "display" : "Occupational noise exposure (event)"
          },
          {
            "code" : "78435003",
            "display" : "Ganglion of joint (disorder)"
          },
          {
            "code" : "78444002",
            "display" : "Mycobacterium sphagni (organism)"
          },
          {
            "code" : "78455002",
            "display" : "Subjective visual disturbance (disorder)"
          },
          {
            "code" : "78456001",
            "display" : "Normal menstrual cycle (finding)"
          },
          {
            "code" : "78475006",
            "display" : "Hepatitis E virus (organism)"
          },
          {
            "code" : "78480002",
            "display" : "Structure of right pulmonary artery (body structure)"
          },
          {
            "code" : "78481003",
            "display" : "Iofetamine (123-I) hydrochloride (substance)"
          },
          {
            "code" : "78502005",
            "display" : "Lactose free diet (finding)"
          },
          {
            "code" : "78513008",
            "display" : "Fusion binocular vision (observable entity)"
          },
          {
            "code" : "78514002",
            "display" : "Thigh pain (finding)"
          },
          {
            "code" : "78516000",
            "display" : "Fracture of sternum (disorder)"
          },
          {
            "code" : "78523004",
            "display" : "Late effect of radiation (disorder)"
          },
          {
            "code" : "78524005",
            "display" : "Alcohol-induced sexual dysfunction (finding)"
          },
          {
            "code" : "78533007",
            "display" : "Irrigation of urinary bladder (procedure)"
          },
          {
            "code" : "78541007",
            "display" : "Milking Shorthorn cattle breed (organism)"
          },
          {
            "code" : "78544004",
            "display" : "Chronic hypertensive uremia (disorder)"
          },
          {
            "code" : "78559005",
            "display" : "Operative procedure on shoulder region (procedure)"
          },
          {
            "code" : "78570003",
            "display" : "Indium (111-In) transferrin (substance)"
          },
          {
            "code" : "78580004",
            "display" : "Mumps orchitis (disorder)"
          },
          {
            "code" : "78609007",
            "display" : "Chronic peritoneal effusion (disorder)"
          },
          {
            "code" : "78622004",
            "display" : "Galactorrhea not associated with childbirth (disorder)"
          },
          {
            "code" : "78623009",
            "display" : "Endometritis (disorder)"
          },
          {
            "code" : "78629008",
            "display" : "Total self-care deficit (finding)"
          },
          {
            "code" : "78633001",
            "display" : "Altered thought processes (finding)"
          },
          {
            "code" : "78648007",
            "display" : "At risk for infection (finding)"
          },
          {
            "code" : "78667006",
            "display" : "Dysthymia (disorder)"
          },
          {
            "code" : "78678003",
            "display" : "Sus scrofa (organism)"
          },
          {
            "code" : "78686003",
            "display" : "Copper (64-Cu) acetate (substance)"
          },
          {
            "code" : "78715003",
            "display" : "Subdeltoid bursitis (disorder)"
          },
          {
            "code" : "78737005",
            "display" : "Frontal sinusitis (disorder)"
          },
          {
            "code" : "78740005",
            "display" : "Complete monosomy 21 syndrome (disorder)"
          },
          {
            "code" : "78745000",
            "display" : "Urticaria pigmentosa (disorder)"
          },
          {
            "code" : "78768009",
            "display" : "Subconjunctival hemorrhage (disorder)"
          },
          {
            "code" : "78808002",
            "display" : "Essential hypertension complicating AND/OR reason for care during pregnancy (disorder)"
          },
          {
            "code" : "78809005",
            "display" : "Gastric polyp (disorder)"
          },
          {
            "code" : "78823007",
            "display" : "Life support procedure (procedure)"
          },
          {
            "code" : "78857004",
            "display" : "Natural death with proved cause without autopsy (event)"
          },
          {
            "code" : "78868004",
            "display" : "Chronic mucoid otitis media (disorder)"
          },
          {
            "code" : "78869007",
            "display" : "Nuclear fast red stain (substance)"
          },
          {
            "code" : "78875003",
            "display" : "Cortical senile cataract (disorder)"
          },
          {
            "code" : "78895009",
            "display" : "Congenital pneumonia (disorder)"
          },
          {
            "code" : "78904004",
            "display" : "Chest wall structure (body structure)"
          },
          {
            "code" : "78961009",
            "display" : "Splenic structure (body structure)"
          },
          {
            "code" : "78962002",
            "display" : "Kissing (finding)"
          },
          {
            "code" : "78972004",
            "display" : "Structure of pedicle of vertebra (body structure)"
          },
          {
            "code" : "78975002",
            "display" : "Malignant essential hypertension (disorder)"
          },
          {
            "code" : "78981005",
            "display" : "Genus Mycoplasma (organism)"
          },
          {
            "code" : "78994007",
            "display" : "British landrace pig (organism)"
          },
          {
            "code" : "79010009",
            "display" : "Parenthood (observable entity)"
          },
          {
            "code" : "79012001",
            "display" : "Vaginospasm (finding)"
          },
          {
            "code" : "79015004",
            "display" : "Worried (finding)"
          },
          {
            "code" : "79035003",
            "display" : "Anemia due to unknown mechanism (disorder)"
          },
          {
            "code" : "79068005",
            "display" : "Needle, device (physical object)"
          },
          {
            "code" : "79095000",
            "display" : "Complete excision of organ (procedure)"
          },
          {
            "code" : "79128009",
            "display" : "Salmonella Paratyphi A (organism)"
          },
          {
            "code" : "79139007",
            "display" : "Petting (finding)"
          },
          {
            "code" : "79142001",
            "display" : "Suprapulmonic valve area structure (body structure)"
          },
          {
            "code" : "79163004",
            "display" : "Structure of left lobe of thyroid gland (body structure)"
          },
          {
            "code" : "79168008",
            "display" : "Congenital genu varum (disorder)"
          },
          {
            "code" : "79184009",
            "display" : "Bladder trabeculation (disorder)"
          },
          {
            "code" : "79197006",
            "display" : "Rubidium-82 (substance)"
          },
          {
            "code" : "79206001",
            "display" : "Specialized medical examination (procedure)"
          },
          {
            "code" : "79210003",
            "display" : "Electra complex (finding)"
          },
          {
            "code" : "79255005",
            "display" : "Mentum presentation of fetus (disorder)"
          },
          {
            "code" : "79261008",
            "display" : "Van der Woude syndrome (disorder)"
          },
          {
            "code" : "79267007",
            "display" : "Retinal migraine (disorder)"
          },
          {
            "code" : "79268002",
            "display" : "Polyneuropathy, organomegaly, endocrinopathy, monoclonal gammopathy, and skin changes syndrome (disorder)"
          },
          {
            "code" : "79280005",
            "display" : "Hypersomnia with sleep apnea (disorder)"
          },
          {
            "code" : "79283007",
            "display" : "Skin structure of tip of nose (body structure)"
          },
          {
            "code" : "79284001",
            "display" : "Rickettsia typhi (organism)"
          },
          {
            "code" : "79295007",
            "display" : "Boston terrier (organism)"
          },
          {
            "code" : "79298009",
            "display" : "Mild major depression, single episode (disorder)"
          },
          {
            "code" : "79313003",
            "display" : "Skin structure of helix (body structure)"
          },
          {
            "code" : "79315005",
            "display" : "Mechanical complication due to urethral indwelling catheter (disorder)"
          },
          {
            "code" : "79342006",
            "display" : "Ectropion of cervix (disorder)"
          },
          {
            "code" : "79348005",
            "display" : "Simple partial seizure, consciousness not impaired (disorder)"
          },
          {
            "code" : "79353000",
            "display" : "Tibia vara (disorder)"
          },
          {
            "code" : "79361005",
            "display" : "Structure of fontanel of skull (body structure)"
          },
          {
            "code" : "79365001",
            "display" : "Decreased stress (finding)"
          },
          {
            "code" : "79367009",
            "display" : "Child diabetes diet (finding)"
          },
          {
            "code" : "79369007",
            "display" : "Complication of transplanted pancreas (disorder)"
          },
          {
            "code" : "79385002",
            "display" : "Lowe syndrome (disorder)"
          },
          {
            "code" : "79410001",
            "display" : "Congenital cataract (disorder)"
          },
          {
            "code" : "79411002",
            "display" : "Acute prostatitis (disorder)"
          },
          {
            "code" : "79420006",
            "display" : "NX category (finding)"
          },
          {
            "code" : "79434006",
            "display" : "Quechua (ethnic group)"
          },
          {
            "code" : "79437004",
            "display" : "Rickettsia rhipicephali (organism)"
          },
          {
            "code" : "79458005",
            "display" : "Ascending (qualifier value)"
          },
          {
            "code" : "79471008",
            "display" : "Sudden hearing loss (disorder)"
          },
          {
            "code" : "79477007",
            "display" : "Gallium-66 (substance)"
          },
          {
            "code" : "79484004",
            "display" : "Closed transcervical fracture of femur (disorder)"
          },
          {
            "code" : "79502000",
            "display" : "Skin structure of tragus (body structure)"
          },
          {
            "code" : "79523006",
            "display" : "Bromine-76 (substance)"
          },
          {
            "code" : "79524000",
            "display" : "Ecouteurism (disorder)"
          },
          {
            "code" : "79546008",
            "display" : "Closed fracture of three ribs (disorder)"
          },
          {
            "code" : "79573009",
            "display" : "Accident while engaged in household activity (event)"
          },
          {
            "code" : "79586000",
            "display" : "Tubal pregnancy (disorder)"
          },
          {
            "code" : "79591004",
            "display" : "Spastic paralysis due to spinal birth injury (disorder)"
          },
          {
            "code" : "79601000",
            "display" : "Bone structure of scapula (body structure)"
          },
          {
            "code" : "79603002",
            "display" : "Romedale sheep (organism)"
          },
          {
            "code" : "79604008",
            "display" : "Disorder of breast (disorder)"
          },
          {
            "code" : "79610008",
            "display" : "Technetium (99m-Tc) albumin (substance)"
          },
          {
            "code" : "79619009",
            "display" : "Mitral valve stenosis (disorder)"
          },
          {
            "code" : "79631006",
            "display" : "Absence seizure (disorder)"
          },
          {
            "code" : "79643007",
            "display" : "Right sacroanterior position (finding)"
          },
          {
            "code" : "79652003",
            "display" : "Internal structure of eyeball (body structure)"
          },
          {
            "code" : "79654002",
            "display" : "Edema (morphologic abnormality)"
          },
          {
            "code" : "79671001",
            "display" : "Inferior vena cava syndrome (disorder)"
          },
          {
            "code" : "79688008",
            "display" : "Respiratory obstruction (disorder)"
          },
          {
            "code" : "79692001",
            "display" : "Right to left cardiovascular shunt (finding)"
          },
          {
            "code" : "79718009",
            "display" : "Structure of right carotid sinus (body structure)"
          },
          {
            "code" : "79720007",
            "display" : "Chronic nonalcoholic liver disease (disorder)"
          },
          {
            "code" : "79733001",
            "display" : "Amputation above-knee (procedure)"
          },
          {
            "code" : "79734007",
            "display" : "Noninflammatory disorder of ovary (disorder)"
          },
          {
            "code" : "79740000",
            "display" : "Candidiasis of mouth (disorder)"
          },
          {
            "code" : "79741001",
            "display" : "Common bile duct structure (body structure)"
          },
          {
            "code" : "79779006",
            "display" : "Patient discharge, deceased, no autopsy (procedure)"
          },
          {
            "code" : "79811009",
            "display" : "Electric blanket, device (physical object)"
          },
          {
            "code" : "79814001",
            "display" : "Poland China pig (organism)"
          },
          {
            "code" : "79817008",
            "display" : "Mycobacterium shimoidei (organism)"
          },
          {
            "code" : "79823003",
            "display" : "Panic (finding)"
          },
          {
            "code" : "79841006",
            "display" : "Genetic counseling (procedure)"
          },
          {
            "code" : "79875007",
            "display" : "Crimean-Congo hemorrhagic fever virus (organism)"
          },
          {
            "code" : "79879001",
            "display" : "Breath smells unpleasant (finding)"
          },
          {
            "code" : "79883001",
            "display" : "Cyst of ovary (disorder)"
          },
          {
            "code" : "79888005",
            "display" : "Sacroanterior position (finding)"
          },
          {
            "code" : "79890006",
            "display" : "Loss of appetite (finding)"
          },
          {
            "code" : "79917009",
            "display" : "Implantation of pulmonary valve prosthesis or synthetic device (procedure)"
          },
          {
            "code" : "79922009",
            "display" : "Epigastric pain (finding)"
          },
          {
            "code" : "79926007",
            "display" : "Structure of sacral lymph node (body structure)"
          },
          {
            "code" : "79951008",
            "display" : "Skin of occipital region (body structure)"
          },
          {
            "code" : "79962008",
            "display" : "Diffuse spasm of esophagus (disorder)"
          },
          {
            "code" : "79993009",
            "display" : "Government hospital (environment)"
          },
          {
            "code" : "80049006",
            "display" : "Structure of forceps major (body structure)"
          },
          {
            "code" : "80060002",
            "display" : "Furred tongue (disorder)"
          },
          {
            "code" : "80068009",
            "display" : "Swelling of limb (finding)"
          },
          {
            "code" : "80084005",
            "display" : "Lucie pig (organism)"
          },
          {
            "code" : "80093006",
            "display" : "Enophthalmos (disorder)"
          },
          {
            "code" : "80098002",
            "display" : "Diffuse Lewy body disease (disorder)"
          },
          {
            "code" : "80131009",
            "display" : "Landrace pig (organism)"
          },
          {
            "code" : "80140008",
            "display" : "Structure of permanent mandibular right first premolar tooth (body structure)"
          },
          {
            "code" : "80141007",
            "display" : "Hemoglobinopathy (disorder)"
          },
          {
            "code" : "80142000",
            "display" : "Perforation of nasal septum (disorder)"
          },
          {
            "code" : "80144004",
            "display" : "Bone structure of calcaneum (body structure)"
          },
          {
            "code" : "80146002",
            "display" : "Excision of appendix (procedure)"
          },
          {
            "code" : "80149009",
            "display" : "Manual penile stimulation (finding)"
          },
          {
            "code" : "80166006",
            "display" : "Streptococcus pyogenes (organism)"
          },
          {
            "code" : "80182007",
            "display" : "Irregular periods (finding)"
          },
          {
            "code" : "80193009",
            "display" : "Postgastric surgery syndrome (disorder)"
          },
          {
            "code" : "80208004",
            "display" : "Portuguese (ethnic group)"
          },
          {
            "code" : "80237000",
            "display" : "Cocoa butter (substance)"
          },
          {
            "code" : "80243003",
            "display" : "Eyelid structure (body structure)"
          },
          {
            "code" : "80246006",
            "display" : "Special stain, blood or bone marrow, explain by report (procedure)"
          },
          {
            "code" : "80248007",
            "display" : "Left breast structure (body structure)"
          },
          {
            "code" : "80272002",
            "display" : "Structure of carotid bifurcation (body structure)"
          },
          {
            "code" : "80274001",
            "display" : "Glomerular filtration rate (observable entity)"
          },
          {
            "code" : "80281008",
            "display" : "Cleft lip (disorder)"
          },
          {
            "code" : "80305003",
            "display" : "Pontamine sky blue 6BX stain (substance)"
          },
          {
            "code" : "80313002",
            "display" : "Palpitations (finding)"
          },
          {
            "code" : "80321008",
            "display" : "Mesangiocapillary glomerulonephritis (disorder)"
          },
          {
            "code" : "80327007",
            "display" : "Serous otitis media (disorder)"
          },
          {
            "code" : "80353004",
            "display" : "Enamel caries (disorder)"
          },
          {
            "code" : "80359000",
            "display" : "Infant diet 7-9 months: meat and egg (finding)"
          },
          {
            "code" : "80384002",
            "display" : "Epiglottitis (disorder)"
          },
          {
            "code" : "80388004",
            "display" : "Chronic gonorrhea of upper genitourinary tract (disorder)"
          },
          {
            "code" : "80394007",
            "display" : "Hyperglycemia (disorder)"
          },
          {
            "code" : "80402001",
            "display" : "Insertion of implantable venous access port (procedure)"
          },
          {
            "code" : "80423007",
            "display" : "Spontaneous pneumothorax (disorder)"
          },
          {
            "code" : "80426004",
            "display" : "Prolapsed internal hemorrhoids (disorder)"
          },
          {
            "code" : "80434005",
            "display" : "Structure of vertical occipital fasciculus (body structure)"
          },
          {
            "code" : "80446009",
            "display" : "Complete bilateral cleft lip (disorder)"
          },
          {
            "code" : "80447000",
            "display" : "Structure of cerebral aqueduct (body structure)"
          },
          {
            "code" : "80495009",
            "display" : "Sleep walking disorder (disorder)"
          },
          {
            "code" : "80515008",
            "display" : "Large liver (disorder)"
          },
          {
            "code" : "80520008",
            "display" : "Victim of trampling (finding)"
          },
          {
            "code" : "80522000",
            "display" : "Rehabilitation hospital (environment)"
          },
          {
            "code" : "80528001",
            "display" : "Xosa (ethnic group)"
          },
          {
            "code" : "80544005",
            "display" : "Spongy degeneration of central nervous system (disorder)"
          },
          {
            "code" : "80576000",
            "display" : "Sussex spaniel (organism)"
          },
          {
            "code" : "80580005",
            "display" : "Exposure to attack by marine animal (event)"
          },
          {
            "code" : "80581009",
            "display" : "Upper abdomen structure (body structure)"
          },
          {
            "code" : "80583007",
            "display" : "Severe anxiety (panic) (finding)"
          },
          {
            "code" : "80585000",
            "display" : "Intolerant of cold (finding)"
          },
          {
            "code" : "80600003",
            "display" : "Acute suppuration of nasal sinus (disorder)"
          },
          {
            "code" : "80601004",
            "display" : "At risk for activity intolerance (finding)"
          },
          {
            "code" : "80604007",
            "display" : "Acute gonococcal bartholinitis (disorder)"
          },
          {
            "code" : "80621003",
            "display" : "Structure of choroid plexus (body structure)"
          },
          {
            "code" : "80622005",
            "display" : "Abducens nerve structure (body structure)"
          },
          {
            "code" : "80623000",
            "display" : "Sleep-wake schedule disorder, delayed phase type (disorder)"
          },
          {
            "code" : "80635001",
            "display" : "Cardiovascular stress test using treadmill (procedure)"
          },
          {
            "code" : "80638004",
            "display" : "Work-related activity, function (observable entity)"
          },
          {
            "code" : "80640009",
            "display" : "Perirenal abscess (disorder)"
          },
          {
            "code" : "80645004",
            "display" : "Chronic mastoiditis (disorder)"
          },
          {
            "code" : "80647007",
            "display" : "Structure of maxillary right canine tooth (body structure)"
          },
          {
            "code" : "80659006",
            "display" : "Disorder of skin and/or subcutaneous tissue (disorder)"
          },
          {
            "code" : "80660001",
            "display" : "Mauriac's syndrome (disorder)"
          },
          {
            "code" : "80690008",
            "display" : "Degenerative disease of the central nervous system (disorder)"
          },
          {
            "code" : "80710001",
            "display" : "Primary hypomagnesemia (disorder)"
          },
          {
            "code" : "80711002",
            "display" : "Narcissistic personality disorder (disorder)"
          },
          {
            "code" : "80712009",
            "display" : "Congenital spondylolysis of lumbosacral region (disorder)"
          },
          {
            "code" : "80751004",
            "display" : "Xenon-133 (substance)"
          },
          {
            "code" : "80756009",
            "display" : "Closed fracture of patella (disorder)"
          },
          {
            "code" : "80764003",
            "display" : "Restoration, inlay (procedure)"
          },
          {
            "code" : "80769008",
            "display" : "Structure of tibial lymph node (body structure)"
          },
          {
            "code" : "80770009",
            "display" : "Secondary syphilis of liver (disorder)"
          },
          {
            "code" : "80777007",
            "display" : "Andalusian horse (organism)"
          },
          {
            "code" : "80835003",
            "display" : "Shorthorn cattle breed (organism)"
          },
          {
            "code" : "80865008",
            "display" : "Specimen mammography (procedure)"
          },
          {
            "code" : "80867000",
            "display" : "Structure of gluteal lymph node (body structure)"
          },
          {
            "code" : "80891009",
            "display" : "Heart structure (body structure)"
          },
          {
            "code" : "80897008",
            "display" : "Legionella pneumophila (organism)"
          },
          {
            "code" : "80910005",
            "display" : "Skin sensation disturbance (finding)"
          },
          {
            "code" : "80917008",
            "display" : "Toxin (substance)"
          },
          {
            "code" : "80919006",
            "display" : "Jewelry (physical object)"
          },
          {
            "code" : "80943009",
            "display" : "Risk factor (observable entity)"
          },
          {
            "code" : "80967001",
            "display" : "Dental caries (disorder)"
          },
          {
            "code" : "80979001",
            "display" : "San Pierre pig (organism)"
          },
          {
            "code" : "81000006",
            "display" : "Pediculosis capitis (disorder)"
          },
          {
            "code" : "81004002",
            "display" : "Leprosy (disorder)"
          },
          {
            "code" : "81016008",
            "display" : "Optic disc structure (body structure)"
          },
          {
            "code" : "81035008",
            "display" : "Pakistani (Urduspeakers) (ethnic group)"
          },
          {
            "code" : "81040000",
            "display" : "Pulmonary artery structure (body structure)"
          },
          {
            "code" : "81060008",
            "display" : "Intestinal obstruction (disorder)"
          },
          {
            "code" : "81075000",
            "display" : "Pleural effusion associated with pulmonary infection (disorder)"
          },
          {
            "code" : "81099000",
            "display" : "Cervical arthrodesis (procedure)"
          },
          {
            "code" : "81105003",
            "display" : "Cervical lymph node structure (body structure)"
          },
          {
            "code" : "81120009",
            "display" : "Functional disorder of intestine (disorder)"
          },
          {
            "code" : "81128002",
            "display" : "Structure of sinus of Valsalva (body structure)"
          },
          {
            "code" : "81132008",
            "display" : "Structure of scalene lymph node (body structure)"
          },
          {
            "code" : "81147004",
            "display" : "Fear of coitus (finding)"
          },
          {
            "code" : "81234003",
            "display" : "Walk-in clinic (environment)"
          },
          {
            "code" : "81256000",
            "display" : "Anomaly of tooth position (disorder)"
          },
          {
            "code" : "81267004",
            "display" : "Normande cattle breed (organism)"
          },
          {
            "code" : "81274009",
            "display" : "Apocrine metaplasia (morphologic abnormality)"
          },
          {
            "code" : "81283004",
            "display" : "Todas (ethnic group)"
          },
          {
            "code" : "81302005",
            "display" : "Worried well (finding)"
          },
          {
            "code" : "81308009",
            "display" : "Disorder of brain (disorder)"
          },
          {
            "code" : "81323004",
            "display" : "Normal general body function (finding)"
          },
          {
            "code" : "81339006",
            "display" : "Secondary syphilis of tonsil (disorder)"
          },
          {
            "code" : "81345003",
            "display" : "Stenosis of lacrimal canaliculi (disorder)"
          },
          {
            "code" : "81350009",
            "display" : "Free-floating anxiety (finding)"
          },
          {
            "code" : "81397005",
            "display" : "Auramine O stain (substance)"
          },
          {
            "code" : "81403004",
            "display" : "Swedes (ethnic group)"
          },
          {
            "code" : "81405006",
            "display" : "Open wound of upper limb (disorder)"
          },
          {
            "code" : "81418003",
            "display" : "Nummular eczema (disorder)"
          },
          {
            "code" : "81463002",
            "display" : "Bestiality (disorder)"
          },
          {
            "code" : "81498004",
            "display" : "Bursitis of hip (disorder)"
          },
          {
            "code" : "81502006",
            "display" : "Hypopharyngeal structure (body structure)"
          },
          {
            "code" : "81512004",
            "display" : "Loose body in knee (disorder)"
          },
          {
            "code" : "81516001",
            "display" : "Partial nephrectomy (procedure)"
          },
          {
            "code" : "81526008",
            "display" : "Hydromeningomyelocele (disorder)"
          },
          {
            "code" : "81529001",
            "display" : "Bloodhound (organism)"
          },
          {
            "code" : "81531005",
            "display" : "Diabetes mellitus type 2 in obese (disorder)"
          },
          {
            "code" : "81560001",
            "display" : "Tongan (ethnic group)"
          },
          {
            "code" : "81564005",
            "display" : "Chronic serous otitis media (disorder)"
          },
          {
            "code" : "81573002",
            "display" : "Collagen disease (disorder)"
          },
          {
            "code" : "81576005",
            "display" : "Closed fracture of phalanx of foot (disorder)"
          },
          {
            "code" : "81607005",
            "display" : "Keeshond (organism)"
          },
          {
            "code" : "81608000",
            "display" : "Insomnia disorder related to known organic factor (disorder)"
          },
          {
            "code" : "81621007",
            "display" : "Indium (111-In) labeled erythrocyte (substance)"
          },
          {
            "code" : "81626002",
            "display" : "Malignant hypertension in obstetric context (disorder)"
          },
          {
            "code" : "81639003",
            "display" : "Closed fracture of nasal bones (disorder)"
          },
          {
            "code" : "81642009",
            "display" : "Late effect of spinal cord injury (disorder)"
          },
          {
            "code" : "81653003",
            "display" : "Pehuenches (ethnic group)"
          },
          {
            "code" : "81654009",
            "display" : "Coronal (qualifier value)"
          },
          {
            "code" : "81665004",
            "display" : "Hepatitis B virus (organism)"
          },
          {
            "code" : "81669005",
            "display" : "Neurofibromatosis (morphologic abnormality)"
          },
          {
            "code" : "81680005",
            "display" : "Neck pain (finding)"
          },
          {
            "code" : "81681009",
            "display" : "Junctional premature beats (disorder)"
          },
          {
            "code" : "81701001",
            "display" : "Vesicular stomatitis virus (organism)"
          },
          {
            "code" : "81703003",
            "display" : "Chews tobacco (finding)"
          },
          {
            "code" : "81704009",
            "display" : "Sprue (disorder)"
          },
          {
            "code" : "81712001",
            "display" : "Pain in female genitalia on intercourse (finding)"
          },
          {
            "code" : "81723002",
            "display" : "Amputation (procedure)"
          },
          {
            "code" : "81727001",
            "display" : "Skeletal muscle structure of neck (body structure)"
          },
          {
            "code" : "81730008",
            "display" : "Abnormal sexual state (finding)"
          },
          {
            "code" : "81745001",
            "display" : "Structure of eye proper (body structure)"
          },
          {
            "code" : "81761004",
            "display" : "Technetium (99m-Tc) microaggregated albumin (substance)"
          },
          {
            "code" : "81763001",
            "display" : "At risk for injury (finding)"
          },
          {
            "code" : "81771002",
            "display" : "Opitz-Frias syndrome (disorder)"
          },
          {
            "code" : "81774005",
            "display" : "Klumpke-Déjerine paralysis as birth trauma (disorder)"
          },
          {
            "code" : "81780002",
            "display" : "Beckwith-Wiedemann syndrome (disorder)"
          },
          {
            "code" : "81808003",
            "display" : "Hemarthrosis (disorder)"
          },
          {
            "code" : "81817003",
            "display" : "Atherosclerosis of aorta (disorder)"
          },
          {
            "code" : "81827009",
            "display" : "Diameter (qualifier value)"
          },
          {
            "code" : "81830002",
            "display" : "Mononeuropathy simplex due to diabetes mellitus (disorder)"
          },
          {
            "code" : "81838009",
            "display" : "Mechanical clitoral stimulation (finding)"
          },
          {
            "code" : "81839001",
            "display" : "Medicinal product acting as anticoagulant agent (product)"
          },
          {
            "code" : "81846005",
            "display" : "Naiars (ethnic group)"
          },
          {
            "code" : "81866001",
            "display" : "Maine coon cat (organism)"
          },
          {
            "code" : "81870009",
            "display" : "Parotidectomy (procedure)"
          },
          {
            "code" : "81885003",
            "display" : "Glottal fricative, function (observable entity)"
          },
          {
            "code" : "81891001",
            "display" : "Hypersecretion of ovarian androgens (disorder)"
          },
          {
            "code" : "81902001",
            "display" : "Sprain of medial collateral ligament of knee (disorder)"
          },
          {
            "code" : "81911001",
            "display" : "Chewing tobacco (substance)"
          },
          {
            "code" : "81935006",
            "display" : "Family conflict (finding)"
          },
          {
            "code" : "81951003",
            "display" : "Histoplasma (organism)"
          },
          {
            "code" : "81953000",
            "display" : "Chest pain on exertion (finding)"
          },
          {
            "code" : "81992007",
            "display" : "Skin structure of scrotum (body structure)"
          },
          {
            "code" : "81996005",
            "display" : "Torsion of testis (disorder)"
          },
          {
            "code" : "82035006",
            "display" : "Resection of polyp (procedure)"
          },
          {
            "code" : "82062003",
            "display" : "Congenital hydrocele (disorder)"
          },
          {
            "code" : "82065001",
            "display" : "Fracture of carpal bone (disorder)"
          },
          {
            "code" : "82066000",
            "display" : "Bone density study, dual photon absorptiometry (procedure)"
          },
          {
            "code" : "82078001",
            "display" : "Collection of blood specimen for laboratory (procedure)"
          },
          {
            "code" : "82119001",
            "display" : "Thyroiditis (disorder)"
          },
          {
            "code" : "82127005",
            "display" : "Perianal abscess (disorder)"
          },
          {
            "code" : "82141001",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class A (disorder)"
          },
          {
            "code" : "82174001",
            "display" : "Shona (ethnic group)"
          },
          {
            "code" : "82195006",
            "display" : "Normal male sexual function (finding)"
          },
          {
            "code" : "82196007",
            "display" : "Vascular insufficiency of intestine (disorder)"
          },
          {
            "code" : "82206008",
            "display" : "Black cocker spaniel (organism)"
          },
          {
            "code" : "82212003",
            "display" : "Erosion of teeth (disorder)"
          },
          {
            "code" : "82236004",
            "display" : "Familial x-linked hypophosphatemic vitamin D refractory rickets (disorder)"
          },
          {
            "code" : "82242000",
            "display" : "Children's hospital (environment)"
          },
          {
            "code" : "82260000",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class R (disorder)"
          },
          {
            "code" : "82264009",
            "display" : "Product containing homatropine (medicinal product)"
          },
          {
            "code" : "82271004",
            "display" : "Injury of head (disorder)"
          },
          {
            "code" : "82272006",
            "display" : "Common cold (disorder)"
          },
          {
            "code" : "82275008",
            "display" : "Allergic granulomatosis angiitis (disorder)"
          },
          {
            "code" : "82276009",
            "display" : "Poisoning caused by antidepressant (disorder)"
          },
          {
            "code" : "82280004",
            "display" : "Smooth (qualifier value)"
          },
          {
            "code" : "82285009",
            "display" : "Low fat wired jaw diet (finding)"
          },
          {
            "code" : "82297005",
            "display" : "Congestion of nasal sinus (disorder)"
          },
          {
            "code" : "82300000",
            "display" : "Degenerative joint disease of ankle AND/OR foot (disorder)"
          },
          {
            "code" : "82302008",
            "display" : "Pipe smoker (finding)"
          },
          {
            "code" : "82313006",
            "display" : "Suicide attempt (event)"
          },
          {
            "code" : "82314000",
            "display" : "Administration of vaccine product containing only Rubella virus antigen (procedure)"
          },
          {
            "code" : "82327001",
            "display" : "Cardiac fluoroscopy (procedure)"
          },
          {
            "code" : "82334004",
            "display" : "Indeterminate (qualifier value)"
          },
          {
            "code" : "82339009",
            "display" : "Amphetamine-induced anxiety disorder (disorder)"
          },
          {
            "code" : "82355002",
            "display" : "Syphilitic aortic stenosis (disorder)"
          },
          {
            "code" : "82365008",
            "display" : "Structure of parasternal lymph node (body structure)"
          },
          {
            "code" : "82403002",
            "display" : "Cholangitis (disorder)"
          },
          {
            "code" : "82415003",
            "display" : "Agoraphobia without history of panic disorder without limited symptom attacks (disorder)"
          },
          {
            "code" : "82423001",
            "display" : "Chronic pain (finding)"
          },
          {
            "code" : "82440005",
            "display" : "Hampshire Down sheep (organism)"
          },
          {
            "code" : "82449006",
            "display" : "Peripheral intravenous catheter, device (physical object)"
          },
          {
            "code" : "82470000",
            "display" : "Muscle fasciculation (finding)"
          },
          {
            "code" : "82471001",
            "display" : "Left atrial structure (body structure)"
          },
          {
            "code" : "82474009",
            "display" : "Calcaneal tubercle structure (body structure)"
          },
          {
            "code" : "82494000",
            "display" : "Panic disorder without agoraphobia with panic attacks in full remission (disorder)"
          },
          {
            "code" : "82523003",
            "display" : "Congestive rheumatic heart failure (disorder)"
          },
          {
            "code" : "82525005",
            "display" : "Congenital cystic kidney disease (disorder)"
          },
          {
            "code" : "82545002",
            "display" : "Blood transfusion reaction (disorder)"
          },
          {
            "code" : "82550008",
            "display" : "Acinetobacter calcoaceticus (organism)"
          },
          {
            "code" : "82561000",
            "display" : "Symphysis pubis structure (body structure)"
          },
          {
            "code" : "82562007",
            "display" : "Osteochondritis dissecans (disorder)"
          },
          {
            "code" : "82566005",
            "display" : "Animal feed (substance)"
          },
          {
            "code" : "82573000",
            "display" : "Product containing lidocaine (medicinal product)"
          },
          {
            "code" : "82576008",
            "display" : "Retained foreign body in eye (disorder)"
          },
          {
            "code" : "82581004",
            "display" : "Ex-drinker (finding)"
          },
          {
            "code" : "82598004",
            "display" : "Secondary hypothyroidism (disorder)"
          },
          {
            "code" : "82608003",
            "display" : "Atrial dilatation (disorder)"
          },
          {
            "code" : "82612009",
            "display" : "Stumbling (event)"
          },
          {
            "code" : "82621005",
            "display" : "Natural death with proved cause by autopsy (event)"
          },
          {
            "code" : "82628004",
            "display" : "Structure of mandibular right lateral incisor tooth (body structure)"
          },
          {
            "code" : "82639001",
            "display" : "Premenstrual tension syndrome (disorder)"
          },
          {
            "code" : "82649003",
            "display" : "Astigmatism (disorder)"
          },
          {
            "code" : "82661006",
            "display" : "Abdominal pregnancy (disorder)"
          },
          {
            "code" : "82676003",
            "display" : "Wolf (organism)"
          },
          {
            "code" : "82680008",
            "display" : "Digit structure (body structure)"
          },
          {
            "code" : "82682000",
            "display" : "Victoria blue 4R stain (substance)"
          },
          {
            "code" : "82696006",
            "display" : "Neonatal jaundice due to delayed conjugation from breast milk inhibitor (disorder)"
          },
          {
            "code" : "82701004",
            "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class FR (disorder)"
          },
          {
            "code" : "82711006",
            "display" : "Infiltrating duct carcinoma (morphologic abnormality)"
          },
          {
            "code" : "82719008",
            "display" : "Fetal or neonatal effect of maternal anesthesia and/or analgesia (disorder)"
          },
          {
            "code" : "82732003",
            "display" : "Familial hypokalemic periodic paralysis (disorder)"
          },
          {
            "code" : "82738004",
            "display" : "Panic disorder with agoraphobia, moderate agoraphobic avoidance AND moderate panic attacks (disorder)"
          },
          {
            "code" : "82789004",
            "display" : "Acute mastitis (disorder)"
          },
          {
            "code" : "82793005",
            "display" : "Hypothalamic obesity (disorder)"
          },
          {
            "code" : "82799009",
            "display" : "Cardiac output (observable entity)"
          },
          {
            "code" : "82814008",
            "display" : "Oedipus complex (finding)"
          },
          {
            "code" : "82823006",
            "display" : "Autopsy, gross examination with brain (procedure)"
          },
          {
            "code" : "82849001",
            "display" : "Retroperitoneal compartment structure (body structure)"
          },
          {
            "code" : "82876001",
            "display" : "Living in mobile home (finding)"
          },
          {
            "code" : "82909008",
            "display" : "Middle white pig (organism)"
          },
          {
            "code" : "82935009",
            "display" : "Male mature sexual state (finding)"
          },
          {
            "code" : "82947003",
            "display" : "Fall from tree (event)"
          },
          {
            "code" : "82959004",
            "display" : "Dementia paralytica juvenilis (disorder)"
          },
          {
            "code" : "82971005",
            "display" : "Impaired mobility (finding)"
          },
          {
            "code" : "82985000",
            "display" : "Hemorrhoids without complication (disorder)"
          },
          {
            "code" : "82991003",
            "display" : "Generalized aches and pains (finding)"
          },
          {
            "code" : "82998009",
            "display" : "Moderate manic bipolar I disorder (disorder)"
          },
          {
            "code" : "82999001",
            "display" : "Epidural intracranial hemorrhage (disorder)"
          },
          {
            "code" : "83018002",
            "display" : "Plantar arterial arch structure (body structure)"
          },
          {
            "code" : "83036002",
            "display" : "Lactate (substance)"
          },
          {
            "code" : "83059008",
            "display" : "Tube, device (physical object)"
          },
          {
            "code" : "83074005",
            "display" : "Unplanned pregnancy (finding)"
          },
          {
            "code" : "83077003",
            "display" : "Tall for age (finding)"
          },
          {
            "code" : "83088009",
            "display" : "Acinetobacter lwoffii (organism)"
          },
          {
            "code" : "83099006",
            "display" : "Manual external cardiac massage with closed chest (procedure)"
          },
          {
            "code" : "83119008",
            "display" : "Congenital insufficiency of tricuspid valve (disorder)"
          },
          {
            "code" : "83128009",
            "display" : "Oliguria (finding)"
          },
          {
            "code" : "83132003",
            "display" : "Upper abdominal pain (finding)"
          },
          {
            "code" : "83152002",
            "display" : "Oophorectomy (procedure)"
          },
          {
            "code" : "83159006",
            "display" : "Cytomegalovirus encephalitis (disorder)"
          },
          {
            "code" : "83173002",
            "display" : "Scottish Highland cattle breed (organism)"
          },
          {
            "code" : "83208000",
            "display" : "Exposure to mechanical force (event)"
          },
          {
            "code" : "83216009",
            "display" : "Staffordshire bull terrier (organism)"
          },
          {
            "code" : "83225003",
            "display" : "Bipolar II disorder (disorder)"
          },
          {
            "code" : "83236005",
            "display" : "Saint Bernard dog (organism)"
          },
          {
            "code" : "83240001",
            "display" : "Abnormal sexual state and development (finding)"
          },
          {
            "code" : "83251001",
            "display" : "Frontal lobe structure (body structure)"
          },
          {
            "code" : "83253003",
            "display" : "Shyness disorder of childhood (disorder)"
          },
          {
            "code" : "83285000",
            "display" : "Enteropathogenic Escherichia coli (organism)"
          },
          {
            "code" : "83291003",
            "display" : "Cor pulmonale (disorder)"
          },
          {
            "code" : "83323007",
            "display" : "Bone formation, function (observable entity)"
          },
          {
            "code" : "83330001",
            "display" : "Patent ductus arteriosus (disorder)"
          },
          {
            "code" : "83331002",
            "display" : "T & A soft diet (finding)"
          },
          {
            "code" : "83333004",
            "display" : "Creation of cardiac pacemaker pocket new site in subcutaneous tissue (procedure)"
          },
          {
            "code" : "83346009",
            "display" : "Infant diet 5-7 months: cereal (finding)"
          },
          {
            "code" : "83358009",
            "display" : "Rotavirus group F (organism)"
          },
          {
            "code" : "83365001",
            "display" : "Thais (ethnic group)"
          },
          {
            "code" : "83376002",
            "display" : "Restoration, inlay, porcelain/ceramic (procedure)"
          },
          {
            "code" : "83380007",
            "display" : "Structure of gastro-omental lymph node (body structure)"
          },
          {
            "code" : "83412009",
            "display" : "Periodontal abscess (disorder)"
          },
          {
            "code" : "83414005",
            "display" : "Macrocytic anemia (disorder)"
          },
          {
            "code" : "83419000",
            "display" : "Femoral vein structure (body structure)"
          },
          {
            "code" : "83420006",
            "display" : "Natural daughter (person)"
          },
          {
            "code" : "83421005",
            "display" : "Failure to lose weight (finding)"
          },
          {
            "code" : "83422003",
            "display" : "Diagnostic procedure on blood vessel (procedure)"
          },
          {
            "code" : "83423008",
            "display" : "Sodium diprotrizoate (substance)"
          },
          {
            "code" : "83458005",
            "display" : "Agitated depression (disorder)"
          },
          {
            "code" : "83468000",
            "display" : "Fall from chair (event)"
          },
          {
            "code" : "83469008",
            "display" : "Hyperinsulinism (disorder)"
          },
          {
            "code" : "83473006",
            "display" : "Structure of occlusal surface of tooth (body structure)"
          },
          {
            "code" : "83504004",
            "display" : "Finnish spitz dog (organism)"
          },
          {
            "code" : "83521008",
            "display" : "Dilated cardiomyopathy caused by alcohol (disorder)"
          },
          {
            "code" : "83536006",
            "display" : "Stenosis of cervix (disorder)"
          },
          {
            "code" : "83549001",
            "display" : "Observation of parental sex act (finding)"
          },
          {
            "code" : "83555006",
            "display" : "Structure of lymphatic vessel (body structure)"
          },
          {
            "code" : "83561009",
            "display" : "Spinal stenosis in cervical region (disorder)"
          },
          {
            "code" : "83573009",
            "display" : "Phenylalanine restricted diet (finding)"
          },
          {
            "code" : "83578000",
            "display" : "Surgical (qualifier value)"
          },
          {
            "code" : "83579008",
            "display" : "Mixed gonadal dysgenesis (disorder)"
          },
          {
            "code" : "83584002",
            "display" : "Luo (ethnic group)"
          },
          {
            "code" : "83598005",
            "display" : "Xenon (substance)"
          },
          {
            "code" : "83600004",
            "display" : "Spirit soluble eosin stain (substance)"
          },
          {
            "code" : "83607001",
            "display" : "Gynecologic examination (procedure)"
          },
          {
            "code" : "83617006",
            "display" : "Hepatitis D virus (organism)"
          },
          {
            "code" : "83619009",
            "display" : "Polyvinyl alcohol (substance)"
          },
          {
            "code" : "83620003",
            "display" : "Nonpuerperal mastitis (disorder)"
          },
          {
            "code" : "83631006",
            "display" : "Panic disorder with agoraphobia, moderate agoraphobic avoidance AND severe panic attacks (disorder)"
          },
          {
            "code" : "83670000",
            "display" : "Peritoneal cavity structure (body structure)"
          },
          {
            "code" : "83675005",
            "display" : "Corynebacterium diphtheriae type gravis (organism)"
          },
          {
            "code" : "83723009",
            "display" : "Mycobacterium avium (organism)"
          },
          {
            "code" : "83746006",
            "display" : "Chronic schizophrenia (disorder)"
          },
          {
            "code" : "83785004",
            "display" : "Transient blindness (disorder)"
          },
          {
            "code" : "83799000",
            "display" : "Corrected transposition of great vessels (disorder)"
          },
          {
            "code" : "83813007",
            "display" : "Tube feeding diet (finding)"
          },
          {
            "code" : "83821001",
            "display" : "Cryptosporidium (organism)"
          },
          {
            "code" : "83841006",
            "display" : "Mycobacterium intracellulare (organism)"
          },
          {
            "code" : "83853005",
            "display" : "Enteral formula (finding)"
          },
          {
            "code" : "83866005",
            "display" : "Focal AND segmental proliferative glomerulonephritis (disorder)"
          },
          {
            "code" : "83881004",
            "display" : "Aluminium oxide (substance)"
          },
          {
            "code" : "83883001",
            "display" : "Cardiovascular syphilis (disorder)"
          },
          {
            "code" : "83891005",
            "display" : "Solo practice private office (environment)"
          },
          {
            "code" : "83901003",
            "display" : "Sjögren's syndrome (disorder)"
          },
          {
            "code" : "83939006",
            "display" : "Irula (ethnic group)"
          },
          {
            "code" : "83943005",
            "display" : "Temper tantrum (finding)"
          },
          {
            "code" : "83956003",
            "display" : "Companion sex play (finding)"
          },
          {
            "code" : "83978005",
            "display" : "Primary familial hypertrophic cardiomyopathy (disorder)"
          },
          {
            "code" : "83996001",
            "display" : "Criollo cattle breed (organism)"
          },
          {
            "code" : "84002002",
            "display" : "Pedophilia (disorder)"
          },
          {
            "code" : "84017003",
            "display" : "Bursitis (disorder)"
          },
          {
            "code" : "84026000",
            "display" : "Fall from moving vehicle (event)"
          },
          {
            "code" : "84027009",
            "display" : "Pernicious anemia (disorder)"
          },
          {
            "code" : "84056009",
            "display" : "Esophageal stage of deglutition (observable entity)"
          },
          {
            "code" : "84068000",
            "display" : "C1 certainty (qualifier value)"
          },
          {
            "code" : "84081007",
            "display" : "Boar power pig 747 (organism)"
          },
          {
            "code" : "84088001",
            "display" : "Correction of atresia of external meatus of ear (procedure)"
          },
          {
            "code" : "84089009",
            "display" : "Hiatal hernia (disorder)"
          },
          {
            "code" : "84094009",
            "display" : "Rebound hypertension (disorder)"
          },
          {
            "code" : "84114007",
            "display" : "Heart failure (disorder)"
          },
          {
            "code" : "84138006",
            "display" : "Collapse of vertebra (disorder)"
          },
          {
            "code" : "84149000",
            "display" : "Aspiration of cataract by phacoemulsification (procedure)"
          },
          {
            "code" : "84172003",
            "display" : "Spondylitis (disorder)"
          },
          {
            "code" : "84180005",
            "display" : "Mycobacterium simiae (organism)"
          },
          {
            "code" : "84195007",
            "display" : "Classical cesarean section (procedure)"
          },
          {
            "code" : "84210007",
            "display" : "Campylobacter fetus (organism)"
          },
          {
            "code" : "84217005",
            "display" : "Titan yellow stain (substance)"
          },
          {
            "code" : "84219008",
            "display" : "Structure of iliac lymph node (body structure)"
          },
          {
            "code" : "84229001",
            "display" : "Fatigue (finding)"
          },
          {
            "code" : "84232003",
            "display" : "Kleen leen red pig (organism)"
          },
          {
            "code" : "84267003",
            "display" : "Hysterotomy with removal of foreign body (procedure)"
          },
          {
            "code" : "84275009",
            "display" : "Obstetrical hysterotomy (procedure)"
          },
          {
            "code" : "84282008",
            "display" : "Simple ligature of hemorrhoid (procedure)"
          },
          {
            "code" : "84292000",
            "display" : "Menstrual period late (finding)"
          },
          {
            "code" : "84301002",
            "display" : "External auditory canal structure (body structure)"
          },
          {
            "code" : "84315000",
            "display" : "Boar power pig 474 (organism)"
          },
          {
            "code" : "84360004",
            "display" : "Ovoid shape (qualifier value)"
          },
          {
            "code" : "84365009",
            "display" : "Skin structure of philtrum (body structure)"
          },
          {
            "code" : "84367001",
            "display" : "English setter (organism)"
          },
          {
            "code" : "84386009",
            "display" : "Tribromoethanol (substance)"
          },
          {
            "code" : "84387000",
            "display" : "Asymptomatic (finding)"
          },
          {
            "code" : "84403003",
            "display" : "Circumstantial infidelity (finding)"
          },
          {
            "code" : "84404009",
            "display" : "Metal marker (occupation)"
          },
          {
            "code" : "84416003",
            "display" : "Contusion of thigh (disorder)"
          },
          {
            "code" : "84421000",
            "display" : "Structure of abdominal vein (body structure)"
          },
          {
            "code" : "84445001",
            "display" : "Joint stiffness (finding)"
          },
          {
            "code" : "84457005",
            "display" : "Spontaneous onset of labor (finding)"
          },
          {
            "code" : "84466009",
            "display" : "Dependent personality disorder (disorder)"
          },
          {
            "code" : "84471002",
            "display" : "Slowing of urinary stream (finding)"
          },
          {
            "code" : "84480002",
            "display" : "Retching (finding)"
          },
          {
            "code" : "84494001",
            "display" : "Open-angle glaucoma (disorder)"
          },
          {
            "code" : "84507004",
            "display" : "Skin structure of popliteal fossa (body structure)"
          },
          {
            "code" : "84514002",
            "display" : "Akita dog (organism)"
          },
          {
            "code" : "84528008",
            "display" : "Danish landrace pig (organism)"
          },
          {
            "code" : "84548001",
            "display" : "Kuvasz dog (organism)"
          },
          {
            "code" : "84556003",
            "display" : "Gleason grade score 6 out of 10 (finding)"
          },
          {
            "code" : "84568007",
            "display" : "Atrophic gastritis (disorder)"
          },
          {
            "code" : "84571004",
            "display" : "Formation of consonants, function (observable entity)"
          },
          {
            "code" : "84591006",
            "display" : "Mid-dorsum palatal stop, function (observable entity)"
          },
          {
            "code" : "84607009",
            "display" : "Skin structure of heel (body structure)"
          },
          {
            "code" : "84619001",
            "display" : "Nongonococcal urethritis (disorder)"
          },
          {
            "code" : "84626001",
            "display" : "Nutritional value, function (observable entity)"
          },
          {
            "code" : "84635008",
            "display" : "Disease process or condition education (procedure)"
          },
          {
            "code" : "84654008",
            "display" : "Structure of left anterior division of left branch of atrioventricular bundle (body structure)"
          },
          {
            "code" : "84656005",
            "display" : "Atebrin FS stain (substance)"
          },
          {
            "code" : "84660008",
            "display" : "Karelian bear dog (organism)"
          },
          {
            "code" : "84677008",
            "display" : "Burn of lower limb (disorder)"
          },
          {
            "code" : "84683006",
            "display" : "Aortic valve prosthesis (physical object)"
          },
          {
            "code" : "84698008",
            "display" : "Cholesterol (substance)"
          },
          {
            "code" : "84712000",
            "display" : "Structure of limbus of fossa ovalis (body structure)"
          },
          {
            "code" : "84757009",
            "display" : "Epilepsy (disorder)"
          },
          {
            "code" : "84758004",
            "display" : "Amphetamine abuse (disorder)"
          },
          {
            "code" : "84760002",
            "display" : "Schizoaffective disorder, depressive type (disorder)"
          },
          {
            "code" : "84782009",
            "display" : "Peripheral nerve structure (body structure)"
          },
          {
            "code" : "84797007",
            "display" : "Russian blue cat (organism)"
          },
          {
            "code" : "84805004",
            "display" : "Dental soft diet (finding)"
          },
          {
            "code" : "84812008",
            "display" : "Product containing heparin (medicinal product)"
          },
          {
            "code" : "84828003",
            "display" : "Leukopenia (disorder)"
          },
          {
            "code" : "84829006",
            "display" : "Struck by projectile (event)"
          },
          {
            "code" : "84839000",
            "display" : "Guernsey cattle breed (organism)"
          },
          {
            "code" : "84847000",
            "display" : "Platinum (substance)"
          },
          {
            "code" : "84849002",
            "display" : "Tinea corporis (disorder)"
          },
          {
            "code" : "84857004",
            "display" : "Herniation of nucleus pulposus (disorder)"
          },
          {
            "code" : "84877006",
            "display" : "Arthroscopy of knee with meniscus repair (procedure)"
          },
          {
            "code" : "84889008",
            "display" : "Parapharyngeal abscess (disorder)"
          },
          {
            "code" : "84917001",
            "display" : "Indirect light pupillary reflex (observable entity)"
          },
          {
            "code" : "84923006",
            "display" : "Aberdeen Angus cattle breed (organism)"
          },
          {
            "code" : "84955006",
            "display" : "Lumbo virus (organism)"
          },
          {
            "code" : "85005007",
            "display" : "Cannabis dependence (disorder)"
          },
          {
            "code" : "85007004",
            "display" : "Meralgia paresthetica (disorder)"
          },
          {
            "code" : "85020001",
            "display" : "Cystinuria (disorder)"
          },
          {
            "code" : "85042000",
            "display" : "Epiphora due to insufficient drainage (disorder)"
          },
          {
            "code" : "85050009",
            "display" : "Bone structure of humerus (body structure)"
          },
          {
            "code" : "85057007",
            "display" : "Cyst of liver (disorder)"
          },
          {
            "code" : "85059005",
            "display" : "Fistula of the female genital organs (disorder)"
          },
          {
            "code" : "85061001",
            "display" : "Separation anxiety disorder of childhood, early onset (disorder)"
          },
          {
            "code" : "85066006",
            "display" : "Azo black stain (substance)"
          },
          {
            "code" : "85081000",
            "display" : "Common arterial trunk and widely separate origin of pulmonary arteries (disorder)"
          },
          {
            "code" : "85102008",
            "display" : "Cerebellar ataxia (disorder)"
          },
          {
            "code" : "85119005",
            "display" : "Left inguinal region structure (body structure)"
          },
          {
            "code" : "85121000",
            "display" : "Manual clitoral stimulation (finding)"
          },
          {
            "code" : "85144002",
            "display" : "Belgian sheepdog (organism)"
          },
          {
            "code" : "85163001",
            "display" : "Russians (ethnic group)"
          },
          {
            "code" : "85179000",
            "display" : "Insertion of laminaria into cervix (procedure)"
          },
          {
            "code" : "85182005",
            "display" : "Sexual curiosity (finding)"
          },
          {
            "code" : "85189001",
            "display" : "Acute appendicitis (disorder)"
          },
          {
            "code" : "85190005",
            "display" : "Bismark brown Y stain (substance)"
          },
          {
            "code" : "85216006",
            "display" : "Displacement of cervical intervertebral disc without myelopathy (disorder)"
          },
          {
            "code" : "85225000",
            "display" : "Cyst of nasal sinus (disorder)"
          },
          {
            "code" : "85232009",
            "display" : "Left heart failure (disorder)"
          },
          {
            "code" : "85234005",
            "display" : "Structure of vertebral artery (body structure)"
          },
          {
            "code" : "85235006",
            "display" : "Structure of left subclavian artery (body structure)"
          },
          {
            "code" : "85248005",
            "display" : "Bipolar disorder in remission (disorder)"
          },
          {
            "code" : "85261005",
            "display" : "Contact with plant thorns (event)"
          },
          {
            "code" : "85272000",
            "display" : "Product containing nifedipine (medicinal product)"
          },
          {
            "code" : "85284003",
            "display" : "Angina, class III (disorder)"
          },
          {
            "code" : "85288000",
            "display" : "Rickettsia sibirica (organism)"
          },
          {
            "code" : "85293002",
            "display" : "Interstitial tissue (body structure)"
          },
          {
            "code" : "85315007",
            "display" : "Yorkshire pig (organism)"
          },
          {
            "code" : "85337000",
            "display" : "Poisoning caused by sedative AND/OR hypnotic (disorder)"
          },
          {
            "code" : "85371009",
            "display" : "Bushmen (ethnic group)"
          },
          {
            "code" : "85380009",
            "display" : "Structure of inferior inguinal lymph node (body structure)"
          },
          {
            "code" : "85383006",
            "display" : "Accessory renal artery (body structure)"
          },
          {
            "code" : "85419002",
            "display" : "Orchidopexy (procedure)"
          },
          {
            "code" : "85431000",
            "display" : "Fusiform aneurysm (morphologic abnormality)"
          },
          {
            "code" : "85439003",
            "display" : "Structure of cardiac vein (body structure)"
          },
          {
            "code" : "85456006",
            "display" : "Problem of growth and development (finding)"
          },
          {
            "code" : "85470006",
            "display" : "Testosterone measurement, total (procedure)"
          },
          {
            "code" : "85502002",
            "display" : "Bilateral inguinal hernia (disorder)"
          },
          {
            "code" : "85515006",
            "display" : "Eskimo (ethnic group)"
          },
          {
            "code" : "85544008",
            "display" : "Hyperalimentation formula for digestive tract maldevelopment (finding)"
          },
          {
            "code" : "85548006",
            "display" : "Episiotomy (procedure)"
          },
          {
            "code" : "85562004",
            "display" : "Hand structure (body structure)"
          },
          {
            "code" : "85571008",
            "display" : "Sensory hearing loss (disorder)"
          },
          {
            "code" : "85596006",
            "display" : "Fluorescein stain (substance)"
          },
          {
            "code" : "85598007",
            "display" : "Constrictive pericarditis (disorder)"
          },
          {
            "code" : "85606007",
            "display" : "Radionuclide cardiac ventriculography (procedure)"
          },
          {
            "code" : "85623003",
            "display" : "Ineffective thermoregulation (finding)"
          },
          {
            "code" : "85637007",
            "display" : "Internal capsule structure of brain (body structure)"
          },
          {
            "code" : "85649008",
            "display" : "Megaloblastic anemia due to folate deficiency (disorder)"
          },
          {
            "code" : "85659009",
            "display" : "Aneurysm (morphologic abnormality)"
          },
          {
            "code" : "85670002",
            "display" : "Vitamin deficiency (disorder)"
          },
          {
            "code" : "85672005",
            "display" : "Anterior horn cell disease (disorder)"
          },
          {
            "code" : "85693008",
            "display" : "Technetium (99m-Tc) aggregated albumin (substance)"
          },
          {
            "code" : "85710004",
            "display" : "Bone structure of ischium (body structure)"
          },
          {
            "code" : "85726003",
            "display" : "Mixed aneurysm (morphologic abnormality)"
          },
          {
            "code" : "85729005",
            "display" : "Shigella flexneri (organism)"
          },
          {
            "code" : "85738007",
            "display" : "Rickettsia parkeri (organism)"
          },
          {
            "code" : "85745007",
            "display" : "Ego-syntonic sexual orientation (finding)"
          },
          {
            "code" : "85746008",
            "display" : "Anemia due to protein deficiency (disorder)"
          },
          {
            "code" : "85756007",
            "display" : "Body tissue structure (body structure)"
          },
          {
            "code" : "85769006",
            "display" : "Streptococcal infectious disease (disorder)"
          },
          {
            "code" : "85777005",
            "display" : "Dacryocystitis (disorder)"
          },
          {
            "code" : "85778000",
            "display" : "Milk exchange list (finding)"
          },
          {
            "code" : "85803001",
            "display" : "Structure of eyelash (body structure)"
          },
          {
            "code" : "85816001",
            "display" : "Structure of retromolar area of mouth (body structure)"
          },
          {
            "code" : "85828009",
            "display" : "Autoimmune disease (disorder)"
          },
          {
            "code" : "85848002",
            "display" : "Corneal abrasion (disorder)"
          },
          {
            "code" : "85856004",
            "display" : "Acromioclavicular joint structure (body structure)"
          },
          {
            "code" : "85857008",
            "display" : "Secondary syphilis, relapse (treated) (disorder)"
          },
          {
            "code" : "85892000",
            "display" : "Promiscuous behavior (finding)"
          },
          {
            "code" : "85898001",
            "display" : "Cardiomyopathy (disorder)"
          },
          {
            "code" : "85908006",
            "display" : "Salmonella Paratyphi B (organism)"
          },
          {
            "code" : "85915003",
            "display" : "Laryngotracheobronchitis (disorder)"
          },
          {
            "code" : "85919009",
            "display" : "Disorder of intestine (disorder)"
          },
          {
            "code" : "85920003",
            "display" : "Constipation due to outlet obstruction (disorder)"
          },
          {
            "code" : "85921004",
            "display" : "Puncture procedure (procedure)"
          },
          {
            "code" : "85922006",
            "display" : "Fracture of hamate bone of wrist (disorder)"
          },
          {
            "code" : "85942002",
            "display" : "Ulceration of intestine (disorder)"
          },
          {
            "code" : "85944001",
            "display" : "Lassa virus (organism)"
          },
          {
            "code" : "85981002",
            "display" : "Chromotrope 2R stain (substance)"
          },
          {
            "code" : "86028001",
            "display" : "Syphilis of liver (disorder)"
          },
          {
            "code" : "86030004",
            "display" : "Secondary physiologic amenorrhea (finding)"
          },
          {
            "code" : "86041002",
            "display" : "Pre-existing hypertension in obstetric context (disorder)"
          },
          {
            "code" : "86044005",
            "display" : "Amyotrophic lateral sclerosis (disorder)"
          },
          {
            "code" : "86047003",
            "display" : "Active physical exercise (observable entity)"
          },
          {
            "code" : "86049000",
            "display" : "Malignant neoplasm, primary (morphologic abnormality)"
          },
          {
            "code" : "86088003",
            "display" : "Centesis (procedure)"
          },
          {
            "code" : "86094006",
            "display" : "Chronic rhinitis (disorder)"
          },
          {
            "code" : "86117002",
            "display" : "Internal carotid artery structure (body structure)"
          },
          {
            "code" : "86122002",
            "display" : "Bullet, device (physical object)"
          },
          {
            "code" : "86133004",
            "display" : "Cestode infection (disorder)"
          },
          {
            "code" : "86136007",
            "display" : "Lateral lemniscus structure (body structure)"
          },
          {
            "code" : "86142006",
            "display" : "Pemphigoid (disorder)"
          },
          {
            "code" : "86198006",
            "display" : "Administration of vaccine product containing only Influenza virus antigen (procedure)"
          },
          {
            "code" : "86203003",
            "display" : "Polyhydramnios (disorder)"
          },
          {
            "code" : "86234004",
            "display" : "Hypertensive heart AND renal disease (disorder)"
          },
          {
            "code" : "86259008",
            "display" : "Biopsy of liver (procedure)"
          },
          {
            "code" : "86268005",
            "display" : "Achondroplasia (disorder)"
          },
          {
            "code" : "86273004",
            "display" : "Biopsy (procedure)"
          },
          {
            "code" : "86275006",
            "display" : "Samoan (ethnic group)"
          },
          {
            "code" : "86276007",
            "display" : "Bleeding gums (finding)"
          },
          {
            "code" : "86279000",
            "display" : "Acute suppurative otitis media with spontaneous rupture of ear drum (disorder)"
          },
          {
            "code" : "86290005",
            "display" : "Respiratory rate (observable entity)"
          },
          {
            "code" : "86299006",
            "display" : "Tetralogy of Fallot (disorder)"
          },
          {
            "code" : "86308005",
            "display" : "Product containing sympathomimetic (product)"
          },
          {
            "code" : "86318000",
            "display" : "Decreased cardiac output (finding)"
          },
          {
            "code" : "86347007",
            "display" : "Traumatic urethral stricture (disorder)"
          },
          {
            "code" : "86356004",
            "display" : "Unstable lie (disorder)"
          },
          {
            "code" : "86367003",
            "display" : "Structure of left upper quadrant of abdomen (body structure)"
          },
          {
            "code" : "86378006",
            "display" : "Old bucket handle tear of medial meniscus (disorder)"
          },
          {
            "code" : "86380000",
            "display" : "Acquired claw toes (disorder)"
          },
          {
            "code" : "86395003",
            "display" : "Patient referral for family planning (procedure)"
          },
          {
            "code" : "86406008",
            "display" : "Human immunodeficiency virus infection (disorder)"
          },
          {
            "code" : "86407004",
            "display" : "Table, device (physical object)"
          },
          {
            "code" : "86409001",
            "display" : "Skin of external auditory canal (body structure)"
          },
          {
            "code" : "86414002",
            "display" : "Contracture of joint of hand (disorder)"
          },
          {
            "code" : "86423004",
            "display" : "Polyp of larynx (disorder)"
          },
          {
            "code" : "86432002",
            "display" : "Babesia divergens (organism)"
          },
          {
            "code" : "86433007",
            "display" : "Infant diet 0-12 months: human milk, vitamin D and C, fluoride and iron (finding)"
          },
          {
            "code" : "86440008",
            "display" : "Pic line pig 24 (organism)"
          },
          {
            "code" : "86466006",
            "display" : "Rheumatic mitral stenosis (disorder)"
          },
          {
            "code" : "86477000",
            "display" : "Total hysterectomy with removal of both tubes and ovaries (procedure)"
          },
          {
            "code" : "86480004",
            "display" : "Open reduction of fracture (procedure)"
          },
          {
            "code" : "86481000",
            "display" : "Laparotomy (procedure)"
          },
          {
            "code" : "86489003",
            "display" : "Idiopathic peripheral autonomic neuropathy (disorder)"
          },
          {
            "code" : "86521004",
            "display" : "Bromine-77 (substance)"
          },
          {
            "code" : "86541009",
            "display" : "Brilliant crocein stain (substance)"
          },
          {
            "code" : "86547008",
            "display" : "Structure of dorsalis pedis artery (body structure)"
          },
          {
            "code" : "86553008",
            "display" : "Immunosuppressive therapy (procedure)"
          },
          {
            "code" : "86555001",
            "display" : "Cystic fibrosis of the lung (disorder)"
          },
          {
            "code" : "86569001",
            "display" : "Postpartum state (finding)"
          },
          {
            "code" : "86570000",
            "display" : "Structure of mesenteric artery (body structure)"
          },
          {
            "code" : "86571001",
            "display" : "Finding related to maturity of sexuality (finding)"
          },
          {
            "code" : "86584005",
            "display" : "Iodoalphionic acid (substance)"
          },
          {
            "code" : "86591008",
            "display" : "Fall from ladder (event)"
          },
          {
            "code" : "86593006",
            "display" : "Colored bull terrier (organism)"
          },
          {
            "code" : "86598002",
            "display" : "Structure of apex of lung (body structure)"
          },
          {
            "code" : "86616005",
            "display" : "Intraductal carcinoma, noninfiltrating, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "86693001",
            "display" : "Autopsy review for teaching (procedure)"
          },
          {
            "code" : "86694007",
            "display" : "Hormel miniature pig (organism)"
          },
          {
            "code" : "86719006",
            "display" : "Skin structure of preauricular region (body structure)"
          },
          {
            "code" : "86743009",
            "display" : "Local excision (procedure)"
          },
          {
            "code" : "86749008",
            "display" : "Stripping and ligation (procedure)"
          },
          {
            "code" : "86750008",
            "display" : "Nitrazine yellow stain (substance)"
          },
          {
            "code" : "86765009",
            "display" : "Mild intellectual disability (disorder)"
          },
          {
            "code" : "86767001",
            "display" : "German shorthaired pointer (organism)"
          },
          {
            "code" : "86785008",
            "display" : "Bigamy (finding)"
          },
          {
            "code" : "86800006",
            "display" : "Operation on trachea (procedure)"
          },
          {
            "code" : "86854008",
            "display" : "Hyperreflexia (finding)"
          },
          {
            "code" : "86920006",
            "display" : "Horned dorset sheep breed (organism)"
          },
          {
            "code" : "86933000",
            "display" : "Heavy drinker (finding)"
          },
          {
            "code" : "86944008",
            "display" : "Visual field study (procedure)"
          },
          {
            "code" : "86981007",
            "display" : "Infective otitis externa (disorder)"
          },
          {
            "code" : "87017008",
            "display" : "Focal (qualifier value)"
          },
          {
            "code" : "87021001",
            "display" : "Mechanical vitrectomy by pars plana approach (procedure)"
          },
          {
            "code" : "87029004",
            "display" : "Old English sheepdog (organism)"
          },
          {
            "code" : "87049008",
            "display" : "Disorder of phosphorus metabolism (disorder)"
          },
          {
            "code" : "87061000",
            "display" : "Boar power pig 282 (organism)"
          },
          {
            "code" : "87065009",
            "display" : "Dystrophia unguium (disorder)"
          },
          {
            "code" : "87068006",
            "display" : "Stooped-over position (finding)"
          },
          {
            "code" : "87111007",
            "display" : "Cairn terrier (organism)"
          },
          {
            "code" : "87118001",
            "display" : "Vertiginous syndrome (disorder)"
          },
          {
            "code" : "87132004",
            "display" : "Opioid withdrawal (disorder)"
          },
          {
            "code" : "87166008",
            "display" : "Vomer bone structure (body structure)"
          },
          {
            "code" : "87185006",
            "display" : "Long atonic seizure (finding)"
          },
          {
            "code" : "87199005",
            "display" : "Lead screening (procedure)"
          },
          {
            "code" : "87219003",
            "display" : "Tibetan spaniel (organism)"
          },
          {
            "code" : "87233003",
            "display" : "Product containing low molecular weight heparin (product)"
          },
          {
            "code" : "87269006",
            "display" : "Furuncle of knee (disorder)"
          },
          {
            "code" : "87271006",
            "display" : "Legionella sainthelens (organism)"
          },
          {
            "code" : "87282003",
            "display" : "Intestinal parasitism (disorder)"
          },
          {
            "code" : "87317003",
            "display" : "Respiratory arrest (disorder)"
          },
          {
            "code" : "87323008",
            "display" : "Nez Percé (ethnic group)"
          },
          {
            "code" : "87335007",
            "display" : "Speaking (observable entity)"
          },
          {
            "code" : "87342007",
            "display" : "Bone structure of fibula (body structure)"
          },
          {
            "code" : "87343002",
            "display" : "Prinzmetal angina (disorder)"
          },
          {
            "code" : "87346005",
            "display" : "Child nutrition, function (observable entity)"
          },
          {
            "code" : "87366001",
            "display" : "Total elbow replacement (procedure)"
          },
          {
            "code" : "87386002",
            "display" : "Peau d'orange surface of breast (disorder)"
          },
          {
            "code" : "87388001",
            "display" : "Does not enjoy having sex (finding)"
          },
          {
            "code" : "87402003",
            "display" : "Campylobacter mucosalis (organism)"
          },
          {
            "code" : "87410002",
            "display" : "Technetium (99-Tc) lidofenin (substance)"
          },
          {
            "code" : "87414006",
            "display" : "Reactive depression (situational) (disorder)"
          },
          {
            "code" : "87433001",
            "display" : "Pulmonary emphysema (disorder)"
          },
          {
            "code" : "87437000",
            "display" : "Selenium-73 (substance)"
          },
          {
            "code" : "87445005",
            "display" : "Ipodate (substance)"
          },
          {
            "code" : "87463005",
            "display" : "Cerebral fornix structure (body structure)"
          },
          {
            "code" : "87476004",
            "display" : "Convulsions in the newborn (disorder)"
          },
          {
            "code" : "87483006",
            "display" : "Structure of tunica intima of blood vessel (body structure)"
          },
          {
            "code" : "87486003",
            "display" : "Aphasia (finding)"
          },
          {
            "code" : "87500009",
            "display" : "Hilar lymphadenopathy (disorder)"
          },
          {
            "code" : "87502001",
            "display" : "At risk for imbalanced body temperature (finding)"
          },
          {
            "code" : "87507007",
            "display" : "Sexual frustration (finding)"
          },
          {
            "code" : "87513003",
            "display" : "Herpes zoster ophthalmicus (disorder)"
          },
          {
            "code" : "87522002",
            "display" : "Iron deficiency anemia (disorder)"
          },
          {
            "code" : "87527008",
            "display" : "Term pregnancy (finding)"
          },
          {
            "code" : "87557004",
            "display" : "Urge incontinence of urine (finding)"
          },
          {
            "code" : "87563008",
            "display" : "Structure of diencephalon (body structure)"
          },
          {
            "code" : "87612001",
            "display" : "Blood (substance)"
          },
          {
            "code" : "87613006",
            "display" : "Purine diet (finding)"
          },
          {
            "code" : "87614000",
            "display" : "Pinguecula (disorder)"
          },
          {
            "code" : "87628006",
            "display" : "Bacterial infectious disease (disorder)"
          },
          {
            "code" : "87644002",
            "display" : "Epididymis structure (body structure)"
          },
          {
            "code" : "87648004",
            "display" : "Chronic rheumatic heart disease (disorder)"
          },
          {
            "code" : "87665008",
            "display" : "Chronic tubotympanic suppurative otitis media (disorder)"
          },
          {
            "code" : "87687004",
            "display" : "Extra-articular (qualifier value)"
          },
          {
            "code" : "87688009",
            "display" : "Cholesteatoma of middle ear (disorder)"
          },
          {
            "code" : "87696004",
            "display" : "Hemorrhagic cystitis (disorder)"
          },
          {
            "code" : "87704003",
            "display" : "Structure of permanent maxillary left third molar tooth (body structure)"
          },
          {
            "code" : "87708000",
            "display" : "Vitamin (substance)"
          },
          {
            "code" : "87715008",
            "display" : "Xerostomia (disorder)"
          },
          {
            "code" : "87731000",
            "display" : "Weight bearing function of bone (observable entity)"
          },
          {
            "code" : "87737001",
            "display" : "Signet ring cell carcinoma (morphologic abnormality)"
          },
          {
            "code" : "87739003",
            "display" : "Tolerant non-smoker (finding)"
          },
          {
            "code" : "87759004",
            "display" : "Female internal genitalia structure (body structure)"
          },
          {
            "code" : "87763006",
            "display" : "Lower gastrointestinal hemorrhage (disorder)"
          },
          {
            "code" : "87778004",
            "display" : "Sprain of hand (disorder)"
          },
          {
            "code" : "87784001",
            "display" : "Soft tissues (body structure)"
          },
          {
            "code" : "87795007",
            "display" : "Complete transurethral resection of prostate, including control of postoperative bleeding (procedure)"
          },
          {
            "code" : "87798009",
            "display" : "Panic disorder with agoraphobia, agoraphobic avoidance in full remission AND moderate panic attacks (disorder)"
          },
          {
            "code" : "87825006",
            "display" : "Initial implantation of electrode into cardiac atrium and ventricle (procedure)"
          },
          {
            "code" : "87837008",
            "display" : "Chronic pulmonary heart disease (disorder)"
          },
          {
            "code" : "87853006",
            "display" : "Technetium (99m-Tc) iron ascorbate (substance)"
          },
          {
            "code" : "87860000",
            "display" : "Mass of testicle (finding)"
          },
          {
            "code" : "87872006",
            "display" : "Male pattern alopecia (disorder)"
          },
          {
            "code" : "87875008",
            "display" : "Enterococcus avium (organism)"
          },
          {
            "code" : "87878005",
            "display" : "Left cardiac ventricular structure (body structure)"
          },
          {
            "code" : "87913009",
            "display" : "Malignant phyllodes tumor (morphologic abnormality)"
          },
          {
            "code" : "87919008",
            "display" : "Trivittatus virus (organism)"
          },
          {
            "code" : "87953007",
            "display" : "Ureteric structure (body structure)"
          },
          {
            "code" : "87958003",
            "display" : "Ferrous (59-Fe) citrate (substance)"
          },
          {
            "code" : "87962009",
            "display" : "North County cheviot sheep (organism)"
          },
          {
            "code" : "87979003",
            "display" : "Cleft palate (disorder)"
          },
          {
            "code" : "87982008",
            "display" : "Manual (qualifier value)"
          },
          {
            "code" : "87991007",
            "display" : "Gender identity disorder (disorder)"
          },
          {
            "code" : "88014003",
            "display" : "Beryllium (substance)"
          },
          {
            "code" : "88032003",
            "display" : "Amaurosis fugax (disorder)"
          },
          {
            "code" : "88039007",
            "display" : "Transplant of lung (procedure)"
          },
          {
            "code" : "88050005",
            "display" : "Hematoma of pinna (disorder)"
          },
          {
            "code" : "88051009",
            "display" : "Contact with plant spines (event)"
          },
          {
            "code" : "88088007",
            "display" : "Radical excision with lymph node dissection (procedure)"
          },
          {
            "code" : "88089004",
            "display" : "Skin structure of lip (body structure)"
          },
          {
            "code" : "88092000",
            "display" : "Muscle atrophy (disorder)"
          },
          {
            "code" : "88099009",
            "display" : "Child security measures education (procedure)"
          },
          {
            "code" : "88111009",
            "display" : "Altered bowel function (finding)"
          },
          {
            "code" : "88151007",
            "display" : "Keratoconjunctivitis (disorder)"
          },
          {
            "code" : "88157006",
            "display" : "Salpingitis (disorder)"
          },
          {
            "code" : "88166005",
            "display" : "Copper (64-Cu) versenate (substance)"
          },
          {
            "code" : "88176008",
            "display" : "Lower dental arch structure (body structure)"
          },
          {
            "code" : "88189002",
            "display" : "Anesthesiologist (occupation)"
          },
          {
            "code" : "88202002",
            "display" : "Alteration in nutrition: less than body requirements (finding)"
          },
          {
            "code" : "88210001",
            "display" : "Structure of sinoatrial node (body structure)"
          },
          {
            "code" : "88213004",
            "display" : "Aldosteronism (disorder)"
          },
          {
            "code" : "88223008",
            "display" : "Secondary pulmonary hypertension (disorder)"
          },
          {
            "code" : "88227009",
            "display" : "Rotavirus group D (organism)"
          },
          {
            "code" : "88230002",
            "display" : "Disorder of skeletal system (disorder)"
          },
          {
            "code" : "88241000",
            "display" : "Pronation, function (observable entity)"
          },
          {
            "code" : "88264003",
            "display" : "Infection caused by larvae of Trichinella spiralis (disorder)"
          },
          {
            "code" : "88273006",
            "display" : "Iatrogenic hypothyroidism (disorder)"
          },
          {
            "code" : "88274000",
            "display" : "Trypanosoma cruzi (organism)"
          },
          {
            "code" : "88290000",
            "display" : "Focal chorioretinitis caused by acquired toxoplasmosis (disorder)"
          },
          {
            "code" : "88312006",
            "display" : "Amputation of leg through tibia and fibula (procedure)"
          },
          {
            "code" : "88317000",
            "display" : "Anal erotism (finding)"
          },
          {
            "code" : "88340001",
            "display" : "Structure of longissimus muscle (body structure)"
          },
          {
            "code" : "88348008",
            "display" : "Maxillary sinusitis (disorder)"
          },
          {
            "code" : "88376000",
            "display" : "Carcinogen (substance)"
          },
          {
            "code" : "88415009",
            "display" : "Mycobacteriosis (disorder)"
          },
          {
            "code" : "88425004",
            "display" : "Congenital anomaly of nervous system (disorder)"
          },
          {
            "code" : "88442005",
            "display" : "Corpus callosum structure (body structure)"
          },
          {
            "code" : "88446008",
            "display" : "Laminar (qualifier value)"
          },
          {
            "code" : "88451002",
            "display" : "Unresolved independence-dependence conflict (finding)"
          },
          {
            "code" : "88454005",
            "display" : "Structure of transverse thoracis muscle (body structure)"
          },
          {
            "code" : "88473009",
            "display" : "Selenomethionine (75-Se) (substance)"
          },
          {
            "code" : "88480006",
            "display" : "Potassium (substance)"
          },
          {
            "code" : "88488004",
            "display" : "Lead (substance)"
          },
          {
            "code" : "88518009",
            "display" : "Wilson's disease (disorder)"
          },
          {
            "code" : "88520007",
            "display" : "Creutzfeldt-Jakob agent (organism)"
          },
          {
            "code" : "88531004",
            "display" : "Hypertrophy of kidney (disorder)"
          },
          {
            "code" : "88556005",
            "display" : "Structure of cerebral artery (body structure)"
          },
          {
            "code" : "88562000",
            "display" : "Acquired deformity of ankle AND/OR foot (disorder)"
          },
          {
            "code" : "88580009",
            "display" : "Anal polyp (disorder)"
          },
          {
            "code" : "88587007",
            "display" : "Premature aging (finding)"
          },
          {
            "code" : "88593004",
            "display" : "Structure of aortic isthmus (body structure)"
          },
          {
            "code" : "88594005",
            "display" : "Herpes simplex (disorder)"
          },
          {
            "code" : "88598008",
            "display" : "Impaired social interaction (finding)"
          },
          {
            "code" : "88610006",
            "display" : "Heart murmur (finding)"
          },
          {
            "code" : "88619007",
            "display" : "Vascular resistance, function (observable entity)"
          },
          {
            "code" : "88625006",
            "display" : "Water soluble aniline blue stain (substance)"
          },
          {
            "code" : "88659005",
            "display" : "Cheilognathoprosoposchisis (disorder)"
          },
          {
            "code" : "88660000",
            "display" : "Fast sulfon black F stain (substance)"
          },
          {
            "code" : "88722002",
            "display" : "Initial implantation of electrode into cardiac atrium (procedure)"
          },
          {
            "code" : "88779009",
            "display" : "American foxhound (organism)"
          },
          {
            "code" : "88790004",
            "display" : "Abyssinians (Amharas) (ethnic group)"
          },
          {
            "code" : "88797001",
            "display" : "Complication of surgical procedure (disorder)"
          },
          {
            "code" : "88805009",
            "display" : "Chronic congestive heart failure (disorder)"
          },
          {
            "code" : "88807001",
            "display" : "Red Poll cattle breed (organism)"
          },
          {
            "code" : "88813005",
            "display" : "Chronic gonococcal cystitis (disorder)"
          },
          {
            "code" : "88817006",
            "display" : "Exposure to inanimate mechanical force (event)"
          },
          {
            "code" : "88824007",
            "display" : "Structure of deciduous maxillary right central incisor tooth (body structure)"
          },
          {
            "code" : "88839008",
            "display" : "Sudanese (ethnic group)"
          },
          {
            "code" : "88847008",
            "display" : "General liquid diet (finding)"
          },
          {
            "code" : "88850006",
            "display" : "Chronic pansinusitis (disorder)"
          },
          {
            "code" : "88882009",
            "display" : "Vagus nerve structure (body structure)"
          },
          {
            "code" : "88921000",
            "display" : "Fibril (substance)"
          },
          {
            "code" : "88934004",
            "display" : "Nigerians (ethnic group)"
          },
          {
            "code" : "88943008",
            "display" : "Syphilis of muscle (disorder)"
          },
          {
            "code" : "88968005",
            "display" : "Duodenal ulcer with perforation (disorder)"
          },
          {
            "code" : "88981003",
            "display" : "Pyometra (disorder)"
          },
          {
            "code" : "88986008",
            "display" : "Vertex structure (body structure)"
          },
          {
            "code" : "89026003",
            "display" : "Alacaluf (ethnic group)"
          },
          {
            "code" : "89028002",
            "display" : "Curcumin stain (substance)"
          },
          {
            "code" : "89053004",
            "display" : "Vaginal cesarean section (procedure)"
          },
          {
            "code" : "89065000",
            "display" : "Burmese cat (organism)"
          },
          {
            "code" : "89069006",
            "display" : "Vulvoclitoral habituation (finding)"
          },
          {
            "code" : "89084002",
            "display" : "Neurofibroma, no International Classification of Diseases for Oncology subtype (morphologic abnormality)"
          },
          {
            "code" : "89091004",
            "display" : "Edema of eyelid (disorder)"
          },
          {
            "code" : "89093001",
            "display" : "Structure of right sinus of Valsalva (body structure)"
          },
          {
            "code" : "89102002",
            "display" : "Secondary frigidity (finding)"
          },
          {
            "code" : "89105000",
            "display" : "Asteatosis cutis (disorder)"
          },
          {
            "code" : "89138009",
            "display" : "Cardiogenic shock (disorder)"
          },
          {
            "code" : "89139001",
            "display" : "Light green SF stain (substance)"
          },
          {
            "code" : "89148006",
            "display" : "Fast garnet GBC salt stain (substance)"
          },
          {
            "code" : "89155008",
            "display" : "Systemic sclerosis (disorder)"
          },
          {
            "code" : "89164003",
            "display" : "Breast lump (finding)"
          },
          {
            "code" : "89177007",
            "display" : "Proton (substance)"
          },
          {
            "code" : "89187006",
            "display" : "Airway structure (body structure)"
          },
          {
            "code" : "89202009",
            "display" : "Structure of superior longitudinal fasciculus (body structure)"
          },
          {
            "code" : "89211009",
            "display" : "Hard diet (finding)"
          },
          {
            "code" : "89217008",
            "display" : "Female homosexual (finding)"
          },
          {
            "code" : "89225005",
            "display" : "Anxiety about blushing (finding)"
          },
          {
            "code" : "89242004",
            "display" : "Malignant secondary hypertension (disorder)"
          },
          {
            "code" : "89248000",
            "display" : "Erotic zoophilia (disorder)"
          },
          {
            "code" : "89272005",
            "display" : "Cobalt-58 (substance)"
          },
          {
            "code" : "89278009",
            "display" : "Structure of putamen (body structure)"
          },
          {
            "code" : "89292003",
            "display" : "Rare (qualifier value)"
          },
          {
            "code" : "89293008",
            "display" : "Human immunodeficiency virus type I (organism)"
          },
          {
            "code" : "89323001",
            "display" : "Angina, class IV (disorder)"
          },
          {
            "code" : "89331006",
            "display" : "Rotavirus group B (organism)"
          },
          {
            "code" : "89340005",
            "display" : "Structure of lamina of vertebra (body structure)"
          },
          {
            "code" : "89346004",
            "display" : "Delivery by Kielland rotation (procedure)"
          },
          {
            "code" : "89355001",
            "display" : "Discectomy for intervertebral herniated disc, nucleus pulposus (procedure)"
          },
          {
            "code" : "89357009",
            "display" : "Venal concubinage (finding)"
          },
          {
            "code" : "89362005",
            "display" : "Weight loss (finding)"
          },
          {
            "code" : "89369001",
            "display" : "Anencephalus (disorder)"
          },
          {
            "code" : "89392001",
            "display" : "Prader-Willi syndrome (disorder)"
          },
          {
            "code" : "89405008",
            "display" : "Vesicovaginal fistula (disorder)"
          },
          {
            "code" : "89432003",
            "display" : "Lemesurier operation, cleft lip repair (procedure)"
          },
          {
            "code" : "89450005",
            "display" : "Eskimo dog (organism)"
          },
          {
            "code" : "89452002",
            "display" : "Hyperplastic polyp of intestine (disorder)"
          },
          {
            "code" : "89457008",
            "display" : "Radioactive isotope (substance)"
          },
          {
            "code" : "89458003",
            "display" : "Stupor (finding)"
          },
          {
            "code" : "89461002",
            "display" : "Primary cardiomyopathy (disorder)"
          },
          {
            "code" : "89469000",
            "display" : "Chronic duodenal ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "89538001",
            "display" : "Helicobacter-associated gastritis (disorder)"
          },
          {
            "code" : "89540006",
            "display" : "Segmental excision and ligation (procedure)"
          },
          {
            "code" : "89545001",
            "display" : "Face structure (body structure)"
          },
          {
            "code" : "89546000",
            "display" : "Bone structure of cranium (body structure)"
          },
          {
            "code" : "89550007",
            "display" : "Right sacrolateral position (finding)"
          },
          {
            "code" : "89552004",
            "display" : "Structure of deciduous mandibular left central incisor tooth (body structure)"
          },
          {
            "code" : "89571002",
            "display" : "Premature infant diet: vitamin E at 10 days and iron at 3 weeks (finding)"
          },
          {
            "code" : "89577003",
            "display" : "Pontamine sky blue 5BX stain (substance)"
          },
          {
            "code" : "89580002",
            "display" : "Cryptogenic cirrhosis (disorder)"
          },
          {
            "code" : "89595000",
            "display" : "Iodized oil (substance)"
          },
          {
            "code" : "89605004",
            "display" : "Legionella longbeachae (organism)"
          },
          {
            "code" : "89625000",
            "display" : "Structure of mandibular left first molar tooth (body structure)"
          },
          {
            "code" : "89627008",
            "display" : "Hyponatremia (disorder)"
          },
          {
            "code" : "89634005",
            "display" : "Microbial identification kit, rapid strep method (procedure)"
          },
          {
            "code" : "89644007",
            "display" : "Left ear structure (body structure)"
          },
          {
            "code" : "89648005",
            "display" : "Fjord horse (organism)"
          },
          {
            "code" : "89656008",
            "display" : "Urethral meatitis (disorder)"
          },
          {
            "code" : "89665001",
            "display" : "Targhee sheep (organism)"
          },
          {
            "code" : "89666000",
            "display" : "Cardiopulmonary resuscitation (procedure)"
          },
          {
            "code" : "89675003",
            "display" : "Sleep terror disorder (disorder)"
          },
          {
            "code" : "89689008",
            "display" : "Congenital genu valgum (disorder)"
          },
          {
            "code" : "89700002",
            "display" : "Shoulder girdle dystocia (disorder)"
          },
          {
            "code" : "89708009",
            "display" : "Chamoisee goat (organism)"
          },
          {
            "code" : "89709001",
            "display" : "Legionella jamestowniensis (organism)"
          },
          {
            "code" : "89736004",
            "display" : "Valvular endocarditis (disorder)"
          },
          {
            "code" : "89740008",
            "display" : "Lobular carcinoma (morphologic abnormality)"
          },
          {
            "code" : "89748001",
            "display" : "Acute gastric ulcer with hemorrhage (disorder)"
          },
          {
            "code" : "89765005",
            "display" : "Tobacco dependence syndrome (disorder)"
          },
          {
            "code" : "89784008",
            "display" : "Skin structure of hypothenar region of palm (body structure)"
          },
          {
            "code" : "89792004",
            "display" : "Right ventricular hypertrophy (disorder)"
          },
          {
            "code" : "89811004",
            "display" : "Gluten (substance)"
          },
          {
            "code" : "89814007",
            "display" : "Repair of ventricular septal defect with prosthesis (procedure)"
          },
          {
            "code" : "89818005",
            "display" : "Technetium (99-Tc) labeled red blood cells (substance)"
          },
          {
            "code" : "89820008",
            "display" : "Closed intertrochanteric fracture (disorder)"
          },
          {
            "code" : "89825003",
            "display" : "Closed fracture of thoracic vertebra without spinal cord injury (disorder)"
          },
          {
            "code" : "89837001",
            "display" : "Urinary bladder structure (body structure)"
          },
          {
            "code" : "89849000",
            "display" : "High forceps delivery (procedure)"
          },
          {
            "code" : "89856006",
            "display" : "Ponceau S stain (substance)"
          },
          {
            "code" : "89858007",
            "display" : "Tracheobronchial lymph node, located near carina (body structure)"
          },
          {
            "code" : "89889006",
            "display" : "Cotton fiber (substance)"
          },
          {
            "code" : "89890002",
            "display" : "Structure of lymphatic system (body structure)"
          },
          {
            "code" : "89896008",
            "display" : "Mycobacterium chitae (organism)"
          },
          {
            "code" : "89928000",
            "display" : "FHC pig (organism)"
          },
          {
            "code" : "89948007",
            "display" : "Panic disorder with agoraphobia AND mild panic attacks (disorder)"
          },
          {
            "code" : "89966002",
            "display" : "Hematoma of scrotum (disorder)"
          },
          {
            "code" : "90006008",
            "display" : "High fat meat exchange list (finding)"
          },
          {
            "code" : "90024005",
            "display" : "Structure of internal iliac artery (body structure)"
          },
          {
            "code" : "90027003",
            "display" : "Arabs (ethnic group)"
          },
          {
            "code" : "90036004",
            "display" : "Vitelliform dystrophy (disorder)"
          },
          {
            "code" : "90050009",
            "display" : "American Buckskin horse (organism)"
          },
          {
            "code" : "90069004",
            "display" : "Posterolateral (qualifier value)"
          },
          {
            "code" : "90070003",
            "display" : "Pneumothorax due to trauma (disorder)"
          },
          {
            "code" : "90096001",
            "display" : "Stroke volume (observable entity)"
          },
          {
            "code" : "90101001",
            "display" : "Foxhound (organism)"
          },
          {
            "code" : "90116003",
            "display" : "Contracture of joint of shoulder region (disorder)"
          },
          {
            "code" : "90128006",
            "display" : "Photosensitivity (finding)"
          },
          {
            "code" : "90134004",
            "display" : "Metal periosteal implant, device (physical object)"
          },
          {
            "code" : "90176007",
            "display" : "Tonsillitis (disorder)"
          },
          {
            "code" : "90199006",
            "display" : "Transurethral prostatectomy (procedure)"
          },
          {
            "code" : "90207007",
            "display" : "Grinding teeth (finding)"
          },
          {
            "code" : "90219004",
            "display" : "Coronary sinus structure (body structure)"
          },
          {
            "code" : "90235006",
            "display" : "Closed fracture of shaft of humerus (disorder)"
          },
          {
            "code" : "90241004",
            "display" : "Papillary necrosis (disorder)"
          },
          {
            "code" : "90244007",
            "display" : "Contusion of heel (disorder)"
          },
          {
            "code" : "90272000",
            "display" : "Enterococcus faecium (organism)"
          },
          {
            "code" : "90278001",
            "display" : "Secluding patient (procedure)"
          },
          {
            "code" : "90290004",
            "display" : "Umbilical region structure (body structure)"
          },
          {
            "code" : "90306000",
            "display" : "Trial labor (finding)"
          },
          {
            "code" : "90315007",
            "display" : "Pulmonary valve sinuses (body structure)"
          },
          {
            "code" : "90318009",
            "display" : "Structure of anulus fibrosus of pulmonary artery (body structure)"
          },
          {
            "code" : "90325002",
            "display" : "Vomiting of pregnancy (disorder)"
          },
          {
            "code" : "90348007",
            "display" : "Ghashgai (ethnic group)"
          },
          {
            "code" : "90352007",
            "display" : "Sexual molestation (finding)"
          },
          {
            "code" : "90381008",
            "display" : "Occipitoanterior position (finding)"
          },
          {
            "code" : "90392009",
            "display" : "Nocturnal muscle spasm (finding)"
          },
          {
            "code" : "90418005",
            "display" : "Male external genitalia structure (body structure)"
          },
          {
            "code" : "90438006",
            "display" : "Delivery by Malstrom's extraction (procedure)"
          },
          {
            "code" : "90442009",
            "display" : "Cerclage of cervix during pregnancy by vaginal approach (procedure)"
          },
          {
            "code" : "90444005",
            "display" : "Smooth haired vizsla (organism)"
          },
          {
            "code" : "90446007",
            "display" : "Pruritus ani (disorder)"
          },
          {
            "code" : "90458007",
            "display" : "Internal hemorrhoids (disorder)"
          },
          {
            "code" : "90460009",
            "display" : "Injury of neck (disorder)"
          },
          {
            "code" : "90470006",
            "display" : "Prostatectomy (procedure)"
          },
          {
            "code" : "90480005",
            "display" : "Interrupted breathing (finding)"
          },
          {
            "code" : "90485000",
            "display" : "Sucking (observable entity)"
          },
          {
            "code" : "90493000",
            "display" : "Arteriolar nephrosclerosis (disorder)"
          },
          {
            "code" : "90505000",
            "display" : "Autosomal recessive hypophosphatemic vitamin D refractory rickets (disorder)"
          },
          {
            "code" : "90507008",
            "display" : "Disorder of vein (disorder)"
          },
          {
            "code" : "90520006",
            "display" : "Vertebral artery stenosis (disorder)"
          },
          {
            "code" : "90530002",
            "display" : "Yersinia pseudotuberculosis (organism)"
          },
          {
            "code" : "90539001",
            "display" : "Ventricular aneurysm (disorder)"
          },
          {
            "code" : "90560007",
            "display" : "Inflammatory disorder due to increased blood urate level (disorder)"
          },
          {
            "code" : "90561006",
            "display" : "Right atrioventricular ostium structure (body structure)"
          },
          {
            "code" : "90562004",
            "display" : "Fetal distress, in liveborn infant (finding)"
          },
          {
            "code" : "90572001",
            "display" : "Structure of lower lobe of lung (body structure)"
          },
          {
            "code" : "90584004",
            "display" : "Spinal cord injury (disorder)"
          },
          {
            "code" : "90588001",
            "display" : "Subscapularis muscle structure (body structure)"
          },
          {
            "code" : "90591001",
            "display" : "Sexual act of other site (finding)"
          },
          {
            "code" : "90606007",
            "display" : "Structure of superficial lymph node (body structure)"
          },
          {
            "code" : "90612002",
            "display" : "Salers cattle breed (organism)"
          },
          {
            "code" : "90617008",
            "display" : "Indium (113-In) bleomycin (substance)"
          },
          {
            "code" : "90619006",
            "display" : "Fall in bathtub (event)"
          },
          {
            "code" : "90631008",
            "display" : "Sprain of sacrococcygeal ligament (disorder)"
          },
          {
            "code" : "90639005",
            "display" : "Fall from window (event)"
          },
          {
            "code" : "90660004",
            "display" : "Application of dressing for burn (procedure)"
          },
          {
            "code" : "90673000",
            "display" : "Burning sensation (finding)"
          },
          {
            "code" : "90678009",
            "display" : "Disorder of lip (disorder)"
          },
          {
            "code" : "90688005",
            "display" : "Chronic renal failure syndrome (disorder)"
          },
          {
            "code" : "90700008",
            "display" : "Pathologic promiscuity (finding)"
          },
          {
            "code" : "90708001",
            "display" : "Kidney disease (disorder)"
          },
          {
            "code" : "90731001",
            "display" : "Posterior asynclitism (finding)"
          },
          {
            "code" : "90733003",
            "display" : "Metrizamide (substance)"
          },
          {
            "code" : "90734009",
            "display" : "Chronic (qualifier value)"
          },
          {
            "code" : "90739004",
            "display" : "Thyrotoxicosis (disorder)"
          },
          {
            "code" : "90745007",
            "display" : "Bunamiodyl (substance)"
          },
          {
            "code" : "90771006",
            "display" : "Structure of superior mesenteric vein (body structure)"
          },
          {
            "code" : "90774003",
            "display" : "Victim of physical assault (finding)"
          },
          {
            "code" : "90790003",
            "display" : "Avoidant disorder of adolescence (disorder)"
          },
          {
            "code" : "90822005",
            "display" : "Gambians (ethnic group)"
          },
          {
            "code" : "90823000",
            "display" : "Infantile eczema (disorder)"
          },
          {
            "code" : "90828009",
            "display" : "Primary restrictive cardiomyopathy (disorder)"
          },
          {
            "code" : "90834002",
            "display" : "Pain in limb (finding)"
          },
          {
            "code" : "90864005",
            "display" : "Special autopsy procedure, explain by report (procedure)"
          },
          {
            "code" : "90885005",
            "display" : "Gloucester old spot pig (organism)"
          },
          {
            "code" : "90892000",
            "display" : "Diastole, function (observable entity)"
          },
          {
            "code" : "90927000",
            "display" : "Refractive amblyopia (disorder)"
          },
          {
            "code" : "90933009",
            "display" : "Structure of distal surface of tooth (body structure)"
          },
          {
            "code" : "90935002",
            "display" : "Hemophilia (disorder)"
          },
          {
            "code" : "90958004",
            "display" : "Thrombosis of arteries of lower extremity (disorder)"
          },
          {
            "code" : "90968009",
            "display" : "Prolonged pregnancy (disorder)"
          },
          {
            "code" : "90979004",
            "display" : "Chronic tonsillitis (disorder)"
          },
          {
            "code" : "90987003",
            "display" : "Reflex incontinence of urine (finding)"
          },
          {
            "code" : "91019004",
            "display" : "Paresthesia (finding)"
          },
          {
            "code" : "91022002",
            "display" : "Even vocal attack, function (observable entity)"
          },
          {
            "code" : "91037003",
            "display" : "Closed fracture of pelvis (disorder)"
          },
          {
            "code" : "91038008",
            "display" : "Acute frontal sinusitis (disorder)"
          },
          {
            "code" : "91066000",
            "display" : "Tatars (ethnic group)"
          },
          {
            "code" : "91079009",
            "display" : "Structure of uterine artery (body structure)"
          },
          {
            "code" : "91083009",
            "display" : "Structure of proximal portion of right coronary artery (body structure)"
          },
          {
            "code" : "91085002",
            "display" : "Structure of left posterior division of left branch of atrioventricular bundle (body structure)"
          },
          {
            "code" : "91086001",
            "display" : "Pharyngeal fricative, function (observable entity)"
          },
          {
            "code" : "91096005",
            "display" : "Monitoring of electrocardiogram at surgery (procedure)"
          },
          {
            "code" : "91109007",
            "display" : "Gastric varices (disorder)"
          },
          {
            "code" : "91134007",
            "display" : "Mitral valve structure (body structure)"
          },
          {
            "code" : "91154008",
            "display" : "Free-standing birthing center (environment)"
          },
          {
            "code" : "91175000",
            "display" : "Seizure (finding)"
          },
          {
            "code" : "91191002",
            "display" : "Oraons (ethnic group)"
          },
          {
            "code" : "91209001",
            "display" : "Modified basic hospital diet (finding)"
          },
          {
            "code" : "91221002",
            "display" : "Furuncle of abdominal wall (disorder)"
          },
          {
            "code" : "91238003",
            "display" : "Bone structure of distal ulna (body structure)"
          },
          {
            "code" : "91251008",
            "display" : "Physical therapy procedure (regime/therapy)"
          },
          {
            "code" : "91273001",
            "display" : "Lactic acidosis (disorder)"
          },
          {
            "code" : "91288006",
            "display" : "Acinetobacter baumannii (organism)"
          },
          {
            "code" : "91295002",
            "display" : "Fast blue BB salt stain (substance)"
          },
          {
            "code" : "91302008",
            "display" : "Sepsis (disorder)"
          },
          {
            "code" : "91327001",
            "display" : "Quadriparesis (disorder)"
          },
          {
            "code" : "91335003",
            "display" : "Mural thrombus of heart (disorder)"
          },
          {
            "code" : "91336002",
            "display" : "Mycobacterium porcinum (organism)"
          },
          {
            "code" : "91352004",
            "display" : "Diabetes mellitus due to structurally abnormal insulin (disorder)"
          },
          {
            "code" : "91357005",
            "display" : "Acute endocarditis (disorder)"
          },
          {
            "code" : "91394001",
            "display" : "Structure of retroperitoneal lymph node (body structure)"
          },
          {
            "code" : "91397008",
            "display" : "Bone structure of face (body structure)"
          },
          {
            "code" : "91408006",
            "display" : "Impairment level: blindness, one eye - low vision other eye (disorder)"
          },
          {
            "code" : "91419009",
            "display" : "Closed fracture of forearm (disorder)"
          },
          {
            "code" : "91429002",
            "display" : "Schnauzer superbreed (organism)"
          },
          {
            "code" : "91434003",
            "display" : "Pulmonic valve regurgitation (disorder)"
          },
          {
            "code" : "91470000",
            "display" : "Axillary region structure (body structure)"
          },
          {
            "code" : "91478007",
            "display" : "Secondary hyperparathyroidism (disorder)"
          },
          {
            "code" : "91487003",
            "display" : "Diaper rash (disorder)"
          },
          {
            "code" : "91488008",
            "display" : "New Britons (ethnic group)"
          },
          {
            "code" : "91508008",
            "display" : "Francisella tularensis subspecies tularensis (organism)"
          },
          {
            "code" : "91514001",
            "display" : "Corneal ulcer (disorder)"
          },
          {
            "code" : "91519006",
            "display" : "Neonatal death of male (within 4 weeks, United States of America) (event)"
          },
          {
            "code" : "91524009",
            "display" : "Campylobacter sputorum (organism)"
          },
          {
            "code" : "91525005",
            "display" : "Sexual incompatibility (finding)"
          },
          {
            "code" : "91539005",
            "display" : "Structure of right pulmonary vein (body structure)"
          },
          {
            "code" : "91553005",
            "display" : "Canadian eskimo dog (organism)"
          },
          {
            "code" : "91554004",
            "display" : "Condyloma latum (disorder)"
          },
          {
            "code" : "91555003",
            "display" : "Infant formula (finding)"
          },
          {
            "code" : "91573000",
            "display" : "Tympanometry testing (procedure)"
          },
          {
            "code" : "91584007",
            "display" : "Lactose controlled diet (finding)"
          },
          {
            "code" : "91598004",
            "display" : "Benzoyl peroxide (substance)"
          },
          {
            "code" : "91602002",
            "display" : "Thoracentesis (procedure)"
          },
          {
            "code" : "91603007",
            "display" : "Contusion of lower limb (disorder)"
          },
          {
            "code" : "91606004",
            "display" : "Cochineal stain (substance)"
          },
          {
            "code" : "91609006",
            "display" : "Bone structure of mandible (body structure)"
          },
          {
            "code" : "91613004",
            "display" : "Contusion of elbow (disorder)"
          },
          {
            "code" : "91633000",
            "display" : "Iron free infant formula (finding)"
          },
          {
            "code" : "91637004",
            "display" : "Myasthenia gravis (disorder)"
          },
          {
            "code" : "91669008",
            "display" : "Perirectal abscess (disorder)"
          },
          {
            "code" : "91691001",
            "display" : "Structure of parasternal region (body structure)"
          },
          {
            "code" : "91707000",
            "display" : "Structure of primitive pulmonary artery (body structure)"
          },
          {
            "code" : "91716001",
            "display" : "Mastoid cells and antra structure (body structure)"
          },
          {
            "code" : "91720002",
            "display" : "Body substance (substance)"
          },
          {
            "code" : "91723000",
            "display" : "Anatomical structure (body structure)"
          },
          {
            "code" : "91732003",
            "display" : "Structure of dorsal scapular artery (body structure)"
          },
          {
            "code" : "91747007",
            "display" : "Lumen of blood vessel (body structure)"
          },
          {
            "code" : "91748002",
            "display" : "Structure of mid portion of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "91750005",
            "display" : "Structure of first diagonal branch of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "91751009",
            "display" : "Structure of second diagonal branch of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "91752002",
            "display" : "Structure of third diagonal branch of anterior descending branch of left coronary artery (body structure)"
          },
          {
            "code" : "91753007",
            "display" : "Structure of mid portion of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91754001",
            "display" : "Structure of first obtuse marginal branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91755000",
            "display" : "Structure of second obtuse marginal branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91756004",
            "display" : "Structure of third obtuse marginal branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91757008",
            "display" : "Structure of first left posterolateral branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91758003",
            "display" : "Structure of second left posterolateral branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91759006",
            "display" : "Structure of third left posterolateral branch of circumflex branch of left coronary artery (body structure)"
          },
          {
            "code" : "91760001",
            "display" : "Structure of left posterior descending circumflex coronary artery (body structure)"
          },
          {
            "code" : "91761002",
            "display" : "Structure of first right posterolateral branch of the posterior descending branch of right coronary artery (body structure)"
          },
          {
            "code" : "91762009",
            "display" : "Structure of second right posterolateral branch of the posterior descending branch of right coronary artery (body structure)"
          },
          {
            "code" : "91763004",
            "display" : "Structure of third right posterolateral branch of the posterior descending branch of right coronary artery (body structure)"
          },
          {
            "code" : "91772007",
            "display" : "Organ parenchyma (body structure)"
          },
          {
            "code" : "91830000",
            "display" : "Structure of body conduit (body structure)"
          },
          {
            "code" : "91837002",
            "display" : "Anatomical orifice (body structure)"
          },
          {
            "code" : "91855006",
            "display" : "Acute leukemia, disease (disorder)"
          },
          {
            "code" : "91856007",
            "display" : "Acute lymphoid leukemia in remission (disorder)"
          },
          {
            "code" : "91857003",
            "display" : "Acute lymphoid leukemia, disease (disorder)"
          },
          {
            "code" : "91860005",
            "display" : "Acute myeloid leukemia in remission (disorder)"
          },
          {
            "code" : "91861009",
            "display" : "Acute myeloid leukemia, disease (disorder)"
          },
          {
            "code" : "91863007",
            "display" : "Acute pericoronitis (disorder)"
          },
          {
            "code" : "91935009",
            "display" : "Allergy to peanut (finding)"
          },
          {
            "code" : "91936005",
            "display" : "Allergy to penicillin (finding)"
          },
          {
            "code" : "91943004",
            "display" : "Arthralgia of temporomandibular joint (disorder)"
          },
          {
            "code" : "91945006",
            "display" : "Articular disc disorder of temporomandibular joint (disorder)"
          },
          {
            "code" : "91947003",
            "display" : "Asymptomatic human immunodeficiency virus infection (disorder)"
          },
          {
            "code" : "91950000",
            "display" : "Atrophy of edentulous alveolar ridge (disorder)"
          },
          {
            "code" : "91957002",
            "display" : "Back pain complicating pregnancy (disorder)"
          },
          {
            "code" : "91967007",
            "display" : "Benign neoplasm of adrenal gland (disorder)"
          },
          {
            "code" : "91992005",
            "display" : "Benign neoplasm of bladder (disorder)"
          },
          {
            "code" : "92030004",
            "display" : "Benign neoplasm of brain (disorder)"
          },
          {
            "code" : "92051001",
            "display" : "Benign neoplasm of cerebral meninges (disorder)"
          },
          {
            "code" : "92059004",
            "display" : "Benign neoplasm of choroid (disorder)"
          },
          {
            "code" : "92065004",
            "display" : "Benign neoplasm of colon (disorder)"
          },
          {
            "code" : "92071005",
            "display" : "Benign neoplasm of cranial nerve (disorder)"
          },
          {
            "code" : "92097004",
            "display" : "Benign neoplasm of eye (disorder)"
          },
          {
            "code" : "92102001",
            "display" : "Benign neoplasm of female breast (disorder)"
          },
          {
            "code" : "92103006",
            "display" : "Benign neoplasm of female genital organ (disorder)"
          },
          {
            "code" : "92166000",
            "display" : "Benign neoplasm of labia majora (disorder)"
          },
          {
            "code" : "92206006",
            "display" : "Benign neoplasm of male breast (disorder)"
          },
          {
            "code" : "92207002",
            "display" : "Benign neoplasm of male genital organ (disorder)"
          },
          {
            "code" : "92247009",
            "display" : "Benign neoplasm of nervous system (disorder)"
          },
          {
            "code" : "92248004",
            "display" : "Benign neoplasm of nipple of female breast (disorder)"
          },
          {
            "code" : "92258000",
            "display" : "Benign neoplasm of orbit (disorder)"
          },
          {
            "code" : "92260003",
            "display" : "Benign neoplasm of ovary (disorder)"
          },
          {
            "code" : "92264007",
            "display" : "Benign neoplasm of pancreas (disorder)"
          },
          {
            "code" : "92296004",
            "display" : "Benign neoplasm of pituitary gland (disorder)"
          },
          {
            "code" : "92308005",
            "display" : "Benign neoplasm of prostate (disorder)"
          },
          {
            "code" : "92354001",
            "display" : "Benign neoplasm of skin of ear (disorder)"
          },
          {
            "code" : "92359006",
            "display" : "Benign neoplasm of skin of face (disorder)"
          },
          {
            "code" : "92369000",
            "display" : "Benign neoplasm of skin of lip (disorder)"
          },
          {
            "code" : "92370004",
            "display" : "Benign neoplasm of skin of lower limb (disorder)"
          },
          {
            "code" : "92371000",
            "display" : "Benign neoplasm of skin of neck (disorder)"
          },
          {
            "code" : "92375009",
            "display" : "Benign neoplasm of skin of scalp (disorder)"
          },
          {
            "code" : "92376005",
            "display" : "Benign neoplasm of skin of shoulder (disorder)"
          },
          {
            "code" : "92380000",
            "display" : "Benign neoplasm of skin of trunk (disorder)"
          },
          {
            "code" : "92382008",
            "display" : "Benign neoplasm of skin of upper limb (disorder)"
          },
          {
            "code" : "92384009",
            "display" : "Benign neoplasm of skin (disorder)"
          },
          {
            "code" : "92394004",
            "display" : "Benign neoplasm of soft tissues of lower limb (disorder)"
          },
          {
            "code" : "92401003",
            "display" : "Benign neoplasm of soft tissues of upper limb (disorder)"
          },
          {
            "code" : "92439006",
            "display" : "Benign neoplasm of thyroid gland (disorder)"
          },
          {
            "code" : "92468007",
            "display" : "Benign neoplasm of urinary system (disorder)"
          },
          {
            "code" : "92503002",
            "display" : "Neurofibromatosis type 2 (disorder)"
          },
          {
            "code" : "92506005",
            "display" : "Biventricular congestive heart failure (disorder)"
          },
          {
            "code" : "92517006",
            "display" : "Calcific coronary arteriosclerosis (disorder)"
          },
          {
            "code" : "92546004",
            "display" : "Carcinoma in situ of bladder (disorder)"
          },
          {
            "code" : "92564006",
            "display" : "Carcinoma in situ of uterine cervix (disorder)"
          },
          {
            "code" : "92652009",
            "display" : "Carcinoma in situ of male breast (disorder)"
          },
          {
            "code" : "92653004",
            "display" : "Carcinoma in situ of male genital organ (disorder)"
          },
          {
            "code" : "92664001",
            "display" : "Carcinoma in situ of nasopharynx (disorder)"
          },
          {
            "code" : "92749008",
            "display" : "Carcinoma in situ of skin (disorder)"
          },
          {
            "code" : "92764008",
            "display" : "Carcinoma in situ of testis (disorder)"
          },
          {
            "code" : "92812005",
            "display" : "Chronic leukemia, disease (disorder)"
          },
          {
            "code" : "92813000",
            "display" : "Chronic lymphoid leukemia in remission (disorder)"
          },
          {
            "code" : "92814006",
            "display" : "Chronic lymphoid leukemia, disease (disorder)"
          },
          {
            "code" : "92818009",
            "display" : "Chronic myeloid leukemia, disease (disorder)"
          },
          {
            "code" : "92824003",
            "display" : "Neurofibromatosis type 1 (disorder)"
          },
          {
            "code" : "93143009",
            "display" : "Leukemia, disease (disorder)"
          },
          {
            "code" : "93160004",
            "display" : "Lipoma of skin and subcutaneous tissue of neck (disorder)"
          },
          {
            "code" : "93162007",
            "display" : "Lipoma of spermatic cord (disorder)"
          },
          {
            "code" : "93163002",
            "display" : "Lipoma (disorder)"
          },
          {
            "code" : "93195001",
            "display" : "Malignant lymphoma of lymph nodes of head, face AND/OR neck (disorder)"
          },
          {
            "code" : "93197009",
            "display" : "Malignant lymphoma of lymph nodes of multiple sites (disorder)"
          },
          {
            "code" : "93199007",
            "display" : "Malignant lymphoma of extranodal AND/OR solid organ site (disorder)"
          },
          {
            "code" : "93225001",
            "display" : "Malignant melanoma of skin of face (disorder)"
          },
          {
            "code" : "93423006",
            "display" : "Dermatitis of eyelid (disorder)"
          },
          {
            "code" : "93448009",
            "display" : "Superficial ulcer of skin (disorder)"
          },
          {
            "code" : "93458008",
            "display" : "Foreign body in skin (disorder)"
          },
          {
            "code" : "93459000",
            "display" : "Foreign body in subcutaneous tissue (disorder)"
          },
          {
            "code" : "93469006",
            "display" : "Hemangioma of liver (disorder)"
          },
          {
            "code" : "93471006",
            "display" : "Hemangioma of skin (disorder)"
          },
          {
            "code" : "93473009",
            "display" : "Hemangioma of subcutaneous tissue (disorder)"
          },
          {
            "code" : "93478000",
            "display" : "Intraocular hemorrhage (disorder)"
          },
          {
            "code" : "93557001",
            "display" : "Holorachischisis (disorder)"
          },
          {
            "code" : "93616000",
            "display" : "Intramural leiomyoma of uterus (disorder)"
          },
          {
            "code" : "93651008",
            "display" : "Malignant melanoma of skin of trunk (disorder)"
          },
          {
            "code" : "93655004",
            "display" : "Malignant melanoma of skin (disorder)"
          },
          {
            "code" : "93749002",
            "display" : "Primary malignant neoplasm of cerebrum (disorder)"
          },
          {
            "code" : "93797001",
            "display" : "Primary malignant neoplasm of female genital organ (disorder)"
          },
          {
            "code" : "93870000",
            "display" : "Malignant neoplasm of liver (disorder)"
          },
          {
            "code" : "93880001",
            "display" : "Primary malignant neoplasm of lung (disorder)"
          },
          {
            "code" : "93934004",
            "display" : "Primary malignant neoplasm of ovary (disorder)"
          },
          {
            "code" : "93974005",
            "display" : "Primary malignant neoplasm of prostate (disorder)"
          },
          {
            "code" : "93980002",
            "display" : "Primary malignant neoplasm of rectosigmoid junction (disorder)"
          },
          {
            "code" : "94022001",
            "display" : "Primary malignant neoplasm of skin of face (disorder)"
          },
          {
            "code" : "94038007",
            "display" : "Primary malignant neoplasm of skin of scalp (disorder)"
          },
          {
            "code" : "94057003",
            "display" : "Primary malignant neoplasm of soft tissues of lower limb (disorder)"
          },
          {
            "code" : "94098005",
            "display" : "Primary malignant neoplasm of thyroid gland (disorder)"
          },
          {
            "code" : "94147001",
            "display" : "Mass of mediastinum (finding)"
          },
          {
            "code" : "94150003",
            "display" : "Membranous ventricular septum defect (disorder)"
          },
          {
            "code" : "94161006",
            "display" : "Secondary malignant neoplasm of adrenal gland (disorder)"
          },
          {
            "code" : "94180008",
            "display" : "Secondary malignant neoplasm of axilla (disorder)"
          },
          {
            "code" : "94186002",
            "display" : "Secondary malignant neoplasm of bladder (disorder)"
          },
          {
            "code" : "94222008",
            "display" : "Secondary malignant neoplasm of bone (disorder)"
          },
          {
            "code" : "94225005",
            "display" : "Secondary malignant neoplasm of brain (disorder)"
          },
          {
            "code" : "94243009",
            "display" : "Secondary malignant neoplasm of central nervous system (disorder)"
          },
          {
            "code" : "94254004",
            "display" : "Secondary malignant neoplasm of choroid (disorder)"
          },
          {
            "code" : "94260004",
            "display" : "Secondary malignant neoplasm of colon (disorder)"
          },
          {
            "code" : "94264008",
            "display" : "Secondary malignant neoplasm of soft tissues (disorder)"
          },
          {
            "code" : "94281004",
            "display" : "Secondary malignant neoplasm of endometrium (disorder)"
          },
          {
            "code" : "94286009",
            "display" : "Secondary malignant neoplasm of esophagus (disorder)"
          },
          {
            "code" : "94297009",
            "display" : "Secondary malignant neoplasm of female breast (disorder)"
          },
          {
            "code" : "94347008",
            "display" : "Secondary malignant neoplasm of intra-abdominal lymph nodes (disorder)"
          },
          {
            "code" : "94350006",
            "display" : "Secondary malignant neoplasm of intrapelvic lymph nodes (disorder)"
          },
          {
            "code" : "94351005",
            "display" : "Secondary malignant neoplasm of intrathoracic lymph nodes (disorder)"
          },
          {
            "code" : "94360002",
            "display" : "Secondary malignant neoplasm of kidney (disorder)"
          },
          {
            "code" : "94365007",
            "display" : "Secondary malignant neoplasm of large intestine (disorder)"
          },
          {
            "code" : "94381002",
            "display" : "Secondary malignant neoplasm of liver (disorder)"
          },
          {
            "code" : "94391008",
            "display" : "Secondary malignant neoplasm of lung (disorder)"
          },
          {
            "code" : "94392001",
            "display" : "Secondary malignant neoplasm of lymph node (disorder)"
          },
          {
            "code" : "94393006",
            "display" : "Secondary malignant neoplasm of lymph nodes of face (disorder)"
          },
          {
            "code" : "94397007",
            "display" : "Secondary malignant neoplasm of lymph nodes of neck (disorder)"
          },
          {
            "code" : "94409002",
            "display" : "Secondary malignant neoplasm of mediastinum (disorder)"
          },
          {
            "code" : "94455000",
            "display" : "Secondary malignant neoplasm of ovary (disorder)"
          },
          {
            "code" : "94459006",
            "display" : "Secondary malignant neoplasm of pancreas (disorder)"
          },
          {
            "code" : "94493005",
            "display" : "Secondary malignant neoplasm of pleura (disorder)"
          },
          {
            "code" : "94503003",
            "display" : "Secondary malignant neoplasm of prostate (disorder)"
          },
          {
            "code" : "94513006",
            "display" : "Secondary malignant neoplasm of rectum (disorder)"
          },
          {
            "code" : "94579000",
            "display" : "Secondary malignant neoplasm of skin (disorder)"
          },
          {
            "code" : "94602001",
            "display" : "Secondary malignant neoplasm of vertebral column (disorder)"
          },
          {
            "code" : "94623007",
            "display" : "Secondary malignant neoplasm of testis (disorder)"
          },
          {
            "code" : "94627008",
            "display" : "Secondary malignant neoplasm of peritoneum (disorder)"
          },
          {
            "code" : "94628003",
            "display" : "Secondary malignant neoplasm of retroperitoneum (disorder)"
          },
          {
            "code" : "94704006",
            "display" : "Multiple myeloma in remission (disorder)"
          },
          {
            "code" : "94706008",
            "display" : "Muscular ventricular septum defect (disorder)"
          },
          {
            "code" : "94720001",
            "display" : "Myxoid transformation of tricuspid valve (disorder)"
          },
          {
            "code" : "94754000",
            "display" : "Neoplasm of uncertain behavior of bladder (disorder)"
          },
          {
            "code" : "94767002",
            "display" : "Neoplasm of uncertain behavior of brain (disorder)"
          },
          {
            "code" : "94805002",
            "display" : "Neoplasm of uncertain behavior of soft tissues (disorder)"
          },
          {
            "code" : "94820008",
            "display" : "Neoplasm of uncertain behavior of endocrine gland (disorder)"
          },
          {
            "code" : "94889006",
            "display" : "Neoplasm of uncertain behavior of kidney (disorder)"
          },
          {
            "code" : "94962000",
            "display" : "Neoplasm of uncertain behavior of neck (disorder)"
          },
          {
            "code" : "94963005",
            "display" : "Neoplasm of uncertain behavior of nervous system (disorder)"
          },
          {
            "code" : "94989005",
            "display" : "Neoplasm of uncertain behavior of parotid gland (disorder)"
          },
          {
            "code" : "95087004",
            "display" : "Neoplasm of uncertain behavior of skin (disorder)"
          },
          {
            "code" : "95192000",
            "display" : "Nodular lymphoma of lymph nodes of multiple sites (disorder)"
          },
          {
            "code" : "95212006",
            "display" : "Gingival disease due to pregnancy (disorder)"
          },
          {
            "code" : "95214007",
            "display" : "Primary malignant neoplasm of liver (disorder)"
          },
          {
            "code" : "95217000",
            "display" : "Pseudophakia (disorder)"
          },
          {
            "code" : "95221007",
            "display" : "Radiation retinopathy (disorder)"
          },
          {
            "code" : "95239003",
            "display" : "Rhinitis medicamentosa (disorder)"
          },
          {
            "code" : "95254009",
            "display" : "Secondary dental caries (disorder)"
          },
          {
            "code" : "95279007",
            "display" : "Submucous leiomyoma of uterus (disorder)"
          },
          {
            "code" : "95280005",
            "display" : "Subserous leiomyoma of uterus (disorder)"
          },
          {
            "code" : "95315005",
            "display" : "Uterine leiomyoma (disorder)"
          },
          {
            "code" : "95316006",
            "display" : "Victim of kidnapping (finding)"
          },
          {
            "code" : "95317002",
            "display" : "Victim of terrorism (finding)"
          },
          {
            "code" : "95318007",
            "display" : "Victim of torture (finding)"
          },
          {
            "code" : "95319004",
            "display" : "Skin nodule (finding)"
          },
          {
            "code" : "95320005",
            "display" : "Disorder of skin (disorder)"
          },
          {
            "code" : "95321009",
            "display" : "Fissure in skin (disorder)"
          },
          {
            "code" : "95324001",
            "display" : "Skin lesion (disorder)"
          },
          {
            "code" : "95325000",
            "display" : "Subcutaneous nodule (finding)"
          },
          {
            "code" : "95344007",
            "display" : "Ulcer of lower extremity (disorder)"
          },
          {
            "code" : "95345008",
            "display" : "Ulcer of foot (disorder)"
          },
          {
            "code" : "95347000",
            "display" : "Skin necrosis (disorder)"
          },
          {
            "code" : "95361005",
            "display" : "Inflammatory disease of mucous membrane (disorder)"
          },
          {
            "code" : "95376002",
            "display" : "Injection site disorder (disorder)"
          },
          {
            "code" : "95378001",
            "display" : "Injection site hypersensitivity (disorder)"
          },
          {
            "code" : "95379009",
            "display" : "Injection site irritation (disorder)"
          },
          {
            "code" : "95380007",
            "display" : "Injection site pigmentation change (disorder)"
          },
          {
            "code" : "95381006",
            "display" : "Injection site infection (disorder)"
          },
          {
            "code" : "95382004",
            "display" : "Injection site abscess (disorder)"
          },
          {
            "code" : "95383009",
            "display" : "Injection site sterile abscess (disorder)"
          },
          {
            "code" : "95384003",
            "display" : "Injection site extravasation (disorder)"
          },
          {
            "code" : "95385002",
            "display" : "Injection site hemorrhage (disorder)"
          },
          {
            "code" : "95386001",
            "display" : "Injection site thrombosis (disorder)"
          },
          {
            "code" : "95387005",
            "display" : "Injection site malabsorption (disorder)"
          },
          {
            "code" : "95388000",
            "display" : "Injection site pain (disorder)"
          },
          {
            "code" : "95389008",
            "display" : "Injection site burning (disorder)"
          },
          {
            "code" : "95390004",
            "display" : "Injection site nerve damage (disorder)"
          },
          {
            "code" : "95391000",
            "display" : "Injection site inflammation (disorder)"
          },
          {
            "code" : "95392007",
            "display" : "Injection site edema (disorder)"
          },
          {
            "code" : "95393002",
            "display" : "Injection site dermatitis (disorder)"
          },
          {
            "code" : "95394008",
            "display" : "Injection site urticaria (disorder)"
          },
          {
            "code" : "95395009",
            "display" : "Injection site mass (disorder)"
          },
          {
            "code" : "95396005",
            "display" : "Injection site cyst (disorder)"
          },
          {
            "code" : "95397001",
            "display" : "Injection site necrosis (disorder)"
          },
          {
            "code" : "95398006",
            "display" : "Injection site anesthesia (disorder)"
          },
          {
            "code" : "95399003",
            "display" : "Injection site paresthesia (disorder)"
          },
          {
            "code" : "95400005",
            "display" : "Injection site ulcer (disorder)"
          },
          {
            "code" : "95401009",
            "display" : "Injection site bruising (disorder)"
          },
          {
            "code" : "95402002",
            "display" : "Injection site induration (disorder)"
          },
          {
            "code" : "95403007",
            "display" : "Injection site fibrosis (disorder)"
          },
          {
            "code" : "95404001",
            "display" : "Injection site atrophy (disorder)"
          },
          {
            "code" : "95415006",
            "display" : "Polymyalgia (disorder)"
          },
          {
            "code" : "95417003",
            "display" : "Primary fibromyalgia syndrome (disorder)"
          },
          {
            "code" : "95418008",
            "display" : "Muscle spasms of head AND/OR neck (disorder)"
          },
          {
            "code" : "95421005",
            "display" : "Intercostal myalgia (finding)"
          },
          {
            "code" : "95434006",
            "display" : "Tracheomalacia (disorder)"
          },
          {
            "code" : "95441000",
            "display" : "Pulmonary artery stenosis (disorder)"
          },
          {
            "code" : "95446005",
            "display" : "Thrombosis of mesenteric vein (disorder)"
          },
          {
            "code" : "95451004",
            "display" : "Thrombophlebitis of superficial veins of upper extremities (disorder)"
          },
          {
            "code" : "95453001",
            "display" : "Subdural intracranial hematoma (disorder)"
          },
          {
            "code" : "95486002",
            "display" : "Congenital blindness (disorder)"
          },
          {
            "code" : "95499004",
            "display" : "Hypoplasia of the optic nerve (disorder)"
          },
          {
            "code" : "95508001",
            "display" : "Congenital obstruction of lacrimal canal (disorder)"
          },
          {
            "code" : "95529005",
            "display" : "Acute gastric ulcer (disorder)"
          },
          {
            "code" : "95530000",
            "display" : "Chronic gastric ulcer (disorder)"
          },
          {
            "code" : "95531001",
            "display" : "Hemorrhagic duodenitis (disorder)"
          },
          {
            "code" : "95532008",
            "display" : "Obstruction of duodenum (disorder)"
          },
          {
            "code" : "95533003",
            "display" : "Duodenal hemorrhage (disorder)"
          },
          {
            "code" : "95540002",
            "display" : "Hemorrhage of colon (disorder)"
          },
          {
            "code" : "95545007",
            "display" : "Hemorrhagic diarrhea (disorder)"
          },
          {
            "code" : "95563007",
            "display" : "Gallstone pancreatitis (disorder)"
          },
          {
            "code" : "95566004",
            "display" : "Urolithiasis (disorder)"
          },
          {
            "code" : "95570007",
            "display" : "Kidney stone (disorder)"
          },
          {
            "code" : "95574003",
            "display" : "Stenosis of ureter (disorder)"
          },
          {
            "code" : "95575002",
            "display" : "Obstruction of pelviureteric junction (disorder)"
          },
          {
            "code" : "95581005",
            "display" : "Bilateral hydronephrosis (disorder)"
          },
          {
            "code" : "95598005",
            "display" : "Ruptured cyst of ovary (disorder)"
          },
          {
            "code" : "95617006",
            "display" : "Neonatal cyanosis (disorder)"
          },
          {
            "code" : "95628005",
            "display" : "Neonatal encephalopathy (disorder)"
          },
          {
            "code" : "95636001",
            "display" : "Sadomasochism (disorder)"
          },
          {
            "code" : "95646004",
            "display" : "Cerebellar degeneration (disorder)"
          },
          {
            "code" : "95655001",
            "display" : "Ophthalmic migraine (disorder)"
          },
          {
            "code" : "95657009",
            "display" : "Chronic mixed headache syndrome (disorder)"
          },
          {
            "code" : "95662005",
            "display" : "Sensory neuropathy (disorder)"
          },
          {
            "code" : "95663000",
            "display" : "Peripheral motor neuropathy (disorder)"
          },
          {
            "code" : "95668009",
            "display" : "Pain in face (finding)"
          },
          {
            "code" : "95673003",
            "display" : "Paresthesia of upper limb (finding)"
          },
          {
            "code" : "95675005",
            "display" : "Ulnar neuritis (disorder)"
          },
          {
            "code" : "95677002",
            "display" : "Disorder of vision (disorder)"
          },
          {
            "code" : "95689000",
            "display" : "Retinal deposits (disorder)"
          },
          {
            "code" : "95690009",
            "display" : "Retinal tear (disorder)"
          },
          {
            "code" : "95697007",
            "display" : "Generalized retinal degeneration (disorder)"
          },
          {
            "code" : "95711003",
            "display" : "Nevus of iris (disorder)"
          },
          {
            "code" : "95717004",
            "display" : "Secondary glaucoma (disorder)"
          },
          {
            "code" : "95722004",
            "display" : "Bilateral cataracts (disorder)"
          },
          {
            "code" : "95723009",
            "display" : "Subcapsular cataract (disorder)"
          },
          {
            "code" : "95726001",
            "display" : "Corneal scar (disorder)"
          },
          {
            "code" : "95742008",
            "display" : "Corneal graft rejection (disorder)"
          },
          {
            "code" : "95770005",
            "display" : "Inflammation of orbit proper (disorder)"
          },
          {
            "code" : "95800001",
            "display" : "Asteroid hyalosis (disorder)"
          },
          {
            "code" : "95812002",
            "display" : "Eczema of external auditory canal (disorder)"
          },
          {
            "code" : "95814001",
            "display" : "Peripheral vestibular disease (disorder)"
          },
          {
            "code" : "95820000",
            "display" : "Bilateral hearing loss (disorder)"
          },
          {
            "code" : "95823003",
            "display" : "Leudet's tinnitus (disorder)"
          },
          {
            "code" : "95827002",
            "display" : "Congenital hearing disorder (disorder)"
          },
          {
            "code" : "95828007",
            "display" : "Congenital deafness (disorder)"
          },
          {
            "code" : "95850008",
            "display" : "Depressed fracture of skull (disorder)"
          },
          {
            "code" : "95851007",
            "display" : "Fracture of orbit (disorder)"
          },
          {
            "code" : "95855003",
            "display" : "Traumatic amputation of finger (disorder)"
          },
          {
            "code" : "95862007",
            "display" : "Adverse effect of physical agent (disorder)"
          },
          {
            "code" : "95866005",
            "display" : "Exposure to extreme temperature, non-occupational (event)"
          },
          {
            "code" : "95869003",
            "display" : "Adverse effect of prosthetic device (disorder)"
          },
          {
            "code" : "95871003",
            "display" : "Exposure to mercury (event)"
          },
          {
            "code" : "95875007",
            "display" : "Exposure to carbon monoxide (event)"
          },
          {
            "code" : "95880003",
            "display" : "Soft tissue infection (disorder)"
          },
          {
            "code" : "95891005",
            "display" : "Influenza-like illness (finding)"
          },
          {
            "code" : "95898004",
            "display" : "Tick bite (disorder)"
          },
          {
            "code" : "95919007",
            "display" : "Dependence on corticoids (disorder)"
          },
          {
            "code" : "95921002",
            "display" : "Elderly person maltreatment (event)"
          },
          {
            "code" : "95922009",
            "display" : "Child sex abuse (event)"
          },
          {
            "code" : "95924005",
            "display" : "Victim of mental abuse (finding)"
          },
          {
            "code" : "95925006",
            "display" : "Psychologically abused woman (finding)"
          },
          {
            "code" : "95926007",
            "display" : "Psychologically abused spouse (finding)"
          },
          {
            "code" : "95927003",
            "display" : "Psychologically abused parent (finding)"
          },
          {
            "code" : "95929000",
            "display" : "Psychologically abused elder (finding)"
          },
          {
            "code" : "95930005",
            "display" : "Victim of neglect (finding)"
          },
          {
            "code" : "95931009",
            "display" : "Neglected spouse (finding)"
          },
          {
            "code" : "95932002",
            "display" : "Neglected parents (finding)"
          },
          {
            "code" : "95933007",
            "display" : "Neglected elder (finding)"
          },
          {
            "code" : "96218000",
            "display" : "Acepromazine (substance)"
          },
          {
            "code" : "96227004",
            "display" : "Zolazepam hydrochloride (substance)"
          },
          {
            "code" : "96229001",
            "display" : "Azaperone (substance)"
          },
          {
            "code" : "96230006",
            "display" : "Xylazine hydrochloride (substance)"
          },
          {
            "code" : "96265006",
            "display" : "Tiletamine hydrochloride (substance)"
          },
          {
            "code" : "96300001",
            "display" : "Product containing propafenone (medicinal product)"
          },
          {
            "code" : "96301002",
            "display" : "Product containing sotalol (medicinal product)"
          },
          {
            "code" : "96302009",
            "display" : "Product containing 3-hydroxy-3-methylglutaryl-coenzyme A reductase inhibitor (product)"
          },
          {
            "code" : "96308008",
            "display" : "Product containing angiotensin II receptor antagonist (product)"
          },
          {
            "code" : "96328007",
            "display" : "Medicinal product acting as decongestant (product)"
          },
          {
            "code" : "96390006",
            "display" : "Technetium (99m-Tc) medronate (substance)"
          },
          {
            "code" : "102259006",
            "display" : "Citrus fruit (substance)"
          },
          {
            "code" : "102261002",
            "display" : "Strawberry (substance)"
          },
          {
            "code" : "102262009",
            "display" : "Chocolate (substance)"
          },
          {
            "code" : "102263004",
            "display" : "Eggs (edible) (substance)"
          },
          {
            "code" : "102264005",
            "display" : "Cheese (substance)"
          },
          {
            "code" : "102268008",
            "display" : "Macrobiotic diet (finding)"
          },
          {
            "code" : "102292000",
            "display" : "Skeletal muscle structure of lower limb (body structure)"
          },
          {
            "code" : "102298001",
            "display" : "Structure of chordae tendineae cordis (body structure)"
          },
          {
            "code" : "102303004",
            "display" : "Vascular prosthesis, device (physical object)"
          },
          {
            "code" : "102304005",
            "display" : "Measuring ruler, device (physical object)"
          },
          {
            "code" : "102312002",
            "display" : "Atherectomy device (physical object)"
          },
          {
            "code" : "102313007",
            "display" : "Rotational atherectomy device (physical object)"
          },
          {
            "code" : "102314001",
            "display" : "Embolization coil, device (physical object)"
          },
          {
            "code" : "102315000",
            "display" : "Embolization ball, device (physical object)"
          },
          {
            "code" : "102316004",
            "display" : "Embolization particulate, device (physical object)"
          },
          {
            "code" : "102317008",
            "display" : "Guiding catheter, device (physical object)"
          },
          {
            "code" : "102319006",
            "display" : "Percutaneous transluminal angioplasty balloon, device (physical object)"
          },
          {
            "code" : "102320000",
            "display" : "Detachable balloon, device (physical object)"
          },
          {
            "code" : "102321001",
            "display" : "Operating microscope, device (physical object)"
          },
          {
            "code" : "102322008",
            "display" : "External prosthesis for sonographic procedure, device (physical object)"
          },
          {
            "code" : "102323003",
            "display" : "Water bag prosthesis for imaging procedure, device (physical object)"
          },
          {
            "code" : "102324009",
            "display" : "Saline bag prosthesis for imaging procedure, device (physical object)"
          },
          {
            "code" : "102325005",
            "display" : "Gel prosthesis for imaging procedure, device (physical object)"
          },
          {
            "code" : "102378009",
            "display" : "BB shot, device (qualifier value)"
          },
          {
            "code" : "102420004",
            "display" : "Exposure to pollution (event)"
          },
          {
            "code" : "102421000",
            "display" : "Exposure to environmental pollution (event)"
          },
          {
            "code" : "102422007",
            "display" : "Exposure to environmental pollution, occupational (event)"
          },
          {
            "code" : "102423002",
            "display" : "Exposure to environmental pollution, non-occupational (event)"
          },
          {
            "code" : "102424008",
            "display" : "Exposure to polluted air (event)"
          },
          {
            "code" : "102425009",
            "display" : "Exposure to polluted air, occupational (event)"
          },
          {
            "code" : "102426005",
            "display" : "Exposure to polluted air, non-occupational (event)"
          },
          {
            "code" : "102427001",
            "display" : "Exposure to water pollution (event)"
          },
          {
            "code" : "102428006",
            "display" : "Exposure to polluted water, occupational (event)"
          },
          {
            "code" : "102429003",
            "display" : "Exposure to polluted water, non-occupational (event)"
          },
          {
            "code" : "102430008",
            "display" : "Exposure to polluted drinking water (event)"
          },
          {
            "code" : "102431007",
            "display" : "Exposure to polluted bathing water (event)"
          },
          {
            "code" : "102432000",
            "display" : "Exposure to polluted soil (event)"
          },
          {
            "code" : "102433005",
            "display" : "Exposure to polluted soil, occupational (event)"
          },
          {
            "code" : "102434004",
            "display" : "Exposure to polluted soil, non-occupational (event)"
          },
          {
            "code" : "102435003",
            "display" : "Exposure to chemical pollution (event)"
          },
          {
            "code" : "102436002",
            "display" : "Exposure to chemical pollution, occupational (event)"
          },
          {
            "code" : "102437006",
            "display" : "Exposure to chemical pollution, non-occupational (event)"
          },
          {
            "code" : "102439009",
            "display" : "Exposure to toxic waste, occupational (event)"
          },
          {
            "code" : "102440006",
            "display" : "Exposure to toxic waste, non-occupational (event)"
          },
          {
            "code" : "102441005",
            "display" : "Exposure to toxic agricultural agents (event)"
          },
          {
            "code" : "102442003",
            "display" : "Exposure to toxic agricultural agents, occupational (event)"
          },
          {
            "code" : "102443008",
            "display" : "Exposure to toxic agricultural agents, non-occupational (event)"
          },
          {
            "code" : "102444002",
            "display" : "Exposure to toxic dust (event)"
          },
          {
            "code" : "102445001",
            "display" : "Exposure to toxic dust, occupational (event)"
          },
          {
            "code" : "102446000",
            "display" : "Exposure to toxic dust, non-occupational (event)"
          },
          {
            "code" : "102447009",
            "display" : "Postmenopausal osteoporosis (disorder)"
          },
          {
            "code" : "102449007",
            "display" : "Tardive dyskinesia (disorder)"
          },
          {
            "code" : "102457005",
            "display" : "Battered baby AND/OR child syndrome (finding)"
          },
          {
            "code" : "102458000",
            "display" : "Shaken baby syndrome (finding)"
          },
          {
            "code" : "102459008",
            "display" : "Increased tolerance (finding)"
          },
          {
            "code" : "102460003",
            "display" : "Decreased tolerance (finding)"
          },
          {
            "code" : "102478008",
            "display" : "Pre-existing condition (finding)"
          },
          {
            "code" : "102481003",
            "display" : "Generalized chronic body pains (finding)"
          },
          {
            "code" : "102482005",
            "display" : "Growing pains (finding)"
          },
          {
            "code" : "102483000",
            "display" : "Associated symptom (finding)"
          },
          {
            "code" : "102491009",
            "display" : "Immobile (finding)"
          },
          {
            "code" : "102493007",
            "display" : "Increased body growth (finding)"
          },
          {
            "code" : "102497008",
            "display" : "Symptoms of stress (finding)"
          },
          {
            "code" : "102499006",
            "display" : "Fit and well (finding)"
          },
          {
            "code" : "102500002",
            "display" : "Good neonatal condition at birth (finding)"
          },
          {
            "code" : "102519007",
            "display" : "Apparent age (observable entity)"
          },
          {
            "code" : "102520001",
            "display" : "Age under 20 years (finding)"
          },
          {
            "code" : "102521002",
            "display" : "Age under 25 years (finding)"
          },
          {
            "code" : "102522009",
            "display" : "Age 19 to 59 years (finding)"
          },
          {
            "code" : "102523004",
            "display" : "Age 40 to 49 years, female (finding)"
          },
          {
            "code" : "102524005",
            "display" : "Age more than 50 years (finding)"
          },
          {
            "code" : "102525006",
            "display" : "Age more than 50 years, male (finding)"
          },
          {
            "code" : "102526007",
            "display" : "Age more than 50 years, female (finding)"
          },
          {
            "code" : "102527003",
            "display" : "Age 60 to 64 years (finding)"
          },
          {
            "code" : "102528008",
            "display" : "Age more than 65 years (finding)"
          },
          {
            "code" : "102533007",
            "display" : "Excessive exercise (finding)"
          },
          {
            "code" : "102535000",
            "display" : "Right lateral decubitus position (finding)"
          },
          {
            "code" : "102536004",
            "display" : "Left lateral decubitus position (finding)"
          },
          {
            "code" : "102538003",
            "display" : "Recumbent body position (finding)"
          },
          {
            "code" : "102539006",
            "display" : "Semi-erect body position (finding)"
          },
          {
            "code" : "102540008",
            "display" : "Headfirst position (finding)"
          },
          {
            "code" : "102541007",
            "display" : "Feet first position (finding)"
          },
          {
            "code" : "102549009",
            "display" : "Cramp in lower leg associated with rest (finding)"
          },
          {
            "code" : "102556003",
            "display" : "Pain in upper limb (finding)"
          },
          {
            "code" : "102558002",
            "display" : "Edema of the upper extremity (finding)"
          },
          {
            "code" : "102568007",
            "display" : "Paresis of lower extremity (finding)"
          },
          {
            "code" : "102570003",
            "display" : "Inguinal pain (finding)"
          },
          {
            "code" : "102572006",
            "display" : "Edema of lower extremity (finding)"
          },
          {
            "code" : "102576009",
            "display" : "Edema of foot (finding)"
          },
          {
            "code" : "102588006",
            "display" : "Chest wall pain (finding)"
          },
          {
            "code" : "102589003",
            "display" : "Atypical chest pain (finding)"
          },
          {
            "code" : "102594003",
            "display" : "Electrocardiogram abnormal (finding)"
          },
          {
            "code" : "102608004",
            "display" : "Excessive appetite (finding)"
          },
          {
            "code" : "102609007",
            "display" : "Feeding problem in child (finding)"
          },
          {
            "code" : "102610002",
            "display" : "Inadequate food diet (finding)"
          },
          {
            "code" : "102613000",
            "display" : "Localized abdominal pain (finding)"
          },
          {
            "code" : "102614006",
            "display" : "Generalized abdominal pain (finding)"
          },
          {
            "code" : "102616008",
            "display" : "Painful mouth (finding)"
          },
          {
            "code" : "102618009",
            "display" : "Pharyngeal dryness (finding)"
          },
          {
            "code" : "102635008",
            "display" : "Acute nutritional deficiency (finding)"
          },
          {
            "code" : "102636009",
            "display" : "Chronic nutritional deficiency (finding)"
          },
          {
            "code" : "102660008",
            "display" : "Abnormal glucose level (finding)"
          },
          {
            "code" : "102737005",
            "display" : "High density lipoprotein cholesterol (substance)"
          },
          {
            "code" : "102739008",
            "display" : "Low density lipoprotein cholesterol (substance)"
          },
          {
            "code" : "102835006",
            "display" : "Difficulty passing urine (finding)"
          },
          {
            "code" : "102866000",
            "display" : "Abnormal urine (finding)"
          },
          {
            "code" : "102872000",
            "display" : "Pregnancy on oral contraceptive (finding)"
          },
          {
            "code" : "102874004",
            "display" : "Possible pregnancy (finding)"
          },
          {
            "code" : "102875003",
            "display" : "Surrogate pregnancy (finding)"
          },
          {
            "code" : "102876002",
            "display" : "Multigravida (finding)"
          },
          {
            "code" : "102877006",
            "display" : "Nulliparous (finding)"
          },
          {
            "code" : "102878001",
            "display" : "Recurrent miscarriage (disorder)"
          },
          {
            "code" : "102891000",
            "display" : "Age-related cognitive decline (finding)"
          },
          {
            "code" : "102906002",
            "display" : "Delinquent behavior (finding)"
          },
          {
            "code" : "102912007",
            "display" : "Fear of death (finding)"
          },
          {
            "code" : "102913002",
            "display" : "Taphophobia (finding)"
          },
          {
            "code" : "102915009",
            "display" : "Nosophobia (finding)"
          },
          {
            "code" : "102916005",
            "display" : "Arachnophobia (finding)"
          },
          {
            "code" : "102917001",
            "display" : "Fear of blood (finding)"
          },
          {
            "code" : "102918006",
            "display" : "Microphobia (finding)"
          },
          {
            "code" : "102919003",
            "display" : "Fear of infection (finding)"
          },
          {
            "code" : "102920009",
            "display" : "Fear of contracting human immunodeficiency virus infection (finding)"
          },
          {
            "code" : "102921008",
            "display" : "Toxicophobia (finding)"
          },
          {
            "code" : "102922001",
            "display" : "Tocophobia (finding)"
          },
          {
            "code" : "102923006",
            "display" : "Teratophobia (finding)"
          },
          {
            "code" : "102924000",
            "display" : "Pyrophobia (finding)"
          },
          {
            "code" : "102925004",
            "display" : "Astrapophobia (finding)"
          },
          {
            "code" : "102927007",
            "display" : "Nyctophobia (finding)"
          },
          {
            "code" : "102928002",
            "display" : "Theophobia (finding)"
          },
          {
            "code" : "102929005",
            "display" : "Androphobia (finding)"
          },
          {
            "code" : "102930000",
            "display" : "Gynephobia (finding)"
          },
          {
            "code" : "102931001",
            "display" : "Fear of heart attack (finding)"
          },
          {
            "code" : "102932008",
            "display" : "Fear of hypertension (finding)"
          },
          {
            "code" : "102945007",
            "display" : "Normal sexual behavior (finding)"
          },
          {
            "code" : "102946008",
            "display" : "Abnormal sexual behavior (finding)"
          },
          {
            "code" : "102947004",
            "display" : "High risk sexual behavior (finding)"
          },
          {
            "code" : "102948009",
            "display" : "Sexual inhibition (finding)"
          },
          {
            "code" : "102949001",
            "display" : "Excessive masturbation (finding)"
          },
          {
            "code" : "102950001",
            "display" : "Abusive sexual relationship (finding)"
          },
          {
            "code" : "102951002",
            "display" : "Abusive sexual relationship with partner (finding)"
          },
          {
            "code" : "102952009",
            "display" : "Abusive sexual relationship with wife (finding)"
          },
          {
            "code" : "102953004",
            "display" : "Abusive sexual relationship with husband (finding)"
          },
          {
            "code" : "102954005",
            "display" : "Morning after pill method of contraception (finding)"
          },
          {
            "code" : "102956007",
            "display" : "Non-consummation of sexual intercourse (finding)"
          },
          {
            "code" : "103001002",
            "display" : "Feeling feverish (finding)"
          },
          {
            "code" : "103011009",
            "display" : "Benign exertional headache (finding)"
          },
          {
            "code" : "103021001",
            "display" : "Premature adrenarche (finding)"
          },
          {
            "code" : "103228002",
            "display" : "Hemoglobin saturation with oxygen (observable entity)"
          },
          {
            "code" : "103252009",
            "display" : "Abnormal ocular motility (finding)"
          },
          {
            "code" : "103262002",
            "display" : "Staring (finding)"
          },
          {
            "code" : "103263007",
            "display" : "Dysconjugate gaze (finding)"
          },
          {
            "code" : "103268003",
            "display" : "Circles under eyes (finding)"
          },
          {
            "code" : "103276001",
            "display" : "Decreased hearing (finding)"
          },
          {
            "code" : "103281005",
            "display" : "Sensation of blocked ear (finding)"
          },
          {
            "code" : "103284002",
            "display" : "Positional vertigo (finding)"
          },
          {
            "code" : "103321005",
            "display" : "Request by physician (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "103329007",
            "display" : "Unavailability of (contextual qualifier) (qualifier value)"
          },
          {
            "code" : "103335007",
            "display" : "Duration (attribute)"
          },
          {
            "code" : "103339001",
            "display" : "Long axis (qualifier value)"
          },
          {
            "code" : "103340004",
            "display" : "Short axis (qualifier value)"
          },
          {
            "code" : "103341000",
            "display" : "Off axis (qualifier value)"
          },
          {
            "code" : "103342007",
            "display" : "Mid-longitudinal (qualifier value)"
          },
          {
            "code" : "103343002",
            "display" : "Parasagittal (qualifier value)"
          },
          {
            "code" : "103344008",
            "display" : "Transvesical (qualifier value)"
          },
          {
            "code" : "103345009",
            "display" : "Transthecal (qualifier value)"
          },
          {
            "code" : "103346005",
            "display" : "Transsplenic (qualifier value)"
          },
          {
            "code" : "103347001",
            "display" : "Transrenal (qualifier value)"
          },
          {
            "code" : "103348006",
            "display" : "Transpleural (qualifier value)"
          },
          {
            "code" : "103349003",
            "display" : "Transpancreatic (qualifier value)"
          },
          {
            "code" : "103353001",
            "display" : "Transgastric (qualifier value)"
          },
          {
            "code" : "103354007",
            "display" : "Transmural (qualifier value)"
          },
          {
            "code" : "103355008",
            "display" : "Width (qualifier value)"
          },
          {
            "code" : "103361006",
            "display" : "Unsteady (qualifier value)"
          },
          {
            "code" : "103381007",
            "display" : "Transhepatic approach (qualifier value)"
          },
          {
            "code" : "103382000",
            "display" : "Transtemporal approach (qualifier value)"
          },
          {
            "code" : "103383005",
            "display" : "Transesophageal approach (qualifier value)"
          },
          {
            "code" : "103386002",
            "display" : "Transvenous approach (qualifier value)"
          },
          {
            "code" : "103387006",
            "display" : "Transarterial approach (qualifier value)"
          },
          {
            "code" : "103390000",
            "display" : "Elective (qualifier value)"
          },
          {
            "code" : "103391001",
            "display" : "Urgency (qualifier value)"
          },
          {
            "code" : "103427005",
            "display" : "Campylobacter upsaliensis (organism)"
          },
          {
            "code" : "103428000",
            "display" : "Corynebacterium ulcerans (organism)"
          },
          {
            "code" : "103429008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O157:H7 (organism)"
          },
          {
            "code" : "103430003",
            "display" : "Yersinia enterocolitica serogroup O:3 (organism)"
          },
          {
            "code" : "103431004",
            "display" : "Yersinia enterocolitica serogroup O:5 (organism)"
          },
          {
            "code" : "103432006",
            "display" : "Yersinia enterocolitica serogroup O:8 (organism)"
          },
          {
            "code" : "103433001",
            "display" : "Yersinia enterocolitica serogroup O:9 (organism)"
          },
          {
            "code" : "103436009",
            "display" : "Enterococcus pseudoavium (organism)"
          },
          {
            "code" : "103437000",
            "display" : "Enterococcus raffinosus (organism)"
          },
          {
            "code" : "103441001",
            "display" : "Haemophilus influenzae type a (organism)"
          },
          {
            "code" : "103442008",
            "display" : "Haemophilus influenzae type b (organism)"
          },
          {
            "code" : "103443003",
            "display" : "Haemophilus influenzae type c (organism)"
          },
          {
            "code" : "103444009",
            "display" : "Haemophilus influenzae type d (organism)"
          },
          {
            "code" : "103445005",
            "display" : "Haemophilus influenzae type e (organism)"
          },
          {
            "code" : "103446006",
            "display" : "Haemophilus influenzae type f 