# Jurisdiction ValueSet - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Jurisdiction ValueSet**

## ValueSet: Jurisdiction ValueSet 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/jurisdiction | *Version*:1.0.0 | | |
| Active as of 2024-02-20 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 5 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:JurisdictionValueSet |
| *Other Identifiers:*OID:2.16.840.1.113883.11.21029 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set defines a base set of codes for country, country subdivision and region for indicating where a resource is intended to be used. 
Note: The codes for countries and country subdivisions are taken from [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) while the codes for "supra-national" regions are from [UN Standard country or area codes for statistical use (M49)](http://unstats.un.org/unsd/methods/m49/m49.htm). 

 **References** 

* [Official Address](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-address-official.html)
* [Person Recorded Sex Or Gender](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-individual-recordedSexOrGender.html)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "jurisdiction",
  "meta" : {
    "lastUpdated" : "2023-03-26T15:21:02.749+11:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "vocab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 5
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/jurisdiction",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.21029"
    }
  ],
  "version" : "1.0.0",
  "name" : "JurisdictionValueSet",
  "title" : "Jurisdiction ValueSet",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-20T21:40:00+10:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a base set of codes for country, country subdivision and region    for indicating where a resource is intended to be used.   \r\n   \r\n   Note: The codes for countries and country subdivisions are taken from    [ISO 3166](https://www.iso.org/iso-3166-country-codes.html)    while the codes for \"supra-national\" regions are from    [UN Standard country or area codes for statistical use (M49)](http://unstats.un.org/unsd/methods/m49/m49.htm).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "urn:iso:std:iso:3166"
      },
      {
        "system" : "urn:iso:std:iso:3166:-2"
      },
      {
        "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
        "filter" : [
          {
            "property" : "class",
            "op" : "=",
            "value" : "region"
          }
        ]
      }
    ]
  }
}

```
