# MIF concept relationship symmetry - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF concept relationship symmetry**

## Extension: MIF concept relationship symmetry 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry | *Version*:0.0.34 |
| Active as of 2026-01-26 | *Computable Name*:SupportedConceptRelationshipSymmetry |

Indicates if the relationship always holds in the reverse direction as well (symetric), never holds in the reverse direction as well (antisymetric)

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-relationship-symmetry)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-relationship-symmetry.csv), [Excel](StructureDefinition-ext-mif-relationship-symmetry.xlsx), [Schematron](StructureDefinition-ext-mif-relationship-symmetry.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-relationship-symmetry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
  "version" : "0.0.34",
  "name" : "SupportedConceptRelationshipSymmetry",
  "title" : "MIF concept relationship symmetry",
  "status" : "active",
  "date" : "2026-01-26T07:21:33+00:00",
  "description" : "Indicates if the relationship always holds in the reverse direction as well (symetric), never holds in the reverse direction as well (antisymetric)",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF concept relationship symmetry",
        "definition" : "Indicates if the relationship always holds in the reverse direction as well (symetric), never holds in the reverse direction as well (antisymetric)",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipSymmetry"
        },
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "SupportedConceptRelationship.symmetry"
          }
        ]
      }
    ]
  }
}

```
