# Multum Lexicon - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Multum Lexicon**

## NamingSystem: Multum Lexicon 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/multum | *Version*:2.1.0 |
| Retired as of 2021-11-09 | *Computable Name*:Multum |

 
Broadly, the fields and values in the Multum Lexicon and the VantageRx Database are intended to be available for use in any HL7 message that includes a reference to non-veterinary drug products or active ingredients that are either approved for sale by the FDA or readily available in the United States. The following inter-related definitions recently circulated by us to the HL7 Vocabulary Technical Committee explain the scope of what we mean by "drug product" and "active ingredient". (A definition for "drug ingredient" is also provided here because the definition of "active ingredient" is reliant on this term.) 
Drug Product A drug product is a manufactured or extemporaneously-compounded physiologically-active material intended by the preparer to achieve therapeutic, diagnostic, or preventative effects via biochemical mechanisms when applied to an epithelial surface or placed in an internal body space of a targeted organism. 
Drug Ingredient A drug ingredient is a chemical compound or biologic agent that occurs in a drug product. 
Active Ingredient An active ingredient is a drug ingredient that mediates one or more of the intended therapeutic, diagnostic, or preventative effects of a drug product and is present in sufficient quantities to achieve such effects according to the allopathic tradition of healthcare practice. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "multum",
  "url" : "http://terminology.hl7.org/NamingSystem/multum",
  "version" : "2.1.0",
  "name" : "Multum",
  "title" : "Multum Lexicon",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "description" : "Broadly, the fields and values in the Multum Lexicon and the VantageRx Database are intended to be available for use in any HL7 message that includes a reference to non-veterinary drug products or active ingredients that are either approved for sale by the FDA or readily available in the United States. The following inter-related definitions recently circulated by us to the HL7 Vocabulary Technical Committee explain the scope of what we mean by \"drug product\" and \"active ingredient\". (A definition for \"drug ingredient\" is also provided here because the definition of \"active ingredient\" is reliant on this term.)\r\n\r\nDrug Product A drug product is a manufactured or extemporaneously-compounded physiologically-active material intended by the preparer to achieve therapeutic, diagnostic, or preventative effects via biochemical mechanisms when applied to an epithelial surface or placed in an internal body space of a targeted organism.\r\n\r\nDrug Ingredient A drug ingredient is a chemical compound or biologic agent that occurs in a drug product.\r\n\r\nActive Ingredient An active ingredient is a drug ingredient that mediates one or more of the intended therapeutic, diagnostic, or preventative effects of a drug product and is present in sufficient quantities to achieve such effects according to the allopathic tradition of healthcare practice.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.27",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/multum",
      "preferred" : true
    }
  ]
}

```
