# NHSN Healthcare Facility Patient Care Location - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHSN Healthcare Facility Patient Care Location**

## NamingSystem: NHSN Healthcare Facility Patient Care Location 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/hsloc | *Version*:3.0.0 | |
| Active as of 2021-02-21 | *Responsible:*[U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)](https://www.cdc.gov/nhsn) | *Computable Name*:HSLOC |

 
A classification of patient care locations within healthcare facilities for public health purposes. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "hsloc",
  "url" : "http://terminology.hl7.org/NamingSystem/hsloc",
  "version" : "3.0.0",
  "name" : "HSLOC",
  "title" : "NHSN Healthcare Facility Patient Care Location",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-02-21T00:00:00-04:00",
  "publisher" : "U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)",
  "contact" : [
    {
      "name" : "U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)",
      "telecom" : [
        {
          "system" : "email",
          "value" : "nhsncda@cdc.gov"
        },
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/nhsn"
        }
      ]
    }
  ],
  "description" : "A classification of patient care locations within healthcare facilities for public health purposes.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.259",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/hsloc",
      "preferred" : false,
      "period" : {
        "end" : "2020-07-01T00:00:00-04:00"
      }
    },
    {
      "type" : "uri",
      "value" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html",
      "preferred" : true,
      "period" : {
        "start" : "2020-07-01T00:00:00-04:00"
      }
    }
  ]
}

```
