# US Department of Veterans Affairs - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Department of Veterans Affairs**

## NamingSystem: US Department of Veterans Affairs 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/VHA | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*VA | *Computable Name*:VHA |

 
VHA Enterprise Reference Terminology is based on CHI standard terminologies (e.g., SNOMED-CT, LOINC, HL7, NDF-RT, etc.) when available and on VHA own code sets when necessary (e.g., allergens). All concepts used within the VHA clinical environment receive a VHA Unique IDentifier or VUID. VHA Enterprise Reference Terminology complies with the semantics of the HL7 message structure 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "VHA",
  "url" : "http://terminology.hl7.org/NamingSystem/VHA",
  "version" : "2.1.0",
  "name" : "VHA",
  "title" : "US Department of Veterans Affairs",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "VA",
  "contact" : [
    {
      "name" : "US Department of Veterans Affairs"
    }
  ],
  "responsible" : "VA",
  "description" : "VHA Enterprise Reference Terminology is based on CHI standard terminologies (e.g., SNOMED-CT, LOINC, HL7, NDF-RT, etc.) when available and on VHA own code sets when necessary (e.g., allergens). All concepts used within the VHA clinical environment receive a VHA Unique IDentifier or VUID. VHA Enterprise Reference Terminology complies with the semantics of the HL7 message structure",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.233",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/VHA",
      "preferred" : true
    }
  ]
}

```
