# Universal Protein Resource - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Universal Protein Resource**

## NamingSystem: Universal Protein Resource 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/UniProt | *Version*:1.0.0 | |
| Active as of 2025-03-24 | *Responsible:*[UniProt Consortium](https://www.uniprot.org/help/about) | *Computable Name*:UniProt |
| **Copyright/Legal**: "We have chosen to apply the [Creative Commons Attribution 4.0 International (CC BY 4.0) License](https://creativecommons.org/licenses/by/4.0/) to all copyrightable parts of our databases."See [https://www.uniprot.org/help/copyright](https://www.uniprot.org/help/copyright) and [https://www.uniprot.org/help/license](https://www.uniprot.org/help/license). | | |

 
The Universal Protein Resource (UniProt) is a comprehensive resource for protein sequence and annotation data. The UniProt databases are the [UniProt Knowledgebase (UniProtKB)](https://www.uniprot.org/help/uniprotkb), the [UniProt Reference Clusters (UniRef)](https://www.uniprot.org/help/uniref[), and the [UniProt Archive (UniParc)](https://www.uniprot.org/help/uniparc). 
UniProt Technical Information: [https://www.uniprot.org/help/technical](https://www.uniprot.org/help/technical). 
Examples of records from FDA GSRS (Global Substance Registration System) using UniProt [Accession number](https://www.uniprot.org/help/accession_numbers) identifiers: 
1. Minor histocompatibility antigen HA-1
* GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/826ee7a3-7441-4dd1-9adb-e0ef04caba18) (note UNIPROT accession number is listed under "Codes - Identifiers")
* UNIPROT Accession Number identifier: [O78181](https://www.uniprot.org/uniprotkb/O78181/entry)

1. PULMONARY SURFACTANT-ASSOCIATED PROTEIN C (BOS TAURUS)
* GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/6ef2d88a-75db-4ab5-9f46-e81f63e99e74) (note UNIPROT accession number is listed under "Codes - Identifiers")
* UNIPROT Accession Number identifier: [P15783](https://www.uniprot.org/uniprotkb/P15781/entry)

 
UniProt releases are published every 8 weeks (4 weeks until the last 2019 release, 2019_11), with possible exceptions in January and summer due to reduced staff during holidays. 
The current release number format is YYYY_XX where YYYY is the calendar year and XX a 2-digit number that is incremented for each release of a given year, e.g. 2010_01, 2010_02, etc. 
For more information, see [https://www.uniprot.org/help/synchronization](https://www.uniprot.org/help/synchronization) 
Other useful links: 
1. [API access](https://www.uniprot.org/help/api)
1. [Proteins (UniProtKB)](https://www.uniprot.org/uniprotkb?query=*)
1. [Species (Proteomes)](https://www.uniprot.org/proteomes?query=*)
1. [Protein clusters (UniRef)](https://www.uniprot.org/uniref?query=*)
1. [Sequence archive (UniParc)](https://www.uniprot.org/uniparc?query=*)
 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "UniProt",
  "url" : "http://terminology.hl7.org/NamingSystem/UniProt",
  "version" : "1.0.0",
  "name" : "UniProt",
  "title" : "Universal Protein Resource",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2025-03-24T00:00:00-00:00",
  "publisher" : "UniProt Consortium",
  "contact" : [
    {
      "name" : "UniProt Consortium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.uniprot.org/help/about"
        },
        {
          "system" : "url",
          "value" : "https://www.uniprot.org/contact"
        }
      ]
    }
  ],
  "responsible" : "UniProt Consortium",
  "description" : "The Universal Protein Resource (UniProt) is a comprehensive resource for protein sequence and annotation data. The UniProt databases are the [UniProt Knowledgebase (UniProtKB)](https://www.uniprot.org/help/uniprotkb), the [UniProt Reference Clusters (UniRef)](https://www.uniprot.org/help/uniref[), and the [UniProt Archive (UniParc)](https://www.uniprot.org/help/uniparc).\r\n\r\nUniProt Technical Information: [https://www.uniprot.org/help/technical](https://www.uniprot.org/help/technical).\r\n\r\nExamples of records from FDA GSRS (Global Substance Registration System) using UniProt [Accession number](https://www.uniprot.org/help/accession_numbers) identifiers:\r\n\r\n 1. Minor histocompatibility antigen HA-1\r\n\r\n     - GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/826ee7a3-7441-4dd1-9adb-e0ef04caba18)  (note UNIPROT accession number is listed under \"Codes - Identifiers\")\r\n\r\n     - UNIPROT Accession Number identifier: [O78181](https://www.uniprot.org/uniprotkb/O78181/entry)\r\n\r\n 2. PULMONARY SURFACTANT-ASSOCIATED PROTEIN C (BOS TAURUS)\r\n\r\n     - GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/6ef2d88a-75db-4ab5-9f46-e81f63e99e74) (note UNIPROT accession number is listed under \"Codes - Identifiers\")\r\n\r\n     - UNIPROT Accession Number identifier: [P15783](https://www.uniprot.org/uniprotkb/P15781/entry)     \r\n\r\nUniProt releases are published every 8 weeks (4 weeks until the last 2019 release, 2019_11), with possible exceptions in January and summer due to reduced staff during holidays.\r\n\r\nThe current release number format is YYYY_XX where YYYY is the calendar year and XX a 2-digit number that is incremented for each release of a given year, e.g. 2010_01, 2010_02, etc.\r\n\r\nFor more information, see [https://www.uniprot.org/help/synchronization](https://www.uniprot.org/help/synchronization)\r\n\r\nOther useful links:\r\n\r\n   1. [API access](https://www.uniprot.org/help/api)\r\n\r\n   2. [Proteins (UniProtKB)](https://www.uniprot.org/uniprotkb?query=*)\r\n\r\n   3. [Species (Proteomes)](https://www.uniprot.org/proteomes?query=*)\r\n\r\n   4. [Protein clusters (UniRef)](https://www.uniprot.org/uniref?query=*)\r\n\r\n   5. [Sequence archive (UniParc)](https://www.uniprot.org/uniparc?query=*)",
  "copyright" : "\"We have chosen to apply the [Creative Commons Attribution 4.0 International (CC BY 4.0) License](https://creativecommons.org/licenses/by/4.0/) to all copyrightable parts of our databases.\"\r\n\r\nSee [https://www.uniprot.org/help/copyright](https://www.uniprot.org/help/copyright) and [https://www.uniprot.org/help/license](https://www.uniprot.org/help/license).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.uniprot.org",
      "preferred" : true,
      "period" : {
        "start" : "2025-03-24"
      }
    }
  ]
}

```
