# Unique Ingredient Identifier (UNII) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Unique Ingredient Identifier (UNII)**

## NamingSystem: Unique Ingredient Identifier (UNII) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/UNII | *Version*:1.0.0 | |
| Active as of 2022-08-23 | *Responsible:*[U.S. Food and Drug Administration (FDA)](https://www.fda.gov/) | *Computable Name*:UNII |

 
A UNII is a non-proprietary, free, unique, unambiguous, nonsemantic, alphanumeric identifier based on a substance's molecular structure and/or descriptive information. UNII identifiers are generated based on scientific identity characteristics using ISO 11238 data elements. UNII availability does not imply any regulatory review or approval. Synonyms and mappings are based on the best public information available at the time of publication. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "UNII",
  "url" : "http://terminology.hl7.org/NamingSystem/UNII",
  "version" : "1.0.0",
  "name" : "UNII",
  "title" : "Unique Ingredient Identifier (UNII)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-08-23T00:00:00-00:00",
  "publisher" : "U.S. Food and Drug Administration (FDA)",
  "contact" : [
    {
      "name" : "U.S. Food and Drug Administration (FDA)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.fda.gov/"
        }
      ]
    }
  ],
  "responsible" : "U.S. Food and Drug Administration (FDA)",
  "description" : "A UNII is a non-proprietary, free, unique, unambiguous, nonsemantic, alphanumeric identifier based on a substance's molecular structure and/or descriptive information. UNII identifiers are generated based on scientific identity characteristics using ISO 11238 data elements. UNII availability does not imply any regulatory review or approval. Synonyms and mappings are based on the best public information available at the time of publication.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.9",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://fdasis.nlm.nih.gov",
      "preferred" : true
    }
  ]
}

```
