# Scientific Evidence Code System (SEVCO) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Scientific Evidence Code System (SEVCO)**

## NamingSystem: Scientific Evidence Code System (SEVCO) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/SEVCO | *Version*:1.0.0 | |
| Active as of 2025-02-24 | *Responsible:*[Computable Publishing LLC](https://gps.health/scientific-knowledge-accelerator-foundation-skaf/index.html) | *Computable Name*:SEVCO |
| **Copyright/Legal**: SEVCO has an open license: [https://creativecommons.org/licenses/by-sa/4.0/](https://creativecommons.org/licenses/by-sa/4.0/)Copyright holder is Scientific Knowledge Accelerator Foundation. | | |

 
The Scientific Evidence Code System (SEVCO) includes terms for describing scientific research, including study design, risk of bias, and statistical concepts. For additional derivation details for any term, see [https://fevir.net/resources/CodeSystem/27270](https://fevir.net/resources/CodeSystem/27270) 
For more information, see [https://fevir.net/sevco](https://fevir.net/sevco) 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "SEVCO",
  "url" : "http://terminology.hl7.org/NamingSystem/SEVCO",
  "version" : "1.0.0",
  "name" : "SEVCO",
  "title" : "Scientific Evidence Code System (SEVCO)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-02-24T00:00:00-00:00",
  "publisher" : "Computable Publishing LLC",
  "contact" : [
    {
      "name" : "Scientific Knowledge Accelerator Foundation",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://gps.health/scientific-knowledge-accelerator-foundation-skaf/index.html"
        },
        {
          "system" : "email",
          "value" : "balper@computablepublishing.com"
        }
      ]
    }
  ],
  "description" : "The Scientific Evidence Code System (SEVCO) includes terms for describing scientific research, including study design, risk of bias, and statistical concepts. For additional derivation details for any term, see [https://fevir.net/resources/CodeSystem/27270](https://fevir.net/resources/CodeSystem/27270)\r\n\r\nFor more information, see [https://fevir.net/sevco](https://fevir.net/sevco)",
  "copyright" : "SEVCO has an open license: [https://creativecommons.org/licenses/by-sa/4.0/](https://creativecommons.org/licenses/by-sa/4.0/)\r\n\r\nCopyright holder is Scientific Knowledge Accelerator Foundation.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://fevir.net/sevco",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2025-02-24"
      }
    }
  ]
}

```
