# FDA Establishment Identifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FDA Establishment Identifier**

## NamingSystem: FDA Establishment Identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/FEI | *Version*:1.0.0 | |
| Active as of 2024-10-21 | *Responsible:*[U.S. Food and Drug Administration](https://www.fda.gov/) | *Computable Name*:FEI |
| **Copyright/Legal**: Unless otherwise noted, the contents of the FDA website ([www.fda.gov](http://www.fda.gov)) — both text and graphics — are not copyrighted. They are in the public domain and may be republished, reprinted and otherwise used freely by anyone without the need to obtain permission from FDA. Credit to the U.S. Food and Drug Administration as the source is appreciated but not required. For more information, see [https://www.fda.gov/about-fda/about-website/website-policies#linking](https://www.fda.gov/about-fda/about-website/website-policies#linking) | | |

 
"A FDA Establishment Identifier or Firm Establishment Identifier (FEI) is an FDA system generated number used to identify a firm. FDA systems interact, occasionally creating multiple records (FEIs) for one firm. Upon evaluation, these numbers are merged into one surviving FEI which is used to identify the firm. The remaining FEIs become children of the surviving FEI and are not used to identify the firm." 
For more information, see [https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq](https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "FEI",
  "url" : "http://terminology.hl7.org/NamingSystem/FEI",
  "version" : "1.0.0",
  "name" : "FEI",
  "title" : "FDA Establishment Identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2024-10-21T00:00:00-00:00",
  "publisher" : "U.S. Food and Drug Administration",
  "contact" : [
    {
      "name" : "U.S. Food and Drug Administration; 10903 New Hampshire Ave, Silver Spring, MD 20993-0002",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.fda.gov/"
        },
        {
          "system" : "phone",
          "value" : "1-888-463-6332"
        }
      ]
    }
  ],
  "responsible" : "U.S. Food and Drug Administration",
  "description" : "\"A FDA Establishment Identifier or Firm Establishment Identifier (FEI) is an FDA system generated number used to identify a firm. FDA systems interact, occasionally creating multiple records (FEIs) for one firm. Upon evaluation, these numbers are merged into one surviving FEI which is used to identify the firm. The remaining FEIs become children of the surviving FEI and are not used to identify the firm.\"\r\n\r\nFor more information, see [https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq](https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq).",
  "copyright" : "Unless otherwise noted, the contents of the FDA website ([www.fda.gov](http://www.fda.gov)) — both text and graphics — are not copyrighted. They are in the public domain and may be republished, reprinted and otherwise used freely by anyone without the need to obtain permission from FDA. Credit to the U.S. Food and Drug Administration as the source is appreciated but not required. For more information, see [https://www.fda.gov/about-fda/about-website/website-policies#linking](https://www.fda.gov/about-fda/about-website/website-policies#linking)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.82",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/NamingSystem/FEI",
      "preferred" : true,
      "period" : {
        "start" : "2024-10-21"
      }
    }
  ]
}

```
