# CDC Race and Ethnicity - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDC Race and Ethnicity**

## NamingSystem: CDC Race and Ethnicity 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDCREC | *Version*:3.0.1 | |
| Active as of 2024-10-24 | *Responsible:*[U.S. Centers for Disease Control and Prevention (CDC)](https://www.cdc.gov/phin/php/vocabulary/?CDC_AAref_Val=https://www.cdc.gov/phin/resources/vocabulary/index.html) | *Computable Name*:CDCREC |
| **Copyright/Legal**: Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.For information and exceptions regarding use of CDC material please see https://www.cdc.gov/other/agencymaterials.html. | | |

 
The U.S. Centers for Disease Control and Prevention (CDC) has prepared a code set for use in coding race and ethnicity data. This code set is based on current federal standards for classifying data on race and ethnicity, specifically the minimum race and ethnicity categories defined by the U.S. Office of Management and Budget (OMB) and a more detailed set of race and ethnicity categories maintained by the U.S. Bureau of the Census (BC). The main purpose of the code set is to facilitate use of federal standards for classifying data on race and ethnicity when these data are exchanged, stored, retrieved, or analyzed in electronic form. At the same time, the code set can be applied to paper-based record systems to the extent that these systems are used to collect, maintain, and report data on race and ethnicity in accordance with current federal standards. 
The content is available at https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238#. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDCREC",
  "url" : "http://terminology.hl7.org/NamingSystem/CDCREC",
  "version" : "3.0.1",
  "name" : "CDCREC",
  "title" : "CDC Race and Ethnicity",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-10-24T00:00:00-04:00",
  "publisher" : "U.S. Centers for Disease Control and Prevention (CDC)",
  "contact" : [
    {
      "name" : "U.S. Centers for Disease Control and Prevention (CDC)",
      "telecom" : [
        {
          "system" : "email",
          "value" : "phinvs@cdc.gov"
        },
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/phin/php/vocabulary/?CDC_AAref_Val=https://www.cdc.gov/phin/resources/vocabulary/index.html"
        }
      ]
    }
  ],
  "responsible" : "U.S. Centers for Disease Control and Prevention (CDC)",
  "description" : "The U.S. Centers for Disease Control and Prevention (CDC) has prepared a code set for use in coding race and ethnicity data. This code set is based on current federal standards for classifying data on race and ethnicity, specifically the minimum race and ethnicity categories defined by the U.S. Office of Management and Budget (OMB) and a more detailed set of race and ethnicity categories maintained by the U.S. Bureau of the Census (BC). The main purpose of the code set is to facilitate use of federal standards for classifying data on race and ethnicity when these data are exchanged, stored, retrieved, or analyzed in electronic form. At the same time, the code set can be applied to paper-based record systems to the extent that these systems are used to collect, maintain, and report data on race and ethnicity in accordance with current federal standards.\r\n\r\nThe content is available at https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238#.",
  "copyright" : "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.\r\n\r\nFor information and exceptions regarding use of CDC material please see https://www.cdc.gov/other/agencymaterials.html.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.238",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "urn:oid:2.16.840.1.113883.6.238",
      "preferred" : true,
      "period" : {
        "start" : "2021-09-01"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/PHRaceAndEthnicityCDC",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility.",
      "period" : {
        "end" : "2021-09-01"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0005",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility.",
      "period" : {
        "end" : "2021-09-01"
      }
    }
  ]
}

```
