# HL7PublishingSubSection - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7PublishingSubSection**

## CodeSystem: HL7PublishingSubSection 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Hl7PublishingSubSection |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1134 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:** Codes for HL7 publishing sub-sections (business sub-categories) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-hl7PublishingSubSection",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1134"
    }
  ],
  "version" : "3.0.0",
  "name" : "Hl7PublishingSubSection",
  "title" : "HL7PublishingSubSection",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Codes for HL7 publishing sub-sections (business sub-categories)",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Other"
        }
      ],
      "code" : "OwningSection",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#OwningSection",
      "description" : "Identifies the section (target concept) of which this subsection (source concept) is a part. ConceptRelationshipProperites: [isNavigable: false; functionalism: functional; reflexivity: irreflexive; symmetry: antisymetric; connected: false; transitivity: antitransitive; allowedForTargets: all codes from the hl7PublishingSection code system; requiredForSources: all codes from hl7PublishingSubSection code system;]",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "CO",
      "display" : "common",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds common or shared specifications within the Infrastructure Management (IM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "IM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23160"
        }
      ]
    },
    {
      "code" : "FI",
      "display" : "financial information",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to the management of financial information within the Administrative Management (AM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "AM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23161"
        }
      ]
    },
    {
      "code" : "MC",
      "display" : "message control",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to the definition and control of interoperability messages within the Infrastructure Management (IM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "IM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23162"
        }
      ]
    },
    {
      "code" : "MF",
      "display" : "master file",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to master file and registry management activities within the Infrastructure Management (IM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "IM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23163"
        }
      ]
    },
    {
      "code" : "PO",
      "display" : "operations",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to managing clinical operations within the Health and Clinical Management (HM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "HM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23164"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "practice",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to the management of practice settings within the Administrative Management (AM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "AM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23165"
        }
      ]
    },
    {
      "code" : "QU",
      "display" : "query",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to query/response activities within the Infrastructure Management (IM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "IM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23166"
        }
      ]
    },
    {
      "code" : "RC",
      "display" : "records",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to the definition and communication of records of clinical care within the Health and Clinical Management (HM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "HM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23167"
        }
      ]
    },
    {
      "code" : "RE",
      "display" : "reasoning",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications related to the definition and communication of reasoning (knowledge) within the Health and Clinical Management (HM) section.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "HM"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23168"
        }
      ]
    },
    {
      "code" : "UU",
      "display" : "unknown",
      "definition" : "**Description:** Represents the HL7 V3 publishing sub-section that holds specifications that are unassigned - that have not yet been assigned to one of the formal publishing sections.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.\r\n\r\nFor publishing purposes, these domains are aggregated into sub-sections of related health care areas and these sub-sections are further aggregated into three major sets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSection",
            "code" : "UU"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23169"
        }
      ]
    }
  ]
}

```
